/* MonitorClone.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MonitorClone.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/meta-background-group.h>
#include <meta/display.h>
#include <meta/meta-plugin.h>
#include <mtk/mtk.h>
#include <clutter/clutter.h>
#include <meta/window.h>
#include <meta/workspace.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_MONITOR_CLONE (gala_monitor_clone_get_type ())
#define GALA_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorClone))
#define GALA_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))
#define GALA_IS_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MONITOR_CLONE))
#define GALA_IS_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MONITOR_CLONE))
#define GALA_MONITOR_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))

typedef struct _GalaMonitorClone GalaMonitorClone;
typedef struct _GalaMonitorCloneClass GalaMonitorCloneClass;
typedef struct _GalaMonitorClonePrivate GalaMonitorClonePrivate;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
enum  {
	GALA_MONITOR_CLONE_0_PROPERTY,
	GALA_MONITOR_CLONE_WM_PROPERTY,
	GALA_MONITOR_CLONE_MONITOR_PROPERTY,
	GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY,
	GALA_MONITOR_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_monitor_clone_properties[GALA_MONITOR_CLONE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_WINDOW_LIST_MODEL (gala_window_list_model_get_type ())
#define GALA_WINDOW_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModel))
#define GALA_WINDOW_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModelClass))
#define GALA_IS_WINDOW_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_LIST_MODEL))
#define GALA_IS_WINDOW_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_LIST_MODEL))
#define GALA_WINDOW_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModelClass))

typedef struct _GalaWindowListModel GalaWindowListModel;
typedef struct _GalaWindowListModelClass GalaWindowListModelClass;
typedef enum  {
	GALA_WINDOW_LIST_MODEL_SORT_MODE_NONE,
	GALA_WINDOW_LIST_MODEL_SORT_MODE_STACKING
} GalaWindowListModelSortMode;

#define GALA_WINDOW_LIST_MODEL_TYPE_SORT_MODE (gala_window_list_model_sort_mode_get_type ())
enum  {
	GALA_MONITOR_CLONE_WINDOW_SELECTED_SIGNAL,
	GALA_MONITOR_CLONE_NUM_SIGNALS
};
static guint gala_monitor_clone_signals[GALA_MONITOR_CLONE_NUM_SIGNALS] = {0};

struct _GalaMonitorClone {
	GalaActorTarget parent_instance;
	GalaMonitorClonePrivate * priv;
};

struct _GalaMonitorCloneClass {
	GalaActorTargetClass parent_class;
};

struct _GalaMonitorClonePrivate {
	GalaWindowManager* _wm;
	gint _monitor;
	gfloat _monitor_scale;
	GalaWindowCloneContainer* window_container;
	GalaBackgroundManager* background;
};

static gint GalaMonitorClone_private_offset;
static gpointer gala_monitor_clone_parent_class = NULL;

VALA_EXTERN GType gala_monitor_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMonitorClone, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
VALA_EXTERN GalaMonitorClone* gala_monitor_clone_new (GalaWindowManager* wm,
                                          gint monitor);
VALA_EXTERN GalaMonitorClone* gala_monitor_clone_construct (GType object_type,
                                                GalaWindowManager* wm,
                                                gint monitor);
VALA_EXTERN void gala_monitor_clone_update_allocation (GalaMonitorClone* self);
VALA_EXTERN GalaWindowManager* gala_monitor_clone_get_wm (GalaMonitorClone* self);
VALA_EXTERN gint gala_monitor_clone_get_monitor (GalaMonitorClone* self);
VALA_EXTERN void gala_monitor_clone_set_monitor_scale (GalaMonitorClone* self,
                                           gfloat value);
static void gala_monitor_clone_set_wm (GalaMonitorClone* self,
                                GalaWindowManager* value);
static void gala_monitor_clone_set_monitor (GalaMonitorClone* self,
                                     gint value);
VALA_EXTERN gfloat gala_monitor_clone_get_monitor_scale (GalaMonitorClone* self);
static GObject * gala_monitor_clone_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_new (MetaDisplay* display,
                                                    gint monitor_index,
                                                    gboolean control_position,
                                                    gboolean rounded_corners);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_construct (GType object_type,
                                                          MetaDisplay* display,
                                                          gint monitor_index,
                                                          gboolean control_position,
                                                          gboolean rounded_corners);
VALA_EXTERN GType gala_window_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowListModel, g_object_unref)
VALA_EXTERN GType gala_window_list_model_sort_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaWindowListModel* gala_window_list_model_new (MetaDisplay* display,
                                                 GalaWindowListModelSortMode sort_mode,
                                                 gboolean normal_filter,
                                                 gint monitor_filter,
                                                 MetaWorkspace* workspace_filter,
                                                 GtkFilter* custom_filter);
VALA_EXTERN GalaWindowListModel* gala_window_list_model_construct (GType object_type,
                                                       MetaDisplay* display,
                                                       GalaWindowListModelSortMode sort_mode,
                                                       gboolean normal_filter,
                                                       gint monitor_filter,
                                                       MetaWorkspace* workspace_filter,
                                                       GtkFilter* custom_filter);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           GalaWindowListModel* windows,
                                                           gfloat monitor_scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 GalaWindowListModel* windows,
                                                                 gfloat monitor_scale,
                                                                 gboolean overview_mode);
static void _gala_monitor_clone___lambda74_ (GalaMonitorClone* self,
                                      MetaWindow* w);
static void __gala_monitor_clone___lambda74__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                   MetaWindow* window,
                                                                                   gpointer self);
static void gala_monitor_clone_finalize (GObject * obj);
static GType gala_monitor_clone_get_type_once (void);
static void _vala_gala_monitor_clone_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_gala_monitor_clone_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
gala_monitor_clone_get_instance_private (GalaMonitorClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaMonitorClone_private_offset);
}

GalaMonitorClone*
gala_monitor_clone_construct (GType object_type,
                              GalaWindowManager* wm,
                              gint monitor)
{
	GalaMonitorClone * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaMonitorClone*) g_object_new (object_type, "wm", wm, "monitor", monitor, NULL);
	return self;
}

GalaMonitorClone*
gala_monitor_clone_new (GalaWindowManager* wm,
                        gint monitor)
{
	return gala_monitor_clone_construct (GALA_TYPE_MONITOR_CLONE, wm, monitor);
}

/**
     * Make sure the MonitorClone is at the location of the monitor on the stage
     */
void
gala_monitor_clone_update_allocation (GalaMonitorClone* self)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MtkRectangle monitor_geometry = {0};
	gint _tmp2_;
	MtkRectangle _tmp3_ = {0};
	MtkRectangle _tmp4_;
	MtkRectangle _tmp5_;
	MtkRectangle _tmp6_;
	MtkRectangle _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = self->priv->_monitor;
	meta_display_get_monitor_geometry (display, _tmp2_, &_tmp3_);
	monitor_geometry = _tmp3_;
	_tmp4_ = monitor_geometry;
	_tmp5_ = monitor_geometry;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _tmp4_.x, (gfloat) _tmp5_.y);
	_tmp6_ = monitor_geometry;
	_tmp7_ = monitor_geometry;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp6_.width, (gfloat) _tmp7_.height);
	_tmp8_ = self->priv->_monitor;
	gala_monitor_clone_set_monitor_scale (self, meta_display_get_monitor_scale (display, _tmp8_));
}

GalaWindowManager*
gala_monitor_clone_get_wm (GalaMonitorClone* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_monitor_clone_set_wm (GalaMonitorClone* self,
                           GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_monitor_clone_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_monitor_clone_properties[GALA_MONITOR_CLONE_WM_PROPERTY]);
	}
}

gint
gala_monitor_clone_get_monitor (GalaMonitorClone* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor;
	return result;
}

static void
gala_monitor_clone_set_monitor (GalaMonitorClone* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_monitor_clone_get_monitor (self);
	if (old_value != value) {
		self->priv->_monitor = value;
		g_object_notify_by_pspec ((GObject *) self, gala_monitor_clone_properties[GALA_MONITOR_CLONE_MONITOR_PROPERTY]);
	}
}

gfloat
gala_monitor_clone_get_monitor_scale (GalaMonitorClone* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_monitor_clone_set_monitor_scale (GalaMonitorClone* self,
                                      gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_monitor_clone_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_monitor_clone_properties[GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY]);
	}
}

static void
_gala_monitor_clone___lambda74_ (GalaMonitorClone* self,
                                 MetaWindow* w)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, gala_monitor_clone_signals[GALA_MONITOR_CLONE_WINDOW_SELECTED_SIGNAL], 0, w);
}

static void
__gala_monitor_clone___lambda74__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                              MetaWindow* window,
                                                                              gpointer self)
{
	_gala_monitor_clone___lambda74_ ((GalaMonitorClone*) self, window);
}

static GObject *
gala_monitor_clone_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaMonitorClone * self;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	gint _tmp3_;
	GalaBackgroundManager* _tmp4_;
	GalaWindowListModel* windows = NULL;
	MetaDisplay* _tmp5_;
	gint _tmp6_;
	GalaWindowListModel* _tmp7_;
	GalaWindowManager* _tmp8_;
	GalaWindowListModel* _tmp9_;
	gfloat _tmp10_;
	GalaWindowCloneContainer* _tmp11_;
	GalaWindowCloneContainer* _tmp12_;
	ClutterBindConstraint* _tmp13_;
	ClutterBindConstraint* _tmp14_;
	GalaWindowCloneContainer* _tmp15_;
	GalaWindowCloneContainer* _tmp16_;
	GalaBackgroundManager* _tmp17_;
	GalaWindowCloneContainer* _tmp18_;
	GalaDragDropAction* drop = NULL;
	GalaDragDropAction* _tmp19_;
	GalaDragDropAction* _tmp20_;
	parent_class = G_OBJECT_CLASS (gala_monitor_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	gala_monitor_clone_update_allocation (self);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = self->priv->_monitor;
	_tmp4_ = gala_background_manager_new (_tmp2_, _tmp3_, FALSE, TRUE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = _tmp4_;
	_tmp5_ = display;
	_tmp6_ = self->priv->_monitor;
	_tmp7_ = gala_window_list_model_new (_tmp5_, GALA_WINDOW_LIST_MODEL_SORT_MODE_STACKING, TRUE, _tmp6_, NULL, NULL);
	windows = _tmp7_;
	_tmp8_ = self->priv->_wm;
	_tmp9_ = windows;
	_tmp10_ = self->priv->_monitor_scale;
	_tmp11_ = gala_window_clone_container_new (_tmp8_, _tmp9_, _tmp10_, FALSE);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->window_container);
	self->priv->window_container = _tmp11_;
	_tmp12_ = self->priv->window_container;
	_tmp13_ = (ClutterBindConstraint*) clutter_bind_constraint_new ((ClutterActor*) self, CLUTTER_BIND_SIZE, 0.0f);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	clutter_actor_add_constraint ((ClutterActor*) _tmp12_, (ClutterConstraint*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->window_container;
	g_signal_connect_object (_tmp15_, "window-selected", (GCallback) __gala_monitor_clone___lambda74__gala_window_clone_container_window_selected, self, 0);
	_tmp16_ = self->priv->window_container;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp16_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp17_ = self->priv->background;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp17_);
	_tmp18_ = self->priv->window_container;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp18_);
	_tmp19_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp19_);
	drop = _tmp19_;
	_tmp20_ = drop;
	clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp20_);
	_g_object_unref0 (drop);
	_g_object_unref0 (windows);
	return obj;
}

static void
gala_monitor_clone_class_init (GalaMonitorCloneClass * klass,
                               gpointer klass_data)
{
	gala_monitor_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaMonitorClone_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_monitor_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_monitor_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_monitor_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_monitor_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MONITOR_CLONE_WM_PROPERTY, gala_monitor_clone_properties[GALA_MONITOR_CLONE_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MONITOR_CLONE_MONITOR_PROPERTY, gala_monitor_clone_properties[GALA_MONITOR_CLONE_MONITOR_PROPERTY] = g_param_spec_int ("monitor", "monitor", "monitor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY, gala_monitor_clone_properties[GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gala_monitor_clone_signals[GALA_MONITOR_CLONE_WINDOW_SELECTED_SIGNAL] = g_signal_new ("window-selected", GALA_TYPE_MONITOR_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
}

static void
gala_monitor_clone_instance_init (GalaMonitorClone * self,
                                  gpointer klass)
{
	self->priv = gala_monitor_clone_get_instance_private (self);
}

static void
gala_monitor_clone_finalize (GObject * obj)
{
	GalaMonitorClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->window_container);
	_g_object_unref0 (self->priv->background);
	G_OBJECT_CLASS (gala_monitor_clone_parent_class)->finalize (obj);
}

/**
 * More or less utility class to contain a WindowCloneContainer for each
 * non-primary monitor. It's the pendant to the WorkspaceClone which is
 * only placed on the primary monitor. It also draws a wallpaper behind itself
 * as the WindowGroup is hidden while the view is active. Only used when
 * workspaces-only-on-primary is set to true.
 */
 G_GNUC_NO_INLINE static GType
gala_monitor_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaMonitorCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_monitor_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaMonitorClone), 0, (GInstanceInitFunc) gala_monitor_clone_instance_init, NULL };
	GType gala_monitor_clone_type_id;
	gala_monitor_clone_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaMonitorClone", &g_define_type_info, 0);
	GalaMonitorClone_private_offset = g_type_add_instance_private (gala_monitor_clone_type_id, sizeof (GalaMonitorClonePrivate));
	return gala_monitor_clone_type_id;
}

GType
gala_monitor_clone_get_type (void)
{
	static gsize gala_monitor_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_monitor_clone_type_id__once)) {
		GType gala_monitor_clone_type_id;
		gala_monitor_clone_type_id = gala_monitor_clone_get_type_once ();
		g_once_init_leave (&gala_monitor_clone_type_id__once, gala_monitor_clone_type_id);
	}
	return gala_monitor_clone_type_id__once;
}

static void
_vala_gala_monitor_clone_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GalaMonitorClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	switch (property_id) {
		case GALA_MONITOR_CLONE_WM_PROPERTY:
		g_value_set_object (value, gala_monitor_clone_get_wm (self));
		break;
		case GALA_MONITOR_CLONE_MONITOR_PROPERTY:
		g_value_set_int (value, gala_monitor_clone_get_monitor (self));
		break;
		case GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_monitor_clone_get_monitor_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_monitor_clone_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GalaMonitorClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	switch (property_id) {
		case GALA_MONITOR_CLONE_WM_PROPERTY:
		gala_monitor_clone_set_wm (self, g_value_get_object (value));
		break;
		case GALA_MONITOR_CLONE_MONITOR_PROPERTY:
		gala_monitor_clone_set_monitor (self, g_value_get_int (value));
		break;
		case GALA_MONITOR_CLONE_MONITOR_SCALE_PROPERTY:
		gala_monitor_clone_set_monitor_scale (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

