/* components-inspector-error-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from components-inspector-error-view.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <gtk/gtk.h>
#include "geary-engine.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	COMPONENTS_INSPECTOR_ERROR_VIEW_0_PROPERTY,
	COMPONENTS_INSPECTOR_ERROR_VIEW_NUM_PROPERTIES
};
static GParamSpec* components_inspector_error_view_properties[COMPONENTS_INSPECTOR_ERROR_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _geary_error_context_stack_frame_unref0(var) ((var == NULL) ? NULL : (var = (geary_error_context_stack_frame_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ComponentsInspectorErrorViewPrivate {
	GtkTextView* problem_text;
	GearyErrorContext* error;
	GearyAccountInformation* account;
	GearyServiceInformation* service;
};

static gint ComponentsInspectorErrorView_private_offset;
static gpointer components_inspector_error_view_parent_class = NULL;

static gchar* components_inspector_error_view_format_problem (ComponentsInspectorErrorView* self,
                                                       ComponentsInspectorTextFormat format);
static void components_inspector_error_view_finalize (GObject * obj);
static GType components_inspector_error_view_get_type_once (void);

static inline gpointer
components_inspector_error_view_get_instance_private (ComponentsInspectorErrorView* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsInspectorErrorView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ComponentsInspectorErrorView*
components_inspector_error_view_construct (GType object_type,
                                           GearyErrorContext* _error_,
                                           GearyAccountInformation* account,
                                           GearyServiceInformation* service)
{
	ComponentsInspectorErrorView * self = NULL;
	GearyErrorContext* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GtkTextView* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_error_, GEARY_TYPE_ERROR_CONTEXT), NULL);
	g_return_val_if_fail ((account == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION), NULL);
	g_return_val_if_fail ((service == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION), NULL);
	self = (ComponentsInspectorErrorView*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (_error_);
	_g_object_unref0 (self->priv->error);
	self->priv->error = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (self->priv->account);
	self->priv->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (service);
	_g_object_unref0 (self->priv->service);
	self->priv->service = _tmp2_;
	_tmp3_ = self->priv->problem_text;
	_tmp4_ = gtk_text_view_get_buffer (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = components_inspector_error_view_format_problem (self, COMPONENTS_INSPECTOR_TEXT_FORMAT_PLAIN);
	_tmp7_ = _tmp6_;
	g_object_set (_tmp5_, "text", _tmp7_, NULL);
	_g_free0 (_tmp7_);
	return self;
}

ComponentsInspectorErrorView*
components_inspector_error_view_new (GearyErrorContext* _error_,
                                     GearyAccountInformation* account,
                                     GearyServiceInformation* service)
{
	return components_inspector_error_view_construct (COMPONENTS_TYPE_INSPECTOR_ERROR_VIEW, _error_, account, service);
}

void
components_inspector_error_view_save (ComponentsInspectorErrorView* self,
                                      GDataOutputStream* out,
                                      ComponentsInspectorTextFormat format,
                                      GCancellable* cancellable,
                                      GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_ERROR_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (out, g_data_output_stream_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = components_inspector_error_view_format_problem (self, format);
	_tmp1_ = _tmp0_;
	g_data_output_stream_put_string (out, _tmp1_, cancellable, &_inner_error0_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gchar*
components_inspector_error_view_format_problem (ComponentsInspectorErrorView* self,
                                                ComponentsInspectorTextFormat format)
{
	gchar* line_sep = NULL;
	gchar* _tmp0_;
	GString* details = NULL;
	GString* _tmp1_;
	GearyAccountInformation* _tmp2_;
	GearyServiceInformation* _tmp16_;
	GearyErrorContext* _tmp30_;
	GString* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* result;
	g_return_val_if_fail (COMPONENTS_IS_INSPECTOR_ERROR_VIEW (self), NULL);
	_tmp0_ = components_inspector_text_format_get_line_separator (format);
	line_sep = _tmp0_;
	_tmp1_ = g_string_new ("");
	details = _tmp1_;
	_tmp2_ = self->priv->account;
	if (_tmp2_ != NULL) {
		GString* _tmp3_;
		GearyAccountInformation* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GString* _tmp7_;
		const gchar* _tmp8_;
		GString* _tmp9_;
		GearyAccountInformation* _tmp10_;
		GearyServiceProvider _tmp11_;
		GearyServiceProvider _tmp12_;
		GEnumValue* _tmp13_;
		GString* _tmp14_;
		const gchar* _tmp15_;
		_tmp3_ = details;
		_tmp4_ = self->priv->account;
		_tmp5_ = geary_account_information_get_id (_tmp4_);
		_tmp6_ = _tmp5_;
		g_string_append_printf (_tmp3_, "Account identifier: %s", _tmp6_);
		_tmp7_ = details;
		_tmp8_ = line_sep;
		g_string_append (_tmp7_, _tmp8_);
		_tmp9_ = details;
		_tmp10_ = self->priv->account;
		_tmp11_ = geary_account_information_get_service_provider (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_enum_get_value (g_type_class_ref (GEARY_TYPE_SERVICE_PROVIDER), _tmp12_);
		g_string_append_printf (_tmp9_, "Account provider: %s", (_tmp13_ != NULL) ? _tmp13_->value_name : NULL);
		_tmp14_ = details;
		_tmp15_ = line_sep;
		g_string_append (_tmp14_, _tmp15_);
	}
	_tmp16_ = self->priv->service;
	if (_tmp16_ != NULL) {
		GString* _tmp17_;
		GearyServiceInformation* _tmp18_;
		GearyProtocol _tmp19_;
		GearyProtocol _tmp20_;
		GEnumValue* _tmp21_;
		GString* _tmp22_;
		const gchar* _tmp23_;
		GString* _tmp24_;
		GearyServiceInformation* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		GString* _tmp28_;
		const gchar* _tmp29_;
		_tmp17_ = details;
		_tmp18_ = self->priv->service;
		_tmp19_ = geary_service_information_get_protocol (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_enum_get_value (g_type_class_ref (GEARY_TYPE_PROTOCOL), _tmp20_);
		g_string_append_printf (_tmp17_, "Service type: %s", (_tmp21_ != NULL) ? _tmp21_->value_name : NULL);
		_tmp22_ = details;
		_tmp23_ = line_sep;
		g_string_append (_tmp22_, _tmp23_);
		_tmp24_ = details;
		_tmp25_ = self->priv->service;
		_tmp26_ = geary_service_information_get_host (_tmp25_);
		_tmp27_ = _tmp26_;
		g_string_append_printf (_tmp24_, "Service host: %s", _tmp27_);
		_tmp28_ = details;
		_tmp29_ = line_sep;
		g_string_append (_tmp28_, _tmp29_);
	}
	_tmp30_ = self->priv->error;
	if (_tmp30_ == NULL) {
		GString* _tmp31_;
		GString* _tmp32_;
		const gchar* _tmp33_;
		_tmp31_ = details;
		g_string_append (_tmp31_, "No error reported");
		_tmp32_ = details;
		_tmp33_ = line_sep;
		g_string_append (_tmp32_, _tmp33_);
	} else {
		GString* _tmp34_;
		GearyErrorContext* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		GString* _tmp38_;
		const gchar* _tmp39_;
		GString* _tmp40_;
		GearyErrorContext* _tmp41_;
		GError* _tmp42_;
		GError* _tmp43_;
		const gchar* _tmp44_;
		GString* _tmp45_;
		const gchar* _tmp46_;
		GString* _tmp47_;
		GString* _tmp48_;
		GString* _tmp49_;
		const gchar* _tmp50_;
		_tmp34_ = details;
		_tmp35_ = self->priv->error;
		_tmp36_ = geary_error_context_format_error_type (_tmp35_);
		_tmp37_ = _tmp36_;
		g_string_append_printf (_tmp34_, "Error type: %s", _tmp37_);
		_g_free0 (_tmp37_);
		_tmp38_ = details;
		_tmp39_ = line_sep;
		g_string_append (_tmp38_, _tmp39_);
		_tmp40_ = details;
		_tmp41_ = self->priv->error;
		_tmp42_ = geary_error_context_get_thrown (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = _tmp43_->message;
		g_string_append_printf (_tmp40_, "Message: %s", _tmp44_);
		_tmp45_ = details;
		_tmp46_ = line_sep;
		g_string_append (_tmp45_, _tmp46_);
		_tmp47_ = details;
		g_string_append_c (_tmp47_, '\n');
		_tmp48_ = details;
		g_string_append (_tmp48_, "Back trace:");
		_tmp49_ = details;
		_tmp50_ = line_sep;
		g_string_append (_tmp49_, _tmp50_);
		{
			GeeList* _frame_list = NULL;
			GearyErrorContext* _tmp51_;
			GeeList* _tmp52_;
			GeeList* _tmp53_;
			gint _frame_size = 0;
			GeeList* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			gint _frame_index = 0;
			_tmp51_ = self->priv->error;
			_tmp52_ = geary_error_context_get_backtrace (_tmp51_);
			_tmp53_ = _tmp52_;
			_frame_list = _tmp53_;
			_tmp54_ = _frame_list;
			_tmp55_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp56_ = _tmp55_;
			_frame_size = _tmp56_;
			_frame_index = -1;
			while (TRUE) {
				gint _tmp57_;
				gint _tmp58_;
				GearyErrorContextStackFrame* frame = NULL;
				GeeList* _tmp59_;
				gpointer _tmp60_;
				GString* _tmp61_;
				GearyErrorContextStackFrame* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				GString* _tmp65_;
				const gchar* _tmp66_;
				_frame_index = _frame_index + 1;
				_tmp57_ = _frame_index;
				_tmp58_ = _frame_size;
				if (!(_tmp57_ < _tmp58_)) {
					break;
				}
				_tmp59_ = _frame_list;
				_tmp60_ = gee_list_get (_tmp59_, _frame_index);
				frame = (GearyErrorContextStackFrame*) _tmp60_;
				_tmp61_ = details;
				_tmp62_ = frame;
				_tmp63_ = geary_error_context_stack_frame_to_string (_tmp62_);
				_tmp64_ = _tmp63_;
				g_string_append_printf (_tmp61_, " * %s", _tmp64_);
				_g_free0 (_tmp64_);
				_tmp65_ = details;
				_tmp66_ = line_sep;
				g_string_append (_tmp65_, _tmp66_);
				_geary_error_context_stack_frame_unref0 (frame);
			}
		}
	}
	_tmp67_ = details;
	_tmp68_ = _tmp67_->str;
	_tmp69_ = g_strdup (_tmp68_);
	result = _tmp69_;
	_g_string_free0 (details);
	_g_free0 (line_sep);
	return result;
}

static void
components_inspector_error_view_class_init (ComponentsInspectorErrorViewClass * klass,
                                            gpointer klass_data)
{
	components_inspector_error_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsInspectorErrorView_private_offset);
	G_OBJECT_CLASS (klass)->finalize = components_inspector_error_view_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/components-inspector-error-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "problem_text", FALSE, ComponentsInspectorErrorView_private_offset + G_STRUCT_OFFSET (ComponentsInspectorErrorViewPrivate, problem_text));
}

static void
components_inspector_error_view_instance_init (ComponentsInspectorErrorView * self,
                                               gpointer klass)
{
	self->priv = components_inspector_error_view_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
components_inspector_error_view_finalize (GObject * obj)
{
	ComponentsInspectorErrorView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_INSPECTOR_ERROR_VIEW, ComponentsInspectorErrorView);
	_g_object_unref0 (self->priv->error);
	_g_object_unref0 (self->priv->account);
	_g_object_unref0 (self->priv->service);
	G_OBJECT_CLASS (components_inspector_error_view_parent_class)->finalize (obj);
}

/**
 * A view that displays information about an application error.
 */
static GType
components_inspector_error_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsInspectorErrorViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_inspector_error_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsInspectorErrorView), 0, (GInstanceInitFunc) components_inspector_error_view_instance_init, NULL };
	GType components_inspector_error_view_type_id;
	components_inspector_error_view_type_id = g_type_register_static (gtk_grid_get_type (), "ComponentsInspectorErrorView", &g_define_type_info, 0);
	ComponentsInspectorErrorView_private_offset = g_type_add_instance_private (components_inspector_error_view_type_id, sizeof (ComponentsInspectorErrorViewPrivate));
	return components_inspector_error_view_type_id;
}

GType
components_inspector_error_view_get_type (void)
{
	static volatile gsize components_inspector_error_view_type_id__once = 0;
	if (g_once_init_enter (&components_inspector_error_view_type_id__once)) {
		GType components_inspector_error_view_type_id;
		components_inspector_error_view_type_id = components_inspector_error_view_get_type_once ();
		g_once_init_leave (&components_inspector_error_view_type_id__once, components_inspector_error_view_type_id);
	}
	return components_inspector_error_view_type_id__once;
}

