/* smtp-authenticator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from smtp-authenticator.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_SMTP_AUTHENTICATOR_0_PROPERTY,
	GEARY_SMTP_AUTHENTICATOR_NAME_PROPERTY,
	GEARY_SMTP_AUTHENTICATOR_CREDENTIALS_PROPERTY,
	GEARY_SMTP_AUTHENTICATOR_NUM_PROPERTIES
};
static GParamSpec* geary_smtp_authenticator_properties[GEARY_SMTP_AUTHENTICATOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GearySmtpAuthenticatorPrivate {
	gchar* _name;
	GearyCredentials* _credentials;
};

static gint GearySmtpAuthenticator_private_offset;
static gpointer geary_smtp_authenticator_parent_class = NULL;

static void geary_smtp_authenticator_set_name (GearySmtpAuthenticator* self,
                                        const gchar* value);
static void geary_smtp_authenticator_set_credentials (GearySmtpAuthenticator* self,
                                               GearyCredentials* value);
static GearySmtpRequest* geary_smtp_authenticator_real_initiate (GearySmtpAuthenticator* self);
static GearyMemoryBuffer* geary_smtp_authenticator_real_challenge (GearySmtpAuthenticator* self,
                                                            gint step,
                                                            GearySmtpResponse* response,
                                                            GError** error);
static gchar* geary_smtp_authenticator_real_to_string (GearySmtpAuthenticator* self);
static void geary_smtp_authenticator_finalize (GObject * obj);
static GType geary_smtp_authenticator_get_type_once (void);
static void _vala_geary_smtp_authenticator_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_geary_smtp_authenticator_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
geary_smtp_authenticator_get_instance_private (GearySmtpAuthenticator* self)
{
	return G_STRUCT_MEMBER_P (self, GearySmtpAuthenticator_private_offset);
}

const gchar*
geary_smtp_authenticator_get_name (GearySmtpAuthenticator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_SMTP_IS_AUTHENTICATOR (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
geary_smtp_authenticator_set_name (GearySmtpAuthenticator* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_SMTP_IS_AUTHENTICATOR (self));
	old_value = geary_smtp_authenticator_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_smtp_authenticator_properties[GEARY_SMTP_AUTHENTICATOR_NAME_PROPERTY]);
	}
}

GearyCredentials*
geary_smtp_authenticator_get_credentials (GearySmtpAuthenticator* self)
{
	GearyCredentials* result;
	GearyCredentials* _tmp0_;
	g_return_val_if_fail (GEARY_SMTP_IS_AUTHENTICATOR (self), NULL);
	_tmp0_ = self->priv->_credentials;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_smtp_authenticator_set_credentials (GearySmtpAuthenticator* self,
                                          GearyCredentials* value)
{
	GearyCredentials* old_value;
	g_return_if_fail (GEARY_SMTP_IS_AUTHENTICATOR (self));
	old_value = geary_smtp_authenticator_get_credentials (self);
	if (old_value != value) {
		GearyCredentials* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_credentials);
		self->priv->_credentials = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_smtp_authenticator_properties[GEARY_SMTP_AUTHENTICATOR_CREDENTIALS_PROPERTY]);
	}
}

GearySmtpAuthenticator*
geary_smtp_authenticator_construct (GType object_type,
                                    const gchar* name,
                                    GearyCredentials* credentials)
{
	GearySmtpAuthenticator * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (credentials), NULL);
	self = (GearySmtpAuthenticator*) geary_base_object_construct (object_type);
	geary_smtp_authenticator_set_name (self, name);
	geary_smtp_authenticator_set_credentials (self, credentials);
	if (!geary_credentials_is_complete (credentials)) {
		g_message ("smtp-authenticator.vala:26: Incomplete credentials supplied to SMTP au" \
"thenticator %s", name);
	}
	return self;
}

/**
     * Returns a Request that is used to initiate the challenge-response.
     */
static GearySmtpRequest*
geary_smtp_authenticator_real_initiate (GearySmtpAuthenticator* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_smtp_authenticator_initiate'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GearySmtpRequest*
geary_smtp_authenticator_initiate (GearySmtpAuthenticator* self)
{
	GearySmtpAuthenticatorClass* _klass_;
	g_return_val_if_fail (GEARY_SMTP_IS_AUTHENTICATOR (self), NULL);
	_klass_ = GEARY_SMTP_AUTHENTICATOR_GET_CLASS (self);
	if (_klass_->initiate) {
		return _klass_->initiate (self);
	}
	return NULL;
}

/**
     * Returns a block of data that will be sent for that stage of the authentication challenge.
     * No line terminators should be present.  Various authentication schemes may also have their
     * own requirements.
     *
     * step is the zero-based step number of the challenge-response.  Response is the *last*
     * SMTP response from the server from the prior step (or from the initiate() request).
     *
     * Returns null if the Authenticator chooses to end the process in an orderly fashion.
     *
     * If an error is thrown, the entire process is aborted without any further I/O with the
     * server.  Generally this leaves the connection in a bad state and should be closed.
     */
static GearyMemoryBuffer*
geary_smtp_authenticator_real_challenge (GearySmtpAuthenticator* self,
                                         gint step,
                                         GearySmtpResponse* response,
                                         GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `geary_smtp_authenticator_challenge'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GearyMemoryBuffer*
geary_smtp_authenticator_challenge (GearySmtpAuthenticator* self,
                                    gint step,
                                    GearySmtpResponse* response,
                                    GError** error)
{
	GearySmtpAuthenticatorClass* _klass_;
	g_return_val_if_fail (GEARY_SMTP_IS_AUTHENTICATOR (self), NULL);
	_klass_ = GEARY_SMTP_AUTHENTICATOR_GET_CLASS (self);
	if (_klass_->challenge) {
		return _klass_->challenge (self, step, response, error);
	}
	return NULL;
}

static gchar*
geary_smtp_authenticator_real_to_string (GearySmtpAuthenticator* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
geary_smtp_authenticator_to_string (GearySmtpAuthenticator* self)
{
	GearySmtpAuthenticatorClass* _klass_;
	g_return_val_if_fail (GEARY_SMTP_IS_AUTHENTICATOR (self), NULL);
	_klass_ = GEARY_SMTP_AUTHENTICATOR_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

static void
geary_smtp_authenticator_class_init (GearySmtpAuthenticatorClass * klass,
                                     gpointer klass_data)
{
	geary_smtp_authenticator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearySmtpAuthenticator_private_offset);
	((GearySmtpAuthenticatorClass *) klass)->initiate = (GearySmtpRequest* (*) (GearySmtpAuthenticator*)) geary_smtp_authenticator_real_initiate;
	((GearySmtpAuthenticatorClass *) klass)->challenge = (GearyMemoryBuffer* (*) (GearySmtpAuthenticator*, gint, GearySmtpResponse*, GError**)) geary_smtp_authenticator_real_challenge;
	((GearySmtpAuthenticatorClass *) klass)->to_string = (gchar* (*) (GearySmtpAuthenticator*)) geary_smtp_authenticator_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_smtp_authenticator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_smtp_authenticator_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_smtp_authenticator_finalize;
	/**
	     * The user-visible name for this {@link Authenticator}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SMTP_AUTHENTICATOR_NAME_PROPERTY, geary_smtp_authenticator_properties[GEARY_SMTP_AUTHENTICATOR_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SMTP_AUTHENTICATOR_CREDENTIALS_PROPERTY, geary_smtp_authenticator_properties[GEARY_SMTP_AUTHENTICATOR_CREDENTIALS_PROPERTY] = g_param_spec_object ("credentials", "credentials", "credentials", GEARY_TYPE_CREDENTIALS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_smtp_authenticator_instance_init (GearySmtpAuthenticator * self,
                                        gpointer klass)
{
	self->priv = geary_smtp_authenticator_get_instance_private (self);
}

static void
geary_smtp_authenticator_finalize (GObject * obj)
{
	GearySmtpAuthenticator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SMTP_TYPE_AUTHENTICATOR, GearySmtpAuthenticator);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_credentials);
	G_OBJECT_CLASS (geary_smtp_authenticator_parent_class)->finalize (obj);
}

/**
 * An abstract class describing a process for going through an SASL authentication transaction.
 *
 * Authenticators expect to use complete {@link Credentials}, i.e. user and pass must not be null.
 */
 G_GNUC_NO_INLINE static GType
geary_smtp_authenticator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpAuthenticatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_authenticator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpAuthenticator), 0, (GInstanceInitFunc) geary_smtp_authenticator_instance_init, NULL };
	GType geary_smtp_authenticator_type_id;
	geary_smtp_authenticator_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearySmtpAuthenticator", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearySmtpAuthenticator_private_offset = g_type_add_instance_private (geary_smtp_authenticator_type_id, sizeof (GearySmtpAuthenticatorPrivate));
	return geary_smtp_authenticator_type_id;
}

GType
geary_smtp_authenticator_get_type (void)
{
	static gsize geary_smtp_authenticator_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_authenticator_type_id__once)) {
		GType geary_smtp_authenticator_type_id;
		geary_smtp_authenticator_type_id = geary_smtp_authenticator_get_type_once ();
		g_once_init_leave (&geary_smtp_authenticator_type_id__once, geary_smtp_authenticator_type_id);
	}
	return geary_smtp_authenticator_type_id__once;
}

static void
_vala_geary_smtp_authenticator_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GearySmtpAuthenticator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SMTP_TYPE_AUTHENTICATOR, GearySmtpAuthenticator);
	switch (property_id) {
		case GEARY_SMTP_AUTHENTICATOR_NAME_PROPERTY:
		g_value_set_string (value, geary_smtp_authenticator_get_name (self));
		break;
		case GEARY_SMTP_AUTHENTICATOR_CREDENTIALS_PROPERTY:
		g_value_set_object (value, geary_smtp_authenticator_get_credentials (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_smtp_authenticator_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GearySmtpAuthenticator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SMTP_TYPE_AUTHENTICATOR, GearySmtpAuthenticator);
	switch (property_id) {
		case GEARY_SMTP_AUTHENTICATOR_NAME_PROPERTY:
		geary_smtp_authenticator_set_name (self, g_value_get_string (value));
		break;
		case GEARY_SMTP_AUTHENTICATOR_CREDENTIALS_PROPERTY:
		geary_smtp_authenticator_set_credentials (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

