/* archiveWriter.c generated by valac 0.56.18, the Vala compiler
 * generated from archiveWriter.vala, do not modify */

/*///////////////////////////////////////////////////////////////////////*/
/* Copyright 2011-2021 Simon Schneegans*/
/**/
/* Permission is hereby granted, free of charge, to any person obtaining*/
/* a copy of this software and associated documentation files (the*/
/* "Software"), to deal in the Software without restriction, including*/
/* without limitation the rights to use, copy, modify, merge, publish,*/
/* distribute, sublicense, and/or sell copies of the Software, and to*/
/* permit persons to whom the Software is furnished to do so, subject to*/
/* the following conditions:*/
/* */
/* The above copyright notice and this permission notice shall be*/
/* included in all copies or substantial portions of the Software.*/
/* */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,*/
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF*/
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY*/
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,*/
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE*/
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
/*///////////////////////////////////////////////////////////////////////*/

#include <glib-object.h>
#include <archive.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <archive_entry.h>
#include <sys/stat.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GNOME_PIE_TYPE_ARCHIVE_WRITER (gnome_pie_archive_writer_get_type ())
#define GNOME_PIE_ARCHIVE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_ARCHIVE_WRITER, GnomePieArchiveWriter))
#define GNOME_PIE_ARCHIVE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_ARCHIVE_WRITER, GnomePieArchiveWriterClass))
#define GNOME_PIE_IS_ARCHIVE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_ARCHIVE_WRITER))
#define GNOME_PIE_IS_ARCHIVE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_ARCHIVE_WRITER))
#define GNOME_PIE_ARCHIVE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_ARCHIVE_WRITER, GnomePieArchiveWriterClass))

typedef struct _GnomePieArchiveWriter GnomePieArchiveWriter;
typedef struct _GnomePieArchiveWriterClass GnomePieArchiveWriterClass;
typedef struct _GnomePieArchiveWriterPrivate GnomePieArchiveWriterPrivate;
enum  {
	GNOME_PIE_ARCHIVE_WRITER_0_PROPERTY,
	GNOME_PIE_ARCHIVE_WRITER_NUM_PROPERTIES
};
static GParamSpec* gnome_pie_archive_writer_properties[GNOME_PIE_ARCHIVE_WRITER_NUM_PROPERTIES];
#define _archive_write_free0(var) ((var == NULL) ? NULL : (var = (archive_write_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _archive_entry_free0(var) ((var == NULL) ? NULL : (var = (archive_entry_free (var), NULL)))

struct _GnomePieArchiveWriter {
	GObject parent_instance;
	GnomePieArchiveWriterPrivate * priv;
};

struct _GnomePieArchiveWriterClass {
	GObjectClass parent_class;
};

struct _GnomePieArchiveWriterPrivate {
	struct archive* archive;
};

static gint GnomePieArchiveWriter_private_offset;
static gpointer gnome_pie_archive_writer_parent_class = NULL;

VALA_EXTERN GType gnome_pie_archive_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieArchiveWriter, g_object_unref)
VALA_EXTERN GnomePieArchiveWriter* gnome_pie_archive_writer_new (void);
VALA_EXTERN GnomePieArchiveWriter* gnome_pie_archive_writer_construct (GType object_type);
VALA_EXTERN gboolean gnome_pie_archive_writer_open (GnomePieArchiveWriter* self,
                                        const gchar* path);
VALA_EXTERN gboolean gnome_pie_archive_writer_add (GnomePieArchiveWriter* self,
                                       const gchar* directory);
static gboolean gnome_pie_archive_writer_add_directory (GnomePieArchiveWriter* self,
                                                 const gchar* directory,
                                                 const gchar* relative_to);
VALA_EXTERN void gnome_pie_archive_writer_close (GnomePieArchiveWriter* self);
VALA_EXTERN gboolean gnome_pie_archive_writer_add_file (GnomePieArchiveWriter* self,
                                            const gchar* path,
                                            const gchar* relative_to);
static void gnome_pie_archive_writer_finalize (GObject * obj);
static GType gnome_pie_archive_writer_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gnome_pie_archive_writer_get_instance_private (GnomePieArchiveWriter* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePieArchiveWriter_private_offset);
}

GnomePieArchiveWriter*
gnome_pie_archive_writer_construct (GType object_type)
{
	GnomePieArchiveWriter * self = NULL;
	struct archive* _tmp0_;
	struct archive* _tmp1_;
	struct archive* _tmp2_;
	self = (GnomePieArchiveWriter*) g_object_new (object_type, NULL);
	_tmp0_ = archive_write_new ();
	_archive_write_free0 (self->priv->archive);
	self->priv->archive = _tmp0_;
	_tmp1_ = self->priv->archive;
	archive_write_add_filter_gzip (_tmp1_);
	_tmp2_ = self->priv->archive;
	archive_write_set_format_pax_restricted (_tmp2_);
	return self;
}

GnomePieArchiveWriter*
gnome_pie_archive_writer_new (void)
{
	return gnome_pie_archive_writer_construct (GNOME_PIE_TYPE_ARCHIVE_WRITER);
}

gboolean
gnome_pie_archive_writer_open (GnomePieArchiveWriter* self,
                               const gchar* path)
{
	struct archive* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->archive;
	result = archive_write_open_filename (_tmp0_, path) == ARCHIVE_OK;
	return result;
}

gboolean
gnome_pie_archive_writer_add (GnomePieArchiveWriter* self,
                              const gchar* directory)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	result = gnome_pie_archive_writer_add_directory (self, directory, directory);
	return result;
}

void
gnome_pie_archive_writer_close (GnomePieArchiveWriter* self)
{
	struct archive* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->archive;
	archive_write_close (_tmp0_);
}

static gboolean
gnome_pie_archive_writer_add_directory (GnomePieArchiveWriter* self,
                                        const gchar* directory,
                                        const gchar* relative_to)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	g_return_val_if_fail (relative_to != NULL, FALSE);
	{
		GDir* d = NULL;
		GDir* _tmp0_;
		gchar* name = NULL;
		_tmp0_ = g_dir_open (directory, (guint) 0, &_inner_error0_);
		d = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			const gchar* _tmp1_;
			gchar* _tmp2_;
			const gchar* _tmp3_;
			gchar* path = NULL;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp1_ = g_dir_read_name (d);
			_tmp2_ = g_strdup (_tmp1_);
			_g_free0 (name);
			name = _tmp2_;
			_tmp3_ = name;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = name;
			_tmp5_ = g_build_filename (directory, _tmp4_, NULL);
			path = _tmp5_;
			_tmp6_ = path;
			if (g_file_test (_tmp6_, G_FILE_TEST_IS_DIR)) {
				const gchar* _tmp7_;
				_tmp7_ = path;
				if (!gnome_pie_archive_writer_add_directory (self, _tmp7_, relative_to)) {
					result = FALSE;
					_g_free0 (path);
					_g_free0 (name);
					_g_dir_close0 (d);
					return result;
				}
			} else {
				const gchar* _tmp8_;
				_tmp8_ = path;
				if (g_file_test (_tmp8_, G_FILE_TEST_IS_REGULAR)) {
					const gchar* _tmp9_;
					_tmp9_ = path;
					if (!gnome_pie_archive_writer_add_file (self, _tmp9_, relative_to)) {
						result = FALSE;
						_g_free0 (path);
						_g_free0 (name);
						_g_dir_close0 (d);
						return result;
					}
				} else {
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp10_ = name;
					_tmp11_ = g_strconcat ("Packaging theme: Ignoring irregular file ", _tmp10_, NULL);
					_tmp12_ = _tmp11_;
					g_warning ("archiveWriter.vala:93: %s", _tmp12_);
					_g_free0 (_tmp12_);
				}
			}
			_g_free0 (path);
		}
		_g_free0 (name);
		_g_dir_close0 (d);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("archiveWriter.vala:97: %s", _tmp14_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	result = TRUE;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
gnome_pie_archive_writer_add_file (GnomePieArchiveWriter* self,
                                   const gchar* path,
                                   const gchar* relative_to)
{
	struct archive_entry* entry = NULL;
	struct archive_entry* _tmp0_;
	struct archive_entry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	struct stat st = {0};
	struct stat _tmp4_ = {0};
	struct archive_entry* _tmp5_;
	struct stat _tmp6_;
	struct archive_entry* _tmp7_;
	struct stat _tmp8_;
	struct archive* _tmp9_;
	struct archive_entry* _tmp10_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (relative_to != NULL, FALSE);
	_tmp0_ = archive_entry_new2 (NULL);
	entry = _tmp0_;
	_tmp1_ = entry;
	_tmp2_ = string_replace (path, relative_to, "");
	_tmp3_ = _tmp2_;
	archive_entry_set_pathname (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	stat (path, &_tmp4_);
	st = _tmp4_;
	_tmp5_ = entry;
	_tmp6_ = st;
	archive_entry_copy_stat (_tmp5_, &_tmp6_);
	_tmp7_ = entry;
	_tmp8_ = st;
	archive_entry_set_size (_tmp7_, (la_int64_t) _tmp8_.st_size);
	_tmp9_ = self->priv->archive;
	_tmp10_ = entry;
	if (archive_write_header (_tmp9_, _tmp10_) == ARCHIVE_OK) {
		{
			GFileInputStream* reader = NULL;
			GFile* _tmp11_;
			GFile* _tmp12_;
			GFileInputStream* _tmp13_;
			GFileInputStream* _tmp14_;
			guint8* buffer = NULL;
			guint8* _tmp15_;
			gint buffer_length1;
			gint _buffer_size_;
			gssize _tmp16_ = 0L;
			GFileInputStream* _tmp17_;
			guint8* _tmp18_;
			gint _tmp18__length1;
			struct archive* _tmp25_;
			_tmp11_ = g_file_new_for_path (path);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_file_read (_tmp12_, NULL, &_inner_error0_);
			_tmp14_ = _tmp13_;
			_g_object_unref0 (_tmp12_);
			reader = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp15_ = g_new0 (guint8, 4096);
			buffer = _tmp15_;
			buffer_length1 = 4096;
			_buffer_size_ = buffer_length1;
			_tmp17_ = reader;
			_tmp18_ = buffer;
			_tmp18__length1 = buffer_length1;
			_tmp16_ = g_input_stream_read ((GInputStream*) _tmp17_, _tmp18_, (gsize) _tmp18__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				buffer = (g_free (buffer), NULL);
				_g_object_unref0 (reader);
				goto __catch0_g_error;
			}
			buffer_length1 = (gint) _tmp16_;
			while (TRUE) {
				guint8* _tmp19_;
				gint _tmp19__length1;
				struct archive* _tmp20_;
				guint8* _tmp21_;
				gint _tmp21__length1;
				gssize _tmp22_ = 0L;
				GFileInputStream* _tmp23_;
				guint8* _tmp24_;
				gint _tmp24__length1;
				_tmp19_ = buffer;
				_tmp19__length1 = buffer_length1;
				if (!(_tmp19__length1 > 0)) {
					break;
				}
				_tmp20_ = self->priv->archive;
				_tmp21_ = buffer;
				_tmp21__length1 = buffer_length1;
				archive_write_data (_tmp20_, _tmp21_, (size_t) _tmp21__length1);
				_tmp23_ = reader;
				_tmp24_ = buffer;
				_tmp24__length1 = buffer_length1;
				_tmp22_ = g_input_stream_read ((GInputStream*) _tmp23_, _tmp24_, (gsize) _tmp24__length1, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					buffer = (g_free (buffer), NULL);
					_g_object_unref0 (reader);
					goto __catch0_g_error;
				}
				buffer_length1 = (gint) _tmp22_;
			}
			_tmp25_ = self->priv->archive;
			archive_write_finish_entry (_tmp25_);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (reader);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp26_;
			const gchar* _tmp27_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			g_warning ("archiveWriter.vala:136: %s", _tmp27_);
			result = FALSE;
			_g_error_free0 (e);
			_archive_entry_free0 (entry);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp28_ = FALSE;
			_archive_entry_free0 (entry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp28_;
		}
	} else {
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp29_ = g_strconcat ("Failed to include file ", path, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp30_, " into archive", NULL);
		_tmp32_ = _tmp31_;
		g_warning ("archiveWriter.vala:141: %s", _tmp32_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp30_);
		result = FALSE;
		_archive_entry_free0 (entry);
		return result;
	}
	result = TRUE;
	_archive_entry_free0 (entry);
	return result;
}

static void
gnome_pie_archive_writer_class_init (GnomePieArchiveWriterClass * klass,
                                     gpointer klass_data)
{
	gnome_pie_archive_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePieArchiveWriter_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gnome_pie_archive_writer_finalize;
}

static void
gnome_pie_archive_writer_instance_init (GnomePieArchiveWriter * self,
                                        gpointer klass)
{
	self->priv = gnome_pie_archive_writer_get_instance_private (self);
}

static void
gnome_pie_archive_writer_finalize (GObject * obj)
{
	GnomePieArchiveWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PIE_TYPE_ARCHIVE_WRITER, GnomePieArchiveWriter);
	_archive_write_free0 (self->priv->archive);
	G_OBJECT_CLASS (gnome_pie_archive_writer_parent_class)->finalize (obj);
}

static GType
gnome_pie_archive_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePieArchiveWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_pie_archive_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePieArchiveWriter), 0, (GInstanceInitFunc) gnome_pie_archive_writer_instance_init, NULL };
	GType gnome_pie_archive_writer_type_id;
	gnome_pie_archive_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomePieArchiveWriter", &g_define_type_info, 0);
	GnomePieArchiveWriter_private_offset = g_type_add_instance_private (gnome_pie_archive_writer_type_id, sizeof (GnomePieArchiveWriterPrivate));
	return gnome_pie_archive_writer_type_id;
}

GType
gnome_pie_archive_writer_get_type (void)
{
	static volatile gsize gnome_pie_archive_writer_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_archive_writer_type_id__once)) {
		GType gnome_pie_archive_writer_type_id;
		gnome_pie_archive_writer_type_id = gnome_pie_archive_writer_get_type_once ();
		g_once_init_leave (&gnome_pie_archive_writer_type_id__once, gnome_pie_archive_writer_type_id);
	}
	return gnome_pie_archive_writer_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

