{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Information about nodes in a remote object hierarchy.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.DBusNodeInfo
    ( 

-- * Exported types
    DBusNodeInfo(..)                        ,
    newZeroDBusNodeInfo                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [generateXml]("GI.Gio.Structs.DBusNodeInfo#g:method:generateXml"), [lookupInterface]("GI.Gio.Structs.DBusNodeInfo#g:method:lookupInterface"), [ref]("GI.Gio.Structs.DBusNodeInfo#g:method:ref"), [unref]("GI.Gio.Structs.DBusNodeInfo#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveDBusNodeInfoMethod               ,
#endif

-- ** generateXml #method:generateXml#

#if defined(ENABLE_OVERLOADING)
    DBusNodeInfoGenerateXmlMethodInfo       ,
#endif
    dBusNodeInfoGenerateXml                 ,


-- ** lookupInterface #method:lookupInterface#

#if defined(ENABLE_OVERLOADING)
    DBusNodeInfoLookupInterfaceMethodInfo   ,
#endif
    dBusNodeInfoLookupInterface             ,


-- ** newForXml #method:newForXml#

    dBusNodeInfoNewForXml                   ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    DBusNodeInfoRefMethodInfo               ,
#endif
    dBusNodeInfoRef                         ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    DBusNodeInfoUnrefMethodInfo             ,
#endif
    dBusNodeInfoUnref                       ,




 -- * Properties


-- ** annotations #attr:annotations#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusAnnotationInfo.DBusAnnotationInfo' structures or 'P.Nothing' if there are no annotations.

    clearDBusNodeInfoAnnotations            ,
#if defined(ENABLE_OVERLOADING)
    dBusNodeInfo_annotations                ,
#endif
    getDBusNodeInfoAnnotations              ,
    setDBusNodeInfoAnnotations              ,


-- ** interfaces #attr:interfaces#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusInterfaceInfo.DBusInterfaceInfo' structures or 'P.Nothing' if there are no interfaces.

    clearDBusNodeInfoInterfaces             ,
#if defined(ENABLE_OVERLOADING)
    dBusNodeInfo_interfaces                 ,
#endif
    getDBusNodeInfoInterfaces               ,
    setDBusNodeInfoInterfaces               ,


-- ** nodes #attr:nodes#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusNodeInfo.DBusNodeInfo' structures or 'P.Nothing' if there are no nodes.

    clearDBusNodeInfoNodes                  ,
#if defined(ENABLE_OVERLOADING)
    dBusNodeInfo_nodes                      ,
#endif
    getDBusNodeInfoNodes                    ,
    setDBusNodeInfoNodes                    ,


-- ** path #attr:path#
-- | The path of the node or 'P.Nothing' if omitted. Note that this may be a relative path. See the D-Bus specification for more details.

    clearDBusNodeInfoPath                   ,
#if defined(ENABLE_OVERLOADING)
    dBusNodeInfo_path                       ,
#endif
    getDBusNodeInfoPath                     ,
    setDBusNodeInfoPath                     ,


-- ** refCount #attr:refCount#
-- | The reference count or -1 if statically allocated.

#if defined(ENABLE_OVERLOADING)
    dBusNodeInfo_refCount                   ,
#endif
    getDBusNodeInfoRefCount                 ,
    setDBusNodeInfoRefCount                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.String as GLib.String
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusMethodInfo as Gio.DBusMethodInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusPropertyInfo as Gio.DBusPropertyInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSignalInfo as Gio.DBusSignalInfo

#else
import qualified GI.GLib.Structs.String as GLib.String
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo

#endif

-- | Memory-managed wrapper type.
newtype DBusNodeInfo = DBusNodeInfo (SP.ManagedPtr DBusNodeInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusNodeInfo where
    toManagedPtr (DBusNodeInfo p) = p

foreign import ccall "g_dbus_node_info_get_type" c_g_dbus_node_info_get_type :: 
    IO GType

type instance O.ParentTypes DBusNodeInfo = '[]
instance O.HasParentTypes DBusNodeInfo

instance B.Types.TypedObject DBusNodeInfo where
    glibType = c_g_dbus_node_info_get_type

instance B.Types.GBoxed DBusNodeInfo

-- | Convert t'DBusNodeInfo' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusNodeInfo) where
    gvalueGType_ = c_g_dbus_node_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr DBusNodeInfo)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr DBusNodeInfo)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed DBusNodeInfo ptr
        else return P.Nothing
        
    

-- | Construct a t'DBusNodeInfo' struct initialized to zero.
newZeroDBusNodeInfo :: MonadIO m => m DBusNodeInfo
newZeroDBusNodeInfo = liftIO $ callocBoxedBytes 40 >>= wrapBoxed DBusNodeInfo

instance tag ~ 'AttrSet => Constructible DBusNodeInfo tag where
    new _ attrs = do
        o <- newZeroDBusNodeInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusNodeInfo #refCount
-- @
getDBusNodeInfoRefCount :: MonadIO m => DBusNodeInfo -> m Int32
getDBusNodeInfoRefCount s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusNodeInfo [ #refCount 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusNodeInfoRefCount :: MonadIO m => DBusNodeInfo -> Int32 -> m ()
setDBusNodeInfoRefCount s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data DBusNodeInfoRefCountFieldInfo
instance AttrInfo DBusNodeInfoRefCountFieldInfo where
    type AttrBaseTypeConstraint DBusNodeInfoRefCountFieldInfo = (~) DBusNodeInfo
    type AttrAllowedOps DBusNodeInfoRefCountFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint DBusNodeInfoRefCountFieldInfo = (~) Int32
    type AttrTransferTypeConstraint DBusNodeInfoRefCountFieldInfo = (~)Int32
    type AttrTransferType DBusNodeInfoRefCountFieldInfo = Int32
    type AttrGetType DBusNodeInfoRefCountFieldInfo = Int32
    type AttrLabel DBusNodeInfoRefCountFieldInfo = "ref_count"
    type AttrOrigin DBusNodeInfoRefCountFieldInfo = DBusNodeInfo
    attrGet = getDBusNodeInfoRefCount
    attrSet = setDBusNodeInfoRefCount
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusNodeInfo.refCount"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusNodeInfo.html#g:attr:refCount"
        })

dBusNodeInfo_refCount :: AttrLabelProxy "refCount"
dBusNodeInfo_refCount = AttrLabelProxy

#endif


-- | Get the value of the “@path@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusNodeInfo #path
-- @
getDBusNodeInfoPath :: MonadIO m => DBusNodeInfo -> m (Maybe T.Text)
getDBusNodeInfoPath s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@path@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusNodeInfo [ #path 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusNodeInfoPath :: MonadIO m => DBusNodeInfo -> CString -> m ()
setDBusNodeInfoPath s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@path@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #path
-- @
clearDBusNodeInfoPath :: MonadIO m => DBusNodeInfo -> m ()
clearDBusNodeInfoPath s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DBusNodeInfoPathFieldInfo
instance AttrInfo DBusNodeInfoPathFieldInfo where
    type AttrBaseTypeConstraint DBusNodeInfoPathFieldInfo = (~) DBusNodeInfo
    type AttrAllowedOps DBusNodeInfoPathFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusNodeInfoPathFieldInfo = (~) CString
    type AttrTransferTypeConstraint DBusNodeInfoPathFieldInfo = (~)CString
    type AttrTransferType DBusNodeInfoPathFieldInfo = CString
    type AttrGetType DBusNodeInfoPathFieldInfo = Maybe T.Text
    type AttrLabel DBusNodeInfoPathFieldInfo = "path"
    type AttrOrigin DBusNodeInfoPathFieldInfo = DBusNodeInfo
    attrGet = getDBusNodeInfoPath
    attrSet = setDBusNodeInfoPath
    attrConstruct = undefined
    attrClear = clearDBusNodeInfoPath
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusNodeInfo.path"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusNodeInfo.html#g:attr:path"
        })

dBusNodeInfo_path :: AttrLabelProxy "path"
dBusNodeInfo_path = AttrLabelProxy

#endif


-- | Get the value of the “@interfaces@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusNodeInfo #interfaces
-- @
getDBusNodeInfoInterfaces :: MonadIO m => DBusNodeInfo -> m (Maybe [Gio.DBusInterfaceInfo.DBusInterfaceInfo])
getDBusNodeInfoInterfaces s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr (Ptr Gio.DBusInterfaceInfo.DBusInterfaceInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed Gio.DBusInterfaceInfo.DBusInterfaceInfo) val''
        return val'''
    return result

-- | Set the value of the “@interfaces@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusNodeInfo [ #interfaces 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusNodeInfoInterfaces :: MonadIO m => DBusNodeInfo -> Ptr (Ptr Gio.DBusInterfaceInfo.DBusInterfaceInfo) -> m ()
setDBusNodeInfoInterfaces s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr (Ptr Gio.DBusInterfaceInfo.DBusInterfaceInfo))

-- | Set the value of the “@interfaces@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #interfaces
-- @
clearDBusNodeInfoInterfaces :: MonadIO m => DBusNodeInfo -> m ()
clearDBusNodeInfoInterfaces s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr (Ptr Gio.DBusInterfaceInfo.DBusInterfaceInfo))

#if defined(ENABLE_OVERLOADING)
data DBusNodeInfoInterfacesFieldInfo
instance AttrInfo DBusNodeInfoInterfacesFieldInfo where
    type AttrBaseTypeConstraint DBusNodeInfoInterfacesFieldInfo = (~) DBusNodeInfo
    type AttrAllowedOps DBusNodeInfoInterfacesFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusNodeInfoInterfacesFieldInfo = (~) (Ptr (Ptr Gio.DBusInterfaceInfo.DBusInterfaceInfo))
    type AttrTransferTypeConstraint DBusNodeInfoInterfacesFieldInfo = (~)(Ptr (Ptr Gio.DBusInterfaceInfo.DBusInterfaceInfo))
    type AttrTransferType DBusNodeInfoInterfacesFieldInfo = (Ptr (Ptr Gio.DBusInterfaceInfo.DBusInterfaceInfo))
    type AttrGetType DBusNodeInfoInterfacesFieldInfo = Maybe [Gio.DBusInterfaceInfo.DBusInterfaceInfo]
    type AttrLabel DBusNodeInfoInterfacesFieldInfo = "interfaces"
    type AttrOrigin DBusNodeInfoInterfacesFieldInfo = DBusNodeInfo
    attrGet = getDBusNodeInfoInterfaces
    attrSet = setDBusNodeInfoInterfaces
    attrConstruct = undefined
    attrClear = clearDBusNodeInfoInterfaces
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusNodeInfo.interfaces"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusNodeInfo.html#g:attr:interfaces"
        })

dBusNodeInfo_interfaces :: AttrLabelProxy "interfaces"
dBusNodeInfo_interfaces = AttrLabelProxy

#endif


-- | Get the value of the “@nodes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusNodeInfo #nodes
-- @
getDBusNodeInfoNodes :: MonadIO m => DBusNodeInfo -> m (Maybe [DBusNodeInfo])
getDBusNodeInfoNodes s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr (Ptr DBusNodeInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed DBusNodeInfo) val''
        return val'''
    return result

-- | Set the value of the “@nodes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusNodeInfo [ #nodes 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusNodeInfoNodes :: MonadIO m => DBusNodeInfo -> Ptr (Ptr DBusNodeInfo) -> m ()
setDBusNodeInfoNodes s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr (Ptr DBusNodeInfo))

-- | Set the value of the “@nodes@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #nodes
-- @
clearDBusNodeInfoNodes :: MonadIO m => DBusNodeInfo -> m ()
clearDBusNodeInfoNodes s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr (Ptr DBusNodeInfo))

#if defined(ENABLE_OVERLOADING)
data DBusNodeInfoNodesFieldInfo
instance AttrInfo DBusNodeInfoNodesFieldInfo where
    type AttrBaseTypeConstraint DBusNodeInfoNodesFieldInfo = (~) DBusNodeInfo
    type AttrAllowedOps DBusNodeInfoNodesFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusNodeInfoNodesFieldInfo = (~) (Ptr (Ptr DBusNodeInfo))
    type AttrTransferTypeConstraint DBusNodeInfoNodesFieldInfo = (~)(Ptr (Ptr DBusNodeInfo))
    type AttrTransferType DBusNodeInfoNodesFieldInfo = (Ptr (Ptr DBusNodeInfo))
    type AttrGetType DBusNodeInfoNodesFieldInfo = Maybe [DBusNodeInfo]
    type AttrLabel DBusNodeInfoNodesFieldInfo = "nodes"
    type AttrOrigin DBusNodeInfoNodesFieldInfo = DBusNodeInfo
    attrGet = getDBusNodeInfoNodes
    attrSet = setDBusNodeInfoNodes
    attrConstruct = undefined
    attrClear = clearDBusNodeInfoNodes
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusNodeInfo.nodes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusNodeInfo.html#g:attr:nodes"
        })

dBusNodeInfo_nodes :: AttrLabelProxy "nodes"
dBusNodeInfo_nodes = AttrLabelProxy

#endif


-- | Get the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusNodeInfo #annotations
-- @
getDBusNodeInfoAnnotations :: MonadIO m => DBusNodeInfo -> m (Maybe [Gio.DBusAnnotationInfo.DBusAnnotationInfo])
getDBusNodeInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed Gio.DBusAnnotationInfo.DBusAnnotationInfo) val''
        return val'''
    return result

-- | Set the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusNodeInfo [ #annotations 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusNodeInfoAnnotations :: MonadIO m => DBusNodeInfo -> Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo) -> m ()
setDBusNodeInfoAnnotations s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))

-- | Set the value of the “@annotations@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #annotations
-- @
clearDBusNodeInfoAnnotations :: MonadIO m => DBusNodeInfo -> m ()
clearDBusNodeInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))

#if defined(ENABLE_OVERLOADING)
data DBusNodeInfoAnnotationsFieldInfo
instance AttrInfo DBusNodeInfoAnnotationsFieldInfo where
    type AttrBaseTypeConstraint DBusNodeInfoAnnotationsFieldInfo = (~) DBusNodeInfo
    type AttrAllowedOps DBusNodeInfoAnnotationsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusNodeInfoAnnotationsFieldInfo = (~) (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrTransferTypeConstraint DBusNodeInfoAnnotationsFieldInfo = (~)(Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrTransferType DBusNodeInfoAnnotationsFieldInfo = (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrGetType DBusNodeInfoAnnotationsFieldInfo = Maybe [Gio.DBusAnnotationInfo.DBusAnnotationInfo]
    type AttrLabel DBusNodeInfoAnnotationsFieldInfo = "annotations"
    type AttrOrigin DBusNodeInfoAnnotationsFieldInfo = DBusNodeInfo
    attrGet = getDBusNodeInfoAnnotations
    attrSet = setDBusNodeInfoAnnotations
    attrConstruct = undefined
    attrClear = clearDBusNodeInfoAnnotations
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusNodeInfo.annotations"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusNodeInfo.html#g:attr:annotations"
        })

dBusNodeInfo_annotations :: AttrLabelProxy "annotations"
dBusNodeInfo_annotations = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusNodeInfo
type instance O.AttributeList DBusNodeInfo = DBusNodeInfoAttributeList
type DBusNodeInfoAttributeList = ('[ '("refCount", DBusNodeInfoRefCountFieldInfo), '("path", DBusNodeInfoPathFieldInfo), '("interfaces", DBusNodeInfoInterfacesFieldInfo), '("nodes", DBusNodeInfoNodesFieldInfo), '("annotations", DBusNodeInfoAnnotationsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method DBusNodeInfo::new_for_xml
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "xml_data"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Valid D-Bus introspection XML."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusNodeInfo" })
-- throws : True
-- Skip return : False

foreign import ccall "g_dbus_node_info_new_for_xml" g_dbus_node_info_new_for_xml :: 
    CString ->                              -- xml_data : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr DBusNodeInfo)

-- | Parses /@xmlData@/ and returns a t'GI.Gio.Structs.DBusNodeInfo.DBusNodeInfo' representing the data.
-- 
-- The introspection XML must contain exactly one top-level
-- @\<node>@ element.
-- 
-- Note that this routine is using a
-- <http://developer.gnome.org/gio/stable/../glib/markup.html GMarkup>-based
-- parser that only accepts a subset of valid XML documents.
-- 
-- /Since: 2.26/
dBusNodeInfoNewForXml ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@xmlData@/: Valid D-Bus introspection XML.
    -> m DBusNodeInfo
    -- ^ __Returns:__ A t'GI.Gio.Structs.DBusNodeInfo.DBusNodeInfo' structure or 'P.Nothing' if /@error@/ is set. Free
    -- with 'GI.Gio.Structs.DBusNodeInfo.dBusNodeInfoUnref'. /(Can throw 'Data.GI.Base.GError.GError')/
dBusNodeInfoNewForXml xmlData = liftIO $ do
    xmlData' <- textToCString xmlData
    onException (do
        result <- propagateGError $ g_dbus_node_info_new_for_xml xmlData'
        checkUnexpectedReturnNULL "dBusNodeInfoNewForXml" result
        result' <- (wrapBoxed DBusNodeInfo) result
        freeMem xmlData'
        return result'
     ) (do
        freeMem xmlData'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method DBusNodeInfo::generate_xml
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusNodeInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusNodeInfo." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "indent"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Indentation level." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "string_builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "String" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GString to to append XML data to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_node_info_generate_xml" g_dbus_node_info_generate_xml :: 
    Ptr DBusNodeInfo ->                     -- info : TInterface (Name {namespace = "Gio", name = "DBusNodeInfo"})
    Word32 ->                               -- indent : TBasicType TUInt
    Ptr GLib.String.String ->               -- string_builder : TInterface (Name {namespace = "GLib", name = "String"})
    IO ()

-- | Appends an XML representation of /@info@/ (and its children) to /@stringBuilder@/.
-- 
-- This function is typically used for generating introspection XML documents at run-time for
-- handling the @org.freedesktop.DBus.Introspectable.Introspect@  method.
-- 
-- /Since: 2.26/
dBusNodeInfoGenerateXml ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusNodeInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusNodeInfo.DBusNodeInfo'.
    -> Word32
    -- ^ /@indent@/: Indentation level.
    -> GLib.String.String
    -- ^ /@stringBuilder@/: A t'GI.GLib.Structs.String.String' to to append XML data to.
    -> m ()
dBusNodeInfoGenerateXml info indent stringBuilder = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    stringBuilder' <- unsafeManagedPtrGetPtr stringBuilder
    g_dbus_node_info_generate_xml info' indent stringBuilder'
    touchManagedPtr info
    touchManagedPtr stringBuilder
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusNodeInfoGenerateXmlMethodInfo
instance (signature ~ (Word32 -> GLib.String.String -> m ()), MonadIO m) => O.OverloadedMethod DBusNodeInfoGenerateXmlMethodInfo DBusNodeInfo signature where
    overloadedMethod = dBusNodeInfoGenerateXml

instance O.OverloadedMethodInfo DBusNodeInfoGenerateXmlMethodInfo DBusNodeInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusNodeInfo.dBusNodeInfoGenerateXml",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusNodeInfo.html#v:dBusNodeInfoGenerateXml"
        })


#endif

-- method DBusNodeInfo::lookup_interface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusNodeInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusNodeInfo." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A D-Bus interface name."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "DBusInterfaceInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_node_info_lookup_interface" g_dbus_node_info_lookup_interface :: 
    Ptr DBusNodeInfo ->                     -- info : TInterface (Name {namespace = "Gio", name = "DBusNodeInfo"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Gio.DBusInterfaceInfo.DBusInterfaceInfo)

-- | Looks up information about an interface.
-- 
-- The cost of this function is O(n) in number of interfaces.
-- 
-- /Since: 2.26/
dBusNodeInfoLookupInterface ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusNodeInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusNodeInfo.DBusNodeInfo'.
    -> T.Text
    -- ^ /@name@/: A D-Bus interface name.
    -> m (Maybe Gio.DBusInterfaceInfo.DBusInterfaceInfo)
    -- ^ __Returns:__ A t'GI.Gio.Structs.DBusInterfaceInfo.DBusInterfaceInfo' or 'P.Nothing' if not found. Do not free, it is owned by /@info@/.
dBusNodeInfoLookupInterface info name = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    name' <- textToCString name
    result <- g_dbus_node_info_lookup_interface info' name'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Gio.DBusInterfaceInfo.DBusInterfaceInfo) result'
        return result''
    touchManagedPtr info
    freeMem name'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DBusNodeInfoLookupInterfaceMethodInfo
instance (signature ~ (T.Text -> m (Maybe Gio.DBusInterfaceInfo.DBusInterfaceInfo)), MonadIO m) => O.OverloadedMethod DBusNodeInfoLookupInterfaceMethodInfo DBusNodeInfo signature where
    overloadedMethod = dBusNodeInfoLookupInterface

instance O.OverloadedMethodInfo DBusNodeInfoLookupInterfaceMethodInfo DBusNodeInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusNodeInfo.dBusNodeInfoLookupInterface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusNodeInfo.html#v:dBusNodeInfoLookupInterface"
        })


#endif

-- method DBusNodeInfo::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusNodeInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusNodeInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusNodeInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_node_info_ref" g_dbus_node_info_ref :: 
    Ptr DBusNodeInfo ->                     -- info : TInterface (Name {namespace = "Gio", name = "DBusNodeInfo"})
    IO (Ptr DBusNodeInfo)

-- | If /@info@/ is statically allocated does nothing. Otherwise increases
-- the reference count.
-- 
-- /Since: 2.26/
dBusNodeInfoRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusNodeInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusNodeInfo.DBusNodeInfo'
    -> m DBusNodeInfo
    -- ^ __Returns:__ The same /@info@/.
dBusNodeInfoRef info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    result <- g_dbus_node_info_ref info'
    checkUnexpectedReturnNULL "dBusNodeInfoRef" result
    result' <- (wrapBoxed DBusNodeInfo) result
    touchManagedPtr info
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusNodeInfoRefMethodInfo
instance (signature ~ (m DBusNodeInfo), MonadIO m) => O.OverloadedMethod DBusNodeInfoRefMethodInfo DBusNodeInfo signature where
    overloadedMethod = dBusNodeInfoRef

instance O.OverloadedMethodInfo DBusNodeInfoRefMethodInfo DBusNodeInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusNodeInfo.dBusNodeInfoRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusNodeInfo.html#v:dBusNodeInfoRef"
        })


#endif

-- method DBusNodeInfo::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusNodeInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusNodeInfo." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_node_info_unref" g_dbus_node_info_unref :: 
    Ptr DBusNodeInfo ->                     -- info : TInterface (Name {namespace = "Gio", name = "DBusNodeInfo"})
    IO ()

-- | If /@info@/ is statically allocated, does nothing. Otherwise decreases
-- the reference count of /@info@/. When its reference count drops to 0,
-- the memory used is freed.
-- 
-- /Since: 2.26/
dBusNodeInfoUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusNodeInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusNodeInfo.DBusNodeInfo'.
    -> m ()
dBusNodeInfoUnref info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    g_dbus_node_info_unref info'
    touchManagedPtr info
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusNodeInfoUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod DBusNodeInfoUnrefMethodInfo DBusNodeInfo signature where
    overloadedMethod = dBusNodeInfoUnref

instance O.OverloadedMethodInfo DBusNodeInfoUnrefMethodInfo DBusNodeInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusNodeInfo.dBusNodeInfoUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-DBusNodeInfo.html#v:dBusNodeInfoUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusNodeInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusNodeInfoMethod "generateXml" o = DBusNodeInfoGenerateXmlMethodInfo
    ResolveDBusNodeInfoMethod "lookupInterface" o = DBusNodeInfoLookupInterfaceMethodInfo
    ResolveDBusNodeInfoMethod "ref" o = DBusNodeInfoRefMethodInfo
    ResolveDBusNodeInfoMethod "unref" o = DBusNodeInfoUnrefMethodInfo
    ResolveDBusNodeInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusNodeInfoMethod t DBusNodeInfo, O.OverloadedMethod info DBusNodeInfo p) => OL.IsLabel t (DBusNodeInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusNodeInfoMethod t DBusNodeInfo, O.OverloadedMethod info DBusNodeInfo p, R.HasField t DBusNodeInfo p) => R.HasField t DBusNodeInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusNodeInfoMethod t DBusNodeInfo, O.OverloadedMethodInfo info DBusNodeInfo) => OL.IsLabel t (O.MethodProxy info DBusNodeInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


