#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 3704
#define LARGE_STATE_COUNT 2200
#define SYMBOL_COUNT 459
#define ALIAS_COUNT 10
#define TOKEN_COUNT 284
#define EXTERNAL_TOKEN_COUNT 37
#define FIELD_COUNT 43
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 154

enum ts_symbol_identifiers {
  sym__identifier = 1,
  anon_sym_LBRACE = 2,
  anon_sym_RBRACE = 3,
  anon_sym_COLON = 4,
  anon_sym_SEMI = 5,
  anon_sym_package = 6,
  anon_sym_class = 7,
  anon_sym_role = 8,
  anon_sym_BUILD = 9,
  anon_sym_ADJUST = 10,
  anon_sym_DOLLAR = 11,
  anon_sym_EQ = 12,
  anon_sym_PIPE_PIPE_EQ = 13,
  anon_sym_SLASH_SLASH_EQ = 14,
  anon_sym_AT = 15,
  anon_sym_COMMA = 16,
  anon_sym_RPAREN = 17,
  anon_sym_my = 18,
  anon_sym_extended = 19,
  anon_sym_async = 20,
  anon_sym_sub = 21,
  anon_sym_method = 22,
  anon_sym_LPAREN = 23,
  anon_sym_continue = 24,
  anon_sym_state = 25,
  anon_sym_our = 26,
  anon_sym_try = 27,
  anon_sym_catch = 28,
  anon_sym_finally = 29,
  anon_sym_defer = 30,
  anon_sym_DOT_DOT_DOT = 31,
  anon_sym_else = 32,
  anon_sym_elsif = 33,
  anon_sym_and = 34,
  anon_sym_or = 35,
  anon_sym_xor = 36,
  anon_sym_LBRACK = 37,
  anon_sym_RBRACK = 38,
  anon_sym_DASH_GT = 39,
  anon_sym_PERCENT = 40,
  anon_sym_LT = 41,
  anon_sym_GT = 42,
  anon_sym_LT_LT = 43,
  anon_sym_GT_GT = 44,
  anon_sym_STAR_STAR_EQ = 45,
  anon_sym_PLUS_EQ = 46,
  anon_sym_DASH_EQ = 47,
  anon_sym_DOT_EQ = 48,
  anon_sym_STAR_EQ = 49,
  anon_sym_SLASH_EQ = 50,
  anon_sym_PERCENT_EQ = 51,
  anon_sym_x_EQ = 52,
  anon_sym_AMP_EQ = 53,
  anon_sym_PIPE_EQ = 54,
  anon_sym_CARET_EQ = 55,
  anon_sym_LT_LT_EQ = 56,
  anon_sym_GT_GT_EQ = 57,
  anon_sym_AMP_AMP_EQ = 58,
  anon_sym_DOT_DOT = 59,
  anon_sym_STAR_STAR = 60,
  anon_sym_PIPE_PIPE = 61,
  anon_sym_SLASH_SLASH = 62,
  anon_sym_CARET_CARET = 63,
  anon_sym_AMP_AMP = 64,
  anon_sym_PIPE = 65,
  anon_sym_CARET = 66,
  anon_sym_AMP = 67,
  anon_sym_GT_GT2 = 68,
  anon_sym_PLUS = 69,
  anon_sym_DASH = 70,
  anon_sym_DOT = 71,
  anon_sym_STAR = 72,
  anon_sym_SLASH = 73,
  anon_sym_x = 74,
  anon_sym_EQ_TILDE = 75,
  anon_sym_BANG_TILDE = 76,
  anon_sym_EQ_EQ = 77,
  anon_sym_BANG_EQ = 78,
  anon_sym_eq = 79,
  anon_sym_EQ_EQ_EQ = 80,
  anon_sym_equ = 81,
  anon_sym_eqr = 82,
  anon_sym_ne = 83,
  anon_sym_LT_EQ_GT = 84,
  anon_sym_cmp = 85,
  anon_sym_TILDE_TILDE = 86,
  anon_sym_LT_EQ = 87,
  anon_sym_GT_EQ = 88,
  anon_sym_lt = 89,
  anon_sym_le = 90,
  anon_sym_ge = 91,
  anon_sym_gt = 92,
  anon_sym_isa = 93,
  anon_sym_TILDE = 94,
  anon_sym_BANG = 95,
  anon_sym_PLUS_PLUS = 96,
  anon_sym_DASH_DASH = 97,
  anon_sym_QMARK = 98,
  anon_sym_BSLASH = 99,
  anon_sym_do = 100,
  anon_sym_eval = 101,
  anon_sym_await = 102,
  anon_sym_field = 103,
  anon_sym_local = 104,
  anon_sym_dynamically = 105,
  anon_sym_require = 106,
  anon_sym_map = 107,
  anon_sym_grep = 108,
  anon_sym_sort = 109,
  anon_sym_goto = 110,
  anon_sym_return = 111,
  anon_sym_undef = 112,
  anon_sym_PERCENT2 = 113,
  anon_sym_DOLLAR_POUND = 114,
  aux_sym__var_indirob_autoquote_token1 = 115,
  anon_sym_EQ_GT = 116,
  anon_sym_use = 117,
  anon_sym_no = 118,
  anon_sym_for = 119,
  anon_sym_foreach = 120,
  anon_sym_last = 121,
  anon_sym_next = 122,
  anon_sym_redo = 123,
  anon_sym_BEGIN = 124,
  anon_sym_INIT = 125,
  anon_sym_CHECK = 126,
  anon_sym_UNITCHECK = 127,
  anon_sym_END = 128,
  anon_sym___FILE__ = 129,
  anon_sym___LINE__ = 130,
  anon_sym___PACKAGE__ = 131,
  anon_sym___SUB__ = 132,
  anon_sym_break = 133,
  anon_sym_fork = 134,
  anon_sym_getppid = 135,
  anon_sym_time = 136,
  anon_sym_times = 137,
  anon_sym_wait = 138,
  anon_sym_wantarray = 139,
  anon_sym_abs = 140,
  anon_sym_alarm = 141,
  anon_sym_chop = 142,
  anon_sym_chdir = 143,
  anon_sym_close = 144,
  anon_sym_closedir = 145,
  anon_sym_caller = 146,
  anon_sym_chomp = 147,
  anon_sym_chr = 148,
  anon_sym_cos = 149,
  anon_sym_chroot = 150,
  anon_sym_defined = 151,
  anon_sym_delete = 152,
  anon_sym_dbmclose = 153,
  anon_sym_exists = 154,
  anon_sym_exit = 155,
  anon_sym_eof = 156,
  anon_sym_exp = 157,
  anon_sym_each = 158,
  anon_sym_fc = 159,
  anon_sym_fileno = 160,
  anon_sym_gmtime = 161,
  anon_sym_getc = 162,
  anon_sym_getpgrp = 163,
  anon_sym_getprotobyname = 164,
  anon_sym_getpwname = 165,
  anon_sym_getpwuid = 166,
  anon_sym_getpeername = 167,
  anon_sym_getnetbyname = 168,
  anon_sym_getsockname = 169,
  anon_sym_getgrnam = 170,
  anon_sym_getgrgid = 171,
  anon_sym_hex = 172,
  anon_sym_int = 173,
  anon_sym_keys = 174,
  anon_sym_lc = 175,
  anon_sym_lcfirst = 176,
  anon_sym_length = 177,
  anon_sym_localtime = 178,
  anon_sym_log = 179,
  anon_sym_lock = 180,
  anon_sym_lstat = 181,
  anon_sym_oct = 182,
  anon_sym_ord = 183,
  anon_sym_prototype = 184,
  anon_sym_pop = 185,
  anon_sym_pos = 186,
  anon_sym_quotemeta = 187,
  anon_sym_reset = 188,
  anon_sym_rand = 189,
  anon_sym_rmdir = 190,
  anon_sym_readdir = 191,
  anon_sym_readline = 192,
  anon_sym_readpipe = 193,
  anon_sym_rewinddir = 194,
  anon_sym_readlink = 195,
  anon_sym_ref = 196,
  anon_sym_scalar = 197,
  anon_sym_shift = 198,
  anon_sym_sin = 199,
  anon_sym_sleep = 200,
  anon_sym_sqrt = 201,
  anon_sym_srand = 202,
  anon_sym_stat = 203,
  anon_sym_study = 204,
  anon_sym_tell = 205,
  anon_sym_telldir = 206,
  anon_sym_tied = 207,
  anon_sym_uc = 208,
  anon_sym_ucfirst = 209,
  anon_sym_untie = 210,
  anon_sym_umask = 211,
  anon_sym_values = 212,
  anon_sym_write = 213,
  sym_comment = 214,
  anon_sym___DATA__ = 215,
  anon_sym___END__ = 216,
  aux_sym___DATA___token1 = 217,
  anon_sym_EOT = 218,
  anon_sym_q = 219,
  anon_sym_qq = 220,
  anon_sym_DASH_GT2 = 221,
  anon_sym_LBRACK2 = 222,
  anon_sym_LBRACE2 = 223,
  aux_sym__interpolation_fallbacks_token1 = 224,
  anon_sym_qw = 225,
  anon_sym_qx = 226,
  anon_sym_qr = 227,
  anon_sym_m = 228,
  anon_sym_s = 229,
  sym_quoted_regexp_modifiers = 230,
  sym_match_regexp_modifiers = 231,
  sym_substitution_regexp_modifiers = 232,
  sym_transliteration_modifiers = 233,
  aux_sym__interpolated_transliteration_content_token1 = 234,
  anon_sym_tr = 235,
  anon_sym_y = 236,
  sym_version = 237,
  anon_sym_if = 238,
  anon_sym_unless = 239,
  anon_sym_while = 240,
  anon_sym_until = 241,
  aux_sym__ident_special_token1 = 242,
  aux_sym__bareword_token1 = 243,
  sym_number = 244,
  anon_sym_true = 245,
  anon_sym_false = 246,
  sym__single_quote = 247,
  sym__double_quote = 248,
  sym__backtick_quote = 249,
  sym__search_slash_quote = 250,
  sym__no_search_slash_plz = 251,
  sym__PERLY_SEMICOLON = 252,
  sym__PERLY_HEREDOC = 253,
  sym__ctrl_z_hack = 254,
  sym__quotelike_begin_quote = 255,
  sym__quotelike_middle_close_quote = 256,
  sym__quotelike_middle_skip = 257,
  sym__quotelike_end_zw = 258,
  sym__quotelike_end_quote = 259,
  sym__q_string_content = 260,
  sym__qq_string_content = 261,
  sym_escape_sequence = 262,
  sym_escaped_delimiter = 263,
  sym__dollar_in_regexp = 264,
  sym_pod = 265,
  sym__gobbled_content = 266,
  sym__attribute_value_begin = 267,
  sym_attribute_value = 268,
  sym_prototype = 269,
  sym__signature_start = 270,
  sym__heredoc_delimiter = 271,
  sym__command_heredoc_delimiter = 272,
  sym__heredoc_start = 273,
  sym__heredoc_middle = 274,
  sym_heredoc_end = 275,
  sym__fat_comma_autoquoted = 276,
  sym__filetest = 277,
  sym__brace_autoquoted_token = 278,
  sym__brace_end_zw = 279,
  sym__dollar_ident_zw = 280,
  sym__no_interp_whitespace_zw = 281,
  sym__NONASSOC = 282,
  sym__ERROR = 283,
  sym_source_file = 284,
  sym__PERLY_BRACE_OPEN = 285,
  sym_block = 286,
  sym__fullstmt = 287,
  sym_statement_label = 288,
  sym__semicolon = 289,
  sym__barestmt = 290,
  sym_package_statement = 291,
  sym_class_statement = 292,
  sym_role_statement = 293,
  sym_class_phaser_statement = 294,
  sym_use_version_statement = 295,
  sym_use_statement = 296,
  sym_mandatory_parameter = 297,
  sym_optional_parameter = 298,
  sym_named_parameter = 299,
  sym_slurpy_parameter = 300,
  sym__signature_vars = 301,
  sym_signature = 302,
  sym_subroutine_declaration_statement = 303,
  sym_method_declaration_statement = 304,
  sym_phaser_statement = 305,
  sym_conditional_statement = 306,
  sym__loop_body = 307,
  sym_loop_statement = 308,
  sym_cstyle_for_statement = 309,
  sym__for_initializer = 310,
  sym_for_statement = 311,
  sym_try_statement = 312,
  sym_defer_statement = 313,
  sym_expression_statement = 314,
  sym__postfix_expressions = 315,
  sym_postfix_conditional_expression = 316,
  sym_postfix_loop_expression = 317,
  sym_postfix_for_expression = 318,
  sym_yadayada = 319,
  sym__else = 320,
  sym_else = 321,
  sym_elsif = 322,
  sym__expr = 323,
  sym_lowprec_logical_expression = 324,
  sym__listexpr = 325,
  sym__term_rightward = 326,
  sym_list_expression = 327,
  sym__subscripted = 328,
  sym_container_variable = 329,
  sym_array_element_expression = 330,
  sym__hash_key = 331,
  sym_hash_element_expression = 332,
  sym_coderef_call_expression = 333,
  sym_anonymous_slice_expression = 334,
  sym_slice_container_variable = 335,
  sym_slice_expression = 336,
  sym_keyval_container_variable = 337,
  sym_keyval_expression = 338,
  sym__term = 339,
  sym_readline_expression = 340,
  sym_assignment_expression = 341,
  sym_binary_expression = 342,
  sym_equality_expression = 343,
  sym_relational_expression = 344,
  sym_unary_expression = 345,
  sym_preinc_expression = 346,
  sym_postinc_expression = 347,
  sym_conditional_expression = 348,
  sym_refgen_expression = 349,
  sym_anonymous_array_expression = 350,
  sym__tricky_list = 351,
  sym_anonymous_hash_expression = 352,
  sym_anonymous_subroutine_expression = 353,
  sym_anonymous_method_expression = 354,
  sym_do_expression = 355,
  sym_eval_expression = 356,
  sym_await_expression = 357,
  sym__declared_vars = 358,
  sym_variable_declaration = 359,
  sym__decl_variable_list = 360,
  sym_localization_expression = 361,
  sym_stub_expression = 362,
  sym_scalar_deref_expression = 363,
  sym_array_deref_expression = 364,
  sym_hash_deref_expression = 365,
  sym_amper_deref_expression = 366,
  sym_glob_deref_expression = 367,
  sym_require_expression = 368,
  sym_func0op_call_expression = 369,
  sym_func1op_call_expression = 370,
  sym_map_grep_expression = 371,
  sym_sort_expression = 372,
  sym__label_arg = 373,
  sym_loopex_expression = 374,
  sym_goto_expression = 375,
  sym_return_expression = 376,
  sym_undef_expression = 377,
  sym__listop = 378,
  sym_indirect_object = 379,
  sym_function_call_expression = 380,
  sym__tricky_indirob_hashref = 381,
  sym_ambiguous_function_call_expression = 382,
  sym_function = 383,
  sym_method_call_expression = 384,
  sym_method = 385,
  sym__signature_varname = 386,
  sym_scalar = 387,
  sym__declare_scalar = 388,
  sym__signature_scalar = 389,
  sym_array = 390,
  sym__declare_array = 391,
  sym__signature_array = 392,
  sym_hash = 393,
  sym__declare_hash = 394,
  sym__signature_hash = 395,
  sym_arraylen = 396,
  sym_glob = 397,
  sym__indirob = 398,
  sym_varname = 399,
  sym__var_indirob_autoquote = 400,
  sym__var_indirob = 401,
  sym_attrlist = 402,
  sym_attribute = 403,
  sym_attribute_name = 404,
  sym___DATA__ = 405,
  sym__literal = 406,
  sym__apostrophe = 407,
  sym__quotation_mark = 408,
  sym__backtick = 409,
  sym__search_slash = 410,
  sym__quotelike_begin = 411,
  sym__quotelike_middle_close = 412,
  sym__quotelike_end = 413,
  sym__quotelike_middle = 414,
  sym_string_literal = 415,
  sym_interpolated_string_literal = 416,
  sym__subscripted_interpolations = 417,
  sym__braced_scalar = 418,
  sym__braced_array = 419,
  sym__interp_arrow = 420,
  sym__array_element_interpolation = 421,
  sym__hash_element_interpolation = 422,
  sym__slice_expression_interpolation = 423,
  sym__interpolations = 424,
  aux_sym__noninterpolated_string_content = 425,
  sym__interpolation_fallbacks = 426,
  sym__nonvar_interpolation_fallbacks = 427,
  aux_sym__interpolated_string_content = 428,
  sym_quoted_word_list = 429,
  sym_command_string = 430,
  sym_quoted_regexp = 431,
  sym_match_regexp = 432,
  sym_substitution_regexp = 433,
  aux_sym__interpolated_regexp_content = 434,
  aux_sym__interpolated_transliteration_content = 435,
  sym_transliteration_expression = 436,
  sym_heredoc_token = 437,
  sym_command_heredoc_token = 438,
  sym_heredoc_content = 439,
  sym_package = 440,
  sym__version = 441,
  sym__conditionals = 442,
  sym__loops = 443,
  sym_autoquoted_bareword = 444,
  sym__brace_autoquoted = 445,
  sym_identifier = 446,
  sym__ident_special = 447,
  sym_bareword = 448,
  sym_primitive = 449,
  sym_boolean = 450,
  aux_sym_source_file_repeat1 = 451,
  aux_sym_signature_repeat1 = 452,
  aux_sym_subroutine_declaration_statement_repeat1 = 453,
  aux_sym__for_initializer_repeat1 = 454,
  aux_sym__term_rightward_repeat1 = 455,
  aux_sym__decl_variable_list_repeat1 = 456,
  aux_sym_attrlist_repeat1 = 457,
  aux_sym_heredoc_content_repeat1 = 458,
  alias_sym_block_statement = 459,
  alias_sym_data_section = 460,
  alias_sym_filename = 461,
  alias_sym_label = 462,
  anon_alias_sym_not_DASHinterpolated = 463,
  alias_sym_regexp_content = 464,
  alias_sym_replacement = 465,
  anon_alias_sym_sner = 466,
  alias_sym_string_content = 467,
  alias_sym_transliteration_content = 468,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__identifier] = "_identifier",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COLON] = ":",
  [anon_sym_SEMI] = ";",
  [anon_sym_package] = "package",
  [anon_sym_class] = "class",
  [anon_sym_role] = "role",
  [anon_sym_BUILD] = "BUILD",
  [anon_sym_ADJUST] = "ADJUST",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_EQ] = "=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_AT] = "@",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_my] = "my",
  [anon_sym_extended] = "extended",
  [anon_sym_async] = "async",
  [anon_sym_sub] = "sub",
  [anon_sym_method] = "method",
  [anon_sym_LPAREN] = "(",
  [anon_sym_continue] = "continue",
  [anon_sym_state] = "state",
  [anon_sym_our] = "our",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_defer] = "defer",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_else] = "else",
  [anon_sym_elsif] = "elsif",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_xor] = "xor",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_DOT_EQ] = ".=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_x_EQ] = "x=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_CARET_CARET] = "^^",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_GT_GT2] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_DOT] = ".",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_x] = "x",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_BANG_TILDE] = "!~",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_eq] = "eq",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_equ] = "equ",
  [anon_sym_eqr] = "eqr",
  [anon_sym_ne] = "ne",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_cmp] = "cmp",
  [anon_sym_TILDE_TILDE] = "~~",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_lt] = "lt",
  [anon_sym_le] = "le",
  [anon_sym_ge] = "ge",
  [anon_sym_gt] = "gt",
  [anon_sym_isa] = "isa",
  [anon_sym_TILDE] = "~",
  [anon_sym_BANG] = "!",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_QMARK] = "\?",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_do] = "do",
  [anon_sym_eval] = "eval",
  [anon_sym_await] = "await",
  [anon_sym_field] = "field",
  [anon_sym_local] = "local",
  [anon_sym_dynamically] = "dynamically",
  [anon_sym_require] = "require",
  [anon_sym_map] = "map",
  [anon_sym_grep] = "grep",
  [anon_sym_sort] = "sort",
  [anon_sym_goto] = "goto",
  [anon_sym_return] = "return",
  [anon_sym_undef] = "undef",
  [anon_sym_PERCENT2] = "%",
  [anon_sym_DOLLAR_POUND] = "$#",
  [aux_sym__var_indirob_autoquote_token1] = "varname",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_use] = "use",
  [anon_sym_no] = "no",
  [anon_sym_for] = "for",
  [anon_sym_foreach] = "foreach",
  [anon_sym_last] = "last",
  [anon_sym_next] = "next",
  [anon_sym_redo] = "redo",
  [anon_sym_BEGIN] = "BEGIN",
  [anon_sym_INIT] = "INIT",
  [anon_sym_CHECK] = "CHECK",
  [anon_sym_UNITCHECK] = "UNITCHECK",
  [anon_sym_END] = "END",
  [anon_sym___FILE__] = "__FILE__",
  [anon_sym___LINE__] = "__LINE__",
  [anon_sym___PACKAGE__] = "__PACKAGE__",
  [anon_sym___SUB__] = "__SUB__",
  [anon_sym_break] = "break",
  [anon_sym_fork] = "fork",
  [anon_sym_getppid] = "getppid",
  [anon_sym_time] = "time",
  [anon_sym_times] = "times",
  [anon_sym_wait] = "wait",
  [anon_sym_wantarray] = "wantarray",
  [anon_sym_abs] = "abs",
  [anon_sym_alarm] = "alarm",
  [anon_sym_chop] = "chop",
  [anon_sym_chdir] = "chdir",
  [anon_sym_close] = "close",
  [anon_sym_closedir] = "closedir",
  [anon_sym_caller] = "caller",
  [anon_sym_chomp] = "chomp",
  [anon_sym_chr] = "chr",
  [anon_sym_cos] = "cos",
  [anon_sym_chroot] = "chroot",
  [anon_sym_defined] = "defined",
  [anon_sym_delete] = "delete",
  [anon_sym_dbmclose] = "dbmclose",
  [anon_sym_exists] = "exists",
  [anon_sym_exit] = "exit",
  [anon_sym_eof] = "eof",
  [anon_sym_exp] = "exp",
  [anon_sym_each] = "each",
  [anon_sym_fc] = "fc",
  [anon_sym_fileno] = "fileno",
  [anon_sym_gmtime] = "gmtime",
  [anon_sym_getc] = "getc",
  [anon_sym_getpgrp] = "getpgrp",
  [anon_sym_getprotobyname] = "getprotobyname",
  [anon_sym_getpwname] = "getpwname",
  [anon_sym_getpwuid] = "getpwuid",
  [anon_sym_getpeername] = "getpeername",
  [anon_sym_getnetbyname] = "getnetbyname",
  [anon_sym_getsockname] = "getsockname",
  [anon_sym_getgrnam] = "getgrnam",
  [anon_sym_getgrgid] = "getgrgid",
  [anon_sym_hex] = "hex",
  [anon_sym_int] = "int",
  [anon_sym_keys] = "keys",
  [anon_sym_lc] = "lc",
  [anon_sym_lcfirst] = "lcfirst",
  [anon_sym_length] = "length",
  [anon_sym_localtime] = "localtime",
  [anon_sym_log] = "log",
  [anon_sym_lock] = "lock",
  [anon_sym_lstat] = "lstat",
  [anon_sym_oct] = "oct",
  [anon_sym_ord] = "ord",
  [anon_sym_prototype] = "prototype",
  [anon_sym_pop] = "pop",
  [anon_sym_pos] = "pos",
  [anon_sym_quotemeta] = "quotemeta",
  [anon_sym_reset] = "reset",
  [anon_sym_rand] = "rand",
  [anon_sym_rmdir] = "rmdir",
  [anon_sym_readdir] = "readdir",
  [anon_sym_readline] = "readline",
  [anon_sym_readpipe] = "readpipe",
  [anon_sym_rewinddir] = "rewinddir",
  [anon_sym_readlink] = "readlink",
  [anon_sym_ref] = "ref",
  [anon_sym_scalar] = "scalar",
  [anon_sym_shift] = "shift",
  [anon_sym_sin] = "sin",
  [anon_sym_sleep] = "sleep",
  [anon_sym_sqrt] = "sqrt",
  [anon_sym_srand] = "srand",
  [anon_sym_stat] = "stat",
  [anon_sym_study] = "study",
  [anon_sym_tell] = "tell",
  [anon_sym_telldir] = "telldir",
  [anon_sym_tied] = "tied",
  [anon_sym_uc] = "uc",
  [anon_sym_ucfirst] = "ucfirst",
  [anon_sym_untie] = "untie",
  [anon_sym_umask] = "umask",
  [anon_sym_values] = "values",
  [anon_sym_write] = "write",
  [sym_comment] = "comment",
  [anon_sym___DATA__] = "eof_marker",
  [anon_sym___END__] = "eof_marker",
  [aux_sym___DATA___token1] = "__DATA___token1",
  [anon_sym_EOT] = "eof_marker",
  [anon_sym_q] = "q",
  [anon_sym_qq] = "qq",
  [anon_sym_DASH_GT2] = "->",
  [anon_sym_LBRACK2] = "[",
  [anon_sym_LBRACE2] = "{",
  [aux_sym__interpolation_fallbacks_token1] = "_interpolation_fallbacks_token1",
  [anon_sym_qw] = "qw",
  [anon_sym_qx] = "qx",
  [anon_sym_qr] = "qr",
  [anon_sym_m] = "m",
  [anon_sym_s] = "s",
  [sym_quoted_regexp_modifiers] = "quoted_regexp_modifiers",
  [sym_match_regexp_modifiers] = "match_regexp_modifiers",
  [sym_substitution_regexp_modifiers] = "substitution_regexp_modifiers",
  [sym_transliteration_modifiers] = "transliteration_modifiers",
  [aux_sym__interpolated_transliteration_content_token1] = "_interpolated_transliteration_content_token1",
  [anon_sym_tr] = "tr",
  [anon_sym_y] = "y",
  [sym_version] = "version",
  [anon_sym_if] = "if",
  [anon_sym_unless] = "unless",
  [anon_sym_while] = "while",
  [anon_sym_until] = "until",
  [aux_sym__ident_special_token1] = "_ident_special_token1",
  [aux_sym__bareword_token1] = "_bareword_token1",
  [sym_number] = "number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym__single_quote] = "'",
  [sym__double_quote] = "'",
  [sym__backtick_quote] = "'",
  [sym__search_slash_quote] = "'",
  [sym__no_search_slash_plz] = "_no_search_slash_plz",
  [sym__PERLY_SEMICOLON] = "_PERLY_SEMICOLON",
  [sym__PERLY_HEREDOC] = "_PERLY_HEREDOC",
  [sym__ctrl_z_hack] = "eof_marker",
  [sym__quotelike_begin_quote] = "'",
  [sym__quotelike_middle_close_quote] = "'",
  [sym__quotelike_middle_skip] = "_quotelike_middle_skip",
  [sym__quotelike_end_zw] = "_quotelike_end_zw",
  [sym__quotelike_end_quote] = "'",
  [sym__q_string_content] = "_q_string_content",
  [sym__qq_string_content] = "_qq_string_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_escaped_delimiter] = "escaped_delimiter",
  [sym__dollar_in_regexp] = "_dollar_in_regexp",
  [sym_pod] = "pod",
  [sym__gobbled_content] = "_gobbled_content",
  [sym__attribute_value_begin] = "_attribute_value_begin",
  [sym_attribute_value] = "attribute_value",
  [sym_prototype] = "prototype",
  [sym__signature_start] = "(",
  [sym__heredoc_delimiter] = "_heredoc_delimiter",
  [sym__command_heredoc_delimiter] = "_command_heredoc_delimiter",
  [sym__heredoc_start] = "_heredoc_start",
  [sym__heredoc_middle] = "_heredoc_middle",
  [sym_heredoc_end] = "heredoc_end",
  [sym__fat_comma_autoquoted] = "_fat_comma_autoquoted",
  [sym__filetest] = "-x",
  [sym__brace_autoquoted_token] = "varname",
  [sym__brace_end_zw] = "_brace_end_zw",
  [sym__dollar_ident_zw] = "_dollar_ident_zw",
  [sym__no_interp_whitespace_zw] = "_no_interp_whitespace_zw",
  [sym__NONASSOC] = "_NONASSOC",
  [sym__ERROR] = "_ERROR",
  [sym_source_file] = "source_file",
  [sym__PERLY_BRACE_OPEN] = "_PERLY_BRACE_OPEN",
  [sym_block] = "block",
  [sym__fullstmt] = "_fullstmt",
  [sym_statement_label] = "statement_label",
  [sym__semicolon] = "_semicolon",
  [sym__barestmt] = "_barestmt",
  [sym_package_statement] = "package_statement",
  [sym_class_statement] = "class_statement",
  [sym_role_statement] = "role_statement",
  [sym_class_phaser_statement] = "class_phaser_statement",
  [sym_use_version_statement] = "use_version_statement",
  [sym_use_statement] = "use_statement",
  [sym_mandatory_parameter] = "mandatory_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym_named_parameter] = "named_parameter",
  [sym_slurpy_parameter] = "slurpy_parameter",
  [sym__signature_vars] = "_signature_vars",
  [sym_signature] = "signature",
  [sym_subroutine_declaration_statement] = "subroutine_declaration_statement",
  [sym_method_declaration_statement] = "method_declaration_statement",
  [sym_phaser_statement] = "phaser_statement",
  [sym_conditional_statement] = "conditional_statement",
  [sym__loop_body] = "_loop_body",
  [sym_loop_statement] = "loop_statement",
  [sym_cstyle_for_statement] = "cstyle_for_statement",
  [sym__for_initializer] = "_for_initializer",
  [sym_for_statement] = "for_statement",
  [sym_try_statement] = "try_statement",
  [sym_defer_statement] = "defer_statement",
  [sym_expression_statement] = "expression_statement",
  [sym__postfix_expressions] = "_postfix_expressions",
  [sym_postfix_conditional_expression] = "postfix_conditional_expression",
  [sym_postfix_loop_expression] = "postfix_loop_expression",
  [sym_postfix_for_expression] = "postfix_for_expression",
  [sym_yadayada] = "yadayada",
  [sym__else] = "_else",
  [sym_else] = "else",
  [sym_elsif] = "elsif",
  [sym__expr] = "_expr",
  [sym_lowprec_logical_expression] = "lowprec_logical_expression",
  [sym__listexpr] = "_listexpr",
  [sym__term_rightward] = "_term_rightward",
  [sym_list_expression] = "list_expression",
  [sym__subscripted] = "_subscripted",
  [sym_container_variable] = "container_variable",
  [sym_array_element_expression] = "array_element_expression",
  [sym__hash_key] = "_hash_key",
  [sym_hash_element_expression] = "hash_element_expression",
  [sym_coderef_call_expression] = "coderef_call_expression",
  [sym_anonymous_slice_expression] = "anonymous_slice_expression",
  [sym_slice_container_variable] = "slice_container_variable",
  [sym_slice_expression] = "slice_expression",
  [sym_keyval_container_variable] = "keyval_container_variable",
  [sym_keyval_expression] = "keyval_expression",
  [sym__term] = "_term",
  [sym_readline_expression] = "readline_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_equality_expression] = "equality_expression",
  [sym_relational_expression] = "relational_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_preinc_expression] = "preinc_expression",
  [sym_postinc_expression] = "postinc_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_refgen_expression] = "refgen_expression",
  [sym_anonymous_array_expression] = "anonymous_array_expression",
  [sym__tricky_list] = "list_expression",
  [sym_anonymous_hash_expression] = "anonymous_hash_expression",
  [sym_anonymous_subroutine_expression] = "anonymous_subroutine_expression",
  [sym_anonymous_method_expression] = "anonymous_method_expression",
  [sym_do_expression] = "do_expression",
  [sym_eval_expression] = "eval_expression",
  [sym_await_expression] = "await_expression",
  [sym__declared_vars] = "_declared_vars",
  [sym_variable_declaration] = "variable_declaration",
  [sym__decl_variable_list] = "_decl_variable_list",
  [sym_localization_expression] = "localization_expression",
  [sym_stub_expression] = "stub_expression",
  [sym_scalar_deref_expression] = "scalar_deref_expression",
  [sym_array_deref_expression] = "array_deref_expression",
  [sym_hash_deref_expression] = "hash_deref_expression",
  [sym_amper_deref_expression] = "amper_deref_expression",
  [sym_glob_deref_expression] = "glob_deref_expression",
  [sym_require_expression] = "require_expression",
  [sym_func0op_call_expression] = "func0op_call_expression",
  [sym_func1op_call_expression] = "func1op_call_expression",
  [sym_map_grep_expression] = "map_grep_expression",
  [sym_sort_expression] = "sort_expression",
  [sym__label_arg] = "_label_arg",
  [sym_loopex_expression] = "loopex_expression",
  [sym_goto_expression] = "goto_expression",
  [sym_return_expression] = "return_expression",
  [sym_undef_expression] = "undef_expression",
  [sym__listop] = "_listop",
  [sym_indirect_object] = "indirect_object",
  [sym_function_call_expression] = "function_call_expression",
  [sym__tricky_indirob_hashref] = "anonymous_hash_expression",
  [sym_ambiguous_function_call_expression] = "ambiguous_function_call_expression",
  [sym_function] = "function",
  [sym_method_call_expression] = "method_call_expression",
  [sym_method] = "method",
  [sym__signature_varname] = "_signature_varname",
  [sym_scalar] = "scalar",
  [sym__declare_scalar] = "scalar",
  [sym__signature_scalar] = "scalar",
  [sym_array] = "array",
  [sym__declare_array] = "array",
  [sym__signature_array] = "array",
  [sym_hash] = "hash",
  [sym__declare_hash] = "hash",
  [sym__signature_hash] = "hash",
  [sym_arraylen] = "arraylen",
  [sym_glob] = "glob",
  [sym__indirob] = "filehandle",
  [sym_varname] = "varname",
  [sym__var_indirob_autoquote] = "_var_indirob_autoquote",
  [sym__var_indirob] = "_var_indirob",
  [sym_attrlist] = "attrlist",
  [sym_attribute] = "attribute",
  [sym_attribute_name] = "attribute_name",
  [sym___DATA__] = "__DATA__",
  [sym__literal] = "_literal",
  [sym__apostrophe] = "_apostrophe",
  [sym__quotation_mark] = "_quotation_mark",
  [sym__backtick] = "_backtick",
  [sym__search_slash] = "_search_slash",
  [sym__quotelike_begin] = "_quotelike_begin",
  [sym__quotelike_middle_close] = "_quotelike_middle_close",
  [sym__quotelike_end] = "_quotelike_end",
  [sym__quotelike_middle] = "_quotelike_middle",
  [sym_string_literal] = "string_literal",
  [sym_interpolated_string_literal] = "interpolated_string_literal",
  [sym__subscripted_interpolations] = "_subscripted_interpolations",
  [sym__braced_scalar] = "scalar",
  [sym__braced_array] = "array",
  [sym__interp_arrow] = "_interp_arrow",
  [sym__array_element_interpolation] = "array_element_expression",
  [sym__hash_element_interpolation] = "hash_element_expression",
  [sym__slice_expression_interpolation] = "slice_expression",
  [sym__interpolations] = "_interpolations",
  [aux_sym__noninterpolated_string_content] = "_noninterpolated_string_content",
  [sym__interpolation_fallbacks] = "_interpolation_fallbacks",
  [sym__nonvar_interpolation_fallbacks] = "_nonvar_interpolation_fallbacks",
  [aux_sym__interpolated_string_content] = "_interpolated_string_content",
  [sym_quoted_word_list] = "quoted_word_list",
  [sym_command_string] = "command_string",
  [sym_quoted_regexp] = "quoted_regexp",
  [sym_match_regexp] = "match_regexp",
  [sym_substitution_regexp] = "substitution_regexp",
  [aux_sym__interpolated_regexp_content] = "_interpolated_regexp_content",
  [aux_sym__interpolated_transliteration_content] = "_interpolated_transliteration_content",
  [sym_transliteration_expression] = "transliteration_expression",
  [sym_heredoc_token] = "heredoc_token",
  [sym_command_heredoc_token] = "command_heredoc_token",
  [sym_heredoc_content] = "heredoc_content",
  [sym_package] = "package",
  [sym__version] = "_version",
  [sym__conditionals] = "_conditionals",
  [sym__loops] = "_loops",
  [sym_autoquoted_bareword] = "autoquoted_bareword",
  [sym__brace_autoquoted] = "_brace_autoquoted",
  [sym_identifier] = "identifier",
  [sym__ident_special] = "_ident_special",
  [sym_bareword] = "bareword",
  [sym_primitive] = "primitive",
  [sym_boolean] = "boolean",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_signature_repeat1] = "signature_repeat1",
  [aux_sym_subroutine_declaration_statement_repeat1] = "subroutine_declaration_statement_repeat1",
  [aux_sym__for_initializer_repeat1] = "_for_initializer_repeat1",
  [aux_sym__term_rightward_repeat1] = "_term_rightward_repeat1",
  [aux_sym__decl_variable_list_repeat1] = "_decl_variable_list_repeat1",
  [aux_sym_attrlist_repeat1] = "attrlist_repeat1",
  [aux_sym_heredoc_content_repeat1] = "heredoc_content_repeat1",
  [alias_sym_block_statement] = "block_statement",
  [alias_sym_data_section] = "data_section",
  [alias_sym_filename] = "filename",
  [alias_sym_label] = "label",
  [anon_alias_sym_not_DASHinterpolated] = "not-interpolated",
  [alias_sym_regexp_content] = "regexp_content",
  [alias_sym_replacement] = "replacement",
  [anon_alias_sym_sner] = "sner",
  [alias_sym_string_content] = "string_content",
  [alias_sym_transliteration_content] = "transliteration_content",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__identifier] = sym__identifier,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_role] = anon_sym_role,
  [anon_sym_BUILD] = anon_sym_BUILD,
  [anon_sym_ADJUST] = anon_sym_ADJUST,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_my] = anon_sym_my,
  [anon_sym_extended] = anon_sym_extended,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_sub] = anon_sym_sub,
  [anon_sym_method] = anon_sym_method,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_state] = anon_sym_state,
  [anon_sym_our] = anon_sym_our,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_defer] = anon_sym_defer,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_elsif] = anon_sym_elsif,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_DOT_EQ] = anon_sym_DOT_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_x_EQ] = anon_sym_x_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_CARET_CARET] = anon_sym_CARET_CARET,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_GT_GT2] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_x] = anon_sym_x,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_BANG_TILDE] = anon_sym_BANG_TILDE,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_eq] = anon_sym_eq,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_equ] = anon_sym_equ,
  [anon_sym_eqr] = anon_sym_eqr,
  [anon_sym_ne] = anon_sym_ne,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_cmp] = anon_sym_cmp,
  [anon_sym_TILDE_TILDE] = anon_sym_TILDE_TILDE,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_lt] = anon_sym_lt,
  [anon_sym_le] = anon_sym_le,
  [anon_sym_ge] = anon_sym_ge,
  [anon_sym_gt] = anon_sym_gt,
  [anon_sym_isa] = anon_sym_isa,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_eval] = anon_sym_eval,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_field] = anon_sym_field,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_dynamically] = anon_sym_dynamically,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_map] = anon_sym_map,
  [anon_sym_grep] = anon_sym_grep,
  [anon_sym_sort] = anon_sym_sort,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_undef] = anon_sym_undef,
  [anon_sym_PERCENT2] = anon_sym_PERCENT,
  [anon_sym_DOLLAR_POUND] = anon_sym_DOLLAR_POUND,
  [aux_sym__var_indirob_autoquote_token1] = sym_varname,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_no] = anon_sym_no,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_foreach] = anon_sym_foreach,
  [anon_sym_last] = anon_sym_last,
  [anon_sym_next] = anon_sym_next,
  [anon_sym_redo] = anon_sym_redo,
  [anon_sym_BEGIN] = anon_sym_BEGIN,
  [anon_sym_INIT] = anon_sym_INIT,
  [anon_sym_CHECK] = anon_sym_CHECK,
  [anon_sym_UNITCHECK] = anon_sym_UNITCHECK,
  [anon_sym_END] = anon_sym_END,
  [anon_sym___FILE__] = anon_sym___FILE__,
  [anon_sym___LINE__] = anon_sym___LINE__,
  [anon_sym___PACKAGE__] = anon_sym___PACKAGE__,
  [anon_sym___SUB__] = anon_sym___SUB__,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_fork] = anon_sym_fork,
  [anon_sym_getppid] = anon_sym_getppid,
  [anon_sym_time] = anon_sym_time,
  [anon_sym_times] = anon_sym_times,
  [anon_sym_wait] = anon_sym_wait,
  [anon_sym_wantarray] = anon_sym_wantarray,
  [anon_sym_abs] = anon_sym_abs,
  [anon_sym_alarm] = anon_sym_alarm,
  [anon_sym_chop] = anon_sym_chop,
  [anon_sym_chdir] = anon_sym_chdir,
  [anon_sym_close] = anon_sym_close,
  [anon_sym_closedir] = anon_sym_closedir,
  [anon_sym_caller] = anon_sym_caller,
  [anon_sym_chomp] = anon_sym_chomp,
  [anon_sym_chr] = anon_sym_chr,
  [anon_sym_cos] = anon_sym_cos,
  [anon_sym_chroot] = anon_sym_chroot,
  [anon_sym_defined] = anon_sym_defined,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_dbmclose] = anon_sym_dbmclose,
  [anon_sym_exists] = anon_sym_exists,
  [anon_sym_exit] = anon_sym_exit,
  [anon_sym_eof] = anon_sym_eof,
  [anon_sym_exp] = anon_sym_exp,
  [anon_sym_each] = anon_sym_each,
  [anon_sym_fc] = anon_sym_fc,
  [anon_sym_fileno] = anon_sym_fileno,
  [anon_sym_gmtime] = anon_sym_gmtime,
  [anon_sym_getc] = anon_sym_getc,
  [anon_sym_getpgrp] = anon_sym_getpgrp,
  [anon_sym_getprotobyname] = anon_sym_getprotobyname,
  [anon_sym_getpwname] = anon_sym_getpwname,
  [anon_sym_getpwuid] = anon_sym_getpwuid,
  [anon_sym_getpeername] = anon_sym_getpeername,
  [anon_sym_getnetbyname] = anon_sym_getnetbyname,
  [anon_sym_getsockname] = anon_sym_getsockname,
  [anon_sym_getgrnam] = anon_sym_getgrnam,
  [anon_sym_getgrgid] = anon_sym_getgrgid,
  [anon_sym_hex] = anon_sym_hex,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_keys] = anon_sym_keys,
  [anon_sym_lc] = anon_sym_lc,
  [anon_sym_lcfirst] = anon_sym_lcfirst,
  [anon_sym_length] = anon_sym_length,
  [anon_sym_localtime] = anon_sym_localtime,
  [anon_sym_log] = anon_sym_log,
  [anon_sym_lock] = anon_sym_lock,
  [anon_sym_lstat] = anon_sym_lstat,
  [anon_sym_oct] = anon_sym_oct,
  [anon_sym_ord] = anon_sym_ord,
  [anon_sym_prototype] = anon_sym_prototype,
  [anon_sym_pop] = anon_sym_pop,
  [anon_sym_pos] = anon_sym_pos,
  [anon_sym_quotemeta] = anon_sym_quotemeta,
  [anon_sym_reset] = anon_sym_reset,
  [anon_sym_rand] = anon_sym_rand,
  [anon_sym_rmdir] = anon_sym_rmdir,
  [anon_sym_readdir] = anon_sym_readdir,
  [anon_sym_readline] = anon_sym_readline,
  [anon_sym_readpipe] = anon_sym_readpipe,
  [anon_sym_rewinddir] = anon_sym_rewinddir,
  [anon_sym_readlink] = anon_sym_readlink,
  [anon_sym_ref] = anon_sym_ref,
  [anon_sym_scalar] = anon_sym_scalar,
  [anon_sym_shift] = anon_sym_shift,
  [anon_sym_sin] = anon_sym_sin,
  [anon_sym_sleep] = anon_sym_sleep,
  [anon_sym_sqrt] = anon_sym_sqrt,
  [anon_sym_srand] = anon_sym_srand,
  [anon_sym_stat] = anon_sym_stat,
  [anon_sym_study] = anon_sym_study,
  [anon_sym_tell] = anon_sym_tell,
  [anon_sym_telldir] = anon_sym_telldir,
  [anon_sym_tied] = anon_sym_tied,
  [anon_sym_uc] = anon_sym_uc,
  [anon_sym_ucfirst] = anon_sym_ucfirst,
  [anon_sym_untie] = anon_sym_untie,
  [anon_sym_umask] = anon_sym_umask,
  [anon_sym_values] = anon_sym_values,
  [anon_sym_write] = anon_sym_write,
  [sym_comment] = sym_comment,
  [anon_sym___DATA__] = sym__ctrl_z_hack,
  [anon_sym___END__] = sym__ctrl_z_hack,
  [aux_sym___DATA___token1] = aux_sym___DATA___token1,
  [anon_sym_EOT] = sym__ctrl_z_hack,
  [anon_sym_q] = anon_sym_q,
  [anon_sym_qq] = anon_sym_qq,
  [anon_sym_DASH_GT2] = anon_sym_DASH_GT,
  [anon_sym_LBRACK2] = anon_sym_LBRACK,
  [anon_sym_LBRACE2] = anon_sym_LBRACE,
  [aux_sym__interpolation_fallbacks_token1] = aux_sym__interpolation_fallbacks_token1,
  [anon_sym_qw] = anon_sym_qw,
  [anon_sym_qx] = anon_sym_qx,
  [anon_sym_qr] = anon_sym_qr,
  [anon_sym_m] = anon_sym_m,
  [anon_sym_s] = anon_sym_s,
  [sym_quoted_regexp_modifiers] = sym_quoted_regexp_modifiers,
  [sym_match_regexp_modifiers] = sym_match_regexp_modifiers,
  [sym_substitution_regexp_modifiers] = sym_substitution_regexp_modifiers,
  [sym_transliteration_modifiers] = sym_transliteration_modifiers,
  [aux_sym__interpolated_transliteration_content_token1] = aux_sym__interpolated_transliteration_content_token1,
  [anon_sym_tr] = anon_sym_tr,
  [anon_sym_y] = anon_sym_y,
  [sym_version] = sym_version,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_unless] = anon_sym_unless,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_until] = anon_sym_until,
  [aux_sym__ident_special_token1] = aux_sym__ident_special_token1,
  [aux_sym__bareword_token1] = aux_sym__bareword_token1,
  [sym_number] = sym_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym__single_quote] = sym__single_quote,
  [sym__double_quote] = sym__single_quote,
  [sym__backtick_quote] = sym__single_quote,
  [sym__search_slash_quote] = sym__single_quote,
  [sym__no_search_slash_plz] = sym__no_search_slash_plz,
  [sym__PERLY_SEMICOLON] = sym__PERLY_SEMICOLON,
  [sym__PERLY_HEREDOC] = sym__PERLY_HEREDOC,
  [sym__ctrl_z_hack] = sym__ctrl_z_hack,
  [sym__quotelike_begin_quote] = sym__single_quote,
  [sym__quotelike_middle_close_quote] = sym__single_quote,
  [sym__quotelike_middle_skip] = sym__quotelike_middle_skip,
  [sym__quotelike_end_zw] = sym__quotelike_end_zw,
  [sym__quotelike_end_quote] = sym__single_quote,
  [sym__q_string_content] = sym__q_string_content,
  [sym__qq_string_content] = sym__qq_string_content,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_escaped_delimiter] = sym_escaped_delimiter,
  [sym__dollar_in_regexp] = sym__dollar_in_regexp,
  [sym_pod] = sym_pod,
  [sym__gobbled_content] = sym__gobbled_content,
  [sym__attribute_value_begin] = sym__attribute_value_begin,
  [sym_attribute_value] = sym_attribute_value,
  [sym_prototype] = sym_prototype,
  [sym__signature_start] = anon_sym_LPAREN,
  [sym__heredoc_delimiter] = sym__heredoc_delimiter,
  [sym__command_heredoc_delimiter] = sym__command_heredoc_delimiter,
  [sym__heredoc_start] = sym__heredoc_start,
  [sym__heredoc_middle] = sym__heredoc_middle,
  [sym_heredoc_end] = sym_heredoc_end,
  [sym__fat_comma_autoquoted] = sym__fat_comma_autoquoted,
  [sym__filetest] = sym__filetest,
  [sym__brace_autoquoted_token] = sym_varname,
  [sym__brace_end_zw] = sym__brace_end_zw,
  [sym__dollar_ident_zw] = sym__dollar_ident_zw,
  [sym__no_interp_whitespace_zw] = sym__no_interp_whitespace_zw,
  [sym__NONASSOC] = sym__NONASSOC,
  [sym__ERROR] = sym__ERROR,
  [sym_source_file] = sym_source_file,
  [sym__PERLY_BRACE_OPEN] = sym__PERLY_BRACE_OPEN,
  [sym_block] = sym_block,
  [sym__fullstmt] = sym__fullstmt,
  [sym_statement_label] = sym_statement_label,
  [sym__semicolon] = sym__semicolon,
  [sym__barestmt] = sym__barestmt,
  [sym_package_statement] = sym_package_statement,
  [sym_class_statement] = sym_class_statement,
  [sym_role_statement] = sym_role_statement,
  [sym_class_phaser_statement] = sym_class_phaser_statement,
  [sym_use_version_statement] = sym_use_version_statement,
  [sym_use_statement] = sym_use_statement,
  [sym_mandatory_parameter] = sym_mandatory_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym_named_parameter] = sym_named_parameter,
  [sym_slurpy_parameter] = sym_slurpy_parameter,
  [sym__signature_vars] = sym__signature_vars,
  [sym_signature] = sym_signature,
  [sym_subroutine_declaration_statement] = sym_subroutine_declaration_statement,
  [sym_method_declaration_statement] = sym_method_declaration_statement,
  [sym_phaser_statement] = sym_phaser_statement,
  [sym_conditional_statement] = sym_conditional_statement,
  [sym__loop_body] = sym__loop_body,
  [sym_loop_statement] = sym_loop_statement,
  [sym_cstyle_for_statement] = sym_cstyle_for_statement,
  [sym__for_initializer] = sym__for_initializer,
  [sym_for_statement] = sym_for_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_defer_statement] = sym_defer_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym__postfix_expressions] = sym__postfix_expressions,
  [sym_postfix_conditional_expression] = sym_postfix_conditional_expression,
  [sym_postfix_loop_expression] = sym_postfix_loop_expression,
  [sym_postfix_for_expression] = sym_postfix_for_expression,
  [sym_yadayada] = sym_yadayada,
  [sym__else] = sym__else,
  [sym_else] = sym_else,
  [sym_elsif] = sym_elsif,
  [sym__expr] = sym__expr,
  [sym_lowprec_logical_expression] = sym_lowprec_logical_expression,
  [sym__listexpr] = sym__listexpr,
  [sym__term_rightward] = sym__term_rightward,
  [sym_list_expression] = sym_list_expression,
  [sym__subscripted] = sym__subscripted,
  [sym_container_variable] = sym_container_variable,
  [sym_array_element_expression] = sym_array_element_expression,
  [sym__hash_key] = sym__hash_key,
  [sym_hash_element_expression] = sym_hash_element_expression,
  [sym_coderef_call_expression] = sym_coderef_call_expression,
  [sym_anonymous_slice_expression] = sym_anonymous_slice_expression,
  [sym_slice_container_variable] = sym_slice_container_variable,
  [sym_slice_expression] = sym_slice_expression,
  [sym_keyval_container_variable] = sym_keyval_container_variable,
  [sym_keyval_expression] = sym_keyval_expression,
  [sym__term] = sym__term,
  [sym_readline_expression] = sym_readline_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_equality_expression] = sym_equality_expression,
  [sym_relational_expression] = sym_relational_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_preinc_expression] = sym_preinc_expression,
  [sym_postinc_expression] = sym_postinc_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_refgen_expression] = sym_refgen_expression,
  [sym_anonymous_array_expression] = sym_anonymous_array_expression,
  [sym__tricky_list] = sym_list_expression,
  [sym_anonymous_hash_expression] = sym_anonymous_hash_expression,
  [sym_anonymous_subroutine_expression] = sym_anonymous_subroutine_expression,
  [sym_anonymous_method_expression] = sym_anonymous_method_expression,
  [sym_do_expression] = sym_do_expression,
  [sym_eval_expression] = sym_eval_expression,
  [sym_await_expression] = sym_await_expression,
  [sym__declared_vars] = sym__declared_vars,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym__decl_variable_list] = sym__decl_variable_list,
  [sym_localization_expression] = sym_localization_expression,
  [sym_stub_expression] = sym_stub_expression,
  [sym_scalar_deref_expression] = sym_scalar_deref_expression,
  [sym_array_deref_expression] = sym_array_deref_expression,
  [sym_hash_deref_expression] = sym_hash_deref_expression,
  [sym_amper_deref_expression] = sym_amper_deref_expression,
  [sym_glob_deref_expression] = sym_glob_deref_expression,
  [sym_require_expression] = sym_require_expression,
  [sym_func0op_call_expression] = sym_func0op_call_expression,
  [sym_func1op_call_expression] = sym_func1op_call_expression,
  [sym_map_grep_expression] = sym_map_grep_expression,
  [sym_sort_expression] = sym_sort_expression,
  [sym__label_arg] = sym__label_arg,
  [sym_loopex_expression] = sym_loopex_expression,
  [sym_goto_expression] = sym_goto_expression,
  [sym_return_expression] = sym_return_expression,
  [sym_undef_expression] = sym_undef_expression,
  [sym__listop] = sym__listop,
  [sym_indirect_object] = sym_indirect_object,
  [sym_function_call_expression] = sym_function_call_expression,
  [sym__tricky_indirob_hashref] = sym_anonymous_hash_expression,
  [sym_ambiguous_function_call_expression] = sym_ambiguous_function_call_expression,
  [sym_function] = sym_function,
  [sym_method_call_expression] = sym_method_call_expression,
  [sym_method] = sym_method,
  [sym__signature_varname] = sym__signature_varname,
  [sym_scalar] = sym_scalar,
  [sym__declare_scalar] = sym_scalar,
  [sym__signature_scalar] = sym_scalar,
  [sym_array] = sym_array,
  [sym__declare_array] = sym_array,
  [sym__signature_array] = sym_array,
  [sym_hash] = sym_hash,
  [sym__declare_hash] = sym_hash,
  [sym__signature_hash] = sym_hash,
  [sym_arraylen] = sym_arraylen,
  [sym_glob] = sym_glob,
  [sym__indirob] = sym__indirob,
  [sym_varname] = sym_varname,
  [sym__var_indirob_autoquote] = sym__var_indirob_autoquote,
  [sym__var_indirob] = sym__var_indirob,
  [sym_attrlist] = sym_attrlist,
  [sym_attribute] = sym_attribute,
  [sym_attribute_name] = sym_attribute_name,
  [sym___DATA__] = sym___DATA__,
  [sym__literal] = sym__literal,
  [sym__apostrophe] = sym__apostrophe,
  [sym__quotation_mark] = sym__quotation_mark,
  [sym__backtick] = sym__backtick,
  [sym__search_slash] = sym__search_slash,
  [sym__quotelike_begin] = sym__quotelike_begin,
  [sym__quotelike_middle_close] = sym__quotelike_middle_close,
  [sym__quotelike_end] = sym__quotelike_end,
  [sym__quotelike_middle] = sym__quotelike_middle,
  [sym_string_literal] = sym_string_literal,
  [sym_interpolated_string_literal] = sym_interpolated_string_literal,
  [sym__subscripted_interpolations] = sym__subscripted_interpolations,
  [sym__braced_scalar] = sym_scalar,
  [sym__braced_array] = sym_array,
  [sym__interp_arrow] = sym__interp_arrow,
  [sym__array_element_interpolation] = sym_array_element_expression,
  [sym__hash_element_interpolation] = sym_hash_element_expression,
  [sym__slice_expression_interpolation] = sym_slice_expression,
  [sym__interpolations] = sym__interpolations,
  [aux_sym__noninterpolated_string_content] = aux_sym__noninterpolated_string_content,
  [sym__interpolation_fallbacks] = sym__interpolation_fallbacks,
  [sym__nonvar_interpolation_fallbacks] = sym__nonvar_interpolation_fallbacks,
  [aux_sym__interpolated_string_content] = aux_sym__interpolated_string_content,
  [sym_quoted_word_list] = sym_quoted_word_list,
  [sym_command_string] = sym_command_string,
  [sym_quoted_regexp] = sym_quoted_regexp,
  [sym_match_regexp] = sym_match_regexp,
  [sym_substitution_regexp] = sym_substitution_regexp,
  [aux_sym__interpolated_regexp_content] = aux_sym__interpolated_regexp_content,
  [aux_sym__interpolated_transliteration_content] = aux_sym__interpolated_transliteration_content,
  [sym_transliteration_expression] = sym_transliteration_expression,
  [sym_heredoc_token] = sym_heredoc_token,
  [sym_command_heredoc_token] = sym_command_heredoc_token,
  [sym_heredoc_content] = sym_heredoc_content,
  [sym_package] = sym_package,
  [sym__version] = sym__version,
  [sym__conditionals] = sym__conditionals,
  [sym__loops] = sym__loops,
  [sym_autoquoted_bareword] = sym_autoquoted_bareword,
  [sym__brace_autoquoted] = sym__brace_autoquoted,
  [sym_identifier] = sym_identifier,
  [sym__ident_special] = sym__ident_special,
  [sym_bareword] = sym_bareword,
  [sym_primitive] = sym_primitive,
  [sym_boolean] = sym_boolean,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_signature_repeat1] = aux_sym_signature_repeat1,
  [aux_sym_subroutine_declaration_statement_repeat1] = aux_sym_subroutine_declaration_statement_repeat1,
  [aux_sym__for_initializer_repeat1] = aux_sym__for_initializer_repeat1,
  [aux_sym__term_rightward_repeat1] = aux_sym__term_rightward_repeat1,
  [aux_sym__decl_variable_list_repeat1] = aux_sym__decl_variable_list_repeat1,
  [aux_sym_attrlist_repeat1] = aux_sym_attrlist_repeat1,
  [aux_sym_heredoc_content_repeat1] = aux_sym_heredoc_content_repeat1,
  [alias_sym_block_statement] = alias_sym_block_statement,
  [alias_sym_data_section] = alias_sym_data_section,
  [alias_sym_filename] = alias_sym_filename,
  [alias_sym_label] = alias_sym_label,
  [anon_alias_sym_not_DASHinterpolated] = anon_alias_sym_not_DASHinterpolated,
  [alias_sym_regexp_content] = alias_sym_regexp_content,
  [alias_sym_replacement] = alias_sym_replacement,
  [anon_alias_sym_sner] = anon_alias_sym_sner,
  [alias_sym_string_content] = alias_sym_string_content,
  [alias_sym_transliteration_content] = alias_sym_transliteration_content,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_role] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BUILD] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ADJUST] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_my] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extended] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_method] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_state] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_our] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elsif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_x_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_x] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_equ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eqr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ne] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cmp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_le] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_isa] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eval] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_field] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dynamically] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_grep] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_undef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_POUND] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__var_indirob_autoquote_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_no] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_last] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_next] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_redo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BEGIN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INIT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CHECK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNITCHECK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_END] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___FILE__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___LINE__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___PACKAGE__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___SUB__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fork] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getppid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_time] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_times] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_wait] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_wantarray] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alarm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chdir] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_close] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_closedir] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_caller] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chomp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cos] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chroot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dbmclose] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fileno] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gmtime] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getpgrp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getprotobyname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getpwname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getpwuid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getpeername] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getnetbyname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getsockname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getgrnam] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getgrgid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hex] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keys] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lcfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_length] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_localtime] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lock] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lstat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_oct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ord] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_prototype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pos] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_quotemeta] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rmdir] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readdir] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readpipe] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rewinddir] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readlink] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_scalar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shift] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sleep] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sqrt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_srand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_study] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tell] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_telldir] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tied] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ucfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_untie] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_umask] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_values] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_write] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym___DATA__] = {
    .visible = true,
    .named = true,
  },
  [anon_sym___END__] = {
    .visible = true,
    .named = true,
  },
  [aux_sym___DATA___token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_EOT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_q] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_qq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__interpolation_fallbacks_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_qw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_qx] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_qr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_m] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_s] = {
    .visible = true,
    .named = false,
  },
  [sym_quoted_regexp_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_match_regexp_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution_regexp_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_transliteration_modifiers] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__interpolated_transliteration_content_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_tr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_y] = {
    .visible = true,
    .named = false,
  },
  [sym_version] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unless] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__ident_special_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bareword_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym__single_quote] = {
    .visible = true,
    .named = false,
  },
  [sym__double_quote] = {
    .visible = true,
    .named = false,
  },
  [sym__backtick_quote] = {
    .visible = true,
    .named = false,
  },
  [sym__search_slash_quote] = {
    .visible = true,
    .named = false,
  },
  [sym__no_search_slash_plz] = {
    .visible = false,
    .named = true,
  },
  [sym__PERLY_SEMICOLON] = {
    .visible = false,
    .named = true,
  },
  [sym__PERLY_HEREDOC] = {
    .visible = false,
    .named = true,
  },
  [sym__ctrl_z_hack] = {
    .visible = true,
    .named = true,
  },
  [sym__quotelike_begin_quote] = {
    .visible = true,
    .named = false,
  },
  [sym__quotelike_middle_close_quote] = {
    .visible = true,
    .named = false,
  },
  [sym__quotelike_middle_skip] = {
    .visible = false,
    .named = true,
  },
  [sym__quotelike_end_zw] = {
    .visible = false,
    .named = true,
  },
  [sym__quotelike_end_quote] = {
    .visible = true,
    .named = false,
  },
  [sym__q_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__qq_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_escaped_delimiter] = {
    .visible = true,
    .named = true,
  },
  [sym__dollar_in_regexp] = {
    .visible = false,
    .named = true,
  },
  [sym_pod] = {
    .visible = true,
    .named = true,
  },
  [sym__gobbled_content] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute_value_begin] = {
    .visible = false,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_prototype] = {
    .visible = true,
    .named = true,
  },
  [sym__signature_start] = {
    .visible = true,
    .named = false,
  },
  [sym__heredoc_delimiter] = {
    .visible = false,
    .named = true,
  },
  [sym__command_heredoc_delimiter] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_start] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_middle] = {
    .visible = false,
    .named = true,
  },
  [sym_heredoc_end] = {
    .visible = true,
    .named = true,
  },
  [sym__fat_comma_autoquoted] = {
    .visible = false,
    .named = true,
  },
  [sym__filetest] = {
    .visible = true,
    .named = false,
  },
  [sym__brace_autoquoted_token] = {
    .visible = true,
    .named = true,
  },
  [sym__brace_end_zw] = {
    .visible = false,
    .named = true,
  },
  [sym__dollar_ident_zw] = {
    .visible = false,
    .named = true,
  },
  [sym__no_interp_whitespace_zw] = {
    .visible = false,
    .named = true,
  },
  [sym__NONASSOC] = {
    .visible = false,
    .named = true,
  },
  [sym__ERROR] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__PERLY_BRACE_OPEN] = {
    .visible = false,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__fullstmt] = {
    .visible = false,
    .named = true,
  },
  [sym_statement_label] = {
    .visible = true,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__barestmt] = {
    .visible = false,
    .named = true,
  },
  [sym_package_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_role_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_phaser_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_use_version_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_use_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_mandatory_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_named_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_slurpy_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__signature_vars] = {
    .visible = false,
    .named = true,
  },
  [sym_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_subroutine_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_phaser_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__loop_body] = {
    .visible = false,
    .named = true,
  },
  [sym_loop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_cstyle_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_initializer] = {
    .visible = false,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_defer_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__postfix_expressions] = {
    .visible = false,
    .named = true,
  },
  [sym_postfix_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_loop_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_for_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_yadayada] = {
    .visible = true,
    .named = true,
  },
  [sym__else] = {
    .visible = false,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_elsif] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
  },
  [sym_lowprec_logical_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__listexpr] = {
    .visible = false,
    .named = true,
  },
  [sym__term_rightward] = {
    .visible = false,
    .named = true,
  },
  [sym_list_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__subscripted] = {
    .visible = false,
    .named = true,
  },
  [sym_container_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_array_element_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__hash_key] = {
    .visible = false,
    .named = true,
  },
  [sym_hash_element_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_coderef_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_slice_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_container_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_keyval_container_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_keyval_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__term] = {
    .visible = false,
    .named = true,
  },
  [sym_readline_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_relational_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preinc_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postinc_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_refgen_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__tricky_list] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_hash_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_subroutine_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_method_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_do_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_eval_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__declared_vars] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__decl_variable_list] = {
    .visible = false,
    .named = true,
  },
  [sym_localization_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_stub_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_scalar_deref_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_deref_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_deref_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_amper_deref_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_glob_deref_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_require_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_func0op_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_func1op_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_map_grep_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sort_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__label_arg] = {
    .visible = false,
    .named = true,
  },
  [sym_loopex_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_return_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_undef_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__listop] = {
    .visible = false,
    .named = true,
  },
  [sym_indirect_object] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__tricky_indirob_hashref] = {
    .visible = true,
    .named = true,
  },
  [sym_ambiguous_function_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_method_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method] = {
    .visible = true,
    .named = true,
  },
  [sym__signature_varname] = {
    .visible = false,
    .named = true,
  },
  [sym_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym__declare_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym__signature_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym__declare_array] = {
    .visible = true,
    .named = true,
  },
  [sym__signature_array] = {
    .visible = true,
    .named = true,
  },
  [sym_hash] = {
    .visible = true,
    .named = true,
  },
  [sym__declare_hash] = {
    .visible = true,
    .named = true,
  },
  [sym__signature_hash] = {
    .visible = true,
    .named = true,
  },
  [sym_arraylen] = {
    .visible = true,
    .named = true,
  },
  [sym_glob] = {
    .visible = true,
    .named = true,
  },
  [sym__indirob] = {
    .visible = true,
    .named = true,
  },
  [sym_varname] = {
    .visible = true,
    .named = true,
  },
  [sym__var_indirob_autoquote] = {
    .visible = false,
    .named = true,
  },
  [sym__var_indirob] = {
    .visible = false,
    .named = true,
  },
  [sym_attrlist] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym___DATA__] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym__apostrophe] = {
    .visible = false,
    .named = true,
  },
  [sym__quotation_mark] = {
    .visible = false,
    .named = true,
  },
  [sym__backtick] = {
    .visible = false,
    .named = true,
  },
  [sym__search_slash] = {
    .visible = false,
    .named = true,
  },
  [sym__quotelike_begin] = {
    .visible = false,
    .named = true,
  },
  [sym__quotelike_middle_close] = {
    .visible = false,
    .named = true,
  },
  [sym__quotelike_end] = {
    .visible = false,
    .named = true,
  },
  [sym__quotelike_middle] = {
    .visible = false,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolated_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__subscripted_interpolations] = {
    .visible = false,
    .named = true,
  },
  [sym__braced_scalar] = {
    .visible = true,
    .named = true,
  },
  [sym__braced_array] = {
    .visible = true,
    .named = true,
  },
  [sym__interp_arrow] = {
    .visible = false,
    .named = true,
  },
  [sym__array_element_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__hash_element_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__slice_expression_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__interpolations] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__noninterpolated_string_content] = {
    .visible = false,
    .named = false,
  },
  [sym__interpolation_fallbacks] = {
    .visible = false,
    .named = true,
  },
  [sym__nonvar_interpolation_fallbacks] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__interpolated_string_content] = {
    .visible = false,
    .named = false,
  },
  [sym_quoted_word_list] = {
    .visible = true,
    .named = true,
  },
  [sym_command_string] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_regexp] = {
    .visible = true,
    .named = true,
  },
  [sym_match_regexp] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution_regexp] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__interpolated_regexp_content] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__interpolated_transliteration_content] = {
    .visible = false,
    .named = false,
  },
  [sym_transliteration_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_token] = {
    .visible = true,
    .named = true,
  },
  [sym_command_heredoc_token] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_content] = {
    .visible = true,
    .named = true,
  },
  [sym_package] = {
    .visible = true,
    .named = true,
  },
  [sym__version] = {
    .visible = false,
    .named = true,
  },
  [sym__conditionals] = {
    .visible = false,
    .named = true,
  },
  [sym__loops] = {
    .visible = false,
    .named = true,
  },
  [sym_autoquoted_bareword] = {
    .visible = true,
    .named = true,
  },
  [sym__brace_autoquoted] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__ident_special] = {
    .visible = false,
    .named = true,
  },
  [sym_bareword] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_signature_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subroutine_declaration_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__for_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__term_rightward_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__decl_variable_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attrlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_heredoc_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_block_statement] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_data_section] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_filename] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_label] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_not_DASHinterpolated] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_regexp_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_replacement] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_sner] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_transliteration_content] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_arguments = 2,
  field_array = 3,
  field_arrayref = 4,
  field_attributes = 5,
  field_block = 6,
  field_body = 7,
  field_callback = 8,
  field_catch_block = 9,
  field_catch_expr = 10,
  field_condition = 11,
  field_consequent = 12,
  field_content = 13,
  field_continue = 14,
  field_default = 15,
  field_finally_block = 16,
  field_function = 17,
  field_hash = 18,
  field_hashref = 19,
  field_index = 20,
  field_initialiser = 21,
  field_invocant = 22,
  field_iterator = 23,
  field_key = 24,
  field_label = 25,
  field_left = 26,
  field_lexical = 27,
  field_list = 28,
  field_loopex = 29,
  field_method = 30,
  field_modifiers = 31,
  field_module = 32,
  field_name = 33,
  field_operand = 34,
  field_operator = 35,
  field_phase = 36,
  field_right = 37,
  field_statement = 38,
  field_try_block = 39,
  field_value = 40,
  field_variable = 41,
  field_variables = 42,
  field_version = 43,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_array] = "array",
  [field_arrayref] = "arrayref",
  [field_attributes] = "attributes",
  [field_block] = "block",
  [field_body] = "body",
  [field_callback] = "callback",
  [field_catch_block] = "catch_block",
  [field_catch_expr] = "catch_expr",
  [field_condition] = "condition",
  [field_consequent] = "consequent",
  [field_content] = "content",
  [field_continue] = "continue",
  [field_default] = "default",
  [field_finally_block] = "finally_block",
  [field_function] = "function",
  [field_hash] = "hash",
  [field_hashref] = "hashref",
  [field_index] = "index",
  [field_initialiser] = "initialiser",
  [field_invocant] = "invocant",
  [field_iterator] = "iterator",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_lexical] = "lexical",
  [field_list] = "list",
  [field_loopex] = "loopex",
  [field_method] = "method",
  [field_modifiers] = "modifiers",
  [field_module] = "module",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_phase] = "phase",
  [field_right] = "right",
  [field_statement] = "statement",
  [field_try_block] = "try_block",
  [field_value] = "value",
  [field_variable] = "variable",
  [field_variables] = "variables",
  [field_version] = "version",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 2},
  [6] = {.index = 4, .length = 2},
  [7] = {.index = 6, .length = 4},
  [8] = {.index = 10, .length = 1},
  [10] = {.index = 11, .length = 1},
  [11] = {.index = 12, .length = 1},
  [12] = {.index = 13, .length = 1},
  [13] = {.index = 14, .length = 1},
  [14] = {.index = 15, .length = 1},
  [15] = {.index = 16, .length = 2},
  [16] = {.index = 18, .length = 1},
  [17] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 1},
  [21] = {.index = 22, .length = 1},
  [22] = {.index = 23, .length = 2},
  [23] = {.index = 0, .length = 1},
  [24] = {.index = 25, .length = 2},
  [25] = {.index = 27, .length = 1},
  [29] = {.index = 28, .length = 1},
  [30] = {.index = 29, .length = 1},
  [31] = {.index = 30, .length = 2},
  [32] = {.index = 32, .length = 2},
  [33] = {.index = 34, .length = 2},
  [34] = {.index = 36, .length = 1},
  [35] = {.index = 37, .length = 1},
  [37] = {.index = 38, .length = 1},
  [38] = {.index = 39, .length = 3},
  [39] = {.index = 42, .length = 1},
  [40] = {.index = 43, .length = 1},
  [42] = {.index = 44, .length = 2},
  [43] = {.index = 46, .length = 2},
  [44] = {.index = 48, .length = 1},
  [45] = {.index = 49, .length = 1},
  [46] = {.index = 48, .length = 1},
  [47] = {.index = 50, .length = 2},
  [49] = {.index = 52, .length = 2},
  [50] = {.index = 54, .length = 2},
  [51] = {.index = 56, .length = 3},
  [52] = {.index = 59, .length = 2},
  [53] = {.index = 61, .length = 2},
  [54] = {.index = 63, .length = 1},
  [55] = {.index = 64, .length = 2},
  [56] = {.index = 66, .length = 2},
  [57] = {.index = 68, .length = 2},
  [58] = {.index = 70, .length = 2},
  [59] = {.index = 72, .length = 2},
  [60] = {.index = 74, .length = 2},
  [61] = {.index = 76, .length = 2},
  [62] = {.index = 78, .length = 1},
  [63] = {.index = 79, .length = 1},
  [64] = {.index = 78, .length = 1},
  [65] = {.index = 80, .length = 2},
  [66] = {.index = 82, .length = 2},
  [67] = {.index = 84, .length = 1},
  [68] = {.index = 85, .length = 1},
  [69] = {.index = 86, .length = 1},
  [70] = {.index = 87, .length = 2},
  [71] = {.index = 89, .length = 2},
  [72] = {.index = 91, .length = 1},
  [73] = {.index = 92, .length = 1},
  [74] = {.index = 93, .length = 2},
  [75] = {.index = 95, .length = 3},
  [76] = {.index = 98, .length = 2},
  [77] = {.index = 100, .length = 1},
  [78] = {.index = 101, .length = 2},
  [79] = {.index = 89, .length = 2},
  [80] = {.index = 87, .length = 2},
  [81] = {.index = 92, .length = 1},
  [82] = {.index = 91, .length = 1},
  [83] = {.index = 103, .length = 2},
  [84] = {.index = 105, .length = 1},
  [86] = {.index = 106, .length = 3},
  [87] = {.index = 109, .length = 3},
  [88] = {.index = 112, .length = 2},
  [89] = {.index = 114, .length = 2},
  [90] = {.index = 116, .length = 3},
  [91] = {.index = 119, .length = 1},
  [92] = {.index = 120, .length = 3},
  [93] = {.index = 123, .length = 1},
  [94] = {.index = 124, .length = 3},
  [95] = {.index = 127, .length = 2},
  [96] = {.index = 129, .length = 3},
  [97] = {.index = 132, .length = 2},
  [98] = {.index = 38, .length = 1},
  [99] = {.index = 82, .length = 2},
  [100] = {.index = 134, .length = 1},
  [101] = {.index = 135, .length = 1},
  [102] = {.index = 136, .length = 1},
  [103] = {.index = 137, .length = 3},
  [104] = {.index = 140, .length = 2},
  [105] = {.index = 142, .length = 2},
  [106] = {.index = 144, .length = 3},
  [107] = {.index = 147, .length = 1},
  [108] = {.index = 148, .length = 2},
  [109] = {.index = 150, .length = 2},
  [110] = {.index = 152, .length = 3},
  [111] = {.index = 155, .length = 1},
  [112] = {.index = 156, .length = 3},
  [113] = {.index = 159, .length = 4},
  [114] = {.index = 163, .length = 3},
  [115] = {.index = 166, .length = 3},
  [116] = {.index = 169, .length = 3},
  [117] = {.index = 172, .length = 2},
  [118] = {.index = 174, .length = 4},
  [119] = {.index = 178, .length = 2},
  [120] = {.index = 180, .length = 5},
  [121] = {.index = 185, .length = 2},
  [122] = {.index = 187, .length = 3},
  [123] = {.index = 82, .length = 2},
  [124] = {.index = 187, .length = 3},
  [125] = {.index = 82, .length = 2},
  [126] = {.index = 190, .length = 4},
  [127] = {.index = 194, .length = 1},
  [128] = {.index = 195, .length = 1},
  [129] = {.index = 196, .length = 3},
  [130] = {.index = 199, .length = 2},
  [131] = {.index = 201, .length = 2},
  [132] = {.index = 203, .length = 2},
  [133] = {.index = 205, .length = 3},
  [134] = {.index = 208, .length = 2},
  [135] = {.index = 210, .length = 4},
  [136] = {.index = 214, .length = 3},
  [137] = {.index = 217, .length = 4},
  [138] = {.index = 221, .length = 3},
  [139] = {.index = 224, .length = 2},
  [140] = {.index = 226, .length = 3},
  [141] = {.index = 229, .length = 3},
  [142] = {.index = 232, .length = 3},
  [143] = {.index = 235, .length = 2},
  [144] = {.index = 237, .length = 3},
  [145] = {.index = 237, .length = 3},
  [146] = {.index = 240, .length = 3},
  [147] = {.index = 243, .length = 3},
  [148] = {.index = 246, .length = 4},
  [149] = {.index = 250, .length = 4},
  [150] = {.index = 254, .length = 4},
  [151] = {.index = 258, .length = 4},
  [152] = {.index = 262, .length = 4},
  [153] = {.index = 266, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_function, 0},
  [1] =
    {field_loopex, 0},
  [2] =
    {field_array, 0, .inherited = true},
    {field_index, 0, .inherited = true},
  [4] =
    {field_hash, 0, .inherited = true},
    {field_key, 0, .inherited = true},
  [6] =
    {field_array, 0, .inherited = true},
    {field_arrayref, 0, .inherited = true},
    {field_hash, 0, .inherited = true},
    {field_hashref, 0, .inherited = true},
  [10] =
    {field_phase, 0},
  [11] =
    {field_variable, 1},
  [12] =
    {field_variables, 1},
  [13] =
    {field_body, 1},
  [14] =
    {field_try_block, 1},
  [15] =
    {field_block, 1},
  [16] =
    {field_operator, 0},
    {field_operator, 1},
  [18] =
    {field_modifiers, 1},
  [19] =
    {field_operand, 1},
    {field_operator, 0},
  [21] =
    {field_list, 1},
  [22] =
    {field_variable, 0},
  [23] =
    {field_operand, 0},
    {field_operator, 1},
  [25] =
    {field_arguments, 1},
    {field_function, 0},
  [27] =
    {field_name, 1},
  [28] =
    {field_name, 0},
  [29] =
    {field_body, 2},
  [30] =
    {field_body, 2},
    {field_name, 1},
  [32] =
    {field_operator, 0},
    {field_operator, 2},
  [34] =
    {field_callback, 1},
    {field_list, 2},
  [36] =
    {field_module, 1},
  [37] =
    {field_version, 1},
  [38] =
    {field_operator, 0},
  [39] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [42] =
    {field_list, 2},
  [43] =
    {field_condition, 2},
  [44] =
    {field_invocant, 0},
    {field_method, 2},
  [46] =
    {field_arguments, 2},
    {field_function, 0},
  [48] =
    {field_content, 1},
  [49] =
    {field_modifiers, 2},
  [50] =
    {field_label, 0},
    {field_statement, 2},
  [52] =
    {field_name, 1},
    {field_version, 2},
  [54] =
    {field_attributes, 2},
    {field_phase, 0},
  [56] =
    {field_body, 3},
    {field_lexical, 0},
    {field_name, 2},
  [59] =
    {field_attributes, 3},
    {field_variable, 1},
  [61] =
    {field_attributes, 3},
    {field_variables, 1},
  [63] =
    {field_body, 3},
  [64] =
    {field_attributes, 2},
    {field_body, 3},
  [66] =
    {field_body, 3},
    {field_name, 1},
  [68] =
    {field_catch_block, 3},
    {field_try_block, 1},
  [70] =
    {field_finally_block, 3},
    {field_try_block, 1},
  [72] =
    {field_callback, 1},
    {field_list, 3},
  [74] =
    {field_module, 1},
    {field_version, 2},
  [76] =
    {field_variables, 1},
    {field_variables, 2},
  [78] =
    {field_content, 2},
  [79] =
    {field_modifiers, 3},
  [80] =
    {field_modifiers, 3},
    {field_operator, 0},
  [82] =
    {field_content, 2},
    {field_operator, 0},
  [84] =
    {field_key, 2},
  [85] =
    {field_arguments, 2},
  [86] =
    {field_index, 2},
  [87] =
    {field_hash, 0},
    {field_key, 2},
  [89] =
    {field_array, 0},
    {field_index, 2},
  [91] =
    {field_hash, 0},
  [92] =
    {field_array, 0},
  [93] =
    {field_invocant, 0},
    {field_method, 3},
  [95] =
    {field_arguments, 1},
    {field_arguments, 3},
    {field_function, 0},
  [98] =
    {field_content, 1},
    {field_modifiers, 3},
  [100] =
    {field_list, 0},
  [101] =
    {field_body, 3},
    {field_name, 2},
  [103] =
    {field_attributes, 3},
    {field_name, 1},
  [105] =
    {field_default, 2},
  [106] =
    {field_body, 4},
    {field_lexical, 0},
    {field_name, 2},
  [109] =
    {field_body, 4},
    {field_lexical, 0},
    {field_name, 3},
  [112] =
    {field_attributes, 2},
    {field_body, 4},
  [114] =
    {field_body, 4},
    {field_name, 1},
  [116] =
    {field_attributes, 3},
    {field_body, 4},
    {field_name, 1},
  [119] =
    {field_list, 3},
  [120] =
    {field_variables, 1},
    {field_variables, 2},
    {field_variables, 3},
  [123] =
    {field_block, 0},
  [124] =
    {field_block, 4, .inherited = true},
    {field_continue, 4, .inherited = true},
    {field_list, 2},
  [127] =
    {field_content, 2},
    {field_modifiers, 4},
  [129] =
    {field_content, 2},
    {field_modifiers, 4},
    {field_operator, 0},
  [132] =
    {field_modifiers, 4},
    {field_operator, 0},
  [134] =
    {field_key, 3},
  [135] =
    {field_arguments, 3},
  [136] =
    {field_index, 3},
  [137] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequent, 2},
  [140] =
    {field_arguments, 3},
    {field_function, 0},
  [142] =
    {field_block, 4},
    {field_condition, 2},
  [144] =
    {field_block, 4, .inherited = true},
    {field_condition, 2},
    {field_continue, 4, .inherited = true},
  [147] =
    {field_body, 4},
  [148] =
    {field_attributes, 3},
    {field_body, 4},
  [150] =
    {field_body, 4},
    {field_name, 2},
  [152] =
    {field_attributes, 4},
    {field_name, 1},
    {field_version, 2},
  [155] =
    {field_default, 3},
  [156] =
    {field_body, 5},
    {field_lexical, 0},
    {field_name, 2},
  [159] =
    {field_attributes, 4},
    {field_body, 5},
    {field_lexical, 0},
    {field_name, 2},
  [163] =
    {field_body, 5},
    {field_lexical, 0},
    {field_name, 3},
  [166] =
    {field_attributes, 3},
    {field_body, 5},
    {field_name, 1},
  [169] =
    {field_catch_block, 3},
    {field_finally_block, 5},
    {field_try_block, 1},
  [172] =
    {field_callback, 3},
    {field_list, 4},
  [174] =
    {field_variables, 1},
    {field_variables, 2},
    {field_variables, 3},
    {field_variables, 4},
  [178] =
    {field_block, 5, .inherited = true},
    {field_continue, 5, .inherited = true},
  [180] =
    {field_block, 5, .inherited = true},
    {field_continue, 5, .inherited = true},
    {field_list, 3},
    {field_variable, 1, .inherited = true},
    {field_variables, 1, .inherited = true},
  [185] =
    {field_modifiers, 5},
    {field_operator, 0},
  [187] =
    {field_content, 2},
    {field_modifiers, 5},
    {field_operator, 0},
  [190] =
    {field_left, 0},
    {field_operator, 1},
    {field_operator, 3},
    {field_right, 2},
  [194] =
    {field_hashref, 0},
  [195] =
    {field_arrayref, 0},
  [196] =
    {field_arguments, 4},
    {field_invocant, 0},
    {field_method, 2},
  [199] =
    {field_arguments, 4},
    {field_function, 0},
  [201] =
    {field_attributes, 3},
    {field_body, 5},
  [203] =
    {field_body, 5},
    {field_name, 2},
  [205] =
    {field_attributes, 4},
    {field_body, 5},
    {field_name, 2},
  [208] =
    {field_name, 0},
    {field_value, 3},
  [210] =
    {field_attributes, 4},
    {field_body, 6},
    {field_lexical, 0},
    {field_name, 2},
  [214] =
    {field_body, 6},
    {field_lexical, 0},
    {field_name, 3},
  [217] =
    {field_attributes, 5},
    {field_body, 6},
    {field_lexical, 0},
    {field_name, 3},
  [221] =
    {field_catch_block, 6},
    {field_catch_expr, 4},
    {field_try_block, 1},
  [224] =
    {field_callback, 3},
    {field_list, 5},
  [226] =
    {field_block, 6, .inherited = true},
    {field_continue, 6, .inherited = true},
    {field_iterator, 4},
  [229] =
    {field_block, 6, .inherited = true},
    {field_condition, 3},
    {field_continue, 6, .inherited = true},
  [232] =
    {field_block, 6, .inherited = true},
    {field_continue, 6, .inherited = true},
    {field_initialiser, 2},
  [235] =
    {field_block, 0},
    {field_continue, 2},
  [237] =
    {field_content, 2},
    {field_modifiers, 6},
    {field_operator, 0},
  [240] =
    {field_arguments, 5},
    {field_invocant, 0},
    {field_method, 3},
  [243] =
    {field_attributes, 4},
    {field_body, 6},
    {field_name, 2},
  [246] =
    {field_attributes, 5},
    {field_body, 7},
    {field_lexical, 0},
    {field_name, 3},
  [250] =
    {field_block, 7, .inherited = true},
    {field_condition, 3},
    {field_continue, 7, .inherited = true},
    {field_iterator, 5},
  [254] =
    {field_block, 7, .inherited = true},
    {field_continue, 7, .inherited = true},
    {field_initialiser, 2},
    {field_iterator, 5},
  [258] =
    {field_block, 7, .inherited = true},
    {field_condition, 4},
    {field_continue, 7, .inherited = true},
    {field_initialiser, 2},
  [262] =
    {field_catch_block, 6},
    {field_catch_expr, 4},
    {field_finally_block, 8},
    {field_try_block, 1},
  [266] =
    {field_block, 8, .inherited = true},
    {field_condition, 4},
    {field_continue, 8, .inherited = true},
    {field_initialiser, 2},
    {field_iterator, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [0] = alias_sym_block_statement,
  },
  [4] = {
    [0] = anon_alias_sym_not_DASHinterpolated,
  },
  [9] = {
    [0] = sym_varname,
  },
  [18] = {
    [1] = alias_sym_filename,
  },
  [20] = {
    [0] = alias_sym_label,
  },
  [23] = {
    [1] = sym_indirect_object,
  },
  [26] = {
    [0] = sym_scalar,
  },
  [27] = {
    [0] = sym_array,
  },
  [28] = {
    [0] = sym_hash,
  },
  [36] = {
    [2] = alias_sym_data_section,
  },
  [41] = {
    [0] = sym_autoquoted_bareword,
  },
  [44] = {
    [1] = alias_sym_string_content,
  },
  [46] = {
    [1] = alias_sym_regexp_content,
  },
  [48] = {
    [1] = anon_alias_sym_sner,
  },
  [62] = {
    [2] = alias_sym_string_content,
  },
  [64] = {
    [2] = alias_sym_regexp_content,
  },
  [66] = {
    [2] = alias_sym_regexp_content,
  },
  [76] = {
    [1] = alias_sym_regexp_content,
  },
  [79] = {
    [0] = sym_container_variable,
  },
  [80] = {
    [0] = sym_container_variable,
  },
  [81] = {
    [0] = sym_slice_container_variable,
  },
  [82] = {
    [0] = sym_slice_container_variable,
  },
  [84] = {
    [0] = sym_scalar,
  },
  [85] = {
    [1] = sym_varname,
  },
  [95] = {
    [2] = alias_sym_regexp_content,
  },
  [96] = {
    [2] = alias_sym_regexp_content,
  },
  [98] = {
    [3] = alias_sym_replacement,
  },
  [99] = {
    [2] = alias_sym_transliteration_content,
  },
  [121] = {
    [3] = alias_sym_replacement,
  },
  [122] = {
    [2] = alias_sym_regexp_content,
  },
  [123] = {
    [2] = alias_sym_regexp_content,
    [4] = alias_sym_replacement,
  },
  [124] = {
    [2] = alias_sym_transliteration_content,
  },
  [125] = {
    [2] = alias_sym_transliteration_content,
    [4] = alias_sym_replacement,
  },
  [144] = {
    [2] = alias_sym_regexp_content,
    [4] = alias_sym_replacement,
  },
  [145] = {
    [2] = alias_sym_transliteration_content,
    [4] = alias_sym_replacement,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_block, 3,
    sym_block,
    alias_sym_block_statement,
    sym_indirect_object,
  sym__term, 2,
    sym__term,
    alias_sym_filename,
  sym_scalar, 2,
    sym_scalar,
    sym_container_variable,
  sym_array, 2,
    sym_array,
    sym_slice_container_variable,
  sym__indirob, 2,
    sym__indirob,
    sym_varname,
  aux_sym__noninterpolated_string_content, 5,
    aux_sym__noninterpolated_string_content,
    alias_sym_regexp_content,
    alias_sym_replacement,
    alias_sym_string_content,
    alias_sym_transliteration_content,
  aux_sym__interpolated_string_content, 3,
    aux_sym__interpolated_string_content,
    alias_sym_replacement,
    alias_sym_string_content,
  aux_sym__interpolated_regexp_content, 2,
    aux_sym__interpolated_regexp_content,
    alias_sym_regexp_content,
  aux_sym__interpolated_transliteration_content, 3,
    aux_sym__interpolated_transliteration_content,
    alias_sym_replacement,
    alias_sym_transliteration_content,
  sym_identifier, 2,
    sym_identifier,
    alias_sym_label,
  sym__ident_special, 2,
    sym__ident_special,
    sym_varname,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 2,
  [9] = 3,
  [10] = 2,
  [11] = 7,
  [12] = 6,
  [13] = 4,
  [14] = 5,
  [15] = 3,
  [16] = 16,
  [17] = 6,
  [18] = 4,
  [19] = 7,
  [20] = 5,
  [21] = 21,
  [22] = 21,
  [23] = 21,
  [24] = 21,
  [25] = 21,
  [26] = 21,
  [27] = 21,
  [28] = 21,
  [29] = 21,
  [30] = 21,
  [31] = 21,
  [32] = 21,
  [33] = 21,
  [34] = 21,
  [35] = 21,
  [36] = 21,
  [37] = 21,
  [38] = 21,
  [39] = 21,
  [40] = 40,
  [41] = 21,
  [42] = 2,
  [43] = 2,
  [44] = 2,
  [45] = 45,
  [46] = 46,
  [47] = 46,
  [48] = 46,
  [49] = 46,
  [50] = 3,
  [51] = 46,
  [52] = 45,
  [53] = 46,
  [54] = 46,
  [55] = 46,
  [56] = 3,
  [57] = 46,
  [58] = 45,
  [59] = 45,
  [60] = 45,
  [61] = 46,
  [62] = 46,
  [63] = 45,
  [64] = 46,
  [65] = 46,
  [66] = 2,
  [67] = 46,
  [68] = 3,
  [69] = 69,
  [70] = 7,
  [71] = 6,
  [72] = 72,
  [73] = 4,
  [74] = 69,
  [75] = 72,
  [76] = 72,
  [77] = 4,
  [78] = 69,
  [79] = 72,
  [80] = 5,
  [81] = 69,
  [82] = 7,
  [83] = 72,
  [84] = 5,
  [85] = 69,
  [86] = 72,
  [87] = 6,
  [88] = 69,
  [89] = 72,
  [90] = 72,
  [91] = 69,
  [92] = 69,
  [93] = 72,
  [94] = 69,
  [95] = 69,
  [96] = 72,
  [97] = 69,
  [98] = 72,
  [99] = 69,
  [100] = 69,
  [101] = 69,
  [102] = 40,
  [103] = 69,
  [104] = 7,
  [105] = 69,
  [106] = 72,
  [107] = 69,
  [108] = 4,
  [109] = 69,
  [110] = 69,
  [111] = 69,
  [112] = 69,
  [113] = 69,
  [114] = 69,
  [115] = 69,
  [116] = 69,
  [117] = 69,
  [118] = 69,
  [119] = 69,
  [120] = 69,
  [121] = 69,
  [122] = 69,
  [123] = 69,
  [124] = 6,
  [125] = 3,
  [126] = 5,
  [127] = 72,
  [128] = 69,
  [129] = 72,
  [130] = 7,
  [131] = 5,
  [132] = 6,
  [133] = 4,
  [134] = 134,
  [135] = 134,
  [136] = 5,
  [137] = 5,
  [138] = 138,
  [139] = 138,
  [140] = 5,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 144,
  [152] = 152,
  [153] = 141,
  [154] = 154,
  [155] = 144,
  [156] = 150,
  [157] = 152,
  [158] = 141,
  [159] = 154,
  [160] = 160,
  [161] = 161,
  [162] = 142,
  [163] = 143,
  [164] = 145,
  [165] = 146,
  [166] = 147,
  [167] = 148,
  [168] = 144,
  [169] = 149,
  [170] = 150,
  [171] = 152,
  [172] = 141,
  [173] = 154,
  [174] = 160,
  [175] = 161,
  [176] = 142,
  [177] = 143,
  [178] = 145,
  [179] = 146,
  [180] = 147,
  [181] = 148,
  [182] = 150,
  [183] = 152,
  [184] = 154,
  [185] = 160,
  [186] = 161,
  [187] = 142,
  [188] = 143,
  [189] = 145,
  [190] = 146,
  [191] = 147,
  [192] = 148,
  [193] = 150,
  [194] = 152,
  [195] = 141,
  [196] = 154,
  [197] = 143,
  [198] = 146,
  [199] = 147,
  [200] = 160,
  [201] = 161,
  [202] = 144,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 205,
  [207] = 205,
  [208] = 208,
  [209] = 205,
  [210] = 204,
  [211] = 205,
  [212] = 208,
  [213] = 208,
  [214] = 208,
  [215] = 208,
  [216] = 204,
  [217] = 204,
  [218] = 203,
  [219] = 204,
  [220] = 203,
  [221] = 203,
  [222] = 203,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 231,
  [236] = 236,
  [237] = 237,
  [238] = 226,
  [239] = 229,
  [240] = 233,
  [241] = 234,
  [242] = 231,
  [243] = 236,
  [244] = 223,
  [245] = 237,
  [246] = 226,
  [247] = 225,
  [248] = 233,
  [249] = 234,
  [250] = 231,
  [251] = 236,
  [252] = 237,
  [253] = 226,
  [254] = 229,
  [255] = 233,
  [256] = 234,
  [257] = 231,
  [258] = 236,
  [259] = 237,
  [260] = 226,
  [261] = 229,
  [262] = 236,
  [263] = 233,
  [264] = 234,
  [265] = 224,
  [266] = 227,
  [267] = 228,
  [268] = 230,
  [269] = 232,
  [270] = 270,
  [271] = 237,
  [272] = 270,
  [273] = 229,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 276,
  [286] = 277,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 276,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 277,
  [302] = 290,
  [303] = 291,
  [304] = 292,
  [305] = 293,
  [306] = 295,
  [307] = 298,
  [308] = 299,
  [309] = 300,
  [310] = 310,
  [311] = 274,
  [312] = 275,
  [313] = 282,
  [314] = 310,
  [315] = 278,
  [316] = 279,
  [317] = 284,
  [318] = 281,
  [319] = 290,
  [320] = 291,
  [321] = 292,
  [322] = 293,
  [323] = 295,
  [324] = 298,
  [325] = 299,
  [326] = 300,
  [327] = 327,
  [328] = 310,
  [329] = 274,
  [330] = 275,
  [331] = 282,
  [332] = 278,
  [333] = 279,
  [334] = 280,
  [335] = 281,
  [336] = 290,
  [337] = 291,
  [338] = 292,
  [339] = 293,
  [340] = 295,
  [341] = 298,
  [342] = 299,
  [343] = 300,
  [344] = 310,
  [345] = 274,
  [346] = 275,
  [347] = 282,
  [348] = 278,
  [349] = 279,
  [350] = 280,
  [351] = 281,
  [352] = 290,
  [353] = 291,
  [354] = 292,
  [355] = 293,
  [356] = 295,
  [357] = 310,
  [358] = 274,
  [359] = 282,
  [360] = 278,
  [361] = 279,
  [362] = 280,
  [363] = 296,
  [364] = 297,
  [365] = 327,
  [366] = 283,
  [367] = 280,
  [368] = 5,
  [369] = 369,
  [370] = 369,
  [371] = 369,
  [372] = 369,
  [373] = 369,
  [374] = 369,
  [375] = 369,
  [376] = 5,
  [377] = 377,
  [378] = 378,
  [379] = 378,
  [380] = 380,
  [381] = 378,
  [382] = 380,
  [383] = 378,
  [384] = 380,
  [385] = 378,
  [386] = 380,
  [387] = 387,
  [388] = 380,
  [389] = 378,
  [390] = 387,
  [391] = 380,
  [392] = 378,
  [393] = 387,
  [394] = 4,
  [395] = 387,
  [396] = 387,
  [397] = 380,
  [398] = 398,
  [399] = 398,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 405,
  [408] = 406,
  [409] = 400,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 400,
  [415] = 403,
  [416] = 410,
  [417] = 400,
  [418] = 402,
  [419] = 403,
  [420] = 410,
  [421] = 405,
  [422] = 401,
  [423] = 400,
  [424] = 404,
  [425] = 406,
  [426] = 400,
  [427] = 403,
  [428] = 410,
  [429] = 398,
  [430] = 401,
  [431] = 431,
  [432] = 404,
  [433] = 433,
  [434] = 431,
  [435] = 412,
  [436] = 413,
  [437] = 433,
  [438] = 438,
  [439] = 402,
  [440] = 405,
  [441] = 406,
  [442] = 411,
  [443] = 403,
  [444] = 410,
  [445] = 398,
  [446] = 401,
  [447] = 438,
  [448] = 433,
  [449] = 401,
  [450] = 431,
  [451] = 431,
  [452] = 433,
  [453] = 398,
  [454] = 402,
  [455] = 405,
  [456] = 406,
  [457] = 404,
  [458] = 400,
  [459] = 403,
  [460] = 410,
  [461] = 433,
  [462] = 431,
  [463] = 433,
  [464] = 398,
  [465] = 431,
  [466] = 401,
  [467] = 412,
  [468] = 413,
  [469] = 404,
  [470] = 411,
  [471] = 471,
  [472] = 402,
  [473] = 412,
  [474] = 413,
  [475] = 431,
  [476] = 438,
  [477] = 433,
  [478] = 398,
  [479] = 402,
  [480] = 411,
  [481] = 405,
  [482] = 406,
  [483] = 405,
  [484] = 403,
  [485] = 412,
  [486] = 413,
  [487] = 410,
  [488] = 411,
  [489] = 406,
  [490] = 402,
  [491] = 438,
  [492] = 401,
  [493] = 404,
  [494] = 438,
  [495] = 404,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 496,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 505,
  [512] = 506,
  [513] = 513,
  [514] = 514,
  [515] = 509,
  [516] = 510,
  [517] = 517,
  [518] = 497,
  [519] = 498,
  [520] = 496,
  [521] = 507,
  [522] = 500,
  [523] = 501,
  [524] = 502,
  [525] = 503,
  [526] = 504,
  [527] = 517,
  [528] = 505,
  [529] = 506,
  [530] = 497,
  [531] = 531,
  [532] = 503,
  [533] = 513,
  [534] = 534,
  [535] = 498,
  [536] = 531,
  [537] = 537,
  [538] = 538,
  [539] = 508,
  [540] = 514,
  [541] = 509,
  [542] = 510,
  [543] = 537,
  [544] = 538,
  [545] = 508,
  [546] = 534,
  [547] = 534,
  [548] = 496,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 500,
  [553] = 549,
  [554] = 531,
  [555] = 531,
  [556] = 550,
  [557] = 501,
  [558] = 513,
  [559] = 514,
  [560] = 509,
  [561] = 510,
  [562] = 517,
  [563] = 497,
  [564] = 498,
  [565] = 496,
  [566] = 500,
  [567] = 501,
  [568] = 502,
  [569] = 503,
  [570] = 504,
  [571] = 505,
  [572] = 506,
  [573] = 502,
  [574] = 574,
  [575] = 537,
  [576] = 503,
  [577] = 531,
  [578] = 537,
  [579] = 531,
  [580] = 504,
  [581] = 513,
  [582] = 537,
  [583] = 538,
  [584] = 513,
  [585] = 517,
  [586] = 534,
  [587] = 507,
  [588] = 538,
  [589] = 537,
  [590] = 549,
  [591] = 497,
  [592] = 550,
  [593] = 505,
  [594] = 538,
  [595] = 549,
  [596] = 508,
  [597] = 550,
  [598] = 534,
  [599] = 514,
  [600] = 509,
  [601] = 549,
  [602] = 513,
  [603] = 514,
  [604] = 509,
  [605] = 550,
  [606] = 510,
  [607] = 510,
  [608] = 517,
  [609] = 497,
  [610] = 498,
  [611] = 507,
  [612] = 496,
  [613] = 500,
  [614] = 501,
  [615] = 502,
  [616] = 503,
  [617] = 517,
  [618] = 504,
  [619] = 505,
  [620] = 506,
  [621] = 508,
  [622] = 534,
  [623] = 498,
  [624] = 497,
  [625] = 498,
  [626] = 496,
  [627] = 549,
  [628] = 550,
  [629] = 538,
  [630] = 500,
  [631] = 501,
  [632] = 531,
  [633] = 537,
  [634] = 507,
  [635] = 538,
  [636] = 508,
  [637] = 502,
  [638] = 534,
  [639] = 503,
  [640] = 504,
  [641] = 505,
  [642] = 506,
  [643] = 549,
  [644] = 550,
  [645] = 504,
  [646] = 507,
  [647] = 507,
  [648] = 506,
  [649] = 514,
  [650] = 513,
  [651] = 501,
  [652] = 502,
  [653] = 514,
  [654] = 500,
  [655] = 509,
  [656] = 510,
  [657] = 517,
  [658] = 508,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 660,
  [673] = 660,
  [674] = 660,
  [675] = 660,
  [676] = 660,
  [677] = 660,
  [678] = 660,
  [679] = 660,
  [680] = 660,
  [681] = 660,
  [682] = 660,
  [683] = 660,
  [684] = 660,
  [685] = 660,
  [686] = 660,
  [687] = 660,
  [688] = 660,
  [689] = 660,
  [690] = 690,
  [691] = 690,
  [692] = 671,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 138,
  [697] = 690,
  [698] = 690,
  [699] = 690,
  [700] = 690,
  [701] = 690,
  [702] = 690,
  [703] = 669,
  [704] = 690,
  [705] = 690,
  [706] = 690,
  [707] = 690,
  [708] = 690,
  [709] = 690,
  [710] = 690,
  [711] = 690,
  [712] = 690,
  [713] = 690,
  [714] = 690,
  [715] = 663,
  [716] = 659,
  [717] = 666,
  [718] = 668,
  [719] = 669,
  [720] = 664,
  [721] = 662,
  [722] = 661,
  [723] = 670,
  [724] = 665,
  [725] = 667,
  [726] = 695,
  [727] = 669,
  [728] = 138,
  [729] = 671,
  [730] = 694,
  [731] = 693,
  [732] = 662,
  [733] = 669,
  [734] = 661,
  [735] = 659,
  [736] = 664,
  [737] = 663,
  [738] = 665,
  [739] = 668,
  [740] = 670,
  [741] = 667,
  [742] = 666,
  [743] = 138,
  [744] = 695,
  [745] = 693,
  [746] = 669,
  [747] = 671,
  [748] = 694,
  [749] = 669,
  [750] = 665,
  [751] = 659,
  [752] = 667,
  [753] = 661,
  [754] = 668,
  [755] = 663,
  [756] = 670,
  [757] = 662,
  [758] = 664,
  [759] = 666,
  [760] = 667,
  [761] = 138,
  [762] = 670,
  [763] = 661,
  [764] = 693,
  [765] = 662,
  [766] = 669,
  [767] = 659,
  [768] = 663,
  [769] = 665,
  [770] = 671,
  [771] = 666,
  [772] = 664,
  [773] = 670,
  [774] = 668,
  [775] = 669,
  [776] = 695,
  [777] = 694,
  [778] = 778,
  [779] = 693,
  [780] = 694,
  [781] = 138,
  [782] = 693,
  [783] = 671,
  [784] = 138,
  [785] = 669,
  [786] = 694,
  [787] = 671,
  [788] = 695,
  [789] = 695,
  [790] = 790,
  [791] = 791,
  [792] = 668,
  [793] = 793,
  [794] = 668,
  [795] = 669,
  [796] = 669,
  [797] = 669,
  [798] = 668,
  [799] = 791,
  [800] = 800,
  [801] = 790,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 668,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 669,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 668,
  [902] = 669,
  [903] = 668,
  [904] = 669,
  [905] = 793,
  [906] = 669,
  [907] = 802,
  [908] = 800,
  [909] = 668,
  [910] = 831,
  [911] = 806,
  [912] = 807,
  [913] = 809,
  [914] = 836,
  [915] = 810,
  [916] = 816,
  [917] = 820,
  [918] = 825,
  [919] = 827,
  [920] = 830,
  [921] = 858,
  [922] = 872,
  [923] = 805,
  [924] = 815,
  [925] = 817,
  [926] = 669,
  [927] = 839,
  [928] = 822,
  [929] = 823,
  [930] = 826,
  [931] = 832,
  [932] = 833,
  [933] = 860,
  [934] = 838,
  [935] = 668,
  [936] = 840,
  [937] = 841,
  [938] = 842,
  [939] = 843,
  [940] = 849,
  [941] = 855,
  [942] = 867,
  [943] = 869,
  [944] = 873,
  [945] = 874,
  [946] = 875,
  [947] = 876,
  [948] = 877,
  [949] = 878,
  [950] = 879,
  [951] = 880,
  [952] = 881,
  [953] = 882,
  [954] = 883,
  [955] = 803,
  [956] = 891,
  [957] = 892,
  [958] = 894,
  [959] = 895,
  [960] = 868,
  [961] = 884,
  [962] = 804,
  [963] = 896,
  [964] = 865,
  [965] = 900,
  [966] = 897,
  [967] = 856,
  [968] = 898,
  [969] = 851,
  [970] = 814,
  [971] = 818,
  [972] = 819,
  [973] = 834,
  [974] = 885,
  [975] = 808,
  [976] = 813,
  [977] = 835,
  [978] = 837,
  [979] = 821,
  [980] = 889,
  [981] = 844,
  [982] = 845,
  [983] = 846,
  [984] = 847,
  [985] = 854,
  [986] = 857,
  [987] = 862,
  [988] = 863,
  [989] = 853,
  [990] = 811,
  [991] = 859,
  [992] = 864,
  [993] = 871,
  [994] = 886,
  [995] = 850,
  [996] = 861,
  [997] = 870,
  [998] = 812,
  [999] = 828,
  [1000] = 829,
  [1001] = 899,
  [1002] = 852,
  [1003] = 893,
  [1004] = 887,
  [1005] = 888,
  [1006] = 890,
  [1007] = 824,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 900,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 669,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 666,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 665,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 663,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 667,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 668,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 669,
  [1046] = 1046,
  [1047] = 664,
  [1048] = 659,
  [1049] = 662,
  [1050] = 661,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1051,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1051,
  [1067] = 1051,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 138,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1227,
  [1228] = 1228,
  [1229] = 1229,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1017,
  [1236] = 1016,
  [1237] = 1018,
  [1238] = 1019,
  [1239] = 1020,
  [1240] = 1022,
  [1241] = 1016,
  [1242] = 1017,
  [1243] = 1023,
  [1244] = 1018,
  [1245] = 1027,
  [1246] = 1043,
  [1247] = 1040,
  [1248] = 1020,
  [1249] = 1019,
  [1250] = 665,
  [1251] = 1023,
  [1252] = 1022,
  [1253] = 666,
  [1254] = 1034,
  [1255] = 1044,
  [1256] = 1031,
  [1257] = 1028,
  [1258] = 669,
  [1259] = 1017,
  [1260] = 1054,
  [1261] = 1018,
  [1262] = 1088,
  [1263] = 1016,
  [1264] = 1043,
  [1265] = 1040,
  [1266] = 1027,
  [1267] = 1038,
  [1268] = 664,
  [1269] = 1041,
  [1270] = 1046,
  [1271] = 1030,
  [1272] = 1089,
  [1273] = 1033,
  [1274] = 1083,
  [1275] = 1084,
  [1276] = 1063,
  [1277] = 659,
  [1278] = 663,
  [1279] = 667,
  [1280] = 668,
  [1281] = 1032,
  [1282] = 1025,
  [1283] = 662,
  [1284] = 1035,
  [1285] = 1036,
  [1286] = 1037,
  [1287] = 1026,
  [1288] = 1205,
  [1289] = 1097,
  [1290] = 1209,
  [1291] = 1229,
  [1292] = 1231,
  [1293] = 1180,
  [1294] = 1125,
  [1295] = 1232,
  [1296] = 1181,
  [1297] = 1167,
  [1298] = 1193,
  [1299] = 1104,
  [1300] = 1136,
  [1301] = 1116,
  [1302] = 1160,
  [1303] = 1189,
  [1304] = 1233,
  [1305] = 1226,
  [1306] = 1129,
  [1307] = 1194,
  [1308] = 1098,
  [1309] = 1204,
  [1310] = 1185,
  [1311] = 1196,
  [1312] = 1230,
  [1313] = 1197,
  [1314] = 1199,
  [1315] = 661,
  [1316] = 1053,
  [1317] = 1222,
  [1318] = 1051,
  [1319] = 1052,
  [1320] = 668,
  [1321] = 1085,
  [1322] = 1071,
  [1323] = 1072,
  [1324] = 1073,
  [1325] = 1096,
  [1326] = 1079,
  [1327] = 664,
  [1328] = 1061,
  [1329] = 1023,
  [1330] = 1081,
  [1331] = 1054,
  [1332] = 1092,
  [1333] = 1076,
  [1334] = 1077,
  [1335] = 1078,
  [1336] = 1070,
  [1337] = 1063,
  [1338] = 669,
  [1339] = 1086,
  [1340] = 1087,
  [1341] = 1046,
  [1342] = 1074,
  [1343] = 1060,
  [1344] = 1051,
  [1345] = 1032,
  [1346] = 1025,
  [1347] = 1082,
  [1348] = 1051,
  [1349] = 1034,
  [1350] = 1035,
  [1351] = 1036,
  [1352] = 1090,
  [1353] = 1037,
  [1354] = 1038,
  [1355] = 1033,
  [1356] = 1088,
  [1357] = 1026,
  [1358] = 1016,
  [1359] = 1041,
  [1360] = 1018,
  [1361] = 1075,
  [1362] = 1065,
  [1363] = 1031,
  [1364] = 1080,
  [1365] = 1028,
  [1366] = 1017,
  [1367] = 659,
  [1368] = 1018,
  [1369] = 1091,
  [1370] = 1056,
  [1371] = 1030,
  [1372] = 663,
  [1373] = 662,
  [1374] = 1016,
  [1375] = 1089,
  [1376] = 1062,
  [1377] = 1017,
  [1378] = 1068,
  [1379] = 1093,
  [1380] = 1022,
  [1381] = 667,
  [1382] = 1064,
  [1383] = 1057,
  [1384] = 1058,
  [1385] = 1059,
  [1386] = 1083,
  [1387] = 665,
  [1388] = 1069,
  [1389] = 666,
  [1390] = 1051,
  [1391] = 1084,
  [1392] = 1094,
  [1393] = 1095,
  [1394] = 1044,
  [1395] = 1199,
  [1396] = 1219,
  [1397] = 1114,
  [1398] = 1104,
  [1399] = 1171,
  [1400] = 1227,
  [1401] = 1172,
  [1402] = 1111,
  [1403] = 1136,
  [1404] = 1174,
  [1405] = 1134,
  [1406] = 1116,
  [1407] = 1176,
  [1408] = 1220,
  [1409] = 1160,
  [1410] = 1020,
  [1411] = 1180,
  [1412] = 1181,
  [1413] = 1185,
  [1414] = 1158,
  [1415] = 1120,
  [1416] = 1019,
  [1417] = 1153,
  [1418] = 1165,
  [1419] = 1196,
  [1420] = 1138,
  [1421] = 1197,
  [1422] = 1178,
  [1423] = 1205,
  [1424] = 1097,
  [1425] = 1127,
  [1426] = 1209,
  [1427] = 1103,
  [1428] = 1229,
  [1429] = 1231,
  [1430] = 1119,
  [1431] = 1232,
  [1432] = 1233,
  [1433] = 1189,
  [1434] = 1098,
  [1435] = 1204,
  [1436] = 1230,
  [1437] = 1234,
  [1438] = 1108,
  [1439] = 1190,
  [1440] = 1139,
  [1441] = 1195,
  [1442] = 1109,
  [1443] = 1150,
  [1444] = 1107,
  [1445] = 1182,
  [1446] = 1145,
  [1447] = 1218,
  [1448] = 1167,
  [1449] = 1043,
  [1450] = 1184,
  [1451] = 1040,
  [1452] = 1213,
  [1453] = 1192,
  [1454] = 1027,
  [1455] = 1226,
  [1456] = 1194,
  [1457] = 1106,
  [1458] = 1208,
  [1459] = 1200,
  [1460] = 1207,
  [1461] = 1168,
  [1462] = 1169,
  [1463] = 1214,
  [1464] = 661,
  [1465] = 1170,
  [1466] = 1102,
  [1467] = 1206,
  [1468] = 1140,
  [1469] = 1155,
  [1470] = 1053,
  [1471] = 1156,
  [1472] = 1177,
  [1473] = 1141,
  [1474] = 1183,
  [1475] = 1216,
  [1476] = 1179,
  [1477] = 1224,
  [1478] = 1052,
  [1479] = 138,
  [1480] = 1187,
  [1481] = 1201,
  [1482] = 1202,
  [1483] = 1175,
  [1484] = 1203,
  [1485] = 1159,
  [1486] = 1124,
  [1487] = 1225,
  [1488] = 1128,
  [1489] = 1110,
  [1490] = 1100,
  [1491] = 1131,
  [1492] = 1133,
  [1493] = 1020,
  [1494] = 1223,
  [1495] = 1228,
  [1496] = 1135,
  [1497] = 1188,
  [1498] = 1210,
  [1499] = 1211,
  [1500] = 1161,
  [1501] = 1019,
  [1502] = 1193,
  [1503] = 1137,
  [1504] = 1173,
  [1505] = 1126,
  [1506] = 1212,
  [1507] = 1215,
  [1508] = 1217,
  [1509] = 1099,
  [1510] = 1222,
  [1511] = 1115,
  [1512] = 1117,
  [1513] = 1157,
  [1514] = 1121,
  [1515] = 1144,
  [1516] = 1191,
  [1517] = 1125,
  [1518] = 1198,
  [1519] = 1221,
  [1520] = 1113,
  [1521] = 1122,
  [1522] = 1051,
  [1523] = 1123,
  [1524] = 1142,
  [1525] = 1130,
  [1526] = 1132,
  [1527] = 1118,
  [1528] = 1143,
  [1529] = 1147,
  [1530] = 1151,
  [1531] = 1154,
  [1532] = 1129,
  [1533] = 1152,
  [1534] = 1162,
  [1535] = 1164,
  [1536] = 1166,
  [1537] = 1101,
  [1538] = 1105,
  [1539] = 1186,
  [1540] = 1163,
  [1541] = 1086,
  [1542] = 1034,
  [1543] = 1035,
  [1544] = 1036,
  [1545] = 1037,
  [1546] = 1038,
  [1547] = 1033,
  [1548] = 1026,
  [1549] = 1041,
  [1550] = 1044,
  [1551] = 1031,
  [1552] = 1028,
  [1553] = 1030,
  [1554] = 662,
  [1555] = 1062,
  [1556] = 1060,
  [1557] = 1068,
  [1558] = 659,
  [1559] = 663,
  [1560] = 1081,
  [1561] = 1063,
  [1562] = 1064,
  [1563] = 1069,
  [1564] = 1061,
  [1565] = 1076,
  [1566] = 1077,
  [1567] = 1078,
  [1568] = 1087,
  [1569] = 1046,
  [1570] = 1090,
  [1571] = 1091,
  [1572] = 1056,
  [1573] = 1057,
  [1574] = 1058,
  [1575] = 1059,
  [1576] = 1092,
  [1577] = 664,
  [1578] = 1093,
  [1579] = 1095,
  [1580] = 1074,
  [1581] = 1070,
  [1582] = 1075,
  [1583] = 1080,
  [1584] = 665,
  [1585] = 1022,
  [1586] = 1023,
  [1587] = 666,
  [1588] = 667,
  [1589] = 1022,
  [1590] = 1023,
  [1591] = 668,
  [1592] = 1018,
  [1593] = 1016,
  [1594] = 1054,
  [1595] = 669,
  [1596] = 1088,
  [1597] = 665,
  [1598] = 666,
  [1599] = 1051,
  [1600] = 1051,
  [1601] = 1051,
  [1602] = 1032,
  [1603] = 1025,
  [1604] = 1082,
  [1605] = 1208,
  [1606] = 1188,
  [1607] = 1193,
  [1608] = 1113,
  [1609] = 1104,
  [1610] = 1111,
  [1611] = 1136,
  [1612] = 1116,
  [1613] = 1160,
  [1614] = 1189,
  [1615] = 1218,
  [1616] = 1226,
  [1617] = 1106,
  [1618] = 1110,
  [1619] = 1122,
  [1620] = 1134,
  [1621] = 1138,
  [1622] = 1184,
  [1623] = 1192,
  [1624] = 1194,
  [1625] = 1200,
  [1626] = 1207,
  [1627] = 1214,
  [1628] = 1100,
  [1629] = 1071,
  [1630] = 1072,
  [1631] = 1073,
  [1632] = 1096,
  [1633] = 1079,
  [1634] = 1123,
  [1635] = 1130,
  [1636] = 1032,
  [1637] = 1143,
  [1638] = 1147,
  [1639] = 1151,
  [1640] = 1154,
  [1641] = 1166,
  [1642] = 1171,
  [1643] = 1172,
  [1644] = 1025,
  [1645] = 1174,
  [1646] = 1176,
  [1647] = 1108,
  [1648] = 1195,
  [1649] = 1109,
  [1650] = 1150,
  [1651] = 1182,
  [1652] = 1046,
  [1653] = 1034,
  [1654] = 1065,
  [1655] = 1102,
  [1656] = 1206,
  [1657] = 1155,
  [1658] = 1156,
  [1659] = 1163,
  [1660] = 1179,
  [1661] = 1175,
  [1662] = 1124,
  [1663] = 1128,
  [1664] = 1035,
  [1665] = 1131,
  [1666] = 1133,
  [1667] = 1036,
  [1668] = 1135,
  [1669] = 1037,
  [1670] = 1038,
  [1671] = 1033,
  [1672] = 1152,
  [1673] = 1162,
  [1674] = 1164,
  [1675] = 1178,
  [1676] = 1165,
  [1677] = 1127,
  [1678] = 1216,
  [1679] = 1219,
  [1680] = 1026,
  [1681] = 1220,
  [1682] = 1118,
  [1683] = 1227,
  [1684] = 1132,
  [1685] = 1041,
  [1686] = 1085,
  [1687] = 1101,
  [1688] = 1114,
  [1689] = 1158,
  [1690] = 1190,
  [1691] = 1191,
  [1692] = 1198,
  [1693] = 1044,
  [1694] = 1031,
  [1695] = 1028,
  [1696] = 1030,
  [1697] = 1126,
  [1698] = 1117,
  [1699] = 1120,
  [1700] = 1153,
  [1701] = 1224,
  [1702] = 1137,
  [1703] = 1142,
  [1704] = 1103,
  [1705] = 1119,
  [1706] = 1168,
  [1707] = 1169,
  [1708] = 1161,
  [1709] = 1170,
  [1710] = 1177,
  [1711] = 1183,
  [1712] = 1187,
  [1713] = 1201,
  [1714] = 1202,
  [1715] = 1203,
  [1716] = 1210,
  [1717] = 1211,
  [1718] = 1212,
  [1719] = 1215,
  [1720] = 1217,
  [1721] = 1221,
  [1722] = 1225,
  [1723] = 1157,
  [1724] = 1139,
  [1725] = 1140,
  [1726] = 1141,
  [1727] = 1083,
  [1728] = 1084,
  [1729] = 1129,
  [1730] = 1051,
  [1731] = 1223,
  [1732] = 1228,
  [1733] = 1173,
  [1734] = 1180,
  [1735] = 1181,
  [1736] = 1185,
  [1737] = 1196,
  [1738] = 1197,
  [1739] = 1199,
  [1740] = 1205,
  [1741] = 1097,
  [1742] = 1209,
  [1743] = 1229,
  [1744] = 1231,
  [1745] = 1232,
  [1746] = 1233,
  [1747] = 1098,
  [1748] = 1204,
  [1749] = 1230,
  [1750] = 1043,
  [1751] = 1040,
  [1752] = 1222,
  [1753] = 1027,
  [1754] = 1099,
  [1755] = 1115,
  [1756] = 1121,
  [1757] = 1043,
  [1758] = 1040,
  [1759] = 1027,
  [1760] = 662,
  [1761] = 1144,
  [1762] = 1125,
  [1763] = 659,
  [1764] = 663,
  [1765] = 138,
  [1766] = 1094,
  [1767] = 1105,
  [1768] = 667,
  [1769] = 1186,
  [1770] = 664,
  [1771] = 668,
  [1772] = 669,
  [1773] = 1234,
  [1774] = 1107,
  [1775] = 1145,
  [1776] = 1167,
  [1777] = 661,
  [1778] = 1053,
  [1779] = 1052,
  [1780] = 1213,
  [1781] = 1159,
  [1782] = 1064,
  [1783] = 1092,
  [1784] = 661,
  [1785] = 1051,
  [1786] = 1051,
  [1787] = 1148,
  [1788] = 1149,
  [1789] = 1070,
  [1790] = 1051,
  [1791] = 1095,
  [1792] = 1051,
  [1793] = 1057,
  [1794] = 1075,
  [1795] = 1080,
  [1796] = 1093,
  [1797] = 1797,
  [1798] = 1059,
  [1799] = 1062,
  [1800] = 1060,
  [1801] = 1091,
  [1802] = 1053,
  [1803] = 1068,
  [1804] = 1074,
  [1805] = 1058,
  [1806] = 1081,
  [1807] = 1052,
  [1808] = 1056,
  [1809] = 1069,
  [1810] = 1061,
  [1811] = 1076,
  [1812] = 1077,
  [1813] = 1078,
  [1814] = 1146,
  [1815] = 1086,
  [1816] = 1087,
  [1817] = 1082,
  [1818] = 1090,
  [1819] = 1819,
  [1820] = 1225,
  [1821] = 1120,
  [1822] = 1153,
  [1823] = 1159,
  [1824] = 1137,
  [1825] = 1142,
  [1826] = 1219,
  [1827] = 1103,
  [1828] = 1119,
  [1829] = 1168,
  [1830] = 1169,
  [1831] = 1133,
  [1832] = 1170,
  [1833] = 1177,
  [1834] = 1220,
  [1835] = 1183,
  [1836] = 1187,
  [1837] = 1201,
  [1838] = 1202,
  [1839] = 1203,
  [1840] = 1210,
  [1841] = 1211,
  [1842] = 1212,
  [1843] = 1215,
  [1844] = 1217,
  [1845] = 1221,
  [1846] = 1128,
  [1847] = 1157,
  [1848] = 1139,
  [1849] = 1140,
  [1850] = 1141,
  [1851] = 1062,
  [1852] = 1060,
  [1853] = 1124,
  [1854] = 1054,
  [1855] = 1118,
  [1856] = 1068,
  [1857] = 1227,
  [1858] = 1132,
  [1859] = 1083,
  [1860] = 1084,
  [1861] = 1094,
  [1862] = 1081,
  [1863] = 1088,
  [1864] = 1063,
  [1865] = 1131,
  [1866] = 1064,
  [1867] = 1069,
  [1868] = 1071,
  [1869] = 1072,
  [1870] = 1073,
  [1871] = 1096,
  [1872] = 1079,
  [1873] = 1061,
  [1874] = 1076,
  [1875] = 1077,
  [1876] = 1078,
  [1877] = 1085,
  [1878] = 1086,
  [1879] = 1087,
  [1880] = 1082,
  [1881] = 1090,
  [1882] = 1065,
  [1883] = 1091,
  [1884] = 1056,
  [1885] = 1057,
  [1886] = 1058,
  [1887] = 1059,
  [1888] = 1101,
  [1889] = 1114,
  [1890] = 1152,
  [1891] = 1158,
  [1892] = 1190,
  [1893] = 1191,
  [1894] = 1092,
  [1895] = 1198,
  [1896] = 1085,
  [1897] = 138,
  [1898] = 1162,
  [1899] = 1093,
  [1900] = 1095,
  [1901] = 1074,
  [1902] = 1054,
  [1903] = 1070,
  [1904] = 1088,
  [1905] = 1164,
  [1906] = 1208,
  [1907] = 1178,
  [1908] = 1117,
  [1909] = 1051,
  [1910] = 1051,
  [1911] = 1075,
  [1912] = 1051,
  [1913] = 1080,
  [1914] = 1063,
  [1915] = 1161,
  [1916] = 1223,
  [1917] = 1228,
  [1918] = 1173,
  [1919] = 1089,
  [1920] = 1099,
  [1921] = 1115,
  [1922] = 1121,
  [1923] = 1144,
  [1924] = 1083,
  [1925] = 1084,
  [1926] = 1094,
  [1927] = 1105,
  [1928] = 1186,
  [1929] = 1234,
  [1930] = 1107,
  [1931] = 1145,
  [1932] = 1213,
  [1933] = 1224,
  [1934] = 1188,
  [1935] = 1113,
  [1936] = 1111,
  [1937] = 1218,
  [1938] = 1063,
  [1939] = 1106,
  [1940] = 1110,
  [1941] = 1122,
  [1942] = 1134,
  [1943] = 1138,
  [1944] = 1184,
  [1945] = 1192,
  [1946] = 1200,
  [1947] = 1207,
  [1948] = 1214,
  [1949] = 1100,
  [1950] = 1071,
  [1951] = 1072,
  [1952] = 1073,
  [1953] = 1096,
  [1954] = 1079,
  [1955] = 1123,
  [1956] = 1130,
  [1957] = 1143,
  [1958] = 1147,
  [1959] = 1151,
  [1960] = 1154,
  [1961] = 1166,
  [1962] = 1171,
  [1963] = 1172,
  [1964] = 1174,
  [1965] = 1176,
  [1966] = 1127,
  [1967] = 1135,
  [1968] = 1216,
  [1969] = 1108,
  [1970] = 1195,
  [1971] = 1109,
  [1972] = 1150,
  [1973] = 1182,
  [1974] = 1126,
  [1975] = 1065,
  [1976] = 1175,
  [1977] = 1102,
  [1978] = 1206,
  [1979] = 1155,
  [1980] = 1156,
  [1981] = 1163,
  [1982] = 1179,
  [1983] = 1165,
  [1984] = 1223,
  [1985] = 1152,
  [1986] = 1162,
  [1987] = 1164,
  [1988] = 1178,
  [1989] = 1165,
  [1990] = 1127,
  [1991] = 1216,
  [1992] = 1219,
  [1993] = 1160,
  [1994] = 1220,
  [1995] = 1118,
  [1996] = 1227,
  [1997] = 1132,
  [1998] = 1189,
  [1999] = 1218,
  [2000] = 1101,
  [2001] = 1114,
  [2002] = 1226,
  [2003] = 1158,
  [2004] = 1190,
  [2005] = 1191,
  [2006] = 1198,
  [2007] = 1106,
  [2008] = 1110,
  [2009] = 1208,
  [2010] = 138,
  [2011] = 1122,
  [2012] = 1173,
  [2013] = 1134,
  [2014] = 1138,
  [2015] = 1184,
  [2016] = 1192,
  [2017] = 1126,
  [2018] = 1222,
  [2019] = 1117,
  [2020] = 1120,
  [2021] = 1153,
  [2022] = 1159,
  [2023] = 1137,
  [2024] = 1142,
  [2025] = 1194,
  [2026] = 1103,
  [2027] = 1200,
  [2028] = 1119,
  [2029] = 1168,
  [2030] = 1207,
  [2031] = 1169,
  [2032] = 1214,
  [2033] = 1099,
  [2034] = 1170,
  [2035] = 1177,
  [2036] = 1115,
  [2037] = 1100,
  [2038] = 1183,
  [2039] = 1129,
  [2040] = 1187,
  [2041] = 1201,
  [2042] = 1121,
  [2043] = 1144,
  [2044] = 1202,
  [2045] = 1203,
  [2046] = 1125,
  [2047] = 1161,
  [2048] = 1123,
  [2049] = 1130,
  [2050] = 1210,
  [2051] = 1143,
  [2052] = 1125,
  [2053] = 1211,
  [2054] = 1212,
  [2055] = 1147,
  [2056] = 1151,
  [2057] = 1154,
  [2058] = 1166,
  [2059] = 1171,
  [2060] = 1215,
  [2061] = 1172,
  [2062] = 1054,
  [2063] = 1088,
  [2064] = 1174,
  [2065] = 1167,
  [2066] = 1222,
  [2067] = 1176,
  [2068] = 1193,
  [2069] = 1105,
  [2070] = 1104,
  [2071] = 1180,
  [2072] = 1116,
  [2073] = 1116,
  [2074] = 1160,
  [2075] = 1189,
  [2076] = 1181,
  [2077] = 1185,
  [2078] = 1226,
  [2079] = 1186,
  [2080] = 1228,
  [2081] = 1196,
  [2082] = 1129,
  [2083] = 1217,
  [2084] = 1197,
  [2085] = 1199,
  [2086] = 1205,
  [2087] = 1097,
  [2088] = 1194,
  [2089] = 1209,
  [2090] = 1229,
  [2091] = 1231,
  [2092] = 1221,
  [2093] = 1225,
  [2094] = 1232,
  [2095] = 1233,
  [2096] = 1098,
  [2097] = 1204,
  [2098] = 1230,
  [2099] = 1108,
  [2100] = 1195,
  [2101] = 1109,
  [2102] = 1157,
  [2103] = 1150,
  [2104] = 1182,
  [2105] = 1234,
  [2106] = 1107,
  [2107] = 1145,
  [2108] = 1102,
  [2109] = 1206,
  [2110] = 1139,
  [2111] = 1155,
  [2112] = 1140,
  [2113] = 1141,
  [2114] = 1156,
  [2115] = 1163,
  [2116] = 1180,
  [2117] = 1181,
  [2118] = 1185,
  [2119] = 1179,
  [2120] = 1175,
  [2121] = 1196,
  [2122] = 1197,
  [2123] = 1199,
  [2124] = 1205,
  [2125] = 1097,
  [2126] = 1209,
  [2127] = 1229,
  [2128] = 1231,
  [2129] = 1232,
  [2130] = 1233,
  [2131] = 1098,
  [2132] = 1204,
  [2133] = 1230,
  [2134] = 1124,
  [2135] = 1128,
  [2136] = 1167,
  [2137] = 1131,
  [2138] = 1133,
  [2139] = 1213,
  [2140] = 1136,
  [2141] = 1063,
  [2142] = 1135,
  [2143] = 1224,
  [2144] = 1188,
  [2145] = 1193,
  [2146] = 1113,
  [2147] = 1104,
  [2148] = 1111,
  [2149] = 1136,
  [2150] = 1160,
  [2151] = 1194,
  [2152] = 1084,
  [2153] = 1180,
  [2154] = 1181,
  [2155] = 1185,
  [2156] = 1196,
  [2157] = 1197,
  [2158] = 1199,
  [2159] = 1205,
  [2160] = 1097,
  [2161] = 1209,
  [2162] = 1229,
  [2163] = 1231,
  [2164] = 1232,
  [2165] = 1233,
  [2166] = 1098,
  [2167] = 1204,
  [2168] = 1230,
  [2169] = 1222,
  [2170] = 1083,
  [2171] = 1125,
  [2172] = 1167,
  [2173] = 1193,
  [2174] = 1104,
  [2175] = 1136,
  [2176] = 1116,
  [2177] = 1189,
  [2178] = 1226,
  [2179] = 1129,
  [2180] = 2180,
  [2181] = 2180,
  [2182] = 2182,
  [2183] = 2180,
  [2184] = 2180,
  [2185] = 2180,
  [2186] = 1129,
  [2187] = 2182,
  [2188] = 2180,
  [2189] = 2180,
  [2190] = 2182,
  [2191] = 2182,
  [2192] = 2182,
  [2193] = 2193,
  [2194] = 2193,
  [2195] = 2193,
  [2196] = 2193,
  [2197] = 2193,
  [2198] = 2193,
  [2199] = 2193,
  [2200] = 2200,
  [2201] = 2201,
  [2202] = 2201,
  [2203] = 2200,
  [2204] = 2201,
  [2205] = 2200,
  [2206] = 2200,
  [2207] = 2200,
  [2208] = 2201,
  [2209] = 2201,
  [2210] = 2210,
  [2211] = 2211,
  [2212] = 2212,
  [2213] = 2213,
  [2214] = 2214,
  [2215] = 2210,
  [2216] = 2216,
  [2217] = 2216,
  [2218] = 2212,
  [2219] = 2210,
  [2220] = 2212,
  [2221] = 2213,
  [2222] = 2214,
  [2223] = 2212,
  [2224] = 2211,
  [2225] = 2214,
  [2226] = 2211,
  [2227] = 2213,
  [2228] = 2212,
  [2229] = 2216,
  [2230] = 2214,
  [2231] = 2216,
  [2232] = 2210,
  [2233] = 2211,
  [2234] = 2213,
  [2235] = 2211,
  [2236] = 2214,
  [2237] = 2216,
  [2238] = 2210,
  [2239] = 2213,
  [2240] = 2240,
  [2241] = 2241,
  [2242] = 2242,
  [2243] = 2243,
  [2244] = 2244,
  [2245] = 2245,
  [2246] = 2246,
  [2247] = 2247,
  [2248] = 2248,
  [2249] = 2249,
  [2250] = 2250,
  [2251] = 2247,
  [2252] = 2240,
  [2253] = 2242,
  [2254] = 2243,
  [2255] = 2255,
  [2256] = 2244,
  [2257] = 2245,
  [2258] = 2258,
  [2259] = 2241,
  [2260] = 2248,
  [2261] = 2249,
  [2262] = 2250,
  [2263] = 2247,
  [2264] = 2240,
  [2265] = 2242,
  [2266] = 2243,
  [2267] = 2255,
  [2268] = 2244,
  [2269] = 2245,
  [2270] = 2258,
  [2271] = 2241,
  [2272] = 2248,
  [2273] = 2249,
  [2274] = 2258,
  [2275] = 2250,
  [2276] = 2247,
  [2277] = 2240,
  [2278] = 2243,
  [2279] = 2255,
  [2280] = 2244,
  [2281] = 2245,
  [2282] = 2258,
  [2283] = 2241,
  [2284] = 2248,
  [2285] = 2249,
  [2286] = 2250,
  [2287] = 2247,
  [2288] = 2240,
  [2289] = 2242,
  [2290] = 2243,
  [2291] = 2255,
  [2292] = 2255,
  [2293] = 2250,
  [2294] = 2248,
  [2295] = 2258,
  [2296] = 2249,
  [2297] = 2244,
  [2298] = 2245,
  [2299] = 2241,
  [2300] = 2246,
  [2301] = 2242,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2304,
  [2305] = 2305,
  [2306] = 1054,
  [2307] = 1088,
  [2308] = 2308,
  [2309] = 2309,
  [2310] = 2309,
  [2311] = 2308,
  [2312] = 2309,
  [2313] = 2308,
  [2314] = 2308,
  [2315] = 2308,
  [2316] = 2309,
  [2317] = 2309,
  [2318] = 2318,
  [2319] = 2318,
  [2320] = 2318,
  [2321] = 2321,
  [2322] = 2318,
  [2323] = 2323,
  [2324] = 2324,
  [2325] = 2325,
  [2326] = 2326,
  [2327] = 2327,
  [2328] = 2328,
  [2329] = 669,
  [2330] = 2330,
  [2331] = 2331,
  [2332] = 2332,
  [2333] = 664,
  [2334] = 2334,
  [2335] = 2335,
  [2336] = 669,
  [2337] = 2331,
  [2338] = 2338,
  [2339] = 664,
  [2340] = 2334,
  [2341] = 2335,
  [2342] = 668,
  [2343] = 668,
  [2344] = 2330,
  [2345] = 2345,
  [2346] = 667,
  [2347] = 2345,
  [2348] = 665,
  [2349] = 2349,
  [2350] = 2350,
  [2351] = 2351,
  [2352] = 2352,
  [2353] = 666,
  [2354] = 2349,
  [2355] = 2345,
  [2356] = 2350,
  [2357] = 2349,
  [2358] = 2352,
  [2359] = 2351,
  [2360] = 2349,
  [2361] = 664,
  [2362] = 662,
  [2363] = 659,
  [2364] = 2350,
  [2365] = 2365,
  [2366] = 668,
  [2367] = 2352,
  [2368] = 659,
  [2369] = 663,
  [2370] = 665,
  [2371] = 2349,
  [2372] = 662,
  [2373] = 669,
  [2374] = 2350,
  [2375] = 666,
  [2376] = 663,
  [2377] = 2352,
  [2378] = 2345,
  [2379] = 2350,
  [2380] = 2345,
  [2381] = 2345,
  [2382] = 2345,
  [2383] = 2383,
  [2384] = 2345,
  [2385] = 2345,
  [2386] = 2345,
  [2387] = 2345,
  [2388] = 2345,
  [2389] = 2345,
  [2390] = 2345,
  [2391] = 2391,
  [2392] = 2331,
  [2393] = 669,
  [2394] = 664,
  [2395] = 2395,
  [2396] = 664,
  [2397] = 2352,
  [2398] = 667,
  [2399] = 668,
  [2400] = 2391,
  [2401] = 2395,
  [2402] = 2334,
  [2403] = 2335,
  [2404] = 668,
  [2405] = 2345,
  [2406] = 669,
  [2407] = 2345,
  [2408] = 1054,
  [2409] = 2409,
  [2410] = 2410,
  [2411] = 2411,
  [2412] = 2412,
  [2413] = 2413,
  [2414] = 2414,
  [2415] = 2415,
  [2416] = 2414,
  [2417] = 2417,
  [2418] = 2418,
  [2419] = 2419,
  [2420] = 2411,
  [2421] = 2417,
  [2422] = 2422,
  [2423] = 2423,
  [2424] = 2412,
  [2425] = 2418,
  [2426] = 2426,
  [2427] = 664,
  [2428] = 2422,
  [2429] = 2429,
  [2430] = 2419,
  [2431] = 662,
  [2432] = 2432,
  [2433] = 1088,
  [2434] = 668,
  [2435] = 2410,
  [2436] = 2411,
  [2437] = 2412,
  [2438] = 2413,
  [2439] = 2415,
  [2440] = 2414,
  [2441] = 2417,
  [2442] = 2418,
  [2443] = 2419,
  [2444] = 2444,
  [2445] = 666,
  [2446] = 2446,
  [2447] = 669,
  [2448] = 2422,
  [2449] = 2423,
  [2450] = 2432,
  [2451] = 2451,
  [2452] = 2426,
  [2453] = 2429,
  [2454] = 2446,
  [2455] = 665,
  [2456] = 2410,
  [2457] = 2411,
  [2458] = 2411,
  [2459] = 2412,
  [2460] = 2413,
  [2461] = 2415,
  [2462] = 2414,
  [2463] = 2417,
  [2464] = 2418,
  [2465] = 2419,
  [2466] = 2422,
  [2467] = 2413,
  [2468] = 663,
  [2469] = 2423,
  [2470] = 2426,
  [2471] = 2471,
  [2472] = 2429,
  [2473] = 667,
  [2474] = 2334,
  [2475] = 2335,
  [2476] = 664,
  [2477] = 2415,
  [2478] = 2415,
  [2479] = 2423,
  [2480] = 2415,
  [2481] = 2415,
  [2482] = 2412,
  [2483] = 2415,
  [2484] = 2413,
  [2485] = 2415,
  [2486] = 2426,
  [2487] = 2429,
  [2488] = 2414,
  [2489] = 2429,
  [2490] = 2490,
  [2491] = 2444,
  [2492] = 2409,
  [2493] = 2493,
  [2494] = 2493,
  [2495] = 2495,
  [2496] = 2496,
  [2497] = 2415,
  [2498] = 2426,
  [2499] = 2410,
  [2500] = 2500,
  [2501] = 2501,
  [2502] = 2417,
  [2503] = 2471,
  [2504] = 2496,
  [2505] = 2500,
  [2506] = 2501,
  [2507] = 2507,
  [2508] = 668,
  [2509] = 2495,
  [2510] = 2391,
  [2511] = 2395,
  [2512] = 2490,
  [2513] = 2418,
  [2514] = 2419,
  [2515] = 2423,
  [2516] = 2451,
  [2517] = 2423,
  [2518] = 2410,
  [2519] = 669,
  [2520] = 2331,
  [2521] = 659,
  [2522] = 2422,
  [2523] = 2495,
  [2524] = 2524,
  [2525] = 2471,
  [2526] = 2526,
  [2527] = 2527,
  [2528] = 2528,
  [2529] = 2529,
  [2530] = 2530,
  [2531] = 2531,
  [2532] = 2490,
  [2533] = 2444,
  [2534] = 2391,
  [2535] = 2395,
  [2536] = 2528,
  [2537] = 2409,
  [2538] = 2493,
  [2539] = 2529,
  [2540] = 2530,
  [2541] = 2541,
  [2542] = 2501,
  [2543] = 2528,
  [2544] = 2531,
  [2545] = 2527,
  [2546] = 668,
  [2547] = 659,
  [2548] = 665,
  [2549] = 663,
  [2550] = 2550,
  [2551] = 2528,
  [2552] = 669,
  [2553] = 2553,
  [2554] = 2554,
  [2555] = 2528,
  [2556] = 2531,
  [2557] = 2496,
  [2558] = 2558,
  [2559] = 2531,
  [2560] = 2560,
  [2561] = 2560,
  [2562] = 2562,
  [2563] = 2563,
  [2564] = 2527,
  [2565] = 2500,
  [2566] = 2566,
  [2567] = 2531,
  [2568] = 2566,
  [2569] = 2560,
  [2570] = 2562,
  [2571] = 2558,
  [2572] = 666,
  [2573] = 2550,
  [2574] = 2554,
  [2575] = 664,
  [2576] = 2432,
  [2577] = 2541,
  [2578] = 662,
  [2579] = 2579,
  [2580] = 2580,
  [2581] = 2580,
  [2582] = 2446,
  [2583] = 2563,
  [2584] = 2560,
  [2585] = 2562,
  [2586] = 2586,
  [2587] = 667,
  [2588] = 2527,
  [2589] = 2526,
  [2590] = 2524,
  [2591] = 2560,
  [2592] = 2562,
  [2593] = 2586,
  [2594] = 2527,
  [2595] = 2579,
  [2596] = 2562,
  [2597] = 2490,
  [2598] = 2598,
  [2599] = 2495,
  [2600] = 2496,
  [2601] = 2444,
  [2602] = 2602,
  [2603] = 2603,
  [2604] = 1051,
  [2605] = 2605,
  [2606] = 2606,
  [2607] = 2500,
  [2608] = 2608,
  [2609] = 2602,
  [2610] = 2610,
  [2611] = 2611,
  [2612] = 2612,
  [2613] = 2409,
  [2614] = 2614,
  [2615] = 1088,
  [2616] = 1054,
  [2617] = 2617,
  [2618] = 2501,
  [2619] = 2619,
  [2620] = 2620,
  [2621] = 2621,
  [2622] = 2622,
  [2623] = 1051,
  [2624] = 2624,
  [2625] = 2625,
  [2626] = 2605,
  [2627] = 2621,
  [2628] = 2622,
  [2629] = 2471,
  [2630] = 2610,
  [2631] = 2631,
  [2632] = 2632,
  [2633] = 2493,
  [2634] = 2634,
  [2635] = 2635,
  [2636] = 2620,
  [2637] = 2619,
  [2638] = 2608,
  [2639] = 2639,
  [2640] = 2632,
  [2641] = 2598,
  [2642] = 2612,
  [2643] = 2432,
  [2644] = 2614,
  [2645] = 2617,
  [2646] = 2646,
  [2647] = 2446,
  [2648] = 2606,
  [2649] = 2634,
  [2650] = 2624,
  [2651] = 2635,
  [2652] = 2611,
  [2653] = 2631,
  [2654] = 2625,
  [2655] = 2639,
  [2656] = 2656,
  [2657] = 2603,
  [2658] = 2656,
  [2659] = 2659,
  [2660] = 1017,
  [2661] = 2661,
  [2662] = 2610,
  [2663] = 2621,
  [2664] = 2664,
  [2665] = 2659,
  [2666] = 2666,
  [2667] = 2611,
  [2668] = 2668,
  [2669] = 1018,
  [2670] = 2608,
  [2671] = 2659,
  [2672] = 2620,
  [2673] = 2605,
  [2674] = 2631,
  [2675] = 2675,
  [2676] = 2632,
  [2677] = 1051,
  [2678] = 2598,
  [2679] = 2679,
  [2680] = 2326,
  [2681] = 1018,
  [2682] = 2622,
  [2683] = 2683,
  [2684] = 2684,
  [2685] = 1016,
  [2686] = 2603,
  [2687] = 2610,
  [2688] = 2668,
  [2689] = 2666,
  [2690] = 2659,
  [2691] = 2659,
  [2692] = 2692,
  [2693] = 2603,
  [2694] = 2694,
  [2695] = 2659,
  [2696] = 2696,
  [2697] = 1017,
  [2698] = 2698,
  [2699] = 2606,
  [2700] = 2700,
  [2701] = 1016,
  [2702] = 2702,
  [2703] = 2659,
  [2704] = 2675,
  [2705] = 2625,
  [2706] = 2602,
  [2707] = 2631,
  [2708] = 2632,
  [2709] = 1018,
  [2710] = 2710,
  [2711] = 2620,
  [2712] = 2621,
  [2713] = 2605,
  [2714] = 2714,
  [2715] = 2715,
  [2716] = 2622,
  [2717] = 2598,
  [2718] = 2611,
  [2719] = 2608,
  [2720] = 2625,
  [2721] = 2603,
  [2722] = 2722,
  [2723] = 2715,
  [2724] = 1051,
  [2725] = 1016,
  [2726] = 2606,
  [2727] = 1017,
  [2728] = 2602,
  [2729] = 1023,
  [2730] = 2730,
  [2731] = 2323,
  [2732] = 2732,
  [2733] = 2733,
  [2734] = 2734,
  [2735] = 2732,
  [2736] = 2736,
  [2737] = 2737,
  [2738] = 2738,
  [2739] = 2739,
  [2740] = 2740,
  [2741] = 2741,
  [2742] = 2730,
  [2743] = 2730,
  [2744] = 2733,
  [2745] = 2734,
  [2746] = 2732,
  [2747] = 2747,
  [2748] = 2748,
  [2749] = 2740,
  [2750] = 2741,
  [2751] = 2751,
  [2752] = 2325,
  [2753] = 2753,
  [2754] = 2754,
  [2755] = 2755,
  [2756] = 2326,
  [2757] = 2740,
  [2758] = 2741,
  [2759] = 2759,
  [2760] = 2754,
  [2761] = 2740,
  [2762] = 2753,
  [2763] = 2324,
  [2764] = 2730,
  [2765] = 2765,
  [2766] = 2734,
  [2767] = 2741,
  [2768] = 2733,
  [2769] = 2734,
  [2770] = 2327,
  [2771] = 2755,
  [2772] = 2751,
  [2773] = 2732,
  [2774] = 2732,
  [2775] = 2755,
  [2776] = 2751,
  [2777] = 2751,
  [2778] = 2755,
  [2779] = 2738,
  [2780] = 1022,
  [2781] = 2751,
  [2782] = 2739,
  [2783] = 1023,
  [2784] = 2755,
  [2785] = 2730,
  [2786] = 2759,
  [2787] = 2787,
  [2788] = 1022,
  [2789] = 2733,
  [2790] = 2734,
  [2791] = 2747,
  [2792] = 2748,
  [2793] = 2740,
  [2794] = 2741,
  [2795] = 2787,
  [2796] = 2736,
  [2797] = 2737,
  [2798] = 2765,
  [2799] = 2733,
  [2800] = 2800,
  [2801] = 2801,
  [2802] = 2802,
  [2803] = 2803,
  [2804] = 2804,
  [2805] = 2805,
  [2806] = 2806,
  [2807] = 2807,
  [2808] = 2808,
  [2809] = 2809,
  [2810] = 2810,
  [2811] = 2811,
  [2812] = 2812,
  [2813] = 2813,
  [2814] = 2806,
  [2815] = 1043,
  [2816] = 2816,
  [2817] = 2804,
  [2818] = 2818,
  [2819] = 2819,
  [2820] = 2820,
  [2821] = 2821,
  [2822] = 2800,
  [2823] = 2823,
  [2824] = 2824,
  [2825] = 2825,
  [2826] = 2826,
  [2827] = 2827,
  [2828] = 2803,
  [2829] = 2829,
  [2830] = 2829,
  [2831] = 2831,
  [2832] = 2832,
  [2833] = 2823,
  [2834] = 2834,
  [2835] = 2807,
  [2836] = 2831,
  [2837] = 2811,
  [2838] = 2812,
  [2839] = 2839,
  [2840] = 2840,
  [2841] = 2816,
  [2842] = 2804,
  [2843] = 2834,
  [2844] = 2844,
  [2845] = 2845,
  [2846] = 1022,
  [2847] = 2847,
  [2848] = 2848,
  [2849] = 1023,
  [2850] = 2850,
  [2851] = 2851,
  [2852] = 2834,
  [2853] = 2850,
  [2854] = 2848,
  [2855] = 2813,
  [2856] = 2856,
  [2857] = 2806,
  [2858] = 2801,
  [2859] = 2802,
  [2860] = 2832,
  [2861] = 2803,
  [2862] = 2802,
  [2863] = 2863,
  [2864] = 2864,
  [2865] = 2806,
  [2866] = 2839,
  [2867] = 2823,
  [2868] = 1027,
  [2869] = 2840,
  [2870] = 2870,
  [2871] = 2807,
  [2872] = 2803,
  [2873] = 2829,
  [2874] = 2807,
  [2875] = 2875,
  [2876] = 2844,
  [2877] = 2831,
  [2878] = 2845,
  [2879] = 2813,
  [2880] = 2880,
  [2881] = 2847,
  [2882] = 2882,
  [2883] = 2883,
  [2884] = 2818,
  [2885] = 2800,
  [2886] = 2819,
  [2887] = 2820,
  [2888] = 2800,
  [2889] = 2889,
  [2890] = 2824,
  [2891] = 2812,
  [2892] = 1040,
  [2893] = 2801,
  [2894] = 2875,
  [2895] = 2895,
  [2896] = 2811,
  [2897] = 2897,
  [2898] = 2819,
  [2899] = 2812,
  [2900] = 2883,
  [2901] = 2829,
  [2902] = 2856,
  [2903] = 2831,
  [2904] = 2832,
  [2905] = 2905,
  [2906] = 2820,
  [2907] = 2824,
  [2908] = 2823,
  [2909] = 2909,
  [2910] = 2807,
  [2911] = 1040,
  [2912] = 2912,
  [2913] = 2821,
  [2914] = 2818,
  [2915] = 2816,
  [2916] = 2813,
  [2917] = 2851,
  [2918] = 2819,
  [2919] = 2850,
  [2920] = 2811,
  [2921] = 2812,
  [2922] = 2820,
  [2923] = 2804,
  [2924] = 2847,
  [2925] = 2925,
  [2926] = 2816,
  [2927] = 2804,
  [2928] = 2834,
  [2929] = 2800,
  [2930] = 2834,
  [2931] = 2848,
  [2932] = 2825,
  [2933] = 2847,
  [2934] = 2925,
  [2935] = 2824,
  [2936] = 1008,
  [2937] = 2851,
  [2938] = 2850,
  [2939] = 1027,
  [2940] = 2905,
  [2941] = 2832,
  [2942] = 2848,
  [2943] = 2808,
  [2944] = 2856,
  [2945] = 2816,
  [2946] = 2801,
  [2947] = 2802,
  [2948] = 2803,
  [2949] = 2856,
  [2950] = 2810,
  [2951] = 2806,
  [2952] = 2801,
  [2953] = 2811,
  [2954] = 2805,
  [2955] = 2847,
  [2956] = 2813,
  [2957] = 2870,
  [2958] = 2802,
  [2959] = 2851,
  [2960] = 2824,
  [2961] = 2850,
  [2962] = 2848,
  [2963] = 2895,
  [2964] = 2829,
  [2965] = 1043,
  [2966] = 2856,
  [2967] = 2831,
  [2968] = 2823,
  [2969] = 2818,
  [2970] = 2832,
  [2971] = 2819,
  [2972] = 2851,
  [2973] = 2820,
  [2974] = 2818,
  [2975] = 2975,
  [2976] = 1043,
  [2977] = 2977,
  [2978] = 2978,
  [2979] = 2978,
  [2980] = 2980,
  [2981] = 2977,
  [2982] = 2980,
  [2983] = 2977,
  [2984] = 2984,
  [2985] = 2978,
  [2986] = 2978,
  [2987] = 2980,
  [2988] = 2988,
  [2989] = 2977,
  [2990] = 2990,
  [2991] = 2991,
  [2992] = 2980,
  [2993] = 2993,
  [2994] = 2994,
  [2995] = 2978,
  [2996] = 2994,
  [2997] = 2997,
  [2998] = 2998,
  [2999] = 2991,
  [3000] = 1088,
  [3001] = 1027,
  [3002] = 3002,
  [3003] = 2998,
  [3004] = 2991,
  [3005] = 2991,
  [3006] = 2980,
  [3007] = 2978,
  [3008] = 1054,
  [3009] = 2980,
  [3010] = 2977,
  [3011] = 1040,
  [3012] = 1054,
  [3013] = 2991,
  [3014] = 2993,
  [3015] = 2984,
  [3016] = 3002,
  [3017] = 1088,
  [3018] = 3018,
  [3019] = 2977,
  [3020] = 3020,
  [3021] = 3021,
  [3022] = 3022,
  [3023] = 3023,
  [3024] = 3024,
  [3025] = 659,
  [3026] = 3026,
  [3027] = 3027,
  [3028] = 3028,
  [3029] = 665,
  [3030] = 3030,
  [3031] = 3031,
  [3032] = 3032,
  [3033] = 3033,
  [3034] = 3034,
  [3035] = 3035,
  [3036] = 668,
  [3037] = 3037,
  [3038] = 3038,
  [3039] = 3038,
  [3040] = 3040,
  [3041] = 3041,
  [3042] = 3042,
  [3043] = 3043,
  [3044] = 3044,
  [3045] = 3022,
  [3046] = 3046,
  [3047] = 3047,
  [3048] = 3048,
  [3049] = 3049,
  [3050] = 3050,
  [3051] = 3051,
  [3052] = 3052,
  [3053] = 3053,
  [3054] = 3054,
  [3055] = 3047,
  [3056] = 3056,
  [3057] = 3057,
  [3058] = 3048,
  [3059] = 3057,
  [3060] = 3060,
  [3061] = 3061,
  [3062] = 3062,
  [3063] = 3054,
  [3064] = 3064,
  [3065] = 3062,
  [3066] = 3066,
  [3067] = 3021,
  [3068] = 3068,
  [3069] = 3051,
  [3070] = 3032,
  [3071] = 3071,
  [3072] = 3041,
  [3073] = 3073,
  [3074] = 3042,
  [3075] = 3075,
  [3076] = 3033,
  [3077] = 2694,
  [3078] = 3078,
  [3079] = 3027,
  [3080] = 3049,
  [3081] = 3081,
  [3082] = 3082,
  [3083] = 3028,
  [3084] = 3084,
  [3085] = 3031,
  [3086] = 3052,
  [3087] = 3075,
  [3088] = 3088,
  [3089] = 3061,
  [3090] = 3028,
  [3091] = 3088,
  [3092] = 3088,
  [3093] = 3064,
  [3094] = 3043,
  [3095] = 3032,
  [3096] = 3096,
  [3097] = 3057,
  [3098] = 3060,
  [3099] = 3061,
  [3100] = 3062,
  [3101] = 3082,
  [3102] = 3084,
  [3103] = 3103,
  [3104] = 3044,
  [3105] = 3022,
  [3106] = 3031,
  [3107] = 3023,
  [3108] = 1009,
  [3109] = 3103,
  [3110] = 3034,
  [3111] = 3040,
  [3112] = 3050,
  [3113] = 3113,
  [3114] = 3050,
  [3115] = 3115,
  [3116] = 3075,
  [3117] = 3053,
  [3118] = 3118,
  [3119] = 3073,
  [3120] = 3037,
  [3121] = 3021,
  [3122] = 3027,
  [3123] = 3088,
  [3124] = 3038,
  [3125] = 3125,
  [3126] = 667,
  [3127] = 3127,
  [3128] = 3084,
  [3129] = 3115,
  [3130] = 3020,
  [3131] = 3125,
  [3132] = 3127,
  [3133] = 3084,
  [3134] = 3064,
  [3135] = 3057,
  [3136] = 3060,
  [3137] = 3061,
  [3138] = 3062,
  [3139] = 3073,
  [3140] = 3081,
  [3141] = 3021,
  [3142] = 3125,
  [3143] = 3143,
  [3144] = 3144,
  [3145] = 3118,
  [3146] = 3144,
  [3147] = 3030,
  [3148] = 3148,
  [3149] = 3032,
  [3150] = 3115,
  [3151] = 3143,
  [3152] = 3056,
  [3153] = 3153,
  [3154] = 3020,
  [3155] = 3030,
  [3156] = 3031,
  [3157] = 3157,
  [3158] = 669,
  [3159] = 3127,
  [3160] = 3125,
  [3161] = 3143,
  [3162] = 3081,
  [3163] = 3082,
  [3164] = 3144,
  [3165] = 3030,
  [3166] = 3143,
  [3167] = 3073,
  [3168] = 3148,
  [3169] = 3032,
  [3170] = 3028,
  [3171] = 3031,
  [3172] = 3115,
  [3173] = 3148,
  [3174] = 666,
  [3175] = 3044,
  [3176] = 3081,
  [3177] = 3050,
  [3178] = 3022,
  [3179] = 3143,
  [3180] = 3084,
  [3181] = 3143,
  [3182] = 3044,
  [3183] = 3075,
  [3184] = 3075,
  [3185] = 3057,
  [3186] = 3038,
  [3187] = 3044,
  [3188] = 3022,
  [3189] = 3060,
  [3190] = 3061,
  [3191] = 3062,
  [3192] = 3096,
  [3193] = 3082,
  [3194] = 3027,
  [3195] = 3020,
  [3196] = 3035,
  [3197] = 3148,
  [3198] = 3125,
  [3199] = 3064,
  [3200] = 3024,
  [3201] = 3026,
  [3202] = 3113,
  [3203] = 3064,
  [3204] = 3060,
  [3205] = 3088,
  [3206] = 3082,
  [3207] = 3207,
  [3208] = 3143,
  [3209] = 3068,
  [3210] = 3144,
  [3211] = 3023,
  [3212] = 3040,
  [3213] = 3028,
  [3214] = 3030,
  [3215] = 3034,
  [3216] = 3073,
  [3217] = 3071,
  [3218] = 3115,
  [3219] = 3023,
  [3220] = 3020,
  [3221] = 3034,
  [3222] = 3143,
  [3223] = 2610,
  [3224] = 3035,
  [3225] = 3046,
  [3226] = 3050,
  [3227] = 3035,
  [3228] = 3144,
  [3229] = 3229,
  [3230] = 3081,
  [3231] = 3035,
  [3232] = 3207,
  [3233] = 3021,
  [3234] = 3040,
  [3235] = 3127,
  [3236] = 3027,
  [3237] = 3229,
  [3238] = 3143,
  [3239] = 3078,
  [3240] = 3240,
  [3241] = 3241,
  [3242] = 3242,
  [3243] = 3243,
  [3244] = 3244,
  [3245] = 3245,
  [3246] = 3246,
  [3247] = 3247,
  [3248] = 3248,
  [3249] = 3249,
  [3250] = 3250,
  [3251] = 3251,
  [3252] = 3252,
  [3253] = 3253,
  [3254] = 3254,
  [3255] = 3255,
  [3256] = 3256,
  [3257] = 3257,
  [3258] = 3258,
  [3259] = 3259,
  [3260] = 3260,
  [3261] = 3261,
  [3262] = 3262,
  [3263] = 3263,
  [3264] = 3264,
  [3265] = 3265,
  [3266] = 3266,
  [3267] = 3267,
  [3268] = 3268,
  [3269] = 3269,
  [3270] = 3270,
  [3271] = 3271,
  [3272] = 3272,
  [3273] = 3273,
  [3274] = 3274,
  [3275] = 3275,
  [3276] = 3276,
  [3277] = 3277,
  [3278] = 3278,
  [3279] = 3273,
  [3280] = 3257,
  [3281] = 3281,
  [3282] = 3243,
  [3283] = 3283,
  [3284] = 3244,
  [3285] = 3272,
  [3286] = 3286,
  [3287] = 3287,
  [3288] = 3245,
  [3289] = 3289,
  [3290] = 3277,
  [3291] = 3246,
  [3292] = 3292,
  [3293] = 3262,
  [3294] = 3266,
  [3295] = 3249,
  [3296] = 3276,
  [3297] = 3276,
  [3298] = 3286,
  [3299] = 3281,
  [3300] = 3286,
  [3301] = 3301,
  [3302] = 3292,
  [3303] = 3247,
  [3304] = 3304,
  [3305] = 3304,
  [3306] = 3254,
  [3307] = 3248,
  [3308] = 3308,
  [3309] = 3309,
  [3310] = 3310,
  [3311] = 3311,
  [3312] = 3278,
  [3313] = 3252,
  [3314] = 3314,
  [3315] = 3315,
  [3316] = 3316,
  [3317] = 3317,
  [3318] = 3241,
  [3319] = 3257,
  [3320] = 3275,
  [3321] = 3261,
  [3322] = 3308,
  [3323] = 3323,
  [3324] = 3309,
  [3325] = 3258,
  [3326] = 3265,
  [3327] = 3327,
  [3328] = 3267,
  [3329] = 3314,
  [3330] = 3271,
  [3331] = 3251,
  [3332] = 3327,
  [3333] = 3333,
  [3334] = 3334,
  [3335] = 3276,
  [3336] = 3252,
  [3337] = 3286,
  [3338] = 3283,
  [3339] = 3309,
  [3340] = 3314,
  [3341] = 3334,
  [3342] = 3342,
  [3343] = 3315,
  [3344] = 3269,
  [3345] = 3345,
  [3346] = 3270,
  [3347] = 3240,
  [3348] = 3257,
  [3349] = 3261,
  [3350] = 3257,
  [3351] = 3256,
  [3352] = 3259,
  [3353] = 3342,
  [3354] = 3308,
  [3355] = 3263,
  [3356] = 3309,
  [3357] = 3261,
  [3358] = 3358,
  [3359] = 3241,
  [3360] = 3255,
  [3361] = 3252,
  [3362] = 3314,
  [3363] = 3276,
  [3364] = 3286,
  [3365] = 3275,
  [3366] = 3301,
  [3367] = 3308,
  [3368] = 3368,
  [3369] = 3317,
  [3370] = 3241,
  [3371] = 3250,
  [3372] = 3372,
  [3373] = 3275,
  [3374] = 3368,
  [3375] = 3308,
  [3376] = 3309,
  [3377] = 3264,
  [3378] = 3378,
  [3379] = 3242,
  [3380] = 3252,
  [3381] = 3314,
  [3382] = 3253,
  [3383] = 3333,
  [3384] = 3287,
  [3385] = 3323,
  [3386] = 3241,
  [3387] = 3261,
  [3388] = 3275,
  [3389] = 3345,
  [3390] = 3258,
  [3391] = 3268,
  [3392] = 3265,
  [3393] = 3258,
  [3394] = 3265,
  [3395] = 3240,
  [3396] = 3310,
  [3397] = 3358,
  [3398] = 3372,
  [3399] = 3289,
  [3400] = 3258,
  [3401] = 3240,
  [3402] = 3260,
  [3403] = 3265,
  [3404] = 3316,
  [3405] = 3405,
  [3406] = 3406,
  [3407] = 3407,
  [3408] = 3408,
  [3409] = 3409,
  [3410] = 3410,
  [3411] = 3411,
  [3412] = 3412,
  [3413] = 3407,
  [3414] = 3414,
  [3415] = 3415,
  [3416] = 3408,
  [3417] = 3414,
  [3418] = 3407,
  [3419] = 3408,
  [3420] = 3408,
  [3421] = 3410,
  [3422] = 3411,
  [3423] = 3412,
  [3424] = 3407,
  [3425] = 3425,
  [3426] = 3414,
  [3427] = 3408,
  [3428] = 3410,
  [3429] = 3411,
  [3430] = 3412,
  [3431] = 3431,
  [3432] = 3432,
  [3433] = 3410,
  [3434] = 2324,
  [3435] = 3411,
  [3436] = 2327,
  [3437] = 3410,
  [3438] = 3411,
  [3439] = 3439,
  [3440] = 3412,
  [3441] = 3441,
  [3442] = 3406,
  [3443] = 3405,
  [3444] = 3415,
  [3445] = 3414,
  [3446] = 3409,
  [3447] = 3412,
  [3448] = 3406,
  [3449] = 3405,
  [3450] = 3415,
  [3451] = 3451,
  [3452] = 3409,
  [3453] = 3406,
  [3454] = 3405,
  [3455] = 3415,
  [3456] = 3407,
  [3457] = 3409,
  [3458] = 3406,
  [3459] = 3405,
  [3460] = 3415,
  [3461] = 3414,
  [3462] = 3462,
  [3463] = 3463,
  [3464] = 3464,
  [3465] = 3465,
  [3466] = 3466,
  [3467] = 3465,
  [3468] = 3465,
  [3469] = 664,
  [3470] = 3470,
  [3471] = 3471,
  [3472] = 3472,
  [3473] = 3465,
  [3474] = 3474,
  [3475] = 3475,
  [3476] = 3476,
  [3477] = 3477,
  [3478] = 3478,
  [3479] = 3479,
  [3480] = 3480,
  [3481] = 3471,
  [3482] = 3482,
  [3483] = 3483,
  [3484] = 3484,
  [3485] = 3485,
  [3486] = 3486,
  [3487] = 3465,
  [3488] = 3488,
  [3489] = 3489,
  [3490] = 3490,
  [3491] = 3491,
  [3492] = 3492,
  [3493] = 3493,
  [3494] = 3494,
  [3495] = 3480,
  [3496] = 3476,
  [3497] = 3497,
  [3498] = 3485,
  [3499] = 3474,
  [3500] = 3470,
  [3501] = 3501,
  [3502] = 3463,
  [3503] = 3503,
  [3504] = 3504,
  [3505] = 3505,
  [3506] = 3506,
  [3507] = 860,
  [3508] = 3464,
  [3509] = 3480,
  [3510] = 3510,
  [3511] = 3463,
  [3512] = 3505,
  [3513] = 3470,
  [3514] = 665,
  [3515] = 3515,
  [3516] = 3516,
  [3517] = 3517,
  [3518] = 3518,
  [3519] = 3489,
  [3520] = 3471,
  [3521] = 3477,
  [3522] = 3474,
  [3523] = 3523,
  [3524] = 3482,
  [3525] = 666,
  [3526] = 3466,
  [3527] = 3527,
  [3528] = 3516,
  [3529] = 3462,
  [3530] = 3530,
  [3531] = 3491,
  [3532] = 3497,
  [3533] = 3533,
  [3534] = 3534,
  [3535] = 3465,
  [3536] = 3536,
  [3537] = 3537,
  [3538] = 3538,
  [3539] = 3505,
  [3540] = 3480,
  [3541] = 3492,
  [3542] = 3518,
  [3543] = 3543,
  [3544] = 3462,
  [3545] = 3488,
  [3546] = 3484,
  [3547] = 3493,
  [3548] = 3548,
  [3549] = 3523,
  [3550] = 3465,
  [3551] = 3505,
  [3552] = 3510,
  [3553] = 3472,
  [3554] = 3501,
  [3555] = 3465,
  [3556] = 3463,
  [3557] = 3492,
  [3558] = 3493,
  [3559] = 3523,
  [3560] = 3503,
  [3561] = 3501,
  [3562] = 836,
  [3563] = 3471,
  [3564] = 3464,
  [3565] = 3464,
  [3566] = 3474,
  [3567] = 3470,
  [3568] = 3470,
  [3569] = 3475,
  [3570] = 3472,
  [3571] = 3505,
  [3572] = 3489,
  [3573] = 3489,
  [3574] = 3574,
  [3575] = 3517,
  [3576] = 3489,
  [3577] = 3485,
  [3578] = 3491,
  [3579] = 3465,
  [3580] = 3492,
  [3581] = 3475,
  [3582] = 3492,
  [3583] = 3471,
  [3584] = 3465,
  [3585] = 3515,
  [3586] = 3492,
  [3587] = 3484,
  [3588] = 3471,
  [3589] = 3486,
  [3590] = 3476,
  [3591] = 3492,
  [3592] = 3471,
  [3593] = 3518,
  [3594] = 3594,
  [3595] = 3492,
  [3596] = 3471,
  [3597] = 3510,
  [3598] = 3536,
  [3599] = 3492,
  [3600] = 3471,
  [3601] = 3477,
  [3602] = 3602,
  [3603] = 3471,
  [3604] = 3474,
  [3605] = 3523,
  [3606] = 3471,
  [3607] = 3607,
  [3608] = 3466,
  [3609] = 3471,
  [3610] = 3536,
  [3611] = 3488,
  [3612] = 3471,
  [3613] = 3503,
  [3614] = 3485,
  [3615] = 3471,
  [3616] = 3491,
  [3617] = 3516,
  [3618] = 3471,
  [3619] = 3464,
  [3620] = 3476,
  [3621] = 3471,
  [3622] = 3497,
  [3623] = 3518,
  [3624] = 3471,
  [3625] = 3625,
  [3626] = 3536,
  [3627] = 3471,
  [3628] = 3515,
  [3629] = 3629,
  [3630] = 3485,
  [3631] = 3488,
  [3632] = 3482,
  [3633] = 3517,
  [3634] = 662,
  [3635] = 3503,
  [3636] = 3475,
  [3637] = 3534,
  [3638] = 3465,
  [3639] = 3475,
  [3640] = 3523,
  [3641] = 3477,
  [3642] = 3477,
  [3643] = 3491,
  [3644] = 3501,
  [3645] = 3548,
  [3646] = 3629,
  [3647] = 3465,
  [3648] = 3493,
  [3649] = 3484,
  [3650] = 3476,
  [3651] = 3518,
  [3652] = 3536,
  [3653] = 3510,
  [3654] = 3465,
  [3655] = 3465,
  [3656] = 3475,
  [3657] = 3657,
  [3658] = 3484,
  [3659] = 3488,
  [3660] = 3503,
  [3661] = 3486,
  [3662] = 3493,
  [3663] = 3465,
  [3664] = 3475,
  [3665] = 663,
  [3666] = 3466,
  [3667] = 3462,
  [3668] = 3465,
  [3669] = 3516,
  [3670] = 3548,
  [3671] = 3671,
  [3672] = 3501,
  [3673] = 3472,
  [3674] = 3497,
  [3675] = 3462,
  [3676] = 3463,
  [3677] = 3463,
  [3678] = 3534,
  [3679] = 3548,
  [3680] = 1013,
  [3681] = 3465,
  [3682] = 3465,
  [3683] = 3465,
  [3684] = 3534,
  [3685] = 3475,
  [3686] = 3548,
  [3687] = 3510,
  [3688] = 3548,
  [3689] = 3548,
  [3690] = 3548,
  [3691] = 3548,
  [3692] = 1014,
  [3693] = 3537,
  [3694] = 3594,
  [3695] = 3471,
  [3696] = 3538,
  [3697] = 3506,
  [3698] = 3625,
  [3699] = 3480,
  [3700] = 3515,
  [3701] = 3475,
  [3702] = 3702,
  [3703] = 3703,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0x85, 0x85}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200a}, {0x2028, 0x2029}, {0x202f, 0x202f},
  {0x205f, 0x205f}, {0x3000, 0x3000},
};

static TSCharacterRange aux_sym__interpolation_fallbacks_token1_character_set_1[] = {
  {0, '#'}, {'%', '&'}, {'(', '*'}, {',', ','}, {'.', '/'}, {';', '@'}, {'[', '^'}, {'`', '`'},
  {'{', 0x10ffff},
};

static TSCharacterRange sym_match_regexp_modifiers_character_set_1[] = {
  {'a', 'a'}, {'c', 'd'}, {'g', 'g'}, {'i', 'i'}, {'l', 'n'}, {'p', 'p'}, {'s', 's'}, {'u', 'u'},
  {'x', 'x'},
};

static TSCharacterRange sym_substitution_regexp_modifiers_character_set_1[] = {
  {'a', 'a'}, {'c', 'e'}, {'g', 'g'}, {'i', 'i'}, {'l', 'm'}, {'o', 'p'}, {'r', 's'}, {'u', 'u'},
  {'x', 'x'},
};

static TSCharacterRange sym__identifier_character_set_1[] = {
  {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym__identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2},
  {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc},
  {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd},
  {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f},
  {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4},
  {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe},
  {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39},
  {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75},
  {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5},
  {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c},
  {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d},
  {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2},
  {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28},
  {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63},
  {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4},
  {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3}, {0xd00, 0xd0c},
  {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f},
  {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4},
  {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82},
  {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xece},
  {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39},
  {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
  {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5},
  {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734},
  {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9},
  {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b},
  {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c},
  {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73},
  {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2},
  {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054}, {0x2071, 0x2071},
  {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67},
  {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
  {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096},
  {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf},
  {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873},
  {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0},
  {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d},
  {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
  {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f},
  {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe}, {0xffc2, 0xffc7},
  {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
  {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f},
  {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9},
  {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595},
  {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785},
  {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855},
  {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf},
  {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c},
  {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48},
  {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10efd, 0x10f1c},
  {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba},
  {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176},
  {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c},
  {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d},
  {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461},
  {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644},
  {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a},
  {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943},
  {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99},
  {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7},
  {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10},
  {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0},
  {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9},
  {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f},
  {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155},
  {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d},
  {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454},
  {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
  {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546},
  {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e},
  {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c},
  {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018},
  {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149},
  {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe},
  {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739},
  {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(109);
      ADVANCE_MAP(
        0x04, 252,
        '!', 215,
        '#', 248,
        '$', 118,
        '%', 224,
        '&', 178,
        '(', 127,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 187,
        '/', 190,
        '0', 408,
        ':', 113,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
        '[', 254,
        '\\', 219,
        ']', 143,
        '^', 176,
        'a', 266,
        'c', 292,
        'd', 272,
        'e', 334,
        'g', 313,
        'i', 271,
        'l', 272,
        'm', 263,
        'n', 272,
        'o', 356,
        'p', 272,
        'r', 315,
        's', 265,
        'u', 270,
        'v', 374,
        'x', 272,
        '{', 255,
        '|', 175,
        '}', 111,
        '~', 213,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(102);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        0x04, 252,
        '!', 215,
        '#', 248,
        '$', 118,
        '%', 224,
        '&', 178,
        '(', 127,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 187,
        '/', 190,
        '0', 408,
        ':', 113,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
        '[', 142,
        '\\', 219,
        ']', 143,
        '^', 176,
        'a', 331,
        'c', 294,
        'd', 343,
        'e', 373,
        'g', 313,
        'i', 370,
        'l', 303,
        'm', 260,
        'o', 356,
        'p', 344,
        'r', 316,
        's', 261,
        'u', 306,
        'x', 191,
        '{', 110,
        '|', 175,
        '}', 111,
        '~', 213,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(1);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        0x04, 252,
        '!', 214,
        '#', 248,
        '$', 118,
        '%', 224,
        '(', 127,
        ')', 126,
        '*', 188,
        '+', 180,
        ',', 125,
        '-', 183,
        '.', 98,
        '/', 79,
        '0', 408,
        ':', 81,
        ';', 114,
        '<', 148,
        '=', 85,
        '@', 124,
        '[', 142,
        '\\', 219,
        ']', 143,
        'a', 331,
        'c', 295,
        'd', 343,
        'e', 373,
        'g', 355,
        'l', 304,
        'm', 260,
        'o', 356,
        'p', 344,
        'r', 316,
        's', 261,
        'u', 306,
        'x', 346,
        '{', 110,
        '}', 111,
        '~', 212,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(2);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        0x04, 252,
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        '(', 127,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(14);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'a') ADVANCE(381);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'o') ADVANCE(384);
      if (lookahead == 'x') ADVANCE(193);
      if (lookahead == '{') ADVANCE(110);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(3);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        0x04, 252,
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(16);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'a') ADVANCE(381);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'o') ADVANCE(384);
      if (lookahead == 'x') ADVANCE(193);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(4);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        0x04, 252,
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(16);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'a') ADVANCE(381);
      if (lookahead == 'c') ADVANCE(288);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'o') ADVANCE(384);
      if (lookahead == 'x') ADVANCE(193);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'd' ||
          lookahead == 'r' ||
          lookahead == 's') ADVANCE(288);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(4);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        0x04, 252,
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
      );
      if (lookahead == '\\') SKIP(18);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'a') ADVANCE(381);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'o') ADVANCE(384);
      if (lookahead == 'x') ADVANCE(193);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(6);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        0x04, 252,
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
      );
      if (lookahead == '\\') SKIP(18);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'a') ADVANCE(276);
      if (lookahead == 'c') ADVANCE(275);
      if (lookahead == 'g') ADVANCE(279);
      if (lookahead == 'i') ADVANCE(278);
      if (lookahead == 'l') ADVANCE(279);
      if (lookahead == 'o') ADVANCE(384);
      if (lookahead == 'x') ADVANCE(279);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'd' ||
          ('m' <= lookahead && lookahead <= 'p') ||
          lookahead == 's' ||
          lookahead == 'u') ADVANCE(279);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(6);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        0x04, 252,
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
      );
      if (lookahead == '\\') SKIP(18);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'a') ADVANCE(287);
      if (lookahead == 'c') ADVANCE(282);
      if (lookahead == 'g') ADVANCE(281);
      if (lookahead == 'i') ADVANCE(286);
      if (lookahead == 'l') ADVANCE(281);
      if (lookahead == 'o') ADVANCE(285);
      if (lookahead == 'x') ADVANCE(283);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'd' ||
          lookahead == 'e' ||
          lookahead == 'm' ||
          lookahead == 'p' ||
          lookahead == 'r' ||
          lookahead == 's' ||
          lookahead == 'u') ADVANCE(287);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(6);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        0x04, 252,
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
      );
      if (lookahead == '\\') SKIP(18);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'a') ADVANCE(268);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(271);
      if (lookahead == 'l') ADVANCE(272);
      if (lookahead == 'o') ADVANCE(384);
      if (lookahead == 'x') ADVANCE(272);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'd' ||
          ('m' <= lookahead && lookahead <= 'p') ||
          lookahead == 's' ||
          lookahead == 'u') ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(6);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        0x04, 252,
        '#', 248,
        '$', 117,
        '%', 224,
        '(', 127,
        ')', 126,
        '*', 188,
        ',', 125,
        '-', 182,
        '/', 80,
        ':', 112,
        ';', 114,
        '=', 121,
        '>', 149,
        '@', 124,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(36);
      if (lookahead == 'a') ADVANCE(381);
      if (lookahead == 'o') ADVANCE(384);
      if (lookahead == 'x') ADVANCE(382);
      if (lookahead == '{') ADVANCE(110);
      if (lookahead == '|') ADVANCE(92);
      if (lookahead == '}') ADVANCE(111);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(10);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        0x04, 252,
        '#', 248,
        '$', 117,
        '%', 224,
        '(', 127,
        ')', 126,
        ',', 125,
        '-', 182,
        '/', 80,
        ':', 112,
        ';', 114,
        '=', 119,
        '@', 124,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(38);
      if (lookahead == '{') ADVANCE(110);
      if (lookahead == '|') ADVANCE(92);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(11);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        0x04, 252,
        '#', 248,
        '$', 117,
        '%', 224,
        '(', 127,
        ')', 126,
        ',', 125,
        '-', 185,
        '/', 80,
        ':', 112,
        ';', 114,
        '=', 119,
        '>', 86,
        '@', 124,
        '[', 254,
      );
      if (lookahead == '\\') SKIP(38);
      if (lookahead == '{') ADVANCE(255);
      if (lookahead == '|') ADVANCE(92);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(11);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(3);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(3);
      if (lookahead == '\r') SKIP(13);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(4);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(4);
      if (lookahead == '\r') SKIP(15);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(6);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(6);
      if (lookahead == '\r') SKIP(17);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(52);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(52);
      if (lookahead == '\r') SKIP(19);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(53);
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(53);
      if (lookahead == '\r') SKIP(21);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(61);
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(61);
      if (lookahead == '\r') SKIP(23);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(54);
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(54);
      if (lookahead == '\r') SKIP(25);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(60);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(60);
      if (lookahead == '\r') SKIP(27);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(57);
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(57);
      if (lookahead == '\r') SKIP(29);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(62);
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(62);
      if (lookahead == '\r') SKIP(31);
      END_STATE();
    case 33:
      if (lookahead == '\n') SKIP(65);
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(65);
      if (lookahead == '\r') SKIP(33);
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(10);
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(10);
      if (lookahead == '\r') SKIP(35);
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(11);
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(11);
      if (lookahead == '\r') SKIP(37);
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(68);
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(68);
      if (lookahead == '\r') SKIP(39);
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(75);
      END_STATE();
    case 42:
      if (lookahead == '\n') SKIP(75);
      if (lookahead == '\r') SKIP(41);
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(69);
      END_STATE();
    case 44:
      if (lookahead == '\n') SKIP(69);
      if (lookahead == '\r') SKIP(43);
      END_STATE();
    case 45:
      if (lookahead == '\n') SKIP(76);
      END_STATE();
    case 46:
      if (lookahead == '\n') SKIP(76);
      if (lookahead == '\r') SKIP(45);
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(47);
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '\\') ADVANCE(289);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(290);
      if (lookahead != 0) ADVANCE(289);
      END_STATE();
    case 48:
      ADVANCE_MAP(
        '!', 215,
        '#', 248,
        '$', 118,
        '%', 224,
        '&', 178,
        '(', 127,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 187,
        '/', 190,
        '0', 408,
        ':', 113,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
        '[', 142,
        '\\', 219,
        '^', 176,
        'a', 332,
        'c', 294,
        'd', 343,
        'e', 373,
        'g', 313,
        'i', 370,
        'l', 303,
        'm', 260,
        'o', 366,
        'p', 344,
        'r', 316,
        's', 261,
        'u', 306,
        'x', 192,
        '{', 110,
        '|', 175,
        '}', 111,
        '~', 213,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 49:
      ADVANCE_MAP(
        '!', 214,
        '#', 248,
        '$', 118,
        '%', 224,
        '(', 127,
        ')', 126,
        '*', 188,
        '+', 180,
        ',', 125,
        '-', 183,
        '.', 98,
        '/', 79,
        '0', 408,
        ':', 113,
        ';', 114,
        '<', 148,
        '=', 85,
        '@', 124,
        '[', 142,
        '\\', 219,
        ']', 143,
        'a', 332,
        'c', 295,
        'd', 343,
        'e', 373,
        'g', 355,
        'l', 304,
        'm', 260,
        'o', 366,
        'p', 344,
        'r', 316,
        's', 261,
        'u', 306,
        '{', 110,
        '}', 111,
        '~', 212,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(49);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 50:
      ADVANCE_MAP(
        '!', 214,
        '#', 248,
        '$', 118,
        '%', 224,
        '(', 127,
        '*', 188,
        '+', 180,
        '-', 183,
        '.', 398,
        '/', 399,
        '0', 396,
        ':', 400,
        ';', 114,
        '<', 148,
        '@', 124,
        '[', 142,
        '\\', 219,
        '^', 403,
        'a', 332,
        'c', 293,
        'd', 343,
        'e', 373,
        'g', 355,
        'l', 304,
        'm', 260,
        'o', 366,
        'p', 344,
        'r', 315,
        's', 261,
        'u', 305,
        '{', 110,
        '}', 111,
        '~', 212,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(50);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(397);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(391);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      if (lookahead != 0) ADVANCE(390);
      END_STATE();
    case 51:
      ADVANCE_MAP(
        '!', 214,
        '#', 248,
        '$', 118,
        '%', 224,
        '(', 127,
        '*', 188,
        '+', 180,
        '-', 183,
        '.', 98,
        '/', 79,
        '0', 408,
        ':', 81,
        ';', 114,
        '<', 148,
        '@', 124,
        '[', 142,
        '\\', 219,
        'a', 332,
        'c', 295,
        'd', 343,
        'e', 373,
        'g', 355,
        'l', 304,
        'm', 260,
        'o', 366,
        'p', 344,
        'r', 316,
        's', 261,
        'u', 306,
        'v', 374,
        '{', 110,
        '~', 212,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(51);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 52:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '$', 117,
        '%', 224,
        '&', 178,
        '(', 127,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 113,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
      );
      if (lookahead == '\\') SKIP(20);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(339);
      if (lookahead == 'g') ADVANCE(314);
      if (lookahead == 'i') ADVANCE(370);
      if (lookahead == 'l') ADVANCE(317);
      if (lookahead == 'x') ADVANCE(192);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(52);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 53:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '$', 117,
        '%', 224,
        '&', 178,
        '(', 127,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(22);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'x') ADVANCE(194);
      if (lookahead == '{') ADVANCE(110);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(53);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 54:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '$', 117,
        '%', 224,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(26);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'x') ADVANCE(194);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(54);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 55:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '$', 117,
        '%', 224,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(26);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(288);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'x') ADVANCE(194);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'd' ||
          lookahead == 'r' ||
          lookahead == 's') ADVANCE(288);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(54);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 56:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '$', 117,
        '%', 224,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
      );
      if (lookahead == '\\') SKIP(30);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(271);
      if (lookahead == 'l') ADVANCE(272);
      if (lookahead == 'x') ADVANCE(272);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'a' ||
          lookahead == 'd' ||
          lookahead == 'm' ||
          lookahead == 'n' ||
          lookahead == 'p' ||
          lookahead == 's' ||
          lookahead == 'u') ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(57);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 57:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '$', 117,
        '%', 224,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
      );
      if (lookahead == '\\') SKIP(30);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'x') ADVANCE(194);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(57);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 58:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '$', 117,
        '%', 224,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
      );
      if (lookahead == '\\') SKIP(30);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(275);
      if (lookahead == 'g') ADVANCE(279);
      if (lookahead == 'i') ADVANCE(278);
      if (lookahead == 'l') ADVANCE(279);
      if (lookahead == 'x') ADVANCE(279);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'a' ||
          lookahead == 'd' ||
          lookahead == 'm' ||
          lookahead == 'n' ||
          lookahead == 'p' ||
          lookahead == 's' ||
          lookahead == 'u') ADVANCE(279);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(57);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 59:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '$', 117,
        '%', 224,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
      );
      if (lookahead == '\\') SKIP(30);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(282);
      if (lookahead == 'g') ADVANCE(281);
      if (lookahead == 'i') ADVANCE(286);
      if (lookahead == 'l') ADVANCE(281);
      if (lookahead == 'x') ADVANCE(287);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'a' ||
          lookahead == 'd' ||
          lookahead == 'e' ||
          lookahead == 'm' ||
          lookahead == 'o' ||
          lookahead == 'p' ||
          lookahead == 'r' ||
          lookahead == 's' ||
          lookahead == 'u') ADVANCE(287);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(57);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 60:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        '(', 127,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(28);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'x') ADVANCE(194);
      if (lookahead == '{') ADVANCE(110);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(60);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 61:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 113,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
      );
      if (lookahead == '\\') SKIP(24);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(339);
      if (lookahead == 'g') ADVANCE(314);
      if (lookahead == 'i') ADVANCE(370);
      if (lookahead == 'l') ADVANCE(317);
      if (lookahead == 'x') ADVANCE(192);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(61);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 62:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(32);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'x') ADVANCE(194);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(62);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 63:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(32);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(288);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'x') ADVANCE(194);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'd' ||
          lookahead == 'r' ||
          lookahead == 's') ADVANCE(288);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(62);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 64:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
      );
      if (lookahead == '\\') SKIP(34);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(271);
      if (lookahead == 'l') ADVANCE(272);
      if (lookahead == 'x') ADVANCE(272);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'a' ||
          lookahead == 'd' ||
          lookahead == 'm' ||
          lookahead == 'n' ||
          lookahead == 'p' ||
          lookahead == 's' ||
          lookahead == 'u') ADVANCE(272);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(65);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 65:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
      );
      if (lookahead == '\\') SKIP(34);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'g') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == 'l') ADVANCE(379);
      if (lookahead == 'x') ADVANCE(194);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(65);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 66:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
      );
      if (lookahead == '\\') SKIP(34);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(275);
      if (lookahead == 'g') ADVANCE(279);
      if (lookahead == 'i') ADVANCE(278);
      if (lookahead == 'l') ADVANCE(279);
      if (lookahead == 'x') ADVANCE(279);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'a' ||
          lookahead == 'd' ||
          lookahead == 'm' ||
          lookahead == 'n' ||
          lookahead == 'p' ||
          lookahead == 's' ||
          lookahead == 'u') ADVANCE(279);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(65);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 67:
      ADVANCE_MAP(
        '!', 82,
        '#', 248,
        '%', 146,
        '&', 178,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 112,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
      );
      if (lookahead == '\\') SKIP(34);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'c') ADVANCE(282);
      if (lookahead == 'g') ADVANCE(281);
      if (lookahead == 'i') ADVANCE(286);
      if (lookahead == 'l') ADVANCE(281);
      if (lookahead == 'x') ADVANCE(287);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (lookahead == 'a' ||
          lookahead == 'd' ||
          lookahead == 'e' ||
          lookahead == 'm' ||
          lookahead == 'o' ||
          lookahead == 'p' ||
          lookahead == 'r' ||
          lookahead == 's' ||
          lookahead == 'u') ADVANCE(287);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(65);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 68:
      ADVANCE_MAP(
        '#', 248,
        '$', 117,
        '%', 145,
        '&', 177,
        '(', 127,
        '*', 188,
        ':', 113,
        ';', 114,
        '@', 124,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(40);
      if (lookahead == '{') ADVANCE(110);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(68);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 69:
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '(') ADVANCE(127);
      if (lookahead == '\\') SKIP(44);
      if (lookahead == 'o') ADVANCE(388);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(69);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 70:
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == ':') ADVANCE(400);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(110);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(70);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(392);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      if (lookahead != 0) ADVANCE(390);
      END_STATE();
    case 71:
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == ':') ADVANCE(400);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(110);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(71);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(393);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      if (lookahead != 0) ADVANCE(390);
      END_STATE();
    case 72:
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == ':') ADVANCE(400);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(110);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(72);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      if (lookahead != 0) ADVANCE(390);
      END_STATE();
    case 73:
      ADVANCE_MAP(
        '#', 248,
        '$', 117,
        ':', 400,
        '\\', 256,
        '^', 258,
        '{', 110,
        '\'', 390,
        '+', 390,
        '-', 390,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(257);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(259);
      if (lookahead != 0) ADVANCE(256);
      END_STATE();
    case 74:
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '^') ADVANCE(405);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(74);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(395);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      if (lookahead != 0) ADVANCE(390);
      END_STATE();
    case 75:
      ADVANCE_MAP(
        '#', 248,
        ')', 126,
        ',', 125,
        '.', 98,
        '0', 408,
        ':', 112,
        ';', 114,
        '=', 85,
      );
      if (lookahead == '\\') SKIP(42);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == 'a') ADVANCE(88);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == 'v') ADVANCE(100);
      if (lookahead == 'x') ADVANCE(89);
      if (lookahead == '{') ADVANCE(110);
      if (lookahead == '}') ADVANCE(111);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(75);
      END_STATE();
    case 76:
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '.') ADVANCE(98);
      if (lookahead == '0') ADVANCE(408);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == '\\') SKIP(46);
      if (lookahead == 'v') ADVANCE(374);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(76);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 77:
      if (lookahead == '.') ADVANCE(130);
      END_STATE();
    case 78:
      if (lookahead == '.') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(414);
      END_STATE();
    case 79:
      if (lookahead == '/') ADVANCE(171);
      END_STATE();
    case 80:
      if (lookahead == '/') ADVANCE(83);
      END_STATE();
    case 81:
      if (lookahead == ':') ADVANCE(407);
      END_STATE();
    case 82:
      if (lookahead == '=') ADVANCE(198);
      if (lookahead == '~') ADVANCE(196);
      END_STATE();
    case 83:
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 84:
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 85:
      if (lookahead == '>') ADVANCE(227);
      END_STATE();
    case 86:
      if (lookahead == '>') ADVANCE(153);
      END_STATE();
    case 87:
      if (lookahead == 'd') ADVANCE(132);
      END_STATE();
    case 88:
      if (lookahead == 'n') ADVANCE(87);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(91);
      END_STATE();
    case 90:
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 91:
      if (lookahead == 'r') ADVANCE(139);
      END_STATE();
    case 92:
      if (lookahead == '|') ADVANCE(84);
      END_STATE();
    case 93:
      if (lookahead == '~') ADVANCE(203);
      END_STATE();
    case 94:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(410);
      END_STATE();
    case 95:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(411);
      END_STATE();
    case 96:
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(410);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(413);
      END_STATE();
    case 97:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(409);
      END_STATE();
    case 98:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(414);
      END_STATE();
    case 99:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(410);
      END_STATE();
    case 100:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(291);
      END_STATE();
    case 101:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(412);
      END_STATE();
    case 102:
      if (eof) ADVANCE(109);
      ADVANCE_MAP(
        0x04, 252,
        '!', 215,
        '#', 248,
        '$', 118,
        '%', 224,
        '&', 178,
        '(', 127,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 187,
        '/', 190,
        '0', 408,
        ':', 113,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
        '[', 142,
        '\\', 219,
        ']', 143,
        '^', 176,
        'a', 331,
        'c', 292,
        'd', 343,
        'e', 334,
        'g', 313,
        'i', 370,
        'l', 303,
        'm', 260,
        'o', 356,
        'p', 344,
        'r', 315,
        's', 261,
        'u', 305,
        'v', 374,
        'x', 191,
        '{', 110,
        '|', 175,
        '}', 111,
        '~', 213,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(102);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 103:
      if (eof) ADVANCE(109);
      ADVANCE_MAP(
        0x04, 252,
        '!', 215,
        '#', 248,
        '$', 118,
        '%', 224,
        '&', 178,
        '(', 127,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 187,
        '/', 190,
        '0', 408,
        ':', 81,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
        '[', 142,
        '\\', 219,
        '^', 176,
        'a', 331,
        'c', 292,
        'd', 343,
        'e', 373,
        'g', 313,
        'i', 370,
        'l', 303,
        'm', 260,
        'o', 356,
        'p', 344,
        'r', 315,
        's', 261,
        'u', 305,
        'x', 191,
        '{', 110,
        '|', 175,
        '}', 111,
        '~', 213,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(103);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 104:
      if (eof) ADVANCE(109);
      ADVANCE_MAP(
        0x04, 252,
        '!', 214,
        '#', 248,
        '$', 118,
        '%', 224,
        '(', 127,
        '*', 188,
        '+', 180,
        '-', 183,
        '.', 78,
        '/', 79,
        '0', 408,
        ':', 81,
        ';', 114,
        '<', 148,
        '@', 124,
        '[', 142,
        '\\', 219,
        'a', 332,
        'c', 293,
        'd', 343,
        'e', 334,
        'g', 355,
        'l', 304,
        'm', 260,
        'o', 366,
        'p', 344,
        'r', 315,
        's', 261,
        'u', 305,
        '{', 110,
        '}', 111,
        '~', 212,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(104);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 105:
      if (eof) ADVANCE(109);
      ADVANCE_MAP(
        0x04, 252,
        '!', 214,
        '#', 248,
        '$', 118,
        '%', 224,
        '(', 127,
        '*', 188,
        '+', 180,
        '-', 183,
        '.', 78,
        '/', 79,
        '0', 408,
        ':', 81,
        ';', 114,
        '<', 148,
        '@', 124,
        '[', 142,
        '\\', 219,
        'a', 332,
        'c', 293,
        'd', 343,
        'e', 373,
        'g', 355,
        'l', 304,
        'm', 260,
        'o', 366,
        'p', 344,
        'r', 315,
        's', 261,
        'u', 305,
        '{', 110,
        '}', 111,
        '~', 212,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(409);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(105);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 106:
      if (eof) ADVANCE(109);
      ADVANCE_MAP(
        0x04, 252,
        '!', 82,
        '#', 248,
        '$', 117,
        '%', 146,
        '&', 178,
        '(', 127,
        ')', 126,
        '*', 189,
        '+', 181,
        ',', 125,
        '-', 184,
        '.', 186,
        '/', 190,
        ':', 113,
        ';', 114,
        '<', 147,
        '=', 120,
        '>', 150,
        '?', 218,
        '@', 124,
        '[', 142,
      );
      if (lookahead == '\\') SKIP(108);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == 'a') ADVANCE(342);
      if (lookahead == 'c') ADVANCE(339);
      if (lookahead == 'g') ADVANCE(314);
      if (lookahead == 'i') ADVANCE(370);
      if (lookahead == 'l') ADVANCE(317);
      if (lookahead == 'o') ADVANCE(365);
      if (lookahead == 'x') ADVANCE(191);
      if (lookahead == '{') ADVANCE(110);
      if (lookahead == '|') ADVANCE(175);
      if (lookahead == '}') ADVANCE(111);
      if (lookahead == '~') ADVANCE(93);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(106);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      END_STATE();
    case 107:
      if (eof) ADVANCE(109);
      if (lookahead == '\n') SKIP(106);
      END_STATE();
    case 108:
      if (eof) ADVANCE(109);
      if (lookahead == '\n') SKIP(106);
      if (lookahead == '\r') SKIP(107);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(407);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_class);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_role);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '#') ADVANCE(225);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(197);
      if (lookahead == '>') ADVANCE(227);
      if (lookahead == '~') ADVANCE(195);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(227);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_our);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_our);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_and);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'd') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_or);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_xor);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_xor);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_xor);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(160);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(152);
      if (lookahead == '=') ADVANCE(204);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(151);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(205);
      if (lookahead == '>') ADVANCE(179);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(165);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_DOT_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_x_EQ);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(130);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(154);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_CARET_CARET);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(167);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(163);
      if (lookahead == '|') ADVANCE(170);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(164);
      if (lookahead == '^') ADVANCE(173);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(174);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_GT_GT2);
      if (lookahead == '=') ADVANCE(166);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(216);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(216);
      if (lookahead == '=') ADVANCE(155);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(217);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '=') ADVANCE(156);
      if (lookahead == '>') ADVANCE(144);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(253);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(168);
      if (lookahead == '=') ADVANCE(157);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(168);
      if (lookahead == '=') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(414);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(169);
      if (lookahead == '=') ADVANCE(158);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '=') ADVANCE(159);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_x);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == '=') ADVANCE(161);
      if (lookahead == 'o') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_x);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == '=') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_x);
      if (lookahead == '=') ADVANCE(161);
      if (lookahead == 'o') ADVANCE(385);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_x);
      if (lookahead == '=') ADVANCE(161);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_BANG_TILDE);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(199);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_cmp);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_cmp);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_TILDE_TILDE);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(200);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_le);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_le);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_ge);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_ge);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_isa);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_isa);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '~') ADVANCE(203);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(198);
      if (lookahead == '~') ADVANCE(196);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_local);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_map);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_grep);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_PERCENT2);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_DOLLAR_POUND);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(aux_sym__var_indirob_autoquote_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(226);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_use);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_redo);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_alarm);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_close);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'd') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_closedir);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_caller);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_cos);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_exp);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_lc);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_log);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_ord);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_pop);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_pos);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_rmdir);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_readdir);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_readpipe);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_scalar);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_sin);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_sleep);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_uc);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(248);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(aux_sym___DATA___token1);
      if (lookahead == '\r') ADVANCE(251);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(251);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(aux_sym___DATA___token1);
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '\\') ADVANCE(249);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n') ADVANCE(250);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(251);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(aux_sym___DATA___token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(251);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_EOT);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_DASH_GT2);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_LBRACK2);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_LBRACE2);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(aux_sym__interpolation_fallbacks_token1);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(aux_sym__interpolation_fallbacks_token1);
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '\\') ADVANCE(256);
      if (lookahead == '^') ADVANCE(258);
      if (lookahead == '{') ADVANCE(110);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(257);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(257);
      if ((set_contains(sym__identifier_character_set_1, 668, lookahead)) &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(259);
      if ((!eof && set_contains(aux_sym__interpolation_fallbacks_token1_character_set_1, 9, lookahead))) ADVANCE(256);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(aux_sym__interpolation_fallbacks_token1);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '^' ||
          lookahead == '_' ||
          lookahead == '|') ADVANCE(390);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(aux_sym__interpolation_fallbacks_token1);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_m);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_s);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(298);
      if (lookahead == 'i') ADVANCE(341);
      if (lookahead == 'l') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      if (lookahead == 'a') ADVANCE(272);
      if (lookahead == 'd' ||
          lookahead == 'i' ||
          ('l' <= lookahead && lookahead <= 'n') ||
          lookahead == 'p' ||
          lookahead == 's' ||
          lookahead == 'u' ||
          lookahead == 'x') ADVANCE(272);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      if (lookahead == 'a') ADVANCE(269);
      if (lookahead == 'd' ||
          lookahead == 'i' ||
          ('l' <= lookahead && lookahead <= 'n') ||
          lookahead == 'p' ||
          lookahead == 's' ||
          lookahead == 'u' ||
          lookahead == 'x') ADVANCE(272);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      if (lookahead == 'd') ADVANCE(272);
      if (lookahead == 'a' ||
          lookahead == 'i' ||
          ('l' <= lookahead && lookahead <= 'n') ||
          lookahead == 'p' ||
          lookahead == 's' ||
          lookahead == 'u' ||
          lookahead == 'x') ADVANCE(272);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      ADVANCE_MAP(
        'i', 267,
        'l', 272,
        'a', 272,
        'd', 272,
        'm', 272,
        'n', 272,
        'p', 272,
        's', 272,
        'u', 272,
        'x', 272,
      );
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      ADVANCE_MAP(
        'l', 262,
        'n', 264,
        'a', 272,
        'd', 272,
        'i', 272,
        'm', 272,
        'p', 272,
        's', 272,
        'u', 272,
        'x', 272,
      );
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      ADVANCE_MAP(
        'n', 272,
        'a', 272,
        'd', 272,
        'i', 272,
        'l', 272,
        'm', 272,
        'p', 272,
        's', 272,
        'u', 272,
        'x', 272,
      );
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      ADVANCE_MAP(
        'n', 264,
        'a', 272,
        'd', 272,
        'i', 272,
        'l', 272,
        'm', 272,
        'p', 272,
        's', 272,
        'u', 272,
        'x', 272,
      );
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      if (lookahead == 'p') ADVANCE(272);
      if (lookahead == 'a' ||
          lookahead == 'd' ||
          lookahead == 'i' ||
          ('l' <= lookahead && lookahead <= 'n') ||
          lookahead == 's' ||
          lookahead == 'u' ||
          lookahead == 'x') ADVANCE(272);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      if (lookahead == 's') ADVANCE(272);
      if (lookahead == 'a' ||
          lookahead == 'd' ||
          lookahead == 'i' ||
          ('l' <= lookahead && lookahead <= 'n') ||
          lookahead == 'p' ||
          lookahead == 'u' ||
          lookahead == 'x') ADVANCE(272);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      if (lookahead == 's') ADVANCE(262);
      if (lookahead == 'a' ||
          lookahead == 'd' ||
          lookahead == 'i' ||
          ('l' <= lookahead && lookahead <= 'n') ||
          lookahead == 'p' ||
          lookahead == 'u' ||
          lookahead == 'x') ADVANCE(272);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_quoted_regexp_modifiers);
      if ((set_contains(sym_match_regexp_modifiers_character_set_1, 9, lookahead)) &&
          lookahead != 'c' &&
          lookahead != 'g') ADVANCE(272);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_match_regexp_modifiers);
      if (lookahead == 'a') ADVANCE(279);
      if (set_contains(sym_match_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(279);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_match_regexp_modifiers);
      if (lookahead == 'd') ADVANCE(279);
      if (set_contains(sym_match_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(279);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_match_regexp_modifiers);
      ADVANCE_MAP(
        'm', 277,
        'a', 279,
        'c', 279,
        'd', 279,
        'g', 279,
        'i', 279,
        'l', 279,
        'n', 279,
        'p', 279,
        's', 279,
        'u', 279,
        'x', 279,
      );
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_match_regexp_modifiers);
      ADVANCE_MAP(
        'n', 274,
        'a', 279,
        'c', 279,
        'd', 279,
        'g', 279,
        'i', 279,
        'l', 279,
        'm', 279,
        'p', 279,
        's', 279,
        'u', 279,
        'x', 279,
      );
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_match_regexp_modifiers);
      if (lookahead == 'p') ADVANCE(279);
      if (set_contains(sym_match_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(279);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_match_regexp_modifiers);
      if (lookahead == 's') ADVANCE(273);
      if (set_contains(sym_match_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(279);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_match_regexp_modifiers);
      if (set_contains(sym_match_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(279);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_substitution_regexp_modifiers);
      if (lookahead == 'a') ADVANCE(287);
      if (set_contains(sym_substitution_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(287);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_substitution_regexp_modifiers);
      ADVANCE_MAP(
        'e', 287,
        'a', 287,
        'c', 287,
        'd', 287,
        'g', 287,
        'i', 287,
        'l', 287,
        'm', 287,
        'o', 287,
        'p', 287,
        'r', 287,
        's', 287,
        'u', 287,
        'x', 287,
      );
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_substitution_regexp_modifiers);
      if (lookahead == 'm') ADVANCE(284);
      if (set_contains(sym_substitution_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(287);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_substitution_regexp_modifiers);
      if (lookahead == 'o') ADVANCE(285);
      if (set_contains(sym_substitution_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(287);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_substitution_regexp_modifiers);
      if (lookahead == 'p') ADVANCE(287);
      if (set_contains(sym_substitution_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(287);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_substitution_regexp_modifiers);
      if (lookahead == 'r') ADVANCE(287);
      if (set_contains(sym_substitution_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(287);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_substitution_regexp_modifiers);
      if (lookahead == 's') ADVANCE(280);
      if (set_contains(sym_substitution_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(287);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_substitution_regexp_modifiers);
      if (set_contains(sym_substitution_regexp_modifiers_character_set_1, 9, lookahead)) ADVANCE(287);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_transliteration_modifiers);
      if (lookahead == 'c' ||
          lookahead == 'd' ||
          lookahead == 'r' ||
          lookahead == 's') ADVANCE(288);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(aux_sym__interpolated_transliteration_content_token1);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(aux_sym__interpolated_transliteration_content_token1);
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '\\') ADVANCE(289);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n') ADVANCE(290);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(289);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_version);
      if (lookahead == '.') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(291);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(338);
      if (lookahead == 'l') ADVANCE(300);
      if (lookahead == 'm') ADVANCE(348);
      if (lookahead == 'o') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(338);
      if (lookahead == 'l') ADVANCE(300);
      if (lookahead == 'o') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(338);
      if (lookahead == 'l') ADVANCE(347);
      if (lookahead == 'm') ADVANCE(348);
      if (lookahead == 'o') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(338);
      if (lookahead == 'l') ADVANCE(347);
      if (lookahead == 'o') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(310);
      if (lookahead == 'd') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(371);
      if (lookahead == 'o') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(360);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'a') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(236);
      if (lookahead == 'e') ADVANCE(206);
      if (lookahead == 'o') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(236);
      if (lookahead == 'o') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(247);
      if (lookahead == 's') ADVANCE(320);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'c') ADVANCE(299);
      if (lookahead == 'g') ADVANCE(237);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'd') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'd') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'd') ADVANCE(312);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'd') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'd') ADVANCE(329);
      if (lookahead == 'p') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(208);
      if (lookahead == 'r') ADVANCE(323);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(297);
      if (lookahead == 'm') ADVANCE(309);
      if (lookahead == 'o') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(297);
      if (lookahead == 'm') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(116);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(353);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'e') ADVANCE(324);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'i') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'i') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'i') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'i') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'l') ADVANCE(301);
      if (lookahead == 'n') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'l') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'l') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'l') ADVANCE(369);
      if (lookahead == 'x') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'l') ADVANCE(319);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'l') ADVANCE(325);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'l') ADVANCE(302);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'l') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'm') ADVANCE(348);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'm') ADVANCE(230);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'n') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'n') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'o') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'o') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'o') ADVANCE(229);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'o') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'o') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'p') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'p') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'p') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'p') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'p') ADVANCE(239);
      if (lookahead == 's') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'p') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'p') ADVANCE(322);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(323);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(136);
      if (lookahead == 'u') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(232);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(308);
      if (lookahead == 'u') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 's') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 's') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 's') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 's') ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 's') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 's') ADVANCE(321);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (lookahead == 'x') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(291);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(211);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'd') ADVANCE(134);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(209);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(207);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(383);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(377);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(385);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(202);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(138);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(141);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(129);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(376);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(386);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym__identifier);
      if (set_contains(sym__identifier_character_set_2, 776, lookahead)) ADVANCE(389);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      ADVANCE_MAP(
        '!', 214,
        '#', 248,
        '$', 118,
        '%', 224,
        '(', 127,
        '*', 188,
        '+', 180,
        '-', 183,
        '.', 398,
        '/', 399,
        '0', 396,
        ':', 400,
        ';', 114,
        '<', 148,
        '@', 124,
        '[', 142,
        '\\', 219,
        '^', 403,
        'a', 332,
        'c', 293,
        'd', 343,
        'e', 373,
        'g', 355,
        'l', 304,
        'm', 260,
        'o', 366,
        'p', 344,
        'r', 315,
        's', 261,
        'u', 305,
        '{', 110,
        '}', 111,
        '~', 212,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(397);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(391);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '!') ADVANCE(390);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == ':') ADVANCE(400);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(392);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(390);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == ':') ADVANCE(400);
      if (lookahead == '>') ADVANCE(149);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(393);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(390);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == ':') ADVANCE(400);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(375);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(390);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '#') ADVANCE(248);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '^') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(395);
      if (set_contains(sym__identifier_character_set_1, 668, lookahead)) ADVANCE(389);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(390);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      ADVANCE_MAP(
        '.', 415,
        '_', 99,
        'B', 95,
        'b', 95,
        'E', 94,
        'e', 94,
        'X', 101,
        'x', 101,
        '8', 401,
        '9', 401,
      );
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(402);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '.') ADVANCE(415);
      if (lookahead == '_') ADVANCE(97);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(397);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '.') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(414);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '/') ADVANCE(171);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == ':') ADVANCE(407);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '_') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '_') ADVANCE(96);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(402);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|') ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(226);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(aux_sym__ident_special_token1);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '^' ||
          lookahead == '_' ||
          lookahead == '|') ADVANCE(390);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(aux_sym__bareword_token1);
      if (lookahead == ':') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(406);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(aux_sym__bareword_token1);
      if (lookahead == ':') ADVANCE(81);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(406);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 415,
        '_', 99,
        'B', 95,
        'b', 95,
        'E', 94,
        'e', 94,
        'X', 101,
        'x', 101,
        '8', 410,
        '9', 410,
      );
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(413);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(415);
      if (lookahead == '_') ADVANCE(97);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(409);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(410);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(95);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(411);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(412);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(96);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(410);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(413);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(98);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(414);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(414);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'A') ADVANCE(1);
      if (lookahead == 'B') ADVANCE(2);
      if (lookahead == 'C') ADVANCE(3);
      if (lookahead == 'E') ADVANCE(4);
      if (lookahead == 'I') ADVANCE(5);
      if (lookahead == 'U') ADVANCE(6);
      if (lookahead == '\\') SKIP(7);
      if (lookahead == '_') ADVANCE(8);
      if (lookahead == 'a') ADVANCE(9);
      if (lookahead == 'b') ADVANCE(10);
      if (lookahead == 'c') ADVANCE(11);
      if (lookahead == 'd') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'f') ADVANCE(14);
      if (lookahead == 'g') ADVANCE(15);
      if (lookahead == 'h') ADVANCE(16);
      if (lookahead == 'i') ADVANCE(17);
      if (lookahead == 'k') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(19);
      if (lookahead == 'm') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 'o') ADVANCE(22);
      if (lookahead == 'p') ADVANCE(23);
      if (lookahead == 'q') ADVANCE(24);
      if (lookahead == 'r') ADVANCE(25);
      if (lookahead == 's') ADVANCE(26);
      if (lookahead == 't') ADVANCE(27);
      if (lookahead == 'u') ADVANCE(28);
      if (lookahead == 'v') ADVANCE(29);
      if (lookahead == 'w') ADVANCE(30);
      if (lookahead == 'y') ADVANCE(31);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'D') ADVANCE(32);
      END_STATE();
    case 2:
      if (lookahead == 'E') ADVANCE(33);
      if (lookahead == 'U') ADVANCE(34);
      END_STATE();
    case 3:
      if (lookahead == 'H') ADVANCE(35);
      END_STATE();
    case 4:
      if (lookahead == 'N') ADVANCE(36);
      END_STATE();
    case 5:
      if (lookahead == 'N') ADVANCE(37);
      END_STATE();
    case 6:
      if (lookahead == 'N') ADVANCE(38);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(0);
      if (lookahead == '\r') SKIP(39);
      END_STATE();
    case 8:
      if (lookahead == '_') ADVANCE(40);
      END_STATE();
    case 9:
      if (lookahead == 'b') ADVANCE(41);
      if (lookahead == 's') ADVANCE(42);
      if (lookahead == 'w') ADVANCE(43);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(44);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(45);
      if (lookahead == 'h') ADVANCE(46);
      if (lookahead == 'o') ADVANCE(47);
      END_STATE();
    case 12:
      if (lookahead == 'b') ADVANCE(48);
      if (lookahead == 'e') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(51);
      if (lookahead == 'l') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      if (lookahead == 'q') ADVANCE(54);
      if (lookahead == 'v') ADVANCE(55);
      if (lookahead == 'x') ADVANCE(56);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(57);
      if (lookahead == 'c') ADVANCE(58);
      if (lookahead == 'i') ADVANCE(59);
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == 'm') ADVANCE(62);
      if (lookahead == 'o') ADVANCE(63);
      if (lookahead == 't') ADVANCE(64);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 17:
      if (lookahead == 'f') ADVANCE(66);
      if (lookahead == 'n') ADVANCE(67);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(69);
      if (lookahead == 'c') ADVANCE(70);
      if (lookahead == 'e') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(72);
      if (lookahead == 's') ADVANCE(73);
      if (lookahead == 't') ADVANCE(74);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(75);
      if (lookahead == 'y') ADVANCE(76);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 22:
      if (lookahead == 'c') ADVANCE(79);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(80);
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_q);
      if (lookahead == 'q') ADVANCE(82);
      if (lookahead == 'r') ADVANCE(83);
      if (lookahead == 'u') ADVANCE(84);
      if (lookahead == 'w') ADVANCE(85);
      if (lookahead == 'x') ADVANCE(86);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 26:
      if (lookahead == 'h') ADVANCE(89);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == 'q') ADVANCE(91);
      if (lookahead == 'r') ADVANCE(92);
      if (lookahead == 't') ADVANCE(93);
      if (lookahead == 'u') ADVANCE(94);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(95);
      if (lookahead == 'i') ADVANCE(96);
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(98);
      if (lookahead == 'm') ADVANCE(99);
      if (lookahead == 'n') ADVANCE(100);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(102);
      if (lookahead == 'h') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_y);
      END_STATE();
    case 32:
      if (lookahead == 'J') ADVANCE(105);
      END_STATE();
    case 33:
      if (lookahead == 'G') ADVANCE(106);
      END_STATE();
    case 34:
      if (lookahead == 'I') ADVANCE(107);
      END_STATE();
    case 35:
      if (lookahead == 'E') ADVANCE(108);
      END_STATE();
    case 36:
      if (lookahead == 'D') ADVANCE(109);
      END_STATE();
    case 37:
      if (lookahead == 'I') ADVANCE(110);
      END_STATE();
    case 38:
      if (lookahead == 'I') ADVANCE(111);
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(0);
      END_STATE();
    case 40:
      if (lookahead == 'D') ADVANCE(112);
      if (lookahead == 'E') ADVANCE(113);
      if (lookahead == 'F') ADVANCE(114);
      if (lookahead == 'L') ADVANCE(115);
      if (lookahead == 'P') ADVANCE(116);
      if (lookahead == 'S') ADVANCE(117);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(118);
      END_STATE();
    case 42:
      if (lookahead == 'y') ADVANCE(119);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 46:
      if (lookahead == 'd') ADVANCE(123);
      if (lookahead == 'o') ADVANCE(124);
      if (lookahead == 'r') ADVANCE(125);
      END_STATE();
    case 47:
      if (lookahead == 'n') ADVANCE(126);
      END_STATE();
    case 48:
      if (lookahead == 'm') ADVANCE(127);
      END_STATE();
    case 49:
      if (lookahead == 'f') ADVANCE(128);
      if (lookahead == 'l') ADVANCE(129);
      END_STATE();
    case 50:
      if (lookahead == 'n') ADVANCE(130);
      END_STATE();
    case 51:
      if (lookahead == 'c') ADVANCE(131);
      END_STATE();
    case 52:
      if (lookahead == 's') ADVANCE(132);
      END_STATE();
    case 53:
      if (lookahead == 'f') ADVANCE(133);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_eq);
      if (lookahead == 'r') ADVANCE(134);
      if (lookahead == 'u') ADVANCE(135);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(136);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(137);
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_fc);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(140);
      if (lookahead == 'l') ADVANCE(141);
      if (lookahead == 'n') ADVANCE(142);
      END_STATE();
    case 60:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_gt);
      END_STATE();
    case 65:
      if (lookahead == 'x') ADVANCE(147);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 68:
      if (lookahead == 'y') ADVANCE(149);
      END_STATE();
    case 69:
      if (lookahead == 's') ADVANCE(150);
      END_STATE();
    case 70:
      if (lookahead == 'f') ADVANCE(151);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(152);
      END_STATE();
    case 72:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(154);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_lt);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(155);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_my);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_ne);
      if (lookahead == 'x') ADVANCE(156);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_no);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(158);
      END_STATE();
    case 81:
      if (lookahead == 'o') ADVANCE(159);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_qq);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_qr);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(160);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_qw);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_qx);
      END_STATE();
    case 87:
      if (lookahead == 'n') ADVANCE(161);
      END_STATE();
    case 88:
      if (lookahead == 'a') ADVANCE(162);
      if (lookahead == 'f') ADVANCE(163);
      if (lookahead == 'q') ADVANCE(164);
      if (lookahead == 's') ADVANCE(165);
      if (lookahead == 't') ADVANCE(166);
      if (lookahead == 'w') ADVANCE(167);
      END_STATE();
    case 89:
      if (lookahead == 'i') ADVANCE(168);
      END_STATE();
    case 90:
      if (lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 91:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(171);
      END_STATE();
    case 93:
      if (lookahead == 'a') ADVANCE(172);
      if (lookahead == 'u') ADVANCE(173);
      END_STATE();
    case 94:
      if (lookahead == 'b') ADVANCE(174);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(175);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(176);
      if (lookahead == 'm') ADVANCE(177);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_tr);
      if (lookahead == 'u') ADVANCE(178);
      if (lookahead == 'y') ADVANCE(179);
      END_STATE();
    case 98:
      if (lookahead == 'f') ADVANCE(180);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(181);
      END_STATE();
    case 100:
      if (lookahead == 'd') ADVANCE(182);
      if (lookahead == 'l') ADVANCE(183);
      if (lookahead == 't') ADVANCE(184);
      END_STATE();
    case 101:
      if (lookahead == 'l') ADVANCE(185);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(186);
      if (lookahead == 'n') ADVANCE(187);
      END_STATE();
    case 103:
      if (lookahead == 'i') ADVANCE(188);
      END_STATE();
    case 104:
      if (lookahead == 'i') ADVANCE(189);
      END_STATE();
    case 105:
      if (lookahead == 'U') ADVANCE(190);
      END_STATE();
    case 106:
      if (lookahead == 'I') ADVANCE(191);
      END_STATE();
    case 107:
      if (lookahead == 'L') ADVANCE(192);
      END_STATE();
    case 108:
      if (lookahead == 'C') ADVANCE(193);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_END);
      END_STATE();
    case 110:
      if (lookahead == 'T') ADVANCE(194);
      END_STATE();
    case 111:
      if (lookahead == 'T') ADVANCE(195);
      END_STATE();
    case 112:
      if (lookahead == 'A') ADVANCE(196);
      END_STATE();
    case 113:
      if (lookahead == 'N') ADVANCE(197);
      END_STATE();
    case 114:
      if (lookahead == 'I') ADVANCE(198);
      END_STATE();
    case 115:
      if (lookahead == 'I') ADVANCE(199);
      END_STATE();
    case 116:
      if (lookahead == 'A') ADVANCE(200);
      END_STATE();
    case 117:
      if (lookahead == 'U') ADVANCE(201);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_abs);
      END_STATE();
    case 119:
      if (lookahead == 'n') ADVANCE(202);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(203);
      END_STATE();
    case 121:
      if (lookahead == 'a') ADVANCE(204);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(205);
      END_STATE();
    case 123:
      if (lookahead == 'i') ADVANCE(206);
      END_STATE();
    case 124:
      if (lookahead == 'm') ADVANCE(207);
      if (lookahead == 'p') ADVANCE(208);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_chr);
      if (lookahead == 'o') ADVANCE(209);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 127:
      if (lookahead == 'c') ADVANCE(211);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(212);
      if (lookahead == 'i') ADVANCE(213);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 130:
      if (lookahead == 'a') ADVANCE(215);
      END_STATE();
    case 131:
      if (lookahead == 'h') ADVANCE(216);
      END_STATE();
    case 132:
      if (lookahead == 'i') ADVANCE(217);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_eof);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_eqr);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_equ);
      END_STATE();
    case 136:
      if (lookahead == 'l') ADVANCE(218);
      END_STATE();
    case 137:
      if (lookahead == 's') ADVANCE(219);
      if (lookahead == 't') ADVANCE(220);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(221);
      END_STATE();
    case 139:
      if (lookahead == 's') ADVANCE(222);
      END_STATE();
    case 140:
      if (lookahead == 'l') ADVANCE(223);
      END_STATE();
    case 141:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(225);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == 'e') ADVANCE(226);
      if (lookahead == 'k') ADVANCE(227);
      END_STATE();
    case 144:
      if (lookahead == 'c') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(229);
      if (lookahead == 'n') ADVANCE(230);
      if (lookahead == 'p') ADVANCE(231);
      if (lookahead == 's') ADVANCE(232);
      END_STATE();
    case 145:
      if (lookahead == 'i') ADVANCE(233);
      END_STATE();
    case 146:
      if (lookahead == 'o') ADVANCE(234);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_hex);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(235);
      END_STATE();
    case 150:
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(237);
      END_STATE();
    case 152:
      if (lookahead == 'g') ADVANCE(238);
      END_STATE();
    case 153:
      if (lookahead == 'a') ADVANCE(239);
      if (lookahead == 'k') ADVANCE(240);
      END_STATE();
    case 154:
      if (lookahead == 'a') ADVANCE(241);
      END_STATE();
    case 155:
      if (lookahead == 'h') ADVANCE(242);
      END_STATE();
    case 156:
      if (lookahead == 't') ADVANCE(243);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_oct);
      END_STATE();
    case 158:
      if (lookahead == 'k') ADVANCE(244);
      END_STATE();
    case 159:
      if (lookahead == 't') ADVANCE(245);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(246);
      END_STATE();
    case 161:
      if (lookahead == 'd') ADVANCE(247);
      END_STATE();
    case 162:
      if (lookahead == 'd') ADVANCE(248);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_ref);
      END_STATE();
    case 164:
      if (lookahead == 'u') ADVANCE(249);
      END_STATE();
    case 165:
      if (lookahead == 'e') ADVANCE(250);
      END_STATE();
    case 166:
      if (lookahead == 'u') ADVANCE(251);
      END_STATE();
    case 167:
      if (lookahead == 'i') ADVANCE(252);
      END_STATE();
    case 168:
      if (lookahead == 'f') ADVANCE(253);
      END_STATE();
    case 169:
      if (lookahead == 't') ADVANCE(254);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(255);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(256);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 173:
      if (lookahead == 'd') ADVANCE(258);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_sub);
      END_STATE();
    case 175:
      if (lookahead == 'l') ADVANCE(259);
      END_STATE();
    case 176:
      if (lookahead == 'd') ADVANCE(260);
      END_STATE();
    case 177:
      if (lookahead == 'e') ADVANCE(261);
      END_STATE();
    case 178:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 180:
      if (lookahead == 'i') ADVANCE(263);
      END_STATE();
    case 181:
      if (lookahead == 's') ADVANCE(264);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(266);
      END_STATE();
    case 184:
      if (lookahead == 'i') ADVANCE(267);
      END_STATE();
    case 185:
      if (lookahead == 'u') ADVANCE(268);
      END_STATE();
    case 186:
      if (lookahead == 't') ADVANCE(269);
      END_STATE();
    case 187:
      if (lookahead == 't') ADVANCE(270);
      END_STATE();
    case 188:
      if (lookahead == 'l') ADVANCE(271);
      END_STATE();
    case 189:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 190:
      if (lookahead == 'S') ADVANCE(273);
      END_STATE();
    case 191:
      if (lookahead == 'N') ADVANCE(274);
      END_STATE();
    case 192:
      if (lookahead == 'D') ADVANCE(275);
      END_STATE();
    case 193:
      if (lookahead == 'K') ADVANCE(276);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_INIT);
      END_STATE();
    case 195:
      if (lookahead == 'C') ADVANCE(277);
      END_STATE();
    case 196:
      if (lookahead == 'T') ADVANCE(278);
      END_STATE();
    case 197:
      if (lookahead == 'D') ADVANCE(279);
      END_STATE();
    case 198:
      if (lookahead == 'L') ADVANCE(280);
      END_STATE();
    case 199:
      if (lookahead == 'N') ADVANCE(281);
      END_STATE();
    case 200:
      if (lookahead == 'C') ADVANCE(282);
      END_STATE();
    case 201:
      if (lookahead == 'B') ADVANCE(283);
      END_STATE();
    case 202:
      if (lookahead == 'c') ADVANCE(284);
      END_STATE();
    case 203:
      if (lookahead == 't') ADVANCE(285);
      END_STATE();
    case 204:
      if (lookahead == 'k') ADVANCE(286);
      END_STATE();
    case 205:
      if (lookahead == 'h') ADVANCE(287);
      END_STATE();
    case 206:
      if (lookahead == 'r') ADVANCE(288);
      END_STATE();
    case 207:
      if (lookahead == 'p') ADVANCE(289);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_chop);
      END_STATE();
    case 209:
      if (lookahead == 'o') ADVANCE(290);
      END_STATE();
    case 210:
      if (lookahead == 'i') ADVANCE(291);
      END_STATE();
    case 211:
      if (lookahead == 'l') ADVANCE(292);
      END_STATE();
    case 212:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 213:
      if (lookahead == 'n') ADVANCE(294);
      END_STATE();
    case 214:
      if (lookahead == 't') ADVANCE(295);
      END_STATE();
    case 215:
      if (lookahead == 'm') ADVANCE(296);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 217:
      if (lookahead == 'f') ADVANCE(297);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_eval);
      END_STATE();
    case 219:
      if (lookahead == 't') ADVANCE(298);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_exit);
      END_STATE();
    case 221:
      if (lookahead == 'n') ADVANCE(299);
      END_STATE();
    case 222:
      if (lookahead == 'e') ADVANCE(300);
      END_STATE();
    case 223:
      if (lookahead == 'd') ADVANCE(301);
      END_STATE();
    case 224:
      if (lookahead == 'n') ADVANCE(302);
      END_STATE();
    case 225:
      if (lookahead == 'l') ADVANCE(303);
      END_STATE();
    case 226:
      if (lookahead == 'a') ADVANCE(304);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_fork);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_getc);
      END_STATE();
    case 229:
      if (lookahead == 'r') ADVANCE(305);
      END_STATE();
    case 230:
      if (lookahead == 'e') ADVANCE(306);
      END_STATE();
    case 231:
      if (lookahead == 'e') ADVANCE(307);
      if (lookahead == 'g') ADVANCE(308);
      if (lookahead == 'p') ADVANCE(309);
      if (lookahead == 'r') ADVANCE(310);
      if (lookahead == 'w') ADVANCE(311);
      END_STATE();
    case 232:
      if (lookahead == 'o') ADVANCE(312);
      END_STATE();
    case 233:
      if (lookahead == 'm') ADVANCE(313);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_keys);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_last);
      END_STATE();
    case 237:
      if (lookahead == 'r') ADVANCE(314);
      END_STATE();
    case 238:
      if (lookahead == 't') ADVANCE(315);
      END_STATE();
    case 239:
      if (lookahead == 'l') ADVANCE(316);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_lock);
      END_STATE();
    case 241:
      if (lookahead == 't') ADVANCE(317);
      END_STATE();
    case 242:
      if (lookahead == 'o') ADVANCE(318);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_next);
      END_STATE();
    case 244:
      if (lookahead == 'a') ADVANCE(319);
      END_STATE();
    case 245:
      if (lookahead == 'o') ADVANCE(320);
      END_STATE();
    case 246:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_rand);
      END_STATE();
    case 248:
      if (lookahead == 'l') ADVANCE(322);
      END_STATE();
    case 249:
      if (lookahead == 'i') ADVANCE(323);
      END_STATE();
    case 250:
      if (lookahead == 't') ADVANCE(324);
      END_STATE();
    case 251:
      if (lookahead == 'r') ADVANCE(325);
      END_STATE();
    case 252:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 253:
      if (lookahead == 't') ADVANCE(327);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_sort);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_sqrt);
      END_STATE();
    case 256:
      if (lookahead == 'd') ADVANCE(328);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_stat);
      if (lookahead == 'e') ADVANCE(329);
      END_STATE();
    case 258:
      if (lookahead == 'y') ADVANCE(330);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_tell);
      if (lookahead == 'd') ADVANCE(331);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_tied);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_time);
      if (lookahead == 's') ADVANCE(332);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 263:
      if (lookahead == 'r') ADVANCE(333);
      END_STATE();
    case 264:
      if (lookahead == 'k') ADVANCE(334);
      END_STATE();
    case 265:
      if (lookahead == 'f') ADVANCE(335);
      END_STATE();
    case 266:
      if (lookahead == 's') ADVANCE(336);
      END_STATE();
    case 267:
      if (lookahead == 'e') ADVANCE(337);
      if (lookahead == 'l') ADVANCE(338);
      END_STATE();
    case 268:
      if (lookahead == 'e') ADVANCE(339);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_wait);
      END_STATE();
    case 270:
      if (lookahead == 'a') ADVANCE(340);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(341);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(342);
      END_STATE();
    case 273:
      if (lookahead == 'T') ADVANCE(343);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_BEGIN);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_BUILD);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_CHECK);
      END_STATE();
    case 277:
      if (lookahead == 'H') ADVANCE(344);
      END_STATE();
    case 278:
      if (lookahead == 'A') ADVANCE(345);
      END_STATE();
    case 279:
      if (lookahead == '_') ADVANCE(346);
      END_STATE();
    case 280:
      if (lookahead == 'E') ADVANCE(347);
      END_STATE();
    case 281:
      if (lookahead == 'E') ADVANCE(348);
      END_STATE();
    case 282:
      if (lookahead == 'K') ADVANCE(349);
      END_STATE();
    case 283:
      if (lookahead == '_') ADVANCE(350);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_chdir);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_chomp);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(351);
      END_STATE();
    case 291:
      if (lookahead == 'n') ADVANCE(352);
      END_STATE();
    case 292:
      if (lookahead == 'o') ADVANCE(353);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_defer);
      END_STATE();
    case 294:
      if (lookahead == 'e') ADVANCE(354);
      END_STATE();
    case 295:
      if (lookahead == 'e') ADVANCE(355);
      END_STATE();
    case 296:
      if (lookahead == 'i') ADVANCE(356);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_elsif);
      END_STATE();
    case 298:
      if (lookahead == 's') ADVANCE(357);
      END_STATE();
    case 299:
      if (lookahead == 'd') ADVANCE(358);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_field);
      END_STATE();
    case 302:
      if (lookahead == 'o') ADVANCE(359);
      END_STATE();
    case 303:
      if (lookahead == 'l') ADVANCE(360);
      END_STATE();
    case 304:
      if (lookahead == 'c') ADVANCE(361);
      END_STATE();
    case 305:
      if (lookahead == 'g') ADVANCE(362);
      if (lookahead == 'n') ADVANCE(363);
      END_STATE();
    case 306:
      if (lookahead == 't') ADVANCE(364);
      END_STATE();
    case 307:
      if (lookahead == 'e') ADVANCE(365);
      END_STATE();
    case 308:
      if (lookahead == 'r') ADVANCE(366);
      END_STATE();
    case 309:
      if (lookahead == 'i') ADVANCE(367);
      END_STATE();
    case 310:
      if (lookahead == 'o') ADVANCE(368);
      END_STATE();
    case 311:
      if (lookahead == 'n') ADVANCE(369);
      if (lookahead == 'u') ADVANCE(370);
      END_STATE();
    case 312:
      if (lookahead == 'c') ADVANCE(371);
      END_STATE();
    case 313:
      if (lookahead == 'e') ADVANCE(372);
      END_STATE();
    case 314:
      if (lookahead == 's') ADVANCE(373);
      END_STATE();
    case 315:
      if (lookahead == 'h') ADVANCE(374);
      END_STATE();
    case 316:
      if (lookahead == 't') ADVANCE(375);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_lstat);
      END_STATE();
    case 318:
      if (lookahead == 'd') ADVANCE(376);
      END_STATE();
    case 319:
      if (lookahead == 'g') ADVANCE(377);
      END_STATE();
    case 320:
      if (lookahead == 't') ADVANCE(378);
      END_STATE();
    case 321:
      if (lookahead == 'm') ADVANCE(379);
      END_STATE();
    case 322:
      if (lookahead == 'i') ADVANCE(380);
      END_STATE();
    case 323:
      if (lookahead == 'r') ADVANCE(381);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_reset);
      END_STATE();
    case 325:
      if (lookahead == 'n') ADVANCE(382);
      END_STATE();
    case 326:
      if (lookahead == 'd') ADVANCE(383);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_shift);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_srand);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_state);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_study);
      END_STATE();
    case 331:
      if (lookahead == 'i') ADVANCE(384);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_times);
      END_STATE();
    case 333:
      if (lookahead == 's') ADVANCE(385);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_umask);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_undef);
      END_STATE();
    case 336:
      if (lookahead == 's') ADVANCE(386);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_untie);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 339:
      if (lookahead == 's') ADVANCE(387);
      END_STATE();
    case 340:
      if (lookahead == 'r') ADVANCE(388);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_write);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_ADJUST);
      END_STATE();
    case 344:
      if (lookahead == 'E') ADVANCE(389);
      END_STATE();
    case 345:
      if (lookahead == '_') ADVANCE(390);
      END_STATE();
    case 346:
      if (lookahead == '_') ADVANCE(391);
      END_STATE();
    case 347:
      if (lookahead == '_') ADVANCE(392);
      END_STATE();
    case 348:
      if (lookahead == '_') ADVANCE(393);
      END_STATE();
    case 349:
      if (lookahead == 'A') ADVANCE(394);
      END_STATE();
    case 350:
      if (lookahead == '_') ADVANCE(395);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_chroot);
      END_STATE();
    case 352:
      if (lookahead == 'u') ADVANCE(396);
      END_STATE();
    case 353:
      if (lookahead == 's') ADVANCE(397);
      END_STATE();
    case 354:
      if (lookahead == 'd') ADVANCE(398);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 356:
      if (lookahead == 'c') ADVANCE(399);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_exists);
      END_STATE();
    case 358:
      if (lookahead == 'e') ADVANCE(400);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_fileno);
      END_STATE();
    case 360:
      if (lookahead == 'y') ADVANCE(401);
      END_STATE();
    case 361:
      if (lookahead == 'h') ADVANCE(402);
      END_STATE();
    case 362:
      if (lookahead == 'i') ADVANCE(403);
      END_STATE();
    case 363:
      if (lookahead == 'a') ADVANCE(404);
      END_STATE();
    case 364:
      if (lookahead == 'b') ADVANCE(405);
      END_STATE();
    case 365:
      if (lookahead == 'r') ADVANCE(406);
      END_STATE();
    case 366:
      if (lookahead == 'p') ADVANCE(407);
      END_STATE();
    case 367:
      if (lookahead == 'd') ADVANCE(408);
      END_STATE();
    case 368:
      if (lookahead == 't') ADVANCE(409);
      END_STATE();
    case 369:
      if (lookahead == 'a') ADVANCE(410);
      END_STATE();
    case 370:
      if (lookahead == 'i') ADVANCE(411);
      END_STATE();
    case 371:
      if (lookahead == 'k') ADVANCE(412);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_gmtime);
      END_STATE();
    case 373:
      if (lookahead == 't') ADVANCE(413);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_length);
      END_STATE();
    case 375:
      if (lookahead == 'i') ADVANCE(414);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_method);
      END_STATE();
    case 377:
      if (lookahead == 'e') ADVANCE(415);
      END_STATE();
    case 378:
      if (lookahead == 'y') ADVANCE(416);
      END_STATE();
    case 379:
      if (lookahead == 'e') ADVANCE(417);
      END_STATE();
    case 380:
      if (lookahead == 'n') ADVANCE(418);
      END_STATE();
    case 381:
      if (lookahead == 'e') ADVANCE(419);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 383:
      if (lookahead == 'd') ADVANCE(420);
      END_STATE();
    case 384:
      if (lookahead == 'r') ADVANCE(421);
      END_STATE();
    case 385:
      if (lookahead == 't') ADVANCE(422);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_unless);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_values);
      END_STATE();
    case 388:
      if (lookahead == 'r') ADVANCE(423);
      END_STATE();
    case 389:
      if (lookahead == 'C') ADVANCE(424);
      END_STATE();
    case 390:
      if (lookahead == '_') ADVANCE(425);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym___END__);
      END_STATE();
    case 392:
      if (lookahead == '_') ADVANCE(426);
      END_STATE();
    case 393:
      if (lookahead == '_') ADVANCE(427);
      END_STATE();
    case 394:
      if (lookahead == 'G') ADVANCE(428);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym___SUB__);
      END_STATE();
    case 396:
      if (lookahead == 'e') ADVANCE(429);
      END_STATE();
    case 397:
      if (lookahead == 'e') ADVANCE(430);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_defined);
      END_STATE();
    case 399:
      if (lookahead == 'a') ADVANCE(431);
      END_STATE();
    case 400:
      if (lookahead == 'd') ADVANCE(432);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_foreach);
      END_STATE();
    case 403:
      if (lookahead == 'd') ADVANCE(433);
      END_STATE();
    case 404:
      if (lookahead == 'm') ADVANCE(434);
      END_STATE();
    case 405:
      if (lookahead == 'y') ADVANCE(435);
      END_STATE();
    case 406:
      if (lookahead == 'n') ADVANCE(436);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_getpgrp);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_getppid);
      END_STATE();
    case 409:
      if (lookahead == 'o') ADVANCE(437);
      END_STATE();
    case 410:
      if (lookahead == 'm') ADVANCE(438);
      END_STATE();
    case 411:
      if (lookahead == 'd') ADVANCE(439);
      END_STATE();
    case 412:
      if (lookahead == 'n') ADVANCE(440);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_lcfirst);
      END_STATE();
    case 414:
      if (lookahead == 'm') ADVANCE(441);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 416:
      if (lookahead == 'p') ADVANCE(442);
      END_STATE();
    case 417:
      if (lookahead == 't') ADVANCE(443);
      END_STATE();
    case 418:
      if (lookahead == 'e') ADVANCE(444);
      if (lookahead == 'k') ADVANCE(445);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 420:
      if (lookahead == 'i') ADVANCE(446);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_telldir);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_ucfirst);
      END_STATE();
    case 423:
      if (lookahead == 'a') ADVANCE(447);
      END_STATE();
    case 424:
      if (lookahead == 'K') ADVANCE(448);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym___DATA__);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym___FILE__);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym___LINE__);
      END_STATE();
    case 428:
      if (lookahead == 'E') ADVANCE(449);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_dbmclose);
      END_STATE();
    case 431:
      if (lookahead == 'l') ADVANCE(450);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_extended);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_getgrgid);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_getgrnam);
      END_STATE();
    case 435:
      if (lookahead == 'n') ADVANCE(451);
      END_STATE();
    case 436:
      if (lookahead == 'a') ADVANCE(452);
      END_STATE();
    case 437:
      if (lookahead == 'b') ADVANCE(453);
      END_STATE();
    case 438:
      if (lookahead == 'e') ADVANCE(454);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_getpwuid);
      END_STATE();
    case 440:
      if (lookahead == 'a') ADVANCE(455);
      END_STATE();
    case 441:
      if (lookahead == 'e') ADVANCE(456);
      END_STATE();
    case 442:
      if (lookahead == 'e') ADVANCE(457);
      END_STATE();
    case 443:
      if (lookahead == 'a') ADVANCE(458);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_readline);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_readlink);
      END_STATE();
    case 446:
      if (lookahead == 'r') ADVANCE(459);
      END_STATE();
    case 447:
      if (lookahead == 'y') ADVANCE(460);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_UNITCHECK);
      END_STATE();
    case 449:
      if (lookahead == '_') ADVANCE(461);
      END_STATE();
    case 450:
      if (lookahead == 'l') ADVANCE(462);
      END_STATE();
    case 451:
      if (lookahead == 'a') ADVANCE(463);
      END_STATE();
    case 452:
      if (lookahead == 'm') ADVANCE(464);
      END_STATE();
    case 453:
      if (lookahead == 'y') ADVANCE(465);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_getpwname);
      END_STATE();
    case 455:
      if (lookahead == 'm') ADVANCE(466);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_localtime);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_prototype);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_quotemeta);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_rewinddir);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_wantarray);
      END_STATE();
    case 461:
      if (lookahead == '_') ADVANCE(467);
      END_STATE();
    case 462:
      if (lookahead == 'y') ADVANCE(468);
      END_STATE();
    case 463:
      if (lookahead == 'm') ADVANCE(469);
      END_STATE();
    case 464:
      if (lookahead == 'e') ADVANCE(470);
      END_STATE();
    case 465:
      if (lookahead == 'n') ADVANCE(471);
      END_STATE();
    case 466:
      if (lookahead == 'e') ADVANCE(472);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym___PACKAGE__);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_dynamically);
      END_STATE();
    case 469:
      if (lookahead == 'e') ADVANCE(473);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_getpeername);
      END_STATE();
    case 471:
      if (lookahead == 'a') ADVANCE(474);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_getsockname);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_getnetbyname);
      END_STATE();
    case 474:
      if (lookahead == 'm') ADVANCE(475);
      END_STATE();
    case 475:
      if (lookahead == 'e') ADVANCE(476);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_getprotobyname);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 105, .external_lex_state = 2},
  [2] = {.lex_state = 1, .external_lex_state = 3},
  [3] = {.lex_state = 1, .external_lex_state = 3},
  [4] = {.lex_state = 1, .external_lex_state = 3},
  [5] = {.lex_state = 1, .external_lex_state = 3},
  [6] = {.lex_state = 1, .external_lex_state = 3},
  [7] = {.lex_state = 1, .external_lex_state = 3},
  [8] = {.lex_state = 1, .external_lex_state = 3},
  [9] = {.lex_state = 1, .external_lex_state = 3},
  [10] = {.lex_state = 1, .external_lex_state = 4},
  [11] = {.lex_state = 1, .external_lex_state = 3},
  [12] = {.lex_state = 1, .external_lex_state = 3},
  [13] = {.lex_state = 1, .external_lex_state = 3},
  [14] = {.lex_state = 1, .external_lex_state = 3},
  [15] = {.lex_state = 1, .external_lex_state = 4},
  [16] = {.lex_state = 105, .external_lex_state = 2},
  [17] = {.lex_state = 1, .external_lex_state = 4},
  [18] = {.lex_state = 1, .external_lex_state = 4},
  [19] = {.lex_state = 1, .external_lex_state = 4},
  [20] = {.lex_state = 1, .external_lex_state = 4},
  [21] = {.lex_state = 50, .external_lex_state = 5},
  [22] = {.lex_state = 50, .external_lex_state = 5},
  [23] = {.lex_state = 50, .external_lex_state = 5},
  [24] = {.lex_state = 50, .external_lex_state = 5},
  [25] = {.lex_state = 50, .external_lex_state = 5},
  [26] = {.lex_state = 50, .external_lex_state = 5},
  [27] = {.lex_state = 50, .external_lex_state = 5},
  [28] = {.lex_state = 50, .external_lex_state = 5},
  [29] = {.lex_state = 50, .external_lex_state = 5},
  [30] = {.lex_state = 50, .external_lex_state = 5},
  [31] = {.lex_state = 50, .external_lex_state = 5},
  [32] = {.lex_state = 50, .external_lex_state = 5},
  [33] = {.lex_state = 50, .external_lex_state = 5},
  [34] = {.lex_state = 50, .external_lex_state = 5},
  [35] = {.lex_state = 50, .external_lex_state = 5},
  [36] = {.lex_state = 50, .external_lex_state = 5},
  [37] = {.lex_state = 50, .external_lex_state = 5},
  [38] = {.lex_state = 50, .external_lex_state = 5},
  [39] = {.lex_state = 50, .external_lex_state = 5},
  [40] = {.lex_state = 105, .external_lex_state = 2},
  [41] = {.lex_state = 50, .external_lex_state = 5},
  [42] = {.lex_state = 48, .external_lex_state = 4},
  [43] = {.lex_state = 48, .external_lex_state = 6},
  [44] = {.lex_state = 48, .external_lex_state = 4},
  [45] = {.lex_state = 105, .external_lex_state = 4},
  [46] = {.lex_state = 105, .external_lex_state = 4},
  [47] = {.lex_state = 105, .external_lex_state = 4},
  [48] = {.lex_state = 105, .external_lex_state = 4},
  [49] = {.lex_state = 105, .external_lex_state = 4},
  [50] = {.lex_state = 48, .external_lex_state = 4},
  [51] = {.lex_state = 105, .external_lex_state = 4},
  [52] = {.lex_state = 105, .external_lex_state = 4},
  [53] = {.lex_state = 105, .external_lex_state = 4},
  [54] = {.lex_state = 105, .external_lex_state = 4},
  [55] = {.lex_state = 105, .external_lex_state = 4},
  [56] = {.lex_state = 48, .external_lex_state = 6},
  [57] = {.lex_state = 105, .external_lex_state = 4},
  [58] = {.lex_state = 105, .external_lex_state = 4},
  [59] = {.lex_state = 105, .external_lex_state = 4},
  [60] = {.lex_state = 105, .external_lex_state = 4},
  [61] = {.lex_state = 105, .external_lex_state = 4},
  [62] = {.lex_state = 105, .external_lex_state = 4},
  [63] = {.lex_state = 105, .external_lex_state = 4},
  [64] = {.lex_state = 105, .external_lex_state = 4},
  [65] = {.lex_state = 105, .external_lex_state = 4},
  [66] = {.lex_state = 48, .external_lex_state = 4},
  [67] = {.lex_state = 105, .external_lex_state = 4},
  [68] = {.lex_state = 48, .external_lex_state = 4},
  [69] = {.lex_state = 105, .external_lex_state = 4},
  [70] = {.lex_state = 48, .external_lex_state = 4},
  [71] = {.lex_state = 48, .external_lex_state = 4},
  [72] = {.lex_state = 105, .external_lex_state = 4},
  [73] = {.lex_state = 48, .external_lex_state = 4},
  [74] = {.lex_state = 105, .external_lex_state = 4},
  [75] = {.lex_state = 105, .external_lex_state = 4},
  [76] = {.lex_state = 105, .external_lex_state = 4},
  [77] = {.lex_state = 48, .external_lex_state = 4},
  [78] = {.lex_state = 105, .external_lex_state = 4},
  [79] = {.lex_state = 105, .external_lex_state = 4},
  [80] = {.lex_state = 48, .external_lex_state = 6},
  [81] = {.lex_state = 105, .external_lex_state = 4},
  [82] = {.lex_state = 48, .external_lex_state = 6},
  [83] = {.lex_state = 105, .external_lex_state = 4},
  [84] = {.lex_state = 48, .external_lex_state = 4},
  [85] = {.lex_state = 105, .external_lex_state = 4},
  [86] = {.lex_state = 105, .external_lex_state = 4},
  [87] = {.lex_state = 48, .external_lex_state = 6},
  [88] = {.lex_state = 105, .external_lex_state = 4},
  [89] = {.lex_state = 105, .external_lex_state = 4},
  [90] = {.lex_state = 105, .external_lex_state = 4},
  [91] = {.lex_state = 105, .external_lex_state = 4},
  [92] = {.lex_state = 105, .external_lex_state = 4},
  [93] = {.lex_state = 105, .external_lex_state = 4},
  [94] = {.lex_state = 105, .external_lex_state = 4},
  [95] = {.lex_state = 105, .external_lex_state = 4},
  [96] = {.lex_state = 105, .external_lex_state = 4},
  [97] = {.lex_state = 105, .external_lex_state = 4},
  [98] = {.lex_state = 105, .external_lex_state = 4},
  [99] = {.lex_state = 105, .external_lex_state = 4},
  [100] = {.lex_state = 105, .external_lex_state = 4},
  [101] = {.lex_state = 105, .external_lex_state = 4},
  [102] = {.lex_state = 105, .external_lex_state = 4},
  [103] = {.lex_state = 105, .external_lex_state = 4},
  [104] = {.lex_state = 48, .external_lex_state = 4},
  [105] = {.lex_state = 105, .external_lex_state = 4},
  [106] = {.lex_state = 105, .external_lex_state = 4},
  [107] = {.lex_state = 105, .external_lex_state = 4},
  [108] = {.lex_state = 48, .external_lex_state = 6},
  [109] = {.lex_state = 105, .external_lex_state = 4},
  [110] = {.lex_state = 105, .external_lex_state = 4},
  [111] = {.lex_state = 105, .external_lex_state = 4},
  [112] = {.lex_state = 105, .external_lex_state = 4},
  [113] = {.lex_state = 105, .external_lex_state = 4},
  [114] = {.lex_state = 105, .external_lex_state = 4},
  [115] = {.lex_state = 105, .external_lex_state = 4},
  [116] = {.lex_state = 105, .external_lex_state = 4},
  [117] = {.lex_state = 105, .external_lex_state = 4},
  [118] = {.lex_state = 105, .external_lex_state = 4},
  [119] = {.lex_state = 105, .external_lex_state = 4},
  [120] = {.lex_state = 105, .external_lex_state = 4},
  [121] = {.lex_state = 105, .external_lex_state = 4},
  [122] = {.lex_state = 105, .external_lex_state = 4},
  [123] = {.lex_state = 105, .external_lex_state = 4},
  [124] = {.lex_state = 48, .external_lex_state = 4},
  [125] = {.lex_state = 48, .external_lex_state = 4},
  [126] = {.lex_state = 48, .external_lex_state = 4},
  [127] = {.lex_state = 105, .external_lex_state = 4},
  [128] = {.lex_state = 105, .external_lex_state = 4},
  [129] = {.lex_state = 105, .external_lex_state = 4},
  [130] = {.lex_state = 48, .external_lex_state = 4},
  [131] = {.lex_state = 48, .external_lex_state = 4},
  [132] = {.lex_state = 48, .external_lex_state = 4},
  [133] = {.lex_state = 48, .external_lex_state = 4},
  [134] = {.lex_state = 105, .external_lex_state = 4},
  [135] = {.lex_state = 105, .external_lex_state = 4},
  [136] = {.lex_state = 2, .external_lex_state = 3},
  [137] = {.lex_state = 2, .external_lex_state = 3},
  [138] = {.lex_state = 103, .external_lex_state = 3},
  [139] = {.lex_state = 103, .external_lex_state = 3},
  [140] = {.lex_state = 2, .external_lex_state = 4},
  [141] = {.lex_state = 49, .external_lex_state = 5},
  [142] = {.lex_state = 49, .external_lex_state = 5},
  [143] = {.lex_state = 49, .external_lex_state = 5},
  [144] = {.lex_state = 49, .external_lex_state = 4},
  [145] = {.lex_state = 49, .external_lex_state = 5},
  [146] = {.lex_state = 49, .external_lex_state = 5},
  [147] = {.lex_state = 49, .external_lex_state = 5},
  [148] = {.lex_state = 49, .external_lex_state = 5},
  [149] = {.lex_state = 51, .external_lex_state = 6},
  [150] = {.lex_state = 49, .external_lex_state = 5},
  [151] = {.lex_state = 49, .external_lex_state = 4},
  [152] = {.lex_state = 49, .external_lex_state = 5},
  [153] = {.lex_state = 49, .external_lex_state = 5},
  [154] = {.lex_state = 49, .external_lex_state = 5},
  [155] = {.lex_state = 49, .external_lex_state = 4},
  [156] = {.lex_state = 49, .external_lex_state = 5},
  [157] = {.lex_state = 49, .external_lex_state = 5},
  [158] = {.lex_state = 49, .external_lex_state = 5},
  [159] = {.lex_state = 49, .external_lex_state = 5},
  [160] = {.lex_state = 49, .external_lex_state = 5},
  [161] = {.lex_state = 49, .external_lex_state = 5},
  [162] = {.lex_state = 49, .external_lex_state = 5},
  [163] = {.lex_state = 49, .external_lex_state = 5},
  [164] = {.lex_state = 49, .external_lex_state = 5},
  [165] = {.lex_state = 49, .external_lex_state = 5},
  [166] = {.lex_state = 49, .external_lex_state = 5},
  [167] = {.lex_state = 49, .external_lex_state = 5},
  [168] = {.lex_state = 49, .external_lex_state = 4},
  [169] = {.lex_state = 51, .external_lex_state = 6},
  [170] = {.lex_state = 49, .external_lex_state = 5},
  [171] = {.lex_state = 49, .external_lex_state = 5},
  [172] = {.lex_state = 49, .external_lex_state = 5},
  [173] = {.lex_state = 49, .external_lex_state = 5},
  [174] = {.lex_state = 49, .external_lex_state = 5},
  [175] = {.lex_state = 49, .external_lex_state = 5},
  [176] = {.lex_state = 49, .external_lex_state = 5},
  [177] = {.lex_state = 49, .external_lex_state = 5},
  [178] = {.lex_state = 49, .external_lex_state = 5},
  [179] = {.lex_state = 49, .external_lex_state = 5},
  [180] = {.lex_state = 49, .external_lex_state = 5},
  [181] = {.lex_state = 49, .external_lex_state = 5},
  [182] = {.lex_state = 49, .external_lex_state = 5},
  [183] = {.lex_state = 49, .external_lex_state = 5},
  [184] = {.lex_state = 49, .external_lex_state = 5},
  [185] = {.lex_state = 49, .external_lex_state = 5},
  [186] = {.lex_state = 49, .external_lex_state = 5},
  [187] = {.lex_state = 49, .external_lex_state = 5},
  [188] = {.lex_state = 49, .external_lex_state = 5},
  [189] = {.lex_state = 49, .external_lex_state = 5},
  [190] = {.lex_state = 49, .external_lex_state = 5},
  [191] = {.lex_state = 49, .external_lex_state = 5},
  [192] = {.lex_state = 49, .external_lex_state = 5},
  [193] = {.lex_state = 49, .external_lex_state = 5},
  [194] = {.lex_state = 49, .external_lex_state = 5},
  [195] = {.lex_state = 49, .external_lex_state = 5},
  [196] = {.lex_state = 49, .external_lex_state = 5},
  [197] = {.lex_state = 49, .external_lex_state = 5},
  [198] = {.lex_state = 49, .external_lex_state = 5},
  [199] = {.lex_state = 49, .external_lex_state = 5},
  [200] = {.lex_state = 49, .external_lex_state = 5},
  [201] = {.lex_state = 49, .external_lex_state = 5},
  [202] = {.lex_state = 49, .external_lex_state = 4},
  [203] = {.lex_state = 49, .external_lex_state = 7},
  [204] = {.lex_state = 49, .external_lex_state = 4},
  [205] = {.lex_state = 49, .external_lex_state = 7},
  [206] = {.lex_state = 49, .external_lex_state = 7},
  [207] = {.lex_state = 49, .external_lex_state = 7},
  [208] = {.lex_state = 49, .external_lex_state = 7},
  [209] = {.lex_state = 49, .external_lex_state = 7},
  [210] = {.lex_state = 49, .external_lex_state = 4},
  [211] = {.lex_state = 49, .external_lex_state = 7},
  [212] = {.lex_state = 49, .external_lex_state = 7},
  [213] = {.lex_state = 49, .external_lex_state = 7},
  [214] = {.lex_state = 49, .external_lex_state = 7},
  [215] = {.lex_state = 49, .external_lex_state = 7},
  [216] = {.lex_state = 49, .external_lex_state = 4},
  [217] = {.lex_state = 49, .external_lex_state = 4},
  [218] = {.lex_state = 49, .external_lex_state = 7},
  [219] = {.lex_state = 49, .external_lex_state = 4},
  [220] = {.lex_state = 49, .external_lex_state = 7},
  [221] = {.lex_state = 49, .external_lex_state = 7},
  [222] = {.lex_state = 49, .external_lex_state = 7},
  [223] = {.lex_state = 49, .external_lex_state = 4},
  [224] = {.lex_state = 49, .external_lex_state = 4},
  [225] = {.lex_state = 49, .external_lex_state = 4},
  [226] = {.lex_state = 49, .external_lex_state = 4},
  [227] = {.lex_state = 49, .external_lex_state = 4},
  [228] = {.lex_state = 49, .external_lex_state = 4},
  [229] = {.lex_state = 49, .external_lex_state = 4},
  [230] = {.lex_state = 49, .external_lex_state = 4},
  [231] = {.lex_state = 49, .external_lex_state = 4},
  [232] = {.lex_state = 49, .external_lex_state = 6},
  [233] = {.lex_state = 49, .external_lex_state = 4},
  [234] = {.lex_state = 49, .external_lex_state = 4},
  [235] = {.lex_state = 49, .external_lex_state = 4},
  [236] = {.lex_state = 49, .external_lex_state = 4},
  [237] = {.lex_state = 49, .external_lex_state = 4},
  [238] = {.lex_state = 49, .external_lex_state = 4},
  [239] = {.lex_state = 49, .external_lex_state = 4},
  [240] = {.lex_state = 49, .external_lex_state = 4},
  [241] = {.lex_state = 49, .external_lex_state = 4},
  [242] = {.lex_state = 49, .external_lex_state = 4},
  [243] = {.lex_state = 49, .external_lex_state = 4},
  [244] = {.lex_state = 49, .external_lex_state = 4},
  [245] = {.lex_state = 49, .external_lex_state = 4},
  [246] = {.lex_state = 49, .external_lex_state = 4},
  [247] = {.lex_state = 49, .external_lex_state = 4},
  [248] = {.lex_state = 49, .external_lex_state = 4},
  [249] = {.lex_state = 49, .external_lex_state = 4},
  [250] = {.lex_state = 49, .external_lex_state = 4},
  [251] = {.lex_state = 49, .external_lex_state = 4},
  [252] = {.lex_state = 49, .external_lex_state = 4},
  [253] = {.lex_state = 49, .external_lex_state = 4},
  [254] = {.lex_state = 49, .external_lex_state = 4},
  [255] = {.lex_state = 49, .external_lex_state = 4},
  [256] = {.lex_state = 49, .external_lex_state = 4},
  [257] = {.lex_state = 49, .external_lex_state = 4},
  [258] = {.lex_state = 49, .external_lex_state = 4},
  [259] = {.lex_state = 49, .external_lex_state = 4},
  [260] = {.lex_state = 49, .external_lex_state = 4},
  [261] = {.lex_state = 49, .external_lex_state = 4},
  [262] = {.lex_state = 49, .external_lex_state = 4},
  [263] = {.lex_state = 49, .external_lex_state = 4},
  [264] = {.lex_state = 49, .external_lex_state = 4},
  [265] = {.lex_state = 49, .external_lex_state = 4},
  [266] = {.lex_state = 49, .external_lex_state = 4},
  [267] = {.lex_state = 49, .external_lex_state = 4},
  [268] = {.lex_state = 49, .external_lex_state = 4},
  [269] = {.lex_state = 49, .external_lex_state = 6},
  [270] = {.lex_state = 49, .external_lex_state = 4},
  [271] = {.lex_state = 49, .external_lex_state = 4},
  [272] = {.lex_state = 49, .external_lex_state = 4},
  [273] = {.lex_state = 49, .external_lex_state = 4},
  [274] = {.lex_state = 49, .external_lex_state = 4},
  [275] = {.lex_state = 49, .external_lex_state = 4},
  [276] = {.lex_state = 49, .external_lex_state = 4},
  [277] = {.lex_state = 49, .external_lex_state = 4},
  [278] = {.lex_state = 49, .external_lex_state = 4},
  [279] = {.lex_state = 49, .external_lex_state = 4},
  [280] = {.lex_state = 49, .external_lex_state = 4},
  [281] = {.lex_state = 49, .external_lex_state = 4},
  [282] = {.lex_state = 49, .external_lex_state = 4},
  [283] = {.lex_state = 49, .external_lex_state = 4},
  [284] = {.lex_state = 49, .external_lex_state = 4},
  [285] = {.lex_state = 49, .external_lex_state = 4},
  [286] = {.lex_state = 49, .external_lex_state = 4},
  [287] = {.lex_state = 49, .external_lex_state = 4},
  [288] = {.lex_state = 49, .external_lex_state = 4},
  [289] = {.lex_state = 49, .external_lex_state = 4},
  [290] = {.lex_state = 49, .external_lex_state = 4},
  [291] = {.lex_state = 49, .external_lex_state = 4},
  [292] = {.lex_state = 49, .external_lex_state = 4},
  [293] = {.lex_state = 49, .external_lex_state = 4},
  [294] = {.lex_state = 49, .external_lex_state = 4},
  [295] = {.lex_state = 49, .external_lex_state = 4},
  [296] = {.lex_state = 49, .external_lex_state = 4},
  [297] = {.lex_state = 49, .external_lex_state = 4},
  [298] = {.lex_state = 49, .external_lex_state = 4},
  [299] = {.lex_state = 49, .external_lex_state = 4},
  [300] = {.lex_state = 49, .external_lex_state = 4},
  [301] = {.lex_state = 49, .external_lex_state = 4},
  [302] = {.lex_state = 49, .external_lex_state = 4},
  [303] = {.lex_state = 49, .external_lex_state = 4},
  [304] = {.lex_state = 49, .external_lex_state = 4},
  [305] = {.lex_state = 49, .external_lex_state = 4},
  [306] = {.lex_state = 49, .external_lex_state = 4},
  [307] = {.lex_state = 49, .external_lex_state = 4},
  [308] = {.lex_state = 49, .external_lex_state = 4},
  [309] = {.lex_state = 49, .external_lex_state = 4},
  [310] = {.lex_state = 49, .external_lex_state = 4},
  [311] = {.lex_state = 49, .external_lex_state = 4},
  [312] = {.lex_state = 49, .external_lex_state = 4},
  [313] = {.lex_state = 49, .external_lex_state = 4},
  [314] = {.lex_state = 49, .external_lex_state = 4},
  [315] = {.lex_state = 49, .external_lex_state = 4},
  [316] = {.lex_state = 49, .external_lex_state = 4},
  [317] = {.lex_state = 49, .external_lex_state = 4},
  [318] = {.lex_state = 49, .external_lex_state = 4},
  [319] = {.lex_state = 49, .external_lex_state = 4},
  [320] = {.lex_state = 49, .external_lex_state = 4},
  [321] = {.lex_state = 49, .external_lex_state = 4},
  [322] = {.lex_state = 49, .external_lex_state = 4},
  [323] = {.lex_state = 49, .external_lex_state = 4},
  [324] = {.lex_state = 49, .external_lex_state = 4},
  [325] = {.lex_state = 49, .external_lex_state = 4},
  [326] = {.lex_state = 49, .external_lex_state = 4},
  [327] = {.lex_state = 49, .external_lex_state = 4},
  [328] = {.lex_state = 49, .external_lex_state = 4},
  [329] = {.lex_state = 49, .external_lex_state = 4},
  [330] = {.lex_state = 49, .external_lex_state = 4},
  [331] = {.lex_state = 49, .external_lex_state = 4},
  [332] = {.lex_state = 49, .external_lex_state = 4},
  [333] = {.lex_state = 49, .external_lex_state = 4},
  [334] = {.lex_state = 49, .external_lex_state = 4},
  [335] = {.lex_state = 49, .external_lex_state = 4},
  [336] = {.lex_state = 49, .external_lex_state = 4},
  [337] = {.lex_state = 49, .external_lex_state = 4},
  [338] = {.lex_state = 49, .external_lex_state = 4},
  [339] = {.lex_state = 49, .external_lex_state = 4},
  [340] = {.lex_state = 49, .external_lex_state = 4},
  [341] = {.lex_state = 49, .external_lex_state = 4},
  [342] = {.lex_state = 49, .external_lex_state = 4},
  [343] = {.lex_state = 49, .external_lex_state = 4},
  [344] = {.lex_state = 49, .external_lex_state = 4},
  [345] = {.lex_state = 49, .external_lex_state = 4},
  [346] = {.lex_state = 49, .external_lex_state = 4},
  [347] = {.lex_state = 49, .external_lex_state = 4},
  [348] = {.lex_state = 49, .external_lex_state = 4},
  [349] = {.lex_state = 49, .external_lex_state = 4},
  [350] = {.lex_state = 49, .external_lex_state = 4},
  [351] = {.lex_state = 49, .external_lex_state = 4},
  [352] = {.lex_state = 49, .external_lex_state = 4},
  [353] = {.lex_state = 49, .external_lex_state = 4},
  [354] = {.lex_state = 49, .external_lex_state = 4},
  [355] = {.lex_state = 49, .external_lex_state = 4},
  [356] = {.lex_state = 49, .external_lex_state = 4},
  [357] = {.lex_state = 49, .external_lex_state = 4},
  [358] = {.lex_state = 49, .external_lex_state = 4},
  [359] = {.lex_state = 49, .external_lex_state = 4},
  [360] = {.lex_state = 49, .external_lex_state = 4},
  [361] = {.lex_state = 49, .external_lex_state = 4},
  [362] = {.lex_state = 49, .external_lex_state = 4},
  [363] = {.lex_state = 49, .external_lex_state = 4},
  [364] = {.lex_state = 49, .external_lex_state = 4},
  [365] = {.lex_state = 49, .external_lex_state = 4},
  [366] = {.lex_state = 49, .external_lex_state = 4},
  [367] = {.lex_state = 49, .external_lex_state = 4},
  [368] = {.lex_state = 49, .external_lex_state = 4},
  [369] = {.lex_state = 49, .external_lex_state = 4},
  [370] = {.lex_state = 49, .external_lex_state = 4},
  [371] = {.lex_state = 49, .external_lex_state = 4},
  [372] = {.lex_state = 49, .external_lex_state = 4},
  [373] = {.lex_state = 49, .external_lex_state = 4},
  [374] = {.lex_state = 49, .external_lex_state = 4},
  [375] = {.lex_state = 49, .external_lex_state = 4},
  [376] = {.lex_state = 49, .external_lex_state = 6},
  [377] = {.lex_state = 49, .external_lex_state = 4},
  [378] = {.lex_state = 49, .external_lex_state = 4},
  [379] = {.lex_state = 49, .external_lex_state = 4},
  [380] = {.lex_state = 49, .external_lex_state = 4},
  [381] = {.lex_state = 49, .external_lex_state = 4},
  [382] = {.lex_state = 49, .external_lex_state = 4},
  [383] = {.lex_state = 49, .external_lex_state = 4},
  [384] = {.lex_state = 49, .external_lex_state = 4},
  [385] = {.lex_state = 49, .external_lex_state = 4},
  [386] = {.lex_state = 49, .external_lex_state = 4},
  [387] = {.lex_state = 49, .external_lex_state = 4},
  [388] = {.lex_state = 49, .external_lex_state = 4},
  [389] = {.lex_state = 49, .external_lex_state = 4},
  [390] = {.lex_state = 49, .external_lex_state = 4},
  [391] = {.lex_state = 49, .external_lex_state = 4},
  [392] = {.lex_state = 49, .external_lex_state = 4},
  [393] = {.lex_state = 49, .external_lex_state = 4},
  [394] = {.lex_state = 49, .external_lex_state = 4},
  [395] = {.lex_state = 49, .external_lex_state = 4},
  [396] = {.lex_state = 49, .external_lex_state = 4},
  [397] = {.lex_state = 49, .external_lex_state = 4},
  [398] = {.lex_state = 49, .external_lex_state = 4},
  [399] = {.lex_state = 49, .external_lex_state = 4},
  [400] = {.lex_state = 49, .external_lex_state = 4},
  [401] = {.lex_state = 49, .external_lex_state = 4},
  [402] = {.lex_state = 49, .external_lex_state = 7},
  [403] = {.lex_state = 49, .external_lex_state = 4},
  [404] = {.lex_state = 49, .external_lex_state = 4},
  [405] = {.lex_state = 49, .external_lex_state = 7},
  [406] = {.lex_state = 49, .external_lex_state = 7},
  [407] = {.lex_state = 49, .external_lex_state = 7},
  [408] = {.lex_state = 49, .external_lex_state = 7},
  [409] = {.lex_state = 49, .external_lex_state = 4},
  [410] = {.lex_state = 49, .external_lex_state = 4},
  [411] = {.lex_state = 49, .external_lex_state = 4},
  [412] = {.lex_state = 49, .external_lex_state = 4},
  [413] = {.lex_state = 49, .external_lex_state = 4},
  [414] = {.lex_state = 49, .external_lex_state = 4},
  [415] = {.lex_state = 49, .external_lex_state = 4},
  [416] = {.lex_state = 49, .external_lex_state = 4},
  [417] = {.lex_state = 49, .external_lex_state = 4},
  [418] = {.lex_state = 49, .external_lex_state = 7},
  [419] = {.lex_state = 49, .external_lex_state = 4},
  [420] = {.lex_state = 49, .external_lex_state = 4},
  [421] = {.lex_state = 49, .external_lex_state = 7},
  [422] = {.lex_state = 49, .external_lex_state = 4},
  [423] = {.lex_state = 49, .external_lex_state = 4},
  [424] = {.lex_state = 49, .external_lex_state = 4},
  [425] = {.lex_state = 49, .external_lex_state = 7},
  [426] = {.lex_state = 49, .external_lex_state = 4},
  [427] = {.lex_state = 49, .external_lex_state = 4},
  [428] = {.lex_state = 49, .external_lex_state = 4},
  [429] = {.lex_state = 49, .external_lex_state = 4},
  [430] = {.lex_state = 49, .external_lex_state = 4},
  [431] = {.lex_state = 49, .external_lex_state = 4},
  [432] = {.lex_state = 49, .external_lex_state = 4},
  [433] = {.lex_state = 49, .external_lex_state = 4},
  [434] = {.lex_state = 49, .external_lex_state = 4},
  [435] = {.lex_state = 49, .external_lex_state = 4},
  [436] = {.lex_state = 49, .external_lex_state = 4},
  [437] = {.lex_state = 49, .external_lex_state = 4},
  [438] = {.lex_state = 49, .external_lex_state = 4},
  [439] = {.lex_state = 49, .external_lex_state = 7},
  [440] = {.lex_state = 49, .external_lex_state = 7},
  [441] = {.lex_state = 49, .external_lex_state = 7},
  [442] = {.lex_state = 49, .external_lex_state = 4},
  [443] = {.lex_state = 49, .external_lex_state = 4},
  [444] = {.lex_state = 49, .external_lex_state = 4},
  [445] = {.lex_state = 49, .external_lex_state = 4},
  [446] = {.lex_state = 49, .external_lex_state = 4},
  [447] = {.lex_state = 49, .external_lex_state = 4},
  [448] = {.lex_state = 49, .external_lex_state = 4},
  [449] = {.lex_state = 49, .external_lex_state = 4},
  [450] = {.lex_state = 49, .external_lex_state = 4},
  [451] = {.lex_state = 49, .external_lex_state = 4},
  [452] = {.lex_state = 49, .external_lex_state = 4},
  [453] = {.lex_state = 49, .external_lex_state = 4},
  [454] = {.lex_state = 49, .external_lex_state = 7},
  [455] = {.lex_state = 49, .external_lex_state = 7},
  [456] = {.lex_state = 49, .external_lex_state = 7},
  [457] = {.lex_state = 49, .external_lex_state = 4},
  [458] = {.lex_state = 49, .external_lex_state = 4},
  [459] = {.lex_state = 49, .external_lex_state = 4},
  [460] = {.lex_state = 49, .external_lex_state = 4},
  [461] = {.lex_state = 49, .external_lex_state = 4},
  [462] = {.lex_state = 49, .external_lex_state = 4},
  [463] = {.lex_state = 49, .external_lex_state = 4},
  [464] = {.lex_state = 49, .external_lex_state = 4},
  [465] = {.lex_state = 49, .external_lex_state = 4},
  [466] = {.lex_state = 49, .external_lex_state = 4},
  [467] = {.lex_state = 49, .external_lex_state = 4},
  [468] = {.lex_state = 49, .external_lex_state = 4},
  [469] = {.lex_state = 49, .external_lex_state = 4},
  [470] = {.lex_state = 49, .external_lex_state = 4},
  [471] = {.lex_state = 49, .external_lex_state = 4},
  [472] = {.lex_state = 49, .external_lex_state = 7},
  [473] = {.lex_state = 49, .external_lex_state = 4},
  [474] = {.lex_state = 49, .external_lex_state = 4},
  [475] = {.lex_state = 49, .external_lex_state = 4},
  [476] = {.lex_state = 49, .external_lex_state = 4},
  [477] = {.lex_state = 49, .external_lex_state = 4},
  [478] = {.lex_state = 49, .external_lex_state = 4},
  [479] = {.lex_state = 49, .external_lex_state = 7},
  [480] = {.lex_state = 49, .external_lex_state = 4},
  [481] = {.lex_state = 49, .external_lex_state = 7},
  [482] = {.lex_state = 49, .external_lex_state = 7},
  [483] = {.lex_state = 49, .external_lex_state = 7},
  [484] = {.lex_state = 49, .external_lex_state = 4},
  [485] = {.lex_state = 49, .external_lex_state = 4},
  [486] = {.lex_state = 49, .external_lex_state = 4},
  [487] = {.lex_state = 49, .external_lex_state = 4},
  [488] = {.lex_state = 49, .external_lex_state = 4},
  [489] = {.lex_state = 49, .external_lex_state = 7},
  [490] = {.lex_state = 49, .external_lex_state = 7},
  [491] = {.lex_state = 49, .external_lex_state = 4},
  [492] = {.lex_state = 49, .external_lex_state = 4},
  [493] = {.lex_state = 49, .external_lex_state = 4},
  [494] = {.lex_state = 49, .external_lex_state = 4},
  [495] = {.lex_state = 49, .external_lex_state = 4},
  [496] = {.lex_state = 49, .external_lex_state = 4},
  [497] = {.lex_state = 49, .external_lex_state = 4},
  [498] = {.lex_state = 49, .external_lex_state = 4},
  [499] = {.lex_state = 49, .external_lex_state = 4},
  [500] = {.lex_state = 49, .external_lex_state = 4},
  [501] = {.lex_state = 49, .external_lex_state = 4},
  [502] = {.lex_state = 49, .external_lex_state = 4},
  [503] = {.lex_state = 49, .external_lex_state = 4},
  [504] = {.lex_state = 49, .external_lex_state = 4},
  [505] = {.lex_state = 49, .external_lex_state = 4},
  [506] = {.lex_state = 49, .external_lex_state = 4},
  [507] = {.lex_state = 49, .external_lex_state = 4},
  [508] = {.lex_state = 49, .external_lex_state = 4},
  [509] = {.lex_state = 49, .external_lex_state = 4},
  [510] = {.lex_state = 49, .external_lex_state = 4},
  [511] = {.lex_state = 49, .external_lex_state = 4},
  [512] = {.lex_state = 49, .external_lex_state = 4},
  [513] = {.lex_state = 49, .external_lex_state = 4},
  [514] = {.lex_state = 49, .external_lex_state = 4},
  [515] = {.lex_state = 49, .external_lex_state = 4},
  [516] = {.lex_state = 49, .external_lex_state = 4},
  [517] = {.lex_state = 49, .external_lex_state = 4},
  [518] = {.lex_state = 49, .external_lex_state = 4},
  [519] = {.lex_state = 49, .external_lex_state = 4},
  [520] = {.lex_state = 49, .external_lex_state = 4},
  [521] = {.lex_state = 49, .external_lex_state = 4},
  [522] = {.lex_state = 49, .external_lex_state = 4},
  [523] = {.lex_state = 49, .external_lex_state = 4},
  [524] = {.lex_state = 49, .external_lex_state = 4},
  [525] = {.lex_state = 49, .external_lex_state = 4},
  [526] = {.lex_state = 49, .external_lex_state = 4},
  [527] = {.lex_state = 49, .external_lex_state = 4},
  [528] = {.lex_state = 49, .external_lex_state = 4},
  [529] = {.lex_state = 49, .external_lex_state = 4},
  [530] = {.lex_state = 49, .external_lex_state = 4},
  [531] = {.lex_state = 49, .external_lex_state = 4},
  [532] = {.lex_state = 49, .external_lex_state = 4},
  [533] = {.lex_state = 49, .external_lex_state = 4},
  [534] = {.lex_state = 49, .external_lex_state = 4},
  [535] = {.lex_state = 49, .external_lex_state = 4},
  [536] = {.lex_state = 49, .external_lex_state = 4},
  [537] = {.lex_state = 49, .external_lex_state = 4},
  [538] = {.lex_state = 49, .external_lex_state = 4},
  [539] = {.lex_state = 49, .external_lex_state = 4},
  [540] = {.lex_state = 49, .external_lex_state = 4},
  [541] = {.lex_state = 49, .external_lex_state = 4},
  [542] = {.lex_state = 49, .external_lex_state = 4},
  [543] = {.lex_state = 49, .external_lex_state = 4},
  [544] = {.lex_state = 49, .external_lex_state = 4},
  [545] = {.lex_state = 49, .external_lex_state = 4},
  [546] = {.lex_state = 49, .external_lex_state = 4},
  [547] = {.lex_state = 49, .external_lex_state = 4},
  [548] = {.lex_state = 49, .external_lex_state = 4},
  [549] = {.lex_state = 49, .external_lex_state = 4},
  [550] = {.lex_state = 49, .external_lex_state = 4},
  [551] = {.lex_state = 49, .external_lex_state = 4},
  [552] = {.lex_state = 49, .external_lex_state = 4},
  [553] = {.lex_state = 49, .external_lex_state = 4},
  [554] = {.lex_state = 49, .external_lex_state = 4},
  [555] = {.lex_state = 49, .external_lex_state = 4},
  [556] = {.lex_state = 49, .external_lex_state = 4},
  [557] = {.lex_state = 49, .external_lex_state = 4},
  [558] = {.lex_state = 49, .external_lex_state = 4},
  [559] = {.lex_state = 49, .external_lex_state = 4},
  [560] = {.lex_state = 49, .external_lex_state = 4},
  [561] = {.lex_state = 49, .external_lex_state = 4},
  [562] = {.lex_state = 49, .external_lex_state = 4},
  [563] = {.lex_state = 49, .external_lex_state = 4},
  [564] = {.lex_state = 49, .external_lex_state = 4},
  [565] = {.lex_state = 49, .external_lex_state = 4},
  [566] = {.lex_state = 49, .external_lex_state = 4},
  [567] = {.lex_state = 49, .external_lex_state = 4},
  [568] = {.lex_state = 49, .external_lex_state = 4},
  [569] = {.lex_state = 49, .external_lex_state = 4},
  [570] = {.lex_state = 49, .external_lex_state = 4},
  [571] = {.lex_state = 49, .external_lex_state = 4},
  [572] = {.lex_state = 49, .external_lex_state = 4},
  [573] = {.lex_state = 49, .external_lex_state = 4},
  [574] = {.lex_state = 49, .external_lex_state = 4},
  [575] = {.lex_state = 49, .external_lex_state = 4},
  [576] = {.lex_state = 49, .external_lex_state = 4},
  [577] = {.lex_state = 49, .external_lex_state = 4},
  [578] = {.lex_state = 49, .external_lex_state = 4},
  [579] = {.lex_state = 49, .external_lex_state = 4},
  [580] = {.lex_state = 49, .external_lex_state = 4},
  [581] = {.lex_state = 49, .external_lex_state = 4},
  [582] = {.lex_state = 49, .external_lex_state = 4},
  [583] = {.lex_state = 49, .external_lex_state = 4},
  [584] = {.lex_state = 49, .external_lex_state = 4},
  [585] = {.lex_state = 49, .external_lex_state = 4},
  [586] = {.lex_state = 49, .external_lex_state = 4},
  [587] = {.lex_state = 49, .external_lex_state = 4},
  [588] = {.lex_state = 49, .external_lex_state = 4},
  [589] = {.lex_state = 49, .external_lex_state = 4},
  [590] = {.lex_state = 49, .external_lex_state = 4},
  [591] = {.lex_state = 49, .external_lex_state = 4},
  [592] = {.lex_state = 49, .external_lex_state = 4},
  [593] = {.lex_state = 49, .external_lex_state = 4},
  [594] = {.lex_state = 49, .external_lex_state = 4},
  [595] = {.lex_state = 49, .external_lex_state = 4},
  [596] = {.lex_state = 49, .external_lex_state = 4},
  [597] = {.lex_state = 49, .external_lex_state = 4},
  [598] = {.lex_state = 49, .external_lex_state = 4},
  [599] = {.lex_state = 49, .external_lex_state = 4},
  [600] = {.lex_state = 49, .external_lex_state = 4},
  [601] = {.lex_state = 49, .external_lex_state = 4},
  [602] = {.lex_state = 49, .external_lex_state = 4},
  [603] = {.lex_state = 49, .external_lex_state = 4},
  [604] = {.lex_state = 49, .external_lex_state = 4},
  [605] = {.lex_state = 49, .external_lex_state = 4},
  [606] = {.lex_state = 49, .external_lex_state = 4},
  [607] = {.lex_state = 49, .external_lex_state = 4},
  [608] = {.lex_state = 49, .external_lex_state = 4},
  [609] = {.lex_state = 49, .external_lex_state = 4},
  [610] = {.lex_state = 49, .external_lex_state = 4},
  [611] = {.lex_state = 49, .external_lex_state = 4},
  [612] = {.lex_state = 49, .external_lex_state = 4},
  [613] = {.lex_state = 49, .external_lex_state = 4},
  [614] = {.lex_state = 49, .external_lex_state = 4},
  [615] = {.lex_state = 49, .external_lex_state = 4},
  [616] = {.lex_state = 49, .external_lex_state = 4},
  [617] = {.lex_state = 49, .external_lex_state = 4},
  [618] = {.lex_state = 49, .external_lex_state = 4},
  [619] = {.lex_state = 49, .external_lex_state = 4},
  [620] = {.lex_state = 49, .external_lex_state = 4},
  [621] = {.lex_state = 49, .external_lex_state = 4},
  [622] = {.lex_state = 49, .external_lex_state = 4},
  [623] = {.lex_state = 49, .external_lex_state = 4},
  [624] = {.lex_state = 49, .external_lex_state = 4},
  [625] = {.lex_state = 49, .external_lex_state = 4},
  [626] = {.lex_state = 49, .external_lex_state = 4},
  [627] = {.lex_state = 49, .external_lex_state = 4},
  [628] = {.lex_state = 49, .external_lex_state = 4},
  [629] = {.lex_state = 49, .external_lex_state = 4},
  [630] = {.lex_state = 49, .external_lex_state = 4},
  [631] = {.lex_state = 49, .external_lex_state = 4},
  [632] = {.lex_state = 49, .external_lex_state = 4},
  [633] = {.lex_state = 49, .external_lex_state = 4},
  [634] = {.lex_state = 49, .external_lex_state = 4},
  [635] = {.lex_state = 49, .external_lex_state = 4},
  [636] = {.lex_state = 49, .external_lex_state = 4},
  [637] = {.lex_state = 49, .external_lex_state = 4},
  [638] = {.lex_state = 49, .external_lex_state = 4},
  [639] = {.lex_state = 49, .external_lex_state = 4},
  [640] = {.lex_state = 49, .external_lex_state = 4},
  [641] = {.lex_state = 49, .external_lex_state = 4},
  [642] = {.lex_state = 49, .external_lex_state = 4},
  [643] = {.lex_state = 49, .external_lex_state = 4},
  [644] = {.lex_state = 49, .external_lex_state = 4},
  [645] = {.lex_state = 49, .external_lex_state = 4},
  [646] = {.lex_state = 49, .external_lex_state = 4},
  [647] = {.lex_state = 49, .external_lex_state = 4},
  [648] = {.lex_state = 49, .external_lex_state = 4},
  [649] = {.lex_state = 49, .external_lex_state = 4},
  [650] = {.lex_state = 49, .external_lex_state = 4},
  [651] = {.lex_state = 49, .external_lex_state = 4},
  [652] = {.lex_state = 49, .external_lex_state = 4},
  [653] = {.lex_state = 49, .external_lex_state = 4},
  [654] = {.lex_state = 49, .external_lex_state = 4},
  [655] = {.lex_state = 49, .external_lex_state = 4},
  [656] = {.lex_state = 49, .external_lex_state = 4},
  [657] = {.lex_state = 49, .external_lex_state = 4},
  [658] = {.lex_state = 49, .external_lex_state = 4},
  [659] = {.lex_state = 1, .external_lex_state = 8},
  [660] = {.lex_state = 1, .external_lex_state = 9},
  [661] = {.lex_state = 1, .external_lex_state = 8},
  [662] = {.lex_state = 1, .external_lex_state = 8},
  [663] = {.lex_state = 1, .external_lex_state = 8},
  [664] = {.lex_state = 1, .external_lex_state = 8},
  [665] = {.lex_state = 1, .external_lex_state = 8},
  [666] = {.lex_state = 1, .external_lex_state = 8},
  [667] = {.lex_state = 1, .external_lex_state = 8},
  [668] = {.lex_state = 1, .external_lex_state = 8},
  [669] = {.lex_state = 1, .external_lex_state = 8},
  [670] = {.lex_state = 1, .external_lex_state = 8},
  [671] = {.lex_state = 1, .external_lex_state = 3},
  [672] = {.lex_state = 1, .external_lex_state = 9},
  [673] = {.lex_state = 1, .external_lex_state = 9},
  [674] = {.lex_state = 1, .external_lex_state = 9},
  [675] = {.lex_state = 1, .external_lex_state = 9},
  [676] = {.lex_state = 1, .external_lex_state = 9},
  [677] = {.lex_state = 1, .external_lex_state = 9},
  [678] = {.lex_state = 1, .external_lex_state = 9},
  [679] = {.lex_state = 1, .external_lex_state = 9},
  [680] = {.lex_state = 1, .external_lex_state = 9},
  [681] = {.lex_state = 1, .external_lex_state = 9},
  [682] = {.lex_state = 1, .external_lex_state = 9},
  [683] = {.lex_state = 1, .external_lex_state = 9},
  [684] = {.lex_state = 1, .external_lex_state = 9},
  [685] = {.lex_state = 1, .external_lex_state = 9},
  [686] = {.lex_state = 1, .external_lex_state = 9},
  [687] = {.lex_state = 1, .external_lex_state = 9},
  [688] = {.lex_state = 1, .external_lex_state = 9},
  [689] = {.lex_state = 1, .external_lex_state = 9},
  [690] = {.lex_state = 1, .external_lex_state = 9},
  [691] = {.lex_state = 1, .external_lex_state = 9},
  [692] = {.lex_state = 1, .external_lex_state = 3},
  [693] = {.lex_state = 1, .external_lex_state = 3},
  [694] = {.lex_state = 1, .external_lex_state = 3},
  [695] = {.lex_state = 1, .external_lex_state = 3},
  [696] = {.lex_state = 1, .external_lex_state = 3},
  [697] = {.lex_state = 1, .external_lex_state = 9},
  [698] = {.lex_state = 1, .external_lex_state = 9},
  [699] = {.lex_state = 1, .external_lex_state = 9},
  [700] = {.lex_state = 1, .external_lex_state = 9},
  [701] = {.lex_state = 1, .external_lex_state = 9},
  [702] = {.lex_state = 1, .external_lex_state = 9},
  [703] = {.lex_state = 1, .external_lex_state = 3},
  [704] = {.lex_state = 1, .external_lex_state = 9},
  [705] = {.lex_state = 1, .external_lex_state = 9},
  [706] = {.lex_state = 1, .external_lex_state = 9},
  [707] = {.lex_state = 1, .external_lex_state = 9},
  [708] = {.lex_state = 1, .external_lex_state = 9},
  [709] = {.lex_state = 1, .external_lex_state = 9},
  [710] = {.lex_state = 1, .external_lex_state = 9},
  [711] = {.lex_state = 1, .external_lex_state = 9},
  [712] = {.lex_state = 1, .external_lex_state = 9},
  [713] = {.lex_state = 1, .external_lex_state = 9},
  [714] = {.lex_state = 1, .external_lex_state = 9},
  [715] = {.lex_state = 1, .external_lex_state = 8},
  [716] = {.lex_state = 1, .external_lex_state = 8},
  [717] = {.lex_state = 1, .external_lex_state = 8},
  [718] = {.lex_state = 1, .external_lex_state = 8},
  [719] = {.lex_state = 1, .external_lex_state = 8},
  [720] = {.lex_state = 1, .external_lex_state = 8},
  [721] = {.lex_state = 1, .external_lex_state = 8},
  [722] = {.lex_state = 1, .external_lex_state = 8},
  [723] = {.lex_state = 1, .external_lex_state = 8},
  [724] = {.lex_state = 1, .external_lex_state = 8},
  [725] = {.lex_state = 1, .external_lex_state = 8},
  [726] = {.lex_state = 1, .external_lex_state = 3},
  [727] = {.lex_state = 1, .external_lex_state = 3},
  [728] = {.lex_state = 1, .external_lex_state = 3},
  [729] = {.lex_state = 1, .external_lex_state = 3},
  [730] = {.lex_state = 1, .external_lex_state = 3},
  [731] = {.lex_state = 1, .external_lex_state = 3},
  [732] = {.lex_state = 1, .external_lex_state = 10},
  [733] = {.lex_state = 1, .external_lex_state = 10},
  [734] = {.lex_state = 1, .external_lex_state = 10},
  [735] = {.lex_state = 1, .external_lex_state = 10},
  [736] = {.lex_state = 1, .external_lex_state = 10},
  [737] = {.lex_state = 1, .external_lex_state = 10},
  [738] = {.lex_state = 1, .external_lex_state = 10},
  [739] = {.lex_state = 1, .external_lex_state = 10},
  [740] = {.lex_state = 1, .external_lex_state = 10},
  [741] = {.lex_state = 1, .external_lex_state = 10},
  [742] = {.lex_state = 1, .external_lex_state = 10},
  [743] = {.lex_state = 1, .external_lex_state = 4},
  [744] = {.lex_state = 1, .external_lex_state = 4},
  [745] = {.lex_state = 1, .external_lex_state = 4},
  [746] = {.lex_state = 1, .external_lex_state = 4},
  [747] = {.lex_state = 1, .external_lex_state = 4},
  [748] = {.lex_state = 1, .external_lex_state = 4},
  [749] = {.lex_state = 48, .external_lex_state = 10},
  [750] = {.lex_state = 48, .external_lex_state = 10},
  [751] = {.lex_state = 48, .external_lex_state = 10},
  [752] = {.lex_state = 48, .external_lex_state = 10},
  [753] = {.lex_state = 48, .external_lex_state = 10},
  [754] = {.lex_state = 48, .external_lex_state = 10},
  [755] = {.lex_state = 48, .external_lex_state = 10},
  [756] = {.lex_state = 48, .external_lex_state = 10},
  [757] = {.lex_state = 48, .external_lex_state = 10},
  [758] = {.lex_state = 48, .external_lex_state = 10},
  [759] = {.lex_state = 48, .external_lex_state = 10},
  [760] = {.lex_state = 48, .external_lex_state = 11},
  [761] = {.lex_state = 48, .external_lex_state = 4},
  [762] = {.lex_state = 48, .external_lex_state = 10},
  [763] = {.lex_state = 48, .external_lex_state = 11},
  [764] = {.lex_state = 48, .external_lex_state = 4},
  [765] = {.lex_state = 48, .external_lex_state = 11},
  [766] = {.lex_state = 48, .external_lex_state = 4},
  [767] = {.lex_state = 48, .external_lex_state = 11},
  [768] = {.lex_state = 48, .external_lex_state = 11},
  [769] = {.lex_state = 48, .external_lex_state = 11},
  [770] = {.lex_state = 48, .external_lex_state = 4},
  [771] = {.lex_state = 48, .external_lex_state = 11},
  [772] = {.lex_state = 48, .external_lex_state = 11},
  [773] = {.lex_state = 48, .external_lex_state = 11},
  [774] = {.lex_state = 48, .external_lex_state = 11},
  [775] = {.lex_state = 48, .external_lex_state = 11},
  [776] = {.lex_state = 48, .external_lex_state = 4},
  [777] = {.lex_state = 48, .external_lex_state = 4},
  [778] = {.lex_state = 48, .external_lex_state = 6},
  [779] = {.lex_state = 48, .external_lex_state = 4},
  [780] = {.lex_state = 48, .external_lex_state = 6},
  [781] = {.lex_state = 48, .external_lex_state = 4},
  [782] = {.lex_state = 48, .external_lex_state = 6},
  [783] = {.lex_state = 48, .external_lex_state = 4},
  [784] = {.lex_state = 48, .external_lex_state = 6},
  [785] = {.lex_state = 48, .external_lex_state = 6},
  [786] = {.lex_state = 48, .external_lex_state = 4},
  [787] = {.lex_state = 48, .external_lex_state = 6},
  [788] = {.lex_state = 48, .external_lex_state = 4},
  [789] = {.lex_state = 48, .external_lex_state = 6},
  [790] = {.lex_state = 104, .external_lex_state = 2},
  [791] = {.lex_state = 104, .external_lex_state = 2},
  [792] = {.lex_state = 104, .external_lex_state = 2},
  [793] = {.lex_state = 105, .external_lex_state = 2},
  [794] = {.lex_state = 105, .external_lex_state = 2},
  [795] = {.lex_state = 104, .external_lex_state = 2},
  [796] = {.lex_state = 105, .external_lex_state = 2},
  [797] = {.lex_state = 105, .external_lex_state = 2},
  [798] = {.lex_state = 105, .external_lex_state = 2},
  [799] = {.lex_state = 104, .external_lex_state = 4},
  [800] = {.lex_state = 105, .external_lex_state = 2},
  [801] = {.lex_state = 104, .external_lex_state = 4},
  [802] = {.lex_state = 105, .external_lex_state = 2},
  [803] = {.lex_state = 105, .external_lex_state = 2},
  [804] = {.lex_state = 105, .external_lex_state = 2},
  [805] = {.lex_state = 105, .external_lex_state = 2},
  [806] = {.lex_state = 105, .external_lex_state = 2},
  [807] = {.lex_state = 105, .external_lex_state = 2},
  [808] = {.lex_state = 105, .external_lex_state = 2},
  [809] = {.lex_state = 105, .external_lex_state = 2},
  [810] = {.lex_state = 105, .external_lex_state = 2},
  [811] = {.lex_state = 105, .external_lex_state = 2},
  [812] = {.lex_state = 105, .external_lex_state = 2},
  [813] = {.lex_state = 105, .external_lex_state = 2},
  [814] = {.lex_state = 105, .external_lex_state = 2},
  [815] = {.lex_state = 105, .external_lex_state = 2},
  [816] = {.lex_state = 105, .external_lex_state = 2},
  [817] = {.lex_state = 105, .external_lex_state = 2},
  [818] = {.lex_state = 105, .external_lex_state = 2},
  [819] = {.lex_state = 105, .external_lex_state = 2},
  [820] = {.lex_state = 105, .external_lex_state = 2},
  [821] = {.lex_state = 105, .external_lex_state = 2},
  [822] = {.lex_state = 105, .external_lex_state = 2},
  [823] = {.lex_state = 105, .external_lex_state = 2},
  [824] = {.lex_state = 105, .external_lex_state = 2},
  [825] = {.lex_state = 105, .external_lex_state = 2},
  [826] = {.lex_state = 105, .external_lex_state = 2},
  [827] = {.lex_state = 105, .external_lex_state = 2},
  [828] = {.lex_state = 105, .external_lex_state = 2},
  [829] = {.lex_state = 105, .external_lex_state = 2},
  [830] = {.lex_state = 105, .external_lex_state = 2},
  [831] = {.lex_state = 105, .external_lex_state = 2},
  [832] = {.lex_state = 105, .external_lex_state = 2},
  [833] = {.lex_state = 105, .external_lex_state = 2},
  [834] = {.lex_state = 105, .external_lex_state = 2},
  [835] = {.lex_state = 105, .external_lex_state = 2},
  [836] = {.lex_state = 105, .external_lex_state = 2},
  [837] = {.lex_state = 105, .external_lex_state = 2},
  [838] = {.lex_state = 105, .external_lex_state = 2},
  [839] = {.lex_state = 105, .external_lex_state = 2},
  [840] = {.lex_state = 105, .external_lex_state = 2},
  [841] = {.lex_state = 105, .external_lex_state = 2},
  [842] = {.lex_state = 105, .external_lex_state = 2},
  [843] = {.lex_state = 105, .external_lex_state = 2},
  [844] = {.lex_state = 105, .external_lex_state = 2},
  [845] = {.lex_state = 105, .external_lex_state = 2},
  [846] = {.lex_state = 105, .external_lex_state = 2},
  [847] = {.lex_state = 105, .external_lex_state = 2},
  [848] = {.lex_state = 105, .external_lex_state = 2},
  [849] = {.lex_state = 105, .external_lex_state = 2},
  [850] = {.lex_state = 105, .external_lex_state = 2},
  [851] = {.lex_state = 105, .external_lex_state = 2},
  [852] = {.lex_state = 105, .external_lex_state = 2},
  [853] = {.lex_state = 105, .external_lex_state = 2},
  [854] = {.lex_state = 105, .external_lex_state = 2},
  [855] = {.lex_state = 105, .external_lex_state = 2},
  [856] = {.lex_state = 105, .external_lex_state = 2},
  [857] = {.lex_state = 105, .external_lex_state = 2},
  [858] = {.lex_state = 105, .external_lex_state = 2},
  [859] = {.lex_state = 105, .external_lex_state = 2},
  [860] = {.lex_state = 105, .external_lex_state = 2},
  [861] = {.lex_state = 105, .external_lex_state = 2},
  [862] = {.lex_state = 105, .external_lex_state = 2},
  [863] = {.lex_state = 105, .external_lex_state = 2},
  [864] = {.lex_state = 105, .external_lex_state = 2},
  [865] = {.lex_state = 105, .external_lex_state = 2},
  [866] = {.lex_state = 105, .external_lex_state = 2},
  [867] = {.lex_state = 105, .external_lex_state = 2},
  [868] = {.lex_state = 105, .external_lex_state = 2},
  [869] = {.lex_state = 105, .external_lex_state = 2},
  [870] = {.lex_state = 105, .external_lex_state = 2},
  [871] = {.lex_state = 105, .external_lex_state = 2},
  [872] = {.lex_state = 105, .external_lex_state = 2},
  [873] = {.lex_state = 105, .external_lex_state = 2},
  [874] = {.lex_state = 105, .external_lex_state = 2},
  [875] = {.lex_state = 105, .external_lex_state = 2},
  [876] = {.lex_state = 105, .external_lex_state = 2},
  [877] = {.lex_state = 105, .external_lex_state = 2},
  [878] = {.lex_state = 105, .external_lex_state = 2},
  [879] = {.lex_state = 105, .external_lex_state = 2},
  [880] = {.lex_state = 105, .external_lex_state = 2},
  [881] = {.lex_state = 105, .external_lex_state = 2},
  [882] = {.lex_state = 105, .external_lex_state = 2},
  [883] = {.lex_state = 105, .external_lex_state = 2},
  [884] = {.lex_state = 105, .external_lex_state = 2},
  [885] = {.lex_state = 105, .external_lex_state = 2},
  [886] = {.lex_state = 105, .external_lex_state = 2},
  [887] = {.lex_state = 105, .external_lex_state = 2},
  [888] = {.lex_state = 105, .external_lex_state = 2},
  [889] = {.lex_state = 105, .external_lex_state = 2},
  [890] = {.lex_state = 105, .external_lex_state = 2},
  [891] = {.lex_state = 105, .external_lex_state = 2},
  [892] = {.lex_state = 105, .external_lex_state = 2},
  [893] = {.lex_state = 105, .external_lex_state = 2},
  [894] = {.lex_state = 105, .external_lex_state = 2},
  [895] = {.lex_state = 105, .external_lex_state = 2},
  [896] = {.lex_state = 105, .external_lex_state = 2},
  [897] = {.lex_state = 105, .external_lex_state = 2},
  [898] = {.lex_state = 105, .external_lex_state = 2},
  [899] = {.lex_state = 105, .external_lex_state = 2},
  [900] = {.lex_state = 50, .external_lex_state = 5},
  [901] = {.lex_state = 104, .external_lex_state = 4},
  [902] = {.lex_state = 105, .external_lex_state = 4},
  [903] = {.lex_state = 105, .external_lex_state = 4},
  [904] = {.lex_state = 104, .external_lex_state = 4},
  [905] = {.lex_state = 105, .external_lex_state = 4},
  [906] = {.lex_state = 105, .external_lex_state = 4},
  [907] = {.lex_state = 105, .external_lex_state = 4},
  [908] = {.lex_state = 105, .external_lex_state = 4},
  [909] = {.lex_state = 105, .external_lex_state = 4},
  [910] = {.lex_state = 105, .external_lex_state = 4},
  [911] = {.lex_state = 105, .external_lex_state = 4},
  [912] = {.lex_state = 105, .external_lex_state = 4},
  [913] = {.lex_state = 105, .external_lex_state = 4},
  [914] = {.lex_state = 105, .external_lex_state = 4},
  [915] = {.lex_state = 105, .external_lex_state = 4},
  [916] = {.lex_state = 105, .external_lex_state = 4},
  [917] = {.lex_state = 105, .external_lex_state = 4},
  [918] = {.lex_state = 105, .external_lex_state = 4},
  [919] = {.lex_state = 105, .external_lex_state = 4},
  [920] = {.lex_state = 105, .external_lex_state = 4},
  [921] = {.lex_state = 105, .external_lex_state = 4},
  [922] = {.lex_state = 105, .external_lex_state = 4},
  [923] = {.lex_state = 105, .external_lex_state = 4},
  [924] = {.lex_state = 105, .external_lex_state = 4},
  [925] = {.lex_state = 105, .external_lex_state = 4},
  [926] = {.lex_state = 105, .external_lex_state = 4},
  [927] = {.lex_state = 105, .external_lex_state = 4},
  [928] = {.lex_state = 105, .external_lex_state = 4},
  [929] = {.lex_state = 105, .external_lex_state = 4},
  [930] = {.lex_state = 105, .external_lex_state = 4},
  [931] = {.lex_state = 105, .external_lex_state = 4},
  [932] = {.lex_state = 105, .external_lex_state = 4},
  [933] = {.lex_state = 105, .external_lex_state = 4},
  [934] = {.lex_state = 105, .external_lex_state = 4},
  [935] = {.lex_state = 105, .external_lex_state = 4},
  [936] = {.lex_state = 105, .external_lex_state = 4},
  [937] = {.lex_state = 105, .external_lex_state = 4},
  [938] = {.lex_state = 105, .external_lex_state = 4},
  [939] = {.lex_state = 105, .external_lex_state = 4},
  [940] = {.lex_state = 105, .external_lex_state = 4},
  [941] = {.lex_state = 105, .external_lex_state = 4},
  [942] = {.lex_state = 105, .external_lex_state = 4},
  [943] = {.lex_state = 105, .external_lex_state = 4},
  [944] = {.lex_state = 105, .external_lex_state = 4},
  [945] = {.lex_state = 105, .external_lex_state = 4},
  [946] = {.lex_state = 105, .external_lex_state = 4},
  [947] = {.lex_state = 105, .external_lex_state = 4},
  [948] = {.lex_state = 105, .external_lex_state = 4},
  [949] = {.lex_state = 105, .external_lex_state = 4},
  [950] = {.lex_state = 105, .external_lex_state = 4},
  [951] = {.lex_state = 105, .external_lex_state = 4},
  [952] = {.lex_state = 105, .external_lex_state = 4},
  [953] = {.lex_state = 105, .external_lex_state = 4},
  [954] = {.lex_state = 105, .external_lex_state = 4},
  [955] = {.lex_state = 105, .external_lex_state = 4},
  [956] = {.lex_state = 105, .external_lex_state = 4},
  [957] = {.lex_state = 105, .external_lex_state = 4},
  [958] = {.lex_state = 105, .external_lex_state = 4},
  [959] = {.lex_state = 105, .external_lex_state = 4},
  [960] = {.lex_state = 105, .external_lex_state = 4},
  [961] = {.lex_state = 105, .external_lex_state = 4},
  [962] = {.lex_state = 105, .external_lex_state = 4},
  [963] = {.lex_state = 105, .external_lex_state = 4},
  [964] = {.lex_state = 105, .external_lex_state = 4},
  [965] = {.lex_state = 105, .external_lex_state = 4},
  [966] = {.lex_state = 105, .external_lex_state = 4},
  [967] = {.lex_state = 105, .external_lex_state = 4},
  [968] = {.lex_state = 105, .external_lex_state = 4},
  [969] = {.lex_state = 105, .external_lex_state = 4},
  [970] = {.lex_state = 105, .external_lex_state = 4},
  [971] = {.lex_state = 105, .external_lex_state = 4},
  [972] = {.lex_state = 105, .external_lex_state = 4},
  [973] = {.lex_state = 105, .external_lex_state = 4},
  [974] = {.lex_state = 105, .external_lex_state = 4},
  [975] = {.lex_state = 105, .external_lex_state = 4},
  [976] = {.lex_state = 105, .external_lex_state = 4},
  [977] = {.lex_state = 105, .external_lex_state = 4},
  [978] = {.lex_state = 105, .external_lex_state = 4},
  [979] = {.lex_state = 105, .external_lex_state = 4},
  [980] = {.lex_state = 105, .external_lex_state = 4},
  [981] = {.lex_state = 105, .external_lex_state = 4},
  [982] = {.lex_state = 105, .external_lex_state = 4},
  [983] = {.lex_state = 105, .external_lex_state = 4},
  [984] = {.lex_state = 105, .external_lex_state = 4},
  [985] = {.lex_state = 105, .external_lex_state = 4},
  [986] = {.lex_state = 105, .external_lex_state = 4},
  [987] = {.lex_state = 105, .external_lex_state = 4},
  [988] = {.lex_state = 105, .external_lex_state = 4},
  [989] = {.lex_state = 105, .external_lex_state = 4},
  [990] = {.lex_state = 105, .external_lex_state = 4},
  [991] = {.lex_state = 105, .external_lex_state = 4},
  [992] = {.lex_state = 105, .external_lex_state = 4},
  [993] = {.lex_state = 105, .external_lex_state = 4},
  [994] = {.lex_state = 105, .external_lex_state = 4},
  [995] = {.lex_state = 105, .external_lex_state = 4},
  [996] = {.lex_state = 105, .external_lex_state = 4},
  [997] = {.lex_state = 105, .external_lex_state = 4},
  [998] = {.lex_state = 105, .external_lex_state = 4},
  [999] = {.lex_state = 105, .external_lex_state = 4},
  [1000] = {.lex_state = 105, .external_lex_state = 4},
  [1001] = {.lex_state = 105, .external_lex_state = 4},
  [1002] = {.lex_state = 105, .external_lex_state = 4},
  [1003] = {.lex_state = 105, .external_lex_state = 4},
  [1004] = {.lex_state = 105, .external_lex_state = 4},
  [1005] = {.lex_state = 105, .external_lex_state = 4},
  [1006] = {.lex_state = 105, .external_lex_state = 4},
  [1007] = {.lex_state = 105, .external_lex_state = 4},
  [1008] = {.lex_state = 51, .external_lex_state = 6},
  [1009] = {.lex_state = 49, .external_lex_state = 6},
  [1010] = {.lex_state = 49, .external_lex_state = 4},
  [1011] = {.lex_state = 49, .external_lex_state = 4},
  [1012] = {.lex_state = 49, .external_lex_state = 4},
  [1013] = {.lex_state = 49, .external_lex_state = 4},
  [1014] = {.lex_state = 49, .external_lex_state = 4},
  [1015] = {.lex_state = 49, .external_lex_state = 4},
  [1016] = {.lex_state = 106, .external_lex_state = 12},
  [1017] = {.lex_state = 106, .external_lex_state = 12},
  [1018] = {.lex_state = 106, .external_lex_state = 12},
  [1019] = {.lex_state = 106, .external_lex_state = 12},
  [1020] = {.lex_state = 106, .external_lex_state = 12},
  [1021] = {.lex_state = 3, .external_lex_state = 12},
  [1022] = {.lex_state = 106, .external_lex_state = 13},
  [1023] = {.lex_state = 106, .external_lex_state = 13},
  [1024] = {.lex_state = 3, .external_lex_state = 12},
  [1025] = {.lex_state = 3, .external_lex_state = 12},
  [1026] = {.lex_state = 3, .external_lex_state = 12},
  [1027] = {.lex_state = 106, .external_lex_state = 12},
  [1028] = {.lex_state = 3, .external_lex_state = 12},
  [1029] = {.lex_state = 3, .external_lex_state = 12},
  [1030] = {.lex_state = 3, .external_lex_state = 12},
  [1031] = {.lex_state = 3, .external_lex_state = 12},
  [1032] = {.lex_state = 3, .external_lex_state = 12},
  [1033] = {.lex_state = 3, .external_lex_state = 12},
  [1034] = {.lex_state = 3, .external_lex_state = 12},
  [1035] = {.lex_state = 3, .external_lex_state = 12},
  [1036] = {.lex_state = 3, .external_lex_state = 12},
  [1037] = {.lex_state = 3, .external_lex_state = 12},
  [1038] = {.lex_state = 3, .external_lex_state = 12},
  [1039] = {.lex_state = 3, .external_lex_state = 12},
  [1040] = {.lex_state = 106, .external_lex_state = 12},
  [1041] = {.lex_state = 3, .external_lex_state = 12},
  [1042] = {.lex_state = 3, .external_lex_state = 12},
  [1043] = {.lex_state = 106, .external_lex_state = 12},
  [1044] = {.lex_state = 3, .external_lex_state = 12},
  [1045] = {.lex_state = 3, .external_lex_state = 12},
  [1046] = {.lex_state = 3, .external_lex_state = 12},
  [1047] = {.lex_state = 3, .external_lex_state = 12},
  [1048] = {.lex_state = 3, .external_lex_state = 12},
  [1049] = {.lex_state = 3, .external_lex_state = 12},
  [1050] = {.lex_state = 3, .external_lex_state = 12},
  [1051] = {.lex_state = 5, .external_lex_state = 12},
  [1052] = {.lex_state = 3, .external_lex_state = 12},
  [1053] = {.lex_state = 3, .external_lex_state = 12},
  [1054] = {.lex_state = 3, .external_lex_state = 12},
  [1055] = {.lex_state = 9, .external_lex_state = 12},
  [1056] = {.lex_state = 9, .external_lex_state = 12},
  [1057] = {.lex_state = 7, .external_lex_state = 12},
  [1058] = {.lex_state = 8, .external_lex_state = 12},
  [1059] = {.lex_state = 5, .external_lex_state = 12},
  [1060] = {.lex_state = 7, .external_lex_state = 12},
  [1061] = {.lex_state = 3, .external_lex_state = 12},
  [1062] = {.lex_state = 3, .external_lex_state = 12},
  [1063] = {.lex_state = 3, .external_lex_state = 12},
  [1064] = {.lex_state = 7, .external_lex_state = 12},
  [1065] = {.lex_state = 3, .external_lex_state = 12},
  [1066] = {.lex_state = 7, .external_lex_state = 12},
  [1067] = {.lex_state = 8, .external_lex_state = 12},
  [1068] = {.lex_state = 3, .external_lex_state = 12},
  [1069] = {.lex_state = 3, .external_lex_state = 12},
  [1070] = {.lex_state = 5, .external_lex_state = 12},
  [1071] = {.lex_state = 3, .external_lex_state = 12},
  [1072] = {.lex_state = 3, .external_lex_state = 12},
  [1073] = {.lex_state = 3, .external_lex_state = 12},
  [1074] = {.lex_state = 5, .external_lex_state = 12},
  [1075] = {.lex_state = 8, .external_lex_state = 12},
  [1076] = {.lex_state = 3, .external_lex_state = 12},
  [1077] = {.lex_state = 9, .external_lex_state = 12},
  [1078] = {.lex_state = 7, .external_lex_state = 12},
  [1079] = {.lex_state = 3, .external_lex_state = 12},
  [1080] = {.lex_state = 5, .external_lex_state = 12},
  [1081] = {.lex_state = 3, .external_lex_state = 12},
  [1082] = {.lex_state = 7, .external_lex_state = 12},
  [1083] = {.lex_state = 3, .external_lex_state = 12},
  [1084] = {.lex_state = 3, .external_lex_state = 12},
  [1085] = {.lex_state = 3, .external_lex_state = 12},
  [1086] = {.lex_state = 3, .external_lex_state = 12},
  [1087] = {.lex_state = 3, .external_lex_state = 12},
  [1088] = {.lex_state = 3, .external_lex_state = 12},
  [1089] = {.lex_state = 3, .external_lex_state = 12},
  [1090] = {.lex_state = 3, .external_lex_state = 12},
  [1091] = {.lex_state = 3, .external_lex_state = 12},
  [1092] = {.lex_state = 3, .external_lex_state = 12},
  [1093] = {.lex_state = 8, .external_lex_state = 12},
  [1094] = {.lex_state = 3, .external_lex_state = 12},
  [1095] = {.lex_state = 8, .external_lex_state = 12},
  [1096] = {.lex_state = 3, .external_lex_state = 12},
  [1097] = {.lex_state = 3, .external_lex_state = 12},
  [1098] = {.lex_state = 3, .external_lex_state = 12},
  [1099] = {.lex_state = 3, .external_lex_state = 12},
  [1100] = {.lex_state = 3, .external_lex_state = 12},
  [1101] = {.lex_state = 3, .external_lex_state = 12},
  [1102] = {.lex_state = 3, .external_lex_state = 12},
  [1103] = {.lex_state = 3, .external_lex_state = 12},
  [1104] = {.lex_state = 3, .external_lex_state = 12},
  [1105] = {.lex_state = 3, .external_lex_state = 12},
  [1106] = {.lex_state = 3, .external_lex_state = 12},
  [1107] = {.lex_state = 3, .external_lex_state = 12},
  [1108] = {.lex_state = 3, .external_lex_state = 12},
  [1109] = {.lex_state = 3, .external_lex_state = 12},
  [1110] = {.lex_state = 3, .external_lex_state = 12},
  [1111] = {.lex_state = 3, .external_lex_state = 12},
  [1112] = {.lex_state = 3, .external_lex_state = 12},
  [1113] = {.lex_state = 3, .external_lex_state = 12},
  [1114] = {.lex_state = 3, .external_lex_state = 12},
  [1115] = {.lex_state = 3, .external_lex_state = 12},
  [1116] = {.lex_state = 3, .external_lex_state = 12},
  [1117] = {.lex_state = 3, .external_lex_state = 12},
  [1118] = {.lex_state = 3, .external_lex_state = 12},
  [1119] = {.lex_state = 3, .external_lex_state = 12},
  [1120] = {.lex_state = 3, .external_lex_state = 12},
  [1121] = {.lex_state = 3, .external_lex_state = 12},
  [1122] = {.lex_state = 3, .external_lex_state = 12},
  [1123] = {.lex_state = 3, .external_lex_state = 12},
  [1124] = {.lex_state = 3, .external_lex_state = 12},
  [1125] = {.lex_state = 3, .external_lex_state = 12},
  [1126] = {.lex_state = 3, .external_lex_state = 12},
  [1127] = {.lex_state = 3, .external_lex_state = 12},
  [1128] = {.lex_state = 3, .external_lex_state = 12},
  [1129] = {.lex_state = 3, .external_lex_state = 12},
  [1130] = {.lex_state = 3, .external_lex_state = 12},
  [1131] = {.lex_state = 3, .external_lex_state = 12},
  [1132] = {.lex_state = 3, .external_lex_state = 12},
  [1133] = {.lex_state = 3, .external_lex_state = 12},
  [1134] = {.lex_state = 3, .external_lex_state = 12},
  [1135] = {.lex_state = 3, .external_lex_state = 12},
  [1136] = {.lex_state = 3, .external_lex_state = 12},
  [1137] = {.lex_state = 3, .external_lex_state = 12},
  [1138] = {.lex_state = 3, .external_lex_state = 12},
  [1139] = {.lex_state = 3, .external_lex_state = 12},
  [1140] = {.lex_state = 3, .external_lex_state = 12},
  [1141] = {.lex_state = 3, .external_lex_state = 12},
  [1142] = {.lex_state = 3, .external_lex_state = 12},
  [1143] = {.lex_state = 3, .external_lex_state = 12},
  [1144] = {.lex_state = 3, .external_lex_state = 12},
  [1145] = {.lex_state = 3, .external_lex_state = 12},
  [1146] = {.lex_state = 3, .external_lex_state = 12},
  [1147] = {.lex_state = 3, .external_lex_state = 12},
  [1148] = {.lex_state = 3, .external_lex_state = 12},
  [1149] = {.lex_state = 3, .external_lex_state = 12},
  [1150] = {.lex_state = 3, .external_lex_state = 12},
  [1151] = {.lex_state = 3, .external_lex_state = 12},
  [1152] = {.lex_state = 3, .external_lex_state = 12},
  [1153] = {.lex_state = 3, .external_lex_state = 12},
  [1154] = {.lex_state = 3, .external_lex_state = 12},
  [1155] = {.lex_state = 3, .external_lex_state = 12},
  [1156] = {.lex_state = 3, .external_lex_state = 12},
  [1157] = {.lex_state = 3, .external_lex_state = 12},
  [1158] = {.lex_state = 3, .external_lex_state = 12},
  [1159] = {.lex_state = 3, .external_lex_state = 12},
  [1160] = {.lex_state = 3, .external_lex_state = 12},
  [1161] = {.lex_state = 3, .external_lex_state = 12},
  [1162] = {.lex_state = 3, .external_lex_state = 12},
  [1163] = {.lex_state = 3, .external_lex_state = 12},
  [1164] = {.lex_state = 3, .external_lex_state = 12},
  [1165] = {.lex_state = 3, .external_lex_state = 12},
  [1166] = {.lex_state = 3, .external_lex_state = 12},
  [1167] = {.lex_state = 3, .external_lex_state = 12},
  [1168] = {.lex_state = 3, .external_lex_state = 12},
  [1169] = {.lex_state = 3, .external_lex_state = 12},
  [1170] = {.lex_state = 3, .external_lex_state = 12},
  [1171] = {.lex_state = 3, .external_lex_state = 12},
  [1172] = {.lex_state = 3, .external_lex_state = 12},
  [1173] = {.lex_state = 3, .external_lex_state = 12},
  [1174] = {.lex_state = 3, .external_lex_state = 12},
  [1175] = {.lex_state = 3, .external_lex_state = 12},
  [1176] = {.lex_state = 3, .external_lex_state = 12},
  [1177] = {.lex_state = 3, .external_lex_state = 12},
  [1178] = {.lex_state = 3, .external_lex_state = 12},
  [1179] = {.lex_state = 3, .external_lex_state = 12},
  [1180] = {.lex_state = 3, .external_lex_state = 12},
  [1181] = {.lex_state = 3, .external_lex_state = 12},
  [1182] = {.lex_state = 3, .external_lex_state = 12},
  [1183] = {.lex_state = 3, .external_lex_state = 12},
  [1184] = {.lex_state = 3, .external_lex_state = 12},
  [1185] = {.lex_state = 3, .external_lex_state = 12},
  [1186] = {.lex_state = 3, .external_lex_state = 12},
  [1187] = {.lex_state = 3, .external_lex_state = 12},
  [1188] = {.lex_state = 3, .external_lex_state = 12},
  [1189] = {.lex_state = 3, .external_lex_state = 12},
  [1190] = {.lex_state = 3, .external_lex_state = 12},
  [1191] = {.lex_state = 3, .external_lex_state = 12},
  [1192] = {.lex_state = 3, .external_lex_state = 12},
  [1193] = {.lex_state = 3, .external_lex_state = 12},
  [1194] = {.lex_state = 3, .external_lex_state = 12},
  [1195] = {.lex_state = 3, .external_lex_state = 12},
  [1196] = {.lex_state = 3, .external_lex_state = 12},
  [1197] = {.lex_state = 3, .external_lex_state = 12},
  [1198] = {.lex_state = 3, .external_lex_state = 12},
  [1199] = {.lex_state = 3, .external_lex_state = 12},
  [1200] = {.lex_state = 3, .external_lex_state = 12},
  [1201] = {.lex_state = 3, .external_lex_state = 12},
  [1202] = {.lex_state = 3, .external_lex_state = 12},
  [1203] = {.lex_state = 3, .external_lex_state = 12},
  [1204] = {.lex_state = 3, .external_lex_state = 12},
  [1205] = {.lex_state = 3, .external_lex_state = 12},
  [1206] = {.lex_state = 3, .external_lex_state = 12},
  [1207] = {.lex_state = 3, .external_lex_state = 12},
  [1208] = {.lex_state = 3, .external_lex_state = 12},
  [1209] = {.lex_state = 3, .external_lex_state = 12},
  [1210] = {.lex_state = 3, .external_lex_state = 12},
  [1211] = {.lex_state = 3, .external_lex_state = 12},
  [1212] = {.lex_state = 3, .external_lex_state = 12},
  [1213] = {.lex_state = 3, .external_lex_state = 12},
  [1214] = {.lex_state = 3, .external_lex_state = 12},
  [1215] = {.lex_state = 3, .external_lex_state = 12},
  [1216] = {.lex_state = 3, .external_lex_state = 12},
  [1217] = {.lex_state = 3, .external_lex_state = 12},
  [1218] = {.lex_state = 3, .external_lex_state = 12},
  [1219] = {.lex_state = 3, .external_lex_state = 12},
  [1220] = {.lex_state = 3, .external_lex_state = 12},
  [1221] = {.lex_state = 3, .external_lex_state = 12},
  [1222] = {.lex_state = 3, .external_lex_state = 12},
  [1223] = {.lex_state = 3, .external_lex_state = 12},
  [1224] = {.lex_state = 3, .external_lex_state = 12},
  [1225] = {.lex_state = 3, .external_lex_state = 12},
  [1226] = {.lex_state = 3, .external_lex_state = 12},
  [1227] = {.lex_state = 3, .external_lex_state = 12},
  [1228] = {.lex_state = 3, .external_lex_state = 12},
  [1229] = {.lex_state = 3, .external_lex_state = 12},
  [1230] = {.lex_state = 3, .external_lex_state = 12},
  [1231] = {.lex_state = 3, .external_lex_state = 12},
  [1232] = {.lex_state = 3, .external_lex_state = 12},
  [1233] = {.lex_state = 3, .external_lex_state = 12},
  [1234] = {.lex_state = 3, .external_lex_state = 12},
  [1235] = {.lex_state = 106, .external_lex_state = 12},
  [1236] = {.lex_state = 106, .external_lex_state = 12},
  [1237] = {.lex_state = 106, .external_lex_state = 12},
  [1238] = {.lex_state = 106, .external_lex_state = 12},
  [1239] = {.lex_state = 106, .external_lex_state = 12},
  [1240] = {.lex_state = 106, .external_lex_state = 13},
  [1241] = {.lex_state = 106, .external_lex_state = 14},
  [1242] = {.lex_state = 106, .external_lex_state = 14},
  [1243] = {.lex_state = 106, .external_lex_state = 13},
  [1244] = {.lex_state = 106, .external_lex_state = 14},
  [1245] = {.lex_state = 106, .external_lex_state = 12},
  [1246] = {.lex_state = 106, .external_lex_state = 12},
  [1247] = {.lex_state = 106, .external_lex_state = 12},
  [1248] = {.lex_state = 106, .external_lex_state = 14},
  [1249] = {.lex_state = 106, .external_lex_state = 14},
  [1250] = {.lex_state = 3, .external_lex_state = 14},
  [1251] = {.lex_state = 106, .external_lex_state = 15},
  [1252] = {.lex_state = 106, .external_lex_state = 15},
  [1253] = {.lex_state = 3, .external_lex_state = 14},
  [1254] = {.lex_state = 3, .external_lex_state = 14},
  [1255] = {.lex_state = 3, .external_lex_state = 14},
  [1256] = {.lex_state = 3, .external_lex_state = 14},
  [1257] = {.lex_state = 3, .external_lex_state = 14},
  [1258] = {.lex_state = 3, .external_lex_state = 14},
  [1259] = {.lex_state = 52, .external_lex_state = 14},
  [1260] = {.lex_state = 3, .external_lex_state = 12},
  [1261] = {.lex_state = 52, .external_lex_state = 14},
  [1262] = {.lex_state = 3, .external_lex_state = 12},
  [1263] = {.lex_state = 52, .external_lex_state = 14},
  [1264] = {.lex_state = 106, .external_lex_state = 14},
  [1265] = {.lex_state = 106, .external_lex_state = 14},
  [1266] = {.lex_state = 106, .external_lex_state = 14},
  [1267] = {.lex_state = 3, .external_lex_state = 14},
  [1268] = {.lex_state = 3, .external_lex_state = 14},
  [1269] = {.lex_state = 3, .external_lex_state = 14},
  [1270] = {.lex_state = 3, .external_lex_state = 14},
  [1271] = {.lex_state = 3, .external_lex_state = 14},
  [1272] = {.lex_state = 3, .external_lex_state = 12},
  [1273] = {.lex_state = 3, .external_lex_state = 14},
  [1274] = {.lex_state = 3, .external_lex_state = 12},
  [1275] = {.lex_state = 3, .external_lex_state = 12},
  [1276] = {.lex_state = 3, .external_lex_state = 12},
  [1277] = {.lex_state = 3, .external_lex_state = 14},
  [1278] = {.lex_state = 3, .external_lex_state = 14},
  [1279] = {.lex_state = 3, .external_lex_state = 14},
  [1280] = {.lex_state = 3, .external_lex_state = 14},
  [1281] = {.lex_state = 3, .external_lex_state = 14},
  [1282] = {.lex_state = 3, .external_lex_state = 14},
  [1283] = {.lex_state = 3, .external_lex_state = 14},
  [1284] = {.lex_state = 3, .external_lex_state = 14},
  [1285] = {.lex_state = 3, .external_lex_state = 14},
  [1286] = {.lex_state = 3, .external_lex_state = 14},
  [1287] = {.lex_state = 3, .external_lex_state = 14},
  [1288] = {.lex_state = 3, .external_lex_state = 12},
  [1289] = {.lex_state = 3, .external_lex_state = 12},
  [1290] = {.lex_state = 3, .external_lex_state = 12},
  [1291] = {.lex_state = 3, .external_lex_state = 12},
  [1292] = {.lex_state = 3, .external_lex_state = 12},
  [1293] = {.lex_state = 3, .external_lex_state = 12},
  [1294] = {.lex_state = 3, .external_lex_state = 12},
  [1295] = {.lex_state = 3, .external_lex_state = 12},
  [1296] = {.lex_state = 3, .external_lex_state = 12},
  [1297] = {.lex_state = 3, .external_lex_state = 12},
  [1298] = {.lex_state = 3, .external_lex_state = 12},
  [1299] = {.lex_state = 3, .external_lex_state = 12},
  [1300] = {.lex_state = 3, .external_lex_state = 12},
  [1301] = {.lex_state = 3, .external_lex_state = 12},
  [1302] = {.lex_state = 3, .external_lex_state = 12},
  [1303] = {.lex_state = 3, .external_lex_state = 12},
  [1304] = {.lex_state = 3, .external_lex_state = 12},
  [1305] = {.lex_state = 3, .external_lex_state = 12},
  [1306] = {.lex_state = 3, .external_lex_state = 12},
  [1307] = {.lex_state = 3, .external_lex_state = 12},
  [1308] = {.lex_state = 3, .external_lex_state = 12},
  [1309] = {.lex_state = 3, .external_lex_state = 12},
  [1310] = {.lex_state = 3, .external_lex_state = 12},
  [1311] = {.lex_state = 3, .external_lex_state = 12},
  [1312] = {.lex_state = 3, .external_lex_state = 12},
  [1313] = {.lex_state = 3, .external_lex_state = 12},
  [1314] = {.lex_state = 3, .external_lex_state = 12},
  [1315] = {.lex_state = 3, .external_lex_state = 14},
  [1316] = {.lex_state = 3, .external_lex_state = 14},
  [1317] = {.lex_state = 3, .external_lex_state = 12},
  [1318] = {.lex_state = 5, .external_lex_state = 14},
  [1319] = {.lex_state = 3, .external_lex_state = 14},
  [1320] = {.lex_state = 53, .external_lex_state = 14},
  [1321] = {.lex_state = 3, .external_lex_state = 14},
  [1322] = {.lex_state = 3, .external_lex_state = 14},
  [1323] = {.lex_state = 3, .external_lex_state = 14},
  [1324] = {.lex_state = 3, .external_lex_state = 14},
  [1325] = {.lex_state = 3, .external_lex_state = 14},
  [1326] = {.lex_state = 3, .external_lex_state = 14},
  [1327] = {.lex_state = 53, .external_lex_state = 14},
  [1328] = {.lex_state = 3, .external_lex_state = 14},
  [1329] = {.lex_state = 52, .external_lex_state = 15},
  [1330] = {.lex_state = 3, .external_lex_state = 14},
  [1331] = {.lex_state = 3, .external_lex_state = 14},
  [1332] = {.lex_state = 3, .external_lex_state = 14},
  [1333] = {.lex_state = 3, .external_lex_state = 14},
  [1334] = {.lex_state = 9, .external_lex_state = 14},
  [1335] = {.lex_state = 7, .external_lex_state = 14},
  [1336] = {.lex_state = 5, .external_lex_state = 14},
  [1337] = {.lex_state = 3, .external_lex_state = 14},
  [1338] = {.lex_state = 53, .external_lex_state = 14},
  [1339] = {.lex_state = 3, .external_lex_state = 14},
  [1340] = {.lex_state = 3, .external_lex_state = 14},
  [1341] = {.lex_state = 53, .external_lex_state = 14},
  [1342] = {.lex_state = 5, .external_lex_state = 14},
  [1343] = {.lex_state = 7, .external_lex_state = 14},
  [1344] = {.lex_state = 7, .external_lex_state = 14},
  [1345] = {.lex_state = 53, .external_lex_state = 14},
  [1346] = {.lex_state = 53, .external_lex_state = 14},
  [1347] = {.lex_state = 7, .external_lex_state = 14},
  [1348] = {.lex_state = 9, .external_lex_state = 14},
  [1349] = {.lex_state = 53, .external_lex_state = 14},
  [1350] = {.lex_state = 53, .external_lex_state = 14},
  [1351] = {.lex_state = 53, .external_lex_state = 14},
  [1352] = {.lex_state = 3, .external_lex_state = 14},
  [1353] = {.lex_state = 53, .external_lex_state = 14},
  [1354] = {.lex_state = 53, .external_lex_state = 14},
  [1355] = {.lex_state = 53, .external_lex_state = 14},
  [1356] = {.lex_state = 3, .external_lex_state = 14},
  [1357] = {.lex_state = 53, .external_lex_state = 14},
  [1358] = {.lex_state = 61, .external_lex_state = 16},
  [1359] = {.lex_state = 53, .external_lex_state = 14},
  [1360] = {.lex_state = 61, .external_lex_state = 16},
  [1361] = {.lex_state = 8, .external_lex_state = 14},
  [1362] = {.lex_state = 3, .external_lex_state = 14},
  [1363] = {.lex_state = 53, .external_lex_state = 14},
  [1364] = {.lex_state = 5, .external_lex_state = 14},
  [1365] = {.lex_state = 53, .external_lex_state = 14},
  [1366] = {.lex_state = 61, .external_lex_state = 16},
  [1367] = {.lex_state = 53, .external_lex_state = 14},
  [1368] = {.lex_state = 61, .external_lex_state = 14},
  [1369] = {.lex_state = 3, .external_lex_state = 14},
  [1370] = {.lex_state = 9, .external_lex_state = 14},
  [1371] = {.lex_state = 53, .external_lex_state = 14},
  [1372] = {.lex_state = 53, .external_lex_state = 14},
  [1373] = {.lex_state = 53, .external_lex_state = 14},
  [1374] = {.lex_state = 61, .external_lex_state = 14},
  [1375] = {.lex_state = 3, .external_lex_state = 14},
  [1376] = {.lex_state = 3, .external_lex_state = 14},
  [1377] = {.lex_state = 61, .external_lex_state = 14},
  [1378] = {.lex_state = 3, .external_lex_state = 14},
  [1379] = {.lex_state = 8, .external_lex_state = 14},
  [1380] = {.lex_state = 52, .external_lex_state = 15},
  [1381] = {.lex_state = 53, .external_lex_state = 14},
  [1382] = {.lex_state = 7, .external_lex_state = 14},
  [1383] = {.lex_state = 7, .external_lex_state = 14},
  [1384] = {.lex_state = 8, .external_lex_state = 14},
  [1385] = {.lex_state = 5, .external_lex_state = 14},
  [1386] = {.lex_state = 3, .external_lex_state = 14},
  [1387] = {.lex_state = 53, .external_lex_state = 14},
  [1388] = {.lex_state = 3, .external_lex_state = 14},
  [1389] = {.lex_state = 53, .external_lex_state = 14},
  [1390] = {.lex_state = 8, .external_lex_state = 14},
  [1391] = {.lex_state = 3, .external_lex_state = 14},
  [1392] = {.lex_state = 3, .external_lex_state = 14},
  [1393] = {.lex_state = 8, .external_lex_state = 14},
  [1394] = {.lex_state = 53, .external_lex_state = 14},
  [1395] = {.lex_state = 3, .external_lex_state = 14},
  [1396] = {.lex_state = 3, .external_lex_state = 14},
  [1397] = {.lex_state = 3, .external_lex_state = 14},
  [1398] = {.lex_state = 3, .external_lex_state = 14},
  [1399] = {.lex_state = 3, .external_lex_state = 14},
  [1400] = {.lex_state = 3, .external_lex_state = 14},
  [1401] = {.lex_state = 3, .external_lex_state = 14},
  [1402] = {.lex_state = 3, .external_lex_state = 14},
  [1403] = {.lex_state = 3, .external_lex_state = 14},
  [1404] = {.lex_state = 3, .external_lex_state = 14},
  [1405] = {.lex_state = 3, .external_lex_state = 14},
  [1406] = {.lex_state = 3, .external_lex_state = 14},
  [1407] = {.lex_state = 3, .external_lex_state = 14},
  [1408] = {.lex_state = 3, .external_lex_state = 14},
  [1409] = {.lex_state = 3, .external_lex_state = 14},
  [1410] = {.lex_state = 61, .external_lex_state = 16},
  [1411] = {.lex_state = 3, .external_lex_state = 14},
  [1412] = {.lex_state = 3, .external_lex_state = 14},
  [1413] = {.lex_state = 3, .external_lex_state = 14},
  [1414] = {.lex_state = 3, .external_lex_state = 14},
  [1415] = {.lex_state = 3, .external_lex_state = 14},
  [1416] = {.lex_state = 61, .external_lex_state = 16},
  [1417] = {.lex_state = 3, .external_lex_state = 14},
  [1418] = {.lex_state = 3, .external_lex_state = 14},
  [1419] = {.lex_state = 3, .external_lex_state = 14},
  [1420] = {.lex_state = 3, .external_lex_state = 14},
  [1421] = {.lex_state = 3, .external_lex_state = 14},
  [1422] = {.lex_state = 3, .external_lex_state = 14},
  [1423] = {.lex_state = 3, .external_lex_state = 14},
  [1424] = {.lex_state = 3, .external_lex_state = 14},
  [1425] = {.lex_state = 3, .external_lex_state = 14},
  [1426] = {.lex_state = 3, .external_lex_state = 14},
  [1427] = {.lex_state = 3, .external_lex_state = 14},
  [1428] = {.lex_state = 3, .external_lex_state = 14},
  [1429] = {.lex_state = 3, .external_lex_state = 14},
  [1430] = {.lex_state = 3, .external_lex_state = 14},
  [1431] = {.lex_state = 3, .external_lex_state = 14},
  [1432] = {.lex_state = 3, .external_lex_state = 14},
  [1433] = {.lex_state = 3, .external_lex_state = 14},
  [1434] = {.lex_state = 3, .external_lex_state = 14},
  [1435] = {.lex_state = 3, .external_lex_state = 14},
  [1436] = {.lex_state = 3, .external_lex_state = 14},
  [1437] = {.lex_state = 3, .external_lex_state = 14},
  [1438] = {.lex_state = 3, .external_lex_state = 14},
  [1439] = {.lex_state = 3, .external_lex_state = 14},
  [1440] = {.lex_state = 3, .external_lex_state = 14},
  [1441] = {.lex_state = 3, .external_lex_state = 14},
  [1442] = {.lex_state = 3, .external_lex_state = 14},
  [1443] = {.lex_state = 3, .external_lex_state = 14},
  [1444] = {.lex_state = 3, .external_lex_state = 14},
  [1445] = {.lex_state = 3, .external_lex_state = 14},
  [1446] = {.lex_state = 3, .external_lex_state = 14},
  [1447] = {.lex_state = 3, .external_lex_state = 14},
  [1448] = {.lex_state = 3, .external_lex_state = 14},
  [1449] = {.lex_state = 52, .external_lex_state = 14},
  [1450] = {.lex_state = 3, .external_lex_state = 14},
  [1451] = {.lex_state = 52, .external_lex_state = 14},
  [1452] = {.lex_state = 3, .external_lex_state = 14},
  [1453] = {.lex_state = 3, .external_lex_state = 14},
  [1454] = {.lex_state = 52, .external_lex_state = 14},
  [1455] = {.lex_state = 3, .external_lex_state = 14},
  [1456] = {.lex_state = 3, .external_lex_state = 14},
  [1457] = {.lex_state = 3, .external_lex_state = 14},
  [1458] = {.lex_state = 3, .external_lex_state = 14},
  [1459] = {.lex_state = 3, .external_lex_state = 14},
  [1460] = {.lex_state = 3, .external_lex_state = 14},
  [1461] = {.lex_state = 3, .external_lex_state = 14},
  [1462] = {.lex_state = 3, .external_lex_state = 14},
  [1463] = {.lex_state = 3, .external_lex_state = 14},
  [1464] = {.lex_state = 53, .external_lex_state = 14},
  [1465] = {.lex_state = 3, .external_lex_state = 14},
  [1466] = {.lex_state = 3, .external_lex_state = 14},
  [1467] = {.lex_state = 3, .external_lex_state = 14},
  [1468] = {.lex_state = 3, .external_lex_state = 14},
  [1469] = {.lex_state = 3, .external_lex_state = 14},
  [1470] = {.lex_state = 53, .external_lex_state = 14},
  [1471] = {.lex_state = 3, .external_lex_state = 14},
  [1472] = {.lex_state = 3, .external_lex_state = 14},
  [1473] = {.lex_state = 3, .external_lex_state = 14},
  [1474] = {.lex_state = 3, .external_lex_state = 14},
  [1475] = {.lex_state = 3, .external_lex_state = 14},
  [1476] = {.lex_state = 3, .external_lex_state = 14},
  [1477] = {.lex_state = 3, .external_lex_state = 14},
  [1478] = {.lex_state = 53, .external_lex_state = 14},
  [1479] = {.lex_state = 3, .external_lex_state = 14},
  [1480] = {.lex_state = 3, .external_lex_state = 14},
  [1481] = {.lex_state = 3, .external_lex_state = 14},
  [1482] = {.lex_state = 3, .external_lex_state = 14},
  [1483] = {.lex_state = 3, .external_lex_state = 14},
  [1484] = {.lex_state = 3, .external_lex_state = 14},
  [1485] = {.lex_state = 3, .external_lex_state = 14},
  [1486] = {.lex_state = 3, .external_lex_state = 14},
  [1487] = {.lex_state = 3, .external_lex_state = 14},
  [1488] = {.lex_state = 3, .external_lex_state = 14},
  [1489] = {.lex_state = 3, .external_lex_state = 14},
  [1490] = {.lex_state = 3, .external_lex_state = 14},
  [1491] = {.lex_state = 3, .external_lex_state = 14},
  [1492] = {.lex_state = 3, .external_lex_state = 14},
  [1493] = {.lex_state = 61, .external_lex_state = 14},
  [1494] = {.lex_state = 3, .external_lex_state = 14},
  [1495] = {.lex_state = 3, .external_lex_state = 14},
  [1496] = {.lex_state = 3, .external_lex_state = 14},
  [1497] = {.lex_state = 3, .external_lex_state = 14},
  [1498] = {.lex_state = 3, .external_lex_state = 14},
  [1499] = {.lex_state = 3, .external_lex_state = 14},
  [1500] = {.lex_state = 3, .external_lex_state = 14},
  [1501] = {.lex_state = 61, .external_lex_state = 14},
  [1502] = {.lex_state = 3, .external_lex_state = 14},
  [1503] = {.lex_state = 3, .external_lex_state = 14},
  [1504] = {.lex_state = 3, .external_lex_state = 14},
  [1505] = {.lex_state = 3, .external_lex_state = 14},
  [1506] = {.lex_state = 3, .external_lex_state = 14},
  [1507] = {.lex_state = 3, .external_lex_state = 14},
  [1508] = {.lex_state = 3, .external_lex_state = 14},
  [1509] = {.lex_state = 3, .external_lex_state = 14},
  [1510] = {.lex_state = 3, .external_lex_state = 14},
  [1511] = {.lex_state = 3, .external_lex_state = 14},
  [1512] = {.lex_state = 3, .external_lex_state = 14},
  [1513] = {.lex_state = 3, .external_lex_state = 14},
  [1514] = {.lex_state = 3, .external_lex_state = 14},
  [1515] = {.lex_state = 3, .external_lex_state = 14},
  [1516] = {.lex_state = 3, .external_lex_state = 14},
  [1517] = {.lex_state = 3, .external_lex_state = 14},
  [1518] = {.lex_state = 3, .external_lex_state = 14},
  [1519] = {.lex_state = 3, .external_lex_state = 14},
  [1520] = {.lex_state = 3, .external_lex_state = 14},
  [1521] = {.lex_state = 3, .external_lex_state = 14},
  [1522] = {.lex_state = 55, .external_lex_state = 14},
  [1523] = {.lex_state = 3, .external_lex_state = 14},
  [1524] = {.lex_state = 3, .external_lex_state = 14},
  [1525] = {.lex_state = 3, .external_lex_state = 14},
  [1526] = {.lex_state = 3, .external_lex_state = 14},
  [1527] = {.lex_state = 3, .external_lex_state = 14},
  [1528] = {.lex_state = 3, .external_lex_state = 14},
  [1529] = {.lex_state = 3, .external_lex_state = 14},
  [1530] = {.lex_state = 3, .external_lex_state = 14},
  [1531] = {.lex_state = 3, .external_lex_state = 14},
  [1532] = {.lex_state = 3, .external_lex_state = 14},
  [1533] = {.lex_state = 3, .external_lex_state = 14},
  [1534] = {.lex_state = 3, .external_lex_state = 14},
  [1535] = {.lex_state = 3, .external_lex_state = 14},
  [1536] = {.lex_state = 3, .external_lex_state = 14},
  [1537] = {.lex_state = 3, .external_lex_state = 14},
  [1538] = {.lex_state = 3, .external_lex_state = 14},
  [1539] = {.lex_state = 3, .external_lex_state = 14},
  [1540] = {.lex_state = 3, .external_lex_state = 14},
  [1541] = {.lex_state = 53, .external_lex_state = 14},
  [1542] = {.lex_state = 60, .external_lex_state = 14},
  [1543] = {.lex_state = 60, .external_lex_state = 14},
  [1544] = {.lex_state = 60, .external_lex_state = 14},
  [1545] = {.lex_state = 60, .external_lex_state = 14},
  [1546] = {.lex_state = 60, .external_lex_state = 14},
  [1547] = {.lex_state = 60, .external_lex_state = 14},
  [1548] = {.lex_state = 60, .external_lex_state = 14},
  [1549] = {.lex_state = 60, .external_lex_state = 14},
  [1550] = {.lex_state = 60, .external_lex_state = 14},
  [1551] = {.lex_state = 60, .external_lex_state = 14},
  [1552] = {.lex_state = 60, .external_lex_state = 14},
  [1553] = {.lex_state = 60, .external_lex_state = 14},
  [1554] = {.lex_state = 60, .external_lex_state = 14},
  [1555] = {.lex_state = 53, .external_lex_state = 14},
  [1556] = {.lex_state = 58, .external_lex_state = 14},
  [1557] = {.lex_state = 53, .external_lex_state = 14},
  [1558] = {.lex_state = 60, .external_lex_state = 14},
  [1559] = {.lex_state = 60, .external_lex_state = 14},
  [1560] = {.lex_state = 53, .external_lex_state = 14},
  [1561] = {.lex_state = 53, .external_lex_state = 14},
  [1562] = {.lex_state = 58, .external_lex_state = 14},
  [1563] = {.lex_state = 53, .external_lex_state = 14},
  [1564] = {.lex_state = 53, .external_lex_state = 14},
  [1565] = {.lex_state = 53, .external_lex_state = 14},
  [1566] = {.lex_state = 56, .external_lex_state = 14},
  [1567] = {.lex_state = 58, .external_lex_state = 14},
  [1568] = {.lex_state = 53, .external_lex_state = 14},
  [1569] = {.lex_state = 60, .external_lex_state = 14},
  [1570] = {.lex_state = 53, .external_lex_state = 14},
  [1571] = {.lex_state = 53, .external_lex_state = 14},
  [1572] = {.lex_state = 56, .external_lex_state = 14},
  [1573] = {.lex_state = 58, .external_lex_state = 14},
  [1574] = {.lex_state = 59, .external_lex_state = 14},
  [1575] = {.lex_state = 55, .external_lex_state = 14},
  [1576] = {.lex_state = 53, .external_lex_state = 14},
  [1577] = {.lex_state = 60, .external_lex_state = 14},
  [1578] = {.lex_state = 59, .external_lex_state = 14},
  [1579] = {.lex_state = 59, .external_lex_state = 14},
  [1580] = {.lex_state = 55, .external_lex_state = 14},
  [1581] = {.lex_state = 55, .external_lex_state = 14},
  [1582] = {.lex_state = 59, .external_lex_state = 14},
  [1583] = {.lex_state = 55, .external_lex_state = 14},
  [1584] = {.lex_state = 60, .external_lex_state = 14},
  [1585] = {.lex_state = 61, .external_lex_state = 15},
  [1586] = {.lex_state = 61, .external_lex_state = 15},
  [1587] = {.lex_state = 60, .external_lex_state = 14},
  [1588] = {.lex_state = 60, .external_lex_state = 14},
  [1589] = {.lex_state = 61, .external_lex_state = 17},
  [1590] = {.lex_state = 61, .external_lex_state = 17},
  [1591] = {.lex_state = 60, .external_lex_state = 14},
  [1592] = {.lex_state = 61, .external_lex_state = 14},
  [1593] = {.lex_state = 61, .external_lex_state = 14},
  [1594] = {.lex_state = 53, .external_lex_state = 14},
  [1595] = {.lex_state = 60, .external_lex_state = 14},
  [1596] = {.lex_state = 53, .external_lex_state = 14},
  [1597] = {.lex_state = 60, .external_lex_state = 16},
  [1598] = {.lex_state = 60, .external_lex_state = 16},
  [1599] = {.lex_state = 58, .external_lex_state = 14},
  [1600] = {.lex_state = 56, .external_lex_state = 14},
  [1601] = {.lex_state = 59, .external_lex_state = 14},
  [1602] = {.lex_state = 60, .external_lex_state = 14},
  [1603] = {.lex_state = 60, .external_lex_state = 14},
  [1604] = {.lex_state = 58, .external_lex_state = 14},
  [1605] = {.lex_state = 53, .external_lex_state = 14},
  [1606] = {.lex_state = 53, .external_lex_state = 14},
  [1607] = {.lex_state = 53, .external_lex_state = 14},
  [1608] = {.lex_state = 53, .external_lex_state = 14},
  [1609] = {.lex_state = 53, .external_lex_state = 14},
  [1610] = {.lex_state = 53, .external_lex_state = 14},
  [1611] = {.lex_state = 53, .external_lex_state = 14},
  [1612] = {.lex_state = 53, .external_lex_state = 14},
  [1613] = {.lex_state = 53, .external_lex_state = 14},
  [1614] = {.lex_state = 53, .external_lex_state = 14},
  [1615] = {.lex_state = 53, .external_lex_state = 14},
  [1616] = {.lex_state = 53, .external_lex_state = 14},
  [1617] = {.lex_state = 53, .external_lex_state = 14},
  [1618] = {.lex_state = 53, .external_lex_state = 14},
  [1619] = {.lex_state = 53, .external_lex_state = 14},
  [1620] = {.lex_state = 53, .external_lex_state = 14},
  [1621] = {.lex_state = 53, .external_lex_state = 14},
  [1622] = {.lex_state = 53, .external_lex_state = 14},
  [1623] = {.lex_state = 53, .external_lex_state = 14},
  [1624] = {.lex_state = 53, .external_lex_state = 14},
  [1625] = {.lex_state = 53, .external_lex_state = 14},
  [1626] = {.lex_state = 53, .external_lex_state = 14},
  [1627] = {.lex_state = 53, .external_lex_state = 14},
  [1628] = {.lex_state = 53, .external_lex_state = 14},
  [1629] = {.lex_state = 53, .external_lex_state = 14},
  [1630] = {.lex_state = 53, .external_lex_state = 14},
  [1631] = {.lex_state = 53, .external_lex_state = 14},
  [1632] = {.lex_state = 53, .external_lex_state = 14},
  [1633] = {.lex_state = 53, .external_lex_state = 14},
  [1634] = {.lex_state = 53, .external_lex_state = 14},
  [1635] = {.lex_state = 53, .external_lex_state = 14},
  [1636] = {.lex_state = 60, .external_lex_state = 16},
  [1637] = {.lex_state = 53, .external_lex_state = 14},
  [1638] = {.lex_state = 53, .external_lex_state = 14},
  [1639] = {.lex_state = 53, .external_lex_state = 14},
  [1640] = {.lex_state = 53, .external_lex_state = 14},
  [1641] = {.lex_state = 53, .external_lex_state = 14},
  [1642] = {.lex_state = 53, .external_lex_state = 14},
  [1643] = {.lex_state = 53, .external_lex_state = 14},
  [1644] = {.lex_state = 60, .external_lex_state = 16},
  [1645] = {.lex_state = 53, .external_lex_state = 14},
  [1646] = {.lex_state = 53, .external_lex_state = 14},
  [1647] = {.lex_state = 53, .external_lex_state = 14},
  [1648] = {.lex_state = 53, .external_lex_state = 14},
  [1649] = {.lex_state = 53, .external_lex_state = 14},
  [1650] = {.lex_state = 53, .external_lex_state = 14},
  [1651] = {.lex_state = 53, .external_lex_state = 14},
  [1652] = {.lex_state = 60, .external_lex_state = 16},
  [1653] = {.lex_state = 60, .external_lex_state = 16},
  [1654] = {.lex_state = 53, .external_lex_state = 14},
  [1655] = {.lex_state = 53, .external_lex_state = 14},
  [1656] = {.lex_state = 53, .external_lex_state = 14},
  [1657] = {.lex_state = 53, .external_lex_state = 14},
  [1658] = {.lex_state = 53, .external_lex_state = 14},
  [1659] = {.lex_state = 53, .external_lex_state = 14},
  [1660] = {.lex_state = 53, .external_lex_state = 14},
  [1661] = {.lex_state = 53, .external_lex_state = 14},
  [1662] = {.lex_state = 53, .external_lex_state = 14},
  [1663] = {.lex_state = 53, .external_lex_state = 14},
  [1664] = {.lex_state = 60, .external_lex_state = 16},
  [1665] = {.lex_state = 53, .external_lex_state = 14},
  [1666] = {.lex_state = 53, .external_lex_state = 14},
  [1667] = {.lex_state = 60, .external_lex_state = 16},
  [1668] = {.lex_state = 53, .external_lex_state = 14},
  [1669] = {.lex_state = 60, .external_lex_state = 16},
  [1670] = {.lex_state = 60, .external_lex_state = 16},
  [1671] = {.lex_state = 60, .external_lex_state = 16},
  [1672] = {.lex_state = 53, .external_lex_state = 14},
  [1673] = {.lex_state = 53, .external_lex_state = 14},
  [1674] = {.lex_state = 53, .external_lex_state = 14},
  [1675] = {.lex_state = 53, .external_lex_state = 14},
  [1676] = {.lex_state = 53, .external_lex_state = 14},
  [1677] = {.lex_state = 53, .external_lex_state = 14},
  [1678] = {.lex_state = 53, .external_lex_state = 14},
  [1679] = {.lex_state = 53, .external_lex_state = 14},
  [1680] = {.lex_state = 60, .external_lex_state = 16},
  [1681] = {.lex_state = 53, .external_lex_state = 14},
  [1682] = {.lex_state = 53, .external_lex_state = 14},
  [1683] = {.lex_state = 53, .external_lex_state = 14},
  [1684] = {.lex_state = 53, .external_lex_state = 14},
  [1685] = {.lex_state = 60, .external_lex_state = 16},
  [1686] = {.lex_state = 53, .external_lex_state = 14},
  [1687] = {.lex_state = 53, .external_lex_state = 14},
  [1688] = {.lex_state = 53, .external_lex_state = 14},
  [1689] = {.lex_state = 53, .external_lex_state = 14},
  [1690] = {.lex_state = 53, .external_lex_state = 14},
  [1691] = {.lex_state = 53, .external_lex_state = 14},
  [1692] = {.lex_state = 53, .external_lex_state = 14},
  [1693] = {.lex_state = 60, .external_lex_state = 16},
  [1694] = {.lex_state = 60, .external_lex_state = 16},
  [1695] = {.lex_state = 60, .external_lex_state = 16},
  [1696] = {.lex_state = 60, .external_lex_state = 16},
  [1697] = {.lex_state = 53, .external_lex_state = 14},
  [1698] = {.lex_state = 53, .external_lex_state = 14},
  [1699] = {.lex_state = 53, .external_lex_state = 14},
  [1700] = {.lex_state = 53, .external_lex_state = 14},
  [1701] = {.lex_state = 53, .external_lex_state = 14},
  [1702] = {.lex_state = 53, .external_lex_state = 14},
  [1703] = {.lex_state = 53, .external_lex_state = 14},
  [1704] = {.lex_state = 53, .external_lex_state = 14},
  [1705] = {.lex_state = 53, .external_lex_state = 14},
  [1706] = {.lex_state = 53, .external_lex_state = 14},
  [1707] = {.lex_state = 53, .external_lex_state = 14},
  [1708] = {.lex_state = 53, .external_lex_state = 14},
  [1709] = {.lex_state = 53, .external_lex_state = 14},
  [1710] = {.lex_state = 53, .external_lex_state = 14},
  [1711] = {.lex_state = 53, .external_lex_state = 14},
  [1712] = {.lex_state = 53, .external_lex_state = 14},
  [1713] = {.lex_state = 53, .external_lex_state = 14},
  [1714] = {.lex_state = 53, .external_lex_state = 14},
  [1715] = {.lex_state = 53, .external_lex_state = 14},
  [1716] = {.lex_state = 53, .external_lex_state = 14},
  [1717] = {.lex_state = 53, .external_lex_state = 14},
  [1718] = {.lex_state = 53, .external_lex_state = 14},
  [1719] = {.lex_state = 53, .external_lex_state = 14},
  [1720] = {.lex_state = 53, .external_lex_state = 14},
  [1721] = {.lex_state = 53, .external_lex_state = 14},
  [1722] = {.lex_state = 53, .external_lex_state = 14},
  [1723] = {.lex_state = 53, .external_lex_state = 14},
  [1724] = {.lex_state = 53, .external_lex_state = 14},
  [1725] = {.lex_state = 53, .external_lex_state = 14},
  [1726] = {.lex_state = 53, .external_lex_state = 14},
  [1727] = {.lex_state = 53, .external_lex_state = 14},
  [1728] = {.lex_state = 53, .external_lex_state = 14},
  [1729] = {.lex_state = 53, .external_lex_state = 14},
  [1730] = {.lex_state = 63, .external_lex_state = 14},
  [1731] = {.lex_state = 53, .external_lex_state = 14},
  [1732] = {.lex_state = 53, .external_lex_state = 14},
  [1733] = {.lex_state = 53, .external_lex_state = 14},
  [1734] = {.lex_state = 53, .external_lex_state = 14},
  [1735] = {.lex_state = 53, .external_lex_state = 14},
  [1736] = {.lex_state = 53, .external_lex_state = 14},
  [1737] = {.lex_state = 53, .external_lex_state = 14},
  [1738] = {.lex_state = 53, .external_lex_state = 14},
  [1739] = {.lex_state = 53, .external_lex_state = 14},
  [1740] = {.lex_state = 53, .external_lex_state = 14},
  [1741] = {.lex_state = 53, .external_lex_state = 14},
  [1742] = {.lex_state = 53, .external_lex_state = 14},
  [1743] = {.lex_state = 53, .external_lex_state = 14},
  [1744] = {.lex_state = 53, .external_lex_state = 14},
  [1745] = {.lex_state = 53, .external_lex_state = 14},
  [1746] = {.lex_state = 53, .external_lex_state = 14},
  [1747] = {.lex_state = 53, .external_lex_state = 14},
  [1748] = {.lex_state = 53, .external_lex_state = 14},
  [1749] = {.lex_state = 53, .external_lex_state = 14},
  [1750] = {.lex_state = 61, .external_lex_state = 14},
  [1751] = {.lex_state = 61, .external_lex_state = 14},
  [1752] = {.lex_state = 53, .external_lex_state = 14},
  [1753] = {.lex_state = 61, .external_lex_state = 14},
  [1754] = {.lex_state = 53, .external_lex_state = 14},
  [1755] = {.lex_state = 53, .external_lex_state = 14},
  [1756] = {.lex_state = 53, .external_lex_state = 14},
  [1757] = {.lex_state = 61, .external_lex_state = 16},
  [1758] = {.lex_state = 61, .external_lex_state = 16},
  [1759] = {.lex_state = 61, .external_lex_state = 16},
  [1760] = {.lex_state = 60, .external_lex_state = 16},
  [1761] = {.lex_state = 53, .external_lex_state = 14},
  [1762] = {.lex_state = 53, .external_lex_state = 14},
  [1763] = {.lex_state = 60, .external_lex_state = 16},
  [1764] = {.lex_state = 60, .external_lex_state = 16},
  [1765] = {.lex_state = 53, .external_lex_state = 14},
  [1766] = {.lex_state = 53, .external_lex_state = 14},
  [1767] = {.lex_state = 53, .external_lex_state = 14},
  [1768] = {.lex_state = 60, .external_lex_state = 16},
  [1769] = {.lex_state = 53, .external_lex_state = 14},
  [1770] = {.lex_state = 60, .external_lex_state = 16},
  [1771] = {.lex_state = 60, .external_lex_state = 16},
  [1772] = {.lex_state = 60, .external_lex_state = 16},
  [1773] = {.lex_state = 53, .external_lex_state = 14},
  [1774] = {.lex_state = 53, .external_lex_state = 14},
  [1775] = {.lex_state = 53, .external_lex_state = 14},
  [1776] = {.lex_state = 53, .external_lex_state = 14},
  [1777] = {.lex_state = 60, .external_lex_state = 14},
  [1778] = {.lex_state = 60, .external_lex_state = 14},
  [1779] = {.lex_state = 60, .external_lex_state = 14},
  [1780] = {.lex_state = 53, .external_lex_state = 14},
  [1781] = {.lex_state = 53, .external_lex_state = 14},
  [1782] = {.lex_state = 66, .external_lex_state = 14},
  [1783] = {.lex_state = 60, .external_lex_state = 14},
  [1784] = {.lex_state = 60, .external_lex_state = 16},
  [1785] = {.lex_state = 66, .external_lex_state = 14},
  [1786] = {.lex_state = 64, .external_lex_state = 14},
  [1787] = {.lex_state = 3, .external_lex_state = 14},
  [1788] = {.lex_state = 3, .external_lex_state = 14},
  [1789] = {.lex_state = 63, .external_lex_state = 14},
  [1790] = {.lex_state = 63, .external_lex_state = 16},
  [1791] = {.lex_state = 67, .external_lex_state = 14},
  [1792] = {.lex_state = 67, .external_lex_state = 14},
  [1793] = {.lex_state = 66, .external_lex_state = 14},
  [1794] = {.lex_state = 67, .external_lex_state = 14},
  [1795] = {.lex_state = 63, .external_lex_state = 14},
  [1796] = {.lex_state = 67, .external_lex_state = 14},
  [1797] = {.lex_state = 53, .external_lex_state = 14},
  [1798] = {.lex_state = 63, .external_lex_state = 14},
  [1799] = {.lex_state = 60, .external_lex_state = 14},
  [1800] = {.lex_state = 66, .external_lex_state = 14},
  [1801] = {.lex_state = 60, .external_lex_state = 14},
  [1802] = {.lex_state = 60, .external_lex_state = 16},
  [1803] = {.lex_state = 60, .external_lex_state = 14},
  [1804] = {.lex_state = 63, .external_lex_state = 14},
  [1805] = {.lex_state = 67, .external_lex_state = 14},
  [1806] = {.lex_state = 60, .external_lex_state = 14},
  [1807] = {.lex_state = 60, .external_lex_state = 16},
  [1808] = {.lex_state = 64, .external_lex_state = 14},
  [1809] = {.lex_state = 60, .external_lex_state = 14},
  [1810] = {.lex_state = 60, .external_lex_state = 14},
  [1811] = {.lex_state = 60, .external_lex_state = 14},
  [1812] = {.lex_state = 64, .external_lex_state = 14},
  [1813] = {.lex_state = 66, .external_lex_state = 14},
  [1814] = {.lex_state = 3, .external_lex_state = 14},
  [1815] = {.lex_state = 60, .external_lex_state = 14},
  [1816] = {.lex_state = 60, .external_lex_state = 14},
  [1817] = {.lex_state = 66, .external_lex_state = 14},
  [1818] = {.lex_state = 60, .external_lex_state = 14},
  [1819] = {.lex_state = 53, .external_lex_state = 14},
  [1820] = {.lex_state = 60, .external_lex_state = 14},
  [1821] = {.lex_state = 60, .external_lex_state = 14},
  [1822] = {.lex_state = 60, .external_lex_state = 14},
  [1823] = {.lex_state = 60, .external_lex_state = 14},
  [1824] = {.lex_state = 60, .external_lex_state = 14},
  [1825] = {.lex_state = 60, .external_lex_state = 14},
  [1826] = {.lex_state = 60, .external_lex_state = 14},
  [1827] = {.lex_state = 60, .external_lex_state = 14},
  [1828] = {.lex_state = 60, .external_lex_state = 14},
  [1829] = {.lex_state = 60, .external_lex_state = 14},
  [1830] = {.lex_state = 60, .external_lex_state = 14},
  [1831] = {.lex_state = 60, .external_lex_state = 14},
  [1832] = {.lex_state = 60, .external_lex_state = 14},
  [1833] = {.lex_state = 60, .external_lex_state = 14},
  [1834] = {.lex_state = 60, .external_lex_state = 14},
  [1835] = {.lex_state = 60, .external_lex_state = 14},
  [1836] = {.lex_state = 60, .external_lex_state = 14},
  [1837] = {.lex_state = 60, .external_lex_state = 14},
  [1838] = {.lex_state = 60, .external_lex_state = 14},
  [1839] = {.lex_state = 60, .external_lex_state = 14},
  [1840] = {.lex_state = 60, .external_lex_state = 14},
  [1841] = {.lex_state = 60, .external_lex_state = 14},
  [1842] = {.lex_state = 60, .external_lex_state = 14},
  [1843] = {.lex_state = 60, .external_lex_state = 14},
  [1844] = {.lex_state = 60, .external_lex_state = 14},
  [1845] = {.lex_state = 60, .external_lex_state = 14},
  [1846] = {.lex_state = 60, .external_lex_state = 14},
  [1847] = {.lex_state = 60, .external_lex_state = 14},
  [1848] = {.lex_state = 60, .external_lex_state = 14},
  [1849] = {.lex_state = 60, .external_lex_state = 14},
  [1850] = {.lex_state = 60, .external_lex_state = 14},
  [1851] = {.lex_state = 60, .external_lex_state = 16},
  [1852] = {.lex_state = 66, .external_lex_state = 16},
  [1853] = {.lex_state = 60, .external_lex_state = 14},
  [1854] = {.lex_state = 60, .external_lex_state = 14},
  [1855] = {.lex_state = 60, .external_lex_state = 14},
  [1856] = {.lex_state = 60, .external_lex_state = 16},
  [1857] = {.lex_state = 60, .external_lex_state = 14},
  [1858] = {.lex_state = 60, .external_lex_state = 14},
  [1859] = {.lex_state = 60, .external_lex_state = 16},
  [1860] = {.lex_state = 60, .external_lex_state = 16},
  [1861] = {.lex_state = 60, .external_lex_state = 14},
  [1862] = {.lex_state = 60, .external_lex_state = 16},
  [1863] = {.lex_state = 60, .external_lex_state = 14},
  [1864] = {.lex_state = 60, .external_lex_state = 16},
  [1865] = {.lex_state = 60, .external_lex_state = 14},
  [1866] = {.lex_state = 66, .external_lex_state = 16},
  [1867] = {.lex_state = 60, .external_lex_state = 16},
  [1868] = {.lex_state = 60, .external_lex_state = 14},
  [1869] = {.lex_state = 60, .external_lex_state = 14},
  [1870] = {.lex_state = 60, .external_lex_state = 14},
  [1871] = {.lex_state = 60, .external_lex_state = 16},
  [1872] = {.lex_state = 60, .external_lex_state = 14},
  [1873] = {.lex_state = 60, .external_lex_state = 16},
  [1874] = {.lex_state = 60, .external_lex_state = 16},
  [1875] = {.lex_state = 64, .external_lex_state = 16},
  [1876] = {.lex_state = 66, .external_lex_state = 16},
  [1877] = {.lex_state = 60, .external_lex_state = 14},
  [1878] = {.lex_state = 60, .external_lex_state = 16},
  [1879] = {.lex_state = 60, .external_lex_state = 16},
  [1880] = {.lex_state = 66, .external_lex_state = 16},
  [1881] = {.lex_state = 60, .external_lex_state = 16},
  [1882] = {.lex_state = 60, .external_lex_state = 16},
  [1883] = {.lex_state = 60, .external_lex_state = 16},
  [1884] = {.lex_state = 64, .external_lex_state = 16},
  [1885] = {.lex_state = 66, .external_lex_state = 16},
  [1886] = {.lex_state = 67, .external_lex_state = 16},
  [1887] = {.lex_state = 63, .external_lex_state = 16},
  [1888] = {.lex_state = 60, .external_lex_state = 14},
  [1889] = {.lex_state = 60, .external_lex_state = 14},
  [1890] = {.lex_state = 60, .external_lex_state = 14},
  [1891] = {.lex_state = 60, .external_lex_state = 14},
  [1892] = {.lex_state = 60, .external_lex_state = 14},
  [1893] = {.lex_state = 60, .external_lex_state = 14},
  [1894] = {.lex_state = 60, .external_lex_state = 16},
  [1895] = {.lex_state = 60, .external_lex_state = 14},
  [1896] = {.lex_state = 60, .external_lex_state = 16},
  [1897] = {.lex_state = 60, .external_lex_state = 14},
  [1898] = {.lex_state = 60, .external_lex_state = 14},
  [1899] = {.lex_state = 67, .external_lex_state = 16},
  [1900] = {.lex_state = 67, .external_lex_state = 16},
  [1901] = {.lex_state = 63, .external_lex_state = 16},
  [1902] = {.lex_state = 60, .external_lex_state = 16},
  [1903] = {.lex_state = 63, .external_lex_state = 16},
  [1904] = {.lex_state = 60, .external_lex_state = 16},
  [1905] = {.lex_state = 60, .external_lex_state = 14},
  [1906] = {.lex_state = 60, .external_lex_state = 14},
  [1907] = {.lex_state = 60, .external_lex_state = 14},
  [1908] = {.lex_state = 60, .external_lex_state = 14},
  [1909] = {.lex_state = 66, .external_lex_state = 16},
  [1910] = {.lex_state = 64, .external_lex_state = 16},
  [1911] = {.lex_state = 67, .external_lex_state = 16},
  [1912] = {.lex_state = 67, .external_lex_state = 16},
  [1913] = {.lex_state = 63, .external_lex_state = 16},
  [1914] = {.lex_state = 60, .external_lex_state = 14},
  [1915] = {.lex_state = 60, .external_lex_state = 14},
  [1916] = {.lex_state = 60, .external_lex_state = 14},
  [1917] = {.lex_state = 60, .external_lex_state = 14},
  [1918] = {.lex_state = 60, .external_lex_state = 14},
  [1919] = {.lex_state = 60, .external_lex_state = 16},
  [1920] = {.lex_state = 60, .external_lex_state = 14},
  [1921] = {.lex_state = 60, .external_lex_state = 14},
  [1922] = {.lex_state = 60, .external_lex_state = 14},
  [1923] = {.lex_state = 60, .external_lex_state = 14},
  [1924] = {.lex_state = 60, .external_lex_state = 14},
  [1925] = {.lex_state = 60, .external_lex_state = 14},
  [1926] = {.lex_state = 60, .external_lex_state = 16},
  [1927] = {.lex_state = 60, .external_lex_state = 14},
  [1928] = {.lex_state = 60, .external_lex_state = 14},
  [1929] = {.lex_state = 60, .external_lex_state = 14},
  [1930] = {.lex_state = 60, .external_lex_state = 14},
  [1931] = {.lex_state = 60, .external_lex_state = 14},
  [1932] = {.lex_state = 60, .external_lex_state = 14},
  [1933] = {.lex_state = 60, .external_lex_state = 14},
  [1934] = {.lex_state = 60, .external_lex_state = 14},
  [1935] = {.lex_state = 60, .external_lex_state = 14},
  [1936] = {.lex_state = 60, .external_lex_state = 14},
  [1937] = {.lex_state = 60, .external_lex_state = 14},
  [1938] = {.lex_state = 60, .external_lex_state = 14},
  [1939] = {.lex_state = 60, .external_lex_state = 14},
  [1940] = {.lex_state = 60, .external_lex_state = 14},
  [1941] = {.lex_state = 60, .external_lex_state = 14},
  [1942] = {.lex_state = 60, .external_lex_state = 14},
  [1943] = {.lex_state = 60, .external_lex_state = 14},
  [1944] = {.lex_state = 60, .external_lex_state = 14},
  [1945] = {.lex_state = 60, .external_lex_state = 14},
  [1946] = {.lex_state = 60, .external_lex_state = 14},
  [1947] = {.lex_state = 60, .external_lex_state = 14},
  [1948] = {.lex_state = 60, .external_lex_state = 14},
  [1949] = {.lex_state = 60, .external_lex_state = 14},
  [1950] = {.lex_state = 60, .external_lex_state = 16},
  [1951] = {.lex_state = 60, .external_lex_state = 16},
  [1952] = {.lex_state = 60, .external_lex_state = 16},
  [1953] = {.lex_state = 60, .external_lex_state = 14},
  [1954] = {.lex_state = 60, .external_lex_state = 16},
  [1955] = {.lex_state = 60, .external_lex_state = 14},
  [1956] = {.lex_state = 60, .external_lex_state = 14},
  [1957] = {.lex_state = 60, .external_lex_state = 14},
  [1958] = {.lex_state = 60, .external_lex_state = 14},
  [1959] = {.lex_state = 60, .external_lex_state = 14},
  [1960] = {.lex_state = 60, .external_lex_state = 14},
  [1961] = {.lex_state = 60, .external_lex_state = 14},
  [1962] = {.lex_state = 60, .external_lex_state = 14},
  [1963] = {.lex_state = 60, .external_lex_state = 14},
  [1964] = {.lex_state = 60, .external_lex_state = 14},
  [1965] = {.lex_state = 60, .external_lex_state = 14},
  [1966] = {.lex_state = 60, .external_lex_state = 14},
  [1967] = {.lex_state = 60, .external_lex_state = 14},
  [1968] = {.lex_state = 60, .external_lex_state = 14},
  [1969] = {.lex_state = 60, .external_lex_state = 14},
  [1970] = {.lex_state = 60, .external_lex_state = 14},
  [1971] = {.lex_state = 60, .external_lex_state = 14},
  [1972] = {.lex_state = 60, .external_lex_state = 14},
  [1973] = {.lex_state = 60, .external_lex_state = 14},
  [1974] = {.lex_state = 60, .external_lex_state = 14},
  [1975] = {.lex_state = 60, .external_lex_state = 14},
  [1976] = {.lex_state = 60, .external_lex_state = 14},
  [1977] = {.lex_state = 60, .external_lex_state = 14},
  [1978] = {.lex_state = 60, .external_lex_state = 14},
  [1979] = {.lex_state = 60, .external_lex_state = 14},
  [1980] = {.lex_state = 60, .external_lex_state = 14},
  [1981] = {.lex_state = 60, .external_lex_state = 14},
  [1982] = {.lex_state = 60, .external_lex_state = 14},
  [1983] = {.lex_state = 60, .external_lex_state = 14},
  [1984] = {.lex_state = 60, .external_lex_state = 16},
  [1985] = {.lex_state = 60, .external_lex_state = 16},
  [1986] = {.lex_state = 60, .external_lex_state = 16},
  [1987] = {.lex_state = 60, .external_lex_state = 16},
  [1988] = {.lex_state = 60, .external_lex_state = 16},
  [1989] = {.lex_state = 60, .external_lex_state = 16},
  [1990] = {.lex_state = 60, .external_lex_state = 16},
  [1991] = {.lex_state = 60, .external_lex_state = 16},
  [1992] = {.lex_state = 60, .external_lex_state = 16},
  [1993] = {.lex_state = 60, .external_lex_state = 16},
  [1994] = {.lex_state = 60, .external_lex_state = 16},
  [1995] = {.lex_state = 60, .external_lex_state = 16},
  [1996] = {.lex_state = 60, .external_lex_state = 16},
  [1997] = {.lex_state = 60, .external_lex_state = 16},
  [1998] = {.lex_state = 60, .external_lex_state = 16},
  [1999] = {.lex_state = 60, .external_lex_state = 16},
  [2000] = {.lex_state = 60, .external_lex_state = 16},
  [2001] = {.lex_state = 60, .external_lex_state = 16},
  [2002] = {.lex_state = 60, .external_lex_state = 16},
  [2003] = {.lex_state = 60, .external_lex_state = 16},
  [2004] = {.lex_state = 60, .external_lex_state = 16},
  [2005] = {.lex_state = 60, .external_lex_state = 16},
  [2006] = {.lex_state = 60, .external_lex_state = 16},
  [2007] = {.lex_state = 60, .external_lex_state = 16},
  [2008] = {.lex_state = 60, .external_lex_state = 16},
  [2009] = {.lex_state = 60, .external_lex_state = 16},
  [2010] = {.lex_state = 60, .external_lex_state = 16},
  [2011] = {.lex_state = 60, .external_lex_state = 16},
  [2012] = {.lex_state = 60, .external_lex_state = 16},
  [2013] = {.lex_state = 60, .external_lex_state = 16},
  [2014] = {.lex_state = 60, .external_lex_state = 16},
  [2015] = {.lex_state = 60, .external_lex_state = 16},
  [2016] = {.lex_state = 60, .external_lex_state = 16},
  [2017] = {.lex_state = 60, .external_lex_state = 16},
  [2018] = {.lex_state = 60, .external_lex_state = 16},
  [2019] = {.lex_state = 60, .external_lex_state = 16},
  [2020] = {.lex_state = 60, .external_lex_state = 16},
  [2021] = {.lex_state = 60, .external_lex_state = 16},
  [2022] = {.lex_state = 60, .external_lex_state = 16},
  [2023] = {.lex_state = 60, .external_lex_state = 16},
  [2024] = {.lex_state = 60, .external_lex_state = 16},
  [2025] = {.lex_state = 60, .external_lex_state = 16},
  [2026] = {.lex_state = 60, .external_lex_state = 16},
  [2027] = {.lex_state = 60, .external_lex_state = 16},
  [2028] = {.lex_state = 60, .external_lex_state = 16},
  [2029] = {.lex_state = 60, .external_lex_state = 16},
  [2030] = {.lex_state = 60, .external_lex_state = 16},
  [2031] = {.lex_state = 60, .external_lex_state = 16},
  [2032] = {.lex_state = 60, .external_lex_state = 16},
  [2033] = {.lex_state = 60, .external_lex_state = 16},
  [2034] = {.lex_state = 60, .external_lex_state = 16},
  [2035] = {.lex_state = 60, .external_lex_state = 16},
  [2036] = {.lex_state = 60, .external_lex_state = 16},
  [2037] = {.lex_state = 60, .external_lex_state = 16},
  [2038] = {.lex_state = 60, .external_lex_state = 16},
  [2039] = {.lex_state = 60, .external_lex_state = 16},
  [2040] = {.lex_state = 60, .external_lex_state = 16},
  [2041] = {.lex_state = 60, .external_lex_state = 16},
  [2042] = {.lex_state = 60, .external_lex_state = 16},
  [2043] = {.lex_state = 60, .external_lex_state = 16},
  [2044] = {.lex_state = 60, .external_lex_state = 16},
  [2045] = {.lex_state = 60, .external_lex_state = 16},
  [2046] = {.lex_state = 60, .external_lex_state = 16},
  [2047] = {.lex_state = 60, .external_lex_state = 16},
  [2048] = {.lex_state = 60, .external_lex_state = 16},
  [2049] = {.lex_state = 60, .external_lex_state = 16},
  [2050] = {.lex_state = 60, .external_lex_state = 16},
  [2051] = {.lex_state = 60, .external_lex_state = 16},
  [2052] = {.lex_state = 60, .external_lex_state = 14},
  [2053] = {.lex_state = 60, .external_lex_state = 16},
  [2054] = {.lex_state = 60, .external_lex_state = 16},
  [2055] = {.lex_state = 60, .external_lex_state = 16},
  [2056] = {.lex_state = 60, .external_lex_state = 16},
  [2057] = {.lex_state = 60, .external_lex_state = 16},
  [2058] = {.lex_state = 60, .external_lex_state = 16},
  [2059] = {.lex_state = 60, .external_lex_state = 16},
  [2060] = {.lex_state = 60, .external_lex_state = 16},
  [2061] = {.lex_state = 60, .external_lex_state = 16},
  [2062] = {.lex_state = 60, .external_lex_state = 14},
  [2063] = {.lex_state = 60, .external_lex_state = 14},
  [2064] = {.lex_state = 60, .external_lex_state = 16},
  [2065] = {.lex_state = 60, .external_lex_state = 14},
  [2066] = {.lex_state = 60, .external_lex_state = 14},
  [2067] = {.lex_state = 60, .external_lex_state = 16},
  [2068] = {.lex_state = 60, .external_lex_state = 14},
  [2069] = {.lex_state = 60, .external_lex_state = 16},
  [2070] = {.lex_state = 60, .external_lex_state = 14},
  [2071] = {.lex_state = 60, .external_lex_state = 16},
  [2072] = {.lex_state = 60, .external_lex_state = 16},
  [2073] = {.lex_state = 60, .external_lex_state = 14},
  [2074] = {.lex_state = 60, .external_lex_state = 14},
  [2075] = {.lex_state = 60, .external_lex_state = 14},
  [2076] = {.lex_state = 60, .external_lex_state = 16},
  [2077] = {.lex_state = 60, .external_lex_state = 16},
  [2078] = {.lex_state = 60, .external_lex_state = 14},
  [2079] = {.lex_state = 60, .external_lex_state = 16},
  [2080] = {.lex_state = 60, .external_lex_state = 16},
  [2081] = {.lex_state = 60, .external_lex_state = 16},
  [2082] = {.lex_state = 60, .external_lex_state = 14},
  [2083] = {.lex_state = 60, .external_lex_state = 16},
  [2084] = {.lex_state = 60, .external_lex_state = 16},
  [2085] = {.lex_state = 60, .external_lex_state = 16},
  [2086] = {.lex_state = 60, .external_lex_state = 16},
  [2087] = {.lex_state = 60, .external_lex_state = 16},
  [2088] = {.lex_state = 60, .external_lex_state = 14},
  [2089] = {.lex_state = 60, .external_lex_state = 16},
  [2090] = {.lex_state = 60, .external_lex_state = 16},
  [2091] = {.lex_state = 60, .external_lex_state = 16},
  [2092] = {.lex_state = 60, .external_lex_state = 16},
  [2093] = {.lex_state = 60, .external_lex_state = 16},
  [2094] = {.lex_state = 60, .external_lex_state = 16},
  [2095] = {.lex_state = 60, .external_lex_state = 16},
  [2096] = {.lex_state = 60, .external_lex_state = 16},
  [2097] = {.lex_state = 60, .external_lex_state = 16},
  [2098] = {.lex_state = 60, .external_lex_state = 16},
  [2099] = {.lex_state = 60, .external_lex_state = 16},
  [2100] = {.lex_state = 60, .external_lex_state = 16},
  [2101] = {.lex_state = 60, .external_lex_state = 16},
  [2102] = {.lex_state = 60, .external_lex_state = 16},
  [2103] = {.lex_state = 60, .external_lex_state = 16},
  [2104] = {.lex_state = 60, .external_lex_state = 16},
  [2105] = {.lex_state = 60, .external_lex_state = 16},
  [2106] = {.lex_state = 60, .external_lex_state = 16},
  [2107] = {.lex_state = 60, .external_lex_state = 16},
  [2108] = {.lex_state = 60, .external_lex_state = 16},
  [2109] = {.lex_state = 60, .external_lex_state = 16},
  [2110] = {.lex_state = 60, .external_lex_state = 16},
  [2111] = {.lex_state = 60, .external_lex_state = 16},
  [2112] = {.lex_state = 60, .external_lex_state = 16},
  [2113] = {.lex_state = 60, .external_lex_state = 16},
  [2114] = {.lex_state = 60, .external_lex_state = 16},
  [2115] = {.lex_state = 60, .external_lex_state = 16},
  [2116] = {.lex_state = 60, .external_lex_state = 14},
  [2117] = {.lex_state = 60, .external_lex_state = 14},
  [2118] = {.lex_state = 60, .external_lex_state = 14},
  [2119] = {.lex_state = 60, .external_lex_state = 16},
  [2120] = {.lex_state = 60, .external_lex_state = 16},
  [2121] = {.lex_state = 60, .external_lex_state = 14},
  [2122] = {.lex_state = 60, .external_lex_state = 14},
  [2123] = {.lex_state = 60, .external_lex_state = 14},
  [2124] = {.lex_state = 60, .external_lex_state = 14},
  [2125] = {.lex_state = 60, .external_lex_state = 14},
  [2126] = {.lex_state = 60, .external_lex_state = 14},
  [2127] = {.lex_state = 60, .external_lex_state = 14},
  [2128] = {.lex_state = 60, .external_lex_state = 14},
  [2129] = {.lex_state = 60, .external_lex_state = 14},
  [2130] = {.lex_state = 60, .external_lex_state = 14},
  [2131] = {.lex_state = 60, .external_lex_state = 14},
  [2132] = {.lex_state = 60, .external_lex_state = 14},
  [2133] = {.lex_state = 60, .external_lex_state = 14},
  [2134] = {.lex_state = 60, .external_lex_state = 16},
  [2135] = {.lex_state = 60, .external_lex_state = 16},
  [2136] = {.lex_state = 60, .external_lex_state = 16},
  [2137] = {.lex_state = 60, .external_lex_state = 16},
  [2138] = {.lex_state = 60, .external_lex_state = 16},
  [2139] = {.lex_state = 60, .external_lex_state = 16},
  [2140] = {.lex_state = 60, .external_lex_state = 16},
  [2141] = {.lex_state = 60, .external_lex_state = 14},
  [2142] = {.lex_state = 60, .external_lex_state = 16},
  [2143] = {.lex_state = 60, .external_lex_state = 16},
  [2144] = {.lex_state = 60, .external_lex_state = 16},
  [2145] = {.lex_state = 60, .external_lex_state = 16},
  [2146] = {.lex_state = 60, .external_lex_state = 16},
  [2147] = {.lex_state = 60, .external_lex_state = 16},
  [2148] = {.lex_state = 60, .external_lex_state = 16},
  [2149] = {.lex_state = 60, .external_lex_state = 14},
  [2150] = {.lex_state = 60, .external_lex_state = 14},
  [2151] = {.lex_state = 60, .external_lex_state = 14},
  [2152] = {.lex_state = 60, .external_lex_state = 14},
  [2153] = {.lex_state = 60, .external_lex_state = 14},
  [2154] = {.lex_state = 60, .external_lex_state = 14},
  [2155] = {.lex_state = 60, .external_lex_state = 14},
  [2156] = {.lex_state = 60, .external_lex_state = 14},
  [2157] = {.lex_state = 60, .external_lex_state = 14},
  [2158] = {.lex_state = 60, .external_lex_state = 14},
  [2159] = {.lex_state = 60, .external_lex_state = 14},
  [2160] = {.lex_state = 60, .external_lex_state = 14},
  [2161] = {.lex_state = 60, .external_lex_state = 14},
  [2162] = {.lex_state = 60, .external_lex_state = 14},
  [2163] = {.lex_state = 60, .external_lex_state = 14},
  [2164] = {.lex_state = 60, .external_lex_state = 14},
  [2165] = {.lex_state = 60, .external_lex_state = 14},
  [2166] = {.lex_state = 60, .external_lex_state = 14},
  [2167] = {.lex_state = 60, .external_lex_state = 14},
  [2168] = {.lex_state = 60, .external_lex_state = 14},
  [2169] = {.lex_state = 60, .external_lex_state = 14},
  [2170] = {.lex_state = 60, .external_lex_state = 14},
  [2171] = {.lex_state = 60, .external_lex_state = 14},
  [2172] = {.lex_state = 60, .external_lex_state = 14},
  [2173] = {.lex_state = 60, .external_lex_state = 14},
  [2174] = {.lex_state = 60, .external_lex_state = 14},
  [2175] = {.lex_state = 60, .external_lex_state = 14},
  [2176] = {.lex_state = 60, .external_lex_state = 14},
  [2177] = {.lex_state = 60, .external_lex_state = 14},
  [2178] = {.lex_state = 60, .external_lex_state = 14},
  [2179] = {.lex_state = 60, .external_lex_state = 14},
  [2180] = {.lex_state = 60, .external_lex_state = 14},
  [2181] = {.lex_state = 60, .external_lex_state = 14},
  [2182] = {.lex_state = 60, .external_lex_state = 14},
  [2183] = {.lex_state = 60, .external_lex_state = 14},
  [2184] = {.lex_state = 60, .external_lex_state = 14},
  [2185] = {.lex_state = 60, .external_lex_state = 14},
  [2186] = {.lex_state = 60, .external_lex_state = 14},
  [2187] = {.lex_state = 60, .external_lex_state = 14},
  [2188] = {.lex_state = 60, .external_lex_state = 14},
  [2189] = {.lex_state = 60, .external_lex_state = 14},
  [2190] = {.lex_state = 60, .external_lex_state = 14},
  [2191] = {.lex_state = 60, .external_lex_state = 14},
  [2192] = {.lex_state = 60, .external_lex_state = 14},
  [2193] = {.lex_state = 60, .external_lex_state = 14},
  [2194] = {.lex_state = 60, .external_lex_state = 14},
  [2195] = {.lex_state = 60, .external_lex_state = 14},
  [2196] = {.lex_state = 60, .external_lex_state = 14},
  [2197] = {.lex_state = 60, .external_lex_state = 14},
  [2198] = {.lex_state = 60, .external_lex_state = 14},
  [2199] = {.lex_state = 60, .external_lex_state = 14},
  [2200] = {.lex_state = 10, .external_lex_state = 18},
  [2201] = {.lex_state = 10, .external_lex_state = 18},
  [2202] = {.lex_state = 10, .external_lex_state = 18},
  [2203] = {.lex_state = 10, .external_lex_state = 18},
  [2204] = {.lex_state = 10, .external_lex_state = 18},
  [2205] = {.lex_state = 10, .external_lex_state = 18},
  [2206] = {.lex_state = 10, .external_lex_state = 18},
  [2207] = {.lex_state = 10, .external_lex_state = 18},
  [2208] = {.lex_state = 10, .external_lex_state = 18},
  [2209] = {.lex_state = 10, .external_lex_state = 18},
  [2210] = {.lex_state = 10, .external_lex_state = 19},
  [2211] = {.lex_state = 10, .external_lex_state = 19},
  [2212] = {.lex_state = 10, .external_lex_state = 19},
  [2213] = {.lex_state = 10, .external_lex_state = 19},
  [2214] = {.lex_state = 10, .external_lex_state = 19},
  [2215] = {.lex_state = 10, .external_lex_state = 19},
  [2216] = {.lex_state = 10, .external_lex_state = 19},
  [2217] = {.lex_state = 10, .external_lex_state = 19},
  [2218] = {.lex_state = 10, .external_lex_state = 19},
  [2219] = {.lex_state = 10, .external_lex_state = 19},
  [2220] = {.lex_state = 10, .external_lex_state = 19},
  [2221] = {.lex_state = 10, .external_lex_state = 19},
  [2222] = {.lex_state = 10, .external_lex_state = 19},
  [2223] = {.lex_state = 10, .external_lex_state = 19},
  [2224] = {.lex_state = 10, .external_lex_state = 19},
  [2225] = {.lex_state = 10, .external_lex_state = 19},
  [2226] = {.lex_state = 10, .external_lex_state = 19},
  [2227] = {.lex_state = 10, .external_lex_state = 19},
  [2228] = {.lex_state = 10, .external_lex_state = 19},
  [2229] = {.lex_state = 10, .external_lex_state = 19},
  [2230] = {.lex_state = 10, .external_lex_state = 19},
  [2231] = {.lex_state = 10, .external_lex_state = 19},
  [2232] = {.lex_state = 10, .external_lex_state = 19},
  [2233] = {.lex_state = 10, .external_lex_state = 19},
  [2234] = {.lex_state = 10, .external_lex_state = 19},
  [2235] = {.lex_state = 10, .external_lex_state = 19},
  [2236] = {.lex_state = 10, .external_lex_state = 19},
  [2237] = {.lex_state = 10, .external_lex_state = 19},
  [2238] = {.lex_state = 10, .external_lex_state = 19},
  [2239] = {.lex_state = 10, .external_lex_state = 19},
  [2240] = {.lex_state = 10, .external_lex_state = 20},
  [2241] = {.lex_state = 10, .external_lex_state = 20},
  [2242] = {.lex_state = 10, .external_lex_state = 20},
  [2243] = {.lex_state = 10, .external_lex_state = 20},
  [2244] = {.lex_state = 10, .external_lex_state = 20},
  [2245] = {.lex_state = 10, .external_lex_state = 20},
  [2246] = {.lex_state = 10, .external_lex_state = 18},
  [2247] = {.lex_state = 10, .external_lex_state = 20},
  [2248] = {.lex_state = 10, .external_lex_state = 20},
  [2249] = {.lex_state = 10, .external_lex_state = 20},
  [2250] = {.lex_state = 10, .external_lex_state = 20},
  [2251] = {.lex_state = 10, .external_lex_state = 20},
  [2252] = {.lex_state = 10, .external_lex_state = 20},
  [2253] = {.lex_state = 10, .external_lex_state = 20},
  [2254] = {.lex_state = 10, .external_lex_state = 20},
  [2255] = {.lex_state = 10, .external_lex_state = 20},
  [2256] = {.lex_state = 10, .external_lex_state = 20},
  [2257] = {.lex_state = 10, .external_lex_state = 20},
  [2258] = {.lex_state = 10, .external_lex_state = 20},
  [2259] = {.lex_state = 10, .external_lex_state = 20},
  [2260] = {.lex_state = 10, .external_lex_state = 20},
  [2261] = {.lex_state = 10, .external_lex_state = 20},
  [2262] = {.lex_state = 10, .external_lex_state = 20},
  [2263] = {.lex_state = 10, .external_lex_state = 20},
  [2264] = {.lex_state = 10, .external_lex_state = 20},
  [2265] = {.lex_state = 10, .external_lex_state = 20},
  [2266] = {.lex_state = 10, .external_lex_state = 20},
  [2267] = {.lex_state = 10, .external_lex_state = 20},
  [2268] = {.lex_state = 10, .external_lex_state = 20},
  [2269] = {.lex_state = 10, .external_lex_state = 20},
  [2270] = {.lex_state = 10, .external_lex_state = 20},
  [2271] = {.lex_state = 10, .external_lex_state = 20},
  [2272] = {.lex_state = 10, .external_lex_state = 20},
  [2273] = {.lex_state = 10, .external_lex_state = 20},
  [2274] = {.lex_state = 10, .external_lex_state = 20},
  [2275] = {.lex_state = 10, .external_lex_state = 20},
  [2276] = {.lex_state = 10, .external_lex_state = 20},
  [2277] = {.lex_state = 10, .external_lex_state = 20},
  [2278] = {.lex_state = 10, .external_lex_state = 20},
  [2279] = {.lex_state = 10, .external_lex_state = 20},
  [2280] = {.lex_state = 10, .external_lex_state = 20},
  [2281] = {.lex_state = 10, .external_lex_state = 20},
  [2282] = {.lex_state = 10, .external_lex_state = 20},
  [2283] = {.lex_state = 10, .external_lex_state = 20},
  [2284] = {.lex_state = 10, .external_lex_state = 20},
  [2285] = {.lex_state = 10, .external_lex_state = 20},
  [2286] = {.lex_state = 10, .external_lex_state = 20},
  [2287] = {.lex_state = 10, .external_lex_state = 20},
  [2288] = {.lex_state = 10, .external_lex_state = 20},
  [2289] = {.lex_state = 10, .external_lex_state = 20},
  [2290] = {.lex_state = 10, .external_lex_state = 20},
  [2291] = {.lex_state = 10, .external_lex_state = 20},
  [2292] = {.lex_state = 10, .external_lex_state = 20},
  [2293] = {.lex_state = 10, .external_lex_state = 20},
  [2294] = {.lex_state = 10, .external_lex_state = 20},
  [2295] = {.lex_state = 10, .external_lex_state = 20},
  [2296] = {.lex_state = 10, .external_lex_state = 20},
  [2297] = {.lex_state = 10, .external_lex_state = 20},
  [2298] = {.lex_state = 10, .external_lex_state = 20},
  [2299] = {.lex_state = 10, .external_lex_state = 20},
  [2300] = {.lex_state = 10, .external_lex_state = 19},
  [2301] = {.lex_state = 10, .external_lex_state = 20},
  [2302] = {.lex_state = 10, .external_lex_state = 20},
  [2303] = {.lex_state = 10, .external_lex_state = 21},
  [2304] = {.lex_state = 10, .external_lex_state = 21},
  [2305] = {.lex_state = 10, .external_lex_state = 21},
  [2306] = {.lex_state = 10, .external_lex_state = 12},
  [2307] = {.lex_state = 10, .external_lex_state = 12},
  [2308] = {.lex_state = 10, .external_lex_state = 12},
  [2309] = {.lex_state = 10, .external_lex_state = 12},
  [2310] = {.lex_state = 10, .external_lex_state = 12},
  [2311] = {.lex_state = 10, .external_lex_state = 12},
  [2312] = {.lex_state = 10, .external_lex_state = 12},
  [2313] = {.lex_state = 10, .external_lex_state = 12},
  [2314] = {.lex_state = 10, .external_lex_state = 12},
  [2315] = {.lex_state = 10, .external_lex_state = 12},
  [2316] = {.lex_state = 10, .external_lex_state = 12},
  [2317] = {.lex_state = 10, .external_lex_state = 12},
  [2318] = {.lex_state = 73, .external_lex_state = 22},
  [2319] = {.lex_state = 73, .external_lex_state = 22},
  [2320] = {.lex_state = 73, .external_lex_state = 22},
  [2321] = {.lex_state = 10, .external_lex_state = 12},
  [2322] = {.lex_state = 73, .external_lex_state = 22},
  [2323] = {.lex_state = 10, .external_lex_state = 12},
  [2324] = {.lex_state = 10, .external_lex_state = 12},
  [2325] = {.lex_state = 10, .external_lex_state = 12},
  [2326] = {.lex_state = 10, .external_lex_state = 12},
  [2327] = {.lex_state = 10, .external_lex_state = 12},
  [2328] = {.lex_state = 53, .external_lex_state = 14},
  [2329] = {.lex_state = 12, .external_lex_state = 23},
  [2330] = {.lex_state = 12, .external_lex_state = 14},
  [2331] = {.lex_state = 12, .external_lex_state = 18},
  [2332] = {.lex_state = 53, .external_lex_state = 14},
  [2333] = {.lex_state = 12, .external_lex_state = 23},
  [2334] = {.lex_state = 12, .external_lex_state = 24},
  [2335] = {.lex_state = 12, .external_lex_state = 24},
  [2336] = {.lex_state = 12, .external_lex_state = 24},
  [2337] = {.lex_state = 12, .external_lex_state = 19},
  [2338] = {.lex_state = 53, .external_lex_state = 14},
  [2339] = {.lex_state = 12, .external_lex_state = 24},
  [2340] = {.lex_state = 12, .external_lex_state = 23},
  [2341] = {.lex_state = 12, .external_lex_state = 23},
  [2342] = {.lex_state = 12, .external_lex_state = 24},
  [2343] = {.lex_state = 12, .external_lex_state = 23},
  [2344] = {.lex_state = 12, .external_lex_state = 14},
  [2345] = {.lex_state = 72, .external_lex_state = 25},
  [2346] = {.lex_state = 12, .external_lex_state = 19},
  [2347] = {.lex_state = 72, .external_lex_state = 25},
  [2348] = {.lex_state = 12, .external_lex_state = 19},
  [2349] = {.lex_state = 70, .external_lex_state = 14},
  [2350] = {.lex_state = 10, .external_lex_state = 26},
  [2351] = {.lex_state = 72, .external_lex_state = 27},
  [2352] = {.lex_state = 10, .external_lex_state = 26},
  [2353] = {.lex_state = 12, .external_lex_state = 19},
  [2354] = {.lex_state = 70, .external_lex_state = 14},
  [2355] = {.lex_state = 72, .external_lex_state = 25},
  [2356] = {.lex_state = 10, .external_lex_state = 26},
  [2357] = {.lex_state = 70, .external_lex_state = 14},
  [2358] = {.lex_state = 10, .external_lex_state = 26},
  [2359] = {.lex_state = 72, .external_lex_state = 27},
  [2360] = {.lex_state = 70, .external_lex_state = 14},
  [2361] = {.lex_state = 12, .external_lex_state = 28},
  [2362] = {.lex_state = 12, .external_lex_state = 19},
  [2363] = {.lex_state = 12, .external_lex_state = 19},
  [2364] = {.lex_state = 10, .external_lex_state = 26},
  [2365] = {.lex_state = 53, .external_lex_state = 14},
  [2366] = {.lex_state = 12, .external_lex_state = 28},
  [2367] = {.lex_state = 10, .external_lex_state = 26},
  [2368] = {.lex_state = 12, .external_lex_state = 18},
  [2369] = {.lex_state = 12, .external_lex_state = 18},
  [2370] = {.lex_state = 12, .external_lex_state = 18},
  [2371] = {.lex_state = 70, .external_lex_state = 14},
  [2372] = {.lex_state = 12, .external_lex_state = 18},
  [2373] = {.lex_state = 12, .external_lex_state = 18},
  [2374] = {.lex_state = 10, .external_lex_state = 26},
  [2375] = {.lex_state = 12, .external_lex_state = 18},
  [2376] = {.lex_state = 12, .external_lex_state = 19},
  [2377] = {.lex_state = 10, .external_lex_state = 26},
  [2378] = {.lex_state = 72, .external_lex_state = 25},
  [2379] = {.lex_state = 10, .external_lex_state = 26},
  [2380] = {.lex_state = 72, .external_lex_state = 25},
  [2381] = {.lex_state = 72, .external_lex_state = 25},
  [2382] = {.lex_state = 72, .external_lex_state = 25},
  [2383] = {.lex_state = 72, .external_lex_state = 25},
  [2384] = {.lex_state = 72, .external_lex_state = 25},
  [2385] = {.lex_state = 72, .external_lex_state = 25},
  [2386] = {.lex_state = 72, .external_lex_state = 25},
  [2387] = {.lex_state = 72, .external_lex_state = 25},
  [2388] = {.lex_state = 72, .external_lex_state = 25},
  [2389] = {.lex_state = 72, .external_lex_state = 25},
  [2390] = {.lex_state = 72, .external_lex_state = 25},
  [2391] = {.lex_state = 12, .external_lex_state = 23},
  [2392] = {.lex_state = 12, .external_lex_state = 20},
  [2393] = {.lex_state = 12, .external_lex_state = 28},
  [2394] = {.lex_state = 12, .external_lex_state = 19},
  [2395] = {.lex_state = 12, .external_lex_state = 23},
  [2396] = {.lex_state = 12, .external_lex_state = 18},
  [2397] = {.lex_state = 10, .external_lex_state = 26},
  [2398] = {.lex_state = 12, .external_lex_state = 18},
  [2399] = {.lex_state = 12, .external_lex_state = 19},
  [2400] = {.lex_state = 12, .external_lex_state = 24},
  [2401] = {.lex_state = 12, .external_lex_state = 24},
  [2402] = {.lex_state = 12, .external_lex_state = 28},
  [2403] = {.lex_state = 12, .external_lex_state = 28},
  [2404] = {.lex_state = 12, .external_lex_state = 18},
  [2405] = {.lex_state = 72, .external_lex_state = 25},
  [2406] = {.lex_state = 12, .external_lex_state = 19},
  [2407] = {.lex_state = 72, .external_lex_state = 25},
  [2408] = {.lex_state = 10, .external_lex_state = 12},
  [2409] = {.lex_state = 12, .external_lex_state = 18},
  [2410] = {.lex_state = 10, .external_lex_state = 20},
  [2411] = {.lex_state = 10, .external_lex_state = 20},
  [2412] = {.lex_state = 10, .external_lex_state = 20},
  [2413] = {.lex_state = 10, .external_lex_state = 20},
  [2414] = {.lex_state = 72, .external_lex_state = 14},
  [2415] = {.lex_state = 72, .external_lex_state = 14},
  [2416] = {.lex_state = 72, .external_lex_state = 14},
  [2417] = {.lex_state = 72, .external_lex_state = 14},
  [2418] = {.lex_state = 72, .external_lex_state = 14},
  [2419] = {.lex_state = 72, .external_lex_state = 14},
  [2420] = {.lex_state = 10, .external_lex_state = 20},
  [2421] = {.lex_state = 72, .external_lex_state = 14},
  [2422] = {.lex_state = 12, .external_lex_state = 14},
  [2423] = {.lex_state = 72, .external_lex_state = 14},
  [2424] = {.lex_state = 10, .external_lex_state = 20},
  [2425] = {.lex_state = 72, .external_lex_state = 14},
  [2426] = {.lex_state = 68, .external_lex_state = 14},
  [2427] = {.lex_state = 12, .external_lex_state = 29},
  [2428] = {.lex_state = 12, .external_lex_state = 14},
  [2429] = {.lex_state = 12, .external_lex_state = 14},
  [2430] = {.lex_state = 72, .external_lex_state = 14},
  [2431] = {.lex_state = 12, .external_lex_state = 20},
  [2432] = {.lex_state = 12, .external_lex_state = 19},
  [2433] = {.lex_state = 10, .external_lex_state = 12},
  [2434] = {.lex_state = 12, .external_lex_state = 29},
  [2435] = {.lex_state = 10, .external_lex_state = 20},
  [2436] = {.lex_state = 10, .external_lex_state = 20},
  [2437] = {.lex_state = 10, .external_lex_state = 20},
  [2438] = {.lex_state = 10, .external_lex_state = 20},
  [2439] = {.lex_state = 72, .external_lex_state = 14},
  [2440] = {.lex_state = 72, .external_lex_state = 14},
  [2441] = {.lex_state = 72, .external_lex_state = 14},
  [2442] = {.lex_state = 72, .external_lex_state = 14},
  [2443] = {.lex_state = 72, .external_lex_state = 14},
  [2444] = {.lex_state = 12, .external_lex_state = 18},
  [2445] = {.lex_state = 12, .external_lex_state = 20},
  [2446] = {.lex_state = 12, .external_lex_state = 19},
  [2447] = {.lex_state = 12, .external_lex_state = 29},
  [2448] = {.lex_state = 12, .external_lex_state = 14},
  [2449] = {.lex_state = 72, .external_lex_state = 14},
  [2450] = {.lex_state = 12, .external_lex_state = 18},
  [2451] = {.lex_state = 72, .external_lex_state = 14},
  [2452] = {.lex_state = 68, .external_lex_state = 14},
  [2453] = {.lex_state = 12, .external_lex_state = 14},
  [2454] = {.lex_state = 12, .external_lex_state = 18},
  [2455] = {.lex_state = 12, .external_lex_state = 20},
  [2456] = {.lex_state = 10, .external_lex_state = 20},
  [2457] = {.lex_state = 10, .external_lex_state = 20},
  [2458] = {.lex_state = 10, .external_lex_state = 20},
  [2459] = {.lex_state = 10, .external_lex_state = 20},
  [2460] = {.lex_state = 10, .external_lex_state = 20},
  [2461] = {.lex_state = 72, .external_lex_state = 14},
  [2462] = {.lex_state = 72, .external_lex_state = 14},
  [2463] = {.lex_state = 72, .external_lex_state = 14},
  [2464] = {.lex_state = 72, .external_lex_state = 14},
  [2465] = {.lex_state = 72, .external_lex_state = 14},
  [2466] = {.lex_state = 12, .external_lex_state = 14},
  [2467] = {.lex_state = 10, .external_lex_state = 20},
  [2468] = {.lex_state = 12, .external_lex_state = 20},
  [2469] = {.lex_state = 72, .external_lex_state = 14},
  [2470] = {.lex_state = 68, .external_lex_state = 14},
  [2471] = {.lex_state = 12, .external_lex_state = 19},
  [2472] = {.lex_state = 12, .external_lex_state = 14},
  [2473] = {.lex_state = 12, .external_lex_state = 20},
  [2474] = {.lex_state = 12, .external_lex_state = 29},
  [2475] = {.lex_state = 12, .external_lex_state = 29},
  [2476] = {.lex_state = 12, .external_lex_state = 20},
  [2477] = {.lex_state = 72, .external_lex_state = 14},
  [2478] = {.lex_state = 72, .external_lex_state = 14},
  [2479] = {.lex_state = 72, .external_lex_state = 14},
  [2480] = {.lex_state = 72, .external_lex_state = 14},
  [2481] = {.lex_state = 72, .external_lex_state = 14},
  [2482] = {.lex_state = 10, .external_lex_state = 20},
  [2483] = {.lex_state = 72, .external_lex_state = 14},
  [2484] = {.lex_state = 10, .external_lex_state = 20},
  [2485] = {.lex_state = 72, .external_lex_state = 14},
  [2486] = {.lex_state = 68, .external_lex_state = 14},
  [2487] = {.lex_state = 12, .external_lex_state = 14},
  [2488] = {.lex_state = 72, .external_lex_state = 14},
  [2489] = {.lex_state = 12, .external_lex_state = 14},
  [2490] = {.lex_state = 12, .external_lex_state = 19},
  [2491] = {.lex_state = 12, .external_lex_state = 19},
  [2492] = {.lex_state = 12, .external_lex_state = 19},
  [2493] = {.lex_state = 12, .external_lex_state = 19},
  [2494] = {.lex_state = 12, .external_lex_state = 18},
  [2495] = {.lex_state = 12, .external_lex_state = 18},
  [2496] = {.lex_state = 12, .external_lex_state = 19},
  [2497] = {.lex_state = 72, .external_lex_state = 14},
  [2498] = {.lex_state = 68, .external_lex_state = 14},
  [2499] = {.lex_state = 10, .external_lex_state = 20},
  [2500] = {.lex_state = 12, .external_lex_state = 19},
  [2501] = {.lex_state = 12, .external_lex_state = 19},
  [2502] = {.lex_state = 72, .external_lex_state = 14},
  [2503] = {.lex_state = 12, .external_lex_state = 18},
  [2504] = {.lex_state = 12, .external_lex_state = 18},
  [2505] = {.lex_state = 12, .external_lex_state = 18},
  [2506] = {.lex_state = 12, .external_lex_state = 18},
  [2507] = {.lex_state = 12, .external_lex_state = 14},
  [2508] = {.lex_state = 12, .external_lex_state = 20},
  [2509] = {.lex_state = 12, .external_lex_state = 19},
  [2510] = {.lex_state = 12, .external_lex_state = 28},
  [2511] = {.lex_state = 12, .external_lex_state = 28},
  [2512] = {.lex_state = 12, .external_lex_state = 18},
  [2513] = {.lex_state = 72, .external_lex_state = 14},
  [2514] = {.lex_state = 72, .external_lex_state = 14},
  [2515] = {.lex_state = 72, .external_lex_state = 14},
  [2516] = {.lex_state = 72, .external_lex_state = 14},
  [2517] = {.lex_state = 72, .external_lex_state = 14},
  [2518] = {.lex_state = 10, .external_lex_state = 20},
  [2519] = {.lex_state = 12, .external_lex_state = 20},
  [2520] = {.lex_state = 12, .external_lex_state = 21},
  [2521] = {.lex_state = 12, .external_lex_state = 20},
  [2522] = {.lex_state = 12, .external_lex_state = 14},
  [2523] = {.lex_state = 12, .external_lex_state = 20},
  [2524] = {.lex_state = 68, .external_lex_state = 30},
  [2525] = {.lex_state = 12, .external_lex_state = 20},
  [2526] = {.lex_state = 10, .external_lex_state = 26},
  [2527] = {.lex_state = 71, .external_lex_state = 14},
  [2528] = {.lex_state = 68, .external_lex_state = 30},
  [2529] = {.lex_state = 68, .external_lex_state = 30},
  [2530] = {.lex_state = 68, .external_lex_state = 30},
  [2531] = {.lex_state = 68, .external_lex_state = 30},
  [2532] = {.lex_state = 12, .external_lex_state = 20},
  [2533] = {.lex_state = 12, .external_lex_state = 20},
  [2534] = {.lex_state = 12, .external_lex_state = 29},
  [2535] = {.lex_state = 12, .external_lex_state = 29},
  [2536] = {.lex_state = 68, .external_lex_state = 30},
  [2537] = {.lex_state = 12, .external_lex_state = 20},
  [2538] = {.lex_state = 12, .external_lex_state = 20},
  [2539] = {.lex_state = 68, .external_lex_state = 30},
  [2540] = {.lex_state = 68, .external_lex_state = 30},
  [2541] = {.lex_state = 68, .external_lex_state = 30},
  [2542] = {.lex_state = 12, .external_lex_state = 20},
  [2543] = {.lex_state = 68, .external_lex_state = 30},
  [2544] = {.lex_state = 68, .external_lex_state = 30},
  [2545] = {.lex_state = 71, .external_lex_state = 14},
  [2546] = {.lex_state = 12, .external_lex_state = 21},
  [2547] = {.lex_state = 12, .external_lex_state = 21},
  [2548] = {.lex_state = 12, .external_lex_state = 21},
  [2549] = {.lex_state = 12, .external_lex_state = 21},
  [2550] = {.lex_state = 68, .external_lex_state = 30},
  [2551] = {.lex_state = 68, .external_lex_state = 30},
  [2552] = {.lex_state = 12, .external_lex_state = 21},
  [2553] = {.lex_state = 12, .external_lex_state = 14},
  [2554] = {.lex_state = 68, .external_lex_state = 30},
  [2555] = {.lex_state = 68, .external_lex_state = 30},
  [2556] = {.lex_state = 68, .external_lex_state = 30},
  [2557] = {.lex_state = 12, .external_lex_state = 20},
  [2558] = {.lex_state = 68, .external_lex_state = 16},
  [2559] = {.lex_state = 68, .external_lex_state = 30},
  [2560] = {.lex_state = 68, .external_lex_state = 30},
  [2561] = {.lex_state = 68, .external_lex_state = 30},
  [2562] = {.lex_state = 68, .external_lex_state = 30},
  [2563] = {.lex_state = 68, .external_lex_state = 30},
  [2564] = {.lex_state = 71, .external_lex_state = 14},
  [2565] = {.lex_state = 12, .external_lex_state = 20},
  [2566] = {.lex_state = 68, .external_lex_state = 16},
  [2567] = {.lex_state = 68, .external_lex_state = 30},
  [2568] = {.lex_state = 68, .external_lex_state = 16},
  [2569] = {.lex_state = 68, .external_lex_state = 30},
  [2570] = {.lex_state = 68, .external_lex_state = 30},
  [2571] = {.lex_state = 68, .external_lex_state = 16},
  [2572] = {.lex_state = 12, .external_lex_state = 21},
  [2573] = {.lex_state = 68, .external_lex_state = 30},
  [2574] = {.lex_state = 68, .external_lex_state = 30},
  [2575] = {.lex_state = 12, .external_lex_state = 21},
  [2576] = {.lex_state = 12, .external_lex_state = 20},
  [2577] = {.lex_state = 68, .external_lex_state = 30},
  [2578] = {.lex_state = 12, .external_lex_state = 21},
  [2579] = {.lex_state = 68, .external_lex_state = 16},
  [2580] = {.lex_state = 68, .external_lex_state = 16},
  [2581] = {.lex_state = 68, .external_lex_state = 16},
  [2582] = {.lex_state = 12, .external_lex_state = 20},
  [2583] = {.lex_state = 68, .external_lex_state = 30},
  [2584] = {.lex_state = 68, .external_lex_state = 30},
  [2585] = {.lex_state = 68, .external_lex_state = 30},
  [2586] = {.lex_state = 68, .external_lex_state = 30},
  [2587] = {.lex_state = 12, .external_lex_state = 21},
  [2588] = {.lex_state = 71, .external_lex_state = 14},
  [2589] = {.lex_state = 10, .external_lex_state = 20},
  [2590] = {.lex_state = 68, .external_lex_state = 30},
  [2591] = {.lex_state = 68, .external_lex_state = 30},
  [2592] = {.lex_state = 68, .external_lex_state = 30},
  [2593] = {.lex_state = 68, .external_lex_state = 30},
  [2594] = {.lex_state = 71, .external_lex_state = 14},
  [2595] = {.lex_state = 68, .external_lex_state = 16},
  [2596] = {.lex_state = 68, .external_lex_state = 30},
  [2597] = {.lex_state = 12, .external_lex_state = 21},
  [2598] = {.lex_state = 10, .external_lex_state = 18},
  [2599] = {.lex_state = 12, .external_lex_state = 21},
  [2600] = {.lex_state = 12, .external_lex_state = 21},
  [2601] = {.lex_state = 12, .external_lex_state = 21},
  [2602] = {.lex_state = 10, .external_lex_state = 18},
  [2603] = {.lex_state = 10, .external_lex_state = 19},
  [2604] = {.lex_state = 10, .external_lex_state = 18},
  [2605] = {.lex_state = 10, .external_lex_state = 19},
  [2606] = {.lex_state = 10, .external_lex_state = 19},
  [2607] = {.lex_state = 12, .external_lex_state = 21},
  [2608] = {.lex_state = 10, .external_lex_state = 19},
  [2609] = {.lex_state = 10, .external_lex_state = 19},
  [2610] = {.lex_state = 10, .external_lex_state = 18},
  [2611] = {.lex_state = 10, .external_lex_state = 18},
  [2612] = {.lex_state = 75, .external_lex_state = 16},
  [2613] = {.lex_state = 12, .external_lex_state = 21},
  [2614] = {.lex_state = 75, .external_lex_state = 16},
  [2615] = {.lex_state = 75, .external_lex_state = 14},
  [2616] = {.lex_state = 75, .external_lex_state = 14},
  [2617] = {.lex_state = 68, .external_lex_state = 31},
  [2618] = {.lex_state = 12, .external_lex_state = 21},
  [2619] = {.lex_state = 10, .external_lex_state = 19},
  [2620] = {.lex_state = 10, .external_lex_state = 18},
  [2621] = {.lex_state = 10, .external_lex_state = 19},
  [2622] = {.lex_state = 10, .external_lex_state = 19},
  [2623] = {.lex_state = 10, .external_lex_state = 19},
  [2624] = {.lex_state = 10, .external_lex_state = 18},
  [2625] = {.lex_state = 10, .external_lex_state = 18},
  [2626] = {.lex_state = 10, .external_lex_state = 18},
  [2627] = {.lex_state = 10, .external_lex_state = 18},
  [2628] = {.lex_state = 10, .external_lex_state = 18},
  [2629] = {.lex_state = 12, .external_lex_state = 21},
  [2630] = {.lex_state = 10, .external_lex_state = 19},
  [2631] = {.lex_state = 10, .external_lex_state = 18},
  [2632] = {.lex_state = 10, .external_lex_state = 19},
  [2633] = {.lex_state = 12, .external_lex_state = 21},
  [2634] = {.lex_state = 68, .external_lex_state = 30},
  [2635] = {.lex_state = 68, .external_lex_state = 30},
  [2636] = {.lex_state = 10, .external_lex_state = 19},
  [2637] = {.lex_state = 10, .external_lex_state = 18},
  [2638] = {.lex_state = 10, .external_lex_state = 18},
  [2639] = {.lex_state = 68, .external_lex_state = 30},
  [2640] = {.lex_state = 10, .external_lex_state = 18},
  [2641] = {.lex_state = 10, .external_lex_state = 19},
  [2642] = {.lex_state = 75, .external_lex_state = 16},
  [2643] = {.lex_state = 12, .external_lex_state = 21},
  [2644] = {.lex_state = 75, .external_lex_state = 16},
  [2645] = {.lex_state = 68, .external_lex_state = 31},
  [2646] = {.lex_state = 10, .external_lex_state = 19},
  [2647] = {.lex_state = 12, .external_lex_state = 21},
  [2648] = {.lex_state = 10, .external_lex_state = 18},
  [2649] = {.lex_state = 68, .external_lex_state = 30},
  [2650] = {.lex_state = 10, .external_lex_state = 19},
  [2651] = {.lex_state = 68, .external_lex_state = 30},
  [2652] = {.lex_state = 10, .external_lex_state = 19},
  [2653] = {.lex_state = 10, .external_lex_state = 19},
  [2654] = {.lex_state = 10, .external_lex_state = 19},
  [2655] = {.lex_state = 68, .external_lex_state = 30},
  [2656] = {.lex_state = 68, .external_lex_state = 30},
  [2657] = {.lex_state = 10, .external_lex_state = 18},
  [2658] = {.lex_state = 68, .external_lex_state = 30},
  [2659] = {.lex_state = 52, .external_lex_state = 14},
  [2660] = {.lex_state = 68, .external_lex_state = 30},
  [2661] = {.lex_state = 10, .external_lex_state = 14},
  [2662] = {.lex_state = 10, .external_lex_state = 20},
  [2663] = {.lex_state = 10, .external_lex_state = 20},
  [2664] = {.lex_state = 10, .external_lex_state = 20},
  [2665] = {.lex_state = 52, .external_lex_state = 14},
  [2666] = {.lex_state = 10, .external_lex_state = 26},
  [2667] = {.lex_state = 10, .external_lex_state = 20},
  [2668] = {.lex_state = 10, .external_lex_state = 26},
  [2669] = {.lex_state = 68, .external_lex_state = 16},
  [2670] = {.lex_state = 10, .external_lex_state = 20},
  [2671] = {.lex_state = 52, .external_lex_state = 14},
  [2672] = {.lex_state = 10, .external_lex_state = 20},
  [2673] = {.lex_state = 10, .external_lex_state = 20},
  [2674] = {.lex_state = 10, .external_lex_state = 20},
  [2675] = {.lex_state = 75, .external_lex_state = 16},
  [2676] = {.lex_state = 10, .external_lex_state = 20},
  [2677] = {.lex_state = 10, .external_lex_state = 20},
  [2678] = {.lex_state = 10, .external_lex_state = 20},
  [2679] = {.lex_state = 10, .external_lex_state = 14},
  [2680] = {.lex_state = 10, .external_lex_state = 12},
  [2681] = {.lex_state = 68, .external_lex_state = 30},
  [2682] = {.lex_state = 10, .external_lex_state = 20},
  [2683] = {.lex_state = 10, .external_lex_state = 12},
  [2684] = {.lex_state = 10, .external_lex_state = 20},
  [2685] = {.lex_state = 68, .external_lex_state = 30},
  [2686] = {.lex_state = 10, .external_lex_state = 26},
  [2687] = {.lex_state = 10, .external_lex_state = 26},
  [2688] = {.lex_state = 10, .external_lex_state = 20},
  [2689] = {.lex_state = 10, .external_lex_state = 20},
  [2690] = {.lex_state = 52, .external_lex_state = 14},
  [2691] = {.lex_state = 52, .external_lex_state = 14},
  [2692] = {.lex_state = 10, .external_lex_state = 14},
  [2693] = {.lex_state = 10, .external_lex_state = 20},
  [2694] = {.lex_state = 10, .external_lex_state = 20},
  [2695] = {.lex_state = 52, .external_lex_state = 14},
  [2696] = {.lex_state = 10, .external_lex_state = 20},
  [2697] = {.lex_state = 68, .external_lex_state = 16},
  [2698] = {.lex_state = 10, .external_lex_state = 14},
  [2699] = {.lex_state = 10, .external_lex_state = 20},
  [2700] = {.lex_state = 10, .external_lex_state = 12},
  [2701] = {.lex_state = 68, .external_lex_state = 16},
  [2702] = {.lex_state = 10, .external_lex_state = 12},
  [2703] = {.lex_state = 52, .external_lex_state = 14},
  [2704] = {.lex_state = 75, .external_lex_state = 16},
  [2705] = {.lex_state = 10, .external_lex_state = 20},
  [2706] = {.lex_state = 10, .external_lex_state = 20},
  [2707] = {.lex_state = 10, .external_lex_state = 21},
  [2708] = {.lex_state = 10, .external_lex_state = 21},
  [2709] = {.lex_state = 68, .external_lex_state = 31},
  [2710] = {.lex_state = 12, .external_lex_state = 14},
  [2711] = {.lex_state = 10, .external_lex_state = 21},
  [2712] = {.lex_state = 10, .external_lex_state = 21},
  [2713] = {.lex_state = 10, .external_lex_state = 21},
  [2714] = {.lex_state = 12, .external_lex_state = 14},
  [2715] = {.lex_state = 12, .external_lex_state = 12},
  [2716] = {.lex_state = 10, .external_lex_state = 21},
  [2717] = {.lex_state = 10, .external_lex_state = 21},
  [2718] = {.lex_state = 10, .external_lex_state = 21},
  [2719] = {.lex_state = 10, .external_lex_state = 21},
  [2720] = {.lex_state = 10, .external_lex_state = 21},
  [2721] = {.lex_state = 10, .external_lex_state = 21},
  [2722] = {.lex_state = 10, .external_lex_state = 21},
  [2723] = {.lex_state = 12, .external_lex_state = 12},
  [2724] = {.lex_state = 10, .external_lex_state = 21},
  [2725] = {.lex_state = 68, .external_lex_state = 31},
  [2726] = {.lex_state = 10, .external_lex_state = 21},
  [2727] = {.lex_state = 68, .external_lex_state = 31},
  [2728] = {.lex_state = 10, .external_lex_state = 21},
  [2729] = {.lex_state = 68, .external_lex_state = 32},
  [2730] = {.lex_state = 106, .external_lex_state = 33},
  [2731] = {.lex_state = 75, .external_lex_state = 14},
  [2732] = {.lex_state = 106, .external_lex_state = 33},
  [2733] = {.lex_state = 3, .external_lex_state = 30},
  [2734] = {.lex_state = 3, .external_lex_state = 30},
  [2735] = {.lex_state = 106, .external_lex_state = 33},
  [2736] = {.lex_state = 3, .external_lex_state = 30},
  [2737] = {.lex_state = 3, .external_lex_state = 30},
  [2738] = {.lex_state = 3, .external_lex_state = 30},
  [2739] = {.lex_state = 3, .external_lex_state = 30},
  [2740] = {.lex_state = 3, .external_lex_state = 30},
  [2741] = {.lex_state = 3, .external_lex_state = 30},
  [2742] = {.lex_state = 106, .external_lex_state = 33},
  [2743] = {.lex_state = 106, .external_lex_state = 33},
  [2744] = {.lex_state = 3, .external_lex_state = 30},
  [2745] = {.lex_state = 3, .external_lex_state = 30},
  [2746] = {.lex_state = 106, .external_lex_state = 33},
  [2747] = {.lex_state = 3, .external_lex_state = 30},
  [2748] = {.lex_state = 3, .external_lex_state = 30},
  [2749] = {.lex_state = 3, .external_lex_state = 30},
  [2750] = {.lex_state = 3, .external_lex_state = 30},
  [2751] = {.lex_state = 106, .external_lex_state = 33},
  [2752] = {.lex_state = 75, .external_lex_state = 14},
  [2753] = {.lex_state = 3, .external_lex_state = 30},
  [2754] = {.lex_state = 3, .external_lex_state = 30},
  [2755] = {.lex_state = 106, .external_lex_state = 33},
  [2756] = {.lex_state = 75, .external_lex_state = 14},
  [2757] = {.lex_state = 3, .external_lex_state = 30},
  [2758] = {.lex_state = 3, .external_lex_state = 30},
  [2759] = {.lex_state = 3, .external_lex_state = 16},
  [2760] = {.lex_state = 3, .external_lex_state = 30},
  [2761] = {.lex_state = 3, .external_lex_state = 30},
  [2762] = {.lex_state = 3, .external_lex_state = 30},
  [2763] = {.lex_state = 75, .external_lex_state = 14},
  [2764] = {.lex_state = 106, .external_lex_state = 33},
  [2765] = {.lex_state = 69, .external_lex_state = 14},
  [2766] = {.lex_state = 3, .external_lex_state = 30},
  [2767] = {.lex_state = 3, .external_lex_state = 30},
  [2768] = {.lex_state = 3, .external_lex_state = 30},
  [2769] = {.lex_state = 3, .external_lex_state = 30},
  [2770] = {.lex_state = 75, .external_lex_state = 14},
  [2771] = {.lex_state = 106, .external_lex_state = 33},
  [2772] = {.lex_state = 106, .external_lex_state = 33},
  [2773] = {.lex_state = 106, .external_lex_state = 33},
  [2774] = {.lex_state = 106, .external_lex_state = 33},
  [2775] = {.lex_state = 106, .external_lex_state = 33},
  [2776] = {.lex_state = 106, .external_lex_state = 33},
  [2777] = {.lex_state = 106, .external_lex_state = 33},
  [2778] = {.lex_state = 106, .external_lex_state = 33},
  [2779] = {.lex_state = 3, .external_lex_state = 30},
  [2780] = {.lex_state = 68, .external_lex_state = 17},
  [2781] = {.lex_state = 106, .external_lex_state = 33},
  [2782] = {.lex_state = 3, .external_lex_state = 30},
  [2783] = {.lex_state = 68, .external_lex_state = 17},
  [2784] = {.lex_state = 106, .external_lex_state = 33},
  [2785] = {.lex_state = 106, .external_lex_state = 33},
  [2786] = {.lex_state = 3, .external_lex_state = 16},
  [2787] = {.lex_state = 3, .external_lex_state = 16},
  [2788] = {.lex_state = 68, .external_lex_state = 32},
  [2789] = {.lex_state = 3, .external_lex_state = 30},
  [2790] = {.lex_state = 3, .external_lex_state = 30},
  [2791] = {.lex_state = 3, .external_lex_state = 30},
  [2792] = {.lex_state = 3, .external_lex_state = 30},
  [2793] = {.lex_state = 3, .external_lex_state = 30},
  [2794] = {.lex_state = 3, .external_lex_state = 30},
  [2795] = {.lex_state = 3, .external_lex_state = 16},
  [2796] = {.lex_state = 3, .external_lex_state = 30},
  [2797] = {.lex_state = 3, .external_lex_state = 30},
  [2798] = {.lex_state = 69, .external_lex_state = 14},
  [2799] = {.lex_state = 3, .external_lex_state = 30},
  [2800] = {.lex_state = 106, .external_lex_state = 34},
  [2801] = {.lex_state = 68, .external_lex_state = 14},
  [2802] = {.lex_state = 106, .external_lex_state = 34},
  [2803] = {.lex_state = 106, .external_lex_state = 34},
  [2804] = {.lex_state = 106, .external_lex_state = 30},
  [2805] = {.lex_state = 3, .external_lex_state = 31},
  [2806] = {.lex_state = 106, .external_lex_state = 34},
  [2807] = {.lex_state = 106, .external_lex_state = 34},
  [2808] = {.lex_state = 106, .external_lex_state = 30},
  [2809] = {.lex_state = 53, .external_lex_state = 14},
  [2810] = {.lex_state = 106, .external_lex_state = 30},
  [2811] = {.lex_state = 106, .external_lex_state = 34},
  [2812] = {.lex_state = 106, .external_lex_state = 34},
  [2813] = {.lex_state = 106, .external_lex_state = 34},
  [2814] = {.lex_state = 106, .external_lex_state = 34},
  [2815] = {.lex_state = 68, .external_lex_state = 30},
  [2816] = {.lex_state = 106, .external_lex_state = 30},
  [2817] = {.lex_state = 106, .external_lex_state = 30},
  [2818] = {.lex_state = 106, .external_lex_state = 34},
  [2819] = {.lex_state = 106, .external_lex_state = 34},
  [2820] = {.lex_state = 106, .external_lex_state = 34},
  [2821] = {.lex_state = 106, .external_lex_state = 30},
  [2822] = {.lex_state = 106, .external_lex_state = 34},
  [2823] = {.lex_state = 106, .external_lex_state = 34},
  [2824] = {.lex_state = 106, .external_lex_state = 34},
  [2825] = {.lex_state = 106, .external_lex_state = 30},
  [2826] = {.lex_state = 53, .external_lex_state = 14},
  [2827] = {.lex_state = 53, .external_lex_state = 14},
  [2828] = {.lex_state = 106, .external_lex_state = 34},
  [2829] = {.lex_state = 106, .external_lex_state = 30},
  [2830] = {.lex_state = 106, .external_lex_state = 30},
  [2831] = {.lex_state = 106, .external_lex_state = 30},
  [2832] = {.lex_state = 106, .external_lex_state = 34},
  [2833] = {.lex_state = 106, .external_lex_state = 34},
  [2834] = {.lex_state = 106, .external_lex_state = 34},
  [2835] = {.lex_state = 106, .external_lex_state = 34},
  [2836] = {.lex_state = 106, .external_lex_state = 30},
  [2837] = {.lex_state = 106, .external_lex_state = 34},
  [2838] = {.lex_state = 106, .external_lex_state = 34},
  [2839] = {.lex_state = 106, .external_lex_state = 30},
  [2840] = {.lex_state = 106, .external_lex_state = 30},
  [2841] = {.lex_state = 106, .external_lex_state = 30},
  [2842] = {.lex_state = 106, .external_lex_state = 30},
  [2843] = {.lex_state = 106, .external_lex_state = 34},
  [2844] = {.lex_state = 106, .external_lex_state = 30},
  [2845] = {.lex_state = 106, .external_lex_state = 30},
  [2846] = {.lex_state = 68, .external_lex_state = 35},
  [2847] = {.lex_state = 106, .external_lex_state = 34},
  [2848] = {.lex_state = 106, .external_lex_state = 34},
  [2849] = {.lex_state = 68, .external_lex_state = 35},
  [2850] = {.lex_state = 106, .external_lex_state = 34},
  [2851] = {.lex_state = 106, .external_lex_state = 34},
  [2852] = {.lex_state = 106, .external_lex_state = 34},
  [2853] = {.lex_state = 106, .external_lex_state = 34},
  [2854] = {.lex_state = 106, .external_lex_state = 34},
  [2855] = {.lex_state = 106, .external_lex_state = 34},
  [2856] = {.lex_state = 106, .external_lex_state = 34},
  [2857] = {.lex_state = 106, .external_lex_state = 34},
  [2858] = {.lex_state = 68, .external_lex_state = 14},
  [2859] = {.lex_state = 106, .external_lex_state = 34},
  [2860] = {.lex_state = 106, .external_lex_state = 34},
  [2861] = {.lex_state = 106, .external_lex_state = 34},
  [2862] = {.lex_state = 106, .external_lex_state = 34},
  [2863] = {.lex_state = 12, .external_lex_state = 14},
  [2864] = {.lex_state = 12, .external_lex_state = 12},
  [2865] = {.lex_state = 106, .external_lex_state = 34},
  [2866] = {.lex_state = 106, .external_lex_state = 30},
  [2867] = {.lex_state = 106, .external_lex_state = 34},
  [2868] = {.lex_state = 68, .external_lex_state = 30},
  [2869] = {.lex_state = 106, .external_lex_state = 30},
  [2870] = {.lex_state = 76, .external_lex_state = 14},
  [2871] = {.lex_state = 106, .external_lex_state = 34},
  [2872] = {.lex_state = 106, .external_lex_state = 34},
  [2873] = {.lex_state = 106, .external_lex_state = 30},
  [2874] = {.lex_state = 106, .external_lex_state = 34},
  [2875] = {.lex_state = 106, .external_lex_state = 16},
  [2876] = {.lex_state = 106, .external_lex_state = 30},
  [2877] = {.lex_state = 106, .external_lex_state = 30},
  [2878] = {.lex_state = 106, .external_lex_state = 30},
  [2879] = {.lex_state = 106, .external_lex_state = 34},
  [2880] = {.lex_state = 12, .external_lex_state = 12},
  [2881] = {.lex_state = 106, .external_lex_state = 34},
  [2882] = {.lex_state = 12, .external_lex_state = 12},
  [2883] = {.lex_state = 106, .external_lex_state = 16},
  [2884] = {.lex_state = 106, .external_lex_state = 34},
  [2885] = {.lex_state = 106, .external_lex_state = 34},
  [2886] = {.lex_state = 106, .external_lex_state = 34},
  [2887] = {.lex_state = 106, .external_lex_state = 34},
  [2888] = {.lex_state = 106, .external_lex_state = 34},
  [2889] = {.lex_state = 53, .external_lex_state = 14},
  [2890] = {.lex_state = 106, .external_lex_state = 34},
  [2891] = {.lex_state = 106, .external_lex_state = 34},
  [2892] = {.lex_state = 68, .external_lex_state = 30},
  [2893] = {.lex_state = 68, .external_lex_state = 14},
  [2894] = {.lex_state = 106, .external_lex_state = 16},
  [2895] = {.lex_state = 106, .external_lex_state = 16},
  [2896] = {.lex_state = 106, .external_lex_state = 34},
  [2897] = {.lex_state = 12, .external_lex_state = 14},
  [2898] = {.lex_state = 106, .external_lex_state = 34},
  [2899] = {.lex_state = 106, .external_lex_state = 34},
  [2900] = {.lex_state = 106, .external_lex_state = 16},
  [2901] = {.lex_state = 106, .external_lex_state = 30},
  [2902] = {.lex_state = 106, .external_lex_state = 34},
  [2903] = {.lex_state = 106, .external_lex_state = 30},
  [2904] = {.lex_state = 106, .external_lex_state = 34},
  [2905] = {.lex_state = 106, .external_lex_state = 16},
  [2906] = {.lex_state = 106, .external_lex_state = 34},
  [2907] = {.lex_state = 106, .external_lex_state = 34},
  [2908] = {.lex_state = 106, .external_lex_state = 34},
  [2909] = {.lex_state = 53, .external_lex_state = 14},
  [2910] = {.lex_state = 106, .external_lex_state = 34},
  [2911] = {.lex_state = 68, .external_lex_state = 16},
  [2912] = {.lex_state = 53, .external_lex_state = 14},
  [2913] = {.lex_state = 106, .external_lex_state = 30},
  [2914] = {.lex_state = 106, .external_lex_state = 34},
  [2915] = {.lex_state = 106, .external_lex_state = 30},
  [2916] = {.lex_state = 106, .external_lex_state = 34},
  [2917] = {.lex_state = 106, .external_lex_state = 34},
  [2918] = {.lex_state = 106, .external_lex_state = 34},
  [2919] = {.lex_state = 106, .external_lex_state = 34},
  [2920] = {.lex_state = 106, .external_lex_state = 34},
  [2921] = {.lex_state = 106, .external_lex_state = 34},
  [2922] = {.lex_state = 106, .external_lex_state = 34},
  [2923] = {.lex_state = 106, .external_lex_state = 30},
  [2924] = {.lex_state = 106, .external_lex_state = 34},
  [2925] = {.lex_state = 106, .external_lex_state = 16},
  [2926] = {.lex_state = 106, .external_lex_state = 30},
  [2927] = {.lex_state = 106, .external_lex_state = 30},
  [2928] = {.lex_state = 106, .external_lex_state = 34},
  [2929] = {.lex_state = 106, .external_lex_state = 34},
  [2930] = {.lex_state = 106, .external_lex_state = 34},
  [2931] = {.lex_state = 106, .external_lex_state = 34},
  [2932] = {.lex_state = 106, .external_lex_state = 30},
  [2933] = {.lex_state = 106, .external_lex_state = 34},
  [2934] = {.lex_state = 106, .external_lex_state = 16},
  [2935] = {.lex_state = 106, .external_lex_state = 34},
  [2936] = {.lex_state = 75, .external_lex_state = 16},
  [2937] = {.lex_state = 106, .external_lex_state = 34},
  [2938] = {.lex_state = 106, .external_lex_state = 34},
  [2939] = {.lex_state = 68, .external_lex_state = 16},
  [2940] = {.lex_state = 106, .external_lex_state = 16},
  [2941] = {.lex_state = 106, .external_lex_state = 34},
  [2942] = {.lex_state = 106, .external_lex_state = 34},
  [2943] = {.lex_state = 106, .external_lex_state = 30},
  [2944] = {.lex_state = 106, .external_lex_state = 34},
  [2945] = {.lex_state = 106, .external_lex_state = 30},
  [2946] = {.lex_state = 68, .external_lex_state = 14},
  [2947] = {.lex_state = 106, .external_lex_state = 34},
  [2948] = {.lex_state = 106, .external_lex_state = 34},
  [2949] = {.lex_state = 106, .external_lex_state = 34},
  [2950] = {.lex_state = 106, .external_lex_state = 30},
  [2951] = {.lex_state = 106, .external_lex_state = 34},
  [2952] = {.lex_state = 68, .external_lex_state = 14},
  [2953] = {.lex_state = 106, .external_lex_state = 34},
  [2954] = {.lex_state = 3, .external_lex_state = 31},
  [2955] = {.lex_state = 106, .external_lex_state = 34},
  [2956] = {.lex_state = 106, .external_lex_state = 34},
  [2957] = {.lex_state = 76, .external_lex_state = 14},
  [2958] = {.lex_state = 106, .external_lex_state = 34},
  [2959] = {.lex_state = 106, .external_lex_state = 34},
  [2960] = {.lex_state = 106, .external_lex_state = 34},
  [2961] = {.lex_state = 106, .external_lex_state = 34},
  [2962] = {.lex_state = 106, .external_lex_state = 34},
  [2963] = {.lex_state = 106, .external_lex_state = 16},
  [2964] = {.lex_state = 106, .external_lex_state = 30},
  [2965] = {.lex_state = 68, .external_lex_state = 16},
  [2966] = {.lex_state = 106, .external_lex_state = 34},
  [2967] = {.lex_state = 106, .external_lex_state = 30},
  [2968] = {.lex_state = 106, .external_lex_state = 34},
  [2969] = {.lex_state = 106, .external_lex_state = 34},
  [2970] = {.lex_state = 106, .external_lex_state = 34},
  [2971] = {.lex_state = 106, .external_lex_state = 34},
  [2972] = {.lex_state = 106, .external_lex_state = 34},
  [2973] = {.lex_state = 106, .external_lex_state = 34},
  [2974] = {.lex_state = 106, .external_lex_state = 34},
  [2975] = {.lex_state = 53, .external_lex_state = 14},
  [2976] = {.lex_state = 68, .external_lex_state = 31},
  [2977] = {.lex_state = 74, .external_lex_state = 14},
  [2978] = {.lex_state = 74, .external_lex_state = 14},
  [2979] = {.lex_state = 74, .external_lex_state = 14},
  [2980] = {.lex_state = 74, .external_lex_state = 14},
  [2981] = {.lex_state = 74, .external_lex_state = 14},
  [2982] = {.lex_state = 74, .external_lex_state = 14},
  [2983] = {.lex_state = 74, .external_lex_state = 14},
  [2984] = {.lex_state = 12, .external_lex_state = 14},
  [2985] = {.lex_state = 74, .external_lex_state = 14},
  [2986] = {.lex_state = 74, .external_lex_state = 14},
  [2987] = {.lex_state = 74, .external_lex_state = 14},
  [2988] = {.lex_state = 106, .external_lex_state = 14},
  [2989] = {.lex_state = 74, .external_lex_state = 14},
  [2990] = {.lex_state = 12, .external_lex_state = 14},
  [2991] = {.lex_state = 12, .external_lex_state = 14},
  [2992] = {.lex_state = 74, .external_lex_state = 14},
  [2993] = {.lex_state = 106, .external_lex_state = 31},
  [2994] = {.lex_state = 106, .external_lex_state = 33},
  [2995] = {.lex_state = 74, .external_lex_state = 14},
  [2996] = {.lex_state = 106, .external_lex_state = 34},
  [2997] = {.lex_state = 106, .external_lex_state = 14},
  [2998] = {.lex_state = 75, .external_lex_state = 14},
  [2999] = {.lex_state = 12, .external_lex_state = 14},
  [3000] = {.lex_state = 106, .external_lex_state = 14},
  [3001] = {.lex_state = 68, .external_lex_state = 31},
  [3002] = {.lex_state = 12, .external_lex_state = 14},
  [3003] = {.lex_state = 75, .external_lex_state = 14},
  [3004] = {.lex_state = 12, .external_lex_state = 14},
  [3005] = {.lex_state = 12, .external_lex_state = 14},
  [3006] = {.lex_state = 74, .external_lex_state = 14},
  [3007] = {.lex_state = 74, .external_lex_state = 14},
  [3008] = {.lex_state = 106, .external_lex_state = 14},
  [3009] = {.lex_state = 74, .external_lex_state = 14},
  [3010] = {.lex_state = 74, .external_lex_state = 14},
  [3011] = {.lex_state = 68, .external_lex_state = 31},
  [3012] = {.lex_state = 106, .external_lex_state = 16},
  [3013] = {.lex_state = 12, .external_lex_state = 14},
  [3014] = {.lex_state = 106, .external_lex_state = 31},
  [3015] = {.lex_state = 12, .external_lex_state = 14},
  [3016] = {.lex_state = 12, .external_lex_state = 14},
  [3017] = {.lex_state = 106, .external_lex_state = 16},
  [3018] = {.lex_state = 106, .external_lex_state = 14},
  [3019] = {.lex_state = 74, .external_lex_state = 14},
  [3020] = {.lex_state = 75, .external_lex_state = 14},
  [3021] = {.lex_state = 75, .external_lex_state = 14},
  [3022] = {.lex_state = 75, .external_lex_state = 14},
  [3023] = {.lex_state = 75, .external_lex_state = 14},
  [3024] = {.lex_state = 75, .external_lex_state = 14},
  [3025] = {.lex_state = 10, .external_lex_state = 14},
  [3026] = {.lex_state = 75, .external_lex_state = 14},
  [3027] = {.lex_state = 75, .external_lex_state = 14},
  [3028] = {.lex_state = 75, .external_lex_state = 14},
  [3029] = {.lex_state = 10, .external_lex_state = 14},
  [3030] = {.lex_state = 75, .external_lex_state = 14},
  [3031] = {.lex_state = 75, .external_lex_state = 14},
  [3032] = {.lex_state = 75, .external_lex_state = 14},
  [3033] = {.lex_state = 106, .external_lex_state = 14},
  [3034] = {.lex_state = 75, .external_lex_state = 14},
  [3035] = {.lex_state = 106, .external_lex_state = 36},
  [3036] = {.lex_state = 10, .external_lex_state = 14},
  [3037] = {.lex_state = 75, .external_lex_state = 14},
  [3038] = {.lex_state = 106, .external_lex_state = 27},
  [3039] = {.lex_state = 106, .external_lex_state = 27},
  [3040] = {.lex_state = 75, .external_lex_state = 14},
  [3041] = {.lex_state = 106, .external_lex_state = 14},
  [3042] = {.lex_state = 106, .external_lex_state = 14},
  [3043] = {.lex_state = 75, .external_lex_state = 14},
  [3044] = {.lex_state = 75, .external_lex_state = 14},
  [3045] = {.lex_state = 75, .external_lex_state = 14},
  [3046] = {.lex_state = 106, .external_lex_state = 14},
  [3047] = {.lex_state = 106, .external_lex_state = 14},
  [3048] = {.lex_state = 106, .external_lex_state = 14},
  [3049] = {.lex_state = 75, .external_lex_state = 14},
  [3050] = {.lex_state = 75, .external_lex_state = 14},
  [3051] = {.lex_state = 106, .external_lex_state = 14},
  [3052] = {.lex_state = 75, .external_lex_state = 14},
  [3053] = {.lex_state = 106, .external_lex_state = 14},
  [3054] = {.lex_state = 75, .external_lex_state = 14},
  [3055] = {.lex_state = 106, .external_lex_state = 14},
  [3056] = {.lex_state = 75, .external_lex_state = 14},
  [3057] = {.lex_state = 106, .external_lex_state = 36},
  [3058] = {.lex_state = 106, .external_lex_state = 14},
  [3059] = {.lex_state = 106, .external_lex_state = 36},
  [3060] = {.lex_state = 106, .external_lex_state = 36},
  [3061] = {.lex_state = 106, .external_lex_state = 36},
  [3062] = {.lex_state = 106, .external_lex_state = 36},
  [3063] = {.lex_state = 75, .external_lex_state = 14},
  [3064] = {.lex_state = 75, .external_lex_state = 14},
  [3065] = {.lex_state = 106, .external_lex_state = 36},
  [3066] = {.lex_state = 12, .external_lex_state = 14},
  [3067] = {.lex_state = 75, .external_lex_state = 14},
  [3068] = {.lex_state = 75, .external_lex_state = 14},
  [3069] = {.lex_state = 106, .external_lex_state = 14},
  [3070] = {.lex_state = 75, .external_lex_state = 14},
  [3071] = {.lex_state = 106, .external_lex_state = 14},
  [3072] = {.lex_state = 106, .external_lex_state = 14},
  [3073] = {.lex_state = 75, .external_lex_state = 14},
  [3074] = {.lex_state = 106, .external_lex_state = 14},
  [3075] = {.lex_state = 75, .external_lex_state = 14},
  [3076] = {.lex_state = 106, .external_lex_state = 14},
  [3077] = {.lex_state = 106, .external_lex_state = 34},
  [3078] = {.lex_state = 106, .external_lex_state = 14},
  [3079] = {.lex_state = 75, .external_lex_state = 14},
  [3080] = {.lex_state = 75, .external_lex_state = 14},
  [3081] = {.lex_state = 75, .external_lex_state = 14},
  [3082] = {.lex_state = 75, .external_lex_state = 14},
  [3083] = {.lex_state = 75, .external_lex_state = 14},
  [3084] = {.lex_state = 75, .external_lex_state = 14},
  [3085] = {.lex_state = 75, .external_lex_state = 14},
  [3086] = {.lex_state = 75, .external_lex_state = 14},
  [3087] = {.lex_state = 75, .external_lex_state = 14},
  [3088] = {.lex_state = 75, .external_lex_state = 14},
  [3089] = {.lex_state = 106, .external_lex_state = 36},
  [3090] = {.lex_state = 75, .external_lex_state = 14},
  [3091] = {.lex_state = 75, .external_lex_state = 14},
  [3092] = {.lex_state = 75, .external_lex_state = 14},
  [3093] = {.lex_state = 75, .external_lex_state = 14},
  [3094] = {.lex_state = 75, .external_lex_state = 14},
  [3095] = {.lex_state = 75, .external_lex_state = 14},
  [3096] = {.lex_state = 75, .external_lex_state = 14},
  [3097] = {.lex_state = 106, .external_lex_state = 36},
  [3098] = {.lex_state = 106, .external_lex_state = 36},
  [3099] = {.lex_state = 106, .external_lex_state = 36},
  [3100] = {.lex_state = 106, .external_lex_state = 36},
  [3101] = {.lex_state = 75, .external_lex_state = 14},
  [3102] = {.lex_state = 75, .external_lex_state = 14},
  [3103] = {.lex_state = 106, .external_lex_state = 14},
  [3104] = {.lex_state = 75, .external_lex_state = 14},
  [3105] = {.lex_state = 75, .external_lex_state = 14},
  [3106] = {.lex_state = 75, .external_lex_state = 14},
  [3107] = {.lex_state = 75, .external_lex_state = 14},
  [3108] = {.lex_state = 3, .external_lex_state = 16},
  [3109] = {.lex_state = 106, .external_lex_state = 14},
  [3110] = {.lex_state = 75, .external_lex_state = 14},
  [3111] = {.lex_state = 75, .external_lex_state = 14},
  [3112] = {.lex_state = 75, .external_lex_state = 14},
  [3113] = {.lex_state = 106, .external_lex_state = 33},
  [3114] = {.lex_state = 75, .external_lex_state = 14},
  [3115] = {.lex_state = 75, .external_lex_state = 14},
  [3116] = {.lex_state = 75, .external_lex_state = 14},
  [3117] = {.lex_state = 106, .external_lex_state = 14},
  [3118] = {.lex_state = 106, .external_lex_state = 33},
  [3119] = {.lex_state = 75, .external_lex_state = 14},
  [3120] = {.lex_state = 75, .external_lex_state = 14},
  [3121] = {.lex_state = 75, .external_lex_state = 14},
  [3122] = {.lex_state = 75, .external_lex_state = 14},
  [3123] = {.lex_state = 75, .external_lex_state = 14},
  [3124] = {.lex_state = 106, .external_lex_state = 27},
  [3125] = {.lex_state = 75, .external_lex_state = 14},
  [3126] = {.lex_state = 10, .external_lex_state = 14},
  [3127] = {.lex_state = 75, .external_lex_state = 14},
  [3128] = {.lex_state = 75, .external_lex_state = 14},
  [3129] = {.lex_state = 75, .external_lex_state = 14},
  [3130] = {.lex_state = 75, .external_lex_state = 14},
  [3131] = {.lex_state = 75, .external_lex_state = 14},
  [3132] = {.lex_state = 75, .external_lex_state = 14},
  [3133] = {.lex_state = 75, .external_lex_state = 14},
  [3134] = {.lex_state = 75, .external_lex_state = 14},
  [3135] = {.lex_state = 106, .external_lex_state = 36},
  [3136] = {.lex_state = 106, .external_lex_state = 36},
  [3137] = {.lex_state = 106, .external_lex_state = 36},
  [3138] = {.lex_state = 106, .external_lex_state = 36},
  [3139] = {.lex_state = 75, .external_lex_state = 14},
  [3140] = {.lex_state = 75, .external_lex_state = 14},
  [3141] = {.lex_state = 75, .external_lex_state = 14},
  [3142] = {.lex_state = 75, .external_lex_state = 14},
  [3143] = {.lex_state = 68, .external_lex_state = 14},
  [3144] = {.lex_state = 75, .external_lex_state = 14},
  [3145] = {.lex_state = 106, .external_lex_state = 34},
  [3146] = {.lex_state = 75, .external_lex_state = 14},
  [3147] = {.lex_state = 75, .external_lex_state = 14},
  [3148] = {.lex_state = 75, .external_lex_state = 14},
  [3149] = {.lex_state = 75, .external_lex_state = 14},
  [3150] = {.lex_state = 75, .external_lex_state = 14},
  [3151] = {.lex_state = 68, .external_lex_state = 14},
  [3152] = {.lex_state = 75, .external_lex_state = 14},
  [3153] = {.lex_state = 75, .external_lex_state = 14},
  [3154] = {.lex_state = 75, .external_lex_state = 14},
  [3155] = {.lex_state = 75, .external_lex_state = 14},
  [3156] = {.lex_state = 75, .external_lex_state = 14},
  [3157] = {.lex_state = 3, .external_lex_state = 30},
  [3158] = {.lex_state = 10, .external_lex_state = 14},
  [3159] = {.lex_state = 75, .external_lex_state = 14},
  [3160] = {.lex_state = 75, .external_lex_state = 14},
  [3161] = {.lex_state = 68, .external_lex_state = 14},
  [3162] = {.lex_state = 75, .external_lex_state = 14},
  [3163] = {.lex_state = 75, .external_lex_state = 14},
  [3164] = {.lex_state = 75, .external_lex_state = 14},
  [3165] = {.lex_state = 75, .external_lex_state = 14},
  [3166] = {.lex_state = 68, .external_lex_state = 14},
  [3167] = {.lex_state = 75, .external_lex_state = 14},
  [3168] = {.lex_state = 75, .external_lex_state = 14},
  [3169] = {.lex_state = 75, .external_lex_state = 14},
  [3170] = {.lex_state = 75, .external_lex_state = 14},
  [3171] = {.lex_state = 75, .external_lex_state = 14},
  [3172] = {.lex_state = 75, .external_lex_state = 14},
  [3173] = {.lex_state = 75, .external_lex_state = 14},
  [3174] = {.lex_state = 10, .external_lex_state = 14},
  [3175] = {.lex_state = 75, .external_lex_state = 14},
  [3176] = {.lex_state = 75, .external_lex_state = 14},
  [3177] = {.lex_state = 75, .external_lex_state = 14},
  [3178] = {.lex_state = 75, .external_lex_state = 14},
  [3179] = {.lex_state = 68, .external_lex_state = 14},
  [3180] = {.lex_state = 75, .external_lex_state = 14},
  [3181] = {.lex_state = 68, .external_lex_state = 14},
  [3182] = {.lex_state = 75, .external_lex_state = 14},
  [3183] = {.lex_state = 75, .external_lex_state = 14},
  [3184] = {.lex_state = 75, .external_lex_state = 14},
  [3185] = {.lex_state = 106, .external_lex_state = 36},
  [3186] = {.lex_state = 106, .external_lex_state = 27},
  [3187] = {.lex_state = 75, .external_lex_state = 14},
  [3188] = {.lex_state = 75, .external_lex_state = 14},
  [3189] = {.lex_state = 106, .external_lex_state = 36},
  [3190] = {.lex_state = 106, .external_lex_state = 36},
  [3191] = {.lex_state = 106, .external_lex_state = 36},
  [3192] = {.lex_state = 75, .external_lex_state = 14},
  [3193] = {.lex_state = 75, .external_lex_state = 14},
  [3194] = {.lex_state = 75, .external_lex_state = 14},
  [3195] = {.lex_state = 75, .external_lex_state = 14},
  [3196] = {.lex_state = 106, .external_lex_state = 36},
  [3197] = {.lex_state = 75, .external_lex_state = 14},
  [3198] = {.lex_state = 75, .external_lex_state = 14},
  [3199] = {.lex_state = 75, .external_lex_state = 14},
  [3200] = {.lex_state = 75, .external_lex_state = 14},
  [3201] = {.lex_state = 75, .external_lex_state = 14},
  [3202] = {.lex_state = 106, .external_lex_state = 34},
  [3203] = {.lex_state = 75, .external_lex_state = 14},
  [3204] = {.lex_state = 106, .external_lex_state = 36},
  [3205] = {.lex_state = 75, .external_lex_state = 14},
  [3206] = {.lex_state = 75, .external_lex_state = 14},
  [3207] = {.lex_state = 75, .external_lex_state = 14},
  [3208] = {.lex_state = 68, .external_lex_state = 14},
  [3209] = {.lex_state = 75, .external_lex_state = 14},
  [3210] = {.lex_state = 75, .external_lex_state = 14},
  [3211] = {.lex_state = 75, .external_lex_state = 14},
  [3212] = {.lex_state = 75, .external_lex_state = 14},
  [3213] = {.lex_state = 75, .external_lex_state = 14},
  [3214] = {.lex_state = 75, .external_lex_state = 14},
  [3215] = {.lex_state = 75, .external_lex_state = 14},
  [3216] = {.lex_state = 75, .external_lex_state = 14},
  [3217] = {.lex_state = 106, .external_lex_state = 14},
  [3218] = {.lex_state = 75, .external_lex_state = 14},
  [3219] = {.lex_state = 75, .external_lex_state = 14},
  [3220] = {.lex_state = 75, .external_lex_state = 14},
  [3221] = {.lex_state = 75, .external_lex_state = 14},
  [3222] = {.lex_state = 68, .external_lex_state = 14},
  [3223] = {.lex_state = 106, .external_lex_state = 34},
  [3224] = {.lex_state = 106, .external_lex_state = 36},
  [3225] = {.lex_state = 106, .external_lex_state = 14},
  [3226] = {.lex_state = 75, .external_lex_state = 14},
  [3227] = {.lex_state = 106, .external_lex_state = 36},
  [3228] = {.lex_state = 75, .external_lex_state = 14},
  [3229] = {.lex_state = 106, .external_lex_state = 14},
  [3230] = {.lex_state = 75, .external_lex_state = 14},
  [3231] = {.lex_state = 106, .external_lex_state = 36},
  [3232] = {.lex_state = 75, .external_lex_state = 14},
  [3233] = {.lex_state = 75, .external_lex_state = 14},
  [3234] = {.lex_state = 75, .external_lex_state = 14},
  [3235] = {.lex_state = 75, .external_lex_state = 14},
  [3236] = {.lex_state = 75, .external_lex_state = 14},
  [3237] = {.lex_state = 106, .external_lex_state = 14},
  [3238] = {.lex_state = 68, .external_lex_state = 14},
  [3239] = {.lex_state = 106, .external_lex_state = 14},
  [3240] = {.lex_state = 106, .external_lex_state = 14},
  [3241] = {.lex_state = 106, .external_lex_state = 14},
  [3242] = {.lex_state = 106, .external_lex_state = 14},
  [3243] = {.lex_state = 106, .external_lex_state = 14},
  [3244] = {.lex_state = 106, .external_lex_state = 14},
  [3245] = {.lex_state = 106, .external_lex_state = 14},
  [3246] = {.lex_state = 106, .external_lex_state = 14},
  [3247] = {.lex_state = 106, .external_lex_state = 14},
  [3248] = {.lex_state = 106, .external_lex_state = 14},
  [3249] = {.lex_state = 106, .external_lex_state = 14},
  [3250] = {.lex_state = 106, .external_lex_state = 37},
  [3251] = {.lex_state = 106, .external_lex_state = 14},
  [3252] = {.lex_state = 106, .external_lex_state = 14},
  [3253] = {.lex_state = 106, .external_lex_state = 14},
  [3254] = {.lex_state = 106, .external_lex_state = 14},
  [3255] = {.lex_state = 106, .external_lex_state = 14},
  [3256] = {.lex_state = 106, .external_lex_state = 14},
  [3257] = {.lex_state = 106, .external_lex_state = 14},
  [3258] = {.lex_state = 106, .external_lex_state = 14},
  [3259] = {.lex_state = 106, .external_lex_state = 14},
  [3260] = {.lex_state = 106, .external_lex_state = 14},
  [3261] = {.lex_state = 106, .external_lex_state = 14},
  [3262] = {.lex_state = 68, .external_lex_state = 14},
  [3263] = {.lex_state = 106, .external_lex_state = 14},
  [3264] = {.lex_state = 106, .external_lex_state = 14},
  [3265] = {.lex_state = 106, .external_lex_state = 14},
  [3266] = {.lex_state = 68, .external_lex_state = 14},
  [3267] = {.lex_state = 106, .external_lex_state = 14},
  [3268] = {.lex_state = 106, .external_lex_state = 14},
  [3269] = {.lex_state = 68, .external_lex_state = 14},
  [3270] = {.lex_state = 68, .external_lex_state = 14},
  [3271] = {.lex_state = 68, .external_lex_state = 14},
  [3272] = {.lex_state = 106, .external_lex_state = 14},
  [3273] = {.lex_state = 106, .external_lex_state = 14},
  [3274] = {.lex_state = 106, .external_lex_state = 14},
  [3275] = {.lex_state = 106, .external_lex_state = 14},
  [3276] = {.lex_state = 106, .external_lex_state = 14},
  [3277] = {.lex_state = 68, .external_lex_state = 14},
  [3278] = {.lex_state = 68, .external_lex_state = 14},
  [3279] = {.lex_state = 106, .external_lex_state = 14},
  [3280] = {.lex_state = 106, .external_lex_state = 14},
  [3281] = {.lex_state = 106, .external_lex_state = 14},
  [3282] = {.lex_state = 106, .external_lex_state = 14},
  [3283] = {.lex_state = 106, .external_lex_state = 14},
  [3284] = {.lex_state = 106, .external_lex_state = 14},
  [3285] = {.lex_state = 106, .external_lex_state = 14},
  [3286] = {.lex_state = 106, .external_lex_state = 14},
  [3287] = {.lex_state = 106, .external_lex_state = 14},
  [3288] = {.lex_state = 106, .external_lex_state = 14},
  [3289] = {.lex_state = 106, .external_lex_state = 14},
  [3290] = {.lex_state = 68, .external_lex_state = 14},
  [3291] = {.lex_state = 106, .external_lex_state = 14},
  [3292] = {.lex_state = 106, .external_lex_state = 14},
  [3293] = {.lex_state = 68, .external_lex_state = 14},
  [3294] = {.lex_state = 68, .external_lex_state = 14},
  [3295] = {.lex_state = 106, .external_lex_state = 14},
  [3296] = {.lex_state = 106, .external_lex_state = 14},
  [3297] = {.lex_state = 106, .external_lex_state = 14},
  [3298] = {.lex_state = 106, .external_lex_state = 14},
  [3299] = {.lex_state = 106, .external_lex_state = 14},
  [3300] = {.lex_state = 106, .external_lex_state = 14},
  [3301] = {.lex_state = 106, .external_lex_state = 14},
  [3302] = {.lex_state = 106, .external_lex_state = 14},
  [3303] = {.lex_state = 106, .external_lex_state = 14},
  [3304] = {.lex_state = 106, .external_lex_state = 14},
  [3305] = {.lex_state = 106, .external_lex_state = 14},
  [3306] = {.lex_state = 106, .external_lex_state = 14},
  [3307] = {.lex_state = 106, .external_lex_state = 14},
  [3308] = {.lex_state = 10, .external_lex_state = 14},
  [3309] = {.lex_state = 10, .external_lex_state = 14},
  [3310] = {.lex_state = 106, .external_lex_state = 16},
  [3311] = {.lex_state = 106, .external_lex_state = 14},
  [3312] = {.lex_state = 68, .external_lex_state = 14},
  [3313] = {.lex_state = 106, .external_lex_state = 14},
  [3314] = {.lex_state = 106, .external_lex_state = 14},
  [3315] = {.lex_state = 106, .external_lex_state = 16},
  [3316] = {.lex_state = 106, .external_lex_state = 14},
  [3317] = {.lex_state = 106, .external_lex_state = 14},
  [3318] = {.lex_state = 106, .external_lex_state = 14},
  [3319] = {.lex_state = 106, .external_lex_state = 14},
  [3320] = {.lex_state = 106, .external_lex_state = 14},
  [3321] = {.lex_state = 106, .external_lex_state = 14},
  [3322] = {.lex_state = 10, .external_lex_state = 14},
  [3323] = {.lex_state = 106, .external_lex_state = 14},
  [3324] = {.lex_state = 10, .external_lex_state = 14},
  [3325] = {.lex_state = 106, .external_lex_state = 14},
  [3326] = {.lex_state = 106, .external_lex_state = 14},
  [3327] = {.lex_state = 106, .external_lex_state = 14},
  [3328] = {.lex_state = 106, .external_lex_state = 14},
  [3329] = {.lex_state = 106, .external_lex_state = 14},
  [3330] = {.lex_state = 68, .external_lex_state = 14},
  [3331] = {.lex_state = 106, .external_lex_state = 14},
  [3332] = {.lex_state = 106, .external_lex_state = 14},
  [3333] = {.lex_state = 106, .external_lex_state = 14},
  [3334] = {.lex_state = 106, .external_lex_state = 14},
  [3335] = {.lex_state = 106, .external_lex_state = 14},
  [3336] = {.lex_state = 106, .external_lex_state = 14},
  [3337] = {.lex_state = 106, .external_lex_state = 14},
  [3338] = {.lex_state = 106, .external_lex_state = 14},
  [3339] = {.lex_state = 10, .external_lex_state = 14},
  [3340] = {.lex_state = 106, .external_lex_state = 14},
  [3341] = {.lex_state = 106, .external_lex_state = 14},
  [3342] = {.lex_state = 106, .external_lex_state = 14},
  [3343] = {.lex_state = 106, .external_lex_state = 16},
  [3344] = {.lex_state = 68, .external_lex_state = 14},
  [3345] = {.lex_state = 106, .external_lex_state = 14},
  [3346] = {.lex_state = 68, .external_lex_state = 14},
  [3347] = {.lex_state = 106, .external_lex_state = 14},
  [3348] = {.lex_state = 106, .external_lex_state = 14},
  [3349] = {.lex_state = 106, .external_lex_state = 14},
  [3350] = {.lex_state = 106, .external_lex_state = 14},
  [3351] = {.lex_state = 106, .external_lex_state = 14},
  [3352] = {.lex_state = 106, .external_lex_state = 14},
  [3353] = {.lex_state = 106, .external_lex_state = 14},
  [3354] = {.lex_state = 10, .external_lex_state = 14},
  [3355] = {.lex_state = 106, .external_lex_state = 14},
  [3356] = {.lex_state = 10, .external_lex_state = 14},
  [3357] = {.lex_state = 106, .external_lex_state = 14},
  [3358] = {.lex_state = 106, .external_lex_state = 14},
  [3359] = {.lex_state = 106, .external_lex_state = 14},
  [3360] = {.lex_state = 106, .external_lex_state = 14},
  [3361] = {.lex_state = 106, .external_lex_state = 14},
  [3362] = {.lex_state = 106, .external_lex_state = 14},
  [3363] = {.lex_state = 106, .external_lex_state = 14},
  [3364] = {.lex_state = 106, .external_lex_state = 14},
  [3365] = {.lex_state = 106, .external_lex_state = 14},
  [3366] = {.lex_state = 106, .external_lex_state = 14},
  [3367] = {.lex_state = 10, .external_lex_state = 14},
  [3368] = {.lex_state = 106, .external_lex_state = 14},
  [3369] = {.lex_state = 106, .external_lex_state = 14},
  [3370] = {.lex_state = 106, .external_lex_state = 14},
  [3371] = {.lex_state = 106, .external_lex_state = 37},
  [3372] = {.lex_state = 106, .external_lex_state = 16},
  [3373] = {.lex_state = 106, .external_lex_state = 14},
  [3374] = {.lex_state = 106, .external_lex_state = 14},
  [3375] = {.lex_state = 10, .external_lex_state = 14},
  [3376] = {.lex_state = 10, .external_lex_state = 14},
  [3377] = {.lex_state = 106, .external_lex_state = 14},
  [3378] = {.lex_state = 106, .external_lex_state = 14},
  [3379] = {.lex_state = 106, .external_lex_state = 14},
  [3380] = {.lex_state = 106, .external_lex_state = 14},
  [3381] = {.lex_state = 106, .external_lex_state = 14},
  [3382] = {.lex_state = 106, .external_lex_state = 14},
  [3383] = {.lex_state = 106, .external_lex_state = 14},
  [3384] = {.lex_state = 106, .external_lex_state = 14},
  [3385] = {.lex_state = 106, .external_lex_state = 14},
  [3386] = {.lex_state = 106, .external_lex_state = 14},
  [3387] = {.lex_state = 106, .external_lex_state = 14},
  [3388] = {.lex_state = 106, .external_lex_state = 14},
  [3389] = {.lex_state = 106, .external_lex_state = 14},
  [3390] = {.lex_state = 106, .external_lex_state = 14},
  [3391] = {.lex_state = 106, .external_lex_state = 14},
  [3392] = {.lex_state = 106, .external_lex_state = 14},
  [3393] = {.lex_state = 106, .external_lex_state = 14},
  [3394] = {.lex_state = 106, .external_lex_state = 14},
  [3395] = {.lex_state = 106, .external_lex_state = 14},
  [3396] = {.lex_state = 106, .external_lex_state = 16},
  [3397] = {.lex_state = 106, .external_lex_state = 14},
  [3398] = {.lex_state = 106, .external_lex_state = 16},
  [3399] = {.lex_state = 106, .external_lex_state = 14},
  [3400] = {.lex_state = 106, .external_lex_state = 14},
  [3401] = {.lex_state = 106, .external_lex_state = 14},
  [3402] = {.lex_state = 106, .external_lex_state = 14},
  [3403] = {.lex_state = 106, .external_lex_state = 14},
  [3404] = {.lex_state = 106, .external_lex_state = 14},
  [3405] = {.lex_state = 106, .external_lex_state = 14},
  [3406] = {.lex_state = 106, .external_lex_state = 14},
  [3407] = {.lex_state = 106, .external_lex_state = 38},
  [3408] = {.lex_state = 106, .external_lex_state = 14},
  [3409] = {.lex_state = 106, .external_lex_state = 14},
  [3410] = {.lex_state = 106, .external_lex_state = 39},
  [3411] = {.lex_state = 106, .external_lex_state = 39},
  [3412] = {.lex_state = 106, .external_lex_state = 39},
  [3413] = {.lex_state = 106, .external_lex_state = 38},
  [3414] = {.lex_state = 106, .external_lex_state = 14},
  [3415] = {.lex_state = 106, .external_lex_state = 14},
  [3416] = {.lex_state = 106, .external_lex_state = 14},
  [3417] = {.lex_state = 106, .external_lex_state = 14},
  [3418] = {.lex_state = 106, .external_lex_state = 38},
  [3419] = {.lex_state = 106, .external_lex_state = 14},
  [3420] = {.lex_state = 106, .external_lex_state = 14},
  [3421] = {.lex_state = 106, .external_lex_state = 39},
  [3422] = {.lex_state = 106, .external_lex_state = 39},
  [3423] = {.lex_state = 106, .external_lex_state = 39},
  [3424] = {.lex_state = 106, .external_lex_state = 38},
  [3425] = {.lex_state = 106, .external_lex_state = 14},
  [3426] = {.lex_state = 106, .external_lex_state = 14},
  [3427] = {.lex_state = 106, .external_lex_state = 14},
  [3428] = {.lex_state = 106, .external_lex_state = 39},
  [3429] = {.lex_state = 106, .external_lex_state = 39},
  [3430] = {.lex_state = 106, .external_lex_state = 39},
  [3431] = {.lex_state = 106, .external_lex_state = 37},
  [3432] = {.lex_state = 12, .external_lex_state = 14},
  [3433] = {.lex_state = 106, .external_lex_state = 39},
  [3434] = {.lex_state = 106, .external_lex_state = 16},
  [3435] = {.lex_state = 106, .external_lex_state = 39},
  [3436] = {.lex_state = 106, .external_lex_state = 16},
  [3437] = {.lex_state = 106, .external_lex_state = 39},
  [3438] = {.lex_state = 106, .external_lex_state = 39},
  [3439] = {.lex_state = 106, .external_lex_state = 14},
  [3440] = {.lex_state = 106, .external_lex_state = 39},
  [3441] = {.lex_state = 106, .external_lex_state = 14},
  [3442] = {.lex_state = 106, .external_lex_state = 14},
  [3443] = {.lex_state = 106, .external_lex_state = 14},
  [3444] = {.lex_state = 106, .external_lex_state = 14},
  [3445] = {.lex_state = 106, .external_lex_state = 14},
  [3446] = {.lex_state = 106, .external_lex_state = 14},
  [3447] = {.lex_state = 106, .external_lex_state = 39},
  [3448] = {.lex_state = 106, .external_lex_state = 14},
  [3449] = {.lex_state = 106, .external_lex_state = 14},
  [3450] = {.lex_state = 106, .external_lex_state = 14},
  [3451] = {.lex_state = 106, .external_lex_state = 14},
  [3452] = {.lex_state = 106, .external_lex_state = 14},
  [3453] = {.lex_state = 106, .external_lex_state = 14},
  [3454] = {.lex_state = 106, .external_lex_state = 14},
  [3455] = {.lex_state = 106, .external_lex_state = 14},
  [3456] = {.lex_state = 106, .external_lex_state = 38},
  [3457] = {.lex_state = 106, .external_lex_state = 14},
  [3458] = {.lex_state = 106, .external_lex_state = 14},
  [3459] = {.lex_state = 106, .external_lex_state = 14},
  [3460] = {.lex_state = 106, .external_lex_state = 14},
  [3461] = {.lex_state = 106, .external_lex_state = 14},
  [3462] = {.lex_state = 106, .external_lex_state = 14},
  [3463] = {.lex_state = 106, .external_lex_state = 25},
  [3464] = {.lex_state = 106, .external_lex_state = 14},
  [3465] = {.lex_state = 106, .external_lex_state = 14},
  [3466] = {.lex_state = 106, .external_lex_state = 27},
  [3467] = {.lex_state = 106, .external_lex_state = 14},
  [3468] = {.lex_state = 106, .external_lex_state = 14},
  [3469] = {.lex_state = 10, .external_lex_state = 14},
  [3470] = {.lex_state = 106, .external_lex_state = 14},
  [3471] = {.lex_state = 106, .external_lex_state = 40},
  [3472] = {.lex_state = 106, .external_lex_state = 14},
  [3473] = {.lex_state = 106, .external_lex_state = 14},
  [3474] = {.lex_state = 12, .external_lex_state = 14},
  [3475] = {.lex_state = 106, .external_lex_state = 14},
  [3476] = {.lex_state = 106, .external_lex_state = 41},
  [3477] = {.lex_state = 106, .external_lex_state = 14},
  [3478] = {.lex_state = 106, .external_lex_state = 14},
  [3479] = {.lex_state = 106, .external_lex_state = 14},
  [3480] = {.lex_state = 106, .external_lex_state = 14},
  [3481] = {.lex_state = 106, .external_lex_state = 40},
  [3482] = {.lex_state = 106, .external_lex_state = 42},
  [3483] = {.lex_state = 106, .external_lex_state = 14},
  [3484] = {.lex_state = 106, .external_lex_state = 14},
  [3485] = {.lex_state = 106, .external_lex_state = 14},
  [3486] = {.lex_state = 106, .external_lex_state = 42},
  [3487] = {.lex_state = 106, .external_lex_state = 14},
  [3488] = {.lex_state = 106, .external_lex_state = 41},
  [3489] = {.lex_state = 10, .external_lex_state = 14},
  [3490] = {.lex_state = 106, .external_lex_state = 14},
  [3491] = {.lex_state = 106, .external_lex_state = 14},
  [3492] = {.lex_state = 106, .external_lex_state = 43},
  [3493] = {.lex_state = 106, .external_lex_state = 14},
  [3494] = {.lex_state = 106, .external_lex_state = 14},
  [3495] = {.lex_state = 106, .external_lex_state = 14},
  [3496] = {.lex_state = 106, .external_lex_state = 41},
  [3497] = {.lex_state = 106, .external_lex_state = 14},
  [3498] = {.lex_state = 106, .external_lex_state = 14},
  [3499] = {.lex_state = 12, .external_lex_state = 14},
  [3500] = {.lex_state = 106, .external_lex_state = 14},
  [3501] = {.lex_state = 106, .external_lex_state = 14},
  [3502] = {.lex_state = 106, .external_lex_state = 25},
  [3503] = {.lex_state = 106, .external_lex_state = 41},
  [3504] = {.lex_state = 106, .external_lex_state = 14},
  [3505] = {.lex_state = 10, .external_lex_state = 14},
  [3506] = {.lex_state = 106, .external_lex_state = 14},
  [3507] = {.lex_state = 106, .external_lex_state = 14},
  [3508] = {.lex_state = 106, .external_lex_state = 14},
  [3509] = {.lex_state = 106, .external_lex_state = 14},
  [3510] = {.lex_state = 106, .external_lex_state = 14},
  [3511] = {.lex_state = 106, .external_lex_state = 25},
  [3512] = {.lex_state = 10, .external_lex_state = 14},
  [3513] = {.lex_state = 106, .external_lex_state = 14},
  [3514] = {.lex_state = 106, .external_lex_state = 40},
  [3515] = {.lex_state = 106, .external_lex_state = 14},
  [3516] = {.lex_state = 106, .external_lex_state = 14},
  [3517] = {.lex_state = 250, .external_lex_state = 14},
  [3518] = {.lex_state = 106, .external_lex_state = 14},
  [3519] = {.lex_state = 10, .external_lex_state = 14},
  [3520] = {.lex_state = 106, .external_lex_state = 40},
  [3521] = {.lex_state = 106, .external_lex_state = 14},
  [3522] = {.lex_state = 12, .external_lex_state = 14},
  [3523] = {.lex_state = 106, .external_lex_state = 14},
  [3524] = {.lex_state = 106, .external_lex_state = 42},
  [3525] = {.lex_state = 106, .external_lex_state = 40},
  [3526] = {.lex_state = 106, .external_lex_state = 27},
  [3527] = {.lex_state = 106, .external_lex_state = 14},
  [3528] = {.lex_state = 106, .external_lex_state = 14},
  [3529] = {.lex_state = 106, .external_lex_state = 14},
  [3530] = {.lex_state = 106, .external_lex_state = 14},
  [3531] = {.lex_state = 106, .external_lex_state = 14},
  [3532] = {.lex_state = 106, .external_lex_state = 14},
  [3533] = {.lex_state = 106, .external_lex_state = 14},
  [3534] = {.lex_state = 106, .external_lex_state = 14},
  [3535] = {.lex_state = 106, .external_lex_state = 14},
  [3536] = {.lex_state = 106, .external_lex_state = 14},
  [3537] = {.lex_state = 106, .external_lex_state = 14},
  [3538] = {.lex_state = 106, .external_lex_state = 14},
  [3539] = {.lex_state = 10, .external_lex_state = 14},
  [3540] = {.lex_state = 106, .external_lex_state = 14},
  [3541] = {.lex_state = 106, .external_lex_state = 43},
  [3542] = {.lex_state = 106, .external_lex_state = 14},
  [3543] = {.lex_state = 106, .external_lex_state = 14},
  [3544] = {.lex_state = 106, .external_lex_state = 14},
  [3545] = {.lex_state = 106, .external_lex_state = 41},
  [3546] = {.lex_state = 106, .external_lex_state = 14},
  [3547] = {.lex_state = 106, .external_lex_state = 14},
  [3548] = {.lex_state = 106, .external_lex_state = 14},
  [3549] = {.lex_state = 106, .external_lex_state = 14},
  [3550] = {.lex_state = 106, .external_lex_state = 14},
  [3551] = {.lex_state = 10, .external_lex_state = 14},
  [3552] = {.lex_state = 106, .external_lex_state = 14},
  [3553] = {.lex_state = 106, .external_lex_state = 14},
  [3554] = {.lex_state = 106, .external_lex_state = 14},
  [3555] = {.lex_state = 106, .external_lex_state = 14},
  [3556] = {.lex_state = 106, .external_lex_state = 25},
  [3557] = {.lex_state = 106, .external_lex_state = 43},
  [3558] = {.lex_state = 106, .external_lex_state = 14},
  [3559] = {.lex_state = 106, .external_lex_state = 14},
  [3560] = {.lex_state = 106, .external_lex_state = 41},
  [3561] = {.lex_state = 106, .external_lex_state = 14},
  [3562] = {.lex_state = 106, .external_lex_state = 14},
  [3563] = {.lex_state = 106, .external_lex_state = 40},
  [3564] = {.lex_state = 106, .external_lex_state = 14},
  [3565] = {.lex_state = 106, .external_lex_state = 14},
  [3566] = {.lex_state = 12, .external_lex_state = 14},
  [3567] = {.lex_state = 106, .external_lex_state = 14},
  [3568] = {.lex_state = 106, .external_lex_state = 14},
  [3569] = {.lex_state = 106, .external_lex_state = 14},
  [3570] = {.lex_state = 106, .external_lex_state = 14},
  [3571] = {.lex_state = 10, .external_lex_state = 14},
  [3572] = {.lex_state = 10, .external_lex_state = 14},
  [3573] = {.lex_state = 10, .external_lex_state = 14},
  [3574] = {.lex_state = 106, .external_lex_state = 14},
  [3575] = {.lex_state = 250, .external_lex_state = 14},
  [3576] = {.lex_state = 10, .external_lex_state = 14},
  [3577] = {.lex_state = 106, .external_lex_state = 14},
  [3578] = {.lex_state = 106, .external_lex_state = 14},
  [3579] = {.lex_state = 106, .external_lex_state = 14},
  [3580] = {.lex_state = 106, .external_lex_state = 43},
  [3581] = {.lex_state = 106, .external_lex_state = 14},
  [3582] = {.lex_state = 106, .external_lex_state = 43},
  [3583] = {.lex_state = 106, .external_lex_state = 40},
  [3584] = {.lex_state = 106, .external_lex_state = 14},
  [3585] = {.lex_state = 106, .external_lex_state = 14},
  [3586] = {.lex_state = 106, .external_lex_state = 43},
  [3587] = {.lex_state = 106, .external_lex_state = 14},
  [3588] = {.lex_state = 106, .external_lex_state = 40},
  [3589] = {.lex_state = 106, .external_lex_state = 42},
  [3590] = {.lex_state = 106, .external_lex_state = 41},
  [3591] = {.lex_state = 106, .external_lex_state = 43},
  [3592] = {.lex_state = 106, .external_lex_state = 40},
  [3593] = {.lex_state = 106, .external_lex_state = 14},
  [3594] = {.lex_state = 106, .external_lex_state = 14},
  [3595] = {.lex_state = 106, .external_lex_state = 43},
  [3596] = {.lex_state = 106, .external_lex_state = 40},
  [3597] = {.lex_state = 106, .external_lex_state = 14},
  [3598] = {.lex_state = 106, .external_lex_state = 14},
  [3599] = {.lex_state = 106, .external_lex_state = 43},
  [3600] = {.lex_state = 106, .external_lex_state = 40},
  [3601] = {.lex_state = 106, .external_lex_state = 14},
  [3602] = {.lex_state = 106, .external_lex_state = 14},
  [3603] = {.lex_state = 106, .external_lex_state = 40},
  [3604] = {.lex_state = 12, .external_lex_state = 14},
  [3605] = {.lex_state = 106, .external_lex_state = 14},
  [3606] = {.lex_state = 106, .external_lex_state = 40},
  [3607] = {.lex_state = 106, .external_lex_state = 14},
  [3608] = {.lex_state = 106, .external_lex_state = 27},
  [3609] = {.lex_state = 106, .external_lex_state = 40},
  [3610] = {.lex_state = 106, .external_lex_state = 14},
  [3611] = {.lex_state = 106, .external_lex_state = 41},
  [3612] = {.lex_state = 106, .external_lex_state = 40},
  [3613] = {.lex_state = 106, .external_lex_state = 41},
  [3614] = {.lex_state = 106, .external_lex_state = 14},
  [3615] = {.lex_state = 106, .external_lex_state = 40},
  [3616] = {.lex_state = 106, .external_lex_state = 14},
  [3617] = {.lex_state = 106, .external_lex_state = 14},
  [3618] = {.lex_state = 106, .external_lex_state = 40},
  [3619] = {.lex_state = 106, .external_lex_state = 14},
  [3620] = {.lex_state = 106, .external_lex_state = 41},
  [3621] = {.lex_state = 106, .external_lex_state = 40},
  [3622] = {.lex_state = 106, .external_lex_state = 14},
  [3623] = {.lex_state = 106, .external_lex_state = 14},
  [3624] = {.lex_state = 106, .external_lex_state = 40},
  [3625] = {.lex_state = 47, .external_lex_state = 14},
  [3626] = {.lex_state = 106, .external_lex_state = 14},
  [3627] = {.lex_state = 106, .external_lex_state = 40},
  [3628] = {.lex_state = 106, .external_lex_state = 14},
  [3629] = {.lex_state = 3, .external_lex_state = 14},
  [3630] = {.lex_state = 106, .external_lex_state = 14},
  [3631] = {.lex_state = 106, .external_lex_state = 41},
  [3632] = {.lex_state = 106, .external_lex_state = 42},
  [3633] = {.lex_state = 250, .external_lex_state = 14},
  [3634] = {.lex_state = 10, .external_lex_state = 14},
  [3635] = {.lex_state = 106, .external_lex_state = 41},
  [3636] = {.lex_state = 106, .external_lex_state = 14},
  [3637] = {.lex_state = 106, .external_lex_state = 14},
  [3638] = {.lex_state = 106, .external_lex_state = 14},
  [3639] = {.lex_state = 106, .external_lex_state = 14},
  [3640] = {.lex_state = 106, .external_lex_state = 14},
  [3641] = {.lex_state = 106, .external_lex_state = 14},
  [3642] = {.lex_state = 106, .external_lex_state = 14},
  [3643] = {.lex_state = 106, .external_lex_state = 14},
  [3644] = {.lex_state = 106, .external_lex_state = 14},
  [3645] = {.lex_state = 106, .external_lex_state = 14},
  [3646] = {.lex_state = 3, .external_lex_state = 14},
  [3647] = {.lex_state = 106, .external_lex_state = 14},
  [3648] = {.lex_state = 106, .external_lex_state = 14},
  [3649] = {.lex_state = 106, .external_lex_state = 14},
  [3650] = {.lex_state = 106, .external_lex_state = 41},
  [3651] = {.lex_state = 106, .external_lex_state = 14},
  [3652] = {.lex_state = 106, .external_lex_state = 14},
  [3653] = {.lex_state = 106, .external_lex_state = 14},
  [3654] = {.lex_state = 106, .external_lex_state = 14},
  [3655] = {.lex_state = 106, .external_lex_state = 14},
  [3656] = {.lex_state = 106, .external_lex_state = 14},
  [3657] = {.lex_state = 106, .external_lex_state = 14},
  [3658] = {.lex_state = 106, .external_lex_state = 14},
  [3659] = {.lex_state = 106, .external_lex_state = 41},
  [3660] = {.lex_state = 106, .external_lex_state = 41},
  [3661] = {.lex_state = 106, .external_lex_state = 42},
  [3662] = {.lex_state = 106, .external_lex_state = 14},
  [3663] = {.lex_state = 106, .external_lex_state = 14},
  [3664] = {.lex_state = 106, .external_lex_state = 14},
  [3665] = {.lex_state = 10, .external_lex_state = 14},
  [3666] = {.lex_state = 106, .external_lex_state = 27},
  [3667] = {.lex_state = 106, .external_lex_state = 14},
  [3668] = {.lex_state = 106, .external_lex_state = 14},
  [3669] = {.lex_state = 106, .external_lex_state = 14},
  [3670] = {.lex_state = 106, .external_lex_state = 14},
  [3671] = {.lex_state = 106, .external_lex_state = 14},
  [3672] = {.lex_state = 106, .external_lex_state = 14},
  [3673] = {.lex_state = 106, .external_lex_state = 14},
  [3674] = {.lex_state = 106, .external_lex_state = 14},
  [3675] = {.lex_state = 106, .external_lex_state = 14},
  [3676] = {.lex_state = 106, .external_lex_state = 25},
  [3677] = {.lex_state = 106, .external_lex_state = 25},
  [3678] = {.lex_state = 106, .external_lex_state = 14},
  [3679] = {.lex_state = 106, .external_lex_state = 14},
  [3680] = {.lex_state = 106, .external_lex_state = 14},
  [3681] = {.lex_state = 106, .external_lex_state = 14},
  [3682] = {.lex_state = 106, .external_lex_state = 14},
  [3683] = {.lex_state = 106, .external_lex_state = 14},
  [3684] = {.lex_state = 106, .external_lex_state = 14},
  [3685] = {.lex_state = 106, .external_lex_state = 14},
  [3686] = {.lex_state = 106, .external_lex_state = 14},
  [3687] = {.lex_state = 106, .external_lex_state = 14},
  [3688] = {.lex_state = 106, .external_lex_state = 14},
  [3689] = {.lex_state = 106, .external_lex_state = 14},
  [3690] = {.lex_state = 106, .external_lex_state = 14},
  [3691] = {.lex_state = 106, .external_lex_state = 14},
  [3692] = {.lex_state = 106, .external_lex_state = 14},
  [3693] = {.lex_state = 106, .external_lex_state = 14},
  [3694] = {.lex_state = 106, .external_lex_state = 14},
  [3695] = {.lex_state = 106, .external_lex_state = 40},
  [3696] = {.lex_state = 106, .external_lex_state = 14},
  [3697] = {.lex_state = 106, .external_lex_state = 14},
  [3698] = {.lex_state = 47, .external_lex_state = 14},
  [3699] = {.lex_state = 106, .external_lex_state = 14},
  [3700] = {.lex_state = 106, .external_lex_state = 14},
  [3701] = {.lex_state = 106, .external_lex_state = 14},
  [3702] = {(TSStateId)(-1)},
  [3703] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_heredoc_content] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__identifier] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_role] = ACTIONS(1),
    [anon_sym_BUILD] = ACTIONS(1),
    [anon_sym_ADJUST] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_my] = ACTIONS(1),
    [anon_sym_extended] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_sub] = ACTIONS(1),
    [anon_sym_method] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_state] = ACTIONS(1),
    [anon_sym_our] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_defer] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_elsif] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_xor] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_DOT_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_x_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_CARET_CARET] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_GT_GT2] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_x] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_BANG_TILDE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_eq] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_equ] = ACTIONS(1),
    [anon_sym_eqr] = ACTIONS(1),
    [anon_sym_ne] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_cmp] = ACTIONS(1),
    [anon_sym_TILDE_TILDE] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_lt] = ACTIONS(1),
    [anon_sym_le] = ACTIONS(1),
    [anon_sym_ge] = ACTIONS(1),
    [anon_sym_gt] = ACTIONS(1),
    [anon_sym_isa] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_eval] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_field] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_dynamically] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_map] = ACTIONS(1),
    [anon_sym_grep] = ACTIONS(1),
    [anon_sym_sort] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_undef] = ACTIONS(1),
    [anon_sym_PERCENT2] = ACTIONS(1),
    [anon_sym_DOLLAR_POUND] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_no] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_foreach] = ACTIONS(1),
    [anon_sym_last] = ACTIONS(1),
    [anon_sym_next] = ACTIONS(1),
    [anon_sym_redo] = ACTIONS(1),
    [anon_sym_BEGIN] = ACTIONS(1),
    [anon_sym_INIT] = ACTIONS(1),
    [anon_sym_CHECK] = ACTIONS(1),
    [anon_sym_UNITCHECK] = ACTIONS(1),
    [anon_sym_END] = ACTIONS(1),
    [anon_sym___FILE__] = ACTIONS(1),
    [anon_sym___LINE__] = ACTIONS(1),
    [anon_sym___PACKAGE__] = ACTIONS(1),
    [anon_sym___SUB__] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_fork] = ACTIONS(1),
    [anon_sym_getppid] = ACTIONS(1),
    [anon_sym_time] = ACTIONS(1),
    [anon_sym_times] = ACTIONS(1),
    [anon_sym_wait] = ACTIONS(1),
    [anon_sym_wantarray] = ACTIONS(1),
    [anon_sym_abs] = ACTIONS(1),
    [anon_sym_alarm] = ACTIONS(1),
    [anon_sym_chop] = ACTIONS(1),
    [anon_sym_chdir] = ACTIONS(1),
    [anon_sym_close] = ACTIONS(1),
    [anon_sym_closedir] = ACTIONS(1),
    [anon_sym_caller] = ACTIONS(1),
    [anon_sym_chomp] = ACTIONS(1),
    [anon_sym_chr] = ACTIONS(1),
    [anon_sym_cos] = ACTIONS(1),
    [anon_sym_chroot] = ACTIONS(1),
    [anon_sym_defined] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_dbmclose] = ACTIONS(1),
    [anon_sym_exists] = ACTIONS(1),
    [anon_sym_exit] = ACTIONS(1),
    [anon_sym_eof] = ACTIONS(1),
    [anon_sym_exp] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_fc] = ACTIONS(1),
    [anon_sym_fileno] = ACTIONS(1),
    [anon_sym_gmtime] = ACTIONS(1),
    [anon_sym_getc] = ACTIONS(1),
    [anon_sym_getpgrp] = ACTIONS(1),
    [anon_sym_getprotobyname] = ACTIONS(1),
    [anon_sym_getpwname] = ACTIONS(1),
    [anon_sym_getpwuid] = ACTIONS(1),
    [anon_sym_getpeername] = ACTIONS(1),
    [anon_sym_getnetbyname] = ACTIONS(1),
    [anon_sym_getsockname] = ACTIONS(1),
    [anon_sym_getgrnam] = ACTIONS(1),
    [anon_sym_getgrgid] = ACTIONS(1),
    [anon_sym_hex] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_keys] = ACTIONS(1),
    [anon_sym_lc] = ACTIONS(1),
    [anon_sym_lcfirst] = ACTIONS(1),
    [anon_sym_length] = ACTIONS(1),
    [anon_sym_localtime] = ACTIONS(1),
    [anon_sym_log] = ACTIONS(1),
    [anon_sym_lock] = ACTIONS(1),
    [anon_sym_lstat] = ACTIONS(1),
    [anon_sym_oct] = ACTIONS(1),
    [anon_sym_ord] = ACTIONS(1),
    [anon_sym_prototype] = ACTIONS(1),
    [anon_sym_pop] = ACTIONS(1),
    [anon_sym_pos] = ACTIONS(1),
    [anon_sym_quotemeta] = ACTIONS(1),
    [anon_sym_reset] = ACTIONS(1),
    [anon_sym_rand] = ACTIONS(1),
    [anon_sym_rmdir] = ACTIONS(1),
    [anon_sym_readdir] = ACTIONS(1),
    [anon_sym_readline] = ACTIONS(1),
    [anon_sym_readpipe] = ACTIONS(1),
    [anon_sym_rewinddir] = ACTIONS(1),
    [anon_sym_readlink] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [anon_sym_scalar] = ACTIONS(1),
    [anon_sym_shift] = ACTIONS(1),
    [anon_sym_sin] = ACTIONS(1),
    [anon_sym_sleep] = ACTIONS(1),
    [anon_sym_sqrt] = ACTIONS(1),
    [anon_sym_srand] = ACTIONS(1),
    [anon_sym_stat] = ACTIONS(1),
    [anon_sym_study] = ACTIONS(1),
    [anon_sym_tell] = ACTIONS(1),
    [anon_sym_telldir] = ACTIONS(1),
    [anon_sym_tied] = ACTIONS(1),
    [anon_sym_uc] = ACTIONS(1),
    [anon_sym_ucfirst] = ACTIONS(1),
    [anon_sym_untie] = ACTIONS(1),
    [anon_sym_umask] = ACTIONS(1),
    [anon_sym_values] = ACTIONS(1),
    [anon_sym_write] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(1),
    [anon_sym___END__] = ACTIONS(1),
    [anon_sym_EOT] = ACTIONS(1),
    [anon_sym_q] = ACTIONS(1),
    [anon_sym_qq] = ACTIONS(1),
    [anon_sym_LBRACK2] = ACTIONS(1),
    [anon_sym_LBRACE2] = ACTIONS(1),
    [anon_sym_qw] = ACTIONS(1),
    [anon_sym_qx] = ACTIONS(1),
    [anon_sym_qr] = ACTIONS(1),
    [anon_sym_m] = ACTIONS(1),
    [anon_sym_s] = ACTIONS(1),
    [sym_quoted_regexp_modifiers] = ACTIONS(1),
    [anon_sym_tr] = ACTIONS(1),
    [anon_sym_y] = ACTIONS(1),
    [sym_version] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_unless] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [aux_sym__bareword_token1] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym__single_quote] = ACTIONS(1),
    [sym__double_quote] = ACTIONS(1),
    [sym__backtick_quote] = ACTIONS(1),
    [sym__search_slash_quote] = ACTIONS(1),
    [sym__no_search_slash_plz] = ACTIONS(1),
    [sym__PERLY_SEMICOLON] = ACTIONS(1),
    [sym__PERLY_HEREDOC] = ACTIONS(1),
    [sym__ctrl_z_hack] = ACTIONS(1),
    [sym__quotelike_begin_quote] = ACTIONS(1),
    [sym__quotelike_middle_close_quote] = ACTIONS(1),
    [sym__quotelike_middle_skip] = ACTIONS(1),
    [sym__quotelike_end_zw] = ACTIONS(1),
    [sym__quotelike_end_quote] = ACTIONS(1),
    [sym__q_string_content] = ACTIONS(1),
    [sym__qq_string_content] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_escaped_delimiter] = ACTIONS(1),
    [sym__dollar_in_regexp] = ACTIONS(1),
    [sym_pod] = ACTIONS(5),
    [sym__gobbled_content] = ACTIONS(1),
    [sym__attribute_value_begin] = ACTIONS(1),
    [sym_attribute_value] = ACTIONS(1),
    [sym_prototype] = ACTIONS(1),
    [sym__signature_start] = ACTIONS(1),
    [sym__heredoc_delimiter] = ACTIONS(1),
    [sym__command_heredoc_delimiter] = ACTIONS(1),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__heredoc_middle] = ACTIONS(1),
    [sym_heredoc_end] = ACTIONS(1),
    [sym__fat_comma_autoquoted] = ACTIONS(1),
    [sym__filetest] = ACTIONS(1),
    [sym__brace_autoquoted_token] = ACTIONS(1),
    [sym__brace_end_zw] = ACTIONS(1),
    [sym__dollar_ident_zw] = ACTIONS(1),
    [sym__no_interp_whitespace_zw] = ACTIONS(1),
    [sym__NONASSOC] = ACTIONS(1),
    [sym__ERROR] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(3543),
    [sym__PERLY_BRACE_OPEN] = STATE(67),
    [sym_block] = STATE(868),
    [sym__fullstmt] = STATE(884),
    [sym_statement_label] = STATE(804),
    [sym__barestmt] = STATE(804),
    [sym_package_statement] = STATE(839),
    [sym_class_statement] = STATE(839),
    [sym_role_statement] = STATE(839),
    [sym_class_phaser_statement] = STATE(839),
    [sym_use_version_statement] = STATE(839),
    [sym_use_statement] = STATE(839),
    [sym_subroutine_declaration_statement] = STATE(839),
    [sym_method_declaration_statement] = STATE(839),
    [sym_phaser_statement] = STATE(839),
    [sym_conditional_statement] = STATE(839),
    [sym_loop_statement] = STATE(839),
    [sym_cstyle_for_statement] = STATE(839),
    [sym_for_statement] = STATE(839),
    [sym_try_statement] = STATE(839),
    [sym_defer_statement] = STATE(839),
    [sym_expression_statement] = STATE(2715),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym___DATA__] = STATE(3504),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(1),
    [sym__conditionals] = STATE(3537),
    [sym__loops] = STATE(3594),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3646),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(16),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(2984),
    [ts_builtin_sym_end] = ACTIONS(9),
    [sym__identifier] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(15),
    [anon_sym_package] = ACTIONS(17),
    [anon_sym_class] = ACTIONS(19),
    [anon_sym_role] = ACTIONS(21),
    [anon_sym_BUILD] = ACTIONS(23),
    [anon_sym_ADJUST] = ACTIONS(23),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(29),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(33),
    [anon_sym_method] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_defer] = ACTIONS(45),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_use] = ACTIONS(91),
    [anon_sym_no] = ACTIONS(91),
    [anon_sym_for] = ACTIONS(93),
    [anon_sym_foreach] = ACTIONS(93),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(97),
    [anon_sym_INIT] = ACTIONS(97),
    [anon_sym_CHECK] = ACTIONS(97),
    [anon_sym_UNITCHECK] = ACTIONS(97),
    [anon_sym_END] = ACTIONS(97),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(101),
    [anon_sym___END__] = ACTIONS(101),
    [anon_sym_EOT] = ACTIONS(103),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__bareword_token1] = ACTIONS(125),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(141),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
  },
  [2] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1226),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym__label_arg] = STATE(1138),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(2),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(1110),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(151),
    [anon_sym_SEMI] = ACTIONS(151),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(151),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(151),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(151),
    [anon_sym_my] = ACTIONS(41),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(151),
    [anon_sym_and] = ACTIONS(151),
    [anon_sym_or] = ACTIONS(151),
    [anon_sym_xor] = ACTIONS(151),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(151),
    [anon_sym_PERCENT] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(151),
    [anon_sym_LT_LT] = ACTIONS(151),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(151),
    [anon_sym_PLUS_EQ] = ACTIONS(151),
    [anon_sym_DASH_EQ] = ACTIONS(151),
    [anon_sym_DOT_EQ] = ACTIONS(151),
    [anon_sym_STAR_EQ] = ACTIONS(151),
    [anon_sym_SLASH_EQ] = ACTIONS(151),
    [anon_sym_PERCENT_EQ] = ACTIONS(151),
    [anon_sym_x_EQ] = ACTIONS(151),
    [anon_sym_AMP_EQ] = ACTIONS(151),
    [anon_sym_PIPE_EQ] = ACTIONS(151),
    [anon_sym_CARET_EQ] = ACTIONS(151),
    [anon_sym_LT_LT_EQ] = ACTIONS(151),
    [anon_sym_GT_GT_EQ] = ACTIONS(151),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(151),
    [anon_sym_DOT_DOT] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_SLASH_SLASH] = ACTIONS(151),
    [anon_sym_CARET_CARET] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(151),
    [anon_sym_CARET] = ACTIONS(151),
    [anon_sym_AMP] = ACTIONS(151),
    [anon_sym_GT_GT2] = ACTIONS(151),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(151),
    [anon_sym_DOT] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(151),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_x] = ACTIONS(151),
    [anon_sym_EQ_TILDE] = ACTIONS(151),
    [anon_sym_BANG_TILDE] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_eq] = ACTIONS(151),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_equ] = ACTIONS(151),
    [anon_sym_eqr] = ACTIONS(151),
    [anon_sym_ne] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(151),
    [anon_sym_cmp] = ACTIONS(151),
    [anon_sym_TILDE_TILDE] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_lt] = ACTIONS(151),
    [anon_sym_le] = ACTIONS(151),
    [anon_sym_ge] = ACTIONS(151),
    [anon_sym_gt] = ACTIONS(151),
    [anon_sym_isa] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_BSLASH] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(151),
    [anon_sym_for] = ACTIONS(151),
    [anon_sym_foreach] = ACTIONS(151),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(151),
    [anon_sym___END__] = ACTIONS(151),
    [anon_sym_EOT] = ACTIONS(151),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(151),
    [anon_sym_unless] = ACTIONS(151),
    [anon_sym_while] = ACTIONS(151),
    [anon_sym_until] = ACTIONS(151),
    [aux_sym__bareword_token1] = ACTIONS(125),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(157),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(157),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
  },
  [3] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__term_rightward] = STATE(1122),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1063),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(3),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(125),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(159),
    [anon_sym_SEMI] = ACTIONS(159),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(159),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(159),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(159),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(159),
    [anon_sym_my] = ACTIONS(41),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(159),
    [anon_sym_and] = ACTIONS(159),
    [anon_sym_or] = ACTIONS(159),
    [anon_sym_xor] = ACTIONS(159),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(159),
    [anon_sym_PERCENT] = ACTIONS(159),
    [anon_sym_LT] = ACTIONS(161),
    [anon_sym_GT] = ACTIONS(159),
    [anon_sym_LT_LT] = ACTIONS(164),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(159),
    [anon_sym_PLUS_EQ] = ACTIONS(159),
    [anon_sym_DASH_EQ] = ACTIONS(159),
    [anon_sym_DOT_EQ] = ACTIONS(159),
    [anon_sym_STAR_EQ] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(159),
    [anon_sym_PERCENT_EQ] = ACTIONS(159),
    [anon_sym_x_EQ] = ACTIONS(159),
    [anon_sym_AMP_EQ] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(159),
    [anon_sym_CARET_EQ] = ACTIONS(159),
    [anon_sym_LT_LT_EQ] = ACTIONS(159),
    [anon_sym_GT_GT_EQ] = ACTIONS(159),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(159),
    [anon_sym_DOT_DOT] = ACTIONS(159),
    [anon_sym_STAR_STAR] = ACTIONS(159),
    [anon_sym_PIPE_PIPE] = ACTIONS(159),
    [anon_sym_SLASH_SLASH] = ACTIONS(167),
    [anon_sym_CARET_CARET] = ACTIONS(159),
    [anon_sym_AMP_AMP] = ACTIONS(159),
    [anon_sym_PIPE] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(159),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_GT_GT2] = ACTIONS(159),
    [anon_sym_PLUS] = ACTIONS(170),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_DOT] = ACTIONS(159),
    [anon_sym_STAR] = ACTIONS(176),
    [anon_sym_SLASH] = ACTIONS(159),
    [anon_sym_x] = ACTIONS(159),
    [anon_sym_EQ_TILDE] = ACTIONS(159),
    [anon_sym_BANG_TILDE] = ACTIONS(159),
    [anon_sym_EQ_EQ] = ACTIONS(159),
    [anon_sym_BANG_EQ] = ACTIONS(159),
    [anon_sym_eq] = ACTIONS(159),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(159),
    [anon_sym_equ] = ACTIONS(159),
    [anon_sym_eqr] = ACTIONS(159),
    [anon_sym_ne] = ACTIONS(159),
    [anon_sym_LT_EQ_GT] = ACTIONS(159),
    [anon_sym_cmp] = ACTIONS(159),
    [anon_sym_TILDE_TILDE] = ACTIONS(159),
    [anon_sym_LT_EQ] = ACTIONS(159),
    [anon_sym_GT_EQ] = ACTIONS(159),
    [anon_sym_lt] = ACTIONS(159),
    [anon_sym_le] = ACTIONS(159),
    [anon_sym_ge] = ACTIONS(159),
    [anon_sym_gt] = ACTIONS(159),
    [anon_sym_isa] = ACTIONS(159),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(179),
    [anon_sym_DASH_DASH] = ACTIONS(179),
    [anon_sym_QMARK] = ACTIONS(159),
    [anon_sym_BSLASH] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(159),
    [anon_sym_foreach] = ACTIONS(159),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(159),
    [anon_sym___END__] = ACTIONS(159),
    [anon_sym_EOT] = ACTIONS(159),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_unless] = ACTIONS(159),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_until] = ACTIONS(159),
    [aux_sym__bareword_token1] = ACTIONS(125),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(182),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(182),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
  },
  [4] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1129),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(4),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(125),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(184),
    [anon_sym_SEMI] = ACTIONS(184),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(184),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(184),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(184),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(184),
    [anon_sym_my] = ACTIONS(41),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(184),
    [anon_sym_and] = ACTIONS(184),
    [anon_sym_or] = ACTIONS(184),
    [anon_sym_xor] = ACTIONS(184),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(184),
    [anon_sym_PERCENT] = ACTIONS(184),
    [anon_sym_LT] = ACTIONS(184),
    [anon_sym_GT] = ACTIONS(184),
    [anon_sym_LT_LT] = ACTIONS(184),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(184),
    [anon_sym_PLUS_EQ] = ACTIONS(184),
    [anon_sym_DASH_EQ] = ACTIONS(184),
    [anon_sym_DOT_EQ] = ACTIONS(184),
    [anon_sym_STAR_EQ] = ACTIONS(184),
    [anon_sym_SLASH_EQ] = ACTIONS(184),
    [anon_sym_PERCENT_EQ] = ACTIONS(184),
    [anon_sym_x_EQ] = ACTIONS(184),
    [anon_sym_AMP_EQ] = ACTIONS(184),
    [anon_sym_PIPE_EQ] = ACTIONS(184),
    [anon_sym_CARET_EQ] = ACTIONS(184),
    [anon_sym_LT_LT_EQ] = ACTIONS(184),
    [anon_sym_GT_GT_EQ] = ACTIONS(184),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(184),
    [anon_sym_DOT_DOT] = ACTIONS(184),
    [anon_sym_STAR_STAR] = ACTIONS(184),
    [anon_sym_PIPE_PIPE] = ACTIONS(184),
    [anon_sym_SLASH_SLASH] = ACTIONS(184),
    [anon_sym_CARET_CARET] = ACTIONS(184),
    [anon_sym_AMP_AMP] = ACTIONS(184),
    [anon_sym_PIPE] = ACTIONS(184),
    [anon_sym_CARET] = ACTIONS(184),
    [anon_sym_AMP] = ACTIONS(184),
    [anon_sym_GT_GT2] = ACTIONS(184),
    [anon_sym_PLUS] = ACTIONS(184),
    [anon_sym_DASH] = ACTIONS(184),
    [anon_sym_DOT] = ACTIONS(184),
    [anon_sym_STAR] = ACTIONS(184),
    [anon_sym_SLASH] = ACTIONS(184),
    [anon_sym_x] = ACTIONS(184),
    [anon_sym_EQ_TILDE] = ACTIONS(184),
    [anon_sym_BANG_TILDE] = ACTIONS(184),
    [anon_sym_EQ_EQ] = ACTIONS(184),
    [anon_sym_BANG_EQ] = ACTIONS(184),
    [anon_sym_eq] = ACTIONS(184),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(184),
    [anon_sym_equ] = ACTIONS(184),
    [anon_sym_eqr] = ACTIONS(184),
    [anon_sym_ne] = ACTIONS(184),
    [anon_sym_LT_EQ_GT] = ACTIONS(184),
    [anon_sym_cmp] = ACTIONS(184),
    [anon_sym_TILDE_TILDE] = ACTIONS(184),
    [anon_sym_LT_EQ] = ACTIONS(184),
    [anon_sym_GT_EQ] = ACTIONS(184),
    [anon_sym_lt] = ACTIONS(184),
    [anon_sym_le] = ACTIONS(184),
    [anon_sym_ge] = ACTIONS(184),
    [anon_sym_gt] = ACTIONS(184),
    [anon_sym_isa] = ACTIONS(184),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(184),
    [anon_sym_DASH_DASH] = ACTIONS(184),
    [anon_sym_QMARK] = ACTIONS(184),
    [anon_sym_BSLASH] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(184),
    [anon_sym_for] = ACTIONS(184),
    [anon_sym_foreach] = ACTIONS(184),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(184),
    [anon_sym___END__] = ACTIONS(184),
    [anon_sym_EOT] = ACTIONS(184),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(184),
    [anon_sym_unless] = ACTIONS(184),
    [anon_sym_while] = ACTIONS(184),
    [anon_sym_until] = ACTIONS(184),
    [aux_sym__bareword_token1] = ACTIONS(125),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(186),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(186),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
  },
  [5] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1181),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(5),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(125),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(188),
    [anon_sym_SEMI] = ACTIONS(188),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(188),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(188),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(188),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(188),
    [anon_sym_my] = ACTIONS(41),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(188),
    [anon_sym_and] = ACTIONS(188),
    [anon_sym_or] = ACTIONS(188),
    [anon_sym_xor] = ACTIONS(188),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(188),
    [anon_sym_PERCENT] = ACTIONS(188),
    [anon_sym_LT] = ACTIONS(190),
    [anon_sym_GT] = ACTIONS(188),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(188),
    [anon_sym_PLUS_EQ] = ACTIONS(188),
    [anon_sym_DASH_EQ] = ACTIONS(188),
    [anon_sym_DOT_EQ] = ACTIONS(188),
    [anon_sym_STAR_EQ] = ACTIONS(188),
    [anon_sym_SLASH_EQ] = ACTIONS(188),
    [anon_sym_PERCENT_EQ] = ACTIONS(188),
    [anon_sym_x_EQ] = ACTIONS(188),
    [anon_sym_AMP_EQ] = ACTIONS(188),
    [anon_sym_PIPE_EQ] = ACTIONS(188),
    [anon_sym_CARET_EQ] = ACTIONS(188),
    [anon_sym_LT_LT_EQ] = ACTIONS(188),
    [anon_sym_GT_GT_EQ] = ACTIONS(188),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(188),
    [anon_sym_DOT_DOT] = ACTIONS(188),
    [anon_sym_STAR_STAR] = ACTIONS(188),
    [anon_sym_PIPE_PIPE] = ACTIONS(188),
    [anon_sym_SLASH_SLASH] = ACTIONS(196),
    [anon_sym_CARET_CARET] = ACTIONS(188),
    [anon_sym_AMP_AMP] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(188),
    [anon_sym_AMP] = ACTIONS(188),
    [anon_sym_GT_GT2] = ACTIONS(188),
    [anon_sym_PLUS] = ACTIONS(199),
    [anon_sym_DASH] = ACTIONS(202),
    [anon_sym_DOT] = ACTIONS(188),
    [anon_sym_STAR] = ACTIONS(205),
    [anon_sym_SLASH] = ACTIONS(188),
    [anon_sym_x] = ACTIONS(188),
    [anon_sym_EQ_TILDE] = ACTIONS(188),
    [anon_sym_BANG_TILDE] = ACTIONS(188),
    [anon_sym_EQ_EQ] = ACTIONS(188),
    [anon_sym_BANG_EQ] = ACTIONS(188),
    [anon_sym_eq] = ACTIONS(188),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(188),
    [anon_sym_equ] = ACTIONS(188),
    [anon_sym_eqr] = ACTIONS(188),
    [anon_sym_ne] = ACTIONS(188),
    [anon_sym_LT_EQ_GT] = ACTIONS(188),
    [anon_sym_cmp] = ACTIONS(188),
    [anon_sym_TILDE_TILDE] = ACTIONS(188),
    [anon_sym_LT_EQ] = ACTIONS(188),
    [anon_sym_GT_EQ] = ACTIONS(188),
    [anon_sym_lt] = ACTIONS(188),
    [anon_sym_le] = ACTIONS(188),
    [anon_sym_ge] = ACTIONS(188),
    [anon_sym_gt] = ACTIONS(188),
    [anon_sym_isa] = ACTIONS(188),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(208),
    [anon_sym_DASH_DASH] = ACTIONS(208),
    [anon_sym_QMARK] = ACTIONS(188),
    [anon_sym_BSLASH] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(188),
    [anon_sym_for] = ACTIONS(188),
    [anon_sym_foreach] = ACTIONS(188),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(188),
    [anon_sym___END__] = ACTIONS(188),
    [anon_sym_EOT] = ACTIONS(188),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(188),
    [anon_sym_unless] = ACTIONS(188),
    [anon_sym_while] = ACTIONS(188),
    [anon_sym_until] = ACTIONS(188),
    [aux_sym__bareword_token1] = ACTIONS(125),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(211),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(211),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
  },
  [6] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1189),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(6),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(125),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(213),
    [anon_sym_SEMI] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(213),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(213),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(213),
    [anon_sym_my] = ACTIONS(41),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(213),
    [anon_sym_and] = ACTIONS(213),
    [anon_sym_or] = ACTIONS(213),
    [anon_sym_xor] = ACTIONS(213),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(213),
    [anon_sym_PERCENT] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(213),
    [anon_sym_GT] = ACTIONS(213),
    [anon_sym_LT_LT] = ACTIONS(213),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(213),
    [anon_sym_PLUS_EQ] = ACTIONS(213),
    [anon_sym_DASH_EQ] = ACTIONS(213),
    [anon_sym_DOT_EQ] = ACTIONS(213),
    [anon_sym_STAR_EQ] = ACTIONS(213),
    [anon_sym_SLASH_EQ] = ACTIONS(213),
    [anon_sym_PERCENT_EQ] = ACTIONS(213),
    [anon_sym_x_EQ] = ACTIONS(213),
    [anon_sym_AMP_EQ] = ACTIONS(213),
    [anon_sym_PIPE_EQ] = ACTIONS(213),
    [anon_sym_CARET_EQ] = ACTIONS(213),
    [anon_sym_LT_LT_EQ] = ACTIONS(213),
    [anon_sym_GT_GT_EQ] = ACTIONS(213),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(213),
    [anon_sym_STAR_STAR] = ACTIONS(213),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_SLASH_SLASH] = ACTIONS(213),
    [anon_sym_CARET_CARET] = ACTIONS(213),
    [anon_sym_AMP_AMP] = ACTIONS(213),
    [anon_sym_PIPE] = ACTIONS(213),
    [anon_sym_CARET] = ACTIONS(213),
    [anon_sym_AMP] = ACTIONS(213),
    [anon_sym_GT_GT2] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(213),
    [anon_sym_DASH] = ACTIONS(213),
    [anon_sym_DOT] = ACTIONS(213),
    [anon_sym_STAR] = ACTIONS(213),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_x] = ACTIONS(213),
    [anon_sym_EQ_TILDE] = ACTIONS(213),
    [anon_sym_BANG_TILDE] = ACTIONS(213),
    [anon_sym_EQ_EQ] = ACTIONS(213),
    [anon_sym_BANG_EQ] = ACTIONS(213),
    [anon_sym_eq] = ACTIONS(213),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(213),
    [anon_sym_equ] = ACTIONS(213),
    [anon_sym_eqr] = ACTIONS(213),
    [anon_sym_ne] = ACTIONS(213),
    [anon_sym_LT_EQ_GT] = ACTIONS(213),
    [anon_sym_cmp] = ACTIONS(213),
    [anon_sym_TILDE_TILDE] = ACTIONS(213),
    [anon_sym_LT_EQ] = ACTIONS(213),
    [anon_sym_GT_EQ] = ACTIONS(213),
    [anon_sym_lt] = ACTIONS(213),
    [anon_sym_le] = ACTIONS(213),
    [anon_sym_ge] = ACTIONS(213),
    [anon_sym_gt] = ACTIONS(213),
    [anon_sym_isa] = ACTIONS(213),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(213),
    [anon_sym_DASH_DASH] = ACTIONS(213),
    [anon_sym_QMARK] = ACTIONS(213),
    [anon_sym_BSLASH] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(213),
    [anon_sym_for] = ACTIONS(213),
    [anon_sym_foreach] = ACTIONS(213),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(213),
    [anon_sym___END__] = ACTIONS(213),
    [anon_sym_EOT] = ACTIONS(213),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(213),
    [anon_sym_unless] = ACTIONS(213),
    [anon_sym_while] = ACTIONS(213),
    [anon_sym_until] = ACTIONS(213),
    [aux_sym__bareword_token1] = ACTIONS(125),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(215),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(215),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
  },
  [7] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1125),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(7),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(125),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(217),
    [anon_sym_SEMI] = ACTIONS(217),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(217),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(217),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(217),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(217),
    [anon_sym_my] = ACTIONS(41),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(217),
    [anon_sym_and] = ACTIONS(217),
    [anon_sym_or] = ACTIONS(217),
    [anon_sym_xor] = ACTIONS(217),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(217),
    [anon_sym_PERCENT] = ACTIONS(217),
    [anon_sym_LT] = ACTIONS(217),
    [anon_sym_GT] = ACTIONS(217),
    [anon_sym_LT_LT] = ACTIONS(217),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(217),
    [anon_sym_PLUS_EQ] = ACTIONS(217),
    [anon_sym_DASH_EQ] = ACTIONS(217),
    [anon_sym_DOT_EQ] = ACTIONS(217),
    [anon_sym_STAR_EQ] = ACTIONS(217),
    [anon_sym_SLASH_EQ] = ACTIONS(217),
    [anon_sym_PERCENT_EQ] = ACTIONS(217),
    [anon_sym_x_EQ] = ACTIONS(217),
    [anon_sym_AMP_EQ] = ACTIONS(217),
    [anon_sym_PIPE_EQ] = ACTIONS(217),
    [anon_sym_CARET_EQ] = ACTIONS(217),
    [anon_sym_LT_LT_EQ] = ACTIONS(217),
    [anon_sym_GT_GT_EQ] = ACTIONS(217),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(217),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_STAR_STAR] = ACTIONS(217),
    [anon_sym_PIPE_PIPE] = ACTIONS(217),
    [anon_sym_SLASH_SLASH] = ACTIONS(217),
    [anon_sym_CARET_CARET] = ACTIONS(217),
    [anon_sym_AMP_AMP] = ACTIONS(217),
    [anon_sym_PIPE] = ACTIONS(217),
    [anon_sym_CARET] = ACTIONS(217),
    [anon_sym_AMP] = ACTIONS(217),
    [anon_sym_GT_GT2] = ACTIONS(217),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(217),
    [anon_sym_STAR] = ACTIONS(217),
    [anon_sym_SLASH] = ACTIONS(217),
    [anon_sym_x] = ACTIONS(217),
    [anon_sym_EQ_TILDE] = ACTIONS(217),
    [anon_sym_BANG_TILDE] = ACTIONS(217),
    [anon_sym_EQ_EQ] = ACTIONS(217),
    [anon_sym_BANG_EQ] = ACTIONS(217),
    [anon_sym_eq] = ACTIONS(217),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(217),
    [anon_sym_equ] = ACTIONS(217),
    [anon_sym_eqr] = ACTIONS(217),
    [anon_sym_ne] = ACTIONS(217),
    [anon_sym_LT_EQ_GT] = ACTIONS(217),
    [anon_sym_cmp] = ACTIONS(217),
    [anon_sym_TILDE_TILDE] = ACTIONS(217),
    [anon_sym_LT_EQ] = ACTIONS(217),
    [anon_sym_GT_EQ] = ACTIONS(217),
    [anon_sym_lt] = ACTIONS(217),
    [anon_sym_le] = ACTIONS(217),
    [anon_sym_ge] = ACTIONS(217),
    [anon_sym_gt] = ACTIONS(217),
    [anon_sym_isa] = ACTIONS(217),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_QMARK] = ACTIONS(217),
    [anon_sym_BSLASH] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(217),
    [anon_sym_for] = ACTIONS(217),
    [anon_sym_foreach] = ACTIONS(217),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(217),
    [anon_sym___END__] = ACTIONS(217),
    [anon_sym_EOT] = ACTIONS(217),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(217),
    [anon_sym_unless] = ACTIONS(217),
    [anon_sym_while] = ACTIONS(217),
    [anon_sym_until] = ACTIONS(217),
    [aux_sym__bareword_token1] = ACTIONS(125),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(221),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(221),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
  },
  [8] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1305),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym__label_arg] = STATE(1138),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(370),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(8),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(1110),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(223),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_SEMI] = ACTIONS(151),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(151),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(151),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(151),
    [anon_sym_my] = ACTIONS(225),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(225),
    [anon_sym_our] = ACTIONS(225),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(151),
    [anon_sym_and] = ACTIONS(151),
    [anon_sym_or] = ACTIONS(151),
    [anon_sym_xor] = ACTIONS(151),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(151),
    [anon_sym_PERCENT] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(151),
    [anon_sym_LT_LT] = ACTIONS(151),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(151),
    [anon_sym_PLUS_EQ] = ACTIONS(151),
    [anon_sym_DASH_EQ] = ACTIONS(151),
    [anon_sym_DOT_EQ] = ACTIONS(151),
    [anon_sym_STAR_EQ] = ACTIONS(151),
    [anon_sym_SLASH_EQ] = ACTIONS(151),
    [anon_sym_PERCENT_EQ] = ACTIONS(151),
    [anon_sym_x_EQ] = ACTIONS(151),
    [anon_sym_AMP_EQ] = ACTIONS(151),
    [anon_sym_PIPE_EQ] = ACTIONS(151),
    [anon_sym_CARET_EQ] = ACTIONS(151),
    [anon_sym_LT_LT_EQ] = ACTIONS(151),
    [anon_sym_GT_GT_EQ] = ACTIONS(151),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(151),
    [anon_sym_DOT_DOT] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_SLASH_SLASH] = ACTIONS(151),
    [anon_sym_CARET_CARET] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(151),
    [anon_sym_CARET] = ACTIONS(151),
    [anon_sym_AMP] = ACTIONS(151),
    [anon_sym_GT_GT2] = ACTIONS(151),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(151),
    [anon_sym_DOT] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(151),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_x] = ACTIONS(151),
    [anon_sym_EQ_TILDE] = ACTIONS(151),
    [anon_sym_BANG_TILDE] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_eq] = ACTIONS(151),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_equ] = ACTIONS(151),
    [anon_sym_eqr] = ACTIONS(151),
    [anon_sym_ne] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(151),
    [anon_sym_cmp] = ACTIONS(151),
    [anon_sym_TILDE_TILDE] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_lt] = ACTIONS(151),
    [anon_sym_le] = ACTIONS(151),
    [anon_sym_ge] = ACTIONS(151),
    [anon_sym_gt] = ACTIONS(151),
    [anon_sym_isa] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(227),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_BSLASH] = ACTIONS(229),
    [anon_sym_do] = ACTIONS(231),
    [anon_sym_eval] = ACTIONS(233),
    [anon_sym_await] = ACTIONS(235),
    [anon_sym_field] = ACTIONS(225),
    [anon_sym_local] = ACTIONS(237),
    [anon_sym_dynamically] = ACTIONS(237),
    [anon_sym_require] = ACTIONS(239),
    [anon_sym_map] = ACTIONS(241),
    [anon_sym_grep] = ACTIONS(241),
    [anon_sym_sort] = ACTIONS(243),
    [anon_sym_goto] = ACTIONS(245),
    [anon_sym_return] = ACTIONS(247),
    [anon_sym_undef] = ACTIONS(249),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(151),
    [anon_sym_last] = ACTIONS(251),
    [anon_sym_next] = ACTIONS(251),
    [anon_sym_redo] = ACTIONS(251),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(253),
    [anon_sym_alarm] = ACTIONS(253),
    [anon_sym_chop] = ACTIONS(253),
    [anon_sym_chdir] = ACTIONS(253),
    [anon_sym_close] = ACTIONS(253),
    [anon_sym_closedir] = ACTIONS(253),
    [anon_sym_caller] = ACTIONS(253),
    [anon_sym_chomp] = ACTIONS(253),
    [anon_sym_chr] = ACTIONS(253),
    [anon_sym_cos] = ACTIONS(253),
    [anon_sym_chroot] = ACTIONS(253),
    [anon_sym_defined] = ACTIONS(253),
    [anon_sym_delete] = ACTIONS(253),
    [anon_sym_dbmclose] = ACTIONS(253),
    [anon_sym_exists] = ACTIONS(253),
    [anon_sym_exit] = ACTIONS(253),
    [anon_sym_eof] = ACTIONS(253),
    [anon_sym_exp] = ACTIONS(253),
    [anon_sym_each] = ACTIONS(253),
    [anon_sym_fc] = ACTIONS(253),
    [anon_sym_fileno] = ACTIONS(253),
    [anon_sym_gmtime] = ACTIONS(253),
    [anon_sym_getc] = ACTIONS(253),
    [anon_sym_getpgrp] = ACTIONS(253),
    [anon_sym_getprotobyname] = ACTIONS(253),
    [anon_sym_getpwname] = ACTIONS(253),
    [anon_sym_getpwuid] = ACTIONS(253),
    [anon_sym_getpeername] = ACTIONS(253),
    [anon_sym_getnetbyname] = ACTIONS(253),
    [anon_sym_getsockname] = ACTIONS(253),
    [anon_sym_getgrnam] = ACTIONS(253),
    [anon_sym_getgrgid] = ACTIONS(253),
    [anon_sym_hex] = ACTIONS(253),
    [anon_sym_int] = ACTIONS(253),
    [anon_sym_keys] = ACTIONS(253),
    [anon_sym_lc] = ACTIONS(253),
    [anon_sym_lcfirst] = ACTIONS(253),
    [anon_sym_length] = ACTIONS(253),
    [anon_sym_localtime] = ACTIONS(253),
    [anon_sym_log] = ACTIONS(253),
    [anon_sym_lock] = ACTIONS(253),
    [anon_sym_lstat] = ACTIONS(253),
    [anon_sym_oct] = ACTIONS(253),
    [anon_sym_ord] = ACTIONS(253),
    [anon_sym_prototype] = ACTIONS(253),
    [anon_sym_pop] = ACTIONS(253),
    [anon_sym_pos] = ACTIONS(253),
    [anon_sym_quotemeta] = ACTIONS(253),
    [anon_sym_reset] = ACTIONS(253),
    [anon_sym_rand] = ACTIONS(253),
    [anon_sym_rmdir] = ACTIONS(253),
    [anon_sym_readdir] = ACTIONS(253),
    [anon_sym_readline] = ACTIONS(253),
    [anon_sym_readpipe] = ACTIONS(253),
    [anon_sym_rewinddir] = ACTIONS(253),
    [anon_sym_readlink] = ACTIONS(253),
    [anon_sym_ref] = ACTIONS(253),
    [anon_sym_scalar] = ACTIONS(253),
    [anon_sym_shift] = ACTIONS(253),
    [anon_sym_sin] = ACTIONS(253),
    [anon_sym_sleep] = ACTIONS(253),
    [anon_sym_sqrt] = ACTIONS(253),
    [anon_sym_srand] = ACTIONS(253),
    [anon_sym_stat] = ACTIONS(253),
    [anon_sym_study] = ACTIONS(253),
    [anon_sym_tell] = ACTIONS(253),
    [anon_sym_telldir] = ACTIONS(253),
    [anon_sym_tied] = ACTIONS(253),
    [anon_sym_uc] = ACTIONS(253),
    [anon_sym_ucfirst] = ACTIONS(253),
    [anon_sym_untie] = ACTIONS(253),
    [anon_sym_umask] = ACTIONS(253),
    [anon_sym_values] = ACTIONS(253),
    [anon_sym_write] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(151),
    [anon_sym___END__] = ACTIONS(151),
    [anon_sym_EOT] = ACTIONS(151),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [aux_sym__bareword_token1] = ACTIONS(255),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(157),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(157),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(257),
  },
  [9] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__term_rightward] = STATE(1122),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1276),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(370),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(9),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(255),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_SEMI] = ACTIONS(159),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(159),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(159),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(159),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(159),
    [anon_sym_my] = ACTIONS(225),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(225),
    [anon_sym_our] = ACTIONS(225),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(159),
    [anon_sym_and] = ACTIONS(159),
    [anon_sym_or] = ACTIONS(159),
    [anon_sym_xor] = ACTIONS(159),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(159),
    [anon_sym_PERCENT] = ACTIONS(159),
    [anon_sym_LT] = ACTIONS(161),
    [anon_sym_GT] = ACTIONS(159),
    [anon_sym_LT_LT] = ACTIONS(164),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(159),
    [anon_sym_PLUS_EQ] = ACTIONS(159),
    [anon_sym_DASH_EQ] = ACTIONS(159),
    [anon_sym_DOT_EQ] = ACTIONS(159),
    [anon_sym_STAR_EQ] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(159),
    [anon_sym_PERCENT_EQ] = ACTIONS(159),
    [anon_sym_x_EQ] = ACTIONS(159),
    [anon_sym_AMP_EQ] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(159),
    [anon_sym_CARET_EQ] = ACTIONS(159),
    [anon_sym_LT_LT_EQ] = ACTIONS(159),
    [anon_sym_GT_GT_EQ] = ACTIONS(159),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(159),
    [anon_sym_DOT_DOT] = ACTIONS(159),
    [anon_sym_STAR_STAR] = ACTIONS(159),
    [anon_sym_PIPE_PIPE] = ACTIONS(159),
    [anon_sym_SLASH_SLASH] = ACTIONS(167),
    [anon_sym_CARET_CARET] = ACTIONS(159),
    [anon_sym_AMP_AMP] = ACTIONS(159),
    [anon_sym_PIPE] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(159),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_GT_GT2] = ACTIONS(159),
    [anon_sym_PLUS] = ACTIONS(259),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_DOT] = ACTIONS(159),
    [anon_sym_STAR] = ACTIONS(176),
    [anon_sym_SLASH] = ACTIONS(159),
    [anon_sym_x] = ACTIONS(159),
    [anon_sym_EQ_TILDE] = ACTIONS(159),
    [anon_sym_BANG_TILDE] = ACTIONS(159),
    [anon_sym_EQ_EQ] = ACTIONS(159),
    [anon_sym_BANG_EQ] = ACTIONS(159),
    [anon_sym_eq] = ACTIONS(159),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(159),
    [anon_sym_equ] = ACTIONS(159),
    [anon_sym_eqr] = ACTIONS(159),
    [anon_sym_ne] = ACTIONS(159),
    [anon_sym_LT_EQ_GT] = ACTIONS(159),
    [anon_sym_cmp] = ACTIONS(159),
    [anon_sym_TILDE_TILDE] = ACTIONS(159),
    [anon_sym_LT_EQ] = ACTIONS(159),
    [anon_sym_GT_EQ] = ACTIONS(159),
    [anon_sym_lt] = ACTIONS(159),
    [anon_sym_le] = ACTIONS(159),
    [anon_sym_ge] = ACTIONS(159),
    [anon_sym_gt] = ACTIONS(159),
    [anon_sym_isa] = ACTIONS(159),
    [anon_sym_TILDE] = ACTIONS(227),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_PLUS_PLUS] = ACTIONS(265),
    [anon_sym_DASH_DASH] = ACTIONS(265),
    [anon_sym_QMARK] = ACTIONS(159),
    [anon_sym_BSLASH] = ACTIONS(229),
    [anon_sym_do] = ACTIONS(231),
    [anon_sym_eval] = ACTIONS(233),
    [anon_sym_await] = ACTIONS(235),
    [anon_sym_field] = ACTIONS(225),
    [anon_sym_local] = ACTIONS(237),
    [anon_sym_dynamically] = ACTIONS(237),
    [anon_sym_require] = ACTIONS(239),
    [anon_sym_map] = ACTIONS(241),
    [anon_sym_grep] = ACTIONS(241),
    [anon_sym_sort] = ACTIONS(243),
    [anon_sym_goto] = ACTIONS(245),
    [anon_sym_return] = ACTIONS(247),
    [anon_sym_undef] = ACTIONS(249),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(159),
    [anon_sym_last] = ACTIONS(251),
    [anon_sym_next] = ACTIONS(251),
    [anon_sym_redo] = ACTIONS(251),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(253),
    [anon_sym_alarm] = ACTIONS(253),
    [anon_sym_chop] = ACTIONS(253),
    [anon_sym_chdir] = ACTIONS(253),
    [anon_sym_close] = ACTIONS(253),
    [anon_sym_closedir] = ACTIONS(253),
    [anon_sym_caller] = ACTIONS(253),
    [anon_sym_chomp] = ACTIONS(253),
    [anon_sym_chr] = ACTIONS(253),
    [anon_sym_cos] = ACTIONS(253),
    [anon_sym_chroot] = ACTIONS(253),
    [anon_sym_defined] = ACTIONS(253),
    [anon_sym_delete] = ACTIONS(253),
    [anon_sym_dbmclose] = ACTIONS(253),
    [anon_sym_exists] = ACTIONS(253),
    [anon_sym_exit] = ACTIONS(253),
    [anon_sym_eof] = ACTIONS(253),
    [anon_sym_exp] = ACTIONS(253),
    [anon_sym_each] = ACTIONS(253),
    [anon_sym_fc] = ACTIONS(253),
    [anon_sym_fileno] = ACTIONS(253),
    [anon_sym_gmtime] = ACTIONS(253),
    [anon_sym_getc] = ACTIONS(253),
    [anon_sym_getpgrp] = ACTIONS(253),
    [anon_sym_getprotobyname] = ACTIONS(253),
    [anon_sym_getpwname] = ACTIONS(253),
    [anon_sym_getpwuid] = ACTIONS(253),
    [anon_sym_getpeername] = ACTIONS(253),
    [anon_sym_getnetbyname] = ACTIONS(253),
    [anon_sym_getsockname] = ACTIONS(253),
    [anon_sym_getgrnam] = ACTIONS(253),
    [anon_sym_getgrgid] = ACTIONS(253),
    [anon_sym_hex] = ACTIONS(253),
    [anon_sym_int] = ACTIONS(253),
    [anon_sym_keys] = ACTIONS(253),
    [anon_sym_lc] = ACTIONS(253),
    [anon_sym_lcfirst] = ACTIONS(253),
    [anon_sym_length] = ACTIONS(253),
    [anon_sym_localtime] = ACTIONS(253),
    [anon_sym_log] = ACTIONS(253),
    [anon_sym_lock] = ACTIONS(253),
    [anon_sym_lstat] = ACTIONS(253),
    [anon_sym_oct] = ACTIONS(253),
    [anon_sym_ord] = ACTIONS(253),
    [anon_sym_prototype] = ACTIONS(253),
    [anon_sym_pop] = ACTIONS(253),
    [anon_sym_pos] = ACTIONS(253),
    [anon_sym_quotemeta] = ACTIONS(253),
    [anon_sym_reset] = ACTIONS(253),
    [anon_sym_rand] = ACTIONS(253),
    [anon_sym_rmdir] = ACTIONS(253),
    [anon_sym_readdir] = ACTIONS(253),
    [anon_sym_readline] = ACTIONS(253),
    [anon_sym_readpipe] = ACTIONS(253),
    [anon_sym_rewinddir] = ACTIONS(253),
    [anon_sym_readlink] = ACTIONS(253),
    [anon_sym_ref] = ACTIONS(253),
    [anon_sym_scalar] = ACTIONS(253),
    [anon_sym_shift] = ACTIONS(253),
    [anon_sym_sin] = ACTIONS(253),
    [anon_sym_sleep] = ACTIONS(253),
    [anon_sym_sqrt] = ACTIONS(253),
    [anon_sym_srand] = ACTIONS(253),
    [anon_sym_stat] = ACTIONS(253),
    [anon_sym_study] = ACTIONS(253),
    [anon_sym_tell] = ACTIONS(253),
    [anon_sym_telldir] = ACTIONS(253),
    [anon_sym_tied] = ACTIONS(253),
    [anon_sym_uc] = ACTIONS(253),
    [anon_sym_ucfirst] = ACTIONS(253),
    [anon_sym_untie] = ACTIONS(253),
    [anon_sym_umask] = ACTIONS(253),
    [anon_sym_values] = ACTIONS(253),
    [anon_sym_write] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(159),
    [anon_sym___END__] = ACTIONS(159),
    [anon_sym_EOT] = ACTIONS(159),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [aux_sym__bareword_token1] = ACTIONS(255),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(182),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(182),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(257),
  },
  [10] = {
    [sym__PERLY_BRACE_OPEN] = STATE(204),
    [sym__subscripted] = STATE(1281),
    [sym_container_variable] = STATE(3442),
    [sym_array_element_expression] = STATE(1282),
    [sym_hash_element_expression] = STATE(1282),
    [sym_coderef_call_expression] = STATE(1282),
    [sym_anonymous_slice_expression] = STATE(1282),
    [sym_slice_container_variable] = STATE(3443),
    [sym_slice_expression] = STATE(1504),
    [sym_keyval_container_variable] = STATE(3444),
    [sym_keyval_expression] = STATE(1504),
    [sym__term] = STATE(1455),
    [sym_readline_expression] = STATE(1504),
    [sym_assignment_expression] = STATE(1504),
    [sym_binary_expression] = STATE(1504),
    [sym_equality_expression] = STATE(1504),
    [sym_relational_expression] = STATE(1504),
    [sym_unary_expression] = STATE(1504),
    [sym_preinc_expression] = STATE(1504),
    [sym_postinc_expression] = STATE(1504),
    [sym_conditional_expression] = STATE(1504),
    [sym_refgen_expression] = STATE(1504),
    [sym_anonymous_array_expression] = STATE(1504),
    [sym_anonymous_hash_expression] = STATE(1504),
    [sym_anonymous_subroutine_expression] = STATE(1504),
    [sym_anonymous_method_expression] = STATE(1504),
    [sym_do_expression] = STATE(1504),
    [sym_eval_expression] = STATE(1504),
    [sym_await_expression] = STATE(1504),
    [sym_variable_declaration] = STATE(1504),
    [sym_localization_expression] = STATE(1504),
    [sym_stub_expression] = STATE(1504),
    [sym_scalar_deref_expression] = STATE(1504),
    [sym_array_deref_expression] = STATE(1504),
    [sym_hash_deref_expression] = STATE(1504),
    [sym_amper_deref_expression] = STATE(1504),
    [sym_glob_deref_expression] = STATE(1504),
    [sym_require_expression] = STATE(1504),
    [sym_func0op_call_expression] = STATE(1504),
    [sym_func1op_call_expression] = STATE(1504),
    [sym_map_grep_expression] = STATE(1504),
    [sym_sort_expression] = STATE(1504),
    [sym__label_arg] = STATE(1420),
    [sym_loopex_expression] = STATE(1504),
    [sym_goto_expression] = STATE(1504),
    [sym_return_expression] = STATE(1504),
    [sym_undef_expression] = STATE(1504),
    [sym__listop] = STATE(1504),
    [sym_function_call_expression] = STATE(1509),
    [sym_ambiguous_function_call_expression] = STATE(1509),
    [sym_function] = STATE(374),
    [sym_method_call_expression] = STATE(1509),
    [sym_scalar] = STATE(1504),
    [sym_array] = STATE(1504),
    [sym_hash] = STATE(1504),
    [sym_arraylen] = STATE(1504),
    [sym_glob] = STATE(1504),
    [sym__literal] = STATE(1504),
    [sym__apostrophe] = STATE(2855),
    [sym__quotation_mark] = STATE(2248),
    [sym__backtick] = STATE(2249),
    [sym__search_slash] = STATE(2226),
    [sym_string_literal] = STATE(1511),
    [sym_interpolated_string_literal] = STATE(1511),
    [sym_quoted_word_list] = STATE(1378),
    [sym_command_string] = STATE(1511),
    [sym_quoted_regexp] = STATE(1511),
    [sym_match_regexp] = STATE(1511),
    [sym_substitution_regexp] = STATE(1511),
    [sym_transliteration_expression] = STATE(1511),
    [sym_heredoc_token] = STATE(1504),
    [sym_command_heredoc_token] = STATE(1504),
    [sym_heredoc_content] = STATE(10),
    [sym_autoquoted_bareword] = STATE(1504),
    [sym_identifier] = STATE(1489),
    [sym_bareword] = STATE(1504),
    [sym_primitive] = STATE(1504),
    [sym_boolean] = STATE(1494),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3013),
    [sym__identifier] = ACTIONS(268),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(151),
    [anon_sym_SEMI] = ACTIONS(151),
    [anon_sym_DOLLAR] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(151),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(151),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(151),
    [anon_sym_RPAREN] = ACTIONS(151),
    [anon_sym_my] = ACTIONS(274),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(276),
    [anon_sym_method] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_continue] = ACTIONS(282),
    [anon_sym_state] = ACTIONS(274),
    [anon_sym_our] = ACTIONS(274),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(151),
    [anon_sym_and] = ACTIONS(151),
    [anon_sym_or] = ACTIONS(151),
    [anon_sym_xor] = ACTIONS(151),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_RBRACK] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(151),
    [anon_sym_PERCENT] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(151),
    [anon_sym_LT_LT] = ACTIONS(151),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(151),
    [anon_sym_PLUS_EQ] = ACTIONS(151),
    [anon_sym_DASH_EQ] = ACTIONS(151),
    [anon_sym_DOT_EQ] = ACTIONS(151),
    [anon_sym_STAR_EQ] = ACTIONS(151),
    [anon_sym_SLASH_EQ] = ACTIONS(151),
    [anon_sym_PERCENT_EQ] = ACTIONS(151),
    [anon_sym_x_EQ] = ACTIONS(151),
    [anon_sym_AMP_EQ] = ACTIONS(151),
    [anon_sym_PIPE_EQ] = ACTIONS(151),
    [anon_sym_CARET_EQ] = ACTIONS(151),
    [anon_sym_LT_LT_EQ] = ACTIONS(151),
    [anon_sym_GT_GT_EQ] = ACTIONS(151),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(151),
    [anon_sym_DOT_DOT] = ACTIONS(151),
    [anon_sym_STAR_STAR] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(151),
    [anon_sym_SLASH_SLASH] = ACTIONS(151),
    [anon_sym_CARET_CARET] = ACTIONS(151),
    [anon_sym_AMP_AMP] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(151),
    [anon_sym_CARET] = ACTIONS(151),
    [anon_sym_AMP] = ACTIONS(151),
    [anon_sym_GT_GT2] = ACTIONS(151),
    [anon_sym_PLUS] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(151),
    [anon_sym_DOT] = ACTIONS(151),
    [anon_sym_STAR] = ACTIONS(151),
    [anon_sym_SLASH] = ACTIONS(151),
    [anon_sym_x] = ACTIONS(151),
    [anon_sym_EQ_TILDE] = ACTIONS(151),
    [anon_sym_BANG_TILDE] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(151),
    [anon_sym_eq] = ACTIONS(151),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_equ] = ACTIONS(151),
    [anon_sym_eqr] = ACTIONS(151),
    [anon_sym_ne] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(151),
    [anon_sym_cmp] = ACTIONS(151),
    [anon_sym_TILDE_TILDE] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_lt] = ACTIONS(151),
    [anon_sym_le] = ACTIONS(151),
    [anon_sym_ge] = ACTIONS(151),
    [anon_sym_gt] = ACTIONS(151),
    [anon_sym_isa] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(286),
    [anon_sym_BANG] = ACTIONS(286),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_QMARK] = ACTIONS(151),
    [anon_sym_BSLASH] = ACTIONS(288),
    [anon_sym_do] = ACTIONS(290),
    [anon_sym_eval] = ACTIONS(292),
    [anon_sym_await] = ACTIONS(294),
    [anon_sym_field] = ACTIONS(274),
    [anon_sym_local] = ACTIONS(296),
    [anon_sym_dynamically] = ACTIONS(296),
    [anon_sym_require] = ACTIONS(298),
    [anon_sym_map] = ACTIONS(300),
    [anon_sym_grep] = ACTIONS(300),
    [anon_sym_sort] = ACTIONS(302),
    [anon_sym_goto] = ACTIONS(304),
    [anon_sym_return] = ACTIONS(306),
    [anon_sym_undef] = ACTIONS(308),
    [anon_sym_PERCENT2] = ACTIONS(310),
    [anon_sym_DOLLAR_POUND] = ACTIONS(312),
    [anon_sym_EQ_GT] = ACTIONS(151),
    [anon_sym_last] = ACTIONS(314),
    [anon_sym_next] = ACTIONS(314),
    [anon_sym_redo] = ACTIONS(314),
    [anon_sym___FILE__] = ACTIONS(282),
    [anon_sym___LINE__] = ACTIONS(282),
    [anon_sym___PACKAGE__] = ACTIONS(282),
    [anon_sym___SUB__] = ACTIONS(282),
    [anon_sym_break] = ACTIONS(282),
    [anon_sym_fork] = ACTIONS(282),
    [anon_sym_getppid] = ACTIONS(282),
    [anon_sym_time] = ACTIONS(282),
    [anon_sym_times] = ACTIONS(282),
    [anon_sym_wait] = ACTIONS(282),
    [anon_sym_wantarray] = ACTIONS(282),
    [anon_sym_abs] = ACTIONS(316),
    [anon_sym_alarm] = ACTIONS(316),
    [anon_sym_chop] = ACTIONS(316),
    [anon_sym_chdir] = ACTIONS(316),
    [anon_sym_close] = ACTIONS(316),
    [anon_sym_closedir] = ACTIONS(316),
    [anon_sym_caller] = ACTIONS(316),
    [anon_sym_chomp] = ACTIONS(316),
    [anon_sym_chr] = ACTIONS(316),
    [anon_sym_cos] = ACTIONS(316),
    [anon_sym_chroot] = ACTIONS(316),
    [anon_sym_defined] = ACTIONS(316),
    [anon_sym_delete] = ACTIONS(316),
    [anon_sym_dbmclose] = ACTIONS(316),
    [anon_sym_exists] = ACTIONS(316),
    [anon_sym_exit] = ACTIONS(316),
    [anon_sym_eof] = ACTIONS(316),
    [anon_sym_exp] = ACTIONS(316),
    [anon_sym_each] = ACTIONS(316),
    [anon_sym_fc] = ACTIONS(316),
    [anon_sym_fileno] = ACTIONS(316),
    [anon_sym_gmtime] = ACTIONS(316),
    [anon_sym_getc] = ACTIONS(316),
    [anon_sym_getpgrp] = ACTIONS(316),
    [anon_sym_getprotobyname] = ACTIONS(316),
    [anon_sym_getpwname] = ACTIONS(316),
    [anon_sym_getpwuid] = ACTIONS(316),
    [anon_sym_getpeername] = ACTIONS(316),
    [anon_sym_getnetbyname] = ACTIONS(316),
    [anon_sym_getsockname] = ACTIONS(316),
    [anon_sym_getgrnam] = ACTIONS(316),
    [anon_sym_getgrgid] = ACTIONS(316),
    [anon_sym_hex] = ACTIONS(316),
    [anon_sym_int] = ACTIONS(316),
    [anon_sym_keys] = ACTIONS(316),
    [anon_sym_lc] = ACTIONS(316),
    [anon_sym_lcfirst] = ACTIONS(316),
    [anon_sym_length] = ACTIONS(316),
    [anon_sym_localtime] = ACTIONS(316),
    [anon_sym_log] = ACTIONS(316),
    [anon_sym_lock] = ACTIONS(316),
    [anon_sym_lstat] = ACTIONS(316),
    [anon_sym_oct] = ACTIONS(316),
    [anon_sym_ord] = ACTIONS(316),
    [anon_sym_prototype] = ACTIONS(316),
    [anon_sym_pop] = ACTIONS(316),
    [anon_sym_pos] = ACTIONS(316),
    [anon_sym_quotemeta] = ACTIONS(316),
    [anon_sym_reset] = ACTIONS(316),
    [anon_sym_rand] = ACTIONS(316),
    [anon_sym_rmdir] = ACTIONS(316),
    [anon_sym_readdir] = ACTIONS(316),
    [anon_sym_readline] = ACTIONS(316),
    [anon_sym_readpipe] = ACTIONS(316),
    [anon_sym_rewinddir] = ACTIONS(316),
    [anon_sym_readlink] = ACTIONS(316),
    [anon_sym_ref] = ACTIONS(316),
    [anon_sym_scalar] = ACTIONS(316),
    [anon_sym_shift] = ACTIONS(316),
    [anon_sym_sin] = ACTIONS(316),
    [anon_sym_sleep] = ACTIONS(316),
    [anon_sym_sqrt] = ACTIONS(316),
    [anon_sym_srand] = ACTIONS(316),
    [anon_sym_stat] = ACTIONS(316),
    [anon_sym_study] = ACTIONS(316),
    [anon_sym_tell] = ACTIONS(316),
    [anon_sym_telldir] = ACTIONS(316),
    [anon_sym_tied] = ACTIONS(316),
    [anon_sym_uc] = ACTIONS(316),
    [anon_sym_ucfirst] = ACTIONS(316),
    [anon_sym_untie] = ACTIONS(316),
    [anon_sym_umask] = ACTIONS(316),
    [anon_sym_values] = ACTIONS(316),
    [anon_sym_write] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(318),
    [anon_sym_qq] = ACTIONS(320),
    [anon_sym_qw] = ACTIONS(322),
    [anon_sym_qx] = ACTIONS(324),
    [anon_sym_qr] = ACTIONS(326),
    [anon_sym_m] = ACTIONS(328),
    [anon_sym_s] = ACTIONS(330),
    [anon_sym_tr] = ACTIONS(332),
    [anon_sym_y] = ACTIONS(332),
    [aux_sym__bareword_token1] = ACTIONS(334),
    [sym_number] = ACTIONS(336),
    [anon_sym_true] = ACTIONS(338),
    [anon_sym_false] = ACTIONS(338),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(340),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(342),
    [sym__filetest] = ACTIONS(344),
  },
  [11] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1294),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(370),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(11),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(255),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_SEMI] = ACTIONS(217),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(217),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(217),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(217),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(217),
    [anon_sym_my] = ACTIONS(225),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(219),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(225),
    [anon_sym_our] = ACTIONS(225),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(217),
    [anon_sym_and] = ACTIONS(217),
    [anon_sym_or] = ACTIONS(217),
    [anon_sym_xor] = ACTIONS(217),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(217),
    [anon_sym_PERCENT] = ACTIONS(217),
    [anon_sym_LT] = ACTIONS(217),
    [anon_sym_GT] = ACTIONS(217),
    [anon_sym_LT_LT] = ACTIONS(217),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(217),
    [anon_sym_PLUS_EQ] = ACTIONS(217),
    [anon_sym_DASH_EQ] = ACTIONS(217),
    [anon_sym_DOT_EQ] = ACTIONS(217),
    [anon_sym_STAR_EQ] = ACTIONS(217),
    [anon_sym_SLASH_EQ] = ACTIONS(217),
    [anon_sym_PERCENT_EQ] = ACTIONS(217),
    [anon_sym_x_EQ] = ACTIONS(217),
    [anon_sym_AMP_EQ] = ACTIONS(217),
    [anon_sym_PIPE_EQ] = ACTIONS(217),
    [anon_sym_CARET_EQ] = ACTIONS(217),
    [anon_sym_LT_LT_EQ] = ACTIONS(217),
    [anon_sym_GT_GT_EQ] = ACTIONS(217),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(217),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_STAR_STAR] = ACTIONS(217),
    [anon_sym_PIPE_PIPE] = ACTIONS(217),
    [anon_sym_SLASH_SLASH] = ACTIONS(217),
    [anon_sym_CARET_CARET] = ACTIONS(217),
    [anon_sym_AMP_AMP] = ACTIONS(217),
    [anon_sym_PIPE] = ACTIONS(217),
    [anon_sym_CARET] = ACTIONS(217),
    [anon_sym_AMP] = ACTIONS(217),
    [anon_sym_GT_GT2] = ACTIONS(217),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(217),
    [anon_sym_STAR] = ACTIONS(217),
    [anon_sym_SLASH] = ACTIONS(217),
    [anon_sym_x] = ACTIONS(217),
    [anon_sym_EQ_TILDE] = ACTIONS(217),
    [anon_sym_BANG_TILDE] = ACTIONS(217),
    [anon_sym_EQ_EQ] = ACTIONS(217),
    [anon_sym_BANG_EQ] = ACTIONS(217),
    [anon_sym_eq] = ACTIONS(217),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(217),
    [anon_sym_equ] = ACTIONS(217),
    [anon_sym_eqr] = ACTIONS(217),
    [anon_sym_ne] = ACTIONS(217),
    [anon_sym_LT_EQ_GT] = ACTIONS(217),
    [anon_sym_cmp] = ACTIONS(217),
    [anon_sym_TILDE_TILDE] = ACTIONS(217),
    [anon_sym_LT_EQ] = ACTIONS(217),
    [anon_sym_GT_EQ] = ACTIONS(217),
    [anon_sym_lt] = ACTIONS(217),
    [anon_sym_le] = ACTIONS(217),
    [anon_sym_ge] = ACTIONS(217),
    [anon_sym_gt] = ACTIONS(217),
    [anon_sym_isa] = ACTIONS(217),
    [anon_sym_TILDE] = ACTIONS(227),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_QMARK] = ACTIONS(217),
    [anon_sym_BSLASH] = ACTIONS(229),
    [anon_sym_do] = ACTIONS(231),
    [anon_sym_eval] = ACTIONS(233),
    [anon_sym_await] = ACTIONS(235),
    [anon_sym_field] = ACTIONS(225),
    [anon_sym_local] = ACTIONS(237),
    [anon_sym_dynamically] = ACTIONS(237),
    [anon_sym_require] = ACTIONS(239),
    [anon_sym_map] = ACTIONS(241),
    [anon_sym_grep] = ACTIONS(241),
    [anon_sym_sort] = ACTIONS(243),
    [anon_sym_goto] = ACTIONS(245),
    [anon_sym_return] = ACTIONS(247),
    [anon_sym_undef] = ACTIONS(249),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(217),
    [anon_sym_last] = ACTIONS(251),
    [anon_sym_next] = ACTIONS(251),
    [anon_sym_redo] = ACTIONS(251),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(253),
    [anon_sym_alarm] = ACTIONS(253),
    [anon_sym_chop] = ACTIONS(253),
    [anon_sym_chdir] = ACTIONS(253),
    [anon_sym_close] = ACTIONS(253),
    [anon_sym_closedir] = ACTIONS(253),
    [anon_sym_caller] = ACTIONS(253),
    [anon_sym_chomp] = ACTIONS(253),
    [anon_sym_chr] = ACTIONS(253),
    [anon_sym_cos] = ACTIONS(253),
    [anon_sym_chroot] = ACTIONS(253),
    [anon_sym_defined] = ACTIONS(253),
    [anon_sym_delete] = ACTIONS(253),
    [anon_sym_dbmclose] = ACTIONS(253),
    [anon_sym_exists] = ACTIONS(253),
    [anon_sym_exit] = ACTIONS(253),
    [anon_sym_eof] = ACTIONS(253),
    [anon_sym_exp] = ACTIONS(253),
    [anon_sym_each] = ACTIONS(253),
    [anon_sym_fc] = ACTIONS(253),
    [anon_sym_fileno] = ACTIONS(253),
    [anon_sym_gmtime] = ACTIONS(253),
    [anon_sym_getc] = ACTIONS(253),
    [anon_sym_getpgrp] = ACTIONS(253),
    [anon_sym_getprotobyname] = ACTIONS(253),
    [anon_sym_getpwname] = ACTIONS(253),
    [anon_sym_getpwuid] = ACTIONS(253),
    [anon_sym_getpeername] = ACTIONS(253),
    [anon_sym_getnetbyname] = ACTIONS(253),
    [anon_sym_getsockname] = ACTIONS(253),
    [anon_sym_getgrnam] = ACTIONS(253),
    [anon_sym_getgrgid] = ACTIONS(253),
    [anon_sym_hex] = ACTIONS(253),
    [anon_sym_int] = ACTIONS(253),
    [anon_sym_keys] = ACTIONS(253),
    [anon_sym_lc] = ACTIONS(253),
    [anon_sym_lcfirst] = ACTIONS(253),
    [anon_sym_length] = ACTIONS(253),
    [anon_sym_localtime] = ACTIONS(253),
    [anon_sym_log] = ACTIONS(253),
    [anon_sym_lock] = ACTIONS(253),
    [anon_sym_lstat] = ACTIONS(253),
    [anon_sym_oct] = ACTIONS(253),
    [anon_sym_ord] = ACTIONS(253),
    [anon_sym_prototype] = ACTIONS(253),
    [anon_sym_pop] = ACTIONS(253),
    [anon_sym_pos] = ACTIONS(253),
    [anon_sym_quotemeta] = ACTIONS(253),
    [anon_sym_reset] = ACTIONS(253),
    [anon_sym_rand] = ACTIONS(253),
    [anon_sym_rmdir] = ACTIONS(253),
    [anon_sym_readdir] = ACTIONS(253),
    [anon_sym_readline] = ACTIONS(253),
    [anon_sym_readpipe] = ACTIONS(253),
    [anon_sym_rewinddir] = ACTIONS(253),
    [anon_sym_readlink] = ACTIONS(253),
    [anon_sym_ref] = ACTIONS(253),
    [anon_sym_scalar] = ACTIONS(253),
    [anon_sym_shift] = ACTIONS(253),
    [anon_sym_sin] = ACTIONS(253),
    [anon_sym_sleep] = ACTIONS(253),
    [anon_sym_sqrt] = ACTIONS(253),
    [anon_sym_srand] = ACTIONS(253),
    [anon_sym_stat] = ACTIONS(253),
    [anon_sym_study] = ACTIONS(253),
    [anon_sym_tell] = ACTIONS(253),
    [anon_sym_telldir] = ACTIONS(253),
    [anon_sym_tied] = ACTIONS(253),
    [anon_sym_uc] = ACTIONS(253),
    [anon_sym_ucfirst] = ACTIONS(253),
    [anon_sym_untie] = ACTIONS(253),
    [anon_sym_umask] = ACTIONS(253),
    [anon_sym_values] = ACTIONS(253),
    [anon_sym_write] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(217),
    [anon_sym___END__] = ACTIONS(217),
    [anon_sym_EOT] = ACTIONS(217),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [aux_sym__bareword_token1] = ACTIONS(255),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(221),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(221),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(257),
  },
  [12] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1303),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(370),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(12),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(255),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_SEMI] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(213),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(213),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(213),
    [anon_sym_my] = ACTIONS(225),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(225),
    [anon_sym_our] = ACTIONS(225),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(213),
    [anon_sym_and] = ACTIONS(213),
    [anon_sym_or] = ACTIONS(213),
    [anon_sym_xor] = ACTIONS(213),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(213),
    [anon_sym_PERCENT] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(213),
    [anon_sym_GT] = ACTIONS(213),
    [anon_sym_LT_LT] = ACTIONS(213),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(213),
    [anon_sym_PLUS_EQ] = ACTIONS(213),
    [anon_sym_DASH_EQ] = ACTIONS(213),
    [anon_sym_DOT_EQ] = ACTIONS(213),
    [anon_sym_STAR_EQ] = ACTIONS(213),
    [anon_sym_SLASH_EQ] = ACTIONS(213),
    [anon_sym_PERCENT_EQ] = ACTIONS(213),
    [anon_sym_x_EQ] = ACTIONS(213),
    [anon_sym_AMP_EQ] = ACTIONS(213),
    [anon_sym_PIPE_EQ] = ACTIONS(213),
    [anon_sym_CARET_EQ] = ACTIONS(213),
    [anon_sym_LT_LT_EQ] = ACTIONS(213),
    [anon_sym_GT_GT_EQ] = ACTIONS(213),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(213),
    [anon_sym_STAR_STAR] = ACTIONS(213),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_SLASH_SLASH] = ACTIONS(213),
    [anon_sym_CARET_CARET] = ACTIONS(213),
    [anon_sym_AMP_AMP] = ACTIONS(213),
    [anon_sym_PIPE] = ACTIONS(213),
    [anon_sym_CARET] = ACTIONS(213),
    [anon_sym_AMP] = ACTIONS(213),
    [anon_sym_GT_GT2] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(213),
    [anon_sym_DASH] = ACTIONS(213),
    [anon_sym_DOT] = ACTIONS(213),
    [anon_sym_STAR] = ACTIONS(213),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_x] = ACTIONS(213),
    [anon_sym_EQ_TILDE] = ACTIONS(213),
    [anon_sym_BANG_TILDE] = ACTIONS(213),
    [anon_sym_EQ_EQ] = ACTIONS(213),
    [anon_sym_BANG_EQ] = ACTIONS(213),
    [anon_sym_eq] = ACTIONS(213),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(213),
    [anon_sym_equ] = ACTIONS(213),
    [anon_sym_eqr] = ACTIONS(213),
    [anon_sym_ne] = ACTIONS(213),
    [anon_sym_LT_EQ_GT] = ACTIONS(213),
    [anon_sym_cmp] = ACTIONS(213),
    [anon_sym_TILDE_TILDE] = ACTIONS(213),
    [anon_sym_LT_EQ] = ACTIONS(213),
    [anon_sym_GT_EQ] = ACTIONS(213),
    [anon_sym_lt] = ACTIONS(213),
    [anon_sym_le] = ACTIONS(213),
    [anon_sym_ge] = ACTIONS(213),
    [anon_sym_gt] = ACTIONS(213),
    [anon_sym_isa] = ACTIONS(213),
    [anon_sym_TILDE] = ACTIONS(227),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_PLUS_PLUS] = ACTIONS(213),
    [anon_sym_DASH_DASH] = ACTIONS(213),
    [anon_sym_QMARK] = ACTIONS(213),
    [anon_sym_BSLASH] = ACTIONS(229),
    [anon_sym_do] = ACTIONS(231),
    [anon_sym_eval] = ACTIONS(233),
    [anon_sym_await] = ACTIONS(235),
    [anon_sym_field] = ACTIONS(225),
    [anon_sym_local] = ACTIONS(237),
    [anon_sym_dynamically] = ACTIONS(237),
    [anon_sym_require] = ACTIONS(239),
    [anon_sym_map] = ACTIONS(241),
    [anon_sym_grep] = ACTIONS(241),
    [anon_sym_sort] = ACTIONS(243),
    [anon_sym_goto] = ACTIONS(245),
    [anon_sym_return] = ACTIONS(247),
    [anon_sym_undef] = ACTIONS(249),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(213),
    [anon_sym_last] = ACTIONS(251),
    [anon_sym_next] = ACTIONS(251),
    [anon_sym_redo] = ACTIONS(251),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(253),
    [anon_sym_alarm] = ACTIONS(253),
    [anon_sym_chop] = ACTIONS(253),
    [anon_sym_chdir] = ACTIONS(253),
    [anon_sym_close] = ACTIONS(253),
    [anon_sym_closedir] = ACTIONS(253),
    [anon_sym_caller] = ACTIONS(253),
    [anon_sym_chomp] = ACTIONS(253),
    [anon_sym_chr] = ACTIONS(253),
    [anon_sym_cos] = ACTIONS(253),
    [anon_sym_chroot] = ACTIONS(253),
    [anon_sym_defined] = ACTIONS(253),
    [anon_sym_delete] = ACTIONS(253),
    [anon_sym_dbmclose] = ACTIONS(253),
    [anon_sym_exists] = ACTIONS(253),
    [anon_sym_exit] = ACTIONS(253),
    [anon_sym_eof] = ACTIONS(253),
    [anon_sym_exp] = ACTIONS(253),
    [anon_sym_each] = ACTIONS(253),
    [anon_sym_fc] = ACTIONS(253),
    [anon_sym_fileno] = ACTIONS(253),
    [anon_sym_gmtime] = ACTIONS(253),
    [anon_sym_getc] = ACTIONS(253),
    [anon_sym_getpgrp] = ACTIONS(253),
    [anon_sym_getprotobyname] = ACTIONS(253),
    [anon_sym_getpwname] = ACTIONS(253),
    [anon_sym_getpwuid] = ACTIONS(253),
    [anon_sym_getpeername] = ACTIONS(253),
    [anon_sym_getnetbyname] = ACTIONS(253),
    [anon_sym_getsockname] = ACTIONS(253),
    [anon_sym_getgrnam] = ACTIONS(253),
    [anon_sym_getgrgid] = ACTIONS(253),
    [anon_sym_hex] = ACTIONS(253),
    [anon_sym_int] = ACTIONS(253),
    [anon_sym_keys] = ACTIONS(253),
    [anon_sym_lc] = ACTIONS(253),
    [anon_sym_lcfirst] = ACTIONS(253),
    [anon_sym_length] = ACTIONS(253),
    [anon_sym_localtime] = ACTIONS(253),
    [anon_sym_log] = ACTIONS(253),
    [anon_sym_lock] = ACTIONS(253),
    [anon_sym_lstat] = ACTIONS(253),
    [anon_sym_oct] = ACTIONS(253),
    [anon_sym_ord] = ACTIONS(253),
    [anon_sym_prototype] = ACTIONS(253),
    [anon_sym_pop] = ACTIONS(253),
    [anon_sym_pos] = ACTIONS(253),
    [anon_sym_quotemeta] = ACTIONS(253),
    [anon_sym_reset] = ACTIONS(253),
    [anon_sym_rand] = ACTIONS(253),
    [anon_sym_rmdir] = ACTIONS(253),
    [anon_sym_readdir] = ACTIONS(253),
    [anon_sym_readline] = ACTIONS(253),
    [anon_sym_readpipe] = ACTIONS(253),
    [anon_sym_rewinddir] = ACTIONS(253),
    [anon_sym_readlink] = ACTIONS(253),
    [anon_sym_ref] = ACTIONS(253),
    [anon_sym_scalar] = ACTIONS(253),
    [anon_sym_shift] = ACTIONS(253),
    [anon_sym_sin] = ACTIONS(253),
    [anon_sym_sleep] = ACTIONS(253),
    [anon_sym_sqrt] = ACTIONS(253),
    [anon_sym_srand] = ACTIONS(253),
    [anon_sym_stat] = ACTIONS(253),
    [anon_sym_study] = ACTIONS(253),
    [anon_sym_tell] = ACTIONS(253),
    [anon_sym_telldir] = ACTIONS(253),
    [anon_sym_tied] = ACTIONS(253),
    [anon_sym_uc] = ACTIONS(253),
    [anon_sym_ucfirst] = ACTIONS(253),
    [anon_sym_untie] = ACTIONS(253),
    [anon_sym_umask] = ACTIONS(253),
    [anon_sym_values] = ACTIONS(253),
    [anon_sym_write] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(213),
    [anon_sym___END__] = ACTIONS(213),
    [anon_sym_EOT] = ACTIONS(213),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [aux_sym__bareword_token1] = ACTIONS(255),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(215),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(215),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(257),
  },
  [13] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1306),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(370),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(13),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(255),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_SEMI] = ACTIONS(184),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(184),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(184),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(184),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(184),
    [anon_sym_my] = ACTIONS(225),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(225),
    [anon_sym_our] = ACTIONS(225),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(184),
    [anon_sym_and] = ACTIONS(184),
    [anon_sym_or] = ACTIONS(184),
    [anon_sym_xor] = ACTIONS(184),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(184),
    [anon_sym_PERCENT] = ACTIONS(184),
    [anon_sym_LT] = ACTIONS(184),
    [anon_sym_GT] = ACTIONS(184),
    [anon_sym_LT_LT] = ACTIONS(184),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(184),
    [anon_sym_PLUS_EQ] = ACTIONS(184),
    [anon_sym_DASH_EQ] = ACTIONS(184),
    [anon_sym_DOT_EQ] = ACTIONS(184),
    [anon_sym_STAR_EQ] = ACTIONS(184),
    [anon_sym_SLASH_EQ] = ACTIONS(184),
    [anon_sym_PERCENT_EQ] = ACTIONS(184),
    [anon_sym_x_EQ] = ACTIONS(184),
    [anon_sym_AMP_EQ] = ACTIONS(184),
    [anon_sym_PIPE_EQ] = ACTIONS(184),
    [anon_sym_CARET_EQ] = ACTIONS(184),
    [anon_sym_LT_LT_EQ] = ACTIONS(184),
    [anon_sym_GT_GT_EQ] = ACTIONS(184),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(184),
    [anon_sym_DOT_DOT] = ACTIONS(184),
    [anon_sym_STAR_STAR] = ACTIONS(184),
    [anon_sym_PIPE_PIPE] = ACTIONS(184),
    [anon_sym_SLASH_SLASH] = ACTIONS(184),
    [anon_sym_CARET_CARET] = ACTIONS(184),
    [anon_sym_AMP_AMP] = ACTIONS(184),
    [anon_sym_PIPE] = ACTIONS(184),
    [anon_sym_CARET] = ACTIONS(184),
    [anon_sym_AMP] = ACTIONS(184),
    [anon_sym_GT_GT2] = ACTIONS(184),
    [anon_sym_PLUS] = ACTIONS(184),
    [anon_sym_DASH] = ACTIONS(184),
    [anon_sym_DOT] = ACTIONS(184),
    [anon_sym_STAR] = ACTIONS(184),
    [anon_sym_SLASH] = ACTIONS(184),
    [anon_sym_x] = ACTIONS(184),
    [anon_sym_EQ_TILDE] = ACTIONS(184),
    [anon_sym_BANG_TILDE] = ACTIONS(184),
    [anon_sym_EQ_EQ] = ACTIONS(184),
    [anon_sym_BANG_EQ] = ACTIONS(184),
    [anon_sym_eq] = ACTIONS(184),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(184),
    [anon_sym_equ] = ACTIONS(184),
    [anon_sym_eqr] = ACTIONS(184),
    [anon_sym_ne] = ACTIONS(184),
    [anon_sym_LT_EQ_GT] = ACTIONS(184),
    [anon_sym_cmp] = ACTIONS(184),
    [anon_sym_TILDE_TILDE] = ACTIONS(184),
    [anon_sym_LT_EQ] = ACTIONS(184),
    [anon_sym_GT_EQ] = ACTIONS(184),
    [anon_sym_lt] = ACTIONS(184),
    [anon_sym_le] = ACTIONS(184),
    [anon_sym_ge] = ACTIONS(184),
    [anon_sym_gt] = ACTIONS(184),
    [anon_sym_isa] = ACTIONS(184),
    [anon_sym_TILDE] = ACTIONS(227),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_PLUS_PLUS] = ACTIONS(184),
    [anon_sym_DASH_DASH] = ACTIONS(184),
    [anon_sym_QMARK] = ACTIONS(184),
    [anon_sym_BSLASH] = ACTIONS(229),
    [anon_sym_do] = ACTIONS(231),
    [anon_sym_eval] = ACTIONS(233),
    [anon_sym_await] = ACTIONS(235),
    [anon_sym_field] = ACTIONS(225),
    [anon_sym_local] = ACTIONS(237),
    [anon_sym_dynamically] = ACTIONS(237),
    [anon_sym_require] = ACTIONS(239),
    [anon_sym_map] = ACTIONS(241),
    [anon_sym_grep] = ACTIONS(241),
    [anon_sym_sort] = ACTIONS(243),
    [anon_sym_goto] = ACTIONS(245),
    [anon_sym_return] = ACTIONS(247),
    [anon_sym_undef] = ACTIONS(249),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(184),
    [anon_sym_last] = ACTIONS(251),
    [anon_sym_next] = ACTIONS(251),
    [anon_sym_redo] = ACTIONS(251),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(253),
    [anon_sym_alarm] = ACTIONS(253),
    [anon_sym_chop] = ACTIONS(253),
    [anon_sym_chdir] = ACTIONS(253),
    [anon_sym_close] = ACTIONS(253),
    [anon_sym_closedir] = ACTIONS(253),
    [anon_sym_caller] = ACTIONS(253),
    [anon_sym_chomp] = ACTIONS(253),
    [anon_sym_chr] = ACTIONS(253),
    [anon_sym_cos] = ACTIONS(253),
    [anon_sym_chroot] = ACTIONS(253),
    [anon_sym_defined] = ACTIONS(253),
    [anon_sym_delete] = ACTIONS(253),
    [anon_sym_dbmclose] = ACTIONS(253),
    [anon_sym_exists] = ACTIONS(253),
    [anon_sym_exit] = ACTIONS(253),
    [anon_sym_eof] = ACTIONS(253),
    [anon_sym_exp] = ACTIONS(253),
    [anon_sym_each] = ACTIONS(253),
    [anon_sym_fc] = ACTIONS(253),
    [anon_sym_fileno] = ACTIONS(253),
    [anon_sym_gmtime] = ACTIONS(253),
    [anon_sym_getc] = ACTIONS(253),
    [anon_sym_getpgrp] = ACTIONS(253),
    [anon_sym_getprotobyname] = ACTIONS(253),
    [anon_sym_getpwname] = ACTIONS(253),
    [anon_sym_getpwuid] = ACTIONS(253),
    [anon_sym_getpeername] = ACTIONS(253),
    [anon_sym_getnetbyname] = ACTIONS(253),
    [anon_sym_getsockname] = ACTIONS(253),
    [anon_sym_getgrnam] = ACTIONS(253),
    [anon_sym_getgrgid] = ACTIONS(253),
    [anon_sym_hex] = ACTIONS(253),
    [anon_sym_int] = ACTIONS(253),
    [anon_sym_keys] = ACTIONS(253),
    [anon_sym_lc] = ACTIONS(253),
    [anon_sym_lcfirst] = ACTIONS(253),
    [anon_sym_length] = ACTIONS(253),
    [anon_sym_localtime] = ACTIONS(253),
    [anon_sym_log] = ACTIONS(253),
    [anon_sym_lock] = ACTIONS(253),
    [anon_sym_lstat] = ACTIONS(253),
    [anon_sym_oct] = ACTIONS(253),
    [anon_sym_ord] = ACTIONS(253),
    [anon_sym_prototype] = ACTIONS(253),
    [anon_sym_pop] = ACTIONS(253),
    [anon_sym_pos] = ACTIONS(253),
    [anon_sym_quotemeta] = ACTIONS(253),
    [anon_sym_reset] = ACTIONS(253),
    [anon_sym_rand] = ACTIONS(253),
    [anon_sym_rmdir] = ACTIONS(253),
    [anon_sym_readdir] = ACTIONS(253),
    [anon_sym_readline] = ACTIONS(253),
    [anon_sym_readpipe] = ACTIONS(253),
    [anon_sym_rewinddir] = ACTIONS(253),
    [anon_sym_readlink] = ACTIONS(253),
    [anon_sym_ref] = ACTIONS(253),
    [anon_sym_scalar] = ACTIONS(253),
    [anon_sym_shift] = ACTIONS(253),
    [anon_sym_sin] = ACTIONS(253),
    [anon_sym_sleep] = ACTIONS(253),
    [anon_sym_sqrt] = ACTIONS(253),
    [anon_sym_srand] = ACTIONS(253),
    [anon_sym_stat] = ACTIONS(253),
    [anon_sym_study] = ACTIONS(253),
    [anon_sym_tell] = ACTIONS(253),
    [anon_sym_telldir] = ACTIONS(253),
    [anon_sym_tied] = ACTIONS(253),
    [anon_sym_uc] = ACTIONS(253),
    [anon_sym_ucfirst] = ACTIONS(253),
    [anon_sym_untie] = ACTIONS(253),
    [anon_sym_umask] = ACTIONS(253),
    [anon_sym_values] = ACTIONS(253),
    [anon_sym_write] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(184),
    [anon_sym___END__] = ACTIONS(184),
    [anon_sym_EOT] = ACTIONS(184),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [aux_sym__bareword_token1] = ACTIONS(255),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(186),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(186),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(257),
  },
  [14] = {
    [sym__PERLY_BRACE_OPEN] = STATE(219),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1296),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(370),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(14),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3005),
    [sym__identifier] = ACTIONS(255),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_SEMI] = ACTIONS(188),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_EQ] = ACTIONS(188),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(188),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(188),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(188),
    [anon_sym_my] = ACTIONS(225),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(153),
    [anon_sym_method] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(225),
    [anon_sym_our] = ACTIONS(225),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(188),
    [anon_sym_and] = ACTIONS(188),
    [anon_sym_or] = ACTIONS(188),
    [anon_sym_xor] = ACTIONS(188),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_DASH_GT] = ACTIONS(188),
    [anon_sym_PERCENT] = ACTIONS(188),
    [anon_sym_LT] = ACTIONS(190),
    [anon_sym_GT] = ACTIONS(188),
    [anon_sym_LT_LT] = ACTIONS(193),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(188),
    [anon_sym_PLUS_EQ] = ACTIONS(188),
    [anon_sym_DASH_EQ] = ACTIONS(188),
    [anon_sym_DOT_EQ] = ACTIONS(188),
    [anon_sym_STAR_EQ] = ACTIONS(188),
    [anon_sym_SLASH_EQ] = ACTIONS(188),
    [anon_sym_PERCENT_EQ] = ACTIONS(188),
    [anon_sym_x_EQ] = ACTIONS(188),
    [anon_sym_AMP_EQ] = ACTIONS(188),
    [anon_sym_PIPE_EQ] = ACTIONS(188),
    [anon_sym_CARET_EQ] = ACTIONS(188),
    [anon_sym_LT_LT_EQ] = ACTIONS(188),
    [anon_sym_GT_GT_EQ] = ACTIONS(188),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(188),
    [anon_sym_DOT_DOT] = ACTIONS(188),
    [anon_sym_STAR_STAR] = ACTIONS(188),
    [anon_sym_PIPE_PIPE] = ACTIONS(188),
    [anon_sym_SLASH_SLASH] = ACTIONS(196),
    [anon_sym_CARET_CARET] = ACTIONS(188),
    [anon_sym_AMP_AMP] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(188),
    [anon_sym_AMP] = ACTIONS(188),
    [anon_sym_GT_GT2] = ACTIONS(188),
    [anon_sym_PLUS] = ACTIONS(346),
    [anon_sym_DASH] = ACTIONS(349),
    [anon_sym_DOT] = ACTIONS(188),
    [anon_sym_STAR] = ACTIONS(205),
    [anon_sym_SLASH] = ACTIONS(188),
    [anon_sym_x] = ACTIONS(188),
    [anon_sym_EQ_TILDE] = ACTIONS(188),
    [anon_sym_BANG_TILDE] = ACTIONS(188),
    [anon_sym_EQ_EQ] = ACTIONS(188),
    [anon_sym_BANG_EQ] = ACTIONS(188),
    [anon_sym_eq] = ACTIONS(188),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(188),
    [anon_sym_equ] = ACTIONS(188),
    [anon_sym_eqr] = ACTIONS(188),
    [anon_sym_ne] = ACTIONS(188),
    [anon_sym_LT_EQ_GT] = ACTIONS(188),
    [anon_sym_cmp] = ACTIONS(188),
    [anon_sym_TILDE_TILDE] = ACTIONS(188),
    [anon_sym_LT_EQ] = ACTIONS(188),
    [anon_sym_GT_EQ] = ACTIONS(188),
    [anon_sym_lt] = ACTIONS(188),
    [anon_sym_le] = ACTIONS(188),
    [anon_sym_ge] = ACTIONS(188),
    [anon_sym_gt] = ACTIONS(188),
    [anon_sym_isa] = ACTIONS(188),
    [anon_sym_TILDE] = ACTIONS(227),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_QMARK] = ACTIONS(188),
    [anon_sym_BSLASH] = ACTIONS(229),
    [anon_sym_do] = ACTIONS(231),
    [anon_sym_eval] = ACTIONS(233),
    [anon_sym_await] = ACTIONS(235),
    [anon_sym_field] = ACTIONS(225),
    [anon_sym_local] = ACTIONS(237),
    [anon_sym_dynamically] = ACTIONS(237),
    [anon_sym_require] = ACTIONS(239),
    [anon_sym_map] = ACTIONS(241),
    [anon_sym_grep] = ACTIONS(241),
    [anon_sym_sort] = ACTIONS(243),
    [anon_sym_goto] = ACTIONS(245),
    [anon_sym_return] = ACTIONS(247),
    [anon_sym_undef] = ACTIONS(249),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(188),
    [anon_sym_last] = ACTIONS(251),
    [anon_sym_next] = ACTIONS(251),
    [anon_sym_redo] = ACTIONS(251),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(253),
    [anon_sym_alarm] = ACTIONS(253),
    [anon_sym_chop] = ACTIONS(253),
    [anon_sym_chdir] = ACTIONS(253),
    [anon_sym_close] = ACTIONS(253),
    [anon_sym_closedir] = ACTIONS(253),
    [anon_sym_caller] = ACTIONS(253),
    [anon_sym_chomp] = ACTIONS(253),
    [anon_sym_chr] = ACTIONS(253),
    [anon_sym_cos] = ACTIONS(253),
    [anon_sym_chroot] = ACTIONS(253),
    [anon_sym_defined] = ACTIONS(253),
    [anon_sym_delete] = ACTIONS(253),
    [anon_sym_dbmclose] = ACTIONS(253),
    [anon_sym_exists] = ACTIONS(253),
    [anon_sym_exit] = ACTIONS(253),
    [anon_sym_eof] = ACTIONS(253),
    [anon_sym_exp] = ACTIONS(253),
    [anon_sym_each] = ACTIONS(253),
    [anon_sym_fc] = ACTIONS(253),
    [anon_sym_fileno] = ACTIONS(253),
    [anon_sym_gmtime] = ACTIONS(253),
    [anon_sym_getc] = ACTIONS(253),
    [anon_sym_getpgrp] = ACTIONS(253),
    [anon_sym_getprotobyname] = ACTIONS(253),
    [anon_sym_getpwname] = ACTIONS(253),
    [anon_sym_getpwuid] = ACTIONS(253),
    [anon_sym_getpeername] = ACTIONS(253),
    [anon_sym_getnetbyname] = ACTIONS(253),
    [anon_sym_getsockname] = ACTIONS(253),
    [anon_sym_getgrnam] = ACTIONS(253),
    [anon_sym_getgrgid] = ACTIONS(253),
    [anon_sym_hex] = ACTIONS(253),
    [anon_sym_int] = ACTIONS(253),
    [anon_sym_keys] = ACTIONS(253),
    [anon_sym_lc] = ACTIONS(253),
    [anon_sym_lcfirst] = ACTIONS(253),
    [anon_sym_length] = ACTIONS(253),
    [anon_sym_localtime] = ACTIONS(253),
    [anon_sym_log] = ACTIONS(253),
    [anon_sym_lock] = ACTIONS(253),
    [anon_sym_lstat] = ACTIONS(253),
    [anon_sym_oct] = ACTIONS(253),
    [anon_sym_ord] = ACTIONS(253),
    [anon_sym_prototype] = ACTIONS(253),
    [anon_sym_pop] = ACTIONS(253),
    [anon_sym_pos] = ACTIONS(253),
    [anon_sym_quotemeta] = ACTIONS(253),
    [anon_sym_reset] = ACTIONS(253),
    [anon_sym_rand] = ACTIONS(253),
    [anon_sym_rmdir] = ACTIONS(253),
    [anon_sym_readdir] = ACTIONS(253),
    [anon_sym_readline] = ACTIONS(253),
    [anon_sym_readpipe] = ACTIONS(253),
    [anon_sym_rewinddir] = ACTIONS(253),
    [anon_sym_readlink] = ACTIONS(253),
    [anon_sym_ref] = ACTIONS(253),
    [anon_sym_scalar] = ACTIONS(253),
    [anon_sym_shift] = ACTIONS(253),
    [anon_sym_sin] = ACTIONS(253),
    [anon_sym_sleep] = ACTIONS(253),
    [anon_sym_sqrt] = ACTIONS(253),
    [anon_sym_srand] = ACTIONS(253),
    [anon_sym_stat] = ACTIONS(253),
    [anon_sym_study] = ACTIONS(253),
    [anon_sym_tell] = ACTIONS(253),
    [anon_sym_telldir] = ACTIONS(253),
    [anon_sym_tied] = ACTIONS(253),
    [anon_sym_uc] = ACTIONS(253),
    [anon_sym_ucfirst] = ACTIONS(253),
    [anon_sym_untie] = ACTIONS(253),
    [anon_sym_umask] = ACTIONS(253),
    [anon_sym_values] = ACTIONS(253),
    [anon_sym_write] = ACTIONS(253),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(188),
    [anon_sym___END__] = ACTIONS(188),
    [anon_sym_EOT] = ACTIONS(188),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [aux_sym__bareword_token1] = ACTIONS(255),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_SEMICOLON] = ACTIONS(211),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(211),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(257),
  },
  [15] = {
    [sym__PERLY_BRACE_OPEN] = STATE(204),
    [sym__term_rightward] = STATE(1521),
    [sym__subscripted] = STATE(1281),
    [sym_container_variable] = STATE(3442),
    [sym_array_element_expression] = STATE(1282),
    [sym_hash_element_expression] = STATE(1282),
    [sym_coderef_call_expression] = STATE(1282),
    [sym_anonymous_slice_expression] = STATE(1282),
    [sym_slice_container_variable] = STATE(3443),
    [sym_slice_expression] = STATE(1504),
    [sym_keyval_container_variable] = STATE(3444),
    [sym_keyval_expression] = STATE(1504),
    [sym__term] = STATE(1337),
    [sym_readline_expression] = STATE(1504),
    [sym_assignment_expression] = STATE(1504),
    [sym_binary_expression] = STATE(1504),
    [sym_equality_expression] = STATE(1504),
    [sym_relational_expression] = STATE(1504),
    [sym_unary_expression] = STATE(1504),
    [sym_preinc_expression] = STATE(1504),
    [sym_postinc_expression] = STATE(1504),
    [sym_conditional_expression] = STATE(1504),
    [sym_refgen_expression] = STATE(1504),
    [sym_anonymous_array_expression] = STATE(1504),
    [sym_anonymous_hash_expression] = STATE(1504),
    [sym_anonymous_subroutine_expression] = STATE(1504),
    [sym_anonymous_method_expression] = STATE(1504),
    [sym_do_expression] = STATE(1504),
    [sym_eval_expression] = STATE(1504),
    [sym_await_expression] = STATE(1504),
    [sym_variable_declaration] = STATE(1504),
    [sym_localization_expression] = STATE(1504),
    [sym_stub_expression] = STATE(1504),
    [sym_scalar_deref_expression] = STATE(1504),
    [sym_array_deref_expression] = STATE(1504),
    [sym_hash_deref_expression] = STATE(1504),
    [sym_amper_deref_expression] = STATE(1504),
    [sym_glob_deref_expression] = STATE(1504),
    [sym_require_expression] = STATE(1504),
    [sym_func0op_call_expression] = STATE(1504),
    [sym_func1op_call_expression] = STATE(1504),
    [sym_map_grep_expression] = STATE(1504),
    [sym_sort_expression] = STATE(1504),
    [sym_loopex_expression] = STATE(1504),
    [sym_goto_expression] = STATE(1504),
    [sym_return_expression] = STATE(1504),
    [sym_undef_expression] = STATE(1504),
    [sym__listop] = STATE(1504),
    [sym_function_call_expression] = STATE(1509),
    [sym_ambiguous_function_call_expression] = STATE(1509),
    [sym_function] = STATE(374),
    [sym_method_call_expression] = STATE(1509),
    [sym_scalar] = STATE(1504),
    [sym_array] = STATE(1504),
    [sym_hash] = STATE(1504),
    [sym_arraylen] = STATE(1504),
    [sym_glob] = STATE(1504),
    [sym__literal] = STATE(1504),
    [sym__apostrophe] = STATE(2855),
    [sym__quotation_mark] = STATE(2248),
    [sym__backtick] = STATE(2249),
    [sym__search_slash] = STATE(2226),
    [sym_string_literal] = STATE(1511),
    [sym_interpolated_string_literal] = STATE(1511),
    [sym_quoted_word_list] = STATE(1378),
    [sym_command_string] = STATE(1511),
    [sym_quoted_regexp] = STATE(1511),
    [sym_match_regexp] = STATE(1511),
    [sym_substitution_regexp] = STATE(1511),
    [sym_transliteration_expression] = STATE(1511),
    [sym_heredoc_token] = STATE(1504),
    [sym_command_heredoc_token] = STATE(1504),
    [sym_heredoc_content] = STATE(15),
    [sym_autoquoted_bareword] = STATE(1504),
    [sym_bareword] = STATE(1504),
    [sym_primitive] = STATE(1504),
    [sym_boolean] = STATE(1494),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3013),
    [sym__identifier] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(159),
    [anon_sym_SEMI] = ACTIONS(159),
    [anon_sym_DOLLAR] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(159),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(159),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(159),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(159),
    [anon_sym_RPAREN] = ACTIONS(159),
    [anon_sym_my] = ACTIONS(274),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(276),
    [anon_sym_method] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_continue] = ACTIONS(282),
    [anon_sym_state] = ACTIONS(274),
    [anon_sym_our] = ACTIONS(274),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(159),
    [anon_sym_and] = ACTIONS(159),
    [anon_sym_or] = ACTIONS(159),
    [anon_sym_xor] = ACTIONS(159),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_RBRACK] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(159),
    [anon_sym_PERCENT] = ACTIONS(159),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(159),
    [anon_sym_LT_LT] = ACTIONS(358),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(159),
    [anon_sym_PLUS_EQ] = ACTIONS(159),
    [anon_sym_DASH_EQ] = ACTIONS(159),
    [anon_sym_DOT_EQ] = ACTIONS(159),
    [anon_sym_STAR_EQ] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(159),
    [anon_sym_PERCENT_EQ] = ACTIONS(159),
    [anon_sym_x_EQ] = ACTIONS(159),
    [anon_sym_AMP_EQ] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(159),
    [anon_sym_CARET_EQ] = ACTIONS(159),
    [anon_sym_LT_LT_EQ] = ACTIONS(159),
    [anon_sym_GT_GT_EQ] = ACTIONS(159),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(159),
    [anon_sym_DOT_DOT] = ACTIONS(159),
    [anon_sym_STAR_STAR] = ACTIONS(159),
    [anon_sym_PIPE_PIPE] = ACTIONS(159),
    [anon_sym_SLASH_SLASH] = ACTIONS(361),
    [anon_sym_CARET_CARET] = ACTIONS(159),
    [anon_sym_AMP_AMP] = ACTIONS(159),
    [anon_sym_PIPE] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(159),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_GT_GT2] = ACTIONS(159),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(367),
    [anon_sym_DOT] = ACTIONS(159),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(159),
    [anon_sym_x] = ACTIONS(159),
    [anon_sym_EQ_TILDE] = ACTIONS(159),
    [anon_sym_BANG_TILDE] = ACTIONS(159),
    [anon_sym_EQ_EQ] = ACTIONS(159),
    [anon_sym_BANG_EQ] = ACTIONS(159),
    [anon_sym_eq] = ACTIONS(159),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(159),
    [anon_sym_equ] = ACTIONS(159),
    [anon_sym_eqr] = ACTIONS(159),
    [anon_sym_ne] = ACTIONS(159),
    [anon_sym_LT_EQ_GT] = ACTIONS(159),
    [anon_sym_cmp] = ACTIONS(159),
    [anon_sym_TILDE_TILDE] = ACTIONS(159),
    [anon_sym_LT_EQ] = ACTIONS(159),
    [anon_sym_GT_EQ] = ACTIONS(159),
    [anon_sym_lt] = ACTIONS(159),
    [anon_sym_le] = ACTIONS(159),
    [anon_sym_ge] = ACTIONS(159),
    [anon_sym_gt] = ACTIONS(159),
    [anon_sym_isa] = ACTIONS(159),
    [anon_sym_TILDE] = ACTIONS(286),
    [anon_sym_BANG] = ACTIONS(286),
    [anon_sym_PLUS_PLUS] = ACTIONS(373),
    [anon_sym_DASH_DASH] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(159),
    [anon_sym_BSLASH] = ACTIONS(288),
    [anon_sym_do] = ACTIONS(290),
    [anon_sym_eval] = ACTIONS(292),
    [anon_sym_await] = ACTIONS(294),
    [anon_sym_field] = ACTIONS(274),
    [anon_sym_local] = ACTIONS(296),
    [anon_sym_dynamically] = ACTIONS(296),
    [anon_sym_require] = ACTIONS(298),
    [anon_sym_map] = ACTIONS(300),
    [anon_sym_grep] = ACTIONS(300),
    [anon_sym_sort] = ACTIONS(302),
    [anon_sym_goto] = ACTIONS(304),
    [anon_sym_return] = ACTIONS(306),
    [anon_sym_undef] = ACTIONS(308),
    [anon_sym_PERCENT2] = ACTIONS(310),
    [anon_sym_DOLLAR_POUND] = ACTIONS(312),
    [anon_sym_EQ_GT] = ACTIONS(159),
    [anon_sym_last] = ACTIONS(314),
    [anon_sym_next] = ACTIONS(314),
    [anon_sym_redo] = ACTIONS(314),
    [anon_sym___FILE__] = ACTIONS(282),
    [anon_sym___LINE__] = ACTIONS(282),
    [anon_sym___PACKAGE__] = ACTIONS(282),
    [anon_sym___SUB__] = ACTIONS(282),
    [anon_sym_break] = ACTIONS(282),
    [anon_sym_fork] = ACTIONS(282),
    [anon_sym_getppid] = ACTIONS(282),
    [anon_sym_time] = ACTIONS(282),
    [anon_sym_times] = ACTIONS(282),
    [anon_sym_wait] = ACTIONS(282),
    [anon_sym_wantarray] = ACTIONS(282),
    [anon_sym_abs] = ACTIONS(316),
    [anon_sym_alarm] = ACTIONS(316),
    [anon_sym_chop] = ACTIONS(316),
    [anon_sym_chdir] = ACTIONS(316),
    [anon_sym_close] = ACTIONS(316),
    [anon_sym_closedir] = ACTIONS(316),
    [anon_sym_caller] = ACTIONS(316),
    [anon_sym_chomp] = ACTIONS(316),
    [anon_sym_chr] = ACTIONS(316),
    [anon_sym_cos] = ACTIONS(316),
    [anon_sym_chroot] = ACTIONS(316),
    [anon_sym_defined] = ACTIONS(316),
    [anon_sym_delete] = ACTIONS(316),
    [anon_sym_dbmclose] = ACTIONS(316),
    [anon_sym_exists] = ACTIONS(316),
    [anon_sym_exit] = ACTIONS(316),
    [anon_sym_eof] = ACTIONS(316),
    [anon_sym_exp] = ACTIONS(316),
    [anon_sym_each] = ACTIONS(316),
    [anon_sym_fc] = ACTIONS(316),
    [anon_sym_fileno] = ACTIONS(316),
    [anon_sym_gmtime] = ACTIONS(316),
    [anon_sym_getc] = ACTIONS(316),
    [anon_sym_getpgrp] = ACTIONS(316),
    [anon_sym_getprotobyname] = ACTIONS(316),
    [anon_sym_getpwname] = ACTIONS(316),
    [anon_sym_getpwuid] = ACTIONS(316),
    [anon_sym_getpeername] = ACTIONS(316),
    [anon_sym_getnetbyname] = ACTIONS(316),
    [anon_sym_getsockname] = ACTIONS(316),
    [anon_sym_getgrnam] = ACTIONS(316),
    [anon_sym_getgrgid] = ACTIONS(316),
    [anon_sym_hex] = ACTIONS(316),
    [anon_sym_int] = ACTIONS(316),
    [anon_sym_keys] = ACTIONS(316),
    [anon_sym_lc] = ACTIONS(316),
    [anon_sym_lcfirst] = ACTIONS(316),
    [anon_sym_length] = ACTIONS(316),
    [anon_sym_localtime] = ACTIONS(316),
    [anon_sym_log] = ACTIONS(316),
    [anon_sym_lock] = ACTIONS(316),
    [anon_sym_lstat] = ACTIONS(316),
    [anon_sym_oct] = ACTIONS(316),
    [anon_sym_ord] = ACTIONS(316),
    [anon_sym_prototype] = ACTIONS(316),
    [anon_sym_pop] = ACTIONS(316),
    [anon_sym_pos] = ACTIONS(316),
    [anon_sym_quotemeta] = ACTIONS(316),
    [anon_sym_reset] = ACTIONS(316),
    [anon_sym_rand] = ACTIONS(316),
    [anon_sym_rmdir] = ACTIONS(316),
    [anon_sym_readdir] = ACTIONS(316),
    [anon_sym_readline] = ACTIONS(316),
    [anon_sym_readpipe] = ACTIONS(316),
    [anon_sym_rewinddir] = ACTIONS(316),
    [anon_sym_readlink] = ACTIONS(316),
    [anon_sym_ref] = ACTIONS(316),
    [anon_sym_scalar] = ACTIONS(316),
    [anon_sym_shift] = ACTIONS(316),
    [anon_sym_sin] = ACTIONS(316),
    [anon_sym_sleep] = ACTIONS(316),
    [anon_sym_sqrt] = ACTIONS(316),
    [anon_sym_srand] = ACTIONS(316),
    [anon_sym_stat] = ACTIONS(316),
    [anon_sym_study] = ACTIONS(316),
    [anon_sym_tell] = ACTIONS(316),
    [anon_sym_telldir] = ACTIONS(316),
    [anon_sym_tied] = ACTIONS(316),
    [anon_sym_uc] = ACTIONS(316),
    [anon_sym_ucfirst] = ACTIONS(316),
    [anon_sym_untie] = ACTIONS(316),
    [anon_sym_umask] = ACTIONS(316),
    [anon_sym_values] = ACTIONS(316),
    [anon_sym_write] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(318),
    [anon_sym_qq] = ACTIONS(320),
    [anon_sym_qw] = ACTIONS(322),
    [anon_sym_qx] = ACTIONS(324),
    [anon_sym_qr] = ACTIONS(326),
    [anon_sym_m] = ACTIONS(328),
    [anon_sym_s] = ACTIONS(330),
    [anon_sym_tr] = ACTIONS(332),
    [anon_sym_y] = ACTIONS(332),
    [aux_sym__bareword_token1] = ACTIONS(334),
    [sym_number] = ACTIONS(336),
    [anon_sym_true] = ACTIONS(338),
    [anon_sym_false] = ACTIONS(338),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(340),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(342),
    [sym__filetest] = ACTIONS(344),
  },
  [16] = {
    [sym__PERLY_BRACE_OPEN] = STATE(67),
    [sym_block] = STATE(868),
    [sym__fullstmt] = STATE(884),
    [sym_statement_label] = STATE(804),
    [sym__barestmt] = STATE(804),
    [sym_package_statement] = STATE(839),
    [sym_class_statement] = STATE(839),
    [sym_role_statement] = STATE(839),
    [sym_class_phaser_statement] = STATE(839),
    [sym_use_version_statement] = STATE(839),
    [sym_use_statement] = STATE(839),
    [sym_subroutine_declaration_statement] = STATE(839),
    [sym_method_declaration_statement] = STATE(839),
    [sym_phaser_statement] = STATE(839),
    [sym_conditional_statement] = STATE(839),
    [sym_loop_statement] = STATE(839),
    [sym_cstyle_for_statement] = STATE(839),
    [sym_for_statement] = STATE(839),
    [sym_try_statement] = STATE(839),
    [sym_defer_statement] = STATE(839),
    [sym_expression_statement] = STATE(2715),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym___DATA__] = STATE(3494),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(16),
    [sym__conditionals] = STATE(3537),
    [sym__loops] = STATE(3594),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3646),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(40),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(2984),
    [ts_builtin_sym_end] = ACTIONS(376),
    [sym__identifier] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(15),
    [anon_sym_package] = ACTIONS(17),
    [anon_sym_class] = ACTIONS(19),
    [anon_sym_role] = ACTIONS(21),
    [anon_sym_BUILD] = ACTIONS(23),
    [anon_sym_ADJUST] = ACTIONS(23),
    [anon_sym_DOLLAR] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(29),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(33),
    [anon_sym_method] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_defer] = ACTIONS(45),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [anon_sym_use] = ACTIONS(91),
    [anon_sym_no] = ACTIONS(91),
    [anon_sym_for] = ACTIONS(93),
    [anon_sym_foreach] = ACTIONS(93),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(97),
    [anon_sym_INIT] = ACTIONS(97),
    [anon_sym_CHECK] = ACTIONS(97),
    [anon_sym_UNITCHECK] = ACTIONS(97),
    [anon_sym_END] = ACTIONS(97),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym___DATA__] = ACTIONS(101),
    [anon_sym___END__] = ACTIONS(101),
    [anon_sym_EOT] = ACTIONS(103),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__bareword_token1] = ACTIONS(125),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym__ctrl_z_hack] = ACTIONS(141),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
  },
  [17] = {
    [sym__PERLY_BRACE_OPEN] = STATE(204),
    [sym__subscripted] = STATE(1281),
    [sym_container_variable] = STATE(3442),
    [sym_array_element_expression] = STATE(1282),
    [sym_hash_element_expression] = STATE(1282),
    [sym_coderef_call_expression] = STATE(1282),
    [sym_anonymous_slice_expression] = STATE(1282),
    [sym_slice_container_variable] = STATE(3443),
    [sym_slice_expression] = STATE(1504),
    [sym_keyval_container_variable] = STATE(3444),
    [sym_keyval_expression] = STATE(1504),
    [sym__term] = STATE(1433),
    [sym_readline_expression] = STATE(1504),
    [sym_assignment_expression] = STATE(1504),
    [sym_binary_expression] = STATE(1504),
    [sym_equality_expression] = STATE(1504),
    [sym_relational_expression] = STATE(1504),
    [sym_unary_expression] = STATE(1504),
    [sym_preinc_expression] = STATE(1504),
    [sym_postinc_expression] = STATE(1504),
    [sym_conditional_expression] = STATE(1504),
    [sym_refgen_expression] = STATE(1504),
    [sym_anonymous_array_expression] = STATE(1504),
    [sym_anonymous_hash_expression] = STATE(1504),
    [sym_anonymous_subroutine_expression] = STATE(1504),
    [sym_anonymous_method_expression] = STATE(1504),
    [sym_do_expression] = STATE(1504),
    [sym_eval_expression] = STATE(1504),
    [sym_await_expression] = STATE(1504),
    [sym_variable_declaration] = STATE(1504),
    [sym_localization_expression] = STATE(1504),
    [sym_stub_expression] = STATE(1504),
    [sym_scalar_deref_expression] = STATE(1504),
    [sym_array_deref_expression] = STATE(1504),
    [sym_hash_deref_expression] = STATE(1504),
    [sym_amper_deref_expression] = STATE(1504),
    [sym_glob_deref_expression] = STATE(1504),
    [sym_require_expression] = STATE(1504),
    [sym_func0op_call_expression] = STATE(1504),
    [sym_func1op_call_expression] = STATE(1504),
    [sym_map_grep_expression] = STATE(1504),
    [sym_sort_expression] = STATE(1504),
    [sym_loopex_expression] = STATE(1504),
    [sym_goto_expression] = STATE(1504),
    [sym_return_expression] = STATE(1504),
    [sym_undef_expression] = STATE(1504),
    [sym__listop] = STATE(1504),
    [sym_function_call_expression] = STATE(1509),
    [sym_ambiguous_function_call_expression] = STATE(1509),
    [sym_function] = STATE(374),
    [sym_method_call_expression] = STATE(1509),
    [sym_scalar] = STATE(1504),
    [sym_array] = STATE(1504),
    [sym_hash] = STATE(1504),
    [sym_arraylen] = STATE(1504),
    [sym_glob] = STATE(1504),
    [sym__literal] = STATE(1504),
    [sym__apostrophe] = STATE(2855),
    [sym__quotation_mark] = STATE(2248),
    [sym__backtick] = STATE(2249),
    [sym__search_slash] = STATE(2226),
    [sym_string_literal] = STATE(1511),
    [sym_interpolated_string_literal] = STATE(1511),
    [sym_quoted_word_list] = STATE(1378),
    [sym_command_string] = STATE(1511),
    [sym_quoted_regexp] = STATE(1511),
    [sym_match_regexp] = STATE(1511),
    [sym_substitution_regexp] = STATE(1511),
    [sym_transliteration_expression] = STATE(1511),
    [sym_heredoc_token] = STATE(1504),
    [sym_command_heredoc_token] = STATE(1504),
    [sym_heredoc_content] = STATE(17),
    [sym_autoquoted_bareword] = STATE(1504),
    [sym_bareword] = STATE(1504),
    [sym_primitive] = STATE(1504),
    [sym_boolean] = STATE(1494),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3013),
    [sym__identifier] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(213),
    [anon_sym_SEMI] = ACTIONS(213),
    [anon_sym_DOLLAR] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(213),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(213),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(213),
    [anon_sym_RPAREN] = ACTIONS(213),
    [anon_sym_my] = ACTIONS(274),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(276),
    [anon_sym_method] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_continue] = ACTIONS(282),
    [anon_sym_state] = ACTIONS(274),
    [anon_sym_our] = ACTIONS(274),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(213),
    [anon_sym_and] = ACTIONS(213),
    [anon_sym_or] = ACTIONS(213),
    [anon_sym_xor] = ACTIONS(213),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_RBRACK] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(213),
    [anon_sym_PERCENT] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(213),
    [anon_sym_GT] = ACTIONS(213),
    [anon_sym_LT_LT] = ACTIONS(213),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(213),
    [anon_sym_PLUS_EQ] = ACTIONS(213),
    [anon_sym_DASH_EQ] = ACTIONS(213),
    [anon_sym_DOT_EQ] = ACTIONS(213),
    [anon_sym_STAR_EQ] = ACTIONS(213),
    [anon_sym_SLASH_EQ] = ACTIONS(213),
    [anon_sym_PERCENT_EQ] = ACTIONS(213),
    [anon_sym_x_EQ] = ACTIONS(213),
    [anon_sym_AMP_EQ] = ACTIONS(213),
    [anon_sym_PIPE_EQ] = ACTIONS(213),
    [anon_sym_CARET_EQ] = ACTIONS(213),
    [anon_sym_LT_LT_EQ] = ACTIONS(213),
    [anon_sym_GT_GT_EQ] = ACTIONS(213),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(213),
    [anon_sym_STAR_STAR] = ACTIONS(213),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_SLASH_SLASH] = ACTIONS(213),
    [anon_sym_CARET_CARET] = ACTIONS(213),
    [anon_sym_AMP_AMP] = ACTIONS(213),
    [anon_sym_PIPE] = ACTIONS(213),
    [anon_sym_CARET] = ACTIONS(213),
    [anon_sym_AMP] = ACTIONS(213),
    [anon_sym_GT_GT2] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(213),
    [anon_sym_DASH] = ACTIONS(213),
    [anon_sym_DOT] = ACTIONS(213),
    [anon_sym_STAR] = ACTIONS(213),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_x] = ACTIONS(213),
    [anon_sym_EQ_TILDE] = ACTIONS(213),
    [anon_sym_BANG_TILDE] = ACTIONS(213),
    [anon_sym_EQ_EQ] = ACTIONS(213),
    [anon_sym_BANG_EQ] = ACTIONS(213),
    [anon_sym_eq] = ACTIONS(213),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(213),
    [anon_sym_equ] = ACTIONS(213),
    [anon_sym_eqr] = ACTIONS(213),
    [anon_sym_ne] = ACTIONS(213),
    [anon_sym_LT_EQ_GT] = ACTIONS(213),
    [anon_sym_cmp] = ACTIONS(213),
    [anon_sym_TILDE_TILDE] = ACTIONS(213),
    [anon_sym_LT_EQ] = ACTIONS(213),
    [anon_sym_GT_EQ] = ACTIONS(213),
    [anon_sym_lt] = ACTIONS(213),
    [anon_sym_le] = ACTIONS(213),
    [anon_sym_ge] = ACTIONS(213),
    [anon_sym_gt] = ACTIONS(213),
    [anon_sym_isa] = ACTIONS(213),
    [anon_sym_TILDE] = ACTIONS(286),
    [anon_sym_BANG] = ACTIONS(286),
    [anon_sym_PLUS_PLUS] = ACTIONS(213),
    [anon_sym_DASH_DASH] = ACTIONS(213),
    [anon_sym_QMARK] = ACTIONS(213),
    [anon_sym_BSLASH] = ACTIONS(288),
    [anon_sym_do] = ACTIONS(290),
    [anon_sym_eval] = ACTIONS(292),
    [anon_sym_await] = ACTIONS(294),
    [anon_sym_field] = ACTIONS(274),
    [anon_sym_local] = ACTIONS(296),
    [anon_sym_dynamically] = ACTIONS(296),
    [anon_sym_require] = ACTIONS(298),
    [anon_sym_map] = ACTIONS(300),
    [anon_sym_grep] = ACTIONS(300),
    [anon_sym_sort] = ACTIONS(302),
    [anon_sym_goto] = ACTIONS(304),
    [anon_sym_return] = ACTIONS(306),
    [anon_sym_undef] = ACTIONS(308),
    [anon_sym_PERCENT2] = ACTIONS(310),
    [anon_sym_DOLLAR_POUND] = ACTIONS(312),
    [anon_sym_EQ_GT] = ACTIONS(213),
    [anon_sym_last] = ACTIONS(314),
    [anon_sym_next] = ACTIONS(314),
    [anon_sym_redo] = ACTIONS(314),
    [anon_sym___FILE__] = ACTIONS(282),
    [anon_sym___LINE__] = ACTIONS(282),
    [anon_sym___PACKAGE__] = ACTIONS(282),
    [anon_sym___SUB__] = ACTIONS(282),
    [anon_sym_break] = ACTIONS(282),
    [anon_sym_fork] = ACTIONS(282),
    [anon_sym_getppid] = ACTIONS(282),
    [anon_sym_time] = ACTIONS(282),
    [anon_sym_times] = ACTIONS(282),
    [anon_sym_wait] = ACTIONS(282),
    [anon_sym_wantarray] = ACTIONS(282),
    [anon_sym_abs] = ACTIONS(316),
    [anon_sym_alarm] = ACTIONS(316),
    [anon_sym_chop] = ACTIONS(316),
    [anon_sym_chdir] = ACTIONS(316),
    [anon_sym_close] = ACTIONS(316),
    [anon_sym_closedir] = ACTIONS(316),
    [anon_sym_caller] = ACTIONS(316),
    [anon_sym_chomp] = ACTIONS(316),
    [anon_sym_chr] = ACTIONS(316),
    [anon_sym_cos] = ACTIONS(316),
    [anon_sym_chroot] = ACTIONS(316),
    [anon_sym_defined] = ACTIONS(316),
    [anon_sym_delete] = ACTIONS(316),
    [anon_sym_dbmclose] = ACTIONS(316),
    [anon_sym_exists] = ACTIONS(316),
    [anon_sym_exit] = ACTIONS(316),
    [anon_sym_eof] = ACTIONS(316),
    [anon_sym_exp] = ACTIONS(316),
    [anon_sym_each] = ACTIONS(316),
    [anon_sym_fc] = ACTIONS(316),
    [anon_sym_fileno] = ACTIONS(316),
    [anon_sym_gmtime] = ACTIONS(316),
    [anon_sym_getc] = ACTIONS(316),
    [anon_sym_getpgrp] = ACTIONS(316),
    [anon_sym_getprotobyname] = ACTIONS(316),
    [anon_sym_getpwname] = ACTIONS(316),
    [anon_sym_getpwuid] = ACTIONS(316),
    [anon_sym_getpeername] = ACTIONS(316),
    [anon_sym_getnetbyname] = ACTIONS(316),
    [anon_sym_getsockname] = ACTIONS(316),
    [anon_sym_getgrnam] = ACTIONS(316),
    [anon_sym_getgrgid] = ACTIONS(316),
    [anon_sym_hex] = ACTIONS(316),
    [anon_sym_int] = ACTIONS(316),
    [anon_sym_keys] = ACTIONS(316),
    [anon_sym_lc] = ACTIONS(316),
    [anon_sym_lcfirst] = ACTIONS(316),
    [anon_sym_length] = ACTIONS(316),
    [anon_sym_localtime] = ACTIONS(316),
    [anon_sym_log] = ACTIONS(316),
    [anon_sym_lock] = ACTIONS(316),
    [anon_sym_lstat] = ACTIONS(316),
    [anon_sym_oct] = ACTIONS(316),
    [anon_sym_ord] = ACTIONS(316),
    [anon_sym_prototype] = ACTIONS(316),
    [anon_sym_pop] = ACTIONS(316),
    [anon_sym_pos] = ACTIONS(316),
    [anon_sym_quotemeta] = ACTIONS(316),
    [anon_sym_reset] = ACTIONS(316),
    [anon_sym_rand] = ACTIONS(316),
    [anon_sym_rmdir] = ACTIONS(316),
    [anon_sym_readdir] = ACTIONS(316),
    [anon_sym_readline] = ACTIONS(316),
    [anon_sym_readpipe] = ACTIONS(316),
    [anon_sym_rewinddir] = ACTIONS(316),
    [anon_sym_readlink] = ACTIONS(316),
    [anon_sym_ref] = ACTIONS(316),
    [anon_sym_scalar] = ACTIONS(316),
    [anon_sym_shift] = ACTIONS(316),
    [anon_sym_sin] = ACTIONS(316),
    [anon_sym_sleep] = ACTIONS(316),
    [anon_sym_sqrt] = ACTIONS(316),
    [anon_sym_srand] = ACTIONS(316),
    [anon_sym_stat] = ACTIONS(316),
    [anon_sym_study] = ACTIONS(316),
    [anon_sym_tell] = ACTIONS(316),
    [anon_sym_telldir] = ACTIONS(316),
    [anon_sym_tied] = ACTIONS(316),
    [anon_sym_uc] = ACTIONS(316),
    [anon_sym_ucfirst] = ACTIONS(316),
    [anon_sym_untie] = ACTIONS(316),
    [anon_sym_umask] = ACTIONS(316),
    [anon_sym_values] = ACTIONS(316),
    [anon_sym_write] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(318),
    [anon_sym_qq] = ACTIONS(320),
    [anon_sym_qw] = ACTIONS(322),
    [anon_sym_qx] = ACTIONS(324),
    [anon_sym_qr] = ACTIONS(326),
    [anon_sym_m] = ACTIONS(328),
    [anon_sym_s] = ACTIONS(330),
    [anon_sym_tr] = ACTIONS(332),
    [anon_sym_y] = ACTIONS(332),
    [aux_sym__bareword_token1] = ACTIONS(334),
    [sym_number] = ACTIONS(336),
    [anon_sym_true] = ACTIONS(338),
    [anon_sym_false] = ACTIONS(338),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(340),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(342),
    [sym__filetest] = ACTIONS(344),
  },
  [18] = {
    [sym__PERLY_BRACE_OPEN] = STATE(204),
    [sym__subscripted] = STATE(1281),
    [sym_container_variable] = STATE(3442),
    [sym_array_element_expression] = STATE(1282),
    [sym_hash_element_expression] = STATE(1282),
    [sym_coderef_call_expression] = STATE(1282),
    [sym_anonymous_slice_expression] = STATE(1282),
    [sym_slice_container_variable] = STATE(3443),
    [sym_slice_expression] = STATE(1504),
    [sym_keyval_container_variable] = STATE(3444),
    [sym_keyval_expression] = STATE(1504),
    [sym__term] = STATE(1532),
    [sym_readline_expression] = STATE(1504),
    [sym_assignment_expression] = STATE(1504),
    [sym_binary_expression] = STATE(1504),
    [sym_equality_expression] = STATE(1504),
    [sym_relational_expression] = STATE(1504),
    [sym_unary_expression] = STATE(1504),
    [sym_preinc_expression] = STATE(1504),
    [sym_postinc_expression] = STATE(1504),
    [sym_conditional_expression] = STATE(1504),
    [sym_refgen_expression] = STATE(1504),
    [sym_anonymous_array_expression] = STATE(1504),
    [sym_anonymous_hash_expression] = STATE(1504),
    [sym_anonymous_subroutine_expression] = STATE(1504),
    [sym_anonymous_method_expression] = STATE(1504),
    [sym_do_expression] = STATE(1504),
    [sym_eval_expression] = STATE(1504),
    [sym_await_expression] = STATE(1504),
    [sym_variable_declaration] = STATE(1504),
    [sym_localization_expression] = STATE(1504),
    [sym_stub_expression] = STATE(1504),
    [sym_scalar_deref_expression] = STATE(1504),
    [sym_array_deref_expression] = STATE(1504),
    [sym_hash_deref_expression] = STATE(1504),
    [sym_amper_deref_expression] = STATE(1504),
    [sym_glob_deref_expression] = STATE(1504),
    [sym_require_expression] = STATE(1504),
    [sym_func0op_call_expression] = STATE(1504),
    [sym_func1op_call_expression] = STATE(1504),
    [sym_map_grep_expression] = STATE(1504),
    [sym_sort_expression] = STATE(1504),
    [sym_loopex_expression] = STATE(1504),
    [sym_goto_expression] = STATE(1504),
    [sym_return_expression] = STATE(1504),
    [sym_undef_expression] = STATE(1504),
    [sym__listop] = STATE(1504),
    [sym_function_call_expression] = STATE(1509),
    [sym_ambiguous_function_call_expression] = STATE(1509),
    [sym_function] = STATE(374),
    [sym_method_call_expression] = STATE(1509),
    [sym_scalar] = STATE(1504),
    [sym_array] = STATE(1504),
    [sym_hash] = STATE(1504),
    [sym_arraylen] = STATE(1504),
    [sym_glob] = STATE(1504),
    [sym__literal] = STATE(1504),
    [sym__apostrophe] = STATE(2855),
    [sym__quotation_mark] = STATE(2248),
    [sym__backtick] = STATE(2249),
    [sym__search_slash] = STATE(2226),
    [sym_string_literal] = STATE(1511),
    [sym_interpolated_string_literal] = STATE(1511),
    [sym_quoted_word_list] = STATE(1378),
    [sym_command_string] = STATE(1511),
    [sym_quoted_regexp] = STATE(1511),
    [sym_match_regexp] = STATE(1511),
    [sym_substitution_regexp] = STATE(1511),
    [sym_transliteration_expression] = STATE(1511),
    [sym_heredoc_token] = STATE(1504),
    [sym_command_heredoc_token] = STATE(1504),
    [sym_heredoc_content] = STATE(18),
    [sym_autoquoted_bareword] = STATE(1504),
    [sym_bareword] = STATE(1504),
    [sym_primitive] = STATE(1504),
    [sym_boolean] = STATE(1494),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3013),
    [sym__identifier] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(184),
    [anon_sym_SEMI] = ACTIONS(184),
    [anon_sym_DOLLAR] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(184),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(184),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(184),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(184),
    [anon_sym_RPAREN] = ACTIONS(184),
    [anon_sym_my] = ACTIONS(274),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(276),
    [anon_sym_method] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_continue] = ACTIONS(282),
    [anon_sym_state] = ACTIONS(274),
    [anon_sym_our] = ACTIONS(274),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(184),
    [anon_sym_and] = ACTIONS(184),
    [anon_sym_or] = ACTIONS(184),
    [anon_sym_xor] = ACTIONS(184),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_RBRACK] = ACTIONS(184),
    [anon_sym_DASH_GT] = ACTIONS(184),
    [anon_sym_PERCENT] = ACTIONS(184),
    [anon_sym_LT] = ACTIONS(184),
    [anon_sym_GT] = ACTIONS(184),
    [anon_sym_LT_LT] = ACTIONS(184),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(184),
    [anon_sym_PLUS_EQ] = ACTIONS(184),
    [anon_sym_DASH_EQ] = ACTIONS(184),
    [anon_sym_DOT_EQ] = ACTIONS(184),
    [anon_sym_STAR_EQ] = ACTIONS(184),
    [anon_sym_SLASH_EQ] = ACTIONS(184),
    [anon_sym_PERCENT_EQ] = ACTIONS(184),
    [anon_sym_x_EQ] = ACTIONS(184),
    [anon_sym_AMP_EQ] = ACTIONS(184),
    [anon_sym_PIPE_EQ] = ACTIONS(184),
    [anon_sym_CARET_EQ] = ACTIONS(184),
    [anon_sym_LT_LT_EQ] = ACTIONS(184),
    [anon_sym_GT_GT_EQ] = ACTIONS(184),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(184),
    [anon_sym_DOT_DOT] = ACTIONS(184),
    [anon_sym_STAR_STAR] = ACTIONS(184),
    [anon_sym_PIPE_PIPE] = ACTIONS(184),
    [anon_sym_SLASH_SLASH] = ACTIONS(184),
    [anon_sym_CARET_CARET] = ACTIONS(184),
    [anon_sym_AMP_AMP] = ACTIONS(184),
    [anon_sym_PIPE] = ACTIONS(184),
    [anon_sym_CARET] = ACTIONS(184),
    [anon_sym_AMP] = ACTIONS(184),
    [anon_sym_GT_GT2] = ACTIONS(184),
    [anon_sym_PLUS] = ACTIONS(184),
    [anon_sym_DASH] = ACTIONS(184),
    [anon_sym_DOT] = ACTIONS(184),
    [anon_sym_STAR] = ACTIONS(184),
    [anon_sym_SLASH] = ACTIONS(184),
    [anon_sym_x] = ACTIONS(184),
    [anon_sym_EQ_TILDE] = ACTIONS(184),
    [anon_sym_BANG_TILDE] = ACTIONS(184),
    [anon_sym_EQ_EQ] = ACTIONS(184),
    [anon_sym_BANG_EQ] = ACTIONS(184),
    [anon_sym_eq] = ACTIONS(184),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(184),
    [anon_sym_equ] = ACTIONS(184),
    [anon_sym_eqr] = ACTIONS(184),
    [anon_sym_ne] = ACTIONS(184),
    [anon_sym_LT_EQ_GT] = ACTIONS(184),
    [anon_sym_cmp] = ACTIONS(184),
    [anon_sym_TILDE_TILDE] = ACTIONS(184),
    [anon_sym_LT_EQ] = ACTIONS(184),
    [anon_sym_GT_EQ] = ACTIONS(184),
    [anon_sym_lt] = ACTIONS(184),
    [anon_sym_le] = ACTIONS(184),
    [anon_sym_ge] = ACTIONS(184),
    [anon_sym_gt] = ACTIONS(184),
    [anon_sym_isa] = ACTIONS(184),
    [anon_sym_TILDE] = ACTIONS(286),
    [anon_sym_BANG] = ACTIONS(286),
    [anon_sym_PLUS_PLUS] = ACTIONS(184),
    [anon_sym_DASH_DASH] = ACTIONS(184),
    [anon_sym_QMARK] = ACTIONS(184),
    [anon_sym_BSLASH] = ACTIONS(288),
    [anon_sym_do] = ACTIONS(290),
    [anon_sym_eval] = ACTIONS(292),
    [anon_sym_await] = ACTIONS(294),
    [anon_sym_field] = ACTIONS(274),
    [anon_sym_local] = ACTIONS(296),
    [anon_sym_dynamically] = ACTIONS(296),
    [anon_sym_require] = ACTIONS(298),
    [anon_sym_map] = ACTIONS(300),
    [anon_sym_grep] = ACTIONS(300),
    [anon_sym_sort] = ACTIONS(302),
    [anon_sym_goto] = ACTIONS(304),
    [anon_sym_return] = ACTIONS(306),
    [anon_sym_undef] = ACTIONS(308),
    [anon_sym_PERCENT2] = ACTIONS(310),
    [anon_sym_DOLLAR_POUND] = ACTIONS(312),
    [anon_sym_EQ_GT] = ACTIONS(184),
    [anon_sym_last] = ACTIONS(314),
    [anon_sym_next] = ACTIONS(314),
    [anon_sym_redo] = ACTIONS(314),
    [anon_sym___FILE__] = ACTIONS(282),
    [anon_sym___LINE__] = ACTIONS(282),
    [anon_sym___PACKAGE__] = ACTIONS(282),
    [anon_sym___SUB__] = ACTIONS(282),
    [anon_sym_break] = ACTIONS(282),
    [anon_sym_fork] = ACTIONS(282),
    [anon_sym_getppid] = ACTIONS(282),
    [anon_sym_time] = ACTIONS(282),
    [anon_sym_times] = ACTIONS(282),
    [anon_sym_wait] = ACTIONS(282),
    [anon_sym_wantarray] = ACTIONS(282),
    [anon_sym_abs] = ACTIONS(316),
    [anon_sym_alarm] = ACTIONS(316),
    [anon_sym_chop] = ACTIONS(316),
    [anon_sym_chdir] = ACTIONS(316),
    [anon_sym_close] = ACTIONS(316),
    [anon_sym_closedir] = ACTIONS(316),
    [anon_sym_caller] = ACTIONS(316),
    [anon_sym_chomp] = ACTIONS(316),
    [anon_sym_chr] = ACTIONS(316),
    [anon_sym_cos] = ACTIONS(316),
    [anon_sym_chroot] = ACTIONS(316),
    [anon_sym_defined] = ACTIONS(316),
    [anon_sym_delete] = ACTIONS(316),
    [anon_sym_dbmclose] = ACTIONS(316),
    [anon_sym_exists] = ACTIONS(316),
    [anon_sym_exit] = ACTIONS(316),
    [anon_sym_eof] = ACTIONS(316),
    [anon_sym_exp] = ACTIONS(316),
    [anon_sym_each] = ACTIONS(316),
    [anon_sym_fc] = ACTIONS(316),
    [anon_sym_fileno] = ACTIONS(316),
    [anon_sym_gmtime] = ACTIONS(316),
    [anon_sym_getc] = ACTIONS(316),
    [anon_sym_getpgrp] = ACTIONS(316),
    [anon_sym_getprotobyname] = ACTIONS(316),
    [anon_sym_getpwname] = ACTIONS(316),
    [anon_sym_getpwuid] = ACTIONS(316),
    [anon_sym_getpeername] = ACTIONS(316),
    [anon_sym_getnetbyname] = ACTIONS(316),
    [anon_sym_getsockname] = ACTIONS(316),
    [anon_sym_getgrnam] = ACTIONS(316),
    [anon_sym_getgrgid] = ACTIONS(316),
    [anon_sym_hex] = ACTIONS(316),
    [anon_sym_int] = ACTIONS(316),
    [anon_sym_keys] = ACTIONS(316),
    [anon_sym_lc] = ACTIONS(316),
    [anon_sym_lcfirst] = ACTIONS(316),
    [anon_sym_length] = ACTIONS(316),
    [anon_sym_localtime] = ACTIONS(316),
    [anon_sym_log] = ACTIONS(316),
    [anon_sym_lock] = ACTIONS(316),
    [anon_sym_lstat] = ACTIONS(316),
    [anon_sym_oct] = ACTIONS(316),
    [anon_sym_ord] = ACTIONS(316),
    [anon_sym_prototype] = ACTIONS(316),
    [anon_sym_pop] = ACTIONS(316),
    [anon_sym_pos] = ACTIONS(316),
    [anon_sym_quotemeta] = ACTIONS(316),
    [anon_sym_reset] = ACTIONS(316),
    [anon_sym_rand] = ACTIONS(316),
    [anon_sym_rmdir] = ACTIONS(316),
    [anon_sym_readdir] = ACTIONS(316),
    [anon_sym_readline] = ACTIONS(316),
    [anon_sym_readpipe] = ACTIONS(316),
    [anon_sym_rewinddir] = ACTIONS(316),
    [anon_sym_readlink] = ACTIONS(316),
    [anon_sym_ref] = ACTIONS(316),
    [anon_sym_scalar] = ACTIONS(316),
    [anon_sym_shift] = ACTIONS(316),
    [anon_sym_sin] = ACTIONS(316),
    [anon_sym_sleep] = ACTIONS(316),
    [anon_sym_sqrt] = ACTIONS(316),
    [anon_sym_srand] = ACTIONS(316),
    [anon_sym_stat] = ACTIONS(316),
    [anon_sym_study] = ACTIONS(316),
    [anon_sym_tell] = ACTIONS(316),
    [anon_sym_telldir] = ACTIONS(316),
    [anon_sym_tied] = ACTIONS(316),
    [anon_sym_uc] = ACTIONS(316),
    [anon_sym_ucfirst] = ACTIONS(316),
    [anon_sym_untie] = ACTIONS(316),
    [anon_sym_umask] = ACTIONS(316),
    [anon_sym_values] = ACTIONS(316),
    [anon_sym_write] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(318),
    [anon_sym_qq] = ACTIONS(320),
    [anon_sym_qw] = ACTIONS(322),
    [anon_sym_qx] = ACTIONS(324),
    [anon_sym_qr] = ACTIONS(326),
    [anon_sym_m] = ACTIONS(328),
    [anon_sym_s] = ACTIONS(330),
    [anon_sym_tr] = ACTIONS(332),
    [anon_sym_y] = ACTIONS(332),
    [aux_sym__bareword_token1] = ACTIONS(334),
    [sym_number] = ACTIONS(336),
    [anon_sym_true] = ACTIONS(338),
    [anon_sym_false] = ACTIONS(338),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(340),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(342),
    [sym__filetest] = ACTIONS(344),
  },
  [19] = {
    [sym__PERLY_BRACE_OPEN] = STATE(204),
    [sym__subscripted] = STATE(1281),
    [sym_container_variable] = STATE(3442),
    [sym_array_element_expression] = STATE(1282),
    [sym_hash_element_expression] = STATE(1282),
    [sym_coderef_call_expression] = STATE(1282),
    [sym_anonymous_slice_expression] = STATE(1282),
    [sym_slice_container_variable] = STATE(3443),
    [sym_slice_expression] = STATE(1504),
    [sym_keyval_container_variable] = STATE(3444),
    [sym_keyval_expression] = STATE(1504),
    [sym__term] = STATE(1517),
    [sym_readline_expression] = STATE(1504),
    [sym_assignment_expression] = STATE(1504),
    [sym_binary_expression] = STATE(1504),
    [sym_equality_expression] = STATE(1504),
    [sym_relational_expression] = STATE(1504),
    [sym_unary_expression] = STATE(1504),
    [sym_preinc_expression] = STATE(1504),
    [sym_postinc_expression] = STATE(1504),
    [sym_conditional_expression] = STATE(1504),
    [sym_refgen_expression] = STATE(1504),
    [sym_anonymous_array_expression] = STATE(1504),
    [sym_anonymous_hash_expression] = STATE(1504),
    [sym_anonymous_subroutine_expression] = STATE(1504),
    [sym_anonymous_method_expression] = STATE(1504),
    [sym_do_expression] = STATE(1504),
    [sym_eval_expression] = STATE(1504),
    [sym_await_expression] = STATE(1504),
    [sym_variable_declaration] = STATE(1504),
    [sym_localization_expression] = STATE(1504),
    [sym_stub_expression] = STATE(1504),
    [sym_scalar_deref_expression] = STATE(1504),
    [sym_array_deref_expression] = STATE(1504),
    [sym_hash_deref_expression] = STATE(1504),
    [sym_amper_deref_expression] = STATE(1504),
    [sym_glob_deref_expression] = STATE(1504),
    [sym_require_expression] = STATE(1504),
    [sym_func0op_call_expression] = STATE(1504),
    [sym_func1op_call_expression] = STATE(1504),
    [sym_map_grep_expression] = STATE(1504),
    [sym_sort_expression] = STATE(1504),
    [sym_loopex_expression] = STATE(1504),
    [sym_goto_expression] = STATE(1504),
    [sym_return_expression] = STATE(1504),
    [sym_undef_expression] = STATE(1504),
    [sym__listop] = STATE(1504),
    [sym_function_call_expression] = STATE(1509),
    [sym_ambiguous_function_call_expression] = STATE(1509),
    [sym_function] = STATE(374),
    [sym_method_call_expression] = STATE(1509),
    [sym_scalar] = STATE(1504),
    [sym_array] = STATE(1504),
    [sym_hash] = STATE(1504),
    [sym_arraylen] = STATE(1504),
    [sym_glob] = STATE(1504),
    [sym__literal] = STATE(1504),
    [sym__apostrophe] = STATE(2855),
    [sym__quotation_mark] = STATE(2248),
    [sym__backtick] = STATE(2249),
    [sym__search_slash] = STATE(2226),
    [sym_string_literal] = STATE(1511),
    [sym_interpolated_string_literal] = STATE(1511),
    [sym_quoted_word_list] = STATE(1378),
    [sym_command_string] = STATE(1511),
    [sym_quoted_regexp] = STATE(1511),
    [sym_match_regexp] = STATE(1511),
    [sym_substitution_regexp] = STATE(1511),
    [sym_transliteration_expression] = STATE(1511),
    [sym_heredoc_token] = STATE(1504),
    [sym_command_heredoc_token] = STATE(1504),
    [sym_heredoc_content] = STATE(19),
    [sym_autoquoted_bareword] = STATE(1504),
    [sym_bareword] = STATE(1504),
    [sym_primitive] = STATE(1504),
    [sym_boolean] = STATE(1494),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3013),
    [sym__identifier] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(217),
    [anon_sym_SEMI] = ACTIONS(217),
    [anon_sym_DOLLAR] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(217),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(217),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(217),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(217),
    [anon_sym_RPAREN] = ACTIONS(217),
    [anon_sym_my] = ACTIONS(274),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(276),
    [anon_sym_method] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(378),
    [anon_sym_continue] = ACTIONS(282),
    [anon_sym_state] = ACTIONS(274),
    [anon_sym_our] = ACTIONS(274),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(217),
    [anon_sym_and] = ACTIONS(217),
    [anon_sym_or] = ACTIONS(217),
    [anon_sym_xor] = ACTIONS(217),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_RBRACK] = ACTIONS(217),
    [anon_sym_DASH_GT] = ACTIONS(217),
    [anon_sym_PERCENT] = ACTIONS(217),
    [anon_sym_LT] = ACTIONS(217),
    [anon_sym_GT] = ACTIONS(217),
    [anon_sym_LT_LT] = ACTIONS(217),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(217),
    [anon_sym_PLUS_EQ] = ACTIONS(217),
    [anon_sym_DASH_EQ] = ACTIONS(217),
    [anon_sym_DOT_EQ] = ACTIONS(217),
    [anon_sym_STAR_EQ] = ACTIONS(217),
    [anon_sym_SLASH_EQ] = ACTIONS(217),
    [anon_sym_PERCENT_EQ] = ACTIONS(217),
    [anon_sym_x_EQ] = ACTIONS(217),
    [anon_sym_AMP_EQ] = ACTIONS(217),
    [anon_sym_PIPE_EQ] = ACTIONS(217),
    [anon_sym_CARET_EQ] = ACTIONS(217),
    [anon_sym_LT_LT_EQ] = ACTIONS(217),
    [anon_sym_GT_GT_EQ] = ACTIONS(217),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(217),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_STAR_STAR] = ACTIONS(217),
    [anon_sym_PIPE_PIPE] = ACTIONS(217),
    [anon_sym_SLASH_SLASH] = ACTIONS(217),
    [anon_sym_CARET_CARET] = ACTIONS(217),
    [anon_sym_AMP_AMP] = ACTIONS(217),
    [anon_sym_PIPE] = ACTIONS(217),
    [anon_sym_CARET] = ACTIONS(217),
    [anon_sym_AMP] = ACTIONS(217),
    [anon_sym_GT_GT2] = ACTIONS(217),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(217),
    [anon_sym_STAR] = ACTIONS(217),
    [anon_sym_SLASH] = ACTIONS(217),
    [anon_sym_x] = ACTIONS(217),
    [anon_sym_EQ_TILDE] = ACTIONS(217),
    [anon_sym_BANG_TILDE] = ACTIONS(217),
    [anon_sym_EQ_EQ] = ACTIONS(217),
    [anon_sym_BANG_EQ] = ACTIONS(217),
    [anon_sym_eq] = ACTIONS(217),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(217),
    [anon_sym_equ] = ACTIONS(217),
    [anon_sym_eqr] = ACTIONS(217),
    [anon_sym_ne] = ACTIONS(217),
    [anon_sym_LT_EQ_GT] = ACTIONS(217),
    [anon_sym_cmp] = ACTIONS(217),
    [anon_sym_TILDE_TILDE] = ACTIONS(217),
    [anon_sym_LT_EQ] = ACTIONS(217),
    [anon_sym_GT_EQ] = ACTIONS(217),
    [anon_sym_lt] = ACTIONS(217),
    [anon_sym_le] = ACTIONS(217),
    [anon_sym_ge] = ACTIONS(217),
    [anon_sym_gt] = ACTIONS(217),
    [anon_sym_isa] = ACTIONS(217),
    [anon_sym_TILDE] = ACTIONS(286),
    [anon_sym_BANG] = ACTIONS(286),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_QMARK] = ACTIONS(217),
    [anon_sym_BSLASH] = ACTIONS(288),
    [anon_sym_do] = ACTIONS(290),
    [anon_sym_eval] = ACTIONS(292),
    [anon_sym_await] = ACTIONS(294),
    [anon_sym_field] = ACTIONS(274),
    [anon_sym_local] = ACTIONS(296),
    [anon_sym_dynamically] = ACTIONS(296),
    [anon_sym_require] = ACTIONS(298),
    [anon_sym_map] = ACTIONS(300),
    [anon_sym_grep] = ACTIONS(300),
    [anon_sym_sort] = ACTIONS(302),
    [anon_sym_goto] = ACTIONS(304),
    [anon_sym_return] = ACTIONS(306),
    [anon_sym_undef] = ACTIONS(308),
    [anon_sym_PERCENT2] = ACTIONS(310),
    [anon_sym_DOLLAR_POUND] = ACTIONS(312),
    [anon_sym_EQ_GT] = ACTIONS(217),
    [anon_sym_last] = ACTIONS(314),
    [anon_sym_next] = ACTIONS(314),
    [anon_sym_redo] = ACTIONS(314),
    [anon_sym___FILE__] = ACTIONS(282),
    [anon_sym___LINE__] = ACTIONS(282),
    [anon_sym___PACKAGE__] = ACTIONS(282),
    [anon_sym___SUB__] = ACTIONS(282),
    [anon_sym_break] = ACTIONS(282),
    [anon_sym_fork] = ACTIONS(282),
    [anon_sym_getppid] = ACTIONS(282),
    [anon_sym_time] = ACTIONS(282),
    [anon_sym_times] = ACTIONS(282),
    [anon_sym_wait] = ACTIONS(282),
    [anon_sym_wantarray] = ACTIONS(282),
    [anon_sym_abs] = ACTIONS(316),
    [anon_sym_alarm] = ACTIONS(316),
    [anon_sym_chop] = ACTIONS(316),
    [anon_sym_chdir] = ACTIONS(316),
    [anon_sym_close] = ACTIONS(316),
    [anon_sym_closedir] = ACTIONS(316),
    [anon_sym_caller] = ACTIONS(316),
    [anon_sym_chomp] = ACTIONS(316),
    [anon_sym_chr] = ACTIONS(316),
    [anon_sym_cos] = ACTIONS(316),
    [anon_sym_chroot] = ACTIONS(316),
    [anon_sym_defined] = ACTIONS(316),
    [anon_sym_delete] = ACTIONS(316),
    [anon_sym_dbmclose] = ACTIONS(316),
    [anon_sym_exists] = ACTIONS(316),
    [anon_sym_exit] = ACTIONS(316),
    [anon_sym_eof] = ACTIONS(316),
    [anon_sym_exp] = ACTIONS(316),
    [anon_sym_each] = ACTIONS(316),
    [anon_sym_fc] = ACTIONS(316),
    [anon_sym_fileno] = ACTIONS(316),
    [anon_sym_gmtime] = ACTIONS(316),
    [anon_sym_getc] = ACTIONS(316),
    [anon_sym_getpgrp] = ACTIONS(316),
    [anon_sym_getprotobyname] = ACTIONS(316),
    [anon_sym_getpwname] = ACTIONS(316),
    [anon_sym_getpwuid] = ACTIONS(316),
    [anon_sym_getpeername] = ACTIONS(316),
    [anon_sym_getnetbyname] = ACTIONS(316),
    [anon_sym_getsockname] = ACTIONS(316),
    [anon_sym_getgrnam] = ACTIONS(316),
    [anon_sym_getgrgid] = ACTIONS(316),
    [anon_sym_hex] = ACTIONS(316),
    [anon_sym_int] = ACTIONS(316),
    [anon_sym_keys] = ACTIONS(316),
    [anon_sym_lc] = ACTIONS(316),
    [anon_sym_lcfirst] = ACTIONS(316),
    [anon_sym_length] = ACTIONS(316),
    [anon_sym_localtime] = ACTIONS(316),
    [anon_sym_log] = ACTIONS(316),
    [anon_sym_lock] = ACTIONS(316),
    [anon_sym_lstat] = ACTIONS(316),
    [anon_sym_oct] = ACTIONS(316),
    [anon_sym_ord] = ACTIONS(316),
    [anon_sym_prototype] = ACTIONS(316),
    [anon_sym_pop] = ACTIONS(316),
    [anon_sym_pos] = ACTIONS(316),
    [anon_sym_quotemeta] = ACTIONS(316),
    [anon_sym_reset] = ACTIONS(316),
    [anon_sym_rand] = ACTIONS(316),
    [anon_sym_rmdir] = ACTIONS(316),
    [anon_sym_readdir] = ACTIONS(316),
    [anon_sym_readline] = ACTIONS(316),
    [anon_sym_readpipe] = ACTIONS(316),
    [anon_sym_rewinddir] = ACTIONS(316),
    [anon_sym_readlink] = ACTIONS(316),
    [anon_sym_ref] = ACTIONS(316),
    [anon_sym_scalar] = ACTIONS(316),
    [anon_sym_shift] = ACTIONS(316),
    [anon_sym_sin] = ACTIONS(316),
    [anon_sym_sleep] = ACTIONS(316),
    [anon_sym_sqrt] = ACTIONS(316),
    [anon_sym_srand] = ACTIONS(316),
    [anon_sym_stat] = ACTIONS(316),
    [anon_sym_study] = ACTIONS(316),
    [anon_sym_tell] = ACTIONS(316),
    [anon_sym_telldir] = ACTIONS(316),
    [anon_sym_tied] = ACTIONS(316),
    [anon_sym_uc] = ACTIONS(316),
    [anon_sym_ucfirst] = ACTIONS(316),
    [anon_sym_untie] = ACTIONS(316),
    [anon_sym_umask] = ACTIONS(316),
    [anon_sym_values] = ACTIONS(316),
    [anon_sym_write] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(318),
    [anon_sym_qq] = ACTIONS(320),
    [anon_sym_qw] = ACTIONS(322),
    [anon_sym_qx] = ACTIONS(324),
    [anon_sym_qr] = ACTIONS(326),
    [anon_sym_m] = ACTIONS(328),
    [anon_sym_s] = ACTIONS(330),
    [anon_sym_tr] = ACTIONS(332),
    [anon_sym_y] = ACTIONS(332),
    [aux_sym__bareword_token1] = ACTIONS(334),
    [sym_number] = ACTIONS(336),
    [anon_sym_true] = ACTIONS(338),
    [anon_sym_false] = ACTIONS(338),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(340),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(342),
    [sym__filetest] = ACTIONS(344),
  },
  [20] = {
    [sym__PERLY_BRACE_OPEN] = STATE(204),
    [sym__subscripted] = STATE(1281),
    [sym_container_variable] = STATE(3442),
    [sym_array_element_expression] = STATE(1282),
    [sym_hash_element_expression] = STATE(1282),
    [sym_coderef_call_expression] = STATE(1282),
    [sym_anonymous_slice_expression] = STATE(1282),
    [sym_slice_container_variable] = STATE(3443),
    [sym_slice_expression] = STATE(1504),
    [sym_keyval_container_variable] = STATE(3444),
    [sym_keyval_expression] = STATE(1504),
    [sym__term] = STATE(1412),
    [sym_readline_expression] = STATE(1504),
    [sym_assignment_expression] = STATE(1504),
    [sym_binary_expression] = STATE(1504),
    [sym_equality_expression] = STATE(1504),
    [sym_relational_expression] = STATE(1504),
    [sym_unary_expression] = STATE(1504),
    [sym_preinc_expression] = STATE(1504),
    [sym_postinc_expression] = STATE(1504),
    [sym_conditional_expression] = STATE(1504),
    [sym_refgen_expression] = STATE(1504),
    [sym_anonymous_array_expression] = STATE(1504),
    [sym_anonymous_hash_expression] = STATE(1504),
    [sym_anonymous_subroutine_expression] = STATE(1504),
    [sym_anonymous_method_expression] = STATE(1504),
    [sym_do_expression] = STATE(1504),
    [sym_eval_expression] = STATE(1504),
    [sym_await_expression] = STATE(1504),
    [sym_variable_declaration] = STATE(1504),
    [sym_localization_expression] = STATE(1504),
    [sym_stub_expression] = STATE(1504),
    [sym_scalar_deref_expression] = STATE(1504),
    [sym_array_deref_expression] = STATE(1504),
    [sym_hash_deref_expression] = STATE(1504),
    [sym_amper_deref_expression] = STATE(1504),
    [sym_glob_deref_expression] = STATE(1504),
    [sym_require_expression] = STATE(1504),
    [sym_func0op_call_expression] = STATE(1504),
    [sym_func1op_call_expression] = STATE(1504),
    [sym_map_grep_expression] = STATE(1504),
    [sym_sort_expression] = STATE(1504),
    [sym_loopex_expression] = STATE(1504),
    [sym_goto_expression] = STATE(1504),
    [sym_return_expression] = STATE(1504),
    [sym_undef_expression] = STATE(1504),
    [sym__listop] = STATE(1504),
    [sym_function_call_expression] = STATE(1509),
    [sym_ambiguous_function_call_expression] = STATE(1509),
    [sym_function] = STATE(374),
    [sym_method_call_expression] = STATE(1509),
    [sym_scalar] = STATE(1504),
    [sym_array] = STATE(1504),
    [sym_hash] = STATE(1504),
    [sym_arraylen] = STATE(1504),
    [sym_glob] = STATE(1504),
    [sym__literal] = STATE(1504),
    [sym__apostrophe] = STATE(2855),
    [sym__quotation_mark] = STATE(2248),
    [sym__backtick] = STATE(2249),
    [sym__search_slash] = STATE(2226),
    [sym_string_literal] = STATE(1511),
    [sym_interpolated_string_literal] = STATE(1511),
    [sym_quoted_word_list] = STATE(1378),
    [sym_command_string] = STATE(1511),
    [sym_quoted_regexp] = STATE(1511),
    [sym_match_regexp] = STATE(1511),
    [sym_substitution_regexp] = STATE(1511),
    [sym_transliteration_expression] = STATE(1511),
    [sym_heredoc_token] = STATE(1504),
    [sym_command_heredoc_token] = STATE(1504),
    [sym_heredoc_content] = STATE(20),
    [sym_autoquoted_bareword] = STATE(1504),
    [sym_bareword] = STATE(1504),
    [sym_primitive] = STATE(1504),
    [sym_boolean] = STATE(1494),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3013),
    [sym__identifier] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(188),
    [anon_sym_SEMI] = ACTIONS(188),
    [anon_sym_DOLLAR] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(188),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(188),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(188),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(188),
    [anon_sym_RPAREN] = ACTIONS(188),
    [anon_sym_my] = ACTIONS(274),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(276),
    [anon_sym_method] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_continue] = ACTIONS(282),
    [anon_sym_state] = ACTIONS(274),
    [anon_sym_our] = ACTIONS(274),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(188),
    [anon_sym_and] = ACTIONS(188),
    [anon_sym_or] = ACTIONS(188),
    [anon_sym_xor] = ACTIONS(188),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_RBRACK] = ACTIONS(188),
    [anon_sym_DASH_GT] = ACTIONS(188),
    [anon_sym_PERCENT] = ACTIONS(188),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_GT] = ACTIONS(188),
    [anon_sym_LT_LT] = ACTIONS(383),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(188),
    [anon_sym_PLUS_EQ] = ACTIONS(188),
    [anon_sym_DASH_EQ] = ACTIONS(188),
    [anon_sym_DOT_EQ] = ACTIONS(188),
    [anon_sym_STAR_EQ] = ACTIONS(188),
    [anon_sym_SLASH_EQ] = ACTIONS(188),
    [anon_sym_PERCENT_EQ] = ACTIONS(188),
    [anon_sym_x_EQ] = ACTIONS(188),
    [anon_sym_AMP_EQ] = ACTIONS(188),
    [anon_sym_PIPE_EQ] = ACTIONS(188),
    [anon_sym_CARET_EQ] = ACTIONS(188),
    [anon_sym_LT_LT_EQ] = ACTIONS(188),
    [anon_sym_GT_GT_EQ] = ACTIONS(188),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(188),
    [anon_sym_DOT_DOT] = ACTIONS(188),
    [anon_sym_STAR_STAR] = ACTIONS(188),
    [anon_sym_PIPE_PIPE] = ACTIONS(188),
    [anon_sym_SLASH_SLASH] = ACTIONS(386),
    [anon_sym_CARET_CARET] = ACTIONS(188),
    [anon_sym_AMP_AMP] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(188),
    [anon_sym_CARET] = ACTIONS(188),
    [anon_sym_AMP] = ACTIONS(188),
    [anon_sym_GT_GT2] = ACTIONS(188),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(392),
    [anon_sym_DOT] = ACTIONS(188),
    [anon_sym_STAR] = ACTIONS(395),
    [anon_sym_SLASH] = ACTIONS(188),
    [anon_sym_x] = ACTIONS(188),
    [anon_sym_EQ_TILDE] = ACTIONS(188),
    [anon_sym_BANG_TILDE] = ACTIONS(188),
    [anon_sym_EQ_EQ] = ACTIONS(188),
    [anon_sym_BANG_EQ] = ACTIONS(188),
    [anon_sym_eq] = ACTIONS(188),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(188),
    [anon_sym_equ] = ACTIONS(188),
    [anon_sym_eqr] = ACTIONS(188),
    [anon_sym_ne] = ACTIONS(188),
    [anon_sym_LT_EQ_GT] = ACTIONS(188),
    [anon_sym_cmp] = ACTIONS(188),
    [anon_sym_TILDE_TILDE] = ACTIONS(188),
    [anon_sym_LT_EQ] = ACTIONS(188),
    [anon_sym_GT_EQ] = ACTIONS(188),
    [anon_sym_lt] = ACTIONS(188),
    [anon_sym_le] = ACTIONS(188),
    [anon_sym_ge] = ACTIONS(188),
    [anon_sym_gt] = ACTIONS(188),
    [anon_sym_isa] = ACTIONS(188),
    [anon_sym_TILDE] = ACTIONS(286),
    [anon_sym_BANG] = ACTIONS(286),
    [anon_sym_PLUS_PLUS] = ACTIONS(398),
    [anon_sym_DASH_DASH] = ACTIONS(398),
    [anon_sym_QMARK] = ACTIONS(188),
    [anon_sym_BSLASH] = ACTIONS(288),
    [anon_sym_do] = ACTIONS(290),
    [anon_sym_eval] = ACTIONS(292),
    [anon_sym_await] = ACTIONS(294),
    [anon_sym_field] = ACTIONS(274),
    [anon_sym_local] = ACTIONS(296),
    [anon_sym_dynamically] = ACTIONS(296),
    [anon_sym_require] = ACTIONS(298),
    [anon_sym_map] = ACTIONS(300),
    [anon_sym_grep] = ACTIONS(300),
    [anon_sym_sort] = ACTIONS(302),
    [anon_sym_goto] = ACTIONS(304),
    [anon_sym_return] = ACTIONS(306),
    [anon_sym_undef] = ACTIONS(308),
    [anon_sym_PERCENT2] = ACTIONS(310),
    [anon_sym_DOLLAR_POUND] = ACTIONS(312),
    [anon_sym_EQ_GT] = ACTIONS(188),
    [anon_sym_last] = ACTIONS(314),
    [anon_sym_next] = ACTIONS(314),
    [anon_sym_redo] = ACTIONS(314),
    [anon_sym___FILE__] = ACTIONS(282),
    [anon_sym___LINE__] = ACTIONS(282),
    [anon_sym___PACKAGE__] = ACTIONS(282),
    [anon_sym___SUB__] = ACTIONS(282),
    [anon_sym_break] = ACTIONS(282),
    [anon_sym_fork] = ACTIONS(282),
    [anon_sym_getppid] = ACTIONS(282),
    [anon_sym_time] = ACTIONS(282),
    [anon_sym_times] = ACTIONS(282),
    [anon_sym_wait] = ACTIONS(282),
    [anon_sym_wantarray] = ACTIONS(282),
    [anon_sym_abs] = ACTIONS(316),
    [anon_sym_alarm] = ACTIONS(316),
    [anon_sym_chop] = ACTIONS(316),
    [anon_sym_chdir] = ACTIONS(316),
    [anon_sym_close] = ACTIONS(316),
    [anon_sym_closedir] = ACTIONS(316),
    [anon_sym_caller] = ACTIONS(316),
    [anon_sym_chomp] = ACTIONS(316),
    [anon_sym_chr] = ACTIONS(316),
    [anon_sym_cos] = ACTIONS(316),
    [anon_sym_chroot] = ACTIONS(316),
    [anon_sym_defined] = ACTIONS(316),
    [anon_sym_delete] = ACTIONS(316),
    [anon_sym_dbmclose] = ACTIONS(316),
    [anon_sym_exists] = ACTIONS(316),
    [anon_sym_exit] = ACTIONS(316),
    [anon_sym_eof] = ACTIONS(316),
    [anon_sym_exp] = ACTIONS(316),
    [anon_sym_each] = ACTIONS(316),
    [anon_sym_fc] = ACTIONS(316),
    [anon_sym_fileno] = ACTIONS(316),
    [anon_sym_gmtime] = ACTIONS(316),
    [anon_sym_getc] = ACTIONS(316),
    [anon_sym_getpgrp] = ACTIONS(316),
    [anon_sym_getprotobyname] = ACTIONS(316),
    [anon_sym_getpwname] = ACTIONS(316),
    [anon_sym_getpwuid] = ACTIONS(316),
    [anon_sym_getpeername] = ACTIONS(316),
    [anon_sym_getnetbyname] = ACTIONS(316),
    [anon_sym_getsockname] = ACTIONS(316),
    [anon_sym_getgrnam] = ACTIONS(316),
    [anon_sym_getgrgid] = ACTIONS(316),
    [anon_sym_hex] = ACTIONS(316),
    [anon_sym_int] = ACTIONS(316),
    [anon_sym_keys] = ACTIONS(316),
    [anon_sym_lc] = ACTIONS(316),
    [anon_sym_lcfirst] = ACTIONS(316),
    [anon_sym_length] = ACTIONS(316),
    [anon_sym_localtime] = ACTIONS(316),
    [anon_sym_log] = ACTIONS(316),
    [anon_sym_lock] = ACTIONS(316),
    [anon_sym_lstat] = ACTIONS(316),
    [anon_sym_oct] = ACTIONS(316),
    [anon_sym_ord] = ACTIONS(316),
    [anon_sym_prototype] = ACTIONS(316),
    [anon_sym_pop] = ACTIONS(316),
    [anon_sym_pos] = ACTIONS(316),
    [anon_sym_quotemeta] = ACTIONS(316),
    [anon_sym_reset] = ACTIONS(316),
    [anon_sym_rand] = ACTIONS(316),
    [anon_sym_rmdir] = ACTIONS(316),
    [anon_sym_readdir] = ACTIONS(316),
    [anon_sym_readline] = ACTIONS(316),
    [anon_sym_readpipe] = ACTIONS(316),
    [anon_sym_rewinddir] = ACTIONS(316),
    [anon_sym_readlink] = ACTIONS(316),
    [anon_sym_ref] = ACTIONS(316),
    [anon_sym_scalar] = ACTIONS(316),
    [anon_sym_shift] = ACTIONS(316),
    [anon_sym_sin] = ACTIONS(316),
    [anon_sym_sleep] = ACTIONS(316),
    [anon_sym_sqrt] = ACTIONS(316),
    [anon_sym_srand] = ACTIONS(316),
    [anon_sym_stat] = ACTIONS(316),
    [anon_sym_study] = ACTIONS(316),
    [anon_sym_tell] = ACTIONS(316),
    [anon_sym_telldir] = ACTIONS(316),
    [anon_sym_tied] = ACTIONS(316),
    [anon_sym_uc] = ACTIONS(316),
    [anon_sym_ucfirst] = ACTIONS(316),
    [anon_sym_untie] = ACTIONS(316),
    [anon_sym_umask] = ACTIONS(316),
    [anon_sym_values] = ACTIONS(316),
    [anon_sym_write] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(318),
    [anon_sym_qq] = ACTIONS(320),
    [anon_sym_qw] = ACTIONS(322),
    [anon_sym_qx] = ACTIONS(324),
    [anon_sym_qr] = ACTIONS(326),
    [anon_sym_m] = ACTIONS(328),
    [anon_sym_s] = ACTIONS(330),
    [anon_sym_tr] = ACTIONS(332),
    [anon_sym_y] = ACTIONS(332),
    [aux_sym__bareword_token1] = ACTIONS(334),
    [sym_number] = ACTIONS(336),
    [anon_sym_true] = ACTIONS(338),
    [anon_sym_false] = ACTIONS(338),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(340),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(342),
    [sym__filetest] = ACTIONS(344),
  },
  [21] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(21),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3520),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(111),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(401),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(429),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(439),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(441),
  },
  [22] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(22),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3471),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(111),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(443),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(445),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(447),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(449),
  },
  [23] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(23),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3695),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(92),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(451),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(453),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(455),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(457),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(459),
  },
  [24] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(24),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3481),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(81),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(461),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(465),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(467),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(469),
  },
  [25] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(25),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3471),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(85),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(443),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(471),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(445),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(447),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(449),
  },
  [26] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(26),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3563),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(91),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(475),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(477),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(479),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(481),
  },
  [27] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(27),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3588),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(101),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(485),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(487),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(489),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(491),
  },
  [28] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(28),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3592),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(103),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(493),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(495),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(497),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(499),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(501),
  },
  [29] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(29),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3596),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(105),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(503),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(505),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(507),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(509),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(511),
  },
  [30] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(30),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3600),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(107),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(513),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(517),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(519),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(521),
  },
  [31] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(31),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3603),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(110),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(523),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(527),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(529),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(531),
  },
  [32] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(32),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3606),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(69),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(533),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(535),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(537),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(539),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(541),
  },
  [33] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(33),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3609),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(113),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(543),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(545),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(547),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(549),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(551),
  },
  [34] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(34),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3612),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(115),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(553),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(555),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(557),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(559),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(561),
  },
  [35] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(35),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3615),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(116),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(563),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(565),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89),
    [aux_sym__var_indirob_autoquote_token1] = ACTIONS(567),
    [anon_sym_use] = ACTIONS(431),
    [anon_sym_no] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_foreach] = ACTIONS(433),
    [anon_sym_last] = ACTIONS(95),
    [anon_sym_next] = ACTIONS(95),
    [anon_sym_redo] = ACTIONS(95),
    [anon_sym_BEGIN] = ACTIONS(435),
    [anon_sym_INIT] = ACTIONS(435),
    [anon_sym_CHECK] = ACTIONS(435),
    [anon_sym_UNITCHECK] = ACTIONS(435),
    [anon_sym_END] = ACTIONS(435),
    [anon_sym___FILE__] = ACTIONS(39),
    [anon_sym___LINE__] = ACTIONS(39),
    [anon_sym___PACKAGE__] = ACTIONS(39),
    [anon_sym___SUB__] = ACTIONS(39),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_fork] = ACTIONS(39),
    [anon_sym_getppid] = ACTIONS(39),
    [anon_sym_time] = ACTIONS(39),
    [anon_sym_times] = ACTIONS(39),
    [anon_sym_wait] = ACTIONS(39),
    [anon_sym_wantarray] = ACTIONS(39),
    [anon_sym_abs] = ACTIONS(99),
    [anon_sym_alarm] = ACTIONS(99),
    [anon_sym_chop] = ACTIONS(99),
    [anon_sym_chdir] = ACTIONS(99),
    [anon_sym_close] = ACTIONS(99),
    [anon_sym_closedir] = ACTIONS(99),
    [anon_sym_caller] = ACTIONS(99),
    [anon_sym_chomp] = ACTIONS(99),
    [anon_sym_chr] = ACTIONS(99),
    [anon_sym_cos] = ACTIONS(99),
    [anon_sym_chroot] = ACTIONS(99),
    [anon_sym_defined] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(99),
    [anon_sym_dbmclose] = ACTIONS(99),
    [anon_sym_exists] = ACTIONS(99),
    [anon_sym_exit] = ACTIONS(99),
    [anon_sym_eof] = ACTIONS(99),
    [anon_sym_exp] = ACTIONS(99),
    [anon_sym_each] = ACTIONS(99),
    [anon_sym_fc] = ACTIONS(99),
    [anon_sym_fileno] = ACTIONS(99),
    [anon_sym_gmtime] = ACTIONS(99),
    [anon_sym_getc] = ACTIONS(99),
    [anon_sym_getpgrp] = ACTIONS(99),
    [anon_sym_getprotobyname] = ACTIONS(99),
    [anon_sym_getpwname] = ACTIONS(99),
    [anon_sym_getpwuid] = ACTIONS(99),
    [anon_sym_getpeername] = ACTIONS(99),
    [anon_sym_getnetbyname] = ACTIONS(99),
    [anon_sym_getsockname] = ACTIONS(99),
    [anon_sym_getgrnam] = ACTIONS(99),
    [anon_sym_getgrgid] = ACTIONS(99),
    [anon_sym_hex] = ACTIONS(99),
    [anon_sym_int] = ACTIONS(99),
    [anon_sym_keys] = ACTIONS(99),
    [anon_sym_lc] = ACTIONS(99),
    [anon_sym_lcfirst] = ACTIONS(99),
    [anon_sym_length] = ACTIONS(99),
    [anon_sym_localtime] = ACTIONS(99),
    [anon_sym_log] = ACTIONS(99),
    [anon_sym_lock] = ACTIONS(99),
    [anon_sym_lstat] = ACTIONS(99),
    [anon_sym_oct] = ACTIONS(99),
    [anon_sym_ord] = ACTIONS(99),
    [anon_sym_prototype] = ACTIONS(99),
    [anon_sym_pop] = ACTIONS(99),
    [anon_sym_pos] = ACTIONS(99),
    [anon_sym_quotemeta] = ACTIONS(99),
    [anon_sym_reset] = ACTIONS(99),
    [anon_sym_rand] = ACTIONS(99),
    [anon_sym_rmdir] = ACTIONS(99),
    [anon_sym_readdir] = ACTIONS(99),
    [anon_sym_readline] = ACTIONS(99),
    [anon_sym_readpipe] = ACTIONS(99),
    [anon_sym_rewinddir] = ACTIONS(99),
    [anon_sym_readlink] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(99),
    [anon_sym_scalar] = ACTIONS(99),
    [anon_sym_shift] = ACTIONS(99),
    [anon_sym_sin] = ACTIONS(99),
    [anon_sym_sleep] = ACTIONS(99),
    [anon_sym_sqrt] = ACTIONS(99),
    [anon_sym_srand] = ACTIONS(99),
    [anon_sym_stat] = ACTIONS(99),
    [anon_sym_study] = ACTIONS(99),
    [anon_sym_tell] = ACTIONS(99),
    [anon_sym_telldir] = ACTIONS(99),
    [anon_sym_tied] = ACTIONS(99),
    [anon_sym_uc] = ACTIONS(99),
    [anon_sym_ucfirst] = ACTIONS(99),
    [anon_sym_untie] = ACTIONS(99),
    [anon_sym_umask] = ACTIONS(99),
    [anon_sym_values] = ACTIONS(99),
    [anon_sym_write] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [anon_sym_q] = ACTIONS(105),
    [anon_sym_qq] = ACTIONS(107),
    [anon_sym_qw] = ACTIONS(109),
    [anon_sym_qx] = ACTIONS(111),
    [anon_sym_qr] = ACTIONS(113),
    [anon_sym_m] = ACTIONS(115),
    [anon_sym_s] = ACTIONS(117),
    [anon_sym_tr] = ACTIONS(119),
    [anon_sym_y] = ACTIONS(119),
    [anon_sym_if] = ACTIONS(121),
    [anon_sym_unless] = ACTIONS(121),
    [anon_sym_while] = ACTIONS(123),
    [anon_sym_until] = ACTIONS(123),
    [aux_sym__ident_special_token1] = ACTIONS(437),
    [aux_sym__bareword_token1] = ACTIONS(569),
    [sym_number] = ACTIONS(127),
    [anon_sym_true] = ACTIONS(129),
    [anon_sym_false] = ACTIONS(129),
    [sym__single_quote] = ACTIONS(131),
    [sym__double_quote] = ACTIONS(133),
    [sym__backtick_quote] = ACTIONS(135),
    [sym__search_slash_quote] = ACTIONS(137),
    [sym__PERLY_HEREDOC] = ACTIONS(139),
    [sym_pod] = ACTIONS(5),
    [sym__heredoc_start] = ACTIONS(7),
    [sym__fat_comma_autoquoted] = ACTIONS(143),
    [sym__filetest] = ACTIONS(145),
    [sym__brace_autoquoted_token] = ACTIONS(571),
  },
  [36] = {
    [sym__PERLY_BRACE_OPEN] = STATE(61),
    [sym_block] = STATE(960),
    [sym__fullstmt] = STATE(961),
    [sym_statement_label] = STATE(962),
    [sym__barestmt] = STATE(962),
    [sym_package_statement] = STATE(927),
    [sym_class_statement] = STATE(927),
    [sym_role_statement] = STATE(927),
    [sym_class_phaser_statement] = STATE(927),
    [sym_use_version_statement] = STATE(927),
    [sym_use_statement] = STATE(927),
    [sym_subroutine_declaration_statement] = STATE(927),
    [sym_method_declaration_statement] = STATE(927),
    [sym_phaser_statement] = STATE(927),
    [sym_conditional_statement] = STATE(927),
    [sym_loop_statement] = STATE(927),
    [sym_cstyle_for_statement] = STATE(927),
    [sym_for_statement] = STATE(927),
    [sym_try_statement] = STATE(927),
    [sym_defer_statement] = STATE(927),
    [sym_expression_statement] = STATE(2723),
    [sym__postfix_expressions] = STATE(2880),
    [sym_postfix_conditional_expression] = STATE(2882),
    [sym_postfix_loop_expression] = STATE(2882),
    [sym_postfix_for_expression] = STATE(2882),
    [sym_yadayada] = STATE(2880),
    [sym__expr] = STATE(2321),
    [sym_lowprec_logical_expression] = STATE(2323),
    [sym__listexpr] = STATE(2323),
    [sym__term_rightward] = STATE(2324),
    [sym_list_expression] = STATE(2327),
    [sym__subscripted] = STATE(1032),
    [sym_container_variable] = STATE(3406),
    [sym_array_element_expression] = STATE(1025),
    [sym_hash_element_expression] = STATE(1025),
    [sym_coderef_call_expression] = STATE(1025),
    [sym_anonymous_slice_expression] = STATE(1025),
    [sym_slice_container_variable] = STATE(3405),
    [sym_slice_expression] = STATE(1173),
    [sym_keyval_container_variable] = STATE(3415),
    [sym_keyval_expression] = STATE(1173),
    [sym__term] = STATE(1089),
    [sym_readline_expression] = STATE(1173),
    [sym_assignment_expression] = STATE(1173),
    [sym_binary_expression] = STATE(1173),
    [sym_equality_expression] = STATE(1173),
    [sym_relational_expression] = STATE(1173),
    [sym_unary_expression] = STATE(1173),
    [sym_preinc_expression] = STATE(1173),
    [sym_postinc_expression] = STATE(1173),
    [sym_conditional_expression] = STATE(1173),
    [sym_refgen_expression] = STATE(1173),
    [sym_anonymous_array_expression] = STATE(1173),
    [sym_anonymous_hash_expression] = STATE(1173),
    [sym_anonymous_subroutine_expression] = STATE(1173),
    [sym_anonymous_method_expression] = STATE(1173),
    [sym_do_expression] = STATE(1173),
    [sym_eval_expression] = STATE(1173),
    [sym_await_expression] = STATE(1173),
    [sym_variable_declaration] = STATE(1173),
    [sym_localization_expression] = STATE(1173),
    [sym_stub_expression] = STATE(1173),
    [sym_scalar_deref_expression] = STATE(1173),
    [sym_array_deref_expression] = STATE(1173),
    [sym_hash_deref_expression] = STATE(1173),
    [sym_amper_deref_expression] = STATE(1173),
    [sym_glob_deref_expression] = STATE(1173),
    [sym_require_expression] = STATE(1173),
    [sym_func0op_call_expression] = STATE(1173),
    [sym_func1op_call_expression] = STATE(1173),
    [sym_map_grep_expression] = STATE(1173),
    [sym_sort_expression] = STATE(1173),
    [sym_loopex_expression] = STATE(1173),
    [sym_goto_expression] = STATE(1173),
    [sym_return_expression] = STATE(1173),
    [sym_undef_expression] = STATE(1173),
    [sym__listop] = STATE(1173),
    [sym_function_call_expression] = STATE(1099),
    [sym_ambiguous_function_call_expression] = STATE(1099),
    [sym_function] = STATE(375),
    [sym_method_call_expression] = STATE(1099),
    [sym_scalar] = STATE(1173),
    [sym_array] = STATE(1173),
    [sym_hash] = STATE(1173),
    [sym_arraylen] = STATE(1173),
    [sym_glob] = STATE(1173),
    [sym__literal] = STATE(1173),
    [sym__apostrophe] = STATE(2916),
    [sym__quotation_mark] = STATE(2294),
    [sym__backtick] = STATE(2296),
    [sym__search_slash] = STATE(2235),
    [sym_string_literal] = STATE(1115),
    [sym_interpolated_string_literal] = STATE(1115),
    [sym_quoted_word_list] = STATE(1068),
    [sym_command_string] = STATE(1115),
    [sym_quoted_regexp] = STATE(1115),
    [sym_match_regexp] = STATE(1115),
    [sym_substitution_regexp] = STATE(1115),
    [sym_transliteration_expression] = STATE(1115),
    [sym_heredoc_token] = STATE(1173),
    [sym_command_heredoc_token] = STATE(1173),
    [sym_heredoc_content] = STATE(36),
    [sym__conditionals] = STATE(3693),
    [sym__loops] = STATE(3694),
    [sym_autoquoted_bareword] = STATE(1173),
    [sym_identifier] = STATE(3629),
    [sym__ident_special] = STATE(3618),
    [sym_bareword] = STATE(1173),
    [sym_primitive] = STATE(1173),
    [sym_boolean] = STATE(1223),
    [aux_sym_source_file_repeat1] = STATE(117),
    [aux_sym_subroutine_declaration_statement_repeat1] = STATE(3015),
    [sym__identifier] = ACTIONS(573),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_package] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(409),
    [anon_sym_role] = ACTIONS(411),
    [anon_sym_BUILD] = ACTIONS(413),
    [anon_sym_ADJUST] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(27),
    [anon_sym_my] = ACTIONS(417),
    [anon_sym_extended] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_sub] = ACTIONS(419),
    [anon_sym_method] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_continue] = ACTIONS(39),
    [anon_sym_state] = ACTIONS(41),
    [anon_sym_our] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(423),
    [anon_sym_defer] = ACTIONS(425),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(49),
    [anon_sym_LT] = ACTIONS(51),
    [anon_sym_LT_LT] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(57),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_eval] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [anon_sym_field] = ACTIONS(41),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_dynamically] = ACTIONS(73),
    [anon_sym_require] = ACTIONS(75),
    [anon_sym_map] = ACTIONS(77),
    [anon_sym_grep] = ACTIONS(77),
    [anon_sym_sort] = ACTIONS(79),
    [anon_sym_goto] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(83),
    [anon_sym_undef] = ACTIONS(85),
    [anon_sym_PERCENT2] = ACTIONS(87),
    [anon_sym_DOLLAR_POUND] = ACTIONS(89