#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 350
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 145
#define ALIAS_COUNT 7
#define TOKEN_COUNT 61
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 5
#define PRODUCTION_ID_COUNT 11

enum {
  anon_sym_DOLLAR = 1,
  anon_sym_COLON = 2,
  anon_sym_metadata = 3,
  anon_sym_EQ = 4,
  anon_sym_namespace = 5,
  anon_sym_DOT = 6,
  anon_sym_use = 7,
  anon_sym_POUND = 8,
  anon_sym_enum = 9,
  anon_sym_intEnum = 10,
  anon_sym_LBRACE = 11,
  anon_sym_RBRACE = 12,
  anon_sym_list = 13,
  anon_sym_map = 14,
  anon_sym_set = 15,
  anon_sym_structure = 16,
  anon_sym_union = 17,
  anon_sym_service = 18,
  anon_sym_operation = 19,
  anon_sym_resource = 20,
  anon_sym_COMMA = 21,
  anon_sym_LBRACK = 22,
  anon_sym_RBRACK = 23,
  anon_sym_COLON_EQ = 24,
  anon_sym_AT = 25,
  anon_sym_LPAREN = 26,
  anon_sym_RPAREN = 27,
  anon_sym_apply = 28,
  anon_sym_with = 29,
  anon_sym_for = 30,
  anon_sym_blob = 31,
  anon_sym_boolean = 32,
  anon_sym_byte = 33,
  anon_sym_document = 34,
  anon_sym_double = 35,
  anon_sym_float = 36,
  anon_sym_integer = 37,
  anon_sym_long = 38,
  anon_sym_short = 39,
  anon_sym_string = 40,
  anon_sym_timestamp = 41,
  anon_sym_bigInteger = 42,
  anon_sym_bigDecimal = 43,
  anon_sym_true = 44,
  anon_sym_false = 45,
  sym_null = 46,
  anon_sym_DASH = 47,
  aux_sym_number_token1 = 48,
  aux_sym_float_token1 = 49,
  anon_sym_DQUOTE = 50,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 51,
  sym_string_fragment = 52,
  aux_sym__multiline_string_fragment_token1 = 53,
  aux_sym__multiline_string_fragment_token2 = 54,
  aux_sym__escape_sequence_token1 = 55,
  sym_escape_sequence = 56,
  aux_sym_identifier_token1 = 57,
  sym_comment = 58,
  anon_sym_SLASH_SLASH_SLASH = 59,
  aux_sym_documentation_comment_token1 = 60,
  sym_source_file = 61,
  sym_control_section = 62,
  sym_control_statement = 63,
  sym_control_var_name = 64,
  sym_metadata_section = 65,
  sym_metadata_statement = 66,
  sym_shape_section = 67,
  sym_namespace_statement = 68,
  sym_namespace = 69,
  sym__definition = 70,
  sym_use_statement = 71,
  sym_shape_statement = 72,
  sym_shape_body = 73,
  sym_absolute_root_shape_id = 74,
  sym_root_shape_id = 75,
  sym_shape_id_member = 76,
  sym_shape_id = 77,
  sym_simple_shape_statement = 78,
  sym_enum_statement = 79,
  sym_enum_members = 80,
  sym_enum_member = 81,
  sym_list_statement = 82,
  sym_map_statement = 83,
  sym_set_statement = 84,
  sym_structure_statement = 85,
  sym_union_statement = 86,
  sym_service_statement = 87,
  sym_operation_statement = 88,
  sym_resource_statement = 89,
  sym_shape_members = 90,
  sym_shape_member = 91,
  sym_shape_member_elided = 92,
  sym_operation_body = 93,
  sym_operation_member = 94,
  sym_operation_errors = 95,
  sym_operation_error = 96,
  sym_inline_structure = 97,
  sym_trait_statement = 98,
  sym_trait_body = 99,
  sym_trait_body_value = 100,
  sym_trait_structure = 101,
  sym_apply_statement = 102,
  sym_apply_statement_singular = 103,
  sym_apply_statement_block = 104,
  sym_mixins = 105,
  sym_structure_resource = 106,
  sym_value_assignment = 107,
  sym_node_value = 108,
  sym_node_array = 109,
  sym_node_object = 110,
  sym_node_object_kvp = 111,
  sym_node_object_key = 112,
  sym_literal = 113,
  sym_primitive = 114,
  sym_boolean = 115,
  sym_number = 116,
  sym_float = 117,
  sym_string = 118,
  sym__string_literal = 119,
  sym__multiline_string_literal = 120,
  sym__multiline_string_fragment = 121,
  sym__escape_sequence = 122,
  sym_identifier = 123,
  sym__control_identifier = 124,
  sym__namespace_identifier = 125,
  sym_documentation_comment = 126,
  aux_sym_control_section_repeat1 = 127,
  aux_sym_metadata_section_repeat1 = 128,
  aux_sym_shape_section_repeat1 = 129,
  aux_sym_namespace_repeat1 = 130,
  aux_sym_shape_statement_repeat1 = 131,
  aux_sym_shape_id_repeat1 = 132,
  aux_sym_enum_members_repeat1 = 133,
  aux_sym_shape_members_repeat1 = 134,
  aux_sym_operation_body_repeat1 = 135,
  aux_sym_operation_member_repeat1 = 136,
  aux_sym_operation_errors_repeat1 = 137,
  aux_sym_trait_structure_repeat1 = 138,
  aux_sym_mixins_repeat1 = 139,
  aux_sym_node_array_repeat1 = 140,
  aux_sym_node_object_repeat1 = 141,
  aux_sym__string_literal_repeat1 = 142,
  aux_sym__multiline_string_literal_repeat1 = 143,
  aux_sym__multiline_string_fragment_repeat1 = 144,
  alias_sym_enum_field = 145,
  alias_sym_field = 146,
  alias_sym_key_identifier = 147,
  alias_sym_operation_error_field = 148,
  alias_sym_operation_field = 149,
  alias_sym_trait_node_value = 150,
  alias_sym_trait_object_kvp = 151,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_COLON] = ":",
  [anon_sym_metadata] = "metadata",
  [anon_sym_EQ] = "=",
  [anon_sym_namespace] = "namespace",
  [anon_sym_DOT] = ".",
  [anon_sym_use] = "use",
  [anon_sym_POUND] = "#",
  [anon_sym_enum] = "enum",
  [anon_sym_intEnum] = "intEnum",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_list] = "list",
  [anon_sym_map] = "map",
  [anon_sym_set] = "set",
  [anon_sym_structure] = "structure",
  [anon_sym_union] = "union",
  [anon_sym_service] = "service",
  [anon_sym_operation] = "operation",
  [anon_sym_resource] = "resource",
  [anon_sym_COMMA] = ",",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_AT] = "@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_apply] = "apply",
  [anon_sym_with] = "with",
  [anon_sym_for] = "for",
  [anon_sym_blob] = "blob",
  [anon_sym_boolean] = "boolean",
  [anon_sym_byte] = "byte",
  [anon_sym_document] = "document",
  [anon_sym_double] = "double",
  [anon_sym_float] = "float",
  [anon_sym_integer] = "integer",
  [anon_sym_long] = "long",
  [anon_sym_short] = "short",
  [anon_sym_string] = "string",
  [anon_sym_timestamp] = "timestamp",
  [anon_sym_bigInteger] = "bigInteger",
  [anon_sym_bigDecimal] = "bigDecimal",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_null] = "null",
  [anon_sym_DASH] = "-",
  [aux_sym_number_token1] = "number_token1",
  [aux_sym_float_token1] = "float_token1",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [sym_string_fragment] = "string_fragment",
  [aux_sym__multiline_string_fragment_token1] = "_multiline_string_fragment_token1",
  [aux_sym__multiline_string_fragment_token2] = "_multiline_string_fragment_token2",
  [aux_sym__escape_sequence_token1] = "_escape_sequence_token1",
  [sym_escape_sequence] = "escape_sequence",
  [aux_sym_identifier_token1] = "identifier_token1",
  [sym_comment] = "comment",
  [anon_sym_SLASH_SLASH_SLASH] = "///",
  [aux_sym_documentation_comment_token1] = "documentation_comment_token1",
  [sym_source_file] = "source_file",
  [sym_control_section] = "control_section",
  [sym_control_statement] = "control_statement",
  [sym_control_var_name] = "control_var_name",
  [sym_metadata_section] = "metadata_section",
  [sym_metadata_statement] = "metadata_statement",
  [sym_shape_section] = "shape_section",
  [sym_namespace_statement] = "namespace_statement",
  [sym_namespace] = "namespace",
  [sym__definition] = "_definition",
  [sym_use_statement] = "use_statement",
  [sym_shape_statement] = "shape_statement",
  [sym_shape_body] = "shape_body",
  [sym_absolute_root_shape_id] = "absolute_root_shape_id",
  [sym_root_shape_id] = "root_shape_id",
  [sym_shape_id_member] = "shape_id_member",
  [sym_shape_id] = "shape_id",
  [sym_simple_shape_statement] = "simple_shape_statement",
  [sym_enum_statement] = "enum_statement",
  [sym_enum_members] = "enum_members",
  [sym_enum_member] = "enum_member",
  [sym_list_statement] = "list_statement",
  [sym_map_statement] = "map_statement",
  [sym_set_statement] = "set_statement",
  [sym_structure_statement] = "structure_statement",
  [sym_union_statement] = "union_statement",
  [sym_service_statement] = "service_statement",
  [sym_operation_statement] = "operation_statement",
  [sym_resource_statement] = "resource_statement",
  [sym_shape_members] = "shape_members",
  [sym_shape_member] = "shape_member",
  [sym_shape_member_elided] = "shape_member_elided",
  [sym_operation_body] = "operation_body",
  [sym_operation_member] = "operation_member",
  [sym_operation_errors] = "operation_errors",
  [sym_operation_error] = "operation_error",
  [sym_inline_structure] = "inline_structure",
  [sym_trait_statement] = "trait_statement",
  [sym_trait_body] = "trait_body",
  [sym_trait_body_value] = "trait_body_value",
  [sym_trait_structure] = "trait_structure",
  [sym_apply_statement] = "apply_statement",
  [sym_apply_statement_singular] = "apply_statement_singular",
  [sym_apply_statement_block] = "apply_statement_block",
  [sym_mixins] = "mixins",
  [sym_structure_resource] = "structure_resource",
  [sym_value_assignment] = "value_assignment",
  [sym_node_value] = "node_value",
  [sym_node_array] = "node_array",
  [sym_node_object] = "node_object",
  [sym_node_object_kvp] = "node_object_kvp",
  [sym_node_object_key] = "node_object_key",
  [sym_literal] = "literal",
  [sym_primitive] = "primitive",
  [sym_boolean] = "boolean",
  [sym_number] = "number",
  [sym_float] = "float",
  [sym_string] = "string",
  [sym__string_literal] = "_string_literal",
  [sym__multiline_string_literal] = "_multiline_string_literal",
  [sym__multiline_string_fragment] = "multiline_string_fragment",
  [sym__escape_sequence] = "_escape_sequence",
  [sym_identifier] = "identifier",
  [sym__control_identifier] = "control_key",
  [sym__namespace_identifier] = "_namespace_identifier",
  [sym_documentation_comment] = "documentation_comment",
  [aux_sym_control_section_repeat1] = "control_section_repeat1",
  [aux_sym_metadata_section_repeat1] = "metadata_section_repeat1",
  [aux_sym_shape_section_repeat1] = "shape_section_repeat1",
  [aux_sym_namespace_repeat1] = "namespace_repeat1",
  [aux_sym_shape_statement_repeat1] = "shape_statement_repeat1",
  [aux_sym_shape_id_repeat1] = "shape_id_repeat1",
  [aux_sym_enum_members_repeat1] = "enum_members_repeat1",
  [aux_sym_shape_members_repeat1] = "shape_members_repeat1",
  [aux_sym_operation_body_repeat1] = "operation_body_repeat1",
  [aux_sym_operation_member_repeat1] = "operation_member_repeat1",
  [aux_sym_operation_errors_repeat1] = "operation_errors_repeat1",
  [aux_sym_trait_structure_repeat1] = "trait_structure_repeat1",
  [aux_sym_mixins_repeat1] = "mixins_repeat1",
  [aux_sym_node_array_repeat1] = "node_array_repeat1",
  [aux_sym_node_object_repeat1] = "node_object_repeat1",
  [aux_sym__string_literal_repeat1] = "_string_literal_repeat1",
  [aux_sym__multiline_string_literal_repeat1] = "_multiline_string_literal_repeat1",
  [aux_sym__multiline_string_fragment_repeat1] = "_multiline_string_fragment_repeat1",
  [alias_sym_enum_field] = "enum_field",
  [alias_sym_field] = "field",
  [alias_sym_key_identifier] = "key_identifier",
  [alias_sym_operation_error_field] = "operation_error_field",
  [alias_sym_operation_field] = "operation_field",
  [alias_sym_trait_node_value] = "trait_node_value",
  [alias_sym_trait_object_kvp] = "trait_object_kvp",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_metadata] = anon_sym_metadata,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_intEnum] = anon_sym_intEnum,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_list] = anon_sym_list,
  [anon_sym_map] = anon_sym_map,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_structure] = anon_sym_structure,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_service] = anon_sym_service,
  [anon_sym_operation] = anon_sym_operation,
  [anon_sym_resource] = anon_sym_resource,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_apply] = anon_sym_apply,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_blob] = anon_sym_blob,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_document] = anon_sym_document,
  [anon_sym_double] = anon_sym_double,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_integer] = anon_sym_integer,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_timestamp] = anon_sym_timestamp,
  [anon_sym_bigInteger] = anon_sym_bigInteger,
  [anon_sym_bigDecimal] = anon_sym_bigDecimal,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_null] = sym_null,
  [anon_sym_DASH] = anon_sym_DASH,
  [aux_sym_number_token1] = aux_sym_number_token1,
  [aux_sym_float_token1] = aux_sym_float_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [sym_string_fragment] = sym_string_fragment,
  [aux_sym__multiline_string_fragment_token1] = aux_sym__multiline_string_fragment_token1,
  [aux_sym__multiline_string_fragment_token2] = aux_sym__multiline_string_fragment_token2,
  [aux_sym__escape_sequence_token1] = aux_sym__escape_sequence_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [sym_comment] = sym_comment,
  [anon_sym_SLASH_SLASH_SLASH] = anon_sym_SLASH_SLASH_SLASH,
  [aux_sym_documentation_comment_token1] = aux_sym_documentation_comment_token1,
  [sym_source_file] = sym_source_file,
  [sym_control_section] = sym_control_section,
  [sym_control_statement] = sym_control_statement,
  [sym_control_var_name] = sym_control_var_name,
  [sym_metadata_section] = sym_metadata_section,
  [sym_metadata_statement] = sym_metadata_statement,
  [sym_shape_section] = sym_shape_section,
  [sym_namespace_statement] = sym_namespace_statement,
  [sym_namespace] = sym_namespace,
  [sym__definition] = sym__definition,
  [sym_use_statement] = sym_use_statement,
  [sym_shape_statement] = sym_shape_statement,
  [sym_shape_body] = sym_shape_body,
  [sym_absolute_root_shape_id] = sym_absolute_root_shape_id,
  [sym_root_shape_id] = sym_root_shape_id,
  [sym_shape_id_member] = sym_shape_id_member,
  [sym_shape_id] = sym_shape_id,
  [sym_simple_shape_statement] = sym_simple_shape_statement,
  [sym_enum_statement] = sym_enum_statement,
  [sym_enum_members] = sym_enum_members,
  [sym_enum_member] = sym_enum_member,
  [sym_list_statement] = sym_list_statement,
  [sym_map_statement] = sym_map_statement,
  [sym_set_statement] = sym_set_statement,
  [sym_structure_statement] = sym_structure_statement,
  [sym_union_statement] = sym_union_statement,
  [sym_service_statement] = sym_service_statement,
  [sym_operation_statement] = sym_operation_statement,
  [sym_resource_statement] = sym_resource_statement,
  [sym_shape_members] = sym_shape_members,
  [sym_shape_member] = sym_shape_member,
  [sym_shape_member_elided] = sym_shape_member_elided,
  [sym_operation_body] = sym_operation_body,
  [sym_operation_member] = sym_operation_member,
  [sym_operation_errors] = sym_operation_errors,
  [sym_operation_error] = sym_operation_error,
  [sym_inline_structure] = sym_inline_structure,
  [sym_trait_statement] = sym_trait_statement,
  [sym_trait_body] = sym_trait_body,
  [sym_trait_body_value] = sym_trait_body_value,
  [sym_trait_structure] = sym_trait_structure,
  [sym_apply_statement] = sym_apply_statement,
  [sym_apply_statement_singular] = sym_apply_statement_singular,
  [sym_apply_statement_block] = sym_apply_statement_block,
  [sym_mixins] = sym_mixins,
  [sym_structure_resource] = sym_structure_resource,
  [sym_value_assignment] = sym_value_assignment,
  [sym_node_value] = sym_node_value,
  [sym_node_array] = sym_node_array,
  [sym_node_object] = sym_node_object,
  [sym_node_object_kvp] = sym_node_object_kvp,
  [sym_node_object_key] = sym_node_object_key,
  [sym_literal] = sym_literal,
  [sym_primitive] = sym_primitive,
  [sym_boolean] = sym_boolean,
  [sym_number] = sym_number,
  [sym_float] = sym_float,
  [sym_string] = sym_string,
  [sym__string_literal] = sym__string_literal,
  [sym__multiline_string_literal] = sym__multiline_string_literal,
  [sym__multiline_string_fragment] = sym__multiline_string_fragment,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym_identifier] = sym_identifier,
  [sym__control_identifier] = sym__control_identifier,
  [sym__namespace_identifier] = sym__namespace_identifier,
  [sym_documentation_comment] = sym_documentation_comment,
  [aux_sym_control_section_repeat1] = aux_sym_control_section_repeat1,
  [aux_sym_metadata_section_repeat1] = aux_sym_metadata_section_repeat1,
  [aux_sym_shape_section_repeat1] = aux_sym_shape_section_repeat1,
  [aux_sym_namespace_repeat1] = aux_sym_namespace_repeat1,
  [aux_sym_shape_statement_repeat1] = aux_sym_shape_statement_repeat1,
  [aux_sym_shape_id_repeat1] = aux_sym_shape_id_repeat1,
  [aux_sym_enum_members_repeat1] = aux_sym_enum_members_repeat1,
  [aux_sym_shape_members_repeat1] = aux_sym_shape_members_repeat1,
  [aux_sym_operation_body_repeat1] = aux_sym_operation_body_repeat1,
  [aux_sym_operation_member_repeat1] = aux_sym_operation_member_repeat1,
  [aux_sym_operation_errors_repeat1] = aux_sym_operation_errors_repeat1,
  [aux_sym_trait_structure_repeat1] = aux_sym_trait_structure_repeat1,
  [aux_sym_mixins_repeat1] = aux_sym_mixins_repeat1,
  [aux_sym_node_array_repeat1] = aux_sym_node_array_repeat1,
  [aux_sym_node_object_repeat1] = aux_sym_node_object_repeat1,
  [aux_sym__string_literal_repeat1] = aux_sym__string_literal_repeat1,
  [aux_sym__multiline_string_literal_repeat1] = aux_sym__multiline_string_literal_repeat1,
  [aux_sym__multiline_string_fragment_repeat1] = aux_sym__multiline_string_fragment_repeat1,
  [alias_sym_enum_field] = alias_sym_enum_field,
  [alias_sym_field] = alias_sym_field,
  [alias_sym_key_identifier] = alias_sym_key_identifier,
  [alias_sym_operation_error_field] = alias_sym_operation_error_field,
  [alias_sym_operation_field] = alias_sym_operation_field,
  [alias_sym_trait_node_value] = alias_sym_trait_node_value,
  [alias_sym_trait_object_kvp] = alias_sym_trait_object_kvp,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_metadata] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_intEnum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_structure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_service] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_operation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_resource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_apply] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blob] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_document] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_integer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_timestamp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bigInteger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bigDecimal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_float_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__multiline_string_fragment_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_string_fragment_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_documentation_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_control_section] = {
    .visible = true,
    .named = true,
  },
  [sym_control_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_control_var_name] = {
    .visible = true,
    .named = true,
  },
  [sym_metadata_section] = {
    .visible = true,
    .named = true,
  },
  [sym_metadata_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_shape_section] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym_use_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_shape_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_shape_body] = {
    .visible = true,
    .named = true,
  },
  [sym_absolute_root_shape_id] = {
    .visible = true,
    .named = true,
  },
  [sym_root_shape_id] = {
    .visible = true,
    .named = true,
  },
  [sym_shape_id_member] = {
    .visible = true,
    .named = true,
  },
  [sym_shape_id] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_shape_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_members] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_member] = {
    .visible = true,
    .named = true,
  },
  [sym_list_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_map_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_set_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_structure_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_union_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_service_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_operation_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_shape_members] = {
    .visible = true,
    .named = true,
  },
  [sym_shape_member] = {
    .visible = true,
    .named = true,
  },
  [sym_shape_member_elided] = {
    .visible = true,
    .named = true,
  },
  [sym_operation_body] = {
    .visible = true,
    .named = true,
  },
  [sym_operation_member] = {
    .visible = true,
    .named = true,
  },
  [sym_operation_errors] = {
    .visible = true,
    .named = true,
  },
  [sym_operation_error] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_structure] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_body] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_body_value] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_structure] = {
    .visible = true,
    .named = true,
  },
  [sym_apply_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_apply_statement_singular] = {
    .visible = true,
    .named = true,
  },
  [sym_apply_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_mixins] = {
    .visible = true,
    .named = true,
  },
  [sym_structure_resource] = {
    .visible = true,
    .named = true,
  },
  [sym_value_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_node_value] = {
    .visible = true,
    .named = true,
  },
  [sym_node_array] = {
    .visible = true,
    .named = true,
  },
  [sym_node_object] = {
    .visible = true,
    .named = true,
  },
  [sym_node_object_kvp] = {
    .visible = true,
    .named = true,
  },
  [sym_node_object_key] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__control_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__namespace_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_documentation_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_control_section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_metadata_section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shape_section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_namespace_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shape_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shape_id_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_members_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shape_members_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operation_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operation_member_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operation_errors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trait_structure_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_mixins_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_node_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_node_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_string_fragment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_enum_field] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_field] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_key_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_operation_error_field] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_operation_field] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_trait_node_value] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_trait_object_kvp] = {
    .visible = true,
    .named = true,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [1] = sym__control_identifier,
  },
  [2] = {
    [0] = alias_sym_key_identifier,
  },
  [3] = {
    [0] = alias_sym_enum_field,
  },
  [4] = {
    [0] = alias_sym_trait_node_value,
  },
  [5] = {
    [0] = alias_sym_trait_object_kvp,
  },
  [6] = {
    [1] = alias_sym_enum_field,
  },
  [7] = {
    [0] = alias_sym_field,
  },
  [8] = {
    [0] = alias_sym_operation_field,
  },
  [9] = {
    [1] = alias_sym_field,
  },
  [10] = {
    [0] = alias_sym_operation_error_field,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_node_value, 2,
    sym_node_value,
    alias_sym_trait_node_value,
  sym_node_object_kvp, 2,
    sym_node_object_kvp,
    alias_sym_trait_object_kvp,
  sym_string, 2,
    sym_string,
    sym__control_identifier,
  sym_identifier, 6,
    sym_identifier,
    alias_sym_enum_field,
    alias_sym_field,
    alias_sym_key_identifier,
    alias_sym_operation_error_field,
    alias_sym_operation_field,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 16,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 28,
  [30] = 30,
  [31] = 31,
  [32] = 28,
  [33] = 33,
  [34] = 34,
  [35] = 34,
  [36] = 34,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 39,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 9,
  [82] = 7,
  [83] = 5,
  [84] = 8,
  [85] = 6,
  [86] = 11,
  [87] = 12,
  [88] = 13,
  [89] = 14,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 7,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 19,
  [100] = 5,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 18,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 8,
  [110] = 110,
  [111] = 110,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 110,
  [116] = 116,
  [117] = 117,
  [118] = 113,
  [119] = 113,
  [120] = 9,
  [121] = 12,
  [122] = 6,
  [123] = 13,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 14,
  [128] = 124,
  [129] = 125,
  [130] = 11,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 139,
  [143] = 9,
  [144] = 139,
  [145] = 145,
  [146] = 138,
  [147] = 138,
  [148] = 148,
  [149] = 8,
  [150] = 19,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 97,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 106,
  [162] = 98,
  [163] = 163,
  [164] = 164,
  [165] = 107,
  [166] = 157,
  [167] = 167,
  [168] = 91,
  [169] = 91,
  [170] = 103,
  [171] = 18,
  [172] = 92,
  [173] = 106,
  [174] = 90,
  [175] = 107,
  [176] = 176,
  [177] = 93,
  [178] = 108,
  [179] = 95,
  [180] = 102,
  [181] = 157,
  [182] = 101,
  [183] = 183,
  [184] = 96,
  [185] = 97,
  [186] = 98,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 9,
  [192] = 192,
  [193] = 193,
  [194] = 193,
  [195] = 189,
  [196] = 189,
  [197] = 197,
  [198] = 193,
  [199] = 8,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 92,
  [209] = 90,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 15,
  [216] = 108,
  [217] = 217,
  [218] = 102,
  [219] = 101,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 26,
  [224] = 224,
  [225] = 225,
  [226] = 96,
  [227] = 95,
  [228] = 103,
  [229] = 93,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 217,
  [237] = 211,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 26,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 20,
  [270] = 270,
  [271] = 22,
  [272] = 272,
  [273] = 21,
  [274] = 37,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 275,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 285,
  [288] = 284,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 45,
  [293] = 73,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 275,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 284,
  [309] = 285,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 328,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 336,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 328,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
};

static inline bool sym_escape_sequence_character_set_1(int32_t c) {
  return (c < 'a'
    ? (c < '?'
      ? (c < '\''
        ? c == '"'
        : c <= '\'')
      : (c <= '?' || c == '\\'))
    : (c <= 'b' || (c < 'r'
      ? (c < 'n'
        ? c == 'f'
        : c <= 'n')
      : (c <= 'r' || (c >= 't' && c <= 'v')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(152);
      if (lookahead == '"') ADVANCE(210);
      if (lookahead == '#') ADVANCE(161);
      if (lookahead == '$') ADVANCE(153);
      if (lookahead == '(') ADVANCE(181);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == ',') ADVANCE(174);
      if (lookahead == '-') ADVANCE(205);
      if (lookahead == '.') ADVANCE(159);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(154);
      if (lookahead == '=') ADVANCE(156);
      if (lookahead == '@') ADVANCE(180);
      if (lookahead == '[') ADVANCE(177);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']') ADVANCE(178);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'b') ADVANCE(58);
      if (lookahead == 'd') ADVANCE(92);
      if (lookahead == 'e') ADVANCE(81);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'l') ADVANCE(59);
      if (lookahead == 'm') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(102);
      if (lookahead == 'r') ADVANCE(42);
      if (lookahead == 's') ADVANCE(32);
      if (lookahead == 't') ADVANCE(66);
      if (lookahead == 'u') ADVANCE(85);
      if (lookahead == 'w') ADVANCE(61);
      if (lookahead == '{') ADVANCE(164);
      if (lookahead == '}') ADVANCE(165);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(151)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(210);
      if (lookahead == '#') ADVANCE(161);
      if (lookahead == '$') ADVANCE(153);
      if (lookahead == '(') ADVANCE(181);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == ',') ADVANCE(174);
      if (lookahead == '.') ADVANCE(158);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '=') ADVANCE(156);
      if (lookahead == '@') ADVANCE(180);
      if (lookahead == '[') ADVANCE(177);
      if (lookahead == ']') ADVANCE(178);
      if (lookahead == '}') ADVANCE(165);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(210);
      if (lookahead == '#') ADVANCE(161);
      if (lookahead == '$') ADVANCE(153);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == ',') ADVANCE(174);
      if (lookahead == '-') ADVANCE(205);
      if (lookahead == '.') ADVANCE(159);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '[') ADVANCE(177);
      if (lookahead == ']') ADVANCE(178);
      if (lookahead == 'f') ADVANCE(239);
      if (lookahead == 'n') ADVANCE(248);
      if (lookahead == 't') ADVANCE(245);
      if (lookahead == '{') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(211);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(5);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '/') ADVANCE(221);
      if (lookahead == '\\') ADVANCE(219);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(220);
      if (lookahead != 0) ADVANCE(228);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(230);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(229);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == ',') ADVANCE(216);
      if (lookahead == '/') ADVANCE(215);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(214);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 8:
      if (lookahead == '/') ADVANCE(250);
      END_STATE();
    case 9:
      if (lookahead == 'D') ADVANCE(43);
      if (lookahead == 'I') ADVANCE(90);
      END_STATE();
    case 10:
      if (lookahead == 'E') ADVANCE(91);
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(70);
      if (lookahead == 'l') ADVANCE(94);
      if (lookahead == 'o') ADVANCE(106);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(79);
      if (lookahead == 'u') ADVANCE(71);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(31);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(155);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(100);
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(29);
      END_STATE();
    case 23:
      if (lookahead == 'b') ADVANCE(186);
      END_STATE();
    case 24:
      if (lookahead == 'b') ADVANCE(73);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(63);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(132);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(38);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(39);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(40);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(135);
      if (lookahead == 'u') ADVANCE(24);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(21);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(107);
      if (lookahead == 'h') ADVANCE(97);
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(160);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(199);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(201);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(169);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(19);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 52:
      if (lookahead == 'g') ADVANCE(9);
      END_STATE();
    case 53:
      if (lookahead == 'g') ADVANCE(193);
      END_STATE();
    case 54:
      if (lookahead == 'g') ADVANCE(195);
      END_STATE();
    case 55:
      if (lookahead == 'g') ADVANCE(47);
      END_STATE();
    case 56:
      if (lookahead == 'g') ADVANCE(48);
      END_STATE();
    case 57:
      if (lookahead == 'h') ADVANCE(184);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(52);
      if (lookahead == 'l') ADVANCE(93);
      if (lookahead == 'o') ADVANCE(96);
      if (lookahead == 'y') ADVANCE(127);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(116);
      if (lookahead == 'o') ADVANCE(86);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(27);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(121);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(88);
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(80);
      if (lookahead == 'r') ADVANCE(137);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(141);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(203);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(198);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 71:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 72:
      if (lookahead == 'l') ADVANCE(45);
      END_STATE();
    case 73:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 74:
      if (lookahead == 'm') ADVANCE(162);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(163);
      END_STATE();
    case 76:
      if (lookahead == 'm') ADVANCE(101);
      END_STATE();
    case 77:
      if (lookahead == 'm') ADVANCE(17);
      END_STATE();
    case 78:
      if (lookahead == 'm') ADVANCE(50);
      END_STATE();
    case 79:
      if (lookahead == 'm') ADVANCE(46);
      END_STATE();
    case 80:
      if (lookahead == 'm') ADVANCE(49);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(134);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(187);
      END_STATE();
    case 84:
      if (lookahead == 'n') ADVANCE(172);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(64);
      if (lookahead == 's') ADVANCE(33);
      END_STATE();
    case 86:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 87:
      if (lookahead == 'n') ADVANCE(120);
      END_STATE();
    case 88:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 89:
      if (lookahead == 'n') ADVANCE(125);
      END_STATE();
    case 90:
      if (lookahead == 'n') ADVANCE(130);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 92:
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 93:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 94:
      if (lookahead == 'o') ADVANCE(16);
      END_STATE();
    case 95:
      if (lookahead == 'o') ADVANCE(138);
      END_STATE();
    case 96:
      if (lookahead == 'o') ADVANCE(72);
      END_STATE();
    case 97:
      if (lookahead == 'o') ADVANCE(111);
      END_STATE();
    case 98:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 99:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 100:
      if (lookahead == 'p') ADVANCE(167);
      END_STATE();
    case 101:
      if (lookahead == 'p') ADVANCE(196);
      END_STATE();
    case 102:
      if (lookahead == 'p') ADVANCE(44);
      END_STATE();
    case 103:
      if (lookahead == 'p') ADVANCE(104);
      END_STATE();
    case 104:
      if (lookahead == 'p') ADVANCE(67);
      END_STATE();
    case 105:
      if (lookahead == 'p') ADVANCE(22);
      END_STATE();
    case 106:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 107:
      if (lookahead == 'r') ADVANCE(140);
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 108:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 109:
      if (lookahead == 'r') ADVANCE(192);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(197);
      END_STATE();
    case 111:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 112:
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(20);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 115:
      if (lookahead == 's') ADVANCE(105);
      END_STATE();
    case 116:
      if (lookahead == 's') ADVANCE(122);
      END_STATE();
    case 117:
      if (lookahead == 's') ADVANCE(95);
      END_STATE();
    case 118:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 119:
      if (lookahead == 's') ADVANCE(128);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(10);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(189);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(34);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(18);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(14);
      END_STATE();
    case 130:
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(65);
      END_STATE();
    case 132:
      if (lookahead == 't') ADVANCE(139);
      END_STATE();
    case 133:
      if (lookahead == 'u') ADVANCE(142);
      if (lookahead == 'x') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(232);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(235);
      if (lookahead != 0) ADVANCE(231);
      END_STATE();
    case 134:
      if (lookahead == 'u') ADVANCE(74);
      END_STATE();
    case 135:
      if (lookahead == 'u') ADVANCE(78);
      END_STATE();
    case 136:
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 137:
      if (lookahead == 'u') ADVANCE(35);
      END_STATE();
    case 138:
      if (lookahead == 'u') ADVANCE(114);
      END_STATE();
    case 139:
      if (lookahead == 'u') ADVANCE(112);
      END_STATE();
    case 140:
      if (lookahead == 'v') ADVANCE(60);
      END_STATE();
    case 141:
      if (lookahead == 'y') ADVANCE(183);
      END_STATE();
    case 142:
      if (lookahead == '{') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(147);
      END_STATE();
    case 143:
      if (lookahead == '}') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(143);
      END_STATE();
    case 144:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      END_STATE();
    case 145:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(207);
      END_STATE();
    case 146:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      END_STATE();
    case 147:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(150);
      END_STATE();
    case 148:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(235);
      END_STATE();
    case 149:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(143);
      END_STATE();
    case 150:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(148);
      END_STATE();
    case 151:
      if (eof) ADVANCE(152);
      if (lookahead == '"') ADVANCE(210);
      if (lookahead == '#') ADVANCE(161);
      if (lookahead == '$') ADVANCE(153);
      if (lookahead == '(') ADVANCE(181);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == ',') ADVANCE(174);
      if (lookahead == '-') ADVANCE(205);
      if (lookahead == '.') ADVANCE(159);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(154);
      if (lookahead == '=') ADVANCE(156);
      if (lookahead == '@') ADVANCE(180);
      if (lookahead == '[') ADVANCE(177);
      if (lookahead == ']') ADVANCE(178);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'b') ADVANCE(58);
      if (lookahead == 'd') ADVANCE(92);
      if (lookahead == 'e') ADVANCE(81);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'l') ADVANCE(59);
      if (lookahead == 'm') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(102);
      if (lookahead == 'r') ADVANCE(42);
      if (lookahead == 's') ADVANCE(32);
      if (lookahead == 't') ADVANCE(66);
      if (lookahead == 'u') ADVANCE(85);
      if (lookahead == 'w') ADVANCE(61);
      if (lookahead == '{') ADVANCE(164);
      if (lookahead == '}') ADVANCE(165);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(151)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(179);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_metadata);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(207);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_intEnum);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_list);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_map);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_structure);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_service);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_operation);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_resource);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(256);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_apply);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_blob);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_document);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_integer);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_timestamp);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_bigInteger);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_bigDecimal);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_null);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(145);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(aux_sym_float_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym_float_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(3);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '/') ADVANCE(213);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(213);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(213);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == ',') ADVANCE(216);
      if (lookahead == '/') ADVANCE(215);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(214);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(216);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '/') ADVANCE(212);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(216);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(216);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '\n') ADVANCE(228);
      if (lookahead == '"') ADVANCE(251);
      if (lookahead == '/') ADVANCE(252);
      if (lookahead != 0) ADVANCE(218);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '\n') ADVANCE(228);
      if (lookahead == '"') ADVANCE(251);
      if (lookahead != 0) ADVANCE(218);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '"') ADVANCE(235);
      if (lookahead == 'u') ADVANCE(222);
      if (lookahead == 'x') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(233);
      if (lookahead == '\'' ||
          lookahead == '?' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          ('t' <= lookahead && lookahead <= 'v')) ADVANCE(238);
      if (lookahead != 0) ADVANCE(234);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == ',') ADVANCE(176);
      if (lookahead == '/') ADVANCE(221);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(220);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '/') ADVANCE(217);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '{') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(224);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '}') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(223);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(227);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(223);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(225);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token2);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token2);
      if (lookahead == '"') ADVANCE(211);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(236);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(237);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(235);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(228);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'u') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'u') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(249);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(253);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(251);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(251);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_SLASH);
      if (lookahead == '\n') ADVANCE(228);
      if (lookahead == '"') ADVANCE(251);
      if (lookahead != 0) ADVANCE(218);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(251);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(aux_sym_documentation_comment_token1);
      if (lookahead == ',') ADVANCE(175);
      if (lookahead == '/') ADVANCE(255);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(254);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(256);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(aux_sym_documentation_comment_token1);
      if (lookahead == '/') ADVANCE(250);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(256);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(aux_sym_documentation_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(256);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 2},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 2},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 2},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 2},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 0},
  [77] = {.lex_state = 2},
  [78] = {.lex_state = 0},
  [79] = {.lex_state = 2},
  [80] = {.lex_state = 0},
  [81] = {.lex_state = 2},
  [82] = {.lex_state = 2},
  [83] = {.lex_state = 2},
  [84] = {.lex_state = 2},
  [85] = {.lex_state = 2},
  [86] = {.lex_state = 2},
  [87] = {.lex_state = 2},
  [88] = {.lex_state = 2},
  [89] = {.lex_state = 2},
  [90] = {.lex_state = 2},
  [91] = {.lex_state = 2},
  [92] = {.lex_state = 2},
  [93] = {.lex_state = 2},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 2},
  [96] = {.lex_state = 2},
  [97] = {.lex_state = 2},
  [98] = {.lex_state = 2},
  [99] = {.lex_state = 2},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 2},
  [103] = {.lex_state = 2},
  [104] = {.lex_state = 2},
  [105] = {.lex_state = 2},
  [106] = {.lex_state = 2},
  [107] = {.lex_state = 2},
  [108] = {.lex_state = 2},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 2},
  [115] = {.lex_state = 1},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 1},
  [118] = {.lex_state = 1},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 1},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 1},
  [126] = {.lex_state = 1},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 1},
  [130] = {.lex_state = 1},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 0},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 0},
  [135] = {.lex_state = 1},
  [136] = {.lex_state = 0},
  [137] = {.lex_state = 4},
  [138] = {.lex_state = 4},
  [139] = {.lex_state = 4},
  [140] = {.lex_state = 1},
  [141] = {.lex_state = 1},
  [142] = {.lex_state = 4},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 4},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 4},
  [147] = {.lex_state = 4},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 0},
  [155] = {.lex_state = 0},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 1},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 1},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 4},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 7},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 7},
  [194] = {.lex_state = 7},
  [195] = {.lex_state = 7},
  [196] = {.lex_state = 7},
  [197] = {.lex_state = 4},
  [198] = {.lex_state = 7},
  [199] = {.lex_state = 0},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 7},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 4},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 4},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 4},
  [212] = {.lex_state = 4},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 4},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 4},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 0},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 0},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 7},
  [236] = {.lex_state = 7},
  [237] = {.lex_state = 7},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 0},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 0},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 1},
  [293] = {.lex_state = 1},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 1},
  [298] = {.lex_state = 1},
  [299] = {.lex_state = 1},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 1},
  [304] = {.lex_state = 1},
  [305] = {.lex_state = 1},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 1},
  [309] = {.lex_state = 1},
  [310] = {.lex_state = 1},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 1},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 1},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 1},
  [319] = {.lex_state = 1},
  [320] = {.lex_state = 1},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 1},
  [323] = {.lex_state = 1},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 1},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 1},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 254},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_documentation_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_metadata] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_intEnum] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_list] = ACTIONS(1),
    [anon_sym_map] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_structure] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_service] = ACTIONS(1),
    [anon_sym_operation] = ACTIONS(1),
    [anon_sym_resource] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_apply] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_blob] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_document] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_integer] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_timestamp] = ACTIONS(1),
    [anon_sym_bigInteger] = ACTIONS(1),
    [anon_sym_bigDecimal] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [aux_sym_number_token1] = ACTIONS(1),
    [aux_sym_float_token1] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [aux_sym__escape_sequence_token1] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
  },
  [1] = {
    [sym_source_file] = STATE(334),
    [sym_control_section] = STATE(136),
    [sym_control_statement] = STATE(239),
    [sym_control_var_name] = STATE(79),
    [sym_metadata_section] = STATE(245),
    [sym_metadata_statement] = STATE(270),
    [sym_shape_section] = STATE(347),
    [sym_namespace_statement] = STATE(2),
    [sym_documentation_comment] = STATE(1),
    [aux_sym_control_section_repeat1] = STATE(155),
    [aux_sym_metadata_section_repeat1] = STATE(224),
    [ts_builtin_sym_end] = ACTIONS(9),
    [anon_sym_DOLLAR] = ACTIONS(11),
    [anon_sym_metadata] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(3),
    [sym_comment] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 27,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(17), 1,
      ts_builtin_sym_end,
    ACTIONS(19), 1,
      anon_sym_use,
    ACTIONS(23), 1,
      anon_sym_list,
    ACTIONS(25), 1,
      anon_sym_map,
    ACTIONS(27), 1,
      anon_sym_set,
    ACTIONS(29), 1,
      anon_sym_structure,
    ACTIONS(31), 1,
      anon_sym_union,
    ACTIONS(33), 1,
      anon_sym_service,
    ACTIONS(35), 1,
      anon_sym_operation,
    ACTIONS(37), 1,
      anon_sym_resource,
    ACTIONS(39), 1,
      anon_sym_AT,
    ACTIONS(41), 1,
      anon_sym_apply,
    STATE(2), 1,
      sym_documentation_comment,
    STATE(3), 1,
      aux_sym_shape_section_repeat1,
    STATE(10), 1,
      aux_sym_shape_statement_repeat1,
    STATE(37), 1,
      sym_trait_statement,
    STATE(55), 1,
      sym__definition,
    STATE(57), 1,
      sym_shape_body,
    STATE(277), 1,
      sym_primitive,
    ACTIONS(21), 2,
      anon_sym_enum,
      anon_sym_intEnum,
    STATE(40), 2,
      sym_apply_statement_singular,
      sym_apply_statement_block,
    STATE(56), 3,
      sym_use_statement,
      sym_shape_statement,
      sym_apply_statement,
    STATE(58), 10,
      sym_simple_shape_statement,
      sym_enum_statement,
      sym_list_statement,
      sym_map_statement,
      sym_set_statement,
      sym_structure_statement,
      sym_union_statement,
      sym_service_statement,
      sym_operation_statement,
      sym_resource_statement,
    ACTIONS(43), 13,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [107] = 27,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(19), 1,
      anon_sym_use,
    ACTIONS(23), 1,
      anon_sym_list,
    ACTIONS(25), 1,
      anon_sym_map,
    ACTIONS(27), 1,
      anon_sym_set,
    ACTIONS(29), 1,
      anon_sym_structure,
    ACTIONS(31), 1,
      anon_sym_union,
    ACTIONS(33), 1,
      anon_sym_service,
    ACTIONS(35), 1,
      anon_sym_operation,
    ACTIONS(37), 1,
      anon_sym_resource,
    ACTIONS(39), 1,
      anon_sym_AT,
    ACTIONS(41), 1,
      anon_sym_apply,
    ACTIONS(45), 1,
      ts_builtin_sym_end,
    STATE(3), 1,
      sym_documentation_comment,
    STATE(4), 1,
      aux_sym_shape_section_repeat1,
    STATE(10), 1,
      aux_sym_shape_statement_repeat1,
    STATE(37), 1,
      sym_trait_statement,
    STATE(55), 1,
      sym__definition,
    STATE(57), 1,
      sym_shape_body,
    STATE(277), 1,
      sym_primitive,
    ACTIONS(21), 2,
      anon_sym_enum,
      anon_sym_intEnum,
    STATE(40), 2,
      sym_apply_statement_singular,
      sym_apply_statement_block,
    STATE(56), 3,
      sym_use_statement,
      sym_shape_statement,
      sym_apply_statement,
    STATE(58), 10,
      sym_simple_shape_statement,
      sym_enum_statement,
      sym_list_statement,
      sym_map_statement,
      sym_set_statement,
      sym_structure_statement,
      sym_union_statement,
      sym_service_statement,
      sym_operation_statement,
      sym_resource_statement,
    ACTIONS(43), 13,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [214] = 26,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(47), 1,
      ts_builtin_sym_end,
    ACTIONS(49), 1,
      anon_sym_use,
    ACTIONS(55), 1,
      anon_sym_list,
    ACTIONS(58), 1,
      anon_sym_map,
    ACTIONS(61), 1,
      anon_sym_set,
    ACTIONS(64), 1,
      anon_sym_structure,
    ACTIONS(67), 1,
      anon_sym_union,
    ACTIONS(70), 1,
      anon_sym_service,
    ACTIONS(73), 1,
      anon_sym_operation,
    ACTIONS(76), 1,
      anon_sym_resource,
    ACTIONS(79), 1,
      anon_sym_AT,
    ACTIONS(82), 1,
      anon_sym_apply,
    STATE(10), 1,
      aux_sym_shape_statement_repeat1,
    STATE(37), 1,
      sym_trait_statement,
    STATE(55), 1,
      sym__definition,
    STATE(57), 1,
      sym_shape_body,
    STATE(277), 1,
      sym_primitive,
    ACTIONS(52), 2,
      anon_sym_enum,
      anon_sym_intEnum,
    STATE(4), 2,
      sym_documentation_comment,
      aux_sym_shape_section_repeat1,
    STATE(40), 2,
      sym_apply_statement_singular,
      sym_apply_statement_block,
    STATE(56), 3,
      sym_use_statement,
      sym_shape_statement,
      sym_apply_statement,
    STATE(58), 10,
      sym_simple_shape_statement,
      sym_enum_statement,
      sym_list_statement,
      sym_map_statement,
      sym_set_statement,
      sym_structure_statement,
      sym_union_statement,
      sym_service_statement,
      sym_operation_statement,
      sym_resource_statement,
    ACTIONS(85), 13,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [319] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(5), 1,
      sym_documentation_comment,
    ACTIONS(90), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    ACTIONS(88), 37,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_COLON,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [375] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(92), 1,
      anon_sym_COLON,
    STATE(6), 1,
      sym_documentation_comment,
    ACTIONS(88), 38,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_EQ,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_COLON_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [431] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(96), 1,
      anon_sym_DOLLAR,
    STATE(12), 1,
      sym_shape_id_member,
    STATE(7), 2,
      sym_documentation_comment,
      aux_sym_shape_id_repeat1,
    ACTIONS(94), 35,
      ts_builtin_sym_end,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [488] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(101), 1,
      anon_sym_DOLLAR,
    STATE(7), 1,
      aux_sym_shape_id_repeat1,
    STATE(8), 1,
      sym_documentation_comment,
    STATE(12), 1,
      sym_shape_id_member,
    ACTIONS(99), 35,
      ts_builtin_sym_end,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [547] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(101), 1,
      anon_sym_DOLLAR,
    STATE(8), 1,
      aux_sym_shape_id_repeat1,
    STATE(9), 1,
      sym_documentation_comment,
    STATE(12), 1,
      sym_shape_id_member,
    ACTIONS(103), 35,
      ts_builtin_sym_end,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [606] = 20,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(23), 1,
      anon_sym_list,
    ACTIONS(25), 1,
      anon_sym_map,
    ACTIONS(27), 1,
      anon_sym_set,
    ACTIONS(29), 1,
      anon_sym_structure,
    ACTIONS(31), 1,
      anon_sym_union,
    ACTIONS(33), 1,
      anon_sym_service,
    ACTIONS(35), 1,
      anon_sym_operation,
    ACTIONS(37), 1,
      anon_sym_resource,
    ACTIONS(39), 1,
      anon_sym_AT,
    STATE(10), 1,
      sym_documentation_comment,
    STATE(26), 1,
      aux_sym_shape_statement_repeat1,
    STATE(37), 1,
      sym_trait_statement,
    STATE(80), 1,
      sym_shape_body,
    STATE(277), 1,
      sym_primitive,
    ACTIONS(21), 2,
      anon_sym_enum,
      anon_sym_intEnum,
    STATE(58), 10,
      sym_simple_shape_statement,
      sym_enum_statement,
      sym_list_statement,
      sym_map_statement,
      sym_set_statement,
      sym_structure_statement,
      sym_union_statement,
      sym_service_statement,
      sym_operation_statement,
      sym_resource_statement,
    ACTIONS(43), 13,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [689] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(11), 1,
      sym_documentation_comment,
    ACTIONS(105), 36,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [740] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(12), 1,
      sym_documentation_comment,
    ACTIONS(107), 36,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [791] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(13), 1,
      sym_documentation_comment,
    ACTIONS(109), 36,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [842] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(14), 1,
      sym_documentation_comment,
    ACTIONS(111), 36,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [893] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(115), 1,
      anon_sym_LPAREN,
    STATE(15), 1,
      sym_documentation_comment,
    STATE(21), 1,
      sym_trait_body,
    ACTIONS(113), 31,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [945] = 30,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_RPAREN,
    ACTIONS(125), 1,
      sym_null,
    ACTIONS(127), 1,
      anon_sym_DASH,
    ACTIONS(129), 1,
      aux_sym_number_token1,
    ACTIONS(131), 1,
      aux_sym_float_token1,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(137), 1,
      aux_sym_identifier_token1,
    STATE(9), 1,
      sym_root_shape_id,
    STATE(11), 1,
      sym_absolute_root_shape_id,
    STATE(16), 1,
      sym_documentation_comment,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(112), 1,
      aux_sym_trait_structure_repeat1,
    STATE(253), 1,
      sym_node_object_kvp,
    STATE(267), 1,
      sym_identifier,
    STATE(289), 1,
      sym_string,
    STATE(326), 1,
      sym_node_value,
    STATE(332), 1,
      sym_namespace,
    STATE(338), 1,
      sym_trait_body_value,
    STATE(339), 1,
      sym_trait_structure,
    STATE(340), 1,
      sym_node_object_key,
    ACTIONS(123), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(209), 3,
      sym_boolean,
      sym_number,
      sym_float,
    STATE(226), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [1043] = 30,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(125), 1,
      sym_null,
    ACTIONS(127), 1,
      anon_sym_DASH,
    ACTIONS(129), 1,
      aux_sym_number_token1,
    ACTIONS(131), 1,
      aux_sym_float_token1,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(137), 1,
      aux_sym_identifier_token1,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(9), 1,
      sym_root_shape_id,
    STATE(11), 1,
      sym_absolute_root_shape_id,
    STATE(17), 1,
      sym_documentation_comment,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(112), 1,
      aux_sym_trait_structure_repeat1,
    STATE(253), 1,
      sym_node_object_kvp,
    STATE(267), 1,
      sym_identifier,
    STATE(289), 1,
      sym_string,
    STATE(326), 1,
      sym_node_value,
    STATE(332), 1,
      sym_namespace,
    STATE(336), 1,
      sym_trait_body_value,
    STATE(339), 1,
      sym_trait_structure,
    STATE(340), 1,
      sym_node_object_key,
    ACTIONS(123), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(209), 3,
      sym_boolean,
      sym_number,
      sym_float,
    STATE(226), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [1141] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(18), 1,
      sym_documentation_comment,
    ACTIONS(141), 31,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1187] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(19), 1,
      sym_documentation_comment,
    ACTIONS(143), 31,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1233] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(20), 1,
      sym_documentation_comment,
    ACTIONS(145), 31,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1279] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(21), 1,
      sym_documentation_comment,
    ACTIONS(147), 31,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1325] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(22), 1,
      sym_documentation_comment,
    ACTIONS(149), 31,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1371] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(153), 1,
      anon_sym_DOT,
    STATE(23), 1,
      sym_documentation_comment,
    STATE(25), 1,
      aux_sym_namespace_repeat1,
    ACTIONS(151), 28,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_POUND,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1420] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(157), 1,
      anon_sym_DOT,
    STATE(24), 2,
      sym_documentation_comment,
      aux_sym_namespace_repeat1,
    ACTIONS(155), 28,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_POUND,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1467] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(153), 1,
      anon_sym_DOT,
    STATE(24), 1,
      aux_sym_namespace_repeat1,
    STATE(25), 1,
      sym_documentation_comment,
    ACTIONS(160), 28,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_POUND,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1516] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(164), 1,
      anon_sym_AT,
    STATE(37), 1,
      sym_trait_statement,
    STATE(26), 2,
      sym_documentation_comment,
      aux_sym_shape_statement_repeat1,
    ACTIONS(162), 27,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1565] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(27), 1,
      sym_documentation_comment,
    ACTIONS(155), 29,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_use,
      anon_sym_POUND,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1609] = 24,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_LBRACK,
    ACTIONS(171), 1,
      anon_sym_RBRACK,
    ACTIONS(175), 1,
      sym_null,
    ACTIONS(177), 1,
      anon_sym_DASH,
    ACTIONS(179), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      aux_sym_float_token1,
    ACTIONS(183), 1,
      anon_sym_DQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(28), 1,
      sym_documentation_comment,
    STATE(31), 1,
      aux_sym_node_array_repeat1,
    STATE(81), 1,
      sym_root_shape_id,
    STATE(104), 1,
      sym_node_value,
    STATE(328), 1,
      sym_namespace,
    ACTIONS(173), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(91), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(90), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(96), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [1691] = 24,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      sym_null,
    ACTIONS(177), 1,
      anon_sym_DASH,
    ACTIONS(179), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      aux_sym_float_token1,
    ACTIONS(183), 1,
      anon_sym_DQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_identifier_token1,
    ACTIONS(189), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(29), 1,
      sym_documentation_comment,
    STATE(31), 1,
      aux_sym_node_array_repeat1,
    STATE(81), 1,
      sym_root_shape_id,
    STATE(104), 1,
      sym_node_value,
    STATE(328), 1,
      sym_namespace,
    ACTIONS(173), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(91), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(90), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(96), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [1773] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(30), 1,
      sym_documentation_comment,
    ACTIONS(90), 29,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_use,
      anon_sym_POUND,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [1817] = 23,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_LBRACK,
    ACTIONS(197), 1,
      anon_sym_RBRACK,
    ACTIONS(202), 1,
      sym_null,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(208), 1,
      aux_sym_number_token1,
    ACTIONS(211), 1,
      aux_sym_float_token1,
    ACTIONS(214), 1,
      anon_sym_DQUOTE,
    ACTIONS(217), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(81), 1,
      sym_root_shape_id,
    STATE(104), 1,
      sym_node_value,
    STATE(328), 1,
      sym_namespace,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(31), 2,
      sym_documentation_comment,
      aux_sym_node_array_repeat1,
    STATE(86), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(91), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(90), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(96), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [1897] = 24,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      sym_null,
    ACTIONS(177), 1,
      anon_sym_DASH,
    ACTIONS(179), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      aux_sym_float_token1,
    ACTIONS(183), 1,
      anon_sym_DQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_identifier_token1,
    ACTIONS(223), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(31), 1,
      aux_sym_node_array_repeat1,
    STATE(32), 1,
      sym_documentation_comment,
    STATE(81), 1,
      sym_root_shape_id,
    STATE(104), 1,
      sym_node_value,
    STATE(328), 1,
      sym_namespace,
    ACTIONS(173), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(91), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(90), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(96), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [1979] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    STATE(33), 1,
      sym_documentation_comment,
    STATE(42), 1,
      sym_mixins,
    ACTIONS(225), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2027] = 24,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      sym_null,
    ACTIONS(177), 1,
      anon_sym_DASH,
    ACTIONS(179), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      aux_sym_float_token1,
    ACTIONS(183), 1,
      anon_sym_DQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_identifier_token1,
    ACTIONS(229), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(28), 1,
      aux_sym_node_array_repeat1,
    STATE(34), 1,
      sym_documentation_comment,
    STATE(81), 1,
      sym_root_shape_id,
    STATE(104), 1,
      sym_node_value,
    STATE(328), 1,
      sym_namespace,
    ACTIONS(173), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(91), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(90), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(96), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [2109] = 24,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      sym_null,
    ACTIONS(177), 1,
      anon_sym_DASH,
    ACTIONS(179), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      aux_sym_float_token1,
    ACTIONS(183), 1,
      anon_sym_DQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_identifier_token1,
    ACTIONS(231), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(29), 1,
      aux_sym_node_array_repeat1,
    STATE(35), 1,
      sym_documentation_comment,
    STATE(81), 1,
      sym_root_shape_id,
    STATE(104), 1,
      sym_node_value,
    STATE(328), 1,
      sym_namespace,
    ACTIONS(173), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(91), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(90), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(96), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [2191] = 24,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_LBRACK,
    ACTIONS(175), 1,
      sym_null,
    ACTIONS(177), 1,
      anon_sym_DASH,
    ACTIONS(179), 1,
      aux_sym_number_token1,
    ACTIONS(181), 1,
      aux_sym_float_token1,
    ACTIONS(183), 1,
      anon_sym_DQUOTE,
    ACTIONS(185), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_identifier_token1,
    ACTIONS(233), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(32), 1,
      aux_sym_node_array_repeat1,
    STATE(36), 1,
      sym_documentation_comment,
    STATE(81), 1,
      sym_root_shape_id,
    STATE(104), 1,
      sym_node_value,
    STATE(328), 1,
      sym_namespace,
    ACTIONS(173), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(86), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(91), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(90), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(96), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [2273] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(37), 1,
      sym_documentation_comment,
    ACTIONS(235), 28,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_with,
      anon_sym_for,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2316] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(38), 1,
      sym_documentation_comment,
    ACTIONS(237), 28,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_LBRACE,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2359] = 22,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(239), 1,
      anon_sym_LBRACE,
    ACTIONS(241), 1,
      anon_sym_LBRACK,
    ACTIONS(245), 1,
      sym_null,
    ACTIONS(247), 1,
      anon_sym_DASH,
    ACTIONS(249), 1,
      aux_sym_number_token1,
    ACTIONS(251), 1,
      aux_sym_float_token1,
    ACTIONS(253), 1,
      anon_sym_DQUOTE,
    ACTIONS(255), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(257), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(39), 1,
      sym_documentation_comment,
    STATE(120), 1,
      sym_root_shape_id,
    STATE(232), 1,
      sym_node_value,
    STATE(345), 1,
      sym_namespace,
    ACTIONS(243), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(169), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(174), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(184), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [2435] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(40), 1,
      sym_documentation_comment,
    ACTIONS(259), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2477] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(41), 1,
      sym_documentation_comment,
    ACTIONS(261), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2519] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(42), 1,
      sym_documentation_comment,
    ACTIONS(263), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2561] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(43), 1,
      sym_documentation_comment,
    ACTIONS(265), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2603] = 22,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(239), 1,
      anon_sym_LBRACE,
    ACTIONS(241), 1,
      anon_sym_LBRACK,
    ACTIONS(245), 1,
      sym_null,
    ACTIONS(247), 1,
      anon_sym_DASH,
    ACTIONS(249), 1,
      aux_sym_number_token1,
    ACTIONS(251), 1,
      aux_sym_float_token1,
    ACTIONS(253), 1,
      anon_sym_DQUOTE,
    ACTIONS(255), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(257), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(44), 1,
      sym_documentation_comment,
    STATE(143), 1,
      sym_root_shape_id,
    STATE(232), 1,
      sym_node_value,
    STATE(345), 1,
      sym_namespace,
    ACTIONS(243), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(169), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(174), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(184), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [2679] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(45), 1,
      sym_documentation_comment,
    ACTIONS(267), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2721] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(46), 1,
      sym_documentation_comment,
    ACTIONS(269), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2763] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(47), 1,
      sym_documentation_comment,
    ACTIONS(271), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2805] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(48), 1,
      sym_documentation_comment,
    ACTIONS(273), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2847] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(49), 1,
      sym_documentation_comment,
    ACTIONS(275), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2889] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(50), 1,
      sym_documentation_comment,
    ACTIONS(277), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2931] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(51), 1,
      sym_documentation_comment,
    ACTIONS(279), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [2973] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(52), 1,
      sym_documentation_comment,
    ACTIONS(281), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3015] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(53), 1,
      sym_documentation_comment,
    ACTIONS(283), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3057] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(54), 1,
      sym_documentation_comment,
    ACTIONS(285), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3099] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(55), 1,
      sym_documentation_comment,
    ACTIONS(287), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3141] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(56), 1,
      sym_documentation_comment,
    ACTIONS(289), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3183] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(57), 1,
      sym_documentation_comment,
    ACTIONS(291), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3225] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(58), 1,
      sym_documentation_comment,
    ACTIONS(293), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3267] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(59), 1,
      sym_documentation_comment,
    ACTIONS(295), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3309] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(60), 1,
      sym_documentation_comment,
    ACTIONS(297), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3351] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(61), 1,
      sym_documentation_comment,
    ACTIONS(299), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3393] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(62), 1,
      sym_documentation_comment,
    ACTIONS(301), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3435] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(63), 1,
      sym_documentation_comment,
    ACTIONS(303), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3477] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(64), 1,
      sym_documentation_comment,
    ACTIONS(305), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3519] = 22,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(239), 1,
      anon_sym_LBRACE,
    ACTIONS(241), 1,
      anon_sym_LBRACK,
    ACTIONS(245), 1,
      sym_null,
    ACTIONS(247), 1,
      anon_sym_DASH,
    ACTIONS(249), 1,
      aux_sym_number_token1,
    ACTIONS(251), 1,
      aux_sym_float_token1,
    ACTIONS(253), 1,
      anon_sym_DQUOTE,
    ACTIONS(255), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(257), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(65), 1,
      sym_documentation_comment,
    STATE(120), 1,
      sym_root_shape_id,
    STATE(207), 1,
      sym_node_value,
    STATE(345), 1,
      sym_namespace,
    ACTIONS(243), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(169), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(174), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(184), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [3595] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(66), 1,
      sym_documentation_comment,
    ACTIONS(307), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3637] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(67), 1,
      sym_documentation_comment,
    ACTIONS(309), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3679] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(68), 1,
      sym_documentation_comment,
    ACTIONS(311), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3721] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(69), 1,
      sym_documentation_comment,
    ACTIONS(313), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3763] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(70), 1,
      sym_documentation_comment,
    ACTIONS(315), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3805] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(71), 1,
      sym_documentation_comment,
    ACTIONS(317), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3847] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(72), 1,
      sym_documentation_comment,
    ACTIONS(319), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3889] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(73), 1,
      sym_documentation_comment,
    ACTIONS(321), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3931] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(74), 1,
      sym_documentation_comment,
    ACTIONS(323), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [3973] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(75), 1,
      sym_documentation_comment,
    ACTIONS(325), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [4015] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(76), 1,
      sym_documentation_comment,
    ACTIONS(327), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [4057] = 22,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(125), 1,
      sym_null,
    ACTIONS(127), 1,
      anon_sym_DASH,
    ACTIONS(129), 1,
      aux_sym_number_token1,
    ACTIONS(131), 1,
      aux_sym_float_token1,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(137), 1,
      aux_sym_identifier_token1,
    STATE(9), 1,
      sym_root_shape_id,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(77), 1,
      sym_documentation_comment,
    STATE(265), 1,
      sym_node_value,
    STATE(332), 1,
      sym_namespace,
    ACTIONS(123), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(209), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(226), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [4133] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(78), 1,
      sym_documentation_comment,
    ACTIONS(329), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [4175] = 22,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(125), 1,
      sym_null,
    ACTIONS(127), 1,
      anon_sym_DASH,
    ACTIONS(129), 1,
      aux_sym_number_token1,
    ACTIONS(131), 1,
      aux_sym_float_token1,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(137), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(79), 1,
      sym_documentation_comment,
    STATE(191), 1,
      sym_root_shape_id,
    STATE(243), 1,
      sym_node_value,
    STATE(332), 1,
      sym_namespace,
    ACTIONS(123), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(209), 4,
      sym_boolean,
      sym_number,
      sym_float,
      sym_string,
    STATE(226), 4,
      sym_shape_id,
      sym_node_array,
      sym_node_object,
      sym_literal,
  [4251] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(80), 1,
      sym_documentation_comment,
    ACTIONS(331), 27,
      ts_builtin_sym_end,
      anon_sym_use,
      anon_sym_enum,
      anon_sym_intEnum,
      anon_sym_list,
      anon_sym_map,
      anon_sym_set,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_service,
      anon_sym_operation,
      anon_sym_resource,
      anon_sym_AT,
      anon_sym_apply,
      anon_sym_blob,
      anon_sym_boolean,
      anon_sym_byte,
      anon_sym_document,
      anon_sym_double,
      anon_sym_float,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_string,
      anon_sym_timestamp,
      anon_sym_bigInteger,
      anon_sym_bigDecimal,
  [4293] = 9,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(333), 1,
      anon_sym_DOLLAR,
    STATE(81), 1,
      sym_documentation_comment,
    STATE(84), 1,
      aux_sym_shape_id_repeat1,
    STATE(87), 1,
      sym_shape_id_member,
    ACTIONS(103), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(335), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4331] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(337), 1,
      anon_sym_DOLLAR,
    STATE(87), 1,
      sym_shape_id_member,
    STATE(82), 2,
      sym_documentation_comment,
      aux_sym_shape_id_repeat1,
    ACTIONS(94), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(340), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4367] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(90), 1,
      anon_sym_POUND,
    ACTIONS(342), 1,
      anon_sym_DOT,
    STATE(83), 1,
      sym_documentation_comment,
    ACTIONS(88), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(92), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4403] = 9,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(333), 1,
      anon_sym_DOLLAR,
    STATE(82), 1,
      aux_sym_shape_id_repeat1,
    STATE(84), 1,
      sym_documentation_comment,
    STATE(87), 1,
      sym_shape_id_member,
    ACTIONS(99), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(344), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4441] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(85), 1,
      sym_documentation_comment,
    ACTIONS(88), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(92), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4471] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(86), 1,
      sym_documentation_comment,
    ACTIONS(105), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(346), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4501] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(87), 1,
      sym_documentation_comment,
    ACTIONS(107), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(348), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4531] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(88), 1,
      sym_documentation_comment,
    ACTIONS(109), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(350), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4561] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(89), 1,
      sym_documentation_comment,
    ACTIONS(111), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(352), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4591] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(90), 1,
      sym_documentation_comment,
    ACTIONS(354), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(356), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4620] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(91), 1,
      sym_documentation_comment,
    ACTIONS(358), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(360), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4649] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(92), 1,
      sym_documentation_comment,
    ACTIONS(362), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(364), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4678] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(93), 1,
      sym_documentation_comment,
    ACTIONS(366), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(368), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4707] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(340), 1,
      anon_sym_DQUOTE,
    ACTIONS(370), 1,
      anon_sym_DOLLAR,
    STATE(121), 1,
      sym_shape_id_member,
    STATE(94), 2,
      sym_documentation_comment,
      aux_sym_shape_id_repeat1,
    ACTIONS(94), 8,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [4740] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(95), 1,
      sym_documentation_comment,
    ACTIONS(373), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(375), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4769] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(96), 1,
      sym_documentation_comment,
    ACTIONS(377), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(379), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4798] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(97), 1,
      sym_documentation_comment,
    ACTIONS(381), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(383), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4827] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(98), 1,
      sym_documentation_comment,
    ACTIONS(385), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(387), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4856] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(99), 1,
      sym_documentation_comment,
    ACTIONS(143), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(389), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4885] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(92), 1,
      anon_sym_DQUOTE,
    STATE(100), 1,
      sym_documentation_comment,
    ACTIONS(90), 2,
      anon_sym_DOT,
      anon_sym_POUND,
    ACTIONS(88), 9,
      anon_sym_DOLLAR,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [4916] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(101), 1,
      sym_documentation_comment,
    ACTIONS(391), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(393), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4945] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(102), 1,
      sym_documentation_comment,
    ACTIONS(395), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(397), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [4974] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(103), 1,
      sym_documentation_comment,
    ACTIONS(399), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(401), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [5003] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(104), 1,
      sym_documentation_comment,
    ACTIONS(403), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(405), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [5032] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(105), 1,
      sym_documentation_comment,
    ACTIONS(141), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(407), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [5061] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(106), 1,
      sym_documentation_comment,
    ACTIONS(409), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(411), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [5090] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(107), 1,
      sym_documentation_comment,
    ACTIONS(413), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(415), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [5119] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(108), 1,
      sym_documentation_comment,
    ACTIONS(417), 5,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(419), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [5148] = 9,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(344), 1,
      anon_sym_DQUOTE,
    ACTIONS(421), 1,
      anon_sym_DOLLAR,
    STATE(94), 1,
      aux_sym_shape_id_repeat1,
    STATE(109), 1,
      sym_documentation_comment,
    STATE(121), 1,
      sym_shape_id_member,
    ACTIONS(99), 7,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [5182] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(423), 1,
      anon_sym_RBRACE,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(110), 1,
      sym_documentation_comment,
    STATE(117), 1,
      aux_sym_node_object_repeat1,
    STATE(246), 1,
      sym_node_object_kvp,
    STATE(340), 1,
      sym_node_object_key,
    STATE(342), 1,
      sym_string,
    STATE(343), 1,
      sym_identifier,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
  [5226] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(427), 1,
      anon_sym_RBRACE,
    STATE(111), 1,
      sym_documentation_comment,
    STATE(117), 1,
      aux_sym_node_object_repeat1,
    STATE(246), 1,
      sym_node_object_kvp,
    STATE(340), 1,
      sym_node_object_key,
    STATE(342), 1,
      sym_string,
    STATE(343), 1,
      sym_identifier,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
  [5270] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(429), 1,
      anon_sym_RPAREN,
    STATE(112), 1,
      sym_documentation_comment,
    STATE(116), 1,
      aux_sym_trait_structure_repeat1,
    STATE(253), 1,
      sym_node_object_kvp,
    STATE(340), 1,
      sym_node_object_key,
    STATE(342), 1,
      sym_string,
    STATE(343), 1,
      sym_identifier,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
  [5314] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(431), 1,
      anon_sym_RBRACE,
    STATE(111), 1,
      aux_sym_node_object_repeat1,
    STATE(113), 1,
      sym_documentation_comment,
    STATE(246), 1,
      sym_node_object_kvp,
    STATE(340), 1,
      sym_node_object_key,
    STATE(342), 1,
      sym_string,
    STATE(343), 1,
      sym_identifier,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
  [5358] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(114), 1,
      sym_documentation_comment,
    ACTIONS(433), 4,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(435), 7,
      anon_sym_true,
      anon_sym_false,
      sym_null,
      aux_sym_number_token1,
      aux_sym_float_token1,
      anon_sym_DQUOTE,
      aux_sym_identifier_token1,
  [5386] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(437), 1,
      anon_sym_RBRACE,
    STATE(115), 1,
      sym_documentation_comment,
    STATE(117), 1,
      aux_sym_node_object_repeat1,
    STATE(246), 1,
      sym_node_object_kvp,
    STATE(340), 1,
      sym_node_object_key,
    STATE(342), 1,
      sym_string,
    STATE(343), 1,
      sym_identifier,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
  [5430] = 13,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(439), 1,
      anon_sym_RPAREN,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    ACTIONS(444), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(447), 1,
      aux_sym_identifier_token1,
    STATE(253), 1,
      sym_node_object_kvp,
    STATE(340), 1,
      sym_node_object_key,
    STATE(342), 1,
      sym_string,
    STATE(343), 1,
      sym_identifier,
    STATE(116), 2,
      sym_documentation_comment,
      aux_sym_trait_structure_repeat1,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
  [5472] = 13,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(450), 1,
      anon_sym_RBRACE,
    ACTIONS(452), 1,
      anon_sym_DQUOTE,
    ACTIONS(455), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(458), 1,
      aux_sym_identifier_token1,
    STATE(246), 1,
      sym_node_object_kvp,
    STATE(340), 1,
      sym_node_object_key,
    STATE(342), 1,
      sym_string,
    STATE(343), 1,
      sym_identifier,
    STATE(117), 2,
      sym_documentation_comment,
      aux_sym_node_object_repeat1,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
  [5514] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(461), 1,
      anon_sym_RBRACE,
    STATE(115), 1,
      aux_sym_node_object_repeat1,
    STATE(118), 1,
      sym_documentation_comment,
    STATE(246), 1,
      sym_node_object_kvp,
    STATE(340), 1,
      sym_node_object_key,
    STATE(342), 1,
      sym_string,
    STATE(343), 1,
      sym_identifier,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
  [5558] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(463), 1,
      anon_sym_RBRACE,
    STATE(110), 1,
      aux_sym_node_object_repeat1,
    STATE(119), 1,
      sym_documentation_comment,
    STATE(246), 1,
      sym_node_object_kvp,
    STATE(340), 1,
      sym_node_object_key,
    STATE(342), 1,
      sym_string,
    STATE(343), 1,
      sym_identifier,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
  [5602] = 9,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(335), 1,
      anon_sym_DQUOTE,
    ACTIONS(421), 1,
      anon_sym_DOLLAR,
    STATE(109), 1,
      aux_sym_shape_id_repeat1,
    STATE(120), 1,
      sym_documentation_comment,
    STATE(121), 1,
      sym_shape_id_member,
    ACTIONS(103), 7,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [5636] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(348), 1,
      anon_sym_DQUOTE,
    STATE(121), 1,
      sym_documentation_comment,
    ACTIONS(107), 9,
      anon_sym_DOLLAR,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [5663] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(92), 1,
      anon_sym_DQUOTE,
    STATE(122), 1,
      sym_documentation_comment,
    ACTIONS(88), 9,
      anon_sym_DOLLAR,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [5690] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    STATE(123), 1,
      sym_documentation_comment,
    ACTIONS(109), 9,
      anon_sym_DOLLAR,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [5717] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(465), 1,
      anon_sym_DOLLAR,
    ACTIONS(467), 1,
      anon_sym_RBRACE,
    ACTIONS(469), 1,
      anon_sym_AT,
    STATE(124), 1,
      sym_documentation_comment,
    STATE(126), 1,
      aux_sym_shape_members_repeat1,
    STATE(176), 1,
      aux_sym_shape_statement_repeat1,
    STATE(192), 1,
      sym_shape_member_elided,
    STATE(244), 1,
      sym_shape_member,
    STATE(274), 1,
      sym_trait_statement,
    STATE(330), 1,
      sym_identifier,
  [5760] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(465), 1,
      anon_sym_DOLLAR,
    ACTIONS(469), 1,
      anon_sym_AT,
    ACTIONS(471), 1,
      anon_sym_RBRACE,
    STATE(124), 1,
      aux_sym_shape_members_repeat1,
    STATE(125), 1,
      sym_documentation_comment,
    STATE(176), 1,
      aux_sym_shape_statement_repeat1,
    STATE(192), 1,
      sym_shape_member_elided,
    STATE(244), 1,
      sym_shape_member,
    STATE(274), 1,
      sym_trait_statement,
    STATE(330), 1,
      sym_identifier,
  [5803] = 13,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(473), 1,
      anon_sym_DOLLAR,
    ACTIONS(476), 1,
      anon_sym_RBRACE,
    ACTIONS(478), 1,
      anon_sym_AT,
    ACTIONS(481), 1,
      aux_sym_identifier_token1,
    STATE(176), 1,
      aux_sym_shape_statement_repeat1,
    STATE(192), 1,
      sym_shape_member_elided,
    STATE(244), 1,
      sym_shape_member,
    STATE(274), 1,
      sym_trait_statement,
    STATE(330), 1,
      sym_identifier,
    STATE(126), 2,
      sym_documentation_comment,
      aux_sym_shape_members_repeat1,
  [5844] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(352), 1,
      anon_sym_DQUOTE,
    STATE(127), 1,
      sym_documentation_comment,
    ACTIONS(111), 9,
      anon_sym_DOLLAR,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [5871] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(465), 1,
      anon_sym_DOLLAR,
    ACTIONS(469), 1,
      anon_sym_AT,
    ACTIONS(484), 1,
      anon_sym_RBRACE,
    STATE(126), 1,
      aux_sym_shape_members_repeat1,
    STATE(128), 1,
      sym_documentation_comment,
    STATE(176), 1,
      aux_sym_shape_statement_repeat1,
    STATE(192), 1,
      sym_shape_member_elided,
    STATE(244), 1,
      sym_shape_member,
    STATE(274), 1,
      sym_trait_statement,
    STATE(330), 1,
      sym_identifier,
  [5914] = 14,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(465), 1,
      anon_sym_DOLLAR,
    ACTIONS(469), 1,
      anon_sym_AT,
    ACTIONS(486), 1,
      anon_sym_RBRACE,
    STATE(128), 1,
      aux_sym_shape_members_repeat1,
    STATE(129), 1,
      sym_documentation_comment,
    STATE(176), 1,
      aux_sym_shape_statement_repeat1,
    STATE(192), 1,
      sym_shape_member_elided,
    STATE(244), 1,
      sym_shape_member,
    STATE(274), 1,
      sym_trait_statement,
    STATE(330), 1,
      sym_identifier,
  [5957] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(346), 1,
      anon_sym_DQUOTE,
    STATE(130), 1,
      sym_documentation_comment,
    ACTIONS(105), 9,
      anon_sym_DOLLAR,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [5984] = 12,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(488), 1,
      anon_sym_RBRACK,
    ACTIONS(490), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(120), 1,
      sym_root_shape_id,
    STATE(131), 1,
      sym_documentation_comment,
    STATE(133), 1,
      aux_sym_mixins_repeat1,
    STATE(282), 1,
      sym_shape_id,
    STATE(345), 1,
      sym_namespace,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [6022] = 13,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(39), 1,
      anon_sym_AT,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(492), 1,
      anon_sym_LBRACE,
    ACTIONS(494), 1,
      anon_sym_for,
    STATE(26), 1,
      aux_sym_shape_statement_repeat1,
    STATE(37), 1,
      sym_trait_statement,
    STATE(132), 1,
      sym_documentation_comment,
    STATE(247), 1,
      sym_structure_resource,
    STATE(311), 1,
      sym_mixins,
    STATE(314), 1,
      sym_shape_members,
  [6062] = 11,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(496), 1,
      anon_sym_RBRACK,
    ACTIONS(498), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(120), 1,
      sym_root_shape_id,
    STATE(282), 1,
      sym_shape_id,
    STATE(345), 1,
      sym_namespace,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
    STATE(133), 2,
      sym_documentation_comment,
      aux_sym_mixins_repeat1,
  [6098] = 13,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(39), 1,
      anon_sym_AT,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(492), 1,
      anon_sym_LBRACE,
    ACTIONS(494), 1,
      anon_sym_for,
    STATE(37), 1,
      sym_trait_statement,
    STATE(132), 1,
      aux_sym_shape_statement_repeat1,
    STATE(134), 1,
      sym_documentation_comment,
    STATE(238), 1,
      sym_structure_resource,
    STATE(276), 1,
      sym_mixins,
    STATE(298), 1,
      sym_shape_members,
  [6138] = 11,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(490), 1,
      aux_sym_identifier_token1,
    ACTIONS(501), 1,
      anon_sym_LBRACK,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(120), 1,
      sym_root_shape_id,
    STATE(135), 1,
      sym_documentation_comment,
    STATE(291), 1,
      sym_shape_id,
    STATE(345), 1,
      sym_namespace,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [6173] = 12,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(13), 1,
      anon_sym_metadata,
    ACTIONS(15), 1,
      anon_sym_namespace,
    ACTIONS(503), 1,
      ts_builtin_sym_end,
    STATE(2), 1,
      sym_namespace_statement,
    STATE(136), 1,
      sym_documentation_comment,
    STATE(224), 1,
      aux_sym_metadata_section_repeat1,
    STATE(249), 1,
      sym_metadata_section,
    STATE(270), 1,
      sym_metadata_statement,
    STATE(327), 1,
      sym_shape_section,
  [6210] = 9,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(505), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(507), 1,
      aux_sym__multiline_string_fragment_token1,
    ACTIONS(510), 1,
      aux_sym__multiline_string_fragment_token2,
    ACTIONS(513), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(516), 1,
      sym_escape_sequence,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    STATE(137), 2,
      sym_documentation_comment,
      aux_sym__multiline_string_literal_repeat1,
    STATE(206), 2,
      sym__multiline_string_fragment,
      sym__escape_sequence,
  [6241] = 10,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(519), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(521), 1,
      aux_sym__multiline_string_fragment_token1,
    ACTIONS(523), 1,
      aux_sym__multiline_string_fragment_token2,
    ACTIONS(525), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(527), 1,
      sym_escape_sequence,
    STATE(138), 1,
      sym_documentation_comment,
    STATE(144), 1,
      aux_sym__multiline_string_literal_repeat1,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    STATE(206), 2,
      sym__multiline_string_fragment,
      sym__escape_sequence,
  [6274] = 10,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(521), 1,
      aux_sym__multiline_string_fragment_token1,
    ACTIONS(523), 1,
      aux_sym__multiline_string_fragment_token2,
    ACTIONS(525), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(529), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(137), 1,
      aux_sym__multiline_string_literal_repeat1,
    STATE(139), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    STATE(206), 2,
      sym__multiline_string_fragment,
      sym__escape_sequence,
  [6307] = 12,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(531), 1,
      anon_sym_RBRACE,
    ACTIONS(533), 1,
      anon_sym_AT,
    ACTIONS(535), 1,
      aux_sym_identifier_token1,
    STATE(140), 1,
      sym_documentation_comment,
    STATE(145), 1,
      aux_sym_enum_members_repeat1,
    STATE(213), 1,
      sym_identifier,
    STATE(222), 1,
      aux_sym_shape_statement_repeat1,
    STATE(262), 1,
      sym_enum_member,
    STATE(274), 1,
      sym_trait_statement,
  [6344] = 11,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(537), 1,
      anon_sym_RBRACE,
    ACTIONS(539), 1,
      anon_sym_AT,
    ACTIONS(542), 1,
      aux_sym_identifier_token1,
    STATE(213), 1,
      sym_identifier,
    STATE(222), 1,
      aux_sym_shape_statement_repeat1,
    STATE(262), 1,
      sym_enum_member,
    STATE(274), 1,
      sym_trait_statement,
    STATE(141), 2,
      sym_documentation_comment,
      aux_sym_enum_members_repeat1,
  [6379] = 10,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(521), 1,
      aux_sym__multiline_string_fragment_token1,
    ACTIONS(523), 1,
      aux_sym__multiline_string_fragment_token2,
    ACTIONS(525), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(545), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(137), 1,
      aux_sym__multiline_string_literal_repeat1,
    STATE(142), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    STATE(206), 2,
      sym__multiline_string_fragment,
      sym__escape_sequence,
  [6412] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(121), 1,
      sym_shape_id_member,
    STATE(143), 1,
      sym_documentation_comment,
    STATE(149), 1,
      aux_sym_shape_id_repeat1,
    ACTIONS(103), 6,
      anon_sym_DOLLAR,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      aux_sym_identifier_token1,
  [6439] = 10,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(521), 1,
      aux_sym__multiline_string_fragment_token1,
    ACTIONS(523), 1,
      aux_sym__multiline_string_fragment_token2,
    ACTIONS(525), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(547), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(137), 1,
      aux_sym__multiline_string_literal_repeat1,
    STATE(144), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    STATE(206), 2,
      sym__multiline_string_fragment,
      sym__escape_sequence,
  [6472] = 12,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(533), 1,
      anon_sym_AT,
    ACTIONS(535), 1,
      aux_sym_identifier_token1,
    ACTIONS(549), 1,
      anon_sym_RBRACE,
    STATE(141), 1,
      aux_sym_enum_members_repeat1,
    STATE(145), 1,
      sym_documentation_comment,
    STATE(213), 1,
      sym_identifier,
    STATE(222), 1,
      aux_sym_shape_statement_repeat1,
    STATE(262), 1,
      sym_enum_member,
    STATE(274), 1,
      sym_trait_statement,
  [6509] = 10,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(521), 1,
      aux_sym__multiline_string_fragment_token1,
    ACTIONS(523), 1,
      aux_sym__multiline_string_fragment_token2,
    ACTIONS(525), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(551), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(139), 1,
      aux_sym__multiline_string_literal_repeat1,
    STATE(146), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    STATE(206), 2,
      sym__multiline_string_fragment,
      sym__escape_sequence,
  [6542] = 10,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(521), 1,
      aux_sym__multiline_string_fragment_token1,
    ACTIONS(523), 1,
      aux_sym__multiline_string_fragment_token2,
    ACTIONS(525), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(527), 1,
      sym_escape_sequence,
    ACTIONS(553), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(142), 1,
      aux_sym__multiline_string_literal_repeat1,
    STATE(147), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    STATE(206), 2,
      sym__multiline_string_fragment,
      sym__escape_sequence,
  [6575] = 11,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(490), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(120), 1,
      sym_root_shape_id,
    STATE(131), 1,
      aux_sym_mixins_repeat1,
    STATE(148), 1,
      sym_documentation_comment,
    STATE(282), 1,
      sym_shape_id,
    STATE(345), 1,
      sym_namespace,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [6610] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(94), 1,
      aux_sym_shape_id_repeat1,
    STATE(121), 1,
      sym_shape_id_member,
    STATE(149), 1,
      sym_documentation_comment,
    ACTIONS(99), 6,
      anon_sym_DOLLAR,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      aux_sym_identifier_token1,
  [6637] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    STATE(150), 1,
      sym_documentation_comment,
    ACTIONS(143), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [6661] = 11,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(555), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_documentation_comment,
    STATE(160), 1,
      aux_sym_operation_body_repeat1,
    STATE(230), 1,
      aux_sym_operation_member_repeat1,
    STATE(266), 1,
      sym_identifier,
    STATE(303), 1,
      sym_operation_errors,
    STATE(304), 1,
      sym_operation_member,
  [6695] = 9,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(152), 1,
      sym_documentation_comment,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(344), 2,
      sym_string,
      sym_identifier,
  [6725] = 10,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(557), 1,
      aux_sym_identifier_token1,
    STATE(9), 1,
      sym_root_shape_id,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(153), 1,
      sym_documentation_comment,
    STATE(307), 1,
      sym_shape_id,
    STATE(332), 1,
      sym_namespace,
    STATE(11), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [6757] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(154), 1,
      sym_documentation_comment,
    ACTIONS(381), 7,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_COLON,
      anon_sym_metadata,
      anon_sym_EQ,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [6779] = 9,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_DOLLAR,
    STATE(79), 1,
      sym_control_var_name,
    STATE(155), 1,
      sym_documentation_comment,
    STATE(156), 1,
      aux_sym_control_section_repeat1,
    STATE(239), 1,
      sym_control_statement,
    ACTIONS(559), 3,
      ts_builtin_sym_end,
      anon_sym_metadata,
      anon_sym_namespace,
  [6809] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(563), 1,
      anon_sym_DOLLAR,
    STATE(79), 1,
      sym_control_var_name,
    STATE(239), 1,
      sym_control_statement,
    STATE(156), 2,
      sym_documentation_comment,
      aux_sym_control_section_repeat1,
    ACTIONS(561), 3,
      ts_builtin_sym_end,
      anon_sym_metadata,
      anon_sym_namespace,
  [6837] = 10,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(490), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(143), 1,
      sym_root_shape_id,
    STATE(157), 1,
      sym_documentation_comment,
    STATE(215), 1,
      sym_shape_id,
    STATE(345), 1,
      sym_namespace,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [6869] = 11,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(566), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      aux_sym_operation_body_repeat1,
    STATE(158), 1,
      sym_documentation_comment,
    STATE(230), 1,
      aux_sym_operation_member_repeat1,
    STATE(266), 1,
      sym_identifier,
    STATE(303), 1,
      sym_operation_errors,
    STATE(304), 1,
      sym_operation_member,
  [6903] = 10,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(490), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(143), 1,
      sym_root_shape_id,
    STATE(159), 1,
      sym_documentation_comment,
    STATE(190), 1,
      sym_shape_id,
    STATE(345), 1,
      sym_namespace,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [6935] = 10,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(568), 1,
      anon_sym_RBRACE,
    ACTIONS(570), 1,
      aux_sym_identifier_token1,
    STATE(230), 1,
      aux_sym_operation_member_repeat1,
    STATE(266), 1,
      sym_identifier,
    STATE(303), 1,
      sym_operation_errors,
    STATE(304), 1,
      sym_operation_member,
    STATE(160), 2,
      sym_documentation_comment,
      aux_sym_operation_body_repeat1,
  [6967] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(161), 1,
      sym_documentation_comment,
    ACTIONS(409), 7,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_COLON,
      anon_sym_metadata,
      anon_sym_EQ,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [6989] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(162), 1,
      sym_documentation_comment,
    ACTIONS(385), 7,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_COLON,
      anon_sym_metadata,
      anon_sym_EQ,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [7011] = 10,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(557), 1,
      aux_sym_identifier_token1,
    STATE(9), 1,
      sym_root_shape_id,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(163), 1,
      sym_documentation_comment,
    STATE(272), 1,
      sym_shape_id,
    STATE(332), 1,
      sym_namespace,
    STATE(11), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [7043] = 10,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(490), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(143), 1,
      sym_root_shape_id,
    STATE(164), 1,
      sym_documentation_comment,
    STATE(188), 1,
      sym_shape_id,
    STATE(345), 1,
      sym_namespace,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [7075] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(165), 1,
      sym_documentation_comment,
    ACTIONS(413), 7,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_COLON,
      anon_sym_metadata,
      anon_sym_EQ,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [7097] = 10,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(490), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(120), 1,
      sym_root_shape_id,
    STATE(166), 1,
      sym_documentation_comment,
    STATE(215), 1,
      sym_shape_id,
    STATE(345), 1,
      sym_namespace,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [7129] = 9,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(573), 1,
      aux_sym_identifier_token1,
    STATE(167), 1,
      sym_documentation_comment,
    STATE(168), 2,
      sym__string_literal,
      sym__multiline_string_literal,
    STATE(346), 2,
      sym_string,
      sym__control_identifier,
  [7159] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(168), 1,
      sym_documentation_comment,
    ACTIONS(358), 7,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_COLON,
      anon_sym_metadata,
      anon_sym_EQ,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [7181] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(360), 1,
      anon_sym_DQUOTE,
    STATE(169), 1,
      sym_documentation_comment,
    ACTIONS(358), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7205] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(401), 1,
      anon_sym_DQUOTE,
    STATE(170), 1,
      sym_documentation_comment,
    ACTIONS(399), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7229] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_DQUOTE,
    STATE(171), 1,
      sym_documentation_comment,
    ACTIONS(141), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7253] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(364), 1,
      anon_sym_DQUOTE,
    STATE(172), 1,
      sym_documentation_comment,
    ACTIONS(362), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7277] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(411), 1,
      anon_sym_DQUOTE,
    STATE(173), 1,
      sym_documentation_comment,
    ACTIONS(409), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7301] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(356), 1,
      anon_sym_DQUOTE,
    STATE(174), 1,
      sym_documentation_comment,
    ACTIONS(354), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7325] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(415), 1,
      anon_sym_DQUOTE,
    STATE(175), 1,
      sym_documentation_comment,
    ACTIONS(413), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7349] = 11,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    ACTIONS(465), 1,
      anon_sym_DOLLAR,
    ACTIONS(469), 1,
      anon_sym_AT,
    STATE(176), 1,
      sym_documentation_comment,
    STATE(202), 1,
      sym_shape_member_elided,
    STATE(223), 1,
      aux_sym_shape_statement_repeat1,
    STATE(274), 1,
      sym_trait_statement,
    STATE(348), 1,
      sym_identifier,
  [7383] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(368), 1,
      anon_sym_DQUOTE,
    STATE(177), 1,
      sym_documentation_comment,
    ACTIONS(366), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7407] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(419), 1,
      anon_sym_DQUOTE,
    STATE(178), 1,
      sym_documentation_comment,
    ACTIONS(417), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7431] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(375), 1,
      anon_sym_DQUOTE,
    STATE(179), 1,
      sym_documentation_comment,
    ACTIONS(373), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7455] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(397), 1,
      anon_sym_DQUOTE,
    STATE(180), 1,
      sym_documentation_comment,
    ACTIONS(395), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7479] = 10,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(557), 1,
      aux_sym_identifier_token1,
    STATE(9), 1,
      sym_root_shape_id,
    STATE(15), 1,
      sym_shape_id,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(181), 1,
      sym_documentation_comment,
    STATE(332), 1,
      sym_namespace,
    STATE(11), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [7511] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    STATE(182), 1,
      sym_documentation_comment,
    ACTIONS(391), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7535] = 10,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(490), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(120), 1,
      sym_root_shape_id,
    STATE(183), 1,
      sym_documentation_comment,
    STATE(291), 1,
      sym_shape_id,
    STATE(345), 1,
      sym_namespace,
    STATE(130), 2,
      sym_absolute_root_shape_id,
      sym_identifier,
  [7567] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(379), 1,
      anon_sym_DQUOTE,
    STATE(184), 1,
      sym_documentation_comment,
    ACTIONS(377), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7591] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(383), 1,
      anon_sym_DQUOTE,
    STATE(185), 1,
      sym_documentation_comment,
    ACTIONS(381), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7615] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(387), 1,
      anon_sym_DQUOTE,
    STATE(186), 1,
      sym_documentation_comment,
    ACTIONS(385), 6,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [7639] = 5,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(577), 1,
      aux_sym__multiline_string_fragment_token1,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    STATE(187), 2,
      sym_documentation_comment,
      aux_sym__multiline_string_fragment_repeat1,
    ACTIONS(575), 4,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym__multiline_string_fragment_token2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [7660] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(582), 1,
      anon_sym_EQ,
    STATE(188), 1,
      sym_documentation_comment,
    STATE(240), 1,
      sym_value_assignment,
    ACTIONS(580), 4,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [7685] = 9,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(584), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      sym_string_fragment,
    ACTIONS(588), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(590), 1,
      sym_escape_sequence,
    STATE(189), 1,
      sym_documentation_comment,
    STATE(198), 1,
      aux_sym__string_literal_repeat1,
    STATE(235), 1,
      sym__escape_sequence,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
  [7714] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(582), 1,
      anon_sym_EQ,
    STATE(190), 1,
      sym_documentation_comment,
    STATE(248), 1,
      sym_value_assignment,
    ACTIONS(592), 4,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [7739] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(12), 1,
      sym_shape_id_member,
    STATE(191), 1,
      sym_documentation_comment,
    STATE(199), 1,
      aux_sym_shape_id_repeat1,
    ACTIONS(103), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
  [7764] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(582), 1,
      anon_sym_EQ,
    STATE(192), 1,
      sym_documentation_comment,
    STATE(252), 1,
      sym_value_assignment,
    ACTIONS(594), 4,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [7789] = 9,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(586), 1,
      sym_string_fragment,
    ACTIONS(588), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(590), 1,
      sym_escape_sequence,
    ACTIONS(596), 1,
      anon_sym_DQUOTE,
    STATE(193), 1,
      sym_documentation_comment,
    STATE(201), 1,
      aux_sym__string_literal_repeat1,
    STATE(235), 1,
      sym__escape_sequence,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
  [7818] = 9,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(586), 1,
      sym_string_fragment,
    ACTIONS(588), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(590), 1,
      sym_escape_sequence,
    ACTIONS(598), 1,
      anon_sym_DQUOTE,
    STATE(194), 1,
      sym_documentation_comment,
    STATE(201), 1,
      aux_sym__string_literal_repeat1,
    STATE(235), 1,
      sym__escape_sequence,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
  [7847] = 9,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(586), 1,
      sym_string_fragment,
    ACTIONS(588), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(590), 1,
      sym_escape_sequence,
    ACTIONS(600), 1,
      anon_sym_DQUOTE,
    STATE(194), 1,
      aux_sym__string_literal_repeat1,
    STATE(195), 1,
      sym_documentation_comment,
    STATE(235), 1,
      sym__escape_sequence,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
  [7876] = 9,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(586), 1,
      sym_string_fragment,
    ACTIONS(588), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(590), 1,
      sym_escape_sequence,
    ACTIONS(602), 1,
      anon_sym_DQUOTE,
    STATE(193), 1,
      aux_sym__string_literal_repeat1,
    STATE(196), 1,
      sym_documentation_comment,
    STATE(235), 1,
      sym__escape_sequence,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
  [7905] = 6,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(606), 1,
      aux_sym__multiline_string_fragment_token1,
    STATE(187), 1,
      aux_sym__multiline_string_fragment_repeat1,
    STATE(197), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    ACTIONS(604), 4,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym__multiline_string_fragment_token2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [7928] = 9,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(586), 1,
      sym_string_fragment,
    ACTIONS(588), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(590), 1,
      sym_escape_sequence,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    STATE(198), 1,
      sym_documentation_comment,
    STATE(201), 1,
      aux_sym__string_literal_repeat1,
    STATE(235), 1,
      sym__escape_sequence,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
  [7957] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(7), 1,
      aux_sym_shape_id_repeat1,
    STATE(12), 1,
      sym_shape_id_member,
    STATE(199), 1,
      sym_documentation_comment,
    ACTIONS(99), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
  [7982] = 10,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(494), 1,
      anon_sym_for,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(50), 1,
      sym_shape_members,
    STATE(200), 1,
      sym_documentation_comment,
    STATE(233), 1,
      sym_structure_resource,
    STATE(290), 1,
      sym_mixins,
  [8013] = 8,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(612), 1,
      anon_sym_DQUOTE,
    ACTIONS(614), 1,
      sym_string_fragment,
    ACTIONS(617), 1,
      aux_sym__escape_sequence_token1,
    ACTIONS(620), 1,
      sym_escape_sequence,
    STATE(235), 1,
      sym__escape_sequence,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    STATE(201), 2,
      sym_documentation_comment,
      aux_sym__string_literal_repeat1,
  [8040] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(582), 1,
      anon_sym_EQ,
    STATE(202), 1,
      sym_documentation_comment,
    STATE(234), 1,
      sym_value_assignment,
    ACTIONS(623), 4,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [8065] = 6,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(606), 1,
      aux_sym__multiline_string_fragment_token1,
    STATE(197), 1,
      aux_sym__multiline_string_fragment_repeat1,
    STATE(203), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    ACTIONS(625), 4,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym__multiline_string_fragment_token2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [8088] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(204), 1,
      sym_documentation_comment,
    ACTIONS(627), 5,
      anon_sym_DOLLAR,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [8108] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(631), 1,
      anon_sym_metadata,
    STATE(270), 1,
      sym_metadata_statement,
    ACTIONS(629), 2,
      ts_builtin_sym_end,
      anon_sym_namespace,
    STATE(205), 2,
      sym_documentation_comment,
      aux_sym_metadata_section_repeat1,
  [8132] = 4,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(206), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    ACTIONS(634), 5,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym__multiline_string_fragment_token1,
      aux_sym__multiline_string_fragment_token2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [8150] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(638), 1,
      anon_sym_DQUOTE,
    STATE(207), 1,
      sym_documentation_comment,
    ACTIONS(636), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [8172] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(208), 1,
      sym_documentation_comment,
    ACTIONS(362), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [8192] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(209), 1,
      sym_documentation_comment,
    ACTIONS(354), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [8212] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(640), 1,
      anon_sym_EQ,
    STATE(210), 1,
      sym_documentation_comment,
    STATE(263), 1,
      sym_value_assignment,
    ACTIONS(642), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [8236] = 4,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(211), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    ACTIONS(644), 5,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym__multiline_string_fragment_token1,
      aux_sym__multiline_string_fragment_token2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [8254] = 4,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(212), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    ACTIONS(646), 5,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym__multiline_string_fragment_token1,
      aux_sym__multiline_string_fragment_token2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [8272] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(640), 1,
      anon_sym_EQ,
    STATE(213), 1,
      sym_documentation_comment,
    STATE(268), 1,
      sym_value_assignment,
    ACTIONS(648), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [8296] = 4,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(214), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    ACTIONS(625), 5,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym__multiline_string_fragment_token1,
      aux_sym__multiline_string_fragment_token2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [8314] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(650), 1,
      anon_sym_LPAREN,
    STATE(215), 1,
      sym_documentation_comment,
    STATE(273), 1,
      sym_trait_body,
    ACTIONS(113), 3,
      anon_sym_DOLLAR,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [8338] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(216), 1,
      sym_documentation_comment,
    ACTIONS(417), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [8358] = 4,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(217), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    ACTIONS(644), 5,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym__multiline_string_fragment_token1,
      aux_sym__multiline_string_fragment_token2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [8376] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(218), 1,
      sym_documentation_comment,
    ACTIONS(395), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [8396] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(219), 1,
      sym_documentation_comment,
    ACTIONS(391), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [8416] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(652), 1,
      anon_sym_RBRACK,
    ACTIONS(654), 1,
      aux_sym_identifier_token1,
    STATE(317), 1,
      sym_identifier,
    STATE(320), 1,
      sym_operation_error,
    STATE(220), 2,
      sym_documentation_comment,
      aux_sym_operation_errors_repeat1,
  [8442] = 9,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(535), 1,
      aux_sym_identifier_token1,
    ACTIONS(657), 1,
      anon_sym_RBRACK,
    STATE(220), 1,
      aux_sym_operation_errors_repeat1,
    STATE(221), 1,
      sym_documentation_comment,
    STATE(317), 1,
      sym_identifier,
    STATE(320), 1,
      sym_operation_error,
  [8470] = 9,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(533), 1,
      anon_sym_AT,
    ACTIONS(535), 1,
      aux_sym_identifier_token1,
    STATE(210), 1,
      sym_identifier,
    STATE(222), 1,
      sym_documentation_comment,
    STATE(255), 1,
      aux_sym_shape_statement_repeat1,
    STATE(274), 1,
      sym_trait_statement,
  [8498] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(659), 1,
      anon_sym_AT,
    STATE(274), 1,
      sym_trait_statement,
    ACTIONS(162), 2,
      anon_sym_DOLLAR,
      aux_sym_identifier_token1,
    STATE(223), 2,
      sym_documentation_comment,
      aux_sym_shape_statement_repeat1,
  [8522] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(13), 1,
      anon_sym_metadata,
    STATE(205), 1,
      aux_sym_metadata_section_repeat1,
    STATE(224), 1,
      sym_documentation_comment,
    STATE(270), 1,
      sym_metadata_statement,
    ACTIONS(662), 2,
      ts_builtin_sym_end,
      anon_sym_namespace,
  [8548] = 9,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(535), 1,
      aux_sym_identifier_token1,
    ACTIONS(664), 1,
      anon_sym_RBRACK,
    STATE(221), 1,
      aux_sym_operation_errors_repeat1,
    STATE(225), 1,
      sym_documentation_comment,
    STATE(317), 1,
      sym_identifier,
    STATE(320), 1,
      sym_operation_error,
  [8576] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(226), 1,
      sym_documentation_comment,
    ACTIONS(377), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [8596] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(227), 1,
      sym_documentation_comment,
    ACTIONS(373), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [8616] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(228), 1,
      sym_documentation_comment,
    ACTIONS(399), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [8636] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(229), 1,
      sym_documentation_comment,
    ACTIONS(366), 5,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
      anon_sym_RPAREN,
  [8656] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(230), 1,
      sym_documentation_comment,
    STATE(250), 1,
      aux_sym_operation_member_repeat1,
    STATE(331), 1,
      sym_identifier,
    ACTIONS(666), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [8679] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(53), 1,
      sym_shape_members,
    STATE(231), 1,
      sym_documentation_comment,
    STATE(279), 1,
      sym_mixins,
  [8704] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(232), 1,
      sym_documentation_comment,
    ACTIONS(668), 4,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [8723] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(63), 1,
      sym_shape_members,
    STATE(233), 1,
      sym_documentation_comment,
    STATE(306), 1,
      sym_mixins,
  [8748] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(234), 1,
      sym_documentation_comment,
    ACTIONS(670), 4,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [8767] = 5,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(674), 1,
      sym_string_fragment,
    STATE(235), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    ACTIONS(672), 3,
      anon_sym_DQUOTE,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [8786] = 5,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(676), 1,
      sym_string_fragment,
    STATE(236), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    ACTIONS(644), 3,
      anon_sym_DQUOTE,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [8805] = 5,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(676), 1,
      sym_string_fragment,
    STATE(237), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
    ACTIONS(644), 3,
      anon_sym_DQUOTE,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
  [8824] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(492), 1,
      anon_sym_LBRACE,
    STATE(238), 1,
      sym_documentation_comment,
    STATE(311), 1,
      sym_mixins,
    STATE(314), 1,
      sym_shape_members,
  [8849] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(239), 1,
      sym_documentation_comment,
    ACTIONS(678), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
  [8868] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(240), 1,
      sym_documentation_comment,
    ACTIONS(680), 4,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [8887] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(39), 1,
      anon_sym_AT,
    ACTIONS(682), 1,
      anon_sym_RBRACE,
    STATE(37), 1,
      sym_trait_statement,
    STATE(241), 1,
      sym_documentation_comment,
    STATE(258), 1,
      aux_sym_shape_statement_repeat1,
  [8912] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(684), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(78), 1,
      sym_absolute_root_shape_id,
    STATE(242), 1,
      sym_documentation_comment,
    STATE(332), 1,
      sym_namespace,
  [8937] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(243), 1,
      sym_documentation_comment,
    ACTIONS(686), 4,
      ts_builtin_sym_end,
      anon_sym_DOLLAR,
      anon_sym_metadata,
      anon_sym_namespace,
  [8956] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(244), 1,
      sym_documentation_comment,
    ACTIONS(688), 4,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [8975] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(15), 1,
      anon_sym_namespace,
    ACTIONS(503), 1,
      ts_builtin_sym_end,
    STATE(2), 1,
      sym_namespace_statement,
    STATE(245), 1,
      sym_documentation_comment,
    STATE(327), 1,
      sym_shape_section,
  [9000] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(692), 1,
      anon_sym_DQUOTE,
    STATE(246), 1,
      sym_documentation_comment,
    ACTIONS(690), 3,
      anon_sym_RBRACE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [9021] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(492), 1,
      anon_sym_LBRACE,
    STATE(247), 1,
      sym_documentation_comment,
    STATE(302), 1,
      sym_mixins,
    STATE(305), 1,
      sym_shape_members,
  [9046] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(248), 1,
      sym_documentation_comment,
    ACTIONS(694), 4,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [9065] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(15), 1,
      anon_sym_namespace,
    ACTIONS(696), 1,
      ts_builtin_sym_end,
    STATE(2), 1,
      sym_namespace_statement,
    STATE(249), 1,
      sym_documentation_comment,
    STATE(335), 1,
      sym_shape_section,
  [9090] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(698), 1,
      anon_sym_RBRACE,
    ACTIONS(700), 1,
      aux_sym_identifier_token1,
    STATE(331), 1,
      sym_identifier,
    STATE(250), 2,
      sym_documentation_comment,
      aux_sym_operation_member_repeat1,
  [9113] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    STATE(47), 1,
      sym_operation_body,
    STATE(251), 1,
      sym_documentation_comment,
    STATE(313), 1,
      sym_mixins,
  [9138] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(252), 1,
      sym_documentation_comment,
    ACTIONS(623), 4,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [9157] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(707), 1,
      anon_sym_DQUOTE,
    STATE(253), 1,
      sym_documentation_comment,
    ACTIONS(705), 3,
      anon_sym_RPAREN,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym_identifier_token1,
  [9178] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_with,
    STATE(48), 1,
      sym_node_object,
    STATE(254), 1,
      sym_documentation_comment,
    STATE(296), 1,
      sym_mixins,
  [9203] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(162), 1,
      aux_sym_identifier_token1,
    ACTIONS(709), 1,
      anon_sym_AT,
    STATE(274), 1,
      sym_trait_statement,
    STATE(255), 2,
      sym_documentation_comment,
      aux_sym_shape_statement_repeat1,
  [9226] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(712), 1,
      anon_sym_LBRACE,
    STATE(54), 1,
      sym_enum_members,
    STATE(256), 1,
      sym_documentation_comment,
    STATE(316), 1,
      sym_mixins,
  [9251] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(49), 1,
      sym_shape_members,
    STATE(257), 1,
      sym_documentation_comment,
    STATE(295), 1,
      sym_mixins,
  [9276] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(39), 1,
      anon_sym_AT,
    ACTIONS(714), 1,
      anon_sym_RBRACE,
    STATE(26), 1,
      aux_sym_shape_statement_repeat1,
    STATE(37), 1,
      sym_trait_statement,
    STATE(258), 1,
      sym_documentation_comment,
  [9301] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(51), 1,
      sym_shape_members,
    STATE(259), 1,
      sym_documentation_comment,
    STATE(281), 1,
      sym_mixins,
  [9326] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_with,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(52), 1,
      sym_shape_members,
    STATE(260), 1,
      sym_documentation_comment,
    STATE(280), 1,
      sym_mixins,
  [9351] = 8,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_with,
    STATE(46), 1,
      sym_node_object,
    STATE(261), 1,
      sym_documentation_comment,
    STATE(324), 1,
      sym_mixins,
  [9376] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(262), 1,
      sym_documentation_comment,
    ACTIONS(716), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [9394] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(263), 1,
      sym_documentation_comment,
    ACTIONS(718), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [9412] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(684), 1,
      aux_sym_identifier_token1,
    STATE(23), 1,
      sym__namespace_identifier,
    STATE(70), 1,
      sym_namespace,
    STATE(264), 1,
      sym_documentation_comment,
  [9434] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(265), 1,
      sym_documentation_comment,
    ACTIONS(720), 3,
      ts_builtin_sym_end,
      anon_sym_metadata,
      anon_sym_namespace,
  [9452] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(722), 1,
      anon_sym_COLON,
    ACTIONS(724), 1,
      anon_sym_COLON_EQ,
    STATE(266), 1,
      sym_documentation_comment,
    STATE(278), 1,
      sym_inline_structure,
  [9474] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(726), 1,
      anon_sym_COLON,
    STATE(267), 1,
      sym_documentation_comment,
    ACTIONS(105), 2,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [9494] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(268), 1,
      sym_documentation_comment,
    ACTIONS(728), 3,
      anon_sym_RBRACE,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [9512] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(269), 1,
      sym_documentation_comment,
    ACTIONS(145), 3,
      anon_sym_DOLLAR,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [9530] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(270), 1,
      sym_documentation_comment,
    ACTIONS(730), 3,
      ts_builtin_sym_end,
      anon_sym_metadata,
      anon_sym_namespace,
  [9548] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(271), 1,
      sym_documentation_comment,
    ACTIONS(149), 3,
      anon_sym_DOLLAR,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [9566] = 7,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(39), 1,
      anon_sym_AT,
    ACTIONS(732), 1,
      anon_sym_LBRACE,
    STATE(43), 1,
      sym_trait_statement,
    STATE(272), 1,
      sym_documentation_comment,
  [9588] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(273), 1,
      sym_documentation_comment,
    ACTIONS(147), 3,
      anon_sym_DOLLAR,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [9606] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(274), 1,
      sym_documentation_comment,
    ACTIONS(235), 3,
      anon_sym_DOLLAR,
      anon_sym_AT,
      aux_sym_identifier_token1,
  [9624] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(734), 1,
      aux_sym_number_token1,
    ACTIONS(736), 1,
      aux_sym_float_token1,
    STATE(275), 1,
      sym_documentation_comment,
  [9643] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(492), 1,
      anon_sym_LBRACE,
    STATE(276), 1,
      sym_documentation_comment,
    STATE(314), 1,
      sym_shape_members,
  [9662] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(33), 1,
      sym_identifier,
    STATE(277), 1,
      sym_documentation_comment,
  [9681] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(278), 1,
      sym_documentation_comment,
    ACTIONS(738), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [9698] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(59), 1,
      sym_shape_members,
    STATE(279), 1,
      sym_documentation_comment,
  [9717] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(61), 1,
      sym_shape_members,
    STATE(280), 1,
      sym_documentation_comment,
  [9736] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(62), 1,
      sym_shape_members,
    STATE(281), 1,
      sym_documentation_comment,
  [9755] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(282), 1,
      sym_documentation_comment,
    ACTIONS(740), 2,
      anon_sym_RBRACK,
      aux_sym_identifier_token1,
  [9772] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(742), 1,
      aux_sym_number_token1,
    ACTIONS(744), 1,
      aux_sym_float_token1,
    STATE(283), 1,
      sym_documentation_comment,
  [9791] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(746), 1,
      aux_sym_identifier_token1,
    STATE(89), 1,
      sym_identifier,
    STATE(284), 1,
      sym_documentation_comment,
  [9810] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(746), 1,
      aux_sym_identifier_token1,
    STATE(88), 1,
      sym_identifier,
    STATE(285), 1,
      sym_documentation_comment,
  [9829] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(261), 1,
      sym_identifier,
    STATE(286), 1,
      sym_documentation_comment,
  [9848] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(13), 1,
      sym_identifier,
    STATE(287), 1,
      sym_documentation_comment,
  [9867] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(14), 1,
      sym_identifier,
    STATE(288), 1,
      sym_documentation_comment,
  [9886] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(354), 1,
      anon_sym_RPAREN,
    ACTIONS(748), 1,
      anon_sym_COLON,
    STATE(289), 1,
      sym_documentation_comment,
  [9905] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(63), 1,
      sym_shape_members,
    STATE(290), 1,
      sym_documentation_comment,
  [9924] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(291), 1,
      sym_documentation_comment,
    ACTIONS(750), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [9941] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(292), 1,
      sym_documentation_comment,
    ACTIONS(267), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [9958] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(293), 1,
      sym_documentation_comment,
    ACTIONS(321), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [9975] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(251), 1,
      sym_identifier,
    STATE(294), 1,
      sym_documentation_comment,
  [9994] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(64), 1,
      sym_shape_members,
    STATE(295), 1,
      sym_documentation_comment,
  [10013] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    STATE(66), 1,
      sym_node_object,
    STATE(296), 1,
      sym_documentation_comment,
  [10032] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(297), 1,
      sym_documentation_comment,
    ACTIONS(752), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [10049] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(298), 1,
      sym_documentation_comment,
    ACTIONS(754), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [10066] = 4,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(299), 1,
      sym_documentation_comment,
    ACTIONS(756), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      aux_sym_identifier_token1,
  [10081] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(758), 1,
      aux_sym_number_token1,
    ACTIONS(760), 1,
      aux_sym_float_token1,
    STATE(300), 1,
      sym_documentation_comment,
  [10100] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(254), 1,
      sym_identifier,
    STATE(301), 1,
      sym_documentation_comment,
  [10119] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(492), 1,
      anon_sym_LBRACE,
    STATE(297), 1,
      sym_shape_members,
    STATE(302), 1,
      sym_documentation_comment,
  [10138] = 5,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(762), 1,
      anon_sym_COMMA,
    STATE(303), 1,
      sym_documentation_comment,
    ACTIONS(666), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [10155] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(304), 1,
      sym_documentation_comment,
    ACTIONS(764), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [10172] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(305), 1,
      sym_documentation_comment,
    ACTIONS(766), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [10189] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(74), 1,
      sym_shape_members,
    STATE(306), 1,
      sym_documentation_comment,
  [10208] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(307), 1,
      sym_documentation_comment,
    ACTIONS(768), 2,
      anon_sym_LBRACE,
      anon_sym_with,
  [10225] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(535), 1,
      aux_sym_identifier_token1,
    STATE(127), 1,
      sym_identifier,
    STATE(308), 1,
      sym_documentation_comment,
  [10244] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(535), 1,
      aux_sym_identifier_token1,
    STATE(123), 1,
      sym_identifier,
    STATE(309), 1,
      sym_documentation_comment,
  [10263] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(684), 1,
      aux_sym_identifier_token1,
    STATE(27), 1,
      sym__namespace_identifier,
    STATE(310), 1,
      sym_documentation_comment,
  [10282] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(492), 1,
      anon_sym_LBRACE,
    STATE(305), 1,
      sym_shape_members,
    STATE(311), 1,
      sym_documentation_comment,
  [10301] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(257), 1,
      sym_identifier,
    STATE(312), 1,
      sym_documentation_comment,
  [10320] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(703), 1,
      anon_sym_LBRACE,
    STATE(68), 1,
      sym_operation_body,
    STATE(313), 1,
      sym_documentation_comment,
  [10339] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(314), 1,
      sym_documentation_comment,
    ACTIONS(770), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [10356] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(535), 1,
      aux_sym_identifier_token1,
    STATE(204), 1,
      sym_identifier,
    STATE(315), 1,
      sym_documentation_comment,
  [10375] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(712), 1,
      anon_sym_LBRACE,
    STATE(60), 1,
      sym_enum_members,
    STATE(316), 1,
      sym_documentation_comment,
  [10394] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(317), 1,
      sym_documentation_comment,
    ACTIONS(772), 2,
      anon_sym_RBRACK,
      aux_sym_identifier_token1,
  [10411] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(256), 1,
      sym_identifier,
    STATE(318), 1,
      sym_documentation_comment,
  [10430] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(231), 1,
      sym_identifier,
    STATE(319), 1,
      sym_documentation_comment,
  [10449] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(320), 1,
      sym_documentation_comment,
    ACTIONS(774), 2,
      anon_sym_RBRACK,
      aux_sym_identifier_token1,
  [10466] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(260), 1,
      sym_identifier,
    STATE(321), 1,
      sym_documentation_comment,
  [10485] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(259), 1,
      sym_identifier,
    STATE(322), 1,
      sym_documentation_comment,
  [10504] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(425), 1,
      aux_sym_identifier_token1,
    STATE(200), 1,
      sym_identifier,
    STATE(323), 1,
      sym_documentation_comment,
  [10523] = 6,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(117), 1,
      anon_sym_LBRACE,
    STATE(69), 1,
      sym_node_object,
    STATE(324), 1,
      sym_documentation_comment,
  [10542] = 4,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    STATE(325), 1,
      sym_documentation_comment,
    ACTIONS(776), 3,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      aux_sym_identifier_token1,
  [10557] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(778), 1,
      anon_sym_RPAREN,
    STATE(326), 1,
      sym_documentation_comment,
  [10573] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(696), 1,
      ts_builtin_sym_end,
    STATE(327), 1,
      sym_documentation_comment,
  [10589] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(780), 1,
      anon_sym_POUND,
    STATE(328), 1,
      sym_documentation_comment,
  [10605] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(782), 1,
      anon_sym_COLON,
    STATE(329), 1,
      sym_documentation_comment,
  [10621] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(784), 1,
      anon_sym_COLON,
    STATE(330), 1,
      sym_documentation_comment,
  [10637] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(786), 1,
      anon_sym_COLON,
    STATE(331), 1,
      sym_documentation_comment,
  [10653] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(788), 1,
      anon_sym_POUND,
    STATE(332), 1,
      sym_documentation_comment,
  [10669] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(790), 1,
      aux_sym_identifier_token1,
    STATE(333), 1,
      sym_documentation_comment,
  [10685] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(792), 1,
      ts_builtin_sym_end,
    STATE(334), 1,
      sym_documentation_comment,
  [10701] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(794), 1,
      ts_builtin_sym_end,
    STATE(335), 1,
      sym_documentation_comment,
  [10717] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(796), 1,
      anon_sym_RPAREN,
    STATE(336), 1,
      sym_documentation_comment,
  [10733] = 4,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(798), 1,
      aux_sym_documentation_comment_token1,
    STATE(337), 1,
      sym_documentation_comment,
    ACTIONS(5), 2,
      anon_sym_COMMA,
      sym_comment,
  [10747] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(800), 1,
      anon_sym_RPAREN,
    STATE(338), 1,
      sym_documentation_comment,
  [10763] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(802), 1,
      anon_sym_RPAREN,
    STATE(339), 1,
      sym_documentation_comment,
  [10779] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(804), 1,
      anon_sym_COLON,
    STATE(340), 1,
      sym_documentation_comment,
  [10795] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(806), 1,
      anon_sym_LBRACK,
    STATE(341), 1,
      sym_documentation_comment,
  [10811] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(748), 1,
      anon_sym_COLON,
    STATE(342), 1,
      sym_documentation_comment,
  [10827] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(726), 1,
      anon_sym_COLON,
    STATE(343), 1,
      sym_documentation_comment,
  [10843] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(808), 1,
      anon_sym_EQ,
    STATE(344), 1,
      sym_documentation_comment,
  [10859] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(810), 1,
      anon_sym_POUND,
    STATE(345), 1,
      sym_documentation_comment,
  [10875] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(812), 1,
      anon_sym_COLON,
    STATE(346), 1,
      sym_documentation_comment,
  [10891] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(503), 1,
      ts_builtin_sym_end,
    STATE(347), 1,
      sym_documentation_comment,
  [10907] = 5,
    ACTIONS(3), 1,
      anon_sym_COMMA,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_SLASH_SLASH_SLASH,
    ACTIONS(814), 1,
      anon_sym_COLON,
    STATE(348), 1,
      sym_documentation_comment,
  [10923] = 1,
    ACTIONS(816), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 107,
  [SMALL_STATE(4)] = 214,
  [SMALL_STATE(5)] = 319,
  [SMALL_STATE(6)] = 375,
  [SMALL_STATE(7)] = 431,
  [SMALL_STATE(8)] = 488,
  [SMALL_STATE(9)] = 547,
  [SMALL_STATE(10)] = 606,
  [SMALL_STATE(11)] = 689,
  [SMALL_STATE(12)] = 740,
  [SMALL_STATE(13)] = 791,
  [SMALL_STATE(14)] = 842,
  [SMALL_STATE(15)] = 893,
  [SMALL_STATE(16)] = 945,
  [SMALL_STATE(17)] = 1043,
  [SMALL_STATE(18)] = 1141,
  [SMALL_STATE(19)] = 1187,
  [SMALL_STATE(20)] = 1233,
  [SMALL_STATE(21)] = 1279,
  [SMALL_STATE(22)] = 1325,
  [SMALL_STATE(23)] = 1371,
  [SMALL_STATE(24)] = 1420,
  [SMALL_STATE(25)] = 1467,
  [SMALL_STATE(26)] = 1516,
  [SMALL_STATE(27)] = 1565,
  [SMALL_STATE(28)] = 1609,
  [SMALL_STATE(29)] = 1691,
  [SMALL_STATE(30)] = 1773,
  [SMALL_STATE(31)] = 1817,
  [SMALL_STATE(32)] = 1897,
  [SMALL_STATE(33)] = 1979,
  [SMALL_STATE(34)] = 2027,
  [SMALL_STATE(35)] = 2109,
  [SMALL_STATE(36)] = 2191,
  [SMALL_STATE(37)] = 2273,
  [SMALL_STATE(38)] = 2316,
  [SMALL_STATE(39)] = 2359,
  [SMALL_STATE(40)] = 2435,
  [SMALL_STATE(41)] = 2477,
  [SMALL_STATE(42)] = 2519,
  [SMALL_STATE(43)] = 2561,
  [SMALL_STATE(44)] = 2603,
  [SMALL_STATE(45)] = 2679,
  [SMALL_STATE(46)] = 2721,
  [SMALL_STATE(47)] = 2763,
  [SMALL_STATE(48)] = 2805,
  [SMALL_STATE(49)] = 2847,
  [SMALL_STATE(50)] = 2889,
  [SMALL_STATE(51)] = 2931,
  [SMALL_STATE(52)] = 2973,
  [SMALL_STATE(53)] = 3015,
  [SMALL_STATE(54)] = 3057,
  [SMALL_STATE(55)] = 3099,
  [SMALL_STATE(56)] = 3141,
  [SMALL_STATE(57)] = 3183,
  [SMALL_STATE(58)] = 3225,
  [SMALL_STATE(59)] = 3267,
  [SMALL_STATE(60)] = 3309,
  [SMALL_STATE(61)] = 3351,
  [SMALL_STATE(62)] = 3393,
  [SMALL_STATE(63)] = 3435,
  [SMALL_STATE(64)] = 3477,
  [SMALL_STATE(65)] = 3519,
  [SMALL_STATE(66)] = 3595,
  [SMALL_STATE(67)] = 3637,
  [SMALL_STATE(68)] = 3679,
  [SMALL_STATE(69)] = 3721,
  [SMALL_STATE(70)] = 3763,
  [SMALL_STATE(71)] = 3805,
  [SMALL_STATE(72)] = 3847,
  [SMALL_STATE(73)] = 3889,
  [SMALL_STATE(74)] = 3931,
  [SMALL_STATE(75)] = 3973,
  [SMALL_STATE(76)] = 4015,
  [SMALL_STATE(77)] = 4057,
  [SMALL_STATE(78)] = 4133,
  [SMALL_STATE(79)] = 4175,
  [SMALL_STATE(80)] = 4251,
  [SMALL_STATE(81)] = 4293,
  [SMALL_STATE(82)] = 4331,
  [SMALL_STATE(83)] = 4367,
  [SMALL_STATE(84)] = 4403,
  [SMALL_STATE(85)] = 4441,
  [SMALL_STATE(86)] = 4471,
  [SMALL_STATE(87)] = 4501,
  [SMALL_STATE(88)] = 4531,
  [SMALL_STATE(89)] = 4561,
  [SMALL_STATE(90)] = 4591,
  [SMALL_STATE(91)] = 4620,
  [SMALL_STATE(92)] = 4649,
  [SMALL_STATE(93)] = 4678,
  [SMALL_STATE(94)] = 4707,
  [SMALL_STATE(95)] = 4740,
  [SMALL_STATE(96)] = 4769,
  [SMALL_STATE(97)] = 4798,
  [SMALL_STATE(98)] = 4827,
  [SMALL_STATE(99)] = 4856,
  [SMALL_STATE(100)] = 4885,
  [SMALL_STATE(101)] = 4916,
  [SMALL_STATE(102)] = 4945,
  [SMALL_STATE(103)] = 4974,
  [SMALL_STATE(104)] = 5003,
  [SMALL_STATE(105)] = 5032,
  [SMALL_STATE(106)] = 5061,
  [SMALL_STATE(107)] = 5090,
  [SMALL_STATE(108)] = 5119,
  [SMALL_STATE(109)] = 5148,
  [SMALL_STATE(110)] = 5182,
  [SMALL_STATE(111)] = 5226,
  [SMALL_STATE(112)] = 5270,
  [SMALL_STATE(113)] = 5314,
  [SMALL_STATE(114)] = 5358,
  [SMALL_STATE(115)] = 5386,
  [SMALL_STATE(116)] = 5430,
  [SMALL_STATE(117)] = 5472,
  [SMALL_STATE(118)] = 5514,
  [SMALL_STATE(119)] = 5558,
  [SMALL_STATE(120)] = 5602,
  [SMALL_STATE(121)] = 5636,
  [SMALL_STATE(122)] = 5663,
  [SMALL_STATE(123)] = 5690,
  [SMALL_STATE(124)] = 5717,
  [SMALL_STATE(125)] = 5760,
  [SMALL_STATE(126)] = 5803,
  [SMALL_STATE(127)] = 5844,
  [SMALL_STATE(128)] = 5871,
  [SMALL_STATE(129)] = 5914,
  [SMALL_STATE(130)] = 5957,
  [SMALL_STATE(131)] = 5984,
  [SMALL_STATE(132)] = 6022,
  [SMALL_STATE(133)] = 6062,
  [SMALL_STATE(134)] = 6098,
  [SMALL_STATE(135)] = 6138,
  [SMALL_STATE(136)] = 6173,
  [SMALL_STATE(137)] = 6210,
  [SMALL_STATE(138)] = 6241,
  [SMALL_STATE(139)] = 6274,
  [SMALL_STATE(140)] = 6307,
  [SMALL_STATE(141)] = 6344,
  [SMALL_STATE(142)] = 6379,
  [SMALL_STATE(143)] = 6412,
  [SMALL_STATE(144)] = 6439,
  [SMALL_STATE(145)] = 6472,
  [SMALL_STATE(146)] = 6509,
  [SMALL_STATE(147)] = 6542,
  [SMALL_STATE(148)] = 6575,
  [SMALL_STATE(149)] = 6610,
  [SMALL_STATE(150)] = 6637,
  [SMALL_STATE(151)] = 6661,
  [SMALL_STATE(152)] = 6695,
  [SMALL_STATE(153)] = 6725,
  [SMALL_STATE(154)] = 6757,
  [SMALL_STATE(155)] = 6779,
  [SMALL_STATE(156)] = 6809,
  [SMALL_STATE(157)] = 6837,
  [SMALL_STATE(158)] = 6869,
  [SMALL_STATE(159)] = 6903,
  [SMALL_STATE(160)] = 6935,
  [SMALL_STATE(161)] = 6967,
  [SMALL_STATE(162)] = 6989,
  [SMALL_STATE(163)] = 7011,
  [SMALL_STATE(164)] = 7043,
  [SMALL_STATE(165)] = 7075,
  [SMALL_STATE(166)] = 7097,
  [SMALL_STATE(167)] = 7129,
  [SMALL_STATE(168)] = 7159,
  [SMALL_STATE(169)] = 7181,
  [SMALL_STATE(170)] = 7205,
  [SMALL_STATE(171)] = 7229,
  [SMALL_STATE(172)] = 7253,
  [SMALL_STATE(173)] = 7277,
  [SMALL_STATE(174)] = 7301,
  [SMALL_STATE(175)] = 7325,
  [SMALL_STATE(176)] = 7349,
  [SMALL_STATE(177)] = 7383,
  [SMALL_STATE(178)] = 7407,
  [SMALL_STATE(179)] = 7431,
  [SMALL_STATE(180)] = 7455,
  [SMALL_STATE(181)] = 7479,
  [SMALL_STATE(182)] = 7511,
  [SMALL_STATE(183)] = 7535,
  [SMALL_STATE(184)] = 7567,
  [SMALL_STATE(185)] = 7591,
  [SMALL_STATE(186)] = 7615,
  [SMALL_STATE(187)] = 7639,
  [SMALL_STATE(188)] = 7660,
  [SMALL_STATE(189)] = 7685,
  [SMALL_STATE(190)] = 7714,
  [SMALL_STATE(191)] = 7739,
  [SMALL_STATE(192)] = 7764,
  [SMALL_STATE(193)] = 7789,
  [SMALL_STATE(194)] = 7818,
  [SMALL_STATE(195)] = 7847,
  [SMALL_STATE(196)] = 7876,
  [SMALL_STATE(197)] = 7905,
  [SMALL_STATE(198)] = 7928,
  [SMALL_STATE(199)] = 7957,
  [SMALL_STATE(200)] = 7982,
  [SMALL_STATE(201)] = 8013,
  [SMALL_STATE(202)] = 8040,
  [SMALL_STATE(203)] = 8065,
  [SMALL_STATE(204)] = 8088,
  [SMALL_STATE(205)] = 8108,
  [SMALL_STATE(206)] = 8132,
  [SMALL_STATE(207)] = 8150,
  [SMALL_STATE(208)] = 8172,
  [SMALL_STATE(209)] = 8192,
  [SMALL_STATE(210)] = 8212,
  [SMALL_STATE(211)] = 8236,
  [SMALL_STATE(212)] = 8254,
  [SMALL_STATE(213)] = 8272,
  [SMALL_STATE(214)] = 8296,
  [SMALL_STATE(215)] = 8314,
  [SMALL_STATE(216)] = 8338,
  [SMALL_STATE(217)] = 8358,
  [SMALL_STATE(218)] = 8376,
  [SMALL_STATE(219)] = 8396,
  [SMALL_STATE(220)] = 8416,
  [SMALL_STATE(221)] = 8442,
  [SMALL_STATE(222)] = 8470,
  [SMALL_STATE(223)] = 8498,
  [SMALL_STATE(224)] = 8522,
  [SMALL_STATE(225)] = 8548,
  [SMALL_STATE(226)] = 8576,
  [SMALL_STATE(227)] = 8596,
  [SMALL_STATE(228)] = 8616,
  [SMALL_STATE(229)] = 8636,
  [SMALL_STATE(230)] = 8656,
  [SMALL_STATE(231)] = 8679,
  [SMALL_STATE(232)] = 8704,
  [SMALL_STATE(233)] = 8723,
  [SMALL_STATE(234)] = 8748,
  [SMALL_STATE(235)] = 8767,
  [SMALL_STATE(236)] = 8786,
  [SMALL_STATE(237)] = 8805,
  [SMALL_STATE(238)] = 8824,
  [SMALL_STATE(239)] = 8849,
  [SMALL_STATE(240)] = 8868,
  [SMALL_STATE(241)] = 8887,
  [SMALL_STATE(242)] = 8912,
  [SMALL_STATE(243)] = 8937,
  [SMALL_STATE(244)] = 8956,
  [SMALL_STATE(245)] = 8975,
  [SMALL_STATE(246)] = 9000,
  [SMALL_STATE(247)] = 9021,
  [SMALL_STATE(248)] = 9046,
  [SMALL_STATE(249)] = 9065,
  [SMALL_STATE(250)] = 9090,
  [SMALL_STATE(251)] = 9113,
  [SMALL_STATE(252)] = 9138,
  [SMALL_STATE(253)] = 9157,
  [SMALL_STATE(254)] = 9178,
  [SMALL_STATE(255)] = 9203,
  [SMALL_STATE(256)] = 9226,
  [SMALL_STATE(257)] = 9251,
  [SMALL_STATE(258)] = 9276,
  [SMALL_STATE(259)] = 9301,
  [SMALL_STATE(260)] = 9326,
  [SMALL_STATE(261)] = 9351,
  [SMALL_STATE(262)] = 9376,
  [SMALL_STATE(263)] = 9394,
  [SMALL_STATE(264)] = 9412,
  [SMALL_STATE(265)] = 9434,
  [SMALL_STATE(266)] = 9452,
  [SMALL_STATE(267)] = 9474,
  [SMALL_STATE(268)] = 9494,
  [SMALL_STATE(269)] = 9512,
  [SMALL_STATE(270)] = 9530,
  [SMALL_STATE(271)] = 9548,
  [SMALL_STATE(272)] = 9566,
  [SMALL_STATE(273)] = 9588,
  [SMALL_STATE(274)] = 9606,
  [SMALL_STATE(275)] = 9624,
  [SMALL_STATE(276)] = 9643,
  [SMALL_STATE(277)] = 9662,
  [SMALL_STATE(278)] = 9681,
  [SMALL_STATE(279)] = 9698,
  [SMALL_STATE(280)] = 9717,
  [SMALL_STATE(281)] = 9736,
  [SMALL_STATE(282)] = 9755,
  [SMALL_STATE(283)] = 9772,
  [SMALL_STATE(284)] = 9791,
  [SMALL_STATE(285)] = 9810,
  [SMALL_STATE(286)] = 9829,
  [SMALL_STATE(287)] = 9848,
  [SMALL_STATE(288)] = 9867,
  [SMALL_STATE(289)] = 9886,
  [SMALL_STATE(290)] = 9905,
  [SMALL_STATE(291)] = 9924,
  [SMALL_STATE(292)] = 9941,
  [SMALL_STATE(293)] = 9958,
  [SMALL_STATE(294)] = 9975,
  [SMALL_STATE(295)] = 9994,
  [SMALL_STATE(296)] = 10013,
  [SMALL_STATE(297)] = 10032,
  [SMALL_STATE(298)] = 10049,
  [SMALL_STATE(299)] = 10066,
  [SMALL_STATE(300)] = 10081,
  [SMALL_STATE(301)] = 10100,
  [SMALL_STATE(302)] = 10119,
  [SMALL_STATE(303)] = 10138,
  [SMALL_STATE(304)] = 10155,
  [SMALL_STATE(305)] = 10172,
  [SMALL_STATE(306)] = 10189,
  [SMALL_STATE(307)] = 10208,
  [SMALL_STATE(308)] = 10225,
  [SMALL_STATE(309)] = 10244,
  [SMALL_STATE(310)] = 10263,
  [SMALL_STATE(311)] = 10282,
  [SMALL_STATE(312)] = 10301,
  [SMALL_STATE(313)] = 10320,
  [SMALL_STATE(314)] = 10339,
  [SMALL_STATE(315)] = 10356,
  [SMALL_STATE(316)] = 10375,
  [SMALL_STATE(317)] = 10394,
  [SMALL_STATE(318)] = 10411,
  [SMALL_STATE(319)] = 10430,
  [SMALL_STATE(320)] = 10449,
  [SMALL_STATE(321)] = 10466,
  [SMALL_STATE(322)] = 10485,
  [SMALL_STATE(323)] = 10504,
  [SMALL_STATE(324)] = 10523,
  [SMALL_STATE(325)] = 10542,
  [SMALL_STATE(326)] = 10557,
  [SMALL_STATE(327)] = 10573,
  [SMALL_STATE(328)] = 10589,
  [SMALL_STATE(329)] = 10605,
  [SMALL_STATE(330)] = 10621,
  [SMALL_STATE(331)] = 10637,
  [SMALL_STATE(332)] = 10653,
  [SMALL_STATE(333)] = 10669,
  [SMALL_STATE(334)] = 10685,
  [SMALL_STATE(335)] = 10701,
  [SMALL_STATE(336)] = 10717,
  [SMALL_STATE(337)] = 10733,
  [SMALL_STATE(338)] = 10747,
  [SMALL_STATE(339)] = 10763,
  [SMALL_STATE(340)] = 10779,
  [SMALL_STATE(341)] = 10795,
  [SMALL_STATE(342)] = 10811,
  [SMALL_STATE(343)] = 10827,
  [SMALL_STATE(344)] = 10843,
  [SMALL_STATE(345)] = 10859,
  [SMALL_STATE(346)] = 10875,
  [SMALL_STATE(347)] = 10891,
  [SMALL_STATE(348)] = 10907,
  [SMALL_STATE(349)] = 10923,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [9] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [17] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_section, 1),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [45] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_section, 2),
  [47] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2),
  [49] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(242),
  [52] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(318),
  [55] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(319),
  [58] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(321),
  [61] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(322),
  [64] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(323),
  [67] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(312),
  [70] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(301),
  [73] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(294),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(286),
  [79] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(181),
  [82] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(163),
  [85] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 2), SHIFT_REPEAT(333),
  [88] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier, 1),
  [90] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__namespace_identifier, 1),
  [92] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier, 1),
  [94] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_shape_id_repeat1, 2),
  [96] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_id_repeat1, 2), SHIFT_REPEAT(287),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_id, 2),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_id, 1),
  [105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_root_shape_id, 1),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_shape_id_repeat1, 1),
  [109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_id_member, 2),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_absolute_root_shape_id, 3),
  [113] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_statement, 2),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node_object, 3),
  [143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node_object, 2),
  [145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_body, 2),
  [147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_statement, 3),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_body, 3),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace, 1),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_namespace_repeat1, 2),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_repeat1, 2), SHIFT_REPEAT(310),
  [160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace, 2),
  [162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_shape_statement_repeat1, 2),
  [164] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_statement_repeat1, 2), SHIFT_REPEAT(181),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [191] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_array_repeat1, 2), SHIFT_REPEAT(118),
  [194] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_array_repeat1, 2), SHIFT_REPEAT(36),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_node_array_repeat1, 2),
  [199] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_array_repeat1, 2), SHIFT_REPEAT(92),
  [202] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_array_repeat1, 2), SHIFT_REPEAT(90),
  [205] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_array_repeat1, 2), SHIFT_REPEAT(300),
  [208] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_array_repeat1, 2), SHIFT_REPEAT(93),
  [211] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_array_repeat1, 2), SHIFT_REPEAT(95),
  [214] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_array_repeat1, 2), SHIFT_REPEAT(196),
  [217] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_array_repeat1, 2), SHIFT_REPEAT(147),
  [220] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_array_repeat1, 2), SHIFT_REPEAT(83),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simple_shape_statement, 2),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_shape_statement_repeat1, 1),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mixins, 4),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [251] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_apply_statement, 1),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_members, 2),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simple_shape_statement, 3),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_apply_statement_singular, 3),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_members, 2),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_resource_statement, 3),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_statement, 3),
  [273] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_statement, 3),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_statement, 3),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_statement, 3),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_statement, 3),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_statement, 3),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_statement, 3),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_statement, 3),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_shape_section_repeat1, 1),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__definition, 1),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_statement, 1),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_body, 1),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_statement, 4),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_statement, 4),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_statement, 4),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_statement, 4),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_statement, 4),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_statement, 4),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_service_statement, 4),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_body, 2),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_statement, 4),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_resource_statement, 4),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_statement, 2),
  [317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_apply_statement_block, 4),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_members, 3),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_members, 3),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_statement, 5),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_body, 3),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_apply_statement_block, 5),
  [329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_statement, 2),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_statement, 2),
  [333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shape_id, 1),
  [337] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_id_repeat1, 2), SHIFT_REPEAT(285),
  [340] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_shape_id_repeat1, 2),
  [342] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__namespace_identifier, 1),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shape_id, 2),
  [346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_root_shape_id, 1),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_shape_id_repeat1, 1),
  [350] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shape_id_member, 2),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_absolute_root_shape_id, 3),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 1),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1),
  [368] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1),
  [370] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_id_repeat1, 2), SHIFT_REPEAT(309),
  [373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float, 1),
  [375] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float, 1),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node_value, 1),
  [379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node_value, 1),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_literal, 2),
  [383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_literal, 2),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__multiline_string_literal, 2),
  [387] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__multiline_string_literal, 2),
  [389] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node_object, 2),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node_array, 2),
  [393] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node_array, 2),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 2),
  [397] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 2),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node_array, 3),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node_array, 3),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_node_array_repeat1, 1),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_node_array_repeat1, 1),
  [407] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node_object, 3),
  [409] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__multiline_string_literal, 3),
  [411] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__multiline_string_literal, 3),
  [413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_literal, 3),
  [415] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_literal, 3),
  [417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float, 2),
  [419] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float, 2),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_structure, 1),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_control_var_name, 3, .production_id = 1),
  [435] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_control_var_name, 3, .production_id = 1),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_trait_structure_repeat1, 2),
  [441] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_trait_structure_repeat1, 2), SHIFT_REPEAT(195),
  [444] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trait_structure_repeat1, 2), SHIFT_REPEAT(138),
  [447] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trait_structure_repeat1, 2), SHIFT_REPEAT(6),
  [450] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_node_object_repeat1, 2),
  [452] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_node_object_repeat1, 2), SHIFT_REPEAT(195),
  [455] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_object_repeat1, 2), SHIFT_REPEAT(138),
  [458] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_node_object_repeat1, 2), SHIFT_REPEAT(6),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [473] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_members_repeat1, 2), SHIFT_REPEAT(315),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_shape_members_repeat1, 2),
  [478] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_members_repeat1, 2), SHIFT_REPEAT(157),
  [481] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_members_repeat1, 2), SHIFT_REPEAT(6),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_mixins_repeat1, 2),
  [498] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_mixins_repeat1, 2), SHIFT_REPEAT(100),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [505] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__multiline_string_literal_repeat1, 2),
  [507] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__multiline_string_literal_repeat1, 2), SHIFT_REPEAT(214),
  [510] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__multiline_string_literal_repeat1, 2), SHIFT_REPEAT(203),
  [513] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__multiline_string_literal_repeat1, 2), SHIFT_REPEAT(217),
  [516] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__multiline_string_literal_repeat1, 2), SHIFT_REPEAT(211),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [521] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [523] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [525] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [527] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [529] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_members_repeat1, 2),
  [539] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_members_repeat1, 2), SHIFT_REPEAT(166),
  [542] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_members_repeat1, 2), SHIFT_REPEAT(122),
  [545] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [547] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [551] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_control_section, 1),
  [561] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_control_section_repeat1, 2),
  [563] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_control_section_repeat1, 2), SHIFT_REPEAT(167),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operation_body_repeat1, 2),
  [570] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_operation_body_repeat1, 2), SHIFT_REPEAT(6),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [575] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__multiline_string_fragment_repeat1, 2),
  [577] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__multiline_string_fragment_repeat1, 2), SHIFT_REPEAT(212),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_member, 3, .production_id = 7),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [590] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_member, 4, .production_id = 9),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_member, 1),
  [596] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [598] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [600] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [602] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [604] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__multiline_string_fragment, 2),
  [606] = {.entry = {.count = 1, .reusable = false}}, SHIFT(212),
  [608] = {.entry = {.count = 1, .reusable = false}}, SHIFT(175),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__string_literal_repeat1, 2),
  [614] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__string_literal_repeat1, 2), SHIFT_REPEAT(235),
  [617] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__string_literal_repeat1, 2), SHIFT_REPEAT(236),
  [620] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__string_literal_repeat1, 2), SHIFT_REPEAT(237),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_member, 2),
  [625] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__multiline_string_fragment, 1),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_member_elided, 2),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_metadata_section_repeat1, 2),
  [631] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_metadata_section_repeat1, 2), SHIFT_REPEAT(152),
  [634] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__multiline_string_literal_repeat1, 1),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node_object_kvp, 3),
  [638] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node_object_kvp, 3),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 2, .production_id = 6),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__escape_sequence, 1),
  [646] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__multiline_string_fragment_repeat1, 1),
  [648] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 1, .production_id = 3),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operation_errors_repeat1, 2),
  [654] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_operation_errors_repeat1, 2), SHIFT_REPEAT(122),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [659] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_statement_repeat1, 2), SHIFT_REPEAT(157),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metadata_section, 1),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_member, 1),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_assignment, 2),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_member, 3),
  [672] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__string_literal_repeat1, 1),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__string_literal_repeat1, 1),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__escape_sequence, 1),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_control_section_repeat1, 1),
  [680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_member, 4, .production_id = 7),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_control_statement, 2),
  [688] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_shape_members_repeat1, 1),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_node_object_repeat1, 1),
  [692] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_node_object_repeat1, 1),
  [694] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shape_member, 5, .production_id = 9),
  [696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 2),
  [698] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operation_member_repeat1, 2),
  [700] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_operation_member_repeat1, 2), SHIFT_REPEAT(6),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_trait_structure_repeat1, 1, .production_id = 5),
  [707] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_trait_structure_repeat1, 1, .production_id = 5),
  [709] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shape_statement_repeat1, 2), SHIFT_REPEAT(166),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [716] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_members_repeat1, 1),
  [718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 3, .production_id = 6),
  [720] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metadata_statement, 4),
  [722] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node_object_key, 1, .production_id = 2),
  [728] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 2, .production_id = 3),
  [730] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_metadata_section_repeat1, 1),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [734] = {.entry = {.count = 1, .reusable = false}}, SHIFT(218),
  [736] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [738] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_member, 2),
  [740] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_mixins_repeat1, 1),
  [742] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [744] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node_object_key, 1),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operation_member_repeat1, 3, .production_id = 8),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inline_structure, 5),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inline_structure, 2),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_errors, 5, .production_id = 10),
  [758] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [760] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [764] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operation_body_repeat1, 1),
  [766] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inline_structure, 4),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_resource, 2),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inline_structure, 3),
  [772] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_error, 1),
  [774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operation_errors_repeat1, 1),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_errors, 4, .production_id = 10),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_body_value, 1, .production_id = 4),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__control_identifier, 1),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primitive, 1),
  [792] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 3),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [798] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trait_body_value, 1),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_documentation_comment, 2),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_smithy(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
