#pragma once

#include <cstdint>
#include <string>
#include <aquamarine/backend/Misc.hpp>
#include <hyprutils/math/Vector2D.hpp>

namespace Hyprtoolkit {
    using DRMFormat = uint32_t;
    using SHMFormat = uint32_t;

    struct SPixelFormat {
        DRMFormat                 drmFormat        = 0; /* DRM_FORMAT_INVALID */
        bool                      flipRB           = false;
        int                       glInternalFormat = 0;
        int                       glFormat         = 0;
        int                       glType           = 0;
        bool                      withAlpha        = true;
        DRMFormat                 alphaStripped    = 0; /* DRM_FORMAT_INVALID */
        uint32_t                  bytesPerBlock    = 0;
        Hyprutils::Math::Vector2D blockSize;
    };

    using SDRMFormat = Aquamarine::SDRMFormat;

    namespace NFormatUtils {
        const SPixelFormat* getPixelFormatFromDRM(DRMFormat drm);
        const SPixelFormat* getPixelFormatFromGL(uint32_t glFormat, uint32_t glType, bool alpha);
        bool                isFormatOpaque(DRMFormat drm);
        int                 pixelsPerBlock(const SPixelFormat* const fmt);
        int                 minStride(const SPixelFormat* const fmt, int32_t width);
        uint32_t            drmFormatToGL(DRMFormat drm);
        uint32_t            glFormatToType(uint32_t gl);
        std::string         drmFormatName(DRMFormat drm);
        std::string         drmModifierName(uint64_t mod);
    };
}
