/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	resource "k8s.io/apimachinery/pkg/api/resource"
)

// CapacityRequestPolicyRangeApplyConfiguration represents a declarative configuration of the CapacityRequestPolicyRange type for use
// with apply.
//
// CapacityRequestPolicyRange defines a valid range for consumable capacity values.
//
// - If the requested amount is less than Min, it is rounded up to the Min value.
// - If Step is set and the requested amount is between Min and Max but not aligned with Step,
// it will be rounded up to the next value equal to Min + (n * Step).
// - If Step is not set, the requested amount is used as-is if it falls within the range Min to Max (if set).
// - If the requested or rounded amount exceeds Max (if set), the request does not satisfy the policy,
// and the device cannot be allocated.
type CapacityRequestPolicyRangeApplyConfiguration struct {
	// Min specifies the minimum capacity allowed for a consumption request.
	//
	// Min must be greater than or equal to zero,
	// and less than or equal to the capacity value.
	// requestPolicy.default must be more than or equal to the minimum.
	Min *resource.Quantity `json:"min,omitempty"`
	// Max defines the upper limit for capacity that can be requested.
	//
	// Max must be less than or equal to the capacity value.
	// Min and requestPolicy.default must be less than or equal to the maximum.
	Max *resource.Quantity `json:"max,omitempty"`
	// Step defines the step size between valid capacity amounts within the range.
	//
	// Max (if set) and requestPolicy.default must be a multiple of Step.
	// Min + Step must be less than or equal to the capacity value.
	Step *resource.Quantity `json:"step,omitempty"`
}

// CapacityRequestPolicyRangeApplyConfiguration constructs a declarative configuration of the CapacityRequestPolicyRange type for use with
// apply.
func CapacityRequestPolicyRange() *CapacityRequestPolicyRangeApplyConfiguration {
	return &CapacityRequestPolicyRangeApplyConfiguration{}
}

// WithMin sets the Min field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Min field is set to the value of the last call.
func (b *CapacityRequestPolicyRangeApplyConfiguration) WithMin(value resource.Quantity) *CapacityRequestPolicyRangeApplyConfiguration {
	b.Min = &value
	return b
}

// WithMax sets the Max field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Max field is set to the value of the last call.
func (b *CapacityRequestPolicyRangeApplyConfiguration) WithMax(value resource.Quantity) *CapacityRequestPolicyRangeApplyConfiguration {
	b.Max = &value
	return b
}

// WithStep sets the Step field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Step field is set to the value of the last call.
func (b *CapacityRequestPolicyRangeApplyConfiguration) WithStep(value resource.Quantity) *CapacityRequestPolicyRangeApplyConfiguration {
	b.Step = &value
	return b
}
