/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// CSINodeDriverApplyConfiguration represents a declarative configuration of the CSINodeDriver type for use
// with apply.
//
// CSINodeDriver holds information about the specification of one CSI driver installed on a node
type CSINodeDriverApplyConfiguration struct {
	// name represents the name of the CSI driver that this object refers to.
	// This MUST be the same name returned by the CSI GetPluginName() call for
	// that driver.
	Name *string `json:"name,omitempty"`
	// nodeID of the node from the driver point of view.
	// This field enables Kubernetes to communicate with storage systems that do
	// not share the same nomenclature for nodes. For example, Kubernetes may
	// refer to a given node as "node1", but the storage system may refer to
	// the same node as "nodeA". When Kubernetes issues a command to the storage
	// system to attach a volume to a specific node, it can use this field to
	// refer to the node name using the ID that the storage system will
	// understand, e.g. "nodeA" instead of "node1". This field is required.
	NodeID *string `json:"nodeID,omitempty"`
	// topologyKeys is the list of keys supported by the driver.
	// When a driver is initialized on a cluster, it provides a set of topology
	// keys that it understands (e.g. "company.com/zone", "company.com/region").
	// When a driver is initialized on a node, it provides the same topology keys
	// along with values. Kubelet will expose these topology keys as labels
	// on its own node object.
	// When Kubernetes does topology aware provisioning, it can use this list to
	// determine which labels it should retrieve from the node object and pass
	// back to the driver.
	// It is possible for different nodes to use different topology keys.
	// This can be empty if driver does not support topology.
	TopologyKeys []string `json:"topologyKeys,omitempty"`
	// allocatable represents the volume resources of a node that are available for scheduling.
	Allocatable *VolumeNodeResourcesApplyConfiguration `json:"allocatable,omitempty"`
}

// CSINodeDriverApplyConfiguration constructs a declarative configuration of the CSINodeDriver type for use with
// apply.
func CSINodeDriver() *CSINodeDriverApplyConfiguration {
	return &CSINodeDriverApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *CSINodeDriverApplyConfiguration) WithName(value string) *CSINodeDriverApplyConfiguration {
	b.Name = &value
	return b
}

// WithNodeID sets the NodeID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeID field is set to the value of the last call.
func (b *CSINodeDriverApplyConfiguration) WithNodeID(value string) *CSINodeDriverApplyConfiguration {
	b.NodeID = &value
	return b
}

// WithTopologyKeys adds the given value to the TopologyKeys field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the TopologyKeys field.
func (b *CSINodeDriverApplyConfiguration) WithTopologyKeys(values ...string) *CSINodeDriverApplyConfiguration {
	for i := range values {
		b.TopologyKeys = append(b.TopologyKeys, values[i])
	}
	return b
}

// WithAllocatable sets the Allocatable field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Allocatable field is set to the value of the last call.
func (b *CSINodeDriverApplyConfiguration) WithAllocatable(value *VolumeNodeResourcesApplyConfiguration) *CSINodeDriverApplyConfiguration {
	b.Allocatable = value
	return b
}
