/* Generated by wayland-scanner 1.24.0 */

#ifndef XDG_TOPLEVEL_TAG_V1_CLIENT_PROTOCOL_H
#define XDG_TOPLEVEL_TAG_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_xdg_toplevel_tag_v1 The xdg_toplevel_tag_v1 protocol
 * @section page_ifaces_xdg_toplevel_tag_v1 Interfaces
 * - @subpage page_iface_xdg_toplevel_tag_manager_v1 - protocol for setting toplevel tags
 * @section page_copyright_xdg_toplevel_tag_v1 Copyright
 * <pre>
 *
 * Copyright © 2024 Xaver Hugl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct xdg_toplevel;
struct xdg_toplevel_tag_manager_v1;

#ifndef XDG_TOPLEVEL_TAG_MANAGER_V1_INTERFACE
#define XDG_TOPLEVEL_TAG_MANAGER_V1_INTERFACE
/**
 * @page page_iface_xdg_toplevel_tag_manager_v1 xdg_toplevel_tag_manager_v1
 * @section page_iface_xdg_toplevel_tag_manager_v1_desc Description
 *
 * In order to make some window properties like position, size,
 * "always on top" or user defined rules for window behavior persistent, the
 * compositor needs some way to identify windows even after the application
 * has been restarted.
 * This protocol allows clients to make this possible by setting a tag for
 * toplevels.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_xdg_toplevel_tag_manager_v1_api API
 * See @ref iface_xdg_toplevel_tag_manager_v1.
 */
/**
 * @defgroup iface_xdg_toplevel_tag_manager_v1 The xdg_toplevel_tag_manager_v1 interface
 *
 * In order to make some window properties like position, size,
 * "always on top" or user defined rules for window behavior persistent, the
 * compositor needs some way to identify windows even after the application
 * has been restarted.
 * This protocol allows clients to make this possible by setting a tag for
 * toplevels.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface xdg_toplevel_tag_manager_v1_interface;
#endif

#define XDG_TOPLEVEL_TAG_MANAGER_V1_DESTROY 0
#define XDG_TOPLEVEL_TAG_MANAGER_V1_SET_TOPLEVEL_TAG 1
#define XDG_TOPLEVEL_TAG_MANAGER_V1_SET_TOPLEVEL_DESCRIPTION 2


/**
 * @ingroup iface_xdg_toplevel_tag_manager_v1
 */
#define XDG_TOPLEVEL_TAG_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_tag_manager_v1
 */
#define XDG_TOPLEVEL_TAG_MANAGER_V1_SET_TOPLEVEL_TAG_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_tag_manager_v1
 */
#define XDG_TOPLEVEL_TAG_MANAGER_V1_SET_TOPLEVEL_DESCRIPTION_SINCE_VERSION 1

/** @ingroup iface_xdg_toplevel_tag_manager_v1 */
static inline void
xdg_toplevel_tag_manager_v1_set_user_data(struct xdg_toplevel_tag_manager_v1 *xdg_toplevel_tag_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) xdg_toplevel_tag_manager_v1, user_data);
}

/** @ingroup iface_xdg_toplevel_tag_manager_v1 */
static inline void *
xdg_toplevel_tag_manager_v1_get_user_data(struct xdg_toplevel_tag_manager_v1 *xdg_toplevel_tag_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) xdg_toplevel_tag_manager_v1);
}

static inline uint32_t
xdg_toplevel_tag_manager_v1_get_version(struct xdg_toplevel_tag_manager_v1 *xdg_toplevel_tag_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_tag_manager_v1);
}

/**
 * @ingroup iface_xdg_toplevel_tag_manager_v1
 *
 * Destroy this toplevel tag manager object. This request has no other
 * effects.
 */
static inline void
xdg_toplevel_tag_manager_v1_destroy(struct xdg_toplevel_tag_manager_v1 *xdg_toplevel_tag_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xdg_toplevel_tag_manager_v1,
			 XDG_TOPLEVEL_TAG_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_tag_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_xdg_toplevel_tag_manager_v1
 *
 * Set a tag for a toplevel. The tag may be shown to the user in UI, so
 * it's preferable for it to be human readable, but it must be suitable
 * for configuration files and should not be translated.
 * Suitable tags would for example be "main window", "settings",
 * "e-mail composer" or similar.
 *
 * The tag does not need to be unique across applications, and the client
 * may set the same tag for multiple windows, for example if the user has
 * opened the same UI twice. How the potentially resulting conflicts are
 * handled is compositor policy.
 *
 * The client should set the tag as part of the initial commit on the
 * associated toplevel, but it may set it at any time afterwards as well,
 * for example if the purpose of the toplevel changes.
 */
static inline void
xdg_toplevel_tag_manager_v1_set_toplevel_tag(struct xdg_toplevel_tag_manager_v1 *xdg_toplevel_tag_manager_v1, struct xdg_toplevel *toplevel, const char *tag)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xdg_toplevel_tag_manager_v1,
			 XDG_TOPLEVEL_TAG_MANAGER_V1_SET_TOPLEVEL_TAG, NULL, wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_tag_manager_v1), 0, toplevel, tag);
}

/**
 * @ingroup iface_xdg_toplevel_tag_manager_v1
 *
 * Set a description for a toplevel. This description may be shown to the
 * user in UI or read by a screen reader for accessibility purposes, and
 * should be translated.
 * It is recommended to make the description the translation of the tag.
 *
 * The client should set the description as part of the initial commit on
 * the associated toplevel, but it may set it at any time afterwards as
 * well, for example if the purpose of the toplevel changes.
 */
static inline void
xdg_toplevel_tag_manager_v1_set_toplevel_description(struct xdg_toplevel_tag_manager_v1 *xdg_toplevel_tag_manager_v1, struct xdg_toplevel *toplevel, const char *description)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xdg_toplevel_tag_manager_v1,
			 XDG_TOPLEVEL_TAG_MANAGER_V1_SET_TOPLEVEL_DESCRIPTION, NULL, wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_tag_manager_v1), 0, toplevel, description);
}

#ifdef  __cplusplus
}
#endif

#endif
