// This file is generated by kconfig_compiler_kf6 from kscreenlockersettings.kcfg.
// All changes you do to this file will be lost.
#ifndef KSCREENSAVERSETTINGSBASE_H
#define KSCREENSAVERSETTINGSBASE_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class KScreenSaverSettingsBase : public KConfigSkeleton
{
  Q_OBJECT
  public:

    static KScreenSaverSettingsBase *self();
    ~KScreenSaverSettingsBase() override;

    /**
      Set Screen lock enabled
    */
    static
    void setAutolock( bool v )
    {
      if (v != self()->mAutolock && !self()->isAutolockImmutable()) {
        self()->mAutolock = v;
        Q_EMIT self()->AutolockChanged();
      }
    }

    Q_PROPERTY(bool autolock READ autolock WRITE setAutolock NOTIFY AutolockChanged)
    Q_PROPERTY(bool isAutolockImmutable READ isAutolockImmutable CONSTANT)
    /**
      Get Screen lock enabled
    */
    static
    bool autolock()
    {
      return self()->mAutolock;
    }

    /**
      Is Screen lock enabled Immutable
    */
    static
    bool isAutolockImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Autolock" ) );
    }

    /**
      Set Screen saver timeout
    */
    static
    void setTimeout( double v )
    {
      if (v != self()->mTimeout && !self()->isTimeoutImmutable()) {
        self()->mTimeout = v;
        Q_EMIT self()->TimeoutChanged();
      }
    }

    Q_PROPERTY(double timeout READ timeout WRITE setTimeout NOTIFY TimeoutChanged)
    Q_PROPERTY(bool isTimeoutImmutable READ isTimeoutImmutable CONSTANT)
    /**
      Get Screen saver timeout
    */
    static
    double timeout()
    {
      return self()->mTimeout;
    }

    /**
      Is Screen saver timeout Immutable
    */
    static
    bool isTimeoutImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Timeout" ) );
    }

    /**
      Set Lock
    */
    static
    void setLock( bool v )
    {
      if (v != self()->mLock && !self()->isLockImmutable()) {
        self()->mLock = v;
        Q_EMIT self()->LockChanged();
      }
    }

    Q_PROPERTY(bool lock READ lock WRITE setLock NOTIFY LockChanged)
    Q_PROPERTY(bool isLockImmutable READ isLockImmutable CONSTANT)
    /**
      Get Lock
    */
    static
    bool lock()
    {
      return self()->mLock;
    }

    /**
      Is Lock Immutable
    */
    static
    bool isLockImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Lock" ) );
    }

    /**
      Set LockGrace
    */
    static
    void setLockGrace( int v )
    {
      if (v != self()->mLockGrace && !self()->isLockGraceImmutable()) {
        self()->mLockGrace = v;
        Q_EMIT self()->LockGraceChanged();
      }
    }

    Q_PROPERTY(int lockGrace READ lockGrace WRITE setLockGrace NOTIFY LockGraceChanged)
    Q_PROPERTY(bool isLockGraceImmutable READ isLockGraceImmutable CONSTANT)
    /**
      Get LockGrace
    */
    static
    int lockGrace()
    {
      return self()->mLockGrace;
    }

    /**
      Is LockGrace Immutable
    */
    static
    bool isLockGraceImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LockGrace" ) );
    }

    /**
      Set Require password
    */
    static
    void setRequirePassword( bool v )
    {
      if (v != self()->mRequirePassword && !self()->isRequirePasswordImmutable()) {
        self()->mRequirePassword = v;
        Q_EMIT self()->RequirePasswordChanged();
      }
    }

    Q_PROPERTY(bool requirePassword READ requirePassword WRITE setRequirePassword NOTIFY RequirePasswordChanged)
    Q_PROPERTY(bool isRequirePasswordImmutable READ isRequirePasswordImmutable CONSTANT)
    /**
      Get Require password
    */
    static
    bool requirePassword()
    {
      return self()->mRequirePassword;
    }

    /**
      Is Require password Immutable
    */
    static
    bool isRequirePasswordImmutable()
    {
      return self()->isImmutable( QStringLiteral( "RequirePassword" ) );
    }

    /**
      Set LockOnResume
    */
    static
    void setLockOnResume( bool v )
    {
      if (v != self()->mLockOnResume && !self()->isLockOnResumeImmutable()) {
        self()->mLockOnResume = v;
        Q_EMIT self()->LockOnResumeChanged();
      }
    }

    Q_PROPERTY(bool lockOnResume READ lockOnResume WRITE setLockOnResume NOTIFY LockOnResumeChanged)
    Q_PROPERTY(bool isLockOnResumeImmutable READ isLockOnResumeImmutable CONSTANT)
    /**
      Get LockOnResume
    */
    static
    bool lockOnResume()
    {
      return self()->mLockOnResume;
    }

    /**
      Is LockOnResume Immutable
    */
    static
    bool isLockOnResumeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LockOnResume" ) );
    }

    /**
      Set Defines if the session is locked on startup
    */
    static
    void setLockOnStart( bool v )
    {
      if (v != self()->mLockOnStart && !self()->isLockOnStartImmutable()) {
        self()->mLockOnStart = v;
        Q_EMIT self()->LockOnStartChanged();
      }
    }

    Q_PROPERTY(bool lockOnStart READ lockOnStart WRITE setLockOnStart NOTIFY LockOnStartChanged)
    Q_PROPERTY(bool isLockOnStartImmutable READ isLockOnStartImmutable CONSTANT)
    /**
      Get Defines if the session is locked on startup
    */
    static
    bool lockOnStart()
    {
      return self()->mLockOnStart;
    }

    /**
      Is Defines if the session is locked on startup Immutable
    */
    static
    bool isLockOnStartImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LockOnStart" ) );
    }

    /**
      Set Theme
    */
    static
    void setTheme( const QString & v )
    {
      if (v != self()->mTheme && !self()->isThemeImmutable()) {
        self()->mTheme = v;
        Q_EMIT self()->ThemeChanged();
      }
    }

    Q_PROPERTY(QString theme READ theme WRITE setTheme NOTIFY ThemeChanged)
    Q_PROPERTY(bool isThemeImmutable READ isThemeImmutable CONSTANT)
    /**
      Get Theme
    */
    static
    QString theme()
    {
      return self()->mTheme;
    }

    /**
      Is Theme Immutable
    */
    static
    bool isThemeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Theme" ) );
    }

    /**
      Set WallpaperPlugin
    */
    static
    void setWallpaperPluginId( const QString & v )
    {
      if (v != self()->mWallpaperPluginId && !self()->isWallpaperPluginIdImmutable()) {
        self()->mWallpaperPluginId = v;
        Q_EMIT self()->wallpaperPluginIdChanged();
      }
    }

    Q_PROPERTY(QString wallpaperPluginId READ wallpaperPluginId WRITE setWallpaperPluginId NOTIFY wallpaperPluginIdChanged)
    Q_PROPERTY(bool isWallpaperPluginIdImmutable READ isWallpaperPluginIdImmutable CONSTANT)
    /**
      Get WallpaperPlugin
    */
    static
    QString wallpaperPluginId()
    {
      return self()->mWallpaperPluginId;
    }

    /**
      Is WallpaperPlugin Immutable
    */
    static
    bool isWallpaperPluginIdImmutable()
    {
      return self()->isImmutable( QStringLiteral( "wallpaperPluginId" ) );
    }


    enum {
      signalAutolockChanged = 1,
      signalTimeoutChanged = 2,
      signalLockChanged = 3,
      signalLockGraceChanged = 4,
      signalRequirePasswordChanged = 5,
      signalLockOnResumeChanged = 6,
      signalLockOnStartChanged = 7,
      signalThemeChanged = 8,
      signalWallpaperPluginIdChanged = 9
    };

  Q_SIGNALS:
    void AutolockChanged();

    void TimeoutChanged();

    void LockChanged();

    void LockGraceChanged();

    void RequirePasswordChanged();

    void LockOnResumeChanged();

    void LockOnStartChanged();

    void ThemeChanged();

    void wallpaperPluginIdChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    KScreenSaverSettingsBase();
    friend class KScreenSaverSettingsBaseHelper;


    // Daemon
    bool mAutolock;
    double mTimeout;
    bool mLock;
    int mLockGrace;
    bool mRequirePassword;
    bool mLockOnResume;
    bool mLockOnStart;

    // Greeter
    QString mTheme;
    QString mWallpaperPluginId;
};

#endif

