/*
 * Copyright 2022, Oak Ridge National Laboratory.
 * MGARD-X: MultiGrid Adaptive Reduction of Data Portable across GPUs and CPUs
 * Author: Jieyang Chen (chenj3@ornl.gov)
 * Date: March 17, 2022
 */

#include "mgard-x/DataRefactoring/MultiDimension/Correction/CalcCorrectionND.hpp"
// clang-format off
namespace mgard_x {

namespace data_refactoring {

namespace multi_dimension {

template void CalcCorrectionND<4, double, OPENMP>(
    Hierarchy<4, double, OPENMP> &hierarchy,
    SubArray<4, double, OPENMP> dcoeff,
    SubArray<4, double, OPENMP> &dcorrection, SIZE l,
    int queue_idx);

} // namespace multi_dimension

} // namespace data_refactoring

} // namespace mgard_x
// clang-format on
