/* ThemeEditor.c generated by valac 0.56.18, the Vala compiler
 * generated from ThemeEditor.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <handy.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THEME_EDITOR (theme_editor_get_type ())
#define THEME_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_EDITOR, ThemeEditor))
#define THEME_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_EDITOR, ThemeEditorClass))
#define IS_THEME_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_EDITOR))
#define IS_THEME_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_EDITOR))
#define THEME_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_EDITOR, ThemeEditorClass))

typedef struct _ThemeEditor ThemeEditor;
typedef struct _ThemeEditorClass ThemeEditorClass;
typedef struct _ThemeEditorPrivate ThemeEditorPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
enum  {
	THEME_EDITOR_0_PROPERTY,
	THEME_EDITOR_NUM_PROPERTIES
};
static GParamSpec* theme_editor_properties[THEME_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_THEMES (themes_get_type ())
#define THEMES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMES, Themes))
#define THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMES, ThemesClass))
#define IS_THEMES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMES))
#define IS_THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMES))
#define THEMES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMES, ThemesClass))

typedef struct _Themes Themes;
typedef struct _ThemesClass ThemesClass;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
typedef struct _Block54Data Block54Data;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

struct _ThemeEditor {
	GtkBox parent_instance;
	ThemeEditorPrivate * priv;
};

struct _ThemeEditorClass {
	GtkBoxClass parent_class;
};

struct _ThemeEditorPrivate {
	MainWindow* _win;
	Theme* _theme;
	Theme* _orig_theme;
	gboolean _edit;
	GtkEntry* _name;
	GeeHashMap* _btns;
	GtkSwitch* _prefer_dark;
	GtkRevealer* _delrev;
};

struct _Block54Data {
	int _ref_count_;
	ThemeEditor* self;
	GtkColorButton* btn;
	gchar* name;
};

static gint ThemeEditor_private_offset;
static gpointer theme_editor_parent_class = NULL;

VALA_EXTERN GType theme_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeEditor, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN ThemeEditor* theme_editor_new (MainWindow* win);
VALA_EXTERN ThemeEditor* theme_editor_construct (GType object_type,
                                     MainWindow* win);
VALA_EXTERN gchar* utils_make_title (const gchar* str);
static gboolean __lambda102_ (ThemeEditor* self,
                       GdkEventFocus* e);
VALA_EXTERN const gchar* theme_get_name (Theme* self);
VALA_EXTERN GType themes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Themes, g_object_unref)
VALA_EXTERN Themes* main_window_get_themes (MainWindow* self);
VALA_EXTERN gchar* themes_uniquify_name (Themes* self,
                             const gchar* name);
static gboolean ___lambda102__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                   GdkEventFocus* event,
                                                   gpointer self);
static void theme_editor_add_color (ThemeEditor* self,
                             const gchar* lbl_str,
                             const gchar* name,
                             GtkGrid* grid,
                             gint row);
static gboolean __lambda104_ (ThemeEditor* self,
                       GdkEventButton* e);
VALA_EXTERN gboolean theme_get_prefer_dark (Theme* self);
VALA_EXTERN void theme_set_prefer_dark (Theme* self,
                            gboolean value);
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN DrawArea* main_window_get_current_da (MainWindow* self,
                                      const gchar* caller);
VALA_EXTERN void draw_area_set_theme (DrawArea* self,
                          Theme* theme,
                          gboolean save);
static gboolean ___lambda104__gtk_widget_button_release_event (GtkWidget* _sender,
                                                        GdkEventButton* event,
                                                        gpointer self);
VALA_EXTERN gint theme_num_link_colors (void);
static void theme_editor_confirm_deletion (ThemeEditor* self);
static void _theme_editor_confirm_deletion_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static void theme_editor_close_window (ThemeEditor* self);
static void _theme_editor_close_window_gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self);
static void theme_editor_save_theme (ThemeEditor* self);
static void _theme_editor_save_theme_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static void __lambda103_ (Block54Data* _data54_);
VALA_EXTERN gboolean theme_set_color (Theme* self,
                          const gchar* name,
                          GdkRGBA* color);
static void ___lambda103__gtk_color_button_color_set (GtkColorButton* _sender,
                                               gpointer self);
VALA_EXTERN void theme_editor_initialize (ThemeEditor* self,
                              Theme* theme,
                              gboolean edit);
VALA_EXTERN Theme* theme_new_from_theme (Theme* theme);
VALA_EXTERN Theme* theme_construct_from_theme (GType object_type,
                                   Theme* theme);
VALA_EXTERN void theme_set_label (Theme* self,
                      const gchar* value);
VALA_EXTERN void theme_set_name (Theme* self,
                     const gchar* value);
VALA_EXTERN GArray* theme_colors (Theme* self);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN gboolean theme_get_temporary (Theme* self);
static void theme_editor_delete_theme (ThemeEditor* self);
VALA_EXTERN Theme* themes_get_theme (Themes* self,
                         const gchar* name);
VALA_EXTERN void themes_delete_theme (Themes* self,
                          const gchar* name);
VALA_EXTERN void main_window_hide_theme_editor (MainWindow* self);
VALA_EXTERN void theme_copy (Theme* self,
                 Theme* theme);
VALA_EXTERN void theme_set_temporary (Theme* self,
                          gboolean value);
VALA_EXTERN void themes_add_theme (Themes* self,
                       Theme* theme);
static void theme_editor_finalize (GObject * obj);
static GType theme_editor_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
theme_editor_get_instance_private (ThemeEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ThemeEditor_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda102_ (ThemeEditor* self,
              GdkEventFocus* e)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (!self->priv->_edit) {
		_tmp0_ = TRUE;
	} else {
		GtkEntry* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		Theme* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp1_ = self->priv->_name;
		_tmp2_ = gtk_entry_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_orig_theme;
		_tmp5_ = theme_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp6_) != 0;
	}
	if (_tmp0_) {
		GtkEntry* _tmp7_;
		MainWindow* _tmp8_;
		Themes* _tmp9_;
		Themes* _tmp10_;
		GtkEntry* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp7_ = self->priv->_name;
		_tmp8_ = self->priv->_win;
		_tmp9_ = main_window_get_themes (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_name;
		_tmp12_ = gtk_entry_get_text (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = themes_uniquify_name (_tmp10_, _tmp13_);
		_tmp15_ = _tmp14_;
		gtk_entry_set_text (_tmp7_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda102__gtk_widget_focus_out_event (GtkWidget* _sender,
                                          GdkEventFocus* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda102_ ((ThemeEditor*) self, event);
	return result;
}

static gboolean
__lambda104_ (ThemeEditor* self,
              GdkEventButton* e)
{
	Theme* _tmp0_;
	Theme* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	MainWindow* _tmp4_;
	DrawArea* _tmp5_;
	DrawArea* _tmp6_;
	Theme* _tmp7_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->_theme;
	_tmp1_ = self->priv->_theme;
	_tmp2_ = theme_get_prefer_dark (_tmp1_);
	_tmp3_ = _tmp2_;
	theme_set_prefer_dark (_tmp0_, !_tmp3_);
	_tmp4_ = self->priv->_win;
	_tmp5_ = main_window_get_current_da (_tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_theme;
	draw_area_set_theme (_tmp6_, _tmp7_, TRUE);
	_g_object_unref0 (_tmp6_);
	result = FALSE;
	return result;
}

static gboolean
___lambda104__gtk_widget_button_release_event (GtkWidget* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	gboolean result;
	result = __lambda104_ ((ThemeEditor*) self, event);
	return result;
}

static void
_theme_editor_confirm_deletion_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	theme_editor_confirm_deletion ((ThemeEditor*) self);
}

static void
_theme_editor_close_window_gtk_button_clicked (GtkButton* _sender,
                                               gpointer self)
{
	theme_editor_close_window ((ThemeEditor*) self);
}

static void
_theme_editor_save_theme_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	theme_editor_save_theme ((ThemeEditor*) self);
}

ThemeEditor*
theme_editor_construct (GType object_type,
                        MainWindow* win)
{
	ThemeEditor * self = NULL;
	MainWindow* _tmp0_;
	GeeHashMap* _tmp1_;
	GtkLabel* title = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkBox* nbox = NULL;
	GtkBox* _tmp10_;
	GtkLabel* nlbl = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkEntry* _tmp19_;
	GtkEntry* _tmp20_;
	GtkBox* _tmp21_;
	GtkLabel* _tmp22_;
	GtkBox* _tmp23_;
	GtkEntry* _tmp24_;
	GtkBox* _tmp25_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp26_;
	GtkViewport* vp = NULL;
	GtkViewport* _tmp27_;
	GtkViewport* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	GtkViewport* _tmp30_;
	GtkScrolledWindow* _tmp31_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp32_;
	GtkGrid* _tmp33_;
	GtkGrid* _tmp34_;
	GtkGrid* _tmp35_;
	GtkViewport* _tmp36_;
	GtkGrid* _tmp37_;
	GtkLabel* color_lbl = NULL;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GtkLabel* _tmp42_;
	GtkLabel* _tmp43_;
	GtkLabel* _tmp44_;
	GtkLabel* _tmp45_;
	GtkGrid* _tmp46_;
	GtkLabel* _tmp47_;
	GtkGrid* _tmp48_;
	GtkGrid* _tmp49_;
	GtkGrid* _tmp50_;
	GtkGrid* _tmp51_;
	GtkGrid* _tmp52_;
	GtkGrid* _tmp53_;
	GtkGrid* _tmp54_;
	GtkGrid* _tmp55_;
	GtkGrid* _tmp56_;
	GtkGrid* _tmp57_;
	GtkGrid* _tmp58_;
	GtkGrid* _tmp59_;
	GtkGrid* _tmp60_;
	GtkGrid* _tmp61_;
	GtkGrid* _tmp62_;
	GtkGrid* _tmp63_;
	GtkGrid* _tmp64_;
	GtkGrid* _tmp65_;
	GtkGrid* _tmp66_;
	GtkGrid* _tmp67_;
	gint row = 0;
	GtkGrid* _tmp68_;
	GtkLabel* _tmp69_;
	GtkLabel* _tmp70_;
	GtkLabel* dark_lbl = NULL;
	gchar* _tmp71_;
	gchar* _tmp72_;
	GtkLabel* _tmp73_;
	GtkLabel* _tmp74_;
	GtkLabel* _tmp75_;
	GtkLabel* _tmp76_;
	GtkSwitch* _tmp77_;
	GtkSwitch* _tmp78_;
	GtkGrid* _tmp79_;
	GtkLabel* _tmp80_;
	GtkGrid* _tmp81_;
	GtkSwitch* _tmp82_;
	GtkGrid* _tmp83_;
	GtkLabel* _tmp84_;
	GtkLabel* _tmp85_;
	GtkLabel* link_lbl = NULL;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	GtkLabel* _tmp90_;
	GtkLabel* _tmp91_;
	GtkLabel* _tmp92_;
	GtkLabel* _tmp93_;
	GtkGrid* _tmp94_;
	GtkLabel* _tmp95_;
	GtkBox* bbox = NULL;
	GtkBox* _tmp105_;
	GtkRevealer* _tmp106_;
	GtkButton* del = NULL;
	GtkButton* _tmp107_;
	GtkStyleContext* _tmp108_;
	GtkRevealer* _tmp109_;
	GtkButton* cancel = NULL;
	GtkButton* _tmp110_;
	GtkButton* save = NULL;
	GtkButton* _tmp111_;
	GtkStyleContext* _tmp112_;
	GtkRevealer* _tmp113_;
	g_return_val_if_fail (win != NULL, NULL);
	self = (ThemeEditor*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 10, NULL);
	_tmp0_ = _g_object_ref0 (win);
	_g_object_unref0 (self->priv->_win);
	self->priv->_win = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gtk_color_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_btns);
	self->priv->_btns = _tmp1_;
	_tmp2_ = g_strconcat (_ ("Customize Theme"), "\n", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = utils_make_title (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	title = _tmp7_;
	_tmp8_ = title;
	gtk_label_set_use_markup (_tmp8_, TRUE);
	_tmp9_ = title;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp9_, FALSE, TRUE, (guint) 0);
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp10_);
	nbox = _tmp10_;
	_tmp11_ = g_strconcat (_ ("Name"), ":", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = utils_make_title (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = (GtkLabel*) gtk_label_new (_tmp14_);
	g_object_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	nlbl = _tmp16_;
	_tmp17_ = nlbl;
	gtk_label_set_xalign (_tmp17_, (gfloat) 0);
	_tmp18_ = nlbl;
	gtk_label_set_use_markup (_tmp18_, TRUE);
	_tmp19_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->_name);
	self->priv->_name = _tmp19_;
	_tmp20_ = self->priv->_name;
	g_signal_connect_object ((GtkWidget*) _tmp20_, "focus-out-event", (GCallback) ___lambda102__gtk_widget_focus_out_event, self, 0);
	_tmp21_ = nbox;
	_tmp22_ = nlbl;
	gtk_box_pack_start (_tmp21_, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) 0);
	_tmp23_ = nbox;
	_tmp24_ = self->priv->_name;
	gtk_box_pack_start (_tmp23_, (GtkWidget*) _tmp24_, TRUE, TRUE, (guint) 0);
	_tmp25_ = nbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp25_, FALSE, TRUE, (guint) 0);
	_tmp26_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp26_);
	sw = _tmp26_;
	_tmp27_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
	g_object_ref_sink (_tmp27_);
	vp = _tmp27_;
	_tmp28_ = vp;
	gtk_widget_set_size_request ((GtkWidget*) _tmp28_, 180, 600);
	_tmp29_ = sw;
	_tmp30_ = vp;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = sw;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp31_, TRUE, TRUE, (guint) 0);
	_tmp32_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp32_);
	grid = _tmp32_;
	_tmp33_ = grid;
	gtk_grid_set_row_spacing (_tmp33_, 5);
	_tmp34_ = grid;
	gtk_grid_set_column_spacing (_tmp34_, 30);
	_tmp35_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp35_, (guint) 5);
	_tmp36_ = vp;
	_tmp37_ = grid;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = g_strconcat (_ ("Base Colors"), "\n", NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = utils_make_title (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = (GtkLabel*) gtk_label_new (_tmp41_);
	g_object_ref_sink (_tmp42_);
	_tmp43_ = _tmp42_;
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	color_lbl = _tmp43_;
	_tmp44_ = color_lbl;
	gtk_label_set_xalign (_tmp44_, (gfloat) 0);
	_tmp45_ = color_lbl;
	gtk_label_set_use_markup (_tmp45_, TRUE);
	_tmp46_ = grid;
	_tmp47_ = color_lbl;
	gtk_grid_attach (_tmp46_, (GtkWidget*) _tmp47_, 0, 0, 2, 1);
	_tmp48_ = grid;
	theme_editor_add_color (self, _ ("Background"), "background", _tmp48_, 1);
	_tmp49_ = grid;
	theme_editor_add_color (self, _ ("Foreground"), "foreground", _tmp49_, 2);
	_tmp50_ = grid;
	theme_editor_add_color (self, _ ("Root Node Background"), "root_background", _tmp50_, 3);
	_tmp51_ = grid;
	theme_editor_add_color (self, _ ("Root Node Foreground"), "root_foreground", _tmp51_, 4);
	_tmp52_ = grid;
	theme_editor_add_color (self, _ ("Node Select Background"), "nodesel_background", _tmp52_, 5);
	_tmp53_ = grid;
	theme_editor_add_color (self, _ ("Node Select Foreground"), "nodesel_foreground", _tmp53_, 6);
	_tmp54_ = grid;
	theme_editor_add_color (self, _ ("Text Select Background"), "textsel_background", _tmp54_, 7);
	_tmp55_ = grid;
	theme_editor_add_color (self, _ ("Text Select Foreground"), "textsel_foreground", _tmp55_, 8);
	_tmp56_ = grid;
	theme_editor_add_color (self, _ ("Text Cursor"), "text_cursor", _tmp56_, 9);
	_tmp57_ = grid;
	theme_editor_add_color (self, _ ("Attachable Highlight"), "attachable", _tmp57_, 10);
	_tmp58_ = grid;
	theme_editor_add_color (self, _ ("Connection Color"), "connection_background", _tmp58_, 11);
	_tmp59_ = grid;
	theme_editor_add_color (self, _ ("Connection Title Color"), "connection_foreground", _tmp59_, 12);
	_tmp60_ = grid;
	theme_editor_add_color (self, _ ("Callout Background"), "callout_background", _tmp60_, 13);
	_tmp61_ = grid;
	theme_editor_add_color (self, _ ("URL Link Background"), "url_background", _tmp61_, 14);
	_tmp62_ = grid;
	theme_editor_add_color (self, _ ("URL Link Foreground"), "url_foreground", _tmp62_, 15);
	_tmp63_ = grid;
	theme_editor_add_color (self, _ ("Tag"), "tag", _tmp63_, 16);
	_tmp64_ = grid;
	theme_editor_add_color (self, _ ("Markdown Syntax Chars"), "syntax", _tmp64_, 17);
	_tmp65_ = grid;
	theme_editor_add_color (self, _ ("Match Background"), "match_background", _tmp65_, 18);
	_tmp66_ = grid;
	theme_editor_add_color (self, _ ("Match Foreground"), "match_foreground", _tmp66_, 19);
	_tmp67_ = grid;
	theme_editor_add_color (self, _ ("Markdown List Item"), "markdown_listitem", _tmp67_, 20);
	row = 20;
	_tmp68_ = grid;
	_tmp69_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp69_);
	_tmp70_ = _tmp69_;
	gtk_grid_attach (_tmp68_, (GtkWidget*) _tmp70_, 0, row, 1, 1);
	_g_object_unref0 (_tmp70_);
	_tmp71_ = utils_make_title (_ ("Prefer Dark Mode"));
	_tmp72_ = _tmp71_;
	_tmp73_ = (GtkLabel*) gtk_label_new (_tmp72_);
	g_object_ref_sink (_tmp73_);
	_tmp74_ = _tmp73_;
	_g_free0 (_tmp72_);
	dark_lbl = _tmp74_;
	_tmp75_ = dark_lbl;
	gtk_label_set_xalign (_tmp75_, (gfloat) 0);
	_tmp76_ = dark_lbl;
	gtk_label_set_use_markup (_tmp76_, TRUE);
	_tmp77_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->_prefer_dark);
	self->priv->_prefer_dark = _tmp77_;
	_tmp78_ = self->priv->_prefer_dark;
	g_signal_connect_object ((GtkWidget*) _tmp78_, "button-release-event", (GCallback) ___lambda104__gtk_widget_button_release_event, self, 0);
	_tmp79_ = grid;
	_tmp80_ = dark_lbl;
	gtk_grid_attach (_tmp79_, (GtkWidget*) _tmp80_, 0, row + 1, 1, 1);
	_tmp81_ = grid;
	_tmp82_ = self->priv->_prefer_dark;
	gtk_grid_attach (_tmp81_, (GtkWidget*) _tmp82_, 1, row + 1, 1, 1);
	_tmp83_ = grid;
	_tmp84_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp84_);
	_tmp85_ = _tmp84_;
	gtk_grid_attach (_tmp83_, (GtkWidget*) _tmp85_, 0, row + 2, 1, 1);
	_g_object_unref0 (_tmp85_);
	_tmp86_ = g_strconcat (_ ("Link Colors"), "\n", NULL);
	_tmp87_ = _tmp86_;
	_tmp88_ = utils_make_title (_tmp87_);
	_tmp89_ = _tmp88_;
	_tmp90_ = (GtkLabel*) gtk_label_new (_tmp89_);
	g_object_ref_sink (_tmp90_);
	_tmp91_ = _tmp90_;
	_g_free0 (_tmp89_);
	_g_free0 (_tmp87_);
	link_lbl = _tmp91_;
	_tmp92_ = link_lbl;
	gtk_label_set_xalign (_tmp92_, (gfloat) 0);
	_tmp93_ = link_lbl;
	gtk_label_set_use_markup (_tmp93_, TRUE);
	_tmp94_ = grid;
	_tmp95_ = link_lbl;
	gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 0, row + 3, 2, 1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp96_ = FALSE;
			_tmp96_ = TRUE;
			while (TRUE) {
				gchar* _tmp98_;
				gchar* _tmp99_;
				gchar* _tmp100_;
				gchar* _tmp101_;
				gchar* _tmp102_;
				gchar* _tmp103_;
				GtkGrid* _tmp104_;
				if (!_tmp96_) {
					gint _tmp97_;
					_tmp97_ = i;
					i = _tmp97_ + 1;
				}
				_tmp96_ = FALSE;
				if (!(i < theme_num_link_colors ())) {
					break;
				}
				_tmp98_ = g_strdup_printf (" #%d", i + 1);
				_tmp99_ = _tmp98_;
				_tmp100_ = g_strconcat (_ ("Link Color"), _tmp99_, NULL);
				_tmp101_ = _tmp100_;
				_tmp102_ = g_strdup_printf ("link_color%d", i);
				_tmp103_ = _tmp102_;
				_tmp104_ = grid;
				theme_editor_add_color (self, _tmp101_, _tmp103_, _tmp104_, (row + 4) + i);
				_g_free0 (_tmp103_);
				_g_free0 (_tmp101_);
				_g_free0 (_tmp99_);
			}
		}
	}
	_tmp105_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp105_);
	bbox = _tmp105_;
	_tmp106_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp106_);
	_g_object_unref0 (self->priv->_delrev);
	self->priv->_delrev = _tmp106_;
	_tmp107_ = (GtkButton*) gtk_button_new_with_label (_ ("Delete"));
	g_object_ref_sink (_tmp107_);
	del = _tmp107_;
	_tmp108_ = gtk_widget_get_style_context ((GtkWidget*) del);
	gtk_style_context_add_class (_tmp108_, "destructive-action");
	g_signal_connect_object (del, "clicked", (GCallback) _theme_editor_confirm_deletion_gtk_button_clicked, self, 0);
	_tmp109_ = self->priv->_delrev;
	gtk_container_add ((GtkContainer*) _tmp109_, (GtkWidget*) del);
	_tmp110_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp110_);
	cancel = _tmp110_;
	g_signal_connect_object (cancel, "clicked", (GCallback) _theme_editor_close_window_gtk_button_clicked, self, 0);
	_tmp111_ = (GtkButton*) gtk_button_new_with_label (_ ("Save"));
	g_object_ref_sink (_tmp111_);
	save = _tmp111_;
	_tmp112_ = gtk_widget_get_style_context ((GtkWidget*) save);
	gtk_style_context_add_class (_tmp112_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	g_signal_connect_object (save, "clicked", (GCallback) _theme_editor_save_theme_gtk_button_clicked, self, 0);
	_tmp113_ = self->priv->_delrev;
	gtk_box_pack_start (bbox, (GtkWidget*) _tmp113_, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end (bbox, (GtkWidget*) save, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end (bbox, (GtkWidget*) cancel, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) bbox, FALSE, TRUE, (guint) 0);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 10);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (save);
	_g_object_unref0 (cancel);
	_g_object_unref0 (del);
	_g_object_unref0 (bbox);
	_g_object_unref0 (link_lbl);
	_g_object_unref0 (dark_lbl);
	_g_object_unref0 (color_lbl);
	_g_object_unref0 (grid);
	_g_object_unref0 (vp);
	_g_object_unref0 (sw);
	_g_object_unref0 (nlbl);
	_g_object_unref0 (nbox);
	_g_object_unref0 (title);
	return self;
}

ThemeEditor*
theme_editor_new (MainWindow* win)
{
	return theme_editor_construct (TYPE_THEME_EDITOR, win);
}

static Block54Data*
block54_data_ref (Block54Data* _data54_)
{
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}

static void
block54_data_unref (void * _userdata_)
{
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		ThemeEditor* self;
		self = _data54_->self;
		_g_object_unref0 (_data54_->btn);
		_g_free0 (_data54_->name);
		_g_object_unref0 (self);
		g_slice_free (Block54Data, _data54_);
	}
}

static void
__lambda103_ (Block54Data* _data54_)
{
	ThemeEditor* self;
	Theme* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_;
	MainWindow* _tmp3_;
	DrawArea* _tmp4_;
	DrawArea* _tmp5_;
	Theme* _tmp6_;
	self = _data54_->self;
	_tmp0_ = self->priv->_theme;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _data54_->btn, &_tmp1_);
	_tmp2_ = _tmp1_;
	theme_set_color (_tmp0_, _data54_->name, &_tmp2_);
	_tmp3_ = self->priv->_win;
	_tmp4_ = main_window_get_current_da (_tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_theme;
	draw_area_set_theme (_tmp5_, _tmp6_, TRUE);
	_g_object_unref0 (_tmp5_);
}

static void
___lambda103__gtk_color_button_color_set (GtkColorButton* _sender,
                                          gpointer self)
{
	__lambda103_ (self);
}

static void
theme_editor_add_color (ThemeEditor* self,
                        const gchar* lbl_str,
                        const gchar* name,
                        GtkGrid* grid,
                        gint row)
{
	Block54Data* _data54_;
	gchar* _tmp0_;
	GtkLabel* lbl = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkColorButton* _tmp5_;
	GeeHashMap* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lbl_str != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (grid != NULL);
	_data54_ = g_slice_new0 (Block54Data);
	_data54_->_ref_count_ = 1;
	_data54_->self = g_object_ref (self);
	_tmp0_ = g_strdup (name);
	_g_free0 (_data54_->name);
	_data54_->name = _tmp0_;
	_tmp1_ = g_strconcat ("  ", lbl_str, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	lbl = _tmp4_;
	gtk_label_set_xalign (lbl, (gfloat) 0);
	_tmp5_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp5_);
	_data54_->btn = _tmp5_;
	g_signal_connect_data (_data54_->btn, "color-set", (GCallback) ___lambda103__gtk_color_button_color_set, block54_data_ref (_data54_), (GClosureNotify) block54_data_unref, 0);
	_tmp6_ = self->priv->_btns;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _data54_->name, _data54_->btn);
	gtk_grid_attach (grid, (GtkWidget*) lbl, 0, row, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) _data54_->btn, 1, row, 2, 1);
	_g_object_unref0 (lbl);
	block54_data_unref (_data54_);
	_data54_ = NULL;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

void
theme_editor_initialize (ThemeEditor* self,
                         Theme* theme,
                         gboolean edit)
{
	Theme* _tmp0_;
	Theme* _tmp1_;
	GArray* colors = NULL;
	Theme* _tmp11_;
	GArray* _tmp12_;
	GtkEntry* _tmp27_;
	Theme* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GtkSwitch* _tmp31_;
	Theme* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_ = FALSE;
	GtkRevealer* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = _g_object_ref0 (theme);
	_g_object_unref0 (self->priv->_orig_theme);
	self->priv->_orig_theme = _tmp0_;
	self->priv->_edit = edit;
	_tmp1_ = theme_new_from_theme (theme);
	_g_object_unref0 (self->priv->_theme);
	self->priv->_theme = _tmp1_;
	if (!edit) {
		Theme* _tmp2_;
		Theme* _tmp3_;
		MainWindow* _tmp4_;
		Themes* _tmp5_;
		Themes* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp2_ = self->priv->_theme;
		_tmp3_ = self->priv->_theme;
		_tmp4_ = self->priv->_win;
		_tmp5_ = main_window_get_themes (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_ ("Custom"), " #1", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = themes_uniquify_name (_tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		theme_set_label (_tmp3_, _tmp10_);
		theme_set_name (_tmp2_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
	_tmp11_ = self->priv->_theme;
	_tmp12_ = theme_colors (_tmp11_);
	colors = _tmp12_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				GArray* _tmp15_;
				GeeHashMap* _tmp16_;
				GArray* _tmp17_;
				const gchar* _tmp18_;
				gpointer _tmp19_;
				GtkColorButton* _tmp20_;
				Theme* _tmp21_;
				GArray* _tmp22_;
				const gchar* _tmp23_;
				GdkRGBA* _tmp24_;
				GdkRGBA* _tmp25_;
				GdkRGBA _tmp26_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = colors;
				if (!(((guint) i) < _tmp15_->len)) {
					break;
				}
				_tmp16_ = self->priv->_btns;
				_tmp17_ = colors;
				_tmp18_ = g_array_index (_tmp17_, gchar*, (guint) i);
				_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, _tmp18_);
				_tmp20_ = (GtkColorButton*) _tmp19_;
				_tmp21_ = self->priv->_theme;
				_tmp22_ = colors;
				_tmp23_ = g_array_index (_tmp22_, gchar*, (guint) i);
				_tmp24_ = theme_get_color (_tmp21_, _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = *_tmp25_;
				gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp20_, &_tmp26_);
				__vala_GdkRGBA_free0 (_tmp25_);
				_g_object_unref0 (_tmp20_);
			}
		}
	}
	_tmp27_ = self->priv->_name;
	_tmp28_ = self->priv->_theme;
	_tmp29_ = theme_get_name (_tmp28_);
	_tmp30_ = _tmp29_;
	gtk_entry_set_text (_tmp27_, _tmp30_);
	_tmp31_ = self->priv->_prefer_dark;
	_tmp32_ = self->priv->_theme;
	_tmp33_ = theme_get_prefer_dark (_tmp32_);
	_tmp34_ = _tmp33_;
	gtk_switch_set_active (_tmp31_, _tmp34_);
	if (edit) {
		gboolean _tmp36_;
		gboolean _tmp37_;
		_tmp36_ = theme_get_temporary (theme);
		_tmp37_ = _tmp36_;
		_tmp35_ = !_tmp37_;
	} else {
		_tmp35_ = FALSE;
	}
	_tmp38_ = self->priv->_delrev;
	gtk_revealer_set_reveal_child (_tmp38_, _tmp35_);
	_g_array_unref0 (colors);
}

static void
theme_editor_confirm_deletion (ThemeEditor* self)
{
	GraniteMessageDialog* dialog = NULL;
	GraniteMessageDialog* _tmp0_;
	GtkButton* no = NULL;
	GtkButton* _tmp1_;
	GraniteMessageDialog* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* yes = NULL;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkStyleContext* _tmp6_;
	GraniteMessageDialog* _tmp7_;
	GtkButton* _tmp8_;
	GraniteMessageDialog* _tmp9_;
	MainWindow* _tmp10_;
	GraniteMessageDialog* _tmp11_;
	GraniteMessageDialog* _tmp12_;
	GraniteMessageDialog* _tmp13_;
	gint res = 0;
	GraniteMessageDialog* _tmp14_;
	GraniteMessageDialog* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Delete theme?"), _ ("This operation cannot be undone."), "dialog-warning", GTK_BUTTONS_NONE);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_ ("No"));
	g_object_ref_sink (_tmp1_);
	no = _tmp1_;
	_tmp2_ = dialog;
	_tmp3_ = no;
	gtk_dialog_add_action_widget ((GtkDialog*) _tmp2_, (GtkWidget*) _tmp3_, (gint) GTK_RESPONSE_CANCEL);
	_tmp4_ = (GtkButton*) gtk_button_new_with_label (_ ("Yes"));
	g_object_ref_sink (_tmp4_);
	yes = _tmp4_;
	_tmp5_ = yes;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp7_ = dialog;
	_tmp8_ = yes;
	gtk_dialog_add_action_widget ((GtkDialog*) _tmp7_, (GtkWidget*) _tmp8_, (gint) GTK_RESPONSE_ACCEPT);
	_tmp9_ = dialog;
	_tmp10_ = self->priv->_win;
	gtk_window_set_transient_for ((GtkWindow*) _tmp9_, (GtkWindow*) _tmp10_);
	_tmp11_ = dialog;
	gtk_dialog_set_default_response ((GtkDialog*) _tmp11_, (gint) GTK_RESPONSE_ACCEPT);
	_tmp12_ = dialog;
	gtk_window_set_title ((GtkWindow*) _tmp12_, "");
	_tmp13_ = dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp13_);
	_tmp14_ = dialog;
	res = gtk_dialog_run ((GtkDialog*) _tmp14_);
	_tmp15_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
	if (res == ((gint) GTK_RESPONSE_ACCEPT)) {
		theme_editor_delete_theme (self);
	}
	_g_object_unref0 (yes);
	_g_object_unref0 (no);
	_g_object_unref0 (dialog);
}

static void
theme_editor_delete_theme (ThemeEditor* self)
{
	MainWindow* _tmp0_;
	DrawArea* _tmp1_;
	DrawArea* _tmp2_;
	MainWindow* _tmp3_;
	Themes* _tmp4_;
	Themes* _tmp5_;
	Theme* _tmp6_;
	Theme* _tmp7_;
	MainWindow* _tmp8_;
	Themes* _tmp9_;
	Themes* _tmp10_;
	Theme* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	MainWindow* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_win;
	_tmp1_ = main_window_get_current_da (_tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_win;
	_tmp4_ = main_window_get_themes (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = themes_get_theme (_tmp5_, _ ("Default"));
	_tmp7_ = _tmp6_;
	draw_area_set_theme (_tmp2_, _tmp7_, TRUE);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp2_);
	_tmp8_ = self->priv->_win;
	_tmp9_ = main_window_get_themes (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->_orig_theme;
	_tmp12_ = theme_get_name (_tmp11_);
	_tmp13_ = _tmp12_;
	themes_delete_theme (_tmp10_, _tmp13_);
	_tmp14_ = self->priv->_win;
	main_window_hide_theme_editor (_tmp14_);
}

static void
theme_editor_close_window (ThemeEditor* self)
{
	MainWindow* _tmp0_;
	DrawArea* _tmp1_;
	DrawArea* _tmp2_;
	Theme* _tmp3_;
	MainWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_win;
	_tmp1_ = main_window_get_current_da (_tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_orig_theme;
	draw_area_set_theme (_tmp2_, _tmp3_, TRUE);
	_g_object_unref0 (_tmp2_);
	_tmp4_ = self->priv->_win;
	main_window_hide_theme_editor (_tmp4_);
}

static void
theme_editor_save_theme (ThemeEditor* self)
{
	Theme* _tmp0_;
	Theme* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	MainWindow* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_theme;
	_tmp1_ = self->priv->_theme;
	_tmp2_ = self->priv->_name;
	_tmp3_ = gtk_entry_get_text (_tmp2_);
	_tmp4_ = _tmp3_;
	theme_set_label (_tmp1_, _tmp4_);
	theme_set_name (_tmp0_, _tmp4_);
	if (self->priv->_edit) {
		Theme* _tmp5_;
		Theme* _tmp6_;
		Theme* _tmp7_;
		MainWindow* _tmp8_;
		Themes* _tmp9_;
		Themes* _tmp10_;
		_tmp5_ = self->priv->_orig_theme;
		_tmp6_ = self->priv->_theme;
		theme_copy (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->_orig_theme;
		theme_set_temporary (_tmp7_, FALSE);
		_tmp8_ = self->priv->_win;
		_tmp9_ = main_window_get_themes (_tmp8_);
		_tmp10_ = _tmp9_;
		g_signal_emit_by_name (_tmp10_, "themes-changed");
	} else {
		MainWindow* _tmp11_;
		Themes* _tmp12_;
		Themes* _tmp13_;
		Theme* _tmp14_;
		_tmp11_ = self->priv->_win;
		_tmp12_ = main_window_get_themes (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->_theme;
		themes_add_theme (_tmp13_, _tmp14_);
	}
	_tmp15_ = self->priv->_win;
	main_window_hide_theme_editor (_tmp15_);
}

static void
theme_editor_class_init (ThemeEditorClass * klass,
                         gpointer klass_data)
{
	theme_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ThemeEditor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = theme_editor_finalize;
}

static void
theme_editor_instance_init (ThemeEditor * self,
                            gpointer klass)
{
	self->priv = theme_editor_get_instance_private (self);
}

static void
theme_editor_finalize (GObject * obj)
{
	ThemeEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME_EDITOR, ThemeEditor);
	_g_object_unref0 (self->priv->_win);
	_g_object_unref0 (self->priv->_theme);
	_g_object_unref0 (self->priv->_orig_theme);
	_g_object_unref0 (self->priv->_name);
	_g_object_unref0 (self->priv->_btns);
	_g_object_unref0 (self->priv->_prefer_dark);
	_g_object_unref0 (self->priv->_delrev);
	G_OBJECT_CLASS (theme_editor_parent_class)->finalize (obj);
}

static GType
theme_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThemeEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThemeEditor), 0, (GInstanceInitFunc) theme_editor_instance_init, NULL };
	GType theme_editor_type_id;
	theme_editor_type_id = g_type_register_static (gtk_box_get_type (), "ThemeEditor", &g_define_type_info, 0);
	ThemeEditor_private_offset = g_type_add_instance_private (theme_editor_type_id, sizeof (ThemeEditorPrivate));
	return theme_editor_type_id;
}

GType
theme_editor_get_type (void)
{
	static volatile gsize theme_editor_type_id__once = 0;
	if (g_once_init_enter (&theme_editor_type_id__once)) {
		GType theme_editor_type_id;
		theme_editor_type_id = theme_editor_get_type_once ();
		g_once_init_leave (&theme_editor_type_id__once, theme_editor_type_id);
	}
	return theme_editor_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

