/* UnicodeParser.c generated by valac 0.56.18, the Vala compiler
 * generated from UnicodeParser.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <handy.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TEXT_PARSER (text_parser_get_type ())
#define TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_PARSER, TextParser))
#define TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_PARSER, TextParserClass))
#define IS_TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_PARSER))
#define IS_TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_PARSER))
#define TEXT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_PARSER, TextParserClass))

typedef struct _TextParser TextParser;
typedef struct _TextParserClass TextParserClass;
typedef struct _TextParserPrivate TextParserPrivate;
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_TEXT_BUFFER (undo_text_buffer_get_type ())
#define UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer))
#define UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))
#define IS_UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_BUFFER))
#define IS_UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_BUFFER))
#define UNDO_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))

typedef struct _UndoTextBuffer UndoTextBuffer;
typedef struct _UndoTextBufferClass UndoTextBufferClass;

#define TYPE_UNICODE_PARSER (unicode_parser_get_type ())
#define UNICODE_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNICODE_PARSER, UnicodeParser))
#define UNICODE_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNICODE_PARSER, UnicodeParserClass))
#define IS_UNICODE_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNICODE_PARSER))
#define IS_UNICODE_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNICODE_PARSER))
#define UNICODE_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNICODE_PARSER, UnicodeParserClass))

typedef struct _UnicodeParser UnicodeParser;
typedef struct _UnicodeParserClass UnicodeParserClass;
typedef struct _UnicodeParserPrivate UnicodeParserPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
typedef void (*TextParserTextMatchCallback) (FormattedText* text, GMatchInfo* match_info, gpointer user_data);

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_CALLOUT (callout_get_type ())
#define CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALLOUT, Callout))
#define CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALLOUT, CalloutClass))
#define IS_CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALLOUT))
#define IS_CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALLOUT))
#define CALLOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALLOUT, CalloutClass))

typedef struct _Callout Callout;
typedef struct _CalloutClass CalloutClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TEXT_COMPLETION_ITEM (text_completion_item_get_type ())
#define TEXT_COMPLETION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItem))
#define TEXT_COMPLETION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItemClass))
#define IS_TEXT_COMPLETION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_COMPLETION_ITEM))
#define IS_TEXT_COMPLETION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_COMPLETION_ITEM))
#define TEXT_COMPLETION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItemClass))

typedef struct _TextCompletionItem TextCompletionItem;
typedef struct _TextCompletionItemClass TextCompletionItemClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_UNICODE_INSERT (unicode_insert_get_type ())
#define UNICODE_INSERT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNICODE_INSERT, UnicodeInsert))
#define UNICODE_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNICODE_INSERT, UnicodeInsertClass))
#define IS_UNICODE_INSERT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNICODE_INSERT))
#define IS_UNICODE_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNICODE_INSERT))
#define UNICODE_INSERT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNICODE_INSERT, UnicodeInsertClass))

typedef struct _UnicodeInsert UnicodeInsert;
typedef struct _UnicodeInsertClass UnicodeInsertClass;

struct _TextParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TextParserPrivate * priv;
};

struct _TextParserClass {
	GTypeClass parent_class;
	void (*finalize) (TextParser *self);
	gboolean (*tag_handled) (TextParser* self, FormatTag tag);
	void (*insert_tag) (TextParser* self, CanvasText* ct, FormatTag tag, gint start_pos, gint end_pos, UndoTextBuffer* undo_buffer, const gchar* extra);
	void (*remove_all_tags) (TextParser* self, CanvasText* ct, gint start_pos, gint end_pos, UndoTextBuffer* undo_buffer);
};

struct _UnicodeParser {
	TextParser parent_instance;
	UnicodeParserPrivate * priv;
};

struct _UnicodeParserClass {
	TextParserClass parent_class;
};

struct _UnicodeParserPrivate {
	DrawArea* _da;
};

static gint UnicodeParser_private_offset;
static gpointer unicode_parser_parent_class = NULL;

VALA_EXTERN gpointer text_parser_ref (gpointer instance);
VALA_EXTERN void text_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_parser (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_text_parser (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_text_parser (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_text_parser (const GValue* value);
VALA_EXTERN GType text_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextParser, text_parser_unref)
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN GType undo_text_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextBuffer, g_object_unref)
VALA_EXTERN GType unicode_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnicodeParser, text_parser_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN gboolean text_parser_tag_handled (TextParser* self,
                                  FormatTag tag);
VALA_EXTERN UnicodeParser* unicode_parser_new (DrawArea* da);
VALA_EXTERN UnicodeParser* unicode_parser_construct (GType object_type,
                                         DrawArea* da);
VALA_EXTERN TextParser* text_parser_new (const gchar* name);
VALA_EXTERN TextParser* text_parser_construct (GType object_type,
                                   const gchar* name);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN void text_parser_add_regex (TextParser* self,
                            const gchar* re,
                            TextParserTextMatchCallback func,
                            gpointer func_target);
static void unicode_parser_handle_code (UnicodeParser* self,
                                 FormattedText* text,
                                 GMatchInfo* match);
static void _unicode_parser_handle_code_text_parser_text_match_callback (FormattedText* text,
                                                                  GMatchInfo* match_info,
                                                                  gpointer self);
static void unicode_parser_handle_nocode (UnicodeParser* self,
                                   FormattedText* text,
                                   GMatchInfo* match);
static void _unicode_parser_handle_nocode_text_parser_text_match_callback (FormattedText* text,
                                                                    GMatchInfo* match_info,
                                                                    gpointer self);
VALA_EXTERN gchar* text_parser_get_text (TextParser* self,
                             GMatchInfo* matches,
                             gint paren);
VALA_EXTERN void text_parser_add_tag (TextParser* self,
                          FormattedText* text,
                          GMatchInfo* matches,
                          gint paren,
                          FormatTag tag,
                          const gchar* extra);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN Node* draw_area_get_current_node (DrawArea* self);
static void unicode_parser_handle_code_for_ct (UnicodeParser* self,
                                        CanvasText* ct,
                                        FormattedText* text,
                                        GMatchInfo* match,
                                        const gchar* tag);
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN GType callout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Callout, g_object_unref)
VALA_EXTERN Callout* draw_area_get_current_callout (DrawArea* self);
VALA_EXTERN CanvasText* callout_get_text (Callout* self);
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN gint canvas_text_get_cursor (CanvasText* self);
VALA_EXTERN gpointer text_completion_item_ref (gpointer instance);
VALA_EXTERN void text_completion_item_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_completion_item (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void value_set_text_completion_item (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void value_take_text_completion_item (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer value_get_text_completion_item (const GValue* value);
VALA_EXTERN GType text_completion_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextCompletionItem, text_completion_item_unref)
VALA_EXTERN void draw_area_show_auto_completion (DrawArea* self,
                                     GList* values,
                                     gint start_pos,
                                     gint end_pos);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN MainWindow* draw_area_get_win (DrawArea* self);
VALA_EXTERN gpointer unicode_insert_ref (gpointer instance);
VALA_EXTERN void unicode_insert_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_unicode_insert (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_unicode_insert (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_unicode_insert (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_unicode_insert (const GValue* value);
VALA_EXTERN GType unicode_insert_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnicodeInsert, unicode_insert_unref)
VALA_EXTERN UnicodeInsert* main_window_get_unicoder (MainWindow* self);
VALA_EXTERN GList* unicode_insert_get_matches (UnicodeInsert* self,
                                   const gchar* partial);
static void _text_completion_item_unref0_ (gpointer var);
static inline void _g_list_free__text_completion_item_unref0_ (GList* self);
static void unicode_parser_handle_nocode_for_ct (UnicodeParser* self,
                                          CanvasText* ct,
                                          FormattedText* text,
                                          GMatchInfo* match);
VALA_EXTERN void draw_area_hide_auto_completion (DrawArea* self);
static gboolean unicode_parser_real_tag_handled (TextParser* base,
                                          FormatTag tag);
static void unicode_parser_finalize (TextParser * obj);
static GType unicode_parser_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
unicode_parser_get_instance_private (UnicodeParser* self)
{
	return G_STRUCT_MEMBER_P (self, UnicodeParser_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_unicode_parser_handle_code_text_parser_text_match_callback (FormattedText* text,
                                                             GMatchInfo* match_info,
                                                             gpointer self)
{
	unicode_parser_handle_code ((UnicodeParser*) self, text, match_info);
}

static void
_unicode_parser_handle_nocode_text_parser_text_match_callback (FormattedText* text,
                                                               GMatchInfo* match_info,
                                                               gpointer self)
{
	unicode_parser_handle_nocode ((UnicodeParser*) self, text, match_info);
}

UnicodeParser*
unicode_parser_construct (GType object_type,
                          DrawArea* da)
{
	UnicodeParser* self = NULL;
	DrawArea* _tmp0_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (UnicodeParser*) text_parser_construct (object_type, "Unicode");
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	text_parser_add_regex ((TextParser*) self, "\\\\([a-zA-Z0-9_\\^\\(\\){}!+-=~:\\`'\".<>-]*)", _unicode_parser_handle_code_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "\\s", _unicode_parser_handle_nocode_text_parser_text_match_callback, self);
	return self;
}

UnicodeParser*
unicode_parser_new (DrawArea* da)
{
	return unicode_parser_construct (TYPE_UNICODE_PARSER, da);
}

static void
unicode_parser_handle_code (UnicodeParser* self,
                            FormattedText* text,
                            GMatchInfo* match)
{
	gchar* tag = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	DrawArea* _tmp2_;
	Node* _tmp3_;
	Node* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	_tmp0_ = text_parser_get_text ((TextParser*) self, match, 0);
	tag = _tmp0_;
	_tmp1_ = tag;
	text_parser_add_tag ((TextParser*) self, text, match, 0, FORMAT_TAG_TAG, _tmp1_);
	_tmp2_ = self->priv->_da;
	_tmp3_ = draw_area_get_current_node (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		DrawArea* _tmp6_;
		Node* _tmp7_;
		Node* _tmp8_;
		CanvasText* _tmp9_;
		CanvasText* _tmp10_;
		const gchar* _tmp11_;
		_tmp6_ = self->priv->_da;
		_tmp7_ = draw_area_get_current_node (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = node_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = tag;
		unicode_parser_handle_code_for_ct (self, _tmp10_, text, match, _tmp11_);
		_g_object_unref0 (_tmp8_);
	} else {
		DrawArea* _tmp12_;
		Callout* _tmp13_;
		Callout* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = self->priv->_da;
		_tmp13_ = draw_area_get_current_callout (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_ != NULL;
		_g_object_unref0 (_tmp14_);
		if (_tmp15_) {
			DrawArea* _tmp16_;
			Callout* _tmp17_;
			Callout* _tmp18_;
			CanvasText* _tmp19_;
			CanvasText* _tmp20_;
			const gchar* _tmp21_;
			_tmp16_ = self->priv->_da;
			_tmp17_ = draw_area_get_current_callout (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = callout_get_text (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = tag;
			unicode_parser_handle_code_for_ct (self, _tmp20_, text, match, _tmp21_);
			_g_object_unref0 (_tmp18_);
		}
	}
	_g_free0 (tag);
}

static void
_text_completion_item_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (text_completion_item_unref (var), NULL));
}

static inline void
_g_list_free__text_completion_item_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _text_completion_item_unref0_);
}

static void
unicode_parser_handle_code_for_ct (UnicodeParser* self,
                                   CanvasText* ct,
                                   FormattedText* text,
                                   GMatchInfo* match,
                                   const gchar* tag)
{
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ct != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == text) {
		gint start = 0;
		gint end = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint cursor = 0;
		gint _tmp4_;
		gint _tmp5_;
		gboolean _tmp6_ = FALSE;
		g_match_info_fetch_pos (match, 0, &_tmp2_, &_tmp3_);
		start = _tmp2_;
		end = _tmp3_;
		_tmp4_ = canvas_text_get_cursor (ct);
		_tmp5_ = _tmp4_;
		cursor = _tmp5_;
		if (start <= cursor) {
			_tmp6_ = cursor <= end;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			DrawArea* _tmp7_;
			DrawArea* _tmp8_;
			MainWindow* _tmp9_;
			MainWindow* _tmp10_;
			UnicodeInsert* _tmp11_;
			UnicodeInsert* _tmp12_;
			GList* _tmp13_;
			GList* _tmp14_;
			_tmp7_ = self->priv->_da;
			_tmp8_ = self->priv->_da;
			_tmp9_ = draw_area_get_win (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = main_window_get_unicoder (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = unicode_insert_get_matches (_tmp12_, tag);
			_tmp14_ = _tmp13_;
			draw_area_show_auto_completion (_tmp7_, _tmp14_, start, end);
			(_tmp14_ == NULL) ? NULL : (_tmp14_ = (_g_list_free__text_completion_item_unref0_ (_tmp14_), NULL));
		}
	}
}

static void
unicode_parser_handle_nocode (UnicodeParser* self,
                              FormattedText* text,
                              GMatchInfo* match)
{
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		DrawArea* _tmp4_;
		Node* _tmp5_;
		Node* _tmp6_;
		CanvasText* _tmp7_;
		CanvasText* _tmp8_;
		_tmp4_ = self->priv->_da;
		_tmp5_ = draw_area_get_current_node (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = node_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		unicode_parser_handle_nocode_for_ct (self, _tmp8_, text, match);
		_g_object_unref0 (_tmp6_);
	} else {
		DrawArea* _tmp9_;
		Callout* _tmp10_;
		Callout* _tmp11_;
		gboolean _tmp12_;
		_tmp9_ = self->priv->_da;
		_tmp10_ = draw_area_get_current_callout (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_ != NULL;
		_g_object_unref0 (_tmp11_);
		if (_tmp12_) {
			DrawArea* _tmp13_;
			Callout* _tmp14_;
			Callout* _tmp15_;
			CanvasText* _tmp16_;
			CanvasText* _tmp17_;
			_tmp13_ = self->priv->_da;
			_tmp14_ = draw_area_get_current_callout (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = callout_get_text (_tmp15_);
			_tmp17_ = _tmp16_;
			unicode_parser_handle_nocode_for_ct (self, _tmp17_, text, match);
			_g_object_unref0 (_tmp15_);
		}
	}
}

static void
unicode_parser_handle_nocode_for_ct (UnicodeParser* self,
                                     CanvasText* ct,
                                     FormattedText* text,
                                     GMatchInfo* match)
{
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ct != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == text) {
		gint start = 0;
		gint end = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_;
		gint _tmp5_;
		g_match_info_fetch_pos (match, 0, &_tmp2_, &_tmp3_);
		start = _tmp2_;
		end = _tmp3_;
		_tmp4_ = canvas_text_get_cursor (ct);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == start) {
			DrawArea* _tmp6_;
			_tmp6_ = self->priv->_da;
			draw_area_hide_auto_completion (_tmp6_);
		}
	}
}

static gboolean
unicode_parser_real_tag_handled (TextParser* base,
                                 FormatTag tag)
{
	UnicodeParser * self;
	gboolean result;
	self = (UnicodeParser*) base;
	result = tag == FORMAT_TAG_TAG;
	return result;
}

static void
unicode_parser_class_init (UnicodeParserClass * klass,
                           gpointer klass_data)
{
	unicode_parser_parent_class = g_type_class_peek_parent (klass);
	((TextParserClass *) klass)->finalize = unicode_parser_finalize;
	g_type_class_adjust_private_offset (klass, &UnicodeParser_private_offset);
	((TextParserClass *) klass)->tag_handled = (gboolean (*) (TextParser*, FormatTag)) unicode_parser_real_tag_handled;
}

static void
unicode_parser_instance_init (UnicodeParser * self,
                              gpointer klass)
{
	self->priv = unicode_parser_get_instance_private (self);
}

static void
unicode_parser_finalize (TextParser * obj)
{
	UnicodeParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNICODE_PARSER, UnicodeParser);
	_g_object_unref0 (self->priv->_da);
	TEXT_PARSER_CLASS (unicode_parser_parent_class)->finalize (obj);
}

static GType
unicode_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnicodeParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unicode_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnicodeParser), 0, (GInstanceInitFunc) unicode_parser_instance_init, NULL };
	GType unicode_parser_type_id;
	unicode_parser_type_id = g_type_register_static (TYPE_TEXT_PARSER, "UnicodeParser", &g_define_type_info, 0);
	UnicodeParser_private_offset = g_type_add_instance_private (unicode_parser_type_id, sizeof (UnicodeParserPrivate));
	return unicode_parser_type_id;
}

GType
unicode_parser_get_type (void)
{
	static volatile gsize unicode_parser_type_id__once = 0;
	if (g_once_init_enter (&unicode_parser_type_id__once)) {
		GType unicode_parser_type_id;
		unicode_parser_type_id = unicode_parser_get_type_once ();
		g_once_init_leave (&unicode_parser_type_id__once, unicode_parser_type_id);
	}
	return unicode_parser_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

