/* ParsedEvent.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ParsedEvent.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2015 elementary LLC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Mario Guerriero <marioguerriero33@gmail.com>
 *              pantor
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_SERVICES_TYPE_PARSED_EVENT (maya_services_parsed_event_get_type ())
#define MAYA_SERVICES_PARSED_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEvent))
#define MAYA_SERVICES_PARSED_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEventClass))
#define MAYA_SERVICES_IS_PARSED_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT))
#define MAYA_SERVICES_IS_PARSED_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_SERVICES_TYPE_PARSED_EVENT))
#define MAYA_SERVICES_PARSED_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEventClass))

typedef struct _MayaServicesParsedEvent MayaServicesParsedEvent;
typedef struct _MayaServicesParsedEventClass MayaServicesParsedEventClass;
typedef struct _MayaServicesParsedEventPrivate MayaServicesParsedEventPrivate;
enum  {
	MAYA_SERVICES_PARSED_EVENT_0_PROPERTY,
	MAYA_SERVICES_PARSED_EVENT_NUM_PROPERTIES
};
static GParamSpec* maya_services_parsed_event_properties[MAYA_SERVICES_PARSED_EVENT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _MayaServicesParsedEvent {
	GObject parent_instance;
	MayaServicesParsedEventPrivate * priv;
	gchar* title;
	gchar* location;
	gchar* participants;
	GDateTime* from;
	GDateTime* to;
	gboolean* all_day;
	gboolean date_parsed;
	gboolean time_parsed;
};

struct _MayaServicesParsedEventClass {
	GObjectClass parent_class;
};

static gpointer maya_services_parsed_event_parent_class = NULL;

VALA_EXTERN GType maya_services_parsed_event_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaServicesParsedEvent, g_object_unref)
VALA_EXTERN MayaServicesParsedEvent* maya_services_parsed_event_new (const gchar* _title,
                                                         GDateTime* _from,
                                                         GDateTime* _to,
                                                         const gchar* _location,
                                                         gboolean* _all_day,
                                                         const gchar* _participants,
                                                         gboolean _date_parsed,
                                                         gboolean _time_parsed);
VALA_EXTERN MayaServicesParsedEvent* maya_services_parsed_event_construct (GType object_type,
                                                               const gchar* _title,
                                                               GDateTime* _from,
                                                               GDateTime* _to,
                                                               const gchar* _location,
                                                               gboolean* _all_day,
                                                               const gchar* _participants,
                                                               gboolean _date_parsed,
                                                               gboolean _time_parsed);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN void maya_services_parsed_event_set_length_to_minutes (MayaServicesParsedEvent* self,
                                                       gint minutes);
VALA_EXTERN void maya_services_parsed_event_set_length_to_hours (MayaServicesParsedEvent* self,
                                                     gint hours);
VALA_EXTERN void maya_services_parsed_event_set_length_to_days (MayaServicesParsedEvent* self,
                                                    gint days);
VALA_EXTERN void maya_services_parsed_event_set_length_to_weeks (MayaServicesParsedEvent* self,
                                                     gint weeks);
VALA_EXTERN void maya_services_parsed_event_from_set_second (MayaServicesParsedEvent* self,
                                                 gint second);
VALA_EXTERN void maya_services_parsed_event_to_set_second (MayaServicesParsedEvent* self,
                                               gint second);
VALA_EXTERN void maya_services_parsed_event_from_set_minute (MayaServicesParsedEvent* self,
                                                 gint minute);
VALA_EXTERN void maya_services_parsed_event_to_set_minute (MayaServicesParsedEvent* self,
                                               gint minute);
static gint maya_services_parsed_event_hour_from_half (MayaServicesParsedEvent* self,
                                                gint hour,
                                                const gchar* half);
VALA_EXTERN void maya_services_parsed_event_from_set_hour (MayaServicesParsedEvent* self,
                                               gint hour,
                                               const gchar* half);
VALA_EXTERN void maya_services_parsed_event_to_set_hour (MayaServicesParsedEvent* self,
                                             gint hour,
                                             const gchar* half);
VALA_EXTERN void maya_services_parsed_event_from_set_day (MayaServicesParsedEvent* self,
                                              gint day);
VALA_EXTERN void maya_services_parsed_event_to_set_day (MayaServicesParsedEvent* self,
                                            gint day);
VALA_EXTERN void maya_services_parsed_event_from_set_month (MayaServicesParsedEvent* self,
                                                gint month);
VALA_EXTERN void maya_services_parsed_event_to_set_month (MayaServicesParsedEvent* self,
                                              gint month);
VALA_EXTERN void maya_services_parsed_event_from_set_year (MayaServicesParsedEvent* self,
                                               gint year);
VALA_EXTERN void maya_services_parsed_event_to_set_year (MayaServicesParsedEvent* self,
                                             gint year);
VALA_EXTERN void maya_services_parsed_event_set_all_day (MayaServicesParsedEvent* self);
VALA_EXTERN void maya_services_parsed_event_unset_all_day (MayaServicesParsedEvent* self);
VALA_EXTERN void maya_services_parsed_event_set_one_entire_day (MayaServicesParsedEvent* self);
VALA_EXTERN void maya_services_parsed_event_if_elapsed_delay_to_next_day (MayaServicesParsedEvent* self,
                                                              GDateTime* simulated_dt);
VALA_EXTERN void maya_services_parsed_event_if_elapsed_delay_to_next_week (MayaServicesParsedEvent* self,
                                                               GDateTime* simulated_dt);
VALA_EXTERN void maya_services_parsed_event_if_elapsed_delay_to_next_month (MayaServicesParsedEvent* self,
                                                                GDateTime* simulated_dt);
VALA_EXTERN void maya_services_parsed_event_if_elapsed_delay_to_next_year (MayaServicesParsedEvent* self,
                                                               GDateTime* simulated_dt);
static void maya_services_parsed_event_finalize (GObject * obj);
static GType maya_services_parsed_event_get_type_once (void);

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

MayaServicesParsedEvent*
maya_services_parsed_event_construct (GType object_type,
                                      const gchar* _title,
                                      GDateTime* _from,
                                      GDateTime* _to,
                                      const gchar* _location,
                                      gboolean* _all_day,
                                      const gchar* _participants,
                                      gboolean _date_parsed,
                                      gboolean _time_parsed)
{
	MayaServicesParsedEvent * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gboolean* _tmp5_;
	g_return_val_if_fail (_title != NULL, NULL);
	g_return_val_if_fail (_location != NULL, NULL);
	g_return_val_if_fail (_participants != NULL, NULL);
	self = (MayaServicesParsedEvent*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (_title);
	_g_free0 (self->title);
	self->title = _tmp0_;
	_tmp1_ = g_strdup (_location);
	_g_free0 (self->location);
	self->location = _tmp1_;
	_tmp2_ = g_strdup (_participants);
	_g_free0 (self->participants);
	self->participants = _tmp2_;
	_tmp3_ = _g_date_time_ref0 (_from);
	_g_date_time_unref0 (self->from);
	self->from = _tmp3_;
	_tmp4_ = _g_date_time_ref0 (_to);
	_g_date_time_unref0 (self->to);
	self->to = _tmp4_;
	_tmp5_ = __bool_dup0 (_all_day);
	_g_free0 (self->all_day);
	self->all_day = _tmp5_;
	self->date_parsed = _date_parsed;
	self->time_parsed = _time_parsed;
	return self;
}

MayaServicesParsedEvent*
maya_services_parsed_event_new (const gchar* _title,
                                GDateTime* _from,
                                GDateTime* _to,
                                const gchar* _location,
                                gboolean* _all_day,
                                const gchar* _participants,
                                gboolean _date_parsed,
                                gboolean _time_parsed)
{
	return maya_services_parsed_event_construct (MAYA_SERVICES_TYPE_PARSED_EVENT, _title, _from, _to, _location, _all_day, _participants, _date_parsed, _time_parsed);
}

void
maya_services_parsed_event_set_length_to_minutes (MayaServicesParsedEvent* self,
                                                  gint minutes)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->from;
	_tmp1_ = g_date_time_add_minutes (_tmp0_, minutes);
	_g_date_time_unref0 (self->to);
	self->to = _tmp1_;
}

void
maya_services_parsed_event_set_length_to_hours (MayaServicesParsedEvent* self,
                                                gint hours)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->from;
	_tmp1_ = g_date_time_add_hours (_tmp0_, hours);
	_g_date_time_unref0 (self->to);
	self->to = _tmp1_;
}

void
maya_services_parsed_event_set_length_to_days (MayaServicesParsedEvent* self,
                                               gint days)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->from;
	_tmp1_ = g_date_time_add_days (_tmp0_, days);
	_g_date_time_unref0 (self->to);
	self->to = _tmp1_;
}

void
maya_services_parsed_event_set_length_to_weeks (MayaServicesParsedEvent* self,
                                                gint weeks)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->from;
	_tmp1_ = g_date_time_add_days (_tmp0_, 7 * weeks);
	_g_date_time_unref0 (self->to);
	self->to = _tmp1_;
}

void
maya_services_parsed_event_from_set_second (MayaServicesParsedEvent* self,
                                            gint second)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->from;
	_tmp1_ = self->from;
	_tmp2_ = g_date_time_add_seconds (_tmp0_, (gdouble) (second - g_date_time_get_second (_tmp1_)));
	_g_date_time_unref0 (self->from);
	self->from = _tmp2_;
}

void
maya_services_parsed_event_to_set_second (MayaServicesParsedEvent* self,
                                          gint second)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->to;
	_tmp1_ = self->to;
	_tmp2_ = g_date_time_add_seconds (_tmp0_, (gdouble) (second - g_date_time_get_second (_tmp1_)));
	_g_date_time_unref0 (self->to);
	self->to = _tmp2_;
}

void
maya_services_parsed_event_from_set_minute (MayaServicesParsedEvent* self,
                                            gint minute)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->from;
	_tmp1_ = self->from;
	_tmp2_ = g_date_time_add_minutes (_tmp0_, minute - g_date_time_get_minute (_tmp1_));
	_g_date_time_unref0 (self->from);
	self->from = _tmp2_;
}

void
maya_services_parsed_event_to_set_minute (MayaServicesParsedEvent* self,
                                          gint minute)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->to;
	_tmp1_ = self->to;
	_tmp2_ = g_date_time_add_minutes (_tmp0_, minute - g_date_time_get_minute (_tmp1_));
	_g_date_time_unref0 (self->to);
	self->to = _tmp2_;
}

static gint
maya_services_parsed_event_hour_from_half (MayaServicesParsedEvent* self,
                                           gint hour,
                                           const gchar* half)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (half != NULL, 0);
	if (hour > 12) {
		result = hour;
		return result;
	}
	if (g_strcmp0 (half, "pm") == 0) {
		result = hour + 12;
		return result;
	}
	if (g_strcmp0 (half, "p") == 0) {
		result = hour + 12;
		return result;
	}
	if (g_strcmp0 (half, "") == 0) {
		if (hour < 8) {
			hour = hour + 12;
		}
	}
	result = hour;
	return result;
}

void
maya_services_parsed_event_from_set_hour (MayaServicesParsedEvent* self,
                                          gint hour,
                                          const gchar* half)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (half != NULL);
	hour = maya_services_parsed_event_hour_from_half (self, hour, half);
	_tmp0_ = self->from;
	_tmp1_ = self->from;
	_tmp2_ = g_date_time_add_hours (_tmp0_, hour - g_date_time_get_hour (_tmp1_));
	_g_date_time_unref0 (self->from);
	self->from = _tmp2_;
}

void
maya_services_parsed_event_to_set_hour (MayaServicesParsedEvent* self,
                                        gint hour,
                                        const gchar* half)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (half != NULL);
	hour = maya_services_parsed_event_hour_from_half (self, hour, half);
	_tmp0_ = self->to;
	_tmp1_ = self->to;
	_tmp2_ = g_date_time_add_hours (_tmp0_, hour - g_date_time_get_hour (_tmp1_));
	_g_date_time_unref0 (self->to);
	self->to = _tmp2_;
}

void
maya_services_parsed_event_from_set_day (MayaServicesParsedEvent* self,
                                         gint day)
{
	g_return_if_fail (self != NULL);
	if (day > 0) {
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp0_ = self->from;
		_tmp1_ = self->from;
		_tmp2_ = g_date_time_add_days (_tmp0_, day - g_date_time_get_day_of_month (_tmp1_));
		_g_date_time_unref0 (self->from);
		self->from = _tmp2_;
	}
}

void
maya_services_parsed_event_to_set_day (MayaServicesParsedEvent* self,
                                       gint day)
{
	g_return_if_fail (self != NULL);
	if (day > 0) {
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp0_ = self->to;
		_tmp1_ = self->to;
		_tmp2_ = g_date_time_add_days (_tmp0_, day - g_date_time_get_day_of_month (_tmp1_));
		_g_date_time_unref0 (self->to);
		self->to = _tmp2_;
	}
}

void
maya_services_parsed_event_from_set_month (MayaServicesParsedEvent* self,
                                           gint month)
{
	g_return_if_fail (self != NULL);
	if (month > 0) {
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp0_ = self->from;
		_tmp1_ = self->from;
		_tmp2_ = g_date_time_add_months (_tmp0_, month - g_date_time_get_month (_tmp1_));
		_g_date_time_unref0 (self->from);
		self->from = _tmp2_;
	}
}

void
maya_services_parsed_event_to_set_month (MayaServicesParsedEvent* self,
                                         gint month)
{
	g_return_if_fail (self != NULL);
	if (month > 0) {
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp0_ = self->to;
		_tmp1_ = self->to;
		_tmp2_ = g_date_time_add_months (_tmp0_, month - g_date_time_get_month (_tmp1_));
		_g_date_time_unref0 (self->to);
		self->to = _tmp2_;
	}
}

void
maya_services_parsed_event_from_set_year (MayaServicesParsedEvent* self,
                                          gint year)
{
	g_return_if_fail (self != NULL);
	if (year > 0) {
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp0_ = self->from;
		_tmp1_ = self->from;
		_tmp2_ = g_date_time_add_years (_tmp0_, year - g_date_time_get_year (_tmp1_));
		_g_date_time_unref0 (self->from);
		self->from = _tmp2_;
	}
}

void
maya_services_parsed_event_to_set_year (MayaServicesParsedEvent* self,
                                        gint year)
{
	g_return_if_fail (self != NULL);
	if (year > 0) {
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp0_ = self->to;
		_tmp1_ = self->to;
		_tmp2_ = g_date_time_add_years (_tmp0_, year - g_date_time_get_year (_tmp1_));
		_g_date_time_unref0 (self->to);
		self->to = _tmp2_;
	}
}

void
maya_services_parsed_event_set_all_day (MayaServicesParsedEvent* self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	gboolean _tmp12_;
	gboolean* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->from;
	_tmp1_ = self->from;
	_tmp2_ = g_date_time_add_hours (_tmp0_, -g_date_time_get_hour (_tmp1_));
	_tmp3_ = _tmp2_;
	_tmp4_ = self->from;
	_tmp5_ = g_date_time_add_minutes (_tmp3_, -g_date_time_get_minute (_tmp4_));
	_g_date_time_unref0 (self->from);
	self->from = _tmp5_;
	_g_date_time_unref0 (_tmp3_);
	_tmp6_ = self->to;
	_tmp7_ = self->to;
	_tmp8_ = g_date_time_add_hours (_tmp6_, -g_date_time_get_hour (_tmp7_));
	_tmp9_ = _tmp8_;
	_tmp10_ = self->to;
	_tmp11_ = g_date_time_add_minutes (_tmp9_, -g_date_time_get_minute (_tmp10_));
	_g_date_time_unref0 (self->to);
	self->to = _tmp11_;
	_g_date_time_unref0 (_tmp9_);
	_tmp12_ = TRUE;
	_tmp13_ = __bool_dup0 (&_tmp12_);
	_g_free0 (self->all_day);
	self->all_day = _tmp13_;
}

void
maya_services_parsed_event_unset_all_day (MayaServicesParsedEvent* self)
{
	gboolean _tmp0_;
	gboolean* _tmp1_;
	g_return_if_fail (self != NULL);
	maya_services_parsed_event_set_length_to_hours (self, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->all_day);
	self->all_day = _tmp1_;
}

void
maya_services_parsed_event_set_one_entire_day (MayaServicesParsedEvent* self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	gboolean _tmp8_;
	gboolean* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->from;
	_tmp1_ = self->from;
	_tmp2_ = g_date_time_add_hours (_tmp0_, -g_date_time_get_hour (_tmp1_));
	_tmp3_ = _tmp2_;
	_tmp4_ = self->from;
	_tmp5_ = g_date_time_add_minutes (_tmp3_, -g_date_time_get_minute (_tmp4_));
	_g_date_time_unref0 (self->from);
	self->from = _tmp5_;
	_g_date_time_unref0 (_tmp3_);
	_tmp6_ = self->from;
	_tmp7_ = _g_date_time_ref0 (_tmp6_);
	_g_date_time_unref0 (self->to);
	self->to = _tmp7_;
	_tmp8_ = TRUE;
	_tmp9_ = __bool_dup0 (&_tmp8_);
	_g_free0 (self->all_day);
	self->all_day = _tmp9_;
}

void
maya_services_parsed_event_if_elapsed_delay_to_next_day (MayaServicesParsedEvent* self,
                                                         GDateTime* simulated_dt)
{
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (simulated_dt != NULL);
	_tmp0_ = self->from;
	if (g_date_time_compare (_tmp0_, simulated_dt) < 0) {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		_tmp1_ = self->from;
		_tmp2_ = g_date_time_add_days (_tmp1_, 1);
		_g_date_time_unref0 (self->from);
		self->from = _tmp2_;
		_tmp3_ = self->to;
		_tmp4_ = g_date_time_add_days (_tmp3_, 1);
		_g_date_time_unref0 (self->to);
		self->to = _tmp4_;
	}
}

void
maya_services_parsed_event_if_elapsed_delay_to_next_week (MayaServicesParsedEvent* self,
                                                          GDateTime* simulated_dt)
{
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (simulated_dt != NULL);
	_tmp0_ = self->from;
	if (g_date_time_compare (_tmp0_, simulated_dt) < 0) {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		_tmp1_ = self->from;
		_tmp2_ = g_date_time_add_days (_tmp1_, 7);
		_g_date_time_unref0 (self->from);
		self->from = _tmp2_;
		_tmp3_ = self->to;
		_tmp4_ = g_date_time_add_days (_tmp3_, 7);
		_g_date_time_unref0 (self->to);
		self->to = _tmp4_;
	}
}

void
maya_services_parsed_event_if_elapsed_delay_to_next_month (MayaServicesParsedEvent* self,
                                                           GDateTime* simulated_dt)
{
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (simulated_dt != NULL);
	_tmp0_ = self->from;
	if (g_date_time_compare (_tmp0_, simulated_dt) < 0) {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		_tmp1_ = self->from;
		_tmp2_ = g_date_time_add_months (_tmp1_, 1);
		_g_date_time_unref0 (self->from);
		self->from = _tmp2_;
		_tmp3_ = self->to;
		_tmp4_ = g_date_time_add_months (_tmp3_, 1);
		_g_date_time_unref0 (self->to);
		self->to = _tmp4_;
	}
}

void
maya_services_parsed_event_if_elapsed_delay_to_next_year (MayaServicesParsedEvent* self,
                                                          GDateTime* simulated_dt)
{
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (simulated_dt != NULL);
	_tmp0_ = self->from;
	if (g_date_time_compare (_tmp0_, simulated_dt) < 0) {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		_tmp1_ = self->from;
		_tmp2_ = g_date_time_add_years (_tmp1_, 1);
		_g_date_time_unref0 (self->from);
		self->from = _tmp2_;
		_tmp3_ = self->to;
		_tmp4_ = g_date_time_add_years (_tmp3_, 1);
		_g_date_time_unref0 (self->to);
		self->to = _tmp4_;
	}
}

static void
maya_services_parsed_event_class_init (MayaServicesParsedEventClass * klass,
                                       gpointer klass_data)
{
	maya_services_parsed_event_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = maya_services_parsed_event_finalize;
}

static void
maya_services_parsed_event_instance_init (MayaServicesParsedEvent * self,
                                          gpointer klass)
{
}

static void
maya_services_parsed_event_finalize (GObject * obj)
{
	MayaServicesParsedEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEvent);
	_g_free0 (self->title);
	_g_free0 (self->location);
	_g_free0 (self->participants);
	_g_date_time_unref0 (self->from);
	_g_date_time_unref0 (self->to);
	_g_free0 (self->all_day);
	G_OBJECT_CLASS (maya_services_parsed_event_parent_class)->finalize (obj);
}

static GType
maya_services_parsed_event_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaServicesParsedEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_services_parsed_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaServicesParsedEvent), 0, (GInstanceInitFunc) maya_services_parsed_event_instance_init, NULL };
	GType maya_services_parsed_event_type_id;
	maya_services_parsed_event_type_id = g_type_register_static (G_TYPE_OBJECT, "MayaServicesParsedEvent", &g_define_type_info, 0);
	return maya_services_parsed_event_type_id;
}

GType
maya_services_parsed_event_get_type (void)
{
	static volatile gsize maya_services_parsed_event_type_id__once = 0;
	if (g_once_init_enter (&maya_services_parsed_event_type_id__once)) {
		GType maya_services_parsed_event_type_id;
		maya_services_parsed_event_type_id = maya_services_parsed_event_get_type_once ();
		g_once_init_leave (&maya_services_parsed_event_type_id__once, maya_services_parsed_event_type_id);
	}
	return maya_services_parsed_event_type_id__once;
}

