/* VersionTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from VersionTable.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer version_table_parent_class = NULL;
static VersionTable* version_table_instance;
static VersionTable* version_table_instance = NULL;

static VersionTable* version_table_new (void);
static VersionTable* version_table_construct (GType object_type);
static void version_table_finalize (DatabaseTable * obj);
static GType version_table_get_type_once (void);

static VersionTable*
version_table_construct (GType object_type)
{
	VersionTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	self = (VersionTable*) database_table_construct (object_type);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS VersionTable (" "id INTEGER PRIMARY KEY, " "schema_version INTEGER, " "app_version TEXT, " "user_data TEXT NULL" ")");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create version table", res);
	}
	database_table_set_table_name ((DatabaseTable*) self, "VersionTable");
	_sqlite3_finalize0 (stmt);
	return self;
}

static VersionTable*
version_table_new (void)
{
	return version_table_construct (TYPE_VERSION_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

VersionTable*
version_table_get_instance (void)
{
	VersionTable* _tmp0_;
	VersionTable* _tmp2_;
	VersionTable* _tmp3_;
	VersionTable* result;
	_tmp0_ = version_table_instance;
	if (_tmp0_ == NULL) {
		VersionTable* _tmp1_;
		_tmp1_ = version_table_new ();
		_database_table_unref0 (version_table_instance);
		version_table_instance = _tmp1_;
	}
	_tmp2_ = version_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gint
version_table_get_version (VersionTable* self,
                           gchar** app_version)
{
	gchar* _vala_app_version = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	sqlite3_stmt* _tmp5_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT schema_version, app_version FROM VersionTable ORDER BY schema_v" \
"ersion DESC LIMIT 1");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res != SQLITE_ROW) {
		if (res != SQLITE_DONE) {
			database_table_fatal ("get_version", res);
		}
		_g_free0 (_vala_app_version);
		_vala_app_version = NULL;
		result = -1;
		_sqlite3_finalize0 (stmt);
		if (app_version) {
			*app_version = _vala_app_version;
		} else {
			_g_free0 (_vala_app_version);
		}
		return result;
	}
	_tmp2_ = stmt;
	_tmp3_ = (const gchar*) sqlite3_column_text (_tmp2_, 1);
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_vala_app_version);
	_vala_app_version = _tmp4_;
	_tmp5_ = stmt;
	result = sqlite3_column_int (_tmp5_, 0);
	_sqlite3_finalize0 (stmt);
	if (app_version) {
		*app_version = _vala_app_version;
	} else {
		_g_free0 (_vala_app_version);
	}
	return result;
}

void
version_table_set_version (VersionTable* self,
                           gint version,
                           const gchar* app_version,
                           const gchar* user_data)
{
	sqlite3_stmt* stmt = NULL;
	gchar* bitbucket = NULL;
	gchar* _tmp0_ = NULL;
	gint _tmp1_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	gint res = 0;
	sqlite3_stmt* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_version != NULL);
	_tmp1_ = version_table_get_version (self, &_tmp0_);
	_g_free0 (bitbucket);
	bitbucket = _tmp0_;
	if (_tmp1_ != -1) {
		sqlite3_stmt* _tmp2_;
		_tmp2_ = database_table_create_stmt ((DatabaseTable*) self, "UPDATE VersionTable SET schema_version=?, app_version=?, user_data=?");
		_sqlite3_finalize0 (stmt);
		stmt = _tmp2_;
	} else {
		sqlite3_stmt* _tmp3_;
		_tmp3_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO VersionTable (schema_version, app_version, user_data) VALU" \
"ES (?,?, ?)");
		_sqlite3_finalize0 (stmt);
		stmt = _tmp3_;
	}
	_tmp4_ = stmt;
	database_table_bind_int (_tmp4_, 1, version);
	_tmp5_ = stmt;
	database_table_bind_text (_tmp5_, 2, app_version);
	_tmp6_ = stmt;
	database_table_bind_text (_tmp6_, 3, user_data);
	_tmp7_ = stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_DONE) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = g_strdup_printf ("set_version %d %s %s", version, app_version, user_data);
		_tmp9_ = _tmp8_;
		database_table_fatal (_tmp9_, res);
		_g_free0 (_tmp9_);
	}
	_g_free0 (bitbucket);
	_sqlite3_finalize0 (stmt);
}

void
version_table_update_version (VersionTable* self,
                              gint version,
                              const gchar* app_version)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	gint res = 0;
	sqlite3_stmt* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_version != NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "UPDATE VersionTable SET schema_version=?, app_version=?");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	database_table_bind_int (_tmp1_, 1, version);
	_tmp2_ = stmt;
	database_table_bind_text (_tmp2_, 2, app_version);
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup_printf ("update_version %d", version);
		_tmp5_ = _tmp4_;
		database_table_fatal (_tmp5_, res);
		_g_free0 (_tmp5_);
	}
	_sqlite3_finalize0 (stmt);
}

static void
version_table_class_init (VersionTableClass * klass,
                          gpointer klass_data)
{
	version_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = version_table_finalize;
}

static void
version_table_instance_init (VersionTable * self,
                             gpointer klass)
{
}

static void
version_table_finalize (DatabaseTable * obj)
{
	VersionTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VERSION_TABLE, VersionTable);
	DATABASE_TABLE_CLASS (version_table_parent_class)->finalize (obj);
}

static GType
version_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VersionTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) version_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VersionTable), 0, (GInstanceInitFunc) version_table_instance_init, NULL };
	GType version_table_type_id;
	version_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "VersionTable", &g_define_type_info, 0);
	return version_table_type_id;
}

GType
version_table_get_type (void)
{
	static volatile gsize version_table_type_id__once = 0;
	if (g_once_init_enter (&version_table_type_id__once)) {
		GType version_table_type_id;
		version_table_type_id = version_table_get_type_once ();
		g_once_init_leave (&version_table_type_id__once, version_table_type_id);
	}
	return version_table_type_id__once;
}

