// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <avtArrayMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtArrayMetaData::avtArrayMetaData
//
// Purpose:
//   Init utility for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtArrayMetaData::Init()
{
    nVars = 0;

    avtArrayMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtArrayMetaData::avtArrayMetaData
//
// Purpose:
//   Copy utility for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void avtArrayMetaData::Copy(const avtArrayMetaData &obj)
{
    nVars = obj.nVars;
    compNames = obj.compNames;

    avtArrayMetaData::SelectAll();
}

// Type map format string
const char *avtArrayMetaData::TypeMapFormatString = AVTARRAYMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtArrayMetaData::TmfsStruct = {AVTARRAYMETADATA_TMFS};


// ****************************************************************************
// Method: avtArrayMetaData::avtArrayMetaData
//
// Purpose:
//   Default constructor for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtArrayMetaData::avtArrayMetaData() :
    avtVarMetaData(avtArrayMetaData::TmfsStruct)
{
    avtArrayMetaData::Init();
}

// ****************************************************************************
// Method: avtArrayMetaData::avtArrayMetaData
//
// Purpose:
//   Constructor for the derived classes of avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtArrayMetaData::avtArrayMetaData(private_tmfs_t tmfs) :
    avtVarMetaData(tmfs)
{
    avtArrayMetaData::Init();
}

// ****************************************************************************
// Method: avtArrayMetaData::avtArrayMetaData
//
// Purpose:
//   Copy constructor for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtArrayMetaData::avtArrayMetaData(const avtArrayMetaData &obj) :
    avtVarMetaData(obj,avtArrayMetaData::TmfsStruct)
{
    avtArrayMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtArrayMetaData::avtArrayMetaData
//
// Purpose:
//   Copy constructor for derived classes of the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtArrayMetaData::avtArrayMetaData(const avtArrayMetaData &obj, private_tmfs_t tmfs) :
    avtVarMetaData(obj,tmfs)
{
    avtArrayMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtArrayMetaData::~avtArrayMetaData
//
// Purpose:
//   Destructor for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtArrayMetaData::~avtArrayMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtArrayMetaData::operator =
//
// Purpose:
//   Assignment operator for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

avtArrayMetaData&
avtArrayMetaData::operator = (const avtArrayMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtVarMetaData::operator=(obj);

    avtArrayMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtArrayMetaData::operator ==
//
// Purpose:
//   Comparison operator == for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtArrayMetaData::operator == (const avtArrayMetaData &obj) const
{
    // Create the return value
    return ((nVars == obj.nVars) &&
            (compNames == obj.compNames) &&
            avtVarMetaData::operator==(obj));
}

// ****************************************************************************
// Method: avtArrayMetaData::operator !=
//
// Purpose:
//   Comparison operator != for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtArrayMetaData::operator != (const avtArrayMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtArrayMetaData::TypeName
//
// Purpose:
//   Type name method for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
avtArrayMetaData::TypeName() const
{
    return "avtArrayMetaData";
}

// ****************************************************************************
// Method: avtArrayMetaData::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtArrayMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtArrayMetaData *tmp = (const avtArrayMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtArrayMetaData::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtArrayMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtArrayMetaData(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: avtArrayMetaData::NewInstance
//
// Purpose:
//   NewInstance method for the avtArrayMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
avtArrayMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtArrayMetaData(*this);
    else
        retval = new avtArrayMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtArrayMetaData::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
avtArrayMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtVarMetaData::SelectAll();
    Select(ID_nVars,     (void *)&nVars);
    Select(ID_compNames, (void *)&compNames);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtArrayMetaData::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtArrayMetaData::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_nVars:     return "nVars";
    case ID_compNames: return "compNames";
    default:  return avtVarMetaData::GetFieldName(index);
    }
}

// ****************************************************************************
// Method: avtArrayMetaData::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
avtArrayMetaData::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_nVars:     return FieldType_int;
    case ID_compNames: return FieldType_stringVector;
    default:  return avtVarMetaData::GetFieldType(index);
    }
}

// ****************************************************************************
// Method: avtArrayMetaData::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
avtArrayMetaData::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_nVars:     return "int";
    case ID_compNames: return "stringVector";
    default:  return avtVarMetaData::GetFieldTypeName(index);
    }
}

// ****************************************************************************
// Method: avtArrayMetaData::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
avtArrayMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const avtArrayMetaData &obj = *((const avtArrayMetaData*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_nVars:
        {  // new scope
        retval = (nVars == obj.nVars);
        }
        break;
    case ID_compNames:
        {  // new scope
        retval = (compNames == obj.compNames);
        }
        break;
    default: retval = avtVarMetaData::FieldsEqual(index_, rhs);
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtArrayMetaData constructor
//
//  Arguments:
//      n           The name of the array variable.
//      mn          The name of the mesh the array var is defined on.
//      nv          The number of components.
//      c           The centering of the variable.
//
//  Programmer: Hank Childs
//  Creation:   July 19, 2005
//
// ****************************************************************************

avtArrayMetaData::avtArrayMetaData(std::string n, std::string mn,
                                   avtCentering c, int nv)
    : avtVarMetaData(avtArrayMetaData::TmfsStruct, n, mn, c)
{
    avtArrayMetaData::Init();
    nVars = nv;
    compNames.resize(nVars);
    for (int i = 0 ; i < nVars ; i++)
    {
        char name[1024];
        snprintf(name, 1024, "comp%d", i);
    }
}

// ****************************************************************************
//  Method: avtArrayMetaData constructor
//
//  Arguments:
//      n           The name of the array variable.
//      mn          The name of the mesh the array var is defined on.
//      c           The centering of the variable.
//      nv          The number of components.
//      cn          The component names.
//
//  Programmer: Hank Childs
//  Creation:   July 19, 2005
//
// ****************************************************************************

avtArrayMetaData::avtArrayMetaData(std::string n, std::string mn,
                                   avtCentering c, int nv,
                                   const stringVector &cn)
    : avtVarMetaData(avtArrayMetaData::TmfsStruct, n, mn, c)
{
    avtArrayMetaData::Init();
    nVars = nv;
    compNames = cn;
}

// ****************************************************************************
//  Method: avtArrayMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer:  Hank Childs
//  Creation:    July 19, 2005
//
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}
void
avtArrayMetaData::Print(ostream &out, int indent) const
{
    avtVarMetaData::Print(out, indent);

    Indent(out, indent);
    out << "Number of variables = " << nVars << endl;
    Indent(out, indent);
    out << "Components are: ";
    for (size_t i = 0 ; i < compNames.size() ; i++)
    {
        out << compNames[i].c_str();
        if (i != compNames.size()-1)
            out << ", ";
        else
            out << endl;
    }
}

