/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "ptyxis-agent-ipc.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__UINT_UINT_BOXED (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintUintBoxedFunc)
       (void *data1,
        guint arg_position,
        guint arg_removed,
        const gchar *const *arg_added,
        void *data2);
  _GDbusCodegenMarshalVoid_UintUintBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintUintBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            g_marshal_value_peek_boxed (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_INT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringIntFunc)
       (void *data1,
        const gchar *arg_process,
        gint arg_exit_code,
        void *data2);
  _GDbusCodegenMarshalVoid_StringIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_int (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        GVariant *arg_pty_fd,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_STRING_BOXED_VARIANT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectStringBoxedVariantVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        const gchar *arg_cwd,
        const gchar *const *arg_argv,
        GVariant *arg_fds,
        GVariant *arg_env,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectStringBoxedVariantVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 7);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectStringBoxedVariantVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_boxed (param_values + 4),
              g_marshal_value_peek_variant (param_values + 5),
              g_marshal_value_peek_variant (param_values + 6),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_program,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_signum,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Ptyxis.Agent
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PtyxisIpcAgent
 * @title: PtyxisIpcAgent
 * @short_description: Generated C code for the org.gnome.Ptyxis.Agent D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Ptyxis-Agent.top_of_page">org.gnome.Ptyxis.Agent</link> D-Bus interface in C.
 */

enum
{
  PTYXIS_IPC__AGENT_CONTAINERS_CHANGED,
  PTYXIS_IPC__AGENT_PROCESS_EXITED,
};

static unsigned PTYXIS_IPC__AGENT_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.gnome.Ptyxis.Agent ---- */

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_method_info_get_preferred_shell_OUT_ARG_shell =
{
  {
    -1,
    (gchar *) "shell",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_agent_method_info_get_preferred_shell_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_agent_method_info_get_preferred_shell_OUT_ARG_shell.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_agent_method_info_get_preferred_shell =
{
  {
    -1,
    (gchar *) "GetPreferredShell",
    NULL,
    (GDBusArgInfo **) &_ptyxis_ipc_agent_method_info_get_preferred_shell_OUT_ARG_pointers,
    NULL
  },
  "handle-get-preferred-shell",
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_method_info_list_containers_OUT_ARG_containers =
{
  {
    -1,
    (gchar *) "containers",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_agent_method_info_list_containers_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_agent_method_info_list_containers_OUT_ARG_containers.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_agent_method_info_list_containers =
{
  {
    -1,
    (gchar *) "ListContainers",
    NULL,
    (GDBusArgInfo **) &_ptyxis_ipc_agent_method_info_list_containers_OUT_ARG_pointers,
    NULL
  },
  "handle-list-containers",
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_method_info_create_pty_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_agent_method_info_create_pty_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_agent_method_info_create_pty_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_agent_method_info_create_pty =
{
  {
    -1,
    (gchar *) "CreatePty",
    NULL,
    (GDBusArgInfo **) &_ptyxis_ipc_agent_method_info_create_pty_OUT_ARG_pointers,
    NULL
  },
  "handle-create-pty",
  TRUE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_method_info_create_pty_producer_IN_ARG_pty_fd =
{
  {
    -1,
    (gchar *) "pty_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_agent_method_info_create_pty_producer_IN_ARG_pointers[] =
{
  &_ptyxis_ipc_agent_method_info_create_pty_producer_IN_ARG_pty_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_method_info_create_pty_producer_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_agent_method_info_create_pty_producer_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_agent_method_info_create_pty_producer_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_agent_method_info_create_pty_producer =
{
  {
    -1,
    (gchar *) "CreatePtyProducer",
    (GDBusArgInfo **) &_ptyxis_ipc_agent_method_info_create_pty_producer_IN_ARG_pointers,
    (GDBusArgInfo **) &_ptyxis_ipc_agent_method_info_create_pty_producer_OUT_ARG_pointers,
    NULL
  },
  "handle-create-pty-producer",
  TRUE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_method_info_discover_current_container_IN_ARG_pty_fd =
{
  {
    -1,
    (gchar *) "pty_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_agent_method_info_discover_current_container_IN_ARG_pointers[] =
{
  &_ptyxis_ipc_agent_method_info_discover_current_container_IN_ARG_pty_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_method_info_discover_current_container_OUT_ARG_container =
{
  {
    -1,
    (gchar *) "container",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_agent_method_info_discover_current_container_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_agent_method_info_discover_current_container_OUT_ARG_container.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_agent_method_info_discover_current_container =
{
  {
    -1,
    (gchar *) "DiscoverCurrentContainer",
    (GDBusArgInfo **) &_ptyxis_ipc_agent_method_info_discover_current_container_IN_ARG_pointers,
    (GDBusArgInfo **) &_ptyxis_ipc_agent_method_info_discover_current_container_OUT_ARG_pointers,
    NULL
  },
  "handle-discover-current-container",
  TRUE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_method_info_discover_proxy_environment_OUT_ARG_proxy_environment =
{
  {
    -1,
    (gchar *) "proxy_environment",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_agent_method_info_discover_proxy_environment_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_agent_method_info_discover_proxy_environment_OUT_ARG_proxy_environment.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_agent_method_info_discover_proxy_environment =
{
  {
    -1,
    (gchar *) "DiscoverProxyEnvironment",
    NULL,
    (GDBusArgInfo **) &_ptyxis_ipc_agent_method_info_discover_proxy_environment_OUT_ARG_pointers,
    NULL
  },
  "handle-discover-proxy-environment",
  FALSE
};

static const GDBusMethodInfo * const _ptyxis_ipc_agent_method_info_pointers[] =
{
  &_ptyxis_ipc_agent_method_info_get_preferred_shell.parent_struct,
  &_ptyxis_ipc_agent_method_info_list_containers.parent_struct,
  &_ptyxis_ipc_agent_method_info_create_pty.parent_struct,
  &_ptyxis_ipc_agent_method_info_create_pty_producer.parent_struct,
  &_ptyxis_ipc_agent_method_info_discover_current_container.parent_struct,
  &_ptyxis_ipc_agent_method_info_discover_proxy_environment.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_signal_info_containers_changed_ARG_position =
{
  {
    -1,
    (gchar *) "position",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_signal_info_containers_changed_ARG_removed =
{
  {
    -1,
    (gchar *) "removed",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_signal_info_containers_changed_ARG_added =
{
  {
    -1,
    (gchar *) "added",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_agent_signal_info_containers_changed_ARG_pointers[] =
{
  &_ptyxis_ipc_agent_signal_info_containers_changed_ARG_position.parent_struct,
  &_ptyxis_ipc_agent_signal_info_containers_changed_ARG_removed.parent_struct,
  &_ptyxis_ipc_agent_signal_info_containers_changed_ARG_added.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ptyxis_ipc_agent_signal_info_containers_changed =
{
  {
    -1,
    (gchar *) "ContainersChanged",
    (GDBusArgInfo **) &_ptyxis_ipc_agent_signal_info_containers_changed_ARG_pointers,
    NULL
  },
  "containers-changed"
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_signal_info_process_exited_ARG_process =
{
  {
    -1,
    (gchar *) "process",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_agent_signal_info_process_exited_ARG_exit_code =
{
  {
    -1,
    (gchar *) "exit_code",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_agent_signal_info_process_exited_ARG_pointers[] =
{
  &_ptyxis_ipc_agent_signal_info_process_exited_ARG_process.parent_struct,
  &_ptyxis_ipc_agent_signal_info_process_exited_ARG_exit_code.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ptyxis_ipc_agent_signal_info_process_exited =
{
  {
    -1,
    (gchar *) "ProcessExited",
    (GDBusArgInfo **) &_ptyxis_ipc_agent_signal_info_process_exited_ARG_pointers,
    NULL
  },
  "process-exited"
};

static const GDBusSignalInfo * const _ptyxis_ipc_agent_signal_info_pointers[] =
{
  &_ptyxis_ipc_agent_signal_info_containers_changed.parent_struct,
  &_ptyxis_ipc_agent_signal_info_process_exited.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _ptyxis_ipc_agent_property_info_os_name =
{
  {
    -1,
    (gchar *) "OsName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "os-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ptyxis_ipc_agent_property_info_user_data_dir =
{
  {
    -1,
    (gchar *) "UserDataDir",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "user-data-dir",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _ptyxis_ipc_agent_property_info_pointers[] =
{
  &_ptyxis_ipc_agent_property_info_os_name.parent_struct,
  &_ptyxis_ipc_agent_property_info_user_data_dir.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ptyxis_ipc_agent_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Ptyxis.Agent",
    (GDBusMethodInfo **) &_ptyxis_ipc_agent_method_info_pointers,
    (GDBusSignalInfo **) &_ptyxis_ipc_agent_signal_info_pointers,
    (GDBusPropertyInfo **) &_ptyxis_ipc_agent_property_info_pointers,
    NULL
  },
  "agent",
};


/**
 * ptyxis_ipc_agent_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Ptyxis-Agent.top_of_page">org.gnome.Ptyxis.Agent</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ptyxis_ipc_agent_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ptyxis_ipc_agent_interface_info.parent_struct;
}

/**
 * ptyxis_ipc_agent_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PtyxisIpcAgent interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ptyxis_ipc_agent_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "os-name");
  g_object_class_override_property (klass, property_id_begin++, "user-data-dir");
  return property_id_begin - 1;
}


inline static void
ptyxis_ipc_agent_signal_marshal_containers_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_UINT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_agent_signal_marshal_process_exited (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_agent_method_marshal_get_preferred_shell (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_agent_method_marshal_list_containers (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_agent_method_marshal_create_pty (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_agent_method_marshal_create_pty_producer (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_agent_method_marshal_discover_current_container (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_agent_method_marshal_discover_proxy_environment (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PtyxisIpcAgent:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Agent.top_of_page">org.gnome.Ptyxis.Agent</link>.
 */

/**
 * PtyxisIpcAgentIface:
 * @parent_iface: The parent interface.
 * @handle_create_pty: Handler for the #PtyxisIpcAgent::handle-create-pty signal.
 * @handle_create_pty_producer: Handler for the #PtyxisIpcAgent::handle-create-pty-producer signal.
 * @handle_discover_current_container: Handler for the #PtyxisIpcAgent::handle-discover-current-container signal.
 * @handle_discover_proxy_environment: Handler for the #PtyxisIpcAgent::handle-discover-proxy-environment signal.
 * @handle_get_preferred_shell: Handler for the #PtyxisIpcAgent::handle-get-preferred-shell signal.
 * @handle_list_containers: Handler for the #PtyxisIpcAgent::handle-list-containers signal.
 * @get_os_name: Getter for the #PtyxisIpcAgent:os-name property.
 * @get_user_data_dir: Getter for the #PtyxisIpcAgent:user-data-dir property.
 * @containers_changed: Handler for the #PtyxisIpcAgent::containers-changed signal.
 * @process_exited: Handler for the #PtyxisIpcAgent::process-exited signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Agent.top_of_page">org.gnome.Ptyxis.Agent</link>.
 */

typedef PtyxisIpcAgentIface PtyxisIpcAgentInterface;
G_DEFINE_INTERFACE (PtyxisIpcAgent, ptyxis_ipc_agent, G_TYPE_OBJECT)

static void
ptyxis_ipc_agent_default_init (PtyxisIpcAgentIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PtyxisIpcAgent::handle-get-preferred-shell:
   * @object: A #PtyxisIpcAgent.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.GetPreferredShell">GetPreferredShell()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_agent_complete_get_preferred_shell() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-preferred-shell",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcAgentIface, handle_get_preferred_shell),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_agent_method_marshal_get_preferred_shell,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * PtyxisIpcAgent::handle-list-containers:
   * @object: A #PtyxisIpcAgent.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.ListContainers">ListContainers()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_agent_complete_list_containers() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-containers",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcAgentIface, handle_list_containers),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_agent_method_marshal_list_containers,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * PtyxisIpcAgent::handle-create-pty:
   * @object: A #PtyxisIpcAgent.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.CreatePty">CreatePty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_agent_complete_create_pty() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-pty",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcAgentIface, handle_create_pty),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_agent_method_marshal_create_pty,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST);

  /**
   * PtyxisIpcAgent::handle-create-pty-producer:
   * @object: A #PtyxisIpcAgent.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_pty_fd: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.CreatePtyProducer">CreatePtyProducer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_agent_complete_create_pty_producer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-pty-producer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcAgentIface, handle_create_pty_producer),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_agent_method_marshal_create_pty_producer,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /**
   * PtyxisIpcAgent::handle-discover-current-container:
   * @object: A #PtyxisIpcAgent.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_pty_fd: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.DiscoverCurrentContainer">DiscoverCurrentContainer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_agent_complete_discover_current_container() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-discover-current-container",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcAgentIface, handle_discover_current_container),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_agent_method_marshal_discover_current_container,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /**
   * PtyxisIpcAgent::handle-discover-proxy-environment:
   * @object: A #PtyxisIpcAgent.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.DiscoverProxyEnvironment">DiscoverProxyEnvironment()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_agent_complete_discover_proxy_environment() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-discover-proxy-environment",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcAgentIface, handle_discover_proxy_environment),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_agent_method_marshal_discover_proxy_environment,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * PtyxisIpcAgent::containers-changed:
   * @object: A #PtyxisIpcAgent.
   * @arg_position: Argument.
   * @arg_removed: Argument.
   * @arg_added: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Ptyxis-Agent.ContainersChanged">"ContainersChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PTYXIS_IPC__AGENT_SIGNALS[PTYXIS_IPC__AGENT_CONTAINERS_CHANGED] =
    g_signal_new ("containers-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PtyxisIpcAgentIface, containers_changed),
      NULL,
      NULL,
      ptyxis_ipc_agent_signal_marshal_containers_changed,
      G_TYPE_NONE,
      3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRV);

  /**
   * PtyxisIpcAgent::process-exited:
   * @object: A #PtyxisIpcAgent.
   * @arg_process: Argument.
   * @arg_exit_code: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Ptyxis-Agent.ProcessExited">"ProcessExited"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PTYXIS_IPC__AGENT_SIGNALS[PTYXIS_IPC__AGENT_PROCESS_EXITED] =
    g_signal_new ("process-exited",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PtyxisIpcAgentIface, process_exited),
      NULL,
      NULL,
      ptyxis_ipc_agent_signal_marshal_process_exited,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_INT);

  /* GObject properties for D-Bus properties: */
  /**
   * PtyxisIpcAgent:os-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Ptyxis-Agent.OsName">"OsName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("os-name", "OsName", "OsName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * PtyxisIpcAgent:user-data-dir:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Ptyxis-Agent.UserDataDir">"UserDataDir"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("user-data-dir", "UserDataDir", "UserDataDir", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * ptyxis_ipc_agent_get_os_name: (skip)
 * @object: A #PtyxisIpcAgent.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Ptyxis-Agent.OsName">"OsName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ptyxis_ipc_agent_dup_os_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ptyxis_ipc_agent_get_os_name (PtyxisIpcAgent *object)
{
  g_return_val_if_fail (PTYXIS_IPC_IS_AGENT (object), NULL);

  return PTYXIS_IPC_AGENT_GET_IFACE (object)->get_os_name (object);
}

/**
 * ptyxis_ipc_agent_dup_os_name: (skip)
 * @object: A #PtyxisIpcAgent.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Ptyxis-Agent.OsName">"OsName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ptyxis_ipc_agent_dup_os_name (PtyxisIpcAgent *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "os-name", &value, NULL);
  return value;
}

/**
 * ptyxis_ipc_agent_set_os_name: (skip)
 * @object: A #PtyxisIpcAgent.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Ptyxis-Agent.OsName">"OsName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ptyxis_ipc_agent_set_os_name (PtyxisIpcAgent *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "os-name", value, NULL);
}

/**
 * ptyxis_ipc_agent_get_user_data_dir: (skip)
 * @object: A #PtyxisIpcAgent.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Ptyxis-Agent.UserDataDir">"UserDataDir"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ptyxis_ipc_agent_dup_user_data_dir() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ptyxis_ipc_agent_get_user_data_dir (PtyxisIpcAgent *object)
{
  g_return_val_if_fail (PTYXIS_IPC_IS_AGENT (object), NULL);

  return PTYXIS_IPC_AGENT_GET_IFACE (object)->get_user_data_dir (object);
}

/**
 * ptyxis_ipc_agent_dup_user_data_dir: (skip)
 * @object: A #PtyxisIpcAgent.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Ptyxis-Agent.UserDataDir">"UserDataDir"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ptyxis_ipc_agent_dup_user_data_dir (PtyxisIpcAgent *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "user-data-dir", &value, NULL);
  return value;
}

/**
 * ptyxis_ipc_agent_set_user_data_dir: (skip)
 * @object: A #PtyxisIpcAgent.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Ptyxis-Agent.UserDataDir">"UserDataDir"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ptyxis_ipc_agent_set_user_data_dir (PtyxisIpcAgent *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "user-data-dir", value, NULL);
}

/**
 * ptyxis_ipc_agent_emit_containers_changed:
 * @object: A #PtyxisIpcAgent.
 * @arg_position: Argument to pass with the signal.
 * @arg_removed: Argument to pass with the signal.
 * @arg_added: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Ptyxis-Agent.ContainersChanged">"ContainersChanged"</link> D-Bus signal.
 */
void
ptyxis_ipc_agent_emit_containers_changed (
    PtyxisIpcAgent *object,
    guint arg_position,
    guint arg_removed,
    const gchar *const *arg_added)
{
  g_signal_emit (object, PTYXIS_IPC__AGENT_SIGNALS[PTYXIS_IPC__AGENT_CONTAINERS_CHANGED], 0, arg_position, arg_removed, arg_added);
}

/**
 * ptyxis_ipc_agent_emit_process_exited:
 * @object: A #PtyxisIpcAgent.
 * @arg_process: Argument to pass with the signal.
 * @arg_exit_code: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Ptyxis-Agent.ProcessExited">"ProcessExited"</link> D-Bus signal.
 */
void
ptyxis_ipc_agent_emit_process_exited (
    PtyxisIpcAgent *object,
    const gchar *arg_process,
    gint arg_exit_code)
{
  g_signal_emit (object, PTYXIS_IPC__AGENT_SIGNALS[PTYXIS_IPC__AGENT_PROCESS_EXITED], 0, arg_process, arg_exit_code);
}

/**
 * ptyxis_ipc_agent_call_get_preferred_shell:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.GetPreferredShell">GetPreferredShell()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_agent_call_get_preferred_shell_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_agent_call_get_preferred_shell_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_agent_call_get_preferred_shell (
    PtyxisIpcAgent *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetPreferredShell",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_agent_call_get_preferred_shell_finish:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @out_shell: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_agent_call_get_preferred_shell().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_agent_call_get_preferred_shell().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_get_preferred_shell_finish (
    PtyxisIpcAgent *proxy,
    gchar **out_shell,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_shell);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_get_preferred_shell_sync:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @out_shell: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.GetPreferredShell">GetPreferredShell()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_agent_call_get_preferred_shell() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_get_preferred_shell_sync (
    PtyxisIpcAgent *proxy,
    gchar **out_shell,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetPreferredShell",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_shell);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_list_containers:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.ListContainers">ListContainers()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_agent_call_list_containers_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_agent_call_list_containers_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_agent_call_list_containers (
    PtyxisIpcAgent *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListContainers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_agent_call_list_containers_finish:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @out_containers: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_agent_call_list_containers().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_agent_call_list_containers().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_list_containers_finish (
    PtyxisIpcAgent *proxy,
    gchar ***out_containers,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_containers);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_list_containers_sync:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @out_containers: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.ListContainers">ListContainers()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_agent_call_list_containers() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_list_containers_sync (
    PtyxisIpcAgent *proxy,
    gchar ***out_containers,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListContainers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_containers);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_create_pty:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.CreatePty">CreatePty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_agent_call_create_pty_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_agent_call_create_pty_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_agent_call_create_pty (
    PtyxisIpcAgent *proxy,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "CreatePty",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_agent_call_create_pty_finish:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_agent_call_create_pty().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_agent_call_create_pty().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_create_pty_finish (
    PtyxisIpcAgent *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_create_pty_sync:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.CreatePty">CreatePty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_agent_call_create_pty() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_create_pty_sync (
    PtyxisIpcAgent *proxy,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "CreatePty",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_create_pty_producer:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @arg_pty_fd: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.CreatePtyProducer">CreatePtyProducer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_agent_call_create_pty_producer_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_agent_call_create_pty_producer_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_agent_call_create_pty_producer (
    PtyxisIpcAgent *proxy,
    GVariant *arg_pty_fd,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "CreatePtyProducer",
    g_variant_new ("(@h)",
                   arg_pty_fd),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_agent_call_create_pty_producer_finish:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_agent_call_create_pty_producer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_agent_call_create_pty_producer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_create_pty_producer_finish (
    PtyxisIpcAgent *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_create_pty_producer_sync:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @arg_pty_fd: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.CreatePtyProducer">CreatePtyProducer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_agent_call_create_pty_producer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_create_pty_producer_sync (
    PtyxisIpcAgent *proxy,
    GVariant *arg_pty_fd,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "CreatePtyProducer",
    g_variant_new ("(@h)",
                   arg_pty_fd),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_discover_current_container:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @arg_pty_fd: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.DiscoverCurrentContainer">DiscoverCurrentContainer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_agent_call_discover_current_container_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_agent_call_discover_current_container_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_agent_call_discover_current_container (
    PtyxisIpcAgent *proxy,
    GVariant *arg_pty_fd,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "DiscoverCurrentContainer",
    g_variant_new ("(@h)",
                   arg_pty_fd),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_agent_call_discover_current_container_finish:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @out_container: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_agent_call_discover_current_container().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_agent_call_discover_current_container().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_discover_current_container_finish (
    PtyxisIpcAgent *proxy,
    gchar **out_container,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_container);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_discover_current_container_sync:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @arg_pty_fd: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_container: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.DiscoverCurrentContainer">DiscoverCurrentContainer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_agent_call_discover_current_container() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_discover_current_container_sync (
    PtyxisIpcAgent *proxy,
    GVariant *arg_pty_fd,
    GUnixFDList  *fd_list,
    gchar **out_container,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "DiscoverCurrentContainer",
    g_variant_new ("(@h)",
                   arg_pty_fd),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_container);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_discover_proxy_environment:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.DiscoverProxyEnvironment">DiscoverProxyEnvironment()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_agent_call_discover_proxy_environment_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_agent_call_discover_proxy_environment_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_agent_call_discover_proxy_environment (
    PtyxisIpcAgent *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DiscoverProxyEnvironment",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_agent_call_discover_proxy_environment_finish:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @out_proxy_environment: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_agent_call_discover_proxy_environment().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_agent_call_discover_proxy_environment().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_discover_proxy_environment_finish (
    PtyxisIpcAgent *proxy,
    gchar ***out_proxy_environment,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_proxy_environment);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_call_discover_proxy_environment_sync:
 * @proxy: A #PtyxisIpcAgentProxy.
 * @out_proxy_environment: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.DiscoverProxyEnvironment">DiscoverProxyEnvironment()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_agent_call_discover_proxy_environment() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_agent_call_discover_proxy_environment_sync (
    PtyxisIpcAgent *proxy,
    gchar ***out_proxy_environment,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DiscoverProxyEnvironment",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_proxy_environment);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_agent_complete_get_preferred_shell:
 * @object: A #PtyxisIpcAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @shell: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.GetPreferredShell">GetPreferredShell()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_agent_complete_get_preferred_shell (
    PtyxisIpcAgent *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *shell)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ay)",
                   shell));
}

/**
 * ptyxis_ipc_agent_complete_list_containers:
 * @object: A #PtyxisIpcAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @containers: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.ListContainers">ListContainers()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_agent_complete_list_containers (
    PtyxisIpcAgent *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *containers)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   containers));
}

/**
 * ptyxis_ipc_agent_complete_create_pty:
 * @object: A #PtyxisIpcAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.CreatePty">CreatePty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_agent_complete_create_pty (
    PtyxisIpcAgent *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * ptyxis_ipc_agent_complete_create_pty_producer:
 * @object: A #PtyxisIpcAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.CreatePtyProducer">CreatePtyProducer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_agent_complete_create_pty_producer (
    PtyxisIpcAgent *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * ptyxis_ipc_agent_complete_discover_current_container:
 * @object: A #PtyxisIpcAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @container: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.DiscoverCurrentContainer">DiscoverCurrentContainer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_agent_complete_discover_current_container (
    PtyxisIpcAgent *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *container)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(o)",
                   container),
    fd_list);
}

/**
 * ptyxis_ipc_agent_complete_discover_proxy_environment:
 * @object: A #PtyxisIpcAgent.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @proxy_environment: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Agent.DiscoverProxyEnvironment">DiscoverProxyEnvironment()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_agent_complete_discover_proxy_environment (
    PtyxisIpcAgent *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *proxy_environment)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   proxy_environment));
}

/* ------------------------------------------------------------------------ */

/**
 * PtyxisIpcAgentProxy:
 *
 * The #PtyxisIpcAgentProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PtyxisIpcAgentProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PtyxisIpcAgentProxy.
 */

struct _PtyxisIpcAgentProxyPrivate
{
  GData *qdata;
};

static void ptyxis_ipc_agent_proxy_iface_init (PtyxisIpcAgentIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcAgentProxy, ptyxis_ipc_agent_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PtyxisIpcAgentProxy)
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_AGENT, ptyxis_ipc_agent_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcAgentProxy, ptyxis_ipc_agent_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_AGENT, ptyxis_ipc_agent_proxy_iface_init))

#endif
static void
ptyxis_ipc_agent_proxy_finalize (GObject *object)
{
  PtyxisIpcAgentProxy *proxy = PTYXIS_IPC_AGENT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ptyxis_ipc_agent_proxy_parent_class)->finalize (object);
}

static void
ptyxis_ipc_agent_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ptyxis_ipc_agent_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
ptyxis_ipc_agent_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Ptyxis.Agent: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
ptyxis_ipc_agent_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ptyxis_ipc_agent_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Ptyxis.Agent", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) ptyxis_ipc_agent_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
ptyxis_ipc_agent_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ptyxis_ipc_agent_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PTYXIS_IPC_TYPE_AGENT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PTYXIS_IPC_TYPE_AGENT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ptyxis_ipc_agent_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PtyxisIpcAgentProxy *proxy = PTYXIS_IPC_AGENT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_agent_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_agent_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
ptyxis_ipc_agent_proxy_get_os_name (PtyxisIpcAgent *object)
{
  PtyxisIpcAgentProxy *proxy = PTYXIS_IPC_AGENT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OsName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ptyxis_ipc_agent_proxy_get_user_data_dir (PtyxisIpcAgent *object)
{
  PtyxisIpcAgentProxy *proxy = PTYXIS_IPC_AGENT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UserDataDir");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
ptyxis_ipc_agent_proxy_init (PtyxisIpcAgentProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ptyxis_ipc_agent_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PTYXIS_IPC_TYPE_AGENT_PROXY, PtyxisIpcAgentProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ptyxis_ipc_agent_interface_info ());
}

static void
ptyxis_ipc_agent_proxy_class_init (PtyxisIpcAgentProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ptyxis_ipc_agent_proxy_finalize;
  gobject_class->get_property = ptyxis_ipc_agent_proxy_get_property;
  gobject_class->set_property = ptyxis_ipc_agent_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ptyxis_ipc_agent_proxy_g_signal;
  proxy_class->g_properties_changed = ptyxis_ipc_agent_proxy_g_properties_changed;

  ptyxis_ipc_agent_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PtyxisIpcAgentProxyPrivate));
#endif
}

static void
ptyxis_ipc_agent_proxy_iface_init (PtyxisIpcAgentIface *iface)
{
  iface->get_os_name = ptyxis_ipc_agent_proxy_get_os_name;
  iface->get_user_data_dir = ptyxis_ipc_agent_proxy_get_user_data_dir;
}

/**
 * ptyxis_ipc_agent_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Agent.top_of_page">org.gnome.Ptyxis.Agent</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_agent_proxy_new_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_agent_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ptyxis_ipc_agent_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PTYXIS_IPC_TYPE_AGENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Agent", NULL);
}

/**
 * ptyxis_ipc_agent_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_agent_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ptyxis_ipc_agent_proxy_new().
 *
 * Returns: (transfer full) (type PtyxisIpcAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcAgent *
ptyxis_ipc_agent_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PTYXIS_IPC_AGENT (ret);
  else
    return NULL;
}

/**
 * ptyxis_ipc_agent_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Agent.top_of_page">org.gnome.Ptyxis.Agent</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_agent_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PtyxisIpcAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcAgent *
ptyxis_ipc_agent_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PTYXIS_IPC_TYPE_AGENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Agent", NULL);
  if (ret != NULL)
    return PTYXIS_IPC_AGENT (ret);
  else
    return NULL;
}


/**
 * ptyxis_ipc_agent_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ptyxis_ipc_agent_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_agent_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_agent_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ptyxis_ipc_agent_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PTYXIS_IPC_TYPE_AGENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Agent", NULL);
}

/**
 * ptyxis_ipc_agent_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_agent_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ptyxis_ipc_agent_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PtyxisIpcAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcAgent *
ptyxis_ipc_agent_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PTYXIS_IPC_AGENT (ret);
  else
    return NULL;
}

/**
 * ptyxis_ipc_agent_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ptyxis_ipc_agent_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_agent_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PtyxisIpcAgentProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcAgent *
ptyxis_ipc_agent_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PTYXIS_IPC_TYPE_AGENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Agent", NULL);
  if (ret != NULL)
    return PTYXIS_IPC_AGENT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PtyxisIpcAgentSkeleton:
 *
 * The #PtyxisIpcAgentSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PtyxisIpcAgentSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PtyxisIpcAgentSkeleton.
 */

struct _PtyxisIpcAgentSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ptyxis_ipc_agent_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PTYXIS_IPC_TYPE_AGENT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PTYXIS_IPC_TYPE_AGENT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ptyxis_ipc_agent_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_agent_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ptyxis_ipc_agent_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_agent_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ptyxis_ipc_agent_skeleton_vtable =
{
  _ptyxis_ipc_agent_skeleton_handle_method_call,
  _ptyxis_ipc_agent_skeleton_handle_get_property,
  _ptyxis_ipc_agent_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ptyxis_ipc_agent_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ptyxis_ipc_agent_interface_info ();
}

static GDBusInterfaceVTable *
ptyxis_ipc_agent_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ptyxis_ipc_agent_skeleton_vtable;
}

static GVariant *
ptyxis_ipc_agent_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_ptyxis_ipc_agent_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ptyxis_ipc_agent_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ptyxis_ipc_agent_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ptyxis_ipc_agent_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Ptyxis.Agent", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _ptyxis_ipc_agent_emit_changed (gpointer user_data);

static void
ptyxis_ipc_agent_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _ptyxis_ipc_agent_emit_changed (skeleton);
}

static void
_ptyxis_ipc_agent_on_signal_containers_changed (
    PtyxisIpcAgent *object,
    guint arg_position,
    guint arg_removed,
    const gchar *const *arg_added)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu^ao)",
                   arg_position,
                   arg_removed,
                   arg_added));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Ptyxis.Agent", "ContainersChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ptyxis_ipc_agent_on_signal_process_exited (
    PtyxisIpcAgent *object,
    const gchar *arg_process,
    gint arg_exit_code)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(oi)",
                   arg_process,
                   arg_exit_code));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Ptyxis.Agent", "ProcessExited",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void ptyxis_ipc_agent_skeleton_iface_init (PtyxisIpcAgentIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcAgentSkeleton, ptyxis_ipc_agent_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PtyxisIpcAgentSkeleton)
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_AGENT, ptyxis_ipc_agent_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcAgentSkeleton, ptyxis_ipc_agent_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_AGENT, ptyxis_ipc_agent_skeleton_iface_init))

#endif
static void
ptyxis_ipc_agent_skeleton_finalize (GObject *object)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ptyxis_ipc_agent_skeleton_parent_class)->finalize (object);
}

static void
ptyxis_ipc_agent_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_ptyxis_ipc_agent_emit_changed (gpointer user_data)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Ptyxis.Agent",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_ptyxis_ipc_agent_schedule_emit_changed (PtyxisIpcAgentSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
ptyxis_ipc_agent_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _ptyxis_ipc_agent_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _ptyxis_ipc_agent_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
ptyxis_ipc_agent_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ptyxis_ipc_agent_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _ptyxis_ipc_agent_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
ptyxis_ipc_agent_skeleton_init (PtyxisIpcAgentSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ptyxis_ipc_agent_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PTYXIS_IPC_TYPE_AGENT_SKELETON, PtyxisIpcAgentSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
}

static const gchar *
ptyxis_ipc_agent_skeleton_get_os_name (PtyxisIpcAgent *object)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ptyxis_ipc_agent_skeleton_get_user_data_dir (PtyxisIpcAgent *object)
{
  PtyxisIpcAgentSkeleton *skeleton = PTYXIS_IPC_AGENT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
ptyxis_ipc_agent_skeleton_class_init (PtyxisIpcAgentSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ptyxis_ipc_agent_skeleton_finalize;
  gobject_class->get_property = ptyxis_ipc_agent_skeleton_get_property;
  gobject_class->set_property = ptyxis_ipc_agent_skeleton_set_property;
  gobject_class->notify       = ptyxis_ipc_agent_skeleton_notify;


  ptyxis_ipc_agent_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ptyxis_ipc_agent_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ptyxis_ipc_agent_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ptyxis_ipc_agent_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ptyxis_ipc_agent_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PtyxisIpcAgentSkeletonPrivate));
#endif
}

static void
ptyxis_ipc_agent_skeleton_iface_init (PtyxisIpcAgentIface *iface)
{
  iface->containers_changed = _ptyxis_ipc_agent_on_signal_containers_changed;
  iface->process_exited = _ptyxis_ipc_agent_on_signal_process_exited;
  iface->get_os_name = ptyxis_ipc_agent_skeleton_get_os_name;
  iface->get_user_data_dir = ptyxis_ipc_agent_skeleton_get_user_data_dir;
}

/**
 * ptyxis_ipc_agent_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Agent.top_of_page">org.gnome.Ptyxis.Agent</link>.
 *
 * Returns: (transfer full) (type PtyxisIpcAgentSkeleton): The skeleton object.
 */
PtyxisIpcAgent *
ptyxis_ipc_agent_skeleton_new (void)
{
  return PTYXIS_IPC_AGENT (g_object_new (PTYXIS_IPC_TYPE_AGENT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Ptyxis.Container
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PtyxisIpcContainer
 * @title: PtyxisIpcContainer
 * @short_description: Generated C code for the org.gnome.Ptyxis.Container D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Ptyxis-Container.top_of_page">org.gnome.Ptyxis.Container</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Ptyxis.Container ---- */

static const _ExtendedGDBusArgInfo _ptyxis_ipc_container_method_info_spawn_IN_ARG_cwd =
{
  {
    -1,
    (gchar *) "cwd",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_container_method_info_spawn_IN_ARG_argv =
{
  {
    -1,
    (gchar *) "argv",
    (gchar *) "aay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_container_method_info_spawn_IN_ARG_fds =
{
  {
    -1,
    (gchar *) "fds",
    (gchar *) "a{uh}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_container_method_info_spawn_IN_ARG_env =
{
  {
    -1,
    (gchar *) "env",
    (gchar *) "a{ss}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_container_method_info_spawn_IN_ARG_pointers[] =
{
  &_ptyxis_ipc_container_method_info_spawn_IN_ARG_cwd.parent_struct,
  &_ptyxis_ipc_container_method_info_spawn_IN_ARG_argv.parent_struct,
  &_ptyxis_ipc_container_method_info_spawn_IN_ARG_fds.parent_struct,
  &_ptyxis_ipc_container_method_info_spawn_IN_ARG_env.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_container_method_info_spawn_OUT_ARG_process =
{
  {
    -1,
    (gchar *) "process",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_container_method_info_spawn_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_container_method_info_spawn_OUT_ARG_process.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_container_method_info_spawn =
{
  {
    -1,
    (gchar *) "Spawn",
    (GDBusArgInfo **) &_ptyxis_ipc_container_method_info_spawn_IN_ARG_pointers,
    (GDBusArgInfo **) &_ptyxis_ipc_container_method_info_spawn_OUT_ARG_pointers,
    NULL
  },
  "handle-spawn",
  TRUE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_container_method_info_find_program_in_path_IN_ARG_program =
{
  {
    -1,
    (gchar *) "program",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_container_method_info_find_program_in_path_IN_ARG_pointers[] =
{
  &_ptyxis_ipc_container_method_info_find_program_in_path_IN_ARG_program.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_container_method_info_find_program_in_path_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_container_method_info_find_program_in_path_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_container_method_info_find_program_in_path_OUT_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_container_method_info_find_program_in_path =
{
  {
    -1,
    (gchar *) "FindProgramInPath",
    (GDBusArgInfo **) &_ptyxis_ipc_container_method_info_find_program_in_path_IN_ARG_pointers,
    (GDBusArgInfo **) &_ptyxis_ipc_container_method_info_find_program_in_path_OUT_ARG_pointers,
    NULL
  },
  "handle-find-program-in-path",
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_container_method_info_translate_uri_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_container_method_info_translate_uri_IN_ARG_pointers[] =
{
  &_ptyxis_ipc_container_method_info_translate_uri_IN_ARG_uri.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_container_method_info_translate_uri_OUT_ARG_translated =
{
  {
    -1,
    (gchar *) "translated",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_container_method_info_translate_uri_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_container_method_info_translate_uri_OUT_ARG_translated.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_container_method_info_translate_uri =
{
  {
    -1,
    (gchar *) "TranslateURI",
    (GDBusArgInfo **) &_ptyxis_ipc_container_method_info_translate_uri_IN_ARG_pointers,
    (GDBusArgInfo **) &_ptyxis_ipc_container_method_info_translate_uri_OUT_ARG_pointers,
    NULL
  },
  "handle-translate-uri",
  FALSE
};

static const GDBusMethodInfo * const _ptyxis_ipc_container_method_info_pointers[] =
{
  &_ptyxis_ipc_container_method_info_spawn.parent_struct,
  &_ptyxis_ipc_container_method_info_find_program_in_path.parent_struct,
  &_ptyxis_ipc_container_method_info_translate_uri.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _ptyxis_ipc_container_property_info_provider =
{
  {
    -1,
    (gchar *) "Provider",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "provider",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ptyxis_ipc_container_property_info_id =
{
  {
    -1,
    (gchar *) "Id",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ptyxis_ipc_container_property_info_icon_name =
{
  {
    -1,
    (gchar *) "IconName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "icon-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ptyxis_ipc_container_property_info_display_name =
{
  {
    -1,
    (gchar *) "DisplayName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "display-name",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _ptyxis_ipc_container_property_info_pointers[] =
{
  &_ptyxis_ipc_container_property_info_provider.parent_struct,
  &_ptyxis_ipc_container_property_info_id.parent_struct,
  &_ptyxis_ipc_container_property_info_icon_name.parent_struct,
  &_ptyxis_ipc_container_property_info_display_name.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ptyxis_ipc_container_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Ptyxis.Container",
    (GDBusMethodInfo **) &_ptyxis_ipc_container_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_ptyxis_ipc_container_property_info_pointers,
    NULL
  },
  "container",
};


/**
 * ptyxis_ipc_container_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Ptyxis-Container.top_of_page">org.gnome.Ptyxis.Container</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ptyxis_ipc_container_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ptyxis_ipc_container_interface_info.parent_struct;
}

/**
 * ptyxis_ipc_container_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PtyxisIpcContainer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ptyxis_ipc_container_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "provider");
  g_object_class_override_property (klass, property_id_begin++, "id");
  g_object_class_override_property (klass, property_id_begin++, "icon-name");
  g_object_class_override_property (klass, property_id_begin++, "display-name");
  return property_id_begin - 1;
}


inline static void
ptyxis_ipc_container_method_marshal_spawn (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_STRING_BOXED_VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_container_method_marshal_find_program_in_path (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_container_method_marshal_translate_uri (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PtyxisIpcContainer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Container.top_of_page">org.gnome.Ptyxis.Container</link>.
 */

/**
 * PtyxisIpcContainerIface:
 * @parent_iface: The parent interface.
 * @handle_find_program_in_path: Handler for the #PtyxisIpcContainer::handle-find-program-in-path signal.
 * @handle_spawn: Handler for the #PtyxisIpcContainer::handle-spawn signal.
 * @handle_translate_uri: Handler for the #PtyxisIpcContainer::handle-translate-uri signal.
 * @get_display_name: Getter for the #PtyxisIpcContainer:display-name property.
 * @get_icon_name: Getter for the #PtyxisIpcContainer:icon-name property.
 * @get_id: Getter for the #PtyxisIpcContainer:id property.
 * @get_provider: Getter for the #PtyxisIpcContainer:provider property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Container.top_of_page">org.gnome.Ptyxis.Container</link>.
 */

typedef PtyxisIpcContainerIface PtyxisIpcContainerInterface;
G_DEFINE_INTERFACE (PtyxisIpcContainer, ptyxis_ipc_container, G_TYPE_OBJECT)

static void
ptyxis_ipc_container_default_init (PtyxisIpcContainerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PtyxisIpcContainer::handle-spawn:
   * @object: A #PtyxisIpcContainer.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_cwd: Argument passed by remote caller.
   * @arg_argv: Argument passed by remote caller.
   * @arg_fds: Argument passed by remote caller.
   * @arg_env: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.Spawn">Spawn()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_container_complete_spawn() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-spawn",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcContainerIface, handle_spawn),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_container_method_marshal_spawn,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * PtyxisIpcContainer::handle-find-program-in-path:
   * @object: A #PtyxisIpcContainer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_program: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.FindProgramInPath">FindProgramInPath()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_container_complete_find_program_in_path() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-find-program-in-path",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcContainerIface, handle_find_program_in_path),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_container_method_marshal_find_program_in_path,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * PtyxisIpcContainer::handle-translate-uri:
   * @object: A #PtyxisIpcContainer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uri: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.TranslateURI">TranslateURI()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_container_complete_translate_uri() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-translate-uri",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcContainerIface, handle_translate_uri),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_container_method_marshal_translate_uri,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * PtyxisIpcContainer:provider:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Ptyxis-Container.Provider">"Provider"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("provider", "Provider", "Provider", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * PtyxisIpcContainer:id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Ptyxis-Container.Id">"Id"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id", "Id", "Id", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * PtyxisIpcContainer:icon-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Ptyxis-Container.IconName">"IconName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("icon-name", "IconName", "IconName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * PtyxisIpcContainer:display-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Ptyxis-Container.DisplayName">"DisplayName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("display-name", "DisplayName", "DisplayName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * ptyxis_ipc_container_get_provider: (skip)
 * @object: A #PtyxisIpcContainer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.Provider">"Provider"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ptyxis_ipc_container_dup_provider() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ptyxis_ipc_container_get_provider (PtyxisIpcContainer *object)
{
  g_return_val_if_fail (PTYXIS_IPC_IS_CONTAINER (object), NULL);

  return PTYXIS_IPC_CONTAINER_GET_IFACE (object)->get_provider (object);
}

/**
 * ptyxis_ipc_container_dup_provider: (skip)
 * @object: A #PtyxisIpcContainer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.Provider">"Provider"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ptyxis_ipc_container_dup_provider (PtyxisIpcContainer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "provider", &value, NULL);
  return value;
}

/**
 * ptyxis_ipc_container_set_provider: (skip)
 * @object: A #PtyxisIpcContainer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.Provider">"Provider"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ptyxis_ipc_container_set_provider (PtyxisIpcContainer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "provider", value, NULL);
}

/**
 * ptyxis_ipc_container_get_id: (skip)
 * @object: A #PtyxisIpcContainer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ptyxis_ipc_container_dup_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ptyxis_ipc_container_get_id (PtyxisIpcContainer *object)
{
  g_return_val_if_fail (PTYXIS_IPC_IS_CONTAINER (object), NULL);

  return PTYXIS_IPC_CONTAINER_GET_IFACE (object)->get_id (object);
}

/**
 * ptyxis_ipc_container_dup_id: (skip)
 * @object: A #PtyxisIpcContainer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ptyxis_ipc_container_dup_id (PtyxisIpcContainer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id", &value, NULL);
  return value;
}

/**
 * ptyxis_ipc_container_set_id: (skip)
 * @object: A #PtyxisIpcContainer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.Id">"Id"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ptyxis_ipc_container_set_id (PtyxisIpcContainer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id", value, NULL);
}

/**
 * ptyxis_ipc_container_get_icon_name: (skip)
 * @object: A #PtyxisIpcContainer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.IconName">"IconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ptyxis_ipc_container_dup_icon_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ptyxis_ipc_container_get_icon_name (PtyxisIpcContainer *object)
{
  g_return_val_if_fail (PTYXIS_IPC_IS_CONTAINER (object), NULL);

  return PTYXIS_IPC_CONTAINER_GET_IFACE (object)->get_icon_name (object);
}

/**
 * ptyxis_ipc_container_dup_icon_name: (skip)
 * @object: A #PtyxisIpcContainer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.IconName">"IconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ptyxis_ipc_container_dup_icon_name (PtyxisIpcContainer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "icon-name", &value, NULL);
  return value;
}

/**
 * ptyxis_ipc_container_set_icon_name: (skip)
 * @object: A #PtyxisIpcContainer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.IconName">"IconName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ptyxis_ipc_container_set_icon_name (PtyxisIpcContainer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "icon-name", value, NULL);
}

/**
 * ptyxis_ipc_container_get_display_name: (skip)
 * @object: A #PtyxisIpcContainer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.DisplayName">"DisplayName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ptyxis_ipc_container_dup_display_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ptyxis_ipc_container_get_display_name (PtyxisIpcContainer *object)
{
  g_return_val_if_fail (PTYXIS_IPC_IS_CONTAINER (object), NULL);

  return PTYXIS_IPC_CONTAINER_GET_IFACE (object)->get_display_name (object);
}

/**
 * ptyxis_ipc_container_dup_display_name: (skip)
 * @object: A #PtyxisIpcContainer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.DisplayName">"DisplayName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ptyxis_ipc_container_dup_display_name (PtyxisIpcContainer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "display-name", &value, NULL);
  return value;
}

/**
 * ptyxis_ipc_container_set_display_name: (skip)
 * @object: A #PtyxisIpcContainer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Ptyxis-Container.DisplayName">"DisplayName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ptyxis_ipc_container_set_display_name (PtyxisIpcContainer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "display-name", value, NULL);
}

/**
 * ptyxis_ipc_container_call_spawn:
 * @proxy: A #PtyxisIpcContainerProxy.
 * @arg_cwd: Argument to pass with the method invocation.
 * @arg_argv: Argument to pass with the method invocation.
 * @arg_fds: Argument to pass with the method invocation.
 * @arg_env: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.Spawn">Spawn()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_container_call_spawn_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_container_call_spawn_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_container_call_spawn (
    PtyxisIpcContainer *proxy,
    const gchar *arg_cwd,
    const gchar *const *arg_argv,
    GVariant *arg_fds,
    GVariant *arg_env,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Spawn",
    g_variant_new ("(^ay^aay@a{uh}@a{ss})",
                   arg_cwd,
                   arg_argv,
                   arg_fds,
                   arg_env),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_container_call_spawn_finish:
 * @proxy: A #PtyxisIpcContainerProxy.
 * @out_process: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_container_call_spawn().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_container_call_spawn().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_container_call_spawn_finish (
    PtyxisIpcContainer *proxy,
    gchar **out_process,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_process);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_container_call_spawn_sync:
 * @proxy: A #PtyxisIpcContainerProxy.
 * @arg_cwd: Argument to pass with the method invocation.
 * @arg_argv: Argument to pass with the method invocation.
 * @arg_fds: Argument to pass with the method invocation.
 * @arg_env: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_process: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.Spawn">Spawn()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_container_call_spawn() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_container_call_spawn_sync (
    PtyxisIpcContainer *proxy,
    const gchar *arg_cwd,
    const gchar *const *arg_argv,
    GVariant *arg_fds,
    GVariant *arg_env,
    GUnixFDList  *fd_list,
    gchar **out_process,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Spawn",
    g_variant_new ("(^ay^aay@a{uh}@a{ss})",
                   arg_cwd,
                   arg_argv,
                   arg_fds,
                   arg_env),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_process);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_container_call_find_program_in_path:
 * @proxy: A #PtyxisIpcContainerProxy.
 * @arg_program: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.FindProgramInPath">FindProgramInPath()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_container_call_find_program_in_path_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_container_call_find_program_in_path_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_container_call_find_program_in_path (
    PtyxisIpcContainer *proxy,
    const gchar *arg_program,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FindProgramInPath",
    g_variant_new ("(s)",
                   arg_program),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_container_call_find_program_in_path_finish:
 * @proxy: A #PtyxisIpcContainerProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_container_call_find_program_in_path().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_container_call_find_program_in_path().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_container_call_find_program_in_path_finish (
    PtyxisIpcContainer *proxy,
    gchar **out_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_container_call_find_program_in_path_sync:
 * @proxy: A #PtyxisIpcContainerProxy.
 * @arg_program: Argument to pass with the method invocation.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.FindProgramInPath">FindProgramInPath()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_container_call_find_program_in_path() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_container_call_find_program_in_path_sync (
    PtyxisIpcContainer *proxy,
    const gchar *arg_program,
    gchar **out_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FindProgramInPath",
    g_variant_new ("(s)",
                   arg_program),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_container_call_translate_uri:
 * @proxy: A #PtyxisIpcContainerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.TranslateURI">TranslateURI()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_container_call_translate_uri_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_container_call_translate_uri_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_container_call_translate_uri (
    PtyxisIpcContainer *proxy,
    const gchar *arg_uri,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TranslateURI",
    g_variant_new ("(s)",
                   arg_uri),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_container_call_translate_uri_finish:
 * @proxy: A #PtyxisIpcContainerProxy.
 * @out_translated: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_container_call_translate_uri().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_container_call_translate_uri().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_container_call_translate_uri_finish (
    PtyxisIpcContainer *proxy,
    gchar **out_translated,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_translated);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_container_call_translate_uri_sync:
 * @proxy: A #PtyxisIpcContainerProxy.
 * @arg_uri: Argument to pass with the method invocation.
 * @out_translated: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.TranslateURI">TranslateURI()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_container_call_translate_uri() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_container_call_translate_uri_sync (
    PtyxisIpcContainer *proxy,
    const gchar *arg_uri,
    gchar **out_translated,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TranslateURI",
    g_variant_new ("(s)",
                   arg_uri),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_translated);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_container_complete_spawn:
 * @object: A #PtyxisIpcContainer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @process: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.Spawn">Spawn()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_container_complete_spawn (
    PtyxisIpcContainer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *process)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(o)",
                   process),
    fd_list);
}

/**
 * ptyxis_ipc_container_complete_find_program_in_path:
 * @object: A #PtyxisIpcContainer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.FindProgramInPath">FindProgramInPath()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_container_complete_find_program_in_path (
    PtyxisIpcContainer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   path));
}

/**
 * ptyxis_ipc_container_complete_translate_uri:
 * @object: A #PtyxisIpcContainer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @translated: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Container.TranslateURI">TranslateURI()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_container_complete_translate_uri (
    PtyxisIpcContainer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *translated)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   translated));
}

/* ------------------------------------------------------------------------ */

/**
 * PtyxisIpcContainerProxy:
 *
 * The #PtyxisIpcContainerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PtyxisIpcContainerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PtyxisIpcContainerProxy.
 */

struct _PtyxisIpcContainerProxyPrivate
{
  GData *qdata;
};

static void ptyxis_ipc_container_proxy_iface_init (PtyxisIpcContainerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcContainerProxy, ptyxis_ipc_container_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PtyxisIpcContainerProxy)
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_CONTAINER, ptyxis_ipc_container_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcContainerProxy, ptyxis_ipc_container_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_CONTAINER, ptyxis_ipc_container_proxy_iface_init))

#endif
static void
ptyxis_ipc_container_proxy_finalize (GObject *object)
{
  PtyxisIpcContainerProxy *proxy = PTYXIS_IPC_CONTAINER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ptyxis_ipc_container_proxy_parent_class)->finalize (object);
}

static void
ptyxis_ipc_container_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _ptyxis_ipc_container_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
ptyxis_ipc_container_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Ptyxis.Container: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
ptyxis_ipc_container_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _ptyxis_ipc_container_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Ptyxis.Container", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) ptyxis_ipc_container_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
ptyxis_ipc_container_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ptyxis_ipc_container_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PTYXIS_IPC_TYPE_CONTAINER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PTYXIS_IPC_TYPE_CONTAINER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ptyxis_ipc_container_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PtyxisIpcContainerProxy *proxy = PTYXIS_IPC_CONTAINER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_container_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_container_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
ptyxis_ipc_container_proxy_get_provider (PtyxisIpcContainer *object)
{
  PtyxisIpcContainerProxy *proxy = PTYXIS_IPC_CONTAINER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Provider");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ptyxis_ipc_container_proxy_get_id (PtyxisIpcContainer *object)
{
  PtyxisIpcContainerProxy *proxy = PTYXIS_IPC_CONTAINER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Id");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ptyxis_ipc_container_proxy_get_icon_name (PtyxisIpcContainer *object)
{
  PtyxisIpcContainerProxy *proxy = PTYXIS_IPC_CONTAINER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IconName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ptyxis_ipc_container_proxy_get_display_name (PtyxisIpcContainer *object)
{
  PtyxisIpcContainerProxy *proxy = PTYXIS_IPC_CONTAINER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DisplayName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
ptyxis_ipc_container_proxy_init (PtyxisIpcContainerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ptyxis_ipc_container_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PTYXIS_IPC_TYPE_CONTAINER_PROXY, PtyxisIpcContainerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ptyxis_ipc_container_interface_info ());
}

static void
ptyxis_ipc_container_proxy_class_init (PtyxisIpcContainerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ptyxis_ipc_container_proxy_finalize;
  gobject_class->get_property = ptyxis_ipc_container_proxy_get_property;
  gobject_class->set_property = ptyxis_ipc_container_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ptyxis_ipc_container_proxy_g_signal;
  proxy_class->g_properties_changed = ptyxis_ipc_container_proxy_g_properties_changed;

  ptyxis_ipc_container_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PtyxisIpcContainerProxyPrivate));
#endif
}

static void
ptyxis_ipc_container_proxy_iface_init (PtyxisIpcContainerIface *iface)
{
  iface->get_provider = ptyxis_ipc_container_proxy_get_provider;
  iface->get_id = ptyxis_ipc_container_proxy_get_id;
  iface->get_icon_name = ptyxis_ipc_container_proxy_get_icon_name;
  iface->get_display_name = ptyxis_ipc_container_proxy_get_display_name;
}

/**
 * ptyxis_ipc_container_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Container.top_of_page">org.gnome.Ptyxis.Container</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_container_proxy_new_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_container_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ptyxis_ipc_container_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PTYXIS_IPC_TYPE_CONTAINER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Container", NULL);
}

/**
 * ptyxis_ipc_container_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_container_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ptyxis_ipc_container_proxy_new().
 *
 * Returns: (transfer full) (type PtyxisIpcContainerProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcContainer *
ptyxis_ipc_container_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PTYXIS_IPC_CONTAINER (ret);
  else
    return NULL;
}

/**
 * ptyxis_ipc_container_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Container.top_of_page">org.gnome.Ptyxis.Container</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_container_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PtyxisIpcContainerProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcContainer *
ptyxis_ipc_container_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PTYXIS_IPC_TYPE_CONTAINER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Container", NULL);
  if (ret != NULL)
    return PTYXIS_IPC_CONTAINER (ret);
  else
    return NULL;
}


/**
 * ptyxis_ipc_container_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ptyxis_ipc_container_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_container_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_container_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ptyxis_ipc_container_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PTYXIS_IPC_TYPE_CONTAINER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Container", NULL);
}

/**
 * ptyxis_ipc_container_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_container_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ptyxis_ipc_container_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PtyxisIpcContainerProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcContainer *
ptyxis_ipc_container_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PTYXIS_IPC_CONTAINER (ret);
  else
    return NULL;
}

/**
 * ptyxis_ipc_container_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ptyxis_ipc_container_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_container_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PtyxisIpcContainerProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcContainer *
ptyxis_ipc_container_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PTYXIS_IPC_TYPE_CONTAINER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Container", NULL);
  if (ret != NULL)
    return PTYXIS_IPC_CONTAINER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PtyxisIpcContainerSkeleton:
 *
 * The #PtyxisIpcContainerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PtyxisIpcContainerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PtyxisIpcContainerSkeleton.
 */

struct _PtyxisIpcContainerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ptyxis_ipc_container_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PTYXIS_IPC_TYPE_CONTAINER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PTYXIS_IPC_TYPE_CONTAINER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ptyxis_ipc_container_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_container_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ptyxis_ipc_container_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_container_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ptyxis_ipc_container_skeleton_vtable =
{
  _ptyxis_ipc_container_skeleton_handle_method_call,
  _ptyxis_ipc_container_skeleton_handle_get_property,
  _ptyxis_ipc_container_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ptyxis_ipc_container_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ptyxis_ipc_container_interface_info ();
}

static GDBusInterfaceVTable *
ptyxis_ipc_container_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ptyxis_ipc_container_skeleton_vtable;
}

static GVariant *
ptyxis_ipc_container_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_ptyxis_ipc_container_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ptyxis_ipc_container_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ptyxis_ipc_container_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ptyxis_ipc_container_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Ptyxis.Container", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _ptyxis_ipc_container_emit_changed (gpointer user_data);

static void
ptyxis_ipc_container_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _ptyxis_ipc_container_emit_changed (skeleton);
}

static void ptyxis_ipc_container_skeleton_iface_init (PtyxisIpcContainerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcContainerSkeleton, ptyxis_ipc_container_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PtyxisIpcContainerSkeleton)
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_CONTAINER, ptyxis_ipc_container_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcContainerSkeleton, ptyxis_ipc_container_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_CONTAINER, ptyxis_ipc_container_skeleton_iface_init))

#endif
static void
ptyxis_ipc_container_skeleton_finalize (GObject *object)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (object);
  guint n;
  for (n = 0; n < 4; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ptyxis_ipc_container_skeleton_parent_class)->finalize (object);
}

static void
ptyxis_ipc_container_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_ptyxis_ipc_container_emit_changed (gpointer user_data)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Ptyxis.Container",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_ptyxis_ipc_container_schedule_emit_changed (PtyxisIpcContainerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
ptyxis_ipc_container_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _ptyxis_ipc_container_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _ptyxis_ipc_container_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
ptyxis_ipc_container_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _ptyxis_ipc_container_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _ptyxis_ipc_container_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
ptyxis_ipc_container_skeleton_init (PtyxisIpcContainerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ptyxis_ipc_container_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PTYXIS_IPC_TYPE_CONTAINER_SKELETON, PtyxisIpcContainerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 4);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
}

static const gchar *
ptyxis_ipc_container_skeleton_get_provider (PtyxisIpcContainer *object)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ptyxis_ipc_container_skeleton_get_id (PtyxisIpcContainer *object)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ptyxis_ipc_container_skeleton_get_icon_name (PtyxisIpcContainer *object)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ptyxis_ipc_container_skeleton_get_display_name (PtyxisIpcContainer *object)
{
  PtyxisIpcContainerSkeleton *skeleton = PTYXIS_IPC_CONTAINER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
ptyxis_ipc_container_skeleton_class_init (PtyxisIpcContainerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ptyxis_ipc_container_skeleton_finalize;
  gobject_class->get_property = ptyxis_ipc_container_skeleton_get_property;
  gobject_class->set_property = ptyxis_ipc_container_skeleton_set_property;
  gobject_class->notify       = ptyxis_ipc_container_skeleton_notify;


  ptyxis_ipc_container_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ptyxis_ipc_container_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ptyxis_ipc_container_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ptyxis_ipc_container_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ptyxis_ipc_container_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PtyxisIpcContainerSkeletonPrivate));
#endif
}

static void
ptyxis_ipc_container_skeleton_iface_init (PtyxisIpcContainerIface *iface)
{
  iface->get_provider = ptyxis_ipc_container_skeleton_get_provider;
  iface->get_id = ptyxis_ipc_container_skeleton_get_id;
  iface->get_icon_name = ptyxis_ipc_container_skeleton_get_icon_name;
  iface->get_display_name = ptyxis_ipc_container_skeleton_get_display_name;
}

/**
 * ptyxis_ipc_container_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Container.top_of_page">org.gnome.Ptyxis.Container</link>.
 *
 * Returns: (transfer full) (type PtyxisIpcContainerSkeleton): The skeleton object.
 */
PtyxisIpcContainer *
ptyxis_ipc_container_skeleton_new (void)
{
  return PTYXIS_IPC_CONTAINER (g_object_new (PTYXIS_IPC_TYPE_CONTAINER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Ptyxis.Process
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PtyxisIpcProcess
 * @title: PtyxisIpcProcess
 * @short_description: Generated C code for the org.gnome.Ptyxis.Process D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Ptyxis-Process.top_of_page">org.gnome.Ptyxis.Process</link> D-Bus interface in C.
 */

enum
{
  PTYXIS_IPC__PROCESS_EXITED,
  PTYXIS_IPC__PROCESS_SIGNALED,
};

static unsigned PTYXIS_IPC__PROCESS_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.gnome.Ptyxis.Process ---- */

static const _ExtendedGDBusArgInfo _ptyxis_ipc_process_method_info_has_foreground_process_IN_ARG_pty_fd =
{
  {
    -1,
    (gchar *) "pty_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_process_method_info_has_foreground_process_IN_ARG_pointers[] =
{
  &_ptyxis_ipc_process_method_info_has_foreground_process_IN_ARG_pty_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_process_method_info_has_foreground_process_OUT_ARG_has_foreground_process =
{
  {
    -1,
    (gchar *) "has_foreground_process",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_process_method_info_has_foreground_process_OUT_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_process_method_info_has_foreground_process_OUT_ARG_cmdline =
{
  {
    -1,
    (gchar *) "cmdline",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_process_method_info_has_foreground_process_OUT_ARG_leader_kind =
{
  {
    -1,
    (gchar *) "leader_kind",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_process_method_info_has_foreground_process_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_process_method_info_has_foreground_process_OUT_ARG_has_foreground_process.parent_struct,
  &_ptyxis_ipc_process_method_info_has_foreground_process_OUT_ARG_pid.parent_struct,
  &_ptyxis_ipc_process_method_info_has_foreground_process_OUT_ARG_cmdline.parent_struct,
  &_ptyxis_ipc_process_method_info_has_foreground_process_OUT_ARG_leader_kind.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_process_method_info_has_foreground_process =
{
  {
    -1,
    (gchar *) "HasForegroundProcess",
    (GDBusArgInfo **) &_ptyxis_ipc_process_method_info_has_foreground_process_IN_ARG_pointers,
    (GDBusArgInfo **) &_ptyxis_ipc_process_method_info_has_foreground_process_OUT_ARG_pointers,
    NULL
  },
  "handle-has-foreground-process",
  TRUE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_process_method_info_send_signal_IN_ARG_signum =
{
  {
    -1,
    (gchar *) "signum",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_process_method_info_send_signal_IN_ARG_pointers[] =
{
  &_ptyxis_ipc_process_method_info_send_signal_IN_ARG_signum.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_process_method_info_send_signal =
{
  {
    -1,
    (gchar *) "SendSignal",
    (GDBusArgInfo **) &_ptyxis_ipc_process_method_info_send_signal_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-send-signal",
  FALSE
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_process_method_info_get_working_directory_IN_ARG_pty_fd =
{
  {
    -1,
    (gchar *) "pty_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_process_method_info_get_working_directory_IN_ARG_pointers[] =
{
  &_ptyxis_ipc_process_method_info_get_working_directory_IN_ARG_pty_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_process_method_info_get_working_directory_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_process_method_info_get_working_directory_OUT_ARG_pointers[] =
{
  &_ptyxis_ipc_process_method_info_get_working_directory_OUT_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ptyxis_ipc_process_method_info_get_working_directory =
{
  {
    -1,
    (gchar *) "GetWorkingDirectory",
    (GDBusArgInfo **) &_ptyxis_ipc_process_method_info_get_working_directory_IN_ARG_pointers,
    (GDBusArgInfo **) &_ptyxis_ipc_process_method_info_get_working_directory_OUT_ARG_pointers,
    NULL
  },
  "handle-get-working-directory",
  TRUE
};

static const GDBusMethodInfo * const _ptyxis_ipc_process_method_info_pointers[] =
{
  &_ptyxis_ipc_process_method_info_has_foreground_process.parent_struct,
  &_ptyxis_ipc_process_method_info_send_signal.parent_struct,
  &_ptyxis_ipc_process_method_info_get_working_directory.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_process_signal_info_exited_ARG_exit_status =
{
  {
    -1,
    (gchar *) "exit_status",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_process_signal_info_exited_ARG_pointers[] =
{
  &_ptyxis_ipc_process_signal_info_exited_ARG_exit_status.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ptyxis_ipc_process_signal_info_exited =
{
  {
    -1,
    (gchar *) "Exited",
    (GDBusArgInfo **) &_ptyxis_ipc_process_signal_info_exited_ARG_pointers,
    NULL
  },
  "exited"
};

static const _ExtendedGDBusArgInfo _ptyxis_ipc_process_signal_info_signaled_ARG_term_sig =
{
  {
    -1,
    (gchar *) "term_sig",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ptyxis_ipc_process_signal_info_signaled_ARG_pointers[] =
{
  &_ptyxis_ipc_process_signal_info_signaled_ARG_term_sig.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ptyxis_ipc_process_signal_info_signaled =
{
  {
    -1,
    (gchar *) "Signaled",
    (GDBusArgInfo **) &_ptyxis_ipc_process_signal_info_signaled_ARG_pointers,
    NULL
  },
  "signaled"
};

static const GDBusSignalInfo * const _ptyxis_ipc_process_signal_info_pointers[] =
{
  &_ptyxis_ipc_process_signal_info_exited.parent_struct,
  &_ptyxis_ipc_process_signal_info_signaled.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ptyxis_ipc_process_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Ptyxis.Process",
    (GDBusMethodInfo **) &_ptyxis_ipc_process_method_info_pointers,
    (GDBusSignalInfo **) &_ptyxis_ipc_process_signal_info_pointers,
    NULL,
    NULL
  },
  "process",
};


/**
 * ptyxis_ipc_process_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Ptyxis-Process.top_of_page">org.gnome.Ptyxis.Process</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ptyxis_ipc_process_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ptyxis_ipc_process_interface_info.parent_struct;
}

/**
 * ptyxis_ipc_process_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PtyxisIpcProcess interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ptyxis_ipc_process_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
ptyxis_ipc_process_signal_marshal_exited (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_process_signal_marshal_signaled (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_process_method_marshal_has_foreground_process (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_process_method_marshal_send_signal (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ptyxis_ipc_process_method_marshal_get_working_directory (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PtyxisIpcProcess:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Process.top_of_page">org.gnome.Ptyxis.Process</link>.
 */

/**
 * PtyxisIpcProcessIface:
 * @parent_iface: The parent interface.
 * @handle_get_working_directory: Handler for the #PtyxisIpcProcess::handle-get-working-directory signal.
 * @handle_has_foreground_process: Handler for the #PtyxisIpcProcess::handle-has-foreground-process signal.
 * @handle_send_signal: Handler for the #PtyxisIpcProcess::handle-send-signal signal.
 * @exited: Handler for the #PtyxisIpcProcess::exited signal.
 * @signaled: Handler for the #PtyxisIpcProcess::signaled signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Process.top_of_page">org.gnome.Ptyxis.Process</link>.
 */

typedef PtyxisIpcProcessIface PtyxisIpcProcessInterface;
G_DEFINE_INTERFACE (PtyxisIpcProcess, ptyxis_ipc_process, G_TYPE_OBJECT)

static void
ptyxis_ipc_process_default_init (PtyxisIpcProcessIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PtyxisIpcProcess::handle-has-foreground-process:
   * @object: A #PtyxisIpcProcess.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_pty_fd: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.HasForegroundProcess">HasForegroundProcess()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_process_complete_has_foreground_process() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-has-foreground-process",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcProcessIface, handle_has_foreground_process),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_process_method_marshal_has_foreground_process,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /**
   * PtyxisIpcProcess::handle-send-signal:
   * @object: A #PtyxisIpcProcess.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_signum: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.SendSignal">SendSignal()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_process_complete_send_signal() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-send-signal",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcProcessIface, handle_send_signal),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_process_method_marshal_send_signal,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * PtyxisIpcProcess::handle-get-working-directory:
   * @object: A #PtyxisIpcProcess.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_pty_fd: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.GetWorkingDirectory">GetWorkingDirectory()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ptyxis_ipc_process_complete_get_working_directory() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-working-directory",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PtyxisIpcProcessIface, handle_get_working_directory),
    g_signal_accumulator_true_handled,
    NULL,
      ptyxis_ipc_process_method_marshal_get_working_directory,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * PtyxisIpcProcess::exited:
   * @object: A #PtyxisIpcProcess.
   * @arg_exit_status: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Ptyxis-Process.Exited">"Exited"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PTYXIS_IPC__PROCESS_SIGNALS[PTYXIS_IPC__PROCESS_EXITED] =
    g_signal_new ("exited",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PtyxisIpcProcessIface, exited),
      NULL,
      NULL,
      ptyxis_ipc_process_signal_marshal_exited,
      G_TYPE_NONE,
      1, G_TYPE_INT);

  /**
   * PtyxisIpcProcess::signaled:
   * @object: A #PtyxisIpcProcess.
   * @arg_term_sig: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Ptyxis-Process.Signaled">"Signaled"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PTYXIS_IPC__PROCESS_SIGNALS[PTYXIS_IPC__PROCESS_SIGNALED] =
    g_signal_new ("signaled",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PtyxisIpcProcessIface, signaled),
      NULL,
      NULL,
      ptyxis_ipc_process_signal_marshal_signaled,
      G_TYPE_NONE,
      1, G_TYPE_INT);

}

/**
 * ptyxis_ipc_process_emit_exited:
 * @object: A #PtyxisIpcProcess.
 * @arg_exit_status: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Ptyxis-Process.Exited">"Exited"</link> D-Bus signal.
 */
void
ptyxis_ipc_process_emit_exited (
    PtyxisIpcProcess *object,
    gint arg_exit_status)
{
  g_signal_emit (object, PTYXIS_IPC__PROCESS_SIGNALS[PTYXIS_IPC__PROCESS_EXITED], 0, arg_exit_status);
}

/**
 * ptyxis_ipc_process_emit_signaled:
 * @object: A #PtyxisIpcProcess.
 * @arg_term_sig: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Ptyxis-Process.Signaled">"Signaled"</link> D-Bus signal.
 */
void
ptyxis_ipc_process_emit_signaled (
    PtyxisIpcProcess *object,
    gint arg_term_sig)
{
  g_signal_emit (object, PTYXIS_IPC__PROCESS_SIGNALS[PTYXIS_IPC__PROCESS_SIGNALED], 0, arg_term_sig);
}

/**
 * ptyxis_ipc_process_call_has_foreground_process:
 * @proxy: A #PtyxisIpcProcessProxy.
 * @arg_pty_fd: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.HasForegroundProcess">HasForegroundProcess()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_process_call_has_foreground_process_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_process_call_has_foreground_process_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_process_call_has_foreground_process (
    PtyxisIpcProcess *proxy,
    GVariant *arg_pty_fd,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "HasForegroundProcess",
    g_variant_new ("(@h)",
                   arg_pty_fd),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_process_call_has_foreground_process_finish:
 * @proxy: A #PtyxisIpcProcessProxy.
 * @out_has_foreground_process: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_pid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_cmdline: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_leader_kind: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_process_call_has_foreground_process().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_process_call_has_foreground_process().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_process_call_has_foreground_process_finish (
    PtyxisIpcProcess *proxy,
    gboolean *out_has_foreground_process,
    gint *out_pid,
    gchar **out_cmdline,
    gchar **out_leader_kind,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(biss)",
                 out_has_foreground_process,
                 out_pid,
                 out_cmdline,
                 out_leader_kind);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_process_call_has_foreground_process_sync:
 * @proxy: A #PtyxisIpcProcessProxy.
 * @arg_pty_fd: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_has_foreground_process: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_pid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_cmdline: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_leader_kind: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.HasForegroundProcess">HasForegroundProcess()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_process_call_has_foreground_process() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_process_call_has_foreground_process_sync (
    PtyxisIpcProcess *proxy,
    GVariant *arg_pty_fd,
    GUnixFDList  *fd_list,
    gboolean *out_has_foreground_process,
    gint *out_pid,
    gchar **out_cmdline,
    gchar **out_leader_kind,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "HasForegroundProcess",
    g_variant_new ("(@h)",
                   arg_pty_fd),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(biss)",
                 out_has_foreground_process,
                 out_pid,
                 out_cmdline,
                 out_leader_kind);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_process_call_send_signal:
 * @proxy: A #PtyxisIpcProcessProxy.
 * @arg_signum: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.SendSignal">SendSignal()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_process_call_send_signal_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_process_call_send_signal_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_process_call_send_signal (
    PtyxisIpcProcess *proxy,
    gint arg_signum,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SendSignal",
    g_variant_new ("(i)",
                   arg_signum),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_process_call_send_signal_finish:
 * @proxy: A #PtyxisIpcProcessProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_process_call_send_signal().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_process_call_send_signal().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_process_call_send_signal_finish (
    PtyxisIpcProcess *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_process_call_send_signal_sync:
 * @proxy: A #PtyxisIpcProcessProxy.
 * @arg_signum: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.SendSignal">SendSignal()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_process_call_send_signal() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_process_call_send_signal_sync (
    PtyxisIpcProcess *proxy,
    gint arg_signum,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SendSignal",
    g_variant_new ("(i)",
                   arg_signum),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_process_call_get_working_directory:
 * @proxy: A #PtyxisIpcProcessProxy.
 * @arg_pty_fd: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.GetWorkingDirectory">GetWorkingDirectory()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_process_call_get_working_directory_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_process_call_get_working_directory_sync() for the synchronous, blocking version of this method.
 */
void
ptyxis_ipc_process_call_get_working_directory (
    PtyxisIpcProcess *proxy,
    GVariant *arg_pty_fd,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "GetWorkingDirectory",
    g_variant_new ("(@h)",
                   arg_pty_fd),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * ptyxis_ipc_process_call_get_working_directory_finish:
 * @proxy: A #PtyxisIpcProcessProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_process_call_get_working_directory().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ptyxis_ipc_process_call_get_working_directory().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_process_call_get_working_directory_finish (
    PtyxisIpcProcess *proxy,
    gchar **out_path,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_process_call_get_working_directory_sync:
 * @proxy: A #PtyxisIpcProcessProxy.
 * @arg_pty_fd: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.GetWorkingDirectory">GetWorkingDirectory()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_process_call_get_working_directory() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ptyxis_ipc_process_call_get_working_directory_sync (
    PtyxisIpcProcess *proxy,
    GVariant *arg_pty_fd,
    GUnixFDList  *fd_list,
    gchar **out_path,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "GetWorkingDirectory",
    g_variant_new ("(@h)",
                   arg_pty_fd),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ptyxis_ipc_process_complete_has_foreground_process:
 * @object: A #PtyxisIpcProcess.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @has_foreground_process: Parameter to return.
 * @pid: Parameter to return.
 * @cmdline: Parameter to return.
 * @leader_kind: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.HasForegroundProcess">HasForegroundProcess()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_process_complete_has_foreground_process (
    PtyxisIpcProcess *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    gboolean has_foreground_process,
    gint pid,
    const gchar *cmdline,
    const gchar *leader_kind)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(biss)",
                   has_foreground_process,
                   pid,
                   cmdline,
                   leader_kind),
    fd_list);
}

/**
 * ptyxis_ipc_process_complete_send_signal:
 * @object: A #PtyxisIpcProcess.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.SendSignal">SendSignal()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_process_complete_send_signal (
    PtyxisIpcProcess *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ptyxis_ipc_process_complete_get_working_directory:
 * @object: A #PtyxisIpcProcess.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Ptyxis-Process.GetWorkingDirectory">GetWorkingDirectory()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ptyxis_ipc_process_complete_get_working_directory (
    PtyxisIpcProcess *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *path)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(^ay)",
                   path),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * PtyxisIpcProcessProxy:
 *
 * The #PtyxisIpcProcessProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PtyxisIpcProcessProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PtyxisIpcProcessProxy.
 */

struct _PtyxisIpcProcessProxyPrivate
{
  GData *qdata;
};

static void ptyxis_ipc_process_proxy_iface_init (PtyxisIpcProcessIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcProcessProxy, ptyxis_ipc_process_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PtyxisIpcProcessProxy)
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_PROCESS, ptyxis_ipc_process_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcProcessProxy, ptyxis_ipc_process_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_PROCESS, ptyxis_ipc_process_proxy_iface_init))

#endif
static void
ptyxis_ipc_process_proxy_finalize (GObject *object)
{
  PtyxisIpcProcessProxy *proxy = PTYXIS_IPC_PROCESS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ptyxis_ipc_process_proxy_parent_class)->finalize (object);
}

static void
ptyxis_ipc_process_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ptyxis_ipc_process_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ptyxis_ipc_process_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ptyxis_ipc_process_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PTYXIS_IPC_TYPE_PROCESS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PTYXIS_IPC_TYPE_PROCESS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ptyxis_ipc_process_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PtyxisIpcProcessProxy *proxy = PTYXIS_IPC_PROCESS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_process_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_process_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
ptyxis_ipc_process_proxy_init (PtyxisIpcProcessProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ptyxis_ipc_process_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PTYXIS_IPC_TYPE_PROCESS_PROXY, PtyxisIpcProcessProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ptyxis_ipc_process_interface_info ());
}

static void
ptyxis_ipc_process_proxy_class_init (PtyxisIpcProcessProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ptyxis_ipc_process_proxy_finalize;
  gobject_class->get_property = ptyxis_ipc_process_proxy_get_property;
  gobject_class->set_property = ptyxis_ipc_process_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ptyxis_ipc_process_proxy_g_signal;
  proxy_class->g_properties_changed = ptyxis_ipc_process_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PtyxisIpcProcessProxyPrivate));
#endif
}

static void
ptyxis_ipc_process_proxy_iface_init (PtyxisIpcProcessIface *iface G_GNUC_UNUSED)
{
}

/**
 * ptyxis_ipc_process_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Process.top_of_page">org.gnome.Ptyxis.Process</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_process_proxy_new_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_process_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ptyxis_ipc_process_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PTYXIS_IPC_TYPE_PROCESS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Process", NULL);
}

/**
 * ptyxis_ipc_process_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_process_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ptyxis_ipc_process_proxy_new().
 *
 * Returns: (transfer full) (type PtyxisIpcProcessProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcProcess *
ptyxis_ipc_process_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PTYXIS_IPC_PROCESS (ret);
  else
    return NULL;
}

/**
 * ptyxis_ipc_process_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Process.top_of_page">org.gnome.Ptyxis.Process</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_process_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PtyxisIpcProcessProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcProcess *
ptyxis_ipc_process_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PTYXIS_IPC_TYPE_PROCESS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Process", NULL);
  if (ret != NULL)
    return PTYXIS_IPC_PROCESS (ret);
  else
    return NULL;
}


/**
 * ptyxis_ipc_process_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ptyxis_ipc_process_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ptyxis_ipc_process_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ptyxis_ipc_process_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ptyxis_ipc_process_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PTYXIS_IPC_TYPE_PROCESS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Process", NULL);
}

/**
 * ptyxis_ipc_process_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ptyxis_ipc_process_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ptyxis_ipc_process_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PtyxisIpcProcessProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcProcess *
ptyxis_ipc_process_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PTYXIS_IPC_PROCESS (ret);
  else
    return NULL;
}

/**
 * ptyxis_ipc_process_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ptyxis_ipc_process_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ptyxis_ipc_process_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PtyxisIpcProcessProxy): The constructed proxy object or %NULL if @error is set.
 */
PtyxisIpcProcess *
ptyxis_ipc_process_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PTYXIS_IPC_TYPE_PROCESS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Ptyxis.Process", NULL);
  if (ret != NULL)
    return PTYXIS_IPC_PROCESS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PtyxisIpcProcessSkeleton:
 *
 * The #PtyxisIpcProcessSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PtyxisIpcProcessSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PtyxisIpcProcessSkeleton.
 */

struct _PtyxisIpcProcessSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ptyxis_ipc_process_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PtyxisIpcProcessSkeleton *skeleton = PTYXIS_IPC_PROCESS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PTYXIS_IPC_TYPE_PROCESS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PTYXIS_IPC_TYPE_PROCESS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ptyxis_ipc_process_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PtyxisIpcProcessSkeleton *skeleton = PTYXIS_IPC_PROCESS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_process_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ptyxis_ipc_process_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PtyxisIpcProcessSkeleton *skeleton = PTYXIS_IPC_PROCESS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ptyxis_ipc_process_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ptyxis_ipc_process_skeleton_vtable =
{
  _ptyxis_ipc_process_skeleton_handle_method_call,
  _ptyxis_ipc_process_skeleton_handle_get_property,
  _ptyxis_ipc_process_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ptyxis_ipc_process_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ptyxis_ipc_process_interface_info ();
}

static GDBusInterfaceVTable *
ptyxis_ipc_process_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ptyxis_ipc_process_skeleton_vtable;
}

static GVariant *
ptyxis_ipc_process_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PtyxisIpcProcessSkeleton *skeleton = PTYXIS_IPC_PROCESS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_ptyxis_ipc_process_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ptyxis_ipc_process_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ptyxis_ipc_process_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ptyxis_ipc_process_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Ptyxis.Process", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
ptyxis_ipc_process_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_ptyxis_ipc_process_on_signal_exited (
    PtyxisIpcProcess *object,
    gint arg_exit_status)
{
  PtyxisIpcProcessSkeleton *skeleton = PTYXIS_IPC_PROCESS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(i)",
                   arg_exit_status));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Ptyxis.Process", "Exited",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ptyxis_ipc_process_on_signal_signaled (
    PtyxisIpcProcess *object,
    gint arg_term_sig)
{
  PtyxisIpcProcessSkeleton *skeleton = PTYXIS_IPC_PROCESS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(i)",
                   arg_term_sig));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Ptyxis.Process", "Signaled",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void ptyxis_ipc_process_skeleton_iface_init (PtyxisIpcProcessIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcProcessSkeleton, ptyxis_ipc_process_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PtyxisIpcProcessSkeleton)
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_PROCESS, ptyxis_ipc_process_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PtyxisIpcProcessSkeleton, ptyxis_ipc_process_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PTYXIS_IPC_TYPE_PROCESS, ptyxis_ipc_process_skeleton_iface_init))

#endif
static void
ptyxis_ipc_process_skeleton_finalize (GObject *object)
{
  PtyxisIpcProcessSkeleton *skeleton = PTYXIS_IPC_PROCESS_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ptyxis_ipc_process_skeleton_parent_class)->finalize (object);
}

static void
ptyxis_ipc_process_skeleton_init (PtyxisIpcProcessSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ptyxis_ipc_process_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PTYXIS_IPC_TYPE_PROCESS_SKELETON, PtyxisIpcProcessSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
ptyxis_ipc_process_skeleton_class_init (PtyxisIpcProcessSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ptyxis_ipc_process_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ptyxis_ipc_process_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ptyxis_ipc_process_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ptyxis_ipc_process_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ptyxis_ipc_process_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PtyxisIpcProcessSkeletonPrivate));
#endif
}

static void
ptyxis_ipc_process_skeleton_iface_init (PtyxisIpcProcessIface *iface)
{
  iface->exited = _ptyxis_ipc_process_on_signal_exited;
  iface->signaled = _ptyxis_ipc_process_on_signal_signaled;
}

/**
 * ptyxis_ipc_process_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Ptyxis-Process.top_of_page">org.gnome.Ptyxis.Process</link>.
 *
 * Returns: (transfer full) (type PtyxisIpcProcessSkeleton): The skeleton object.
 */
PtyxisIpcProcess *
ptyxis_ipc_process_skeleton_new (void)
{
  return PTYXIS_IPC_PROCESS (g_object_new (PTYXIS_IPC_TYPE_PROCESS_SKELETON, NULL));
}

