// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package main

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type KProbePWRUConfig struct {
	_            structs.HostLayout
	Netns        uint32
	Mark         uint32
	Mask         uint32
	Ifindex      uint32
	_            [3]byte /* unsupported bitfield */
	FilterUnused uint8
	SkbBtfId     uint32
	ShinfoBtfId  uint32
}

type KProbePWRUEventT struct {
	_             structs.HostLayout
	Pid           uint32
	Type          uint32
	Addr          uint64
	CallerAddr    uint64
	SkbAddr       uint64
	Ts            uint64
	PrintSkbId    uint64
	PrintShinfoId uint64
	Meta          struct {
		_        structs.HostLayout
		Netns    uint32
		Mark     uint32
		Ifindex  uint32
		Len      uint32
		Mtu      uint32
		Protocol uint16
		Cb       [5]uint32
	}
	Tuple struct {
		_     structs.HostLayout
		Saddr struct {
			_      structs.HostLayout
			V4addr uint32
			_      [12]byte
		}
		Daddr struct {
			_      structs.HostLayout
			V4addr uint32
			_      [12]byte
		}
		Sport    uint16
		Dport    uint16
		L3Proto  uint16
		L4Proto  uint8
		TcpFlags uint8
	}
	TunnelTuple struct {
		_     structs.HostLayout
		Saddr struct {
			_      structs.HostLayout
			V4addr uint32
			_      [12]byte
		}
		Daddr struct {
			_      structs.HostLayout
			V4addr uint32
			_      [12]byte
		}
		Sport    uint16
		Dport    uint16
		L3Proto  uint16
		L4Proto  uint8
		TcpFlags uint8
	}
	PrintStackId int64
	ParamSecond  uint64
	ParamThird   uint64
	CpuId        uint32
	SkbMetadata  [4]uint64
}

type KProbePWRUPrintShinfoValue struct {
	_   structs.HostLayout
	Len uint32
	Str [4092]int8
}

type KProbePWRUPrintSkbValue struct {
	_   structs.HostLayout
	Len uint32
	Str [4092]int8
}

// LoadKProbePWRU returns the embedded CollectionSpec for KProbePWRU.
func LoadKProbePWRU() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_KProbePWRUBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load KProbePWRU: %w", err)
	}

	return spec, err
}

// LoadKProbePWRUObjects loads KProbePWRU and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*KProbePWRUObjects
//	*KProbePWRUPrograms
//	*KProbePWRUMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadKProbePWRUObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadKProbePWRU()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// KProbePWRUSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type KProbePWRUSpecs struct {
	KProbePWRUProgramSpecs
	KProbePWRUMapSpecs
	KProbePWRUVariableSpecs
}

// KProbePWRUProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type KProbePWRUProgramSpecs struct {
	FentryTc                         *ebpf.ProgramSpec `ebpf:"fentry_tc"`
	FentryXdp                        *ebpf.ProgramSpec `ebpf:"fentry_xdp"`
	FexitSkbClone                    *ebpf.ProgramSpec `ebpf:"fexit_skb_clone"`
	FexitSkbCopy                     *ebpf.ProgramSpec `ebpf:"fexit_skb_copy"`
	FexitXdp                         *ebpf.ProgramSpec `ebpf:"fexit_xdp"`
	KprobeMultiSkb1                  *ebpf.ProgramSpec `ebpf:"kprobe_multi_skb_1"`
	KprobeMultiSkb2                  *ebpf.ProgramSpec `ebpf:"kprobe_multi_skb_2"`
	KprobeMultiSkb3                  *ebpf.ProgramSpec `ebpf:"kprobe_multi_skb_3"`
	KprobeMultiSkb4                  *ebpf.ProgramSpec `ebpf:"kprobe_multi_skb_4"`
	KprobeMultiSkb5                  *ebpf.ProgramSpec `ebpf:"kprobe_multi_skb_5"`
	KprobeSkb1                       *ebpf.ProgramSpec `ebpf:"kprobe_skb_1"`
	KprobeSkb2                       *ebpf.ProgramSpec `ebpf:"kprobe_skb_2"`
	KprobeSkb3                       *ebpf.ProgramSpec `ebpf:"kprobe_skb_3"`
	KprobeSkb4                       *ebpf.ProgramSpec `ebpf:"kprobe_skb_4"`
	KprobeSkb5                       *ebpf.ProgramSpec `ebpf:"kprobe_skb_5"`
	KprobeSkbByStackid               *ebpf.ProgramSpec `ebpf:"kprobe_skb_by_stackid"`
	KprobeSkbLifetimeTermination     *ebpf.ProgramSpec `ebpf:"kprobe_skb_lifetime_termination"`
	KprobeVethConvertSkbToXdpBuff    *ebpf.ProgramSpec `ebpf:"kprobe_veth_convert_skb_to_xdp_buff"`
	KretprobeVethConvertSkbToXdpBuff *ebpf.ProgramSpec `ebpf:"kretprobe_veth_convert_skb_to_xdp_buff"`
}

// KProbePWRUMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type KProbePWRUMapSpecs struct {
	Events           *ebpf.MapSpec `ebpf:"events"`
	PercpuBigBuff    *ebpf.MapSpec `ebpf:"percpu_big_buff"`
	PrintShinfoIdMap *ebpf.MapSpec `ebpf:"print_shinfo_id_map"`
	PrintShinfoMap   *ebpf.MapSpec `ebpf:"print_shinfo_map"`
	PrintSkbIdMap    *ebpf.MapSpec `ebpf:"print_skb_id_map"`
	PrintSkbMap      *ebpf.MapSpec `ebpf:"print_skb_map"`
	PrintStackMap    *ebpf.MapSpec `ebpf:"print_stack_map"`
	SkbAddresses     *ebpf.MapSpec `ebpf:"skb_addresses"`
	SkbStackid       *ebpf.MapSpec `ebpf:"skb_stackid"`
	StackidSkb       *ebpf.MapSpec `ebpf:"stackid_skb"`
	VethSkbs         *ebpf.MapSpec `ebpf:"veth_skbs"`
	XdpDhsSkbHeads   *ebpf.MapSpec `ebpf:"xdp_dhs_skb_heads"`
}

// KProbePWRUVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type KProbePWRUVariableSpecs struct {
	CFG             *ebpf.VariableSpec `ebpf:"CFG"`
	ENDBR_INSN_SIZE *ebpf.VariableSpec `ebpf:"ENDBR_INSN_SIZE"`
}

// KProbePWRUObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadKProbePWRUObjects or ebpf.CollectionSpec.LoadAndAssign.
type KProbePWRUObjects struct {
	KProbePWRUPrograms
	KProbePWRUMaps
	KProbePWRUVariables
}

func (o *KProbePWRUObjects) Close() error {
	return _KProbePWRUClose(
		&o.KProbePWRUPrograms,
		&o.KProbePWRUMaps,
	)
}

// KProbePWRUMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadKProbePWRUObjects or ebpf.CollectionSpec.LoadAndAssign.
type KProbePWRUMaps struct {
	Events           *ebpf.Map `ebpf:"events"`
	PercpuBigBuff    *ebpf.Map `ebpf:"percpu_big_buff"`
	PrintShinfoIdMap *ebpf.Map `ebpf:"print_shinfo_id_map"`
	PrintShinfoMap   *ebpf.Map `ebpf:"print_shinfo_map"`
	PrintSkbIdMap    *ebpf.Map `ebpf:"print_skb_id_map"`
	PrintSkbMap      *ebpf.Map `ebpf:"print_skb_map"`
	PrintStackMap    *ebpf.Map `ebpf:"print_stack_map"`
	SkbAddresses     *ebpf.Map `ebpf:"skb_addresses"`
	SkbStackid       *ebpf.Map `ebpf:"skb_stackid"`
	StackidSkb       *ebpf.Map `ebpf:"stackid_skb"`
	VethSkbs         *ebpf.Map `ebpf:"veth_skbs"`
	XdpDhsSkbHeads   *ebpf.Map `ebpf:"xdp_dhs_skb_heads"`
}

func (m *KProbePWRUMaps) Close() error {
	return _KProbePWRUClose(
		m.Events,
		m.PercpuBigBuff,
		m.PrintShinfoIdMap,
		m.PrintShinfoMap,
		m.PrintSkbIdMap,
		m.PrintSkbMap,
		m.PrintStackMap,
		m.SkbAddresses,
		m.SkbStackid,
		m.StackidSkb,
		m.VethSkbs,
		m.XdpDhsSkbHeads,
	)
}

// KProbePWRUVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadKProbePWRUObjects or ebpf.CollectionSpec.LoadAndAssign.
type KProbePWRUVariables struct {
	CFG             *ebpf.Variable `ebpf:"CFG"`
	ENDBR_INSN_SIZE *ebpf.Variable `ebpf:"ENDBR_INSN_SIZE"`
}

// KProbePWRUPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadKProbePWRUObjects or ebpf.CollectionSpec.LoadAndAssign.
type KProbePWRUPrograms struct {
	FentryTc                         *ebpf.Program `ebpf:"fentry_tc"`
	FentryXdp                        *ebpf.Program `ebpf:"fentry_xdp"`
	FexitSkbClone                    *ebpf.Program `ebpf:"fexit_skb_clone"`
	FexitSkbCopy                     *ebpf.Program `ebpf:"fexit_skb_copy"`
	FexitXdp                         *ebpf.Program `ebpf:"fexit_xdp"`
	KprobeMultiSkb1                  *ebpf.Program `ebpf:"kprobe_multi_skb_1"`
	KprobeMultiSkb2                  *ebpf.Program `ebpf:"kprobe_multi_skb_2"`
	KprobeMultiSkb3                  *ebpf.Program `ebpf:"kprobe_multi_skb_3"`
	KprobeMultiSkb4                  *ebpf.Program `ebpf:"kprobe_multi_skb_4"`
	KprobeMultiSkb5                  *ebpf.Program `ebpf:"kprobe_multi_skb_5"`
	KprobeSkb1                       *ebpf.Program `ebpf:"kprobe_skb_1"`
	KprobeSkb2                       *ebpf.Program `ebpf:"kprobe_skb_2"`
	KprobeSkb3                       *ebpf.Program `ebpf:"kprobe_skb_3"`
	KprobeSkb4                       *ebpf.Program `ebpf:"kprobe_skb_4"`
	KprobeSkb5                       *ebpf.Program `ebpf:"kprobe_skb_5"`
	KprobeSkbByStackid               *ebpf.Program `ebpf:"kprobe_skb_by_stackid"`
	KprobeSkbLifetimeTermination     *ebpf.Program `ebpf:"kprobe_skb_lifetime_termination"`
	KprobeVethConvertSkbToXdpBuff    *ebpf.Program `ebpf:"kprobe_veth_convert_skb_to_xdp_buff"`
	KretprobeVethConvertSkbToXdpBuff *ebpf.Program `ebpf:"kretprobe_veth_convert_skb_to_xdp_buff"`
}

func (p *KProbePWRUPrograms) Close() error {
	return _KProbePWRUClose(
		p.FentryTc,
		p.FentryXdp,
		p.FexitSkbClone,
		p.FexitSkbCopy,
		p.FexitXdp,
		p.KprobeMultiSkb1,
		p.KprobeMultiSkb2,
		p.KprobeMultiSkb3,
		p.KprobeMultiSkb4,
		p.KprobeMultiSkb5,
		p.KprobeSkb1,
		p.KprobeSkb2,
		p.KprobeSkb3,
		p.KprobeSkb4,
		p.KprobeSkb5,
		p.KprobeSkbByStackid,
		p.KprobeSkbLifetimeTermination,
		p.KprobeVethConvertSkbToXdpBuff,
		p.KretprobeVethConvertSkbToXdpBuff,
	)
}

func _KProbePWRUClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed kprobepwru_x86_bpfel.o
var _KProbePWRUBytes []byte
