/*
 * This was generated from help.txt.  Do not modify directly.
 *
 * Copyright (c) 2002-2009 Johann George.  All rights reserved.
 * Copyright (c) 2006-2009 QLogic Corporation.  All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
char *Usage[] ={
    "main",
        "Synopsis\n"
        "    qperf\n"
        "    qperf SERVERNODE [OPTIONS] TESTS\n"
        "\n"
        "Description\n"
        "    qperf measures bandwidth and latency between two nodes.  It can w"
            "ork\n"
        "    over TCP/IP as well as the RDMA transports.  On one of the nodes,"
            " qperf\n"
        "    is typically run with no arguments designating it the server node"
            ".  One\n"
        "    may then run qperf on a client node to obtain measurements such a"
            "s\n"
        "    bandwidth, latency and cpu utilization.\n"
        "\n"
        "    In its most basic form, qperf is run on one node in server mode b"
            "y\n"
        "    invoking it with no arguments.  On the other node, it is run with"
            " two\n"
        "    arguments: the name of the server node followed by the name of th"
            "e\n"
        "    test.  A list of tests can be found in the section, TESTS.  A var"
            "iety\n"
        "    of options may also be specified.\n"
        "\n"
        "    One can get more detailed information on qperf by using the --hel"
            "p\n"
        "    option.  Below are examples of using the --help option:\n"
        "\n"
        "        qperf --help examples       Some examples of using qperf\n"
        "        qperf --help opts           Summary of options\n"
        "        qperf --help options        Description of options\n"
        "        qperf --help tests          Short summary and description of "
            "tests\n"
        "        qperf --help TESTNAME       More information on test TESTNAME"
            "\n",
    "author",
        "Written by Johann George.\n",
    "bugs",
        "None of the RDMA tests are available if qperf is compiled without the"
            " RDMA\n"
        "libraries.  None of the XRC tests are available if qperf is compiled"
            "\n"
        "without the XRC extensions.  The -f option is not yet implemented in "
            "many\n"
        "of the tests.\n",
    "categories",
        "To get help on a particular category, you may type:\n"
        "    qperf --help CATEGORY\n"
        "where CATEGORY might be one of the following:\n"
        "    categories          This current list being displayed\n"
        "    examples            Some examples\n"
        "    options             A long list of options\n"
        "    opts                A short description of the options\n"
        "    tests               A list of tests\n"
        "CATEGORY may also be one of the following tests\n"
        "    conf\n"
        "    quit\n"
        "    rc_bi_bw\n"
        "    rc_bw\n"
        "    rc_compare_swap_mr\n"
        "    rc_fetch_add_mr\n"
        "    rc_lat\n"
        "    rc_rdma_read_bw\n"
        "    rc_rdma_read_lat\n"
        "    rc_rdma_write_bw\n"
        "    rc_rdma_write_lat\n"
        "    rc_rdma_write_poll_lat\n"
        "    rds_bw\n"
        "    rds_lat\n"
        "    sctp_bw\n"
        "    sctp_lat\n"
        "    sdp_bw\n"
        "    sdp_lat\n"
        "    tcp_bw\n"
        "    tcp_lat\n"
        "    uc_bi_bw\n"
        "    uc_bw\n"
        "    uc_lat\n"
        "    uc_rdma_write_bw\n"
        "    uc_rdma_write_lat\n"
        "    uc_rdma_write_poll_lat\n"
        "    ud_bi_bw\n"
        "    ud_bw\n"
        "    ud_lat\n"
        "    udp_bw\n"
        "    udp_lat\n"
        "    ver_rc_compare_swap\n"
        "    ver_rc_fetch_add\n"
        "    xrc_bi_bw\n"
        "    xrc_bw\n"
        "    xrc_lat\n",
    "examples",
        "In these examples, we first run qperf on a node called myserver in se"
            "rver\n"
        "mode by invoking it with no arguments.  In all the subsequent example"
            "s, we\n"
        "run qperf on another node and connect to the server which we assume h"
            "as a\n"
        "hostname of myserver.\n"
        "    * To run a TCP bandwidth and latency test:\n"
        "        qperf myserver tcp_bw tcp_lat\n"
        "    * To run a SDP bandwidth test for 10 seconds:\n"
        "        qperf myserver -t 10 sdp_bw\n"
        "    * To run a UDP latency test and then cause the server to terminat"
            "e:\n"
        "        qperf myserver udp_lat quit\n"
        "    * To measure the RDMA UD latency and bandwidth:\n"
        "        qperf myserver ud_lat ud_bw\n"
        "    * To measure RDMA UC bi-directional bandwidth:\n"
        "        qperf myserver rc_bi_bw\n"
        "    * To get a range of TCP latencies with a message size from 1 to 6"
            "4K\n"
        "        qperf myserver -oo msg_size:1:64K:*2 -vu tcp_lat\n",
    "opts",
        "--access_recv OnOff (-ar)           Turn on/off accessing received da"
            "ta\n"
        "  -ar1                              Cause received data to be accesse"
            "d\n"
        "--alt_port Port (-ap)               Set alternate path port\n"
        "  --loc_alt_port Port (-lap)        Set local alternate path port\n"
        "  --rem_alt_port Port (-rap)        Set remote alternate path port\n"
        "--cpu_affinity PN (-ca)             Set processor affinity\n"
        "  --loc_cpu_affinity PN (-lca)      Set local processor affinity\n"
        "  --rem_cpu_affinity PN (-rca)      Set remote processor affinity\n"
        "--flip OnOff (-f)                   Flip on/off sender and receiver\n"
        "  -f1                               Flip (on) sender and receiver\n"
        "--help Topic (-h)                   Get more information on a topic\n"
        "--host Node (-H)                    Identify server node\n"
        "--id Device:Port (-i)               Set RDMA device and port\n"
        "  --loc_id Device:Port (-li)        Set local RDMA device and port\n"
        "  --rem_id Device:Port (-ri)        Set remote RDMA device and port\n"
        "--listen_port Port (-lp)            Set server listen port\n"
        "--loop Var:Init:Last:Incr (-oo)     Sequence through values\n"
        "--msg_size Size (-m)                Set message size\n"
        "--mtu_size Size (-mt)               Set MTU size (RDMA only)\n"
        "--no_msgs Count (-n)                Send Count messages\n"
        "--cq_poll OnOff                     Set polling mode on/off\n"
        "  --loc_cq_poll OnOff (-lcp)        Set local polling mode on/off\n"
        "  --rem_cq_poll OnOff (-rcp)        Set remote polling mode on/off\n"
        "  -cp1                              Turn polling mode on\n"
        "  -lcp1                             Turn local polling mode on\n"
        "  -rcp1                             Turn remote polling mode on\n"
        "--ip_port Port (-ip)                Set TCP port used for tests\n"
        "--precision Digits (-e)             Set precision reported\n"
        "--rd_atomic Max (-nr)               Set RDMA read/atomic count\n"
        "    --loc_rd_atomic Max (-lnr)      Set local RDMA read/atomic count"
            "\n"
        "    --rem_rd_atomic Max (-rnr)      Set remote RDMA read/atomic count"
            "\n"
        "--service_level SL (-sl)            Set service level\n"
        "  --service_level SL (-lsl)         Set local service level\n"
        "  --service_level SL (-rsl)         Set remote service level\n"
        "--sock_buf_size Size (-sb)          Set socket buffer size\n"
        "  --loc_sock_buf_size Size (-lsb)   Set local socket buffer size\n"
        "  --rem_sock_buf_size Size (-rsb)   Set remote socket buffer size\n"
        "--src_path_bits num (-sp)           Set source path bits\n"
        "  --loc_src_path_bits num (-lsp)    Set local source path bits\n"
        "  --rem_src_path_bits num (-rsp)    Set remote source path bits\n"
        "--static_rate (-sr)                 Set IB static rate\n"
        "  --loc_static_rate (-lsr)          Set local IB static rate\n"
        "  --rem_static_rate (-rsr)          Set remote IB static rate\n"
        "--time Time (-t)                    Set test duration\n"
        "--timeout Time (-to)                Set timeout\n"
        "  --loc_timeout Time (-lto)         Set local timeout\n"
        "  --rem_timeout Time (-rto)         Set remote timeout\n"
        "--unify_nodes (-un)                 Unify nodes\n"
        "--unify_units (-uu)                 Unify units\n"
        "--use_bits_per_sec (-ub)            Use bits/sec rather than bytes/se"
            "c\n"
        "--use_cm OnOff (-cm)                Use RDMA Connection Manager or no"
            "t\n"
        "  -cm1                              Use RDMA Connection Manager\n"
        "--verbose (-v)                      Verbose; turn on all of -v[cstu]"
            "\n"
        "  --verbose_conf (-vc)              Show configuration information\n"
        "  --verbose_stat (-vs)              Show statistical information\n"
        "  --verbose_time (-vt)              Show timing information\n"
        "  --verbose_used (-vu)              Show information on parameters\n"
        "  --verbose_more (-vv)              More verbose; turn on all of -v[C"
            "STU]\n"
        "  --verbose_more_conf (-vvc)        Show more configuration informati"
            "on\n"
        "  --verbose_more_stat (-vvs)        Show more statistical information"
            "\n"
        "  --verbose_more_time (-vvt)        Show more timing information\n"
        "  --verbose_more_used (-vvu)        Show more information on paramete"
            "rs\n"
        "--version (-V)                      Print out version\n"
        "--wait_server Time (-ws)            Set time to wait for server\n",
    "options",
        "--access_recv OnOff (-ar)\n"
        "      If OnOff is non-zero, data is accessed once received.  Otherwis"
            "e,\n"
        "      data is ignored.  By default, OnOff is 0.  This can help to mim"
            "ic\n"
        "      some applications.\n"
        "  -ar1\n"
        "      Cause received data to be accessed.\n"
        "--alt_port Port (-ap)\n"
        "      Set alternate path port. This enables automatic path failover."
            "\n"
        "  --loc_alt_port Port (-lap)\n"
        "      Set local alternate path port. This enables automatic path fail"
            "over.\n"
        "  --rem_alt_port Port (-rap)\n"
        "      Set remote alternate path port. This enables automatic path fai"
            "lover.\n"
        "--cpu_affinity PN (-ca)\n"
        "      Set cpu affinity to PN.  CPUs are numbered sequentially from 0."
            "  If\n"
        "      PN is \"any\", any cpu is allowed otherwise the cpu is limited "
            "to the\n"
        "      one specified.\n"
        "  --loc_cpu_affinity PN (-lca)\n"
        "      Set local processor affinity to PN.\n"
        "  --rem_cpu_affinity PN (-rca)\n"
        "      Set remote processor affinity to PN.\n"
        "--flip OnOff (-f)\n"
        "      If non-zero, cause sender and receiver to play opposite roles."
            "\n"
        "  -f1\n"
        "      Cause sender and receiver to play opposite roles.\n"
        "--help Topic (-h)\n"
        "      Print out information about Topic.  To see the list of topics, "
            "type\n"
        "          qperf --help\n"
        "--host Host (-H)\n"
        "      Run test between the current node and the qperf running on node"
            " Host.\n"
        "      This can also be specified as the first non-option argument.\n"
        "--id Device:Port (-i)\n"
        "      Use RDMA Device and Port.\n"
        "  --loc_id Device:Port (-li)\n"
        "      Use local RDMA Device and Port.\n"
        "  --rem_id Device:Port (-ri)\n"
        "      Use remote RDMA Device and Port.\n"
        "--listen_port Port (-lp)\n"
        "      Set the port we listen on to ListenPort.  This must be set to t"
            "he\n"
        "      same port on both the server and client machines.  The default "
            "value\n"
        "      is 19765.\n"
        "--loop Var:Init:Last:Incr (-oo)\n"
        "    Run a test multiple times sequencing through a series of values. "
            " Var\n"
        "    is the loop variable; Init is the initial value; Last is the valu"
            "e it\n"
        "    must not exceed and Incr is the increment.  It is useful to set t"
            "he\n"
        "    --verbose_used (-vu) option in conjunction with this option.\n"
        "--msg_size Size (-m)\n"
        "      Set the message size to Size.  The default value varies by test"
            ".  It\n"
        "      is assumed that the value is specified in bytes however, a trai"
            "ling\n"
        "      kib or K, mib or M, or gib or G indicates that the size is bein"
            "g\n"
        "      specified in kibibytes, mebibytes or gibibytes respectively whi"
            "le a\n"
        "      trailing kb or k, mb or m, or gb or g indicates kilobytes, mega"
            "bytes\n"
        "      or gigabytes respectively.\n"
        "--mtu_size Size (-mt)\n"
        "      Set the MTU size.  Only relevant to the RDMA UC/RC tests.  Unit"
            "s are\n"
        "      specified in the same manner as the --msg_size option.\n"
        "--no_msgs N (-n)\n"
        "    Set test duration by number of messages sent instead of time.\n"
        "--cq_poll OnOff (-cp)\n"
        "      Turn polling mode on or off.  This is only relevant to the RDMA"
            " tests\n"
        "      and determines whether they poll or wait on the completion queu"
            "es.\n"
        "      If OnOff is 0, they wait; otherwise they poll.\n"
        "  --loc_cq_poll OnOff (-lcp)\n"
        "      Locally turn polling mode on or off.\n"
        "  --rem_cq_poll OnOff (-rcp)\n"
        "      Remotely turn polling mode on or off.\n"
        "  -cp1\n"
        "      Turn polling mode on.\n"
        "  -lcp1\n"
        "      Turn local polling mode on.\n"
        "  -rcp1\n"
        "      Turn remote polling mode on.\n"
        "--ip_port Port (-ip)\n"
        "      Use Port to run the socket tests.  This is different from\n"
        "      --listen_port which is used for synchronization.  This is only"
            "\n"
        "      relevant for the socket tests and refers to the TCP/UDP/SDP/RDS"
            "/SCTP\n"
        "      port that the test is run on.\n"
        "--precision Digits (-e)\n"
        "      Set the number of significant digits that are used to report re"
            "sults.\n"
        "--rd_atomic Max (-nr)\n"
        "      Set the number of in-flight operations that can be handled for "
            "a RDMA\n"
        "      read or atomic operation to Max.  This is only relevant to the "
            "RDMA\n"
        "      Read and Atomic tests.\n"
        "  --loc_rd_atomic Max (-lnr)\n"
        "      Set local read/atomic count.\n"
        "  --rem_rd_atomic Max (-rnr)\n"
        "      Set remote read/atomic count.\n"
        "--service_level SL (-sl)\n"
        "      Set RDMA service level to SL.  This is only used by the RDMA te"
            "sts.\n"
        "      The service level must be between 0 and 15.  The default servic"
            "e\n"
        "      level is 0.\n"
        "  --loc_service_level SL (-lsl)\n"
        "      Set local service level.\n"
        "  --rem_service_level SL (-rsl)\n"
        "      Set remote service level.\n"
        "--sock_buf_size Size (-sb)\n"
        "      Set the socket buffer size.  This is only relevant to the socke"
            "t\n"
        "      tests.\n"
        "  --loc_sock_buf_size Size (-lsb)\n"
        "      Set local socket buffer size.\n"
        "  --rem_sock_buf_size Size (-rsb)\n"
        "      Set remote socket buffer size.\n"
        "--src_path_bits N (-sp)\n"
        "      Set source path bits. If the LMC is not zero, this will cause t"
            "he\n"
        "      connection to use a LID with the low order LMC bits set to N.\n"
        "  --loc_src_path_bits N (-lsp)\n"
        "      Set local source path bits.\n"
        "  --rem_src_path_bits N (-rsp)\n"
        "      Set remote source path bits.\n"
        "--static_rate Rate (-sr)\n"
        "      Force InfiniBand static rate.  Rate can be one of: 2.5, 5, 10, "
            "20,\n"
        "      30, 40, 60, 80, 120, 1xSDR (2.5 Gbps), 1xDDR (5 Gbps), 1xQDR (1"
            "0\n"
        "      Gbps), 4xSDR (2.5 Gbps), 4xDDR (5 Gbps), 4xQDR (10 Gbps), 8xSDR"
            " (2.5\n"
        "      Gbps), 8xDDR (5 Gbps), 8xQDR (10 Gbps).\n"
        "  --loc_static_rate (-lsr)\n"
        "      Force local InfiniBand static rate\n"
        "  --rem_static_rate (-rsr)\n"
        "      Force remote InfiniBand static rate\n"
        "--time Time (-t)\n"
        "      Set test duration to Time.  Specified in seconds however a trai"
            "ling\n"
        "      m, h or d indicates that the time is specified in minutes, hour"
            "s or\n"
        "      days respectively.\n"
        "--timeout Time (-to)\n"
        "      Set timeout to Time.  This is the timeout used for various thin"
            "gs\n"
        "      such as exchanging messages.  The default is 5 seconds.\n"
        "  --loc_timeout Time (-lto)\n"
        "      Set local timeout to Time.  This may be used on the server to s"
            "et\n"
        "      the timeout when initially exchanging data with each client.\n"
        "      However, as soon as we receive the client's parameters, the cli"
            "ent's\n"
        "      remote timeout will override this parameter.\n"
        "  --rem_timeout Time (-rto)\n"
        "      Set remote timeout to Time.\n"
        "--unify_nodes (-un)\n"
        "      Unify the nodes.  Describe them in terms of local and remote ra"
            "ther\n"
        "      than send and receive.\n"
        "--unify_units (-uu)\n"
        "      Unify the units that results are shown in.  Uses the lowest com"
            "mon\n"
        "      denominator.  Helpful for scripts.\n"
        "--use_bits_per_sec (-ub)\n"
        "      Use bits/sec rather than bytes/sec when displaying networking s"
            "peed.\n"
        "--use_cm OnOff (-cm)\n"
        "      Use the RDMA Connection Manager (CM) if OnOff is non-zero.  It "
            "is\n"
        "      necessary to use the CM for iWARP devices.  The default is to\n"
        "      establish the connection without using the CM.  This only works"
            " for\n"
        "      the tests that use the RC transport.\n"
        "  -cm1\n"
        "      Use RDMA Connection Manager.\n"
        "--verbose (-v)\n"
        "      Provide more detailed output.  Turns on -vc, -vs, -vt and -vu."
            "\n"
        "  --verbose_conf (-vc)\n"
        "      Provide information on configuration.\n"
        "  --verbose_stat (-vs)\n"
        "      Provide information on statistics.\n"
        "  --verbose_time (-vt)\n"
        "      Provide information on timing.\n"
        "  --verbose_used (-vu)\n"
        "      Provide information on parameters used.\n"
        "  --verbose_more (-vv)\n"
        "      Provide even more detailed output.  Turns on -vvc, -vvs, -vvt a"
            "nd\n"
        "      -vvu.\n"
        "  --verbose_more_conf (-vvc)\n"
        "      Provide more information on configuration.\n"
        "  --verbose_more_stat (-vvs)\n"
        "      Provide more information on statistics.\n"
        "  --verbose_more_time (-vvt)\n"
        "      Provide more information on timing.\n"
        "  --verbose_more_used (-vvu)\n"
        "      Provide more information on parameters used.\n"
        "--version (-V)\n"
        "      The current version of qperf is printed.\n"
        "--wait_server Time (-ws)\n"
        "      If the server is not ready, continue to try connecting for Time"
            "\n"
        "      seconds before giving up.  The default is 5 seconds.\n",
    "tests",
        "Miscellaneous\n"
        "    conf                    Show configuration\n"
        "    quit                    Cause the server to quit\n"
        "Socket Based\n"
        "    rds_bw                  RDS streaming one way bandwidth\n"
        "    rds_lat                 RDS one way latency\n"
        "    sctp_bw                 SCTP streaming one way bandwidth\n"
        "    sctp_lat                SCTP one way latency\n"
        "    sdp_bw                  SDP streaming one way bandwidth\n"
        "    sdp_lat                 SDP one way latency\n"
        "    tcp_bw                  TCP streaming one way bandwidth\n"
        "    tcp_lat                 TCP one way latency\n"
        "    udp_bw                  UDP streaming one way bandwidth\n"
        "    udp_lat                 UDP one way latency\n"
        "RDMA Send/Receive\n"
        "    rc_bi_bw                RC streaming two way bandwidth\n"
        "    rc_bw                   RC streaming one way bandwidth\n"
        "    rc_lat                  RC one way latency\n"
        "    uc_bi_bw                UC streaming two way bandwidth\n"
        "    uc_bw                   UC streaming one way bandwidth\n"
        "    uc_lat                  UC one way latency\n"
        "    ud_bi_bw                UD streaming two way bandwidth\n"
        "    ud_bw                   UD streaming one way bandwidth\n"
        "    ud_lat                  UD one way latency\n"
        "    xrc_bi_bw               XRC streaming two way bandwidth\n"
        "    xrc_bw                  XRC streaming one way bandwidth\n"
        "    xrc_lat                 XRC one way latency\n"
        "RDMA\n"
        "    rc_rdma_read_bw         RC RDMA read streaming one way bandwidth"
            "\n"
        "    rc_rdma_read_lat        RC RDMA read one way latency\n"
        "    rc_rdma_write_bw        RC RDMA write streaming one way bandwidth"
            "\n"
        "    rc_rdma_write_lat       RC RDMA write one way latency\n"
        "    rc_rdma_write_poll_lat  RC RDMA write one way polling latency\n"
        "    uc_rdma_write_bw        UC RDMA write streaming one way bandwidth"
            "\n"
        "    uc_rdma_write_lat       UC RDMA write one way latency\n"
        "    uc_rdma_write_poll_lat  UC RDMA write one way polling latency\n"
        "InfiniBand Atomics\n"
        "    rc_compare_swap_mr      RC compare and swap messaging rate\n"
        "    rc_fetch_add_mr         RC fetch and add messaging rate\n"
        "Verification\n"
        "    ver_rc_compare_swap     Verify RC compare and swap\n"
        "    ver_rc_fetch_add        Verify RC fetch and add\n",
    "conf",
        "Purpose\n"
        "    Show configuration\n"
        "Common Options\n"
        "    None\n"
        "Description\n"
        "    Shows the node name, CPUs and OS of both nodes being used.\n",
    "quit",
        "Purpose\n"
        "    Quit\n"
        "Common Options\n"
        "    None\n"
        "Description\n"
        "    Causes the server to quit.\n",
    "rds_bw",
        "Purpose\n"
        "    RDS streaming one way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --cpu_affinity PN (-ca)     Set processor affinity\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --sock_buf_size Size (-sb)  Set socket buffer size\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --listen_port, --ip_port, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client repeatedly sends messages to the server while the serv"
            "er\n"
        "    notes how many were received.\n",
    "rds_lat",
        "Purpose\n"
        "    RDS one way latency\n"
        "Common Options\n"
        "    --cpu_affinity PN (-ca)     Set processor affinity\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --sock_buf_size Size (-sb)  Set socket buffer size\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --listen_port, --ip_port, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    repeatedly using RDS sockets.\n",
    "sctp_bw",
        "Purpose\n"
        "    SCTP streaming one way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --cpu_affinity PN (-ca)     Set processor affinity\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --sock_buf_size Size (-sb)  Set socket buffer size\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --listen_port, --ip_port, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client repeatedly sends messages to the server while the serv"
            "er\n"
        "    notes how many were received.\n",
    "sctp_lat",
        "Purpose\n"
        "    SCTP one way latency\n"
        "Common Options\n"
        "    --cpu_affinity PN (-ca)     Set processor affinity\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --sock_buf_size Size (-sb)  Set socket buffer size\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --listen_port, --ip_port, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    repeatedly using STCP sockets.\n",
    "sdp_bw",
        "Purpose\n"
        "    SDP streaming one way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --cpu_affinity PN (-ca)     Set processor affinity\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --sock_buf_size Size (-sb)  Set socket buffer size\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --listen_port, --ip_port, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client repeatedly sends messages to the server while the serv"
            "er\n"
        "    notes how many were received.\n",
    "sdp_lat",
        "Purpose\n"
        "    SDP one way latency\n"
        "Common Options\n"
        "    --cpu_affinity PN (-ca)     Set processor affinity\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --sock_buf_size Size (-sb)  Set socket buffer size\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --listen_port, --ip_port, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    repeatedly using SDP sockets.\n",
    "tcp_bw",
        "Purpose\n"
        "    TCP streaming one way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --cpu_affinity PN (-ca)     Set processor affinity\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --sock_buf_size Size (-sb)  Set socket buffer size\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --listen_port, --ip_port, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client repeatedly sends messages to the server while the serv"
            "er\n"
        "    notes how many were received.\n",
    "tcp_lat",
        "Purpose\n"
        "    TCP one way latency\n"
        "Common Options\n"
        "    --cpu_affinity PN (-ca)     Set processor affinity\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --sock_buf_size Size (-sb)  Set socket buffer size\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --listen_port, --ip_port, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    repeatedly using TCP sockets.\n",
    "udp_bw",
        "Purpose\n"
        "    UDP streaming one way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --cpu_affinity PN (-ca)     Set processor affinity\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --sock_buf_size Size (-sb)  Set socket buffer size\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --listen_port, --ip_port, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client repeatedly sends messages to the server while the serv"
            "er\n"
        "    notes how many were received.\n",
    "udp_lat",
        "Purpose\n"
        "    UDP one way latency\n"
        "Common Options\n"
        "    --cpu_affinity PN (-ca)     Set processor affinity\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --sock_buf_size Size (-sb)  Set socket buffer size\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --listen_port, --ip_port, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    repeatedly using UDP sockets.\n",
    "ud_bw",
        "Purpose\n"
        "    UD streaming one way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --id Device:Port (-i)       Set RDMA device and port\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --cq_poll OnOff             Set polling mode on/off\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client sends messages to the server who notes how many it rec"
            "eived.\n"
        "    The UD Send/Receive mechanism is used.\n",
    "ud_bi_bw",
        "Purpose\n"
        "    UD streaming two way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --id Device:Port (-i)       Set RDMA device and port\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --cq_poll OnOff             Set polling mode on/off\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    Both the client and server exchange messages with each other usin"
            "g the\n"
        "    UD Send/Receive mechanism and note how many were received.\n",
    "ud_lat",
        "Purpose\n"
        "    UD one way latency\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    repeatedly using UD Send/Receive.\n",
    "rc_bw",
        "Purpose\n"
        "    RC streaming one way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --id Device:Port (-i)       Set RDMA device and port\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --cq_poll OnOff             Set polling mode on/off\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client sends messages to the server who notes how many it rec"
            "eived.\n"
        "    The RC Send/Receive mechanism is used.\n",
    "rc_bi_bw",
        "Purpose\n"
        "    RC streaming two way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --id Device:Port (-i)       Set RDMA device and port\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --cq_poll OnOff             Set polling mode on/off\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    Both the client and server exchange messages with each other usin"
            "g the\n"
        "    RC Send/Receive mechanism and note how many were received.\n",
    "rc_lat",
        "Purpose\n"
        "    RC one way latency\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    repeatedly using RC Send/Receive.\n",
    "uc_bw",
        "Purpose\n"
        "    UC streaming one way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --id Device:Port (-i)       Set RDMA device and port\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --cq_poll OnOff             Set polling mode on/off\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client sends messages to the server who notes how many it rec"
            "eived.\n"
        "    The UC Send/Receive mechanism is used.\n",
    "uc_bi_bw",
        "Purpose\n"
        "    UC streaming two way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --id Device:Port (-i)       Set RDMA device and port\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --cq_poll OnOff             Set polling mode on/off\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    Both the client and server exchange messages with each other usin"
            "g the\n"
        "    UC Send/Receive mechanism and note how many were received.\n",
    "uc_lat",
        "Purpose\n"
        "    UC one way latency\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    repeatedly using UC Send/Receive.\n",
    "rc_rdma_read_bw",
        "Purpose\n"
        "    RC RDMA read streaming one way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --id Device:Port (-i)       Set RDMA device and port\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --cq_poll OnOff             Set polling mode on/off\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --rd_atomic, --static_"
            "rate,\n"
        "    --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client repeatedly performs RC RDMA Read operations and notes "
            "how\n"
        "    many of them complete.\n",
    "rc_rdma_read_lat",
        "Purpose\n"
        "    RC RDMA read one way latency\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    The client repeatedly performs RC RDMA Read operations waiting fo"
            "r\n"
        "    completion before starting the next one.\n",
    "rc_rdma_write_bw",
        "Purpose\n"
        "    RC RDMA write streaming one way bandwidth\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client repeatedly performs RC RDMA Write operations and notes"
            " how\n"
        "    many of them complete.\n",
    "rc_rdma_write_lat",
        "Purpose\n"
        "    RC RDMA write one way latency\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    using RC RDMA write operations.\n",
    "rc_rdma_write_poll_lat",
        "Purpose\n"
        "    RC RDMA write one way polling latency\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test using RC RDMA Write operations.  First t"
            "he\n"
        "    client performs an RDMA Write while the server stays in a tight l"
            "oop\n"
        "    waiting for the memory buffer to change.  The first and last byte"
            "s of\n"
        "    the memory buffer are tested to ensure that the entire message wa"
            "s\n"
        "    received.  This is then repeated with both sides playing opposite"
            "\n"
        "    roles.  Since this does not use completion queues, the --cq_poll "
            "flag\n"
        "    has no effect.\n",
    "uc_rdma_write_bw",
        "Purpose\n"
        "    UC RDMA write streaming one way bandwidth\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client repeatedly performs UC RDMA Write operations and notes"
            " how\n"
        "    many of them complete.\n",
    "uc_rdma_write_lat",
        "Purpose\n"
        "    UC RDMA write one way latency\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    using UC RDMA write operations.\n",
    "uc_rdma_write_poll_lat",
        "Purpose\n"
        "    UC RDMA write one way polling latency\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test using UC RDMA Write operations.  First t"
            "he\n"
        "    client performs an RDMA Write while the server stays in a tight l"
            "oop\n"
        "    waiting for the memory buffer to change.  The first and last byte"
            "s of\n"
        "    the memory buffer are tested to ensure that the entire message wa"
            "s\n"
        "    received.  This is then repeated with both sides playing opposite"
            "\n"
        "    roles.  Since this does not use completion queues, the --cq_poll "
            "flag\n"
        "    has no effect.\n",
    "rc_compare_swap_mr",
        "Purpose\n"
        "    RC compare and swap messaging rate\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --rd_atomic, --static_"
            "rate,\n"
        "    --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    The client repeatedly performs the RC Atomic Compare and Swap ope"
            "ration\n"
        "    and determines how many of them complete.\n",
    "rc_fetch_add_mr",
        "Purpose\n"
        "    RC fetch and add messaging rate\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --rd_atomic, --static_"
            "rate,\n"
        "    --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    The client repeatedly performs the RC Atomic Fetch and Add operat"
            "ion\n"
        "    and determines how many of them complete.\n",
    "ver_rc_compare_swap",
        "Purpose\n"
        "    Verify RC compare and swap\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --msg_size, --mtu_size, --rd_atomi"
            "c,\n"
        "    --static_rate, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    Test the RC Compare and Swap Atomic operation.  The server's memo"
            "ry\n"
        "    location starts with zero and the client successively makes excha"
            "nges\n"
        "    with a variety of different values.  The results are checked for"
            "\n"
        "    correctness.\n",
    "ver_rc_fetch_add",
        "Purpose\n"
        "    Verify RC fetch and add\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --msg_size, --mtu_size, --rd_atomi"
            "c,\n"
        "    --static_rate, --timeout\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    Tests the RC Fetch and Add Atomic operation.  The server's memory"
            "\n"
        "    location starts with zero and the client successively adds one.  "
            "The\n"
        "    results are checked for correctness.\n",
    "xrc_bw",
        "Purpose\n"
        "    XRC streaming one way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --id Device:Port (-i)       Set RDMA device and port\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --cq_poll OnOff             Set polling mode on/off\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    The client sends messages to the server who notes how many it rec"
            "eived.\n"
        "    The XRC Send/Receive mechanism is used.\n",
    "xrc_bi_bw",
        "Purpose\n"
        "    XRC streaming two way bandwidth\n"
        "Common Options\n"
        "    --access_recv OnOff (-ar)   Access received data\n"
        "    --id Device:Port (-i)       Set RDMA device and port\n"
        "    --msg_size Size (-m)        Set message size\n"
        "    --cq_poll OnOff             Set polling mode on/off\n"
        "    --time (-t)                 Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --use_bits_per_sec,\n"
        "    --verbose\n"
        "Description\n"
        "    Both the client and server exchange messages with each other usin"
            "g the\n"
        "    XRC Send/Receive mechanism and note how many were received.\n",
    "xrc_lat",
        "Purpose\n"
        "    XRC one way latency\n"
        "Common Options\n"
        "    --id Device:Port (-i)   Set RDMA device and port\n"
        "    --msg_size Size (-m)    Set message size\n"
        "    --cq_poll OnOff         Set polling mode on/off\n"
        "    --time (-t)             Set test duration\n"
        "Other Options\n"
        "    --cpu_affinity, --listen_port, --mtu_size, --static_rate, --timeo"
            "ut\n"
        "Display Options\n"
        "    --precision, --unify_nodes, --unify_units, --verbose\n"
        "Description\n"
        "    A ping pong latency test where the server and client exchange mes"
            "sages\n"
        "    repeatedly using XRC Send/Receive.\n",
    0,
};
