// A Bison parser, made by GNU Bison 3.8.2.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.





#include "parser.hpp"


// Unqualified %code blocks.
#line 33 "asm/parser.y"

	#include <algorithm>
	#include <inttypes.h>
	#include <optional>
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <string_view>

	#include "extern/utf8decoder.hpp"
	#include "helpers.hpp"
	#include "util.hpp" // toLower, toUpper

	#include "asm/charmap.hpp"
	#include "asm/fixpoint.hpp"
	#include "asm/fstack.hpp"
	#include "asm/main.hpp"
	#include "asm/opt.hpp"
	#include "asm/output.hpp"
	#include "asm/section.hpp"
	#include "asm/symbol.hpp"
	#include "asm/warning.hpp"

	using namespace std::literals;

	yy::parser::symbol_type yylex(); // Provided by lexer.cpp

	template<typename NumCallbackFnT, typename StrCallbackFnT>
	static auto handleSymbolByType(
	    std::string const &symName, NumCallbackFnT numCallback, StrCallbackFnT strCallback
	) {
		if (Symbol *sym = sym_FindScopedSymbol(symName); sym && sym->type == SYM_EQUS) {
			return strCallback(*sym->getEqus());
		} else {
			Expression expr;
			expr.makeSymbol(symName);
			return numCallback(expr);
		}
	}

	// The CPU encodes instructions in a logical way, so most instructions actually follow patterns.
	// These enums thus help with bit twiddling to compute opcodes.
	enum { REG_B, REG_C, REG_D, REG_E, REG_H, REG_L, REG_HL_IND, REG_A };

	enum { REG_BC_IND, REG_DE_IND, REG_HL_INDINC, REG_HL_INDDEC };

	// REG_AF == REG_SP since LD/INC/ADD/DEC allow SP, while PUSH/POP allow AF
	enum { REG_BC, REG_DE, REG_HL, REG_SP, REG_AF = REG_SP };
	// Names are not needed for AF or SP
	static char const *reg_tt_names[] = { "BC", "DE", "HL" };
	static char const *reg_tt_high_names[] = { "B", "D", "H" };
	static char const *reg_tt_low_names[] = { "C", "E", "L" };

	// CC_NZ == CC_Z ^ 1, and CC_NC == CC_C ^ 1, so `!` can toggle them
	enum { CC_NZ, CC_Z, CC_NC, CC_C };

#line 103 "/build/rgbds/src/rgbds/src/asm/parser.cpp"


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif


// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
# if defined __GNUC__ && !defined __EXCEPTIONS
#  define YY_EXCEPTIONS 0
# else
#  define YY_EXCEPTIONS 1
# endif
#endif



// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << '\n';                       \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yy_stack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YY_USE (Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void> (0)
# define YY_STACK_PRINT()                static_cast<void> (0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

namespace yy {
#line 176 "/build/rgbds/src/rgbds/src/asm/parser.cpp"

  /// Build a parser object.
  parser::parser ()
#if YYDEBUG
    : yydebug_ (false),
      yycdebug_ (&std::cerr),
#else
    :
#endif
      yy_lac_established_ (false)
  {}

  parser::~parser ()
  {}

  parser::syntax_error::~syntax_error () YY_NOEXCEPT YY_NOTHROW
  {}

  /*---------.
  | symbol.  |
  `---------*/



  // by_state.
  parser::by_state::by_state () YY_NOEXCEPT
    : state (empty_state)
  {}

  parser::by_state::by_state (const by_state& that) YY_NOEXCEPT
    : state (that.state)
  {}

  void
  parser::by_state::clear () YY_NOEXCEPT
  {
    state = empty_state;
  }

  void
  parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  parser::by_state::by_state (state_type s) YY_NOEXCEPT
    : state (s)
  {}

  parser::symbol_kind_type
  parser::by_state::kind () const YY_NOEXCEPT
  {
    if (state == empty_state)
      return symbol_kind::S_YYEMPTY;
    else
      return YY_CAST (symbol_kind_type, yystos_[+state]);
  }

  parser::stack_symbol_type::stack_symbol_type ()
  {}

  parser::stack_symbol_type::stack_symbol_type (YY_RVREF (stack_symbol_type) that)
    : super_type (YY_MOVE (that.state))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.YY_MOVE_OR_COPY< AlignmentSpec > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.YY_MOVE_OR_COPY< AssertionType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.YY_MOVE_OR_COPY< Capture > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.YY_MOVE_OR_COPY< Expression > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_for_args: // for_args
        value.YY_MOVE_OR_COPY< ForArgs > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.YY_MOVE_OR_COPY< RPNCommand > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.YY_MOVE_OR_COPY< SectionModifier > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.YY_MOVE_OR_COPY< SectionSpec > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.YY_MOVE_OR_COPY< SectionType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.YY_MOVE_OR_COPY< StrFmtArgList > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_maybe_quiet: // maybe_quiet
        value.YY_MOVE_OR_COPY< bool > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.YY_MOVE_OR_COPY< int32_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.YY_MOVE_OR_COPY< std::shared_ptr<MacroArgs> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_QMACRO: // "quiet macro"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.YY_MOVE_OR_COPY< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.YY_MOVE_OR_COPY< std::vector<Expression> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.YY_MOVE_OR_COPY< std::vector<int32_t> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.YY_MOVE_OR_COPY< std::vector<std::string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

#if 201103L <= YY_CPLUSPLUS
    // that is emptied.
    that.state = empty_state;
#endif
  }

  parser::stack_symbol_type::stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) that)
    : super_type (s)
  {
    switch (that.kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.move< AlignmentSpec > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.move< AssertionType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.move< Capture > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.move< Expression > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_for_args: // for_args
        value.move< ForArgs > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.move< RPNCommand > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.move< SectionModifier > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.move< SectionSpec > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.move< SectionType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.move< StrFmtArgList > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_maybe_quiet: // maybe_quiet
        value.move< bool > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.move< int32_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.move< std::shared_ptr<MacroArgs> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_QMACRO: // "quiet macro"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.move< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.move< std::vector<Expression> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.move< std::vector<int32_t> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.move< std::vector<std::string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

    // that is emptied.
    that.kind_ = symbol_kind::S_YYEMPTY;
  }

#if YY_CPLUSPLUS < 201103L
  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.copy< AlignmentSpec > (that.value);
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.copy< AssertionType > (that.value);
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.copy< Capture > (that.value);
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.copy< Expression > (that.value);
        break;

      case symbol_kind::S_for_args: // for_args
        value.copy< ForArgs > (that.value);
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.copy< RPNCommand > (that.value);
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.copy< SectionModifier > (that.value);
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.copy< SectionSpec > (that.value);
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.copy< SectionType > (that.value);
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.copy< StrFmtArgList > (that.value);
        break;

      case symbol_kind::S_maybe_quiet: // maybe_quiet
        value.copy< bool > (that.value);
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.copy< int32_t > (that.value);
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.copy< std::shared_ptr<MacroArgs> > (that.value);
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_QMACRO: // "quiet macro"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.copy< std::string > (that.value);
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.copy< std::vector<Expression> > (that.value);
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.copy< std::vector<int32_t> > (that.value);
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.copy< std::vector<std::string> > (that.value);
        break;

      default:
        break;
    }

    return *this;
  }

  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.move< AlignmentSpec > (that.value);
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.move< AssertionType > (that.value);
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.move< Capture > (that.value);
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.move< Expression > (that.value);
        break;

      case symbol_kind::S_for_args: // for_args
        value.move< ForArgs > (that.value);
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.move< RPNCommand > (that.value);
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.move< SectionModifier > (that.value);
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.move< SectionSpec > (that.value);
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.move< SectionType > (that.value);
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.move< StrFmtArgList > (that.value);
        break;

      case symbol_kind::S_maybe_quiet: // maybe_quiet
        value.move< bool > (that.value);
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.move< int32_t > (that.value);
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.move< std::shared_ptr<MacroArgs> > (that.value);
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_QMACRO: // "quiet macro"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.move< std::string > (that.value);
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.move< std::vector<Expression> > (that.value);
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.move< std::vector<int32_t> > (that.value);
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.move< std::vector<std::string> > (that.value);
        break;

      default:
        break;
    }

    // that is emptied.
    that.state = empty_state;
    return *this;
  }
#endif

  template <typename Base>
  void
  parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);
  }

#if YYDEBUG
  template <typename Base>
  void
  parser::yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YY_USE (yyoutput);
    if (yysym.empty ())
      yyo << "empty symbol";
    else
      {
        symbol_kind_type yykind = yysym.kind ();
        yyo << (yykind < YYNTOKENS ? "token" : "nterm")
            << ' ' << yysym.name () << " (";
        YY_USE (yykind);
        yyo << ')';
      }
  }
#endif

  void
  parser::yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym)
  {
    if (m)
      YY_SYMBOL_PRINT (m, sym);
    yystack_.push (YY_MOVE (sym));
  }

  void
  parser::yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym)
  {
#if 201103L <= YY_CPLUSPLUS
    yypush_ (m, stack_symbol_type (s, std::move (sym)));
#else
    stack_symbol_type ss (s, sym);
    yypush_ (m, ss);
#endif
  }

  void
  parser::yypop_ (int n) YY_NOEXCEPT
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  parser::debug_level_type
  parser::debug_level () const
  {
    return yydebug_;
  }

  void
  parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

  parser::state_type
  parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - YYNTOKENS] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - YYNTOKENS];
  }

  bool
  parser::yy_pact_value_is_default_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yypact_ninf_;
  }

  bool
  parser::yy_table_value_is_error_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yytable_ninf_;
  }

  int
  parser::operator() ()
  {
    return parse ();
  }

  int
  parser::parse ()
  {
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The return value of parse ().
    int yyresult;

    // Discard the LAC context in case there still is one left from a
    // previous invocation.
    yy_lac_discard_ ("init");

#if YY_EXCEPTIONS
    try
#endif // YY_EXCEPTIONS
      {
    YYCDEBUG << "Starting parse\n";


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, YY_MOVE (yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << int (yystack_[0].state) << '\n';
    YY_STACK_PRINT ();

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;


  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[+yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token\n";
#if YY_EXCEPTIONS
        try
#endif // YY_EXCEPTIONS
          {
            symbol_type yylookahead (yylex ());
            yyla.move (yylookahead);
          }
#if YY_EXCEPTIONS
        catch (const syntax_error& yyexc)
          {
            YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
            error (yyexc);
            goto yyerrlab1;
          }
#endif // YY_EXCEPTIONS
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    if (yyla.kind () == symbol_kind::S_YYerror)
    {
      // The scanner already issued an error message, process directly
      // to error recovery.  But do not keep the error token as
      // lookahead, it is too special and may lead us to an endless
      // loop in error recovery. */
      yyla.kind_ = symbol_kind::S_YYUNDEF;
      goto yyerrlab1;
    }

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.kind ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.kind ())
      {
        if (!yy_lac_establish_ (yyla.kind ()))
          goto yyerrlab;
        goto yydefault;
      }

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        if (!yy_lac_establish_ (yyla.kind ()))
          goto yyerrlab;

        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", state_type (yyn), YY_MOVE (yyla));
    yy_lac_discard_ ("shift");
    goto yynewstate;


  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[+yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;


  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_ (yystack_[yylen].state, yyr1_[yyn]);
      /* Variants are always initialized to an empty instance of the
         correct type. The default '$$ = $1' action is NOT applied
         when using variants.  */
      switch (yyr1_[yyn])
    {
      case symbol_kind::S_align_spec: // align_spec
        yylhs.value.emplace< AlignmentSpec > ();
        break;

      case symbol_kind::S_assert_type: // assert_type
        yylhs.value.emplace< AssertionType > ();
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        yylhs.value.emplace< Capture > ();
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        yylhs.value.emplace< Expression > ();
        break;

      case symbol_kind::S_for_args: // for_args
        yylhs.value.emplace< ForArgs > ();
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        yylhs.value.emplace< RPNCommand > ();
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        yylhs.value.emplace< SectionModifier > ();
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        yylhs.value.emplace< SectionSpec > ();
        break;

      case symbol_kind::S_sect_type: // sect_type
        yylhs.value.emplace< SectionType > ();
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        yylhs.value.emplace< StrFmtArgList > ();
        break;

      case symbol_kind::S_maybe_quiet: // maybe_quiet
        yylhs.value.emplace< bool > ();
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        yylhs.value.emplace< int32_t > ();
        break;

      case symbol_kind::S_macro_args: // macro_args
        yylhs.value.emplace< std::shared_ptr<MacroArgs> > ();
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_QMACRO: // "quiet macro"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        yylhs.value.emplace< std::string > ();
        break;

      case symbol_kind::S_ds_args: // ds_args
        yylhs.value.emplace< std::vector<Expression> > ();
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        yylhs.value.emplace< std::vector<int32_t> > ();
        break;

      case symbol_kind::S_purge_args: // purge_args
        yylhs.value.emplace< std::vector<std::string> > ();
        break;

      default:
        break;
    }



      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
        {
          switch (yyn)
            {
  case 5: // $@1: %empty
#line 420 "asm/parser.y"
                {
		lexer_SetMode(LEXER_NORMAL);
		lexer_ToggleStringExpansion(true);
	}
#line 1161 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 6: // lines: error $@1 endofline
#line 423 "asm/parser.y"
                    {
		yyerrok;
	}
#line 1169 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 8: // diff_mark: "+"
#line 430 "asm/parser.y"
                 {
		::error(
		    "syntax error, unexpected '+' at the beginning of the line (is it a leftover diff "
		    "mark?)"
		);
	}
#line 1180 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 9: // diff_mark: "-"
#line 436 "asm/parser.y"
                 {
		::error(
		    "syntax error, unexpected '-' at the beginning of the line (is it a leftover diff "
		    "mark?)"
		);
	}
#line 1191 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 24: // if: "IF" iconst "end of line"
#line 471 "asm/parser.y"
                              {
		act_If(yystack_[1].value.as < int32_t > ());
	}
#line 1199 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 25: // elif: "ELIF" iconst "end of line"
#line 477 "asm/parser.y"
                                {
		act_Elif(yystack_[1].value.as < int32_t > ());
	}
#line 1207 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 26: // else: "ELSE" "end of line"
#line 483 "asm/parser.y"
                         {
		act_Else();
	}
#line 1215 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 31: // endc: "ENDC" endofline
#line 498 "asm/parser.y"
                           {
		act_Endc();
	}
#line 1223 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 32: // $@2: %empty
#line 504 "asm/parser.y"
               {
		lexer_ToggleStringExpansion(false);
	}
#line 1231 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 33: // def_id: "DEF" $@2 "symbol"
#line 506 "asm/parser.y"
                 {
		lexer_ToggleStringExpansion(true);
		yylhs.value.as < std::string > () = std::move(yystack_[0].value.as < std::string > ());
	}
#line 1240 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 34: // $@3: %empty
#line 513 "asm/parser.y"
                  {
		lexer_ToggleStringExpansion(false);
	}
#line 1248 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 35: // redef_id: "REDEF" $@3 "symbol"
#line 515 "asm/parser.y"
                 {
		lexer_ToggleStringExpansion(true);
		yylhs.value.as < std::string > () = std::move(yystack_[0].value.as < std::string > ());
	}
#line 1257 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 36: // scoped_sym_no_anon: "symbol"
#line 521 "asm/parser.y"
                    { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1263 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 37: // scoped_sym_no_anon: "label"
#line 521 "asm/parser.y"
                             { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1269 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 38: // scoped_sym_no_anon: "local label"
#line 521 "asm/parser.y"
                                     { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1275 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 39: // scoped_sym: scoped_sym_no_anon
#line 523 "asm/parser.y"
            { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1281 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 40: // scoped_sym: "anonymous label"
#line 523 "asm/parser.y"
                                 { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1287 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 42: // label: "label" ":"
#line 527 "asm/parser.y"
                      {
		sym_AddLabel(yystack_[1].value.as < std::string > ());
	}
#line 1295 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 43: // label: "label" "::"
#line 530 "asm/parser.y"
                             {
		sym_AddLabel(yystack_[1].value.as < std::string > ());
		sym_Export(yystack_[1].value.as < std::string > ());
	}
#line 1304 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 44: // label: "local label"
#line 534 "asm/parser.y"
                {
		sym_AddLocalLabel(yystack_[0].value.as < std::string > ());
	}
#line 1312 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 45: // label: "local label" ":"
#line 537 "asm/parser.y"
                      {
		sym_AddLocalLabel(yystack_[1].value.as < std::string > ());
	}
#line 1320 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 46: // label: "local label" "::"
#line 540 "asm/parser.y"
                             {
		sym_AddLocalLabel(yystack_[1].value.as < std::string > ());
		sym_Export(yystack_[1].value.as < std::string > ());
	}
#line 1329 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 47: // label: ":"
#line 544 "asm/parser.y"
                {
		sym_AddAnonLabel();
	}
#line 1337 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 48: // $@4: %empty
#line 550 "asm/parser.y"
               {
		// Parsing 'macro_args' will restore the lexer's normal mode
		lexer_SetMode(LEXER_RAW);
	}
#line 1346 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 49: // macro_invocation: "symbol" $@4 macro_args
#line 553 "asm/parser.y"
                     {
		fstk_RunMacro(yystack_[2].value.as < std::string > (), yystack_[0].value.as < std::shared_ptr<MacroArgs> > (), false);
	}
#line 1354 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 50: // $@5: %empty
#line 556 "asm/parser.y"
                 {
		// Parsing 'macro_args' will restore the lexer's normal mode
		lexer_SetMode(LEXER_RAW);
	}
#line 1363 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 51: // macro_invocation: "quiet macro" $@5 macro_args
#line 559 "asm/parser.y"
                     {
		fstk_RunMacro(yystack_[2].value.as < std::string > (), yystack_[0].value.as < std::shared_ptr<MacroArgs> > (), true);
	}
#line 1371 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 52: // macro_args: %empty
#line 565 "asm/parser.y"
               {
		yylhs.value.as < std::shared_ptr<MacroArgs> > () = std::make_shared<MacroArgs>();
	}
#line 1379 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 53: // macro_args: macro_args "string"
#line 568 "asm/parser.y"
                            {
		yylhs.value.as < std::shared_ptr<MacroArgs> > () = std::move(yystack_[1].value.as < std::shared_ptr<MacroArgs> > ());
		yylhs.value.as < std::shared_ptr<MacroArgs> > ()->appendArg(std::make_shared<std::string>(yystack_[0].value.as < std::string > ()));
	}
#line 1388 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 88: // def_numeric: def_equ
#line 612 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1394 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 89: // def_numeric: redef_equ
#line 613 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1400 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 90: // def_numeric: def_set
#line 614 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1406 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 91: // def_numeric: def_rb
#line 615 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1412 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 92: // def_numeric: def_rw
#line 616 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1418 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 93: // def_numeric: def_rl
#line 617 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1424 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 96: // compound_eq: "+="
#line 623 "asm/parser.y"
                  {
		yylhs.value.as < RPNCommand > () = RPN_ADD;
	}
#line 1432 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 97: // compound_eq: "-="
#line 626 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_SUB;
	}
#line 1440 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 98: // compound_eq: "*="
#line 629 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_MUL;
	}
#line 1448 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 99: // compound_eq: "/="
#line 632 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_DIV;
	}
#line 1456 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 100: // compound_eq: "%="
#line 635 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_MOD;
	}
#line 1464 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 101: // compound_eq: "^="
#line 638 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_XOR;
	}
#line 1472 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 102: // compound_eq: "|="
#line 641 "asm/parser.y"
                   {
		yylhs.value.as < RPNCommand > () = RPN_OR;
	}
#line 1480 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 103: // compound_eq: "&="
#line 644 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_AND;
	}
#line 1488 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 104: // compound_eq: "<<="
#line 647 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_SHL;
	}
#line 1496 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 105: // compound_eq: ">>="
#line 650 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_SHR;
	}
#line 1504 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 106: // align: "ALIGN" align_spec
#line 656 "asm/parser.y"
                             {
		sect_AlignPC(yystack_[0].value.as < AlignmentSpec > ().alignment, yystack_[0].value.as < AlignmentSpec > ().alignOfs);
	}
#line 1512 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 107: // align_spec: uconst
#line 662 "asm/parser.y"
               {
		yylhs.value.as < AlignmentSpec > () = act_Alignment(yystack_[0].value.as < int32_t > (), 0);
	}
#line 1520 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 108: // align_spec: uconst "," iconst
#line 665 "asm/parser.y"
                              {
		yylhs.value.as < AlignmentSpec > () = act_Alignment(yystack_[2].value.as < int32_t > (), yystack_[0].value.as < int32_t > ());
	}
#line 1528 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 109: // $@6: %empty
#line 671 "asm/parser.y"
                {
		// Parsing 'opt_list' will restore the lexer's normal mode
		lexer_SetMode(LEXER_RAW);
	}
#line 1537 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 113: // opt_list_entry: "string"
#line 683 "asm/parser.y"
               {
		opt_Parse(yystack_[0].value.as < std::string > ().c_str());
	}
#line 1545 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 114: // popo: "POPO"
#line 689 "asm/parser.y"
                 {
		opt_Pop();
	}
#line 1553 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 115: // $@7: %empty
#line 695 "asm/parser.y"
                  {
		opt_Push();
		// Parsing 'pusho_opt_list' will restore the lexer's normal mode
		lexer_SetMode(LEXER_RAW);
	}
#line 1563 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 117: // pusho_opt_list: %empty
#line 703 "asm/parser.y"
               {
		lexer_SetMode(LEXER_NORMAL);
	}
#line 1571 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 119: // pops: "POPS"
#line 710 "asm/parser.y"
                 {
		sect_PopSection();
	}
#line 1579 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 120: // pushs: "PUSHS"
#line 716 "asm/parser.y"
                  {
		sect_PushSection();
	}
#line 1587 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 121: // endsection: "ENDSECTION"
#line 722 "asm/parser.y"
                       {
		sect_EndSection();
	}
#line 1595 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 122: // fail: "FAIL" string
#line 728 "asm/parser.y"
                        {
		fatal("%s", yystack_[0].value.as < std::string > ().c_str());
	}
#line 1603 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 123: // warn: "WARN" string
#line 734 "asm/parser.y"
                        {
		warning(WARNING_USER, "%s", yystack_[0].value.as < std::string > ().c_str());
	}
#line 1611 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 124: // assert_type: %empty
#line 740 "asm/parser.y"
               {
		yylhs.value.as < AssertionType > () = ASSERT_ERROR;
	}
#line 1619 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 125: // assert_type: "WARN" ","
#line 743 "asm/parser.y"
                         {
		yylhs.value.as < AssertionType > () = ASSERT_WARN;
	}
#line 1627 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 126: // assert_type: "FAIL" ","
#line 746 "asm/parser.y"
                         {
		yylhs.value.as < AssertionType > () = ASSERT_ERROR;
	}
#line 1635 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 127: // assert_type: "FATAL" ","
#line 749 "asm/parser.y"
                          {
		yylhs.value.as < AssertionType > () = ASSERT_FATAL;
	}
#line 1643 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 128: // assert: "ASSERT" assert_type relocexpr
#line 755 "asm/parser.y"
                                         {
		act_Assert(yystack_[1].value.as < AssertionType > (), yystack_[0].value.as < Expression > (), "");
	}
#line 1651 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 129: // assert: "ASSERT" assert_type relocexpr "," string
#line 758 "asm/parser.y"
                                                        {
		act_Assert(yystack_[3].value.as < AssertionType > (), yystack_[2].value.as < Expression > (), yystack_[0].value.as < std::string > ());
	}
#line 1659 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 130: // assert: "STATIC_ASSERT" assert_type iconst
#line 761 "asm/parser.y"
                                               {
		act_StaticAssert(yystack_[1].value.as < AssertionType > (), yystack_[0].value.as < int32_t > (), "");
	}
#line 1667 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 131: // assert: "STATIC_ASSERT" assert_type iconst "," string
#line 764 "asm/parser.y"
                                                            {
		act_StaticAssert(yystack_[3].value.as < AssertionType > (), yystack_[2].value.as < int32_t > (), yystack_[0].value.as < std::string > ());
	}
#line 1675 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 132: // shift: "SHIFT" shift_const
#line 770 "asm/parser.y"
                              {
		if (MacroArgs *macroArgs = fstk_GetCurrentMacroArgs(); macroArgs) {
			macroArgs->shiftArgs(yystack_[0].value.as < int32_t > ());
		} else {
			::error("Cannot shift macro arguments outside of a macro");
		}
	}
#line 1687 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 133: // shift_const: %empty
#line 780 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = 1;
	}
#line 1695 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 134: // shift_const: iconst
#line 783 "asm/parser.y"
          { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 1701 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 135: // load: "LOAD" sect_mod string "," sect_type sect_org sect_attrs
#line 787 "asm/parser.y"
                                                                     {
		sect_SetLoadSection(yystack_[4].value.as < std::string > (), yystack_[2].value.as < SectionType > (), yystack_[1].value.as < int32_t > (), yystack_[0].value.as < SectionSpec > (), yystack_[5].value.as < SectionModifier > ());
	}
#line 1709 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 136: // load: "ENDL"
#line 790 "asm/parser.y"
                   {
		sect_EndLoadSection(nullptr);
	}
#line 1717 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 137: // maybe_quiet: %empty
#line 796 "asm/parser.y"
               {
		yylhs.value.as < bool > () = false;
	}
#line 1725 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 138: // maybe_quiet: "?"
#line 799 "asm/parser.y"
                       {
		yylhs.value.as < bool > () = true;
	}
#line 1733 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 139: // rept: "REPT" maybe_quiet uconst "end of line" capture_rept endofline
#line 805 "asm/parser.y"
                                                                   {
		if (yystack_[1].value.as < Capture > ().span.ptr) {
			fstk_RunRept(yystack_[3].value.as < int32_t > (), yystack_[1].value.as < Capture > ().lineNo, yystack_[1].value.as < Capture > ().span, yystack_[4].value.as < bool > ());
		}
	}
#line 1743 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 140: // $@8: %empty
#line 813 "asm/parser.y"
                {
		lexer_ToggleStringExpansion(false);
	}
#line 1751 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 141: // $@9: %empty
#line 815 "asm/parser.y"
                             {
		lexer_ToggleStringExpansion(true);
	}
#line 1759 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 142: // for: "FOR" $@8 maybe_quiet "symbol" $@9 "," for_args "end of line" capture_rept endofline
#line 817 "asm/parser.y"
                                                        {
		if (yystack_[1].value.as < Capture > ().span.ptr) {
			fstk_RunFor(yystack_[6].value.as < std::string > (), yystack_[3].value.as < ForArgs > ().start, yystack_[3].value.as < ForArgs > ().stop, yystack_[3].value.as < ForArgs > ().step, yystack_[1].value.as < Capture > ().lineNo, yystack_[1].value.as < Capture > ().span, yystack_[7].value.as < bool > ());
		}
	}
#line 1769 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 143: // capture_rept: %empty
#line 825 "asm/parser.y"
               {
		yylhs.value.as < Capture > () = lexer_CaptureRept();
	}
#line 1777 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 144: // for_args: iconst
#line 831 "asm/parser.y"
               {
		yylhs.value.as < ForArgs > ().start = 0;
		yylhs.value.as < ForArgs > ().stop = yystack_[0].value.as < int32_t > ();
		yylhs.value.as < ForArgs > ().step = 1;
	}
#line 1787 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 145: // for_args: iconst "," iconst
#line 836 "asm/parser.y"
                              {
		yylhs.value.as < ForArgs > ().start = yystack_[2].value.as < int32_t > ();
		yylhs.value.as < ForArgs > ().stop = yystack_[0].value.as < int32_t > ();
		yylhs.value.as < ForArgs > ().step = 1;
	}
#line 1797 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 146: // for_args: iconst "," iconst "," iconst
#line 841 "asm/parser.y"
                                           {
		yylhs.value.as < ForArgs > ().start = yystack_[4].value.as < int32_t > ();
		yylhs.value.as < ForArgs > ().stop = yystack_[2].value.as < int32_t > ();
		yylhs.value.as < ForArgs > ().step = yystack_[0].value.as < int32_t > ();
	}
#line 1807 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 147: // break: label "BREAK" endofline
#line 849 "asm/parser.y"
                                  {
		if (fstk_Break()) {
			lexer_SetMode(LEXER_SKIP_TO_ENDR);
		}
	}
#line 1817 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 148: // $@10: %empty
#line 857 "asm/parser.y"
                  {
		lexer_ToggleStringExpansion(false);
	}
#line 1825 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 149: // $@11: %empty
#line 859 "asm/parser.y"
                             {
		lexer_ToggleStringExpansion(true);
	}
#line 1833 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 150: // macro_def: "MACRO" $@10 maybe_quiet "symbol" $@11 "end of line" capture_macro endofline
#line 861 "asm/parser.y"
                                          {
		if (yystack_[1].value.as < Capture > ().span.ptr) {
			sym_AddMacro(yystack_[4].value.as < std::string > (), yystack_[1].value.as < Capture > ().lineNo, yystack_[1].value.as < Capture > ().span, yystack_[5].value.as < bool > ());
		}
	}
#line 1843 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 151: // capture_macro: %empty
#line 869 "asm/parser.y"
               {
		yylhs.value.as < Capture > () = lexer_CaptureMacro();
	}
#line 1851 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 152: // rsset: "RSSET" uconst
#line 875 "asm/parser.y"
                         {
		sym_SetRSValue(yystack_[0].value.as < int32_t > ());
	}
#line 1859 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 153: // rsreset: "RSRESET"
#line 881 "asm/parser.y"
                    {
		sym_SetRSValue(0);
	}
#line 1867 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 154: // rs_uconst: %empty
#line 887 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = 1;
	}
#line 1875 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 155: // rs_uconst: uconst
#line 890 "asm/parser.y"
          { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 1881 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 156: // union: "UNION"
#line 894 "asm/parser.y"
                  {
		sect_StartUnion();
	}
#line 1889 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 157: // nextu: "NEXTU"
#line 900 "asm/parser.y"
                  {
		sect_NextUnionMember();
	}
#line 1897 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 158: // endu: "ENDU"
#line 906 "asm/parser.y"
                 {
		sect_EndUnion();
	}
#line 1905 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 159: // def_equ: def_id "EQU" iconst
#line 912 "asm/parser.y"
                              {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_AddEqu(yylhs.value.as < std::string > (), yystack_[0].value.as < int32_t > ());
	}
#line 1914 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 160: // redef_equ: redef_id "EQU" iconst
#line 919 "asm/parser.y"
                                {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_RedefEqu(yylhs.value.as < std::string > (), yystack_[0].value.as < int32_t > ());
	}
#line 1923 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 161: // def_set: def_id "=" iconst
#line 926 "asm/parser.y"
                                {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_AddVar(yylhs.value.as < std::string > (), yystack_[0].value.as < int32_t > ());
	}
#line 1932 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 162: // def_set: redef_id "=" iconst
#line 930 "asm/parser.y"
                                    {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_AddVar(yylhs.value.as < std::string > (), yystack_[0].value.as < int32_t > ());
	}
#line 1941 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 163: // def_set: def_id compound_eq iconst
#line 934 "asm/parser.y"
                                    {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		act_CompoundAssignment(yylhs.value.as < std::string > (), yystack_[1].value.as < RPNCommand > (), yystack_[0].value.as < int32_t > ());
	}
#line 1950 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 164: // def_set: redef_id compound_eq iconst
#line 938 "asm/parser.y"
                                      {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		act_CompoundAssignment(yylhs.value.as < std::string > (), yystack_[1].value.as < RPNCommand > (), yystack_[0].value.as < int32_t > ());
	}
#line 1959 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 165: // def_rb: def_id "RB" rs_uconst
#line 945 "asm/parser.y"
                                {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		uint32_t rs = sym_GetRSValue();
		sym_AddEqu(yylhs.value.as < std::string > (), rs);
		sym_SetRSValue(rs + yystack_[0].value.as < int32_t > ());
	}
#line 1970 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 166: // def_rw: def_id "RW" rs_uconst
#line 954 "asm/parser.y"
                                {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		uint32_t rs = sym_GetRSValue();
		sym_AddEqu(yylhs.value.as < std::string > (), rs);
		sym_SetRSValue(rs + 2 * yystack_[0].value.as < int32_t > ());
	}
#line 1981 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 167: // def_rl: def_id "rl" rs_uconst
#line 963 "asm/parser.y"
                                 {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		uint32_t rs = sym_GetRSValue();
		sym_AddEqu(yylhs.value.as < std::string > (), rs);
		sym_SetRSValue(rs + 4 * yystack_[0].value.as < int32_t > ());
	}
#line 1992 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 168: // def_equs: def_id "EQUS" string
#line 972 "asm/parser.y"
                               {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_AddString(yylhs.value.as < std::string > (), std::make_shared<std::string>(yystack_[0].value.as < std::string > ()));
	}
#line 2001 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 169: // redef_equs: redef_id "EQUS" string
#line 979 "asm/parser.y"
                                 {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_RedefString(yylhs.value.as < std::string > (), std::make_shared<std::string>(yystack_[0].value.as < std::string > ()));
	}
#line 2010 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 170: // $@12: %empty
#line 986 "asm/parser.y"
                  {
		lexer_ToggleStringExpansion(false);
	}
#line 2018 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 171: // purge: "PURGE" $@12 purge_args trailing_comma
#line 988 "asm/parser.y"
                                    {
		for (std::string &arg : yystack_[1].value.as < std::vector<std::string> > ()) {
			sym_Purge(arg);
		}
		lexer_ToggleStringExpansion(true);
	}
#line 2029 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 172: // purge_args: scoped_sym_no_anon
#line 997 "asm/parser.y"
                           {
		yylhs.value.as < std::vector<std::string> > ().push_back(yystack_[0].value.as < std::string > ());
	}
#line 2037 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 173: // purge_args: purge_args "," scoped_sym_no_anon
#line 1000 "asm/parser.y"
                                              {
		yylhs.value.as < std::vector<std::string> > () = std::move(yystack_[2].value.as < std::vector<std::string> > ());
		yylhs.value.as < std::vector<std::string> > ().push_back(yystack_[0].value.as < std::string > ());
	}
#line 2046 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 177: // export_list_entry: scoped_sym_no_anon
#line 1014 "asm/parser.y"
                           {
		sym_Export(yystack_[0].value.as < std::string > ());
	}
#line 2054 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 178: // export_def: "EXPORT" def_numeric
#line 1020 "asm/parser.y"
                               {
		sym_Export(yystack_[0].value.as < std::string > ());
	}
#line 2062 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 179: // include: label "INCLUDE" maybe_quiet string endofline
#line 1026 "asm/parser.y"
                                                       {
		if (fstk_RunInclude(yystack_[1].value.as < std::string > (), yystack_[2].value.as < bool > ())) {
			YYACCEPT;
		}
	}
#line 2072 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 180: // incbin: "INCBIN" string
#line 1034 "asm/parser.y"
                          {
		if (sect_BinaryFile(yystack_[0].value.as < std::string > (), 0)) {
			YYACCEPT;
		}
	}
#line 2082 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 181: // incbin: "INCBIN" string "," uconst
#line 1039 "asm/parser.y"
                                         {
		if (sect_BinaryFile(yystack_[2].value.as < std::string > (), yystack_[0].value.as < int32_t > ())) {
			YYACCEPT;
		}
	}
#line 2092 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 182: // incbin: "INCBIN" string "," uconst "," uconst
#line 1044 "asm/parser.y"
                                                      {
		if (sect_BinaryFileSlice(yystack_[4].value.as < std::string > (), yystack_[2].value.as < int32_t > (), yystack_[0].value.as < int32_t > ())) {
			YYACCEPT;
		}
	}
#line 2102 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 183: // charmap: "CHARMAP" string "," charmap_args trailing_comma
#line 1052 "asm/parser.y"
                                                             {
		charmap_Add(yystack_[3].value.as < std::string > (), std::move(yystack_[1].value.as < std::vector<int32_t> > ()));
	}
#line 2110 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 184: // charmap: "CHARMAP" "character" "," charmap_args trailing_comma
#line 1055 "asm/parser.y"
                                                                  {
		charmap_Add(yystack_[3].value.as < std::string > (), std::move(yystack_[1].value.as < std::vector<int32_t> > ()));
	}
#line 2118 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 185: // charmap_args: iconst
#line 1061 "asm/parser.y"
               {
		yylhs.value.as < std::vector<int32_t> > ().push_back(std::move(yystack_[0].value.as < int32_t > ()));
	}
#line 2126 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 186: // charmap_args: charmap_args "," iconst
#line 1064 "asm/parser.y"
                                    {
		yylhs.value.as < std::vector<int32_t> > () = std::move(yystack_[2].value.as < std::vector<int32_t> > ());
		yylhs.value.as < std::vector<int32_t> > ().push_back(std::move(yystack_[0].value.as < int32_t > ()));
	}
#line 2135 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 187: // newcharmap: "NEWCHARMAP" "symbol"
#line 1071 "asm/parser.y"
                              {
		charmap_New(yystack_[0].value.as < std::string > (), nullptr);
	}
#line 2143 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 188: // newcharmap: "NEWCHARMAP" "symbol" "," "symbol"
#line 1074 "asm/parser.y"
                                             {
		charmap_New(yystack_[2].value.as < std::string > (), &yystack_[0].value.as < std::string > ());
	}
#line 2151 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 189: // setcharmap: "SETCHARMAP" "symbol"
#line 1080 "asm/parser.y"
                              {
		charmap_Set(yystack_[0].value.as < std::string > ());
	}
#line 2159 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 190: // pushc: "PUSHC"
#line 1086 "asm/parser.y"
                  {
		charmap_Push();
	}
#line 2167 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 191: // pushc_setcharmap: "PUSHC" "symbol"
#line 1092 "asm/parser.y"
                         {
		charmap_Push();
		charmap_Set(yystack_[0].value.as < std::string > ());
	}
#line 2176 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 192: // popc: "POPC"
#line 1099 "asm/parser.y"
                 {
		charmap_Pop();
	}
#line 2184 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 194: // println: "PRINTLN"
#line 1107 "asm/parser.y"
                    {
		putchar('\n');
		fflush(stdout);
	}
#line 2193 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 195: // println: "PRINTLN" print_exprs trailing_comma
#line 1111 "asm/parser.y"
                                                 {
		putchar('\n');
		fflush(stdout);
	}
#line 2202 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 198: // print_expr: relocexpr_no_str
#line 1123 "asm/parser.y"
                         {
		printf("$%" PRIX32, yystack_[0].value.as < Expression > ().getConstVal());
	}
#line 2210 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 199: // print_expr: string_literal
#line 1126 "asm/parser.y"
                         {
		// Allow printing NUL characters
		fwrite(yystack_[0].value.as < std::string > ().data(), 1, yystack_[0].value.as < std::string > ().length(), stdout);
	}
#line 2219 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 200: // print_expr: scoped_sym
#line 1130 "asm/parser.y"
                     {
		handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [](Expression const &expr) { printf("$%" PRIX32, expr.getConstVal()); },
		    [](std::string const &str) { fwrite(str.data(), 1, str.length(), stdout); }
		);
	}
#line 2231 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 201: // reloc_3bit: relocexpr
#line 1140 "asm/parser.y"
                  {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
		yylhs.value.as < Expression > ().checkNBit(3);
	}
#line 2240 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 204: // constlist_8bit_entry: relocexpr_no_str
#line 1152 "asm/parser.y"
                         {
		yystack_[0].value.as < Expression > ().checkNBit(8);
		sect_RelByte(yystack_[0].value.as < Expression > (), 0);
	}
#line 2249 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 205: // constlist_8bit_entry: string_literal
#line 1156 "asm/parser.y"
                         {
		std::vector<int32_t> output = charmap_Convert(yystack_[0].value.as < std::string > ());
		sect_ByteString(output);
	}
#line 2258 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 206: // constlist_8bit_entry: scoped_sym
#line 1160 "asm/parser.y"
                     {
		handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [](Expression const &expr) {
			    expr.checkNBit(8);
			    sect_RelByte(expr, 0);
		    },
		    [](std::string const &str) {
			    std::vector<int32_t> output = charmap_Convert(str);
			    sect_ByteString(output);
		    }
		);
	}
#line 2276 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 209: // constlist_16bit_entry: relocexpr_no_str
#line 1181 "asm/parser.y"
                         {
		yystack_[0].value.as < Expression > ().checkNBit(16);
		sect_RelWord(yystack_[0].value.as < Expression > (), 0);
	}
#line 2285 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 210: // constlist_16bit_entry: string_literal
#line 1185 "asm/parser.y"
                         {
		std::vector<int32_t> output = charmap_Convert(yystack_[0].value.as < std::string > ());
		sect_WordString(output);
	}
#line 2294 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 211: // constlist_16bit_entry: scoped_sym
#line 1189 "asm/parser.y"
                     {
		handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [](Expression const &expr) {
			    expr.checkNBit(16);
			    sect_RelWord(expr, 0);
		    },
		    [](std::string const &str) {
			    std::vector<int32_t> output = charmap_Convert(str);
			    sect_WordString(output);
		    }
		);
	}
#line 2312 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 212: // constlist_16bit_entry: fragment_literal
#line 1202 "asm/parser.y"
                           {
		Expression expr;
		expr.makeSymbol(yystack_[0].value.as < std::string > ());
		expr.checkNBit(16);
		sect_RelWord(expr, 0);
	}
#line 2323 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 215: // constlist_32bit_entry: relocexpr_no_str
#line 1216 "asm/parser.y"
                         {
		sect_RelLong(yystack_[0].value.as < Expression > (), 0);
	}
#line 2331 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 216: // constlist_32bit_entry: string_literal
#line 1219 "asm/parser.y"
                         {
		std::vector<int32_t> output = charmap_Convert(yystack_[0].value.as < std::string > ());
		sect_LongString(output);
	}
#line 2340 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 217: // constlist_32bit_entry: scoped_sym
#line 1223 "asm/parser.y"
                     {
		handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [](Expression const &expr) { sect_RelLong(expr, 0); },
		    [](std::string const &str) {
			    std::vector<int32_t> output = charmap_Convert(str);
			    sect_LongString(output);
		    }
		);
	}
#line 2355 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 218: // reloc_8bit: relocexpr
#line 1236 "asm/parser.y"
                  {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
		yylhs.value.as < Expression > ().checkNBit(8);
	}
#line 2364 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 219: // reloc_16bit: relocexpr
#line 1243 "asm/parser.y"
                  {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
		yylhs.value.as < Expression > ().checkNBit(16);
	}
#line 2373 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 220: // reloc_16bit: fragment_literal
#line 1247 "asm/parser.y"
                           {
		yylhs.value.as < Expression > ().makeSymbol(yystack_[0].value.as < std::string > ());
	}
#line 2381 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 221: // fragment_literal: "[[" fragment_literal_name asm_file "]]"
#line 1253 "asm/parser.y"
                                                       {
		sect_PopSection();
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
	}
#line 2390 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 222: // fragment_literal_name: %empty
#line 1260 "asm/parser.y"
               {
		yylhs.value.as < std::string > () = sect_PushSectionFragmentLiteral();
		sym_AddLabel(yylhs.value.as < std::string > ());
	}
#line 2399 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 223: // relocexpr: relocexpr_no_str
#line 1267 "asm/parser.y"
                         {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
	}
#line 2407 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 224: // relocexpr: string_literal
#line 1270 "asm/parser.y"
                         {
		yylhs.value.as < Expression > ().makeNumber(act_StringToNum(yystack_[0].value.as < std::string > ()));
	}
#line 2415 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 225: // relocexpr: scoped_sym
#line 1273 "asm/parser.y"
                     {
		yylhs.value.as < Expression > () = handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [](Expression const &expr) { return expr; },
		    [](std::string const &str) {
			    Expression expr;
			    expr.makeNumber(act_StringToNum(str));
			    return expr;
		    }
		);
	}
#line 2431 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 226: // relocexpr_no_str: "number"
#line 1287 "asm/parser.y"
               {
		yylhs.value.as < Expression > ().makeNumber(yystack_[0].value.as < int32_t > ());
	}
#line 2439 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 227: // relocexpr_no_str: "character"
#line 1290 "asm/parser.y"
                    {
		yylhs.value.as < Expression > ().makeNumber(act_CharToNum(yystack_[0].value.as < std::string > ()));
	}
#line 2447 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 228: // relocexpr_no_str: string "===" string
#line 1293 "asm/parser.y"
                                  {
		yylhs.value.as < Expression > ().makeNumber(yystack_[2].value.as < std::string > ().compare(yystack_[0].value.as < std::string > ()) == 0);
	}
#line 2455 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 229: // relocexpr_no_str: string "!==" string
#line 1296 "asm/parser.y"
                                 {
		yylhs.value.as < Expression > ().makeNumber(yystack_[2].value.as < std::string > ().compare(yystack_[0].value.as < std::string > ()) != 0);
	}
#line 2463 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 230: // relocexpr_no_str: "!" relocexpr
#line 1299 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_LOGNOT, std::move(yystack_[0].value.as < Expression > ()));
	}
#line 2471 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 231: // relocexpr_no_str: relocexpr "||" relocexpr
#line 1302 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGOR, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2479 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 232: // relocexpr_no_str: relocexpr "&&" relocexpr
#line 1305 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGAND, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2487 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 233: // relocexpr_no_str: relocexpr "==" relocexpr
#line 1308 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGEQ, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2495 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 234: // relocexpr_no_str: relocexpr ">" relocexpr
#line 1311 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGGT, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2503 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 235: // relocexpr_no_str: relocexpr "<" relocexpr
#line 1314 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGLT, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2511 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 236: // relocexpr_no_str: relocexpr ">=" relocexpr
#line 1317 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGGE, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2519 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 237: // relocexpr_no_str: relocexpr "<=" relocexpr
#line 1320 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGLE, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2527 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 238: // relocexpr_no_str: relocexpr "!=" relocexpr
#line 1323 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGNE, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2535 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 239: // relocexpr_no_str: relocexpr "+" relocexpr
#line 1326 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_ADD, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2543 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 240: // relocexpr_no_str: relocexpr "-" relocexpr
#line 1329 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_SUB, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2551 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 241: // relocexpr_no_str: relocexpr "^" relocexpr
#line 1332 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_XOR, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2559 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 242: // relocexpr_no_str: relocexpr "|" relocexpr
#line 1335 "asm/parser.y"
                                    {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_OR, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2567 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 243: // relocexpr_no_str: relocexpr "&" relocexpr
#line 1338 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_AND, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2575 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 244: // relocexpr_no_str: relocexpr "<<" relocexpr
#line 1341 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_SHL, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2583 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 245: // relocexpr_no_str: relocexpr ">>" relocexpr
#line 1344 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_SHR, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2591 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 246: // relocexpr_no_str: relocexpr ">>>" relocexpr
#line 1347 "asm/parser.y"
                                      {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_USHR, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2599 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 247: // relocexpr_no_str: relocexpr "*" relocexpr
#line 1350 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_MUL, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2607 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 248: // relocexpr_no_str: relocexpr "/" relocexpr
#line 1353 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_DIV, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2615 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 249: // relocexpr_no_str: relocexpr "%" relocexpr
#line 1356 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_MOD, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2623 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 250: // relocexpr_no_str: relocexpr "**" relocexpr
#line 1359 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_EXP, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2631 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 251: // relocexpr_no_str: "+" relocexpr
#line 1362 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
	}
#line 2639 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 252: // relocexpr_no_str: "-" relocexpr
#line 1365 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_NEG, std::move(yystack_[0].value.as < Expression > ()));
	}
#line 2647 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 253: // relocexpr_no_str: "~" relocexpr
#line 1368 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_NOT, std::move(yystack_[0].value.as < Expression > ()));
	}
#line 2655 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 254: // relocexpr_no_str: "HIGH" "(" relocexpr ")"
#line 1371 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_HIGH, std::move(yystack_[1].value.as < Expression > ()));
	}
#line 2663 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 255: // relocexpr_no_str: "LOW" "(" relocexpr ")"
#line 1374 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_LOW, std::move(yystack_[1].value.as < Expression > ()));
	}
#line 2671 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 256: // relocexpr_no_str: "BITWIDTH" "(" relocexpr ")"
#line 1377 "asm/parser.y"
                                              {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_BITWIDTH, std::move(yystack_[1].value.as < Expression > ()));
	}
#line 2679 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 257: // relocexpr_no_str: "TZCOUNT" "(" relocexpr ")"
#line 1380 "asm/parser.y"
                                             {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_TZCOUNT, std::move(yystack_[1].value.as < Expression > ()));
	}
#line 2687 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 258: // relocexpr_no_str: "ISCONST" "(" relocexpr ")"
#line 1383 "asm/parser.y"
                                             {
		yylhs.value.as < Expression > ().makeNumber(yystack_[1].value.as < Expression > ().isKnown());
	}
#line 2695 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 259: // relocexpr_no_str: "BANK" "(" scoped_sym ")"
#line 1386 "asm/parser.y"
                                           {
		// '@' is also a SYMBOL; it is handled here
		yylhs.value.as < Expression > ().makeBankSymbol(yystack_[1].value.as < std::string > ());
	}
#line 2704 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 260: // relocexpr_no_str: "BANK" "(" string_literal ")"
#line 1390 "asm/parser.y"
                                               {
		yylhs.value.as < Expression > ().makeBankSection(yystack_[1].value.as < std::string > ());
	}
#line 2712 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 261: // relocexpr_no_str: "SIZEOF" "(" string ")"
#line 1393 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeSizeOfSection(yystack_[1].value.as < std::string > ());
	}
#line 2720 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 262: // relocexpr_no_str: "STARTOF" "(" string ")"
#line 1396 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeStartOfSection(yystack_[1].value.as < std::string > ());
	}
#line 2728 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 263: // relocexpr_no_str: "SIZEOF" "(" sect_type ")"
#line 1399 "asm/parser.y"
                                            {
		yylhs.value.as < Expression > ().makeSizeOfSectionType(yystack_[1].value.as < SectionType > ());
	}
#line 2736 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 264: // relocexpr_no_str: "STARTOF" "(" sect_type ")"
#line 1402 "asm/parser.y"
                                             {
		yylhs.value.as < Expression > ().makeStartOfSectionType(yystack_[1].value.as < SectionType > ());
	}
#line 2744 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 265: // relocexpr_no_str: "SIZEOF" "(" MODE_R8 ")"
#line 1405 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeNumber(1);
	}
#line 2752 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 266: // relocexpr_no_str: "SIZEOF" "(" MODE_R16 ")"
#line 1408 "asm/parser.y"
                                           {
		yylhs.value.as < Expression > ().makeNumber(2);
	}
#line 2760 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 267: // $@13: %empty
#line 1411 "asm/parser.y"
                 {
		lexer_ToggleStringExpansion(false);
	}
#line 2768 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 268: // relocexpr_no_str: "DEF" $@13 "(" scoped_sym ")"
#line 1413 "asm/parser.y"
                                   {
		yylhs.value.as < Expression > ().makeNumber(sym_FindScopedValidSymbol(yystack_[1].value.as < std::string > ()) != nullptr);
		lexer_ToggleStringExpansion(true);
	}
#line 2777 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 269: // relocexpr_no_str: "ROUND" "(" iconst precision_arg ")"
#line 1417 "asm/parser.y"
                                                      {
		yylhs.value.as < Expression > ().makeNumber(fix_Round(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2785 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 270: // relocexpr_no_str: "CEIL" "(" iconst precision_arg ")"
#line 1420 "asm/parser.y"
                                                     {
		yylhs.value.as < Expression > ().makeNumber(fix_Ceil(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2793 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 271: // relocexpr_no_str: "FLOOR" "(" iconst precision_arg ")"
#line 1423 "asm/parser.y"
                                                      {
		yylhs.value.as < Expression > ().makeNumber(fix_Floor(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2801 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 272: // relocexpr_no_str: "FDIV" "(" iconst "," iconst precision_arg ")"
#line 1426 "asm/parser.y"
                                                                  {
		yylhs.value.as < Expression > ().makeNumber(fix_Div(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2809 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 273: // relocexpr_no_str: "FMUL" "(" iconst "," iconst precision_arg ")"
#line 1429 "asm/parser.y"
                                                                  {
		yylhs.value.as < Expression > ().makeNumber(fix_Mul(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2817 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 274: // relocexpr_no_str: "FMOD" "(" iconst "," iconst precision_arg ")"
#line 1432 "asm/parser.y"
                                                                  {
		yylhs.value.as < Expression > ().makeNumber(fix_Mod(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2825 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 275: // relocexpr_no_str: "POW" "(" iconst "," iconst precision_arg ")"
#line 1435 "asm/parser.y"
                                                                 {
		yylhs.value.as < Expression > ().makeNumber(fix_Pow(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2833 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 276: // relocexpr_no_str: "LOG" "(" iconst "," iconst precision_arg ")"
#line 1438 "asm/parser.y"
                                                                 {
		yylhs.value.as < Expression > ().makeNumber(fix_Log(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2841 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 277: // relocexpr_no_str: "SIN" "(" iconst precision_arg ")"
#line 1441 "asm/parser.y"
                                                    {
		yylhs.value.as < Expression > ().makeNumber(fix_Sin(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2849 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 278: // relocexpr_no_str: "COS" "(" iconst precision_arg ")"
#line 1444 "asm/parser.y"
                                                    {
		yylhs.value.as < Expression > ().makeNumber(fix_Cos(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2857 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 279: // relocexpr_no_str: "TAN" "(" iconst precision_arg ")"
#line 1447 "asm/parser.y"
                                                    {
		yylhs.value.as < Expression > ().makeNumber(fix_Tan(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2865 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 280: // relocexpr_no_str: "ASIN" "(" iconst precision_arg ")"
#line 1450 "asm/parser.y"
                                                     {
		yylhs.value.as < Expression > ().makeNumber(fix_ASin(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2873 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 281: // relocexpr_no_str: "ACOS" "(" iconst precision_arg ")"
#line 1453 "asm/parser.y"
                                                     {
		yylhs.value.as < Expression > ().makeNumber(fix_ACos(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2881 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 282: // relocexpr_no_str: "ATAN" "(" iconst precision_arg ")"
#line 1456 "asm/parser.y"
                                                     {
		yylhs.value.as < Expression > ().makeNumber(fix_ATan(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2889 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 283: // relocexpr_no_str: "ATAN2" "(" iconst "," iconst precision_arg ")"
#line 1459 "asm/parser.y"
                                                                   {
		yylhs.value.as < Expression > ().makeNumber(fix_ATan2(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2897 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 284: // relocexpr_no_str: "STRCMP" "(" string "," string ")"
#line 1462 "asm/parser.y"
                                                      {
		yylhs.value.as < Expression > ().makeNumber(yystack_[3].value.as < std::string > ().compare(yystack_[1].value.as < std::string > ()));
	}
#line 2905 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 285: // relocexpr_no_str: "STRFIND" "(" string "," string ")"
#line 1465 "asm/parser.y"
                                                       {
		size_t pos = yystack_[3].value.as < std::string > ().find(yystack_[1].value.as < std::string > ());
		yylhs.value.as < Expression > ().makeNumber(pos != std::string::npos ? pos : -1);
	}
#line 2914 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 286: // relocexpr_no_str: "STRRFIND" "(" string "," string ")"
#line 1469 "asm/parser.y"
                                                        {
		size_t pos = yystack_[3].value.as < std::string > ().rfind(yystack_[1].value.as < std::string > ());
		yylhs.value.as < Expression > ().makeNumber(pos != std::string::npos ? pos : -1);
	}
#line 2923 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 287: // relocexpr_no_str: "STRIN" "(" string "," string ")"
#line 1473 "asm/parser.y"
                                                     {
		warning(WARNING_OBSOLETE, "`STRIN` is deprecated; use 0-indexed `STRFIND` instead");
		size_t pos = yystack_[3].value.as < std::string > ().find(yystack_[1].value.as < std::string > ());
		yylhs.value.as < Expression > ().makeNumber(pos != std::string::npos ? pos + 1 : 0);
	}
#line 2933 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 288: // relocexpr_no_str: "STRRIN" "(" string "," string ")"
#line 1478 "asm/parser.y"
                                                      {
		warning(WARNING_OBSOLETE, "`STRRIN` is deprecated; use 0-indexed `STRRFIND` instead");
		size_t pos = yystack_[3].value.as < std::string > ().rfind(yystack_[1].value.as < std::string > ());
		yylhs.value.as < Expression > ().makeNumber(pos != std::string::npos ? pos + 1 : 0);
	}
#line 2943 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 289: // relocexpr_no_str: "STRLEN" "(" string ")"
#line 1483 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeNumber(act_StringLen(yystack_[1].value.as < std::string > (), true));
	}
#line 2951 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 290: // relocexpr_no_str: "BYTELEN" "(" string ")"
#line 1486 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeNumber(yystack_[1].value.as < std::string > ().length());
	}
#line 2959 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 291: // relocexpr_no_str: "CHARLEN" "(" string ")"
#line 1489 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeNumber(act_CharLen(yystack_[1].value.as < std::string > ()));
	}
#line 2967 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 292: // relocexpr_no_str: "INCHARMAP" "(" string ")"
#line 1492 "asm/parser.y"
                                            {
		yylhs.value.as < Expression > ().makeNumber(charmap_HasChar(yystack_[1].value.as < std::string > ()));
	}
#line 2975 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 293: // relocexpr_no_str: "CHARCMP" "(" string "," string ")"
#line 1495 "asm/parser.y"
                                                       {
		yylhs.value.as < Expression > ().makeNumber(act_CharCmp(yystack_[3].value.as < std::string > (), yystack_[1].value.as < std::string > ()));
	}
#line 2983 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 294: // relocexpr_no_str: "CHARSIZE" "(" string ")"
#line 1498 "asm/parser.y"
                                           {
		size_t charSize = charmap_CharSize(yystack_[1].value.as < std::string > ());
		if (charSize == 0) {
			::error("CHARSIZE: No character mapping for \"%s\"", yystack_[1].value.as < std::string > ().c_str());
		}
		yylhs.value.as < Expression > ().makeNumber(charSize);
	}
#line 2995 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 295: // relocexpr_no_str: "CHARVAL" "(" string "," iconst ")"
#line 1505 "asm/parser.y"
                                                       {
		yylhs.value.as < Expression > ().makeNumber(act_CharVal(yystack_[3].value.as < std::string > (), yystack_[1].value.as < int32_t > ()));
	}
#line 3003 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 296: // relocexpr_no_str: "CHARVAL" "(" string ")"
#line 1508 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeNumber(act_CharVal(yystack_[1].value.as < std::string > ()));
	}
#line 3011 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 297: // relocexpr_no_str: "STRBYTE" "(" string "," iconst ")"
#line 1511 "asm/parser.y"
                                                       {
		yylhs.value.as < Expression > ().makeNumber(act_StringByte(yystack_[3].value.as < std::string > (), yystack_[1].value.as < int32_t > ()));
	}
#line 3019 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 298: // relocexpr_no_str: "(" relocexpr ")"
#line 1514 "asm/parser.y"
                                  {
		yylhs.value.as < Expression > () = std::move(yystack_[1].value.as < Expression > ());
	}
#line 3027 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 299: // uconst: iconst
#line 1520 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > ();
		if (yylhs.value.as < int32_t > () < 0) {
			fatal("Constant must not be negative: %d", yylhs.value.as < int32_t > ());
		}
	}
#line 3038 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 300: // iconst: relocexpr
#line 1529 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = yystack_[0].value.as < Expression > ().getConstVal();
	}
#line 3046 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 301: // precision_arg: %empty
#line 1535 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = options.fixPrecision;
	}
#line 3054 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 302: // precision_arg: "," iconst
#line 1538 "asm/parser.y"
                       {
		yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > ();
		if (yylhs.value.as < int32_t > () < 1 || yylhs.value.as < int32_t > () > 31) {
			::error("Fixed-point precision must be between 1 and 31, not %" PRId32, yylhs.value.as < int32_t > ());
			yylhs.value.as < int32_t > () = options.fixPrecision;
		}
	}
#line 3066 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 303: // string_literal: "string"
#line 1548 "asm/parser.y"
               {
		yylhs.value.as < std::string > () = std::move(yystack_[0].value.as < std::string > ());
	}
#line 3074 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 304: // string_literal: string "++" string
#line 1551 "asm/parser.y"
                               {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		yylhs.value.as < std::string > ().append(yystack_[0].value.as < std::string > ());
	}
#line 3083 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 305: // string_literal: "READFILE" "(" string ")"
#line 1555 "asm/parser.y"
                                           {
		if (std::optional<std::string> contents = act_ReadFile(yystack_[1].value.as < std::string > (), UINT32_MAX); contents) {
			yylhs.value.as < std::string > () = std::move(*contents);
		} else {
			YYACCEPT;
		}
	}
#line 3095 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 306: // string_literal: "READFILE" "(" string "," uconst ")"
#line 1562 "asm/parser.y"
                                                        {
		if (std::optional<std::string> contents = act_ReadFile(yystack_[3].value.as < std::string > (), yystack_[1].value.as < int32_t > ()); contents) {
			yylhs.value.as < std::string > () = std::move(*contents);
		} else {
			YYACCEPT;
		}
	}
#line 3107 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 307: // string_literal: "STRSLICE" "(" string "," iconst "," iconst ")"
#line 1569 "asm/parser.y"
                                                                     {
		yylhs.value.as < std::string > () = act_StringSlice(yystack_[5].value.as < std::string > (), yystack_[3].value.as < int32_t > (), yystack_[1].value.as < int32_t > ());
	}
#line 3115 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 308: // string_literal: "STRSLICE" "(" string "," iconst ")"
#line 1572 "asm/parser.y"
                                                        {
		yylhs.value.as < std::string > () = act_StringSlice(yystack_[3].value.as < std::string > (), yystack_[1].value.as < int32_t > (), std::nullopt);
	}
#line 3123 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 309: // string_literal: "STRSUB" "(" string "," iconst "," uconst ")"
#line 1575 "asm/parser.y"
                                                                   {
		yylhs.value.as < std::string > () = act_StringSub(yystack_[5].value.as < std::string > (), yystack_[3].value.as < int32_t > (), yystack_[1].value.as < int32_t > ());
	}
#line 3131 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 310: // string_literal: "STRSUB" "(" string "," iconst ")"
#line 1578 "asm/parser.y"
                                                      {
		yylhs.value.as < std::string > () = act_StringSub(yystack_[3].value.as < std::string > (), yystack_[1].value.as < int32_t > (), std::nullopt);
	}
#line 3139 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 311: // string_literal: "STRCHAR" "(" string "," iconst ")"
#line 1581 "asm/parser.y"
                                                       {
		yylhs.value.as < std::string > () = act_StringChar(yystack_[3].value.as < std::string > (), yystack_[1].value.as < int32_t > ());
	}
#line 3147 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 312: // string_literal: "CHARSUB" "(" string "," iconst ")"
#line 1584 "asm/parser.y"
                                                       {
		yylhs.value.as < std::string > () = act_CharSub(yystack_[3].value.as < std::string > (), yystack_[1].value.as < int32_t > ());
	}
#line 3155 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 313: // string_literal: "REVCHAR" "(" charmap_args ")"
#line 1587 "asm/parser.y"
                                                {
		bool unique;
		yylhs.value.as < std::string > () = charmap_Reverse(yystack_[1].value.as < std::vector<int32_t> > (), unique);
		if (!unique) {
			::error("REVCHAR: Multiple character mappings to values");
		} else if (yylhs.value.as < std::string > ().empty()) {
			::error("REVCHAR: No character mapping to values");
		}
	}
#line 3169 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 314: // string_literal: "STRCAT" "(" ")"
#line 1596 "asm/parser.y"
                                  {
		yylhs.value.as < std::string > ().clear();
	}
#line 3177 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 315: // string_literal: "STRCAT" "(" strcat_args ")"
#line 1599 "asm/parser.y"
                                              {
		yylhs.value.as < std::string > () = std::move(yystack_[1].value.as < std::string > ());
	}
#line 3185 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 316: // string_literal: "STRUPR" "(" string ")"
#line 1602 "asm/parser.y"
                                         {
		yylhs.value.as < std::string > () = std::move(yystack_[1].value.as < std::string > ());
		std::transform(RANGE(yylhs.value.as < std::string > ()), yylhs.value.as < std::string > ().begin(), toUpper);
	}
#line 3194 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 317: // string_literal: "STRLWR" "(" string ")"
#line 1606 "asm/parser.y"
                                         {
		yylhs.value.as < std::string > () = std::move(yystack_[1].value.as < std::string > ());
		std::transform(RANGE(yylhs.value.as < std::string > ()), yylhs.value.as < std::string > ().begin(), toLower);
	}
#line 3203 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 318: // string_literal: "STRRPL" "(" string "," string "," string ")"
#line 1610 "asm/parser.y"
                                                                   {
		yylhs.value.as < std::string > () = act_StringReplace(yystack_[5].value.as < std::string > (), yystack_[3].value.as < std::string > (), yystack_[1].value.as < std::string > ());
	}
#line 3211 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 319: // string_literal: "STRFMT" "(" strfmt_args ")"
#line 1613 "asm/parser.y"
                                              {
		yylhs.value.as < std::string > () = act_StringFormat(yystack_[1].value.as < StrFmtArgList > ().format, yystack_[1].value.as < StrFmtArgList > ().args);
	}
#line 3219 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 320: // string_literal: "SECTION" "(" scoped_sym ")"
#line 1616 "asm/parser.y"
                                               {
		yylhs.value.as < std::string > () = act_SectionName(yystack_[1].value.as < std::string > ());
	}
#line 3227 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 321: // string: string_literal
#line 1622 "asm/parser.y"
                       {
		yylhs.value.as < std::string > () = std::move(yystack_[0].value.as < std::string > ());
	}
#line 3235 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 322: // string: scoped_sym
#line 1625 "asm/parser.y"
                     {
		if (Symbol *sym = sym_FindScopedSymbol(yystack_[0].value.as < std::string > ()); sym && sym->type == SYM_EQUS) {
			yylhs.value.as < std::string > () = *sym->getEqus();
		} else {
			::error("`%s` is not a string symbol", yystack_[0].value.as < std::string > ().c_str());
		}
	}
#line 3247 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 323: // strcat_args: string
#line 1635 "asm/parser.y"
               {
		yylhs.value.as < std::string > () = std::move(yystack_[0].value.as < std::string > ());
	}
#line 3255 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 324: // strcat_args: strcat_args "," string
#line 1638 "asm/parser.y"
                                   {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		yylhs.value.as < std::string > ().append(yystack_[0].value.as < std::string > ());
	}
#line 3264 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 325: // strfmt_args: %empty
#line 1645 "asm/parser.y"
                 {}
#line 3270 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 326: // strfmt_args: string strfmt_va_args
#line 1646 "asm/parser.y"
                                {
		yylhs.value.as < StrFmtArgList > () = std::move(yystack_[0].value.as < StrFmtArgList > ());
		yylhs.value.as < StrFmtArgList > ().format = std::move(yystack_[1].value.as < std::string > ());
	}
#line 3279 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 327: // strfmt_va_args: %empty
#line 1653 "asm/parser.y"
                 {}
#line 3285 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 328: // strfmt_va_args: strfmt_va_args "," relocexpr_no_str
#line 1654 "asm/parser.y"
                                                {
		yylhs.value.as < StrFmtArgList > () = std::move(yystack_[2].value.as < StrFmtArgList > ());
		yylhs.value.as < StrFmtArgList > ().args.push_back(static_cast<uint32_t>(yystack_[0].value.as < Expression > ().getConstVal()));
	}
#line 3294 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 329: // strfmt_va_args: strfmt_va_args "," string_literal
#line 1658 "asm/parser.y"
                                              {
		yylhs.value.as < StrFmtArgList > () = std::move(yystack_[2].value.as < StrFmtArgList > ());
		yylhs.value.as < StrFmtArgList > ().args.push_back(std::move(yystack_[0].value.as < std::string > ()));
	}
#line 3303 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 330: // strfmt_va_args: strfmt_va_args "," scoped_sym
#line 1662 "asm/parser.y"
                                          {
		yylhs.value.as < StrFmtArgList > () = std::move(yystack_[2].value.as < StrFmtArgList > ());
		handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [&](Expression const &expr) {
			    yylhs.value.as < StrFmtArgList > ().args.push_back(static_cast<uint32_t>(expr.getConstVal()));
		    },
		    [&](std::string const &str) { yylhs.value.as < StrFmtArgList > ().args.push_back(str); }
		);
	}
#line 3318 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 331: // section: "SECTION" sect_mod string "," sect_type sect_org sect_attrs
#line 1675 "asm/parser.y"
                                                                        {
		sect_NewSection(yystack_[4].value.as < std::string > (), yystack_[2].value.as < SectionType > (), yystack_[1].value.as < int32_t > (), yystack_[0].value.as < SectionSpec > (), yystack_[5].value.as < SectionModifier > ());
	}
#line 3326 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 332: // pushs_section: "PUSHS" sect_mod string "," sect_type sect_org sect_attrs
#line 1681 "asm/parser.y"
                                                                      {
		sect_PushSection();
		sect_NewSection(yystack_[4].value.as < std::string > (), yystack_[2].value.as < SectionType > (), yystack_[1].value.as < int32_t > (), yystack_[0].value.as < SectionSpec > (), yystack_[5].value.as < SectionModifier > ());
	}
#line 3335 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 333: // sect_mod: %empty
#line 1688 "asm/parser.y"
               {
		yylhs.value.as < SectionModifier > () = SECTION_NORMAL;
	}
#line 3343 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 334: // sect_mod: "UNION"
#line 1691 "asm/parser.y"
                    {
		yylhs.value.as < SectionModifier > () = SECTION_UNION;
	}
#line 3351 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 335: // sect_mod: "FRAGMENT"
#line 1694 "asm/parser.y"
                       {
		yylhs.value.as < SectionModifier > () = SECTION_FRAGMENT;
	}
#line 3359 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 336: // sect_type: "WRAM0"
#line 1700 "asm/parser.y"
                   {
		yylhs.value.as < SectionType > () = SECTTYPE_WRAM0;
	}
#line 3367 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 337: // sect_type: "VRAM"
#line 1703 "asm/parser.y"
                    {
		yylhs.value.as < SectionType > () = SECTTYPE_VRAM;
	}
#line 3375 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 338: // sect_type: "ROMX"
#line 1706 "asm/parser.y"
                    {
		yylhs.value.as < SectionType > () = SECTTYPE_ROMX;
	}
#line 3383 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 339: // sect_type: "ROM0"
#line 1709 "asm/parser.y"
                    {
		yylhs.value.as < SectionType > () = SECTTYPE_ROM0;
	}
#line 3391 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 340: // sect_type: "HRAM"
#line 1712 "asm/parser.y"
                    {
		yylhs.value.as < SectionType > () = SECTTYPE_HRAM;
	}
#line 3399 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 341: // sect_type: "WRAMX"
#line 1715 "asm/parser.y"
                     {
		yylhs.value.as < SectionType > () = SECTTYPE_WRAMX;
	}
#line 3407 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 342: // sect_type: "SRAM"
#line 1718 "asm/parser.y"
                    {
		yylhs.value.as < SectionType > () = SECTTYPE_SRAM;
	}
#line 3415 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 343: // sect_type: "OAM"
#line 1721 "asm/parser.y"
                   {
		yylhs.value.as < SectionType > () = SECTTYPE_OAM;
	}
#line 3423 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 344: // sect_org: %empty
#line 1727 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = -1;
	}
#line 3431 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 345: // sect_org: "[" uconst "]"
#line 1730 "asm/parser.y"
                               {
		yylhs.value.as < int32_t > () = yystack_[1].value.as < int32_t > ();
		if (yylhs.value.as < int32_t > () < 0 || yylhs.value.as < int32_t > () > 0xFFFF) {
			::error("Address $%x is not 16-bit", yylhs.value.as < int32_t > ());
			yylhs.value.as < int32_t > () = -1;
		}
	}
#line 3443 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 346: // sect_attrs: %empty
#line 1740 "asm/parser.y"
               {
		yylhs.value.as < SectionSpec > ().alignment = 0;
		yylhs.value.as < SectionSpec > ().alignOfs = 0;
		yylhs.value.as < SectionSpec > ().bank = -1;
	}
#line 3453 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 347: // sect_attrs: sect_attrs "," "ALIGN" "[" align_spec "]"
#line 1745 "asm/parser.y"
                                                              {
		yylhs.value.as < SectionSpec > () = yystack_[5].value.as < SectionSpec > ();
		yylhs.value.as < SectionSpec > ().alignment = yystack_[1].value.as < AlignmentSpec > ().alignment;
		yylhs.value.as < SectionSpec > ().alignOfs = yystack_[1].value.as < AlignmentSpec > ().alignOfs;
	}
#line 3463 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 348: // sect_attrs: sect_attrs "," "BANK" "[" uconst "]"
#line 1750 "asm/parser.y"
                                                        {
		yylhs.value.as < SectionSpec > () = yystack_[5].value.as < SectionSpec > ();
		yylhs.value.as < SectionSpec > ().bank = yystack_[1].value.as < int32_t > (); // We cannot check the validity of this yet
	}
#line 3472 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 401: // ds: "DS" uconst
#line 1817 "asm/parser.y"
                      {
		sect_Skip(yystack_[0].value.as < int32_t > (), true);
	}
#line 3480 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 402: // ds: "DS" uconst "," ds_args trailing_comma
#line 1820 "asm/parser.y"
                                                     {
		sect_RelBytes(yystack_[3].value.as < int32_t > (), yystack_[1].value.as < std::vector<Expression> > ());
	}
#line 3488 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 403: // ds: "DS" "ALIGN" "[" align_spec "]" trailing_comma
#line 1823 "asm/parser.y"
                                                                   {
		uint32_t n = sect_GetAlignBytes(yystack_[2].value.as < AlignmentSpec > ().alignment, yystack_[2].value.as < AlignmentSpec > ().alignOfs);
		sect_Skip(n, true);
		sect_AlignPC(yystack_[2].value.as < AlignmentSpec > ().alignment, yystack_[2].value.as < AlignmentSpec > ().alignOfs);
	}
#line 3498 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 404: // ds: "DS" "ALIGN" "[" align_spec "]" "," ds_args trailing_comma
#line 1828 "asm/parser.y"
                                                                                 {
		uint32_t n = sect_GetAlignBytes(yystack_[4].value.as < AlignmentSpec > ().alignment, yystack_[4].value.as < AlignmentSpec > ().alignOfs);
		sect_RelBytes(n, yystack_[1].value.as < std::vector<Expression> > ());
		sect_AlignPC(yystack_[4].value.as < AlignmentSpec > ().alignment, yystack_[4].value.as < AlignmentSpec > ().alignOfs);
	}
#line 3508 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 405: // ds_args: reloc_8bit
#line 1836 "asm/parser.y"
                   {
		yylhs.value.as < std::vector<Expression> > ().push_back(std::move(yystack_[0].value.as < Expression > ()));
	}
#line 3516 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 406: // ds_args: ds_args "," reloc_8bit
#line 1839 "asm/parser.y"
                                   {
		yylhs.value.as < std::vector<Expression> > () = std::move(yystack_[2].value.as < std::vector<Expression> > ());
		yylhs.value.as < std::vector<Expression> > ().push_back(std::move(yystack_[0].value.as < Expression > ()));
	}
#line 3525 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 407: // db: "DB"
#line 1846 "asm/parser.y"
               {
		sect_Skip(1, false);
	}
#line 3533 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 409: // dw: "DW"
#line 1853 "asm/parser.y"
               {
		sect_Skip(2, false);
	}
#line 3541 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 411: // dl: "DL"
#line 1860 "asm/parser.y"
               {
		sect_Skip(4, false);
	}
#line 3549 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 413: // sm83_adc: "adc" op_a_n
#line 1867 "asm/parser.y"
                        {
		sect_ConstByte(0xCE);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3558 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 414: // sm83_adc: "adc" op_a_r
#line 1871 "asm/parser.y"
                          {
		sect_ConstByte(0x88 | yystack_[0].value.as < int32_t > ());
	}
#line 3566 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 415: // sm83_add: "add" op_a_n
#line 1877 "asm/parser.y"
                        {
		sect_ConstByte(0xC6);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3575 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 416: // sm83_add: "add" op_a_r
#line 1881 "asm/parser.y"
                          {
		sect_ConstByte(0x80 | yystack_[0].value.as < int32_t > ());
	}
#line 3583 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 417: // sm83_add: "add" "hl" "," reg_ss
#line 1884 "asm/parser.y"
                                        {
		sect_ConstByte(0x09 | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 3591 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 418: // sm83_add: "add" "sp" "," reloc_8bit
#line 1887 "asm/parser.y"
                                            {
		sect_ConstByte(0xE8);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3600 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 419: // sm83_and: "and" op_a_n
#line 1894 "asm/parser.y"
                        {
		sect_ConstByte(0xE6);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3609 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 420: // sm83_and: "and" op_a_r
#line 1898 "asm/parser.y"
                          {
		sect_ConstByte(0xA0 | yystack_[0].value.as < int32_t > ());
	}
#line 3617 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 421: // sm83_bit: "bit" reloc_3bit "," reg_r
#line 1904 "asm/parser.y"
                                        {
		uint8_t mask = static_cast<uint8_t>(0x40 | yystack_[0].value.as < int32_t > ());
		yystack_[2].value.as < Expression > ().addCheckBitIndex(mask);
		sect_ConstByte(0xCB);
		if (!yystack_[2].value.as < Expression > ().isKnown()) {
			sect_RelByte(yystack_[2].value.as < Expression > (), 0);
		} else {
			sect_ConstByte(mask | (yystack_[2].value.as < Expression > ().value() << 3));
		}
	}
#line 3632 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 422: // sm83_call: "call" reloc_16bit
#line 1917 "asm/parser.y"
                              {
		sect_ConstByte(0xCD);
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3641 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 423: // sm83_call: "call" ccode_expr "," reloc_16bit
#line 1921 "asm/parser.y"
                                                 {
		sect_ConstByte(0xC4 | (yystack_[2].value.as < int32_t > () << 3));
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3650 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 424: // sm83_ccf: "ccf"
#line 1928 "asm/parser.y"
                 {
		sect_ConstByte(0x3F);
	}
#line 3658 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 425: // sm83_cp: "cp" op_a_n
#line 1934 "asm/parser.y"
                       {
		sect_ConstByte(0xFE);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3667 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 426: // sm83_cp: "cp" op_a_r
#line 1938 "asm/parser.y"
                         {
		sect_ConstByte(0xB8 | yystack_[0].value.as < int32_t > ());
	}
#line 3675 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 427: // sm83_cpl: "cpl"
#line 1944 "asm/parser.y"
                 {
		sect_ConstByte(0x2F);
	}
#line 3683 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 428: // sm83_cpl: "cpl" MODE_A
#line 1947 "asm/parser.y"
                          {
		sect_ConstByte(0x2F);
	}
#line 3691 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 429: // sm83_daa: "daa"
#line 1953 "asm/parser.y"
                 {
		sect_ConstByte(0x27);
	}
#line 3699 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 430: // sm83_dec: "dec" reg_r
#line 1959 "asm/parser.y"
                       {
		sect_ConstByte(0x05 | (yystack_[0].value.as < int32_t > () << 3));
	}
#line 3707 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 431: // sm83_dec: "dec" reg_ss
#line 1962 "asm/parser.y"
                          {
		sect_ConstByte(0x0B | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 3715 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 432: // sm83_di: "di"
#line 1968 "asm/parser.y"
                {
		sect_ConstByte(0xF3);
	}
#line 3723 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 433: // sm83_ei: "ei"
#line 1974 "asm/parser.y"
                {
		sect_ConstByte(0xFB);
	}
#line 3731 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 434: // sm83_halt: "halt"
#line 1980 "asm/parser.y"
                  {
		sect_ConstByte(0x76);
	}
#line 3739 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 435: // sm83_inc: "inc" reg_r
#line 1986 "asm/parser.y"
                       {
		sect_ConstByte(0x04 | (yystack_[0].value.as < int32_t > () << 3));
	}
#line 3747 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 436: // sm83_inc: "inc" reg_ss
#line 1989 "asm/parser.y"
                          {
		sect_ConstByte(0x03 | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 3755 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 437: // sm83_jp: "jp" reloc_16bit
#line 1995 "asm/parser.y"
                            {
		sect_ConstByte(0xC3);
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3764 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 438: // sm83_jp: "jp" ccode_expr "," reloc_16bit
#line 1999 "asm/parser.y"
                                               {
		sect_ConstByte(0xC2 | (yystack_[2].value.as < int32_t > () << 3));
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3773 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 439: // sm83_jp: "jp" "hl"
#line 2003 "asm/parser.y"
                          {
		sect_ConstByte(0xE9);
	}
#line 3781 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 440: // sm83_jr: "jr" reloc_16bit
#line 2009 "asm/parser.y"
                            {
		sect_ConstByte(0x18);
		sect_PCRelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3790 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 441: // sm83_jr: "jr" ccode_expr "," reloc_16bit
#line 2013 "asm/parser.y"
                                               {
		sect_ConstByte(0x20 | (yystack_[2].value.as < int32_t > () << 3));
		sect_PCRelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3799 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 442: // sm83_ldi: "ldi" "[" "hl" "]" "," MODE_A
#line 2020 "asm/parser.y"
                                                    {
		sect_ConstByte(0x02 | (2 << 4));
	}
#line 3807 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 443: // sm83_ldi: "ldi" MODE_A "," "[" "hl" "]"
#line 2023 "asm/parser.y"
                                                      {
		sect_ConstByte(0x0A | (2 << 4));
	}
#line 3815 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 444: // sm83_ldd: "ldd" "[" "hl" "]" "," MODE_A
#line 2029 "asm/parser.y"
                                                    {
		sect_ConstByte(0x02 | (3 << 4));
	}
#line 3823 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 445: // sm83_ldd: "ldd" MODE_A "," "[" "hl" "]"
#line 2032 "asm/parser.y"
                                                      {
		sect_ConstByte(0x0A | (3 << 4));
	}
#line 3831 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 446: // sm83_ldh: "ldh" MODE_A "," op_mem_ind
#line 2038 "asm/parser.y"
                                         {
		yystack_[0].value.as < Expression > ().addCheckHRAM();
		sect_ConstByte(0xF0);
		if (!yystack_[0].value.as < Expression > ().isKnown()) {
			sect_RelByte(yystack_[0].value.as < Expression > (), 1);
		} else {
			sect_ConstByte(yystack_[0].value.as < Expression > ().value());
		}
	}
#line 3845 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 447: // sm83_ldh: "ldh" op_mem_ind "," MODE_A
#line 2047 "asm/parser.y"
                                           {
		yystack_[2].value.as < Expression > ().addCheckHRAM();
		sect_ConstByte(0xE0);
		if (!yystack_[2].value.as < Expression > ().isKnown()) {
			sect_RelByte(yystack_[2].value.as < Expression > (), 1);
		} else {
			sect_ConstByte(yystack_[2].value.as < Expression > ().value());
		}
	}
#line 3859 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 448: // sm83_ldh: "ldh" MODE_A "," c_ind
#line 2056 "asm/parser.y"
                                      {
		sect_ConstByte(0xF2);
	}
#line 3867 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 449: // sm83_ldh: "ldh" MODE_A "," ff00_c_ind
#line 2059 "asm/parser.y"
                                           {
		sect_ConstByte(0xF2);
	}
#line 3875 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 450: // sm83_ldh: "ldh" c_ind "," MODE_A
#line 2062 "asm/parser.y"
                                      {
		sect_ConstByte(0xE2);
	}
#line 3883 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 451: // sm83_ldh: "ldh" ff00_c_ind "," MODE_A
#line 2065 "asm/parser.y"
                                           {
		sect_ConstByte(0xE2);
	}
#line 3891 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 453: // ff00_c_ind: "[" relocexpr "+" MODE_C "]"
#line 2073 "asm/parser.y"
                                              {
		// This has to use `relocexpr`, not `iconst`, to avoid a shift/reduce conflict
		if (yystack_[3].value.as < Expression > ().getConstVal() != 0xFF00) {
			::error("Base value must be equal to $FF00 for [$FF00+C]");
		}
	}
#line 3902 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 462: // sm83_ld_hl: "ld" "hl" "," "sp" op_sp_offset
#line 2093 "asm/parser.y"
                                                   {
		sect_ConstByte(0xF8);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3911 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 463: // sm83_ld_hl: "ld" "hl" "," reloc_16bit
#line 2097 "asm/parser.y"
                                            {
		sect_ConstByte(0x01 | (REG_HL << 4));
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3920 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 464: // sm83_ld_hl: "ld" "hl" "," reg_tt_no_af
#line 2101 "asm/parser.y"
                                             {
		::error(
		    "\"LD HL, %s\" is not a valid instruction; use \"LD H, %s\" and \"LD L, %s\"",
		    reg_tt_names[yystack_[0].value.as < int32_t > ()],
		    reg_tt_high_names[yystack_[0].value.as < int32_t > ()],
		    reg_tt_low_names[yystack_[0].value.as < int32_t > ()]
		);
	}
#line 3933 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 465: // sm83_ld_sp: "ld" "sp" "," "hl"
#line 2112 "asm/parser.y"
                                      {
		sect_ConstByte(0xF9);
	}
#line 3941 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 466: // sm83_ld_sp: "ld" "sp" "," reg_bc_or_de
#line 2115 "asm/parser.y"
                                             {
		::error("\"LD SP, %s\" is not a valid instruction", reg_tt_names[yystack_[0].value.as < int32_t > ()]);
	}
#line 3949 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 467: // sm83_ld_sp: "ld" "sp" "," reloc_16bit
#line 2118 "asm/parser.y"
                                            {
		sect_ConstByte(0x01 | (REG_SP << 4));
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3958 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 468: // sm83_ld_mem: "ld" op_mem_ind "," "sp"
#line 2125 "asm/parser.y"
                                         {
		sect_ConstByte(0x08);
		sect_RelWord(yystack_[2].value.as < Expression > (), 1);
	}
#line 3967 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 469: // sm83_ld_mem: "ld" op_mem_ind "," MODE_A
#line 2129 "asm/parser.y"
                                          {
		sect_ConstByte(0xEA);
		sect_RelWord(yystack_[2].value.as < Expression > (), 1);
	}
#line 3976 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 470: // sm83_ld_c_ind: "ld" ff00_c_ind "," MODE_A
#line 2136 "asm/parser.y"
                                        {
		sect_ConstByte(0xE2);
	}
#line 3984 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 471: // sm83_ld_rr: "ld" reg_rr "," MODE_A
#line 2142 "asm/parser.y"
                                    {
		sect_ConstByte(0x02 | (yystack_[2].value.as < int32_t > () << 4));
	}
#line 3992 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 472: // sm83_ld_r_no_a: "ld" reg_r_no_a "," reloc_8bit
#line 2148 "asm/parser.y"
                                            {
		sect_ConstByte(0x06 | (yystack_[2].value.as < int32_t > () << 3));
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4001 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 473: // sm83_ld_r_no_a: "ld" reg_r_no_a "," reg_r
#line 2152 "asm/parser.y"
                                         {
		if (yystack_[2].value.as < int32_t > () == REG_HL_IND && yystack_[0].value.as < int32_t > () == REG_HL_IND) {
			::error("\"LD [HL], [HL]\" is not a valid instruction");
		} else {
			sect_ConstByte(0x40 | (yystack_[2].value.as < int32_t > () << 3) | yystack_[0].value.as < int32_t > ());
		}
	}
#line 4013 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 474: // sm83_ld_a: "ld" reg_a "," reloc_8bit
#line 2162 "asm/parser.y"
                                       {
		sect_ConstByte(0x06 | (yystack_[2].value.as < int32_t > () << 3));
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4022 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 475: // sm83_ld_a: "ld" reg_a "," reg_r
#line 2166 "asm/parser.y"
                                    {
		sect_ConstByte(0x40 | (yystack_[2].value.as < int32_t > () << 3) | yystack_[0].value.as < int32_t > ());
	}
#line 4030 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 476: // sm83_ld_a: "ld" reg_a "," ff00_c_ind
#line 2169 "asm/parser.y"
                                         {
		sect_ConstByte(0xF2);
	}
#line 4038 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 477: // sm83_ld_a: "ld" reg_a "," reg_rr
#line 2172 "asm/parser.y"
                                     {
		sect_ConstByte(0x0A | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 4046 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 478: // sm83_ld_a: "ld" reg_a "," op_mem_ind
#line 2175 "asm/parser.y"
                                         {
		sect_ConstByte(0xFA);
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 4055 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 479: // sm83_ld_ss: "ld" reg_bc_or_de "," reloc_16bit
#line 2182 "asm/parser.y"
                                               {
		sect_ConstByte(0x01 | (yystack_[2].value.as < int32_t > () << 4));
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 4064 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 480: // sm83_ld_ss: "ld" reg_bc_or_de "," reg_tt_no_af
#line 2186 "asm/parser.y"
                                                  {
		::error(
		    "\"LD %s, %s\" is not a valid instruction; use \"LD %s, %s\" and \"LD %s, %s\"",
		    reg_tt_names[yystack_[2].value.as < int32_t > ()],
		    reg_tt_names[yystack_[0].value.as < int32_t > ()],
		    reg_tt_high_names[yystack_[2].value.as < int32_t > ()],
		    reg_tt_high_names[yystack_[0].value.as < int32_t > ()],
		    reg_tt_low_names[yystack_[2].value.as < int32_t > ()],
		    reg_tt_low_names[yystack_[0].value.as < int32_t > ()]
		);
	}
#line 4080 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 481: // sm83_nop: "nop"
#line 2202 "asm/parser.y"
                 {
		sect_ConstByte(0x00);
	}
#line 4088 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 482: // sm83_or: "or" op_a_n
#line 2208 "asm/parser.y"
                       {
		sect_ConstByte(0xF6);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4097 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 483: // sm83_or: "or" op_a_r
#line 2212 "asm/parser.y"
                         {
		sect_ConstByte(0xB0 | yystack_[0].value.as < int32_t > ());
	}
#line 4105 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 484: // sm83_pop: "pop" reg_tt
#line 2218 "asm/parser.y"
                        {
		sect_ConstByte(0xC1 | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 4113 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 485: // sm83_push: "push" reg_tt
#line 2224 "asm/parser.y"
                         {
		sect_ConstByte(0xC5 | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 4121 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 486: // sm83_res: "res" reloc_3bit "," reg_r
#line 2230 "asm/parser.y"
                                        {
		uint8_t mask = static_cast<uint8_t>(0x80 | yystack_[0].value.as < int32_t > ());
		yystack_[2].value.as < Expression > ().addCheckBitIndex(mask);
		sect_ConstByte(0xCB);
		if (!yystack_[2].value.as < Expression > ().isKnown()) {
			sect_RelByte(yystack_[2].value.as < Expression > (), 0);
		} else {
			sect_ConstByte(mask | (yystack_[2].value.as < Expression > ().value() << 3));
		}
	}
#line 4136 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 487: // sm83_ret: "ret"
#line 2243 "asm/parser.y"
                 {
		sect_ConstByte(0xC9);
	}
#line 4144 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 488: // sm83_ret: "ret" ccode_expr
#line 2246 "asm/parser.y"
                              {
		sect_ConstByte(0xC0 | (yystack_[0].value.as < int32_t > () << 3));
	}
#line 4152 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 489: // sm83_reti: "reti"
#line 2252 "asm/parser.y"
                  {
		sect_ConstByte(0xD9);
	}
#line 4160 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 490: // sm83_rl: "rl" reg_r
#line 2258 "asm/parser.y"
                      {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x10 | yystack_[0].value.as < int32_t > ());
	}
#line 4169 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 491: // sm83_rla: "rla"
#line 2265 "asm/parser.y"
                 {
		sect_ConstByte(0x17);
	}
#line 4177 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 492: // sm83_rlc: "rlc" reg_r
#line 2271 "asm/parser.y"
                       {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x00 | yystack_[0].value.as < int32_t > ());
	}
#line 4186 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 493: // sm83_rlca: "rlca"
#line 2278 "asm/parser.y"
                  {
		sect_ConstByte(0x07);
	}
#line 4194 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 494: // sm83_rr: "rr" reg_r
#line 2284 "asm/parser.y"
                      {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x18 | yystack_[0].value.as < int32_t > ());
	}
#line 4203 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 495: // sm83_rra: "rra"
#line 2291 "asm/parser.y"
                 {
		sect_ConstByte(0x1F);
	}
#line 4211 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 496: // sm83_rrc: "rrc" reg_r
#line 2297 "asm/parser.y"
                       {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x08 | yystack_[0].value.as < int32_t > ());
	}
#line 4220 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 497: // sm83_rrca: "rrca"
#line 2304 "asm/parser.y"
                  {
		sect_ConstByte(0x0F);
	}
#line 4228 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 498: // sm83_rst: "rst" reloc_8bit
#line 2310 "asm/parser.y"
                            {
		yystack_[0].value.as < Expression > ().addCheckRST();
		if (!yystack_[0].value.as < Expression > ().isKnown()) {
			sect_RelByte(yystack_[0].value.as < Expression > (), 0);
		} else {
			sect_ConstByte(0xC7 | yystack_[0].value.as < Expression > ().value());
		}
	}
#line 4241 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 499: // sm83_sbc: "sbc" op_a_n
#line 2321 "asm/parser.y"
                        {
		sect_ConstByte(0xDE);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4250 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 500: // sm83_sbc: "sbc" op_a_r
#line 2325 "asm/parser.y"
                          {
		sect_ConstByte(0x98 | yystack_[0].value.as < int32_t > ());
	}
#line 4258 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 501: // sm83_scf: "scf"
#line 2331 "asm/parser.y"
                 {
		sect_ConstByte(0x37);
	}
#line 4266 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 502: // sm83_set: "set" reloc_3bit "," reg_r
#line 2337 "asm/parser.y"
                                        {
		uint8_t mask = static_cast<uint8_t>(0xC0 | yystack_[0].value.as < int32_t > ());
		yystack_[2].value.as < Expression > ().addCheckBitIndex(mask);
		sect_ConstByte(0xCB);
		if (!yystack_[2].value.as < Expression > ().isKnown()) {
			sect_RelByte(yystack_[2].value.as < Expression > (), 0);
		} else {
			sect_ConstByte(mask | (yystack_[2].value.as < Expression > ().value() << 3));
		}
	}
#line 4281 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 503: // sm83_sla: "sla" reg_r
#line 2350 "asm/parser.y"
                       {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x20 | yystack_[0].value.as < int32_t > ());
	}
#line 4290 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 504: // sm83_sra: "sra" reg_r
#line 2357 "asm/parser.y"
                       {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x28 | yystack_[0].value.as < int32_t > ());
	}
#line 4299 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 505: // sm83_srl: "srl" reg_r
#line 2364 "asm/parser.y"
                       {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x38 | yystack_[0].value.as < int32_t > ());
	}
#line 4308 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 506: // sm83_stop: "stop"
#line 2371 "asm/parser.y"
                  {
		sect_ConstByte(0x10);
		sect_ConstByte(0x00);
	}
#line 4317 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 507: // sm83_stop: "stop" reloc_8bit
#line 2375 "asm/parser.y"
                               {
		sect_ConstByte(0x10);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4326 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 508: // sm83_sub: "sub" op_a_n
#line 2382 "asm/parser.y"
                        {
		sect_ConstByte(0xD6);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4335 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 509: // sm83_sub: "sub" op_a_r
#line 2386 "asm/parser.y"
                          {
		sect_ConstByte(0x90 | yystack_[0].value.as < int32_t > ());
	}
#line 4343 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 510: // sm83_swap: "swap" reg_r
#line 2392 "asm/parser.y"
                        {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x30 | yystack_[0].value.as < int32_t > ());
	}
#line 4352 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 511: // sm83_xor: "xor" op_a_n
#line 2399 "asm/parser.y"
                        {
		sect_ConstByte(0xEE);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4361 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 512: // sm83_xor: "xor" op_a_r
#line 2403 "asm/parser.y"
                          {
		sect_ConstByte(0xA8 | yystack_[0].value.as < int32_t > ());
	}
#line 4369 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 513: // op_mem_ind: "[" reloc_16bit "]"
#line 2411 "asm/parser.y"
                                  {
		yylhs.value.as < Expression > () = std::move(yystack_[1].value.as < Expression > ());
	}
#line 4377 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 514: // op_a_r: reg_r
#line 2417 "asm/parser.y"
          { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4383 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 515: // op_a_r: MODE_A "," reg_r
#line 2418 "asm/parser.y"
                             {
		yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > ();
	}
#line 4391 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 516: // op_a_n: reloc_8bit
#line 2424 "asm/parser.y"
                   {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
	}
#line 4399 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 517: // op_a_n: MODE_A "," reloc_8bit
#line 2427 "asm/parser.y"
                                  {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
	}
#line 4407 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 518: // op_sp_offset: "+" relocexpr
#line 2433 "asm/parser.y"
                         {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
		yylhs.value.as < Expression > ().checkNBit(8);
	}
#line 4416 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 519: // op_sp_offset: "-" relocexpr
#line 2437 "asm/parser.y"
                           {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_NEG, std::move(yystack_[0].value.as < Expression > ()));
		yylhs.value.as < Expression > ().checkNBit(8);
	}
#line 4425 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 520: // op_sp_offset: %empty
#line 2441 "asm/parser.y"
                 {
		::error("\"LD HL, SP\" is not a valid instruction; use \"LD HL, SP + 0\"");
	}
#line 4433 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 552: // ccode_expr: ccode
#line 2507 "asm/parser.y"
          { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4439 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 553: // ccode_expr: "!" ccode_expr
#line 2508 "asm/parser.y"
                                 {
		yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > () ^ 1;
	}
#line 4447 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 554: // ccode: "nz"
#line 2514 "asm/parser.y"
              {
		yylhs.value.as < int32_t > () = CC_NZ;
	}
#line 4455 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 555: // ccode: "z"
#line 2517 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = CC_Z;
	}
#line 4463 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 556: // ccode: "nc"
#line 2520 "asm/parser.y"
                {
		yylhs.value.as < int32_t > () = CC_NC;
	}
#line 4471 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 557: // ccode: "c"
#line 2523 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = CC_C;
	}
#line 4479 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 558: // reg_r: reg_r_no_a
#line 2528 "asm/parser.y"
       { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4485 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 559: // reg_r: reg_a
#line 2528 "asm/parser.y"
                    { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4491 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 560: // reg_r_no_a: MODE_B
#line 2531 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = REG_B;
	}
#line 4499 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 561: // reg_r_no_a: MODE_C
#line 2534 "asm/parser.y"
                 {
		yylhs.value.as < int32_t > () = REG_C;
	}
#line 4507 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 562: // reg_r_no_a: MODE_D
#line 2537 "asm/parser.y"
                 {
		yylhs.value.as < int32_t > () = REG_D;
	}
#line 4515 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 563: // reg_r_no_a: MODE_E
#line 2540 "asm/parser.y"
                 {
		yylhs.value.as < int32_t > () = REG_E;
	}
#line 4523 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 564: // reg_r_no_a: MODE_H
#line 2543 "asm/parser.y"
                 {
		yylhs.value.as < int32_t > () = REG_H;
	}
#line 4531 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 565: // reg_r_no_a: MODE_L
#line 2546 "asm/parser.y"
                 {
		yylhs.value.as < int32_t > () = REG_L;
	}
#line 4539 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 566: // reg_r_no_a: "[" "hl" "]"
#line 2549 "asm/parser.y"
                                {
		yylhs.value.as < int32_t > () = REG_HL_IND;
	}
#line 4547 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 567: // reg_a: MODE_A
#line 2555 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = REG_A;
	}
#line 4555 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 568: // reg_tt: reg_tt_no_af
#line 2561 "asm/parser.y"
        { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4561 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 569: // reg_tt: "af"
#line 2562 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = REG_AF;
	}
#line 4569 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 570: // reg_ss: reg_tt_no_af
#line 2568 "asm/parser.y"
        { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4575 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 571: // reg_ss: "sp"
#line 2569 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = REG_SP;
	}
#line 4583 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 572: // reg_tt_no_af: reg_bc_or_de
#line 2575 "asm/parser.y"
        { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4589 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 573: // reg_tt_no_af: "hl"
#line 2576 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = REG_HL;
	}
#line 4597 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 574: // reg_bc_or_de: "bc"
#line 2582 "asm/parser.y"
                {
		yylhs.value.as < int32_t > () = REG_BC;
	}
#line 4605 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 575: // reg_bc_or_de: "de"
#line 2585 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = REG_DE;
	}
#line 4613 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 576: // reg_rr: "[" "bc" "]"
#line 2591 "asm/parser.y"
                              {
		yylhs.value.as < int32_t > () = REG_BC_IND;
	}
#line 4621 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 577: // reg_rr: "[" "de" "]"
#line 2594 "asm/parser.y"
                                {
		yylhs.value.as < int32_t > () = REG_DE_IND;
	}
#line 4629 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 578: // reg_rr: hl_ind_inc
#line 2597 "asm/parser.y"
                     {
		yylhs.value.as < int32_t > () = REG_HL_INDINC;
	}
#line 4637 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 579: // reg_rr: hl_ind_dec
#line 2600 "asm/parser.y"
                     {
		yylhs.value.as < int32_t > () = REG_HL_INDDEC;
	}
#line 4645 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;


#line 4649 "/build/rgbds/src/rgbds/src/asm/parser.cpp"

            default:
              break;
            }
        }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
        {
          YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
          error (yyexc);
          YYERROR;
        }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, YY_MOVE (yylhs));
    }
    goto yynewstate;


  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        context yyctx (*this, yyla);
        std::string msg = yysyntax_error_ (yyctx);
        error (YY_MOVE (msg));
      }


    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.kind () == symbol_kind::S_YYEOF)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();
    goto yyerrlab1;


  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    // Pop stack until we find a state that shifts the error token.
    for (;;)
      {
        yyn = yypact_[+yystack_[0].state];
        if (!yy_pact_value_is_default_ (yyn))
          {
            yyn += symbol_kind::S_YYerror;
            if (0 <= yyn && yyn <= yylast_
                && yycheck_[yyn] == symbol_kind::S_YYerror)
              {
                yyn = yytable_[yyn];
                if (0 < yyn)
                  break;
              }
          }

        // Pop the current state because it cannot handle the error token.
        if (yystack_.size () == 1)
          YYABORT;

        yy_destroy_ ("Error: popping", yystack_[0]);
        yypop_ ();
        YY_STACK_PRINT ();
      }
    {
      stack_symbol_type error_token;


      // Shift the error token.
      yy_lac_discard_ ("error recovery");
      error_token.state = state_type (yyn);
      yypush_ ("Shifting", YY_MOVE (error_token));
    }
    goto yynewstate;


  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;


  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;


  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    YY_STACK_PRINT ();
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
#if YY_EXCEPTIONS
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
        // Do not try to display the values of the reclaimed symbols,
        // as their printers might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
#endif // YY_EXCEPTIONS
  }

  void
  parser::error (const syntax_error& yyexc)
  {
    error (yyexc.what ());
  }

  const char *
  parser::symbol_name (symbol_kind_type yysymbol)
  {
    static const char *const yy_sname[] =
    {
    "end of file", "error", "invalid token", "end of line", "end of buffer",
  "end of fragment literal", ",", ":", "::", "[", "]", "[[", "]]", "(",
  ")", "?", "+", "-", "*", "/", "%", "**", "++", "===", "!==", "==", "!=",
  "<", ">", "<=", ">=", "&&", "||", "!", "&", "|", "^", "<<", ">>", ">>>",
  "~", "NEG", "=", "+=", "-=", "*=", "/=", "%=", "&=", "|=", "^=", "<<=",
  ">>=", "a", "b", "c", "d", "e", "h", "l", "af", "bc", "de", "hl", "sp",
  "hli/hl+", "hld/hl-", "z", "nz", "nc", "adc", "add", "and", "bit",
  "call", "ccf", "cp", "cpl", "daa", "dec", "di", "ei", "halt", "inc",
  "jp", "jr", "ldd", "ldh", "ldi", "ld", "nop", "or", "pop", "push", "res",
  "reti", "ret", "rla", "rlca", "rlc", "rl", "rra", "rrca", "rrc", "rr",
  "rst", "sbc", "scf", "set", "sla", "sra", "srl", "stop", "sub", "swap",
  "xor", "ALIGN", "ASSERT", "BREAK", "CHARMAP", "DB", "DL", "DS", "DW",
  "ELIF", "ELSE", "ENDC", "ENDL", "ENDM", "ENDR", "ENDSECTION", "ENDU",
  "EQU", "EQUS", "EXPORT", "FAIL", "FATAL", "FOR", "FRAGMENT", "IF",
  "INCBIN", "INCLUDE", "LOAD", "MACRO", "NEWCHARMAP", "NEXTU", "OPT",
  "POPC", "POPO", "POPS", "PRINTLN", "PRINT", "PURGE", "PUSHC", "PUSHO",
  "PUSHS", "RB", "REDEF", "REPT", "RSRESET", "RSSET", "RW", "SECTION",
  "SETCHARMAP", "SHIFT", "STATIC_ASSERT", "UNION", "WARN", "ACOS", "ASIN",
  "ATAN", "ATAN2", "BANK", "BITWIDTH", "BYTELEN", "CEIL", "CHARCMP",
  "CHARLEN", "CHARSIZE", "CHARSUB", "CHARVAL", "COS", "DEF", "FDIV",
  "FLOOR", "FMOD", "FMUL", "HIGH", "INCHARMAP", "ISCONST", "LOG", "LOW",
  "POW", "READFILE", "REVCHAR", "ROUND", "SIN", "SIZEOF", "STARTOF",
  "STRBYTE", "STRCAT", "STRCHAR", "STRCMP", "STRFIND", "STRFMT", "STRIN",
  "STRLEN", "STRLWR", "STRRFIND", "STRRIN", "STRRPL", "STRSLICE", "STRSUB",
  "STRUPR", "TAN", "TZCOUNT", "HRAM", "OAM", "ROM0", "ROMX", "SRAM",
  "VRAM", "WRAM0", "WRAMX", "number", "string", "character", "symbol",
  "label", "local label", "anonymous label", "quiet macro", "$accept",
  "asm_file", "lines", "$@1", "diff_mark", "line", "endofline",
  "line_directive", "if", "elif", "else", "plain_directive", "endc",
  "def_id", "$@2", "redef_id", "$@3", "scoped_sym_no_anon", "scoped_sym",
  "label", "macro_invocation", "$@4", "$@5", "macro_args", "directive",
  "def_numeric", "trailing_comma", "compound_eq", "align", "align_spec",
  "opt", "$@6", "opt_list", "opt_list_entry", "popo", "pusho", "$@7",
  "pusho_opt_list", "pops", "pushs", "endsection", "fail", "warn",
  "assert_type", "assert", "shift", "shift_const", "load", "maybe_quiet",
  "rept", "for", "$@8", "$@9", "capture_rept", "for_args", "break",
  "macro_def", "$@10", "$@11", "capture_macro", "rsset", "rsreset",
  "rs_uconst", "union", "nextu", "endu", "def_equ", "redef_equ", "def_set",
  "def_rb", "def_rw", "def_rl", "def_equs", "redef_equs", "purge", "$@12",
  "purge_args", "export", "export_list", "export_list_entry", "export_def",
  "include", "incbin", "charmap", "charmap_args", "newcharmap",
  "setcharmap", "pushc", "pushc_setcharmap", "popc", "print", "println",
  "print_exprs", "print_expr", "reloc_3bit", "constlist_8bit",
  "constlist_8bit_entry", "constlist_16bit", "constlist_16bit_entry",
  "constlist_32bit", "constlist_32bit_entry", "reloc_8bit", "reloc_16bit",
  "fragment_literal", "fragment_literal_name", "relocexpr",
  "relocexpr_no_str", "$@13", "uconst", "iconst", "precision_arg",
  "string_literal", "string", "strcat_args", "strfmt_args",
  "strfmt_va_args", "section", "pushs_section", "sect_mod", "sect_type",
  "sect_org", "sect_attrs", "data", "datum", "ds", "ds_args", "db", "dw",
  "dl", "sm83_adc", "sm83_add", "sm83_and", "sm83_bit", "sm83_call",
  "sm83_ccf", "sm83_cp", "sm83_cpl", "sm83_daa", "sm83_dec", "sm83_di",
  "sm83_ei", "sm83_halt", "sm83_inc", "sm83_jp", "sm83_jr", "sm83_ldi",
  "sm83_ldd", "sm83_ldh", "c_ind", "ff00_c_ind", "sm83_ld", "sm83_ld_hl",
  "sm83_ld_sp", "sm83_ld_mem", "sm83_ld_c_ind", "sm83_ld_rr",
  "sm83_ld_r_no_a", "sm83_ld_a", "sm83_ld_ss", "sm83_nop", "sm83_or",
  "sm83_pop", "sm83_push", "sm83_res", "sm83_ret", "sm83_reti", "sm83_rl",
  "sm83_rla", "sm83_rlc", "sm83_rlca", "sm83_rr", "sm83_rra", "sm83_rrc",
  "sm83_rrca", "sm83_rst", "sm83_sbc", "sm83_scf", "sm83_set", "sm83_sla",
  "sm83_sra", "sm83_srl", "sm83_stop", "sm83_sub", "sm83_swap", "sm83_xor",
  "op_mem_ind", "op_a_r", "op_a_n", "op_sp_offset", "MODE_R8", "MODE_R16",
  "MODE_A", "MODE_B", "MODE_C", "MODE_D", "MODE_E", "MODE_H", "MODE_L",
  "ccode_expr", "ccode", "reg_r", "reg_r_no_a", "reg_a", "reg_tt",
  "reg_ss", "reg_tt_no_af", "reg_bc_or_de", "reg_rr", "hl_ind_inc",
  "hl_ind_dec", YY_NULLPTR
    };
    return yy_sname[yysymbol];
  }



  // parser::context.
  parser::context::context (const parser& yyparser, const symbol_type& yyla)
    : yyparser_ (yyparser)
    , yyla_ (yyla)
  {}

  int
  parser::context::expected_tokens (symbol_kind_type yyarg[], int yyargn) const
  {
    // Actual number of expected tokens
    int yycount = 0;

#if YYDEBUG
    // Execute LAC once. We don't care if it is successful, we
    // only do it for the sake of debugging output.
    if (!yyparser_.yy_lac_established_)
      yyparser_.yy_lac_check_ (yyla_.kind ());
#endif

    for (int yyx = 0; yyx < YYNTOKENS; ++yyx)
      {
        symbol_kind_type yysym = YY_CAST (symbol_kind_type, yyx);
        if (yysym != symbol_kind::S_YYerror
            && yysym != symbol_kind::S_YYUNDEF
            && yyparser_.yy_lac_check_ (yysym))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = yysym;
          }
      }
    if (yyarg && yycount == 0 && 0 < yyargn)
      yyarg[0] = symbol_kind::S_YYEMPTY;
    return yycount;
  }




  bool
  parser::yy_lac_check_ (symbol_kind_type yytoken) const
  {
    // Logically, the yylac_stack's lifetime is confined to this function.
    // Clear it, to get rid of potential left-overs from previous call.
    yylac_stack_.clear ();
    // Reduce until we encounter a shift and thereby accept the token.
#if YYDEBUG
    YYCDEBUG << "LAC: checking lookahead " << symbol_name (yytoken) << ':';
#endif
    std::ptrdiff_t lac_top = 0;
    while (true)
      {
        state_type top_state = (yylac_stack_.empty ()
                                ? yystack_[lac_top].state
                                : yylac_stack_.back ());
        int yyrule = yypact_[+top_state];
        if (yy_pact_value_is_default_ (yyrule)
            || (yyrule += yytoken) < 0 || yylast_ < yyrule
            || yycheck_[yyrule] != yytoken)
          {
            // Use the default action.
            yyrule = yydefact_[+top_state];
            if (yyrule == 0)
              {
                YYCDEBUG << " Err\n";
                return false;
              }
          }
        else
          {
            // Use the action from yytable.
            yyrule = yytable_[yyrule];
            if (yy_table_value_is_error_ (yyrule))
              {
                YYCDEBUG << " Err\n";
                return false;
              }
            if (0 < yyrule)
              {
                YYCDEBUG << " S" << yyrule << '\n';
                return true;
              }
            yyrule = -yyrule;
          }
        // By now we know we have to simulate a reduce.
        YYCDEBUG << " R" << yyrule - 1;
        // Pop the corresponding number of values from the stack.
        {
          std::ptrdiff_t yylen = yyr2_[yyrule];
          // First pop from the LAC stack as many tokens as possible.
          std::ptrdiff_t lac_size = std::ptrdiff_t (yylac_stack_.size ());
          if (yylen < lac_size)
            {
              yylac_stack_.resize (std::size_t (lac_size - yylen));
              yylen = 0;
            }
          else if (lac_size)
            {
              yylac_stack_.clear ();
              yylen -= lac_size;
            }
          // Only afterwards look at the main stack.
          // We simulate popping elements by incrementing lac_top.
          lac_top += yylen;
        }
        // Keep top_state in sync with the updated stack.
        top_state = (yylac_stack_.empty ()
                     ? yystack_[lac_top].state
                     : yylac_stack_.back ());
        // Push the resulting state of the reduction.
        state_type state = yy_lr_goto_state_ (top_state, yyr1_[yyrule]);
        YYCDEBUG << " G" << int (state);
        yylac_stack_.push_back (state);
      }
  }

  // Establish the initial context if no initial context currently exists.
  bool
  parser::yy_lac_establish_ (symbol_kind_type yytoken)
  {
    /* Establish the initial context for the current lookahead if no initial
       context is currently established.

       We define a context as a snapshot of the parser stacks.  We define
       the initial context for a lookahead as the context in which the
       parser initially examines that lookahead in order to select a
       syntactic action.  Thus, if the lookahead eventually proves
       syntactically unacceptable (possibly in a later context reached via a
       series of reductions), the initial context can be used to determine
       the exact set of tokens that would be syntactically acceptable in the
       lookahead's place.  Moreover, it is the context after which any
       further semantic actions would be erroneous because they would be
       determined by a syntactically unacceptable token.

       yy_lac_establish_ should be invoked when a reduction is about to be
       performed in an inconsistent state (which, for the purposes of LAC,
       includes consistent states that don't know they're consistent because
       their default reductions have been disabled).

       For parse.lac=full, the implementation of yy_lac_establish_ is as
       follows.  If no initial context is currently established for the
       current lookahead, then check if that lookahead can eventually be
       shifted if syntactic actions continue from the current context.  */
    if (yy_lac_established_)
      return true;
    else
      {
#if YYDEBUG
        YYCDEBUG << "LAC: initial context established for "
                 << symbol_name (yytoken) << '\n';
#endif
        yy_lac_established_ = true;
        return yy_lac_check_ (yytoken);
      }
  }

  // Discard any previous initial lookahead context.
  void
  parser::yy_lac_discard_ (const char* event)
  {
   /* Discard any previous initial lookahead context because of Event,
      which may be a lookahead change or an invalidation of the currently
      established initial context for the current lookahead.

      The most common example of a lookahead change is a shift.  An example
      of both cases is syntax error recovery.  That is, a syntax error
      occurs when the lookahead is syntactically erroneous for the
      currently established initial context, so error recovery manipulates
      the parser stacks to try to find a new initial context in which the
      current lookahead is syntactically acceptable.  If it fails to find
      such a context, it discards the lookahead.  */
    if (yy_lac_established_)
      {
        YYCDEBUG << "LAC: initial context discarded due to "
                 << event << '\n';
        yy_lac_established_ = false;
      }
  }


  int
  parser::yy_syntax_error_arguments_ (const context& yyctx,
                                                 symbol_kind_type yyarg[], int yyargn) const
  {
    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
         In the first two cases, it might appear that the current syntax
         error should have been detected in the previous state when
         yy_lac_check was invoked.  However, at that time, there might
         have been a different syntax error that discarded a different
         initial context during error recovery, leaving behind the
         current lookahead.
    */

    if (!yyctx.lookahead ().empty ())
      {
        if (yyarg)
          yyarg[0] = yyctx.token ();
        int yyn = yyctx.expected_tokens (yyarg ? yyarg + 1 : yyarg, yyargn - 1);
        return yyn + 1;
      }
    return 0;
  }

  // Generate an error message.
  std::string
  parser::yysyntax_error_ (const context& yyctx) const
  {
    // Its maximum.
    enum { YYARGS_MAX = 5 };
    // Arguments of yyformat.
    symbol_kind_type yyarg[YYARGS_MAX];
    int yycount = yy_syntax_error_arguments_ (yyctx, yyarg, YYARGS_MAX);

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
      default: // Avoid compiler warnings.
        YYCASE_ (0, YY_("syntax error"));
        YYCASE_ (1, YY_("syntax error, unexpected %s"));
        YYCASE_ (2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_ (3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_ (4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_ (5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    std::ptrdiff_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += symbol_name (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const short parser::yypact_ninf_ = -735;

  const short parser::yytable_ninf_ = -331;

  const short
  parser::yypact_[] =
  {
    1320,  -735,    25,   290,   396,  -735,  -735,  -735,    60,  -735,
    -735,  -735,  -735,  -735,  3985,    48,   396,  -735,  3985,  -735,
      42,   328,   356,  -735,  -735,  -735,  -735,  -735,   396,  -735,
    4146,  -735,  -735,  -735,  -735,  -735,  3985,  3985,  3985,  3985,
    3985,    49,    75,   107,   122,   131,   141,   143,   146,   158,
     180,   197,   211,   250,   269,   271,  -735,   278,   297,   308,
     327,   329,   347,   401,   420,   422,   440,   454,   457,   469,
     471,   478,   487,   500,   506,   511,   516,   530,   532,   537,
     557,   571,   583,   603,   615,   624,   626,   628,   629,   649,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,   407,   926,
    -735,   136,   630,   690,  -735,  -735,    42,   247,    42,  -735,
    3985,  -735,  -735,  -735,  -735,  -735,  1990,  1921,  1990,  3985,
    2486,  -735,  1990,   -32,  -735,   294,  -735,  -735,  -735,   294,
    1021,  2486,    17,    26,    27,   334,  -735,  1990,   598,   598,
    3985,  -735,    41,  -735,  -735,   274,   274,  -735,  -735,   274,
     274,  3985,  1990,  -735,  3985,   274,   274,   274,  3985,  1990,
     274,  1990,  3985,   -22,   396,  1082,  3985,  3985,  3678,  3103,
    -735,  -735,  -735,   -76,  1138,  1138,    42,   -90,   -44,  -735,
    -735,  -735,  -735,  -735,  3985,  3985,  -735,    32,  -735,    36,
    -735,  -735,  3985,   -90,   233,  3985,   -22,  -735,  1138,  -735,
    -735,  -735,   646,   490,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,   279,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  1542,   657,   657,   657,
     657,   582,  3985,  3985,  3985,  3985,  1138,  3985,  1138,  3985,
    1138,  1138,  1138,  1138,  1138,  3985,   669,  3985,  3985,  3985,
    3985,  3985,  1138,  3985,  3985,  3985,  3985,  1138,  3985,  3985,
    3985,  1481,  1404,  1138,    15,  1138,  1138,  1138,  1138,  1138,
    1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  3985,  3985,
    3985,  3985,  3985,  3985,  3985,  3985,  3985,  3985,  3985,  3985,
    3985,  3985,  3985,  3985,  3985,  3985,  3985,  3985,  3985,  3985,
    -735,  1138,  1138,  1138,   456,  -735,   460,   696,  -735,   638,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,   689,   693,  -735,
     926,  -735,  -735,   702,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,   703,   715,  -735,  -735,  -735,  -735,   717,
     926,  -735,  3306,  -735,  -735,  -735,  -735,  -735,  -735,   926,
     730,  -735,  -735,  -735,   724,  -735,  -735,  -735,  -735,  -735,
     741,   742,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,   758,  -735,   759,   704,   763,  3034,   764,   765,   771,
     789,   735,   793,  2281,   794,   798,   799,   802,   811,   812,
     814,   815,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
     825,    41,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
     826,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,   829,   830,   831,   832,  3985,  -735,   835,  -735,  -735,
      69,   243,   837,  -735,   926,   621,   399,   451,   838,  -735,
     714,   493,   836,   841,   553,   842,  -735,  -735,   744,   575,
     818,   187,  -735,  -735,   843,  -735,   828,    80,  1138,  -735,
    -735,  1138,   845,   631,   662,   848,  -735,   722,   739,   848,
     531,  -735,   631,  1138,   632,  -735,  1138,  -735,  -735,  -735,
    3985,   828,   644,  -735,  -735,  3985,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  3985,  3985,  1138,  3985,
    3985,  3985,  3985,  3985,  1138,  3985,  3077,  -735,   844,   849,
     849,   849,   866,   859,   860,   828,  1704,    81,   849,   109,
     184,   198,   160,   126,   849,   582,   869,   849,   870,   871,
    1766,   263,  2036,   872,  2299,   873,   538,    44,  -735,   849,
     849,   609,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,   295,   867,   874,   875,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,   340,   876,
     170,  -735,   828,   298,   173,   174,   195,   828,   877,   199,
     398,   412,   201,   246,   275,   286,   312,   444,   849,  2334,
     468,   468,   657,   657,   657,   657,   237,   237,   237,   237,
     237,   237,  1930,  2573,   754,   754,   754,   795,   795,   795,
    -735,   828,   828,  -735,  -735,  -735,   882,  3375,  3578,  1990,
     762,  3985,   274,  1762,  -735,  3103,   823,   767,   670,  3103,
    3103,   884,   888,   885,   889,  1790,   890,   -32,   -32,   -32,
     892,   893,   895,   896,   897,   596,   898,   899,  2555,  2760,
     -32,   -26,  1990,  2212,  2829,   -32,   274,   274,  3985,  -735,
    -735,  -735,  1488,  3985,  3985,  3985,  -735,  3985,  -735,  3985,
    3985,  3103,  -735,   531,  -735,  3985,   165,   339,   658,  -735,
     631,  -735,  3985,  -735,  -735,  -735,   880,   631,  -735,   388,
    -735,   402,   904,  -735,   677,   677,  -735,  -735,  -735,  -735,
     828,  -735,  -735,  -735,  -735,  -735,   828,  -735,  -735,  -735,
    3985,   891,   900,   906,  3985,  -735,  -735,  -735,  -735,   907,
    1138,  -735,  -735,  3985,  3985,  -735,   909,   912,  3985,   913,
    3985,  3985,  -735,  -735,  -735,  3985,  -735,  3985,  3985,  -735,
    3985,  -735,   914,   916,   901,   902,   640,  -735,  -735,  -735,
    -735,  -735,  -735,  3985,  1138,  -735,  3985,  1138,  1138,   925,
    -735,  1138,  -735,  -735,  1138,  1138,  1138,  3985,  3985,  -735,
     923,  -735,   943,   910,   396,  -735,   952,   953,   955,   956,
     958,   961,   962,  -735,  -735,  -735,  -735,  -735,   968,  -735,
    -735,  -735,   976,   920,  3782,  -735,  3881,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,   978,   922,  -735,  -735,   977,   979,
    -735,  -735,   447,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  1138,   980,   980,  -735,  -735,   981,
    -735,   982,  -735,  -735,   984,  -735,   565,  -735,  -735,  -735,
     531,  -735,   565,   565,  1138,  -735,  -735,  -735,  -735,  -735,
     849,  -735,   498,   985,   986,  -735,  -735,   849,  -735,   849,
     849,   849,   849,   988,  -735,  -735,  -735,  -735,  -735,  -735,
     989,   828,   990,   508,   509,  3985,   540,   550,   551,   403,
     560,   579,  -735,  3985,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,   -32,   983,   996,   -32,   997,  -735,
    -735,  3985,  3985,  -735,   828,  3985,  -735,  -735,  1002,  3985,
    -735,  3985,   987,  -735,   987,   987,   828,   998,  -735,  -735,
    -735,   999,  1001,  1003,  1004,  1006,  -735,  -735,  -735,  -735,
    -735,   272,   588,   504,  -735,  -735,  -735,  1138,  3985,  -735,
    3985,  -735,   991,  1005,   396,  -735,  -735,  -735,  -735,  -735,
     926,   926,  3985,  -735,  -735,  -735,  3985,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,   581,  1007,  1008,  -735,
    3985,  -735,   982,  1000,  1010,  1010,  1010,  -735,  -735,  -735,
     396,  1017,  -735,  -735,   -85,  -735,  3985,  1015,  1016,  -735,
    3985,  3985,  1018,  1020,  -735,  -735
  };

  const short
  parser::yydefact_[] =
  {
       0,     5,     0,     7,     0,     1,     8,     9,    41,    12,
      13,    14,     6,    47,     0,     0,     0,   140,     0,   148,
     137,     0,    44,     4,    11,    20,    22,    23,     0,    21,
      27,    16,    17,    18,    15,    19,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   267,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     226,   303,   227,    36,    37,    38,    40,    39,   225,   300,
     223,     0,   224,     0,    26,    31,   137,     0,   137,   138,
       0,    42,    43,    45,    46,    10,     0,     0,     0,     0,
       0,   424,     0,   427,   429,     0,   432,   433,   434,     0,
       0,     0,     0,     0,     0,     0,   481,     0,     0,     0,
       0,   489,   487,   491,   493,     0,     0,   495,   497,     0,
       0,     0,     0,   501,     0,     0,     0,     0,   506,     0,
       0,     0,     0,   124,     0,     0,   407,   411,     0,   409,
     136,   121,   158,     0,     0,     0,   137,   333,     0,   157,
     109,   192,   114,   119,   194,     0,   170,   190,   115,   333,
      34,   153,     0,   333,     0,   133,   124,   156,     0,    32,
      48,    50,     0,     0,    29,    30,    76,    87,    86,    84,
      85,    80,    81,    83,    73,    74,    75,    72,    71,    60,
      59,    61,    62,    63,    88,    89,    90,    91,    92,    93,
      77,    78,    79,    56,    57,    64,    65,    66,    67,    68,
      70,    69,    54,    55,    58,    82,    28,   349,   354,   351,
     352,   353,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   374,   372,
     373,   371,   458,   459,   454,   455,   456,   460,   461,   457,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,     0,   251,   252,   230,
     253,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   325,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      25,     0,     0,     0,     0,    24,     0,     0,   299,     0,
     538,   540,   542,   544,   546,   548,   550,     0,     0,   516,
     218,   414,   413,   567,   560,   561,   562,   563,   564,   565,
     514,   558,   559,     0,     0,   416,   415,   420,   419,     0,
     201,   222,     0,   557,   555,   554,   556,   422,   220,   219,
       0,   552,   426,   425,     0,   428,   574,   575,   573,   571,
       0,     0,   567,   430,   431,   570,   572,   435,   436,   439,
     437,     0,   440,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   578,   579,   483,   482,   569,   484,   568,   485,
       0,     0,   488,   492,   490,   496,   494,   498,   500,   499,
       0,   503,   504,   505,   507,   509,   508,   510,   512,   511,
     106,   107,     0,     0,     0,     0,   147,     0,   322,   321,
       0,   225,    94,   202,     0,   223,   224,   225,    94,   213,
     223,   224,     0,   401,   225,    94,   207,   212,   223,   224,
       0,     0,   177,   178,    94,   175,   122,   180,     0,   335,
     334,     0,   187,     0,   225,    94,   196,   223,   224,    94,
       0,   191,   117,     0,     0,   152,     0,   189,   132,   134,
       0,   123,     0,    52,    52,     0,    96,    97,    98,    99,
     100,   103,   102,   101,   104,   105,   154,     0,     0,   154,
     154,     0,     0,     0,     0,     0,     0,   298,     0,   301,
     301,   301,     0,   322,   321,     0,     0,     0,   301,     0,
       0,     0,     0,     0,   301,     0,     0,   301,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   185,   301,
     301,     0,   533,   534,   535,   536,   537,   340,   343,   339,
     338,   342,   337,   336,   341,     0,     0,     0,     0,   521,
     522,   523,   524,   525,   526,   527,   531,   532,     0,     0,
       0,   314,   323,     0,     0,     0,     0,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   301,     0,
     239,   240,   247,   248,   249,   250,   233,   238,   235,   234,
     237,   236,   232,   231,   243,   242,   241,   244,   245,   246,
     304,   228,   229,   141,   149,   143,     0,     0,     0,     0,
       0,     0,     0,     0,   553,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   219,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   126,
     127,   125,   128,     0,     0,    95,   408,    95,   412,     0,
       0,    95,   410,    95,   174,     0,     0,     0,     0,   113,
     110,   111,    95,   195,   193,   172,    94,   118,   116,     0,
      35,     0,   130,    33,    49,    51,   161,   167,   155,   159,
     168,   165,   166,   163,   162,   160,   169,   164,   350,   320,
       0,     0,     0,     0,     0,   259,   260,   256,   290,     0,
       0,   291,   294,     0,     0,   296,     0,     0,     0,     0,
       0,     0,   254,   292,   258,     0,   255,     0,     0,   305,
       0,   313,     0,     0,     0,     0,     0,   261,   263,   265,
     266,   262,   264,     0,     0,   315,     0,     0,     0,   326,
     319,     0,   289,   317,     0,     0,     0,     0,     0,   316,
       0,   257,     0,     0,     0,   566,     0,     0,     0,     0,
       0,     0,     0,   517,   515,   417,   418,   421,     0,   423,
     438,   441,     0,     0,     0,   513,     0,   452,   450,   451,
     447,   448,   449,   446,     0,     0,   576,   577,     0,     0,
     580,   582,   520,   463,   464,   465,   467,   466,   470,   468,
     469,   472,   473,   474,   476,   478,   475,   477,   479,   480,
     471,   486,   502,   108,     0,    94,    94,   203,   214,     0,
     405,    94,   208,   176,   181,   179,     0,   188,   112,   197,
      95,   171,     0,     0,     0,    53,   302,   281,   280,   282,
     301,   270,     0,     0,     0,   278,   268,   301,   271,   301,
     301,   301,   301,     0,   186,   269,   277,   528,   529,   530,
       0,   324,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   279,     0,   151,   139,   539,   541,   545,   549,
     543,   547,   551,   221,     0,     0,     0,     0,     0,   581,
     583,     0,     0,   462,   129,    95,   184,   183,    94,    95,
     402,     0,   344,   173,   344,   344,   131,     0,   293,   312,
     295,     0,     0,     0,     0,     0,   306,   297,   311,   284,
     285,   225,   223,   224,   287,   286,   288,     0,     0,   308,
       0,   310,     0,   144,     0,   444,   445,   453,   442,   443,
     518,   519,    95,   403,   406,   182,     0,   346,   346,   346,
     283,   272,   274,   273,   276,   275,     0,     0,     0,   143,
       0,   150,    94,     0,   135,   332,   331,   318,   307,   309,
       0,   145,   404,   345,     0,   142,     0,     0,     0,   146,
       0,     0,     0,     0,   347,   348
  };

  const short
  parser::yypgoto_[] =
  {
    -735,   289,  -735,  -735,  -735,  -735,   -15,  -735,  -735,  -735,
    -735,  -735,  -735,   822,  -735,   853,  -735,  -164,    95,  -735,
    -735,  -735,  -735,   463,  -735,   858,  -407,  -193,  -735,  -734,
    -735,  -735,   481,  -675,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,   839,  -735,  -735,  -735,  -735,   -59,  -735,
    -735,  -735,  -735,   -23,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,    28,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,   287,
    -735,  -735,  -735,  -735,  -264,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,   854,   280,   -24,  -735,   296,  -735,   292,  -735,
     300,  -146,   -65,  -161,  -735,     6,  -113,  -735,  -108,   -14,
    -457,   750,   803,  -735,  -735,  -735,  -735,  -735,  -165,  -312,
    -394,  -501,   458,  -735,  -735,     3,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,   330,  -132,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,  -735,
    -735,  -735,  -735,  -735,  -735,  -128,   -54,   -40,  -735,  -735,
    -735,  -100,   708,  -327,   710,   711,   712,   716,    58,  -735,
     -56,   921,   924,   919,  -118,  -119,  -129,   331,   726,   728
  };

  const short
  parser::yydefgoto_[] =
  {
       0,     2,     3,     4,     8,    23,    12,    24,    25,    26,
      27,    28,    29,   202,   562,   203,   554,    97,    98,    30,
     204,   563,   564,   774,   205,   206,   746,   581,   207,   500,
     208,   543,   760,   761,   209,   210,   552,   768,   211,   212,
     213,   214,   215,   505,   216,   217,   558,   218,   110,    31,
      32,   106,   852,   854,  1032,    33,    34,   108,   853,  1034,
     219,   220,   777,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   550,   766,   233,   534,   535,
     234,    35,   235,   236,   617,   237,   238,   239,   240,   241,
     242,   243,   545,   546,   419,   512,   513,   525,   526,   518,
     519,   399,   714,   428,   703,    99,   100,   326,   501,   388,
     791,   102,   103,   653,   658,   839,   244,   245,   541,   636,
    1047,  1064,   246,   247,   248,   921,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   457,   458,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   459,   401,   402,   993,   637,
     638,   442,   404,   405,   406,   407,   408,   409,   704,   431,
     410,   411,   412,   477,   444,   445,   446,   471,   472,   473
  };

  const short
  parser::yytable_[] =
  {
     101,   105,   387,   466,   107,   487,   470,   467,   527,   532,
     585,   448,   494,   115,   641,   919,   403,   403,   403,   478,
     478,   390,   403,   435,   553,     5,   454,   390,   556,   651,
     649,  1077,   455,   460,   462,   456,   461,   403,   899,  -120,
    -120,  -120,   306,   307,   308,   309,   310,   384,   539,   386,
     820,   104,   403,   515,   520,   427,   528,   109,   821,   403,
     523,   403,   311,   415,   417,   450,   452,    13,   432,   443,
     390,   547,   547,   447,   481,   744,   540,   416,   418,   390,
     390,   190,   433,   474,   555,   928,   755,  1078,   312,   483,
     484,   381,   928,   485,   486,   798,   423,   475,   488,   491,
     492,   493,   381,   381,   497,   495,   199,   498,   424,   425,
     426,   748,   489,   502,   503,   800,   480,   538,   752,   496,
     313,   499,   400,   400,   400,   420,   429,   754,   400,   716,
     490,   381,   804,   792,   793,   314,   429,   429,   763,   380,
     805,   799,   764,   400,   315,   504,   420,   806,   381,   506,
     809,    93,    94,    95,   316,   434,   317,   400,   400,   318,
     420,   434,   822,   823,   400,   400,   803,   400,     9,    10,
      11,   319,   514,   514,   539,   514,   833,    41,   430,   836,
     837,   559,   381,   542,    14,    15,    16,   381,   451,   453,
     514,   514,   381,   320,    53,   381,   381,    17,   801,    18,
     482,   838,   540,    19,   434,   841,   381,   844,    67,    68,
     321,   850,   802,   434,   434,    74,    75,   381,    20,    78,
     381,   381,    81,   381,   322,    84,    85,    86,    87,   582,
     566,   567,   568,   569,   570,   571,   572,   573,   574,   575,
      91,   639,    93,    94,    95,    96,  -206,  -206,  -206,  -206,
     385,  -206,   845,   360,   361,   362,   363,   364,   365,   551,
     508,   511,   517,   323,   524,  -322,  -322,  -322,   381,   508,
     508,   374,   375,   376,   377,   378,   379,   813,  -330,   544,
     544,   846,   324,   389,   325,   381,  -330,   586,    21,    22,
      -2,   327,   847,   508,  -322,  -322,  -322,   381,   589,   590,
     591,   592,    -2,   389,   834,   598,     6,     7,   381,   827,
     328,   604,   835,   606,   607,   608,   609,   381,   848,   583,
     613,   329,   615,   596,   618,   619,   620,   390,   391,   392,
     393,   394,   395,   396,   381,   111,   112,   610,   585,   612,
     330,   614,   331,   463,   668,   926,  1082,   390,   391,   392,
     393,   394,   395,   396,   831,   436,   437,   438,   439,   931,
     332,   381,   381,   113,   114,   669,   670,   671,   672,   673,
     674,   675,   676,   677,   678,   679,   680,   681,   682,   683,
     684,   685,   686,   687,   688,   689,   765,   390,   391,   392,
     393,   394,   395,   396,   932,   436,   437,   464,   465,     9,
      10,    11,  -205,  -205,  -205,  -205,   588,  -205,   933,  1027,
     381,   593,   842,   508,   333,   508,   508,   508,   508,   508,
     381,  -321,  -321,  -321,   381,   381,   843,   508,   309,  -322,
    -322,  -322,   508,   334,   381,   335,   508,   508,   508,   508,
     508,   508,   508,   508,   508,   508,   508,   508,   508,   508,
     508,   508,   508,   336,  -217,  -217,  -217,  -217,   849,  -217,
     557,   440,   715,   991,   992,   441,   381,   337,   778,   715,
     338,   778,   778,  -322,  -322,  -322,   508,   508,   508,   915,
     916,   440,   339,  1007,   340,   441,   362,   363,   364,   365,
    1011,   341,  1012,  1013,  1014,  1015,  -216,  -216,  -216,  -216,
     342,  -216,   374,   375,   376,   377,   378,   379,   996,   997,
    -329,   742,  1008,   343,  1000,  -321,  -321,  -321,  -329,   344,
     381,   440,  1019,  1020,   345,   441,  -321,  -321,  -321,   346,
     381,   381,   582,   566,   567,   568,   569,   570,   571,   572,
     573,   574,   575,   347,   818,   348,   772,  1065,  1066,   986,
     349,   776,   819,   863,  1024,   866,  -211,  -211,  -211,  -211,
     381,  -211,   381,   779,  1025,  1026,  1028,   783,   784,   785,
     350,   787,   381,   381,  1029,  -322,  -322,  -322,  -210,  -210,
    -210,  -210,   865,  -210,   351,  1030,   901,   903,   882,   532,
     527,  1043,   883,  1031,  -328,  1067,   352,  -321,  -321,  -321,
     897,   904,  -328,   381,   920,   905,   855,   781,   782,   894,
    1048,  1049,   888,   889,  1002,   909,   353,   878,   879,   880,
    1004,  1005,   583,   584,  -204,  -204,  -204,  -204,   354,  -204,
     898,   900,   515,   508,   520,   910,   508,   355,   528,   356,
     869,   357,   358,   864,   870,   871,   867,   924,   508,   547,
     959,   508,  -321,  -321,  -321,  1072,   888,   889,   476,   436,
     437,   438,   359,   893,   896,  -200,  -200,  -200,  -200,   908,
     824,   825,   826,   508,   726,   727,   902,   906,   365,   508,
     911,   912,   605,   693,  -322,  -322,  -322,   694,   565,   566,
     567,   568,   569,   570,   571,   572,   573,   574,   575,   695,
     807,   696,   697,   610,   614,   400,   698,   400,   699,   700,
     953,   429,   381,   382,   383,   429,   429,  -215,  -215,  -215,
    -215,   701,  -215,   702,   913,  -198,  -198,  -198,  -198,   618,
     618,   860,   861,   862,   429,   429,   705,   706,   400,   400,
     429,   925,  -199,  -199,  -199,  -199,   576,  -209,  -209,  -209,
    -209,   514,  -209,   514,   707,   708,   400,   514,    93,    94,
      95,  -321,  -321,  -321,   709,   710,  1003,   711,   514,   712,
     717,   718,   362,   363,   364,   365,   936,   719,   577,   578,
     940,   627,   628,   629,   630,   631,   632,   633,   634,   943,
     944,   377,   378,   379,   947,   720,   949,   950,   721,   722,
     728,   951,   579,   952,   729,   730,   954,   580,   731,    93,
      94,    95,    96,   362,   363,   364,   365,   732,   733,   960,
     734,   735,   962,   436,   437,   438,   439,   856,   857,   858,
     859,   736,   737,   970,   971,   738,   739,   740,   741,   975,
     511,   743,   517,   745,   747,   749,   524,   750,   751,   753,
     381,   758,  1022,  1044,   762,   790,   759,   544,   789,   770,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   773,   794,   795,   796,   808,   810,   811,   815,   817,
     614,   828,   670,   856,  1035,   927,   930,  1038,   829,   830,
     832,   840,   855,  1045,   872,   508,   920,   873,   874,   875,
     877,   456,   935,   884,   885,   937,   886,   887,   890,   891,
     934,   957,   958,   974,   938,   509,   516,   521,   576,   529,
     939,   941,  1058,   945,   509,   509,   946,   948,   955,   508,
     956,   965,   508,   508,   548,   548,   508,   972,  1063,   508,
     508,   508,   360,   361,   362,   363,   364,   365,   509,   973,
     577,   366,   367,   368,   369,   370,   371,   372,   373,  1033,
     374,   375,   376,   377,   378,   379,   976,   977,   510,   978,
     979,   514,   980,  1083,   579,   981,   982,   536,   537,   580,
     983,   954,   984,   985,   987,   988,   995,   989,   999,   990,
    1001,   998,   868,  1036,  1059,   530,  1046,  1040,  1041,  1009,
    1010,   561,  1016,  1017,  1018,   400,  1037,  1039,  1042,   508,
    1073,  1060,  1050,  1051,  1057,  1052,  1074,  1053,  1054,  1061,
    1055,  1068,  1069,  1076,  1080,  1081,   531,   775,  1084,   508,
    1085,   533,   421,   767,    36,   560,  1070,    37,    38,   549,
     923,   917,   929,   922,   788,  1062,  1071,   918,   400,   640,
     881,   642,   643,   644,   422,  1075,   468,   645,   479,   469,
    1021,    40,  1079,     0,   907,     0,   594,   646,   509,   647,
     509,   509,   509,   509,   509,     0,   423,     0,     0,     0,
       0,     0,   509,     0,   449,     0,     0,   509,   424,   425,
     426,   509,   509,   509,   509,   509,   509,   509,   509,   509,
     509,   509,   509,   509,   509,   509,   509,   509,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   595,
       0,   597,   508,   599,   600,   601,   602,   603,     0,     0,
       0,   509,   509,   509,     0,   611,     0,     0,     0,     0,
     616,     0,     0,     0,   635,   648,   650,   652,   654,   655,
     656,   657,   659,   660,   661,   662,   663,   664,   665,   666,
     667,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,   690,   691,   692,     0,     0,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,     0,     0,     0,
       0,     0,     0,     0,    41,    90,    91,    92,    93,    94,
      95,    96,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    53,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    67,    68,     0,     0,     0,
       0,     0,    74,    75,     0,     0,    78,     0,   509,    81,
       0,   509,    84,    85,    86,    87,     0,     0,     0,     0,
      41,     0,     0,   509,     0,     0,   509,    91,   507,    93,
      94,    95,    96,     0,     0,     0,     0,    53,     0,     0,
      -3,     1,     0,    -3,    -3,    -3,     0,    -3,   509,     0,
       0,    67,    68,     0,   509,     0,    -3,    -3,    74,    75,
       0,   756,    78,     0,   757,    81,     0,     0,    84,    85,
      86,    87,     0,     0,     0,     0,   769,     0,     0,   771,
       0,     0,     0,    91,     0,    93,    94,    95,    96,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   780,     0,     0,     0,     0,     0,   786,     0,     0,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,     0,     0,
      -3,    -3,     0,     0,    -3,    -3,     0,    -3,     0,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,     0,    -3,    -3,    -3,
      -3,     0,    -3,    -3,    -3,    -3,    -3,    -3,     0,     0,
     621,     0,     0,     0,   914,   516,     0,   521,     0,     0,
       0,   529,    -3,     0,   360,   361,   362,   363,   364,   365,
       0,     0,   548,   366,   367,   368,   369,   370,   371,   372,
     373,     0,   374,   375,   376,   377,   378,   379,     0,     0,
       0,     0,     0,     0,   390,   391,   392,   393,   394,   395,
     396,   622,   623,   624,   625,   626,     0,    -3,    -3,    -3,
     509,    -3,     0,     0,     0,     0,   587,     0,   360,   361,
     362,   363,   364,   365,     0,     0,    41,   366,   367,   368,
     369,   370,   371,   372,   373,     0,   374,   375,   376,   377,
     378,   379,     0,    53,   509,     0,     0,   509,   509,     0,
       0,   509,     0,     0,   509,   509,   509,    67,    68,     0,
       0,     0,     0,   942,    74,    75,     0,     0,    78,     0,
       0,    81,     0,     0,    84,    85,    86,    87,     0,     0,
     627,   628,   629,   630,   631,   632,   633,   634,     0,    91,
       0,    93,    94,    95,    96,     0,     0,   961,     0,     0,
     963,   964,     0,    41,   966,     0,     0,   967,   968,   969,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      53,     0,     0,     0,   509,     0,     0,     0,   440,     0,
       0,     0,   441,     0,    67,    68,     0,     0,     0,     0,
       0,    74,    75,     0,   509,    78,     0,     0,    81,     0,
       0,    84,    85,    86,    87,     0,     0,   627,   628,   629,
     630,   631,   632,   633,   634,     0,    91,     0,    93,    94,
      95,    96,     0,     0,     0,  1023,     0,   994,   797,     0,
     360,   361,   362,   363,   364,   365,     0,     0,     0,   366,
     367,   368,   369,   370,   371,   372,   373,  1006,   374,   375,
     376,   377,   378,   379,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     1,     0,    -3,    -3,    -3,     0,    -3,
       0,     0,     0,     0,    -3,     0,     0,   509,    -3,    -3,
     812,     0,   360,   361,   362,   363,   364,   365,     0,     0,
       0,   366,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,   376,   377,   378,   379,   876,   361,   362,   363,
     364,   365,     0,     0,     0,   366,   367,   368,   369,   370,
     371,   372,   373,     0,   374,   375,   376,   377,   378,   379,
    1056,     0,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
       0,     0,    -3,    -3,     0,     0,    -3,    -3,     0,    -3,
       0,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,     0,    -3,
      -3,    -3,    -3,     0,    -3,    -3,    -3,    -3,    -3,    -3,
     389,     0,     0,     0,    36,     0,     0,    37,    38,     0,
       0,     0,     0,     0,    -3,     0,   360,   361,   362,   363,
     364,   365,     0,     0,    39,   366,   367,   368,   369,   370,
     371,    40,     0,     0,   374,   375,   376,   377,   378,   379,
       0,     0,     0,     0,   390,   391,   392,   393,   394,   395,
     396,     0,     0,     0,   413,   414,     0,     0,     0,    -3,
      -3,    -3,     0,    -3,     0,     0,     0,     0,     0,   389,
       0,     0,     0,    36,     0,     0,    37,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    39,     0,     0,     0,     0,     0,     0,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   390,   391,   392,   393,   394,   395,   396,
     814,     0,   360,   361,   362,   363,   364,   365,     0,     0,
       0,   366,   367,   368,   369,   370,   371,   372,   373,     0,
     374,   375,   376,   377,   378,   379,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,     0,     0,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,   397,    62,
      63,    64,   398,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,     0,     0,     0,
       0,     0,     0,     0,     0,    90,    91,    92,    93,    94,
      95,    96,    41,     0,     0,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,   397,    62,    63,
      64,   398,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,     0,     0,     0,     0,
       0,     0,     0,     0,    90,    91,    92,    93,    94,    95,
      96,   463,     0,     0,     0,    36,     0,     0,    37,    38,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   390,   391,   392,   393,   394,
     395,   396,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   421,     0,    36,     0,     0,    37,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   816,    39,   360,   361,   362,   363,   364,
     365,    40,     0,     0,   366,   367,   368,   369,   370,   371,
     372,   373,     0,   374,   375,   376,   377,   378,   379,     0,
       0,     0,   723,   724,   725,     0,   726,   727,   851,     0,
     360,   361,   362,   363,   364,   365,     0,     0,     0,   366,
     367,   368,   369,   370,   371,   372,   373,     0,   374,   375,
     376,   377,   378,   379,    41,     0,     0,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,   397,
      62,    63,    64,   398,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,     0,     0,
       0,     0,     0,     0,     0,     0,    90,    91,    92,    93,
      94,    95,    96,    41,     0,     0,     0,     0,     0,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,   421,     0,    36,
       0,     0,    37,    38,     0,    90,    91,    92,    93,    94,
      95,    96,     0,     0,     0,     0,     0,     0,     0,   422,
       0,     0,     0,     0,     0,     0,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   423,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   424,   425,   426,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   421,     0,    36,     0,
       0,    37,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,   360,
     361,   362,   363,   364,   365,    40,     0,     0,   366,   367,
     368,   369,   370,   371,   372,     0,     0,   374,   375,   376,
     377,   378,   379,     0,     0,     0,   436,   437,   438,   892,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,     0,     0,     0,     0,     0,     0,     0,     0,
      90,    91,    92,    93,    94,    95,    96,    41,     0,     0,
       0,     0,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,   421,     0,    36,     0,     0,    37,    38,     0,    90,
      91,    92,    93,    94,    95,    96,     0,     0,     0,     0,
       0,     0,     0,    39,     0,     0,     0,     0,     0,     0,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   436,   437,   895,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     421,     0,    36,     0,     0,    37,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     436,   437,   438,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,     0,     0,     0,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,     0,     0,     0,     0,
       0,     0,     0,     0,    90,    91,    92,    93,    94,    95,
      96,    41,     0,     0,     0,     0,     0,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,   421,     0,    36,     0,     0,
      37,    38,     0,    90,    91,    92,    93,    94,    95,    96,
       0,     0,     0,     0,     0,     0,     0,    39,     0,     0,
       0,     0,     0,     0,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   392,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   421,     0,    36,     0,     0,    37,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    39,     0,     0,     0,
       0,     0,     0,    40,     0,     0,     0,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,     0,     0,     0,    41,   166,   167,   168,
     169,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,   713,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
       0,     0,     0,     0,     0,     0,     0,     0,    90,    91,
      92,    93,    94,    95,    96,    41,     0,     0,     0,     0,
       0,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    36,
       0,     0,    37,    38,     0,     0,     0,    90,    91,    92,
      93,    94,    95,    96,     0,     0,     0,     0,     0,   422,
       0,     0,     0,     0,     0,     0,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   423,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   424,   425,   426,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       0,    37,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   856,   857,   858,   859,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,     0,     0,     0,     0,     0,     0,     0,     0,
      90,    91,    92,    93,    94,    95,    96,    41,     0,     0,
       0,     0,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    36,     0,     0,    37,    38,     0,     0,     0,    90,
      91,    92,    93,    94,    95,    96,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,     0,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   860,
     861,   862,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    36,     0,     0,    37,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,     0,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,   522,    36,     0,     0,    37,    38,
       0,     0,    90,    91,    92,    93,    94,    95,    96,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,   860,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    36,     0,     0,    37,    38,     0,
       0,     0,    90,    91,    92,    93,    94,    95,    96,     0,
       0,     0,     0,     0,    39,     0,     0,     0,     0,     0,
       0,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   392,     0,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,     0,     0,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    36,     0,
       0,    37,    38,     0,     0,     0,    90,    91,    92,    93,
      94,    95,    96,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,     0,     0,     0,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,   713,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,     0,     0,     0,
       0,     0,     0,     0,     0,    90,    91,    92,    93,    94,
      95,    96,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,     0,     0,
       0,     0,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,     0,     0,     0,     0,     0,     0,     0,     0,    90,
      91,    92,    93,    94,    95,    96,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
       0,     0,     0,   170,     0,     0,   171,   172,     0,     0,
     173,   174,     0,     0,     0,     0,   175,   176,   177,     0,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,     0,   190,     0,   191,   192,     0,   193,   194,
     195,   196,   197,   198,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   200,     0,     0,     0,   201
  };

  const short
  parser::yycheck_[] =
  {
      14,    16,   110,   135,    18,   151,   135,   135,   169,   173,
     203,   129,   158,    28,   341,   749,   116,   117,   118,   138,
     139,    53,   122,   123,   189,     0,     9,    53,   193,    14,
     342,   116,   132,   133,   134,     9,     9,   137,    64,     3,
       4,     5,    36,    37,    38,    39,    40,   106,   138,   108,
       6,     3,   152,   166,   167,   120,   169,    15,    14,   159,
     168,   161,    13,   117,   118,   130,   131,     7,   122,   125,
      53,   184,   185,   129,    33,     6,   166,   117,   118,    53,
      53,   157,   122,   137,   192,   760,     6,   172,    13,   145,
     146,    22,   767,   149,   150,    14,    55,   137,   152,   155,
     156,   157,    22,    22,   160,   159,   182,   161,    67,    68,
      69,   518,   152,   135,   136,     6,   140,   176,   525,   159,
      13,   161,   116,   117,   118,   119,   120,   534,   122,   456,
     154,    22,     6,   590,   591,    13,   130,   131,   545,     3,
      14,   598,   549,   137,    13,   167,   140,   604,    22,   164,
     607,   227,   228,   229,    13,   187,    13,   151,   152,    13,
     154,   187,   619,   620,   158,   159,     6,   161,     3,     4,
       5,    13,   166,   167,   138,   169,     6,   162,   120,     6,
       6,   195,    22,   227,   124,   125,   126,    22,   130,   131,
     184,   185,    22,    13,   179,    22,    22,   137,    14,   139,
     142,     6,   166,   143,   187,     6,    22,     6,   193,   194,
      13,   668,    14,   187,   187,   200,   201,    22,   158,   204,
      22,    22,   207,    22,    13,   210,   211,   212,   213,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
     225,   341,   227,   228,   229,   230,     3,     4,     5,     6,
       3,     8,     6,    16,    17,    18,    19,    20,    21,   227,
     165,   166,   167,    13,   169,    22,    23,    24,    22,   174,
     175,    34,    35,    36,    37,    38,    39,    14,     6,   184,
     185,     6,    13,     9,    13,    22,    14,     8,   228,   229,
       0,    13,     6,   198,    22,    23,    24,    22,   312,   313,
     314,   315,    12,     9,     6,   319,    16,    17,    22,    14,
      13,   325,    14,   327,   328,   329,   330,    22,     6,   132,
     334,    13,   336,   317,   338,   339,   340,    53,    54,    55,
      56,    57,    58,    59,    22,     7,     8,   331,   531,   333,
      13,   335,    13,     9,   358,     6,  1080,    53,    54,    55,
      56,    57,    58,    59,    14,    61,    62,    63,    64,   766,
      13,    22,    22,     7,     8,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,   550,    53,    54,    55,
      56,    57,    58,    59,     6,    61,    62,    63,    64,     3,
       4,     5,     3,     4,     5,     6,   311,     8,     6,     6,
      22,   316,    14,   318,    13,   320,   321,   322,   323,   324,
      22,    22,    23,    24,    22,    22,    14,   332,   422,    22,
      23,    24,   337,    13,    22,    13,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,    13,     3,     4,     5,     6,    14,     8,
     227,   187,   456,    16,    17,   191,    22,    13,   576,   463,
      13,   579,   580,    22,    23,    24,   381,   382,   383,   743,
     744,   187,    13,   940,    13,   191,    18,    19,    20,    21,
     947,    13,   949,   950,   951,   952,     3,     4,     5,     6,
      13,     8,    34,    35,    36,    37,    38,    39,   915,   916,
       6,   505,    14,    13,   921,    22,    23,    24,    14,    13,
      22,   187,    14,    14,    13,   191,    22,    23,    24,    13,
      22,    22,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    13,     6,    13,   560,  1048,  1049,   876,
      13,   565,    14,   699,    14,   701,     3,     4,     5,     6,
      22,     8,    22,   577,    14,    14,     6,   581,   582,   583,
      13,   585,    22,    22,    14,    22,    23,    24,     3,     4,
       5,     6,   700,     8,    13,     6,   732,   733,   720,   753,
     751,   998,   720,    14,     6,    14,    13,    22,    23,    24,
     729,   733,    14,    22,   750,   733,    10,   579,   580,   728,
    1004,  1005,    16,    17,   926,   734,    13,   717,   718,   719,
     932,   933,   132,   133,     3,     4,     5,     6,    13,     8,
     730,   731,   745,   538,   747,   735,   541,    13,   751,    13,
     705,    13,    13,   699,   709,   710,   702,   755,   553,   762,
      10,   556,    22,    23,    24,  1062,    16,    17,    60,    61,
      62,    63,    13,   728,   729,     3,     4,     5,     6,   734,
      61,    62,    63,   578,    65,    66,   732,   733,    21,   584,
     736,   737,    13,   227,    22,    23,    24,   227,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,     3,
     605,    63,    13,   697,   698,   699,    13,   701,     6,     6,
     818,   705,    22,    23,    24,   709,   710,     3,     4,     5,
       6,     6,     8,     6,   738,     3,     4,     5,     6,   743,
     744,    61,    62,    63,   728,   729,     6,    13,   732,   733,
     734,   756,     3,     4,     5,     6,   100,     3,     4,     5,
       6,   745,     8,   747,    13,    13,   750,   751,   227,   228,
     229,    22,    23,    24,     6,     6,   930,    63,   762,     6,
       6,     6,    18,    19,    20,    21,   790,     6,   132,   133,
     794,   216,   217,   218,   219,   220,   221,   222,   223,   803,
     804,    37,    38,    39,   808,     6,   810,   811,    63,     6,
       6,   815,   156,   817,     6,     6,   820,   161,     6,   227,
     228,   229,   230,    18,    19,    20,    21,     6,     6,   833,
       6,     6,   836,    61,    62,    63,    64,    60,    61,    62,
      63,     6,     6,   847,   848,     6,     6,     6,     6,   854,
     745,     6,   747,     6,     6,     9,   751,     6,     6,     6,
      22,     6,   965,   999,     6,     6,   225,   762,    14,   227,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,   227,     6,    14,    14,     6,     6,     6,     6,     6,
     874,    14,   876,    60,   984,   227,     6,   987,    14,    14,
      14,    14,    10,  1001,    10,   800,  1042,     9,    13,    10,
      10,     9,   225,    10,     9,    14,    10,    10,    10,    10,
       6,    10,    10,     3,    14,   165,   166,   167,   100,   169,
      14,    14,  1030,    14,   174,   175,    14,    14,    14,   834,
      14,     6,   837,   838,   184,   185,   841,    14,  1046,   844,
     845,   846,    16,    17,    18,    19,    20,    21,   198,     6,
     132,    25,    26,    27,    28,    29,    30,    31,    32,   973,
      34,    35,    36,    37,    38,    39,    14,    14,   165,    14,
      14,   965,    14,  1081,   156,    14,    14,   174,   175,   161,
      12,   995,     6,    63,     6,    63,     6,    10,     6,    10,
       6,    10,   703,    10,     3,   173,     9,   991,   992,    14,
      14,   198,    14,    14,    14,   999,    10,    10,     6,   914,
      10,     6,    14,    14,  1028,    14,     6,    14,    14,  1034,
      14,    14,    14,     6,     9,     9,   173,   564,    10,   934,
      10,   173,    11,   552,    13,   196,  1059,    16,    17,   185,
     753,   745,   762,   751,   586,  1042,  1060,   747,  1042,   341,
     720,   341,   341,   341,    33,  1070,   135,   341,   139,   135,
     965,    40,  1076,    -1,   733,    -1,   316,   341,   318,   341,
     320,   321,   322,   323,   324,    -1,    55,    -1,    -1,    -1,
      -1,    -1,   332,    -1,    63,    -1,    -1,   337,    67,    68,
      69,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   316,
      -1,   318,  1027,   320,   321,   322,   323,   324,    -1,    -1,
      -1,   381,   382,   383,    -1,   332,    -1,    -1,    -1,    -1,
     337,    -1,    -1,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   162,   381,   382,   383,    -1,    -1,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   162,   224,   225,   226,   227,   228,
     229,   230,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   193,   194,    -1,    -1,    -1,
      -1,    -1,   200,   201,    -1,    -1,   204,    -1,   538,   207,
      -1,   541,   210,   211,   212,   213,    -1,    -1,    -1,    -1,
     162,    -1,    -1,   553,    -1,    -1,   556,   225,   226,   227,
     228,   229,   230,    -1,    -1,    -1,    -1,   179,    -1,    -1,
       0,     1,    -1,     3,     4,     5,    -1,     7,   578,    -1,
      -1,   193,   194,    -1,   584,    -1,    16,    17,   200,   201,
      -1,   538,   204,    -1,   541,   207,    -1,    -1,   210,   211,
     212,   213,    -1,    -1,    -1,    -1,   553,    -1,    -1,   556,
      -1,    -1,    -1,   225,    -1,   227,   228,   229,   230,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   578,    -1,    -1,    -1,    -1,    -1,   584,    -1,    -1,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,    -1,    -1,
     130,   131,    -1,    -1,   134,   135,    -1,   137,    -1,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,   167,    -1,    -1,
       9,    -1,    -1,    -1,     6,   745,    -1,   747,    -1,    -1,
      -1,   751,   182,    -1,    16,    17,    18,    19,    20,    21,
      -1,    -1,   762,    25,    26,    27,    28,    29,    30,    31,
      32,    -1,    34,    35,    36,    37,    38,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    -1,   227,   228,   229,
     800,   231,    -1,    -1,    -1,    -1,    14,    -1,    16,    17,
      18,    19,    20,    21,    -1,    -1,   162,    25,    26,    27,
      28,    29,    30,    31,    32,    -1,    34,    35,    36,    37,
      38,    39,    -1,   179,   834,    -1,    -1,   837,   838,    -1,
      -1,   841,    -1,    -1,   844,   845,   846,   193,   194,    -1,
      -1,    -1,    -1,   800,   200,   201,    -1,    -1,   204,    -1,
      -1,   207,    -1,    -1,   210,   211,   212,   213,    -1,    -1,
     216,   217,   218,   219,   220,   221,   222,   223,    -1,   225,
      -1,   227,   228,   229,   230,    -1,    -1,   834,    -1,    -1,
     837,   838,    -1,   162,   841,    -1,    -1,   844,   845,   846,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     179,    -1,    -1,    -1,   914,    -1,    -1,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,   194,    -1,    -1,    -1,    -1,
      -1,   200,   201,    -1,   934,   204,    -1,    -1,   207,    -1,
      -1,   210,   211,   212,   213,    -1,    -1,   216,   217,   218,
     219,   220,   221,   222,   223,    -1,   225,    -1,   227,   228,
     229,   230,    -1,    -1,    -1,   965,    -1,   914,    14,    -1,
      16,    17,    18,    19,    20,    21,    -1,    -1,    -1,    25,
      26,    27,    28,    29,    30,    31,    32,   934,    34,    35,
      36,    37,    38,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     1,    -1,     3,     4,     5,    -1,     7,
      -1,    -1,    -1,    -1,    12,    -1,    -1,  1027,    16,    17,
      14,    -1,    16,    17,    18,    19,    20,    21,    -1,    -1,
      -1,    25,    26,    27,    28,    29,    30,    31,    32,    -1,
      34,    35,    36,    37,    38,    39,    16,    17,    18,    19,
      20,    21,    -1,    -1,    -1,    25,    26,    27,    28,    29,
      30,    31,    32,    -1,    34,    35,    36,    37,    38,    39,
    1027,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
      -1,    -1,   130,   131,    -1,    -1,   134,   135,    -1,   137,
      -1,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,   167,
       9,    -1,    -1,    -1,    13,    -1,    -1,    16,    17,    -1,
      -1,    -1,    -1,    -1,   182,    -1,    16,    17,    18,    19,
      20,    21,    -1,    -1,    33,    25,    26,    27,    28,    29,
      30,    40,    -1,    -1,    34,    35,    36,    37,    38,    39,
      -1,    -1,    -1,    -1,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    63,    64,    -1,    -1,    -1,   227,
     228,   229,    -1,   231,    -1,    -1,    -1,    -1,    -1,     9,
      -1,    -1,    -1,    13,    -1,    -1,    16,    17,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    33,    -1,    -1,    -1,    -1,    -1,    -1,
      40,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    53,    54,    55,    56,    57,    58,    59,
      14,    -1,    16,    17,    18,    19,    20,    21,    -1,    -1,
      -1,    25,    26,    27,    28,    29,    30,    31,    32,    -1,
      34,    35,    36,    37,    38,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   224,   225,   226,   227,   228,
     229,   230,   162,    -1,    -1,    -1,    -1,    -1,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   224,   225,   226,   227,   228,   229,
     230,     9,    -1,    -1,    -1,    13,    -1,    -1,    16,    17,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    33,    -1,    -1,    -1,    -1,
      -1,    -1,    40,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    53,    54,    55,    56,    57,
      58,    59,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    11,    -1,    13,    -1,    -1,    16,    17,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    14,    33,    16,    17,    18,    19,    20,
      21,    40,    -1,    -1,    25,    26,    27,    28,    29,    30,
      31,    32,    -1,    34,    35,    36,    37,    38,    39,    -1,
      -1,    -1,    61,    62,    63,    -1,    65,    66,    14,    -1,
      16,    17,    18,    19,    20,    21,    -1,    -1,    -1,    25,
      26,    27,    28,    29,    30,    31,    32,    -1,    34,    35,
      36,    37,    38,    39,   162,    -1,    -1,    -1,    -1,    -1,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   224,   225,   226,   227,
     228,   229,   230,   162,    -1,    -1,    -1,    -1,    -1,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,    11,    -1,    13,
      -1,    -1,    16,    17,    -1,   224,   225,   226,   227,   228,
     229,   230,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    33,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    11,    -1,    13,    -1,
      -1,    16,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    33,    16,
      17,    18,    19,    20,    21,    40,    -1,    -1,    25,    26,
      27,    28,    29,    30,    31,    -1,    -1,    34,    35,    36,
      37,    38,    39,    -1,    -1,    -1,    61,    62,    63,    64,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   162,    -1,
      -1,    -1,    -1,    -1,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     224,   225,   226,   227,   228,   229,   230,   162,    -1,    -1,
      -1,    -1,    -1,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,    11,    -1,    13,    -1,    -1,    16,    17,    -1,   224,
     225,   226,   227,   228,   229,   230,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    33,    -1,    -1,    -1,    -1,    -1,    -1,
      40,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      11,    -1,    13,    -1,    -1,    16,    17,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    33,    -1,    -1,    -1,    -1,    -1,    -1,    40,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   224,   225,   226,   227,   228,   229,
     230,   162,    -1,    -1,    -1,    -1,    -1,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,    11,    -1,    13,    -1,    -1,
      16,    17,    -1,   224,   225,   226,   227,   228,   229,   230,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    33,    -1,    -1,
      -1,    -1,    -1,    -1,    40,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    55,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    11,    -1,    13,    -1,    -1,    16,
      17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    33,    -1,    -1,    -1,
      -1,    -1,    -1,    40,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,    -1,    -1,    -1,   162,   120,   121,   122,
     123,    -1,   168,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   224,   225,
     226,   227,   228,   229,   230,   162,    -1,    -1,    -1,    -1,
      -1,   168,   169,   170,   171,   172,   173,   174,   175,   176,
     177,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   215,    13,
      -1,    -1,    16,    17,    -1,    -1,    -1,   224,   225,   226,
     227,   228,   229,   230,    -1,    -1,    -1,    -1,    -1,    33,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,    -1,
      -1,    16,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    33,    -1,
      -1,    -1,    -1,    -1,    -1,    40,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    60,    61,    62,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   162,    -1,
      -1,    -1,    -1,    -1,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     224,   225,   226,   227,   228,   229,   230,   162,    -1,    -1,
      -1,    -1,    -1,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,    13,    -1,    -1,    16,    17,    -1,    -1,    -1,   224,
     225,   226,   227,   228,   229,   230,    -1,    -1,    -1,    -1,
      -1,    33,    -1,    -1,    -1,    -1,    -1,    -1,    40,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,
      62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    13,    -1,    -1,    16,    17,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    33,    -1,    -1,    -1,    -1,    -1,    -1,    40,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     162,    -1,    -1,    -1,    -1,    -1,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   116,    13,    -1,    -1,    16,    17,
      -1,    -1,   224,   225,   226,   227,   228,   229,   230,    -1,
      -1,    -1,    -1,    -1,    -1,    33,    -1,    -1,    -1,    -1,
      -1,    -1,    40,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     162,    -1,    -1,    61,    -1,    -1,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,    13,    -1,    -1,    16,    17,    -1,
      -1,    -1,   224,   225,   226,   227,   228,   229,   230,    -1,
      -1,    -1,    -1,    -1,    33,    -1,    -1,    -1,    -1,    -1,
      -1,    40,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    55,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,    13,    -1,
      -1,    16,    17,    -1,    -1,    -1,   224,   225,   226,   227,
     228,   229,   230,    -1,    -1,    -1,    -1,    -1,    33,    -1,
      -1,    -1,    -1,    -1,    -1,    40,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   224,   225,   226,   227,   228,
     229,   230,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   162,    -1,    -1,
      -1,    -1,    -1,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   224,
     225,   226,   227,   228,   229,   230,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
      -1,    -1,    -1,   127,    -1,    -1,   130,   131,    -1,    -1,
     134,   135,    -1,    -1,    -1,    -1,   140,   141,   142,    -1,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,   157,    -1,   159,   160,    -1,   162,   163,
     164,   165,   166,   167,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   227,    -1,    -1,    -1,   231
  };

  const short
  parser::yystos_[] =
  {
       0,     1,   233,   234,   235,     0,    16,    17,   236,     3,
       4,     5,   238,     7,   124,   125,   126,   137,   139,   143,
     158,   228,   229,   237,   239,   240,   241,   242,   243,   244,
     251,   281,   282,   287,   288,   313,    13,    16,    17,    33,
      40,   162,   168,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     224,   225,   226,   227,   228,   229,   230,   249,   250,   337,
     338,   341,   343,   344,     3,   238,   283,   341,   289,    15,
     280,     7,     8,     7,     8,   238,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     127,   130,   131,   134,   135,   140,   141,   142,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     157,   159,   160,   162,   163,   164,   165,   166,   167,   182,
     227,   231,   245,   247,   252,   256,   257,   260,   262,   266,
     267,   270,   271,   272,   273,   274,   276,   277,   279,   292,
     293,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   309,   312,   314,   315,   317,   318,   319,
     320,   321,   322,   323,   348,   349,   354,   355,   356,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   337,   337,   337,   337,
     337,    13,    13,    13,    13,    13,    13,    13,    13,    13,
      13,    13,    13,    13,    13,    13,   339,    13,    13,    13,
      13,    13,    13,    13,    13,    13,    13,    13,    13,    13,
      13,    13,    13,    13,    13,    13,    13,    13,    13,    13,
      13,    13,    13,    13,    13,    13,    13,    13,    13,    13,
      16,    17,    18,    19,    20,    21,    25,    26,    27,    28,
      29,    30,    31,    32,    34,    35,    36,    37,    38,    39,
       3,    22,    23,    24,   280,     3,   280,   340,   341,     9,
      53,    54,    55,    56,    57,    58,    59,   187,   191,   333,
     337,   418,   419,   423,   424,   425,   426,   427,   428,   429,
     432,   433,   434,    63,    64,   418,   419,   418,   419,   326,
     337,    11,    33,    55,    67,    68,    69,   334,   335,   337,
     430,   431,   418,   419,   187,   423,    61,    62,    63,    64,
     187,   191,   423,   432,   436,   437,   438,   432,   436,    63,
     334,   430,   334,   430,     9,   423,     9,   380,   381,   417,
     423,     9,   423,     9,    63,    64,   381,   417,   433,   434,
     438,   439,   440,   441,   418,   419,    60,   435,   437,   435,
     326,    33,   430,   432,   432,   432,   432,   333,   418,   419,
     326,   432,   432,   432,   333,   418,   419,   432,   418,   419,
     261,   340,   135,   136,   167,   275,   238,   226,   250,   343,
     344,   250,   327,   328,   337,   338,   343,   250,   331,   332,
     338,   343,   116,   340,   250,   329,   330,   335,   338,   343,
     245,   247,   249,   257,   310,   311,   344,   344,   280,   138,
     166,   350,   227,   263,   250,   324,   325,   338,   343,   324,
     307,   227,   268,   350,   248,   340,   350,   227,   278,   341,
     275,   344,   246,   253,   254,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,   100,   132,   133,   156,
     161,   259,    42,   132,   133,   259,     8,    14,   250,   341,
     341,   341,   341,   250,   343,   344,   337,   344,   341,   344,
     344,   344,   344,   344,   341,    13,   341,   341,   341,   341,
     337,   344,   337,   341,   337,   341,   344,   316,   341,   341,
     341,     9,    60,    61,    62,    63,    64,   216,   217,   218,
     219,   220,   221,   222,   223,   344,   351,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   440,   441,   344,   351,
     344,    14,   344,   345,   344,   344,   344,   344,   346,   344,
     344,   344,   344,   344,   344,   344,   344,   344,   341,   337,
     337,   337,   337,   337,   337,   337,   337,   337,   337,   337,
     337,   337,   337,   337,   337,   337,   337,   337,   337,   337,
     344,   344,   344,   227,   227,     3,    63,    13,    13,     6,
       6,     6,     6,   336,   430,     6,    13,    13,    13,     6,
       6,    63,     6,   191,   334,   337,   425,     6,     6,     6,
       6,    63,     6,    61,    62,    63,    65,    66,     6,     6,
       6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
       6,     6,   337,     6,     6,     6,   258,     6,   258,     9,
       6,     6,   258,     6,   258,     6,   344,   344,     6,   225,
     264,   265,     6,   258,   258,   249,   308,   264,   269,   344,
     227,   344,   341,   227,   255,   255,   341,   294,   340,   341,
     344,   294,   294,   341,   341,   341,   344,   341,   354,    14,
       6,   342,   342,   342,     6,    14,    14,    14,    14,   342,
       6,    14,    14,     6,     6,    14,   342,   250,     6,   342,
       6,     6,    14,    14,    14,     6,    14,     6,     6,    14,
       6,    14,   342,   342,    61,    62,    63,    14,    14,    14,
      14,    14,    14,     6,     6,    14,     6,     6,     6,   347,
      14,     6,    14,    14,     6,     6,     6,     6,     6,    14,
     342,    14,   284,   290,   285,    10,    60,    61,    62,    63,
      61,    62,    63,   333,   432,   436,   333,   432,   233,   334,
     334,   334,    10,     9,    13,    10,    16,    10,   423,   423,
     423,   380,   381,   417,    10,     9,    10,    10,    16,    17,
      10,    10,    64,   334,   437,    63,   334,   438,   423,    64,
     423,   333,   432,   333,   381,   417,   432,   439,   334,   437,
     423,   432,   432,   341,     6,   316,   316,   328,   332,   261,
     333,   357,   330,   311,   340,   238,     6,   227,   265,   325,
       6,   258,     6,     6,     6,   225,   341,    14,    14,    14,
     341,    14,   344,   341,   341,    14,    14,   341,    14,   341,
     341,   341,   341,   340,   341,    14,    14,    10,    10,    10,
     341,   344,   341,   344,   344,     6,   344,   344,   344,   344,
     341,   341,    14,     6,     3,   238,    14,    14,    14,    14,
      14,    14,    14,    12,     6,    63,   425,     6,    63,    10,
      10,    16,    17,   420,   344,     6,   258,   258,    10,     6,
     258,     6,   351,   249,   351,   351,   344,   342,    14,    14,
      14,   342,   342,   342,   342,   342,    14,    14,    14,    14,
      14,   250,   338,   343,    14,    14,    14,     6,     6,    14,
       6,    14,   286,   341,   291,   423,    10,    10,   423,    10,
     337,   337,     6,   258,   333,   340,     9,   352,   352,   352,
      14,    14,    14,    14,    14,    14,   344,   341,   340,     3,
       6,   238,   357,   340,   353,   353,   353,    14,    14,    14,
     285,   341,   258,    10,     6,   238,     6,   116,   172,   341,
       9,     9,   261,   340,    10,    10
  };

  const short
  parser::yyr1_[] =
  {
       0,   232,   233,   234,   234,   235,   234,   236,   236,   236,
     237,   237,   238,   238,   238,   239,   239,   239,   239,   239,
     239,   239,   239,   239,   240,   241,   242,   243,   243,   243,
     243,   244,   246,   245,   248,   247,   249,   249,   249,   250,
     250,   251,   251,   251,   251,   251,   251,   251,   253,   252,
     254,   252,   255,   255,   256,   256,   256,   256,   256,   256,
     256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     256,   256,   256,   256,   256,   256,   256,   256,   257,   257,
     257,   257,   257,   257,   258,   258,   259,   259,   259,   259,
     259,   259,   259,   259,   259,   259,   260,   261,   261,   263,
     262,   264,   264,   265,   266,   268,   267,   269,   269,   270,
     271,   272,   273,   274,   275,   275,   275,   275,   276,   276,
     276,   276,   277,   278,   278,   279,   279,   280,   280,   281,
     283,   284,   282,   285,   286,   286,   286,   287,   289,   290,
     288,   291,   292,   293,   294,   294,   295,   296,   297,   298,
     299,   300,   300,   300,   300,   301,   302,   303,   304,   305,
     307,   306,   308,   308,   309,   310,   310,   311,   312,   313,
     314,   314,   314,   315,   315,   316,   316,   317,   317,   318,
     319,   320,   321,   322,   323,   323,   324,   324,   325,   325,
     325,   326,   327,   327,   328,   328,   328,   329,   329,   330,
     330,   330,   330,   331,   331,   332,   332,   332,   333,   334,
     334,   335,   336,   337,   337,   337,   338,   338,   338,   338,
     338,   338,   338,   338,   338,   338,   338,   338,   338,   338,
     338,   338,   338,   338,   338,   338,   338,   338,   338,   338,
     338,   338,   338,   338,   338,   338,   338,   338,   338,   338,
     338,   338,   338,   338,   338,   338,   338,   339,   338,   338,
     338,   338,   338,   338,   338,   338,   338,   338,   338,   338,
     338,   338,   338,   338,   338,   338,   338,   338,   338,   338,
     338,   338,   338,   338,   338,   338,   338,   338,   338,   340,
     341,   342,   342,   343,   343,   343,   343,   343,   343,   343,
     343,   343,   343,   343,   343,   343,   343,   343,   343,   343,
     343,   344,   344,   345,   345,   346,   346,   347,   347,   347,
     347,   348,   349,   350,   350,   350,   351,   351,   351,   351,
     351,   351,   351,   351,   352,   352,   353,   353,   353,   354,
     354,   355,   355,   355,   355,   355,   355,   355,   355,   355,
     355,   355,   355,   355,   355,   355,   355,   355,   355,   355,
     355,   355,   355,   355,   355,   355,   355,   355,   355,   355,
     355,   355,   355,   355,   355,   355,   355,   355,   355,   355,
     355,   355,   355,   355,   355,   355,   355,   355,   355,   355,
     355,   356,   356,   356,   356,   357,   357,   358,   358,   359,
     359,   360,   360,   361,   361,   362,   362,   362,   362,   363,
     363,   364,   365,   365,   366,   367,   367,   368,   368,   369,
     370,   370,   371,   372,   373,   374,   374,   375,   375,   375,
     376,   376,   377,   377,   378,   378,   379,   379,   379,   379,
     379,   379,   380,   381,   382,   382,   382,   382,   382,   382,
     382,   382,   383,   383,   383,   384,   384,   384,   385,   385,
     386,   387,   388,   388,   389,   389,   389,   389,   389,   390,
     390,   391,   392,   392,   393,   394,   395,   396,   396,   397,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     407,   408,   409,   410,   411,   412,   413,   413,   414,   414,
     415,   416,   416,   417,   418,   418,   419,   419,   420,   420,
     420,   421,   421,   421,   421,   421,   421,   421,   421,   421,
     421,   421,   421,   422,   422,   422,   422,   422,   423,   423,
     424,   424,   425,   425,   426,   426,   427,   427,   428,   428,
     429,   429,   430,   430,   431,   431,   431,   431,   432,   432,
     433,   433,   433,   433,   433,   433,   433,   434,   435,   435,
     436,   436,   437,   437,   438,   438,   439,   439,   439,   439,
     440,   440,   441,   441
  };

  const signed char
  parser::yyr2_[] =
  {
       0,     2,     1,     0,     3,     0,     3,     0,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     2,     1,     2,     2,
       2,     2,     0,     3,     0,     3,     1,     1,     1,     1,
       1,     0,     2,     2,     1,     2,     2,     1,     0,     3,
       0,     3,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     3,     0,
       3,     1,     2,     1,     1,     0,     3,     0,     1,     1,
       1,     1,     2,     2,     0,     2,     2,     2,     3,     5,
       3,     5,     2,     0,     1,     7,     1,     0,     1,     6,
       0,     0,    10,     0,     1,     3,     5,     3,     0,     0,
       8,     0,     2,     1,     0,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       0,     4,     1,     3,     3,     1,     3,     1,     2,     5,
       2,     4,     6,     5,     5,     1,     3,     2,     4,     2,
       1,     2,     1,     3,     1,     3,     1,     3,     1,     1,
       1,     1,     1,     3,     1,     1,     1,     1,     3,     1,
       1,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     4,     0,     1,     1,     1,     1,     1,     3,     3,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     2,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     0,     5,     5,
       5,     5,     7,     7,     7,     7,     7,     5,     5,     5,
       5,     5,     5,     7,     6,     6,     6,     6,     6,     4,
       4,     4,     4,     6,     4,     6,     4,     6,     3,     1,
       1,     0,     2,     1,     3,     4,     6,     8,     6,     8,
       6,     6,     6,     4,     3,     4,     4,     4,     8,     4,
       4,     1,     1,     1,     3,     0,     2,     0,     3,     3,
       3,     7,     7,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     3,     0,     6,     6,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     5,     6,     8,     1,     3,     1,     3,     1,
       3,     1,     3,     2,     2,     2,     2,     4,     4,     2,
       2,     4,     2,     4,     1,     2,     2,     1,     2,     1,
       2,     2,     1,     1,     1,     2,     2,     2,     4,     2,
       2,     4,     6,     6,     6,     6,     4,     4,     4,     4,
       4,     4,     3,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     1,     2,     2,     2,     2,     4,     1,     2,     1,
       2,     1,     2,     1,     2,     1,     2,     1,     2,     2,
       2,     1,     4,     2,     2,     2,     1,     2,     2,     2,
       2,     2,     2,     3,     1,     3,     1,     3,     2,     2,
       0,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     4,     1,     4,     1,     4,     1,     4,     1,     4,
       1,     4,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     3,     1,     1,
       3,     4,     3,     4
  };




#if YYDEBUG
  const short
  parser::yyrline_[] =
  {
       0,   414,   414,   417,   418,   420,   420,   429,   430,   436,
     447,   448,   451,   451,   451,   458,   459,   460,   461,   462,
     463,   464,   466,   467,   471,   477,   483,   491,   492,   493,
     494,   498,   504,   504,   513,   513,   521,   521,   521,   523,
     523,   526,   527,   530,   534,   537,   540,   544,   550,   550,
     556,   556,   565,   568,   575,   576,   577,   578,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,   598,   599,   600,
     601,   602,   603,   604,   605,   606,   607,   608,   612,   613,
     614,   615,   616,   617,   620,   620,   623,   626,   629,   632,
     635,   638,   641,   644,   647,   650,   656,   662,   665,   671,
     671,   678,   679,   683,   689,   695,   695,   703,   706,   710,
     716,   722,   728,   734,   740,   743,   746,   749,   755,   758,
     761,   764,   770,   780,   783,   787,   790,   796,   799,   805,
     813,   815,   813,   825,   831,   836,   841,   849,   857,   859,
     857,   869,   875,   881,   887,   890,   894,   900,   906,   912,
     919,   926,   930,   934,   938,   945,   954,   963,   972,   979,
     986,   986,   997,  1000,  1006,  1009,  1010,  1014,  1020,  1026,
    1034,  1039,  1044,  1052,  1055,  1061,  1064,  1071,  1074,  1080,
    1086,  1092,  1099,  1104,  1107,  1111,  1118,  1119,  1123,  1126,
    1130,  1140,  1147,  1148,  1152,  1156,  1160,  1176,  1177,  1181,
    1185,  1189,  1202,  1211,  1212,  1216,  1219,  1223,  1236,  1243,
    1247,  1253,  1260,  1267,  1270,  1273,  1287,  1290,  1293,  1296,
    1299,  1302,  1305,  1308,  1311,  1314,  1317,  1320,  1323,  1326,
    1329,  1332,  1335,  1338,  1341,  1344,  1347,  1350,  1353,  1356,
    1359,  1362,  1365,  1368,  1371,  1374,  1377,  1380,  1383,  1386,
    1390,  1393,  1396,  1399,  1402,  1405,  1408,  1411,  1411,  1417,
    1420,  1423,  1426,  1429,  1432,  1435,  1438,  1441,  1444,  1447,
    1450,  1453,  1456,  1459,  1462,  1465,  1469,  1473,  1478,  1483,
    1486,  1489,  1492,  1495,  1498,  1505,  1508,  1511,  1514,  1520,
    1529,  1535,  1538,  1548,  1551,  1555,  1562,  1569,  1572,  1575,
    1578,  1581,  1584,  1587,  1596,  1599,  1602,  1606,  1610,  1613,
    1616,  1622,  1625,  1635,  1638,  1645,  1646,  1653,  1654,  1658,
    1662,  1675,  1681,  1688,  1691,  1694,  1700,  1703,  1706,  1709,
    1712,  1715,  1718,  1721,  1727,  1730,  1740,  1745,  1750,  1759,
    1760,  1764,  1765,  1766,  1767,  1768,  1769,  1770,  1771,  1772,
    1773,  1774,  1775,  1776,  1777,  1778,  1779,  1780,  1781,  1782,
    1783,  1784,  1785,  1786,  1787,  1788,  1789,  1790,  1791,  1792,
    1793,  1794,  1795,  1796,  1797,  1798,  1799,  1800,  1801,  1802,
    1803,  1804,  1805,  1806,  1807,  1808,  1809,  1810,  1811,  1812,
    1813,  1817,  1820,  1823,  1828,  1836,  1839,  1846,  1849,  1853,
    1856,  1860,  1863,  1867,  1871,  1877,  1881,  1884,  1887,  1894,
    1898,  1904,  1917,  1921,  1928,  1934,  1938,  1944,  1947,  1953,
    1959,  1962,  1968,  1974,  1980,  1986,  1989,  1995,  1999,  2003,
    2009,  2013,  2020,  2023,  2029,  2032,  2038,  2047,  2056,  2059,
    2062,  2065,  2070,  2073,  2082,  2083,  2084,  2085,  2086,  2087,
    2088,  2089,  2093,  2097,  2101,  2112,  2115,  2118,  2125,  2129,
    2136,  2142,  2148,  2152,  2162,  2166,  2169,  2172,  2175,  2182,
    2186,  2202,  2208,  2212,  2218,  2224,  2230,  2243,  2246,  2252,
    2258,  2265,  2271,  2278,  2284,  2291,  2297,  2304,  2310,  2321,
    2325,  2331,  2337,  2350,  2357,  2364,  2371,  2375,  2382,  2386,
    2392,  2399,  2403,  2411,  2417,  2418,  2424,  2427,  2433,  2437,
    2441,  2449,  2450,  2451,  2452,  2453,  2454,  2455,  2456,  2457,
    2458,  2459,  2460,  2464,  2465,  2466,  2467,  2468,  2472,  2473,
    2477,  2478,  2482,  2483,  2487,  2488,  2492,  2493,  2497,  2498,
    2502,  2503,  2507,  2508,  2514,  2517,  2520,  2523,  2528,  2528,
    2531,  2534,  2537,  2540,  2543,  2546,  2549,  2555,  2561,  2562,
    2568,  2569,  2575,  2576,  2582,  2585,  2591,  2594,  2597,  2600,
    2606,  2607,  2611,  2612
  };

  void
  parser::yy_stack_print_ () const
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << int (i->state);
    *yycdebug_ << '\n';
  }

  void
  parser::yy_reduce_print_ (int yyrule) const
  {
    int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):\n";
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG


} // yy
#line 6671 "/build/rgbds/src/rgbds/src/asm/parser.cpp"

#line 2615 "asm/parser.y"


/******************** Error handler ********************/

void yy::parser::error(std::string const &str) {
	::error("%s", str.c_str());
}
