// SPDX-License-Identifier: BSD-2-Clause

// This code is part of the sfizz library and is licensed under a BSD 2-clause
// license. You should have receive a LICENSE.md file along with the code.
// If not, contact the sfizz maintainers at https://github.com/sfztools/sfizz

#pragma once
#include "Effects.h"
#include "OversamplerHelpers.h"

namespace sfz {
namespace fx {

    /**
     * @brief Half-wave and full-wave rectifier
     */
    class Rectify : public Effect {
    public:
        Rectify();

        /**
         * @brief Initializes with the given sample rate.
         */
        void setSampleRate(double sampleRate) override;

        /**
         * @brief Sets the maximum number of frames to render at a time. The actual
         * value can be lower but should never be higher.
         */
        void setSamplesPerBlock(int samplesPerBlock) override;

        /**
         * @brief Reset the state to initial.
         */
        void clear() override;

        /**
         * @brief Copy the input signal to the output
         */
        void process(const float* const inputs[], float* const outputs[], unsigned nframes) override;

        /**
          * @brief Instantiates given the contents of the <effect> block.
          */
        static std::unique_ptr<Effect> makeInstance(absl::Span<const Opcode> members);

    private:
        AudioBuffer<float, 1> _tempBuffer { 1, config::defaultSamplesPerBlock };
        hiir::Downsampler2x<12> _downsampler2x[2];
        hiir::Upsampler2x<12> _upsampler2x[2];

        float _amount = 0;
        bool _full = false;
    };

} // namespace fx
} // namespace sfz
