/* authorize-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from authorize-dialog.vala, do not modify */

/*
 * Copyright (C) 2009-2017 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>,
 *         Eduard Gotwig <g@ox.io>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <adwaita.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_AUTHORIZE_DIALOG (authorize_dialog_get_type ())
#define AUTHORIZE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTHORIZE_DIALOG, AuthorizeDialog))
#define AUTHORIZE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTHORIZE_DIALOG, AuthorizeDialogClass))
#define IS_AUTHORIZE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTHORIZE_DIALOG))
#define IS_AUTHORIZE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTHORIZE_DIALOG))
#define AUTHORIZE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTHORIZE_DIALOG, AuthorizeDialogClass))

typedef struct _AuthorizeDialog AuthorizeDialog;
typedef struct _AuthorizeDialogClass AuthorizeDialogClass;
typedef struct _AuthorizeDialogPrivate AuthorizeDialogPrivate;
enum  {
	AUTHORIZE_DIALOG_0_PROPERTY,
	AUTHORIZE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* authorize_dialog_properties[AUTHORIZE_DIALOG_NUM_PROPERTIES];

#define TYPE_AUTHORIZE_DIALOG_RESPONSE (authorize_dialog_response_get_type ())
typedef struct _AuthorizeDialogResponse AuthorizeDialogResponse;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _AuthorizeDialogOpenData AuthorizeDialogOpenData;
enum  {
	AUTHORIZE_DIALOG_AUTHORIZED_SIGNAL,
	AUTHORIZE_DIALOG_NUM_SIGNALS
};
static guint authorize_dialog_signals[AUTHORIZE_DIALOG_NUM_SIGNALS] = {0};

struct _AuthorizeDialog {
	GtkWindow parent_instance;
	AuthorizeDialogPrivate * priv;
};

struct _AuthorizeDialogClass {
	GtkWindowClass parent_class;
};

struct _AuthorizeDialogPrivate {
	AdwPreferencesGroup* preferences_group;
	AdwEntryRow* username_entry;
	AdwPasswordEntryRow* password_entry;
};

struct _AuthorizeDialogResponse {
	gchar* username;
	gchar* password;
	gboolean success;
};

struct _Block8Data {
	int _ref_count_;
	AuthorizeDialog* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	AuthorizeDialogResponse response;
	gpointer _async_data_;
};

struct _AuthorizeDialogOpenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AuthorizeDialog* self;
	AuthorizeDialogResponse result;
	Block8Data* _data8_;
	AuthorizeDialogResponse _tmp0_;
	AuthorizeDialogResponse _tmp1_;
	AuthorizeDialogResponse _tmp2_;
	AuthorizeDialogResponse _tmp3_;
};

static gint AuthorizeDialog_private_offset;
static gpointer authorize_dialog_parent_class = NULL;

VALA_EXTERN GType authorize_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AuthorizeDialog, g_object_unref)
VALA_EXTERN AuthorizeDialog* authorize_dialog_new (GtkWindow* parent,
                                       const gchar* title);
VALA_EXTERN AuthorizeDialog* authorize_dialog_construct (GType object_type,
                                             GtkWindow* parent,
                                             const gchar* title);
VALA_EXTERN gchar* authorize_dialog_get_username (AuthorizeDialog* self);
VALA_EXTERN gchar* authorize_dialog_get_password (AuthorizeDialog* self);
static void authorize_dialog_authorize_button_cb (AuthorizeDialog* self);
VALA_EXTERN GType authorize_dialog_response_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AuthorizeDialogResponse* authorize_dialog_response_dup (const AuthorizeDialogResponse* self);
VALA_EXTERN void authorize_dialog_response_free (AuthorizeDialogResponse* self);
VALA_EXTERN void authorize_dialog_response_copy (const AuthorizeDialogResponse* self,
                                     AuthorizeDialogResponse* dest);
VALA_EXTERN void authorize_dialog_response_destroy (AuthorizeDialogResponse* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (AuthorizeDialogResponse, authorize_dialog_response_destroy)
VALA_EXTERN void authorize_dialog_response_new_authorized (const gchar* username,
                                               const gchar* password,
                                               AuthorizeDialogResponse* result);
static void _authorize_dialog_authorize_button_cb_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
static void authorize_dialog_cancel_button_cb (AuthorizeDialog* self);
VALA_EXTERN void authorize_dialog_response_new_canceled (AuthorizeDialogResponse* result);
static void _authorize_dialog_cancel_button_cb_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self);
static void authorize_dialog_open_data_free (gpointer _data);
VALA_EXTERN void authorize_dialog_open (AuthorizeDialog* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_);
VALA_EXTERN void authorize_dialog_open_finish (AuthorizeDialog* self,
                                   GAsyncResult* _res_,
                                   AuthorizeDialogResponse* result);
static gboolean authorize_dialog_open_co (AuthorizeDialogOpenData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static gboolean _authorize_dialog_open_co_gsource_func (gpointer self);
static void __lambda42_ (Block8Data* _data8_,
                  AuthorizeDialogResponse* res);
static void ___lambda42__authorize_dialog_authorized (AuthorizeDialog* _sender,
                                               AuthorizeDialogResponse* res,
                                               gpointer self);
static void authorize_dialog_finalize (GObject * obj);
static GType authorize_dialog_get_type_once (void);

static inline gpointer
authorize_dialog_get_instance_private (AuthorizeDialog* self)
{
	return G_STRUCT_MEMBER_P (self, AuthorizeDialog_private_offset);
}

AuthorizeDialog*
authorize_dialog_construct (GType object_type,
                            GtkWindow* parent,
                            const gchar* title)
{
	AuthorizeDialog * self = NULL;
	AdwPreferencesGroup* _tmp0_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (AuthorizeDialog*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->preferences_group;
	adw_preferences_group_set_title (_tmp0_, title);
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	return self;
}

AuthorizeDialog*
authorize_dialog_new (GtkWindow* parent,
                      const gchar* title)
{
	return authorize_dialog_construct (TYPE_AUTHORIZE_DIALOG, parent, title);
}

gchar*
authorize_dialog_get_username (AuthorizeDialog* self)
{
	AdwEntryRow* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->username_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
authorize_dialog_get_password (AuthorizeDialog* self)
{
	AdwPasswordEntryRow* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->password_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
authorize_dialog_authorize_button_cb (AuthorizeDialog* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	AuthorizeDialogResponse _tmp4_ = {0};
	AuthorizeDialogResponse _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = authorize_dialog_get_username (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = authorize_dialog_get_password (self);
	_tmp3_ = _tmp2_;
	authorize_dialog_response_new_authorized (_tmp1_, _tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	g_signal_emit (self, authorize_dialog_signals[AUTHORIZE_DIALOG_AUTHORIZED_SIGNAL], 0, &_tmp5_);
	authorize_dialog_response_destroy (&_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

static void
_authorize_dialog_authorize_button_cb_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	authorize_dialog_authorize_button_cb ((AuthorizeDialog*) self);
}

static void
authorize_dialog_cancel_button_cb (AuthorizeDialog* self)
{
	AuthorizeDialogResponse _tmp0_ = {0};
	AuthorizeDialogResponse _tmp1_;
	g_return_if_fail (self != NULL);
	authorize_dialog_response_new_canceled (&_tmp0_);
	_tmp1_ = _tmp0_;
	g_signal_emit (self, authorize_dialog_signals[AUTHORIZE_DIALOG_AUTHORIZED_SIGNAL], 0, &_tmp1_);
	authorize_dialog_response_destroy (&_tmp1_);
}

static void
_authorize_dialog_cancel_button_cb_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self)
{
	authorize_dialog_cancel_button_cb ((AuthorizeDialog*) self);
}

static void
authorize_dialog_open_data_free (gpointer _data)
{
	AuthorizeDialogOpenData* _data_;
	_data_ = _data;
	authorize_dialog_response_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AuthorizeDialogOpenData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
authorize_dialog_open (AuthorizeDialog* self,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	AuthorizeDialogOpenData* _data_;
	AuthorizeDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AuthorizeDialogOpenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, authorize_dialog_open_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	authorize_dialog_open_co (_data_);
}

void
authorize_dialog_open_finish (AuthorizeDialog* self,
                              GAsyncResult* _res_,
                              AuthorizeDialogResponse* result)
{
	AuthorizeDialogOpenData* _data_;
	AuthorizeDialogResponse _tmp0_;
	AuthorizeDialogResponse _tmp1_ = {0};
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	_tmp0_ = _data_->result;
	authorize_dialog_response_copy (&_tmp0_, &_tmp1_);
	*result = _tmp1_;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		AuthorizeDialog* self;
		self = _data8_->self;
		authorize_dialog_response_destroy (&_data8_->response);
		(_data8_->callback_target_destroy_notify == NULL) ? NULL : (_data8_->callback_target_destroy_notify (_data8_->callback_target), NULL);
		_data8_->callback = NULL;
		_data8_->callback_target = NULL;
		_data8_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static gboolean
_authorize_dialog_open_co_gsource_func (gpointer self)
{
	gboolean result;
	result = authorize_dialog_open_co (self);
	return result;
}

static void
__lambda42_ (Block8Data* _data8_,
             AuthorizeDialogResponse* res)
{
	AuthorizeDialog* self;
	AuthorizeDialogResponse _tmp0_;
	AuthorizeDialogResponse _tmp1_;
	AuthorizeDialogResponse _tmp2_ = {0};
	self = _data8_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = *res;
	_tmp1_ = _tmp0_;
	authorize_dialog_response_copy (&_tmp1_, &_tmp2_);
	authorize_dialog_response_destroy (&_data8_->response);
	_data8_->response = _tmp2_;
	_data8_->callback (_data8_->callback_target);
}

static void
___lambda42__authorize_dialog_authorized (AuthorizeDialog* _sender,
                                          AuthorizeDialogResponse* res,
                                          gpointer self)
{
	__lambda42_ (self, res);
}

static gboolean
authorize_dialog_open_co (AuthorizeDialogOpenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_data_->_data8_->_async_data_ = _data_;
	_data_->_data8_->callback = _authorize_dialog_open_co_gsource_func;
	_data_->_data8_->callback_target = _data_;
	_data_->_data8_->callback_target_destroy_notify = NULL;
	memset (&_data_->_tmp0_, 0, sizeof (AuthorizeDialogResponse));
	_data_->_data8_->response = _data_->_tmp0_;
	g_signal_connect_data (_data_->self, "authorized", (GCallback) ___lambda42__authorize_dialog_authorized, block8_data_ref (_data_->_data8_), (GClosureNotify) block8_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data_->self);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	gtk_window_close ((GtkWindow*) _data_->self);
	_data_->_tmp1_ = _data_->_data8_->response;
	_data_->_tmp2_ = _data_->_tmp1_;
	memset (&_data_->_tmp3_, 0, sizeof (AuthorizeDialogResponse));
	authorize_dialog_response_copy (&_data_->_tmp2_, &_data_->_tmp3_);
	_data_->result = _data_->_tmp3_;
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
authorize_dialog_class_init (AuthorizeDialogClass * klass,
                             gpointer klass_data)
{
	authorize_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AuthorizeDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = authorize_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/SimpleScan/ui/authorize-dialog.ui");
	authorize_dialog_signals[AUTHORIZE_DIALOG_AUTHORIZED_SIGNAL] = g_signal_new ("authorized", TYPE_AUTHORIZE_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, TYPE_AUTHORIZE_DIALOG_RESPONSE);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preferences_group", FALSE, AuthorizeDialog_private_offset + G_STRUCT_OFFSET (AuthorizeDialogPrivate, preferences_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "username_entry", FALSE, AuthorizeDialog_private_offset + G_STRUCT_OFFSET (AuthorizeDialogPrivate, username_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "password_entry", FALSE, AuthorizeDialog_private_offset + G_STRUCT_OFFSET (AuthorizeDialogPrivate, password_entry));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "authorize_button_cb", G_CALLBACK(_authorize_dialog_authorize_button_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_button_cb", G_CALLBACK(_authorize_dialog_cancel_button_cb_gtk_button_clicked));
}

static void
authorize_dialog_instance_init (AuthorizeDialog * self,
                                gpointer klass)
{
	self->priv = authorize_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
authorize_dialog_finalize (GObject * obj)
{
	AuthorizeDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AUTHORIZE_DIALOG, AuthorizeDialog);
	G_OBJECT_CLASS (authorize_dialog_parent_class)->finalize (obj);
}

static GType
authorize_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AuthorizeDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) authorize_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AuthorizeDialog), 0, (GInstanceInitFunc) authorize_dialog_instance_init, NULL };
	GType authorize_dialog_type_id;
	authorize_dialog_type_id = g_type_register_static (gtk_window_get_type (), "AuthorizeDialog", &g_define_type_info, 0);
	AuthorizeDialog_private_offset = g_type_add_instance_private (authorize_dialog_type_id, sizeof (AuthorizeDialogPrivate));
	return authorize_dialog_type_id;
}

GType
authorize_dialog_get_type (void)
{
	static volatile gsize authorize_dialog_type_id__once = 0;
	if (g_once_init_enter (&authorize_dialog_type_id__once)) {
		GType authorize_dialog_type_id;
		authorize_dialog_type_id = authorize_dialog_get_type_once ();
		g_once_init_leave (&authorize_dialog_type_id__once, authorize_dialog_type_id);
	}
	return authorize_dialog_type_id__once;
}

void
authorize_dialog_response_new_canceled (AuthorizeDialogResponse* result)
{
	AuthorizeDialogResponse _tmp0_ = {0};
	memset (&_tmp0_, 0, sizeof (AuthorizeDialogResponse));
	_tmp0_.success = FALSE;
	*result = _tmp0_;
	return;
}

void
authorize_dialog_response_new_authorized (const gchar* username,
                                          const gchar* password,
                                          AuthorizeDialogResponse* result)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	AuthorizeDialogResponse _tmp2_ = {0};
	g_return_if_fail (username != NULL);
	g_return_if_fail (password != NULL);
	_tmp0_ = g_strdup (username);
	_tmp1_ = g_strdup (password);
	memset (&_tmp2_, 0, sizeof (AuthorizeDialogResponse));
	_g_free0 (_tmp2_.username);
	_tmp2_.username = _tmp0_;
	_g_free0 (_tmp2_.password);
	_tmp2_.password = _tmp1_;
	_tmp2_.success = TRUE;
	*result = _tmp2_;
	return;
}

void
authorize_dialog_response_copy (const AuthorizeDialogResponse* self,
                                AuthorizeDialogResponse* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).username;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).username);
	(*dest).username = _tmp1_;
	_tmp2_ = (*self).password;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).password);
	(*dest).password = _tmp3_;
	(*dest).success = (*self).success;
}

void
authorize_dialog_response_destroy (AuthorizeDialogResponse* self)
{
	_g_free0 ((*self).username);
	_g_free0 ((*self).password);
}

AuthorizeDialogResponse*
authorize_dialog_response_dup (const AuthorizeDialogResponse* self)
{
	AuthorizeDialogResponse* dup;
	dup = g_new0 (AuthorizeDialogResponse, 1);
	authorize_dialog_response_copy (self, dup);
	return dup;
}

void
authorize_dialog_response_free (AuthorizeDialogResponse* self)
{
	authorize_dialog_response_destroy (self);
	g_free (self);
}

static GType
authorize_dialog_response_get_type_once (void)
{
	GType authorize_dialog_response_type_id;
	authorize_dialog_response_type_id = g_boxed_type_register_static ("AuthorizeDialogResponse", (GBoxedCopyFunc) authorize_dialog_response_dup, (GBoxedFreeFunc) authorize_dialog_response_free);
	return authorize_dialog_response_type_id;
}

GType
authorize_dialog_response_get_type (void)
{
	static volatile gsize authorize_dialog_response_type_id__once = 0;
	if (g_once_init_enter (&authorize_dialog_response_type_id__once)) {
		GType authorize_dialog_response_type_id;
		authorize_dialog_response_type_id = authorize_dialog_response_get_type_once ();
		g_once_init_leave (&authorize_dialog_response_type_id__once, authorize_dialog_response_type_id);
	}
	return authorize_dialog_response_type_id__once;
}

