/* umockdev.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from umockdev.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * SECTION:umockdev
 * @title: umockdev
 * @short_description: Build a test bed for testing software that handles Linux
 * hardware devices.
 *
 * Please see README.md about an overview of the parts of umockdev, and how
 * they fit together.
 */
/**
 * SECTION:functions
 * @title: global functions
 * @short_description: Global functions
 *
 * These work independently from #UMockdevTestbed objects.
 */
/**
 * SECTION:umockdeverror
 * @title: umockdev errors
 * @short_description: #GError types for parsing umockdev files
 * hardware devices.
 *
 * See #GError for more information on error domains.
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include "umockdev.h"
#include <glib-object.h>
#include "umockdev-utils.h"
#include <unistd.h>
#include <gio/gio.h>
#include <stdarg.h>
#include "uevent_sender.h"
#include <sys/socket.h>
#include "linux/input.h"
#include <time.h>
#include <pty.h>
#include <termios.h>
#include <stdio.h>
#include <errno.h>
#include <sys/select.h>
#include <sys/time.h>
#include <gobject/gvaluecollector.h>
#include <gio/gunixsocketaddress.h>
#include <sys/stat.h>
#include <sys/types.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))

#define UMOCKDEV_TYPE_SCRIPT_RUNNER (umockdev_script_runner_get_type ())
#define UMOCKDEV_SCRIPT_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunner))
#define UMOCKDEV_SCRIPT_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerClass))
#define UMOCKDEV_IS_SCRIPT_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER))
#define UMOCKDEV_IS_SCRIPT_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_SCRIPT_RUNNER))
#define UMOCKDEV_SCRIPT_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerClass))

typedef struct _UMockdevScriptRunner UMockdevScriptRunner;
typedef struct _UMockdevScriptRunnerClass UMockdevScriptRunnerClass;

#define UMOCKDEV_TYPE_SOCKET_SERVER (umockdev_socket_server_get_type ())
#define UMOCKDEV_SOCKET_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServer))
#define UMOCKDEV_SOCKET_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerClass))
#define UMOCKDEV_IS_SOCKET_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_SOCKET_SERVER))
#define UMOCKDEV_IS_SOCKET_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_SOCKET_SERVER))
#define UMOCKDEV_SOCKET_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerClass))

typedef struct _UMockdevSocketServer UMockdevSocketServer;
typedef struct _UMockdevSocketServerClass UMockdevSocketServerClass;
enum  {
	UMOCKDEV_TESTBED_0_PROPERTY,
	UMOCKDEV_TESTBED_NUM_PROPERTIES
};
static GParamSpec* umockdev_testbed_properties[UMOCKDEV_TESTBED_NUM_PROPERTIES];
#define _umockdev_socket_server_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_socket_server_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _uevent_sender_close0(var) ((var == NULL) ? NULL : (var = (uevent_sender_close (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

#define UMOCKDEV_TYPE_IOCTL_SPI_BASE (umockdev_ioctl_spi_base_get_type ())
#define UMOCKDEV_IOCTL_SPI_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_SPI_BASE, UMockdevIoctlSpiBase))
#define UMOCKDEV_IOCTL_SPI_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_SPI_BASE, UMockdevIoctlSpiBaseClass))
#define UMOCKDEV_IS_IOCTL_SPI_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_SPI_BASE))
#define UMOCKDEV_IS_IOCTL_SPI_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_SPI_BASE))
#define UMOCKDEV_IOCTL_SPI_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_SPI_BASE, UMockdevIoctlSpiBaseClass))

typedef struct _UMockdevIoctlSpiBase UMockdevIoctlSpiBase;
typedef struct _UMockdevIoctlSpiBaseClass UMockdevIoctlSpiBaseClass;

#define UMOCKDEV_TYPE_IOCTL_SPI_HANDLER (umockdev_ioctl_spi_handler_get_type ())
#define UMOCKDEV_IOCTL_SPI_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_SPI_HANDLER, UMockdevIoctlSpiHandler))
#define UMOCKDEV_IOCTL_SPI_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_SPI_HANDLER, UMockdevIoctlSpiHandlerClass))
#define UMOCKDEV_IS_IOCTL_SPI_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_SPI_HANDLER))
#define UMOCKDEV_IS_IOCTL_SPI_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_SPI_HANDLER))
#define UMOCKDEV_IOCTL_SPI_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_SPI_HANDLER, UMockdevIoctlSpiHandlerClass))

typedef struct _UMockdevIoctlSpiHandler UMockdevIoctlSpiHandler;
typedef struct _UMockdevIoctlSpiHandlerClass UMockdevIoctlSpiHandlerClass;

#define UMOCKDEV_TYPE_IOCTL_TREE_HANDLER (umockdev_ioctl_tree_handler_get_type ())
#define UMOCKDEV_IOCTL_TREE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_TREE_HANDLER, UMockdevIoctlTreeHandler))
#define UMOCKDEV_IOCTL_TREE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_TREE_HANDLER, UMockdevIoctlTreeHandlerClass))
#define UMOCKDEV_IS_IOCTL_TREE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_TREE_HANDLER))
#define UMOCKDEV_IS_IOCTL_TREE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_TREE_HANDLER))
#define UMOCKDEV_IOCTL_TREE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_TREE_HANDLER, UMockdevIoctlTreeHandlerClass))

typedef struct _UMockdevIoctlTreeHandler UMockdevIoctlTreeHandler;
typedef struct _UMockdevIoctlTreeHandlerClass UMockdevIoctlTreeHandlerClass;

#define UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER (umockdev_ioctl_usb_pcap_handler_get_type ())
#define UMOCKDEV_IOCTL_USB_PCAP_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER, UMockdevIoctlUsbPcapHandler))
#define UMOCKDEV_IOCTL_USB_PCAP_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER, UMockdevIoctlUsbPcapHandlerClass))
#define UMOCKDEV_IS_IOCTL_USB_PCAP_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER))
#define UMOCKDEV_IS_IOCTL_USB_PCAP_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER))
#define UMOCKDEV_IOCTL_USB_PCAP_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER, UMockdevIoctlUsbPcapHandlerClass))

typedef struct _UMockdevIoctlUsbPcapHandler UMockdevIoctlUsbPcapHandler;
typedef struct _UMockdevIoctlUsbPcapHandlerClass UMockdevIoctlUsbPcapHandlerClass;
#define _umockdev_script_runner_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_script_runner_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _UMockdevScriptRunnerPrivate UMockdevScriptRunnerPrivate;
typedef struct _UMockdevParamSpecScriptRunner UMockdevParamSpecScriptRunner;
typedef struct _UMockdevSocketServerPrivate UMockdevSocketServerPrivate;
typedef struct _UMockdevParamSpecSocketServer UMockdevParamSpecSocketServer;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
};

struct _UMockdevTestbedPrivate {
	gchar* root_dir;
	gchar* sys_dir;
	GRegex* re_record_val;
	GRegex* re_record_keyval;
	GRegex* re_record_optval;
	GHashTable* dev_fd;
	GHashTable* dev_script_runner;
	UMockdevSocketServer* socket_server;
	GHashTable* custom_handlers;
	GThread* worker_thread;
	GMainContext* worker_ctx;
	GMainLoop* worker_loop;
};

struct _UMockdevScriptRunner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevScriptRunnerPrivate * priv;
};

struct _UMockdevScriptRunnerClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevScriptRunner *self);
};

struct _UMockdevScriptRunnerPrivate {
	gint fd;
	gchar* _device;
	GDataInputStream* script;
	gchar* script_file;
	GThread* thread;
	gboolean running;
	guint fuzz;
};

struct _UMockdevParamSpecScriptRunner {
	GParamSpec parent_instance;
};

struct _UMockdevSocketServer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevSocketServerPrivate * priv;
};

struct _UMockdevSocketServerClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevSocketServer *self);
};

struct _UMockdevSocketServerPrivate {
	GSocket** listen_sockets;
	gint listen_sockets_length1;
	gint _listen_sockets_size_;
	GHashTable* socket_scriptfile;
	GHashTable* script_runners;
	GThread* thread;
	gboolean running;
	gint ctrl_r;
	gint ctrl_w;
};

struct _UMockdevParamSpecSocketServer {
	GParamSpec parent_instance;
};

/**
 * UMockdevError:
 * @UMOCKDEV_ERROR_PARSE:
 * There is a malformed or missing line in the device description.
 * @UMOCKDEV_ERROR_VALUE:
 * A value in the device description has an invalid value, for example a device
 * path does not start with "/devices/".
 *
 * Error codes for parsing umockdev files.
 */

VALA_EXTERN gboolean umockdev___in_mock_env_initialized;
gboolean umockdev___in_mock_env_initialized = FALSE;
VALA_EXTERN gboolean umockdev___in_mock_env_result;
gboolean umockdev___in_mock_env_result = FALSE;
static gint UMockdevTestbed_private_offset;
static gpointer umockdev_testbed_parent_class = NULL;
static GHashTable* umockdev_testbed_bus_lookup_table;
static GHashTable* umockdev_testbed_bus_lookup_table = NULL;
static gint UMockdevScriptRunner_private_offset;
static gpointer umockdev_script_runner_parent_class = NULL;
static gint UMockdevSocketServer_private_offset;
static gpointer umockdev_socket_server_parent_class = NULL;

VALA_EXTERN void umockdev_checked_mkdir (const gchar* path,
                             gint mode);
VALA_EXTERN void umockdev_checked_mkdir_with_parents (const gchar* path,
                                          gint mode);
VALA_EXTERN GThread* umockdev_create_worker_thread (GMainLoop* loop);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
static gpointer ___lambda4__gthread_func (gpointer self);
VALA_EXTERN gpointer umockdev_script_runner_ref (gpointer instance);
VALA_EXTERN void umockdev_script_runner_unref (gpointer instance);
VALA_EXTERN GParamSpec* umockdev_param_spec_script_runner (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void umockdev_value_set_script_runner (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void umockdev_value_take_script_runner (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer umockdev_value_get_script_runner (const GValue* value);
VALA_EXTERN GType umockdev_script_runner_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer umockdev_socket_server_ref (gpointer instance);
VALA_EXTERN void umockdev_socket_server_unref (gpointer instance);
VALA_EXTERN GParamSpec* umockdev_param_spec_socket_server (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void umockdev_value_set_socket_server (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void umockdev_value_take_socket_server (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer umockdev_value_get_socket_server (const GValue* value);
VALA_EXTERN GType umockdev_socket_server_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void umockdev_script_runner_stop (UMockdevScriptRunner* self);
static void _umockdev_testbed___lambda5_ (UMockdevTestbed* self,
                                   const gchar* key,
                                   UMockdevIoctlBase* val);
VALA_EXTERN void umockdev_ioctl_base_unregister_path (UMockdevIoctlBase* self,
                                          const gchar* devnode);
static void __umockdev_testbed___lambda5__gh_func (gconstpointer key,
                                            gconstpointer value,
                                            gpointer self);
VALA_EXTERN void umockdev_socket_server_stop (UMockdevSocketServer* self);
static void _g_free0_ (gpointer var);
static void _umockdev_script_runner_unref0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void umockdev_ioctl_base_register_path (UMockdevIoctlBase* self,
                                        GMainContext* ctx,
                                        const gchar* devnode,
                                        const gchar* sockpath);
static gchar* umockdev_testbed_get_attribute (UMockdevTestbed* self,
                                       const gchar* devpath,
                                       const gchar* name);
static gchar* umockdev_testbed_add_devicev_no_uevent (UMockdevTestbed* self,
                                               const gchar* subsystem,
                                               const gchar* name,
                                               const gchar* parent,
                                               gchar** attributes,
                                               gchar** properties);
static gboolean umockdev_testbed_subsystem_is_bus (const gchar* subsystem);
VALA_EXTERN gchar* umockdev_make_dotdots (const gchar* path);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void umockdev_testbed_remove_with_children (UMockdevTestbed* self,
                                            const gchar* syspath);
VALA_EXTERN gchar* umockdev_find_devnode (const gchar* devpath);
static gchar* umockdev_testbed_add_dev_from_string (UMockdevTestbed* self,
                                             const gchar* data,
                                             GError** error);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
VALA_EXTERN UMockdevIoctlSpiHandler* umockdev_ioctl_spi_handler_new (const gchar* file);
VALA_EXTERN UMockdevIoctlSpiHandler* umockdev_ioctl_spi_handler_construct (GType object_type,
                                                               const gchar* file);
VALA_EXTERN GType umockdev_ioctl_spi_base_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType umockdev_ioctl_spi_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UMockdevIoctlTreeHandler* umockdev_ioctl_tree_handler_new (const gchar* file);
VALA_EXTERN UMockdevIoctlTreeHandler* umockdev_ioctl_tree_handler_construct (GType object_type,
                                                                 const gchar* file);
VALA_EXTERN GType umockdev_ioctl_tree_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType umockdev_ioctl_usb_pcap_handler_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UMockdevIoctlUsbPcapHandler* umockdev_ioctl_usb_pcap_handler_new (const gchar* file,
                                                                  gint bus,
                                                                  gint device);
VALA_EXTERN UMockdevIoctlUsbPcapHandler* umockdev_ioctl_usb_pcap_handler_construct (GType object_type,
                                                                        const gchar* file,
                                                                        gint bus,
                                                                        gint device);
static gboolean umockdev_testbed_load_script_from_stream (UMockdevTestbed* self,
                                                   const gchar* dev,
                                                   GDataInputStream* script,
                                                   const gchar* scriptname,
                                                   GError** error);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
VALA_EXTERN UMockdevScriptRunner* umockdev_script_runner_new (gint device_fd,
                                                  const gchar* device,
                                                  GDataInputStream* script,
                                                  const gchar* script_file,
                                                  GError** error);
VALA_EXTERN UMockdevScriptRunner* umockdev_script_runner_construct (GType object_type,
                                                        gint device_fd,
                                                        const gchar* device,
                                                        GDataInputStream* script,
                                                        const gchar* script_file,
                                                        GError** error);
VALA_EXTERN void umockdev_script_runner_wait (UMockdevScriptRunner* self);
VALA_EXTERN UMockdevSocketServer* umockdev_socket_server_new (void);
VALA_EXTERN UMockdevSocketServer* umockdev_socket_server_construct (GType object_type);
VALA_EXTERN void umockdev_socket_server_add (UMockdevSocketServer* self,
                                 const gchar* sock_path,
                                 gint fd,
                                 const gchar* record_file);
static gboolean umockdev_testbed_load_evemu_events_from_stream (UMockdevTestbed* self,
                                                         const gchar* dev,
                                                         GDataInputStream* events,
                                                         const gchar* eventsname,
                                                         GError** error);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
VALA_EXTERN gchar* umockdev_script_runner_encode (guint8* data,
                                      gint data_length1);
static GHashTable* umockdev_testbed_create_bus_lookup (void);
static gchar* umockdev_testbed_record_parse_line (UMockdevTestbed* self,
                                           const gchar* data,
                                           gchar* type,
                                           gchar** key,
                                           gchar** val);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN guint8* umockdev_decode_hex (const gchar* data,
                             gint* result_length1,
                             GError** error);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void umockdev_testbed_create_node_for_device (UMockdevTestbed* self,
                                              const gchar* subsystem,
                                              const gchar* node_path,
                                              guint8* node_contents,
                                              gint node_contents_length1,
                                              const gchar* majmin,
                                              const gchar* selinux_context,
                                              GError** error);
static void umockdev_testbed_set_selinux_context (UMockdevTestbed* self,
                                           const gchar* path,
                                           const gchar* context);
static void umockdev_testbed_finalize (GObject * obj);
static GType umockdev_testbed_get_type_once (void);
VALA_EXTERN guint8 umockdev_hexdigit (gchar c);
static void umockdev_script_runner_set_device (UMockdevScriptRunner* self,
                                        const gchar* value);
static void* umockdev_script_runner_run (UMockdevScriptRunner* self);
static gpointer _umockdev_script_runner_run_gthread_func (gpointer self);
VALA_EXTERN const gchar* umockdev_script_runner_get_device (UMockdevScriptRunner* self);
static guint8* umockdev_script_runner_next_line (UMockdevScriptRunner* self,
                                          gchar* op,
                                          guint32* delta,
                                          gint* result_length1);
static void umockdev_script_runner_op_write (UMockdevScriptRunner* self,
                                      guint8* data,
                                      gint data_length1,
                                      guint32 delta);
static guint8* umockdev_script_runner_decode (const gchar* quoted,
                                       gint* result_length1);
static guint umockdev_script_runner_hamming (guint8* d1,
                                      gint d1_length1,
                                      guint8* d2,
                                      gint d2_length1);
static void _vala_array_add12 (guint8* * array,
                        gint* length,
                        gint* size,
                        guint8 value);
static void _vala_array_add13 (guint8* * array,
                        gint* length,
                        gint* size,
                        guint8 value);
static void _vala_array_add14 (guint8* * array,
                        gint* length,
                        gint* size,
                        guint8 value);
static void _vala_array_add15 (guint8* * array,
                        gint* length,
                        gint* size,
                        guint8 value);
static void _vala_array_add16 (guint8* * array,
                        gint* length,
                        gint* size,
                        guint8 value);
static void _vala_array_add17 (guint8* * array,
                        gint* length,
                        gint* size,
                        guint8 value);
static void _vala_array_add18 (guint8* * array,
                        gint* length,
                        gint* size,
                        guint8 value);
static void _vala_array_add19 (guint8* * array,
                        gint* length,
                        gint* size,
                        guint8 value);
static void umockdev_script_runner_finalize (UMockdevScriptRunner * obj);
static GType umockdev_script_runner_get_type_once (void);
static void* umockdev_socket_server_run (UMockdevSocketServer* self);
static gpointer _umockdev_socket_server_run_gthread_func (gpointer self);
static void _vala_array_add20 (GSocket** * array,
                        gint* length,
                        gint* size,
                        GSocket* value);
static void umockdev_socket_server_finalize (UMockdevSocketServer * obj);
static GType umockdev_socket_server_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
umockdev_checked_mkdir (const gchar* path,
                        gint mode)
{
	g_return_if_fail (path != NULL);
	if (g_mkdir (path, mode) < 0) {
		g_error ("umockdev.vala:33: cannot create directory %s: %m", path);
	}
}

void
umockdev_checked_mkdir_with_parents (const gchar* path,
                                     gint mode)
{
	g_return_if_fail (path != NULL);
	if (g_mkdir_with_parents (path, mode) < 0) {
		g_error ("umockdev.vala:39: cannot create directory with parents %s: %m", path);
	}
}

/**
 * UMockdevTestbed:
 *
 * The #UMockdevTestbed class builds a temporary sandbox for mock devices.
 * You can add a number of devices including arbitrary sysfs attributes and
 * udev properties, and then run your software in that test bed that is
 * independent of the actual hardware it is running on.  With this you can
 * simulate particular hardware in virtual environments up to some degree,
 * without needing any particular privileges or disturbing the whole system.
 *
 * You can either add devices by specifying individual device paths,
 * properties, and attributes, or use the umockdev-record tool to create a human
 * readable/editable record of a real device (and all its parents) and load
 * that into the testbed with umockdev_testbed_add_from_string().
 *
 * Instantiating a #UMockdevTestbed object creates a temporary directory with
 * an empty sysfs tree and sets the $UMOCKDEV_DIR environment variable so that
 * programs subsequently started under umockdev-wrapper will use the test bed
 * instead of the system's real sysfs.
 */
static gpointer
_g_main_loop_ref0 (gpointer self)
{
	return self ? g_main_loop_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_main_context_ref0 (gpointer self)
{
	return self ? g_main_context_ref (self) : NULL;
}

static void
__lambda4_ (Block1Data* _data1_)
{
	GMainContext* ctx = NULL;
	GMainContext* _tmp0_;
	GMainContext* _tmp1_;
	_tmp0_ = g_main_loop_get_context (_data1_->loop);
	_tmp1_ = _g_main_context_ref0 (_tmp0_);
	ctx = _tmp1_;
	g_main_context_push_thread_default (ctx);
	g_main_loop_run (_data1_->loop);
	g_main_context_pop_thread_default (ctx);
	_g_main_context_unref0 (ctx);
}

static gpointer
___lambda4__gthread_func (gpointer self)
{
	gpointer result;
	__lambda4_ (self);
	result = NULL;
	block1_data_unref (self);
	return result;
}

GThread*
umockdev_create_worker_thread (GMainLoop* loop)
{
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	GThread* _tmp1_;
	GThread* result;
	g_return_val_if_fail (loop != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = _g_main_loop_ref0 (loop);
	_g_main_loop_unref0 (_data1_->loop);
	_data1_->loop = _tmp0_;
	_tmp1_ = g_thread_new ("umockdev-testbed-worker", ___lambda4__gthread_func, block1_data_ref (_data1_));
	result = _tmp1_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static inline gpointer
umockdev_testbed_get_instance_private (UMockdevTestbed* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevTestbed_private_offset);
}

static void
_umockdev_testbed___lambda5_ (UMockdevTestbed* self,
                              const gchar* key,
                              UMockdevIoctlBase* val)
{
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	umockdev_ioctl_base_unregister_path (val, key);
}

static void
__umockdev_testbed___lambda5__gh_func (gconstpointer key,
                                       gconstpointer value,
                                       gpointer self)
{
	_umockdev_testbed___lambda5_ ((UMockdevTestbed*) self, (const gchar*) key, (UMockdevIoctlBase*) value);
}

/**
     * umockdev_testbed_new:
     *
     * Create a new #UMockdevTestbed object. This is initially empty, call
     * methods like #umockdev_testbed_add_device or
     * #umockdev_testbed_add_from_string to fill it.
     *
     * Returns: The newly created #UMockdevTestbed object.
     */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_umockdev_script_runner_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (umockdev_script_runner_unref (var), NULL));
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

UMockdevTestbed*
umockdev_testbed_construct (GType object_type)
{
	UMockdevTestbed * self = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* bus_path = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* class_path = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GHashFunc _tmp11_;
	GEqualFunc _tmp12_;
	GHashTable* _tmp13_;
	GHashFunc _tmp14_;
	GEqualFunc _tmp15_;
	GHashTable* _tmp16_;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	GHashTable* _tmp19_;
	const gchar* _tmp20_;
	GMainContext* _tmp21_;
	GMainContext* _tmp22_;
	GMainLoop* _tmp23_;
	GMainLoop* _tmp24_;
	GThread* _tmp25_;
	UMockdevIoctlBase* handler = NULL;
	UMockdevIoctlBase* _tmp26_;
	gchar* sockpath = NULL;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	GMainContext* _tmp29_;
	const gchar* _tmp30_;
	GError* _inner_error0_ = NULL;
	self = (UMockdevTestbed*) g_object_new (object_type, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_dir_make_tmp ("umockdev.XXXXXX", &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (self->priv->root_dir);
		self->priv->root_dir = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e->message;
		g_error ("umockdev.vala:101: Cannot create temporary directory: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp4_ = self->priv->root_dir;
	_tmp5_ = g_build_filename (_tmp4_, "sys", NULL);
	_g_free0 (self->priv->sys_dir);
	self->priv->sys_dir = _tmp5_;
	_tmp6_ = self->priv->sys_dir;
	umockdev_checked_mkdir (_tmp6_, 0755);
	_tmp7_ = self->priv->sys_dir;
	_tmp8_ = g_build_filename (_tmp7_, "bus", NULL);
	bus_path = _tmp8_;
	umockdev_checked_mkdir (bus_path, 0755);
	_tmp9_ = self->priv->sys_dir;
	_tmp10_ = g_build_filename (_tmp9_, "class", NULL);
	class_path = _tmp10_;
	umockdev_checked_mkdir (class_path, 0755);
	_tmp11_ = g_str_hash;
	_tmp12_ = g_str_equal;
	_tmp13_ = g_hash_table_new_full (_tmp11_, _tmp12_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->dev_fd);
	self->priv->dev_fd = _tmp13_;
	_tmp14_ = g_str_hash;
	_tmp15_ = g_str_equal;
	_tmp16_ = g_hash_table_new_full (_tmp14_, _tmp15_, _g_free0_, _umockdev_script_runner_unref0_);
	_g_hash_table_unref0 (self->priv->dev_script_runner);
	self->priv->dev_script_runner = _tmp16_;
	_tmp17_ = g_str_hash;
	_tmp18_ = g_str_equal;
	_tmp19_ = g_hash_table_new_full (_tmp17_, _tmp18_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->custom_handlers);
	self->priv->custom_handlers = _tmp19_;
	_tmp20_ = self->priv->root_dir;
	umockdev_utils_checked_setenv ("UMOCKDEV_DIR", _tmp20_);
	_tmp21_ = g_main_context_new ();
	_g_main_context_unref0 (self->priv->worker_ctx);
	self->priv->worker_ctx = _tmp21_;
	_tmp22_ = self->priv->worker_ctx;
	_tmp23_ = g_main_loop_new (_tmp22_, FALSE);
	_g_main_loop_unref0 (self->priv->worker_loop);
	self->priv->worker_loop = _tmp23_;
	_tmp24_ = self->priv->worker_loop;
	_tmp25_ = umockdev_create_worker_thread (_tmp24_);
	_g_thread_unref0 (self->priv->worker_thread);
	self->priv->worker_thread = _tmp25_;
	_tmp26_ = umockdev_ioctl_base_new ();
	handler = _tmp26_;
	_tmp27_ = self->priv->root_dir;
	_tmp28_ = g_build_filename (_tmp27_, "ioctl", "_default", NULL);
	sockpath = _tmp28_;
	_tmp29_ = self->priv->worker_ctx;
	umockdev_ioctl_base_register_path (handler, _tmp29_, "_default", sockpath);
	_tmp30_ = self->priv->root_dir;
	g_debug ("umockdev.vala:127: Created udev test bed %s", _tmp30_);
	_g_free0 (sockpath);
	_g_object_unref0 (handler);
	_g_free0 (class_path);
	_g_free0 (bus_path);
	return self;
}

UMockdevTestbed*
umockdev_testbed_new (void)
{
	return umockdev_testbed_construct (UMOCKDEV_TYPE_TESTBED);
}

/**
     * umockdev_testbed_get_root_dir:
     * @self: A #UMockdevTestbed.
     *
     * Get the root directory for the testbed. This is mostly useful for
     * setting up the "dev/" or "proc/" testbed directories in this root
     * directory. For getting the mocked "sys/" dir, use
     * #umockdev_testbed_get_sys_dir.
     *
     * Returns: The testbed's root directory.
     */
gchar*
umockdev_testbed_get_root_dir (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * umockdev_testbed_get_sys_dir:
     * @self: A #UMockdevTestbed.
     *
     * Get the sysfs directory for the testbed.
     *
     * Returns: The testbed's sysfs directory.
     */
gchar*
umockdev_testbed_get_sys_dir (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sys_dir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * umockdev_testbed_set_attribute:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute string value
     *
     * Set a text sysfs attribute for a device.
     */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
umockdev_testbed_set_attribute (UMockdevTestbed* self,
                                const gchar* devpath,
                                const gchar* name,
                                const gchar* value)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = string_get_data (value, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	umockdev_testbed_set_attribute_binary (self, devpath, name, _tmp2_, (gint) _tmp2__length1);
}

/**
     * umockdev_testbed_set_attribute_binary:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name (may contain leading directories like
     *        "queue/rotational")
     * @value: Attribute binary value
     * @value_length1: Length of @value in bytes.
     *
     * Set a binary sysfs attribute for a device.
     */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
umockdev_testbed_set_attribute_binary (UMockdevTestbed* self,
                                       const gchar* devpath,
                                       const gchar* name,
                                       guint8* value,
                                       gint value_length1)
{
	gchar* attr_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, name, NULL);
	attr_path = _tmp1_;
	if (string_contains (name, "/")) {
		gchar* d = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = attr_path;
		_tmp3_ = g_path_get_dirname (_tmp2_);
		d = _tmp3_;
		_tmp4_ = d;
		umockdev_checked_mkdir_with_parents (_tmp4_, 0755);
		_g_free0 (d);
	}
	{
		const gchar* _tmp5_;
		_tmp5_ = attr_path;
		g_file_set_contents (_tmp5_, (const char*) value, (gsize) value_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (attr_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e->message;
		g_error ("umockdev.vala:225: Cannot write attribute file: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (attr_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (attr_path);
}

/**
     * umockdev_testbed_set_attribute_int:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name (may contain leading directories like
     *        "queue/rotational")
     * @value: Attribute integer value
     *
     * Set an integer sysfs attribute for a device.
     */
void
umockdev_testbed_set_attribute_int (UMockdevTestbed* self,
                                    const gchar* devpath,
                                    const gchar* name,
                                    gint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%i", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_attribute (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}

/**
     * umockdev_testbed_set_attribute_hex:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute integer value
     *
     * Set an integer sysfs attribute for a device. Set an integer udev
     * property for a device. @value is interpreted as a hexadecimal number.
     * For example, for value==31 this sets the attribute contents to "1f".
     */
void
umockdev_testbed_set_attribute_hex (UMockdevTestbed* self,
                                    const gchar* devpath,
                                    const gchar* name,
                                    guint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%x", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_attribute (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}

/**
     * umockdev_testbed_set_attribute_link:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute link target value
     *
     * Set a symlink sysfs attribute for a device; this is primarily important
     * for setting "driver" links.
     */
void
umockdev_testbed_set_attribute_link (UMockdevTestbed* self,
                                     const gchar* devpath,
                                     const gchar* name,
                                     const gchar* value)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* dir = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, name, NULL);
	path = _tmp1_;
	_tmp2_ = g_path_get_dirname (path);
	dir = _tmp2_;
	umockdev_checked_mkdir_with_parents (dir, 0755);
	if (symlink (value, path) < 0) {
		g_error ("umockdev.vala:276: Cannot create symlink %s: %m", path);
	}
	_g_free0 (dir);
	_g_free0 (path);
}

static gchar*
umockdev_testbed_get_attribute (UMockdevTestbed* self,
                                const gchar* devpath,
                                const gchar* name)
{
	gchar* read = NULL;
	gchar* attr_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (devpath != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	read = NULL;
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, name, NULL);
	attr_path = _tmp1_;
	{
		gchar* _tmp2_ = NULL;
		g_file_get_contents (attr_path, &_tmp2_, NULL, &_inner_error0_);
		_g_free0 (read);
		read = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (attr_path);
			_g_free0 (read);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e->message;
		g_error ("umockdev.vala:288: Cannot read attribute file: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (attr_path);
		_g_free0 (read);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = read;
	_g_free0 (attr_path);
	return result;
}

/**
     * umockdev_testbed_get_property:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     *
     * Get a string udev property for a device. Note that this is mostly for
     * testing umockdev itself; for real application testing, use
     * libudev/gudev.
     *
     * Returns: property value, or %NULL if it does not exist
     */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
umockdev_testbed_get_property (UMockdevTestbed* self,
                               const gchar* devpath,
                               const gchar* name)
{
	gchar* uevent_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* ret = NULL;
	GFile* f = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	gchar* prefix = NULL;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (devpath != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, "uevent", NULL);
	uevent_path = _tmp1_;
	ret = NULL;
	_tmp2_ = uevent_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	f = _tmp3_;
	_tmp4_ = g_strconcat (name, "=", NULL);
	prefix = _tmp4_;
	{
		GFileInputStream* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileInputStream* _tmp7_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp8_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp22_;
		_tmp6_ = f;
		_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp5_);
		inp = _tmp8_;
		while (TRUE) {
			gchar* _tmp9_ = NULL;
			GDataInputStream* _tmp10_;
			gsize _tmp11_ = 0UL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp10_ = inp;
			_tmp12_ = g_data_input_stream_read_line (_tmp10_, &_tmp11_, NULL, &_inner_error0_);
			len = _tmp11_;
			_tmp9_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp5_);
				goto __catch0_g_error;
			}
			_tmp13_ = _tmp9_;
			_tmp9_ = NULL;
			_g_free0 (line);
			line = _tmp13_;
			_tmp14_ = line;
			if (!(_tmp14_ != NULL)) {
				_g_free0 (_tmp9_);
				break;
			}
			_tmp15_ = line;
			_tmp16_ = prefix;
			if (g_str_has_prefix (_tmp15_, _tmp16_)) {
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gchar* _tmp21_;
				_tmp17_ = line;
				_tmp18_ = prefix;
				_tmp19_ = strlen (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = string_substring (_tmp17_, (glong) _tmp20_, (glong) -1);
				_g_free0 (ret);
				ret = _tmp21_;
				_g_free0 (_tmp9_);
				break;
			}
			_g_free0 (_tmp9_);
		}
		_tmp22_ = inp;
		g_input_stream_close ((GInputStream*) _tmp22_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e->message;
		g_error ("umockdev.vala:324: Cannot read uevent file: %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (prefix);
		_g_object_unref0 (f);
		_g_free0 (ret);
		_g_free0 (uevent_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = ret;
	_g_free0 (prefix);
	_g_object_unref0 (f);
	_g_free0 (uevent_path);
	return result;
}

/**
     * umockdev_testbed_set_property:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property string value
     *
     * Set a string udev property for a device.
     */
void
umockdev_testbed_set_property (UMockdevTestbed* self,
                               const gchar* devpath,
                               const gchar* name,
                               const gchar* value)
{
	gchar* uevent_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* props = NULL;
	gchar* _tmp2_;
	gchar* real_value = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* f = NULL;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	gboolean existing = FALSE;
	gchar* prefix = NULL;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, "uevent", NULL);
	uevent_path = _tmp1_;
	_tmp2_ = g_strdup ("");
	props = _tmp2_;
	if (g_strcmp0 (name, "DEVNAME") == 0) {
		_tmp3_ = g_str_has_prefix (value, "/dev/");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = string_substring (value, (glong) 5, (glong) -1);
		_g_free0 (real_value);
		real_value = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (value);
		_g_free0 (real_value);
		real_value = _tmp5_;
	}
	_tmp6_ = uevent_path;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	f = _tmp7_;
	existing = FALSE;
	_tmp8_ = g_strconcat (name, "=", NULL);
	prefix = _tmp8_;
	{
		GFileInputStream* _tmp9_ = NULL;
		GFile* _tmp10_;
		GFileInputStream* _tmp11_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp12_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp34_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		guint8* _tmp45_;
		gint _tmp45__length1;
		gint _tmp46_ = 0;
		guint8* _tmp47_;
		gint _tmp47__length1;
		_tmp10_ = f;
		_tmp11_ = g_file_read (_tmp10_, NULL, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp12_ = g_data_input_stream_new ((GInputStream*) _tmp9_);
		inp = _tmp12_;
		while (TRUE) {
			gchar* _tmp13_ = NULL;
			GDataInputStream* _tmp14_;
			gsize _tmp15_ = 0UL;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp14_ = inp;
			_tmp16_ = g_data_input_stream_read_line (_tmp14_, &_tmp15_, NULL, &_inner_error0_);
			len = _tmp15_;
			_tmp13_ = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp9_);
				goto __catch0_g_error;
			}
			_tmp17_ = _tmp13_;
			_tmp13_ = NULL;
			_g_free0 (line);
			line = _tmp17_;
			_tmp18_ = line;
			if (!(_tmp18_ != NULL)) {
				_g_free0 (_tmp13_);
				break;
			}
			_tmp19_ = line;
			_tmp20_ = prefix;
			if (g_str_has_prefix (_tmp19_, _tmp20_)) {
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				existing = TRUE;
				_tmp21_ = props;
				_tmp22_ = prefix;
				_tmp23_ = real_value;
				_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strconcat (_tmp21_, _tmp27_, NULL);
				_g_free0 (props);
				props = _tmp28_;
				_g_free0 (_tmp27_);
				_g_free0 (_tmp25_);
			} else {
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp29_ = props;
				_tmp30_ = line;
				_tmp31_ = g_strconcat (_tmp30_, "\n", NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
				_g_free0 (props);
				props = _tmp33_;
				_g_free0 (_tmp32_);
			}
			_g_free0 (_tmp13_);
		}
		_tmp34_ = inp;
		g_input_stream_close ((GInputStream*) _tmp34_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp9_);
			goto __catch0_g_error;
		}
		if (!existing) {
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp35_ = props;
			_tmp36_ = prefix;
			_tmp37_ = real_value;
			_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "\n", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp35_, _tmp41_, NULL);
			_g_free0 (props);
			props = _tmp42_;
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
		}
		_tmp43_ = uevent_path;
		_tmp44_ = props;
		_tmp45_ = string_get_data (_tmp44_, &_tmp46_);
		_tmp45__length1 = _tmp46_;
		_tmp47_ = _tmp45_;
		_tmp47__length1 = _tmp45__length1;
		g_file_set_contents (_tmp43_, (const char*) _tmp47_, (gsize) _tmp47__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp9_);
			goto __catch0_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp9_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp48_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp48_ = e->message;
		g_error ("umockdev.vala:377: Cannot update uevent file: %s", _tmp48_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (prefix);
		_g_object_unref0 (f);
		_g_free0 (real_value);
		_g_free0 (props);
		_g_free0 (uevent_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (prefix);
	_g_object_unref0 (f);
	_g_free0 (real_value);
	_g_free0 (props);
	_g_free0 (uevent_path);
}

/**
     * umockdev_testbed_set_property_int:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property integer value
     *
     * Set an integer udev property for a device.
     */
void
umockdev_testbed_set_property_int (UMockdevTestbed* self,
                                   const gchar* devpath,
                                   const gchar* name,
                                   gint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%i", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_property (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}

/**
     * umockdev_testbed_set_property_hex:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property integer value
     *
     * Set an integer udev property for a device. @value is interpreted as a
     * hexadecimal number. For example, for value==31 this sets the property's
     * value to "1f".
     */
void
umockdev_testbed_set_property_hex (UMockdevTestbed* self,
                                   const gchar* devpath,
                                   const gchar* name,
                                   guint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%x", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_property (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
umockdev_testbed_add_devicev_no_uevent (UMockdevTestbed* self,
                                        const gchar* subsystem,
                                        const gchar* name,
                                        const gchar* parent,
                                        gchar** attributes,
                                        gchar** properties)
{
	gchar* dev_path = NULL;
	gchar* dev_node = NULL;
	gchar* dev_dir = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gchar* dev_path_no_sys = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* props = NULL;
	gchar* _tmp64_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	dev_node = NULL;
	if (parent != NULL) {
		gchar* _tmp0_;
		if (!g_str_has_prefix (parent, "/sys/")) {
			g_critical ("umockdev.vala:420: add_devicev(): parent device %s does not start with" \
" /sys/", parent);
			result = NULL;
			_g_free0 (dev_node);
			_g_free0 (dev_path);
			return result;
		}
		if (!g_file_test (parent, G_FILE_TEST_IS_DIR)) {
			g_critical ("umockdev.vala:424: add_devicev(): parent device %s does not exist", parent);
			result = NULL;
			_g_free0 (dev_node);
			_g_free0 (dev_path);
			return result;
		}
		_tmp0_ = g_build_filename (parent, name, NULL);
		_g_free0 (dev_path);
		dev_path = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_build_filename ("/sys/devices", name, NULL);
		_g_free0 (dev_path);
		dev_path = _tmp1_;
	}
	_tmp2_ = self->priv->root_dir;
	_tmp3_ = dev_path;
	_tmp4_ = g_build_filename (_tmp2_, _tmp3_, NULL);
	dev_dir = _tmp4_;
	_tmp6_ = dev_dir;
	if (g_file_test (_tmp6_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = dev_dir;
		_tmp8_ = g_build_filename (_tmp7_, "uevent", NULL);
		_tmp9_ = _tmp8_;
		_tmp5_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
		_g_free0 (_tmp9_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp10_;
		_tmp10_ = dev_dir;
		g_error ("umockdev.vala:435: device %s already exists", _tmp10_);
	}
	_tmp11_ = dev_path;
	_tmp12_ = dev_path;
	_tmp13_ = string_substring (_tmp11_, (glong) string_index_of (_tmp12_, "/devices/", 0), (glong) -1);
	dev_path_no_sys = _tmp13_;
	_tmp14_ = dev_dir;
	umockdev_checked_mkdir_with_parents (_tmp14_, 0755);
	if (!umockdev_testbed_subsystem_is_bus (subsystem)) {
		gchar* class_dir = NULL;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp15_ = self->priv->sys_dir;
		_tmp16_ = g_build_filename (_tmp15_, "class", subsystem, NULL);
		class_dir = _tmp16_;
		_tmp17_ = class_dir;
		umockdev_checked_mkdir_with_parents (_tmp17_, 0755);
		_tmp18_ = dev_path;
		_tmp19_ = umockdev_make_dotdots (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_build_filename (_tmp20_, "class", subsystem, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = dev_dir;
		_tmp24_ = g_build_filename (_tmp23_, "subsystem", NULL);
		_tmp25_ = _tmp24_;
		_vala_assert (symlink (_tmp22_, _tmp25_) == 0, "FileUtils.symlink(Path.build_filename(make_dotdots(dev_path), \"class\", subsystem),                                      Path.build_filename(dev_dir, \"subsystem\")) == 0");
		_g_free0 (_tmp25_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_tmp26_ = dev_path_no_sys;
		_tmp27_ = g_build_filename ("..", "..", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = class_dir;
		_tmp30_ = g_path_get_basename (name);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_build_filename (_tmp29_, _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_vala_assert (symlink (_tmp28_, _tmp33_) == 0, "FileUtils.symlink(Path.build_filename(\"..\", \"..\", dev_path_no_sys),                                      Path.build_filename(class_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp28_);
		_g_free0 (class_dir);
	} else {
		gchar* bus_dir = NULL;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp34_ = self->priv->sys_dir;
		_tmp35_ = g_build_filename (_tmp34_, "bus", subsystem, "devices", NULL);
		bus_dir = _tmp35_;
		_tmp36_ = bus_dir;
		umockdev_checked_mkdir_with_parents (_tmp36_, 0755);
		_tmp37_ = dev_path_no_sys;
		_tmp38_ = g_build_filename ("..", "..", "..", _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = bus_dir;
		_tmp41_ = g_path_get_basename (name);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_build_filename (_tmp40_, _tmp42_, NULL);
		_tmp44_ = _tmp43_;
		_vala_assert (symlink (_tmp39_, _tmp44_) == 0, "FileUtils.symlink(Path.build_filename(\"..\", \"..\", \"..\", dev_path_no_sys),                                      Path.build_filename(bus_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp44_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp39_);
		_tmp45_ = dev_path;
		_tmp46_ = umockdev_make_dotdots (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_build_filename (_tmp47_, "bus", subsystem, NULL);
		_tmp49_ = _tmp48_;
		_tmp50_ = dev_dir;
		_tmp51_ = g_build_filename (_tmp50_, "subsystem", NULL);
		_tmp52_ = _tmp51_;
		_vala_assert (symlink (_tmp49_, _tmp52_) == 0, "FileUtils.symlink(Path.build_filename(make_dotdots(dev_path), \"bus\", subsystem),                                      Path.build_filename(dev_dir, \"subsystem\")) == 0");
		_g_free0 (_tmp52_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
		_g_free0 (bus_dir);
	}
	if (g_strcmp0 (subsystem, "block") == 0) {
		gchar* block_dir = NULL;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		const gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp53_ = self->priv->sys_dir;
		_tmp54_ = g_build_filename (_tmp53_, "block", NULL);
		block_dir = _tmp54_;
		_tmp55_ = block_dir;
		umockdev_checked_mkdir_with_parents (_tmp55_, 0755);
		_tmp56_ = dev_path_no_sys;
		_tmp57_ = g_build_filename ("..", _tmp56_, NULL);
		_tmp58_ = _tmp57_;
		_tmp59_ = block_dir;
		_tmp60_ = g_path_get_basename (name);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_build_filename (_tmp59_, _tmp61_, NULL);
		_tmp63_ = _tmp62_;
		_vala_assert (symlink (_tmp58_, _tmp63_) == 0, "FileUtils.symlink(Path.build_filename(\"..\", dev_path_no_sys),                                      Path.build_filename(block_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp63_);
		_g_free0 (_tmp61_);
		_g_free0 (_tmp58_);
		_g_free0 (block_dir);
	}
	_tmp64_ = g_strdup ("");
	props = _tmp64_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp65_ = FALSE;
			_tmp65_ = TRUE;
			while (TRUE) {
				gboolean _tmp66_ = FALSE;
				const gchar* _tmp67_;
				if (!_tmp65_) {
					i += 2;
				}
				_tmp65_ = FALSE;
				if (!(i < (_vala_array_length (properties) - 1))) {
					break;
				}
				_tmp67_ = properties[i];
				if (g_strcmp0 (_tmp67_, "DEVNAME") == 0) {
					const gchar* _tmp68_;
					_tmp68_ = properties[i + 1];
					_tmp66_ = g_str_has_prefix (_tmp68_, "/dev/");
				} else {
					_tmp66_ = FALSE;
				}
				if (_tmp66_) {
					const gchar* _tmp69_;
					gchar* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					_tmp69_ = properties[i + 1];
					_tmp70_ = string_substring (_tmp69_, (glong) 5, (glong) -1);
					_g_free0 (dev_node);
					dev_node = _tmp70_;
					_tmp71_ = props;
					_tmp72_ = dev_node;
					_tmp73_ = g_strconcat ("DEVNAME=", _tmp72_, NULL);
					_tmp74_ = _tmp73_;
					_tmp75_ = g_strconcat (_tmp74_, "\n", NULL);
					_tmp76_ = _tmp75_;
					_tmp77_ = g_strconcat (_tmp71_, _tmp76_, NULL);
					_g_free0 (props);
					props = _tmp77_;
					_g_free0 (_tmp76_);
					_g_free0 (_tmp74_);
				} else {
					const gchar* _tmp78_;
					const gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					const gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					gchar* _tmp86_;
					gchar* _tmp87_;
					_tmp78_ = props;
					_tmp79_ = properties[i];
					_tmp80_ = g_strconcat (_tmp79_, "=", NULL);
					_tmp81_ = _tmp80_;
					_tmp82_ = properties[i + 1];
					_tmp83_ = g_strconcat (_tmp81_, _tmp82_, NULL);
					_tmp84_ = _tmp83_;
					_tmp85_ = g_strconcat (_tmp84_, "\n", NULL);
					_tmp86_ = _tmp85_;
					_tmp87_ = g_strconcat (_tmp78_, _tmp86_, NULL);
					_g_free0 (props);
					props = _tmp87_;
					_g_free0 (_tmp86_);
					_g_free0 (_tmp84_);
					_g_free0 (_tmp81_);
				}
			}
		}
	}
	if ((_vala_array_length (properties) % 2) != 0) {
		const gchar* _tmp88_;
		_tmp88_ = properties[_vala_array_length (properties) - 1];
		g_warning ("umockdev.vala:486: add_devicev: Ignoring property key '%s' without val" \
"ue", _tmp88_);
	}
	_tmp89_ = dev_path;
	_tmp90_ = props;
	umockdev_testbed_set_attribute (self, _tmp89_, "uevent", _tmp90_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp91_ = FALSE;
			_tmp91_ = TRUE;
			while (TRUE) {
				const gchar* _tmp92_;
				const gchar* _tmp93_;
				const gchar* _tmp94_;
				gboolean _tmp95_ = FALSE;
				const gchar* _tmp96_;
				if (!_tmp91_) {
					i += 2;
				}
				_tmp91_ = FALSE;
				if (!(i < (_vala_array_length (attributes) - 1))) {
					break;
				}
				_tmp92_ = dev_path;
				_tmp93_ = attributes[i];
				_tmp94_ = attributes[i + 1];
				umockdev_testbed_set_attribute (self, _tmp92_, _tmp93_, _tmp94_);
				_tmp96_ = attributes[i];
				if (g_strcmp0 (_tmp96_, "dev") == 0) {
					const gchar* _tmp97_;
					_tmp97_ = dev_node;
					_tmp95_ = _tmp97_ != NULL;
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					gchar* val = NULL;
					const gchar* _tmp98_;
					gchar* _tmp99_;
					gchar* infodir = NULL;
					const gchar* _tmp100_;
					gchar* _tmp101_;
					const gchar* _tmp102_;
					const gchar* _tmp103_;
					const gchar* _tmp104_;
					const gchar* _tmp105_;
					gchar* _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					gchar* _tmp109_;
					const gchar* _tmp110_ = NULL;
					const gchar* _tmp111_;
					gchar* sysdev_dir = NULL;
					const gchar* _tmp112_;
					gchar* _tmp113_;
					const gchar* _tmp114_;
					gchar* dest = NULL;
					const gchar* _tmp115_;
					const gchar* _tmp116_;
					gchar* _tmp117_;
					const gchar* _tmp118_;
					_tmp98_ = attributes[i + 1];
					_tmp99_ = string_strip (_tmp98_);
					val = _tmp99_;
					_tmp100_ = self->priv->root_dir;
					_tmp101_ = g_build_filename (_tmp100_, "dev", ".node", NULL);
					infodir = _tmp101_;
					_tmp102_ = infodir;
					umockdev_checked_mkdir_with_parents (_tmp102_, 0755);
					_tmp103_ = val;
					_tmp104_ = infodir;
					_tmp105_ = dev_node;
					_tmp106_ = string_replace (_tmp105_, "/", "_");
					_tmp107_ = _tmp106_;
					_tmp108_ = g_build_filename (_tmp104_, _tmp107_, NULL);
					_tmp109_ = _tmp108_;
					_vala_assert (symlink (_tmp103_, _tmp109_) == 0, "FileUtils.symlink(val, Path.build_filename(infodir, dev_node.replace(\"/\", \"_\"))) == 0");
					_g_free0 (_tmp109_);
					_g_free0 (_tmp107_);
					_tmp111_ = dev_path;
					if (string_contains (_tmp111_, "/block/")) {
						_tmp110_ = "block";
					} else {
						_tmp110_ = "char";
					}
					_tmp112_ = self->priv->sys_dir;
					_tmp113_ = g_build_filename (_tmp112_, "dev", _tmp110_, NULL);
					sysdev_dir = _tmp113_;
					_tmp114_ = sysdev_dir;
					umockdev_checked_mkdir_with_parents (_tmp114_, 0755);
					_tmp115_ = sysdev_dir;
					_tmp116_ = val;
					_tmp117_ = g_build_filename (_tmp115_, _tmp116_, NULL);
					dest = _tmp117_;
					_tmp118_ = dest;
					if (!g_file_test (_tmp118_, G_FILE_TEST_EXISTS)) {
						const gchar* _tmp119_;
						gchar* _tmp120_;
						gchar* _tmp121_;
						gchar* _tmp122_;
						gchar* _tmp123_;
						const gchar* _tmp124_;
						gboolean _tmp125_;
						_tmp119_ = dev_path;
						_tmp120_ = string_substring (_tmp119_, (glong) 5, (glong) -1);
						_tmp121_ = _tmp120_;
						_tmp122_ = g_strconcat ("../../", _tmp121_, NULL);
						_tmp123_ = _tmp122_;
						_tmp124_ = dest;
						_tmp125_ = symlink (_tmp123_, _tmp124_) < 0;
						_g_free0 (_tmp123_);
						_g_free0 (_tmp121_);
						if (_tmp125_) {
							const gchar* _tmp126_;
							const gchar* _tmp127_;
							gchar* _tmp128_;
							gchar* _tmp129_;
							_tmp126_ = dest;
							_tmp127_ = dev_path;
							_tmp128_ = string_substring (_tmp127_, (glong) 5, (glong) -1);
							_tmp129_ = _tmp128_;
							g_error ("umockdev.vala:506: add_device %s: failed to symlink %s to %s: %m", name, _tmp126_, _tmp129_);
							_g_free0 (_tmp129_);
						}
					}
					_g_free0 (dest);
					_g_free0 (sysdev_dir);
					_g_free0 (infodir);
					_g_free0 (val);
				}
			}
		}
	}
	if ((_vala_array_length (attributes) % 2) != 0) {
		const gchar* _tmp130_;
		_tmp130_ = attributes[_vala_array_length (attributes) - 1];
		g_warning ("umockdev.vala:512: add_devicev: Ignoring attribute key '%s' without va" \
"lue", _tmp130_);
	}
	result = dev_path;
	_g_free0 (props);
	_g_free0 (dev_path_no_sys);
	_g_free0 (dev_dir);
	_g_free0 (dev_node);
	return result;
}

/**
     * umockdev_testbed_add_devicev:
     * @self: A #UMockdevTestbed.
     * @subsystem: The subsystem name, e. g. "usb"
     * @name: The device name; arbitrary, but needs to be unique within the testbed
     * @parent: (allow-none): device path of the parent device. Use %NULL for a
     *          top-level device.
     * @attributes: (array zero-terminated=1):
     *              A list of device sysfs attributes, alternating names and
     *              values, terminated with %NULL:
     *              { "key1", "value1", "key2", "value2", ..., NULL }
     * @properties: (array zero-terminated=1):
     *              A list of device udev properties; same format as @attributes
     *
     * This method is mostly meant for language bindings (where it is named
     * umockdev_testbed_add_device()). For C programs it is usually more convenient to
     * use umockdev_testbed_add_device().
     *
     * Add a new device to the testbed. A Linux kernel device always has a
     * subsystem (such as "usb" or "pci"), and a device name. The test bed only
     * builds a very simple sysfs structure without nested namespaces, so it
     * requires device names to be unique. Some gudev client programs might make
     * assumptions about the name (e. g. a SCSI disk block device should be called
     * sdaN). A device also has an arbitrary number of sysfs attributes and udev
     * properties; usually you should specify them upon creation, but it is also
     * possible to change them later on with umockdev_testbed_set_attribute() and
     * umockdev_testbed_set_property().
     *
     * If the pseudo-property "__DEVCONTEXT" is present, the SELinux context of the device's
     * DEVNODE will be set to that value.
     *
     * This will synthesize an "add" uevent.
     *
     * Returns: The sysfs path for the newly created device. Free with g_free().
     *
     * Rename to: umockdev_testbed_add_device
     */
gchar*
umockdev_testbed_add_devicev (UMockdevTestbed* self,
                              const gchar* subsystem,
                              const gchar* name,
                              const gchar* parent,
                              gchar** attributes,
                              gchar** properties)
{
	gchar* dev_path = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = umockdev_testbed_add_devicev_no_uevent (self, subsystem, name, parent, attributes, properties);
	dev_path = _tmp0_;
	_tmp2_ = dev_path;
	if (_tmp2_ != NULL) {
		_tmp1_ = umockdev_in_mock_environment ();
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp3_;
		_tmp3_ = dev_path;
		umockdev_testbed_uevent (self, _tmp3_, "add");
	}
	result = dev_path;
	return result;
}

/**
     * umockdev_testbed_add_device: (skip)
     * @self: A #UMockdevTestbed.
     * @subsystem: The subsystem name, e. g. "usb"
     * @name: The device name; arbitrary, but needs to be unique within the testbed
     * @parent: (allow-none): device path of the parent device. Use %NULL for a
     *          top-level device.
     * @...: Arbitrarily many pairs of sysfs attributes (alternating names and
     *       values), terminated by %NULL, followed by arbitrarily many pairs of udev
     *       properties, terminated by another %NULL.
     *
     * Add a new device to the testbed. A Linux kernel device always has a
     * subsystem (such as "usb" or "pci"), and a device name. The test bed only
     * builds a very simple sysfs structure without nested namespaces, so it
     * requires device names to be unique. Some gudev client programs might make
     * assumptions about the name (e. g. a SCSI disk block device should be called
     * sdaN). A device also has an arbitrary number of sysfs attributes and udev
     * properties; usually you should specify them upon creation, but it is also
     * possible to change them later on with umockdev_testbed_set_attribute() and
     * umockdev_testbed_set_property().
     *
     * If the pseudo-property "__DEVCONTEXT" is present, the SELinux context of the device's
     * DEVNODE will be set to that value.
     *
     * This will synthesize an "add" uevent.
     *
     * Example:
     *   |[
     *   umockdev_testbed_add_device (testbed, "usb", "dev1", NULL,
     *                              "idVendor", "0815", "idProduct", "AFFE", NULL,
     *                              "ID_MODEL", "KoolGadget", NULL);
     *   ]|
     *
     * Returns: The sysfs path for the newly created device. Free with g_free().
     */
static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar*
umockdev_testbed_add_device (UMockdevTestbed* self,
                             const gchar* subsystem,
                             const gchar* name,
                             const gchar* parent,
                             ...)
{
	gchar** attributes = NULL;
	gchar** _tmp0_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** properties = NULL;
	gchar** _tmp1_;
	gint properties_length1;
	gint _properties_size_;
	gint arg_set = 0;
	va_list l = {0};
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	attributes = _tmp0_;
	attributes_length1 = 0;
	_attributes_size_ = attributes_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	properties = _tmp1_;
	properties_length1 = 0;
	_properties_size_ = properties_length1;
	arg_set = 0;
	va_start (l, parent);
	while (TRUE) {
		gchar* arg = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = va_arg (l, gchar*);
		_tmp3_ = g_strdup (_tmp2_);
		arg = _tmp3_;
		_tmp4_ = arg;
		if (_tmp4_ == NULL) {
			gint _tmp5_;
			arg_set = arg_set + 1;
			_tmp5_ = arg_set;
			if (_tmp5_ > 1) {
				_g_free0 (arg);
				break;
			} else {
				_g_free0 (arg);
				continue;
			}
		}
		if (arg_set == 0) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = arg;
			_tmp7_ = g_strdup (_tmp6_);
			_vala_array_add1 (&attributes, &attributes_length1, &_attributes_size_, _tmp7_);
		} else {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = arg;
			_tmp9_ = g_strdup (_tmp8_);
			_vala_array_add2 (&properties, &properties_length1, &_properties_size_, _tmp9_);
		}
		_g_free0 (arg);
	}
	_tmp10_ = attributes;
	_tmp10__length1 = attributes_length1;
	_tmp11_ = properties;
	_tmp11__length1 = properties_length1;
	_tmp12_ = umockdev_testbed_add_devicev (self, subsystem, name, parent, _tmp10_, _tmp11_);
	result = _tmp12_;
	va_end (l);
	properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_free), NULL);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
     * umockdev_testbed_remove_device:
     * @self: A #UMockdevTestbed.
     * @syspath: Sysfs path of device
     *
     * Remove a device from the testbed. This removes the sysfs directory, the
     * /sys/class/ link, the device node, and all other information related to
     * it. Note that this will also remove all child devices (i. e.
     * subdirectories of @syspath).
     */
void
umockdev_testbed_remove_device (UMockdevTestbed* self,
                                const gchar* syspath)
{
	gchar* real_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* path = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (syspath != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, syspath, NULL);
	real_path = _tmp1_;
	_tmp2_ = real_path;
	if (!g_file_test (_tmp2_, G_FILE_TEST_IS_DIR)) {
		g_critical ("umockdev.vala:642: umockdev_testbed_remove_device(): device %s does no" \
"t exist", syspath);
		_g_free0 (real_path);
		return;
	}
	_tmp3_ = real_path;
	_tmp4_ = g_build_filename (_tmp3_, "uevent", NULL);
	path = _tmp4_;
	_tmp5_ = path;
	if (!g_file_test (_tmp5_, G_FILE_TEST_IS_REGULAR)) {
		g_critical ("umockdev.vala:648: umockdev_testbed_remove_device(): device %s does no" \
"t appear to be a device", syspath);
		_g_free0 (path);
		_g_free0 (real_path);
		return;
	}
	umockdev_testbed_remove_with_children (self, syspath);
	_g_free0 (path);
	_g_free0 (real_path);
}

static void
umockdev_testbed_remove_with_children (UMockdevTestbed* self,
                                       const gchar* syspath)
{
	gchar* real_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* devname = NULL;
	gchar* _tmp21_;
	gchar* subsystem = NULL;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp81_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (syspath != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, syspath, NULL);
	real_path = _tmp1_;
	{
		GDir* dir = NULL;
		const gchar* _tmp2_;
		GDir* _tmp3_;
		gchar* name = NULL;
		_tmp2_ = real_path;
		_tmp3_ = g_dir_open (_tmp2_, (guint) 0, &_inner_error0_);
		dir = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		name = NULL;
		while (TRUE) {
			GDir* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* path = NULL;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp4_ = dir;
			_tmp5_ = g_dir_read_name (_tmp4_);
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (name);
			name = _tmp6_;
			_tmp7_ = name;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = real_path;
			_tmp9_ = name;
			_tmp10_ = g_build_filename (_tmp8_, _tmp9_, NULL);
			path = _tmp10_;
			_tmp11_ = path;
			if (g_file_test (_tmp11_, G_FILE_TEST_IS_SYMLINK)) {
				_g_free0 (path);
				continue;
			}
			_tmp12_ = path;
			if (g_file_test (_tmp12_, G_FILE_TEST_IS_DIR)) {
				gchar* child_syspath = NULL;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp13_ = name;
				_tmp14_ = g_build_filename (syspath, _tmp13_, NULL);
				child_syspath = _tmp14_;
				_tmp15_ = child_syspath;
				umockdev_testbed_remove_with_children (self, _tmp15_);
				_g_free0 (child_syspath);
			}
			_g_free0 (path);
		}
		_g_free0 (name);
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_critical ("umockdev.vala:676: umockdev_testbed_remove_device(): cannot determine " \
"children of %s: %s", syspath, _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp18_ = real_path;
	_tmp19_ = g_build_filename (_tmp18_, "uevent", NULL);
	path = _tmp19_;
	_tmp20_ = path;
	if (!g_file_test (_tmp20_, G_FILE_TEST_IS_REGULAR)) {
		_g_free0 (path);
		_g_free0 (real_path);
		return;
	}
	_tmp21_ = g_path_get_basename (syspath);
	devname = _tmp21_;
	{
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp23_ = real_path;
		_tmp24_ = g_build_filename (_tmp23_, "subsystem", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_file_read_link (_tmp25_, &_inner_error0_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_tmp22_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_free0 (subsystem);
			_g_free0 (devname);
			_g_free0 (path);
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp28_ = g_path_get_basename (_tmp22_);
		_g_free0 (subsystem);
		subsystem = _tmp28_;
		_g_free0 (_tmp22_);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_critical ("umockdev.vala:697: umockdev_testbed_remove_device(): cannot determine " \
"subsystem of %s: %s", syspath, _tmp30_);
		_g_error_free0 (e);
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (path);
		_g_free0 (real_path);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (path);
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	umockdev_testbed_uevent (self, syspath, "remove");
	{
		gchar* dev_maj_min = NULL;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* dev_node = NULL;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		const gchar* _tmp42_;
		_tmp31_ = real_path;
		_tmp32_ = g_build_filename (_tmp31_, "dev", NULL);
		_tmp33_ = _tmp32_;
		g_file_get_contents (_tmp33_, &_tmp34_, NULL, &_inner_error0_);
		_g_free0 (dev_maj_min);
		dev_maj_min = _tmp34_;
		_g_free0 (_tmp33_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (dev_maj_min);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			_g_free0 (subsystem);
			_g_free0 (devname);
			_g_free0 (path);
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (string_contains (syspath, "/block/")) {
			_tmp35_ = "block";
		} else {
			_tmp35_ = "char";
		}
		_tmp36_ = self->priv->sys_dir;
		_tmp37_ = dev_maj_min;
		_tmp38_ = g_build_filename (_tmp36_, "dev", _tmp35_, _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		g_unlink (_tmp39_);
		_g_free0 (_tmp39_);
		_tmp40_ = real_path;
		_tmp41_ = umockdev_find_devnode (_tmp40_);
		dev_node = _tmp41_;
		_tmp42_ = dev_node;
		if (_tmp42_ != NULL) {
			gchar* real_node = NULL;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			_tmp43_ = self->priv->root_dir;
			_tmp44_ = dev_node;
			_tmp45_ = g_build_filename (_tmp43_, _tmp44_, NULL);
			real_node = _tmp45_;
			_tmp46_ = real_node;
			g_unlink (_tmp46_);
			_tmp47_ = real_node;
			_tmp48_ = g_path_get_dirname (_tmp47_);
			_tmp49_ = _tmp48_;
			g_rmdir (_tmp49_);
			_g_free0 (_tmp49_);
			_tmp50_ = self->priv->root_dir;
			_tmp51_ = dev_node;
			_tmp52_ = string_substring (_tmp51_, (glong) 5, (glong) -1);
			_tmp53_ = _tmp52_;
			_tmp54_ = string_replace (_tmp53_, "/", "_");
			_tmp55_ = _tmp54_;
			_tmp56_ = g_build_filename (_tmp50_, "dev", ".node", _tmp55_, NULL);
			_tmp57_ = _tmp56_;
			g_unlink (_tmp57_);
			_g_free0 (_tmp57_);
			_g_free0 (_tmp55_);
			_g_free0 (_tmp53_);
			_g_free0 (real_node);
		}
		_g_free0 (dev_node);
		_g_free0 (dev_maj_min);
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (path);
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp58_ = self->priv->sys_dir;
	_tmp59_ = subsystem;
	_tmp60_ = devname;
	_tmp61_ = g_build_filename (_tmp58_, "class", _tmp59_, _tmp60_, NULL);
	_tmp62_ = _tmp61_;
	g_unlink (_tmp62_);
	_g_free0 (_tmp62_);
	_tmp63_ = self->priv->sys_dir;
	_tmp64_ = subsystem;
	_tmp65_ = g_build_filename (_tmp63_, "class", _tmp64_, NULL);
	_tmp66_ = _tmp65_;
	g_rmdir (_tmp66_);
	_g_free0 (_tmp66_);
	_tmp67_ = subsystem;
	if (umockdev_testbed_subsystem_is_bus (_tmp67_)) {
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		const gchar* _tmp73_;
		const gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		_tmp68_ = self->priv->sys_dir;
		_tmp69_ = subsystem;
		_tmp70_ = devname;
		_tmp71_ = g_build_filename (_tmp68_, "bus", _tmp69_, "devices", _tmp70_, NULL);
		_tmp72_ = _tmp71_;
		g_unlink (_tmp72_);
		_g_free0 (_tmp72_);
		_tmp73_ = self->priv->sys_dir;
		_tmp74_ = subsystem;
		_tmp75_ = g_build_filename (_tmp73_, "bus", _tmp74_, "devices", NULL);
		_tmp76_ = _tmp75_;
		g_rmdir (_tmp76_);
		_g_free0 (_tmp76_);
		_tmp77_ = self->priv->sys_dir;
		_tmp78_ = subsystem;
		_tmp79_ = g_build_filename (_tmp77_, "bus", _tmp78_, NULL);
		_tmp80_ = _tmp79_;
		g_rmdir (_tmp80_);
		_g_free0 (_tmp80_);
	}
	_tmp81_ = real_path;
	umockdev_utils_remove_dir (_tmp81_, TRUE);
	_g_free0 (subsystem);
	_g_free0 (devname);
	_g_free0 (path);
	_g_free0 (real_path);
}

/**
     * umockdev_testbed_add_from_string:
     * @self: A #UMockdevTestbed.
     * @data: Description of the device(s) as generated with umockdev-record
     * @error: return location for a GError, or %NULL
     *
     * Add a set of devices to the testbed from a textual description. This reads
     * the format generated by the umockdev-record tool.
     *
     * Each paragraph defines one device. A line starts with a type tag (like 'E'),
     * followed by a colon, followed by either a value or a "key=value" assignment,
     * depending on the type tag. A device description must start with a 'P:' line.
     * Available type tags are:
     * <itemizedlist>
     *   <listitem><type>P:</type> <emphasis>path</emphasis>: device path in sysfs, starting with
     *             <filename>/devices/</filename>; must occur exactly once at the
     *             start of device definition</listitem>
     *   <listitem><type>E:</type> <emphasis>key=value</emphasis>: udev property
     *             </listitem>
     *   <listitem><type>A:</type> <emphasis>key=value</emphasis>: ASCII sysfs
     *             attribute, with backslash-style escaping of \ (\\) and newlines
     *             (\n)</listitem>
     *   <listitem><type>H:</type> <emphasis>key=value</emphasis>: binary sysfs
     *             attribute, with the value being written as continuous hex string
     *             (e. g. 0081FE0A..)</listitem>
     *   <listitem><type>N:</type> <emphasis>devname</emphasis>[=<emphasis>contents</emphasis>]:
     *             device node name (without the <filename>/dev/</filename>
     *             prefix); if <emphasis>contents</emphasis> is given (encoded in a
     *             continuous hex string), it creates a
     *             <filename>/dev/devname</filename> in the mock environment with
     *             the given contents, otherwise the created dev file will be a
     *             pty; see #umockdev_testbed_get_dev_fd for details.</listitem>
     *   <listitem><type>S:</type> <emphasis>linkname</emphasis>: device node
     *             symlink (without the <filename>/dev/</filename> prefix); ignored right
     *             now.</listitem>
     * </itemizedlist>
     *
     * Returns: %TRUE on success, %FALSE if the data is invalid and an error
     *          occurred.
     */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
umockdev_testbed_add_from_string (UMockdevTestbed* self,
                                  const gchar* data,
                                  GError** error)
{
	gchar* cur_data = NULL;
	gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	{
		GRegex* _tmp0_;
		GRegex* _tmp5_;
		GRegex* _tmp10_;
		_tmp0_ = self->priv->re_record_val;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp4_;
			_tmp2_ = g_regex_new ("^([PS]): (.*)(?>\n|$)", 0, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp3_ = FALSE;
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp3_;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (self->priv->re_record_val);
			self->priv->re_record_val = _tmp4_;
			_g_regex_unref0 (_tmp1_);
		}
		_tmp5_ = self->priv->re_record_keyval;
		if (_tmp5_ == NULL) {
			GRegex* _tmp6_ = NULL;
			GRegex* _tmp7_;
			GRegex* _tmp9_;
			_tmp7_ = g_regex_new ("^([EAHL]): ([^=\n]+)=(.*)(?>\n|$)", 0, 0, &_inner_error0_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp8_ = FALSE;
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp8_;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_regex_unref0 (self->priv->re_record_keyval);
			self->priv->re_record_keyval = _tmp9_;
			_g_regex_unref0 (_tmp6_);
		}
		_tmp10_ = self->priv->re_record_optval;
		if (_tmp10_ == NULL) {
			GRegex* _tmp11_ = NULL;
			GRegex* _tmp12_;
			GRegex* _tmp14_;
			_tmp12_ = g_regex_new ("^([N]): ([^=\n]+)(?>=([0-9A-F]+))?(?>\n|$)", 0, 0, &_inner_error0_);
			_tmp11_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp13_ = FALSE;
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp13_;
			}
			_tmp14_ = _tmp11_;
			_tmp11_ = NULL;
			_g_regex_unref0 (self->priv->re_record_optval);
			self->priv->re_record_optval = _tmp14_;
			_g_regex_unref0 (_tmp11_);
		}
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e->message;
		g_error ("umockdev.vala:786: Internal error, cannot create regex: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == UMOCKDEV_ERROR) {
			gboolean _tmp16_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp16_;
		} else {
			gboolean _tmp17_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp17_;
		}
	}
	_tmp18_ = g_strdup (data);
	cur_data = _tmp18_;
	while (TRUE) {
		const gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp25_;
		_tmp19_ = cur_data;
		if (!(string_get (_tmp19_, (glong) 0) != '\0')) {
			break;
		}
		_tmp21_ = cur_data;
		_tmp22_ = umockdev_testbed_add_dev_from_string (self, _tmp21_, &_inner_error0_);
		_tmp20_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == UMOCKDEV_ERROR) {
				gboolean _tmp23_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (cur_data);
				return _tmp23_;
			} else {
				gboolean _tmp24_ = FALSE;
				_g_free0 (cur_data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp24_;
			}
		}
		_tmp25_ = _tmp20_;
		_tmp20_ = NULL;
		_g_free0 (cur_data);
		cur_data = _tmp25_;
		_g_free0 (_tmp20_);
	}
	result = TRUE;
	_g_free0 (cur_data);
	return result;
}

/**
     * umockdev_testbed_add_from_file:
     * @self: A #UMockdevTestbed.
     * @path: Path to file with description of the device(s) as generated with umockdev-record
     * @error: return location for a GError, or %NULL
     *
     * Add a set of devices to the testbed from a textual description. This
     * reads a file with the format generated by the umockdev-record tool, and
     * is mostly a convenience wrapper around
     * @umockdev_testbed_add_from_string.
     *
     * Returns: %TRUE on success, %FALSE if the @path cannot be read or thhe
     *          data is invalid and an error occurred.
     */
gboolean
umockdev_testbed_add_from_file (UMockdevTestbed* self,
                                const gchar* path,
                                GError** error)
{
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_file_get_contents (path, &_tmp0_, NULL, &_inner_error0_);
	_g_free0 (contents);
	contents = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == UMOCKDEV_ERROR) || (_inner_error0_->domain == G_FILE_ERROR)) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (contents);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp4_ = contents;
	_tmp3_ = umockdev_testbed_add_from_string (self, _tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == UMOCKDEV_ERROR) || (_inner_error0_->domain == G_FILE_ERROR)) {
			gboolean _tmp5_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (contents);
			return _tmp5_;
		} else {
			gboolean _tmp6_ = FALSE;
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	result = _tmp3_;
	_g_free0 (contents);
	return result;
}

/**
     * umockdev_testbed_uevent:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @action: "add", "remove", or "change"
     *
     * Generate an uevent for a device.
     */
void
umockdev_testbed_uevent (UMockdevTestbed* self,
                         const gchar* devpath,
                         const gchar* action)
{
	uevent_sender* ev_sender = NULL;
	const gchar* _tmp0_;
	uevent_sender* _tmp1_;
	uevent_sender* _tmp2_;
	gchar* uevent_path = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* properties = NULL;
	gchar* _tmp5_;
	uevent_sender* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (action != NULL);
	ev_sender = NULL;
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = uevent_sender_open (_tmp0_);
	_uevent_sender_close0 (ev_sender);
	ev_sender = _tmp1_;
	_tmp2_ = ev_sender;
	_vala_assert (_tmp2_ != NULL, "ev_sender != null");
	g_debug ("umockdev.vala:832: umockdev_testbed_uevent: sending uevent %s for devi" \
"ce %s", action, devpath);
	_tmp3_ = self->priv->root_dir;
	_tmp4_ = g_build_filename (_tmp3_, devpath, "uevent", NULL);
	uevent_path = _tmp4_;
	_tmp5_ = g_strdup ("");
	properties = _tmp5_;
	{
		gchar* _tmp6_ = NULL;
		g_file_get_contents (uevent_path, &_tmp6_, NULL, &_inner_error0_);
		_g_free0 (properties);
		properties = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (properties);
			_g_free0 (uevent_path);
			_uevent_sender_close0 (ev_sender);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_debug ("umockdev.vala:839: uevent: devpath %s has no uevent file: %s", devpath, _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (properties);
		_g_free0 (uevent_path);
		_uevent_sender_close0 (ev_sender);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = ev_sender;
	_tmp10_ = properties;
	uevent_sender_send (_tmp9_, devpath, action, _tmp10_);
	_g_free0 (properties);
	_g_free0 (uevent_path);
	_uevent_sender_close0 (ev_sender);
}

/**
     * umockdev_testbed_attach_ioctl:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) to attach to.
     * @handler: a #UMockdevIoctlBase instance to handle requests
     * @error: return location for a GError, or %NULL
     *
     * Attach an #UMockdevIoctlBase object to handle ioctl, read and write
     * syscalls on the given device file. This allows emulating arbitrary
     * ioctl's and read/write calls for which umockdev does not have builtin
     * support.
     *
     * Returns: %TRUE on success, %FALSE on error.
     * Since: 0.16
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
umockdev_testbed_attach_ioctl (UMockdevTestbed* self,
                               const gchar* dev,
                               UMockdevIoctlBase* handler,
                               GError** error)
{
	GHashTable* _tmp0_;
	gchar* sockpath = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GMainContext* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	UMockdevIoctlBase* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dev != NULL, FALSE);
	g_return_val_if_fail (handler != NULL, FALSE);
	_tmp0_ = self->priv->custom_handlers;
	_vala_assert (!g_hash_table_contains (_tmp0_, dev), "!this.custom_handlers.contains (dev)");
	_tmp1_ = self->priv->root_dir;
	_tmp2_ = g_build_filename (_tmp1_, "ioctl", dev, NULL);
	sockpath = _tmp2_;
	_tmp3_ = self->priv->worker_ctx;
	umockdev_ioctl_base_register_path (handler, _tmp3_, dev, sockpath);
	_tmp4_ = self->priv->custom_handlers;
	_tmp5_ = g_strdup (dev);
	_tmp6_ = _g_object_ref0 (handler);
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp6_);
	result = TRUE;
	_g_free0 (sockpath);
	return result;
}

/**
     * umockdev_testbed_detach_ioctl:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) to detach.
     * @error: return location for a GError, or %NULL
     *
     * Detach a custom #UMockdevIoctlBase object from an device node again. See
     * umockdev_testbed_attach_ioctl(). It is an error to call this function
     * if the path is not currently attached.
     *
     * Returns: %TRUE on success, %FALSE on error.
     * Since: 0.16
     */
gboolean
umockdev_testbed_detach_ioctl (UMockdevTestbed* self,
                               const gchar* dev,
                               GError** error)
{
	UMockdevIoctlBase* handler = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	UMockdevIoctlBase* _tmp2_;
	UMockdevIoctlBase* _tmp3_;
	UMockdevIoctlBase* _tmp6_;
	GHashTable* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dev != NULL, FALSE);
	_tmp0_ = self->priv->custom_handlers;
	_tmp1_ = g_hash_table_lookup (_tmp0_, dev);
	_tmp2_ = _g_object_ref0 ((UMockdevIoctlBase*) _tmp1_);
	handler = _tmp2_;
	_tmp3_ = handler;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "No handler for device was registered.");
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (handler);
		return _tmp5_;
	}
	_tmp6_ = handler;
	umockdev_ioctl_base_unregister_path (_tmp6_, dev);
	_tmp7_ = self->priv->custom_handlers;
	g_hash_table_remove (_tmp7_, dev);
	result = TRUE;
	_g_object_unref0 (handler);
	return result;
}

/**
     * umockdev_testbed_load_ioctl:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the ioctl record.
     *       %NULL is valid; in this case the ioctl record is associated with
     *       the device node it was recorded from.
     * @recordfile: Path of the ioctl record file.
     * @error: return location for a GError, or %NULL
     *
     * Load an ioctl record file for a particular device into the testbed.
     * ioctl records can be created with umockdev-record --ioctl.
     * They can optionally be xz compressed to save space (but then are
     * required to have an .xz file name suffix).
     *
     * Returns: %TRUE on success, %FALSE if the data is invalid and an error
     *          occurred.
     */
static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

gboolean
umockdev_testbed_load_ioctl (UMockdevTestbed* self,
                             const gchar* dev,
                             const gchar* recordfile,
                             GError** error)
{
	gchar* format = NULL;
	gchar* _tmp0_;
	GDataInputStream* recording = NULL;
	gchar* owned_dev = NULL;
	gchar* _tmp1_;
	gchar* line = NULL;
	GDataInputStream* _tmp27_;
	gchar* _tmp28_;
	GMatchInfo* header_matcher = NULL;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp39_;
	GDataInputStream* _tmp52_;
	gchar* dest = NULL;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* contents = NULL;
	GDataInputStream* _tmp63_;
	gchar* _tmp64_;
	const gchar* _tmp66_;
	gboolean _tmp68_ = FALSE;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	UMockdevIoctlBase* handler = NULL;
	const gchar* _tmp72_;
	gchar* sockpath = NULL;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	UMockdevIoctlBase* _tmp80_;
	GMainContext* _tmp81_;
	const gchar* _tmp82_;
	const gchar* _tmp83_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	format = _tmp0_;
	_tmp1_ = g_strdup (dev);
	owned_dev = _tmp1_;
	if (g_str_has_suffix (recordfile, ".xz")) {
		{
			gchar* contents = NULL;
			gint exit = 0;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			gchar* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			const gchar* _tmp10_;
			guint8* _tmp11_;
			gint _tmp11__length1;
			gint _tmp12_ = 0;
			guint8* _tmp13_;
			gint _tmp13__length1;
			guint8* _tmp14_;
			gint _tmp14__length1;
			GMemoryInputStream* _tmp15_;
			GMemoryInputStream* _tmp16_;
			GDataInputStream* _tmp17_;
			_tmp2_ = g_strdup ("xz");
			_tmp3_ = g_strdup ("-cd");
			_tmp4_ = g_strdup (recordfile);
			_tmp5_ = g_new0 (gchar*, 3 + 1);
			_tmp5_[0] = _tmp2_;
			_tmp5_[1] = _tmp3_;
			_tmp5_[2] = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp6__length1 = 3;
			g_spawn_sync (NULL, _tmp6_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp7_, NULL, &_tmp8_, &_inner_error0_);
			_g_free0 (contents);
			contents = _tmp7_;
			exit = _tmp8_;
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp9_ = FALSE;
				_g_free0 (contents);
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				_g_free0 (owned_dev);
				_g_object_unref0 (recording);
				_g_free0 (format);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp9_;
			}
			_vala_assert (exit == 0, "exit == 0");
			_tmp10_ = contents;
			_tmp11_ = string_get_data (_tmp10_, &_tmp12_);
			_tmp11__length1 = _tmp12_;
			_tmp13_ = _tmp11_;
			_tmp13__length1 = _tmp11__length1;
			_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup1 (_tmp13_, _tmp13__length1) : _tmp13_;
			_tmp14__length1 = _tmp13__length1;
			_tmp15_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp14_, _tmp14__length1, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_data_input_stream_new ((GInputStream*) _tmp16_);
			_g_object_unref0 (recording);
			recording = _tmp17_;
			_g_object_unref0 (_tmp16_);
			_g_free0 (contents);
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp18_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp18_ = e->message;
			g_error ("umockdev.vala:935: Cannot call xz to decompress %s: %s", recordfile, _tmp18_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp19_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			_g_free0 (format);
			return _tmp19_;
		}
	} else {
		GFileInputStream* _tmp20_ = NULL;
		GFile* _tmp21_;
		GFile* _tmp22_;
		GFileInputStream* _tmp23_;
		GFileInputStream* _tmp24_;
		GDataInputStream* _tmp26_;
		_tmp21_ = g_file_new_for_path (recordfile);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_file_read (_tmp22_, NULL, &_inner_error0_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		_tmp20_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp25_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			_g_free0 (format);
			return _tmp25_;
		}
		_tmp26_ = g_data_input_stream_new ((GInputStream*) _tmp20_);
		_g_object_unref0 (recording);
		recording = _tmp26_;
		_g_object_unref0 (_tmp20_);
	}
	_tmp27_ = recording;
	_tmp28_ = g_data_input_stream_read_line (_tmp27_, NULL, NULL, &_inner_error0_);
	line = _tmp28_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp29_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		_g_free0 (format);
		return _tmp29_;
	}
	while (TRUE) {
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp31_;
		gchar* _tmp33_ = NULL;
		GDataInputStream* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp37_;
		_tmp31_ = line;
		if (_tmp31_ != NULL) {
			const gchar* _tmp32_;
			_tmp32_ = line;
			_tmp30_ = g_str_has_prefix (_tmp32_, "#");
		} else {
			_tmp30_ = FALSE;
		}
		if (!_tmp30_) {
			break;
		}
		_tmp34_ = recording;
		_tmp35_ = g_data_input_stream_read_line (_tmp34_, NULL, NULL, &_inner_error0_);
		_tmp33_ = _tmp35_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp36_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (line);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			_g_free0 (format);
			return _tmp36_;
		}
		_tmp37_ = _tmp33_;
		_tmp33_ = NULL;
		_g_free0 (line);
		line = _tmp37_;
		_g_free0 (_tmp33_);
	}
	header_matcher = NULL;
	_tmp39_ = line;
	if (_tmp39_ != NULL) {
		GRegex* _tmp40_ = NULL;
		GRegex* _tmp41_;
		const gchar* _tmp43_;
		GMatchInfo* _tmp44_ = NULL;
		gboolean _tmp45_;
		_tmp41_ = g_regex_new ("^@DEV (.*?)( \\((?P<format>[^)]*)\\))?(\n|$)", 0, 0, &_inner_error0_);
		_tmp40_ = _tmp41_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp42_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			_g_free0 (format);
			return _tmp42_;
		}
		_tmp43_ = line;
		_tmp45_ = g_regex_match (_tmp40_, _tmp43_, 0, &_tmp44_);
		_g_match_info_unref0 (header_matcher);
		header_matcher = _tmp44_;
		_tmp38_ = _tmp45_;
		_g_regex_unref0 (_tmp40_);
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		const gchar* _tmp46_;
		GMatchInfo* _tmp49_;
		gchar* _tmp50_;
		_tmp46_ = owned_dev;
		if (_tmp46_ == NULL) {
			GMatchInfo* _tmp47_;
			gchar* _tmp48_;
			_tmp47_ = header_matcher;
			_tmp48_ = g_match_info_fetch (_tmp47_, 1);
			_g_free0 (owned_dev);
			owned_dev = _tmp48_;
		}
		_tmp49_ = header_matcher;
		_tmp50_ = g_match_info_fetch_named (_tmp49_, "format");
		_g_free0 (format);
		format = _tmp50_;
	} else {
		const gchar* _tmp51_;
		_tmp51_ = owned_dev;
		if (_tmp51_ == NULL) {
			g_error ("umockdev.vala:955: null passed for device node, but recording %s has n" \
"o @DEV header", recordfile);
		}
	}
	_tmp52_ = recording;
	g_seekable_seek ((GSeekable*) _tmp52_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp53_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		_g_free0 (format);
		return _tmp53_;
	}
	_tmp54_ = self->priv->root_dir;
	_tmp55_ = owned_dev;
	_tmp56_ = g_strconcat (_tmp55_, ".tree", NULL);
	_tmp57_ = _tmp56_;
	_tmp58_ = g_build_filename (_tmp54_, "ioctl", _tmp57_, NULL);
	_tmp59_ = _tmp58_;
	_g_free0 (_tmp57_);
	dest = _tmp59_;
	_tmp60_ = dest;
	_tmp61_ = g_path_get_dirname (_tmp60_);
	_tmp62_ = _tmp61_;
	umockdev_checked_mkdir_with_parents (_tmp62_, 0755);
	_g_free0 (_tmp62_);
	_tmp63_ = recording;
	_tmp64_ = g_data_input_stream_read_upto (_tmp63_, "", (gssize) 0, NULL, NULL, &_inner_error0_);
	contents = _tmp64_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp65_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (dest);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		_g_free0 (format);
		return _tmp65_;
	}
	_tmp66_ = contents;
	if (_tmp66_ == NULL) {
		gchar* _tmp67_;
		_tmp67_ = g_strdup ("");
		_g_free0 (contents);
		contents = _tmp67_;
	}
	_tmp69_ = dest;
	_tmp70_ = contents;
	_tmp68_ = g_file_set_contents (_tmp69_, _tmp70_, (gssize) -1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp71_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (contents);
		_g_free0 (dest);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		_g_free0 (format);
		return _tmp71_;
	}
	if (!_tmp68_) {
		result = FALSE;
		_g_free0 (contents);
		_g_free0 (dest);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		_g_free0 (format);
		return result;
	}
	_tmp72_ = format;
	if (g_strcmp0 (_tmp72_, "SPI") == 0) {
		const gchar* _tmp73_;
		UMockdevIoctlSpiHandler* _tmp74_;
		_tmp73_ = dest;
		_tmp74_ = umockdev_ioctl_spi_handler_new (_tmp73_);
		_g_object_unref0 (handler);
		handler = (UMockdevIoctlBase*) _tmp74_;
	} else {
		const gchar* _tmp75_;
		UMockdevIoctlTreeHandler* _tmp76_;
		_tmp75_ = dest;
		_tmp76_ = umockdev_ioctl_tree_handler_new (_tmp75_);
		_g_object_unref0 (handler);
		handler = (UMockdevIoctlBase*) _tmp76_;
	}
	_tmp77_ = self->priv->root_dir;
	_tmp78_ = owned_dev;
	_tmp79_ = g_build_filename (_tmp77_, "ioctl", _tmp78_, NULL);
	sockpath = _tmp79_;
	_tmp80_ = handler;
	_tmp81_ = self->priv->worker_ctx;
	_tmp82_ = owned_dev;
	_tmp83_ = sockpath;
	umockdev_ioctl_base_register_path (_tmp80_, _tmp81_, _tmp82_, _tmp83_);
	result = TRUE;
	_g_free0 (sockpath);
	_g_object_unref0 (handler);
	_g_free0 (contents);
	_g_free0 (dest);
	_g_match_info_unref0 (header_matcher);
	_g_free0 (line);
	_g_free0 (owned_dev);
	_g_object_unref0 (recording);
	_g_free0 (format);
	return result;
}

/**
     * umockdev_testbed_load_pcap:
     * @self: A #UMockdevTestbed.
     * @sysfs: sysfs path for device (/sys/...)
     * @recordfile: Path of the pcap or pcapng file.
     * @error: return location for a GError, or %NULL
     *
     * Load a USB pcap/pcapng recording created using e.g. wireshark.
     * The device must have been added previously as the device path in /dev
     * as well as the bus and device numbers need to be extraced from the udev
     * information.
     *
     * Returns: %TRUE on success, %FALSE if the recording could not be loaded
     * Since: 0.16
     */
gboolean
umockdev_testbed_load_pcap (UMockdevTestbed* self,
                            const gchar* sysfs,
                            const gchar* recordfile,
                            GError** error)
{
	gchar* owned_dev = NULL;
	gchar* sockpath = NULL;
	gint busnum = 0;
	gint devnum = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	UMockdevIoctlUsbPcapHandler* handler = NULL;
	UMockdevIoctlUsbPcapHandler* _tmp13_;
	GMainContext* _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sysfs != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = umockdev_testbed_get_attribute (self, sysfs, "busnum");
	_tmp1_ = _tmp0_;
	busnum = atoi (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = umockdev_testbed_get_attribute (self, sysfs, "devnum");
	_tmp3_ = _tmp2_;
	devnum = atoi (_tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = g_strdup_printf ("%03d", busnum);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%03d", devnum);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_build_filename ("/dev", "bus", "usb", _tmp5_, _tmp7_, NULL);
	_g_free0 (owned_dev);
	owned_dev = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp9_ = self->priv->root_dir;
	_tmp10_ = g_build_filename (_tmp9_, "ioctl", owned_dev, NULL);
	_g_free0 (sockpath);
	sockpath = _tmp10_;
	_tmp11_ = g_path_get_dirname (sockpath);
	_tmp12_ = _tmp11_;
	umockdev_checked_mkdir_with_parents (_tmp12_, 0755);
	_g_free0 (_tmp12_);
	_tmp13_ = umockdev_ioctl_usb_pcap_handler_new (recordfile, busnum, devnum);
	handler = _tmp13_;
	_tmp14_ = self->priv->worker_ctx;
	umockdev_ioctl_base_register_path ((UMockdevIoctlBase*) handler, _tmp14_, owned_dev, sockpath);
	result = TRUE;
	_g_object_unref0 (handler);
	_g_free0 (sockpath);
	_g_free0 (owned_dev);
	return result;
}

/**
     * umockdev_testbed_load_script:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the script record.
     *       %NULL is valid; in this case the script is associated with
     *       the device node it was recorded from.
     * @recordfile: Path of the script record file.
     * @error: return location for a GError, or %NULL
     *
     * Load a script record file for a particular device into the testbed.
     * script records can be created with umockdev-record --script.
     *
     * Returns: %TRUE on success, %FALSE if @recordfile is invalid and an error
     *          occurred.
     */
gboolean
umockdev_testbed_load_script (UMockdevTestbed* self,
                              const gchar* dev,
                              const gchar* recordfile,
                              GError** error)
{
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GFileInputStream* _tmp4_;
	gboolean _tmp6_ = FALSE;
	GDataInputStream* _tmp7_;
	GDataInputStream* _tmp8_;
	gboolean _tmp9_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp1_ = g_file_new_for_path (recordfile);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp5_;
	}
	_tmp7_ = g_data_input_stream_new ((GInputStream*) _tmp0_);
	_tmp8_ = _tmp7_;
	_tmp9_ = umockdev_testbed_load_script_from_stream (self, dev, _tmp8_, recordfile, &_inner_error0_);
	_g_object_unref0 (_tmp8_);
	_tmp6_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return _tmp10_;
	}
	result = _tmp6_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * umockdev_testbed_load_script_from_string:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the script record.
     *       %NULL is valid; in this case the script is associated with
     *       the device node it was recorded from.
     * @script: script string
     * @error: return location for a GError, or %NULL
     *
     * Load a script record file for a particular device into the testbed.
     * script records can be created with umockdev-record --script.
     *
     * Returns: %TRUE on success, %FALSE if @recordfile is invalid and an error
     *          occurred.
     */
static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

gboolean
umockdev_testbed_load_script_from_string (UMockdevTestbed* self,
                                          const gchar* dev,
                                          const gchar* script,
                                          GError** error)
{
	gboolean _tmp0_ = FALSE;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	GDestroyNotify _tmp5_;
	GMemoryInputStream* _tmp6_;
	GMemoryInputStream* _tmp7_;
	GDataInputStream* _tmp8_;
	GDataInputStream* _tmp9_;
	gboolean _tmp10_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (script != NULL, FALSE);
	_tmp1_ = string_get_data (script, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = g_free;
	_tmp6_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp4_, _tmp4__length1, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = umockdev_testbed_load_script_from_stream (self, dev, _tmp9_, "<string>", &_inner_error0_);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	_tmp0_ = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp11_;
	}
	result = _tmp0_;
	return result;
}

static gboolean
umockdev_testbed_load_script_from_stream (UMockdevTestbed* self,
                                          const gchar* dev,
                                          GDataInputStream* script,
                                          const gchar* scriptname,
                                          GError** error)
{
	gchar* owned_dev = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp20_;
	const gchar* _tmp21_;
	gint fd = 0;
	const gchar* _tmp22_;
	UMockdevScriptRunner* _tmp29_ = NULL;
	const gchar* _tmp30_;
	UMockdevScriptRunner* _tmp31_;
	GHashTable* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	UMockdevScriptRunner* _tmp36_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (script != NULL, FALSE);
	g_return_val_if_fail (scriptname != NULL, FALSE);
	_tmp0_ = g_strdup (dev);
	owned_dev = _tmp0_;
	_tmp1_ = owned_dev;
	if (_tmp1_ == NULL) {
		gchar* line = NULL;
		gchar* _tmp2_;
		const gchar* _tmp11_;
		GMatchInfo* header_matcher = NULL;
		GRegex* _tmp12_ = NULL;
		GRegex* _tmp13_;
		const gchar* _tmp15_;
		GMatchInfo* _tmp16_ = NULL;
		gboolean _tmp17_;
		GMatchInfo* _tmp18_;
		gchar* _tmp19_;
		_tmp2_ = g_data_input_stream_read_line (script, NULL, NULL, &_inner_error0_);
		line = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (owned_dev);
			return _tmp3_;
		}
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			const gchar* _tmp5_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp10_;
			_tmp5_ = line;
			if (_tmp5_ != NULL) {
				const gchar* _tmp6_;
				_tmp6_ = line;
				_tmp4_ = g_str_has_prefix (_tmp6_, "#");
			} else {
				_tmp4_ = FALSE;
			}
			if (!_tmp4_) {
				break;
			}
			_tmp8_ = g_data_input_stream_read_line (script, NULL, NULL, &_inner_error0_);
			_tmp7_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp9_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (line);
				_g_free0 (owned_dev);
				return _tmp9_;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_free0 (line);
			line = _tmp10_;
			_g_free0 (_tmp7_);
		}
		_tmp11_ = line;
		if (_tmp11_ == NULL) {
			g_error ("umockdev.vala:1078: script %s has no non-comment content", scriptname);
		}
		_tmp13_ = g_regex_new ("^d 0 (.*)(\n|$)", 0, 0, &_inner_error0_);
		_tmp12_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp14_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_free0 (owned_dev);
			return _tmp14_;
		}
		_tmp15_ = line;
		_tmp17_ = g_regex_match (_tmp12_, _tmp15_, 0, &_tmp16_);
		_g_match_info_unref0 (header_matcher);
		header_matcher = _tmp16_;
		if (!_tmp17_) {
			g_error ("umockdev.vala:1082: null passed for device node, but script %s has no " \
"d 0 header", scriptname);
		}
		_tmp18_ = header_matcher;
		_tmp19_ = g_match_info_fetch (_tmp18_, 1);
		_g_free0 (owned_dev);
		owned_dev = _tmp19_;
		_g_regex_unref0 (_tmp12_);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
	}
	_tmp20_ = self->priv->dev_script_runner;
	_tmp21_ = owned_dev;
	_vala_assert (!g_hash_table_contains (_tmp20_, _tmp21_), "!this.dev_script_runner.contains (owned_dev)");
	_tmp22_ = owned_dev;
	fd = umockdev_testbed_get_dev_fd (self, _tmp22_);
	if (fd < 0) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		GError* _tmp26_;
		GError* _tmp27_;
		gboolean _tmp28_ = FALSE;
		_tmp23_ = owned_dev;
		_tmp24_ = g_strconcat (_tmp23_, " is not a device suitable for scripts", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_inner_error0_ = _tmp27_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (owned_dev);
		return _tmp28_;
	}
	_tmp30_ = owned_dev;
	_tmp31_ = umockdev_script_runner_new (fd, _tmp30_, script, scriptname, &_inner_error0_);
	_tmp29_ = _tmp31_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp32_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (owned_dev);
		return _tmp32_;
	}
	_tmp33_ = self->priv->dev_script_runner;
	_tmp34_ = owned_dev;
	_tmp35_ = g_strdup (_tmp34_);
	_tmp36_ = _tmp29_;
	_tmp29_ = NULL;
	g_hash_table_insert (_tmp33_, _tmp35_, _tmp36_);
	result = TRUE;
	_umockdev_script_runner_unref0 (_tmp29_);
	_g_free0 (owned_dev);
	return result;
}

/**
     * umockdev_testbed_wait_script:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) to wait for
     * @error: return location for a GError, or %NULL
     *
     * Wait for a previously loaded script or evemu record to finish.
     *
     * Returns: %TRUE on success, %FALSE if @dev is invalid and an error
     *          occurred.
     */
gboolean
umockdev_testbed_wait_script (UMockdevTestbed* self,
                              const gchar* dev,
                              GError** error)
{
	UMockdevScriptRunner* runner = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	UMockdevScriptRunner* _tmp2_;
	UMockdevScriptRunner* _tmp9_;
	GHashTable* _tmp10_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dev != NULL, FALSE);
	_tmp0_ = self->priv->dev_script_runner;
	_tmp1_ = g_hash_table_lookup (_tmp0_, dev);
	runner = (UMockdevScriptRunner*) _tmp1_;
	_tmp2_ = runner;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_tmp3_ = g_strconcat (dev, " has no active script runner", NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_NOENT, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == G_FILE_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	_tmp9_ = runner;
	umockdev_script_runner_wait (_tmp9_);
	_tmp10_ = self->priv->dev_script_runner;
	g_hash_table_remove (_tmp10_, dev);
	result = TRUE;
	return result;
}

/**
     * umockdev_testbed_load_socket_script:
     * @self: A #UMockdevTestbed.
     * @path: Unix socket path
     * @type: Unix socket type (#SOCK_STREAM, #SOCK_DGRAM)
     * @recordfile: Path of the script record file.
     * @error: return location for a GError, or %NULL
     *
     * Add an Unix socket to the testbed that is backed by a recorded script.
     * Clients can connect to the socket using @path (i. e. without the testbed
     * prefix).
     *
     * Returns: %TRUE on success, %FALSE if the @path or @type are
     *          invalid and an error occurred.
     */
gboolean
umockdev_testbed_load_socket_script (UMockdevTestbed* self,
                                     const gchar* path,
                                     gint type,
                                     const gchar* recordfile,
                                     GError** error)
{
	gint fd = 0;
	gchar* real_path = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	UMockdevSocketServer* _tmp11_;
	UMockdevSocketServer* _tmp13_;
	const gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	fd = socket (AF_UNIX, type, 0);
	if (fd < 0) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		GError* _tmp3_;
		_tmp0_ = g_strdup_printf ("Cannot create socket type %i: %m", type);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == G_FILE_ERROR) {
			gboolean _tmp4_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp4_;
		} else {
			gboolean _tmp5_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	_tmp6_ = self->priv->root_dir;
	_tmp7_ = g_build_filename (_tmp6_, path, NULL);
	real_path = _tmp7_;
	_tmp8_ = real_path;
	_tmp9_ = g_path_get_dirname (_tmp8_);
	_tmp10_ = _tmp9_;
	umockdev_checked_mkdir_with_parents (_tmp10_, 0755);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->socket_server;
	if (_tmp11_ == NULL) {
		UMockdevSocketServer* _tmp12_;
		_tmp12_ = umockdev_socket_server_new ();
		_umockdev_socket_server_unref0 (self->priv->socket_server);
		self->priv->socket_server = _tmp12_;
	}
	_tmp13_ = self->priv->socket_server;
	_tmp14_ = real_path;
	umockdev_socket_server_add (_tmp13_, _tmp14_, fd, recordfile);
	result = TRUE;
	_g_free0 (real_path);
	return result;
}

/**
     * umockdev_testbed_load_evemu_events:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the evemu events.
     *       %NULL is valid; in this case the events are associated with
     *       the device node it was recorded from.
     * @eventsfile: Path of the evemu events file.
     * @error: return location for a GError, or %NULL
     *
     * Load an evemu event file for a particular device into the testbed. These
     * have a very simple line-based format with 4 fields that represent the
     * data in a struct input_event:
     *
     *  E: sec.usec evtype(hex) evcode(hex) evvalue
     *
     * The timestamps in those are absolute, and are usually as they were at
     * record time. When loading them into umockdev they are interpreted
     * relatively: the first event happens immediately, and the time to the
     * next event is the difference between the corresponding timestamps in the
     * .event file.
     *
     * Returns: %TRUE on success, %FALSE if @eventsfile is invalid and an error
     *          occurred.
     */
gboolean
umockdev_testbed_load_evemu_events (UMockdevTestbed* self,
                                    const gchar* dev,
                                    const gchar* eventsfile,
                                    GError** error)
{
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GFileInputStream* _tmp4_;
	gboolean _tmp6_ = FALSE;
	GDataInputStream* _tmp7_;
	GDataInputStream* _tmp8_;
	gboolean _tmp9_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (eventsfile != NULL, FALSE);
	_tmp1_ = g_file_new_for_path (eventsfile);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp5_;
	}
	_tmp7_ = g_data_input_stream_new ((GInputStream*) _tmp0_);
	_tmp8_ = _tmp7_;
	_tmp9_ = umockdev_testbed_load_evemu_events_from_stream (self, dev, _tmp8_, eventsfile, &_inner_error0_);
	_g_object_unref0 (_tmp8_);
	_tmp6_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return _tmp10_;
	}
	result = _tmp6_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

gboolean
umockdev_testbed_load_evemu_events_from_string (UMockdevTestbed* self,
                                                const gchar* dev,
                                                const gchar* events,
                                                GError** error)
{
	gboolean _tmp0_ = FALSE;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	GDestroyNotify _tmp5_;
	GMemoryInputStream* _tmp6_;
	GMemoryInputStream* _tmp7_;
	GDataInputStream* _tmp8_;
	GDataInputStream* _tmp9_;
	gboolean _tmp10_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (events != NULL, FALSE);
	_tmp1_ = string_get_data (events, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup3 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = g_free;
	_tmp6_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp4_, _tmp4__length1, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = umockdev_testbed_load_evemu_events_from_stream (self, dev, _tmp9_, "<string>", &_inner_error0_);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	_tmp0_ = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp11_;
	}
	result = _tmp0_;
	return result;
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static gulong
ulong_parse (const gchar* str,
             guint _base)
{
	gulong result;
	g_return_val_if_fail (str != NULL, 0UL);
	result = strtoul (str, NULL, (gint) _base);
	return result;
}

static gboolean
umockdev_testbed_load_evemu_events_from_stream (UMockdevTestbed* self,
                                                const gchar* dev,
                                                GDataInputStream* events,
                                                const gchar* eventsname,
                                                GError** error)
{
	gchar* line = NULL;
	gchar* recorded_dev = NULL;
	gsize len = 0UL;
	GMatchInfo* match = NULL;
	struct input_event ev = {0};
	struct input_event _tmp0_ = {0};
	GRegex* default_dev_re = NULL;
	GRegex* _tmp1_;
	GRegex* event_re = NULL;
	GRegex* _tmp3_;
	gchar* script = NULL;
	gchar* _tmp5_;
	gint delay = 0;
	gboolean first = FALSE;
	gchar* owned_dev = NULL;
	gchar* _tmp61_;
	const gchar* _tmp62_;
	gboolean _tmp66_ = FALSE;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (events != NULL, FALSE);
	g_return_val_if_fail (eventsname != NULL, FALSE);
	recorded_dev = NULL;
	ev = _tmp0_;
	_tmp1_ = g_regex_new ("^# device (.*)$", 0, 0, &_inner_error0_);
	default_dev_re = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		return _tmp2_;
	}
	_tmp3_ = g_regex_new ("^E: ([0-9]+)\\.([0-9]+) +([0-9a-fA-F]+) +([0-9a-fA-F]+) +(-?[0-9]+) *#" \
"?", 0, 0, &_inner_error0_);
	event_re = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		return _tmp4_;
	}
	_tmp5_ = g_strdup ("");
	script = _tmp5_;
	delay = 0;
	first = TRUE;
	while (TRUE) {
		gchar* _tmp6_ = NULL;
		gsize _tmp7_ = 0UL;
		gchar* _tmp8_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		GMatchInfo* _tmp14_ = NULL;
		gboolean _tmp15_;
		GRegex* _tmp18_;
		const gchar* _tmp19_;
		GMatchInfo* _tmp20_ = NULL;
		gboolean _tmp21_;
		time_t ev_sec = 0;
		GMatchInfo* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		time_t _tmp27_;
		time_t ev_usec = 0;
		GMatchInfo* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		time_t _tmp31_;
		GMatchInfo* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		GMatchInfo* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		GMatchInfo* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		guint8* ev_data = NULL;
		guint8* _tmp43_;
		gint ev_data_length1;
		gint _ev_data_size_;
		guint8* _tmp44_;
		gint _tmp44__length1;
		guint8* _tmp45_;
		gint _tmp45__length1;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		guint8* _tmp53_;
		gint _tmp53__length1;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp8_ = g_data_input_stream_read_line (events, &_tmp7_, NULL, &_inner_error0_);
		len = _tmp7_;
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp9_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (script);
			_g_regex_unref0 (event_re);
			_g_regex_unref0 (default_dev_re);
			_g_match_info_unref0 (match);
			_g_free0 (recorded_dev);
			_g_free0 (line);
			return _tmp9_;
		}
		_tmp10_ = _tmp6_;
		_tmp6_ = NULL;
		_g_free0 (line);
		line = _tmp10_;
		_tmp11_ = line;
		if (!(_tmp11_ != NULL)) {
			_g_free0 (_tmp6_);
			break;
		}
		_tmp12_ = default_dev_re;
		_tmp13_ = line;
		_tmp15_ = g_regex_match (_tmp12_, _tmp13_, 0, &_tmp14_);
		_g_match_info_unref0 (match);
		match = _tmp14_;
		if (_tmp15_) {
			GMatchInfo* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = match;
			_tmp17_ = g_match_info_fetch (_tmp16_, 1);
			_g_free0 (recorded_dev);
			recorded_dev = _tmp17_;
			_g_free0 (_tmp6_);
			continue;
		}
		_tmp18_ = event_re;
		_tmp19_ = line;
		_tmp21_ = g_regex_match (_tmp18_, _tmp19_, 0, &_tmp20_);
		_g_match_info_unref0 (match);
		match = _tmp20_;
		if (!_tmp21_) {
			const gchar* _tmp22_;
			_tmp22_ = line;
			if (!g_str_has_prefix (_tmp22_, "#")) {
				const gchar* _tmp23_;
				_tmp23_ = line;
				g_warning ("umockdev.vala:1213: Ignoring invalid line in %s: %s", eventsname, _tmp23_);
			}
			_g_free0 (_tmp6_);
			continue;
		}
		_tmp24_ = match;
		_tmp25_ = g_match_info_fetch (_tmp24_, 1);
		_tmp26_ = _tmp25_;
		_tmp27_ = (time_t) uint64_parse (_tmp26_, (guint) 0);
		_g_free0 (_tmp26_);
		ev_sec = _tmp27_;
		_tmp28_ = match;
		_tmp29_ = g_match_info_fetch (_tmp28_, 2);
		_tmp30_ = _tmp29_;
		_tmp31_ = (time_t) uint64_parse (_tmp30_, (guint) 0);
		_g_free0 (_tmp30_);
		ev_usec = _tmp31_;
		if (first) {
			delay = 0;
			first = FALSE;
		} else {
			struct input_event _tmp32_;
			struct input_event _tmp33_;
			_tmp32_ = ev;
			_tmp33_ = ev;
			delay = (((gint) (ev_sec - _tmp32_.input_event_sec)) * 1000) + (((gint) (ev_usec - _tmp33_.input_event_usec)) / 1000);
			if (delay < 0) {
				delay = 0;
			}
		}
		ev.input_event_sec = ev_sec;
		ev.input_event_usec = (glong) ev_usec;
		_tmp34_ = match;
		_tmp35_ = g_match_info_fetch (_tmp34_, 3);
		_tmp36_ = _tmp35_;
		ev.type = (guint16) ulong_parse (_tmp36_, (guint) 16);
		_g_free0 (_tmp36_);
		_tmp37_ = match;
		_tmp38_ = g_match_info_fetch (_tmp37_, 4);
		_tmp39_ = _tmp38_;
		ev.code = (guint16) ulong_parse (_tmp39_, (guint) 16);
		_g_free0 (_tmp39_);
		_tmp40_ = match;
		_tmp41_ = g_match_info_fetch (_tmp40_, 5);
		_tmp42_ = _tmp41_;
		ev.value = (gint32) atoi (_tmp42_);
		_g_free0 (_tmp42_);
		_tmp43_ = g_new0 (guint8, sizeof (struct input_event));
		ev_data = _tmp43_;
		ev_data_length1 = sizeof (struct input_event);
		_ev_data_size_ = ev_data_length1;
		_tmp44_ = ev_data;
		_tmp44__length1 = ev_data_length1;
		_tmp45_ = ev_data;
		_tmp45__length1 = ev_data_length1;
		memcpy (_tmp44_, &ev, (gsize) _tmp45__length1);
		_tmp46_ = script;
		_tmp47_ = g_strdup_printf ("%i", delay);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strconcat ("r ", _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat (_tmp50_, " ", NULL);
		_tmp52_ = _tmp51_;
		_tmp53_ = ev_data;
		_tmp53__length1 = ev_data_length1;
		_tmp54_ = umockdev_script_runner_encode (_tmp53_, (gint) _tmp53__length1);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strconcat (_tmp52_, _tmp55_, NULL);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strconcat (_tmp57_, "\n", NULL);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_strconcat (_tmp46_, _tmp59_, NULL);
		_g_free0 (script);
		script = _tmp60_;
		_g_free0 (_tmp59_);
		_g_free0 (_tmp57_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
		_g_free0 (_tmp48_);
		ev_data = (g_free (ev_data), NULL);
		_g_free0 (_tmp6_);
	}
	_tmp61_ = g_strdup (dev);
	owned_dev = _tmp61_;
	_tmp62_ = owned_dev;
	if (_tmp62_ == NULL) {
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		_tmp63_ = recorded_dev;
		if (_tmp63_ == NULL) {
			g_error ("umockdev.vala:1240: null passed for device node, but recording %s has " \
"no '# device' header", eventsname);
		}
		_tmp64_ = recorded_dev;
		_tmp65_ = g_strdup (_tmp64_);
		_g_free0 (owned_dev);
		owned_dev = _tmp65_;
	}
	_tmp67_ = owned_dev;
	_tmp68_ = script;
	_tmp66_ = umockdev_testbed_load_script_from_string (self, _tmp67_, _tmp68_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp69_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (owned_dev);
		_g_free0 (script);
		_g_regex_unref0 (event_re);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		return _tmp69_;
	}
	result = _tmp66_;
	_g_free0 (owned_dev);
	_g_free0 (script);
	_g_regex_unref0 (event_re);
	_g_regex_unref0 (default_dev_re);
	_g_match_info_unref0 (match);
	_g_free0 (recorded_dev);
	_g_free0 (line);
	return result;
}

static GHashTable*
umockdev_testbed_create_bus_lookup (void)
{
	GHashTable* lookup = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	gchar* _tmp130_;
	gchar* _tmp131_;
	gchar* _tmp132_;
	GHashTable* result;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	lookup = _tmp2_;
	_tmp3_ = g_strdup ("ac97");
	g_hash_table_insert (lookup, _tmp3_, NULL);
	_tmp4_ = g_strdup ("ac97bus");
	g_hash_table_insert (lookup, _tmp4_, NULL);
	_tmp5_ = g_strdup ("acpi");
	g_hash_table_insert (lookup, _tmp5_, NULL);
	_tmp6_ = g_strdup ("amba");
	g_hash_table_insert (lookup, _tmp6_, NULL);
	_tmp7_ = g_strdup ("anybuss");
	g_hash_table_insert (lookup, _tmp7_, NULL);
	_tmp8_ = g_strdup ("aoa-soundbus");
	g_hash_table_insert (lookup, _tmp8_, NULL);
	_tmp9_ = g_strdup ("ap");
	g_hash_table_insert (lookup, _tmp9_, NULL);
	_tmp10_ = g_strdup ("aprbus");
	g_hash_table_insert (lookup, _tmp10_, NULL);
	_tmp11_ = g_strdup ("bcma");
	g_hash_table_insert (lookup, _tmp11_, NULL);
	_tmp12_ = g_strdup ("bttv-sub");
	g_hash_table_insert (lookup, _tmp12_, NULL);
	_tmp13_ = g_strdup ("ccw");
	g_hash_table_insert (lookup, _tmp13_, NULL);
	_tmp14_ = g_strdup ("ccwgroup");
	g_hash_table_insert (lookup, _tmp14_, NULL);
	_tmp15_ = g_strdup ("cdmm");
	g_hash_table_insert (lookup, _tmp15_, NULL);
	_tmp16_ = g_strdup ("cec");
	g_hash_table_insert (lookup, _tmp16_, NULL);
	_tmp17_ = g_strdup ("coreboot");
	g_hash_table_insert (lookup, _tmp17_, NULL);
	_tmp18_ = g_strdup ("coresight");
	g_hash_table_insert (lookup, _tmp18_, NULL);
	_tmp19_ = g_strdup ("cosm_bus");
	g_hash_table_insert (lookup, _tmp19_, NULL);
	_tmp20_ = g_strdup ("counter");
	g_hash_table_insert (lookup, _tmp20_, NULL);
	_tmp21_ = g_strdup ("css");
	g_hash_table_insert (lookup, _tmp21_, NULL);
	_tmp22_ = g_strdup ("dax");
	g_hash_table_insert (lookup, _tmp22_, NULL);
	_tmp23_ = g_strdup ("dio");
	g_hash_table_insert (lookup, _tmp23_, NULL);
	_tmp24_ = g_strdup ("ecard");
	g_hash_table_insert (lookup, _tmp24_, NULL);
	_tmp25_ = g_strdup ("eisa");
	g_hash_table_insert (lookup, _tmp25_, NULL);
	_tmp26_ = g_strdup ("event_source");
	g_hash_table_insert (lookup, _tmp26_, NULL);
	_tmp27_ = g_strdup ("fcoe");
	g_hash_table_insert (lookup, _tmp27_, NULL);
	_tmp28_ = g_strdup ("firewire");
	g_hash_table_insert (lookup, _tmp28_, NULL);
	_tmp29_ = g_strdup ("fsi");
	g_hash_table_insert (lookup, _tmp29_, NULL);
	_tmp30_ = g_strdup ("fsl-mc");
	g_hash_table_insert (lookup, _tmp30_, NULL);
	_tmp31_ = g_strdup ("gameport");
	g_hash_table_insert (lookup, _tmp31_, NULL);
	_tmp32_ = g_strdup ("gbphy");
	g_hash_table_insert (lookup, _tmp32_, NULL);
	_tmp33_ = g_strdup ("genpd");
	g_hash_table_insert (lookup, _tmp33_, NULL);
	_tmp34_ = g_strdup ("gio");
	g_hash_table_insert (lookup, _tmp34_, NULL);
	_tmp35_ = g_strdup ("gpio");
	g_hash_table_insert (lookup, _tmp35_, NULL);
	_tmp36_ = g_strdup ("greybus");
	g_hash_table_insert (lookup, _tmp36_, NULL);
	_tmp37_ = g_strdup ("hdaudio");
	g_hash_table_insert (lookup, _tmp37_, NULL);
	_tmp38_ = g_strdup ("hid");
	g_hash_table_insert (lookup, _tmp38_, NULL);
	_tmp39_ = g_strdup ("host1x");
	g_hash_table_insert (lookup, _tmp39_, NULL);
	_tmp40_ = g_strdup ("hsi");
	g_hash_table_insert (lookup, _tmp40_, NULL);
	_tmp41_ = g_strdup ("i2c");
	g_hash_table_insert (lookup, _tmp41_, NULL);
	_tmp42_ = g_strdup ("i3c");
	g_hash_table_insert (lookup, _tmp42_, NULL);
	_tmp43_ = g_strdup ("ibmebus");
	g_hash_table_insert (lookup, _tmp43_, NULL);
	_tmp44_ = g_strdup ("ide");
	g_hash_table_insert (lookup, _tmp44_, NULL);
	_tmp45_ = g_strdup ("iio");
	g_hash_table_insert (lookup, _tmp45_, NULL);
	_tmp46_ = g_strdup ("iio");
	g_hash_table_insert (lookup, _tmp46_, NULL);
	_tmp47_ = g_strdup ("intel_th");
	g_hash_table_insert (lookup, _tmp47_, NULL);
	_tmp48_ = g_strdup ("ipack");
	g_hash_table_insert (lookup, _tmp48_, NULL);
	_tmp49_ = g_strdup ("isa");
	g_hash_table_insert (lookup, _tmp49_, NULL);
	_tmp50_ = g_strdup ("iscsi_flashnode");
	g_hash_table_insert (lookup, _tmp50_, NULL);
	_tmp51_ = g_strdup ("ishtp");
	g_hash_table_insert (lookup, _tmp51_, NULL);
	_tmp52_ = g_strdup ("iucv");
	g_hash_table_insert (lookup, _tmp52_, NULL);
	_tmp53_ = g_strdup ("locomo-bus");
	g_hash_table_insert (lookup, _tmp53_, NULL);
	_tmp54_ = g_strdup ("logicmodule");
	g_hash_table_insert (lookup, _tmp54_, NULL);
	_tmp55_ = g_strdup ("macio");
	g_hash_table_insert (lookup, _tmp55_, NULL);
	_tmp56_ = g_strdup ("maple");
	g_hash_table_insert (lookup, _tmp56_, NULL);
	_tmp57_ = g_strdup ("matrix");
	g_hash_table_insert (lookup, _tmp57_, NULL);
	_tmp58_ = g_strdup ("mcb");
	g_hash_table_insert (lookup, _tmp58_, NULL);
	_tmp59_ = g_strdup ("mcp");
	g_hash_table_insert (lookup, _tmp59_, NULL);
	_tmp60_ = g_strdup ("mdev");
	g_hash_table_insert (lookup, _tmp60_, NULL);
	_tmp61_ = g_strdup ("mdio_bus");
	g_hash_table_insert (lookup, _tmp61_, NULL);
	_tmp62_ = g_strdup ("media");
	g_hash_table_insert (lookup, _tmp62_, NULL);
	_tmp63_ = g_strdup ("mei");
	g_hash_table_insert (lookup, _tmp63_, NULL);
	_tmp64_ = g_strdup ("memstick");
	g_hash_table_insert (lookup, _tmp64_, NULL);
	_tmp65_ = g_strdup ("mic_bus");
	g_hash_table_insert (lookup, _tmp65_, NULL);
	_tmp66_ = g_strdup ("mipi-dsi");
	g_hash_table_insert (lookup, _tmp66_, NULL);
	_tmp67_ = g_strdup ("mmc_rpmb");
	g_hash_table_insert (lookup, _tmp67_, NULL);
	_tmp68_ = g_strdup ("mmc");
	g_hash_table_insert (lookup, _tmp68_, NULL);
	_tmp69_ = g_strdup ("most");
	g_hash_table_insert (lookup, _tmp69_, NULL);
	_tmp70_ = g_strdup ("nd");
	g_hash_table_insert (lookup, _tmp70_, NULL);
	_tmp71_ = g_strdup ("netdevsim");
	g_hash_table_insert (lookup, _tmp71_, NULL);
	_tmp72_ = g_strdup ("ntb_transport");
	g_hash_table_insert (lookup, _tmp72_, NULL);
	_tmp73_ = g_strdup ("ntb");
	g_hash_table_insert (lookup, _tmp73_, NULL);
	_tmp74_ = g_strdup ("nubus");
	g_hash_table_insert (lookup, _tmp74_, NULL);
	_tmp75_ = g_strdup ("nvmem");
	g_hash_table_insert (lookup, _tmp75_, NULL);
	_tmp76_ = g_strdup ("parisc");
	g_hash_table_insert (lookup, _tmp76_, NULL);
	_tmp77_ = g_strdup ("parport");
	g_hash_table_insert (lookup, _tmp77_, NULL);
	_tmp78_ = g_strdup ("pci-epf");
	g_hash_table_insert (lookup, _tmp78_, NULL);
	_tmp79_ = g_strdup ("pci");
	g_hash_table_insert (lookup, _tmp79_, NULL);
	_tmp80_ = g_strdup ("pcmcia");
	g_hash_table_insert (lookup, _tmp80_, NULL);
	_tmp81_ = g_strdup ("platform");
	g_hash_table_insert (lookup, _tmp81_, NULL);
	_tmp82_ = g_strdup ("pnp");
	g_hash_table_insert (lookup, _tmp82_, NULL);
	_tmp83_ = g_strdup ("ps3_system_bus");
	g_hash_table_insert (lookup, _tmp83_, NULL);
	_tmp84_ = g_strdup ("pseudo");
	g_hash_table_insert (lookup, _tmp84_, NULL);
	_tmp85_ = g_strdup ("rapidio");
	g_hash_table_insert (lookup, _tmp85_, NULL);
	_tmp86_ = g_strdup ("rbd");
	g_hash_table_insert (lookup, _tmp86_, NULL);
	_tmp87_ = g_strdup ("rmi4");
	g_hash_table_insert (lookup, _tmp87_, NULL);
	_tmp88_ = g_strdup ("rpmsg");
	g_hash_table_insert (lookup, _tmp88_, NULL);
	_tmp89_ = g_strdup ("sa1111-rab");
	g_hash_table_insert (lookup, _tmp89_, NULL);
	_tmp90_ = g_strdup ("scif_bus");
	g_hash_table_insert (lookup, _tmp90_, NULL);
	_tmp91_ = g_strdup ("scif_peer_bus");
	g_hash_table_insert (lookup, _tmp91_, NULL);
	_tmp92_ = g_strdup ("scm");
	g_hash_table_insert (lookup, _tmp92_, NULL);
	_tmp93_ = g_strdup ("scmi_protocol");
	g_hash_table_insert (lookup, _tmp93_, NULL);
	_tmp94_ = g_strdup ("scsi");
	g_hash_table_insert (lookup, _tmp94_, NULL);
	_tmp95_ = g_strdup ("sdio");
	g_hash_table_insert (lookup, _tmp95_, NULL);
	_tmp96_ = g_strdup ("serial");
	g_hash_table_insert (lookup, _tmp96_, NULL);
	_tmp97_ = g_strdup ("serio");
	g_hash_table_insert (lookup, _tmp97_, NULL);
	_tmp98_ = g_strdup ("siox");
	g_hash_table_insert (lookup, _tmp98_, NULL);
	_tmp99_ = g_strdup ("slimbus");
	g_hash_table_insert (lookup, _tmp99_, NULL);
	_tmp100_ = g_strdup ("snd_seq");
	g_hash_table_insert (lookup, _tmp100_, NULL);
	_tmp101_ = g_strdup ("soc");
	g_hash_table_insert (lookup, _tmp101_, NULL);
	_tmp102_ = g_strdup ("soundwire");
	g_hash_table_insert (lookup, _tmp102_, NULL);
	_tmp103_ = g_strdup ("spi");
	g_hash_table_insert (lookup, _tmp103_, NULL);
	_tmp104_ = g_strdup ("spmi");
	g_hash_table_insert (lookup, _tmp104_, NULL);
	_tmp105_ = g_strdup ("ssb");
	g_hash_table_insert (lookup, _tmp105_, NULL);
	_tmp106_ = g_strdup ("sunxi-rsb");
	g_hash_table_insert (lookup, _tmp106_, NULL);
	_tmp107_ = g_strdup ("superhyway");
	g_hash_table_insert (lookup, _tmp107_, NULL);
	_tmp108_ = g_strdup ("tc");
	g_hash_table_insert (lookup, _tmp108_, NULL);
	_tmp109_ = g_strdup ("tcm_loop_bus");
	g_hash_table_insert (lookup, _tmp109_, NULL);
	_tmp110_ = g_strdup ("tee");
	g_hash_table_insert (lookup, _tmp110_, NULL);
	_tmp111_ = g_strdup ("thunderbolt");
	g_hash_table_insert (lookup, _tmp111_, NULL);
	_tmp112_ = g_strdup ("tifm");
	g_hash_table_insert (lookup, _tmp112_, NULL);
	_tmp113_ = g_strdup ("tiocx");
	g_hash_table_insert (lookup, _tmp113_, NULL);
	_tmp114_ = g_strdup ("typec");
	g_hash_table_insert (lookup, _tmp114_, NULL);
	_tmp115_ = g_strdup ("ulpi");
	g_hash_table_insert (lookup, _tmp115_, NULL);
	_tmp116_ = g_strdup ("umc");
	g_hash_table_insert (lookup, _tmp116_, NULL);
	_tmp117_ = g_strdup ("usb-serial");
	g_hash_table_insert (lookup, _tmp117_, NULL);
	_tmp118_ = g_strdup ("usb");
	g_hash_table_insert (lookup, _tmp118_, NULL);
	_tmp119_ = g_strdup ("usb");
	g_hash_table_insert (lookup, _tmp119_, NULL);
	_tmp120_ = g_strdup ("uwb");
	g_hash_table_insert (lookup, _tmp120_, NULL);
	_tmp121_ = g_strdup ("vio");
	g_hash_table_insert (lookup, _tmp121_, NULL);
	_tmp122_ = g_strdup ("virtio");
	g_hash_table_insert (lookup, _tmp122_, NULL);
	_tmp123_ = g_strdup ("visorbus");
	g_hash_table_insert (lookup, _tmp123_, NULL);
	_tmp124_ = g_strdup ("vlynq");
	g_hash_table_insert (lookup, _tmp124_, NULL);
	_tmp125_ = g_strdup ("vmbus");
	g_hash_table_insert (lookup, _tmp125_, NULL);
	_tmp126_ = g_strdup ("vme");
	g_hash_table_insert (lookup, _tmp126_, NULL);
	_tmp127_ = g_strdup ("vop_bus");
	g_hash_table_insert (lookup, _tmp127_, NULL);
	_tmp128_ = g_strdup ("w1");
	g_hash_table_insert (lookup, _tmp128_, NULL);
	_tmp129_ = g_strdup ("wmi_bus");
	g_hash_table_insert (lookup, _tmp129_, NULL);
	_tmp130_ = g_strdup ("xen-backend");
	g_hash_table_insert (lookup, _tmp130_, NULL);
	_tmp131_ = g_strdup ("xen");
	g_hash_table_insert (lookup, _tmp131_, NULL);
	_tmp132_ = g_strdup ("zorro");
	g_hash_table_insert (lookup, _tmp132_, NULL);
	result = lookup;
	return result;
}

static gboolean
umockdev_testbed_subsystem_is_bus (const gchar* subsystem)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp2_;
	gboolean result;
	g_return_val_if_fail (subsystem != NULL, FALSE);
	_tmp0_ = umockdev_testbed_bus_lookup_table;
	if (_tmp0_ == NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = umockdev_testbed_create_bus_lookup ();
		_g_hash_table_unref0 (umockdev_testbed_bus_lookup_table);
		umockdev_testbed_bus_lookup_table = _tmp1_;
	}
	_tmp2_ = umockdev_testbed_bus_lookup_table;
	result = g_hash_table_contains (_tmp2_, subsystem);
	return result;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
umockdev_testbed_add_dev_from_string (UMockdevTestbed* self,
                                      const gchar* data,
                                      GError** error)
{
	gchar type = '\0';
	gchar* key = NULL;
	gchar* val = NULL;
	gchar* devpath = NULL;
	gchar* subsystem = NULL;
	gchar* majmin = NULL;
	gchar* cur_data = NULL;
	gchar* _tmp0_;
	gchar* devnode_path = NULL;
	guint8* devnode_contents = NULL;
	guint8* _tmp1_;
	gint devnode_contents_length1;
	gint _devnode_contents_size_;
	gchar** devnode_links = NULL;
	gchar** _tmp2_;
	gint devnode_links_length1;
	gint _devnode_links_size_;
	const gchar* _tmp3_;
	gchar _tmp4_ = '\0';
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp11_;
	const gchar* _tmp14_;
	gchar** attrs = NULL;
	gchar** _tmp15_;
	gint attrs_length1;
	gint _attrs_size_;
	gchar** binattrs = NULL;
	gchar** _tmp16_;
	gint binattrs_length1;
	gint _binattrs_size_;
	gchar** linkattrs = NULL;
	gchar** _tmp17_;
	gint linkattrs_length1;
	gint _linkattrs_size_;
	gchar** props = NULL;
	gchar** _tmp18_;
	gint props_length1;
	gint _props_size_;
	gchar* selinux_context = NULL;
	const gchar* _tmp83_;
	const gchar* _tmp86_;
	const gchar* _tmp87_;
	gchar* syspath = NULL;
	const gchar* _tmp88_;
	const gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar** _tmp92_;
	gint _tmp92__length1;
	gchar** _tmp93_;
	gint _tmp93__length1;
	gchar* _tmp94_;
	gchar* _tmp95_;
	const gchar* _tmp113_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	devpath = NULL;
	subsystem = NULL;
	majmin = NULL;
	_tmp0_ = g_strdup (data);
	cur_data = _tmp0_;
	devnode_path = NULL;
	_tmp1_ = g_new0 (guint8, 0);
	devnode_contents = _tmp1_;
	devnode_contents_length1 = 0;
	_devnode_contents_size_ = devnode_contents_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	devnode_links = _tmp2_;
	devnode_links_length1 = 0;
	_devnode_links_size_ = devnode_links_length1;
	_tmp3_ = cur_data;
	_tmp7_ = umockdev_testbed_record_parse_line (self, _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	type = _tmp4_;
	_g_free0 (key);
	key = _tmp5_;
	_g_free0 (devpath);
	devpath = _tmp6_;
	_g_free0 (cur_data);
	cur_data = _tmp7_;
	_tmp9_ = cur_data;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = type != 'P';
	}
	if (_tmp8_) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "device descriptions must start with a \"P: /devices/path/...\" line");
		_inner_error0_ = _tmp10_;
		if (_inner_error0_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error0_);
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = devpath;
	if (!g_str_has_prefix (_tmp11_, "/devices/")) {
		const gchar* _tmp12_;
		GError* _tmp13_;
		_tmp12_ = devpath;
		_tmp13_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "invalid device path '%s': must start with /devices/", _tmp12_);
		_inner_error0_ = _tmp13_;
		if (_inner_error0_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error0_);
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp14_ = devpath;
	g_debug ("umockdev.vala:1414: parsing device description for %s", _tmp14_);
	_tmp15_ = g_new0 (gchar*, 0 + 1);
	attrs = _tmp15_;
	attrs_length1 = 0;
	_attrs_size_ = attrs_length1;
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	binattrs = _tmp16_;
	binattrs_length1 = 0;
	_binattrs_size_ = binattrs_length1;
	_tmp17_ = g_new0 (gchar*, 0 + 1);
	linkattrs = _tmp17_;
	linkattrs_length1 = 0;
	_linkattrs_size_ = linkattrs_length1;
	_tmp18_ = g_new0 (gchar*, 0 + 1);
	props = _tmp18_;
	props_length1 = 0;
	_props_size_ = props_length1;
	selinux_context = NULL;
	while (TRUE) {
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		const gchar* _tmp24_;
		gchar _tmp25_ = '\0';
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp20_ = cur_data;
		_tmp21_ = strlen (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_ > 0) {
			const gchar* _tmp23_;
			_tmp23_ = cur_data;
			_tmp19_ = string_get (_tmp23_, (glong) 0) != '\n';
		} else {
			_tmp19_ = FALSE;
		}
		if (!_tmp19_) {
			break;
		}
		_tmp24_ = cur_data;
		_tmp28_ = umockdev_testbed_record_parse_line (self, _tmp24_, &_tmp25_, &_tmp26_, &_tmp27_);
		type = _tmp25_;
		_g_free0 (key);
		key = _tmp26_;
		_g_free0 (val);
		val = _tmp27_;
		_g_free0 (cur_data);
		cur_data = _tmp28_;
		_tmp29_ = cur_data;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			GError* _tmp31_;
			_tmp30_ = devpath;
			_tmp31_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "malformed attribute or property line in description of device %s", _tmp30_);
			_inner_error0_ = _tmp31_;
			if (_inner_error0_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (selinux_context);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				return NULL;
			} else {
				_g_free0 (selinux_context);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		switch (type) {
			case 'H':
			{
				const gchar* _tmp32_;
				gchar* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp32_ = key;
				_tmp33_ = g_strdup (_tmp32_);
				_vala_array_add3 (&binattrs, &binattrs_length1, &_binattrs_size_, _tmp33_);
				_tmp34_ = val;
				_tmp35_ = g_strdup (_tmp34_);
				_vala_array_add4 (&binattrs, &binattrs_length1, &_binattrs_size_, _tmp35_);
				break;
			}
			case 'A':
			{
				const gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				const gchar* _tmp42_;
				_tmp36_ = key;
				_tmp37_ = g_strdup (_tmp36_);
				_vala_array_add5 (&attrs, &attrs_length1, &_attrs_size_, _tmp37_);
				_tmp38_ = val;
				_tmp39_ = g_strcompress (_tmp38_);
				_g_free0 (val);
				val = _tmp39_;
				_tmp40_ = val;
				_tmp41_ = g_strdup (_tmp40_);
				_vala_array_add6 (&attrs, &attrs_length1, &_attrs_size_, _tmp41_);
				_tmp42_ = key;
				if (g_strcmp0 (_tmp42_, "dev") == 0) {
					const gchar* _tmp43_;
					gchar* _tmp44_;
					_tmp43_ = val;
					_tmp44_ = g_strdup (_tmp43_);
					_g_free0 (majmin);
					majmin = _tmp44_;
				}
				break;
			}
			case 'L':
			{
				const gchar* _tmp45_;
				gchar* _tmp46_;
				const gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp45_ = key;
				_tmp46_ = g_strdup (_tmp45_);
				_vala_array_add7 (&linkattrs, &linkattrs_length1, &_linkattrs_size_, _tmp46_);
				_tmp47_ = val;
				_tmp48_ = g_strdup (_tmp47_);
				_vala_array_add8 (&linkattrs, &linkattrs_length1, &_linkattrs_size_, _tmp48_);
				break;
			}
			case 'E':
			{
				const gchar* _tmp49_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				const gchar* _tmp59_;
				_tmp49_ = key;
				if (g_strcmp0 (_tmp49_, "__DEVCONTEXT") == 0) {
					const gchar* _tmp50_;
					const gchar* _tmp53_;
					gchar* _tmp54_;
					_tmp50_ = selinux_context;
					if (_tmp50_ != NULL) {
						const gchar* _tmp51_;
						GError* _tmp52_;
						_tmp51_ = devpath;
						_tmp52_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "duplicate __DEVCONTEXT property in description of device %s", _tmp51_);
						_inner_error0_ = _tmp52_;
						if (_inner_error0_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (selinux_context);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							_g_free0 (selinux_context);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp53_ = val;
					_tmp54_ = g_strdup (_tmp53_);
					_g_free0 (selinux_context);
					selinux_context = _tmp54_;
					break;
				}
				_tmp55_ = key;
				_tmp56_ = g_strdup (_tmp55_);
				_vala_array_add9 (&props, &props_length1, &_props_size_, _tmp56_);
				_tmp57_ = val;
				_tmp58_ = g_strdup (_tmp57_);
				_vala_array_add10 (&props, &props_length1, &_props_size_, _tmp58_);
				_tmp59_ = key;
				if (g_strcmp0 (_tmp59_, "SUBSYSTEM") == 0) {
					const gchar* _tmp60_;
					const gchar* _tmp63_;
					gchar* _tmp64_;
					_tmp60_ = subsystem;
					if (_tmp60_ != NULL) {
						const gchar* _tmp61_;
						GError* _tmp62_;
						_tmp61_ = devpath;
						_tmp62_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "duplicate SUBSYSTEM property in description of device %s", _tmp61_);
						_inner_error0_ = _tmp62_;
						if (_inner_error0_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (selinux_context);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							_g_free0 (selinux_context);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp63_ = val;
					_tmp64_ = g_strdup (_tmp63_);
					_g_free0 (subsystem);
					subsystem = _tmp64_;
				}
				break;
			}
			case 'P':
			{
				const gchar* _tmp65_;
				GError* _tmp66_;
				_tmp65_ = devpath;
				_tmp66_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "invalid P: line in description of device %s", _tmp65_);
				_inner_error0_ = _tmp66_;
				if (_inner_error0_->domain == UMOCKDEV_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (selinux_context);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					return NULL;
				} else {
					_g_free0 (selinux_context);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			case 'N':
			{
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				gchar* _tmp69_;
				const gchar* _tmp70_;
				_tmp67_ = self->priv->root_dir;
				_tmp68_ = key;
				_tmp69_ = g_build_filename (_tmp67_, "dev", _tmp68_, NULL);
				_g_free0 (devnode_path);
				devnode_path = _tmp69_;
				_tmp70_ = val;
				if (_tmp70_ != NULL) {
					guint8* _tmp71_ = NULL;
					const gchar* _tmp72_;
					gint _tmp73_ = 0;
					guint8* _tmp74_;
					gint _tmp71__length1;
					gint __tmp71__size_;
					guint8* _tmp75_;
					gint _tmp75__length1;
					_tmp72_ = val;
					_tmp74_ = umockdev_decode_hex (_tmp72_, &_tmp73_, &_inner_error0_);
					_tmp71_ = _tmp74_;
					_tmp71__length1 = _tmp73_;
					__tmp71__size_ = _tmp71__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (selinux_context);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							_g_free0 (selinux_context);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp75_ = _tmp71_;
					_tmp75__length1 = _tmp71__length1;
					_tmp71_ = NULL;
					_tmp71__length1 = 0;
					devnode_contents = (g_free (devnode_contents), NULL);
					devnode_contents = _tmp75_;
					devnode_contents_length1 = _tmp75__length1;
					_devnode_contents_size_ = devnode_contents_length1;
					_tmp71_ = (g_free (_tmp71_), NULL);
				}
				break;
			}
			case 'S':
			{
				const gchar* _tmp76_;
				const gchar* _tmp79_;
				const gchar* _tmp80_;
				gchar* _tmp81_;
				_tmp76_ = val;
				if (_tmp76_ == NULL) {
					const gchar* _tmp77_;
					GError* _tmp78_;
					_tmp77_ = devpath;
					_tmp78_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "invalid S: line in description of device %s", _tmp77_);
					_inner_error0_ = _tmp78_;
					if (_inner_error0_->domain == UMOCKDEV_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (selinux_context);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						return NULL;
					} else {
						_g_free0 (selinux_context);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp79_ = self->priv->root_dir;
				_tmp80_ = val;
				_tmp81_ = g_build_filename (_tmp79_, "dev", _tmp80_, NULL);
				_vala_array_add11 (&devnode_links, &devnode_links_length1, &_devnode_links_size_, _tmp81_);
				break;
			}
			default:
			{
				GError* _tmp82_;
				_tmp82_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "Unknown line type '%c'\n", (gint) type);
				_inner_error0_ = _tmp82_;
				if (_inner_error0_->domain == UMOCKDEV_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (selinux_context);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					return NULL;
				} else {
					_g_free0 (selinux_context);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp83_ = subsystem;
	if (_tmp83_ == NULL) {
		const gchar* _tmp84_;
		GError* _tmp85_;
		_tmp84_ = devpath;
		_tmp85_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "missing SUBSYSTEM property in description of device %s", _tmp84_);
		_inner_error0_ = _tmp85_;
		if (_inner_error0_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (selinux_context);
			props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
			linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
			binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
			attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			_g_free0 (selinux_context);
			props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
			linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
			binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
			attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp86_ = devpath;
	_tmp87_ = subsystem;
	g_debug ("umockdev.vala:1492: creating device %s (subsystem %s)", _tmp86_, _tmp87_);
	_tmp88_ = subsystem;
	_tmp89_ = devpath;
	_tmp90_ = string_substring (_tmp89_, (glong) 9, (glong) -1);
	_tmp91_ = _tmp90_;
	_tmp92_ = attrs;
	_tmp92__length1 = attrs_length1;
	_tmp93_ = props;
	_tmp93__length1 = props_length1;
	_tmp94_ = umockdev_testbed_add_devicev_no_uevent (self, _tmp88_, _tmp91_, NULL, _tmp92_, _tmp93_);
	_tmp95_ = _tmp94_;
	_g_free0 (_tmp91_);
	syspath = _tmp95_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp96_ = FALSE;
			_tmp96_ = TRUE;
			while (TRUE) {
				gchar** _tmp97_;
				gint _tmp97__length1;
				guint8* _tmp98_ = NULL;
				gchar** _tmp99_;
				gint _tmp99__length1;
				const gchar* _tmp100_;
				gint _tmp101_ = 0;
				guint8* _tmp102_;
				gint _tmp98__length1;
				gint __tmp98__size_;
				const gchar* _tmp103_;
				gchar** _tmp104_;
				gint _tmp104__length1;
				const gchar* _tmp105_;
				if (!_tmp96_) {
					i += 2;
				}
				_tmp96_ = FALSE;
				_tmp97_ = binattrs;
				_tmp97__length1 = binattrs_length1;
				if (!(i < _tmp97__length1)) {
					break;
				}
				_tmp99_ = binattrs;
				_tmp99__length1 = binattrs_length1;
				_tmp100_ = _tmp99_[i + 1];
				_tmp102_ = umockdev_decode_hex (_tmp100_, &_tmp101_, &_inner_error0_);
				_tmp98_ = _tmp102_;
				_tmp98__length1 = _tmp101_;
				__tmp98__size_ = _tmp98__length1;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == UMOCKDEV_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (syspath);
						_g_free0 (selinux_context);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						return NULL;
					} else {
						_g_free0 (syspath);
						_g_free0 (selinux_context);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp103_ = syspath;
				_tmp104_ = binattrs;
				_tmp104__length1 = binattrs_length1;
				_tmp105_ = _tmp104_[i];
				umockdev_testbed_set_attribute_binary (self, _tmp103_, _tmp105_, _tmp98_, (gint) _tmp98__length1);
				_tmp98_ = (g_free (_tmp98_), NULL);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp106_ = FALSE;
			_tmp106_ = TRUE;
			while (TRUE) {
				gchar** _tmp107_;
				gint _tmp107__length1;
				const gchar* _tmp108_;
				gchar** _tmp109_;
				gint _tmp109__length1;
				const gchar* _tmp110_;
				gchar** _tmp111_;
				gint _tmp111__length1;
				const gchar* _tmp112_;
				if (!_tmp106_) {
					i += 2;
				}
				_tmp106_ = FALSE;
				_tmp107_ = linkattrs;
				_tmp107__length1 = linkattrs_length1;
				if (!(i < _tmp107__length1)) {
					break;
				}
				_tmp108_ = syspath;
				_tmp109_ = linkattrs;
				_tmp109__length1 = linkattrs_length1;
				_tmp110_ = _tmp109_[i];
				_tmp111_ = linkattrs;
				_tmp111__length1 = linkattrs_length1;
				_tmp112_ = _tmp111_[i + 1];
				umockdev_testbed_set_attribute_link (self, _tmp108_, _tmp110_, _tmp112_);
			}
		}
	}
	_tmp113_ = devnode_path;
	if (_tmp113_ != NULL) {
		const gchar* _tmp114_;
		const gchar* _tmp115_;
		guint8* _tmp116_;
		gint _tmp116__length1;
		const gchar* _tmp117_;
		const gchar* _tmp118_;
		_tmp114_ = subsystem;
		_tmp115_ = devnode_path;
		_tmp116_ = devnode_contents;
		_tmp116__length1 = devnode_contents_length1;
		_tmp117_ = majmin;
		_tmp118_ = selinux_context;
		umockdev_testbed_create_node_for_device (self, _tmp114_, _tmp115_, _tmp116_, (gint) _tmp116__length1, _tmp117_, _tmp118_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (syspath);
				_g_free0 (selinux_context);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				return NULL;
			} else {
				_g_free0 (syspath);
				_g_free0 (selinux_context);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp119_ = FALSE;
				_tmp119_ = TRUE;
				while (TRUE) {
					gchar** _tmp121_;
					gint _tmp121__length1;
					gchar** _tmp122_;
					gint _tmp122__length1;
					const gchar* _tmp123_;
					gchar* _tmp124_;
					gchar* _tmp125_;
					const gchar* _tmp126_;
					gchar** _tmp127_;
					gint _tmp127__length1;
					const gchar* _tmp128_;
					if (!_tmp119_) {
						gint _tmp120_;
						_tmp120_ = i;
						i = _tmp120_ + 1;
					}
					_tmp119_ = FALSE;
					_tmp121_ = devnode_links;
					_tmp121__length1 = devnode_links_length1;
					if (!(i < _tmp121__length1)) {
						break;
					}
					_tmp122_ = devnode_links;
					_tmp122__length1 = devnode_links_length1;
					_tmp123_ = _tmp122_[i];
					_tmp124_ = g_path_get_dirname (_tmp123_);
					_tmp125_ = _tmp124_;
					umockdev_checked_mkdir_with_parents (_tmp125_, 0755);
					_g_free0 (_tmp125_);
					_tmp126_ = devnode_path;
					_tmp127_ = devnode_links;
					_tmp127__length1 = devnode_links_length1;
					_tmp128_ = _tmp127_[i];
					if (symlink (_tmp126_, _tmp128_) < 0) {
						gchar** _tmp129_;
						gint _tmp129__length1;
						const gchar* _tmp130_;
						const gchar* _tmp131_;
						const gchar* _tmp132_;
						_tmp129_ = devnode_links;
						_tmp129__length1 = devnode_links_length1;
						_tmp130_ = _tmp129_[i];
						_tmp131_ = devnode_path;
						_tmp132_ = devpath;
						g_warning ("umockdev.vala:1513: failed to create %s -> %s symlink for device %s: %" \
"m", _tmp130_, _tmp131_, _tmp132_);
					}
				}
			}
		}
	}
	while (TRUE) {
		gboolean _tmp133_ = FALSE;
		const gchar* _tmp134_;
		const gchar* _tmp136_;
		const gchar* _tmp137_;
		gchar* _tmp138_;
		_tmp134_ = cur_data;
		if (string_get (_tmp134_, (glong) 0) != '\0') {
			const gchar* _tmp135_;
			_tmp135_ = cur_data;
			_tmp133_ = string_get (_tmp135_, (glong) 0) == '\n';
		} else {
			_tmp133_ = FALSE;
		}
		if (!_tmp133_) {
			break;
		}
		_tmp136_ = cur_data;
		_tmp137_ = g_utf8_next_char (_tmp136_);
		_tmp138_ = g_strdup (_tmp137_);
		_g_free0 (cur_data);
		cur_data = _tmp138_;
	}
	if (umockdev_in_mock_environment ()) {
		const gchar* _tmp139_;
		_tmp139_ = syspath;
		umockdev_testbed_uevent (self, _tmp139_, "add");
	}
	result = cur_data;
	_g_free0 (syspath);
	_g_free0 (selinux_context);
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
	linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
	binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
	attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
	devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
	devnode_contents = (g_free (devnode_contents), NULL);
	_g_free0 (devnode_path);
	_g_free0 (majmin);
	_g_free0 (subsystem);
	_g_free0 (devpath);
	_g_free0 (val);
	_g_free0 (key);
	return result;
}

static void
umockdev_testbed_create_node_for_device (UMockdevTestbed* self,
                                         const gchar* subsystem,
                                         const gchar* node_path,
                                         guint8* node_contents,
                                         gint node_contents_length1,
                                         const gchar* majmin,
                                         const gchar* selinux_context,
                                         GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint ptym = 0;
	gint ptys = 0;
	gchar* ptyname_array = NULL;
	gchar* _tmp5_;
	gint ptyname_array_length1;
	gint _ptyname_array_size_;
	gchar* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_;
	gchar* ptyname = NULL;
	gchar* _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	struct termios ios = {0};
	struct termios _tmp13_ = {0};
	gint _tmp14_;
	struct termios _tmp15_;
	const gchar* _tmp16_;
	gchar* devname = NULL;
	const gchar* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gchar* _tmp31_;
	GHashTable* _tmp32_;
	const gchar* _tmp33_;
	GHashTable* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subsystem != NULL);
	g_return_if_fail (node_path != NULL);
	_tmp0_ = g_path_get_dirname (node_path);
	_tmp1_ = _tmp0_;
	umockdev_checked_mkdir_with_parents (_tmp1_, 0755);
	_g_free0 (_tmp1_);
	if (node_contents_length1 > 0) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 (subsystem, "block") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (subsystem, "usb") == 0;
	}
	if (_tmp2_) {
		{
			g_debug ("umockdev.vala:1538: create_node_for_device: creating file device %s", node_path);
			g_file_set_contents (node_path, (const char*) node_contents, (gsize) node_contents_length1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (g_strcmp0 (subsystem, "block") == 0) {
				g_chmod (node_path, 01644);
			}
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e->message;
			g_error ("umockdev.vala:1545: Cannot create dev node file: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		umockdev_testbed_set_selinux_context (self, node_path, selinux_context);
		return;
	}
	_tmp5_ = g_new0 (gchar, 8192);
	ptyname_array = _tmp5_;
	ptyname_array_length1 = 8192;
	_ptyname_array_size_ = ptyname_array_length1;
	_tmp6_ = ptyname_array;
	_tmp6__length1 = ptyname_array_length1;
	_tmp9_ = openpty (&_tmp7_, &_tmp8_, _tmp6_, NULL, NULL);
	ptym = _tmp7_;
	ptys = _tmp8_;
	if (_tmp9_ < 0) {
		g_error ("umockdev.vala:1556: umockdev Testbed.create_node_for_device: openpty()" \
" failed: %m");
	}
	_tmp10_ = ptyname_array;
	_tmp10__length1 = ptyname_array_length1;
	_tmp11_ = g_strdup ((const gchar*) _tmp10_);
	ptyname = _tmp11_;
	_tmp12_ = ptyname;
	g_debug ("umockdev.vala:1558: create_node_for_device: creating pty device %s: go" \
"t pty %s", node_path, _tmp12_);
	close (ptys);
	_tmp14_ = tcgetattr (ptym, &_tmp13_);
	ios = _tmp13_;
	_vala_assert (_tmp14_ == 0, "Posix.tcgetattr (ptym, out ios) == 0");
	ios.c_iflag = ios.c_iflag & (~((IGNCR | INLCR) | ICRNL));
	ios.c_oflag = ios.c_oflag & (~(ONLCR | OCRNL));
	ios.c_lflag = ios.c_lflag & (~(ICANON | ECHO));
	cfmakeraw (&ios);
	_tmp15_ = ios;
	_vala_assert (tcsetattr (ptym, TCSANOW, &_tmp15_) == 0, "Posix.tcsetattr (ptym, Posix.TCSANOW, ios) == 0");
	_tmp16_ = ptyname;
	_vala_assert (symlink (_tmp16_, node_path) == 0, "FileUtils.symlink (ptyname, node_path) == 0");
	if (majmin != NULL) {
		gchar* mapdir = NULL;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* dest = NULL;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		_tmp17_ = self->priv->root_dir;
		_tmp18_ = g_build_filename (_tmp17_, "dev", ".ptymap", NULL);
		mapdir = _tmp18_;
		_tmp19_ = mapdir;
		umockdev_checked_mkdir_with_parents (_tmp19_, 0755);
		_tmp20_ = mapdir;
		_tmp21_ = ptyname;
		_tmp22_ = string_replace (_tmp21_, "/", "_");
		_tmp23_ = _tmp22_;
		_tmp24_ = g_build_filename (_tmp20_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		dest = _tmp25_;
		_tmp26_ = dest;
		g_debug ("umockdev.vala:1579: create_node_for_device: creating ptymap symlink %s", _tmp26_);
		_tmp27_ = dest;
		_vala_assert (symlink (majmin, _tmp27_) == 0, "FileUtils.symlink(majmin, dest) == 0");
		_g_free0 (dest);
		_g_free0 (mapdir);
	}
	_tmp28_ = self->priv->root_dir;
	_tmp29_ = strlen (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = string_substring (node_path, (glong) _tmp30_, (glong) -1);
	devname = _tmp31_;
	_tmp32_ = self->priv->dev_fd;
	_tmp33_ = devname;
	_vala_assert (!g_hash_table_contains (_tmp32_, _tmp33_), "!this.dev_fd.contains (devname)");
	_tmp34_ = self->priv->dev_fd;
	_tmp35_ = devname;
	_tmp36_ = g_strdup (_tmp35_);
	g_hash_table_insert (_tmp34_, _tmp36_, (gpointer) ((gintptr) ptym));
	umockdev_testbed_set_selinux_context (self, node_path, selinux_context);
	_g_free0 (devname);
	_g_free0 (ptyname);
	ptyname_array = (g_free (ptyname_array), NULL);
}

static void
umockdev_testbed_set_selinux_context (UMockdevTestbed* self,
                                      const gchar* path,
                                      const gchar* context)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
}

/**
     * umockdev_testbed_record_parse_line:
     * @data: String to parse
     * @type: Pointer to a gchar which will get the line type (one of P, N,
     *        S, E, or H)
     * @key:  Pointer to a string which will get the key name; this will be
     *        set to %NULL for line types which do not have a key (P, N, S). You
     *        need to free this with g_free().
     * @value: Pointer to a string which will get the value. You need to
     *         free this with g_free().
     *
     * Parse one line from a device record file.
     *
     * Returns: Pointer to the next line start in @data, or %NULL if the first line
     * is not valid.
     */
static gchar*
umockdev_testbed_record_parse_line (UMockdevTestbed* self,
                                    const gchar* data,
                                    gchar* type,
                                    gchar** key,
                                    gchar** val)
{
	gchar _vala_type = '\0';
	gchar* _vala_key = NULL;
	gchar* _vala_val = NULL;
	GMatchInfo* match = NULL;
	GRegex* _tmp0_;
	GMatchInfo* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* type_str = NULL;
	GMatchInfo* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gint end_pos = 0;
	GMatchInfo* _tmp24_;
	gint _tmp25_ = 0;
	gboolean _tmp26_;
	gchar* _tmp27_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = self->priv->re_record_val;
	_tmp2_ = g_regex_match (_tmp0_, data, 0, &_tmp1_);
	_g_match_info_unref0 (match);
	match = _tmp1_;
	if (_tmp2_) {
		GMatchInfo* _tmp3_;
		gchar* _tmp4_;
		_g_free0 (_vala_key);
		_vala_key = NULL;
		_tmp3_ = match;
		_tmp4_ = g_match_info_fetch (_tmp3_, 2);
		_g_free0 (_vala_val);
		_vala_val = _tmp4_;
	} else {
		GRegex* _tmp5_;
		GMatchInfo* _tmp6_ = NULL;
		gboolean _tmp7_;
		_tmp5_ = self->priv->re_record_keyval;
		_tmp7_ = g_regex_match (_tmp5_, data, 0, &_tmp6_);
		_g_match_info_unref0 (match);
		match = _tmp6_;
		if (_tmp7_) {
			GMatchInfo* _tmp8_;
			gchar* _tmp9_;
			GMatchInfo* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp8_ = match;
			_tmp9_ = g_match_info_fetch (_tmp8_, 2);
			_g_free0 (_vala_key);
			_vala_key = _tmp9_;
			_tmp10_ = match;
			_tmp11_ = g_match_info_fetch (_tmp10_, 3);
			_g_free0 (_vala_val);
			_vala_val = _tmp11_;
			_tmp12_ = _vala_val;
			_vala_assert (_tmp12_ != NULL, "val != null");
		} else {
			GRegex* _tmp13_;
			GMatchInfo* _tmp14_ = NULL;
			gboolean _tmp15_;
			_tmp13_ = self->priv->re_record_optval;
			_tmp15_ = g_regex_match (_tmp13_, data, 0, &_tmp14_);
			_g_match_info_unref0 (match);
			match = _tmp14_;
			if (_tmp15_) {
				GMatchInfo* _tmp16_;
				gchar* _tmp17_;
				GMatchInfo* _tmp18_;
				gchar* _tmp19_;
				_tmp16_ = match;
				_tmp17_ = g_match_info_fetch (_tmp16_, 2);
				_g_free0 (_vala_key);
				_vala_key = _tmp17_;
				_tmp18_ = match;
				_tmp19_ = g_match_info_fetch (_tmp18_, 3);
				_g_free0 (_vala_val);
				_vala_val = _tmp19_;
			} else {
				g_debug ("umockdev.vala:1633: record_parse_line: >%s< does not match anything, f" \
"ailing", data);
				_vala_type = '\0';
				_g_free0 (_vala_key);
				_vala_key = NULL;
				_g_free0 (_vala_val);
				_vala_val = NULL;
				result = NULL;
				_g_match_info_unref0 (match);
				if (type) {
					*type = _vala_type;
				}
				if (key) {
					*key = _vala_key;
				} else {
					_g_free0 (_vala_key);
				}
				if (val) {
					*val = _vala_val;
				} else {
					_g_free0 (_vala_val);
				}
				return result;
			}
		}
	}
	_tmp20_ = match;
	_tmp21_ = g_match_info_fetch (_tmp20_, 1);
	type_str = _tmp21_;
	_tmp22_ = type_str;
	_vala_assert (_tmp22_ != NULL, "type_str != null");
	_tmp23_ = type_str;
	_vala_type = string_get (_tmp23_, (glong) 0);
	_tmp24_ = match;
	_tmp26_ = g_match_info_fetch_pos (_tmp24_, 0, NULL, &_tmp25_);
	end_pos = _tmp25_;
	_vala_assert (_tmp26_, "match.fetch_pos(0, null, out end_pos)");
	_tmp27_ = string_substring (data, (glong) end_pos, (glong) -1);
	result = _tmp27_;
	_g_free0 (type_str);
	_g_match_info_unref0 (match);
	if (type) {
		*type = _vala_type;
	}
	if (key) {
		*key = _vala_key;
	} else {
		_g_free0 (_vala_key);
	}
	if (val) {
		*val = _vala_val;
	} else {
		_g_free0 (_vala_val);
	}
	return result;
}

/**
     * umockdev_testbed_disable:
     * @self: A #UMockdevTestbed.
     *
     * Disable the testbed.  This can be used for temporarily switching back to
     * the real /sys and /dev without having to destroy or change $UMOCKDEV_DIR
     * and the #UMockdevTestbed instance. Use @umockdev_testbed_enable() to
     * re-enable the testbed.
     */
void
umockdev_testbed_disable (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, "disabled", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_fopen (_tmp2_, "w");
	_tmp4_ = _tmp3_;
	_fclose0 (_tmp4_);
	_g_free0 (_tmp2_);
}

/**
     * umockdev_testbed_enable:
     * @self: A #UMockdevTestbed.
     *
     * Re-enable the testbed after @@umockdev_testbed_disable().
     */
void
umockdev_testbed_enable (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, "disabled", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_remove (_tmp2_) < 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		g_debug ("umockdev.vala:1672: enable: failed to remove /disabled flag, ignoring:" \
" %m");
	}
}

/**
     * umockdev_testbed_clear:
     * @self: A #UMockdevTestbed.
     *
     * Remove all added devices from testbed directory.  After that, the
     * umockdev root directory will be in the same state as directly after the
     * constructor.
     */
void
umockdev_testbed_clear (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	umockdev_utils_remove_dir (_tmp0_, FALSE);
	_tmp1_ = self->priv->sys_dir;
	umockdev_checked_mkdir_with_parents (_tmp1_, 0755);
}

/**
     * umockdev_testbed_get_dev_fd:
     * @self: A #UMockdevTestbed.
     * @devnode: Device node name ("/dev/...")
     *
     * Simulated devices without a pre-defined contents are backed by a
     * stream-like device node (PTY). Return the file descriptor
     * for accessing their "master" side, i. e. the end that gets
     * controlled by test suites. The tested program opens the "slave" side,
     * which is just openening the device specified by @devnode, e. g.
     * /dev/ttyUSB2. Once that happened, your test can directly communicate
     * with the tested program over that descriptor.
     *
     * Returns: File descriptor for communicating with clients that connect to
     *           @devnode, or -1 if @devnode does not exist or is not a
     *           simulated stream device. This must not be closed!
     */
gint
umockdev_testbed_get_dev_fd (UMockdevTestbed* self,
                             const gchar* devnode)
{
	GHashTable* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (devnode != NULL, 0);
	_tmp0_ = self->priv->dev_fd;
	if (g_hash_table_contains (_tmp0_, devnode)) {
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = self->priv->dev_fd;
		_tmp2_ = g_hash_table_lookup (_tmp1_, devnode);
		result = (gint) ((gintptr) _tmp2_);
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
umockdev_testbed_class_init (UMockdevTestbedClass * klass,
                             gpointer klass_data)
{
	umockdev_testbed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevTestbed_private_offset);
	G_OBJECT_CLASS (klass)->finalize = umockdev_testbed_finalize;
}

static void
umockdev_testbed_instance_init (UMockdevTestbed * self,
                                gpointer klass)
{
	self->priv = umockdev_testbed_get_instance_private (self);
	self->priv->socket_server = NULL;
}

static void
umockdev_testbed_finalize (GObject * obj)
{
	UMockdevTestbed * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	UMockdevSocketServer* _tmp6_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GMainLoop* _tmp10_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_TESTBED, UMockdevTestbed);
	_tmp0_ = self->priv->dev_script_runner;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp1_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			UMockdevScriptRunner* r = NULL;
			r = (UMockdevScriptRunner*) r_it->data;
			{
				UMockdevScriptRunner* _tmp2_;
				_tmp2_ = r;
				umockdev_script_runner_stop (_tmp2_);
			}
		}
		(r_collection == NULL) ? NULL : (r_collection = (g_list_free (r_collection), NULL));
	}
	_tmp3_ = self->priv->dev_script_runner;
	g_hash_table_remove_all (_tmp3_);
	_tmp4_ = self->priv->custom_handlers;
	g_hash_table_foreach (_tmp4_, __umockdev_testbed___lambda5__gh_func, self);
	_tmp5_ = self->priv->custom_handlers;
	g_hash_table_remove_all (_tmp5_);
	_tmp6_ = self->priv->socket_server;
	if (_tmp6_ != NULL) {
		UMockdevSocketServer* _tmp7_;
		g_debug ("umockdev.vala:149: shutting down socket server thread");
		_tmp7_ = self->priv->socket_server;
		umockdev_socket_server_stop (_tmp7_);
		_umockdev_socket_server_unref0 (self->priv->socket_server);
		self->priv->socket_server = NULL;
	}
	_tmp8_ = self->priv->root_dir;
	g_debug ("umockdev.vala:154: Removing test bed %s", _tmp8_);
	_tmp9_ = self->priv->root_dir;
	umockdev_utils_remove_dir (_tmp9_, TRUE);
	_tmp10_ = self->priv->worker_loop;
	g_main_loop_quit (_tmp10_);
	g_unsetenv ("UMOCKDEV_DIR");
	_g_free0 (self->priv->root_dir);
	_g_free0 (self->priv->sys_dir);
	_g_regex_unref0 (self->priv->re_record_val);
	_g_regex_unref0 (self->priv->re_record_keyval);
	_g_regex_unref0 (self->priv->re_record_optval);
	_g_hash_table_unref0 (self->priv->dev_fd);
	_g_hash_table_unref0 (self->priv->dev_script_runner);
	_umockdev_socket_server_unref0 (self->priv->socket_server);
	_g_hash_table_unref0 (self->priv->custom_handlers);
	_g_thread_unref0 (self->priv->worker_thread);
	_g_main_context_unref0 (self->priv->worker_ctx);
	_g_main_loop_unref0 (self->priv->worker_loop);
	G_OBJECT_CLASS (umockdev_testbed_parent_class)->finalize (obj);
}

static GType
umockdev_testbed_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevTestbedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_testbed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevTestbed), 0, (GInstanceInitFunc) umockdev_testbed_instance_init, NULL };
	GType umockdev_testbed_type_id;
	umockdev_testbed_type_id = g_type_register_static (G_TYPE_OBJECT, "UMockdevTestbed", &g_define_type_info, 0);
	UMockdevTestbed_private_offset = g_type_add_instance_private (umockdev_testbed_type_id, sizeof (UMockdevTestbedPrivate));
	return umockdev_testbed_type_id;
}

GType
umockdev_testbed_get_type (void)
{
	static volatile gsize umockdev_testbed_type_id__once = 0;
	if (g_once_init_enter (&umockdev_testbed_type_id__once)) {
		GType umockdev_testbed_type_id;
		umockdev_testbed_type_id = umockdev_testbed_get_type_once ();
		g_once_init_leave (&umockdev_testbed_type_id__once, umockdev_testbed_type_id);
	}
	return umockdev_testbed_type_id__once;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
umockdev_make_dotdots (const gchar* path)
{
	gint offset = 0;
	guint count = 0U;
	gchar* dots = NULL;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	offset = 0;
	count = (guint) 0;
	while (TRUE) {
		guint _tmp0_;
		gint _tmp1_;
		offset = string_index_of_char (path, (gunichar) '/', offset);
		if (!(offset >= 0)) {
			break;
		}
		count = count + 1;
		_tmp0_ = count;
		offset = offset + 1;
		_tmp1_ = offset;
	}
	_tmp2_ = g_strdup ("");
	dots = _tmp2_;
	while (TRUE) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		guint _tmp5_;
		if (!(count > ((guint) 1))) {
			break;
		}
		_tmp3_ = dots;
		_tmp4_ = g_strconcat (_tmp3_, "../", NULL);
		_g_free0 (dots);
		dots = _tmp4_;
		count = count - 1;
		_tmp5_ = count;
	}
	result = dots;
	return result;
}

guint8
umockdev_hexdigit (gchar c)
{
	gint _tmp0_ = 0;
	guint8 result;
	if (c >= 'a') {
		_tmp0_ = (c - 'a') + 10;
	} else {
		gint _tmp1_ = 0;
		if (c >= 'A') {
			_tmp1_ = (c - 'A') + 10;
		} else {
			_tmp1_ = (gint) (c - '0');
		}
		_tmp0_ = _tmp1_;
	}
	result = (guint8) _tmp0_;
	return result;
}

guint8*
umockdev_decode_hex (const gchar* data,
                     gint* result_length1,
                     GError** error)
{
	gint _tmp0_;
	gint _tmp1_;
	gint len = 0;
	gint _tmp3_;
	gint _tmp4_;
	guint8* bin = NULL;
	guint8* _tmp5_;
	gint bin_length1;
	gint _bin_size_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = strlen (data);
	_tmp1_ = _tmp0_;
	if ((_tmp1_ % 2) != 0) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "malformed hexadecimal value: %s", data);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = strlen (data);
	_tmp4_ = _tmp3_;
	len = _tmp4_;
	_tmp5_ = g_new0 (guint8, len / 2);
	bin = _tmp5_;
	bin_length1 = len / 2;
	_bin_size_ = bin_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint8* _tmp8_;
				gint _tmp8__length1;
				guint8* _tmp9_;
				gint _tmp9__length1;
				if (!_tmp6_) {
					guint _tmp7_;
					i = i + 1;
					_tmp7_ = i;
				}
				_tmp6_ = FALSE;
				_tmp8_ = bin;
				_tmp8__length1 = bin_length1;
				if (!(i < ((guint) _tmp8__length1))) {
					break;
				}
				_tmp9_ = bin;
				_tmp9__length1 = bin_length1;
				_tmp9_[i] = (guint8) ((umockdev_hexdigit (string_get (data, (glong) (i * 2))) << 4) | umockdev_hexdigit (string_get (data, (glong) ((i * 2) + 1))));
			}
		}
	}
	_tmp10_ = bin;
	_tmp10__length1 = bin_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

gchar*
umockdev_find_devnode (const gchar* devpath)
{
	gchar* devname = NULL;
	GFile* f = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (devpath != NULL, NULL);
	devname = NULL;
	_tmp0_ = g_build_filename (devpath, "uevent", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	f = _tmp3_;
	{
		GFileInputStream* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileInputStream* _tmp6_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp7_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp20_;
		_tmp5_ = f;
		_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
		inp = _tmp7_;
		while (TRUE) {
			gchar* _tmp8_ = NULL;
			GDataInputStream* _tmp9_;
			gsize _tmp10_ = 0UL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp9_ = inp;
			_tmp11_ = g_data_input_stream_read_line (_tmp9_, &_tmp10_, NULL, &_inner_error0_);
			len = _tmp10_;
			_tmp8_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp4_);
				goto __catch0_g_error;
			}
			_tmp12_ = _tmp8_;
			_tmp8_ = NULL;
			_g_free0 (line);
			line = _tmp12_;
			_tmp13_ = line;
			if (!(_tmp13_ != NULL)) {
				_g_free0 (_tmp8_);
				break;
			}
			_tmp14_ = line;
			if (g_str_has_prefix (_tmp14_, "DEVNAME=")) {
				const gchar* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = line;
				_tmp16_ = string_substring (_tmp15_, (glong) 8, (glong) -1);
				_g_free0 (devname);
				devname = _tmp16_;
				_tmp17_ = devname;
				if (!g_str_has_prefix (_tmp17_, "/dev/")) {
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp18_ = devname;
					_tmp19_ = g_strconcat ("/dev/", _tmp18_, NULL);
					_g_free0 (devname);
					devname = _tmp19_;
				}
				_g_free0 (_tmp8_);
				break;
			}
			_g_free0 (_tmp8_);
		}
		_tmp20_ = inp;
		g_input_stream_close ((GInputStream*) _tmp20_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp4_);
			goto __catch0_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("umockdev.vala:1799: Cannot read uevent file: %s\n", _tmp22_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (f);
		_g_free0 (devname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = devname;
	_g_object_unref0 (f);
	return result;
}

static inline gpointer
umockdev_script_runner_get_instance_private (UMockdevScriptRunner* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevScriptRunner_private_offset);
}

/**
     * ScriptRunner:
     * @device_fd: File descriptor of the emulated device node
     * @device: Name of the emulated device node, only for debug/error messages
     * @script: Script to load and run
     * @script_file: Description (e.g. file name) of @script, only for debug/error messages
     *
     * Create a new script runner for running @script.
     */
static gpointer
_umockdev_script_runner_run_gthread_func (gpointer self)
{
	gpointer result;
	result = umockdev_script_runner_run ((UMockdevScriptRunner*) self);
	umockdev_script_runner_unref (self);
	return result;
}

UMockdevScriptRunner*
umockdev_script_runner_construct (GType object_type,
                                  gint device_fd,
                                  const gchar* device,
                                  GDataInputStream* script,
                                  const gchar* script_file,
                                  GError** error)
{
	UMockdevScriptRunner* self = NULL;
	GDataInputStream* _tmp0_;
	gchar* _tmp1_;
	GThread* _tmp2_;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (script != NULL, NULL);
	g_return_val_if_fail (script_file != NULL, NULL);
	self = (UMockdevScriptRunner*) g_type_create_instance (object_type);
	self->priv->fd = device_fd;
	umockdev_script_runner_set_device (self, device);
	_tmp0_ = _g_object_ref0 (script);
	_g_object_unref0 (self->priv->script);
	self->priv->script = _tmp0_;
	_tmp1_ = g_strdup (script_file);
	_g_free0 (self->priv->script_file);
	self->priv->script_file = _tmp1_;
	self->priv->running = TRUE;
	_tmp2_ = g_thread_new (device, _umockdev_script_runner_run_gthread_func, umockdev_script_runner_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp2_;
	return self;
}

UMockdevScriptRunner*
umockdev_script_runner_new (gint device_fd,
                            const gchar* device,
                            GDataInputStream* script,
                            const gchar* script_file,
                            GError** error)
{
	return umockdev_script_runner_construct (UMOCKDEV_TYPE_SCRIPT_RUNNER, device_fd, device, script, script_file, error);
}

void
umockdev_script_runner_stop (UMockdevScriptRunner* self)
{
	const gchar* _tmp0_;
	GThread* _tmp1_;
	g_return_if_fail (self != NULL);
	if (!self->priv->running) {
		return;
	}
	_tmp0_ = self->priv->_device;
	g_debug ("umockdev.vala:1836: Stopping script runner for %s: joining thread", _tmp0_);
	self->priv->running = FALSE;
	_tmp1_ = self->priv->thread;
	self->priv->thread = NULL;
	g_thread_join (_tmp1_);
}

void
umockdev_script_runner_wait (UMockdevScriptRunner* self)
{
	const gchar* _tmp1_;
	GThread* _tmp2_;
	g_return_if_fail (self != NULL);
	if (!self->priv->running) {
		const gchar* _tmp0_;
		_tmp0_ = self->priv->_device;
		g_debug ("umockdev.vala:1844: Script runner for %s already finished, nothing to " \
"wait for", _tmp0_);
		return;
	}
	_tmp1_ = self->priv->_device;
	g_debug ("umockdev.vala:1848: Waiting for script runner for %s to finish", _tmp1_);
	_tmp2_ = self->priv->thread;
	self->priv->thread = NULL;
	g_thread_join (_tmp2_);
	_vala_assert (self->priv->running == FALSE, "this.running == false");
}

static void*
umockdev_script_runner_run (UMockdevScriptRunner* self)
{
	gchar op = '\0';
	guint32 delta = 0U;
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_;
	const gchar* _tmp22_;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	g_debug ("umockdev.vala:1859: ScriptRunner[%s]: start", _tmp0_);
	while (TRUE) {
		gchar _tmp1_ = '\0';
		guint32 _tmp2_ = 0U;
		gint _tmp3_ = 0;
		guint8* _tmp4_;
		if (!self->priv->running) {
			break;
		}
		_tmp4_ = umockdev_script_runner_next_line (self, &_tmp1_, &_tmp2_, &_tmp3_);
		op = _tmp1_;
		delta = _tmp2_;
		data = (g_free (data), NULL);
		data = _tmp4_;
		data_length1 = _tmp3_;
		_data_size_ = data_length1;
		switch (op) {
			case 'r':
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				guint8* _tmp7_;
				gint _tmp7__length1;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gssize l = 0L;
				guint8* _tmp10_;
				gint _tmp10__length1;
				guint8* _tmp11_;
				gint _tmp11__length1;
				guint8* _tmp13_;
				gint _tmp13__length1;
				_tmp5_ = self->priv->_device;
				g_debug ("ScriptRunner[%s]: read op; sleeping %" G_GUINT32_FORMAT " ms", _tmp5_, delta);
				g_usleep ((gulong) (delta * 1000));
				_tmp6_ = self->priv->_device;
				_tmp7_ = data;
				_tmp7__length1 = data_length1;
				_tmp8_ = umockdev_script_runner_encode (_tmp7_, (gint) _tmp7__length1);
				_tmp9_ = _tmp8_;
				g_debug ("umockdev.vala:1869: ScriptRunner[%s]: read op after sleep; writing dat" \
"a '%s'", _tmp6_, _tmp9_);
				_g_free0 (_tmp9_);
				_tmp10_ = data;
				_tmp10__length1 = data_length1;
				_tmp11_ = data;
				_tmp11__length1 = data_length1;
				l = write (self->priv->fd, _tmp10_, (gsize) _tmp11__length1);
				if (l < ((gssize) 0)) {
					const gchar* _tmp12_;
					_tmp12_ = self->priv->_device;
					g_error ("umockdev.vala:1872: ScriptRunner[%s]: write failed: %m", _tmp12_);
				}
				_tmp13_ = data;
				_tmp13__length1 = data_length1;
				_vala_assert (l == ((gssize) _tmp13__length1), "l == data.length");
				break;
			}
			case 'w':
			{
				const gchar* _tmp14_;
				guint8* _tmp15_;
				gint _tmp15__length1;
				gchar* _tmp16_;
				gchar* _tmp17_;
				guint8* _tmp18_;
				gint _tmp18__length1;
				_tmp14_ = self->priv->_device;
				_tmp15_ = data;
				_tmp15__length1 = data_length1;
				_tmp16_ = umockdev_script_runner_encode (_tmp15_, (gint) _tmp15__length1);
				_tmp17_ = _tmp16_;
				g_debug ("umockdev.vala:1877: ScriptRunner[%s]: write op, data '%s'", _tmp14_, _tmp17_);
				_g_free0 (_tmp17_);
				_tmp18_ = data;
				_tmp18__length1 = data_length1;
				umockdev_script_runner_op_write (self, _tmp18_, (gint) _tmp18__length1, delta);
				break;
			}
			case 'Q':
			{
				self->priv->running = FALSE;
				break;
			}
			case 'f':
			{
				const gchar* _tmp20_;
				if (delta > ((guint32) 100)) {
					const gchar* _tmp19_;
					_tmp19_ = self->priv->_device;
					g_error ("umockdev.vala:1887: ScriptRunner[%s]: fuzz value %u is invalid (must b" \
"e between 0 and 100)", _tmp19_, (guint) delta);
				}
				self->priv->fuzz = (guint) delta;
				_tmp20_ = self->priv->_device;
				g_debug ("umockdev.vala:1890: ScriptRunner[%s]: setting fuzz level to %u%%", _tmp20_, self->priv->fuzz);
				break;
			}
			case 'd':
			{
				break;
			}
			default:
			{
				const gchar* _tmp21_;
				_tmp21_ = self->priv->_device;
				g_debug ("umockdev.vala:1898: ScriptRunner[%s]: got unknown line op %c, ignoring", _tmp21_, (gint) op);
				break;
			}
		}
	}
	_tmp22_ = self->priv->_device;
	g_debug ("umockdev.vala:1903: ScriptRunner[%s]: not running any more, ending thr" \
"ead", _tmp22_);
	result = NULL;
	data = (g_free (data), NULL);
	return result;
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar** unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static guint8*
umockdev_script_runner_next_line (UMockdevScriptRunner* self,
                                  gchar* op,
                                  guint32* delta,
                                  gint* result_length1)
{
	gchar _vala_op = '\0';
	guint32 _vala_delta = 0U;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint64 cur_pos = 0LL;
		GDataInputStream* _tmp17_;
		guint8 _tmp18_ = 0U;
		GDataInputStream* _tmp19_;
		GDataInputStream* _tmp21_;
		gchar* delta_str = NULL;
		guint8 b = 0U;
		GDataInputStream* _tmp29_;
		gint d = 0;
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp31_;
		gint _tmp32_ = 0;
		gboolean _tmp33_;
		gchar* line = NULL;
		GDataInputStream* _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		gint _tmp40_ = 0;
		guint8* _tmp41_;
		guint8* _tmp42_;
		gint _tmp42__length1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint c = 0;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				{
					guint8 _tmp1_ = 0U;
					GDataInputStream* _tmp2_;
					_tmp2_ = self->priv->script;
					_tmp1_ = g_data_input_stream_read_byte (_tmp2_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_IO_ERROR) {
							goto __catch1_g_io_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					c = (gint) _tmp1_;
				}
				goto __finally1;
				__catch1_g_io_error:
				{
					GError* e = NULL;
					GError* _tmp3_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					GError* _tmp12_;
					const gchar* _tmp13_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp3_ = e;
					if (_tmp3_->code == G_IO_ERROR_FAILED) {
						const gchar* _tmp4_;
						const gchar* _tmp5_;
						GError* _tmp6_;
						const gchar* _tmp7_;
						guint8* _tmp8_;
						guint8* _tmp9_;
						gint _tmp9__length1;
						_tmp4_ = self->priv->_device;
						_tmp5_ = self->priv->script_file;
						_tmp6_ = e;
						_tmp7_ = _tmp6_->message;
						g_debug ("umockdev.vala:1917: ScriptRunner[%s]: end of script %s, closing: %s", _tmp4_, _tmp5_, _tmp7_);
						_vala_op = 'Q';
						_vala_delta = (guint32) 0;
						_tmp8_ = g_new0 (guint8, 0);
						_tmp9_ = _tmp8_;
						_tmp9__length1 = 0;
						if (result_length1) {
							*result_length1 = _tmp9__length1;
						}
						result = _tmp9_;
						_g_error_free0 (e);
						if (op) {
							*op = _vala_op;
						}
						if (delta) {
							*delta = _vala_delta;
						}
						return result;
					}
					_tmp10_ = self->priv->_device;
					_tmp11_ = self->priv->script_file;
					_tmp12_ = e;
					_tmp13_ = _tmp12_->message;
					g_error ("umockdev.vala:1922: ScriptRunner[%s]: failed to read script %s: %s", _tmp10_, _tmp11_, _tmp13_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_IO_ERROR) {
						goto __catch0_g_io_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				if (c == ((gint) '#')) {
					gchar* _tmp14_ = NULL;
					GDataInputStream* _tmp15_;
					gchar* _tmp16_;
					_tmp15_ = self->priv->script;
					_tmp16_ = g_data_input_stream_read_line (_tmp15_, NULL, NULL, &_inner_error0_);
					_tmp14_ = _tmp16_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_IO_ERROR) {
							goto __catch0_g_io_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_vala_assert (_tmp14_ != NULL, "this.script.read_line () != null");
					_g_free0 (_tmp14_);
				} else {
					if (c != ((gint) '\n')) {
						_vala_op = (gchar) c;
						break;
					}
				}
			}
		}
		_tmp17_ = self->priv->script;
		cur_pos = g_seekable_tell ((GSeekable*) _tmp17_);
		_tmp19_ = self->priv->script;
		_tmp18_ = g_data_input_stream_read_byte (_tmp19_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		if (_tmp18_ != ((guint8) ' ')) {
			const gchar* _tmp20_;
			_tmp20_ = self->priv->script_file;
			g_error ("Missing space after operation code in %s at position %" G_GUINT64_FORMAT, _tmp20_, cur_pos);
		}
		_tmp21_ = self->priv->script;
		cur_pos = g_seekable_tell ((GSeekable*) _tmp21_);
		{
			gsize len = 0UL;
			gchar* _tmp22_ = NULL;
			GDataInputStream* _tmp23_;
			gsize _tmp24_ = 0UL;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp23_ = self->priv->script;
			_tmp25_ = g_data_input_stream_read_upto (_tmp23_, " ", (gssize) -1, &_tmp24_, NULL, &_inner_error0_);
			len = _tmp24_;
			_tmp22_ = _tmp25_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch2_g_io_error;
				}
				_g_free0 (delta_str);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp26_ = _tmp22_;
			_tmp22_ = NULL;
			_g_free0 (delta_str);
			delta_str = _tmp26_;
			_g_free0 (_tmp22_);
		}
		goto __finally2;
		__catch2_g_io_error:
		{
			GError* e = NULL;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp27_ = self->priv->script_file;
			_tmp28_ = e->message;
			g_error ("No time value in %s at position %" G_GUINT64_FORMAT ": %s", _tmp27_, cur_pos, _tmp28_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (delta_str);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp29_ = self->priv->script;
		b = g_data_input_stream_read_byte (_tmp29_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (delta_str);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_vala_assert (b == ((guint8) ' '), "b == ' '");
		_tmp31_ = delta_str;
		_tmp33_ = int_try_parse (_tmp31_, &_tmp32_, NULL, (guint) 0);
		d = _tmp32_;
		if (!_tmp33_) {
			_tmp30_ = TRUE;
		} else {
			_tmp30_ = d < 0;
		}
		if (_tmp30_) {
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			_tmp34_ = delta_str;
			_tmp35_ = self->priv->script_file;
			g_error ("Invalid time value '%s' in %s at position %" G_GUINT64_FORMAT, _tmp34_, _tmp35_, cur_pos);
		}
		_vala_delta = (guint32) d;
		_tmp36_ = self->priv->script;
		_tmp37_ = g_data_input_stream_read_line (_tmp36_, NULL, NULL, &_inner_error0_);
		line = _tmp37_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (delta_str);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp38_ = line;
		_vala_assert (_tmp38_ != NULL, "line != null");
		_tmp39_ = line;
		_tmp41_ = umockdev_script_runner_decode (_tmp39_, &_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp42__length1 = _tmp40_;
		if (result_length1) {
			*result_length1 = _tmp42__length1;
		}
		result = _tmp42_;
		_g_free0 (line);
		_g_free0 (delta_str);
		if (op) {
			*op = _vala_op;
		}
		if (delta) {
			*delta = _vala_delta;
		}
		return result;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = self->priv->_device;
		_tmp44_ = self->priv->script_file;
		_tmp45_ = e->message;
		g_error ("umockdev.vala:1959: ScriptRunner[%s]: failed to read script %s: %s", _tmp43_, _tmp44_, _tmp45_);
		_g_error_free0 (e);
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
umockdev_script_runner_op_write (UMockdevScriptRunner* self,
                                 guint8* data,
                                 gint data_length1,
                                 guint32 delta)
{
	fd_set fds = {0};
	struct timeval timeout = {0};
	struct timeval _tmp0_ = {0};
	gssize len = 0L;
	guint8* buf = NULL;
	guint8* _tmp1_;
	gint buf_length1;
	gint _buf_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_.tv_sec = (time_t) 0;
	_tmp0_.tv_usec = (glong) 200000;
	timeout = _tmp0_;
	len = (gssize) 0;
	_tmp1_ = g_new0 (guint8, data_length1);
	buf = _tmp1_;
	buf_length1 = data_length1;
	_buf_size_ = buf_length1;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		fd_set _tmp3_ = {0};
		gint res = 0;
		struct timeval _tmp4_;
		gssize ret = 0L;
		guint8* _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp17_;
		if (self->priv->running) {
			_tmp2_ = len < ((gssize) data_length1);
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		FD_ZERO (&_tmp3_);
		fds = _tmp3_;
		FD_SET (self->priv->fd, &fds);
		_tmp4_ = timeout;
		res = select (self->priv->fd + 1, &fds, NULL, NULL, &_tmp4_);
		if (res < 0) {
			const gchar* _tmp5_;
			if (errno == EINTR) {
				continue;
			}
			_tmp5_ = self->priv->_device;
			g_error ("umockdev.vala:1979: ScriptRunner op_write[%s]: select() failed: %m", _tmp5_);
		}
		if (res == 0) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = self->priv->_device;
			_tmp7_ = umockdev_script_runner_encode (data + ((gint) len), (gint) (data_length1 - ((gint) len)));
			_tmp8_ = _tmp7_;
			g_debug ("umockdev.vala:1983: ScriptRunner[%s]: timed out on read operation on e" \
"xpected block '%s', trying again", _tmp6_, _tmp8_);
			_g_free0 (_tmp8_);
			continue;
		}
		_tmp9_ = buf;
		_tmp9__length1 = buf_length1;
		ret = read (self->priv->fd, &_tmp9_[len], (gsize) (data_length1 - len));
		if (ret <= ((gssize) 0)) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = self->priv->_device;
			_tmp11_ = umockdev_script_runner_encode (data + ((gint) len), (gint) (data_length1 - ((gint) len)));
			_tmp12_ = _tmp11_;
			g_debug ("umockdev.vala:1991: ScriptRunner[%s]: got failure or EOF on read opera" \
"tion on expected block '%s', resetting", _tmp10_, _tmp12_);
			_g_free0 (_tmp12_);
			{
				GDataInputStream* _tmp13_;
				_tmp13_ = self->priv->script;
				g_seekable_seek ((GSeekable*) _tmp13_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp14_ = self->priv->_device;
				_tmp15_ = self->priv->script_file;
				_tmp16_ = e->message;
				g_error ("umockdev.vala:1996: ScriptRunner[%s]: failed to reset script %s: %s", _tmp14_, _tmp15_, _tmp16_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				buf = (g_free (buf), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			buf = (g_free (buf), NULL);
			return;
		}
		len += ret;
		_tmp17_ = self->priv->_device;
		g_debug ("ScriptRunner[%s]: op_write, got %" G_GSSIZE_FORMAT " bytes; expecting  %" G_GSSIZE_FORMAT " more, full block size %i", _tmp17_, ret, data_length1 - len, data_length1);
	}
	if (!self->priv->running) {
		buf = (g_free (buf), NULL);
		return;
	}
	_vala_assert (len == ((gssize) data_length1), "len == data.length");
	if (self->priv->fuzz == ((guint) 0)) {
		guint8* _tmp18_;
		gint _tmp18__length1;
		_tmp18_ = buf;
		_tmp18__length1 = buf_length1;
		if (memcmp (_tmp18_, data, (gsize) len) != 0) {
			const gchar* _tmp19_;
			guint8* _tmp20_;
			gint _tmp20__length1;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp19_ = self->priv->_device;
			_tmp20_ = buf;
			_tmp20__length1 = buf_length1;
			_tmp21_ = umockdev_script_runner_encode (_tmp20_, (gint) _tmp20__length1);
			_tmp22_ = _tmp21_;
			_tmp23_ = umockdev_script_runner_encode (data, (gint) data_length1);
			_tmp24_ = _tmp23_;
			g_error ("ScriptRunner op_write[%s]: data mismatch; got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s'", _tmp19_, _tmp22_, len, _tmp24_);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp22_);
		}
	} else {
		guint d = 0U;
		guint8* _tmp25_;
		gint _tmp25__length1;
		_tmp25_ = buf;
		_tmp25__length1 = buf_length1;
		d = umockdev_script_runner_hamming (_tmp25_, (gint) _tmp25__length1, data, (gint) data_length1);
		if (((gssize) (d * 100)) > (self->priv->fuzz * len)) {
			const gchar* _tmp26_;
			guint8* _tmp27_;
			gint _tmp27__length1;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp26_ = self->priv->_device;
			_tmp27_ = buf;
			_tmp27__length1 = buf_length1;
			_tmp28_ = umockdev_script_runner_encode (_tmp27_, (gint) _tmp27__length1);
			_tmp29_ = _tmp28_;
			_tmp30_ = umockdev_script_runner_encode (data, (gint) data_length1);
			_tmp31_ = _tmp30_;
			g_error ("ScriptRunner op_write[%s]: data mismatch; got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s', difference %u%% > fuzz level %u%%", _tmp26_, _tmp29_, len, _tmp31_, ((guint) (((d * 1000) / len) + 5)) / 10, self->priv->fuzz);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
		} else {
			const gchar* _tmp32_;
			guint8* _tmp33_;
			gint _tmp33__length1;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp32_ = self->priv->_device;
			_tmp33_ = buf;
			_tmp33__length1 = buf_length1;
			_tmp34_ = umockdev_script_runner_encode (_tmp33_, (gint) _tmp33__length1);
			_tmp35_ = _tmp34_;
			_tmp36_ = umockdev_script_runner_encode (data, (gint) data_length1);
			_tmp37_ = _tmp36_;
			g_debug ("ScriptRunner op_write[%s]: data matches: got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s', difference %u%% <= fuzz level %u%%", _tmp32_, _tmp35_, len, _tmp37_, ((guint) (((d * 1000) / len) + 5)) / 10, self->priv->fuzz);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
		}
	}
	buf = (g_free (buf), NULL);
}

static void
_vala_array_add12 (guint8* * array,
                   gint* length,
                   gint* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add13 (guint8* * array,
                   gint* length,
                   gint* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static guint8*
umockdev_script_runner_decode (const gchar* quoted,
                               gint* result_length1)
{
	gint i = 0;
	guint8* data = NULL;
	guint8* _tmp9_;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp34_;
	gint _tmp34__length1;
	guint8* result;
	g_return_val_if_fail (quoted != NULL, NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			guint8* _tmp3_;
			gint _tmp3__length1;
			gint _tmp4_ = 0;
			guint8* _tmp5_;
			gint _tmp5__length1;
			guint8 _tmp6_;
			if (!_tmp0_) {
				gint _tmp1_;
				i = i + 1;
				_tmp1_ = i;
			}
			_tmp0_ = FALSE;
			_tmp3_ = string_get_data (quoted, &_tmp4_);
			_tmp3__length1 = _tmp4_;
			_tmp5_ = _tmp3_;
			_tmp5__length1 = _tmp3__length1;
			_tmp6_ = _tmp5_[i];
			if (_tmp6_ == ((guint8) ' ')) {
				gint _tmp7_;
				gint _tmp8_;
				_tmp7_ = strlen (quoted);
				_tmp8_ = _tmp7_;
				_tmp2_ = i < _tmp8_;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
		}
	}
	_tmp9_ = g_new0 (guint8, 0);
	data = _tmp9_;
	data_length1 = 0;
	_data_size_ = data_length1;
	{
		gboolean _tmp10_ = FALSE;
		_tmp10_ = TRUE;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			guint8* _tmp14_;
			gint _tmp14__length1;
			gint _tmp15_ = 0;
			guint8* _tmp16_;
			gint _tmp16__length1;
			guint8 _tmp17_;
			if (!_tmp10_) {
				gint _tmp11_;
				i = i + 1;
				_tmp11_ = i;
			}
			_tmp10_ = FALSE;
			_tmp12_ = strlen (quoted);
			_tmp13_ = _tmp12_;
			if (!(i < _tmp13_)) {
				break;
			}
			_tmp14_ = string_get_data (quoted, &_tmp15_);
			_tmp14__length1 = _tmp15_;
			_tmp16_ = _tmp14_;
			_tmp16__length1 = _tmp14__length1;
			_tmp17_ = _tmp16_[i];
			if (_tmp17_ == ((guint8) '^')) {
				gint _tmp18_;
				gint _tmp19_;
				gchar _tmp20_ = '\0';
				guint8* _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_ = 0;
				guint8* _tmp23_;
				gint _tmp23__length1;
				guint8 _tmp24_;
				gint _tmp29_;
				_tmp18_ = strlen (quoted);
				_tmp19_ = _tmp18_;
				_vala_assert ((i + 1) < _tmp19_, "i + 1 < quoted.length");
				_tmp21_ = string_get_data (quoted, &_tmp22_);
				_tmp21__length1 = _tmp22_;
				_tmp23_ = _tmp21_;
				_tmp23__length1 = _tmp21__length1;
				_tmp24_ = _tmp23_[i + 1];
				if (_tmp24_ == ((guint8) '`')) {
					_tmp20_ = '^';
				} else {
					guint8* _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_ = 0;
					guint8* _tmp27_;
					gint _tmp27__length1;
					guint8 _tmp28_;
					_tmp25_ = string_get_data (quoted, &_tmp26_);
					_tmp25__length1 = _tmp26_;
					_tmp27_ = _tmp25_;
					_tmp27__length1 = _tmp25__length1;
					_tmp28_ = _tmp27_[i + 1];
					_tmp20_ = (gchar) (_tmp28_ - 64);
				}
				_vala_array_add12 (&data, &data_length1, &_data_size_, (guint8) _tmp20_);
				i = i + 1;
				_tmp29_ = i;
			} else {
				guint8* _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_ = 0;
				guint8* _tmp32_;
				gint _tmp32__length1;
				guint8 _tmp33_;
				_tmp30_ = string_get_data (quoted, &_tmp31_);
				_tmp30__length1 = _tmp31_;
				_tmp32_ = _tmp30_;
				_tmp32__length1 = _tmp30__length1;
				_tmp33_ = _tmp32_[i];
				_vala_array_add13 (&data, &data_length1, &_data_size_, _tmp33_);
			}
		}
	}
	_tmp34_ = data;
	_tmp34__length1 = data_length1;
	if (result_length1) {
		*result_length1 = _tmp34__length1;
	}
	result = _tmp34_;
	return result;
}

static void
_vala_array_add14 (guint8* * array,
                   gint* length,
                   gint* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add15 (guint8* * array,
                   gint* length,
                   gint* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add16 (guint8* * array,
                   gint* length,
                   gint* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add17 (guint8* * array,
                   gint* length,
                   gint* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add18 (guint8* * array,
                   gint* length,
                   gint* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add19 (guint8* * array,
                   gint* length,
                   gint* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

gchar*
umockdev_script_runner_encode (guint8* data,
                               gint data_length1)
{
	guint8* quoted = NULL;
	guint8* _tmp0_;
	gint quoted_length1;
	gint _quoted_size_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	gchar* result;
	_tmp0_ = g_new0 (guint8, 0);
	quoted = _tmp0_;
	quoted_length1 = 0;
	_quoted_size_ = quoted_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint8 _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					i = i + 1;
					_tmp2_ = i;
				}
				_tmp1_ = FALSE;
				if (!(i < data_length1)) {
					break;
				}
				_tmp3_ = data[i];
				if (((gint) _tmp3_) < 32) {
					guint8 _tmp4_;
					_vala_array_add14 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '^');
					_tmp4_ = data[i];
					_vala_array_add15 (&quoted, &quoted_length1, &_quoted_size_, (guint8) (_tmp4_ + 64));
				} else {
					guint8 _tmp5_;
					_tmp5_ = data[i];
					if (_tmp5_ == ((guint8) '^')) {
						_vala_array_add16 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '^');
						_vala_array_add17 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '`');
					} else {
						guint8 _tmp6_;
						_tmp6_ = data[i];
						_vala_array_add18 (&quoted, &quoted_length1, &_quoted_size_, _tmp6_);
					}
				}
			}
		}
	}
	_vala_array_add19 (&quoted, &quoted_length1, &_quoted_size_, (guint8) 0);
	_tmp7_ = quoted;
	_tmp7__length1 = quoted_length1;
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	result = _tmp8_;
	quoted = (g_free (quoted), NULL);
	return result;
}

static guint
umockdev_script_runner_hamming (guint8* d1,
                                gint d1_length1,
                                guint8* d2,
                                gint d2_length1)
{
	guint d = 0U;
	guint i = 0U;
	guint result;
	_vala_assert (d1_length1 == d2_length1, "d1.length == d2.length");
	d = (guint) 0;
	{
		gboolean _tmp0_ = FALSE;
		i = (guint) 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			guint8 _tmp2_;
			guint8 _tmp3_;
			if (!_tmp0_) {
				guint _tmp1_;
				i = i + 1;
				_tmp1_ = i;
			}
			_tmp0_ = FALSE;
			if (!(i < ((guint) d1_length1))) {
				break;
			}
			_tmp2_ = d1[i];
			_tmp3_ = d2[i];
			d += (guint) (((gint) (_tmp2_ ^ _tmp3_)) > 0);
		}
	}
	result = d;
	return result;
}

const gchar*
umockdev_script_runner_get_device (UMockdevScriptRunner* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static void
umockdev_script_runner_set_device (UMockdevScriptRunner* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_device);
	self->priv->_device = _tmp0_;
}

static void
umockdev_value_script_runner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
umockdev_value_script_runner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		umockdev_script_runner_unref (value->data[0].v_pointer);
	}
}

static void
umockdev_value_script_runner_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_script_runner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
umockdev_value_script_runner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
umockdev_value_script_runner_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UMockdevScriptRunner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_script_runner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
umockdev_value_script_runner_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	UMockdevScriptRunner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_script_runner_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
umockdev_param_spec_script_runner (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	UMockdevParamSpecScriptRunner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_SCRIPT_RUNNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
umockdev_value_get_script_runner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER), NULL);
	return value->data[0].v_pointer;
}

void
umockdev_value_set_script_runner (GValue* value,
                                  gpointer v_object)
{
	UMockdevScriptRunner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SCRIPT_RUNNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_script_runner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_script_runner_unref (old);
	}
}

void
umockdev_value_take_script_runner (GValue* value,
                                   gpointer v_object)
{
	UMockdevScriptRunner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SCRIPT_RUNNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_script_runner_unref (old);
	}
}

static void
umockdev_script_runner_class_init (UMockdevScriptRunnerClass * klass,
                                   gpointer klass_data)
{
	umockdev_script_runner_parent_class = g_type_class_peek_parent (klass);
	((UMockdevScriptRunnerClass *) klass)->finalize = umockdev_script_runner_finalize;
	g_type_class_adjust_private_offset (klass, &UMockdevScriptRunner_private_offset);
}

static void
umockdev_script_runner_instance_init (UMockdevScriptRunner * self,
                                      gpointer klass)
{
	self->priv = umockdev_script_runner_get_instance_private (self);
	self->priv->fuzz = (guint) 0;
	self->ref_count = 1;
}

static void
umockdev_script_runner_finalize (UMockdevScriptRunner * obj)
{
	UMockdevScriptRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunner);
	g_signal_handlers_destroy (self);
	umockdev_script_runner_stop (self);
	_g_free0 (self->priv->_device);
	_g_object_unref0 (self->priv->script);
	_g_free0 (self->priv->script_file);
	_g_thread_unref0 (self->priv->thread);
}

static GType
umockdev_script_runner_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { umockdev_value_script_runner_init, umockdev_value_script_runner_free_value, umockdev_value_script_runner_copy_value, umockdev_value_script_runner_peek_pointer, "p", umockdev_value_script_runner_collect_value, "p", umockdev_value_script_runner_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevScriptRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_script_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevScriptRunner), 0, (GInstanceInitFunc) umockdev_script_runner_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType umockdev_script_runner_type_id;
	umockdev_script_runner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevScriptRunner", &g_define_type_info, &g_define_type_fundamental_info, 0);
	UMockdevScriptRunner_private_offset = g_type_add_instance_private (umockdev_script_runner_type_id, sizeof (UMockdevScriptRunnerPrivate));
	return umockdev_script_runner_type_id;
}

GType
umockdev_script_runner_get_type (void)
{
	static volatile gsize umockdev_script_runner_type_id__once = 0;
	if (g_once_init_enter (&umockdev_script_runner_type_id__once)) {
		GType umockdev_script_runner_type_id;
		umockdev_script_runner_type_id = umockdev_script_runner_get_type_once ();
		g_once_init_leave (&umockdev_script_runner_type_id__once, umockdev_script_runner_type_id);
	}
	return umockdev_script_runner_type_id__once;
}

gpointer
umockdev_script_runner_ref (gpointer instance)
{
	UMockdevScriptRunner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
umockdev_script_runner_unref (gpointer instance)
{
	UMockdevScriptRunner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_SCRIPT_RUNNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
umockdev_socket_server_get_instance_private (UMockdevSocketServer* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevSocketServer_private_offset);
}

static gpointer
_umockdev_socket_server_run_gthread_func (gpointer self)
{
	gpointer result;
	result = umockdev_socket_server_run ((UMockdevSocketServer*) self);
	umockdev_socket_server_unref (self);
	return result;
}

UMockdevSocketServer*
umockdev_socket_server_construct (GType object_type)
{
	UMockdevSocketServer* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	gint* fds = NULL;
	gint* _tmp6_;
	gint fds_length1;
	gint _fds_size_;
	gint _tmp7_;
	gint _tmp8_;
	GThread* _tmp9_;
	self = (UMockdevSocketServer*) g_type_create_instance (object_type);
	self->priv->running = TRUE;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->socket_scriptfile);
	self->priv->socket_scriptfile = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _umockdev_script_runner_unref0_);
	_g_hash_table_unref0 (self->priv->script_runners);
	self->priv->script_runners = _tmp5_;
	_tmp6_ = g_new0 (gint, 2);
	fds = _tmp6_;
	fds_length1 = 2;
	_fds_size_ = fds_length1;
	_vala_assert (pipe (fds) == 0, "Posix.pipe (fds) == 0");
	_tmp7_ = fds[0];
	self->priv->ctrl_r = _tmp7_;
	_tmp8_ = fds[1];
	self->priv->ctrl_w = _tmp8_;
	_tmp9_ = g_thread_new ("SocketServer", _umockdev_socket_server_run_gthread_func, umockdev_socket_server_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp9_;
	fds = (g_free (fds), NULL);
	return self;
}

UMockdevSocketServer*
umockdev_socket_server_new (void)
{
	return umockdev_socket_server_construct (UMOCKDEV_TYPE_SOCKET_SERVER);
}

void
umockdev_socket_server_stop (UMockdevSocketServer* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp3_;
	GThread* _tmp4_;
	g_return_if_fail (self != NULL);
	if (!self->priv->running) {
		return;
	}
	g_debug ("umockdev.vala:2123: Stopping SocketServer: signalling thread");
	close (self->priv->ctrl_w);
	_tmp0_ = self->priv->script_runners;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp1_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			UMockdevScriptRunner* r = NULL;
			r = (UMockdevScriptRunner*) r_it->data;
			{
				UMockdevScriptRunner* _tmp2_;
				_tmp2_ = r;
				umockdev_script_runner_stop (_tmp2_);
			}
		}
		(r_collection == NULL) ? NULL : (r_collection = (g_list_free (r_collection), NULL));
	}
	_tmp3_ = self->priv->script_runners;
	g_hash_table_remove_all (_tmp3_);
	g_debug ("umockdev.vala:2131: Stopping SocketServer: joining thread");
	_tmp4_ = self->priv->thread;
	self->priv->thread = NULL;
	g_thread_join (_tmp4_);
}

static void
_vala_array_add20 (GSocket** * array,
                   gint* length,
                   gint* size,
                   GSocket* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GSocket*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
umockdev_socket_server_add (UMockdevSocketServer* self,
                            const gchar* sock_path,
                            gint fd,
                            const gchar* record_file)
{
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar b = '\0';
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sock_path != NULL);
	g_return_if_fail (record_file != NULL);
	{
		GSocket* s = NULL;
		GSocket* _tmp0_;
		GSocket* _tmp1_;
		gboolean _tmp2_ = FALSE;
		GSocket* _tmp3_;
		GUnixSocketAddress* _tmp4_;
		GUnixSocketAddress* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_ = FALSE;
		GSocket* _tmp8_;
		GSocket* _tmp9_;
		GSocket* _tmp10_;
		_tmp0_ = g_socket_new_from_fd (fd, &_inner_error0_);
		s = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = s;
		_vala_assert (_tmp1_ != NULL, "s != null");
		_tmp3_ = s;
		_tmp4_ = (GUnixSocketAddress*) g_unix_socket_address_new (sock_path);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_socket_bind (_tmp3_, (GSocketAddress*) _tmp5_, TRUE, &_inner_error0_);
		_g_object_unref0 (_tmp5_);
		_tmp2_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (s);
			goto __catch0_g_error;
		}
		_vala_assert (_tmp2_, "s.bind (new UnixSocketAddress (sock_path), true)");
		_tmp8_ = s;
		_tmp7_ = g_socket_listen (_tmp8_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (s);
			goto __catch0_g_error;
		}
		_vala_assert (_tmp7_, "s.listen ()");
		_tmp9_ = s;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_vala_array_add20 (&self->priv->listen_sockets, &self->priv->listen_sockets_length1, &self->priv->_listen_sockets_size_, _tmp10_);
		_g_object_unref0 (s);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e->message;
		g_error ("umockdev.vala:2144: load_socket_script(): cannot create Socket: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_debug ("umockdev.vala:2147: SocketServer.add: Created socket path %s, fd %i", sock_path, fd);
	_tmp12_ = self->priv->socket_scriptfile;
	_tmp13_ = g_strdup (sock_path);
	_tmp14_ = g_strdup (record_file);
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
	b = '1';
	_vala_assert (write (self->priv->ctrl_w, &b, (gsize) 1) == ((gssize) 1), "Posix.write (this.ctrl_w, &b, 1) == 1");
}

static void*
umockdev_socket_server_run (UMockdevSocketServer* self)
{
	GError* _inner_error0_ = NULL;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_debug ("umockdev.vala:2158: starting SocketServer thread");
	while (TRUE) {
		fd_set fds = {0};
		fd_set _tmp0_ = {0};
		gint max = 0;
		GSocket** _tmp1_;
		gint _tmp1__length1;
		gint res = 0;
		struct timeval _tmp11_ = {0};
		fd_set _tmp12_;
		GSocket** _tmp13_;
		gint _tmp13__length1;
		if (!self->priv->running) {
			break;
		}
		FD_ZERO (&_tmp0_);
		fds = _tmp0_;
		FD_SET (self->priv->ctrl_r, &fds);
		max = self->priv->ctrl_r;
		_tmp1_ = self->priv->listen_sockets;
		_tmp1__length1 = self->priv->listen_sockets_length1;
		{
			GSocket** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp1_;
			s_collection_length1 = _tmp1__length1;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				GSocket* s = NULL;
				s = s_collection[s_it];
				{
					GSocket* _tmp2_;
					gint _tmp3_;
					gint _tmp4_;
					GSocket* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					_tmp2_ = s;
					_tmp3_ = g_socket_get_fd (_tmp2_);
					_tmp4_ = _tmp3_;
					FD_SET (_tmp4_, &fds);
					_tmp5_ = s;
					_tmp6_ = g_socket_get_fd (_tmp5_);
					_tmp7_ = _tmp6_;
					if (_tmp7_ > max) {
						GSocket* _tmp8_;
						gint _tmp9_;
						gint _tmp10_;
						_tmp8_ = s;
						_tmp9_ = g_socket_get_fd (_tmp8_);
						_tmp10_ = _tmp9_;
						max = _tmp10_;
					}
				}
			}
		}
		_tmp11_.tv_sec = (time_t) 0;
		_tmp11_.tv_usec = (glong) 500000;
		res = select (max + 1, &fds, NULL, NULL, &_tmp11_);
		if (res < 0) {
			if (errno == EINTR) {
				continue;
			}
			g_error ("umockdev.vala:2177: socket server thread: select() failed: %m");
		}
		if (res == 0) {
			continue;
		}
		_tmp12_ = fds;
		if (FD_ISSET (self->priv->ctrl_r, &_tmp12_) > 0) {
			gchar buf = '\0';
			gssize r = 0L;
			g_debug ("umockdev.vala:2184: socket server thread: woken up by control fd");
			r = read (self->priv->ctrl_r, &buf, (gsize) 1);
			if (r == ((gssize) 0)) {
				self->priv->running = FALSE;
				close (self->priv->ctrl_r);
			} else {
				_vala_assert (r == ((gssize) 1), "r == 1");
			}
			continue;
		}
		g_debug ("umockdev.vala:2197: socket server thread: select() got requests");
		_tmp13_ = self->priv->listen_sockets;
		_tmp13__length1 = self->priv->listen_sockets_length1;
		{
			GSocket** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp13_;
			s_collection_length1 = _tmp13__length1;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				GSocket* s = NULL;
				s = s_collection[s_it];
				{
					GSocket* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					fd_set _tmp17_;
					_tmp14_ = s;
					_tmp15_ = g_socket_get_fd (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = fds;
					if (FD_ISSET (_tmp16_, &_tmp17_) > 0) {
						gint fd = 0;
						GSocket* _tmp18_;
						gint _tmp19_;
						gint _tmp20_;
						gchar* sock_path = NULL;
						_tmp18_ = s;
						_tmp19_ = g_socket_get_fd (_tmp18_);
						_tmp20_ = _tmp19_;
						fd = accept (_tmp20_, NULL, NULL);
						if (fd < 0) {
							g_error ("umockdev.vala:2204: socket server thread: accept() failed: %m");
						}
						sock_path = NULL;
						{
							GSocketAddress* _tmp21_ = NULL;
							GSocket* _tmp22_;
							GSocketAddress* _tmp23_;
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* scriptfile = NULL;
							GHashTable* _tmp27_;
							const gchar* _tmp28_;
							gconstpointer _tmp29_;
							gchar* _tmp30_;
							GSocket* _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							const gchar* _tmp34_;
							const gchar* _tmp35_;
							gchar* key = NULL;
							const gchar* _tmp36_;
							gchar* _tmp37_;
							GFileInputStream* _tmp38_ = NULL;
							const gchar* _tmp39_;
							GFile* _tmp40_;
							GFile* _tmp41_;
							GFileInputStream* _tmp42_;
							GFileInputStream* _tmp43_;
							GDataInputStream* script = NULL;
							GDataInputStream* _tmp44_;
							UMockdevScriptRunner* _tmp45_ = NULL;
							const gchar* _tmp46_;
							GDataInputStream* _tmp47_;
							const gchar* _tmp48_;
							UMockdevScriptRunner* _tmp49_;
							GHashTable* _tmp50_;
							const gchar* _tmp51_;
							gchar* _tmp52_;
							UMockdevScriptRunner* _tmp53_;
							_tmp22_ = s;
							_tmp23_ = g_socket_get_local_address (_tmp22_, &_inner_error0_);
							_tmp21_ = _tmp23_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
							_tmp24_ = g_unix_socket_address_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, G_TYPE_UNIX_SOCKET_ADDRESS, GUnixSocketAddress));
							_tmp25_ = _tmp24_;
							_tmp26_ = g_strdup (_tmp25_);
							_g_free0 (sock_path);
							sock_path = _tmp26_;
							_tmp27_ = self->priv->socket_scriptfile;
							_tmp28_ = sock_path;
							_tmp29_ = g_hash_table_lookup (_tmp27_, _tmp28_);
							_tmp30_ = g_strdup ((const gchar*) _tmp29_);
							scriptfile = _tmp30_;
							_tmp31_ = s;
							_tmp32_ = g_socket_get_fd (_tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = sock_path;
							_tmp35_ = scriptfile;
							g_debug ("umockdev.vala:2209: socket server thread: accepted request on server s" \
"ocket fd %i, path %s, script %s", _tmp33_, _tmp34_, _tmp35_);
							_tmp36_ = sock_path;
							_tmp37_ = g_strdup_printf ("%s%i", _tmp36_, fd);
							key = _tmp37_;
							_tmp39_ = scriptfile;
							_tmp40_ = g_file_new_for_path (_tmp39_);
							_tmp41_ = _tmp40_;
							_tmp42_ = g_file_read (_tmp41_, NULL, &_inner_error0_);
							_tmp43_ = _tmp42_;
							_g_object_unref0 (_tmp41_);
							_tmp38_ = _tmp43_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_free0 (key);
								_g_free0 (scriptfile);
								_g_object_unref0 (_tmp21_);
								goto __catch0_g_error;
							}
							_tmp44_ = g_data_input_stream_new ((GInputStream*) _tmp38_);
							script = _tmp44_;
							_tmp46_ = key;
							_tmp47_ = script;
							_tmp48_ = scriptfile;
							_tmp49_ = umockdev_script_runner_new (fd, _tmp46_, _tmp47_, _tmp48_, &_inner_error0_);
							_tmp45_ = _tmp49_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (script);
								_g_object_unref0 (_tmp38_);
								_g_free0 (key);
								_g_free0 (scriptfile);
								_g_object_unref0 (_tmp21_);
								goto __catch0_g_error;
							}
							_tmp50_ = self->priv->script_runners;
							_tmp51_ = key;
							_tmp52_ = g_strdup (_tmp51_);
							_tmp53_ = _tmp45_;
							_tmp45_ = NULL;
							g_hash_table_insert (_tmp50_, _tmp52_, _tmp53_);
							_umockdev_script_runner_unref0 (_tmp45_);
							_g_object_unref0 (script);
							_g_object_unref0 (_tmp38_);
							_g_free0 (key);
							_g_free0 (scriptfile);
							_g_object_unref0 (_tmp21_);
						}
						goto __finally0;
						__catch0_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp54_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp54_ = e->message;
							g_error ("umockdev.vala:2215: socket server thread: cannot launch ScriptRunner: " \
"%s", _tmp54_);
							_g_error_free0 (e);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (sock_path);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_g_free0 (sock_path);
					}
				}
			}
		}
	}
	g_debug ("umockdev.vala:2221: socket server thread: end");
	result = NULL;
	return result;
}

static void
umockdev_value_socket_server_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
umockdev_value_socket_server_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		umockdev_socket_server_unref (value->data[0].v_pointer);
	}
}

static void
umockdev_value_socket_server_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_socket_server_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
umockdev_value_socket_server_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
umockdev_value_socket_server_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UMockdevSocketServer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_socket_server_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
umockdev_value_socket_server_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	UMockdevSocketServer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_socket_server_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
umockdev_param_spec_socket_server (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	UMockdevParamSpecSocketServer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_SOCKET_SERVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
umockdev_value_get_socket_server (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER), NULL);
	return value->data[0].v_pointer;
}

void
umockdev_value_set_socket_server (GValue* value,
                                  gpointer v_object)
{
	UMockdevSocketServer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SOCKET_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_socket_server_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_socket_server_unref (old);
	}
}

void
umockdev_value_take_socket_server (GValue* value,
                                   gpointer v_object)
{
	UMockdevSocketServer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SOCKET_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_socket_server_unref (old);
	}
}

static void
umockdev_socket_server_class_init (UMockdevSocketServerClass * klass,
                                   gpointer klass_data)
{
	umockdev_socket_server_parent_class = g_type_class_peek_parent (klass);
	((UMockdevSocketServerClass *) klass)->finalize = umockdev_socket_server_finalize;
	g_type_class_adjust_private_offset (klass, &UMockdevSocketServer_private_offset);
}

static void
umockdev_socket_server_instance_init (UMockdevSocketServer * self,
                                      gpointer klass)
{
	GSocket** _tmp0_;
	self->priv = umockdev_socket_server_get_instance_private (self);
	_tmp0_ = g_new0 (GSocket*, 0 + 1);
	self->priv->listen_sockets = _tmp0_;
	self->priv->listen_sockets_length1 = 0;
	self->priv->_listen_sockets_size_ = self->priv->listen_sockets_length1;
	self->ref_count = 1;
}

static void
umockdev_socket_server_finalize (UMockdevSocketServer * obj)
{
	UMockdevSocketServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServer);
	g_signal_handlers_destroy (self);
	umockdev_socket_server_stop (self);
	self->priv->listen_sockets = (_vala_array_free (self->priv->listen_sockets, self->priv->listen_sockets_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->socket_scriptfile);
	_g_hash_table_unref0 (self->priv->script_runners);
	_g_thread_unref0 (self->priv->thread);
}

static GType
umockdev_socket_server_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { umockdev_value_socket_server_init, umockdev_value_socket_server_free_value, umockdev_value_socket_server_copy_value, umockdev_value_socket_server_peek_pointer, "p", umockdev_value_socket_server_collect_value, "p", umockdev_value_socket_server_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevSocketServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_socket_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevSocketServer), 0, (GInstanceInitFunc) umockdev_socket_server_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType umockdev_socket_server_type_id;
	umockdev_socket_server_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevSocketServer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	UMockdevSocketServer_private_offset = g_type_add_instance_private (umockdev_socket_server_type_id, sizeof (UMockdevSocketServerPrivate));
	return umockdev_socket_server_type_id;
}

GType
umockdev_socket_server_get_type (void)
{
	static volatile gsize umockdev_socket_server_type_id__once = 0;
	if (g_once_init_enter (&umockdev_socket_server_type_id__once)) {
		GType umockdev_socket_server_type_id;
		umockdev_socket_server_type_id = umockdev_socket_server_get_type_once ();
		g_once_init_leave (&umockdev_socket_server_type_id__once, umockdev_socket_server_type_id);
	}
	return umockdev_socket_server_type_id__once;
}

gpointer
umockdev_socket_server_ref (gpointer instance)
{
	UMockdevSocketServer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
umockdev_socket_server_unref (gpointer instance)
{
	UMockdevSocketServer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_SOCKET_SERVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

/**
 * umockdev_in_mock_environment:
 *
 * Check whether the current process is running under umockdev-wrapper, i. e.
 * the umockdev preload library.
 *
 * Returns: %TRUE if running under preload with mocked devices, %FALSE if
 *          running against the real system.
 */
gboolean
umockdev_in_mock_environment (void)
{
	gboolean result;
	if (!umockdev___in_mock_env_initialized) {
		struct stat st = {0};
		struct stat _tmp0_ = {0};
		gint _tmp1_;
		_tmp1_ = stat ("/sys", &_tmp0_);
		st = _tmp0_;
		if (_tmp1_ >= 0) {
			struct stat _tmp2_;
			_tmp2_ = st;
			umockdev___in_mock_env_result = _tmp2_.st_ino > ((ino_t) 1);
		}
		umockdev___in_mock_env_initialized = TRUE;
	}
	result = umockdev___in_mock_env_result;
	return result;
}

GQuark
umockdev_error_quark (void)
{
	return g_quark_from_static_string ("umockdev-error-quark");
}

static GType
umockdev_error_get_type_once (void)
{
	static const GEnumValue values[] = {{UMOCKDEV_ERROR_PARSE, "UMOCKDEV_ERROR_PARSE", "parse"}, {UMOCKDEV_ERROR_VALUE, "UMOCKDEV_ERROR_VALUE", "value"}, {0, NULL, NULL}};
	GType umockdev_error_type_id;
	umockdev_error_type_id = g_enum_register_static ("UMockdevError", values);
	return umockdev_error_type_id;
}

GType
umockdev_error_get_type (void)
{
	static volatile gsize umockdev_error_type_id__once = 0;
	if (g_once_init_enter (&umockdev_error_type_id__once)) {
		GType umockdev_error_type_id;
		umockdev_error_type_id = umockdev_error_get_type_once ();
		g_once_init_leave (&umockdev_error_type_id__once, umockdev_error_type_id);
	}
	return umockdev_error_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

