// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from formatter.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

#include <format>

#include <properties/AlignmentProperty.h>
#include <properties/BackgroundProperty.h>
#include <properties/BorderProperty.h>
#include <properties/CornerProperty.h>
#include <properties/CornersProperty.h>
#include <properties/IconProperty.h>
#include <properties/ImageProperty.h>
#include <properties/LayoutProperty.h>
#include <properties/LineProperty.h>
#include <properties/OffsetProperty.h>
#include <properties/OutlineProperty.h>
#include <properties/ShadowProperty.h>
#include <properties/SizeProperty.h>
#include <properties/StyleProperty.h>
#include <properties/TextProperty.h>

namespace
{
inline static std::string whitespace(std::size_t(1024), ' ');
}

std::string_view indent(int amount)
{
    return std::string_view(whitespace.begin(), whitespace.begin() + amount);
}

template<typename T>
struct std::formatter<std::optional<T>, char> {
    std::string content_format;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            itr++;
        }
        content_format = std::string(context.begin(), itr);
        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const std::optional<T> &value, FormatContext &context) const
    {
        if (value.has_value()) {
            return std::vformat_to(context.out(), "{0:" + content_format + "}", std::make_format_args(value.value()));
        } else {
            return std::ranges::copy("(empty)", context.out()).out;
        }
    }
};

template<>
struct std::formatter<QColor, char> : public std::formatter<std::string, char> {
    template<class FormatContext>
    FormatContext::iterator format(QColor value, FormatContext &context) const
    {
        return std::formatter<std::string, char>::format(value.name().toStdString(), context);
    }
};

template<>
struct std::formatter<QFont, char> : public std::formatter<std::string, char> {
    template<class FormatContext>
    FormatContext::iterator format(QFont value, FormatContext &context) const
    {
        return std::formatter<std::string, char>::format(value.toString().toStdString(), context);
    }
};

template<>
struct std::formatter<QString, char> : public std::formatter<std::string, char> {
    template<class FormatContext>
    FormatContext::iterator format(QString value, FormatContext &context) const
    {
        return std::formatter<std::string, char>::format(value.toStdString(), context);
    }
};

template<>
struct std::formatter<QUrl, char> : public std::formatter<std::string, char> {
    template<class FormatContext>
    FormatContext::iterator format(QUrl value, FormatContext &context) const
    {
        return std::formatter<std::string, char>::format(value.toString().toStdString(), context);
    }
};

template<>
struct std::formatter<QImage, char> : public std::formatter<std::string, char> {
    template<class FormatContext>
    FormatContext::iterator format(QImage value, FormatContext &context) const
    {
        auto metaEnum = QMetaEnum::fromType<QImage::Format>();
        auto tmp = std::format("QImage(fmt={0}, width={1}, height={2})", metaEnum.valueToKey(value.format()), value.width(), value.height());
        return std::formatter<std::string, char>::format(tmp, context);
    }
};

template<>
struct std::formatter<Qt::Alignment, char> : public std::formatter<std::string, char> {
    template<class FormatContext>
    FormatContext::iterator format(Qt::Alignment value, FormatContext &context) const
    {
        auto metaEnum = QMetaEnum::fromType<Qt::Alignment>();
        return std::formatter<std::string, char>::format(metaEnum.valueToKeys(value).toStdString(), context);
    }
};

template<typename T>
    requires std::is_enum_v<T>
struct std::formatter<T, char> : public std::formatter<std::string, char> {
    template<class FormatContext>
    FormatContext::iterator format(T value, FormatContext &context) const
    {
        auto metaEnum = QMetaEnum::fromType<T>();
        return std::formatter<std::string, char>::format(metaEnum.valueToKey(int(value)), context);
    }
};

template<typename T>
    requires std::is_enum_v<T>
struct std::formatter<QFlags<T>, char> : public std::formatter<std::string, char> {
    template<class FormatContext>
    FormatContext::iterator format(const QFlags<T> value, FormatContext &context) const
    {
        auto metaEnum = QMetaEnum::fromType<T>();
        return std::formatter<std::string, char>::format(metaEnum.valueToKeys(value).toStdString(), context);
    }
};

template<>
struct std::formatter<Union::Properties::StyleProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::StyleProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "layout: ";
        {
            auto value = group.layout();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "text: ";
        {
            auto value = group.text();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "icon: ";
        {
            auto value = group.icon();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "background: ";
        {
            auto value = group.background();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "border: ";
        {
            auto value = group.border();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "outline: ";
        {
            auto value = group.outline();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "corners: ";
        {
            auto value = group.corners();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "shadow: ";
        {
            auto value = group.shadow();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::LayoutProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::LayoutProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "alignment: ";
        {
            auto value = group.alignment();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "width: ";
        {
            auto value = group.width();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "height: ";
        {
            auto value = group.height();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "spacing: ";
        {
            auto value = group.spacing();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "padding: ";
        {
            auto value = group.padding();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "inset: ";
        {
            auto value = group.inset();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "margins: ";
        {
            auto value = group.margins();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::AlignmentProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::AlignmentProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "container: ";
        {
            auto value = group.container();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "horizontal: ";
        {
            auto value = group.horizontal();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "vertical: ";
        {
            auto value = group.vertical();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "order: ";
        {
            auto value = group.order();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::SizeProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::SizeProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "left: ";
        {
            auto value = group.left();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "right: ";
        {
            auto value = group.right();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "top: ";
        {
            auto value = group.top();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "bottom: ";
        {
            auto value = group.bottom();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::TextProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::TextProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "alignment: ";
        {
            auto value = group.alignment();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "font: ";
        {
            auto value = group.font();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "color: ";
        {
            auto value = group.color();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::IconProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::IconProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "alignment: ";
        {
            auto value = group.alignment();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "width: ";
        {
            auto value = group.width();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "height: ";
        {
            auto value = group.height();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "name: ";
        {
            auto value = group.name();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "source: ";
        {
            auto value = group.source();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "color: ";
        {
            auto value = group.color();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::BackgroundProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::BackgroundProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "color: ";
        {
            auto value = group.color();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "image: ";
        {
            auto value = group.image();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::ImageProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::ImageProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "imageData: ";
        {
            auto value = group.imageData();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "width: ";
        {
            auto value = group.width();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "height: ";
        {
            auto value = group.height();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "xOffset: ";
        {
            auto value = group.xOffset();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "yOffset: ";
        {
            auto value = group.yOffset();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "flags: ";
        {
            auto value = group.flags();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "maskColor: ";
        {
            auto value = group.maskColor();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::BorderProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::BorderProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "left: ";
        {
            auto value = group.left();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "right: ";
        {
            auto value = group.right();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "top: ";
        {
            auto value = group.top();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "bottom: ";
        {
            auto value = group.bottom();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::LineProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::LineProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "size: ";
        {
            auto value = group.size();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "color: ";
        {
            auto value = group.color();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "style: ";
        {
            auto value = group.style();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "image: ";
        {
            auto value = group.image();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::OutlineProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::OutlineProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "left: ";
        {
            auto value = group.left();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "right: ";
        {
            auto value = group.right();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "top: ";
        {
            auto value = group.top();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "bottom: ";
        {
            auto value = group.bottom();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::CornersProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::CornersProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "topLeft: ";
        {
            auto value = group.topLeft();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "topRight: ";
        {
            auto value = group.topRight();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "bottomLeft: ";
        {
            auto value = group.bottomLeft();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "bottomRight: ";
        {
            auto value = group.bottomRight();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::CornerProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::CornerProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "radius: ";
        {
            auto value = group.radius();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "width: ";
        {
            auto value = group.width();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "height: ";
        {
            auto value = group.height();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "color: ";
        {
            auto value = group.color();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "image: ";
        {
            auto value = group.image();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::ShadowProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::ShadowProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "offset: ";
        {
            auto value = group.offset();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "color: ";
        {
            auto value = group.color();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "size: ";
        {
            auto value = group.size();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "blur: ";
        {
            auto value = group.blur();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "left: ";
        {
            auto value = group.left();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "right: ";
        {
            auto value = group.right();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "top: ";
        {
            auto value = group.top();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "bottom: ";
        {
            auto value = group.bottom();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "topLeft: ";
        {
            auto value = group.topLeft();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "topRight: ";
        {
            auto value = group.topRight();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "bottomLeft: ";
        {
            auto value = group.bottomLeft();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "bottomRight: ";
        {
            auto value = group.bottomRight();
            if (use_newlines) {
                if (value.has_value()) {
                    auto format_string = "\n{0:nl" + std::to_string(indentation + 2) + "}";
                    out << std::vformat(format_string, std::make_format_args(value));
                } else {
                    out << "(empty)\n";
                }
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

template<>
struct std::formatter<Union::Properties::OffsetProperty, char> {
    bool use_newlines = false;
    int indentation = 0;

    template<class ParseContext>
    constexpr ParseContext::iterator parse(ParseContext &context)
    {
        std::string digits;

        auto itr = context.begin();
        while (itr != context.end() && *itr != '}') {
            if (*itr == 'n' && *(itr + 1) == 'l') {
                use_newlines = true;
            }

            if (*itr >= 48 && *itr <= 57) {
                indentation = indentation * 10 + (*itr - 48);
            }

            itr++;
        }

        return itr;
    }

    template<class FormatContext>
    FormatContext::iterator format(const Union::Properties::OffsetProperty &group, FormatContext &context) const
    {
        std::ostringstream out;

        out << indent(indentation);
        out << "horizontal: ";
        {
            auto value = group.horizontal();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        out << indent(indentation);
        out << "vertical: ";
        {
            auto value = group.vertical();
            if (use_newlines) {
                out << std::format("{}\n", value);
            } else {
                out << std::format("{} ", value);
            }
        }

        return std::ranges::copy(std::move(out).str(), context.out()).out;
    }
};

//