package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteClientKey invokes the kms.DeleteClientKey API synchronously
func (client *Client) DeleteClientKey(request *DeleteClientKeyRequest) (response *DeleteClientKeyResponse, err error) {
	response = CreateDeleteClientKeyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteClientKeyWithChan invokes the kms.DeleteClientKey API asynchronously
func (client *Client) DeleteClientKeyWithChan(request *DeleteClientKeyRequest) (<-chan *DeleteClientKeyResponse, <-chan error) {
	responseChan := make(chan *DeleteClientKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteClientKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteClientKeyWithCallback invokes the kms.DeleteClientKey API asynchronously
func (client *Client) DeleteClientKeyWithCallback(request *DeleteClientKeyRequest, callback func(response *DeleteClientKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteClientKeyResponse
		var err error
		defer close(result)
		response, err = client.DeleteClientKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteClientKeyRequest is the request struct for api DeleteClientKey
type DeleteClientKeyRequest struct {
	*requests.RpcRequest
	ClientKeyId string `position:"Query" name:"ClientKeyId"`
}

// DeleteClientKeyResponse is the response struct for api DeleteClientKey
type DeleteClientKeyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteClientKeyRequest creates a request to invoke DeleteClientKey API
func CreateDeleteClientKeyRequest() (request *DeleteClientKeyRequest) {
	request = &DeleteClientKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "DeleteClientKey", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteClientKeyResponse creates a response to parse from DeleteClientKey response
func CreateDeleteClientKeyResponse() (response *DeleteClientKeyResponse) {
	response = &DeleteClientKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
