/* Indicator.c generated by valac 0.56.18, the Vala compiler
 * generated from Indicator.vala, do not modify */

/*-
 * Copyright (c) 2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "keyboard.h"
#include <wingpanel.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <glib.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	KEYBOARD_INDICATOR_0_PROPERTY,
	KEYBOARD_INDICATOR_SERVER_TYPE_PROPERTY,
	KEYBOARD_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* keyboard_indicator_properties[KEYBOARD_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _KeyboardIndicatorPrivate {
	WingpanelIndicatorManagerServerType _server_type;
	GdkKeymap* keymap;
	GSettings* settings;
	GtkBox* indicator_box;
	GtkBox* main_box;
	GtkRevealer* numlock_revealer;
	GtkRevealer* capslock_revealer;
	KeyboardWidgetsLayoutManager* layouts;
	KeyboardWidgetsKeyboardIcon* layouts_icon;
	GtkRevealer* layouts_revealer;
};

static gint KeyboardIndicator_private_offset;
static gpointer keyboard_indicator_parent_class = NULL;

static GtkWidget* keyboard_indicator_real_get_display_widget (WingpanelIndicator* base);
static void ___lambda15_ (KeyboardIndicator* self);
static void keyboard_indicator_update_visibility (KeyboardIndicator* self);
static void ____lambda15__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void ___lambda16_ (KeyboardIndicator* self);
static void ____lambda16__gdk_keymap_state_changed (GdkKeymap* _sender,
                                             gpointer self);
static gboolean ___lambda17_ (KeyboardIndicator* self,
                       GdkEventButton* e);
static gboolean ____lambda17__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static void ___lambda18_ (KeyboardIndicator* self);
static void ____lambda18__keyboard_widgets_layout_manager_updated (KeyboardWidgetsLayoutManager* _sender,
                                                            gpointer self);
static void keyboard_indicator_update_tooltip (KeyboardIndicator* self);
static GtkWidget* keyboard_indicator_real_get_widget (WingpanelIndicator* base);
static void keyboard_indicator_show_settings (KeyboardIndicator* self);
static void _keyboard_indicator_show_settings_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void keyboard_indicator_show_keyboard_map (KeyboardIndicator* self);
static void _keyboard_indicator_show_keyboard_map_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
static void keyboard_indicator_real_opened (WingpanelIndicator* base);
static void keyboard_indicator_real_closed (WingpanelIndicator* base);
static void keyboard_indicator_finalize (GObject * obj);
static GType keyboard_indicator_get_type_once (void);
static void _vala_keyboard_indicator_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_keyboard_indicator_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
keyboard_indicator_get_instance_private (KeyboardIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardIndicator_private_offset);
}

KeyboardIndicator*
keyboard_indicator_construct (GType object_type,
                              WingpanelIndicatorManagerServerType server_type)
{
	KeyboardIndicator * self = NULL;
	bindtextdomain (CONSTANTS_GETTEXT_PACKAGE, CONSTANTS_LOCALEDIR);
	bind_textdomain_codeset (CONSTANTS_GETTEXT_PACKAGE, "UTF-8");
	self = (KeyboardIndicator*) g_object_new (object_type, "code-name", WINGPANEL_INDICATOR_KEYBOARD, "server-type", server_type, NULL);
	return self;
}

KeyboardIndicator*
keyboard_indicator_new (WingpanelIndicatorManagerServerType server_type)
{
	return keyboard_indicator_construct (KEYBOARD_TYPE_INDICATOR, server_type);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda15_ (KeyboardIndicator* self)
{
	keyboard_indicator_update_visibility (self);
}

static void
____lambda15__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	___lambda15_ ((KeyboardIndicator*) self);
}

static void
___lambda16_ (KeyboardIndicator* self)
{
	keyboard_indicator_update_visibility (self);
}

static void
____lambda16__gdk_keymap_state_changed (GdkKeymap* _sender,
                                        gpointer self)
{
	___lambda16_ ((KeyboardIndicator*) self);
}

static gboolean
___lambda17_ (KeyboardIndicator* self,
              GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button == ((guint) GDK_BUTTON_MIDDLE)) {
		KeyboardWidgetsLayoutManager* _tmp0_;
		_tmp0_ = self->priv->layouts;
		keyboard_widgets_layout_manager_next (_tmp0_);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
____lambda17__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = ___lambda17_ ((KeyboardIndicator*) self, event);
	return result;
}

static void
___lambda18_ (KeyboardIndicator* self)
{
	keyboard_indicator_update_visibility (self);
}

static void
____lambda18__keyboard_widgets_layout_manager_updated (KeyboardWidgetsLayoutManager* _sender,
                                                       gpointer self)
{
	___lambda18_ ((KeyboardIndicator*) self);
}

static GtkWidget*
keyboard_indicator_real_get_display_widget (WingpanelIndicator* base)
{
	KeyboardIndicator * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp36_;
	GtkWidget* _tmp37_;
	GtkWidget* result;
	self = (KeyboardIndicator*) base;
	_tmp0_ = self->priv->indicator_box;
	if (_tmp0_ == NULL) {
		GtkImage* numlock_icon = NULL;
		GtkImage* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		gchar* _tmp4_;
		GtkRevealer* _tmp5_ = NULL;
		GtkRevealer* _tmp6_;
		GtkImage* _tmp7_;
		GtkImage* capslock_icon = NULL;
		GtkImage* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar* _tmp11_;
		GtkRevealer* _tmp12_ = NULL;
		GtkRevealer* _tmp13_;
		GtkImage* _tmp14_;
		KeyboardWidgetsKeyboardIcon* _tmp15_;
		GtkRevealer* _tmp16_ = NULL;
		GtkRevealer* _tmp17_;
		KeyboardWidgetsKeyboardIcon* _tmp18_;
		GtkBox* _tmp19_ = NULL;
		GtkBox* _tmp20_;
		GtkRevealer* _tmp21_;
		GtkBox* _tmp22_;
		GtkRevealer* _tmp23_;
		GtkBox* _tmp24_;
		GtkRevealer* _tmp25_;
		GSettings* _tmp26_;
		GdkDisplay* _tmp27_;
		GdkKeymap* _tmp28_;
		GdkKeymap* _tmp29_;
		GSettings* _tmp30_;
		GdkKeymap* _tmp31_;
		GtkBox* _tmp32_;
		KeyboardWidgetsLayoutManager* _tmp33_;
		KeyboardWidgetsLayoutManager* _tmp34_;
		KeyboardWidgetsLayoutManager* _tmp35_;
		_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("input-keyboard-numlock-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
		g_object_ref_sink (_tmp1_);
		numlock_icon = _tmp1_;
		_tmp2_ = g_new0 (gchar*, 0 + 1);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		_tmp4_ = granite_markup_accel_tooltip (_tmp3_, (gint) 0, _ ("Num Lock is on"));
		_tmp5_ = (GtkRevealer*) gtk_revealer_new ();
		gtk_revealer_set_transition_type (_tmp5_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp5_, _tmp4_);
		_g_free0 (_tmp4_);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->numlock_revealer);
		self->priv->numlock_revealer = _tmp5_;
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		_tmp6_ = self->priv->numlock_revealer;
		_tmp7_ = numlock_icon;
		gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
		_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("input-keyboard-capslock-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
		g_object_ref_sink (_tmp8_);
		capslock_icon = _tmp8_;
		_tmp9_ = g_new0 (gchar*, 0 + 1);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = 0;
		_tmp11_ = granite_markup_accel_tooltip (_tmp10_, (gint) 0, _ ("Caps Lock is on"));
		_tmp12_ = (GtkRevealer*) gtk_revealer_new ();
		gtk_revealer_set_transition_type (_tmp12_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp12_, _tmp11_);
		_g_free0 (_tmp11_);
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (self->priv->capslock_revealer);
		self->priv->capslock_revealer = _tmp12_;
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_tmp13_ = self->priv->capslock_revealer;
		_tmp14_ = capslock_icon;
		gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
		_tmp15_ = keyboard_widgets_keyboard_icon_new ();
		g_object_ref_sink (_tmp15_);
		_g_object_unref0 (self->priv->layouts_icon);
		self->priv->layouts_icon = _tmp15_;
		_tmp16_ = (GtkRevealer*) gtk_revealer_new ();
		gtk_revealer_set_transition_type (_tmp16_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
		g_object_ref_sink (_tmp16_);
		_g_object_unref0 (self->priv->layouts_revealer);
		self->priv->layouts_revealer = _tmp16_;
		_tmp17_ = self->priv->layouts_revealer;
		_tmp18_ = self->priv->layouts_icon;
		gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
		_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		gtk_widget_set_valign ((GtkWidget*) _tmp19_, GTK_ALIGN_CENTER);
		g_object_ref_sink (_tmp19_);
		_g_object_unref0 (self->priv->indicator_box);
		self->priv->indicator_box = _tmp19_;
		_tmp20_ = self->priv->indicator_box;
		_tmp21_ = self->priv->numlock_revealer;
		gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
		_tmp22_ = self->priv->indicator_box;
		_tmp23_ = self->priv->capslock_revealer;
		gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
		_tmp24_ = self->priv->indicator_box;
		_tmp25_ = self->priv->layouts_revealer;
		gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
		_tmp26_ = g_settings_new ("io.elementary.wingpanel.keyboard");
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = _tmp26_;
		_tmp27_ = gdk_display_get_default ();
		_tmp28_ = gdk_keymap_get_for_display (_tmp27_);
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_g_object_unref0 (self->priv->keymap);
		self->priv->keymap = _tmp29_;
		_tmp30_ = self->priv->settings;
		g_signal_connect_object (_tmp30_, "changed", (GCallback) ____lambda15__g_settings_changed, self, 0);
		_tmp31_ = self->priv->keymap;
		g_signal_connect_object (_tmp31_, "state-changed", (GCallback) ____lambda16__gdk_keymap_state_changed, self, 0);
		_tmp32_ = self->priv->indicator_box;
		g_signal_connect_object ((GtkWidget*) _tmp32_, "button-press-event", (GCallback) ____lambda17__gtk_widget_button_press_event, self, 0);
		_tmp33_ = keyboard_widgets_layout_manager_new ();
		g_object_ref_sink (_tmp33_);
		_g_object_unref0 (self->priv->layouts);
		self->priv->layouts = _tmp33_;
		_tmp34_ = self->priv->layouts;
		g_signal_connect_object (_tmp34_, "updated", (GCallback) ____lambda18__keyboard_widgets_layout_manager_updated, self, 0);
		_tmp35_ = self->priv->layouts;
		g_signal_emit_by_name (_tmp35_, "updated");
		_g_object_unref0 (capslock_icon);
		_g_object_unref0 (numlock_icon);
	}
	_tmp36_ = self->priv->indicator_box;
	_tmp37_ = _g_object_ref0 ((GtkWidget*) _tmp36_);
	result = _tmp37_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
keyboard_indicator_update_visibility (KeyboardIndicator* self)
{
	KeyboardWidgetsKeyboardIcon* _tmp0_;
	KeyboardWidgetsLayoutManager* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	KeyboardWidgetsLayoutManager* _tmp7_;
	GtkRevealer* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GdkKeymap* _tmp11_;
	GtkRevealer* _tmp13_;
	gboolean _tmp14_ = FALSE;
	GdkKeymap* _tmp15_;
	GtkRevealer* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GtkRevealer* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp31_ = FALSE;
	GtkRevealer* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	GtkRevealer* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->layouts_icon;
	_tmp1_ = self->priv->layouts;
	_tmp2_ = keyboard_widgets_layout_manager_get_current_language_code (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_slice (_tmp3_, (glong) 0, (glong) 2);
	_tmp5_ = _tmp4_;
	gtk_label_set_label ((GtkLabel*) _tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp7_ = self->priv->layouts;
	if (keyboard_widgets_layout_manager_has_multiple_layouts (_tmp7_)) {
		_tmp6_ = TRUE;
	} else {
		GSettings* _tmp8_;
		_tmp8_ = self->priv->settings;
		_tmp6_ = g_settings_get_boolean (_tmp8_, "always-show-layout");
	}
	_tmp9_ = self->priv->layouts_revealer;
	gtk_revealer_set_reveal_child (_tmp9_, _tmp6_);
	_tmp11_ = self->priv->keymap;
	if (gdk_keymap_get_num_lock_state (_tmp11_)) {
		GSettings* _tmp12_;
		_tmp12_ = self->priv->settings;
		_tmp10_ = g_settings_get_boolean (_tmp12_, "numlock");
	} else {
		_tmp10_ = FALSE;
	}
	_tmp13_ = self->priv->numlock_revealer;
	gtk_revealer_set_reveal_child (_tmp13_, _tmp10_);
	_tmp15_ = self->priv->keymap;
	if (gdk_keymap_get_caps_lock_state (_tmp15_)) {
		GSettings* _tmp16_;
		_tmp16_ = self->priv->settings;
		_tmp14_ = g_settings_get_boolean (_tmp16_, "capslock");
	} else {
		_tmp14_ = FALSE;
	}
	_tmp17_ = self->priv->capslock_revealer;
	gtk_revealer_set_reveal_child (_tmp17_, _tmp14_);
	_tmp19_ = self->priv->numlock_revealer;
	_tmp20_ = gtk_revealer_get_reveal_child (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_) {
		gboolean _tmp22_ = FALSE;
		GtkRevealer* _tmp23_;
		gboolean _tmp24_;
		gboolean _tmp25_;
		_tmp23_ = self->priv->layouts_revealer;
		_tmp24_ = gtk_revealer_get_reveal_child (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_) {
			_tmp22_ = TRUE;
		} else {
			GtkRevealer* _tmp26_;
			gboolean _tmp27_;
			gboolean _tmp28_;
			_tmp26_ = self->priv->capslock_revealer;
			_tmp27_ = gtk_revealer_get_reveal_child (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp22_ = _tmp28_;
		}
		_tmp18_ = _tmp22_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		GtkRevealer* _tmp29_;
		_tmp29_ = self->priv->numlock_revealer;
		gtk_widget_set_margin_end ((GtkWidget*) _tmp29_, 6);
	} else {
		GtkRevealer* _tmp30_;
		_tmp30_ = self->priv->numlock_revealer;
		gtk_widget_set_margin_end ((GtkWidget*) _tmp30_, 0);
	}
	_tmp32_ = self->priv->capslock_revealer;
	_tmp33_ = gtk_revealer_get_reveal_child (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_) {
		GtkRevealer* _tmp35_;
		gboolean _tmp36_;
		gboolean _tmp37_;
		_tmp35_ = self->priv->layouts_revealer;
		_tmp36_ = gtk_revealer_get_reveal_child (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp31_ = _tmp37_;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		GtkRevealer* _tmp38_;
		_tmp38_ = self->priv->capslock_revealer;
		gtk_widget_set_margin_end ((GtkWidget*) _tmp38_, 6);
	} else {
		GtkRevealer* _tmp39_;
		_tmp39_ = self->priv->capslock_revealer;
		gtk_widget_set_margin_end ((GtkWidget*) _tmp39_, 0);
	}
	_tmp42_ = self->priv->layouts_revealer;
	_tmp43_ = gtk_revealer_get_reveal_child (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_) {
		_tmp41_ = TRUE;
	} else {
		GtkRevealer* _tmp45_;
		gboolean _tmp46_;
		gboolean _tmp47_;
		_tmp45_ = self->priv->numlock_revealer;
		_tmp46_ = gtk_revealer_get_reveal_child (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp41_ = _tmp47_;
	}
	if (_tmp41_) {
		_tmp40_ = TRUE;
	} else {
		GtkRevealer* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		_tmp48_ = self->priv->capslock_revealer;
		_tmp49_ = gtk_revealer_get_reveal_child (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp40_ = _tmp50_;
	}
	wingpanel_indicator_set_visible ((WingpanelIndicator*) self, _tmp40_);
	keyboard_indicator_update_tooltip (self);
}

static void
_keyboard_indicator_show_settings_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	keyboard_indicator_show_settings ((KeyboardIndicator*) self);
}

static void
_keyboard_indicator_show_keyboard_map_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	keyboard_indicator_show_keyboard_map ((KeyboardIndicator*) self);
}

static GtkWidget*
keyboard_indicator_real_get_widget (WingpanelIndicator* base)
{
	KeyboardIndicator * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp19_;
	GtkWidget* _tmp20_;
	GtkWidget* result;
	self = (KeyboardIndicator*) base;
	_tmp0_ = self->priv->main_box;
	if (_tmp0_ == NULL) {
		GtkSeparator* separator = NULL;
		GtkSeparator* _tmp1_ = NULL;
		GtkModelButton* map_button = NULL;
		gchar* _tmp2_;
		GtkModelButton* _tmp3_ = NULL;
		GtkBox* _tmp4_;
		GtkBox* _tmp5_;
		KeyboardWidgetsLayoutManager* _tmp6_;
		GtkBox* _tmp7_;
		GtkSeparator* _tmp8_;
		GtkBox* _tmp9_;
		GtkModelButton* _tmp10_;
		WingpanelIndicatorManagerServerType _tmp11_;
		GtkBox* _tmp17_;
		GtkModelButton* _tmp18_;
		_tmp1_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp1_, 3);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, 3);
		g_object_ref_sink (_tmp1_);
		separator = _tmp1_;
		_tmp2_ = g_strdup (_ ("Show Keyboard Layout"));
		_tmp3_ = (GtkModelButton*) gtk_model_button_new ();
		g_object_set (_tmp3_, "text", _tmp2_, NULL);
		_g_free0 (_tmp2_);
		g_object_ref_sink (_tmp3_);
		map_button = _tmp3_;
		_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->main_box);
		self->priv->main_box = _tmp4_;
		_tmp5_ = self->priv->main_box;
		_tmp6_ = self->priv->layouts;
		gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->main_box;
		_tmp8_ = separator;
		gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
		_tmp9_ = self->priv->main_box;
		_tmp10_ = map_button;
		gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
		_tmp11_ = self->priv->_server_type;
		if (_tmp11_ != WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_GREETER) {
			GtkModelButton* settings_button = NULL;
			gchar* _tmp12_;
			GtkModelButton* _tmp13_ = NULL;
			GtkModelButton* _tmp14_;
			GtkBox* _tmp15_;
			GtkModelButton* _tmp16_;
			_tmp12_ = g_strdup (_ ("Keyboard Settings…"));
			_tmp13_ = (GtkModelButton*) gtk_model_button_new ();
			g_object_set (_tmp13_, "text", _tmp12_, NULL);
			_g_free0 (_tmp12_);
			g_object_ref_sink (_tmp13_);
			settings_button = _tmp13_;
			_tmp14_ = settings_button;
			g_signal_connect_object ((GtkButton*) _tmp14_, "clicked", (GCallback) _keyboard_indicator_show_settings_gtk_button_clicked, self, 0);
			_tmp15_ = self->priv->main_box;
			_tmp16_ = settings_button;
			gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
			_g_object_unref0 (settings_button);
		}
		_tmp17_ = self->priv->main_box;
		gtk_widget_show_all ((GtkWidget*) _tmp17_);
		_tmp18_ = map_button;
		g_signal_connect_object ((GtkButton*) _tmp18_, "clicked", (GCallback) _keyboard_indicator_show_keyboard_map_gtk_button_clicked, self, 0);
		_g_object_unref0 (map_button);
		_g_object_unref0 (separator);
	}
	_tmp19_ = self->priv->main_box;
	_tmp20_ = _g_object_ref0 ((GtkWidget*) _tmp19_);
	result = _tmp20_;
	return result;
}

static void
keyboard_indicator_real_opened (WingpanelIndicator* base)
{
	KeyboardIndicator * self;
	self = (KeyboardIndicator*) base;
}

static void
keyboard_indicator_real_closed (WingpanelIndicator* base)
{
	KeyboardIndicator * self;
	self = (KeyboardIndicator*) base;
}

static void
keyboard_indicator_show_settings (KeyboardIndicator* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
	{
		g_app_info_launch_default_for_uri ("settings://input/keyboard/layout", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("Indicator.vala:173: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
keyboard_indicator_show_keyboard_map (KeyboardIndicator* self)
{
	gchar* command = NULL;
	KeyboardWidgetsLayoutManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
	_tmp0_ = self->priv->layouts;
	_tmp1_ = keyboard_widgets_layout_manager_get_current_with_variant (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("gkbd-keyboard-display \"--layout=", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\"", NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	command = _tmp6_;
	{
		GAppInfo* _tmp7_ = NULL;
		const gchar* _tmp8_;
		GAppInfo* _tmp9_;
		_tmp8_ = command;
		_tmp9_ = g_app_info_create_from_commandline (_tmp8_, NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_app_info_launch (_tmp7_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp7_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("Indicator.vala:185: Error launching keyboard layout display: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (command);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (command);
}

static void
keyboard_indicator_update_tooltip (KeyboardIndicator* self)
{
	gchar* description = NULL;
	KeyboardWidgetsLayoutManager* _tmp0_;
	gchar* _tmp1_;
	gchar* accel_label = NULL;
	gchar* _tmp2_;
	GtkRevealer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->layouts;
	_tmp1_ = keyboard_widgets_layout_manager_get_current_description (_tmp0_);
	description = _tmp1_;
	_tmp2_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _ ("Middle-click to switch to the next layout"));
	accel_label = _tmp2_;
	_tmp3_ = self->priv->layouts_revealer;
	_tmp4_ = g_strdup_printf ("%s\n%s", description, accel_label);
	_tmp5_ = _tmp4_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (accel_label);
	_g_free0 (description);
}

WingpanelIndicatorManagerServerType
keyboard_indicator_get_server_type (KeyboardIndicator* self)
{
	WingpanelIndicatorManagerServerType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_server_type;
	return result;
}

static void
keyboard_indicator_set_server_type (KeyboardIndicator* self,
                                    WingpanelIndicatorManagerServerType value)
{
	WingpanelIndicatorManagerServerType old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_indicator_get_server_type (self);
	if (old_value != value) {
		self->priv->_server_type = value;
		g_object_notify_by_pspec ((GObject *) self, keyboard_indicator_properties[KEYBOARD_INDICATOR_SERVER_TYPE_PROPERTY]);
	}
}

static void
keyboard_indicator_class_init (KeyboardIndicatorClass * klass,
                               gpointer klass_data)
{
	keyboard_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardIndicator_private_offset);
	((WingpanelIndicatorClass *) klass)->get_display_widget = (GtkWidget* (*) (WingpanelIndicator*)) keyboard_indicator_real_get_display_widget;
	((WingpanelIndicatorClass *) klass)->get_widget = (GtkWidget* (*) (WingpanelIndicator*)) keyboard_indicator_real_get_widget;
	((WingpanelIndicatorClass *) klass)->opened = (void (*) (WingpanelIndicator*)) keyboard_indicator_real_opened;
	((WingpanelIndicatorClass *) klass)->closed = (void (*) (WingpanelIndicator*)) keyboard_indicator_real_closed;
	G_OBJECT_CLASS (klass)->get_property = _vala_keyboard_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_keyboard_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = keyboard_indicator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_INDICATOR_SERVER_TYPE_PROPERTY, keyboard_indicator_properties[KEYBOARD_INDICATOR_SERVER_TYPE_PROPERTY] = g_param_spec_enum ("server-type", "server-type", "server-type", WINGPANEL_INDICATOR_MANAGER_TYPE_SERVER_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
keyboard_indicator_instance_init (KeyboardIndicator * self,
                                  gpointer klass)
{
	self->priv = keyboard_indicator_get_instance_private (self);
}

static void
keyboard_indicator_finalize (GObject * obj)
{
	KeyboardIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_TYPE_INDICATOR, KeyboardIndicator);
	_g_object_unref0 (self->priv->keymap);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->indicator_box);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->numlock_revealer);
	_g_object_unref0 (self->priv->capslock_revealer);
	_g_object_unref0 (self->priv->layouts);
	_g_object_unref0 (self->priv->layouts_icon);
	_g_object_unref0 (self->priv->layouts_revealer);
	G_OBJECT_CLASS (keyboard_indicator_parent_class)->finalize (obj);
}

static GType
keyboard_indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardIndicator), 0, (GInstanceInitFunc) keyboard_indicator_instance_init, NULL };
	GType keyboard_indicator_type_id;
	keyboard_indicator_type_id = g_type_register_static (WINGPANEL_TYPE_INDICATOR, "KeyboardIndicator", &g_define_type_info, 0);
	KeyboardIndicator_private_offset = g_type_add_instance_private (keyboard_indicator_type_id, sizeof (KeyboardIndicatorPrivate));
	return keyboard_indicator_type_id;
}

GType
keyboard_indicator_get_type (void)
{
	static volatile gsize keyboard_indicator_type_id__once = 0;
	if (g_once_init_enter (&keyboard_indicator_type_id__once)) {
		GType keyboard_indicator_type_id;
		keyboard_indicator_type_id = keyboard_indicator_get_type_once ();
		g_once_init_leave (&keyboard_indicator_type_id__once, keyboard_indicator_type_id);
	}
	return keyboard_indicator_type_id__once;
}

static void
_vala_keyboard_indicator_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	KeyboardIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_TYPE_INDICATOR, KeyboardIndicator);
	switch (property_id) {
		case KEYBOARD_INDICATOR_SERVER_TYPE_PROPERTY:
		g_value_set_enum (value, keyboard_indicator_get_server_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_keyboard_indicator_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	KeyboardIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_TYPE_INDICATOR, KeyboardIndicator);
	switch (property_id) {
		case KEYBOARD_INDICATOR_SERVER_TYPE_PROPERTY:
		keyboard_indicator_set_server_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

WingpanelIndicator*
get_indicator (GModule* module,
               WingpanelIndicatorManagerServerType server_type)
{
	KeyboardIndicator* indicator = NULL;
	KeyboardIndicator* _tmp0_;
	WingpanelIndicator* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Indicator.vala:198: Activating Keyboard Indicator");
	_tmp0_ = keyboard_indicator_new (server_type);
	indicator = _tmp0_;
	result = (WingpanelIndicator*) indicator;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

