// ADNoteUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef ADnoteUI_h
#define ADnoteUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2014-2024, Will Godfrey, Kristian Amlie

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code.


#include <FL/Fl_Box.H>
    #include <FL/Fl_Group.H>
    #include "Params/ADnoteParameters.h"
    #include "Misc/SynthEngine.h"
    #include "DSP/FFTwrapper.h"
    #include "UI/MiscGui.h"
    #include "UI/WidgetPDial.h"
    #include "UI/WidgetMWSlider.h"
    #include "UI/WidgetCheckButton.h"
    #include "UI/WidgetSpinner.h"
    #include "UI/ScaleTrackedWindow.h"
    #include "FilterUI.h"
    #include "PresetsUI.h"
#include <string>
    #include "ResonanceUI.h"
    #include "EnvelopeUI.h"
    #include "LFOUI.h"
    #include "OscilGenUI.h"
#include <FL/Fl_Box.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Counter.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Value_Output.H>
#include <FL/Fl_Button.H>

class ADvoiceUI : public Fl_Group {
public:
  Fl_Group* make_window();
  Fl_Group *ADnoteVoiceParameters;
  Fl_Check_Button2 *voiceonbutton;
private:
  inline void cb_voiceonbutton_i(Fl_Check_Button2*, void*);
  static void cb_voiceonbutton(Fl_Check_Button2*, void*);
public:
  Fl_Group *voiceparametersgroup;
  Fl_Group *voicemodegroup;
  Fl_Group *voiceFMparametersgroup;
  Fl_Group *modfrequency;
  EnvelopeUI *voiceFMfreqenvgroup;
  Fl_Check_Button2 *ModFreqEn;
private:
  inline void cb_ModFreqEn_i(Fl_Check_Button2*, void*);
  static void cb_ModFreqEn(Fl_Check_Button2*, void*);
public:
  Fl_Counter *ModCoarseDetune;
private:
  inline void cb_ModCoarseDetune_i(Fl_Counter*, void*);
  static void cb_ModCoarseDetune(Fl_Counter*, void*);
public:
  Fl_Text_Display *modoctavetext;
  Fl_Counter *ModOctave;
private:
  inline void cb_ModOctave_i(Fl_Counter*, void*);
  static void cb_ModOctave(Fl_Counter*, void*);
public:
  mwheel_slider_rev *ModDetune;
private:
  inline void cb_ModDetune_i(mwheel_slider_rev*, void*);
  static void cb_ModDetune(mwheel_slider_rev*, void*);
public:
  Fl_Choice *ModDetuneType;
private:
  inline void cb_ModDetuneType_i(Fl_Choice*, void*);
  static void cb_ModDetuneType(Fl_Choice*, void*);
public:
  Fl_Value_Output *fmdetunevalueoutput;
private:
  inline void cb_fmdetunevalueoutput_i(Fl_Value_Output*, void*);
  static void cb_fmdetunevalueoutput(Fl_Value_Output*, void*);
public:
  Fl_Check_Button2 *Mod440;
private:
  inline void cb_Mod440_i(Fl_Check_Button2*, void*);
  static void cb_Mod440(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *detuneFromBaseOsc;
private:
  inline void cb_detuneFromBaseOsc_i(Fl_Check_Button2*, void*);
  static void cb_detuneFromBaseOsc(Fl_Check_Button2*, void*);
public:
  Fl_Group *Modampgrp;
  mwheel_val_slider_rev *ModVolume;
private:
  inline void cb_ModVolume_i(mwheel_val_slider_rev*, void*);
  static void cb_ModVolume(mwheel_val_slider_rev*, void*);
public:
  mwheel_val_slider_rev *ModVsense;
private:
  inline void cb_ModVsense_i(mwheel_val_slider_rev*, void*);
  static void cb_ModVsense(mwheel_val_slider_rev*, void*);
public:
  EnvelopeUI *voiceFMampenvgroup;
  Fl_Check_Button2 *ModAmpEn;
private:
  inline void cb_ModAmpEn_i(Fl_Check_Button2*, void*);
  static void cb_ModAmpEn(Fl_Check_Button2*, void*);
public:
  mwheel_val_slider_rev *ModFdamp;
private:
  inline void cb_ModFdamp_i(mwheel_val_slider_rev*, void*);
  static void cb_ModFdamp(mwheel_val_slider_rev*, void*);
public:
  Fl_Group *modOscDisplay;
  Fl_Group *modoscil;
  Fl_Text_Display *ModLocalOsc;
  Fl_Choice *ExtModOsc;
private:
  inline void cb_ExtModOsc_i(Fl_Choice*, void*);
  static void cb_ExtModOsc(Fl_Choice*, void*);
public:
  Fl_Button *changeFMoscilbutton;
private:
  inline void cb_changeFMoscilbutton_i(Fl_Button*, void*);
  static void cb_changeFMoscilbutton(Fl_Button*, void*);
public:
  mwheel_slider_rev *ModPhase;
private:
  inline void cb_ModPhase_i(mwheel_slider_rev*, void*);
  static void cb_ModPhase(mwheel_slider_rev*, void*);
public:
  Fl_Group *fmoscil;
  Fl_Box *modvoicelabel;
private:
  inline void cb_modvoicelabel_i(Fl_Box*, void*);
  static void cb_modvoicelabel(Fl_Box*, void*);
public:
  Fl_Choice *ExtMod;
private:
  inline void cb_ExtMod_i(Fl_Choice*, void*);
  static void cb_ExtMod(Fl_Choice*, void*);
public:
  Fl_Text_Display *modtypetext;
  Fl_Choice *ModType;
private:
  inline void cb_ModType_i(Fl_Choice*, void*);
  static void cb_ModType(Fl_Choice*, void*);
public:
  Fl_Group *freqencygrp;
  EnvelopeUI *voicefreqenvgroup;
  Fl_Check_Button2 *FreqEn;
private:
  inline void cb_FreqEn_i(Fl_Check_Button2*, void*);
  static void cb_FreqEn(Fl_Check_Button2*, void*);
public:
  LFOUI *voicefreqlfogroup;
  Fl_Check_Button2 *FreqLfoEn;
private:
  inline void cb_FreqLfoEn_i(Fl_Check_Button2*, void*);
  static void cb_FreqLfoEn(Fl_Check_Button2*, void*);
public:
  Fl_Text_Display *voiceoctavetext;
  Fl_Counter *Octave;
private:
  inline void cb_Octave_i(Fl_Counter*, void*);
  static void cb_Octave(Fl_Counter*, void*);
public:
  Fl_Counter *CoarseDetune;
private:
  inline void cb_CoarseDetune_i(Fl_Counter*, void*);
  static void cb_CoarseDetune(Fl_Counter*, void*);
public:
  Fl_Choice *FreqDetunetype;
private:
  inline void cb_FreqDetunetype_i(Fl_Choice*, void*);
  static void cb_FreqDetunetype(Fl_Choice*, void*);
public:
  mwheel_slider_rev *Detune;
private:
  inline void cb_Detune_i(mwheel_slider_rev*, void*);
  static void cb_Detune(mwheel_slider_rev*, void*);
public:
  Fl_Value_Output *detunevalueoutput;
private:
  inline void cb_detunevalueoutput_i(Fl_Value_Output*, void*);
  static void cb_detunevalueoutput(Fl_Value_Output*, void*);
public:
  WidgetPDial *bend;
private:
  inline void cb_bend_i(WidgetPDial*, void*);
  static void cb_bend(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *Freq440;
private:
  inline void cb_Freq440_i(Fl_Check_Button2*, void*);
  static void cb_Freq440(Fl_Check_Button2*, void*);
public:
  WidgetPDial *fixedfreqetdial;
private:
  inline void cb_fixedfreqetdial_i(WidgetPDial*, void*);
  static void cb_fixedfreqetdial(WidgetPDial*, void*);
public:
  WidgetPDial *offset;
private:
  inline void cb_offset_i(WidgetPDial*, void*);
  static void cb_offset(WidgetPDial*, void*);
public:
  Fl_Group *oscDisplay;
  Fl_Group *oscGroup;
  Fl_Group *oscParamBox;
  Fl_Choice *UseOsc;
private:
  inline void cb_UseOsc_i(Fl_Choice*, void*);
  static void cb_UseOsc(Fl_Choice*, void*);
public:
  Fl_Button *changevoiceoscilbutton;
private:
  inline void cb_changevoiceoscilbutton_i(Fl_Button*, void*);
  static void cb_changevoiceoscilbutton(Fl_Button*, void*);
public:
  mwheel_slider_rev *VoiceOscPhase;
private:
  inline void cb_VoiceOscPhase_i(mwheel_slider_rev*, void*);
  static void cb_VoiceOscPhase(mwheel_slider_rev*, void*);
public:
  Fl_Group *voiceoscil;
  Fl_Box *osclabel;
private:
  inline void cb_osclabel_i(Fl_Box*, void*);
  static void cb_osclabel(Fl_Box*, void*);
public:
  Fl_Check_Button2 *ResonanceEn;
private:
  inline void cb_ResonanceEn_i(Fl_Check_Button2*, void*);
  static void cb_ResonanceEn(Fl_Check_Button2*, void*);
public:
  Fl_Group *unisongroup;
  WidgetSpinner *unisonsize;
private:
  inline void cb_unisonsize_i(WidgetSpinner*, void*);
  static void cb_unisonsize(WidgetSpinner*, void*);
public:
  WidgetPDial *UnisonStereo;
private:
  inline void cb_UnisonStereo_i(WidgetPDial*, void*);
  static void cb_UnisonStereo(WidgetPDial*, void*);
public:
  WidgetPDial *UnisonVib;
private:
  inline void cb_UnisonVib_i(WidgetPDial*, void*);
  static void cb_UnisonVib(WidgetPDial*, void*);
public:
  Fl_Choice *UnisonInvert;
private:
  inline void cb_UnisonInvert_i(Fl_Choice*, void*);
  static void cb_UnisonInvert(Fl_Choice*, void*);
public:
  mwheel_slider_rev *UnisonFreqSpread;
private:
  inline void cb_UnisonFreqSpread_i(mwheel_slider_rev*, void*);
  static void cb_UnisonFreqSpread(mwheel_slider_rev*, void*);
public:
  Fl_Value_Output *unisonspreadoutput;
private:
  inline void cb_unisonspreadoutput_i(Fl_Value_Output*, void*);
  static void cb_unisonspreadoutput(Fl_Value_Output*, void*);
public:
  WidgetPDial *UnisonVspeed;
private:
  inline void cb_UnisonVspeed_i(WidgetPDial*, void*);
  static void cb_UnisonVspeed(WidgetPDial*, void*);
public:
  WidgetPDial *UnisonPhRnd;
private:
  inline void cb_UnisonPhRnd_i(WidgetPDial*, void*);
  static void cb_UnisonPhRnd(WidgetPDial*, void*);
public:
  Fl_Box *unisName;
  Fl_Check_Button2 *UnisonEn;
private:
  inline void cb_UnisonEn_i(Fl_Check_Button2*, void*);
  static void cb_UnisonEn(Fl_Check_Button2*, void*);
public:
  Fl_Group *amplitudegroup;
  WidgetPDial *voicevolume;
private:
  inline void cb_voicevolume_i(WidgetPDial*, void*);
  static void cb_voicevolume(WidgetPDial*, void*);
public:
  WidgetPDial *voicevsns;
private:
  inline void cb_voicevsns_i(WidgetPDial*, void*);
  static void cb_voicevsns(WidgetPDial*, void*);
public:
  WidgetPDial *voicepan;
private:
  inline void cb_voicepan_i(WidgetPDial*, void*);
  static void cb_voicepan(WidgetPDial*, void*);
public:
  WidgetPDial *voicewidth;
private:
  inline void cb_voicewidth_i(WidgetPDial*, void*);
  static void cb_voicewidth(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *voicerandompan;
private:
  inline void cb_voicerandompan_i(Fl_Check_Button2*, void*);
  static void cb_voicerandompan(Fl_Check_Button2*, void*);
public:
  EnvelopeUI *voiceampenvgroup;
  Fl_Check_Button2 *AmpEnvEn;
private:
  inline void cb_AmpEnvEn_i(Fl_Check_Button2*, void*);
  static void cb_AmpEnvEn(Fl_Check_Button2*, void*);
public:
  LFOUI *voiceamplfogroup;
  Fl_Check_Button2 *AmpLfoEn;
private:
  inline void cb_AmpLfoEn_i(Fl_Check_Button2*, void*);
  static void cb_AmpLfoEn(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *VolumeMinus;
private:
  inline void cb_VolumeMinus_i(Fl_Check_Button2*, void*);
  static void cb_VolumeMinus(Fl_Check_Button2*, void*);
public:
  Fl_Box *ampVoiceLabel;
  Fl_Group *voicefiltergroup;
  FilterUI *voicefilter;
  EnvelopeUI *voicefilterenvgroup;
  Fl_Check_Button2 *FilterEnvEn;
private:
  inline void cb_FilterEnvEn_i(Fl_Check_Button2*, void*);
  static void cb_FilterEnvEn(Fl_Check_Button2*, void*);
public:
  LFOUI *voicefilterlfogroup;
  Fl_Check_Button2 *FilterLfoEn;
private:
  inline void cb_FilterLfoEn_i(Fl_Check_Button2*, void*);
  static void cb_FilterLfoEn(Fl_Check_Button2*, void*);
public:
  mwheel_slider_rev *Delay;
private:
  inline void cb_Delay_i(mwheel_slider_rev*, void*);
  static void cb_Delay(mwheel_slider_rev*, void*);
public:
  Fl_Check_Button2 *bypassfiltercheckbutton;
private:
  inline void cb_bypassfiltercheckbutton_i(Fl_Check_Button2*, void*);
  static void cb_bypassfiltercheckbutton(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *FilterEn;
private:
  inline void cb_FilterEn_i(Fl_Check_Button2*, void*);
  static void cb_FilterEn(Fl_Check_Button2*, void*);
public:
  Fl_Group *extvoicegroup;
  Fl_Choice *ExtOsc;
private:
  inline void cb_ExtOsc_i(Fl_Choice*, void*);
  static void cb_ExtOsc(Fl_Choice*, void*);
public:
  Fl_Choice *SoundType;
private:
  inline void cb_SoundType_i(Fl_Choice*, void*);
  static void cb_SoundType(Fl_Choice*, void*);
public:
  Fl_Box *noiselabel;
private:
  inline void cb_noiselabel_i(Fl_Box*, void*);
  static void cb_noiselabel(Fl_Box*, void*);
public:
  Fl_Group *Vname;
  ADvoiceUI(int x,int y, int w, int h, const char *label=0);
  void send_data(int action, int control, float value, int type);
  void returns_update(CommandBlock *getData);
  void paste();
  void update_osclabels();
  void update_modvoicelabel();
  void update_voiceoscil();
  void update_fmoscil();
  void voiceRtext(float dScale);
  void voicetheme();
  void init(ADnoteParameters *parameters,int npart_, int kititem_, int nvoice_);
  ~ADvoiceUI();
  int nvoice;
private:
  int npart;
  int kititem;
  ADnoteParameters *pars;
public:
  OscilEditor *oscedit;
private:
  fft::Calc *fft;
public:
  OscilGen *oscil;
  OscilGen *oscilFM;
private:
  Oscilloscope *osc;
  Oscilloscope *oscFM;
  SynthEngine *synth;
  float lastdScale;
  int lastWaveW;
};

class ADvoicelistitem : public Fl_Group {
public:
  Fl_Group* make_window();
  Fl_Group *ADnoteVoiceListItem;
  Fl_Group *enabledpatch;
  Fl_Check_Button2 *voiceenabled;
private:
  inline void cb_voiceenabled_i(Fl_Check_Button2*, void*);
  static void cb_voiceenabled(Fl_Check_Button2*, void*);
public:
  Fl_Group *voicelistitemgroup;
  mwheel_slider_rev *voicevolume;
private:
  inline void cb_voicevolume1_i(mwheel_slider_rev*, void*);
  static void cb_voicevolume1(mwheel_slider_rev*, void*);
public:
  Fl_Check_Button2 *voiceresonanceenabled;
private:
  inline void cb_voiceresonanceenabled_i(Fl_Check_Button2*, void*);
  static void cb_voiceresonanceenabled(Fl_Check_Button2*, void*);
public:
  mwheel_slider_rev *voicelistvibratto;
private:
  inline void cb_voicelistvibratto_i(mwheel_slider_rev*, void*);
  static void cb_voicelistvibratto(mwheel_slider_rev*, void*);
public:
  WidgetPDial *voicepanning;
private:
  inline void cb_voicepanning_i(WidgetPDial*, void*);
  static void cb_voicepanning(WidgetPDial*, void*);
public:
  Fl_Group *voiceoscil;
private:
  inline void cb_voiceoscil_i(Fl_Group*, void*);
  static void cb_voiceoscil(Fl_Group*, void*);
public:
  Fl_Box *noiselabel;
private:
  inline void cb_noiselabel1_i(Fl_Box*, void*);
  static void cb_noiselabel1(Fl_Box*, void*);
public:
  Fl_Group *modoscil;
private:
  inline void cb_modoscil_i(Fl_Group*, void*);
  static void cb_modoscil(Fl_Group*, void*);
public:
  Fl_Box *modlabel;
private:
  inline void cb_modlabel_i(Fl_Box*, void*);
  static void cb_modlabel(Fl_Box*, void*);
public:
  mwheel_slider_rev *voicedetune;
private:
  inline void cb_voicedetune_i(mwheel_slider_rev*, void*);
  static void cb_voicedetune(mwheel_slider_rev*, void*);
public:
  Fl_Value_Output *detunevalueoutput;
private:
  inline void cb_detunevalueoutput1_i(Fl_Value_Output*, void*);
  static void cb_detunevalueoutput1(Fl_Value_Output*, void*);
public:
  Fl_Button *itemedit;
private:
  inline void cb_itemedit_i(Fl_Button*, void*);
  static void cb_itemedit(Fl_Button*, void*);
public:
  ADvoicelistitem(int x,int y, int w, int h, const char *label=0);
  void init(ADnoteParameters *parameters, int npart_, int kititem_, int nvoice_);
  void refreshlist(int nvoice);
  void update_voiceoscil();
  void update_noiselabel();
  void update_modoscil();
  void update_modlabel();
  void itemRtext(float dScale);
  ~ADvoicelistitem();
private:
  ADnoteParameters *pars;
public:
  int nvoice;
private:
  fft::Calc *fft;
  OscilGen *oscil;
  OscilGen *oscilFM;
  Oscilloscope *osc;
  Oscilloscope *modosc;
  SynthEngine *synth;
  int npart;
  int kititem;
};

class ADnoteUI : public PresetsUI_ {
  ScaleTrackedWindow* make_window();
// globalrandompan MUST be after globalwidth
public:
  ScaleTrackedWindow *ADnoteGlobalParameters;
private:
  inline void cb_ADnoteGlobalParameters_i(ScaleTrackedWindow*, void*);
  static void cb_ADnoteGlobalParameters(ScaleTrackedWindow*, void*);
public:
  Fl_Group *globalfreq;
  EnvelopeUI *freqenv;
  Fl_Text_Display *octavetext;
  Fl_Counter *octave;
private:
  inline void cb_octave_i(Fl_Counter*, void*);
  static void cb_octave(Fl_Counter*, void*);
public:
  Fl_Counter *coarsedet;
private:
  inline void cb_coarsedet_i(Fl_Counter*, void*);
  static void cb_coarsedet(Fl_Counter*, void*);
public:
  LFOUI *freqlfo;
  mwheel_slider_rev *freq;
private:
  inline void cb_freq_i(mwheel_slider_rev*, void*);
  static void cb_freq(mwheel_slider_rev*, void*);
public:
  Fl_Choice *detunetype;
private:
  inline void cb_detunetype_i(Fl_Choice*, void*);
  static void cb_detunetype(Fl_Choice*, void*);
public:
  Fl_Value_Output *detunevalueoutput;
private:
  inline void cb_detunevalueoutput2_i(Fl_Value_Output*, void*);
  static void cb_detunevalueoutput2(Fl_Value_Output*, void*);
public:
  WidgetPDial *relBwidth;
private:
  inline void cb_relBwidth_i(WidgetPDial*, void*);
  static void cb_relBwidth(WidgetPDial*, void*);
public:
  Fl_Group *amplitudegrp;
  WidgetPDial *globalvolume;
private:
  inline void cb_globalvolume_i(WidgetPDial*, void*);
  static void cb_globalvolume(WidgetPDial*, void*);
public:
  WidgetPDial *vsns;
private:
  inline void cb_vsns_i(WidgetPDial*, void*);
  static void cb_vsns(WidgetPDial*, void*);
public:
  WidgetPDial *globalpan;
private:
  inline void cb_globalpan_i(WidgetPDial*, void*);
  static void cb_globalpan(WidgetPDial*, void*);
public:
  WidgetPDial *globalwidth;
private:
  inline void cb_globalwidth_i(WidgetPDial*, void*);
  static void cb_globalwidth(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *globalrandompan;
private:
  inline void cb_globalrandompan_i(Fl_Check_Button2*, void*);
  static void cb_globalrandompan(Fl_Check_Button2*, void*);
public:
  WidgetPDial *depop;
private:
  inline void cb_depop_i(WidgetPDial*, void*);
  static void cb_depop(WidgetPDial*, void*);
public:
  WidgetPDial *pstr;
private:
  inline void cb_pstr_i(WidgetPDial*, void*);
  static void cb_pstr(WidgetPDial*, void*);
public:
  WidgetPDial *pt;
private:
  inline void cb_pt_i(WidgetPDial*, void*);
  static void cb_pt(WidgetPDial*, void*);
public:
  WidgetPDial *pstc;
private:
  inline void cb_pstc_i(WidgetPDial*, void*);
  static void cb_pstc(WidgetPDial*, void*);
public:
  WidgetPDial *pvel;
private:
  inline void cb_pvel_i(WidgetPDial*, void*);
  static void cb_pvel(WidgetPDial*, void*);
public:
  EnvelopeUI *ampenv;
  LFOUI *amplfo;
  Fl_Check_Button2 *rndgrp;
private:
  inline void cb_rndgrp_i(Fl_Check_Button2*, void*);
  static void cb_rndgrp(Fl_Check_Button2*, void*);
public:
  Fl_Box *amplitudelabel;
  Fl_Group *filtergrp;
  EnvelopeUI *filterenv;
  LFOUI *filterlfo;
  FilterUI *filterui;
  Fl_Check_Button2 *stereo;
private:
  inline void cb_stereo_i(Fl_Check_Button2*, void*);
  static void cb_stereo(Fl_Check_Button2*, void*);
public:
  Fl_Button *showvoicelist;
private:
  inline void cb_showvoicelist_i(Fl_Button*, void*);
  static void cb_showvoicelist(Fl_Button*, void*);
public:
  Fl_Button *showvoicepars;
private:
  inline void cb_showvoicepars_i(Fl_Button*, void*);
  static void cb_showvoicepars(Fl_Button*, void*);
public:
  Fl_Button *globalclose;
private:
  inline void cb_globalclose_i(Fl_Button*, void*);
  static void cb_globalclose(Fl_Button*, void*);
public:
  Fl_Button *resonance;
private:
  inline void cb_resonance_i(Fl_Button*, void*);
  static void cb_resonance(Fl_Button*, void*);
public:
  Fl_Button *globalcopy;
private:
  inline void cb_globalcopy_i(Fl_Button*, void*);
  static void cb_globalcopy(Fl_Button*, void*);
public:
  Fl_Button *globalpaste;
private:
  inline void cb_globalpaste_i(Fl_Button*, void*);
  static void cb_globalpaste(Fl_Button*, void*);
public:
  ScaleTrackedWindow *ADnoteVoice;
private:
  inline void cb_ADnoteVoice_i(ScaleTrackedWindow*, void*);
  static void cb_ADnoteVoice(ScaleTrackedWindow*, void*);
public:
  ADvoiceUI *advoice;
  Fl_Button *Vclose;
private:
  inline void cb_Vclose_i(Fl_Button*, void*);
  static void cb_Vclose(Fl_Button*, void*);
public:
  Fl_Button *Vcopy;
private:
  inline void cb_Vcopy_i(Fl_Button*, void*);
  static void cb_Vcopy(Fl_Button*, void*);
public:
  Fl_Button *Vpaste;
private:
  inline void cb_Vpaste_i(Fl_Button*, void*);
  static void cb_Vpaste(Fl_Button*, void*);
public:
  Fl_Button *g1;
private:
  inline void cb_g1_i(Fl_Button*, void*);
  static void cb_g1(Fl_Button*, void*);
public:
  Fl_Button *g2;
private:
  inline void cb_g2_i(Fl_Button*, void*);
  static void cb_g2(Fl_Button*, void*);
public:
  Fl_Button *g3;
private:
  inline void cb_g3_i(Fl_Button*, void*);
  static void cb_g3(Fl_Button*, void*);
public:
  Fl_Button *g4;
private:
  inline void cb_g4_i(Fl_Button*, void*);
  static void cb_g4(Fl_Button*, void*);
public:
  Fl_Button *g5;
private:
  inline void cb_g5_i(Fl_Button*, void*);
  static void cb_g5(Fl_Button*, void*);
public:
  Fl_Button *g6;
private:
  inline void cb_g6_i(Fl_Button*, void*);
  static void cb_g6(Fl_Button*, void*);
public:
  Fl_Button *g7;
private:
  inline void cb_g7_i(Fl_Button*, void*);
  static void cb_g7(Fl_Button*, void*);
public:
  Fl_Button *g8;
private:
  inline void cb_g8_i(Fl_Button*, void*);
  static void cb_g8(Fl_Button*, void*);
public:
  Fl_Group *voiceTabBar;
  ScaleTrackedWindow *ADnoteVoiceList;
private:
  inline void cb_ADnoteVoiceList_i(ScaleTrackedWindow*, void*);
  static void cb_ADnoteVoiceList(ScaleTrackedWindow*, void*);
public:
  Fl_Text_Display *listNo;
  Fl_Text_Display *listVolume;
  Fl_Text_Display *listDetune;
  Fl_Text_Display *listPan;
  Fl_Text_Display *listVibrato;
  Fl_Text_Display *listResonance;
  Fl_Button *listClose;
private:
  inline void cb_listClose_i(Fl_Button*, void*);
  static void cb_listClose(Fl_Button*, void*);
public:
  Fl_Text_Display *listWave;
  Fl_Text_Display *listModulator;
  void setVoiceTabs(int num, bool edit = true);
  void setTabColour(int nvoice);
  void send_data(int action, int control, float value, int type);
  void returns_update(CommandBlock *getData);
  void paste(CommandBlock *getData);
  ADnoteUI(ADnoteParameters *parameters, int npart_, int kititem_);
  virtual ~ADnoteUI();
  void refresh();
  void ShowGlobal();
  void set_voice(bool type);
  void wincheck();
  void theme();
  void addRtext();
  void addVoiceRtext();
  void addVoiceListRtext();
  void editVoice(int nvoice_);
private:
  ADnoteParameters *pars;
  int addDW;
  int addDH;
  int lastglobalW;
  bool globalSeen;
  int voiceDW;
  int voiceDH;
  int lastvoiceW;
public:
  bool voiceSeen;
private:
  int listDW;
  int listDH;
  int lastlistW;
public:
  bool listSeen;
  ResonanceUI *resui;
private:
  int lastResuiW;
public:
  int nvoice;
  ADvoicelistitem *voicelistitem[NUM_VOICES];
private:
  SynthEngine *synth;
  int npart;
  int kititem;
public:
  bool fromVoiceList;
};
#endif
