//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef GLACIER2_API_EXPORTS
#   define GLACIER2_API_EXPORTS
#endif
#include <Glacier2/Session.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <Ice/SlicedData.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit<::Glacier2::CannotCreateSessionException> iceC_Glacier2_CannotCreateSessionException_init("::Glacier2::CannotCreateSessionException");

const ::std::string iceC_Glacier2_Session_ids[2] =
{
    "::Glacier2::Session",
    "::Ice::Object"
};
const ::std::string iceC_Glacier2_Session_ops[] =
{
    "destroy",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_Glacier2_Session_destroy_name = "destroy";

const ::std::string iceC_Glacier2_StringSet_ids[2] =
{
    "::Glacier2::StringSet",
    "::Ice::Object"
};
const ::std::string iceC_Glacier2_StringSet_ops[] =
{
    "add",
    "get",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "remove"
};
const ::std::string iceC_Glacier2_StringSet_add_name = "add";
const ::std::string iceC_Glacier2_StringSet_remove_name = "remove";
const ::std::string iceC_Glacier2_StringSet_get_name = "get";

const ::std::string iceC_Glacier2_IdentitySet_ids[2] =
{
    "::Glacier2::IdentitySet",
    "::Ice::Object"
};
const ::std::string iceC_Glacier2_IdentitySet_ops[] =
{
    "add",
    "get",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "remove"
};
const ::std::string iceC_Glacier2_IdentitySet_add_name = "add";
const ::std::string iceC_Glacier2_IdentitySet_remove_name = "remove";
const ::std::string iceC_Glacier2_IdentitySet_get_name = "get";

const ::std::string iceC_Glacier2_SessionControl_ids[2] =
{
    "::Glacier2::SessionControl",
    "::Ice::Object"
};
const ::std::string iceC_Glacier2_SessionControl_ops[] =
{
    "adapterIds",
    "categories",
    "destroy",
    "getSessionTimeout",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "identities"
};
const ::std::string iceC_Glacier2_SessionControl_categories_name = "categories";
const ::std::string iceC_Glacier2_SessionControl_adapterIds_name = "adapterIds";
const ::std::string iceC_Glacier2_SessionControl_identities_name = "identities";
const ::std::string iceC_Glacier2_SessionControl_getSessionTimeout_name = "getSessionTimeout";
const ::std::string iceC_Glacier2_SessionControl_destroy_name = "destroy";

const ::std::string iceC_Glacier2_SessionManager_ids[2] =
{
    "::Glacier2::SessionManager",
    "::Ice::Object"
};
const ::std::string iceC_Glacier2_SessionManager_ops[] =
{
    "create",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_Glacier2_SessionManager_create_name = "create";

const ::std::string iceC_Glacier2_SSLSessionManager_ids[2] =
{
    "::Glacier2::SSLSessionManager",
    "::Ice::Object"
};
const ::std::string iceC_Glacier2_SSLSessionManager_ops[] =
{
    "create",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_Glacier2_SSLSessionManager_create_name = "create";

}

Glacier2::CannotCreateSessionException::~CannotCreateSessionException()
{
}

const ::std::string&
Glacier2::CannotCreateSessionException::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::CannotCreateSessionException";
    return typeId;
}

::std::shared_ptr<::Ice::SlicedData>
Glacier2::CannotCreateSessionException::ice_getSlicedData() const
{
    return _slicedData;
}

/// \cond STREAM
void
Glacier2::CannotCreateSessionException::_write(::Ice::OutputStream* ostr) const
{
    ostr->startException(_slicedData);
    _writeImpl(ostr);
    ostr->endException();
}

void
Glacier2::CannotCreateSessionException::_read(::Ice::InputStream* istr)
{
    istr->startException();
    _readImpl(istr);
    _slicedData = istr->endException(true);
}
/// \endcond

bool
Glacier2::Session::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_Session_ids, iceC_Glacier2_Session_ids + 2, s);
}

::std::vector<::std::string>
Glacier2::Session::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_Glacier2_Session_ids[0], &iceC_Glacier2_Session_ids[2]);
}

::std::string
Glacier2::Session::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::Session::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::Session";
    return typeId;
}

/// \cond INTERNAL
bool
Glacier2::Session::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::Session::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_Session_ops, iceC_Glacier2_Session_ops + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_Session_ops)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
Glacier2::StringSet::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_StringSet_ids, iceC_Glacier2_StringSet_ids + 2, s);
}

::std::vector<::std::string>
Glacier2::StringSet::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_Glacier2_StringSet_ids[0], &iceC_Glacier2_StringSet_ids[2]);
}

::std::string
Glacier2::StringSet::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::StringSet::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::StringSet";
    return typeId;
}

/// \cond INTERNAL
bool
Glacier2::StringSet::_iceD_add(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::Ice::StringSeq iceP_additions;
    istr->readAll(iceP_additions);
    inS.endReadParams();
    this->add(::std::move(iceP_additions), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::StringSet::_iceD_remove(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::Ice::StringSeq iceP_deletions;
    istr->readAll(iceP_deletions);
    inS.endReadParams();
    this->remove(::std::move(iceP_deletions), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::StringSet::_iceD_get(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->get(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::StringSet::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_StringSet_ops, iceC_Glacier2_StringSet_ops + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_StringSet_ops)
    {
        case 0:
        {
            return _iceD_add(in, current);
        }
        case 1:
        {
            return _iceD_get(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        case 6:
        {
            return _iceD_remove(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
Glacier2::IdentitySet::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_IdentitySet_ids, iceC_Glacier2_IdentitySet_ids + 2, s);
}

::std::vector<::std::string>
Glacier2::IdentitySet::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_Glacier2_IdentitySet_ids[0], &iceC_Glacier2_IdentitySet_ids[2]);
}

::std::string
Glacier2::IdentitySet::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::IdentitySet::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::IdentitySet";
    return typeId;
}

/// \cond INTERNAL
bool
Glacier2::IdentitySet::_iceD_add(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::Ice::IdentitySeq iceP_additions;
    istr->readAll(iceP_additions);
    inS.endReadParams();
    this->add(::std::move(iceP_additions), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::IdentitySet::_iceD_remove(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::Ice::IdentitySeq iceP_deletions;
    istr->readAll(iceP_deletions);
    inS.endReadParams();
    this->remove(::std::move(iceP_deletions), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::IdentitySet::_iceD_get(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::IdentitySeq ret = this->get(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::IdentitySet::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_IdentitySet_ops, iceC_Glacier2_IdentitySet_ops + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_IdentitySet_ops)
    {
        case 0:
        {
            return _iceD_add(in, current);
        }
        case 1:
        {
            return _iceD_get(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        case 6:
        {
            return _iceD_remove(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
Glacier2::SessionControl::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_SessionControl_ids, iceC_Glacier2_SessionControl_ids + 2, s);
}

::std::vector<::std::string>
Glacier2::SessionControl::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_Glacier2_SessionControl_ids[0], &iceC_Glacier2_SessionControl_ids[2]);
}

::std::string
Glacier2::SessionControl::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::SessionControl::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::SessionControl";
    return typeId;
}

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceD_categories(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<StringSetPrx> ret = this->categories(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceD_adapterIds(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<StringSetPrx> ret = this->adapterIds(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceD_identities(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<IdentitySetPrx> ret = this->identities(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceD_getSessionTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    int ret = this->getSessionTimeout(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_SessionControl_ops, iceC_Glacier2_SessionControl_ops + 9, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_SessionControl_ops)
    {
        case 0:
        {
            return _iceD_adapterIds(in, current);
        }
        case 1:
        {
            return _iceD_categories(in, current);
        }
        case 2:
        {
            return _iceD_destroy(in, current);
        }
        case 3:
        {
            return _iceD_getSessionTimeout(in, current);
        }
        case 4:
        {
            return _iceD_ice_id(in, current);
        }
        case 5:
        {
            return _iceD_ice_ids(in, current);
        }
        case 6:
        {
            return _iceD_ice_isA(in, current);
        }
        case 7:
        {
            return _iceD_ice_ping(in, current);
        }
        case 8:
        {
            return _iceD_identities(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
Glacier2::SessionManager::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_SessionManager_ids, iceC_Glacier2_SessionManager_ids + 2, s);
}

::std::vector<::std::string>
Glacier2::SessionManager::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_Glacier2_SessionManager_ids[0], &iceC_Glacier2_SessionManager_ids[2]);
}

::std::string
Glacier2::SessionManager::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::SessionManager::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::SessionManager";
    return typeId;
}

/// \cond INTERNAL
bool
Glacier2::SessionManager::_iceD_create(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_userId;
    ::std::shared_ptr<SessionControlPrx> iceP_control;
    istr->readAll(iceP_userId, iceP_control);
    inS.endReadParams();
    inS.setFormat(::Ice::FormatType::SlicedFormat);
    ::std::shared_ptr<SessionPrx> ret = this->create(::std::move(iceP_userId), ::std::move(iceP_control), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SessionManager::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_SessionManager_ops, iceC_Glacier2_SessionManager_ops + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_SessionManager_ops)
    {
        case 0:
        {
            return _iceD_create(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
Glacier2::SSLSessionManager::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_SSLSessionManager_ids, iceC_Glacier2_SSLSessionManager_ids + 2, s);
}

::std::vector<::std::string>
Glacier2::SSLSessionManager::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_Glacier2_SSLSessionManager_ids[0], &iceC_Glacier2_SSLSessionManager_ids[2]);
}

::std::string
Glacier2::SSLSessionManager::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::SSLSessionManager::ice_staticId()
{
    static const ::std::string typeId = "::Glacier2::SSLSessionManager";
    return typeId;
}

/// \cond INTERNAL
bool
Glacier2::SSLSessionManager::_iceD_create(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    SSLInfo iceP_info;
    ::std::shared_ptr<SessionControlPrx> iceP_control;
    istr->readAll(iceP_info, iceP_control);
    inS.endReadParams();
    inS.setFormat(::Ice::FormatType::SlicedFormat);
    ::std::shared_ptr<SessionPrx> ret = this->create(::std::move(iceP_info), ::std::move(iceP_control), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SSLSessionManager::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_SSLSessionManager_ops, iceC_Glacier2_SSLSessionManager_ops + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_SSLSessionManager_ops)
    {
        case 0:
        {
            return _iceD_create(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::SessionPrx::_iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_Glacier2_Session_destroy_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Glacier2::SessionPrx::_newInstance() const
{
    return ::IceInternal::createProxy<SessionPrx>();
}
/// \endcond

const ::std::string&
Glacier2::SessionPrx::ice_staticId()
{
    return Session::ice_staticId();
}

/// \cond INTERNAL
void
Glacier2::StringSetPrx::_iceI_add(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::StringSeq& iceP_additions, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_Glacier2_StringSet_add_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_additions);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::StringSetPrx::_iceI_remove(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::StringSeq& iceP_deletions, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_Glacier2_StringSet_remove_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_deletions);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::StringSetPrx::_iceI_get(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_StringSet_get_name);
    outAsync->invoke(iceC_Glacier2_StringSet_get_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Glacier2::StringSetPrx::_newInstance() const
{
    return ::IceInternal::createProxy<StringSetPrx>();
}
/// \endcond

const ::std::string&
Glacier2::StringSetPrx::ice_staticId()
{
    return StringSet::ice_staticId();
}

/// \cond INTERNAL
void
Glacier2::IdentitySetPrx::_iceI_add(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::IdentitySeq& iceP_additions, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_Glacier2_IdentitySet_add_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_additions);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::IdentitySetPrx::_iceI_remove(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::IdentitySeq& iceP_deletions, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_Glacier2_IdentitySet_remove_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_deletions);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::IdentitySetPrx::_iceI_get(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::IdentitySeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_IdentitySet_get_name);
    outAsync->invoke(iceC_Glacier2_IdentitySet_get_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Glacier2::IdentitySetPrx::_newInstance() const
{
    return ::IceInternal::createProxy<IdentitySetPrx>();
}
/// \endcond

const ::std::string&
Glacier2::IdentitySetPrx::ice_staticId()
{
    return IdentitySet::ice_staticId();
}

/// \cond INTERNAL
void
Glacier2::SessionControlPrx::_iceI_categories(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::StringSetPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_SessionControl_categories_name);
    outAsync->invoke(iceC_Glacier2_SessionControl_categories_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::SessionControlPrx::_iceI_adapterIds(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::StringSetPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_SessionControl_adapterIds_name);
    outAsync->invoke(iceC_Glacier2_SessionControl_adapterIds_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::SessionControlPrx::_iceI_identities(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::IdentitySetPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_SessionControl_identities_name);
    outAsync->invoke(iceC_Glacier2_SessionControl_identities_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::SessionControlPrx::_iceI_getSessionTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_SessionControl_getSessionTimeout_name);
    outAsync->invoke(iceC_Glacier2_SessionControl_getSessionTimeout_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::SessionControlPrx::_iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_Glacier2_SessionControl_destroy_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Glacier2::SessionControlPrx::_newInstance() const
{
    return ::IceInternal::createProxy<SessionControlPrx>();
}
/// \endcond

const ::std::string&
Glacier2::SessionControlPrx::ice_staticId()
{
    return SessionControl::ice_staticId();
}

/// \cond INTERNAL
void
Glacier2::SessionManagerPrx::_iceI_create(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>& outAsync, const ::std::string& iceP_userId, const ::std::shared_ptr<SessionControlPrx>& iceP_control, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_SessionManager_create_name);
    outAsync->invoke(iceC_Glacier2_SessionManager_create_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::SlicedFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_userId, iceP_control);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const CannotCreateSessionException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Glacier2::SessionManagerPrx::_newInstance() const
{
    return ::IceInternal::createProxy<SessionManagerPrx>();
}
/// \endcond

const ::std::string&
Glacier2::SessionManagerPrx::ice_staticId()
{
    return SessionManager::ice_staticId();
}

/// \cond INTERNAL
void
Glacier2::SSLSessionManagerPrx::_iceI_create(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>& outAsync, const SSLInfo& iceP_info, const ::std::shared_ptr<SessionControlPrx>& iceP_control, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_Glacier2_SSLSessionManager_create_name);
    outAsync->invoke(iceC_Glacier2_SSLSessionManager_create_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::SlicedFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_info, iceP_control);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const CannotCreateSessionException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
Glacier2::SSLSessionManagerPrx::_newInstance() const
{
    return ::IceInternal::createProxy<SSLSessionManagerPrx>();
}
/// \endcond

const ::std::string&
Glacier2::SSLSessionManagerPrx::ice_staticId()
{
    return SSLSessionManager::ice_staticId();
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_Glacier2_Session_destroy_name = "destroy";

const ::std::string iceC_Glacier2_StringSet_add_name = "add";

const ::std::string iceC_Glacier2_StringSet_remove_name = "remove";

const ::std::string iceC_Glacier2_StringSet_get_name = "get";

const ::std::string iceC_Glacier2_IdentitySet_add_name = "add";

const ::std::string iceC_Glacier2_IdentitySet_remove_name = "remove";

const ::std::string iceC_Glacier2_IdentitySet_get_name = "get";

const ::std::string iceC_Glacier2_SessionControl_categories_name = "categories";

const ::std::string iceC_Glacier2_SessionControl_adapterIds_name = "adapterIds";

const ::std::string iceC_Glacier2_SessionControl_identities_name = "identities";

const ::std::string iceC_Glacier2_SessionControl_getSessionTimeout_name = "getSessionTimeout";

const ::std::string iceC_Glacier2_SessionControl_destroy_name = "destroy";

const ::std::string iceC_Glacier2_SessionManager_create_name = "create";

const ::std::string iceC_Glacier2_SSLSessionManager_create_name = "create";

}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Glacier2::CannotCreateSessionException> iceC_Glacier2_CannotCreateSessionException_init("::Glacier2::CannotCreateSessionException");

}

Glacier2::CannotCreateSessionException::CannotCreateSessionException(const ::std::string& reason) :
    ::Ice::UserException(),
    reason(reason)
{
}

#ifdef ICE_CPP11_COMPILER
Glacier2::CannotCreateSessionException::~CannotCreateSessionException()
{
}
#else
Glacier2::CannotCreateSessionException::~CannotCreateSessionException() throw()
{
}
#endif

::std::string
Glacier2::CannotCreateSessionException::ice_id() const
{
    return "::Glacier2::CannotCreateSessionException";
}

Glacier2::CannotCreateSessionException*
Glacier2::CannotCreateSessionException::ice_clone() const
{
    return new CannotCreateSessionException(*this);
}

void
Glacier2::CannotCreateSessionException::ice_throw() const
{
    throw *this;
}

::Ice::SlicedDataPtr
Glacier2::CannotCreateSessionException::ice_getSlicedData() const
{
    return _slicedData;
}

void
Glacier2::CannotCreateSessionException::_write(::Ice::OutputStream* ostr) const
{
    ostr->startException(_slicedData);
    _writeImpl(ostr);
    ostr->endException();
}

void
Glacier2::CannotCreateSessionException::_read(::Ice::InputStream* istr)
{
    istr->startException();
    _readImpl(istr);
    _slicedData = istr->endException(true);
}

/// \cond STREAM
void
Glacier2::CannotCreateSessionException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::Glacier2::CannotCreateSessionException", -1, true);
    ::Ice::StreamWriter< CannotCreateSessionException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::CannotCreateSessionException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< CannotCreateSessionException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
GLACIER2_API ::IceProxy::Ice::Object* ::IceProxy::Glacier2::upCast(Session* p) { return p; }

void
::IceProxy::Glacier2::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Session>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Session;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Glacier2::Session::_iceI_begin_destroy(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_Session_destroy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_Session_destroy_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_Session_destroy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Glacier2::Session::end_destroy(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_Glacier2_Session_destroy_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Glacier2::Session::_newInstance() const
{
    return new Session;
}
/// \endcond

const ::std::string&
IceProxy::Glacier2::Session::ice_staticId()
{
    return ::Glacier2::Session::ice_staticId();
}

/// \cond INTERNAL
GLACIER2_API ::IceProxy::Ice::Object* ::IceProxy::Glacier2::upCast(StringSet* p) { return p; }

void
::IceProxy::Glacier2::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< StringSet>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new StringSet;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Glacier2::StringSet::_iceI_begin_add(const ::Ice::StringSeq& iceP_additions, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_StringSet_add_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_StringSet_add_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_additions);
        result->endWriteParams();
        result->invoke(iceC_Glacier2_StringSet_add_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Glacier2::StringSet::end_add(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_Glacier2_StringSet_add_name);
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::StringSet::_iceI_begin_remove(const ::Ice::StringSeq& iceP_deletions, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_StringSet_remove_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_StringSet_remove_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_deletions);
        result->endWriteParams();
        result->invoke(iceC_Glacier2_StringSet_remove_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Glacier2::StringSet::end_remove(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_Glacier2_StringSet_remove_name);
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::StringSet::_iceI_begin_get(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_StringSet_get_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_StringSet_get_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_StringSet_get_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_StringSet_get_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::StringSeq
IceProxy::Glacier2::StringSet::end_get(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_StringSet_get_name);
    ::Ice::StringSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Glacier2::StringSet::_newInstance() const
{
    return new StringSet;
}
/// \endcond

const ::std::string&
IceProxy::Glacier2::StringSet::ice_staticId()
{
    return ::Glacier2::StringSet::ice_staticId();
}

/// \cond INTERNAL
GLACIER2_API ::IceProxy::Ice::Object* ::IceProxy::Glacier2::upCast(IdentitySet* p) { return p; }

void
::IceProxy::Glacier2::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< IdentitySet>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new IdentitySet;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Glacier2::IdentitySet::_iceI_begin_add(const ::Ice::IdentitySeq& iceP_additions, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_IdentitySet_add_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_IdentitySet_add_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_additions);
        result->endWriteParams();
        result->invoke(iceC_Glacier2_IdentitySet_add_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Glacier2::IdentitySet::end_add(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_Glacier2_IdentitySet_add_name);
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::IdentitySet::_iceI_begin_remove(const ::Ice::IdentitySeq& iceP_deletions, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_IdentitySet_remove_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_IdentitySet_remove_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_deletions);
        result->endWriteParams();
        result->invoke(iceC_Glacier2_IdentitySet_remove_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Glacier2::IdentitySet::end_remove(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_Glacier2_IdentitySet_remove_name);
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::IdentitySet::_iceI_begin_get(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_IdentitySet_get_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_IdentitySet_get_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_IdentitySet_get_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_IdentitySet_get_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::IdentitySeq
IceProxy::Glacier2::IdentitySet::end_get(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_IdentitySet_get_name);
    ::Ice::IdentitySeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Glacier2::IdentitySet::_newInstance() const
{
    return new IdentitySet;
}
/// \endcond

const ::std::string&
IceProxy::Glacier2::IdentitySet::ice_staticId()
{
    return ::Glacier2::IdentitySet::ice_staticId();
}

/// \cond INTERNAL
GLACIER2_API ::IceProxy::Ice::Object* ::IceProxy::Glacier2::upCast(SessionControl* p) { return p; }

void
::IceProxy::Glacier2::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< SessionControl>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new SessionControl;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Glacier2::SessionControl::_iceI_begin_categories(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_SessionControl_categories_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_SessionControl_categories_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_SessionControl_categories_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_SessionControl_categories_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Glacier2::StringSetPrx
IceProxy::Glacier2::SessionControl::end_categories(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_SessionControl_categories_name);
    ::Glacier2::StringSetPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::SessionControl::_iceI_begin_adapterIds(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_SessionControl_adapterIds_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_SessionControl_adapterIds_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_SessionControl_adapterIds_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_SessionControl_adapterIds_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Glacier2::StringSetPrx
IceProxy::Glacier2::SessionControl::end_adapterIds(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_SessionControl_adapterIds_name);
    ::Glacier2::StringSetPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::SessionControl::_iceI_begin_identities(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_SessionControl_identities_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_SessionControl_identities_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_SessionControl_identities_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_SessionControl_identities_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Glacier2::IdentitySetPrx
IceProxy::Glacier2::SessionControl::end_identities(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_SessionControl_identities_name);
    ::Glacier2::IdentitySetPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::SessionControl::_iceI_begin_getSessionTimeout(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_SessionControl_getSessionTimeout_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_SessionControl_getSessionTimeout_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_SessionControl_getSessionTimeout_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_SessionControl_getSessionTimeout_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::Glacier2::SessionControl::end_getSessionTimeout(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_SessionControl_getSessionTimeout_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::Glacier2::SessionControl::_iceI_begin_destroy(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_SessionControl_destroy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_SessionControl_destroy_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_Glacier2_SessionControl_destroy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::Glacier2::SessionControl::end_destroy(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_Glacier2_SessionControl_destroy_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Glacier2::SessionControl::_newInstance() const
{
    return new SessionControl;
}
/// \endcond

const ::std::string&
IceProxy::Glacier2::SessionControl::ice_staticId()
{
    return ::Glacier2::SessionControl::ice_staticId();
}

/// \cond INTERNAL
GLACIER2_API ::IceProxy::Ice::Object* ::IceProxy::Glacier2::upCast(SessionManager* p) { return p; }

void
::IceProxy::Glacier2::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< SessionManager>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new SessionManager;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Glacier2::SessionManager::_iceI_begin_create(const ::std::string& iceP_userId, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_SessionManager_create_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_SessionManager_create_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_SessionManager_create_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::SlicedFormat);
        ostr->write(iceP_userId);
        ostr->write(iceP_control);
        result->endWriteParams();
        result->invoke(iceC_Glacier2_SessionManager_create_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Glacier2::SessionPrx
IceProxy::Glacier2::SessionManager::end_create(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_SessionManager_create_name);
    ::Glacier2::SessionPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Glacier2::CannotCreateSessionException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Glacier2::SessionManager::_newInstance() const
{
    return new SessionManager;
}
/// \endcond

const ::std::string&
IceProxy::Glacier2::SessionManager::ice_staticId()
{
    return ::Glacier2::SessionManager::ice_staticId();
}

/// \cond INTERNAL
GLACIER2_API ::IceProxy::Ice::Object* ::IceProxy::Glacier2::upCast(SSLSessionManager* p) { return p; }

void
::IceProxy::Glacier2::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< SSLSessionManager>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new SSLSessionManager;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::Glacier2::SSLSessionManager::_iceI_begin_create(const ::Glacier2::SSLInfo& iceP_info, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_Glacier2_SSLSessionManager_create_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_Glacier2_SSLSessionManager_create_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_Glacier2_SSLSessionManager_create_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::SlicedFormat);
        ostr->write(iceP_info);
        ostr->write(iceP_control);
        result->endWriteParams();
        result->invoke(iceC_Glacier2_SSLSessionManager_create_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Glacier2::SessionPrx
IceProxy::Glacier2::SSLSessionManager::end_create(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_Glacier2_SSLSessionManager_create_name);
    ::Glacier2::SessionPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Glacier2::CannotCreateSessionException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::Glacier2::SSLSessionManager::_newInstance() const
{
    return new SSLSessionManager;
}
/// \endcond

const ::std::string&
IceProxy::Glacier2::SSLSessionManager::ice_staticId()
{
    return ::Glacier2::SSLSessionManager::ice_staticId();
}

Glacier2::Session::~Session()
{
}

/// \cond INTERNAL
GLACIER2_API ::Ice::Object* Glacier2::upCast(Session* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Glacier2_Session_ids[2] =
{
    "::Glacier2::Session",
    "::Ice::Object"
};

}

bool
Glacier2::Session::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_Session_ids, iceC_Glacier2_Session_ids + 2, s);
}

::std::vector< ::std::string>
Glacier2::Session::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Glacier2_Session_ids[0], &iceC_Glacier2_Session_ids[2]);
}

const ::std::string&
Glacier2::Session::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::Session::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Glacier2::Session";
    return typeId;
#else
    return iceC_Glacier2_Session_ids[0];
#endif
}

/// \cond INTERNAL
bool
Glacier2::Session::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Glacier2_Session_all[] =
{
    "destroy",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
Glacier2::Session::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_Session_all, iceC_Glacier2_Session_all + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_Session_all)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Glacier2::Session::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Session, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::Session::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Session, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::_icePatchObjectPtr(SessionPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = SessionPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Session::ice_staticId(), v);
    }
}
/// \endcond

Glacier2::StringSet::~StringSet()
{
}

/// \cond INTERNAL
GLACIER2_API ::Ice::Object* Glacier2::upCast(StringSet* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Glacier2_StringSet_ids[2] =
{
    "::Glacier2::StringSet",
    "::Ice::Object"
};

}

bool
Glacier2::StringSet::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_StringSet_ids, iceC_Glacier2_StringSet_ids + 2, s);
}

::std::vector< ::std::string>
Glacier2::StringSet::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Glacier2_StringSet_ids[0], &iceC_Glacier2_StringSet_ids[2]);
}

const ::std::string&
Glacier2::StringSet::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::StringSet::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Glacier2::StringSet";
    return typeId;
#else
    return iceC_Glacier2_StringSet_ids[0];
#endif
}

/// \cond INTERNAL
bool
Glacier2::StringSet::_iceD_add(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::StringSeq iceP_additions;
    istr->read(iceP_additions);
    inS.endReadParams();
    this->add(iceP_additions, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::StringSet::_iceD_remove(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::StringSeq iceP_deletions;
    istr->read(iceP_deletions);
    inS.endReadParams();
    this->remove(iceP_deletions, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::StringSet::_iceD_get(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->get(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Glacier2_StringSet_all[] =
{
    "add",
    "get",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "remove"
};

}

/// \cond INTERNAL
bool
Glacier2::StringSet::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_StringSet_all, iceC_Glacier2_StringSet_all + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_StringSet_all)
    {
        case 0:
        {
            return _iceD_add(in, current);
        }
        case 1:
        {
            return _iceD_get(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        case 6:
        {
            return _iceD_remove(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Glacier2::StringSet::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< StringSet, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::StringSet::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< StringSet, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::_icePatchObjectPtr(StringSetPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = StringSetPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(StringSet::ice_staticId(), v);
    }
}
/// \endcond

Glacier2::IdentitySet::~IdentitySet()
{
}

/// \cond INTERNAL
GLACIER2_API ::Ice::Object* Glacier2::upCast(IdentitySet* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Glacier2_IdentitySet_ids[2] =
{
    "::Glacier2::IdentitySet",
    "::Ice::Object"
};

}

bool
Glacier2::IdentitySet::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_IdentitySet_ids, iceC_Glacier2_IdentitySet_ids + 2, s);
}

::std::vector< ::std::string>
Glacier2::IdentitySet::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Glacier2_IdentitySet_ids[0], &iceC_Glacier2_IdentitySet_ids[2]);
}

const ::std::string&
Glacier2::IdentitySet::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::IdentitySet::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Glacier2::IdentitySet";
    return typeId;
#else
    return iceC_Glacier2_IdentitySet_ids[0];
#endif
}

/// \cond INTERNAL
bool
Glacier2::IdentitySet::_iceD_add(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::IdentitySeq iceP_additions;
    istr->read(iceP_additions);
    inS.endReadParams();
    this->add(iceP_additions, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::IdentitySet::_iceD_remove(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::IdentitySeq iceP_deletions;
    istr->read(iceP_deletions);
    inS.endReadParams();
    this->remove(iceP_deletions, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::IdentitySet::_iceD_get(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::IdentitySeq ret = this->get(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Glacier2_IdentitySet_all[] =
{
    "add",
    "get",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "remove"
};

}

/// \cond INTERNAL
bool
Glacier2::IdentitySet::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_IdentitySet_all, iceC_Glacier2_IdentitySet_all + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_IdentitySet_all)
    {
        case 0:
        {
            return _iceD_add(in, current);
        }
        case 1:
        {
            return _iceD_get(in, current);
        }
        case 2:
        {
            return _iceD_ice_id(in, current);
        }
        case 3:
        {
            return _iceD_ice_ids(in, current);
        }
        case 4:
        {
            return _iceD_ice_isA(in, current);
        }
        case 5:
        {
            return _iceD_ice_ping(in, current);
        }
        case 6:
        {
            return _iceD_remove(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Glacier2::IdentitySet::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< IdentitySet, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::IdentitySet::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< IdentitySet, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::_icePatchObjectPtr(IdentitySetPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = IdentitySetPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(IdentitySet::ice_staticId(), v);
    }
}
/// \endcond

Glacier2::SessionControl::~SessionControl()
{
}

/// \cond INTERNAL
GLACIER2_API ::Ice::Object* Glacier2::upCast(SessionControl* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Glacier2_SessionControl_ids[2] =
{
    "::Glacier2::SessionControl",
    "::Ice::Object"
};

}

bool
Glacier2::SessionControl::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_SessionControl_ids, iceC_Glacier2_SessionControl_ids + 2, s);
}

::std::vector< ::std::string>
Glacier2::SessionControl::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Glacier2_SessionControl_ids[0], &iceC_Glacier2_SessionControl_ids[2]);
}

const ::std::string&
Glacier2::SessionControl::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::SessionControl::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Glacier2::SessionControl";
    return typeId;
#else
    return iceC_Glacier2_SessionControl_ids[0];
#endif
}

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceD_categories(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    StringSetPrx ret = this->categories(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceD_adapterIds(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    StringSetPrx ret = this->adapterIds(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceD_identities(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    IdentitySetPrx ret = this->identities(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceD_getSessionTimeout(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::Int ret = this->getSessionTimeout(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Glacier2_SessionControl_all[] =
{
    "adapterIds",
    "categories",
    "destroy",
    "getSessionTimeout",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "identities"
};

}

/// \cond INTERNAL
bool
Glacier2::SessionControl::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_SessionControl_all, iceC_Glacier2_SessionControl_all + 9, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_SessionControl_all)
    {
        case 0:
        {
            return _iceD_adapterIds(in, current);
        }
        case 1:
        {
            return _iceD_categories(in, current);
        }
        case 2:
        {
            return _iceD_destroy(in, current);
        }
        case 3:
        {
            return _iceD_getSessionTimeout(in, current);
        }
        case 4:
        {
            return _iceD_ice_id(in, current);
        }
        case 5:
        {
            return _iceD_ice_ids(in, current);
        }
        case 6:
        {
            return _iceD_ice_isA(in, current);
        }
        case 7:
        {
            return _iceD_ice_ping(in, current);
        }
        case 8:
        {
            return _iceD_identities(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Glacier2::SessionControl::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< SessionControl, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::SessionControl::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< SessionControl, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::_icePatchObjectPtr(SessionControlPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = SessionControlPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(SessionControl::ice_staticId(), v);
    }
}
/// \endcond

Glacier2::SessionManager::~SessionManager()
{
}

/// \cond INTERNAL
GLACIER2_API ::Ice::Object* Glacier2::upCast(SessionManager* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Glacier2_SessionManager_ids[2] =
{
    "::Glacier2::SessionManager",
    "::Ice::Object"
};

}

bool
Glacier2::SessionManager::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_SessionManager_ids, iceC_Glacier2_SessionManager_ids + 2, s);
}

::std::vector< ::std::string>
Glacier2::SessionManager::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Glacier2_SessionManager_ids[0], &iceC_Glacier2_SessionManager_ids[2]);
}

const ::std::string&
Glacier2::SessionManager::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::SessionManager::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Glacier2::SessionManager";
    return typeId;
#else
    return iceC_Glacier2_SessionManager_ids[0];
#endif
}

/// \cond INTERNAL
bool
Glacier2::SessionManager::_iceD_create(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_userId;
    SessionControlPrx iceP_control;
    istr->read(iceP_userId);
    istr->read(iceP_control);
    inS.endReadParams();
    inS.setFormat(::Ice::SlicedFormat);
    SessionPrx ret = this->create(iceP_userId, iceP_control, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Glacier2_SessionManager_all[] =
{
    "create",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
Glacier2::SessionManager::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_SessionManager_all, iceC_Glacier2_SessionManager_all + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_SessionManager_all)
    {
        case 0:
        {
            return _iceD_create(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Glacier2::SessionManager::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< SessionManager, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::SessionManager::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< SessionManager, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::_icePatchObjectPtr(SessionManagerPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = SessionManagerPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(SessionManager::ice_staticId(), v);
    }
}
/// \endcond

Glacier2::SSLSessionManager::~SSLSessionManager()
{
}

/// \cond INTERNAL
GLACIER2_API ::Ice::Object* Glacier2::upCast(SSLSessionManager* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_Glacier2_SSLSessionManager_ids[2] =
{
    "::Glacier2::SSLSessionManager",
    "::Ice::Object"
};

}

bool
Glacier2::SSLSessionManager::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_Glacier2_SSLSessionManager_ids, iceC_Glacier2_SSLSessionManager_ids + 2, s);
}

::std::vector< ::std::string>
Glacier2::SSLSessionManager::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_Glacier2_SSLSessionManager_ids[0], &iceC_Glacier2_SSLSessionManager_ids[2]);
}

const ::std::string&
Glacier2::SSLSessionManager::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
Glacier2::SSLSessionManager::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Glacier2::SSLSessionManager";
    return typeId;
#else
    return iceC_Glacier2_SSLSessionManager_ids[0];
#endif
}

/// \cond INTERNAL
bool
Glacier2::SSLSessionManager::_iceD_create(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    SSLInfo iceP_info;
    SessionControlPrx iceP_control;
    istr->read(iceP_info);
    istr->read(iceP_control);
    inS.endReadParams();
    inS.setFormat(::Ice::SlicedFormat);
    SessionPrx ret = this->create(iceP_info, iceP_control, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_Glacier2_SSLSessionManager_all[] =
{
    "create",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
Glacier2::SSLSessionManager::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_Glacier2_SSLSessionManager_all, iceC_Glacier2_SSLSessionManager_all + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_Glacier2_SSLSessionManager_all)
    {
        case 0:
        {
            return _iceD_create(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
Glacier2::SSLSessionManager::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< SSLSessionManager, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
Glacier2::SSLSessionManager::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< SSLSessionManager, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
Glacier2::_icePatchObjectPtr(SSLSessionManagerPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = SSLSessionManagerPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(SSLSessionManager::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
