static const ZydisRegisterLookupItem REG_LOOKUP[] =
{
    /* NONE       */ { ZYDIS_REGCLASS_INVALID, -1, 0, 0 },
    /* AL         */ { ZYDIS_REGCLASS_GPR8, 0, 8, 8 },
    /* CL         */ { ZYDIS_REGCLASS_GPR8, 1, 8, 8 },
    /* DL         */ { ZYDIS_REGCLASS_GPR8, 2, 8, 8 },
    /* BL         */ { ZYDIS_REGCLASS_GPR8, 3, 8, 8 },
    /* AH         */ { ZYDIS_REGCLASS_GPR8, 4, 8, 8 },
    /* CH         */ { ZYDIS_REGCLASS_GPR8, 5, 8, 8 },
    /* DH         */ { ZYDIS_REGCLASS_GPR8, 6, 8, 8 },
    /* BH         */ { ZYDIS_REGCLASS_GPR8, 7, 8, 8 },
    /* SPL        */ { ZYDIS_REGCLASS_GPR8, 8, 8, 8 },
    /* BPL        */ { ZYDIS_REGCLASS_GPR8, 9, 8, 8 },
    /* SIL        */ { ZYDIS_REGCLASS_GPR8, 10, 8, 8 },
    /* DIL        */ { ZYDIS_REGCLASS_GPR8, 11, 8, 8 },
    /* R8B        */ { ZYDIS_REGCLASS_GPR8, 12, 8, 8 },
    /* R9B        */ { ZYDIS_REGCLASS_GPR8, 13, 8, 8 },
    /* R10B       */ { ZYDIS_REGCLASS_GPR8, 14, 8, 8 },
    /* R11B       */ { ZYDIS_REGCLASS_GPR8, 15, 8, 8 },
    /* R12B       */ { ZYDIS_REGCLASS_GPR8, 16, 8, 8 },
    /* R13B       */ { ZYDIS_REGCLASS_GPR8, 17, 8, 8 },
    /* R14B       */ { ZYDIS_REGCLASS_GPR8, 18, 8, 8 },
    /* R15B       */ { ZYDIS_REGCLASS_GPR8, 19, 8, 8 },
    /* AX         */ { ZYDIS_REGCLASS_GPR16, 0, 16, 16 },
    /* CX         */ { ZYDIS_REGCLASS_GPR16, 1, 16, 16 },
    /* DX         */ { ZYDIS_REGCLASS_GPR16, 2, 16, 16 },
    /* BX         */ { ZYDIS_REGCLASS_GPR16, 3, 16, 16 },
    /* SP         */ { ZYDIS_REGCLASS_GPR16, 4, 16, 16 },
    /* BP         */ { ZYDIS_REGCLASS_GPR16, 5, 16, 16 },
    /* SI         */ { ZYDIS_REGCLASS_GPR16, 6, 16, 16 },
    /* DI         */ { ZYDIS_REGCLASS_GPR16, 7, 16, 16 },
    /* R8W        */ { ZYDIS_REGCLASS_GPR16, 8, 16, 16 },
    /* R9W        */ { ZYDIS_REGCLASS_GPR16, 9, 16, 16 },
    /* R10W       */ { ZYDIS_REGCLASS_GPR16, 10, 16, 16 },
    /* R11W       */ { ZYDIS_REGCLASS_GPR16, 11, 16, 16 },
    /* R12W       */ { ZYDIS_REGCLASS_GPR16, 12, 16, 16 },
    /* R13W       */ { ZYDIS_REGCLASS_GPR16, 13, 16, 16 },
    /* R14W       */ { ZYDIS_REGCLASS_GPR16, 14, 16, 16 },
    /* R15W       */ { ZYDIS_REGCLASS_GPR16, 15, 16, 16 },
    /* EAX        */ { ZYDIS_REGCLASS_GPR32, 0, 32, 32 },
    /* ECX        */ { ZYDIS_REGCLASS_GPR32, 1, 32, 32 },
    /* EDX        */ { ZYDIS_REGCLASS_GPR32, 2, 32, 32 },
    /* EBX        */ { ZYDIS_REGCLASS_GPR32, 3, 32, 32 },
    /* ESP        */ { ZYDIS_REGCLASS_GPR32, 4, 32, 32 },
    /* EBP        */ { ZYDIS_REGCLASS_GPR32, 5, 32, 32 },
    /* ESI        */ { ZYDIS_REGCLASS_GPR32, 6, 32, 32 },
    /* EDI        */ { ZYDIS_REGCLASS_GPR32, 7, 32, 32 },
    /* R8D        */ { ZYDIS_REGCLASS_GPR32, 8, 32, 32 },
    /* R9D        */ { ZYDIS_REGCLASS_GPR32, 9, 32, 32 },
    /* R10D       */ { ZYDIS_REGCLASS_GPR32, 10, 32, 32 },
    /* R11D       */ { ZYDIS_REGCLASS_GPR32, 11, 32, 32 },
    /* R12D       */ { ZYDIS_REGCLASS_GPR32, 12, 32, 32 },
    /* R13D       */ { ZYDIS_REGCLASS_GPR32, 13, 32, 32 },
    /* R14D       */ { ZYDIS_REGCLASS_GPR32, 14, 32, 32 },
    /* R15D       */ { ZYDIS_REGCLASS_GPR32, 15, 32, 32 },
    /* RAX        */ { ZYDIS_REGCLASS_GPR64, 0, 0, 64 },
    /* RCX        */ { ZYDIS_REGCLASS_GPR64, 1, 0, 64 },
    /* RDX        */ { ZYDIS_REGCLASS_GPR64, 2, 0, 64 },
    /* RBX        */ { ZYDIS_REGCLASS_GPR64, 3, 0, 64 },
    /* RSP        */ { ZYDIS_REGCLASS_GPR64, 4, 0, 64 },
    /* RBP        */ { ZYDIS_REGCLASS_GPR64, 5, 0, 64 },
    /* RSI        */ { ZYDIS_REGCLASS_GPR64, 6, 0, 64 },
    /* RDI        */ { ZYDIS_REGCLASS_GPR64, 7, 0, 64 },
    /* R8         */ { ZYDIS_REGCLASS_GPR64, 8, 0, 64 },
    /* R9         */ { ZYDIS_REGCLASS_GPR64, 9, 0, 64 },
    /* R10        */ { ZYDIS_REGCLASS_GPR64, 10, 0, 64 },
    /* R11        */ { ZYDIS_REGCLASS_GPR64, 11, 0, 64 },
    /* R12        */ { ZYDIS_REGCLASS_GPR64, 12, 0, 64 },
    /* R13        */ { ZYDIS_REGCLASS_GPR64, 13, 0, 64 },
    /* R14        */ { ZYDIS_REGCLASS_GPR64, 14, 0, 64 },
    /* R15        */ { ZYDIS_REGCLASS_GPR64, 15, 0, 64 },
    /* ST0        */ { ZYDIS_REGCLASS_X87, 0, 80, 80 },
    /* ST1        */ { ZYDIS_REGCLASS_X87, 1, 80, 80 },
    /* ST2        */ { ZYDIS_REGCLASS_X87, 2, 80, 80 },
    /* ST3        */ { ZYDIS_REGCLASS_X87, 3, 80, 80 },
    /* ST4        */ { ZYDIS_REGCLASS_X87, 4, 80, 80 },
    /* ST5        */ { ZYDIS_REGCLASS_X87, 5, 80, 80 },
    /* ST6        */ { ZYDIS_REGCLASS_X87, 6, 80, 80 },
    /* ST7        */ { ZYDIS_REGCLASS_X87, 7, 80, 80 },
    /* X87CONTROL */ { ZYDIS_REGCLASS_INVALID, -1, 16, 16 },
    /* X87STATUS  */ { ZYDIS_REGCLASS_INVALID, -1, 16, 16 },
    /* X87TAG     */ { ZYDIS_REGCLASS_INVALID, -1, 16, 16 },
    /* MM0        */ { ZYDIS_REGCLASS_MMX, 0, 64, 64 },
    /* MM1        */ { ZYDIS_REGCLASS_MMX, 1, 64, 64 },
    /* MM2        */ { ZYDIS_REGCLASS_MMX, 2, 64, 64 },
    /* MM3        */ { ZYDIS_REGCLASS_MMX, 3, 64, 64 },
    /* MM4        */ { ZYDIS_REGCLASS_MMX, 4, 64, 64 },
    /* MM5        */ { ZYDIS_REGCLASS_MMX, 5, 64, 64 },
    /* MM6        */ { ZYDIS_REGCLASS_MMX, 6, 64, 64 },
    /* MM7        */ { ZYDIS_REGCLASS_MMX, 7, 64, 64 },
    /* XMM0       */ { ZYDIS_REGCLASS_XMM, 0, 128, 128 },
    /* XMM1       */ { ZYDIS_REGCLASS_XMM, 1, 128, 128 },
    /* XMM2       */ { ZYDIS_REGCLASS_XMM, 2, 128, 128 },
    /* XMM3       */ { ZYDIS_REGCLASS_XMM, 3, 128, 128 },
    /* XMM4       */ { ZYDIS_REGCLASS_XMM, 4, 128, 128 },
    /* XMM5       */ { ZYDIS_REGCLASS_XMM, 5, 128, 128 },
    /* XMM6       */ { ZYDIS_REGCLASS_XMM, 6, 128, 128 },
    /* XMM7       */ { ZYDIS_REGCLASS_XMM, 7, 128, 128 },
    /* XMM8       */ { ZYDIS_REGCLASS_XMM, 8, 128, 128 },
    /* XMM9       */ { ZYDIS_REGCLASS_XMM, 9, 128, 128 },
    /* XMM10      */ { ZYDIS_REGCLASS_XMM, 10, 128, 128 },
    /* XMM11      */ { ZYDIS_REGCLASS_XMM, 11, 128, 128 },
    /* XMM12      */ { ZYDIS_REGCLASS_XMM, 12, 128, 128 },
    /* XMM13      */ { ZYDIS_REGCLASS_XMM, 13, 128, 128 },
    /* XMM14      */ { ZYDIS_REGCLASS_XMM, 14, 128, 128 },
    /* XMM15      */ { ZYDIS_REGCLASS_XMM, 15, 128, 128 },
    /* XMM16      */ { ZYDIS_REGCLASS_XMM, 16, 128, 128 },
    /* XMM17      */ { ZYDIS_REGCLASS_XMM, 17, 128, 128 },
    /* XMM18      */ { ZYDIS_REGCLASS_XMM, 18, 128, 128 },
    /* XMM19      */ { ZYDIS_REGCLASS_XMM, 19, 128, 128 },
    /* XMM20      */ { ZYDIS_REGCLASS_XMM, 20, 128, 128 },
    /* XMM21      */ { ZYDIS_REGCLASS_XMM, 21, 128, 128 },
    /* XMM22      */ { ZYDIS_REGCLASS_XMM, 22, 128, 128 },
    /* XMM23      */ { ZYDIS_REGCLASS_XMM, 23, 128, 128 },
    /* XMM24      */ { ZYDIS_REGCLASS_XMM, 24, 128, 128 },
    /* XMM25      */ { ZYDIS_REGCLASS_XMM, 25, 128, 128 },
    /* XMM26      */ { ZYDIS_REGCLASS_XMM, 26, 128, 128 },
    /* XMM27      */ { ZYDIS_REGCLASS_XMM, 27, 128, 128 },
    /* XMM28      */ { ZYDIS_REGCLASS_XMM, 28, 128, 128 },
    /* XMM29      */ { ZYDIS_REGCLASS_XMM, 29, 128, 128 },
    /* XMM30      */ { ZYDIS_REGCLASS_XMM, 30, 128, 128 },
    /* XMM31      */ { ZYDIS_REGCLASS_XMM, 31, 128, 128 },
    /* YMM0       */ { ZYDIS_REGCLASS_YMM, 0, 256, 256 },
    /* YMM1       */ { ZYDIS_REGCLASS_YMM, 1, 256, 256 },
    /* YMM2       */ { ZYDIS_REGCLASS_YMM, 2, 256, 256 },
    /* YMM3       */ { ZYDIS_REGCLASS_YMM, 3, 256, 256 },
    /* YMM4       */ { ZYDIS_REGCLASS_YMM, 4, 256, 256 },
    /* YMM5       */ { ZYDIS_REGCLASS_YMM, 5, 256, 256 },
    /* YMM6       */ { ZYDIS_REGCLASS_YMM, 6, 256, 256 },
    /* YMM7       */ { ZYDIS_REGCLASS_YMM, 7, 256, 256 },
    /* YMM8       */ { ZYDIS_REGCLASS_YMM, 8, 256, 256 },
    /* YMM9       */ { ZYDIS_REGCLASS_YMM, 9, 256, 256 },
    /* YMM10      */ { ZYDIS_REGCLASS_YMM, 10, 256, 256 },
    /* YMM11      */ { ZYDIS_REGCLASS_YMM, 11, 256, 256 },
    /* YMM12      */ { ZYDIS_REGCLASS_YMM, 12, 256, 256 },
    /* YMM13      */ { ZYDIS_REGCLASS_YMM, 13, 256, 256 },
    /* YMM14      */ { ZYDIS_REGCLASS_YMM, 14, 256, 256 },
    /* YMM15      */ { ZYDIS_REGCLASS_YMM, 15, 256, 256 },
    /* YMM16      */ { ZYDIS_REGCLASS_YMM, 16, 256, 256 },
    /* YMM17      */ { ZYDIS_REGCLASS_YMM, 17, 256, 256 },
    /* YMM18      */ { ZYDIS_REGCLASS_YMM, 18, 256, 256 },
    /* YMM19      */ { ZYDIS_REGCLASS_YMM, 19, 256, 256 },
    /* YMM20      */ { ZYDIS_REGCLASS_YMM, 20, 256, 256 },
    /* YMM21      */ { ZYDIS_REGCLASS_YMM, 21, 256, 256 },
    /* YMM22      */ { ZYDIS_REGCLASS_YMM, 22, 256, 256 },
    /* YMM23      */ { ZYDIS_REGCLASS_YMM, 23, 256, 256 },
    /* YMM24      */ { ZYDIS_REGCLASS_YMM, 24, 256, 256 },
    /* YMM25      */ { ZYDIS_REGCLASS_YMM, 25, 256, 256 },
    /* YMM26      */ { ZYDIS_REGCLASS_YMM, 26, 256, 256 },
    /* YMM27      */ { ZYDIS_REGCLASS_YMM, 27, 256, 256 },
    /* YMM28      */ { ZYDIS_REGCLASS_YMM, 28, 256, 256 },
    /* YMM29      */ { ZYDIS_REGCLASS_YMM, 29, 256, 256 },
    /* YMM30      */ { ZYDIS_REGCLASS_YMM, 30, 256, 256 },
    /* YMM31      */ { ZYDIS_REGCLASS_YMM, 31, 256, 256 },
    /* ZMM0       */ { ZYDIS_REGCLASS_ZMM, 0, 512, 512 },
    /* ZMM1       */ { ZYDIS_REGCLASS_ZMM, 1, 512, 512 },
    /* ZMM2       */ { ZYDIS_REGCLASS_ZMM, 2, 512, 512 },
    /* ZMM3       */ { ZYDIS_REGCLASS_ZMM, 3, 512, 512 },
    /* ZMM4       */ { ZYDIS_REGCLASS_ZMM, 4, 512, 512 },
    /* ZMM5       */ { ZYDIS_REGCLASS_ZMM, 5, 512, 512 },
    /* ZMM6       */ { ZYDIS_REGCLASS_ZMM, 6, 512, 512 },
    /* ZMM7       */ { ZYDIS_REGCLASS_ZMM, 7, 512, 512 },
    /* ZMM8       */ { ZYDIS_REGCLASS_ZMM, 8, 512, 512 },
    /* ZMM9       */ { ZYDIS_REGCLASS_ZMM, 9, 512, 512 },
    /* ZMM10      */ { ZYDIS_REGCLASS_ZMM, 10, 512, 512 },
    /* ZMM11      */ { ZYDIS_REGCLASS_ZMM, 11, 512, 512 },
    /* ZMM12      */ { ZYDIS_REGCLASS_ZMM, 12, 512, 512 },
    /* ZMM13      */ { ZYDIS_REGCLASS_ZMM, 13, 512, 512 },
    /* ZMM14      */ { ZYDIS_REGCLASS_ZMM, 14, 512, 512 },
    /* ZMM15      */ { ZYDIS_REGCLASS_ZMM, 15, 512, 512 },
    /* ZMM16      */ { ZYDIS_REGCLASS_ZMM, 16, 512, 512 },
    /* ZMM17      */ { ZYDIS_REGCLASS_ZMM, 17, 512, 512 },
    /* ZMM18      */ { ZYDIS_REGCLASS_ZMM, 18, 512, 512 },
    /* ZMM19      */ { ZYDIS_REGCLASS_ZMM, 19, 512, 512 },
    /* ZMM20      */ { ZYDIS_REGCLASS_ZMM, 20, 512, 512 },
    /* ZMM21      */ { ZYDIS_REGCLASS_ZMM, 21, 512, 512 },
    /* ZMM22      */ { ZYDIS_REGCLASS_ZMM, 22, 512, 512 },
    /* ZMM23      */ { ZYDIS_REGCLASS_ZMM, 23, 512, 512 },
    /* ZMM24      */ { ZYDIS_REGCLASS_ZMM, 24, 512, 512 },
    /* ZMM25      */ { ZYDIS_REGCLASS_ZMM, 25, 512, 512 },
    /* ZMM26      */ { ZYDIS_REGCLASS_ZMM, 26, 512, 512 },
    /* ZMM27      */ { ZYDIS_REGCLASS_ZMM, 27, 512, 512 },
    /* ZMM28      */ { ZYDIS_REGCLASS_ZMM, 28, 512, 512 },
    /* ZMM29      */ { ZYDIS_REGCLASS_ZMM, 29, 512, 512 },
    /* ZMM30      */ { ZYDIS_REGCLASS_ZMM, 30, 512, 512 },
    /* ZMM31      */ { ZYDIS_REGCLASS_ZMM, 31, 512, 512 },
    /* TMM0       */ { ZYDIS_REGCLASS_TMM, 0, 8192, 8192 },
    /* TMM1       */ { ZYDIS_REGCLASS_TMM, 1, 8192, 8192 },
    /* TMM2       */ { ZYDIS_REGCLASS_TMM, 2, 8192, 8192 },
    /* TMM3       */ { ZYDIS_REGCLASS_TMM, 3, 8192, 8192 },
    /* TMM4       */ { ZYDIS_REGCLASS_TMM, 4, 8192, 8192 },
    /* TMM5       */ { ZYDIS_REGCLASS_TMM, 5, 8192, 8192 },
    /* TMM6       */ { ZYDIS_REGCLASS_TMM, 6, 8192, 8192 },
    /* TMM7       */ { ZYDIS_REGCLASS_TMM, 7, 8192, 8192 },
    /* FLAGS      */ { ZYDIS_REGCLASS_FLAGS, -1, 16, 16 },
    /* EFLAGS     */ { ZYDIS_REGCLASS_FLAGS, -1, 32, 32 },
    /* RFLAGS     */ { ZYDIS_REGCLASS_FLAGS, -1, 0, 64 },
    /* IP         */ { ZYDIS_REGCLASS_IP, -1, 16, 16 },
    /* EIP        */ { ZYDIS_REGCLASS_IP, -1, 32, 32 },
    /* RIP        */ { ZYDIS_REGCLASS_IP, -1, 0, 64 },
    /* ES         */ { ZYDIS_REGCLASS_SEGMENT, 0, 16, 16 },
    /* CS         */ { ZYDIS_REGCLASS_SEGMENT, 1, 16, 16 },
    /* SS         */ { ZYDIS_REGCLASS_SEGMENT, 2, 16, 16 },
    /* DS         */ { ZYDIS_REGCLASS_SEGMENT, 3, 16, 16 },
    /* FS         */ { ZYDIS_REGCLASS_SEGMENT, 4, 16, 16 },
    /* GS         */ { ZYDIS_REGCLASS_SEGMENT, 5, 16, 16 },
    /* GDTR       */ { ZYDIS_REGCLASS_TABLE, -1, 0, 0 },
    /* LDTR       */ { ZYDIS_REGCLASS_TABLE, -1, 0, 0 },
    /* IDTR       */ { ZYDIS_REGCLASS_TABLE, -1, 0, 0 },
    /* TR         */ { ZYDIS_REGCLASS_TABLE, -1, 0, 0 },
    /* TR0        */ { ZYDIS_REGCLASS_TEST, 0, 32, 32 },
    /* TR1        */ { ZYDIS_REGCLASS_TEST, 1, 32, 32 },
    /* TR2        */ { ZYDIS_REGCLASS_TEST, 2, 32, 32 },
    /* TR3        */ { ZYDIS_REGCLASS_TEST, 3, 32, 32 },
    /* TR4        */ { ZYDIS_REGCLASS_TEST, 4, 32, 32 },
    /* TR5        */ { ZYDIS_REGCLASS_TEST, 5, 32, 32 },
    /* TR6        */ { ZYDIS_REGCLASS_TEST, 6, 32, 32 },
    /* TR7        */ { ZYDIS_REGCLASS_TEST, 7, 32, 32 },
    /* CR0        */ { ZYDIS_REGCLASS_CONTROL, 0, 32, 64 },
    /* CR1        */ { ZYDIS_REGCLASS_CONTROL, 1, 32, 64 },
    /* CR2        */ { ZYDIS_REGCLASS_CONTROL, 2, 32, 64 },
    /* CR3        */ { ZYDIS_REGCLASS_CONTROL, 3, 32, 64 },
    /* CR4        */ { ZYDIS_REGCLASS_CONTROL, 4, 32, 64 },
    /* CR5        */ { ZYDIS_REGCLASS_CONTROL, 5, 32, 64 },
    /* CR6        */ { ZYDIS_REGCLASS_CONTROL, 6, 32, 64 },
    /* CR7        */ { ZYDIS_REGCLASS_CONTROL, 7, 32, 64 },
    /* CR8        */ { ZYDIS_REGCLASS_CONTROL, 8, 32, 64 },
    /* CR9        */ { ZYDIS_REGCLASS_CONTROL, 9, 32, 64 },
    /* CR10       */ { ZYDIS_REGCLASS_CONTROL, 10, 32, 64 },
    /* CR11       */ { ZYDIS_REGCLASS_CONTROL, 11, 32, 64 },
    /* CR12       */ { ZYDIS_REGCLASS_CONTROL, 12, 32, 64 },
    /* CR13       */ { ZYDIS_REGCLASS_CONTROL, 13, 32, 64 },
    /* CR14       */ { ZYDIS_REGCLASS_CONTROL, 14, 32, 64 },
    /* CR15       */ { ZYDIS_REGCLASS_CONTROL, 15, 32, 64 },
    /* DR0        */ { ZYDIS_REGCLASS_DEBUG, 0, 32, 64 },
    /* DR1        */ { ZYDIS_REGCLASS_DEBUG, 1, 32, 64 },
    /* DR2        */ { ZYDIS_REGCLASS_DEBUG, 2, 32, 64 },
    /* DR3        */ { ZYDIS_REGCLASS_DEBUG, 3, 32, 64 },
    /* DR4        */ { ZYDIS_REGCLASS_DEBUG, 4, 32, 64 },
    /* DR5        */ { ZYDIS_REGCLASS_DEBUG, 5, 32, 64 },
    /* DR6        */ { ZYDIS_REGCLASS_DEBUG, 6, 32, 64 },
    /* DR7        */ { ZYDIS_REGCLASS_DEBUG, 7, 32, 64 },
    /* DR8        */ { ZYDIS_REGCLASS_DEBUG, 8, 32, 64 },
    /* DR9        */ { ZYDIS_REGCLASS_DEBUG, 9, 32, 64 },
    /* DR10       */ { ZYDIS_REGCLASS_DEBUG, 10, 32, 64 },
    /* DR11       */ { ZYDIS_REGCLASS_DEBUG, 11, 32, 64 },
    /* DR12       */ { ZYDIS_REGCLASS_DEBUG, 12, 32, 64 },
    /* DR13       */ { ZYDIS_REGCLASS_DEBUG, 13, 32, 64 },
    /* DR14       */ { ZYDIS_REGCLASS_DEBUG, 14, 32, 64 },
    /* DR15       */ { ZYDIS_REGCLASS_DEBUG, 15, 32, 64 },
    /* K0         */ { ZYDIS_REGCLASS_MASK, 0, 64, 64 },
    /* K1         */ { ZYDIS_REGCLASS_MASK, 1, 64, 64 },
    /* K2         */ { ZYDIS_REGCLASS_MASK, 2, 64, 64 },
    /* K3         */ { ZYDIS_REGCLASS_MASK, 3, 64, 64 },
    /* K4         */ { ZYDIS_REGCLASS_MASK, 4, 64, 64 },
    /* K5         */ { ZYDIS_REGCLASS_MASK, 5, 64, 64 },
    /* K6         */ { ZYDIS_REGCLASS_MASK, 6, 64, 64 },
    /* K7         */ { ZYDIS_REGCLASS_MASK, 7, 64, 64 },
    /* BND0       */ { ZYDIS_REGCLASS_BOUND, 0, 128, 128 },
    /* BND1       */ { ZYDIS_REGCLASS_BOUND, 1, 128, 128 },
    /* BND2       */ { ZYDIS_REGCLASS_BOUND, 2, 128, 128 },
    /* BND3       */ { ZYDIS_REGCLASS_BOUND, 3, 128, 128 },
    /* BNDCFG     */ { ZYDIS_REGCLASS_INVALID, -1, 64, 64 },
    /* BNDSTATUS  */ { ZYDIS_REGCLASS_INVALID, -1, 64, 64 },
    /* MXCSR      */ { ZYDIS_REGCLASS_INVALID, -1, 32, 32 },
    /* PKRU       */ { ZYDIS_REGCLASS_INVALID, -1, 32, 32 },
    /* XCR0       */ { ZYDIS_REGCLASS_INVALID, -1, 64, 64 },
    /* UIF        */ { ZYDIS_REGCLASS_INVALID, -1, 1, 1 }
};
