/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module glib.Cache;

private import glib.ConstructionException;
private import glib.c.functions;
public  import glib.c.types;


/**
 * A `GCache` allows sharing of complex data structures, in order to
 * save system resources.
 * 
 * `GCache` uses keys and values. A `GCache` key describes the properties
 * of a particular resource. A `GCache` value is the actual resource.
 * 
 * `GCache` has been marked as deprecated, since this API is rarely
 * used and not very actively maintained.
 * 
 * Deprecated: Use a #GHashTable instead
 */
public class Cache
{
	/** the main Gtk struct */
	protected GCache* gCache;
	protected bool ownedRef;

	/** Get the main Gtk struct */
	public GCache* getCacheStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return gCache;
	}

	/** the main Gtk struct as a void* */
	protected void* getStruct()
	{
		return cast(void*)gCache;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (GCache* gCache, bool ownedRef = false)
	{
		this.gCache = gCache;
		this.ownedRef = ownedRef;
	}


	/**
	 * Frees the memory allocated for the #GCache.
	 *
	 * Note that it does not destroy the keys and values which were
	 * contained in the #GCache.
	 *
	 * Deprecated: Use a #GHashTable instead
	 */
	public void destroy()
	{
		g_cache_destroy(gCache);
	}

	/**
	 * Gets the value corresponding to the given key, creating it if
	 * necessary. It first checks if the value already exists in the
	 * #GCache, by using the @key_equal_func function passed to
	 * g_cache_new(). If it does already exist it is returned, and its
	 * reference count is increased by one. If the value does not currently
	 * exist, if is created by calling the @value_new_func. The key is
	 * duplicated by calling @key_dup_func and the duplicated key and value
	 * are inserted into the #GCache.
	 *
	 * Deprecated: Use a #GHashTable instead
	 *
	 * Params:
	 *     key = a key describing a #GCache object
	 *
	 * Returns: a pointer to a #GCache value
	 */
	public void* insert(void* key)
	{
		return g_cache_insert(gCache, key);
	}

	/**
	 * Calls the given function for each of the keys in the #GCache.
	 *
	 * NOTE @func is passed three parameters, the value and key of a cache
	 * entry and the @user_data. The order of value and key is different
	 * from the order in which g_hash_table_foreach() passes key-value
	 * pairs to its callback function !
	 *
	 * Deprecated: Use a #GHashTable instead
	 *
	 * Params:
	 *     func = the function to call with each #GCache key
	 *     userData = user data to pass to the function
	 */
	public void keyForeach(GHFunc func, void* userData)
	{
		g_cache_key_foreach(gCache, func, userData);
	}

	/**
	 * Decreases the reference count of the given value. If it drops to 0
	 * then the value and its corresponding key are destroyed, using the
	 * @value_destroy_func and @key_destroy_func passed to g_cache_new().
	 *
	 * Deprecated: Use a #GHashTable instead
	 *
	 * Params:
	 *     value = the value to remove
	 */
	public void remove(void* value)
	{
		g_cache_remove(gCache, value);
	}

	/**
	 * Calls the given function for each of the values in the #GCache.
	 *
	 * Deprecated: The reason is that it passes pointers to internal
	 * data structures to @func; use g_cache_key_foreach() instead
	 *
	 * Params:
	 *     func = the function to call with each #GCache value
	 *     userData = user data to pass to the function
	 */
	public void valueForeach(GHFunc func, void* userData)
	{
		g_cache_value_foreach(gCache, func, userData);
	}

	/**
	 * Creates a new #GCache.
	 *
	 * Deprecated: Use a #GHashTable instead
	 *
	 * Params:
	 *     valueNewFunc = a function to create a new object given a key.
	 *         This is called by g_cache_insert() if an object
	 *         with the given key does not already exist
	 *     valueDestroyFunc = a function to destroy an object. It is called
	 *         by g_cache_remove() when the object is no
	 *         longer needed (i.e. its reference count drops
	 *         to 0)
	 *     keyDupFunc = a function to copy a key. It is called by
	 *         g_cache_insert() if the key does not already exist in
	 *         the #GCache
	 *     keyDestroyFunc = a function to destroy a key. It is called by
	 *         g_cache_remove() when the object is no longer
	 *         needed (i.e. its reference count drops to 0)
	 *     hashKeyFunc = a function to create a hash value from a key
	 *     hashValueFunc = a function to create a hash value from a value
	 *     keyEqualFunc = a function to compare two keys. It should return
	 *         %TRUE if the two keys are equivalent
	 *
	 * Returns: a new #GCache
	 *
	 * Throws: ConstructionException GTK+ fails to create the object.
	 */
	public this(GCacheNewFunc valueNewFunc, GCacheDestroyFunc valueDestroyFunc, GCacheDupFunc keyDupFunc, GCacheDestroyFunc keyDestroyFunc, GHashFunc hashKeyFunc, GHashFunc hashValueFunc, GEqualFunc keyEqualFunc)
	{
		auto __p = g_cache_new(valueNewFunc, valueDestroyFunc, keyDupFunc, keyDestroyFunc, hashKeyFunc, hashValueFunc, keyEqualFunc);

		if(__p is null)
		{
			throw new ConstructionException("null returned by new");
		}

		this(cast(GCache*) __p);
	}
}
