/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;

public final class ONSRuntimeLoadBalancingEvent
implements OracleLoadBalancingEvent,
Diagnosable {
    static final String CLASS_NAME = ONSRuntimeLoadBalancingEvent.class.getName();
    private static final String ONS_RCLB_EVENT_DELIMITER = "{} =";
    public static final int RLB_INSTANCE_GOOD = 1;
    public static final int RLB_INSTANCE_UNKNOWN = 2;
    public static final int RLB_INSTANCE_VIOLATING = 3;
    public static final int RLB_INSTANCE_NO_DATA = 4;
    public static final int RLB_INSTANCE_BLOCKED = 5;
    public static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
    private Set<RACInstance> m_racInstances;
    private byte[] m_eventBody;
    private final String m_serviceName;

    @Debug(level=Debug.Level.FINEST)
    public ONSRuntimeLoadBalancingEvent(String serviceName, byte[] eventBody) throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.rlb.ONSRuntimeLoadBalancingEvent", "<init>", "entering args ({0}, {1})", null, null, serviceName, eventBody);
            this.m_racInstances = Collections.synchronizedSet(new HashSet());
            this.m_eventBody = null;
            this.m_serviceName = serviceName;
            this.m_eventBody = eventBody;
            StringTokenizer strTokens = null;
            String instNameKey = null;
            String dbUniqNameKey = null;
            int percent = 0;
            float percentf = 0.0f;
            OracleLoadBalancingEvent.InstanceStatus flag = OracleLoadBalancingEvent.InstanceStatus.UNKNOWN;
            boolean updateNecessary = false;
            boolean isAffinityEnabledForThisInstance = false;
            try {
                strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), ONS_RCLB_EVENT_DELIMITER, true);
            }
            catch (UnsupportedEncodingException e) {
                this.trace(Level.WARNING, CLASS_NAME, "ONSRuntimeLoadBalancingEvent", "", null, e, new Object[0]);
            }
            String st = null;
            String val = null;
            String key = null;
            while (strTokens.hasMoreTokens()) {
                val = null;
                st = strTokens.nextToken();
                if (st.equals("=") && strTokens.hasMoreTokens()) {
                    val = strTokens.nextToken();
                } else {
                    if (st.equals("}")) {
                        if (!updateNecessary) continue;
                        RACInstanceImpl racInstance = new RACInstanceImpl(this.m_serviceName, instNameKey, "", dbUniqNameKey);
                        if (percentf > 0.0f) {
                            racInstance.setFloatPercent(percentf);
                        } else {
                            racInstance.setPercent(percent);
                        }
                        racInstance.setStatus(flag);
                        racInstance.setAffinityHint(isAffinityEnabledForThisInstance);
                        this.m_racInstances.add(racInstance);
                        updateNecessary = false;
                        isAffinityEnabledForThisInstance = false;
                        continue;
                    }
                    if (st.equals("{") || st.equals(" ")) continue;
                    key = st;
                    updateNecessary = true;
                }
                if (key.equalsIgnoreCase("version") && val != null) {
                    if (val.startsWith("1.")) continue;
                    this.trace(Level.FINE, CLASS_NAME, "ONSRuntimeLoadBalancingEvent", "Invalid Event version {0}", null, null, val);
                    break;
                }
                if (key.equalsIgnoreCase("database") && val != null) {
                    dbUniqNameKey = val.trim().toLowerCase();
                    continue;
                }
                if (key.equalsIgnoreCase("instance") && val != null) {
                    instNameKey = val.trim().toLowerCase();
                    continue;
                }
                if (key.equalsIgnoreCase("percent") && val != null) {
                    try {
                        percent = Integer.parseInt(val);
                        if (percent != 0) continue;
                        percent = 1;
                    }
                    catch (NumberFormatException nfe) {
                        this.trace(Level.WARNING, CLASS_NAME, "ONSRuntimeLoadBalancingEvent", "", null, nfe, new Object[0]);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("percentf") && val != null) {
                    try {
                        percentf = Float.parseFloat(val);
                    }
                    catch (NumberFormatException nfe) {
                        this.trace(Level.WARNING, CLASS_NAME, "ONSRuntimeLoadBalancingEvent", "", null, nfe, new Object[0]);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("flag") && val != null) {
                    if (val.equalsIgnoreCase("good")) {
                        flag = OracleLoadBalancingEvent.InstanceStatus.GOOD;
                        continue;
                    }
                    if (val.equalsIgnoreCase("violating")) {
                        flag = OracleLoadBalancingEvent.InstanceStatus.VIOLATING;
                        continue;
                    }
                    if (val.equalsIgnoreCase("NO_DATA")) {
                        flag = OracleLoadBalancingEvent.InstanceStatus.NO_DATA;
                        continue;
                    }
                    if (val.equalsIgnoreCase("UNKNOWN")) {
                        flag = OracleLoadBalancingEvent.InstanceStatus.UNKNOWN;
                        continue;
                    }
                    if (!val.equalsIgnoreCase("BLOCKED")) continue;
                    flag = OracleLoadBalancingEvent.InstanceStatus.BLOCKED;
                    continue;
                }
                if (!key.equalsIgnoreCase("aff") || val == null) continue;
                isAffinityEnabledForThisInstance = val.equalsIgnoreCase("true");
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.rlb.ONSRuntimeLoadBalancingEvent", "<init>", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.rlb.ONSRuntimeLoadBalancingEvent", "<init>", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Set<RACInstance> getRACInstances() {
        return this.m_racInstances;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public byte[] getEventBody() {
        return this.m_eventBody;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return DiagnosticsCollectorImpl.getCommon();
    }
}

