/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.register.MLRegisterModelAction;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.common.transport.register.MLRegisterModelRequest;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLRegisterModelAction
extends BaseRestHandler {
    private static final String ML_REGISTER_MODEL_ACTION = "ml_register_model_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLRegisterModelAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public RestMLRegisterModelAction(ClusterService clusterService, Settings settings, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_REGISTER_MODEL_ACTION;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_register", "/_plugins/_ml"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_upload", "/_plugins/_ml")), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/{%s}/_register", "/_plugins/_ml", "model_id", "version"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/{%s}/_upload", "/_plugins/_ml", "model_id", "version")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLRegisterModelRequest mlRegisterModelRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLRegisterModelAction.INSTANCE, (ActionRequest)mlRegisterModelRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLRegisterModelRequest getRequest(RestRequest request) throws IOException {
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        boolean loadModel = request.paramAsBoolean("deploy", false);
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLRegisterModelInput mlInput = MLRegisterModelInput.parse((XContentParser)parser, (boolean)loadModel);
        mlInput.setTenantId(tenantId);
        if (mlInput.getFunctionName() == FunctionName.REMOTE && !this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
            throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
        }
        if (FunctionName.isDLModel((FunctionName)mlInput.getFunctionName()) && !this.mlFeatureEnabledSetting.isLocalModelEnabled()) {
            throw new IllegalStateException("Local Model is currently disabled. To enable it, update the setting \"plugins.ml_commons.local_model.enabled\" to true.");
        }
        return new MLRegisterModelRequest(mlInput);
    }
}

