/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util;

import java.util.Comparator;
import java.util.Objects;

public final class IntDoublePair {
    public final int index;
    public final double value;

    public IntDoublePair(int index, double value) {
        this.index = index;
        this.value = value;
    }

    public static Comparator<IntDoublePair> pairIndexComparator() {
        return Comparator.comparingInt(a -> a.index);
    }

    public static Comparator<IntDoublePair> pairValueComparator() {
        return Comparator.comparingDouble(a -> Math.abs(a.value));
    }

    public static Comparator<IntDoublePair> pairDescendingValueComparator() {
        return (a, b) -> Double.compare(Math.abs(b.value), Math.abs(a.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntDoublePair that = (IntDoublePair)o;
        return this.index == that.index && Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.value);
    }

    public String toString() {
        return "(" + this.index + "," + this.value + ")";
    }
}

