/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.core;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.Span;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;

public abstract class SpanReceiver
implements Closeable {
    private final long id = HIGHEST_SPAN_RECEIVER_ID.incrementAndGet();
    private static final AtomicLong HIGHEST_SPAN_RECEIVER_ID = new AtomicLong(0L);

    public final long getId() {
        return this.id;
    }

    protected SpanReceiver() {
    }

    public abstract void receiveSpan(Span var1);

    public static class Builder {
        private static final Log LOG = LogFactory.getLog(Builder.class);
        static final String DEFAULT_PACKAGE = "org.apache.htrace.core";
        private final HTraceConfiguration conf;
        private boolean logErrors;
        private String className;
        private ClassLoader classLoader = Builder.class.getClassLoader();

        public Builder(HTraceConfiguration conf) {
            this.conf = conf;
            this.reset();
        }

        public Builder reset() {
            this.logErrors = true;
            this.className = null;
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder logErrors(boolean logErrors) {
            this.logErrors = logErrors;
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        private void throwError(String errorStr) {
            if (this.logErrors) {
                LOG.error(errorStr);
            }
            throw new RuntimeException(errorStr);
        }

        private void throwError(String errorStr, Throwable e) {
            if (this.logErrors) {
                LOG.error(errorStr, e);
            }
            throw new RuntimeException(errorStr, e);
        }

        public SpanReceiver build() {
            SpanReceiver spanReceiver = this.newSpanReceiver();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Created new span receiver of type " + spanReceiver.getClass().getName());
            }
            return spanReceiver;
        }

        private SpanReceiver newSpanReceiver() {
            String str;
            if (this.className == null || this.className.isEmpty()) {
                this.throwError("No span receiver class specified.");
            }
            if (!(str = this.className).contains(".")) {
                str = "org.apache.htrace.core." + str;
            }
            Class<?> cls = null;
            try {
                cls = this.classLoader.loadClass(str);
            }
            catch (ClassNotFoundException e) {
                this.throwError("Cannot find SpanReceiver class " + str);
            }
            Constructor<?> ctor = null;
            try {
                ctor = cls.getConstructor(HTraceConfiguration.class);
            }
            catch (NoSuchMethodException e) {
                this.throwError("Cannot find a constructor for class " + str + "which takes an HTraceConfiguration.");
            }
            SpanReceiver receiver = null;
            try {
                LOG.debug("Creating new instance of " + str + "...");
                receiver = (SpanReceiver)ctor.newInstance(this.conf);
            }
            catch (ReflectiveOperationException e) {
                this.throwError("Reflection error when constructing " + str + ".", e);
            }
            catch (Throwable t) {
                this.throwError("NewInstance error when constructing " + str + ".", t);
            }
            return receiver;
        }
    }
}

