/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.privileges.DashboardsMultiTenancyConfiguration;
import org.opensearch.security.privileges.PrivilegesConfiguration;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.DashboardSignInOption;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.setting.OpensearchDynamicSetting;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.node.NodeClient;

public class DashboardsInfoAction
extends BaseRestHandler {
    private static final String KIBANAINFO_ROUTE_DEPRECATION_MESSAGE = "[_opendistro/_security/kibanainfo] is a deprecated endpoint path. Please use _plugins/_security/dashboardsinfo instead.";
    private static final List<RestHandler.Route> routes = ImmutableList.builder().addAll(Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/dashboardsinfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/dashboardsinfo")), "/_plugins/_security")).build();
    private static final List<RestHandler.DeprecatedRoute> deprecatedRoutes = ImmutableList.builder().addAll(Utils.addDeprecatedRoutesPrefix((List<RestHandler.DeprecatedRoute>)ImmutableList.of((Object)new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/kibanainfo", "[_opendistro/_security/kibanainfo] is a deprecated endpoint path. Please use _plugins/_security/dashboardsinfo instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.POST, "/kibanainfo", "[_opendistro/_security/kibanainfo] is a deprecated endpoint path. Please use _plugins/_security/dashboardsinfo instead.")), "/_opendistro/_security")).build();
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final PrivilegesConfiguration privilegesConfiguration;
    private final ConfigurationRepository configurationRepository;
    private final ThreadContext threadContext;
    private final OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting;
    public static final String DEFAULT_PASSWORD_MESSAGE = "Password should be at least 8 characters long and contain at least one uppercase letter, one lowercase letter, one digit, and one special character.";
    public static final String DEFAULT_PASSWORD_REGEX = "(?=.*[A-Z])(?=.*[^a-zA-Z\\d])(?=.*[0-9])(?=.*[a-z]).{8,}";

    public DashboardsInfoAction(PrivilegesConfiguration privilegesConfiguration, ConfigurationRepository configurationRepository, ThreadPool threadPool, OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting) {
        this.resourceSharingEnabledSetting = resourceSharingEnabledSetting;
        this.threadContext = threadPool.getThreadContext();
        this.privilegesConfiguration = privilegesConfiguration;
        this.configurationRepository = configurationRepository;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return deprecatedRoutes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, final NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)DashboardsInfoAction.this.threadContext.getTransient("_opendistro_security_user");
                    DashboardsMultiTenancyConfiguration multiTenancyConfiguration = DashboardsInfoAction.this.privilegesConfiguration.multiTenancyConfiguration();
                    builder.startObject();
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("not_fail_on_forbidden_enabled", DashboardsInfoAction.this.privilegesConfiguration.privilegesEvaluator().notFailOnForbiddenEnabled());
                    builder.field("opensearch_dashboards_mt_enabled", multiTenancyConfiguration.multitenancyEnabled());
                    builder.field("opensearch_dashboards_index", multiTenancyConfiguration.dashboardsIndex());
                    builder.field("opensearch_dashboards_server_user", multiTenancyConfiguration.dashboardsServerUsername());
                    builder.field("multitenancy_enabled", multiTenancyConfiguration.multitenancyEnabled());
                    builder.field("private_tenant_enabled", multiTenancyConfiguration.privateTenantEnabled());
                    builder.field("default_tenant", multiTenancyConfiguration.dashboardsDefaultTenant());
                    builder.field("sign_in_options", DashboardsInfoAction.this.getSignInOptions());
                    builder.field("password_validation_error_message", client.settings().get("plugins.security.restapi.password_validation_error_message", DashboardsInfoAction.DEFAULT_PASSWORD_MESSAGE));
                    builder.field("password_validation_regex", client.settings().get("plugins.security.restapi.password_validation_regex", DashboardsInfoAction.DEFAULT_PASSWORD_REGEX));
                    builder.field("resource_sharing_enabled", DashboardsInfoAction.this.resourceSharingEnabledSetting.getDynamicSettingValue());
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Kibana Info Action";
    }

    private List<DashboardSignInOption> getSignInOptions() {
        ConfigV7 generalConfig = this.configurationRepository.getConfiguration(CType.CONFIG).getCEntry(CType.CONFIG.name());
        if (generalConfig != null && generalConfig.dynamic != null && generalConfig.dynamic.kibana != null) {
            return generalConfig.dynamic.kibana.sign_in_options;
        }
        return new ConfigV7.Kibana().sign_in_options;
    }
}

