package tsk::bucket;
use strict; 

sub new
{
   my ($class) = @_; 
   my @list_src = ();
   my @list_dest= ();
   my $items = 0;  
   my $self = 
   { 
      list_src => \@list_src,
      list_dest =>\@list_dest, 
      items=> \$items
   }; 
   
   bless $self, $class; 
   return $self; 
}

sub push
{
	my ($this, $srcFile, $destFile) = @_; 
	push(@{$this->{'list_src'}},$srcFile);
	push(@{$this->{'list_dest'}},$destFile); 
	${$this->{'items'}}++; 
}

sub has_items
{
	my ($this) = @_; 
	return (${$this->{'items'}} > 0); 
}

sub size
{
	my ($this)= @_; 
	return ${$this->{'items'}}; 
}

sub pop
{
	my ($this) = @_;
	my $src = pop (@{$this->{'list_src'}}); 
	my $dest = pop (@{$this->{'list_dest'}});
	${$this->{'items'}}--;  
	return ($src, $dest); 
}

sub clean
{
	my ($this) = @_;
	undef(@{$this->{'list_src'}});
	undef(@{$this->{'list_dest'}});
	${$this->{'items'}} = 0; 
}

1; 
