/***************************** LICENSE START ***********************************

 Copyright 2022 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#pragma once

#include "IconObject.h"

class WsObject : public IconObject
{
public:
    using IconObject::IconObject;
    WsObject(const WsObject&) = delete;
    WsObject& operator=(const WsObject&) = delete;

    ~WsObject() = default;
    Request request() const override;
    void setRequest(const Request&) override;
    bool checkRequest() override;
    void createFiles() override;

private:
    enum FileType
    {
        NoFileType,
        JsonFileType,
        RequestFileType
    };
    mutable FileType fileType_{NoFileType};

    bool readFromJson(MvRequest& r) const;
    bool readFromRequest(MvRequest& r) const;
};

inline void destroy(WsObject**) {}
