/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var tape = require( 'tape' );
var dtypeChar = require( './../lib' );


// TESTS //

tape( 'main export is a function', function test( t ) {
	t.ok( true, __filename );
	t.strictEqual( typeof dtypeChar, 'function', 'main export is a function' );
	t.end();
});

tape( 'the function returns the single letter character abbreviation for an underlying array data type', function test( t ) {
	var expected;
	var values;
	var ch;
	var i;

	values = [
		'float64',
		'float32',
		'int8',
		'uint8',
		'uint8c',
		'int16',
		'uint16',
		'int32',
		'uint32',
		'int64',
		'uint64',
		'binary',
		'generic',
		'complex64',
		'complex128'
	];

	expected = [
		'd',
		'f',
		's',
		'b',
		'a',
		'k',
		't',
		'i',
		'u',
		'l',
		'v',
		'r',
		'o',
		'c',
		'z'
	];
	for ( i = 0; i < values.length; i++ ) {
		ch = dtypeChar( values[ i ] );
		t.strictEqual( ch, expected[ i ], 'returns '+expected[i]+' when provided '+values[i] );
	}
	t.end();
});

tape( 'the function returns `null` if provided an unknown/unsupported data type', function test( t ) {
	var ch = dtypeChar( 'foobar' );
	t.strictEqual( ch, null, 'returns expected value' );
	t.end();
});
