## TFSA-2020-006: Segmentation fault and/or data corruption due to invalid TFLite model

### CVE Number
CVE-2020-15210

### Impact
If a TFLite saved model uses the same tensor as both input and output of an
operator, then, depending on the operator, we can observe a segmentation fault
or just memory corruption.

### Vulnerable Versions
TensorFlow 1.15.0, 1.15.1, 1.15.2, 1.15.3, 2.0.0, 2.0.1, 2.0.2, 2.1.0, 2.1.1,
2.2.0, 2.3.0.

### Patches
We have patched the issue in
[d58c96946b](https://github.com/tensorflow/tensorflow/commit/d58c96946b) and
will release patch releases for all versions between 1.15 and 2.3.

We recommend users to upgrade to TensorFlow 1.15.4, 2.0.3, 2.1.2, 2.2.1, or
2.3.1.

### Workarounds
A potential workaround would be to add a custom `Verifier` to the model loading
code to ensure that no operator reuses tensors as both inputs and outputs. Care
should be taken to check all types of inputs (i.e., constant or variable tensors
as well as optional tensors).

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been discovered through a variant analysis of [a
vulnerability reported by members of the Aivul Team from Qihoo
360](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-005.md).
