// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQRDMLAH_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SQRDMLAH_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_sqrdmlah_8H[] = {
  0x0000, 0x0001, 0x147d, 0x38f3, 0x7fff, 0x7fff, 0x7fff, 0x3333,
  0x0000, 0x0034, 0x2224, 0x5563, 0x7fff, 0x7fff, 0x007f, 0x3333,
  0x0032, 0x0056, 0x3334, 0x5564, 0x7fff, 0x007e, 0x0080, 0x3333,
  0x0054, 0x0080, 0x3334, 0x5564, 0x007d, 0x007f, 0x0081, 0x3333,
  0x007e, 0x0080, 0x3335, 0x0010, 0x007e, 0x0080, 0x008f, 0x3333,
  0x007e, 0x0080, 0x0002, 0x0011, 0x007f, 0x008e, 0x00fc, 0x3333,
  0x007e, 0x0001, 0x0002, 0x0011, 0x008d, 0x00fb, 0x00fd, 0x3333,
  0x0000, 0x0001, 0x0003, 0x001b, 0x00fa, 0x00fc, 0x00fe, 0x3333,
  0x0000, 0x0001, 0x0008, 0x0063, 0x00fb, 0x00fd, 0x33b2, 0x3333,
  0x0000, 0x0001, 0x0034, 0x0064, 0x00fc, 0x33b0, 0x55d3, 0x3333,
  0x0000, 0x0001, 0x0034, 0x0065, 0x33af, 0x55d2, 0x7fff, 0x3333,
  0x0000, 0x0001, 0x0035, 0x2232, 0x55d0, 0x7fff, 0x7fff, 0x3333,
  0x0000, 0x0001, 0x147d, 0x38f3, 0x7fff, 0x7fff, 0x7fff, 0x3333,
  0x0000, 0x0034, 0x2224, 0x5563, 0x7fff, 0x7fff, 0x8080, 0x3333,
  0x0032, 0x0056, 0x3334, 0x5564, 0x7fff, 0x8080, 0x8081, 0x3333,
  0x0054, 0x0080, 0x3334, 0x5564, 0x8080, 0x8081, 0xab2a, 0x3333,
  0x007e, 0x0080, 0x3335, 0xaabb, 0x8081, 0xab29, 0xcd4b, 0x3333,
  0x007e, 0x0080, 0xcccf, 0xaabc, 0xab29, 0xcd4b, 0xffff, 0x3333,
  0x007e, 0xff82, 0xcccf, 0xc72c, 0xcd4a, 0xfffe, 0x0000, 0x3333,
  0xff82, 0xff82, 0xdde0, 0xdded, 0xfffd, 0xffff, 0x0001, 0x3333,
  0xff82, 0xffac, 0xeb87, 0xffbb, 0xfffe, 0x0000, 0x0002, 0x3333,
  0xffac, 0xffce, 0xffcf, 0xffbb, 0xffff, 0x0001, 0x006f, 0x3333,
  0xffce, 0x0001, 0xffcf, 0xffbc, 0x0000, 0x006e, 0x007c, 0x3333,
  0x0000, 0x0001, 0xffd0, 0xffbd, 0x006d, 0x007b, 0x007d, 0x3333,
  0x0000, 0xffcf, 0xffaf, 0x0000, 0x007a, 0x007c, 0x007f, 0x3333,
  0x0000, 0xffcf, 0xfff7, 0x000d, 0x007b, 0x007d, 0x007f, 0x3333,
  0x0000, 0xfffb, 0x0000, 0x000e, 0x007c, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0000, 0x0001, 0x000f, 0x007d, 0x007f, 0x007f, 0x3333,
  0x0000, 0x0000, 0x0001, 0x0010, 0x007e, 0x0080, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0011, 0x007f, 0x008e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0003, 0x0012, 0x008d, 0x00fb, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0003, 0x0020, 0x00fa, 0x00fc, 0x007f, 0x3333,
  0x0000, 0x0002, 0x000d, 0x008d, 0x00fb, 0x00fd, 0x007f, 0x3334,
  0x0000, 0x0007, 0x0055, 0x008e, 0x00fc, 0x33b1, 0x007f, 0x3334,
  0x0000, 0x0033, 0x0056, 0x008f, 0x33af, 0x55d2, 0x007f, 0x3334,
  0x0000, 0x0033, 0x0057, 0x3342, 0x55d1, 0x7fff, 0x007f, 0x3334,
  0x0000, 0x0034, 0x2224, 0x5563, 0x7fff, 0x7fff, 0x007f, 0x3332,
  0x0000, 0x147c, 0x38e5, 0x7fff, 0x7fff, 0x7fff, 0x007f, 0x3332,
  0x0033, 0x2223, 0x5555, 0x7fff, 0x7fff, 0x807f, 0x007f, 0x3332,
  0x0055, 0x3333, 0x5556, 0x7fff, 0x807f, 0x8080, 0x007f, 0x3333,
  0x007f, 0x3333, 0x5556, 0x8013, 0x8080, 0xab29, 0x007f, 0x3333,
  0x007f, 0x3334, 0xaaad, 0x8014, 0xab28, 0xcd4a, 0x007f, 0x3333,
  0x007f, 0xccce, 0xaaae, 0xaabc, 0xcd4a, 0xfffe, 0x007f, 0x3333,
  0xff81, 0xccce, 0xc71e, 0xccdd, 0xfffd, 0xffff, 0x007f, 0x3333,
  0xff81, 0xdddf, 0xdddf, 0xff90, 0xfffe, 0x0000, 0x007f, 0x3333,
  0xffab, 0xeb86, 0xffad, 0xff91, 0xffff, 0x0001, 0x007f, 0x3333,
  0xffcd, 0xffce, 0xffad, 0xff92, 0x0000, 0x006e, 0x007f, 0x3333,
  0x0000, 0xffce, 0xffae, 0xff93, 0x006d, 0x007b, 0x007f, 0x3333,
  0xffcd, 0xffad, 0xff85, 0x0000, 0x007a, 0x007e, 0x007f, 0x3333,
  0xffce, 0xffae, 0xfff2, 0x000d, 0x007b, 0x007e, 0x007f, 0x3333,
  0xffce, 0xfff6, 0xffff, 0x000e, 0x007c, 0x007e, 0x007f, 0x3333,
  0xfffa, 0xffff, 0x0000, 0x000f, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0000, 0x0001, 0x0010, 0x007e, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0000, 0x0002, 0x0011, 0x007f, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0003, 0x0012, 0x008d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0004, 0x0020, 0x00fa, 0x007e, 0x007f, 0x3334,
  0x0000, 0x0002, 0x0012, 0x008d, 0x00fb, 0x007e, 0x007f, 0x3334,
  0x0001, 0x000c, 0x007f, 0x008e, 0x00fc, 0x007e, 0x0080, 0x3335,
  0x0006, 0x0054, 0x0080, 0x008f, 0x33b0, 0x007e, 0x0080, 0x3335,
  0x0032, 0x0055, 0x0081, 0x3342, 0x55d1, 0x007e, 0x0080, 0x3335,
  0x0032, 0x0056, 0x3334, 0x5564, 0x7fff, 0x007e, 0x0080, 0x3331,
  0x0033, 0x2223, 0x5555, 0x7fff, 0x7fff, 0x007e, 0x007e, 0x3331,
  0x147b, 0x38e4, 0x7ffc, 0x7fff, 0x7fff, 0x007e, 0x007e, 0x3332,
  0x2222, 0x5554, 0x7ffd, 0x7fff, 0x807e, 0x007e, 0x007e, 0x3332,
  0x3332, 0x5555, 0x7ffe, 0x8012, 0x807f, 0x007e, 0x007f, 0x3333,
  0x3332, 0x5555, 0x8005, 0x8013, 0xab28, 0x007e, 0x007f, 0x3333,
  0x3333, 0xaaac, 0x8006, 0xaabb, 0xcd49, 0x007e, 0x007f, 0x3333,
  0xcccd, 0xaaad, 0xaaae, 0xccdd, 0xfffd, 0x007e, 0x007f, 0x3333,
  0xcccd, 0xc71d, 0xcccf, 0xff90, 0xfffe, 0x007e, 0x007f, 0x3333,
  0xddde, 0xddde, 0xff82, 0xff91, 0xffff, 0x007e, 0x007f, 0x3333,
  0xeb85, 0xffac, 0xff83, 0xff92, 0x0000, 0x007e, 0x007f, 0x3333,
  0xffcd, 0xffac, 0xff84, 0xff93, 0x006d, 0x007e, 0x007f, 0x3333,
  0xffab, 0xff83, 0xff85, 0x0000, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffac, 0xff84, 0xfff2, 0x000d, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffad, 0xfff1, 0xffff, 0x000e, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfff5, 0xfffe, 0x0000, 0x000f, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffe, 0xffff, 0x0001, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0000, 0x0002, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0003, 0x0012, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0004, 0x0020, 0x007d, 0x007e, 0x007f, 0x3339,
  0x0001, 0x0003, 0x0012, 0x008d, 0x007d, 0x007e, 0x0080, 0x333e,
  0x0001, 0x0011, 0x007f, 0x008e, 0x007d, 0x007e, 0x0080, 0x3343,
  0x000b, 0x007e, 0x0080, 0x008f, 0x007d, 0x007f, 0x0081, 0x3343,
  0x0053, 0x007f, 0x0081, 0x3343, 0x007d, 0x007f, 0x0081, 0x3343,
  0x0054, 0x0080, 0x3334, 0x5564, 0x007d, 0x007f, 0x0081, 0x3323,
  0x0055, 0x3333, 0x5556, 0x7fff, 0x007d, 0x007f, 0x007d, 0x3323,
  0x2222, 0x5554, 0x7ffd, 0x7fff, 0x007d, 0x007d, 0x007d, 0x3328,
  0x38e3, 0x7ffb, 0x7ffe, 0x7fff, 0x007d, 0x007d, 0x007e, 0x332d,
  0x5553, 0x7ffc, 0x7fff, 0x8011, 0x007d, 0x007d, 0x007e, 0x3333,
  0x5554, 0x7ffd, 0x8004, 0x8012, 0x007d, 0x007e, 0x007f, 0x3333,
  0x5554, 0x8004, 0x8005, 0xaabb, 0x007d, 0x007e, 0x007f, 0x3333,
  0xaaab, 0x8005, 0xaaad, 0xccdc, 0x007d, 0x007e, 0x007f, 0x3333,
  0xaaac, 0xaaad, 0xcccf, 0xff90, 0x007d, 0x007e, 0x007f, 0x3333,
  0xc71c, 0xccce, 0xff82, 0xff91, 0x007d, 0x007e, 0x007f, 0x3333,
  0xdddd, 0xff81, 0xff83, 0xff92, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffab, 0xff82, 0xff84, 0xff93, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff81, 0xff83, 0xff85, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff82, 0xff84, 0xfff2, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff83, 0xfff1, 0xffff, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfff0, 0xfffe, 0x0000, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffd, 0xffff, 0x0001, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffe, 0x0000, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0004, 0x0010, 0x007d, 0x007e, 0x007f, 0x3365,
  0x0001, 0x0003, 0x0012, 0x0010, 0x007d, 0x007e, 0x0085, 0x3386,
  0x0002, 0x0011, 0x007f, 0x0010, 0x007d, 0x007f, 0x008a, 0x33b0,
  0x0010, 0x007e, 0x0080, 0x0010, 0x007d, 0x007f, 0x008f, 0x33b0,
  0x007d, 0x007f, 0x0081, 0x0010, 0x007e, 0x0080, 0x008f, 0x33b0,
  0x007e, 0x0080, 0x3335, 0x0010, 0x007e, 0x0080, 0x008f, 0x32b6,
  0x007f, 0x3333, 0x5556, 0x0010, 0x007e, 0x0080, 0x006f, 0x32b6,
  0x3332, 0x5555, 0x7ffe, 0x0010, 0x007e, 0x007c, 0x006f, 0x32e0,
  0x5553, 0x7ffc, 0x7fff, 0x0010, 0x007c, 0x007c, 0x0074, 0x3301,
  0x7ffa, 0x7ffd, 0x7fff, 0x0010, 0x007c, 0x007d, 0x0079, 0x3333,
  0x7ffb, 0x7ffe, 0x8003, 0x0010, 0x007c, 0x007d, 0x007f, 0x3333,
  0x7ffc, 0x8003, 0x8004, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x8003, 0x8004, 0xaaad, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x8004, 0xaaac, 0xccce, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xaaac, 0xccce, 0xff82, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xcccd, 0xff81, 0xff83, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff80, 0xff82, 0xff84, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff81, 0xff83, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff82, 0xff84, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff83, 0xfff1, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfff0, 0xfffe, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffd, 0xffff, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffe, 0x0000, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3365,
  0x0001, 0x0003, 0x0002, 0x0010, 0x007d, 0x007e, 0x00b1, 0x3387,
  0x0002, 0x0011, 0x0002, 0x0010, 0x007d, 0x0084, 0x00d2, 0x33b1,
  0x0010, 0x007e, 0x0002, 0x0010, 0x007e, 0x0089, 0x00fc, 0x33b1,
  0x007d, 0x007f, 0x0002, 0x0010, 0x007e, 0x008e, 0x00fc, 0x33b1,
  0x007e, 0x0080, 0x0002, 0x0011, 0x007f, 0x008e, 0x00fc, 0x32b5,
  0x007f, 0x3334, 0x0002, 0x0011, 0x007f, 0x008e, 0x0002, 0x32b5,
  0x3332, 0x5555, 0x0002, 0x0011, 0x007f, 0x006e, 0x0002, 0x32df,
  0x5554, 0x7ffd, 0x0002, 0x0011, 0x007b, 0x006e, 0x002c, 0x3301,
  0x7ffb, 0x7ffe, 0x0002, 0x000f, 0x007b, 0x0073, 0x004d, 0x3333,
  0x7ffc, 0x7fff, 0x0002, 0x000f, 0x007c, 0x0078, 0x007f, 0x3333,
  0x7ffd, 0x8002, 0x0002, 0x000f, 0x007c, 0x007e, 0x007f, 0x3333,
  0x8002, 0x8003, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x8003, 0xaaac, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xaaab, 0xcccd, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xcccd, 0xff81, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff80, 0xff82, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff81, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff82, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff83, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfff0, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffd, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffe, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3366,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x00b1, 0x3388,
  0x0002, 0x0001, 0x0002, 0x0010, 0x007d, 0x00b0, 0x00d3, 0x33b2,
  0x0010, 0x0001, 0x0002, 0x0010, 0x0083, 0x00d1, 0x00fd, 0x33b2,
  0x007d, 0x0001, 0x0002, 0x0011, 0x0088, 0x00fb, 0x00fd, 0x33b2,
  0x007e, 0x0001, 0x0002, 0x0011, 0x008d, 0x00fb, 0x00fd, 0x32b4,
  0x007f, 0x0001, 0x0003, 0x0012, 0x008d, 0x00fb, 0x0001, 0x32b4,
  0x3333, 0x0001, 0x0003, 0x0012, 0x008d, 0x0001, 0x0001, 0x32de,
  0x5554, 0x0001, 0x0003, 0x0012, 0x006d, 0x0001, 0x002b, 0x3300,
  0x7ffc, 0x0001, 0x0003, 0x000e, 0x006d, 0x002b, 0x004d, 0x3333,
  0x7ffd, 0x0001, 0x0001, 0x000e, 0x0072, 0x004c, 0x007f, 0x3333,
  0x7ffe, 0x0001, 0x0001, 0x000f, 0x0077, 0x007e, 0x007f, 0x3333,
  0x8001, 0x0001, 0x0001, 0x000f, 0x007d, 0x007e, 0x007f, 0x3333,
  0x8002, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xaaab, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xcccc, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xff80, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3339,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3365,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3365,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3366,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x47ae,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x00b2, 0x5555,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x00b0, 0x00d4, 0x6665,
  0x0000, 0x0001, 0x0002, 0x0010, 0x00af, 0x00d2, 0x00fe, 0x6665,
  0x0000, 0x0001, 0x0002, 0x0016, 0x00d0, 0x00fc, 0x00fe, 0x6666,
  0x0000, 0x0001, 0x0003, 0x001b, 0x00fa, 0x00fc, 0x00fe, 0x0000,
  0x0000, 0x0001, 0x0003, 0x0020, 0x00fa, 0x00fc, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0004, 0x0020, 0x00fa, 0x0000, 0x0000, 0x1111,
  0x0000, 0x0002, 0x0004, 0x0020, 0x0000, 0x0000, 0x002a, 0x1eb8,
  0x0000, 0x0002, 0x0004, 0x0000, 0x0000, 0x002a, 0x004c, 0x3300,
  0x0000, 0x0002, 0x0000, 0x0000, 0x002a, 0x004c, 0x007f, 0x3300,
  0x0000, 0x0000, 0x0000, 0x0005, 0x004b, 0x007e, 0x007f, 0x3301,
  0x0000, 0x0000, 0x0001, 0x000a, 0x007d, 0x007e, 0x007f, 0x3301,
  0x0000, 0x0000, 0x0001, 0x0010, 0x007d, 0x007e, 0x007f, 0x332d,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x0080, 0x333e,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x0085, 0x3386,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x00b1, 0x3387,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x00b1, 0x3388,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x00b2, 0x5555,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x14fa, 0x6c16,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x00b1, 0x22a1, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0010, 0x00af, 0x00d3, 0x33b1, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0042, 0x00d1, 0x00fd, 0x33b1, 0x7fff,
  0x0000, 0x0001, 0x0008, 0x0063, 0x00fb, 0x00fd, 0x33b2, 0xddde,
  0x0000, 0x0002, 0x000d, 0x008d, 0x00fb, 0x00fd, 0xcd4c, 0xdddf,
  0x0000, 0x0002, 0x0012, 0x008d, 0x00fb, 0xffff, 0xcd4c, 0xfa4f,
  0x0001, 0x0003, 0x0012, 0x008d, 0xffff, 0xffff, 0xde5d, 0x1110,
  0x0001, 0x0003, 0x0012, 0xff93, 0xffff, 0x0029, 0xec04, 0x32de,
  0x0001, 0x0003, 0xfff2, 0xff93, 0x0029, 0x004b, 0x004c, 0x32de,
  0x0001, 0xffff, 0xfff2, 0xffbd, 0x004b, 0x007e, 0x004c, 0x32df,
  0xffff, 0xffff, 0xfff7, 0xffde, 0x007d, 0x007e, 0x004d, 0x32e0,
  0xffff, 0x0000, 0xfffc, 0x0010, 0x007d, 0x007e, 0x004d, 0x3328,
  0xffff, 0x0000, 0x0002, 0x0010, 0x007d, 0x007e, 0x0079, 0x3331,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007e, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007e, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007d, 0x007e, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x0080, 0x3335,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x0080, 0x3343,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007f, 0x008a, 0x33b0,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x0084, 0x00d2, 0x33b1,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x00b0, 0x00d3, 0x33b2,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x00b0, 0x00d4, 0x6665,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x00b1, 0x22a1, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x14f9, 0x3962, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0010, 0x00b0, 0x22a0, 0x55d2, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0042, 0x00d2, 0x33b0, 0x55d3, 0x7fff,
  0x0000, 0x0001, 0x0034, 0x0064, 0x00fc, 0x33b0, 0x55d3, 0xb336,
  0x0000, 0x0007, 0x0055, 0x008e, 0x00fc, 0x33b1, 0xab2a, 0xb337,
  0x0001, 0x000c, 0x007f, 0x008e, 0x00fc, 0xcd4b, 0xab2b, 0xdddf,
  0x0001, 0x0011, 0x007f, 0x008e, 0xfffe, 0xcd4b, 0xc79b, 0x0000,
  0x0002, 0x0011, 0x007f, 0xff92, 0xfffe, 0xde5c, 0xde5c, 0x32b3,
  0x0002, 0x0011, 0xff85, 0xff92, 0x0028, 0xec03, 0x002a, 0x32b4,
  0x0002, 0xfff1, 0xff85, 0xffbc, 0x004a, 0x004b, 0x002a, 0x32b5,
  0xfffe, 0xfff1, 0xffaf, 0xffde, 0x007d, 0x004b, 0x002b, 0x32b6,
  0xfffe, 0xfff6, 0xffd0, 0x0010, 0x007d, 0x004c, 0x002c, 0x3323,
  0xffff, 0xfffb, 0x0002, 0x0010, 0x007d, 0x004c, 0x0074, 0x3330,
  0xffff, 0x0001, 0x0002, 0x0010, 0x007d, 0x0078, 0x007d, 0x3331,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007d, 0x007e, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007c, 0x007d, 0x007e, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007c, 0x007d, 0x007f, 0x3334,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x0080, 0x3335,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007f, 0x0081, 0x3343,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007f, 0x008f, 0x33b0,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007e, 0x0089, 0x00fc, 0x33b1,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0083, 0x00d1, 0x00fd, 0x33b2,
  0x0000, 0x0001, 0x0002, 0x0010, 0x00af, 0x00d2, 0x00fe, 0x6665,
  0x0000, 0x0001, 0x0002, 0x0010, 0x00af, 0x00d3, 0x33b1, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0010, 0x00b0, 0x22a0, 0x55d2, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0010, 0x14f8, 0x3961, 0x7fff, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0043, 0x229f, 0x55d1, 0x7fff, 0x7fff,
  0x0000, 0x0001, 0x0034, 0x0065, 0x33af, 0x55d2, 0x7fff, 0xb335,
  0x0000, 0x0033, 0x0056, 0x008f, 0x33af, 0x55d2, 0x8082, 0xb336,
  0x0006, 0x0054, 0x0080, 0x008f, 0x33b0, 0xab29, 0x8083, 0xddde,
  0x000b, 0x007e, 0x0080, 0x008f, 0xcd4a, 0xab2a, 0xab2b, 0x0000,
  0x0010, 0x007e, 0x0080, 0xff91, 0xcd4a, 0xc79a, 0xcd4c, 0x32b3,
  0x0010, 0x007e, 0xff84, 0xff91, 0xde5b, 0xde5b, 0xffff, 0x32b4,
  0x0010, 0xff84, 0xff84, 0xffbb, 0xec02, 0x0029, 0x0000, 0x32b5,
  0xfff0, 0xff84, 0xffae, 0xffdd, 0x004a, 0x0029, 0x0001, 0x32b6,
  0xfff0, 0xffae, 0xffd0, 0x0010, 0x004a, 0x002a, 0x0002, 0x3323,
  0xfff5, 0xffcf, 0x0002, 0x0010, 0x004b, 0x002b, 0x006f, 0x3330,
  0xfffa, 0x0001, 0x0002, 0x0010, 0x004b, 0x0073, 0x007c, 0x3331,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0077, 0x007c, 0x007d, 0x3332,
  0x0000, 0x0001, 0x0002, 0x000a, 0x007b, 0x007c, 0x007e, 0x3333,
  0x0000, 0x0001, 0x0002, 0x000f, 0x007c, 0x007d, 0x007f, 0x3334,
  0x0000, 0x0001, 0x0002, 0x000f, 0x007c, 0x007e, 0x0080, 0x3335,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007f, 0x0081, 0x3343,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007e, 0x0080, 0x008f, 0x33b0,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007e, 0x008e, 0x00fc, 0x33b1,
  0x0000, 0x0001, 0x0002, 0x0011, 0x0088, 0x00fb, 0x00fd, 0x33b2,
  0x0000, 0x0001, 0x0002, 0x0016, 0x00d0, 0x00fc, 0x00fe, 0x6666,
  0x0000, 0x0001, 0x0002, 0x0042, 0x00d1, 0x00fd, 0x33b1, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0042, 0x00d2, 0x33b0, 0x55d3, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x0043, 0x229f, 0x55d1, 0x7fff, 0x7fff,
  0x0000, 0x0001, 0x0002, 0x148b, 0x3960, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x0001, 0x0035, 0x2232, 0x55d0, 0x7fff, 0x7fff, 0xb334,
  0x0000, 0x0033, 0x0057, 0x3342, 0x55d1, 0x7fff, 0x8081, 0xb335,
  0x0032, 0x0055, 0x0081, 0x3342, 0x55d1, 0x8081, 0x8082, 0xddde,
  0x0053, 0x007f, 0x0081, 0x3343, 0xab28, 0x8082, 0xab2a, 0xffff,
  0x007d, 0x007f, 0x0081, 0xccdd, 0xab29, 0xab2a, 0xcd4c, 0x32b3,
  0x007d, 0x007f, 0xff83, 0xccdd, 0xc799, 0xcd4b, 0xffff, 0x32b4,
  0x007d, 0xff83, 0xff83, 0xddee, 0xde5a, 0xfffe, 0x0000, 0x32b5,
  0xff83, 0xff83, 0xffad, 0xeb95, 0x0028, 0xffff, 0x0001, 0x32b6,
  0xff83, 0xffad, 0xffcf, 0xffdd, 0x0028, 0x0000, 0x0002, 0x3323,
  0xffad, 0xffcf, 0x0002, 0xffdd, 0x0029, 0x0001, 0x006f, 0x3330,
  0xffce, 0x0001, 0x0002, 0xffde, 0x002a, 0x006e, 0x007c, 0x3331,
  0x0000, 0x0001, 0x0002, 0xffde, 0x0072, 0x007b, 0x007d, 0x3332,
  0x0000, 0x0001, 0xffd0, 0x0005, 0x007a, 0x007c, 0x007e, 0x3333,
  0x0000, 0x0001, 0xfffc, 0x000e, 0x007b, 0x007d, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0001, 0x000f, 0x007c, 0x007e, 0x0080, 0x3331,
  0x0000, 0x0001, 0x0001, 0x000f, 0x007d, 0x007f, 0x0081, 0x3323,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007e, 0x0080, 0x008f, 0x32b6,
  0x0000, 0x0001, 0x0002, 0x0011, 0x007f, 0x008e, 0x00fc, 0x32b5,
  0x0000, 0x0001, 0x0002, 0x0011, 0x008d, 0x00fb, 0x00fd, 0x32b4,
  0x0000, 0x0001, 0x0003, 0x001b, 0x00fa, 0x00fc, 0x00fe, 0x0000,
  0x0000, 0x0001, 0x0008, 0x0063, 0x00fb, 0x00fd, 0x33b2, 0xddde,
  0x0000, 0x0001, 0x0034, 0x0064, 0x00fc, 0x33b0, 0x55d3, 0xb336,
  0x0000, 0x0001, 0x0034, 0x0065, 0x33af, 0x55d2, 0x7fff, 0xb335,
  0x0000, 0x0001, 0x0035, 0x2232, 0x55d0, 0x7fff, 0x7fff, 0xb334,
  0x0000, 0x0001, 0x147d, 0x38f3, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x0034, 0x2224, 0x5563, 0x7fff, 0x7fff, 0x8080, 0x7fff,
  0x0032, 0x0056, 0x3334, 0x5564, 0x7fff, 0x8080, 0x8081, 0x7fff,
  0x0054, 0x0080, 0x3334, 0x5564, 0x8080, 0x8081, 0xab2a, 0x6667,
  0x007e, 0x0080, 0x3335, 0xaabb, 0x8081, 0xab29, 0xcd4b, 0x33b3,
  0x007e, 0x0080, 0xcccf, 0xaabc, 0xab29, 0xcd4b, 0xffff, 0x33b2,
  0x007e, 0xff82, 0xcccf, 0xc72c, 0xcd4a, 0xfffe, 0x0000, 0x33b1,
  0xff82, 0xff82, 0xdde0, 0xdded, 0xfffd, 0xffff, 0x0001, 0x33b0,
  0xff82, 0xffac, 0xeb87, 0xffbb, 0xfffe, 0x0000, 0x0002, 0x3343,
  0xffac, 0xffce, 0xffcf, 0xffbb, 0xffff, 0x0001, 0x006f, 0x3336,
  0xffce, 0x0001, 0xffcf, 0xffbc, 0x0000, 0x006e, 0x007c, 0x3335,
  0x0000, 0x0001, 0xffd0, 0xffbd, 0x006d, 0x007b, 0x007d, 0x3334,
  0x0000, 0xffcf, 0xffaf, 0x0000, 0x007a, 0x007c, 0x0080, 0x3333,
  0x0000, 0xffcf, 0xfff7, 0x000d, 0x007b, 0x007d, 0x007f, 0x3332,
  0x0000, 0xfffb, 0x0000, 0x000e, 0x007c, 0x007e, 0x007e, 0x3331,
  0x0000, 0x0000, 0x0001, 0x000f, 0x007d, 0x007f, 0x007d, 0x3323,
  0x0000, 0x0000, 0x0001, 0x0010, 0x007e, 0x0080, 0x006f, 0x32b6,
  0x0000, 0x0001, 0x0002, 0x0011, 0x007f, 0x008e, 0x0002, 0x32b5,
  0x0000, 0x0001, 0x0003, 0x0012, 0x008d, 0x00fb, 0x0001, 0x32b4,
  0x0000, 0x0001, 0x0003, 0x0020, 0x00fa, 0x00fc, 0x0000, 0x0000,
  0x0000, 0x0002, 0x000d, 0x008d, 0x00fb, 0x00fd, 0xcd4c, 0xdddf,
  0x0000, 0x0007, 0x0055, 0x008e, 0x00fc, 0x33b1, 0xab2a, 0xb337,
  0x0000, 0x0033, 0x0056, 0x008f, 0x33af, 0x55d2, 0x8082, 0xb336,
  0x0000, 0x0033, 0x0057, 0x3342, 0x55d1, 0x7fff, 0x8081, 0xb335,
  0x0000, 0x0034, 0x2224, 0x5563, 0x7fff, 0x7fff, 0x8080, 0x7fff,
  0x0000, 0x147c, 0x38e5, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0033, 0x2223, 0x5555, 0x7fff, 0x7fff, 0x807f, 0x7fff, 0x7fff,
  0x0055, 0x3333, 0x5556, 0x7fff, 0x807f, 0x8080, 0x55d5, 0x6667,
  0x007f, 0x3333, 0x5556, 0x8013, 0x8080, 0xab29, 0x33b3, 0x33b3,
  0x007f, 0x3334, 0xaaad, 0x8014, 0xab28, 0xcd4a, 0x00ff, 0x33b2,
  0x007f, 0xccce, 0xaaae, 0xaabc, 0xcd4a, 0xfffe, 0x00fe, 0x33b1,
  0xff81, 0xccce, 0xc71e, 0xccdd, 0xfffd, 0xffff, 0x00fd, 0x33b0,
  0xff81, 0xdddf, 0xdddf, 0xff90, 0xfffe, 0x0000, 0x00fc, 0x3343,
  0xffab, 0xeb86, 0xffad, 0xff91, 0xffff, 0x0001, 0x008f, 0x3336,
  0xffcd, 0xffce, 0xffad, 0xff92, 0x0000, 0x006e, 0x0082, 0x3335,
  0x0000, 0xffce, 0xffae, 0xff93, 0x006d, 0x007b, 0x0081, 0x3334,
  0xffcd, 0xffad, 0xff85, 0x0000, 0x007a, 0x0080, 0x0080, 0x3333,
  0xffce, 0xffae, 0xfff2, 0x000d, 0x007b, 0x007f, 0x007f, 0x3332,
  0xffce, 0xfff6, 0xffff, 0x000e, 0x007c, 0x007e, 0x007e, 0x3332,
  0xfffa, 0xffff, 0x0000, 0x000f, 0x007d, 0x007d, 0x007d, 0x3328,
  0xffff, 0x0000, 0x0001, 0x0010, 0x007e, 0x007c, 0x006f, 0x32e0,
  0xffff, 0x0000, 0x0002, 0x0011, 0x007f, 0x006e, 0x0002, 0x32df,
  0x0000, 0x0001, 0x0003, 0x0012, 0x008d, 0x0001, 0x0001, 0x32de,
  0x0000, 0x0002, 0x0004, 0x0020, 0x00fa, 0x0000, 0x0000, 0x1111,
  0x0000, 0x0002, 0x0012, 0x008d, 0x00fb, 0xffff, 0xcd4c, 0xfa4f,
  0x0001, 0x000c, 0x007f, 0x008e, 0x00fc, 0xcd4b, 0xab2b, 0xdddf,
  0x0006, 0x0054, 0x0080, 0x008f, 0x33b0, 0xab29, 0x8083, 0xddde,
  0x0032, 0x0055, 0x0081, 0x3342, 0x55d1, 0x8081, 0x8082, 0xddde,
  0x0032, 0x0056, 0x3334, 0x5564, 0x7fff, 0x8080, 0x8081, 0x7fff,
  0x0033, 0x2223, 0x5555, 0x7fff, 0x7fff, 0x807f, 0x7fff, 0x7fff,
  0x147b, 0x38e4, 0x7ffc, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x6c17,
  0x2222, 0x5554, 0x7ffd, 0x7fff, 0x807e, 0x7fff, 0x55d4, 0x5556,
  0x3332, 0x5555, 0x7ffe, 0x8012, 0x807f, 0x55d4, 0x33b3, 0x3388,
  0x3332, 0x5555, 0x8005, 0x8013, 0xab28, 0x33b2, 0x00ff, 0x3388,
  0x3333, 0xaaac, 0x8006, 0xaabb, 0xcd49, 0x00fe, 0x00fe, 0x3387,
  0xcccd, 0xaaad, 0xaaae, 0xccdd, 0xfffd, 0x00fd, 0x00fd, 0x3386,
  0xcccd, 0xc71d, 0xcccf, 0xff90, 0xfffe, 0x00fc, 0x00fc, 0x333e,
  0xddde, 0xddde, 0xff82, 0xff91, 0xffff, 0x00fb, 0x008f, 0x3335,
  0xeb85, 0xffac, 0xff83, 0xff92, 0x0000, 0x008e, 0x0082, 0x3334,
  0xffcd, 0xffac, 0xff84, 0xff93, 0x006d, 0x0081, 0x0081, 0x3334,
  0xffab, 0xff83, 0xff85, 0x0000, 0x0080, 0x0080, 0x0080, 0x3333,
  0xffac, 0xff84, 0xfff2, 0x000d, 0x007f, 0x007f, 0x007f, 0x3333,
  0xffad, 0xfff1, 0xffff, 0x000e, 0x007e, 0x007e, 0x007e, 0x3332,
  0xfff5, 0xfffe, 0x0000, 0x000f, 0x007d, 0x007d, 0x007e, 0x332d,
  0xfffe, 0xffff, 0x0001, 0x0010, 0x007c, 0x007c, 0x0074, 0x3301,
  0xffff, 0x0000, 0x0002, 0x0011, 0x007b, 0x006e, 0x002c, 0x3301,
  0xffff, 0x0001, 0x0003, 0x0012, 0x006d, 0x0001, 0x002b, 0x3300,
  0x0000, 0x0002, 0x0004, 0x0020, 0x0000, 0x0000, 0x002a, 0x1eb8,
  0x0001, 0x0003, 0x0012, 0x008d, 0xffff, 0xffff, 0xde5d, 0x1110,
  0x0001, 0x0011, 0x007f, 0x008e, 0xfffe, 0xcd4b, 0xc79b, 0x0000,
  0x000b, 0x007e, 0x0080, 0x008f, 0xcd4a, 0xab2a, 0xab2b, 0x0000,
  0x0053, 0x007f, 0x0081, 0x3343, 0xab28, 0x8082, 0xab2a, 0xffff,
  0x0054, 0x0080, 0x3334, 0x5564, 0x8080, 0x8081, 0xab2a, 0x6667,
  0x0055, 0x3333, 0x5556, 0x7fff, 0x807f, 0x8080, 0x55d5, 0x6667,
  0x2222, 0x5554, 0x7ffd, 0x7fff, 0x807e, 0x7fff, 0x55d4, 0x5556,
  0x38e3, 0x7ffb, 0x7ffe, 0x7fff, 0x7fff, 0x7fff, 0x3963, 0x47af,
  0x5553, 0x7ffc, 0x7fff, 0x8011, 0x7fff, 0x55d3, 0x22a2, 0x3366,
  0x5554, 0x7ffd, 0x8004, 0x8012, 0x55d3, 0x33b2, 0x00d4, 0x3366,
  0x5554, 0x8004, 0x8005, 0xaabb, 0x33b1, 0x00fe, 0x00d4, 0x3365,
  0xaaab, 0x8005, 0xaaad, 0xccdc, 0x00fd, 0x00fd, 0x00d3, 0x3365,
  0xaaac, 0xaaad, 0xcccf, 0xff90, 0x00fc, 0x00fc, 0x00d2, 0x3339,
  0xc71c, 0xccce, 0xff82, 0xff91, 0x00fb, 0x00fb, 0x008a, 0x3334,
  0xdddd, 0xff81, 0xff83, 0xff92, 0x00fa, 0x008e, 0x0081, 0x3334,
  0xffab, 0xff82, 0xff84, 0xff93, 0x008d, 0x0081, 0x0080, 0x3333,
  0xff81, 0xff83, 0xff85, 0x0020, 0x0080, 0x007f, 0x007f, 0x3333,
  0xff82, 0xff84, 0xfff2, 0x0013, 0x007f, 0x007f, 0x007f, 0x3333,
  0xff83, 0xfff1, 0xffff, 0x0012, 0x007e, 0x007e, 0x007f, 0x3333,
  0xfff0, 0xfffe, 0x0000, 0x0011, 0x007d, 0x007d, 0x007e, 0x3333,
  0xfffd, 0xffff, 0x0001, 0x0010, 0x007c, 0x007d, 0x0079, 0x3333,
  0xfffe, 0x0000, 0x0002, 0x000f, 0x007b, 0x0073, 0x004d, 0x3333,
  0xffff, 0x0001, 0x0003, 0x000e, 0x006d, 0x002b, 0x004d, 0x3333,
  0x0000, 0x0002, 0x0004, 0x0000, 0x0000, 0x002a, 0x004c, 0x3300,
  0x0001, 0x0003, 0x0012, 0xff93, 0xffff, 0x0029, 0xec04, 0x32de,
  0x0002, 0x0011, 0x007f, 0xff92, 0xfffe, 0xde5c, 0xde5c, 0x32b3,
  0x0010, 0x007e, 0x0080, 0xff91, 0xcd4a, 0xc79a, 0xcd4c, 0x32b3,
  0x007d, 0x007f, 0x0081, 0xccdd, 0xab29, 0xab2a, 0xcd4c, 0x32b3,
  0x007e, 0x0080, 0x3335, 0xaabb, 0x8081, 0xab29, 0xcd4b, 0x33b3,
  0x007f, 0x3333, 0x5556, 0x8013, 0x8080, 0xab29, 0x33b3, 0x33b3,
  0x3332, 0x5555, 0x7ffe, 0x8012, 0x807f, 0x55d4, 0x33b3, 0x3388,
  0x5553, 0x7ffc, 0x7fff, 0x8011, 0x7fff, 0x55d3, 0x22a2, 0x3366,
  0x7ffa, 0x7ffd, 0x7fff, 0x7fff, 0x7fff, 0x3962, 0x14fb, 0x3334,
  0x7ffb, 0x7ffe, 0x8003, 0x7fff, 0x55d2, 0x22a1, 0x00b2, 0x3333,
  0x7ffc, 0x8003, 0x8004, 0x5566, 0x33b1, 0x00d3, 0x00b2, 0x3333,
  0x8003, 0x8004, 0xaaad, 0x3344, 0x00fd, 0x00d3, 0x00b1, 0x3333,
  0x8004, 0xaaac, 0xccce, 0x0090, 0x00fc, 0x00d2, 0x00b1, 0x3333,
  0xaaac, 0xccce, 0xff82, 0x008f, 0x00fb, 0x00d1, 0x0085, 0x3333,
  0xcccd, 0xff81, 0xff83, 0x008e, 0x00fa, 0x0089, 0x0080, 0x3333,
  0xff80, 0xff82, 0xff84, 0x008d, 0x008d, 0x0080, 0x0080, 0x3333,
  0xff81, 0xff83, 0x007f, 0x0020, 0x007f, 0x007f, 0x007f, 0x3333,
  0xff82, 0xff84, 0x0012, 0x0013, 0x007e, 0x007e, 0x007f, 0x3333,
  0xff83, 0xfff1, 0x0005, 0x0012, 0x007e, 0x007e, 0x007f, 0x3333,
  0xfff0, 0xfffe, 0x0004, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffd, 0xffff, 0x0003, 0x0010, 0x007c, 0x007d, 0x007f, 0x3333,
  0xfffe, 0x0000, 0x0002, 0x000f, 0x007c, 0x0078, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0001, 0x000e, 0x0072, 0x004c, 0x007f, 0x3333,
  0x0000, 0x0002, 0x0000, 0x0000, 0x002a, 0x004c, 0x007f, 0x3300,
  0x0001, 0x0003, 0xfff2, 0xff93, 0x0029, 0x004b, 0x004c, 0x32de,
  0x0002, 0x0011, 0xff85, 0xff92, 0x0028, 0xec03, 0x002a, 0x32b4,
  0x0010, 0x007e, 0xff84, 0xff91, 0xde5b, 0xde5b, 0xffff, 0x32b4,
  0x007d, 0x007f, 0xff83, 0xccdd, 0xc799, 0xcd4b, 0xffff, 0x32b4,
  0x007e, 0x0080, 0xcccf, 0xaabc, 0xab29, 0xcd4b, 0xffff, 0x33b2,
  0x007f, 0x3334, 0xaaad, 0x8014, 0xab28, 0xcd4a, 0x00ff, 0x33b2,
  0x3332, 0x5555, 0x8005, 0x8013, 0xab28, 0x33b2, 0x00ff, 0x3388,
  0x5554, 0x7ffd, 0x8004, 0x8012, 0x55d3, 0x33b2, 0x00d4, 0x3366,
  0x7ffb, 0x7ffe, 0x8003, 0x7fff, 0x55d2, 0x22a1, 0x00b2, 0x3333,
  0x7ffc, 0x7fff, 0x7fff, 0x7fff, 0x3961, 0x14fa, 0x0080, 0x3333,
  0x7ffd, 0x8002, 0x7fff, 0x5565, 0x22a0, 0x00b1, 0x007f, 0x3333,
  0x8002, 0x8003, 0x5558, 0x3344, 0x00d2, 0x00b1, 0x007f, 0x3333,
  0x8003, 0xaaac, 0x3336, 0x0090, 0x00d2, 0x00b0, 0x007f, 0x3333,
  0xaaab, 0xcccd, 0x0082, 0x008f, 0x00d1, 0x00b0, 0x007f, 0x3333,
  0xcccd, 0xff81, 0x0081, 0x008e, 0x00d0, 0x0084, 0x007f, 0x3333,
  0xff80, 0xff82, 0x0080, 0x008d, 0x0088, 0x007f, 0x007f, 0x3333,
  0xff81, 0x007f, 0x007f, 0x001b, 0x007e, 0x007e, 0x007f, 0x3333,
  0xff82, 0x007e, 0x0012, 0x0012, 0x007e, 0x007e, 0x007f, 0x3333,
  0xff83, 0x0011, 0x0005, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfff0, 0x0004, 0x0004, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffd, 0x0003, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0xfffe, 0x0002, 0x0002, 0x000f, 0x007c, 0x007e, 0x007f, 0x3333,
  0xffff, 0x0001, 0x0001, 0x000f, 0x0077, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0000, 0x0000, 0x0005, 0x004b, 0x007e, 0x007f, 0x3301,
  0x0001, 0xffff, 0xfff2, 0xffbd, 0x004b, 0x007e, 0x004c, 0x32df,
  0x0002, 0xfff1, 0xff85, 0xffbc, 0x004a, 0x004b, 0x002a, 0x32b5,
  0x0010, 0xff84, 0xff84, 0xffbb, 0xec02, 0x0029, 0x0000, 0x32b5,
  0x007d, 0xff83, 0xff83, 0xddee, 0xde5a, 0xfffe, 0x0000, 0x32b5,
  0x007e, 0xff82, 0xcccf, 0xc72c, 0xcd4a, 0xfffe, 0x0000, 0x33b1,
  0x007f, 0xccce, 0xaaae, 0xaabc, 0xcd4a, 0xfffe, 0x00fe, 0x33b1,
  0x3333, 0xaaac, 0x8006, 0xaabb, 0xcd49, 0x00fe, 0x00fe, 0x3387,
  0x5554, 0x8004, 0x8005, 0xaabb, 0x33b1, 0x00fe, 0x00d4, 0x3365,
  0x7ffc, 0x8003, 0x8004, 0x5566, 0x33b1, 0x00d3, 0x00b2, 0x3333,
  0x7ffd, 0x8002, 0x7fff, 0x5565, 0x22a0, 0x00b1, 0x007f, 0x3333,
  0x7ffe, 0x7fff, 0x7fff, 0x38f4, 0x14f9, 0x007f, 0x007f, 0x3333,
  0x8001, 0x7fff, 0x5557, 0x2233, 0x00b0, 0x007e, 0x007f, 0x3333,
  0x8002, 0x5557, 0x3336, 0x0065, 0x00b0, 0x007e, 0x007f, 0x3333,
  0xaaab, 0x3335, 0x0082, 0x0065, 0x00af, 0x007e, 0x007f, 0x3333,
  0xcccc, 0x0081, 0x0081, 0x0064, 0x00af, 0x007e, 0x007f, 0x3333,
  0xff80, 0x0080, 0x0080, 0x0063, 0x0083, 0x007e, 0x007f, 0x3333,
  0x007f, 0x007f, 0x0055, 0x0016, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007e, 0x007e, 0x000d, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007d, 0x0011, 0x0004, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0010, 0x0004, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0003, 0x0003, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0002, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0001, 0x000f, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0000, 0x0001, 0x000a, 0x007d, 0x007e, 0x007f, 0x3301,
  0xffff, 0xffff, 0xfff7, 0xffde, 0x007d, 0x007e, 0x004d, 0x32e0,
  0xfffe, 0xfff1, 0xffaf, 0xffde, 0x007d, 0x004b, 0x002b, 0x32b6,
  0xfff0, 0xff84, 0xffae, 0xffdd, 0x004a, 0x0029, 0x0001, 0x32b6,
  0xff83, 0xff83, 0xffad, 0xeb95, 0x0028, 0xffff, 0x0001, 0x32b6,
  0xff82, 0xff82, 0xdde0, 0xdded, 0xfffd, 0xffff, 0x0001, 0x33b0,
  0xff81, 0xccce, 0xc71e, 0xccdd, 0xfffd, 0xffff, 0x00fd, 0x33b0,
  0xcccd, 0xaaad, 0xaaae, 0xccdd, 0xfffd, 0x00fd, 0x00fd, 0x3386,
  0xaaab, 0x8005, 0xaaad, 0xccdc, 0x00fd, 0x00fd, 0x00d3, 0x3365,
  0x8003, 0x8004, 0xaaad, 0x3344, 0x00fd, 0x00d3, 0x00b1, 0x3333,
  0x8002, 0x8003, 0x5558, 0x3344, 0x00d2, 0x00b1, 0x007f, 0x3333,
  0x8001, 0x7fff, 0x5557, 0x2233, 0x00b0, 0x007e, 0x007f, 0x3333,
  0x7fff, 0x7fff, 0x38e6, 0x148c, 0x007e, 0x007e, 0x007f, 0x3333,
  0x7fff, 0x5556, 0x2225, 0x0043, 0x007d, 0x007e, 0x007f, 0x3333,
  0x5556, 0x3335, 0x0057, 0x0043, 0x007d, 0x007e, 0x007f, 0x3333,
  0x3334, 0x0081, 0x0057, 0x0042, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0080, 0x0080, 0x0056, 0x0042, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007f, 0x0055, 0x0034, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007e, 0x0054, 0x0008, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x007d, 0x000c, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0010, 0x0003, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0003, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0002, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0000, 0x0001, 0x0010, 0x007d, 0x007e, 0x007f, 0x332d,
  0xffff, 0x0000, 0xfffc, 0x0010, 0x007d, 0x007e, 0x004d, 0x3328,
  0xfffe, 0xfff6, 0xffd0, 0x0010, 0x007d, 0x004c, 0x002c, 0x3323,
  0xfff0, 0xffae, 0xffd0, 0x0010, 0x004a, 0x002a, 0x0002, 0x3323,
  0xff83, 0xffad, 0xffcf, 0xffdd, 0x0028, 0x0000, 0x0002, 0x3323,
  0xff82, 0xffac, 0xeb87, 0xffbb, 0xfffe, 0x0000, 0x0002, 0x3343,
  0xff81, 0xdddf, 0xdddf, 0xff90, 0xfffe, 0x0000, 0x00fc, 0x3343,
  0xcccd, 0xc71d, 0xcccf, 0xff90, 0xfffe, 0x00fc, 0x00fc, 0x333e,
  0xaaac, 0xaaad, 0xcccf, 0xff90, 0x00fc, 0x00fc, 0x00d2, 0x3339,
  0x8004, 0xaaac, 0xccce, 0x0090, 0x00fc, 0x00d2, 0x00b1, 0x3333,
  0x8003, 0xaaac, 0x3336, 0x0090, 0x00d2, 0x00b0, 0x007f, 0x3333,
  0x8002, 0x5557, 0x3336, 0x0065, 0x00b0, 0x007e, 0x007f, 0x3333,
  0x7fff, 0x5556, 0x2225, 0x0043, 0x007d, 0x007e, 0x007f, 0x3333,
  0x7ffe, 0x38e5, 0x147e, 0x0011, 0x007d, 0x007e, 0x007f, 0x3333,
  0x5555, 0x2224, 0x0035, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x3334, 0x0056, 0x0035, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0080, 0x0056, 0x0034, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0055, 0x0033, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0054, 0x0033, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0053, 0x0007, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x000b, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0002, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332,
  0xffff, 0x0000, 0x0002, 0x0010, 0x007d, 0x007e, 0x0079, 0x3331,
  0xffff, 0xfffb, 0x0002, 0x0010, 0x007d, 0x004c, 0x0074, 0x3330,
  0xfff5, 0xffcf, 0x0002, 0x0010, 0x004b, 0x002b, 0x006f, 0x3330,
  0xffad, 0xffcf, 0x0002, 0xffdd, 0x0029, 0x0001, 0x006f, 0x3330,
  0xffac, 0xffce, 0xffcf, 0xffbb, 0xffff, 0x0001, 0x006f, 0x3336,
  0xffab, 0xeb86, 0xffad, 0xff91, 0xffff, 0x0001, 0x008f, 0x3336,
  0xddde, 0xddde, 0xff82, 0xff91, 0xffff, 0x00fb, 0x008f, 0x3335,
  0xc71c, 0xccce, 0xff82, 0xff91, 0x00fb, 0x00fb, 0x008a, 0x3334,
  0xaaac, 0xccce, 0xff82, 0x008f, 0x00fb, 0x00d1, 0x0085, 0x3333,
  0xaaab, 0xcccd, 0x0082, 0x008f, 0x00d1, 0x00b0, 0x007f, 0x3333,
  0xaaab, 0x3335, 0x0082, 0x0065, 0x00af, 0x007e, 0x007f, 0x3333,
  0x5556, 0x3335, 0x0057, 0x0043, 0x007d, 0x007e, 0x007f, 0x3333,
  0x5555, 0x2224, 0x0035, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x38e4, 0x147d, 0x0003, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x2223, 0x0034, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0055, 0x0034, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0033, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0032, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0032, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0006, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007e, 0x3332,
  0xffff, 0x0001, 0x0002, 0x0010, 0x007d, 0x0078, 0x007d, 0x3331,
  0xfffa, 0x0001, 0x0002, 0x0010, 0x004b, 0x0073, 0x007c, 0x3331,
  0xffce, 0x0001, 0x0002, 0xffde, 0x002a, 0x006e, 0x007c, 0x3331,
  0xffce, 0x0001, 0xffcf, 0xffbc, 0x0000, 0x006e, 0x007c, 0x3335,
  0xffcd, 0xffce, 0xffad, 0xff92, 0x0000, 0x006e, 0x0082, 0x3335,
  0xeb85, 0xffac, 0xff83, 0xff92, 0x0000, 0x008e, 0x0082, 0x3334,
  0xdddd, 0xff81, 0xff83, 0xff92, 0x00fa, 0x008e, 0x0081, 0x3334,
  0xcccd, 0xff81, 0xff83, 0x008e, 0x00fa, 0x0089, 0x0080, 0x3333,
  0xcccd, 0xff81, 0x0081, 0x008e, 0x00d0, 0x0084, 0x007f, 0x3333,
  0xcccc, 0x0081, 0x0081, 0x0064, 0x00af, 0x007e, 0x007f, 0x3333,
  0x3334, 0x0081, 0x0057, 0x0042, 0x007d, 0x007e, 0x007f, 0x3333,
  0x3334, 0x0056, 0x0035, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x2223, 0x0034, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x147c, 0x0002, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0033, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007e, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007d, 0x007e, 0x3332,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0077, 0x007c, 0x007d, 0x3332,
  0x0000, 0x0001, 0x0002, 0xffde, 0x0072, 0x007b, 0x007d, 0x3332,
  0x0000, 0x0001, 0xffd0, 0xffbd, 0x006d, 0x007b, 0x007d, 0x3334,
  0x0000, 0xffce, 0xffae, 0xff93, 0x006d, 0x007b, 0x0081, 0x3334,
  0xffcd, 0xffac, 0xff84, 0xff93, 0x006d, 0x0081, 0x0081, 0x3334,
  0xffab, 0xff82, 0xff84, 0xff93, 0x008d, 0x0081, 0x0080, 0x3333,
  0xff80, 0xff82, 0xff84, 0x008d, 0x008d, 0x0080, 0x0080, 0x3333,
  0xff80, 0xff82, 0x0080, 0x008d, 0x0088, 0x007f, 0x007f, 0x3333,
  0xff80, 0x0080, 0x0080, 0x0063, 0x0083, 0x007e, 0x007f, 0x3333,
  0x0080, 0x0080, 0x0056, 0x0042, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0080, 0x0056, 0x0034, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0055, 0x0034, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0033, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
};
const unsigned kExpectedCount_NEON_sqrdmlah_8H = 576;

#endif  // VIXL_SIM_SQRDMLAH_8H_TRACE_AARCH64_H_
