	.register %g2,#ignore
	.register %g3,#ignore

/* Offsets in the state save area. */
S_SP	=	0x0
S_PC	=	0x8
S_FSR	=	0x10
S_PAD1	=	0x18
S_Q0	=	0x20
S_Q4	=	0x30
S_Q8	=	0x40
S_Q12	=	0x50
S_Q16	=	0x60
S_Q20	=	0x70
S_Q24	=	0x80
S_Q28	=	0x90
S_Q32	=	0xa0
S_Q36	=	0xb0
S_Q40	=	0xc0
S_Q44	=	0xd0
S_Q48	=	0xe0
S_Q52	=	0xf0
S_Q56	=	0x100
S_Q60	=	0x110

S_SIZE	=	0x120

/* Bits in the FPRS register. */
FPRS_FEF =	0x04

	.text

	.p2align 4
	.global RTThread__Transfer
	.type	RTThread__Transfer,#function
	.proc	020
RTThread__Transfer:
	save	%sp, -192, %sp
	call	SaveState
	 mov	%i0, %o0
	brnz	%o0, 1f
	 nop
	call	RestoreState
	 mov	%i1, %o0
1:
	ret
	 restore
	.size	RTThread__Transfer, . - RTThread__Transfer


	.p2align 4
	.globl	RTMachine__SaveState
	.type	RTMachine__SaveState,@function
RTMachine__SaveState:
	ba	%xcc, SaveState
	 flushw
	.size	RTMachine__SaveState, . - RTMachine__SaveState

	.p2align 4
	.type	SaveState,@function
SaveState:
	stx	%sp, [%o0 + S_SP]
	stx	%o7, [%o0 + S_PC]
	stx	%fsr, [%o0 + S_FSR]
	stq	%f0, [%o0 + S_Q0]
	stq	%f4, [%o0 + S_Q4]
	stq	%f8, [%o0 + S_Q8]
	stq	%f12, [%o0 + S_Q12]
	stq	%f16, [%o0 + S_Q16]
	stq	%f20, [%o0 + S_Q20]
	stq	%f24, [%o0 + S_Q24]
	stq	%f28, [%o0 + S_Q28]
	stq	%f32, [%o0 + S_Q32]
	stq	%f36, [%o0 + S_Q36]
	stq	%f40, [%o0 + S_Q40]
	stq	%f44, [%o0 + S_Q44]
	stq	%f48, [%o0 + S_Q48]
	stq	%f52, [%o0 + S_Q52]
	stq	%f56, [%o0 + S_Q56]
	stq	%f60, [%o0 + S_Q60]
	retl
	 clr	%o0
	.size	SaveState, . - SaveState

	.p2align 4
	.type	RestoreState,@function
RestoreState:
	save	%sp, -192, %sp
	flushw
	ldx	[%i0 + S_SP], %fp
	ldx	[%i0 + S_PC], %i7
	wr	%g0, FPRS_FEF, %fprs
	ldx	[%i0 + S_FSR], %fsr
	ldq	[%i0 + S_Q0], %f0
	ldq	[%i0 + S_Q4], %f4
	ldq	[%i0 + S_Q8], %f8
	ldq	[%i0 + S_Q12], %f12
	ldq	[%i0 + S_Q16], %f16
	ldq	[%i0 + S_Q20], %f20
	ldq	[%i0 + S_Q24], %f24
	ldq	[%i0 + S_Q28], %f28
	ldq	[%i0 + S_Q32], %f32
	ldq	[%i0 + S_Q36], %f36
	ldq	[%i0 + S_Q40], %f40
	ldq	[%i0 + S_Q44], %f44
	ldq	[%i0 + S_Q48], %f48
	ldq	[%i0 + S_Q52], %f52
	ldq	[%i0 + S_Q56], %f56
	ldq	[%i0 + S_Q60], %f60
	mov	1, %i0
	ret
	 restore
	.size	RestoreState, . - RestoreState
