#!/bin/sh

# panic: Assertion done != job_total_nbytes failed at ../../../kern/sys_socket.c:672
# cpuid = 6
# time = 1630912129
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe00e4f2fa10
# vpanic() at vpanic+0x187/frame 0xfffffe00e4f2fa70
# panic() at panic+0x43/frame 0xfffffe00e4f2fad0
# soaio_process_sb() at soaio_process_sb+0x79a/frame 0xfffffe00e4f2fb70
# soaio_kproc_loop() at soaio_kproc_loop+0x96/frame 0xfffffe00e4f2fbb0
# fork_exit() at fork_exit+0x80/frame 0xfffffe00e4f2fbf0
# fork_trampoline() at fork_trampoline+0xe/frame 0xfffffe00e4f2fbf0
# --- trap 0, rip = 0, rsp = 0, rbp = 0 ---
# KDB: enter: panic
# [ thread pid 26 tid 100163 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x127297e(%rip)
# db> x/s version
# version: FreeBSD 14.0-CURRENT #0 main-n249158-1f7a6325fe1b: Sun Sep  5 09:12:58 CEST 2021
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

[ `uname -p` != "amd64" ] && exit 0
[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
cat > /tmp/syzkaller43.c <<EOF
// https://syzkaller.appspot.com/bug?id=0ecbaedb9a54dd1af01c400dabe774e5c6c6fb6c
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+c7d22dbbb9aef509421d@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  int i, call, thread;
  for (call = 0; call < 5; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000) {
        continue;
      }
      kill_and_wait(pid, &status);
      break;
    }
  }
}

#ifndef SYS_aio_readv
#define SYS_aio_readv 579
#endif

uint64_t r[1] = {0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    res = syscall(SYS_socket, 0x1cul, 5ul, 0x84);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    *(uint64_t*)0x20000440 = 0;
    *(uint32_t*)0x20000448 = 0;
    *(uint64_t*)0x20000450 = 0;
    *(uint64_t*)0x20000458 = 0;
    *(uint64_t*)0x20000460 = 0;
    *(uint64_t*)0x20000468 = 0;
    *(uint32_t*)0x20000470 = 0;
    syscall(SYS_recvmsg, r[0], 0x20000440ul, 0x40040ul);
    break;
  case 2:
    *(uint32_t*)0x200006c0 = r[0];
    *(uint64_t*)0x200006c8 = 0x800;
    *(uint64_t*)0x200006d0 = 0;
    *(uint64_t*)0x200006d8 = 0;
    *(uint32_t*)0x200006e0 = -1;
    *(uint32_t*)0x200006e4 = 8;
    *(uint64_t*)0x200006e8 = 0xffffffffffff658c;
    *(uint32_t*)0x200006f0 = 4;
    *(uint32_t*)0x200006f4 = 0x1ff;
    *(uint64_t*)0x200006f8 = 0x40;
    *(uint64_t*)0x20000700 = 0;
    *(uint64_t*)0x20000708 = 0;
    *(uint32_t*)0x20000710 = 4;
    *(uint32_t*)0x20000714 = 8;
    *(uint32_t*)0x20000718 = 6;
    *(uint64_t*)0x20000720 = 0;
    *(uint64_t*)0x20000728 = 0;
    syscall(SYS_aio_readv, 0x200006c0ul);
    break;
  case 3:
    *(uint32_t*)0x20000140 = 0;
    *(uint16_t*)0x20000144 = 4;
    *(uint8_t*)0x20000146 = 1;
    syscall(SYS_setsockopt, r[0], 0x84, 0x1e, 0x20000140ul, 8ul);
    break;
  case 4:
    *(uint64_t*)0x20000580 = 0x20000080;
    *(uint8_t*)0x20000080 = 0x1c;
    *(uint8_t*)0x20000081 = 0x1c;
    *(uint16_t*)0x20000082 = htobe16(0x4e22);
    *(uint32_t*)0x20000084 = 0;
    *(uint64_t*)0x20000088 = htobe64(0);
    *(uint64_t*)0x20000090 = htobe64(1);
    *(uint32_t*)0x20000098 = 0;
    *(uint32_t*)0x20000588 = 0x1c;
    *(uint64_t*)0x20000590 = 0x20000400;
    *(uint64_t*)0x20000400 = 0x200000c0;
    memset((void*)0x200000c0, 239, 1);
    *(uint64_t*)0x20000408 = 1;
    *(uint32_t*)0x20000598 = 1;
    *(uint64_t*)0x200005a0 = 0;
    *(uint32_t*)0x200005a8 = 0xd0;
    *(uint32_t*)0x200005ac = 0;
    syscall(SYS_sendmsg, r[0], 0x20000580ul, 0ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller43 -Wall -Wextra -O0 /tmp/syzkaller43.c -lpthread ||
    exit 1

(cd /tmp; timeout 3m ./syzkaller43)

rm -rf /tmp/syzkaller43 /tmp/syzkaller43.c /tmp/syzkaller.*
exit 0
