RabbitMQ `3.11.18` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * Classic queues v1 (CQv1) that had a backlog of messages stored by 3.9 and earlier versions
   could run into an exception during queue index recovery after an upgrade to 3.10.x or any later series.

   CQv2 and queues without a backlog were not affected.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#8458](https://github.com/rabbitmq/rabbitmq-server/pull/8458)

 * `rabbitmq-upgrade drain` failed with an exception in environments where management plugin (HTTP API)
   plugin listener was bound to a specific interface.

   GitHub issue: [#8440](https://github.com/rabbitmq/rabbitmq-server/pull/8440)


### OAuth 2 Plugin

#### Enhancements

 * The plugin will now accept JWT tokens without a `scope`. Such tokens would only be useful when the plugin
   is used exclusively for authentication and not authorization.

   GitHub issue: [#8391](https://github.com/rabbitmq/rabbitmq-server/issues/8391)



## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.18.tar.xz`
instead of the source tarball produced by GitHub.
