class DecodedParamCache {
  constructor() {
    this.paramsMap = /* @__PURE__ */ new Map();
    this.registeredParams = /* @__PURE__ */ new Map();
  }
  set(param, stringifiedValue, decodedValue, decode) {
    this.paramsMap.set(param, {
      stringified: stringifiedValue,
      decoded: decodedValue,
      decode
    });
  }
  has(param, stringifiedValue, decode) {
    if (!this.paramsMap.has(param))
      return false;
    const cachedParam = this.paramsMap.get(param);
    if (!cachedParam)
      return false;
    return cachedParam.stringified === stringifiedValue && (decode == null || cachedParam.decode === decode);
  }
  get(param) {
    var _a;
    if (this.paramsMap.has(param))
      return (_a = this.paramsMap.get(param)) == null ? void 0 : _a.decoded;
    return void 0;
  }
  registerParams(paramNames) {
    for (const param of paramNames) {
      const currValue = this.registeredParams.get(param) || 0;
      this.registeredParams.set(param, currValue + 1);
    }
  }
  unregisterParams(paramNames) {
    for (const param of paramNames) {
      const value = (this.registeredParams.get(param) || 0) - 1;
      if (value <= 0) {
        this.registeredParams.delete(param);
        if (this.paramsMap.has(param)) {
          this.paramsMap.delete(param);
        }
      } else {
        this.registeredParams.set(param, value);
      }
    }
  }
  clear() {
    this.paramsMap.clear();
    this.registeredParams.clear();
  }
}
const decodedParamCache = new DecodedParamCache();
export {
  DecodedParamCache,
  decodedParamCache
};
//# sourceMappingURL=decodedParamCache.js.map
