# Security Policy

## Reporting a Vulnerability

If you believe you’ve found a security vulnerability in HandBrake or our website (https://handbrake.fr) please use the "Report a vulnerability" button on the [Security Tab](https://github.com/HandBrake/HandBrake/security) above.

Contributors to this project are also available in [#handbrake on Libera.chat IRC](https://libera.chat/) (irc://irc.libera.chat:6697/#handbrake).
Please note, #handbrake and #handbrake-dev are public so details should only be sent to contributors via private message.


## Responsible Disclosure

We kindly ask that you use responsible disclosure practices when alerting us to any security related issues.
This allows us time to investigate and take corrective action where necessary. 

Our goal is to deal with any issues reported as quickly as possible.  If you do not receive a direct response from us within 24 hours, please follow up with us as we may not have received the message.

## Policy Notes

 - HandBrake is a volunteer project and we are not funded. As such, we do not participate in bug bounty programs or pay out for bugs raised.
 - When a new version of HandBrake is released, all prior versions immediately become end-of-life. 
 - Releases are ad-hoc and do not follow any set release schedule.
 - Any new releases will be published on our website and here on the [GitHub releases](https://github.com/HandBrake/HandBrake/releases) page. They will also be available via in-app software updates usually within a few days of a release being published. 
 - Any security issues will be noted in our [Release Notes](https://github.com/HandBrake/HandBrake/releases), and if relevant an advisory may also be published on our [GitHub Security Page](https://github.com/HandBrake/HandBrake/security).
 - We do NOT fill out any form of questionnaires or provide any security scan results.
 
## Versions

We accept bug reports (including security reports) for the following versions:

| Version                | Accepts Reports    |
| ---------------------- | ------------------ |
| git main (development) | :white_check_mark: |
| 1.9.x                  | :white_check_mark: |
| Earlier Releases       | :x:                |
