"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseTsconfigFile = void 0;
const ts = require("typescript");
const virtual_host_1 = require("./virtual-host");
const path_1 = require("path");
function parseTsconfigFile(tsconfigPath, fileSystem) {
    const { config } = ts.readConfigFile(tsconfigPath, p => fileSystem.read(fileSystem.resolve(p)));
    return ts.parseJsonConfigFileContent(config, new virtual_host_1.FileSystemHost(fileSystem), (0, path_1.dirname)(tsconfigPath), {});
}
exports.parseTsconfigFile = parseTsconfigFile;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFyc2UtdHNjb25maWcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9zcmMvY2RrL3NjaGVtYXRpY3MvdXBkYXRlLXRvb2wvdXRpbHMvcGFyc2UtdHNjb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7R0FNRzs7O0FBRUgsaUNBQWlDO0FBRWpDLGlEQUE4QztBQUM5QywrQkFBNkI7QUFFN0IsU0FBZ0IsaUJBQWlCLENBQy9CLFlBQTJCLEVBQzNCLFVBQXNCO0lBRXRCLE1BQU0sRUFBQyxNQUFNLEVBQUMsR0FBRyxFQUFFLENBQUMsY0FBYyxDQUFDLFlBQVksRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBRSxDQUFDLENBQUM7SUFDL0YsT0FBTyxFQUFFLENBQUMsMEJBQTBCLENBQ2xDLE1BQU0sRUFDTixJQUFJLDZCQUFjLENBQUMsVUFBVSxDQUFDLEVBQzlCLElBQUEsY0FBTyxFQUFDLFlBQVksQ0FBQyxFQUNyQixFQUFFLENBQ0gsQ0FBQztBQUNKLENBQUM7QUFYRCw4Q0FXQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQgKiBhcyB0cyBmcm9tICd0eXBlc2NyaXB0JztcbmltcG9ydCB7RmlsZVN5c3RlbSwgV29ya3NwYWNlUGF0aH0gZnJvbSAnLi4vZmlsZS1zeXN0ZW0nO1xuaW1wb3J0IHtGaWxlU3lzdGVtSG9zdH0gZnJvbSAnLi92aXJ0dWFsLWhvc3QnO1xuaW1wb3J0IHtkaXJuYW1lfSBmcm9tICdwYXRoJztcblxuZXhwb3J0IGZ1bmN0aW9uIHBhcnNlVHNjb25maWdGaWxlKFxuICB0c2NvbmZpZ1BhdGg6IFdvcmtzcGFjZVBhdGgsXG4gIGZpbGVTeXN0ZW06IEZpbGVTeXN0ZW0sXG4pOiB0cy5QYXJzZWRDb21tYW5kTGluZSB7XG4gIGNvbnN0IHtjb25maWd9ID0gdHMucmVhZENvbmZpZ0ZpbGUodHNjb25maWdQYXRoLCBwID0+IGZpbGVTeXN0ZW0ucmVhZChmaWxlU3lzdGVtLnJlc29sdmUocCkpISk7XG4gIHJldHVybiB0cy5wYXJzZUpzb25Db25maWdGaWxlQ29udGVudChcbiAgICBjb25maWcsXG4gICAgbmV3IEZpbGVTeXN0ZW1Ib3N0KGZpbGVTeXN0ZW0pLFxuICAgIGRpcm5hbWUodHNjb25maWdQYXRoKSxcbiAgICB7fSxcbiAgKTtcbn1cbiJdfQ==