/*
 * This file is part of csharp-gentoodotnetinfo - .NET information tool for Gentoo.
 * Copyright (c) 20233-2024, Maciej Barć <xgqt@gentoo.org>
 * Licensed under the GNU GPL v2 License
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * csharp-gentoodotnetinfo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * csharp-gentoodotnetinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with csharp-gentoodotnetinfo.  If not, see <https://www.gnu.org/licenses/>.
 */

using NUnit.Framework;

using Gentoo.DotNet.GentooDotnetInfo.Info;

namespace Gentoo.DotNet.GentooDotnetInfo.Tests.Unit.Info
{

    [TestFixture]
    public class OperatingSystemInfoTest
    {

        private OperatingSystemInfo _fixture;

        [SetUp]
        public void SetUp()
        {
            _fixture = new();
        }

        [Test]
        public void OSProcessArchitecture_Passes()
        {
            Assert.That(() => _fixture.OSProcessArchitecture, Throws.Nothing);
        }

        [Test]
        public void OSProcessorCount_Passes()
        {
            Assert.That(() => _fixture.OSProcessorCount, Throws.Nothing);
        }

        [Test]
        public void OSVersion_Passes()
        {
            Assert.That(() => _fixture.OSVersion, Throws.Nothing);
        }

        [Test]
        public void Locale_Passes()
        {
            Assert.That(() => _fixture.Locale, Throws.Nothing);
        }

    }

}
