/*
 * Decompiled with CFR 0.152.
 */
package dev.dirs;

import dev.dirs.UnsupportedOperatingSystemException;
import dev.dirs.Util;

public final class ProjectDirectories {
    public final String projectPath;
    public final String cacheDir;
    public final String configDir;
    public final String dataDir;
    public final String dataLocalDir;
    public final String preferenceDir;
    public final String runtimeDir;

    private ProjectDirectories(String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Util.requireNonNull(string2);
        this.projectPath = string2;
        this.cacheDir = string3;
        this.configDir = string4;
        this.dataDir = string5;
        this.dataLocalDir = string6;
        this.preferenceDir = string7;
        this.runtimeDir = string8;
    }

    public static ProjectDirectories fromPath(String string2) {
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8 = null;
        switch (Util.operatingSystem) {
            case 'b': 
            case 'i': 
            case 'l': 
            case 's': {
                String string9 = System.getProperty("user.home");
                string7 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_CACHE_HOME"), string2, string9 + "/.cache/", string2);
                string6 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_CONFIG_HOME"), string2, string9 + "/.config/", string2);
                string4 = string5 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_DATA_HOME"), string2, string9 + "/.local/share/", string2);
                string3 = string6;
                string8 = Util.linuxRuntimeDir(string2);
                break;
            }
            case 'm': {
                String string10 = System.getProperty("user.home");
                string7 = string10 + "/Library/Caches/" + string2;
                string6 = string10 + "/Library/Application Support/" + string2;
                string4 = string5 = string10 + "/Library/Application Support/" + string2;
                string3 = string10 + "/Library/Preferences/" + string2;
                break;
            }
            case 'w': {
                String[] stringArray = Util.getWinDirs("3EB685DB-65F9-4CF6-A03A-E3EF65729F3D", "F1B32785-6FBA-4FCF-9D55-7B8E7F157091");
                String string11 = stringArray[0] + '\\' + string2;
                String string12 = stringArray[1] + '\\' + string2;
                string5 = string11 + "\\data";
                string4 = string12 + "\\data";
                string6 = string11 + "\\config";
                string7 = string12 + "\\cache";
                string3 = string6;
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Project directories are not supported on " + Util.operatingSystemName);
            }
        }
        return new ProjectDirectories(string2, string7, string6, string5, string4, string3, string8);
    }

    public static ProjectDirectories from(String string2, String string3, String string4) {
        String string5;
        if (Util.isNullOrEmpty(string3) && Util.isNullOrEmpty(string4)) {
            throw new UnsupportedOperationException("organization and application arguments cannot both be null/empty");
        }
        switch (Util.operatingSystem) {
            case 'b': 
            case 'l': 
            case 's': {
                string5 = Util.trimLowercaseReplaceWhitespace(string4, "", true);
                break;
            }
            case 'm': {
                string5 = Util.macOSApplicationPath(string2, string3, string4);
                break;
            }
            case 'w': {
                string5 = Util.windowsApplicationPath(string2, string3, string4);
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Util.operatingSystemName);
            }
        }
        return ProjectDirectories.fromPath(string5);
    }

    public String toString() {
        return "ProjectDirectories (" + Util.operatingSystemName + "):\n" + "  projectPath   = '" + this.projectPath + "'\n" + "  cacheDir      = '" + this.cacheDir + "'\n" + "  configDir     = '" + this.configDir + "'\n" + "  dataDir       = '" + this.dataDir + "'\n" + "  dataLocalDir  = '" + this.dataLocalDir + "'\n" + "  preferenceDir = '" + this.preferenceDir + "'\n" + "  runtimeDir    = '" + this.runtimeDir + "'\n";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProjectDirectories projectDirectories = (ProjectDirectories)object;
        if (!this.projectPath.equals(projectDirectories.projectPath)) {
            return false;
        }
        if (this.cacheDir != null ? !this.cacheDir.equals(projectDirectories.cacheDir) : projectDirectories.cacheDir != null) {
            return false;
        }
        if (this.configDir != null ? !this.configDir.equals(projectDirectories.configDir) : projectDirectories.configDir != null) {
            return false;
        }
        if (this.dataDir != null ? !this.dataDir.equals(projectDirectories.dataDir) : projectDirectories.dataDir != null) {
            return false;
        }
        if (this.dataLocalDir != null ? !this.dataLocalDir.equals(projectDirectories.dataLocalDir) : projectDirectories.dataLocalDir != null) {
            return false;
        }
        if (this.preferenceDir != null ? !this.preferenceDir.equals(projectDirectories.preferenceDir) : projectDirectories.preferenceDir != null) {
            return false;
        }
        return !(this.runtimeDir != null ? !this.runtimeDir.equals(projectDirectories.runtimeDir) : projectDirectories.runtimeDir != null);
    }

    public int hashCode() {
        int n = this.projectPath.hashCode();
        n = 31 * n + (this.cacheDir != null ? this.cacheDir.hashCode() : 0);
        n = 31 * n + (this.configDir != null ? this.configDir.hashCode() : 0);
        n = 31 * n + (this.dataDir != null ? this.dataDir.hashCode() : 0);
        n = 31 * n + (this.dataLocalDir != null ? this.dataLocalDir.hashCode() : 0);
        n = 31 * n + (this.preferenceDir != null ? this.preferenceDir.hashCode() : 0);
        n = 31 * n + (this.runtimeDir != null ? this.runtimeDir.hashCode() : 0);
        return n;
    }
}

